import{s as Ge,o as Ze,n as _e}from"../chunks/scheduler.37c15a92.js";import{S as Re,i as ve,g as a,s as n,r as m,A as Ce,h as i,f as s,c as r,j as he,u as M,x as o,k as Ue,y as We,a as l,v as g,d as c,t as f,w as u}from"../chunks/index.2bf4358c.js";import{T as ke}from"../chunks/Tip.363c041f.js";import{Y as He}from"../chunks/Youtube.1e50a667.js";import{C as T}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Ie}from"../chunks/CourseFloatingBanner.06521e8b.js";import{F as Fe}from"../chunks/FrameworkSwitchCourse.8d4d4ab6.js";import{H as Ot}from"../chunks/Heading.8ada512a.js";function Xe(w){let p,b='💡 如果您想在訓練期間自動將模型上傳到 Hub，請將push_to_hub=True添加到TrainingArguments之中. 我們將在<a href="/course/chapter4/3">第四章</a>中詳細介紹這部分。';return{c(){p=a("p"),p.innerHTML=b},l(d){p=i(d,"P",{"data-svelte-h":!0}),o(p)!=="svelte-14wsgcy"&&(p.innerHTML=b)},m(d,$){l(d,p,$)},p:_e,d(d){d&&s(p)}}}function ze(w){let p,b="✏️ <strong>試試看!</strong> 使用您在第 2 節中進行的數據處理，在 GLUE SST-2 數據集上微調模型。";return{c(){p=a("p"),p.innerHTML=b},l(d){p=i(d,"P",{"data-svelte-h":!0}),o(p)!=="svelte-w962mn"&&(p.innerHTML=b)},m(d,$){l(d,p,$)},p:_e,d(d){d&&s(p)}}}function Ee(w){let p,b,d,$,y,mt,h,Mt,U,gt,k,ct,_,te='🤗 Transformers提供了一個 <strong>Trainer</strong> 類來幫助您在自己的數據集上微調任何預訓練模型。完成上一節中的所有數據預處理工作後，您只需要執行幾個步驟來創建 <strong>Trainer</strong> .最難的部分可能是為 <strong>Trainer.train()</strong>配置運行環境，因為它在 CPU 上運行速度會非常慢。如果您沒有設置 GPU，您可以訪問免費的 GPU 或 TPU<a href="https://colab.research.google.com/" rel="nofollow">Google Colab</a>.',ft,G,ee="下面的示例假設您已經執行了上一節中的示例。下面這段代碼，概括了您需要提前運行的代碼：",ut,Z,dt,R,Tt,v,se="在我們定義我們的 <strong>Trainer</strong> 之前首先要定義一個 <strong>TrainingArguments</strong> 類，它將包含 <strong>Trainer</strong>用於訓練和評估的所有超參數。您唯一必須提供的參數是保存訓練模型的目錄，以及訓練過程中的檢查點。對於其餘的參數，您可以保留默認值，這對於基本微調應該非常有效。",bt,C,$t,j,yt,W,le="第二步是定義我們的模型。正如在[之前的章節](/2_Using Transformers/Introduction)一樣，我們將使用 <strong>AutoModelForSequenceClassification</strong> 類，它有兩個參數：",jt,H,Jt,I,ne='你會注意到，和<a href="/course/chapter2">第二章</a>不一樣的是，在實例化此預訓練模型後會收到警告。這是因為 BERT 沒有在句子對分類方面進行過預訓練，所以預訓練模型的頭部已經被丟棄，而是添加了一個適合句子序列分類的新頭部。警告表明一些權重沒有使用（對應於丟棄的預訓練頭的那些），而其他一些權重被隨機初始化（新頭的那些）。最後鼓勵您訓練模型，這正是我們現在要做的。',wt,F,re="一旦我們有了我們的模型，我們就可以定義一個 <strong>Trainer</strong> 通過將之前構造的所有對象傳遞給它——我們的<strong>model</strong> 、<strong>training_args</strong> ，訓練和驗證數據集，<strong>data_collator</strong> ，和 <strong>tokenizer</strong> ：",ht,X,Ut,z,ae="請注意，當您在這裡完成<strong>tokenizer</strong>後，默認 <strong>Trainer</strong>使用 的<strong>data_collator</strong>會使用之前預定義的 <strong>DataCollatorWithPadding</strong> ，因此您可以在這個例子中跳過 <strong>data_collator=data_collator</strong>。在第 2 節中向您展示這部分處理仍然很重要！",kt,E,ie="為了讓預訓練模型在在我們的數據集上微調，我們只需要調用<strong>Trainer</strong>的<strong>train()</strong> 方法 ：",_t,V,Gt,B,pe="這將開始微調（在GPU上應該需要幾分鐘），並每500步報告一次訓練損失。但是，它不會告訴您模型的性能如何（或質量如何）。這是因為:",Zt,Y,oe="<li>我們沒有通過將<strong>evaluation_strategy</strong>設置為“<strong>steps</strong>”(在每次更新參數的時候評估)或“<strong>epoch</strong>”(在每個epoch結束時評估)來告訴<strong>Trainer</strong>在訓練期間進行評估。</li> <li>我們沒有為<strong>Trainer</strong>提供一個<strong>compute_metrics()</strong>函數來直接計算模型的好壞(否則評估將只輸出loss，這不是一個非常直觀的數字)。</li>",Rt,x,vt,A,me="讓我們看看如何構建一個有用的 <strong>compute_metrics()</strong> 函數並在我們下次訓練時使用它。該函數必須採用 <strong>EvalPrediction</strong> 對象（帶有 <strong>predictions</strong> 和 <strong>label_ids</strong> 字段的參數元組）並將返回一個字符串到浮點數的字典（字符串是返回的指標的名稱，而浮點數是它們的值）。我們可以使用 <strong>Trainer.predict()</strong> 命令來使用我們的模型進行預測：",Ct,N,Wt,Q,Ht,L,Me="<strong>predict()</strong> 的輸出結果是具有三個字段的命名元組： <strong>predictions</strong> , <strong>label_ids</strong> ， 和 <strong>metrics</strong> .這 <strong>metrics</strong> 字段將只包含傳遞的數據集的loss，以及一些運行時間（預測所需的總時間和平均時間）。如果我們定義了自己的 <strong>compute_metrics()</strong> 函數並將其傳遞給 <strong>Trainer</strong> ，該字段還將包含<strong>compute_metrics()</strong>的結果。",It,P,ge='<strong>predict()</strong> 方法是具有三個字段的命名元組： <strong>predictions</strong> , <strong>label_ids</strong> ， 和 <strong>metrics</strong> .這 <strong>metrics</strong> 字段將只包含傳遞的數據集的loss，以及一些運行時間（預測所需的總時間和平均時間）。如果我們定義了自己的 <strong>compute_metrics()</strong> 函數並將其傳遞給 <strong>Trainer</strong> ，該字段還將包含<strong>compute_metrics()</strong> 的結果。如你看到的， <strong>predictions</strong> 是一個形狀為 408 x 2 的二維數組（408 是我們使用的數據集中元素的數量）。這些是我們傳遞給<strong>predict()</strong>的數據集的每個元素的結果(logits)（正如你在<a href="/course/chapter2">之前的章節</a>看到的情況）。要將我們的預測的可以與真正的標籤進行比較，我們需要在第二個軸上取最大值的索引：',Ft,q,Xt,S,ce='現在建立我們的 <strong>compute_metric()</strong> 函數來較為直觀地評估模型的好壞，我們將使用 🤗 <a href="https://github.com/huggingface/evaluate/" rel="nofollow">Evaluate</a> 庫中的指標。我們可以像加載數據集一樣輕鬆加載與 MRPC 數據集關聯的指標，這次使用 <strong>evaluate.load()</strong> 函數。返回的對象有一個 <strong>compute()</strong>方法我們可以用來進行度量計算的方法：',zt,K,Et,D,Vt,O,fe='您獲得的確切結果可能會有所不同，因為模型頭的隨機初始化可能會影響最終建立的模型。在這裡，我們可以看到我們的模型在驗證集上的準確率為 85.78%，F1 分數為 89.97。這是用於評估 GLUE 基準的 MRPC 數據集結果的兩個指標。而在<a href="https://arxiv.org/pdf/1810.04805.pdf" rel="nofollow">BERT 論文</a>中展示的基礎模型的 F1 分數為 88.9。那是 <strong>uncased</strong> 模型，而我們目前正在使用 <strong>cased</strong> 模型，通過改進得到了更好的結果。',Bt,tt,ue="最後將所有東西打包在一起，我們得到了我們的 <strong>compute_metrics()</strong> 函數：",Yt,et,xt,st,de="為了查看模型在每個訓練週期結束的好壞，下面是我們如何使用<strong>compute_metrics()</strong>函數定義一個新的 <strong>Trainer</strong> ：",At,lt,Nt,nt,Te="請注意，我們設置了了一個新的 <strong>TrainingArguments</strong> 它的<strong>evaluation_strategy</strong> 設置為 <strong>epoch</strong> 並創建了一個新模型。如果不創建新的模型就直接訓練，就只會繼續訓練之前我們已經訓練過的模型。要啟動新的訓練運行，我們執行：",Qt,rt,Lt,at,be="這一次，它將在訓練loss之外，還會輸出每個 epoch 結束時的驗證loss和指標。同樣，由於模型的隨機頭部初始化，您達到的準確率/F1 分數可能與我們發現的略有不同，但它應該在同一範圍內。",Pt,it,$e="這 <strong>Trainer</strong> 將在多個 GPU 或 TPU 上開箱即用，並提供許多選項，例如混合精度訓練（在訓練的參數中使用 <strong>fp16 = True</strong> ）。我們將在第 10 章討論它支持的所有內容。",qt,pt,ye="使用<strong>Trainer</strong> API微調的介紹到此結束。對最常見的 NLP 任務執行此操作的示例將在第 7 章中給出，但現在讓我們看看如何在純 PyTorch 中執行相同的操作。",St,J,Kt,ot,Dt;return y=new Fe({props:{fw:w[0]}}),h=new Ot({props:{title:"使用 Trainer API 微調模型",local:"使用-trainer-api-微調模型",headingTag:"h1"}}),U=new Ie({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter3/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter3/section3.ipynb"}]}}),k=new He({props:{id:"nvBXf7s7vTI"}}),Z=new T({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),R=new Ot({props:{title:"Training",local:"training",headingTag:"h3"}}),C=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>)`,wrap:!1}}),j=new ke({props:{$$slots:{default:[Xe]},$$scope:{ctx:w}}}),H=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),X=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=tokenizer,
)`,wrap:!1}}),V=new T({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),x=new Ot({props:{title:"評估",local:"評估",headingTag:"h3"}}),N=new T({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjB0cmFpbmVyLnByZWRpY3QodG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydmFsaWRhdGlvbiUyMiU1RCklMEFwcmludChwcmVkaWN0aW9ucy5wcmVkaWN0aW9ucy5zaGFwZSUyQyUyMHByZWRpY3Rpb25zLmxhYmVsX2lkcy5zaGFwZSk=",highlighted:`predictions = trainer.predict(tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>])
<span class="hljs-built_in">print</span>(predictions.predictions.shape, predictions.label_ids.shape)`,wrap:!1}}),Q=new T({props:{code:"KDQwOCUyQyUyMDIpJTIwKDQwOCUyQyk=",highlighted:'(<span class="hljs-number">408</span>, <span class="hljs-number">2</span>) (<span class="hljs-number">408</span>,)',wrap:!1}}),q=new T({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcHJlZHMlMjAlM0QlMjBucC5hcmdtYXgocHJlZGljdGlvbnMucHJlZGljdGlvbnMlMkMlMjBheGlzJTNELTEp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

preds = np.argmax(predictions.predictions, axis=-<span class="hljs-number">1</span>)`,wrap:!1}}),K=new T({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZHMlMkMlMjByZWZlcmVuY2VzJTNEcHJlZGljdGlvbnMubGFiZWxfaWRzKQ==",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
metric.compute(predictions=preds, references=predictions.label_ids)`,wrap:!1}}),D=new T({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODU3ODQzMTM3MjU0OTAxOSUyQyUyMCdmMSclM0ElMjAwLjg5OTY1Mzk3OTIzODc1NDIlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8578431372549019</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8996539792387542</span>}',wrap:!1}}),et=new T({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZHMpJTNBJTBBJTIwJTIwJTIwJTIwbWV0cmljJTIwJTNEJTIwZXZhbHVhdGUubG9hZCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWRzJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBucC5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzJTNEbGFiZWxzKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_preds</span>):
    metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
    logits, labels = eval_preds
    predictions = np.argmax(logits, axis=-<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)`,wrap:!1}}),lt=new T({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMiUyQyUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEp",highlighted:`training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>, evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>)
model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=tokenizer,
    compute_metrics=compute_metrics,
)`,wrap:!1}}),rt=new T({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:'trainer.trai<span class="hljs-meta">n</span>()',wrap:!1}}),J=new ke({props:{$$slots:{default:[ze]},$$scope:{ctx:w}}}),{c(){p=a("meta"),b=n(),d=a("p"),$=n(),m(y.$$.fragment),mt=n(),m(h.$$.fragment),Mt=n(),m(U.$$.fragment),gt=n(),m(k.$$.fragment),ct=n(),_=a("p"),_.innerHTML=te,ft=n(),G=a("p"),G.textContent=ee,ut=n(),m(Z.$$.fragment),dt=n(),m(R.$$.fragment),Tt=n(),v=a("p"),v.innerHTML=se,bt=n(),m(C.$$.fragment),$t=n(),m(j.$$.fragment),yt=n(),W=a("p"),W.innerHTML=le,jt=n(),m(H.$$.fragment),Jt=n(),I=a("p"),I.innerHTML=ne,wt=n(),F=a("p"),F.innerHTML=re,ht=n(),m(X.$$.fragment),Ut=n(),z=a("p"),z.innerHTML=ae,kt=n(),E=a("p"),E.innerHTML=ie,_t=n(),m(V.$$.fragment),Gt=n(),B=a("p"),B.textContent=pe,Zt=n(),Y=a("ol"),Y.innerHTML=oe,Rt=n(),m(x.$$.fragment),vt=n(),A=a("p"),A.innerHTML=me,Ct=n(),m(N.$$.fragment),Wt=n(),m(Q.$$.fragment),Ht=n(),L=a("p"),L.innerHTML=Me,It=n(),P=a("p"),P.innerHTML=ge,Ft=n(),m(q.$$.fragment),Xt=n(),S=a("p"),S.innerHTML=ce,zt=n(),m(K.$$.fragment),Et=n(),m(D.$$.fragment),Vt=n(),O=a("p"),O.innerHTML=fe,Bt=n(),tt=a("p"),tt.innerHTML=ue,Yt=n(),m(et.$$.fragment),xt=n(),st=a("p"),st.innerHTML=de,At=n(),m(lt.$$.fragment),Nt=n(),nt=a("p"),nt.innerHTML=Te,Qt=n(),m(rt.$$.fragment),Lt=n(),at=a("p"),at.textContent=be,Pt=n(),it=a("p"),it.innerHTML=$e,qt=n(),pt=a("p"),pt.innerHTML=ye,St=n(),m(J.$$.fragment),Kt=n(),ot=a("p"),this.h()},l(t){const e=Ce("svelte-u9bgzb",document.head);p=i(e,"META",{name:!0,content:!0}),e.forEach(s),b=r(t),d=i(t,"P",{}),he(d).forEach(s),$=r(t),M(y.$$.fragment,t),mt=r(t),M(h.$$.fragment,t),Mt=r(t),M(U.$$.fragment,t),gt=r(t),M(k.$$.fragment,t),ct=r(t),_=i(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-yzse1z"&&(_.innerHTML=te),ft=r(t),G=i(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-ufts1o"&&(G.textContent=ee),ut=r(t),M(Z.$$.fragment,t),dt=r(t),M(R.$$.fragment,t),Tt=r(t),v=i(t,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1u7jlco"&&(v.innerHTML=se),bt=r(t),M(C.$$.fragment,t),$t=r(t),M(j.$$.fragment,t),yt=r(t),W=i(t,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1g8aftd"&&(W.innerHTML=le),jt=r(t),M(H.$$.fragment,t),Jt=r(t),I=i(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1tc6cfe"&&(I.innerHTML=ne),wt=r(t),F=i(t,"P",{"data-svelte-h":!0}),o(F)!=="svelte-rdgn2a"&&(F.innerHTML=re),ht=r(t),M(X.$$.fragment,t),Ut=r(t),z=i(t,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1l514oj"&&(z.innerHTML=ae),kt=r(t),E=i(t,"P",{"data-svelte-h":!0}),o(E)!=="svelte-2nk99r"&&(E.innerHTML=ie),_t=r(t),M(V.$$.fragment,t),Gt=r(t),B=i(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1o2tp52"&&(B.textContent=pe),Zt=r(t),Y=i(t,"OL",{"data-svelte-h":!0}),o(Y)!=="svelte-1gdxy06"&&(Y.innerHTML=oe),Rt=r(t),M(x.$$.fragment,t),vt=r(t),A=i(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-13wbkj"&&(A.innerHTML=me),Ct=r(t),M(N.$$.fragment,t),Wt=r(t),M(Q.$$.fragment,t),Ht=r(t),L=i(t,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1tadn26"&&(L.innerHTML=Me),It=r(t),P=i(t,"P",{"data-svelte-h":!0}),o(P)!=="svelte-x80a2x"&&(P.innerHTML=ge),Ft=r(t),M(q.$$.fragment,t),Xt=r(t),S=i(t,"P",{"data-svelte-h":!0}),o(S)!=="svelte-2z8fgc"&&(S.innerHTML=ce),zt=r(t),M(K.$$.fragment,t),Et=r(t),M(D.$$.fragment,t),Vt=r(t),O=i(t,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1mh7rci"&&(O.innerHTML=fe),Bt=r(t),tt=i(t,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-1gs3ypu"&&(tt.innerHTML=ue),Yt=r(t),M(et.$$.fragment,t),xt=r(t),st=i(t,"P",{"data-svelte-h":!0}),o(st)!=="svelte-1s6lssr"&&(st.innerHTML=de),At=r(t),M(lt.$$.fragment,t),Nt=r(t),nt=i(t,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-1yztrai"&&(nt.innerHTML=Te),Qt=r(t),M(rt.$$.fragment,t),Lt=r(t),at=i(t,"P",{"data-svelte-h":!0}),o(at)!=="svelte-1xq7imi"&&(at.textContent=be),Pt=r(t),it=i(t,"P",{"data-svelte-h":!0}),o(it)!=="svelte-1htwsc9"&&(it.innerHTML=$e),qt=r(t),pt=i(t,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-37vw67"&&(pt.innerHTML=ye),St=r(t),M(J.$$.fragment,t),Kt=r(t),ot=i(t,"P",{}),he(ot).forEach(s),this.h()},h(){Ue(p,"name","hf:doc:metadata"),Ue(p,"content",Ve)},m(t,e){We(document.head,p),l(t,b,e),l(t,d,e),l(t,$,e),g(y,t,e),l(t,mt,e),g(h,t,e),l(t,Mt,e),g(U,t,e),l(t,gt,e),g(k,t,e),l(t,ct,e),l(t,_,e),l(t,ft,e),l(t,G,e),l(t,ut,e),g(Z,t,e),l(t,dt,e),g(R,t,e),l(t,Tt,e),l(t,v,e),l(t,bt,e),g(C,t,e),l(t,$t,e),g(j,t,e),l(t,yt,e),l(t,W,e),l(t,jt,e),g(H,t,e),l(t,Jt,e),l(t,I,e),l(t,wt,e),l(t,F,e),l(t,ht,e),g(X,t,e),l(t,Ut,e),l(t,z,e),l(t,kt,e),l(t,E,e),l(t,_t,e),g(V,t,e),l(t,Gt,e),l(t,B,e),l(t,Zt,e),l(t,Y,e),l(t,Rt,e),g(x,t,e),l(t,vt,e),l(t,A,e),l(t,Ct,e),g(N,t,e),l(t,Wt,e),g(Q,t,e),l(t,Ht,e),l(t,L,e),l(t,It,e),l(t,P,e),l(t,Ft,e),g(q,t,e),l(t,Xt,e),l(t,S,e),l(t,zt,e),g(K,t,e),l(t,Et,e),g(D,t,e),l(t,Vt,e),l(t,O,e),l(t,Bt,e),l(t,tt,e),l(t,Yt,e),g(et,t,e),l(t,xt,e),l(t,st,e),l(t,At,e),g(lt,t,e),l(t,Nt,e),l(t,nt,e),l(t,Qt,e),g(rt,t,e),l(t,Lt,e),l(t,at,e),l(t,Pt,e),l(t,it,e),l(t,qt,e),l(t,pt,e),l(t,St,e),g(J,t,e),l(t,Kt,e),l(t,ot,e),Dt=!0},p(t,[e]){const je={};e&1&&(je.fw=t[0]),y.$set(je);const Je={};e&2&&(Je.$$scope={dirty:e,ctx:t}),j.$set(Je);const we={};e&2&&(we.$$scope={dirty:e,ctx:t}),J.$set(we)},i(t){Dt||(c(y.$$.fragment,t),c(h.$$.fragment,t),c(U.$$.fragment,t),c(k.$$.fragment,t),c(Z.$$.fragment,t),c(R.$$.fragment,t),c(C.$$.fragment,t),c(j.$$.fragment,t),c(H.$$.fragment,t),c(X.$$.fragment,t),c(V.$$.fragment,t),c(x.$$.fragment,t),c(N.$$.fragment,t),c(Q.$$.fragment,t),c(q.$$.fragment,t),c(K.$$.fragment,t),c(D.$$.fragment,t),c(et.$$.fragment,t),c(lt.$$.fragment,t),c(rt.$$.fragment,t),c(J.$$.fragment,t),Dt=!0)},o(t){f(y.$$.fragment,t),f(h.$$.fragment,t),f(U.$$.fragment,t),f(k.$$.fragment,t),f(Z.$$.fragment,t),f(R.$$.fragment,t),f(C.$$.fragment,t),f(j.$$.fragment,t),f(H.$$.fragment,t),f(X.$$.fragment,t),f(V.$$.fragment,t),f(x.$$.fragment,t),f(N.$$.fragment,t),f(Q.$$.fragment,t),f(q.$$.fragment,t),f(K.$$.fragment,t),f(D.$$.fragment,t),f(et.$$.fragment,t),f(lt.$$.fragment,t),f(rt.$$.fragment,t),f(J.$$.fragment,t),Dt=!1},d(t){t&&(s(b),s(d),s($),s(mt),s(Mt),s(gt),s(ct),s(_),s(ft),s(G),s(ut),s(dt),s(Tt),s(v),s(bt),s($t),s(yt),s(W),s(jt),s(Jt),s(I),s(wt),s(F),s(ht),s(Ut),s(z),s(kt),s(E),s(_t),s(Gt),s(B),s(Zt),s(Y),s(Rt),s(vt),s(A),s(Ct),s(Wt),s(Ht),s(L),s(It),s(P),s(Ft),s(Xt),s(S),s(zt),s(Et),s(Vt),s(O),s(Bt),s(tt),s(Yt),s(xt),s(st),s(At),s(Nt),s(nt),s(Qt),s(Lt),s(at),s(Pt),s(it),s(qt),s(pt),s(St),s(Kt),s(ot)),s(p),u(y,t),u(h,t),u(U,t),u(k,t),u(Z,t),u(R,t),u(C,t),u(j,t),u(H,t),u(X,t),u(V,t),u(x,t),u(N,t),u(Q,t),u(q,t),u(K,t),u(D,t),u(et,t),u(lt,t),u(rt,t),u(J,t)}}}const Ve='{"title":"使用 Trainer API 微調模型","local":"使用-trainer-api-微調模型","sections":[{"title":"Training","local":"training","sections":[],"depth":3},{"title":"評估","local":"評估","sections":[],"depth":3}],"depth":1}';function Be(w,p,b){let d="pt";return Ze(()=>{const $=new URLSearchParams(window.location.search);b(0,d=$.get("fw")||"pt")}),[d]}class Se extends Re{constructor(p){super(),ve(this,p,Be,Ee,Ge,{})}}export{Se as component};
