import{s as gt,n as It,o as vt}from"../chunks/scheduler.b9285784.js";import{S as At,i as _t,e as o,s as n,c as r,h as kt,a as s,d as l,b as i,f as Gt,g as d,j as c,k as Ne,l as Bt,m as a,n as y,t as M,o as p,p as m}from"../chunks/index.26bc89a1.js";import{C as xt,H as ne,E as $t}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.e364eac2.js";import{C as ie}from"../chunks/CodeBlock.804615c8.js";function Zt(De){let w,oe,le,se,h,ce,T,re,U,Ke=`PyTorch’s distributed module operates by communicating back and forth between all of the GPUs in your system.
This communication takes time, and ensuring all processes know the states of each other happens at particular triggerpoints
when using the <code>ddp</code> module.`,de,J,qe=`These triggerpoints are added to the PyTorch model, specifically their <code>forward()</code> and <code>backward()</code> methods.
This happens when the model is wrapped with <code>DistributedDataParallel</code>:`,ye,C,Me,f,Oe='In Accelerate this conversion happens automatically when calling <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> and passing in your model.',pe,b,me,j,we,G,et=`You now understand that PyTorch adds hooks to the <code>forward</code> and <code>backward</code> method of your PyTorch model when
training in a distributed setup. But how does this risk slowing down your code?`,ue,g,tt=`In DDP (distributed data parallel), the specific order in which processes are performed and ran are expected
at specific points and these must also occur at roughly the same time before moving on.`,he,I,lt=`The most direct example is when you update model parameters through
<code>optimizer.step()</code>.
Without gradient accumulation, all instances of the model need to have updated
their gradients computed, collated, and updated before moving on to the next
batch of data.
When performing gradient accumulation, you accumulate <code>n</code> loss gradients and
skip <code>optimizer.step()</code> until <code>n</code> batches have been reached. As all training
processes only need to synchronize by the time <code>optimizer.step()</code> is called,
without any modification to your training step, this needless inter-process
communication can cause a significant slowdown.`,Te,v,at="How can you avoid this overhead?",Ue,A,Je,_,nt=`Since you are skipping model parameter updates when training on these batches, their gradients do not need to be synchronized until the point where <code>optimizer.step()</code> is actually called.
PyTorch cannot automagically tell when you need to do this, but they do provide a tool to help through the <a href="https://pytorch.org/docs/stable/generated/torch.nn.parallel.DistributedDataParallel.html#torch.nn.parallel.DistributedDataParallel.no_sync" rel="nofollow"><code>no_sync</code></a> context manager
that is added to your model after converting it to DDP.`,Ce,k,it=`Under this context manager, PyTorch will skip synchronizing the gradients when
<code>.backward()</code> is called, and the first call to <code>.backward()</code> outside this
context manager will trigger the synchronization. See an example below:`,fe,B,be,x,ot=`In Accelerate to make this an API that can be called no matter the training device (though it may not do anything if you are not in a distributed system!),
<code>ddp_model.no_sync</code> gets replaced with <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.no_sync">no_sync()</a> and operates the same way:`,je,$,Ge,Z,st=`As you may expect, the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.accumulate">accumulate()</a> function wraps around this conditional check by keeping track of the current batch number, leaving you with the final
gradient accumulation API:`,ge,z,Ie,H,ct="As a result, you should either use <em><code>accelerator.accumulate</code> or <code>accelerator.no_sync</code></em> when it comes to API choice.",ve,W,Ae,V,rt="To set up a realistic example, consider the following setup:",_e,R,dt='<li>Two single-GPU T4 nodes and one node with two GPUs</li> <li>Each GPU is a T4, and are hosted on GCP</li> <li>The script used is a modification of the <a href="https://github.com/muellerzr/timing_experiments/blob/main/baseline.py" rel="nofollow">NLP Example</a> script</li> <li>Batch size per GPU is 16, and gradients are accumulated every 4 steps</li>',ke,L,yt='All scripts are available in <a href="https://github.com/muellerzr/timing_experiments" rel="nofollow">this repository</a>.',Be,X,Mt=`If not careful about gradient synchronization and GPU communication, a <em>large</em> amount of time can be wasted
from when these GPUs communicate to each other during unnecessary periods.`,xe,S,pt="By how much?",$e,P,mt="Reference:",Ze,Y,wt='<li>Baseline: uses no synchronization practices discussed here</li> <li><code>no_sync</code> improperly: <code>no_sync</code> only around the <code>backward</code> call, not the <code>forward</code></li> <li><code>no_sync</code>: using the <code>no_sync</code> pattern properly</li> <li><code>accumulate</code>: using <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.accumulate">accumulate()</a> properly</li>',ze,F,ut="Below are the average seconds per batch iterating over 29 batches of data for each setup on both a single node and on the dual-node setup:",He,Q,ht='<thead><tr><th align="center"></th> <th align="center">Baseline</th> <th align="center"><code>no_sync</code> improperly</th> <th align="center"><code>no_sync</code></th> <th align="center"><code>accumulate</code></th></tr></thead> <tbody><tr><td align="center">Multi-Node</td> <td align="center">2±0.01s</td> <td align="center">2.13±0.08s</td> <td align="center"><strong>0.91±0.11s</strong></td> <td align="center"><strong>0.91±0.11s</strong></td></tr> <tr><td align="center">Single Node</td> <td align="center">0.50±0.01s</td> <td align="center">0.50±0.01s</td> <td align="center"><strong>0.41±0.015s</strong></td> <td align="center"><strong>0.41±0.015s</strong></td></tr></tbody>',We,E,Tt="As you can see, if you are not careful about how you set up your gradient synchronization, you can get upwards of more than a 2x slowdown during training!",Ve,N,Ut=`If you are worried about making sure everything is done properly, we highly recommend utilizing the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.accumulate">accumulate()</a> function and passing in
<code>gradient_accumulation_steps</code> or <code>gradient_accumulation_plugin</code> to the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> object so Accelerate can handle this for you.`,Re,D,Le,K,Jt='Be aware that not syncing gradients can have adverse effects while performing FSDP training. As it has been warned in <code>torch</code>, the <a href="https://pytorch.org/docs/stable/fsdp.html#torch.distributed.fsdp.FullyShardedDataParallel.no_sync" rel="nofollow"><code>no_sync</code> context manager for FSDP</a> will require additional memory.',Xe,q,Ct='Therefore in memory intensive situations while using FSDP, we recommend to set <code>sync_each_batch</code> to <code>True</code> in the <a href="/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.GradientAccumulationPlugin">GradientAccumulationPlugin</a> to disable <code>no_sync</code>.',Se,O,ft="See the example below where we fine-tune Mixtral (47B parameters) on 8 A100-80GB GPUs. We see that even for a modest <code>gradient_accumulation_steps=2</code> we quickly go out-of-memory (OOM) if <code>no_sync</code> is enabled. Again, this is due to additional memory overheads due to FSDP’s <code>no_sync</code>. However, if <code>no_sync</code> is disabled via <code>sync_each_batch=True</code>, then the memory consumption for <code>gradient_accumulation_steps=16</code> reverts to that of <code>gradient_accumulation_steps=1</code>.",Pe,ee,bt='<thead><tr><th align="center">Model</th> <th align="center"><code>no_sync</code> (accum=1)</th> <th align="center"><code>no_sync</code> (accum=2)</th> <th align="center"><code>no_sync</code> disabled (accum=16)</th></tr></thead> <tbody><tr><td align="center">mixtral 8x7B</td> <td align="center">69G</td> <td align="center">OOM</td> <td align="center">69G</td></tr></tbody>',Ye,u,jt="<p>Disabling <code>no_sync</code> means there <em>will be slowdown</em> due the extra data syncs, as explained by the earlier sections of this guide.</p>",Fe,te,Qe,ae,Ee;return h=new xt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new ne({props:{title:"Gradient synchronization",local:"gradient-synchronization",headingTag:"h1"}}),C=new ie({props:{code:"aW1wb3J0JTIwdG9yY2gubm4lMjBhcyUyMG5uJTBBZnJvbSUyMHRvcmNoLm5uLnBhcmFsbGVsJTIwaW1wb3J0JTIwRGlzdHJpYnV0ZWREYXRhUGFyYWxsZWwlMEElMEFtb2RlbCUyMCUzRCUyMG5uLkxpbmVhcigxMCUyQyUyMDEwKSUwQWRkcF9tb2RlbCUyMCUzRCUyMERpc3RyaWJ1dGVkRGF0YVBhcmFsbGVsKG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">from</span> torch.nn.parallel <span class="hljs-keyword">import</span> DistributedDataParallel

model = nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
ddp_model = DistributedDataParallel(model)`,wrap:!1}}),b=new ie({props:{code:"JTJCJTIwZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUyQiUyMGFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUyMCUyMGltcG9ydCUyMHRvcmNoLm5uJTIwYXMlMjBubiUwQS0lMjBmcm9tJTIwdG9yY2gubm4ucGFyYWxsZWwlMjBpbXBvcnQlMjBEaXN0cmlidXRlZERhdGFQYXJhbGxlbCUwQSUwQSUyMCUyMG1vZGVsJTIwJTNEJTIwbm4uTGluZWFyKDEwJTJDMTApJTBBJTJCJTIwbW9kZWwlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKG1vZGVsKQ==",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
<span class="hljs-addition">+ accelerator = Accelerator()</span>
  import torch.nn as nn
<span class="hljs-deletion">- from torch.nn.parallel import DistributedDataParallel</span>

  model = nn.Linear(10,10)
<span class="hljs-addition">+ model = accelerator.prepare(model)</span>`,wrap:!1}}),j=new ne({props:{title:"The slowdown in gradient accumulation",local:"the-slowdown-in-gradient-accumulation",headingTag:"h2"}}),A=new ne({props:{title:"Solving the slowdown problem",local:"solving-the-slowdown-problem",headingTag:"h2"}}),B=new ie({props:{code:"ZGRwX21vZGVsJTJDJTIwZGF0YWxvYWRlciUyQyUyMG9wdGltaXplciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBkYXRhbG9hZGVyJTJDJTIwb3B0aW1pemVyKSUwQSUwQWZvciUyMGluZGV4JTJDJTIwYmF0Y2glMjBpbiUyMGVudW1lcmF0ZShkYXRhbG9hZGVyKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMCUyMyUyMFRyaWdnZXIlMjBncmFkaWVudCUyMHN5bmNocm9uaXphdGlvbiUyMG9uJTIwdGhlJTIwbGFzdCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwaWYlMjBpbmRleCUyMCElM0QlMjAobGVuKGRhdGFsb2FkZXIpJTIwLSUyMDEpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMGRkcF9tb2RlbC5ub19zeW5jKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBHcmFkaWVudHMlMjBvbmx5JTIwYWNjdW11bGF0ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBkZHBfbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmMob3V0cHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKSUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBHcmFkaWVudHMlMjBmaW5hbGx5JTIwc3luYyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBkZHBfbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmMob3V0cHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci5zdGVwKCk=",highlighted:`ddp_model, dataloader, optimizer = accelerator.prepare(model, dataloader, optimizer)

<span class="hljs-keyword">for</span> index, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(dataloader):
    inputs, targets = batch
    <span class="hljs-comment"># Trigger gradient synchronization on the last batch</span>
    <span class="hljs-keyword">if</span> index != (<span class="hljs-built_in">len</span>(dataloader) - <span class="hljs-number">1</span>):
        <span class="hljs-keyword">with</span> ddp_model.no_sync():
            <span class="hljs-comment"># Gradients only accumulate</span>
            outputs = ddp_model(inputs)
            loss = loss_func(outputs)
            accelerator.backward(loss)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-comment"># Gradients finally sync</span>
        outputs = ddp_model(inputs)
        loss = loss_func(outputs)
        accelerator.backward(loss)
        optimizer.step()`,wrap:!1}}),$=new ie({props:{code:"JTIwJTIwZGRwX21vZGVsJTJDJTIwZGF0YWxvYWRlciUyQyUyMG9wdGltaXplciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBkYXRhbG9hZGVyJTJDJTIwb3B0aW1pemVyKSUwQSUwQSUyMCUyMGZvciUyMGluZGV4JTJDJTIwYmF0Y2glMjBpbiUyMGVudW1lcmF0ZShkYXRhbG9hZGVyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFRyaWdnZXIlMjBncmFkaWVudCUyMHN5bmNocm9uaXphdGlvbiUyMG9uJTIwdGhlJTIwbGFzdCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBpbmRleCUyMCElM0QlMjAobGVuKGRhdGFsb2FkZXIpLTEpJTNBJTBBLSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjBkZHBfbW9kZWwubm9fc3luYygpJTNBJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMGFjY2VsZXJhdG9yLm5vX3N5bmMobW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwR3JhZGllbnRzJTIwb25seSUyMGFjY3VtdWxhdGUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwZGRwX21vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jKG91dHB1dHMlMkMlMjB0YXJnZXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEdyYWRpZW50cyUyMGZpbmFsbHklMjBzeW5jJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMGRkcF9tb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGxvc3NfZnVuYyhvdXRwdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`  ddp_model, dataloader, optimizer = accelerator.prepare(model, dataloader, optimizer)

  for index, batch in enumerate(dataloader):
      inputs, targets = batch
      # Trigger gradient synchronization on the last batch
      if index != (len(dataloader)-1):
<span class="hljs-deletion">-         with ddp_model.no_sync():</span>
<span class="hljs-addition">+         with accelerator.no_sync(model):</span>
              # Gradients only accumulate
              outputs = ddp_model(inputs)
              loss = loss_func(outputs, targets)
              accelerator.backward(loss)
      else:
          # Gradients finally sync
          outputs = ddp_model(inputs)
          loss = loss_func(outputs)
          accelerator.backward(loss)
          optimizer.step()
          optimizer.zero_grad()`,wrap:!1}}),z=new ie({props:{code:"ZGRwX21vZGVsJTJDJTIwZGF0YWxvYWRlciUyQyUyMG9wdGltaXplciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBkYXRhbG9hZGVyJTJDJTIwb3B0aW1pemVyKSUwQSUwQWZvciUyMGJhdGNoJTIwaW4lMjBkYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMGFjY2VsZXJhdG9yLmFjY3VtdWxhdGUobW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCk=",highlighted:`ddp_model, dataloader, optimizer = accelerator.prepare(model, dataloader, optimizer)

<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> dataloader:
    <span class="hljs-keyword">with</span> accelerator.accumulate(model):
        optimizer.zero_grad()
        inputs, targets = batch
        outputs = model(inputs)
        loss = loss_function(outputs, targets)
        accelerator.backward(loss)
        optimizer.step()
        optimizer.zero_grad()`,wrap:!1}}),W=new ne({props:{title:"Just how much of a slowdown is there, and easy mistakes you can make",local:"just-how-much-of-a-slowdown-is-there-and-easy-mistakes-you-can-make",headingTag:"h2"}}),D=new ne({props:{title:"no_sync requires additional GPU memory when using FSDP",local:"nosync-requires-additional-gpu-memory-when-using-fsdp",headingTag:"h3"}}),te=new $t({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/concept_guides/gradient_synchronization.md"}}),{c(){w=o("meta"),oe=n(),le=o("p"),se=n(),r(h.$$.fragment),ce=n(),r(T.$$.fragment),re=n(),U=o("p"),U.innerHTML=Ke,de=n(),J=o("p"),J.innerHTML=qe,ye=n(),r(C.$$.fragment),Me=n(),f=o("p"),f.innerHTML=Oe,pe=n(),r(b.$$.fragment),me=n(),r(j.$$.fragment),we=n(),G=o("p"),G.innerHTML=et,ue=n(),g=o("p"),g.textContent=tt,he=n(),I=o("p"),I.innerHTML=lt,Te=n(),v=o("p"),v.textContent=at,Ue=n(),r(A.$$.fragment),Je=n(),_=o("p"),_.innerHTML=nt,Ce=n(),k=o("p"),k.innerHTML=it,fe=n(),r(B.$$.fragment),be=n(),x=o("p"),x.innerHTML=ot,je=n(),r($.$$.fragment),Ge=n(),Z=o("p"),Z.innerHTML=st,ge=n(),r(z.$$.fragment),Ie=n(),H=o("p"),H.innerHTML=ct,ve=n(),r(W.$$.fragment),Ae=n(),V=o("p"),V.textContent=rt,_e=n(),R=o("ul"),R.innerHTML=dt,ke=n(),L=o("p"),L.innerHTML=yt,Be=n(),X=o("p"),X.innerHTML=Mt,xe=n(),S=o("p"),S.textContent=pt,$e=n(),P=o("p"),P.textContent=mt,Ze=n(),Y=o("ul"),Y.innerHTML=wt,ze=n(),F=o("p"),F.textContent=ut,He=n(),Q=o("table"),Q.innerHTML=ht,We=n(),E=o("p"),E.textContent=Tt,Ve=n(),N=o("p"),N.innerHTML=Ut,Re=n(),r(D.$$.fragment),Le=n(),K=o("p"),K.innerHTML=Jt,Xe=n(),q=o("p"),q.innerHTML=Ct,Se=n(),O=o("p"),O.innerHTML=ft,Pe=n(),ee=o("table"),ee.innerHTML=bt,Ye=n(),u=o("blockquote"),u.innerHTML=jt,Fe=n(),r(te.$$.fragment),Qe=n(),ae=o("p"),this.h()},l(e){const t=kt("svelte-u9bgzb",document.head);w=s(t,"META",{name:!0,content:!0}),t.forEach(l),oe=i(e),le=s(e,"P",{}),Gt(le).forEach(l),se=i(e),d(h.$$.fragment,e),ce=i(e),d(T.$$.fragment,e),re=i(e),U=s(e,"P",{"data-svelte-h":!0}),c(U)!=="svelte-1bq702f"&&(U.innerHTML=Ke),de=i(e),J=s(e,"P",{"data-svelte-h":!0}),c(J)!=="svelte-fqoolu"&&(J.innerHTML=qe),ye=i(e),d(C.$$.fragment,e),Me=i(e),f=s(e,"P",{"data-svelte-h":!0}),c(f)!=="svelte-2k6ktj"&&(f.innerHTML=Oe),pe=i(e),d(b.$$.fragment,e),me=i(e),d(j.$$.fragment,e),we=i(e),G=s(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-byuygg"&&(G.innerHTML=et),ue=i(e),g=s(e,"P",{"data-svelte-h":!0}),c(g)!=="svelte-w9p09z"&&(g.textContent=tt),he=i(e),I=s(e,"P",{"data-svelte-h":!0}),c(I)!=="svelte-1qb001k"&&(I.innerHTML=lt),Te=i(e),v=s(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-14tkwrb"&&(v.textContent=at),Ue=i(e),d(A.$$.fragment,e),Je=i(e),_=s(e,"P",{"data-svelte-h":!0}),c(_)!=="svelte-olrkxe"&&(_.innerHTML=nt),Ce=i(e),k=s(e,"P",{"data-svelte-h":!0}),c(k)!=="svelte-cn8x56"&&(k.innerHTML=it),fe=i(e),d(B.$$.fragment,e),be=i(e),x=s(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-j7c9ip"&&(x.innerHTML=ot),je=i(e),d($.$$.fragment,e),Ge=i(e),Z=s(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-12bvrws"&&(Z.innerHTML=st),ge=i(e),d(z.$$.fragment,e),Ie=i(e),H=s(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-1b3vx79"&&(H.innerHTML=ct),ve=i(e),d(W.$$.fragment,e),Ae=i(e),V=s(e,"P",{"data-svelte-h":!0}),c(V)!=="svelte-1hdyapv"&&(V.textContent=rt),_e=i(e),R=s(e,"UL",{"data-svelte-h":!0}),c(R)!=="svelte-1d218dd"&&(R.innerHTML=dt),ke=i(e),L=s(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-5qwyq6"&&(L.innerHTML=yt),Be=i(e),X=s(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-1yxh0lm"&&(X.innerHTML=Mt),xe=i(e),S=s(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-1n0bzbn"&&(S.textContent=pt),$e=i(e),P=s(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-1i6grvn"&&(P.textContent=mt),Ze=i(e),Y=s(e,"UL",{"data-svelte-h":!0}),c(Y)!=="svelte-10i8zn2"&&(Y.innerHTML=wt),ze=i(e),F=s(e,"P",{"data-svelte-h":!0}),c(F)!=="svelte-vdaq6p"&&(F.textContent=ut),He=i(e),Q=s(e,"TABLE",{"data-svelte-h":!0}),c(Q)!=="svelte-sjfg3j"&&(Q.innerHTML=ht),We=i(e),E=s(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-yk2mxh"&&(E.textContent=Tt),Ve=i(e),N=s(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-8cx020"&&(N.innerHTML=Ut),Re=i(e),d(D.$$.fragment,e),Le=i(e),K=s(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-rzu0c8"&&(K.innerHTML=Jt),Xe=i(e),q=s(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-qdcsdn"&&(q.innerHTML=Ct),Se=i(e),O=s(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-1s75xk0"&&(O.innerHTML=ft),Pe=i(e),ee=s(e,"TABLE",{"data-svelte-h":!0}),c(ee)!=="svelte-iqaw47"&&(ee.innerHTML=bt),Ye=i(e),u=s(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(u)!=="svelte-1be6loi"&&(u.innerHTML=jt),Fe=i(e),d(te.$$.fragment,e),Qe=i(e),ae=s(e,"P",{}),Gt(ae).forEach(l),this.h()},h(){Ne(w,"name","hf:doc:metadata"),Ne(w,"content",zt),Ne(u,"class","warning")},m(e,t){Bt(document.head,w),a(e,oe,t),a(e,le,t),a(e,se,t),y(h,e,t),a(e,ce,t),y(T,e,t),a(e,re,t),a(e,U,t),a(e,de,t),a(e,J,t),a(e,ye,t),y(C,e,t),a(e,Me,t),a(e,f,t),a(e,pe,t),y(b,e,t),a(e,me,t),y(j,e,t),a(e,we,t),a(e,G,t),a(e,ue,t),a(e,g,t),a(e,he,t),a(e,I,t),a(e,Te,t),a(e,v,t),a(e,Ue,t),y(A,e,t),a(e,Je,t),a(e,_,t),a(e,Ce,t),a(e,k,t),a(e,fe,t),y(B,e,t),a(e,be,t),a(e,x,t),a(e,je,t),y($,e,t),a(e,Ge,t),a(e,Z,t),a(e,ge,t),y(z,e,t),a(e,Ie,t),a(e,H,t),a(e,ve,t),y(W,e,t),a(e,Ae,t),a(e,V,t),a(e,_e,t),a(e,R,t),a(e,ke,t),a(e,L,t),a(e,Be,t),a(e,X,t),a(e,xe,t),a(e,S,t),a(e,$e,t),a(e,P,t),a(e,Ze,t),a(e,Y,t),a(e,ze,t),a(e,F,t),a(e,He,t),a(e,Q,t),a(e,We,t),a(e,E,t),a(e,Ve,t),a(e,N,t),a(e,Re,t),y(D,e,t),a(e,Le,t),a(e,K,t),a(e,Xe,t),a(e,q,t),a(e,Se,t),a(e,O,t),a(e,Pe,t),a(e,ee,t),a(e,Ye,t),a(e,u,t),a(e,Fe,t),y(te,e,t),a(e,Qe,t),a(e,ae,t),Ee=!0},p:It,i(e){Ee||(M(h.$$.fragment,e),M(T.$$.fragment,e),M(C.$$.fragment,e),M(b.$$.fragment,e),M(j.$$.fragment,e),M(A.$$.fragment,e),M(B.$$.fragment,e),M($.$$.fragment,e),M(z.$$.fragment,e),M(W.$$.fragment,e),M(D.$$.fragment,e),M(te.$$.fragment,e),Ee=!0)},o(e){p(h.$$.fragment,e),p(T.$$.fragment,e),p(C.$$.fragment,e),p(b.$$.fragment,e),p(j.$$.fragment,e),p(A.$$.fragment,e),p(B.$$.fragment,e),p($.$$.fragment,e),p(z.$$.fragment,e),p(W.$$.fragment,e),p(D.$$.fragment,e),p(te.$$.fragment,e),Ee=!1},d(e){e&&(l(oe),l(le),l(se),l(ce),l(re),l(U),l(de),l(J),l(ye),l(Me),l(f),l(pe),l(me),l(we),l(G),l(ue),l(g),l(he),l(I),l(Te),l(v),l(Ue),l(Je),l(_),l(Ce),l(k),l(fe),l(be),l(x),l(je),l(Ge),l(Z),l(ge),l(Ie),l(H),l(ve),l(Ae),l(V),l(_e),l(R),l(ke),l(L),l(Be),l(X),l(xe),l(S),l($e),l(P),l(Ze),l(Y),l(ze),l(F),l(He),l(Q),l(We),l(E),l(Ve),l(N),l(Re),l(Le),l(K),l(Xe),l(q),l(Se),l(O),l(Pe),l(ee),l(Ye),l(u),l(Fe),l(Qe),l(ae)),l(w),m(h,e),m(T,e),m(C,e),m(b,e),m(j,e),m(A,e),m(B,e),m($,e),m(z,e),m(W,e),m(D,e),m(te,e)}}}const zt='{"title":"Gradient synchronization","local":"gradient-synchronization","sections":[{"title":"The slowdown in gradient accumulation","local":"the-slowdown-in-gradient-accumulation","sections":[],"depth":2},{"title":"Solving the slowdown problem","local":"solving-the-slowdown-problem","sections":[],"depth":2},{"title":"Just how much of a slowdown is there, and easy mistakes you can make","local":"just-how-much-of-a-slowdown-is-there-and-easy-mistakes-you-can-make","sections":[{"title":"no_sync requires additional GPU memory when using FSDP","local":"nosync-requires-additional-gpu-memory-when-using-fsdp","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ht(De){return vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xt extends At{constructor(w){super(),_t(this,w,Ht,Zt,gt,{})}}export{Xt as component};
