import{s as bl,o as fl}from"../chunks/scheduler.b9285784.js";import{S as Ul,i as gl,e as r,s,c,h as Il,a as i,d as t,b as n,f as hl,g as o,j as y,k as Tl,l as _l,m as a,n as p,t as M,o as m,p as d,q as kl,r as Al}from"../chunks/index.26bc89a1.js";import{T as $l}from"../chunks/Tip.e4eba3d6.js";import{C as Bl,H as ie,E as Cl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.e364eac2.js";import{C as u}from"../chunks/CodeBlock.804615c8.js";function Zl(ce){let j;return{c(){j=kl(`Trackers built in Accelerate will automatically execute on the correct process, 
  so if a tracker is only meant to be ran on the main process it will do so 
  automatically.`)},l(J){j=Al(J,`Trackers built in Accelerate will automatically execute on the correct process, 
  so if a tracker is only meant to be ran on the main process it will do so 
  automatically.`)},m(J,h){a(J,j,h)},d(J){J&&t(j)}}}function Gl(ce){let j,J,h,oe,T,pe,b,Me,f,De=`There are a large number of experiment tracking APIs available, however getting them all to work in a multi-processing environment can oftentimes be complex.
Accelerate provides a general tracking API that can be used to log useful items during your script through <code>Accelerator.log()</code>`,me,U,de,g,Oe="Currently <code>Accelerate</code> supports eight trackers out-of-the-box:",ye,I,el="<li>TensorBoard</li> <li>WandB</li> <li>Trackio</li> <li>CometML</li> <li>Aim</li> <li>MLFlow</li> <li>ClearML</li> <li>DVCLive</li>",je,_,ll="To use any of them, pass in the selected type(s) to the <code>log_with</code> parameter in <code>Accelerate</code>:",ue,k,Je,A,tl="At the start of your experiment <code>Accelerator.init_trackers()</code> should be used to setup your project, and potentially add any experiment hyperparameters to be logged:",we,$,he,B,al=`When you are ready to log any data, <code>Accelerator.log()</code> should be used.
A <code>step</code> can also be passed in to correlate the data with a particular step in the training loop.`,Te,C,be,Z,sl='Once you’ve finished training, make sure to run <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.end_training">Accelerator.end_training()</a> so that all the trackers can run their finish functionalities if they have any.',fe,G,Ue,v,nl="A full example is below:",ge,W,Ie,X,rl=`If a tracker requires a directory to save data to, such as <code>TensorBoard</code>, then pass the directory path to <code>project_dir</code>. The <code>project_dir</code> parameter is useful
when there are other configurations to be combined with in the <a href="/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.ProjectConfiguration">ProjectConfiguration</a> data class. For example, you can save the TensorBoard data to <code>project_dir</code> and everything else can be logged in the <code>logging_dir</code> parameter of [<code>~utils.ProjectConfiguration</code>:`,_e,Y,ke,R,Ae,V,il=`To implement a new tracker to be used in <code>Accelerator</code>, a new one can be made through implementing the <code>GeneralTracker</code> class.
Every tracker must implement three functions and have three properties:`,$e,N,cl="<li><p><code>__init__</code>:</p> <ul><li>Should store a <code>run_name</code> and initialize the tracker API of the integrated library.</li> <li>If a tracker stores their data locally (such as TensorBoard), a <code>logging_dir</code> parameter can be added.</li></ul></li> <li><p><code>store_init_configuration</code>:</p> <ul><li>Should take in a <code>values</code> dictionary and store them as a one-time experiment configuration</li></ul></li> <li><p><code>log</code>:</p> <ul><li>Should take in a <code>values</code> dictionary and a <code>step</code>, and should log them to the run</li></ul></li> <li><p><code>name</code> (<code>str</code>):</p> <ul><li>A unique string name for the tracker, such as <code>&quot;wandb&quot;</code> for the wandb tracker.</li> <li>This will be used for interacting with this tracker specifically</li></ul></li> <li><p><code>requires_logging_directory</code> (<code>bool</code>):</p> <ul><li>Whether a <code>logging_dir</code> is needed for this particular tracker and if it uses one.</li></ul></li> <li><p><code>tracker</code>:</p> <ul><li>This should be implemented as a <code>@property</code> function</li> <li>Should return the internal tracking mechanism the library uses, such as the <code>run</code> object for <code>wandb</code>.</li></ul></li>",Be,Q,ol='Each method should also utilize the <a href="/docs/accelerate/main/en/package_reference/state#accelerate.PartialState">state.PartialState</a> class if the logger should only be executed on the main process for instance.',Ce,x,pl=`A brief example can be seen below with an integration with Weights and Biases, containing only the relevant information and logging just on
the main process:`,Ze,E,Ge,F,Ml=`When you are ready to build your <code>Accelerator</code> object, pass in an <strong>instance</strong> of your tracker to <code>Accelerator.log_with</code> to have it automatically
be used with the API:`,ve,H,We,S,ml="These also can be mixed with existing trackers, including with <code>&quot;all&quot;</code>:",Xe,z,Ye,q,Re,L,dl=`If some custom interactions with a tracker might be wanted directly, you can quickly access one using the
<a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.get_tracker">Accelerator.get_tracker()</a> method. Just pass in the string corresponding to a tracker’s <code>.name</code> attribute
and it will return that tracker on the main process.`,Ve,K,yl="This example shows doing so with wandb:",Ne,P,Qe,D,jl="From there you can interact with <code>wandb</code>’s <code>run</code> object like normal:",xe,O,Ee,w,Fe,ee,ul=`If you want to truly remove Accelerate’s wrapping entirely, you can
achieve the same outcome with:`,He,le,Se,te,ze,ae,Jl="If a library has an API that does not follow a strict <code>.log</code> with an overall dictionary such as Neptune.AI, logging can be done manually under an <code>if accelerator.is_main_process</code> statement:",qe,se,Le,ne,Ke,re,Pe;return T=new Bl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),b=new ie({props:{title:"Experiment trackers",local:"experiment-trackers",headingTag:"h1"}}),U=new ie({props:{title:"Integrated Trackers",local:"integrated-trackers",headingTag:"h2"}}),k=new u({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwTG9nZ2VyVHlwZSUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobG9nX3dpdGglM0QlMjJhbGwlMjIpJTIwJTIwJTIzJTIwRm9yJTIwYWxsJTIwYXZhaWxhYmxlJTIwdHJhY2tlcnMlMjBpbiUyMHRoZSUyMGVudmlyb25tZW50JTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihsb2dfd2l0aCUzRCUyMndhbmRiJTIyKSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobG9nX3dpdGglM0QlNUIlMjJ3YW5kYiUyMiUyQyUyMExvZ2dlclR5cGUuVEVOU09SQk9BUkQlNUQp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> LoggerType

accelerator = Accelerator(log_with=<span class="hljs-string">&quot;all&quot;</span>)  <span class="hljs-comment"># For all available trackers in the environment</span>
accelerator = Accelerator(log_with=<span class="hljs-string">&quot;wandb&quot;</span>)
accelerator = Accelerator(log_with=[<span class="hljs-string">&quot;wandb&quot;</span>, LoggerType.TENSORBOARD])`,wrap:!1}}),$=new u({props:{code:"aHBzJTIwJTNEJTIwJTdCJTIybnVtX2l0ZXJhdGlvbnMlMjIlM0ElMjA1JTJDJTIwJTIybGVhcm5pbmdfcmF0ZSUyMiUzQSUyMDFlLTIlN0QlMEFhY2NlbGVyYXRvci5pbml0X3RyYWNrZXJzKCUyMm15X3Byb2plY3QlMjIlMkMlMjBjb25maWclM0RocHMp",highlighted:`hps = {<span class="hljs-string">&quot;num_iterations&quot;</span>: <span class="hljs-number">5</span>, <span class="hljs-string">&quot;learning_rate&quot;</span>: <span class="hljs-number">1e-2</span>}
accelerator.init_trackers(<span class="hljs-string">&quot;my_project&quot;</span>, config=hps)`,wrap:!1}}),C=new u({props:{code:"YWNjZWxlcmF0b3IubG9nKCU3QiUyMnRyYWluX2xvc3MlMjIlM0ElMjAxLjEyJTJDJTIwJTIydmFsaWRfbG9zcyUyMiUzQSUyMDAuOCU3RCUyQyUyMHN0ZXAlM0QxKQ==",highlighted:'accelerator.log({<span class="hljs-string">&quot;train_loss&quot;</span>: <span class="hljs-number">1.12</span>, <span class="hljs-string">&quot;valid_loss&quot;</span>: <span class="hljs-number">0.8</span>}, step=<span class="hljs-number">1</span>)',wrap:!1}}),G=new u({props:{code:"YWNjZWxlcmF0b3IuZW5kX3RyYWluaW5nKCk=",highlighted:"accelerator.end_training()",wrap:!1}}),W=new u({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobG9nX3dpdGglM0QlMjJhbGwlMjIpJTBBY29uZmlnJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIybnVtX2l0ZXJhdGlvbnMlMjIlM0ElMjA1JTJDJTBBJTIwJTIwJTIwJTIwJTIybGVhcm5pbmdfcmF0ZSUyMiUzQSUyMDFlLTIlMkMlMEElMjAlMjAlMjAlMjAlMjJsb3NzX2Z1bmN0aW9uJTIyJTNBJTIwc3RyKG15X2xvc3NfZnVuY3Rpb24pJTJDJTBBJTdEJTBBJTBBYWNjZWxlcmF0b3IuaW5pdF90cmFja2VycyglMjJleGFtcGxlX3Byb2plY3QlMjIlMkMlMjBjb25maWclM0Rjb25maWcpJTBBJTBBbXlfbW9kZWwlMkMlMjBteV9vcHRpbWl6ZXIlMkMlMjBteV90cmFpbmluZ19kYXRhbG9hZGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZShteV9tb2RlbCUyQyUyMG15X29wdGltaXplciUyQyUyMG15X3RyYWluaW5nX2RhdGFsb2FkZXIpJTBBZGV2aWNlJTIwJTNEJTIwYWNjZWxlcmF0b3IuZGV2aWNlJTBBbXlfbW9kZWwudG8oZGV2aWNlKSUwQSUwQWZvciUyMGl0ZXJhdGlvbiUyMGluJTIwcmFuZ2UoY29uZmlnJTVCJTIybnVtX2l0ZXJhdGlvbnMlMjIlNUQpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwc3RlcCUyQyUyMGJhdGNoJTIwaW4lMjBlbnVtZXJhdGUobXlfdHJhaW5pbmdfZGF0YWxvYWRlciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBteV9vcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dHMlMkMlMjB0YXJnZXRzJTIwJTNEJTIwYmF0Y2glMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjBpbnB1dHMudG8oZGV2aWNlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjB0YXJnZXRzLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbXlfbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBteV9sb3NzX2Z1bmN0aW9uKG91dHB1dHMlMkMlMjB0YXJnZXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbXlfb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmxvZyglN0IlMjJ0cmFpbmluZ19sb3NzJTIyJTNBJTIwbG9zcyU3RCUyQyUyMHN0ZXAlM0RzdGVwKSUwQWFjY2VsZXJhdG9yLmVuZF90cmFpbmluZygp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator(log_with=<span class="hljs-string">&quot;all&quot;</span>)
config = {
    <span class="hljs-string">&quot;num_iterations&quot;</span>: <span class="hljs-number">5</span>,
    <span class="hljs-string">&quot;learning_rate&quot;</span>: <span class="hljs-number">1e-2</span>,
    <span class="hljs-string">&quot;loss_function&quot;</span>: <span class="hljs-built_in">str</span>(my_loss_function),
}

accelerator.init_trackers(<span class="hljs-string">&quot;example_project&quot;</span>, config=config)

my_model, my_optimizer, my_training_dataloader = accelerator.prepare(my_model, my_optimizer, my_training_dataloader)
device = accelerator.device
my_model.to(device)

<span class="hljs-keyword">for</span> iteration <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(config[<span class="hljs-string">&quot;num_iterations&quot;</span>]):
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(my_training_dataloader):
        my_optimizer.zero_grad()
        inputs, targets = batch
        inputs = inputs.to(device)
        targets = targets.to(device)
        outputs = my_model(inputs)
        loss = my_loss_function(outputs, targets)
        accelerator.backward(loss)
        my_optimizer.step()
        accelerator.log({<span class="hljs-string">&quot;training_loss&quot;</span>: loss}, step=step)
accelerator.end_training()`,wrap:!1}}),Y=new u({props:{code:"YWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihsb2dfd2l0aCUzRCUyMnRlbnNvcmJvYXJkJTIyJTJDJTIwcHJvamVjdF9kaXIlM0QlMjIuJTIyKSUwQSUwQSUyMyUyMHVzZSUyMHdpdGglMjBQcm9qZWN0Q29uZmlndXJhdGlvbiUwQWNvbmZpZyUyMCUzRCUyMFByb2plY3RDb25maWd1cmF0aW9uKHByb2plY3RfZGlyJTNEJTIyLiUyMiUyQyUyMGxvZ2dpbmdfZGlyJTNEJTIyYW5vdGhlciUyRmRpcmVjdG9yeSUyMiklMEFhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKGxvZ193aXRoJTNEJTIydGVuc29yYm9hcmQlMjIlMkMlMjBwcm9qZWN0X2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`accelerator = Accelerator(log_with=<span class="hljs-string">&quot;tensorboard&quot;</span>, project_dir=<span class="hljs-string">&quot;.&quot;</span>)

<span class="hljs-comment"># use with ProjectConfiguration</span>
config = ProjectConfiguration(project_dir=<span class="hljs-string">&quot;.&quot;</span>, logging_dir=<span class="hljs-string">&quot;another/directory&quot;</span>)
accelerator = Accelerator(log_with=<span class="hljs-string">&quot;tensorboard&quot;</span>, project_config=config)`,wrap:!1}}),R=new ie({props:{title:"Implementing Custom Trackers",local:"implementing-custom-trackers",headingTag:"h2"}}),E=new u({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudHJhY2tpbmclMjBpbXBvcnQlMjBHZW5lcmFsVHJhY2tlciUyQyUyMG9uX21haW5fcHJvY2VzcyUwQWZyb20lMjB0eXBpbmclMjBpbXBvcnQlMjBPcHRpb25hbCUwQSUwQWltcG9ydCUyMHdhbmRiJTBBJTBBJTBBY2xhc3MlMjBNeUN1c3RvbVRyYWNrZXIoR2VuZXJhbFRyYWNrZXIpJTNBJTBBJTIwJTIwJTIwJTIwbmFtZSUyMCUzRCUyMCUyMndhbmRiJTIyJTBBJTIwJTIwJTIwJTIwcmVxdWlyZXNfbG9nZ2luZ19kaXJlY3RvcnklMjAlM0QlMjBGYWxzZSUwQSUwQSUyMCUyMCUyMCUyMCU0MG9uX21haW5fcHJvY2VzcyUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBydW5fbmFtZSUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnJ1bl9uYW1lJTIwJTNEJTIwcnVuX25hbWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBydW4lMjAlM0QlMjB3YW5kYi5pbml0KHNlbGYucnVuX25hbWUpJTBBJTBBJTIwJTIwJTIwJTIwJTQwcHJvcGVydHklMEElMjAlMjAlMjAlMjBkZWYlMjB0cmFja2VyKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2VsZi5ydW4ucnVuJTBBJTBBJTIwJTIwJTIwJTIwJTQwb25fbWFpbl9wcm9jZXNzJTBBJTIwJTIwJTIwJTIwZGVmJTIwc3RvcmVfaW5pdF9jb25maWd1cmF0aW9uKHNlbGYlMkMlMjB2YWx1ZXMlM0ElMjBkaWN0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdhbmRiLmNvbmZpZyh2YWx1ZXMpJTBBJTBBJTIwJTIwJTIwJTIwJTQwb25fbWFpbl9wcm9jZXNzJTBBJTIwJTIwJTIwJTIwZGVmJTIwbG9nKHNlbGYlMkMlMjB2YWx1ZXMlM0ElMjBkaWN0JTJDJTIwc3RlcCUzQSUyME9wdGlvbmFsJTVCaW50JTVEJTIwJTNEJTIwTm9uZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3YW5kYi5sb2codmFsdWVzJTJDJTIwc3RlcCUzRHN0ZXAp",highlighted:`<span class="hljs-keyword">from</span> accelerate.tracking <span class="hljs-keyword">import</span> GeneralTracker, on_main_process
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>

<span class="hljs-keyword">import</span> wandb


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCustomTracker</span>(<span class="hljs-title class_ inherited__">GeneralTracker</span>):
    name = <span class="hljs-string">&quot;wandb&quot;</span>
    requires_logging_directory = <span class="hljs-literal">False</span>

<span class="hljs-meta">    @on_main_process</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, run_name: <span class="hljs-built_in">str</span></span>):
        self.run_name = run_name
        run = wandb.init(self.run_name)

<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">tracker</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> self.run.run

<span class="hljs-meta">    @on_main_process</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">store_init_configuration</span>(<span class="hljs-params">self, values: <span class="hljs-built_in">dict</span></span>):
        wandb.config(values)

<span class="hljs-meta">    @on_main_process</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">log</span>(<span class="hljs-params">self, values: <span class="hljs-built_in">dict</span>, step: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">int</span>] = <span class="hljs-literal">None</span></span>):
        wandb.log(values, step=step)`,wrap:!1}}),H=new u({props:{code:"dHJhY2tlciUyMCUzRCUyME15Q3VzdG9tVHJhY2tlciglMjJzb21lX3J1bl9uYW1lJTIyKSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobG9nX3dpdGglM0R0cmFja2VyKQ==",highlighted:`tracker = MyCustomTracker(<span class="hljs-string">&quot;some_run_name&quot;</span>)
accelerator = Accelerator(log_with=tracker)`,wrap:!1}}),z=new u({props:{code:"dHJhY2tlciUyMCUzRCUyME15Q3VzdG9tVHJhY2tlciglMjJzb21lX3J1bl9uYW1lJTIyKSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobG9nX3dpdGglM0QlNUJ0cmFja2VyJTJDJTIwJTIyYWxsJTIyJTVEKQ==",highlighted:`tracker = MyCustomTracker(<span class="hljs-string">&quot;some_run_name&quot;</span>)
accelerator = Accelerator(log_with=[tracker, <span class="hljs-string">&quot;all&quot;</span>])`,wrap:!1}}),q=new ie({props:{title:"Accessing the internal tracker",local:"accessing-the-internal-tracker",headingTag:"h2"}}),P=new u({props:{code:"d2FuZGJfdHJhY2tlciUyMCUzRCUyMGFjY2VsZXJhdG9yLmdldF90cmFja2VyKCUyMndhbmRiJTIyKQ==",highlighted:'wandb_tracker = accelerator.get_tracker(<span class="hljs-string">&quot;wandb&quot;</span>)',wrap:!1}}),O=new u({props:{code:"d2FuZGJfdHJhY2tlci5sb2dfYXJ0aWZhY3Qoc29tZV9hcnRpZmFjdF90b19sb2cp",highlighted:"wandb_tracker.log_artifact(some_artifact_to_log)",wrap:!1}}),w=new $l({props:{$$slots:{default:[Zl]},$$scope:{ctx:ce}}}),le=new u({props:{code:"d2FuZGJfdHJhY2tlciUyMCUzRCUyMGFjY2VsZXJhdG9yLmdldF90cmFja2VyKCUyMndhbmRiJTIyJTJDJTIwdW53cmFwJTNEVHJ1ZSklMEFpZiUyMGFjY2VsZXJhdG9yLmlzX21haW5fcHJvY2VzcyUzQSUwQSUyMCUyMCUyMCUyMHdhbmRiX3RyYWNrZXIubG9nX2FydGlmYWN0KHNvbWVfYXJ0aWZhY3RfdG9fbG9nKQ==",highlighted:`wandb_tracker = accelerator.get_tracker(<span class="hljs-string">&quot;wandb&quot;</span>, unwrap=<span class="hljs-literal">True</span>)
<span class="hljs-keyword">if</span> accelerator.is_main_process:
    wandb_tracker.log_artifact(some_artifact_to_log)`,wrap:!1}}),te=new ie({props:{title:"When a wrapper cannot work",local:"when-a-wrapper-cannot-work",headingTag:"h2"}}),se=new u({props:{code:"JTIwJTIwZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUyQiUyMGltcG9ydCUyMG5lcHR1bmUlMEElMEElMjAlMjBhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKCklMEElMkIlMjBydW4lMjAlM0QlMjBuZXB0dW5lLmluaXRfcnVuKC4uLiklMEElMEElMjAlMjBteV9tb2RlbCUyQyUyMG15X29wdGltaXplciUyQyUyMG15X3RyYWluaW5nX2RhdGFsb2FkZXIlMjAlM0QlMjBhY2NlbGVyYXRlLnByZXBhcmUobXlfbW9kZWwlMkMlMjBteV9vcHRpbWl6ZXIlMkMlMjBteV90cmFpbmluZ19kYXRhbG9hZGVyKSUwQSUyMCUyMGRldmljZSUyMCUzRCUyMGFjY2VsZXJhdG9yLmRldmljZSUwQSUyMCUyMG15X21vZGVsLnRvKGRldmljZSklMEElMEElMjAlMjBmb3IlMjBpdGVyYXRpb24lMjBpbiUyMGNvbmZpZyU1QiUyMm51bV9pdGVyYXRpb25zJTIyJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMG15X3RyYWluaW5nX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBteV9vcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dHMlMkMlMjB0YXJnZXRzJTIwJTNEJTIwYmF0Y2glMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjBpbnB1dHMudG8oZGV2aWNlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjB0YXJnZXRzLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbXlfbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBteV9sb3NzX2Z1bmN0aW9uKG91dHB1dHMlMkMlMjB0YXJnZXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvdGFsX2xvc3MlMjAlMkIlM0QlMjBsb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBteV9vcHRpbWl6ZXIuc3RlcCgpJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBhY2NlbGVyYXRvci5pc19tYWluX3Byb2Nlc3MlM0ElMEElMkIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBydW4lNUIlMjJsb2dzJTJGdHJhaW5pbmclMkZiYXRjaCUyRmxvc3MlMjIlNUQubG9nKGxvc3Mp",highlighted:`  from accelerate import Accelerator
<span class="hljs-addition">+ import neptune</span>

  accelerator = Accelerator()
<span class="hljs-addition">+ run = neptune.init_run(...)</span>

  my_model, my_optimizer, my_training_dataloader = accelerate.prepare(my_model, my_optimizer, my_training_dataloader)
  device = accelerator.device
  my_model.to(device)

  for iteration in config[&quot;num_iterations&quot;]:
      for batch in my_training_dataloader:
          my_optimizer.zero_grad()
          inputs, targets = batch
          inputs = inputs.to(device)
          targets = targets.to(device)
          outputs = my_model(inputs)
          loss = my_loss_function(outputs, targets)
          total_loss += loss
          accelerator.backward(loss)
          my_optimizer.step()
<span class="hljs-addition">+         if accelerator.is_main_process:</span>
<span class="hljs-addition">+             run[&quot;logs/training/batch/loss&quot;].log(loss)</span>`,wrap:!1}}),ne=new Cl({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/usage_guides/tracking.md"}}),{c(){j=r("meta"),J=s(),h=r("p"),oe=s(),c(T.$$.fragment),pe=s(),c(b.$$.fragment),Me=s(),f=r("p"),f.innerHTML=De,me=s(),c(U.$$.fragment),de=s(),g=r("p"),g.innerHTML=Oe,ye=s(),I=r("ul"),I.innerHTML=el,je=s(),_=r("p"),_.innerHTML=ll,ue=s(),c(k.$$.fragment),Je=s(),A=r("p"),A.innerHTML=tl,we=s(),c($.$$.fragment),he=s(),B=r("p"),B.innerHTML=al,Te=s(),c(C.$$.fragment),be=s(),Z=r("p"),Z.innerHTML=sl,fe=s(),c(G.$$.fragment),Ue=s(),v=r("p"),v.textContent=nl,ge=s(),c(W.$$.fragment),Ie=s(),X=r("p"),X.innerHTML=rl,_e=s(),c(Y.$$.fragment),ke=s(),c(R.$$.fragment),Ae=s(),V=r("p"),V.innerHTML=il,$e=s(),N=r("ul"),N.innerHTML=cl,Be=s(),Q=r("p"),Q.innerHTML=ol,Ce=s(),x=r("p"),x.textContent=pl,Ze=s(),c(E.$$.fragment),Ge=s(),F=r("p"),F.innerHTML=Ml,ve=s(),c(H.$$.fragment),We=s(),S=r("p"),S.innerHTML=ml,Xe=s(),c(z.$$.fragment),Ye=s(),c(q.$$.fragment),Re=s(),L=r("p"),L.innerHTML=dl,Ve=s(),K=r("p"),K.textContent=yl,Ne=s(),c(P.$$.fragment),Qe=s(),D=r("p"),D.innerHTML=jl,xe=s(),c(O.$$.fragment),Ee=s(),c(w.$$.fragment),Fe=s(),ee=r("p"),ee.textContent=ul,He=s(),c(le.$$.fragment),Se=s(),c(te.$$.fragment),ze=s(),ae=r("p"),ae.innerHTML=Jl,qe=s(),c(se.$$.fragment),Le=s(),c(ne.$$.fragment),Ke=s(),re=r("p"),this.h()},l(e){const l=Il("svelte-u9bgzb",document.head);j=i(l,"META",{name:!0,content:!0}),l.forEach(t),J=n(e),h=i(e,"P",{}),hl(h).forEach(t),oe=n(e),o(T.$$.fragment,e),pe=n(e),o(b.$$.fragment,e),Me=n(e),f=i(e,"P",{"data-svelte-h":!0}),y(f)!=="svelte-bw1s2g"&&(f.innerHTML=De),me=n(e),o(U.$$.fragment,e),de=n(e),g=i(e,"P",{"data-svelte-h":!0}),y(g)!=="svelte-153ccmy"&&(g.innerHTML=Oe),ye=n(e),I=i(e,"UL",{"data-svelte-h":!0}),y(I)!=="svelte-1717u44"&&(I.innerHTML=el),je=n(e),_=i(e,"P",{"data-svelte-h":!0}),y(_)!=="svelte-1s812u7"&&(_.innerHTML=ll),ue=n(e),o(k.$$.fragment,e),Je=n(e),A=i(e,"P",{"data-svelte-h":!0}),y(A)!=="svelte-1myr0m3"&&(A.innerHTML=tl),we=n(e),o($.$$.fragment,e),he=n(e),B=i(e,"P",{"data-svelte-h":!0}),y(B)!=="svelte-1eivltl"&&(B.innerHTML=al),Te=n(e),o(C.$$.fragment,e),be=n(e),Z=i(e,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-185unk0"&&(Z.innerHTML=sl),fe=n(e),o(G.$$.fragment,e),Ue=n(e),v=i(e,"P",{"data-svelte-h":!0}),y(v)!=="svelte-14biqpt"&&(v.textContent=nl),ge=n(e),o(W.$$.fragment,e),Ie=n(e),X=i(e,"P",{"data-svelte-h":!0}),y(X)!=="svelte-1xvy8p4"&&(X.innerHTML=rl),_e=n(e),o(Y.$$.fragment,e),ke=n(e),o(R.$$.fragment,e),Ae=n(e),V=i(e,"P",{"data-svelte-h":!0}),y(V)!=="svelte-rvhb9m"&&(V.innerHTML=il),$e=n(e),N=i(e,"UL",{"data-svelte-h":!0}),y(N)!=="svelte-bz1vgf"&&(N.innerHTML=cl),Be=n(e),Q=i(e,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-cy8o0f"&&(Q.innerHTML=ol),Ce=n(e),x=i(e,"P",{"data-svelte-h":!0}),y(x)!=="svelte-1e80qmi"&&(x.textContent=pl),Ze=n(e),o(E.$$.fragment,e),Ge=n(e),F=i(e,"P",{"data-svelte-h":!0}),y(F)!=="svelte-19lwbk8"&&(F.innerHTML=Ml),ve=n(e),o(H.$$.fragment,e),We=n(e),S=i(e,"P",{"data-svelte-h":!0}),y(S)!=="svelte-13imq9d"&&(S.innerHTML=ml),Xe=n(e),o(z.$$.fragment,e),Ye=n(e),o(q.$$.fragment,e),Re=n(e),L=i(e,"P",{"data-svelte-h":!0}),y(L)!=="svelte-10po0uv"&&(L.innerHTML=dl),Ve=n(e),K=i(e,"P",{"data-svelte-h":!0}),y(K)!=="svelte-bsc6i9"&&(K.textContent=yl),Ne=n(e),o(P.$$.fragment,e),Qe=n(e),D=i(e,"P",{"data-svelte-h":!0}),y(D)!=="svelte-gdcdqr"&&(D.innerHTML=jl),xe=n(e),o(O.$$.fragment,e),Ee=n(e),o(w.$$.fragment,e),Fe=n(e),ee=i(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-8mhpnh"&&(ee.textContent=ul),He=n(e),o(le.$$.fragment,e),Se=n(e),o(te.$$.fragment,e),ze=n(e),ae=i(e,"P",{"data-svelte-h":!0}),y(ae)!=="svelte-e74pz9"&&(ae.innerHTML=Jl),qe=n(e),o(se.$$.fragment,e),Le=n(e),o(ne.$$.fragment,e),Ke=n(e),re=i(e,"P",{}),hl(re).forEach(t),this.h()},h(){Tl(j,"name","hf:doc:metadata"),Tl(j,"content",vl)},m(e,l){_l(document.head,j),a(e,J,l),a(e,h,l),a(e,oe,l),p(T,e,l),a(e,pe,l),p(b,e,l),a(e,Me,l),a(e,f,l),a(e,me,l),p(U,e,l),a(e,de,l),a(e,g,l),a(e,ye,l),a(e,I,l),a(e,je,l),a(e,_,l),a(e,ue,l),p(k,e,l),a(e,Je,l),a(e,A,l),a(e,we,l),p($,e,l),a(e,he,l),a(e,B,l),a(e,Te,l),p(C,e,l),a(e,be,l),a(e,Z,l),a(e,fe,l),p(G,e,l),a(e,Ue,l),a(e,v,l),a(e,ge,l),p(W,e,l),a(e,Ie,l),a(e,X,l),a(e,_e,l),p(Y,e,l),a(e,ke,l),p(R,e,l),a(e,Ae,l),a(e,V,l),a(e,$e,l),a(e,N,l),a(e,Be,l),a(e,Q,l),a(e,Ce,l),a(e,x,l),a(e,Ze,l),p(E,e,l),a(e,Ge,l),a(e,F,l),a(e,ve,l),p(H,e,l),a(e,We,l),a(e,S,l),a(e,Xe,l),p(z,e,l),a(e,Ye,l),p(q,e,l),a(e,Re,l),a(e,L,l),a(e,Ve,l),a(e,K,l),a(e,Ne,l),p(P,e,l),a(e,Qe,l),a(e,D,l),a(e,xe,l),p(O,e,l),a(e,Ee,l),p(w,e,l),a(e,Fe,l),a(e,ee,l),a(e,He,l),p(le,e,l),a(e,Se,l),p(te,e,l),a(e,ze,l),a(e,ae,l),a(e,qe,l),p(se,e,l),a(e,Le,l),p(ne,e,l),a(e,Ke,l),a(e,re,l),Pe=!0},p(e,[l]){const wl={};l&2&&(wl.$$scope={dirty:l,ctx:e}),w.$set(wl)},i(e){Pe||(M(T.$$.fragment,e),M(b.$$.fragment,e),M(U.$$.fragment,e),M(k.$$.fragment,e),M($.$$.fragment,e),M(C.$$.fragment,e),M(G.$$.fragment,e),M(W.$$.fragment,e),M(Y.$$.fragment,e),M(R.$$.fragment,e),M(E.$$.fragment,e),M(H.$$.fragment,e),M(z.$$.fragment,e),M(q.$$.fragment,e),M(P.$$.fragment,e),M(O.$$.fragment,e),M(w.$$.fragment,e),M(le.$$.fragment,e),M(te.$$.fragment,e),M(se.$$.fragment,e),M(ne.$$.fragment,e),Pe=!0)},o(e){m(T.$$.fragment,e),m(b.$$.fragment,e),m(U.$$.fragment,e),m(k.$$.fragment,e),m($.$$.fragment,e),m(C.$$.fragment,e),m(G.$$.fragment,e),m(W.$$.fragment,e),m(Y.$$.fragment,e),m(R.$$.fragment,e),m(E.$$.fragment,e),m(H.$$.fragment,e),m(z.$$.fragment,e),m(q.$$.fragment,e),m(P.$$.fragment,e),m(O.$$.fragment,e),m(w.$$.fragment,e),m(le.$$.fragment,e),m(te.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),Pe=!1},d(e){e&&(t(J),t(h),t(oe),t(pe),t(Me),t(f),t(me),t(de),t(g),t(ye),t(I),t(je),t(_),t(ue),t(Je),t(A),t(we),t(he),t(B),t(Te),t(be),t(Z),t(fe),t(Ue),t(v),t(ge),t(Ie),t(X),t(_e),t(ke),t(Ae),t(V),t($e),t(N),t(Be),t(Q),t(Ce),t(x),t(Ze),t(Ge),t(F),t(ve),t(We),t(S),t(Xe),t(Ye),t(Re),t(L),t(Ve),t(K),t(Ne),t(Qe),t(D),t(xe),t(Ee),t(Fe),t(ee),t(He),t(Se),t(ze),t(ae),t(qe),t(Le),t(Ke),t(re)),t(j),d(T,e),d(b,e),d(U,e),d(k,e),d($,e),d(C,e),d(G,e),d(W,e),d(Y,e),d(R,e),d(E,e),d(H,e),d(z,e),d(q,e),d(P,e),d(O,e),d(w,e),d(le,e),d(te,e),d(se,e),d(ne,e)}}}const vl='{"title":"Experiment trackers","local":"experiment-trackers","sections":[{"title":"Integrated Trackers","local":"integrated-trackers","sections":[],"depth":2},{"title":"Implementing Custom Trackers","local":"implementing-custom-trackers","sections":[],"depth":2},{"title":"Accessing the internal tracker","local":"accessing-the-internal-tracker","sections":[],"depth":2},{"title":"When a wrapper cannot work","local":"when-a-wrapper-cannot-work","sections":[],"depth":2}],"depth":1}';function Wl(ce){return fl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ql extends Ul{constructor(j){super(),gl(this,j,Wl,Gl,bl,{})}}export{Ql as component};
