import{s as Dl,n as Ol,o as Kl}from"../chunks/scheduler.5f3e6389.js";import{S as te,i as le,e as m,s as a,c as i,h as ee,a as U,d as e,b as n,f as Pl,g as M,j as u,k as bl,l as se,m as s,n as o,t as p,o as y,p as r}from"../chunks/index.373ab25c.js";import{C as ae,H as T,E as ne}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.f6d2fa18.js";import{C as w}from"../chunks/CodeBlock.f6cc113c.js";function ie(dl){let c,gt,ht,Ct,j,ft,g,It,C,$l="Lighteval supports multilingual evaluations through a comprehensive system of translation literals and language-adapted templates.",bt,f,dt,I,$t,b,vl="We define 19 <code>literals</code>, basic keywords or punctuation signs used when creating evaluation prompts in an automatic manner, such as <code>yes</code>, <code>no</code>, <code>because</code>, etc.",vt,d,Gl="These literals are essential for:",Gt,$,kl="<li><strong>Consistent prompt formatting</strong> across languages</li> <li><strong>Automatic prompt generation</strong> for multilingual tasks</li> <li><strong>Proper localization</strong> of evaluation templates</li>",kt,v,Bt,G,Bl="We welcome translations in your language! To contribute:",Zt,k,Zl='<li><p><strong>Open the translation literals file</strong>: <a href="https://github.com/huggingface/lighteval/blob/main/src/lighteval/tasks/templates/utils/translation_literals.py" rel="nofollow">translation_literals.py</a></p></li> <li><p><strong>Edit the file</strong> to add or expand the literal for your language of interest</p></li> <li><p><strong>Open a PR</strong> with your modifications</p></li>',Wt,B,At,Z,Ft,W,Qt,A,Xt,F,Wl="Before creating a new multilingual task, you should:",xt,Q,Al='<li><strong>Read the custom task guide</strong>: <a href="adding-a-custom-task">Adding a Custom Task</a></li> <li><strong>Understand multilingual task structure</strong>: Review the <a href="https://github.com/huggingface/lighteval/blob/main/src/lighteval/tasks/multilingual/tasks.py" rel="nofollow">multilingual tasks</a> file</li> <li><strong>Browse available templates</strong>: Check the <a href="https://github.com/huggingface/lighteval/tree/main/src/lighteval/tasks/templates" rel="nofollow">templates directory</a></li>',Rt,X,St,x,Yt,R,Fl="For multilingual evaluations, the <code>prompt_function</code> should be implemented using language-adapted templates. These templates handle:",Vt,S,Ql="<li><strong>Correct formatting</strong> for each language</li> <li><strong>Consistent usage</strong> of language-adjusted prompt anchors (e.g., Question/Answer)</li> <li><strong>Proper punctuation</strong> and spacing conventions</li>",Et,Y,qt,V,Xl="Available template types include:",Ht,E,xl='<li><strong>XNLI</strong>: Natural language inference tasks - <a href="https://github.com/huggingface/lighteval/blob/main/src/lighteval/tasks/templates/nli.py#L162" rel="nofollow"><code>get_nli_prompt_function</code></a></li> <li><strong>COPA</strong>: Causal reasoning tasks - <a href="https://github.com/huggingface/lighteval/blob/main/src/lighteval/tasks/templates/copa.py#L76" rel="nofollow"><code>get_copa_prompt_function</code></a></li> <li><strong>Multiple Choice</strong>: Standard multiple choice questions - <a href="https://github.com/huggingface/lighteval/blob/main/src/lighteval/tasks/templates/multichoice.py#L81" rel="nofollow"><code>get_mcq_prompt_function</code></a></li> <li><strong>Question Answering</strong>: Open-ended question answering - <a href="https://github.com/huggingface/lighteval/blob/main/src/lighteval/tasks/templates/qa.py#L46" rel="nofollow"><code>get_qa_prompt_function</code></a></li> <li><strong>Custom</strong>: Specialized task templates</li>',zt,q,_t,H,Nt,z,Rl="Used for standard multiple choice questions where the model selects from lettered options:",Lt,_,Pt,N,Sl="<strong>Example output:</strong>",Dt,L,Ot,P,Kt,D,Yl="Used for classification tasks where the model generates the answer directly:",tl,O,ll,K,Vl="<strong>Example output:</strong>",el,tt,sl,lt,al,et,El="Used for tasks that present choices but expect the full answer text:",nl,st,il,at,ql="<strong>Example output:</strong>",Ml,nt,ol,it,pl,Mt,yl,ot,Hl="Create a Python file following the custom task guide structure.",rl,pt,ml,yt,Ul,rt,ul,mt,Tl,Ut,cl,ut,zl="Follow the custom task guide to test if your task is correctly implemented.",wl,J,_l='<p>All <a href="/docs/lighteval/main/en/package_reference/tasks#lighteval.tasks.lighteval_task.LightevalTaskConfig">LightevalTaskConfig</a> parameters are strongly typed, including the inputs to the template function. Make sure to take advantage of your IDE’s functionality to make it easier to correctly fill these parameters.</p>',Jl,Tt,hl,h,Nl='<li class="task-list-item"><input type="checkbox" disabled=""/> Translation literals are accurate and complete</li> <li class="task-list-item"><input type="checkbox" disabled=""/> Task works correctly across all target languages</li> <li class="task-list-item"><input type="checkbox" disabled=""/> Metrics are appropriate for the task type</li> <li class="task-list-item"><input type="checkbox" disabled=""/> Documentation is clear and comprehensive</li> <li class="task-list-item"><input type="checkbox" disabled=""/> Code follows project conventions</li>',jl,ct,gl,wt,Ll="<li><strong>GitHub Issues</strong>: Report bugs or ask questions</li> <li><strong>Discussions</strong>: Join community discussions</li> <li><strong>Documentation</strong>: Review existing guides and examples</li>",Cl,Jt,fl,jt,Il;return j=new ae({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new T({props:{title:"Contributing to Multilingual Evaluations",local:"contributing-to-multilingual-evaluations",headingTag:"h1"}}),f=new T({props:{title:"Contributing Translation Literals",local:"contributing-translation-literals",headingTag:"h2"}}),I=new T({props:{title:"What Are Translation Literals?",local:"what-are-translation-literals",headingTag:"h3"}}),v=new T({props:{title:"How to Contribute Translations",local:"how-to-contribute-translations",headingTag:"h3"}}),B=new T({props:{title:"Translation Literals Structure",local:"translation-literals-structure",headingTag:"h3"}}),Z=new w({props:{code:"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",highlighted:`Language.ENGLISH: TranslationLiterals(
    language=Language.ENGLISH,
    question_word=<span class="hljs-string">&quot;question&quot;</span>,  <span class="hljs-comment"># Usage: &quot;Question: How are you?&quot;</span>
    answer=<span class="hljs-string">&quot;answer&quot;</span>,  <span class="hljs-comment"># Usage: &quot;Answer: I am fine&quot;</span>
    confirmation_word=<span class="hljs-string">&quot;right&quot;</span>,  <span class="hljs-comment"># Usage: &quot;He is smart, right?&quot;</span>
    yes=<span class="hljs-string">&quot;yes&quot;</span>,  <span class="hljs-comment"># Usage: &quot;Yes, he is&quot;</span>
    no=<span class="hljs-string">&quot;no&quot;</span>,  <span class="hljs-comment"># Usage: &quot;No, he is not&quot;</span>
    also=<span class="hljs-string">&quot;also&quot;</span>,  <span class="hljs-comment"># Usage: &quot;Also, she is smart.&quot;</span>
    cause_word=<span class="hljs-string">&quot;because&quot;</span>,  <span class="hljs-comment"># Usage: &quot;She is smart, because she is tall&quot;</span>
    effect_word=<span class="hljs-string">&quot;therefore&quot;</span>,  <span class="hljs-comment"># Usage: &quot;He is tall therefore he is smart&quot;</span>
    or_word=<span class="hljs-string">&quot;or&quot;</span>,  <span class="hljs-comment"># Usage: &quot;He is tall or small&quot;</span>
    true=<span class="hljs-string">&quot;true&quot;</span>,  <span class="hljs-comment"># Usage: &quot;He is smart, true, false or neither?&quot;</span>
    false=<span class="hljs-string">&quot;false&quot;</span>,  <span class="hljs-comment"># Usage: &quot;He is smart, true, false or neither?&quot;</span>
    neither=<span class="hljs-string">&quot;neither&quot;</span>,  <span class="hljs-comment"># Usage: &quot;He is smart, true, false or neither?&quot;</span>
    <span class="hljs-comment"># Punctuation and spacing: only adjust if your language uses something different than in English</span>
    full_stop=<span class="hljs-string">&quot;.&quot;</span>,
    comma=<span class="hljs-string">&quot;,&quot;</span>,
    question_mark=<span class="hljs-string">&quot;?&quot;</span>,
    exclamation_mark=<span class="hljs-string">&quot;!&quot;</span>,
    word_space=<span class="hljs-string">&quot; &quot;</span>,
    sentence_space=<span class="hljs-string">&quot; &quot;</span>,
    colon=<span class="hljs-string">&quot;:&quot;</span>,
    <span class="hljs-comment"># The first characters of your alphabet used in enumerations, if different from English</span>
    indices=[<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>, ...]
)`,wrap:!1}}),W=new T({props:{title:"Contributing New Multilingual Tasks",local:"contributing-new-multilingual-tasks",headingTag:"h2"}}),A=new T({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h3"}}),X=new T({props:{title:"Key Concepts",local:"key-concepts",headingTag:"h3"}}),x=new T({props:{title:"Language-Adapted Templates",local:"language-adapted-templates",headingTag:"h4"}}),Y=new T({props:{title:"Template Types",local:"template-types",headingTag:"h4"}}),q=new T({props:{title:"Formulation Types",local:"formulation-types",headingTag:"h4"}}),H=new T({props:{title:"Multiple Choice Formulation (MCF)",local:"multiple-choice-formulation-mcf",headingTag:"h5"}}),_=new w({props:{code:"TUNGRm9ybXVsYXRpb24oKQ==",highlighted:"MCFFormulation()",wrap:!1}}),L=new w({props:{code:"UXVlc3Rpb24lM0ElMjBXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMEFBLiUyMExvbmRvbiUwQUIuJTIwUGFyaXMlMEFDLiUyMEJlcmxpbiUwQUQuJTIwUm9tZSUwQUFuc3dlciUzQSUyMCU3QyUyMEElMkZCJTJGQyUyRkQ=",highlighted:`<span class="hljs-variable">Question</span><span class="hljs-operator">:</span> <span class="hljs-variable">What</span> <span class="hljs-variable">is</span> <span class="hljs-variable">the</span> <span class="hljs-variable">capital</span> <span class="hljs-variable">of</span> <span class="hljs-variable">France</span><span class="hljs-operator">?</span>
<span class="hljs-variable">A</span><span class="hljs-operator">.</span> <span class="hljs-variable">London</span>
<span class="hljs-variable">B</span><span class="hljs-operator">.</span> <span class="hljs-variable">Paris</span>
<span class="hljs-built_in">C</span><span class="hljs-operator">.</span> <span class="hljs-variable">Berlin</span>
<span class="hljs-built_in">D</span><span class="hljs-operator">.</span> <span class="hljs-variable">Rome</span>
<span class="hljs-variable">Answer</span><span class="hljs-operator">:</span> <span class="hljs-operator">|</span> <span class="hljs-variable">A</span><span class="hljs-operator">/</span><span class="hljs-variable">B</span><span class="hljs-operator">/</span><span class="hljs-built_in">C</span><span class="hljs-operator">/</span><span class="hljs-built_in">D</span>`,wrap:!1}}),P=new T({props:{title:"Classification Formulation (CF)",local:"classification-formulation-cf",headingTag:"h5"}}),O=new w({props:{code:"Q0ZGb3JtdWxhdGlvbigp",highlighted:"CFFormulation()",wrap:!1}}),tt=new w({props:{code:"UXVlc3Rpb24lM0ElMjBXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMEFBbnN3ZXIlM0ElMjAlN0MlMjBQYXJpcw==",highlighted:`<span class="hljs-symbol">Question:</span> What <span class="hljs-built_in">is</span> the capital <span class="hljs-keyword">of</span> France?
<span class="hljs-symbol">Answer:</span> | Paris`,wrap:!1}}),lt=new T({props:{title:"Hybrid Formulation",local:"hybrid-formulation",headingTag:"h5"}}),st=new w({props:{code:"SHlicmlkRm9ybXVsYXRpb24oKQ==",highlighted:"HybridFormulation()",wrap:!1}}),nt=new w({props:{code:"UXVlc3Rpb24lM0ElMjBXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMEFBLiUyMExvbmRvbiUwQUIuJTIwUGFyaXMlMEFDLiUyMEJlcmxpbiUwQUQuJTIwUm9tZSUwQUFuc3dlciUzQSUyMCU3QyUyMFBhcmlz",highlighted:`<span class="hljs-symbol">Question:</span> What <span class="hljs-built_in">is</span> the capital <span class="hljs-keyword">of</span> France?
A. London
B. Paris
C. Berlin
D. Rome
<span class="hljs-symbol">Answer:</span> | Paris`,wrap:!1}}),it=new T({props:{title:"Creating Your Multilingual Task",local:"creating-your-multilingual-task",headingTag:"h3"}}),Mt=new T({props:{title:"Step 1: Create the Task File",local:"step-1-create-the-task-file",headingTag:"h4"}}),pt=new T({props:{title:"Step 2: Import Required Components",local:"step-2-import-required-components",headingTag:"h4"}}),yt=new w({props:{code:"ZnJvbSUyMGxpZ2h0ZXZhbC50YXNrcy5saWdodGV2YWxfdGFzayUyMGltcG9ydCUyMExpZ2h0ZXZhbFRhc2tDb25maWclMEFmcm9tJTIwbGlnaHRldmFsLnRhc2tzLm11bHRpbGluZ3VhbC5sYW5ndWFnZSUyMGltcG9ydCUyMExhbmd1YWdlJTBBZnJvbSUyMGxpZ2h0ZXZhbC50YXNrcy5tdWx0aWxpbmd1YWwuZm9ybXVsYXRpb25zJTIwaW1wb3J0JTIwTUNGRm9ybXVsYXRpb24lMkMlMjBDRkZvcm11bGF0aW9uJTJDJTIwSHlicmlkRm9ybXVsYXRpb24lMEFmcm9tJTIwbGlnaHRldmFsLnRhc2tzLm11bHRpbGluZ3VhbC50ZW1wbGF0ZXMlMjBpbXBvcnQlMjBnZXRfdGVtcGxhdGVfcHJvbXB0X2Z1bmN0aW9uJTBBZnJvbSUyMGxpZ2h0ZXZhbC50YXNrcy5tdWx0aWxpbmd1YWwubWV0cmljcyUyMGltcG9ydCUyMGdldF9tZXRyaWNzX2Zvcl9mb3JtdWxhdGlvbiUyQyUyMGxvZ2xpa2VsaWhvb2RfYWNjX21ldHJpYyUwQWZyb20lMjBsaWdodGV2YWwudGFza3MubXVsdGlsaW5ndWFsLm5vcm1hbGl6YXRpb24lMjBpbXBvcnQlMjBMb2dQcm9iVG9rZW5Ob3JtJTJDJTIwTG9nUHJvYkNoYXJOb3Jt",highlighted:`<span class="hljs-keyword">from</span> lighteval.tasks.lighteval_task <span class="hljs-keyword">import</span> LightevalTaskConfig
<span class="hljs-keyword">from</span> lighteval.tasks.multilingual.language <span class="hljs-keyword">import</span> Language
<span class="hljs-keyword">from</span> lighteval.tasks.multilingual.formulations <span class="hljs-keyword">import</span> MCFFormulation, CFFormulation, HybridFormulation
<span class="hljs-keyword">from</span> lighteval.tasks.multilingual.templates <span class="hljs-keyword">import</span> get_template_prompt_function
<span class="hljs-keyword">from</span> lighteval.tasks.multilingual.metrics <span class="hljs-keyword">import</span> get_metrics_for_formulation, loglikelihood_acc_metric
<span class="hljs-keyword">from</span> lighteval.tasks.multilingual.normalization <span class="hljs-keyword">import</span> LogProbTokenNorm, LogProbCharNorm`,wrap:!1}}),rt=new T({props:{title:"Step 3: Define Your Tasks",local:"step-3-define-your-tasks",headingTag:"h4"}}),mt=new w({props:{code:"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",highlighted:`your_tasks = [
    LightevalTaskConfig(
        <span class="hljs-comment"># Name of your evaluation</span>
        name=<span class="hljs-string">f&quot;evalname_<span class="hljs-subst">{language.value}</span>_<span class="hljs-subst">{formulation.name.lower()}</span>&quot;</span>,
        <span class="hljs-comment"># The evaluation is community contributed</span>
        suite=[<span class="hljs-string">&quot;community&quot;</span>],
        <span class="hljs-comment"># This will automatically get the correct metrics for your chosen formulation</span>
        metric=get_metrics_for_formulation(
            formulation,
            [
                LogLikelihoodAccMetric(normalization=<span class="hljs-literal">None</span>),
                LogLikelihoodAccMetric(normalization=LogProbTokenNorm()),
                LogLikelihoodAccMetric(normalization=LogProbCharNorm()),
            ],
        ),
        <span class="hljs-comment"># In this function, you choose which template to follow and for which language and formulation</span>
        prompt_function=get_template_prompt_function(
            language=language,
            <span class="hljs-comment"># Use the adapter to define the mapping between the</span>
            <span class="hljs-comment"># keys of the template (left), and the keys of your dataset</span>
            <span class="hljs-comment"># (right)</span>
            <span class="hljs-comment"># To know which template keys are required and available,</span>
            <span class="hljs-comment"># consult the appropriate adapter type and doc-string.</span>
            adapter=<span class="hljs-keyword">lambda</span> line: {
                <span class="hljs-string">&quot;key&quot;</span>: line[<span class="hljs-string">&quot;relevant_key&quot;</span>],
                <span class="hljs-comment"># Add more mappings as needed</span>
            },
            formulation=formulation,
        ),
        <span class="hljs-comment"># You can also add specific filters to remove irrelevant samples</span>
        hf_filter=<span class="hljs-keyword">lambda</span> line: line[<span class="hljs-string">&quot;label&quot;</span>] <span class="hljs-keyword">in</span> &lt;condition&gt;,
        <span class="hljs-comment"># You then select your huggingface dataset as well as</span>
        <span class="hljs-comment"># the splits available for evaluation</span>
        hf_repo=&lt;dataset&gt;,
        hf_subset=&lt;subset&gt;,
        evaluation_splits=[<span class="hljs-string">&quot;train&quot;</span>],
        hf_avail_splits=[<span class="hljs-string">&quot;train&quot;</span>],
    )
    <span class="hljs-keyword">for</span> language <span class="hljs-keyword">in</span> [
        Language.YOUR_LANGUAGE,  <span class="hljs-comment"># Add your target languages</span>
        <span class="hljs-comment"># Language.SPANISH,</span>
        <span class="hljs-comment"># Language.FRENCH,</span>
        <span class="hljs-comment"># etc.</span>
    ]
    <span class="hljs-keyword">for</span> formulation <span class="hljs-keyword">in</span> [MCFFormulation(), CFFormulation(), HybridFormulation()]
]`,wrap:!1}}),Ut=new T({props:{title:"Step 4: Test Your Implementation",local:"step-4-test-your-implementation",headingTag:"h4"}}),Tt=new T({props:{title:"Validation Checklist",local:"validation-checklist",headingTag:"h3"}}),ct=new T({props:{title:"Getting Help",local:"getting-help",headingTag:"h3"}}),Jt=new ne({props:{source:"https://github.com/huggingface/lighteval/blob/main/docs/source/contributing-to-multilingual-evaluations.mdx"}}),{c(){c=m("meta"),gt=a(),ht=m("p"),Ct=a(),i(j.$$.fragment),ft=a(),i(g.$$.fragment),It=a(),C=m("p"),C.textContent=$l,bt=a(),i(f.$$.fragment),dt=a(),i(I.$$.fragment),$t=a(),b=m("p"),b.innerHTML=vl,vt=a(),d=m("p"),d.textContent=Gl,Gt=a(),$=m("ul"),$.innerHTML=kl,kt=a(),i(v.$$.fragment),Bt=a(),G=m("p"),G.textContent=Bl,Zt=a(),k=m("ol"),k.innerHTML=Zl,Wt=a(),i(B.$$.fragment),At=a(),i(Z.$$.fragment),Ft=a(),i(W.$$.fragment),Qt=a(),i(A.$$.fragment),Xt=a(),F=m("p"),F.textContent=Wl,xt=a(),Q=m("ol"),Q.innerHTML=Al,Rt=a(),i(X.$$.fragment),St=a(),i(x.$$.fragment),Yt=a(),R=m("p"),R.innerHTML=Fl,Vt=a(),S=m("ul"),S.innerHTML=Ql,Et=a(),i(Y.$$.fragment),qt=a(),V=m("p"),V.textContent=Xl,Ht=a(),E=m("ul"),E.innerHTML=xl,zt=a(),i(q.$$.fragment),_t=a(),i(H.$$.fragment),Nt=a(),z=m("p"),z.textContent=Rl,Lt=a(),i(_.$$.fragment),Pt=a(),N=m("p"),N.innerHTML=Sl,Dt=a(),i(L.$$.fragment),Ot=a(),i(P.$$.fragment),Kt=a(),D=m("p"),D.textContent=Yl,tl=a(),i(O.$$.fragment),ll=a(),K=m("p"),K.innerHTML=Vl,el=a(),i(tt.$$.fragment),sl=a(),i(lt.$$.fragment),al=a(),et=m("p"),et.textContent=El,nl=a(),i(st.$$.fragment),il=a(),at=m("p"),at.innerHTML=ql,Ml=a(),i(nt.$$.fragment),ol=a(),i(it.$$.fragment),pl=a(),i(Mt.$$.fragment),yl=a(),ot=m("p"),ot.textContent=Hl,rl=a(),i(pt.$$.fragment),ml=a(),i(yt.$$.fragment),Ul=a(),i(rt.$$.fragment),ul=a(),i(mt.$$.fragment),Tl=a(),i(Ut.$$.fragment),cl=a(),ut=m("p"),ut.textContent=zl,wl=a(),J=m("blockquote"),J.innerHTML=_l,Jl=a(),i(Tt.$$.fragment),hl=a(),h=m("ul"),h.innerHTML=Nl,jl=a(),i(ct.$$.fragment),gl=a(),wt=m("ul"),wt.innerHTML=Ll,Cl=a(),i(Jt.$$.fragment),fl=a(),jt=m("p"),this.h()},l(t){const l=ee("svelte-u9bgzb",document.head);c=U(l,"META",{name:!0,content:!0}),l.forEach(e),gt=n(t),ht=U(t,"P",{}),Pl(ht).forEach(e),Ct=n(t),M(j.$$.fragment,t),ft=n(t),M(g.$$.fragment,t),It=n(t),C=U(t,"P",{"data-svelte-h":!0}),u(C)!=="svelte-1re6ahv"&&(C.textContent=$l),bt=n(t),M(f.$$.fragment,t),dt=n(t),M(I.$$.fragment,t),$t=n(t),b=U(t,"P",{"data-svelte-h":!0}),u(b)!=="svelte-119kr4u"&&(b.innerHTML=vl),vt=n(t),d=U(t,"P",{"data-svelte-h":!0}),u(d)!=="svelte-3mks6q"&&(d.textContent=Gl),Gt=n(t),$=U(t,"UL",{"data-svelte-h":!0}),u($)!=="svelte-1dsw83j"&&($.innerHTML=kl),kt=n(t),M(v.$$.fragment,t),Bt=n(t),G=U(t,"P",{"data-svelte-h":!0}),u(G)!=="svelte-awnkj1"&&(G.textContent=Bl),Zt=n(t),k=U(t,"OL",{"data-svelte-h":!0}),u(k)!=="svelte-1s61htl"&&(k.innerHTML=Zl),Wt=n(t),M(B.$$.fragment,t),At=n(t),M(Z.$$.fragment,t),Ft=n(t),M(W.$$.fragment,t),Qt=n(t),M(A.$$.fragment,t),Xt=n(t),F=U(t,"P",{"data-svelte-h":!0}),u(F)!=="svelte-1k1ke89"&&(F.textContent=Wl),xt=n(t),Q=U(t,"OL",{"data-svelte-h":!0}),u(Q)!=="svelte-1v6bdr0"&&(Q.innerHTML=Al),Rt=n(t),M(X.$$.fragment,t),St=n(t),M(x.$$.fragment,t),Yt=n(t),R=U(t,"P",{"data-svelte-h":!0}),u(R)!=="svelte-10zen67"&&(R.innerHTML=Fl),Vt=n(t),S=U(t,"UL",{"data-svelte-h":!0}),u(S)!=="svelte-1pehqym"&&(S.innerHTML=Ql),Et=n(t),M(Y.$$.fragment,t),qt=n(t),V=U(t,"P",{"data-svelte-h":!0}),u(V)!=="svelte-fj6wl8"&&(V.textContent=Xl),Ht=n(t),E=U(t,"UL",{"data-svelte-h":!0}),u(E)!=="svelte-ewvrtu"&&(E.innerHTML=xl),zt=n(t),M(q.$$.fragment,t),_t=n(t),M(H.$$.fragment,t),Nt=n(t),z=U(t,"P",{"data-svelte-h":!0}),u(z)!=="svelte-vecr4s"&&(z.textContent=Rl),Lt=n(t),M(_.$$.fragment,t),Pt=n(t),N=U(t,"P",{"data-svelte-h":!0}),u(N)!=="svelte-5gri02"&&(N.innerHTML=Sl),Dt=n(t),M(L.$$.fragment,t),Ot=n(t),M(P.$$.fragment,t),Kt=n(t),D=U(t,"P",{"data-svelte-h":!0}),u(D)!=="svelte-1616vrk"&&(D.textContent=Yl),tl=n(t),M(O.$$.fragment,t),ll=n(t),K=U(t,"P",{"data-svelte-h":!0}),u(K)!=="svelte-5gri02"&&(K.innerHTML=Vl),el=n(t),M(tt.$$.fragment,t),sl=n(t),M(lt.$$.fragment,t),al=n(t),et=U(t,"P",{"data-svelte-h":!0}),u(et)!=="svelte-qvptvt"&&(et.textContent=El),nl=n(t),M(st.$$.fragment,t),il=n(t),at=U(t,"P",{"data-svelte-h":!0}),u(at)!=="svelte-5gri02"&&(at.innerHTML=ql),Ml=n(t),M(nt.$$.fragment,t),ol=n(t),M(it.$$.fragment,t),pl=n(t),M(Mt.$$.fragment,t),yl=n(t),ot=U(t,"P",{"data-svelte-h":!0}),u(ot)!=="svelte-10cbov8"&&(ot.textContent=Hl),rl=n(t),M(pt.$$.fragment,t),ml=n(t),M(yt.$$.fragment,t),Ul=n(t),M(rt.$$.fragment,t),ul=n(t),M(mt.$$.fragment,t),Tl=n(t),M(Ut.$$.fragment,t),cl=n(t),ut=U(t,"P",{"data-svelte-h":!0}),u(ut)!=="svelte-xvg35t"&&(ut.textContent=zl),wl=n(t),J=U(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(J)!=="svelte-x1zn60"&&(J.innerHTML=_l),Jl=n(t),M(Tt.$$.fragment,t),hl=n(t),h=U(t,"UL",{class:!0,"data-svelte-h":!0}),u(h)!=="svelte-18pkgkh"&&(h.innerHTML=Nl),jl=n(t),M(ct.$$.fragment,t),gl=n(t),wt=U(t,"UL",{"data-svelte-h":!0}),u(wt)!=="svelte-47kvog"&&(wt.innerHTML=Ll),Cl=n(t),M(Jt.$$.fragment,t),fl=n(t),jt=U(t,"P",{}),Pl(jt).forEach(e),this.h()},h(){bl(c,"name","hf:doc:metadata"),bl(c,"content",Me),bl(J,"class","tip"),bl(h,"class","contains-task-list")},m(t,l){se(document.head,c),s(t,gt,l),s(t,ht,l),s(t,Ct,l),o(j,t,l),s(t,ft,l),o(g,t,l),s(t,It,l),s(t,C,l),s(t,bt,l),o(f,t,l),s(t,dt,l),o(I,t,l),s(t,$t,l),s(t,b,l),s(t,vt,l),s(t,d,l),s(t,Gt,l),s(t,$,l),s(t,kt,l),o(v,t,l),s(t,Bt,l),s(t,G,l),s(t,Zt,l),s(t,k,l),s(t,Wt,l),o(B,t,l),s(t,At,l),o(Z,t,l),s(t,Ft,l),o(W,t,l),s(t,Qt,l),o(A,t,l),s(t,Xt,l),s(t,F,l),s(t,xt,l),s(t,Q,l),s(t,Rt,l),o(X,t,l),s(t,St,l),o(x,t,l),s(t,Yt,l),s(t,R,l),s(t,Vt,l),s(t,S,l),s(t,Et,l),o(Y,t,l),s(t,qt,l),s(t,V,l),s(t,Ht,l),s(t,E,l),s(t,zt,l),o(q,t,l),s(t,_t,l),o(H,t,l),s(t,Nt,l),s(t,z,l),s(t,Lt,l),o(_,t,l),s(t,Pt,l),s(t,N,l),s(t,Dt,l),o(L,t,l),s(t,Ot,l),o(P,t,l),s(t,Kt,l),s(t,D,l),s(t,tl,l),o(O,t,l),s(t,ll,l),s(t,K,l),s(t,el,l),o(tt,t,l),s(t,sl,l),o(lt,t,l),s(t,al,l),s(t,et,l),s(t,nl,l),o(st,t,l),s(t,il,l),s(t,at,l),s(t,Ml,l),o(nt,t,l),s(t,ol,l),o(it,t,l),s(t,pl,l),o(Mt,t,l),s(t,yl,l),s(t,ot,l),s(t,rl,l),o(pt,t,l),s(t,ml,l),o(yt,t,l),s(t,Ul,l),o(rt,t,l),s(t,ul,l),o(mt,t,l),s(t,Tl,l),o(Ut,t,l),s(t,cl,l),s(t,ut,l),s(t,wl,l),s(t,J,l),s(t,Jl,l),o(Tt,t,l),s(t,hl,l),s(t,h,l),s(t,jl,l),o(ct,t,l),s(t,gl,l),s(t,wt,l),s(t,Cl,l),o(Jt,t,l),s(t,fl,l),s(t,jt,l),Il=!0},p:Ol,i(t){Il||(p(j.$$.fragment,t),p(g.$$.fragment,t),p(f.$$.fragment,t),p(I.$$.fragment,t),p(v.$$.fragment,t),p(B.$$.fragment,t),p(Z.$$.fragment,t),p(W.$$.fragment,t),p(A.$$.fragment,t),p(X.$$.fragment,t),p(x.$$.fragment,t),p(Y.$$.fragment,t),p(q.$$.fragment,t),p(H.$$.fragment,t),p(_.$$.fragment,t),p(L.$$.fragment,t),p(P.$$.fragment,t),p(O.$$.fragment,t),p(tt.$$.fragment,t),p(lt.$$.fragment,t),p(st.$$.fragment,t),p(nt.$$.fragment,t),p(it.$$.fragment,t),p(Mt.$$.fragment,t),p(pt.$$.fragment,t),p(yt.$$.fragment,t),p(rt.$$.fragment,t),p(mt.$$.fragment,t),p(Ut.$$.fragment,t),p(Tt.$$.fragment,t),p(ct.$$.fragment,t),p(Jt.$$.fragment,t),Il=!0)},o(t){y(j.$$.fragment,t),y(g.$$.fragment,t),y(f.$$.fragment,t),y(I.$$.fragment,t),y(v.$$.fragment,t),y(B.$$.fragment,t),y(Z.$$.fragment,t),y(W.$$.fragment,t),y(A.$$.fragment,t),y(X.$$.fragment,t),y(x.$$.fragment,t),y(Y.$$.fragment,t),y(q.$$.fragment,t),y(H.$$.fragment,t),y(_.$$.fragment,t),y(L.$$.fragment,t),y(P.$$.fragment,t),y(O.$$.fragment,t),y(tt.$$.fragment,t),y(lt.$$.fragment,t),y(st.$$.fragment,t),y(nt.$$.fragment,t),y(it.$$.fragment,t),y(Mt.$$.fragment,t),y(pt.$$.fragment,t),y(yt.$$.fragment,t),y(rt.$$.fragment,t),y(mt.$$.fragment,t),y(Ut.$$.fragment,t),y(Tt.$$.fragment,t),y(ct.$$.fragment,t),y(Jt.$$.fragment,t),Il=!1},d(t){t&&(e(gt),e(ht),e(Ct),e(ft),e(It),e(C),e(bt),e(dt),e($t),e(b),e(vt),e(d),e(Gt),e($),e(kt),e(Bt),e(G),e(Zt),e(k),e(Wt),e(At),e(Ft),e(Qt),e(Xt),e(F),e(xt),e(Q),e(Rt),e(St),e(Yt),e(R),e(Vt),e(S),e(Et),e(qt),e(V),e(Ht),e(E),e(zt),e(_t),e(Nt),e(z),e(Lt),e(Pt),e(N),e(Dt),e(Ot),e(Kt),e(D),e(tl),e(ll),e(K),e(el),e(sl),e(al),e(et),e(nl),e(il),e(at),e(Ml),e(ol),e(pl),e(yl),e(ot),e(rl),e(ml),e(Ul),e(ul),e(Tl),e(cl),e(ut),e(wl),e(J),e(Jl),e(hl),e(h),e(jl),e(gl),e(wt),e(Cl),e(fl),e(jt)),e(c),r(j,t),r(g,t),r(f,t),r(I,t),r(v,t),r(B,t),r(Z,t),r(W,t),r(A,t),r(X,t),r(x,t),r(Y,t),r(q,t),r(H,t),r(_,t),r(L,t),r(P,t),r(O,t),r(tt,t),r(lt,t),r(st,t),r(nt,t),r(it,t),r(Mt,t),r(pt,t),r(yt,t),r(rt,t),r(mt,t),r(Ut,t),r(Tt,t),r(ct,t),r(Jt,t)}}}const Me='{"title":"Contributing to Multilingual Evaluations","local":"contributing-to-multilingual-evaluations","sections":[{"title":"Contributing Translation Literals","local":"contributing-translation-literals","sections":[{"title":"What Are Translation Literals?","local":"what-are-translation-literals","sections":[],"depth":3},{"title":"How to Contribute Translations","local":"how-to-contribute-translations","sections":[],"depth":3},{"title":"Translation Literals Structure","local":"translation-literals-structure","sections":[],"depth":3}],"depth":2},{"title":"Contributing New Multilingual Tasks","local":"contributing-new-multilingual-tasks","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":3},{"title":"Key Concepts","local":"key-concepts","sections":[{"title":"Language-Adapted Templates","local":"language-adapted-templates","sections":[],"depth":4},{"title":"Template Types","local":"template-types","sections":[],"depth":4},{"title":"Formulation Types","local":"formulation-types","sections":[{"title":"Multiple Choice Formulation (MCF)","local":"multiple-choice-formulation-mcf","sections":[],"depth":5},{"title":"Classification Formulation (CF)","local":"classification-formulation-cf","sections":[],"depth":5},{"title":"Hybrid Formulation","local":"hybrid-formulation","sections":[],"depth":5}],"depth":4}],"depth":3},{"title":"Creating Your Multilingual Task","local":"creating-your-multilingual-task","sections":[{"title":"Step 1: Create the Task File","local":"step-1-create-the-task-file","sections":[],"depth":4},{"title":"Step 2: Import Required Components","local":"step-2-import-required-components","sections":[],"depth":4},{"title":"Step 3: Define Your Tasks","local":"step-3-define-your-tasks","sections":[],"depth":4},{"title":"Step 4: Test Your Implementation","local":"step-4-test-your-implementation","sections":[],"depth":4}],"depth":3},{"title":"Validation Checklist","local":"validation-checklist","sections":[],"depth":3},{"title":"Getting Help","local":"getting-help","sections":[],"depth":3}],"depth":2}],"depth":1}';function oe(dl){return Kl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ue extends te{constructor(c){super(),le(this,c,oe,ie,Dl,{})}}export{Ue as component};
