import{s as vl,o as Wl,n as Vl}from"../chunks/scheduler.7da89386.js";import{S as kl,i as xl,g as r,s as n,r as i,m as Rl,A as El,h as d,f as t,c as a,j as ml,u as p,x as y,n as _l,k as rl,y as dl,a as s,v as o,d as m,t as M,w as c}from"../chunks/index.20910acc.js";import{T as Nl}from"../chunks/Tip.53e22153.js";import{C as w}from"../chunks/CodeBlock.143bd81e.js";import{H as u,E as Al}from"../chunks/getInferenceSnippets.7cf363b6.js";function Ql(ue){let h,U="You can find a complete example of a custom model implementation in <code>examples/custom_models/google_translate_model.py</code>.";return{c(){h=r("p"),h.innerHTML=U},l(T){h=d(T,"P",{"data-svelte-h":!0}),y(h)!=="svelte-1s5ktfo"&&(h.innerHTML=U)},m(T,re){s(T,h,re)},p:Vl,d(T){T&&t(h)}}}function Yl(ue){let h,U,T,re,g,Te,f,yl=`Lighteval allows you to evaluate custom model implementations by creating a custom model class that inherits from <code>LightevalModel</code>.
This is useful when you want to evaluate models that aren’t directly supported by the standard backends and providers (Transformers, VLLM, etc.), or
if you want to add your own pre/post-processing logic.`,we,j,Je,b,Ue,$,hl="Create a Python file containing your custom model implementation. The model must inherit from <code>LightevalModel</code> and implement all required methods.",ge,C,ul="Here’s a basic example:",fe,I,je,G,be,Z,Tl="The custom model file should contain exactly one class that inherits from <code>LightevalModel</code>. This class will be automatically detected and instantiated when loading the model.",$e,J,Ce,B,Ie,v,wl="You can evaluate your custom model using either the command-line interface or the Python API.",Ge,W,Ze,V,Be,k,Jl="The command takes three required arguments:",ve,x,Ul="<li><strong>Model name</strong>: Used for tracking in results/logs</li> <li><strong>Model implementation file path</strong>: Path to your Python file containing the custom model</li> <li><strong>Tasks</strong>: Tasks to evaluate on (same format as other backends)</li>",We,R,Ve,E,ke,_,xe,N,gl="Your custom model must implement these core methods:",Re,A,Ee,Q,fl="For generating text until a stop sequence or max tokens is reached. This is used for generative evaluations.",_e,Y,Ne,S,Ae,X,jl="For computing log probabilities of specific continuations. This is used for multiple choice logprob evaluations.",Qe,z,Ye,F,Se,H,bl="For computing rolling log probabilities of sequences. This is used for perplexity metrics.",Xe,L,ze,q,$l="See the <code>LightevalModel</code> base class documentation for detailed method signatures and requirements.",Fe,P,He,D,Cl=`Lighteval includes a caching system that can significantly speed up evaluations by storing and reusing model predictions.
To enable caching in your custom model:`,Le,K,qe,O,Pe,ee,De,le,Ke,te,de,Ml,se,Oe,ne,Il='For detailed information about the caching system, see the <a href="caching">Caching Documentation</a>.',el,ae,ll,ie,tl,pe,Gl="<li><strong>Import Errors</strong>: Ensure all required dependencies are installed</li> <li><strong>Method Signature Errors</strong>: Verify your methods match the expected signatures</li> <li><strong>Caching Issues</strong>: Check that cache decorators are applied correctly</li> <li><strong>Performance Issues</strong>: Consider implementing batching and caching</li>",sl,oe,nl,me,Zl="<li>Use the <code>--max-samples</code> flag to test with a small dataset</li> <li>Enable detailed logging to see what’s happening</li> <li>Test individual methods in isolation</li> <li>Check the example implementations for reference</li>",al,Me,Bl='For more detailed information about custom model implementation, see the <a href="package_reference/models">Model Reference</a>.',il,ce,pl,ye,ol;return g=new u({props:{title:"Evaluating Custom Models",local:"evaluating-custom-models",headingTag:"h1"}}),j=new u({props:{title:"Creating a Custom Model",local:"creating-a-custom-model",headingTag:"h2"}}),b=new u({props:{title:"Step 1: Create Your Model Implementation",local:"step-1-create-your-model-implementation",headingTag:"h3"}}),I=new w({props:{code:"ZnJvbSUyMGxpZ2h0ZXZhbC5tb2RlbHMuYWJzdHJhY3RfbW9kZWwlMjBpbXBvcnQlMjBMaWdodGV2YWxNb2RlbCUwQWZyb20lMjBsaWdodGV2YWwubW9kZWxzLm1vZGVsX291dHB1dCUyMGltcG9ydCUyME1vZGVsUmVzcG9uc2UlMEFmcm9tJTIwbGlnaHRldmFsLnRhc2tzLnJlcXVlc3RzJTIwaW1wb3J0JTIwRG9jJTJDJTIwU2FtcGxpbmdNZXRob2QlMEFmcm9tJTIwbGlnaHRldmFsLnV0aWxzLmNhY2hlX21hbmFnZW1lbnQlMjBpbXBvcnQlMjBTYW1wbGVDYWNoZSUyQyUyMGNhY2hlZCUwQSUwQWNsYXNzJTIwTXlDdXN0b21Nb2RlbChMaWdodGV2YWxNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEluaXRpYWxpemUlMjB5b3VyJTIwbW9kZWwlMjBoZXJlLi4uJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRW5hYmxlJTIwY2FjaGluZyUyMChyZWNvbW1lbmRlZCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLl9jYWNoZSUyMCUzRCUyMFNhbXBsZUNhY2hlKGNvbmZpZyklMEElMEElMjAlMjAlMjAlMjAlNDBjYWNoZWQoU2FtcGxpbmdNZXRob2QuR0VORVJBVElWRSklMEElMjAlMjAlMjAlMjBkZWYlMjBncmVlZHlfdW50aWwoc2VsZiUyQyUyMGRvY3MlM0ElMjBMaXN0JTVCRG9jJTVEKSUyMC0lM0UlMjBMaXN0JTVCTW9kZWxSZXNwb25zZSU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEltcGxlbWVudCUyMGdlbmVyYXRpb24lMjBsb2dpYyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhc3MlMEElMEElMjAlMjAlMjAlMjAlNDBjYWNoZWQoU2FtcGxpbmdNZXRob2QuTE9HUFJPQlMpJTBBJTIwJTIwJTIwJTIwZGVmJTIwbG9nbGlrZWxpaG9vZChzZWxmJTJDJTIwZG9jcyUzQSUyMExpc3QlNUJEb2MlNUQpJTIwLSUzRSUyMExpc3QlNUJNb2RlbFJlc3BvbnNlJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwSW1wbGVtZW50JTIwbG9nbGlrZWxpaG9vZCUyMGNvbXB1dGF0aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFzcyUwQSUwQSUyMCUyMCUyMCUyMCU0MGNhY2hlZChTYW1wbGluZ01ldGhvZC5QRVJQTEVYSVRZKSUwQSUyMCUyMCUyMCUyMGRlZiUyMGxvZ2xpa2VsaWhvb2Rfcm9sbGluZyhzZWxmJTJDJTIwZG9jcyUzQSUyMExpc3QlNUJEb2MlNUQpJTIwLSUzRSUyMExpc3QlNUJNb2RlbFJlc3BvbnNlJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwSW1wbGVtZW50JTIwcm9sbGluZyUyMGxvZ2xpa2VsaWhvb2QlMjBjb21wdXRhdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhc3M=",highlighted:`<span class="hljs-keyword">from</span> lighteval.models.abstract_model <span class="hljs-keyword">import</span> LightevalModel
<span class="hljs-keyword">from</span> lighteval.models.model_output <span class="hljs-keyword">import</span> ModelResponse
<span class="hljs-keyword">from</span> lighteval.tasks.requests <span class="hljs-keyword">import</span> Doc, SamplingMethod
<span class="hljs-keyword">from</span> lighteval.utils.cache_management <span class="hljs-keyword">import</span> SampleCache, cached

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCustomModel</span>(<span class="hljs-title class_ inherited__">LightevalModel</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        <span class="hljs-comment"># Initialize your model here...</span>

        <span class="hljs-comment"># Enable caching (recommended)</span>
        self._cache = SampleCache(config)

<span class="hljs-meta">    @cached(<span class="hljs-params">SamplingMethod.GENERATIVE</span>)</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">greedy_until</span>(<span class="hljs-params">self, docs: <span class="hljs-type">List</span>[Doc]</span>) -&gt; <span class="hljs-type">List</span>[ModelResponse]:
        <span class="hljs-comment"># Implement generation logic</span>
        <span class="hljs-keyword">pass</span>

<span class="hljs-meta">    @cached(<span class="hljs-params">SamplingMethod.LOGPROBS</span>)</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">loglikelihood</span>(<span class="hljs-params">self, docs: <span class="hljs-type">List</span>[Doc]</span>) -&gt; <span class="hljs-type">List</span>[ModelResponse]:
        <span class="hljs-comment"># Implement loglikelihood computation</span>
        <span class="hljs-keyword">pass</span>

<span class="hljs-meta">    @cached(<span class="hljs-params">SamplingMethod.PERPLEXITY</span>)</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">loglikelihood_rolling</span>(<span class="hljs-params">self, docs: <span class="hljs-type">List</span>[Doc]</span>) -&gt; <span class="hljs-type">List</span>[ModelResponse]:
        <span class="hljs-comment"># Implement rolling loglikelihood computation</span>
        <span class="hljs-keyword">pass</span>`,wrap:!1}}),G=new u({props:{title:"Step 2: Model File Requirements",local:"step-2-model-file-requirements",headingTag:"h3"}}),J=new Nl({props:{warning:!1,$$slots:{default:[Ql]},$$scope:{ctx:ue}}}),B=new u({props:{title:"Running the Evaluation",local:"running-the-evaluation",headingTag:"h2"}}),W=new u({props:{title:"Using the Command Line",local:"using-the-command-line",headingTag:"h3"}}),V=new w({props:{code:"bGlnaHRldmFsJTIwY3VzdG9tJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlLXRyYW5zbGF0ZSUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMCUyMmV4YW1wbGVzJTJGY3VzdG9tX21vZGVscyUyRmdvb2dsZV90cmFuc2xhdGVfbW9kZWwucHklMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAlMjJsaWdodGV2YWwlN0N3bXQyMCUzQWZyLWRlJTdDMCUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWF4LXNhbXBsZXMlMjAxMA==",highlighted:`lighteval custom \\
    <span class="hljs-string">&quot;google-translate&quot;</span> \\
    <span class="hljs-string">&quot;examples/custom_models/google_translate_model.py&quot;</span> \\
    <span class="hljs-string">&quot;lighteval|wmt20:fr-de|0&quot;</span> \\
    --max-samples 10`,wrap:!1}}),R=new u({props:{title:"Using the Python API",local:"using-the-python-api",headingTag:"h3"}}),E=new w({props:{code:"ZnJvbSUyMGxpZ2h0ZXZhbC5sb2dnaW5nLmV2YWx1YXRpb25fdHJhY2tlciUyMGltcG9ydCUyMEV2YWx1YXRpb25UcmFja2VyJTBBZnJvbSUyMGxpZ2h0ZXZhbC5tb2RlbHMuY3VzdG9tLmN1c3RvbV9tb2RlbCUyMGltcG9ydCUyMEN1c3RvbU1vZGVsQ29uZmlnJTBBZnJvbSUyMGxpZ2h0ZXZhbC5waXBlbGluZSUyMGltcG9ydCUyMFBpcGVsaW5lJTJDJTIwUGlwZWxpbmVQYXJhbWV0ZXJzJTJDJTIwUGFyYWxsZWxpc21NYW5hZ2VyJTBBJTBBJTIzJTIwU2V0JTIwdXAlMjBldmFsdWF0aW9uJTIwdHJhY2tpbmclMEFldmFsdWF0aW9uX3RyYWNrZXIlMjAlM0QlMjBFdmFsdWF0aW9uVHJhY2tlciglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEJTIycmVzdWx0cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfZGV0YWlscyUzRFRydWUlMEEpJTBBJTBBJTIzJTIwQ29uZmlndXJlJTIwdGhlJTIwcGlwZWxpbmUlMEFwaXBlbGluZV9wYXJhbXMlMjAlM0QlMjBQaXBlbGluZVBhcmFtZXRlcnMoJTBBJTIwJTIwJTIwJTIwbGF1bmNoZXJfdHlwZSUzRFBhcmFsbGVsaXNtTWFuYWdlci5DVVNUT00lMkMlMEEpJTBBJTBBJTIzJTIwQ29uZmlndXJlJTIweW91ciUyMGN1c3RvbSUyMG1vZGVsJTBBbW9kZWxfY29uZmlnJTIwJTNEJTIwQ3VzdG9tTW9kZWxDb25maWcoJTBBJTIwJTIwJTIwJTIwbW9kZWxfbmFtZSUzRCUyMm15LWN1c3RvbS1tb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2RlZmluaXRpb25fZmlsZV9wYXRoJTNEJTIycGF0aCUyRnRvJTJGbXlfbW9kZWwucHklMjIlMEEpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwYW5kJTIwcnVuJTIwdGhlJTIwcGlwZWxpbmUlMEFwaXBlbGluZSUyMCUzRCUyMFBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHRhc2tzJTNEJTIybGVhZGVyYm9hcmQlN0N0cnV0aGZ1bHFhJTNBbWMlN0MwJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmVfcGFyYW1ldGVycyUzRHBpcGVsaW5lX3BhcmFtcyUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fdHJhY2tlciUzRGV2YWx1YXRpb25fdHJhY2tlciUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2NvbmZpZyUzRG1vZGVsX2NvbmZpZyUwQSklMEElMEFwaXBlbGluZS5ldmFsdWF0ZSgpJTBBcGlwZWxpbmUuc2F2ZV9hbmRfcHVzaF9yZXN1bHRzKCk=",highlighted:`<span class="hljs-keyword">from</span> lighteval.logging.evaluation_tracker <span class="hljs-keyword">import</span> EvaluationTracker
<span class="hljs-keyword">from</span> lighteval.models.custom.custom_model <span class="hljs-keyword">import</span> CustomModelConfig
<span class="hljs-keyword">from</span> lighteval.pipeline <span class="hljs-keyword">import</span> Pipeline, PipelineParameters, ParallelismManager

<span class="hljs-comment"># Set up evaluation tracking</span>
evaluation_tracker = EvaluationTracker(
    output_dir=<span class="hljs-string">&quot;results&quot;</span>,
    save_details=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># Configure the pipeline</span>
pipeline_params = PipelineParameters(
    launcher_type=ParallelismManager.CUSTOM,
)

<span class="hljs-comment"># Configure your custom model</span>
model_config = CustomModelConfig(
    model_name=<span class="hljs-string">&quot;my-custom-model&quot;</span>,
    model_definition_file_path=<span class="hljs-string">&quot;path/to/my_model.py&quot;</span>
)

<span class="hljs-comment"># Create and run the pipeline</span>
pipeline = Pipeline(
    tasks=<span class="hljs-string">&quot;leaderboard|truthfulqa:mc|0&quot;</span>,
    pipeline_parameters=pipeline_params,
    evaluation_tracker=evaluation_tracker,
    model_config=model_config
)

pipeline.evaluate()
pipeline.save_and_push_results()`,wrap:!1}}),_=new u({props:{title:"Required Methods",local:"required-methods",headingTag:"h2"}}),A=new u({props:{title:"greedy_until",local:"greedyuntil",headingTag:"h3"}}),Y=new w({props:{code:"ZGVmJTIwZ3JlZWR5X3VudGlsKHNlbGYlMkMlMjBkb2NzJTNBJTIwbGlzdCU1QkRvYyU1RCklMjAtJTNFJTIwbGlzdCU1Qk1vZGVsUmVzcG9uc2UlNUQlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBHZW5lcmF0ZSUyMHRleHQlMjB1bnRpbCUyMHN0b3AlMjBzZXF1ZW5jZSUyMG9yJTIwbWF4JTIwdG9rZW5zLiUwQSUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkb2NzJTNBJTIwbGlzdCUyMG9mJTIwZG9jdW1lbnRzJTIwY29udGFpbmluZyUyMHByb21wdHMlMjBhbmQlMjBnZW5lcmF0aW9uJTIwcGFyYW1ldGVycyUwQSUwQSUyMCUyMCUyMCUyMFJldHVybnMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsaXN0JTIwb2YlMjBtb2RlbCUyMHJlc3BvbnNlcyUyMHdpdGglMjBnZW5lcmF0ZWQlMjB0ZXh0JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcGFzcw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">greedy_until</span>(<span class="hljs-params">self, docs: <span class="hljs-built_in">list</span>[Doc]</span>) -&gt; <span class="hljs-built_in">list</span>[ModelResponse]:
    <span class="hljs-string">&quot;&quot;&quot;
    Generate text until stop sequence or max tokens.

    Args:
        docs: list of documents containing prompts and generation parameters

    Returns:
        list of model responses with generated text
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),S=new u({props:{title:"loglikelihood",local:"loglikelihood",headingTag:"h3"}}),z=new w({props:{code:"ZGVmJTIwbG9nbGlrZWxpaG9vZChzZWxmJTJDJTIwZG9jcyUzQSUyMGxpc3QlNUJEb2MlNUQpJTIwLSUzRSUyMGxpc3QlNUJNb2RlbFJlc3BvbnNlJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwQ29tcHV0ZSUyMGxvZyUyMHByb2JhYmlsaXRpZXMlMjBvZiUyMGNvbnRpbnVhdGlvbnMuJTBBJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRvY3MlM0ElMjBsaXN0JTIwb2YlMjBkb2N1bWVudHMlMjBjb250YWluaW5nJTIwY29udGV4dCUyMGFuZCUyMGNvbnRpbnVhdGlvbiUyMHBhaXJzJTBBJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxpc3QlMjBvZiUyMG1vZGVsJTIwcmVzcG9uc2VzJTIwd2l0aCUyMGxvZyUyMHByb2JhYmlsaXRpZXMlMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">loglikelihood</span>(<span class="hljs-params">self, docs: <span class="hljs-built_in">list</span>[Doc]</span>) -&gt; <span class="hljs-built_in">list</span>[ModelResponse]:
    <span class="hljs-string">&quot;&quot;&quot;
    Compute log probabilities of continuations.

    Args:
        docs: list of documents containing context and continuation pairs

    Returns:
        list of model responses with log probabilities
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),F=new u({props:{title:"loglikelihood_rolling",local:"loglikelihoodrolling",headingTag:"h3"}}),L=new w({props:{code:"ZGVmJTIwbG9nbGlrZWxpaG9vZF9yb2xsaW5nKHNlbGYlMkMlMjBkb2NzJTNBJTIwbGlzdCU1QkRvYyU1RCklMjAtJTNFJTIwbGlzdCU1Qk1vZGVsUmVzcG9uc2UlNUQlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBDb21wdXRlJTIwcm9sbGluZyUyMGxvZyUyMHByb2JhYmlsaXRpZXMlMjBvZiUyMHNlcXVlbmNlcy4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9jcyUzQSUyMGxpc3QlMjBvZiUyMGRvY3VtZW50cyUyMGNvbnRhaW5pbmclMjB0ZXh0JTIwc2VxdWVuY2VzJTBBJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxpc3QlMjBvZiUyMG1vZGVsJTIwcmVzcG9uc2VzJTIwd2l0aCUyMHJvbGxpbmclMjBsb2clMjBwcm9iYWJpbGl0aWVzJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcGFzcw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">loglikelihood_rolling</span>(<span class="hljs-params">self, docs: <span class="hljs-built_in">list</span>[Doc]</span>) -&gt; <span class="hljs-built_in">list</span>[ModelResponse]:
    <span class="hljs-string">&quot;&quot;&quot;
    Compute rolling log probabilities of sequences.

    Args:
        docs: list of documents containing text sequences

    Returns:
        list of model responses with rolling log probabilities
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),P=new u({props:{title:"Enabling Caching (Recommended)",local:"enabling-caching-recommended",headingTag:"h2"}}),K=new u({props:{title:"Step 1: Import Caching Components",local:"step-1-import-caching-components",headingTag:"h3"}}),O=new w({props:{code:"ZnJvbSUyMGxpZ2h0ZXZhbC51dGlscy5jYWNoZV9tYW5hZ2VtZW50JTIwaW1wb3J0JTIwU2FtcGxlQ2FjaGUlMkMlMjBjYWNoZWQ=",highlighted:'<span class="hljs-keyword">from</span> lighteval.utils.cache_management <span class="hljs-keyword">import</span> SampleCache, cached',wrap:!1}}),ee=new u({props:{title:"Step 2: Initialize Cache in Constructor",local:"step-2-initialize-cache-in-constructor",headingTag:"h3"}}),le=new w({props:{code:"ZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjMlMjBZb3VyJTIwaW5pdGlhbGl6YXRpb24lMjBjb2RlLi4uJTBBJTIwJTIwJTIwJTIwc2VsZi5fY2FjaGUlMjAlM0QlMjBTYW1wbGVDYWNoZShjb25maWcp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
    <span class="hljs-built_in">super</span>().__init__(config)
    <span class="hljs-comment"># Your initialization code...</span>
    self._cache = SampleCache(config)`,wrap:!1}}),se=new w({props:{code:"JTQwY2FjaGVkKFNhbXBsaW5nTWV0aG9kLkdFTkVSQVRJVkUpJTBBZGVmJTIwZ3JlZWR5X3VudGlsKHNlbGYlMkMlMjBkb2NzJTNBJTIwTGlzdCU1QkRvYyU1RCklMjAtJTNFJTIwTGlzdCU1Qk1vZGVsUmVzcG9uc2UlNUQlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBZb3VyJTIwaW1wbGVtZW50YXRpb24uLi4=",highlighted:`<span class="hljs-meta">@cached(<span class="hljs-params">SamplingMethod.GENERATIVE</span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">greedy_until</span>(<span class="hljs-params">self, docs: <span class="hljs-type">List</span>[Doc]</span>) -&gt; <span class="hljs-type">List</span>[ModelResponse]:
    <span class="hljs-comment"># Your implementation...</span>`,wrap:!1}}),ae=new u({props:{title:"Troubleshooting",local:"troubleshooting",headingTag:"h2"}}),ie=new u({props:{title:"Common Issues",local:"common-issues",headingTag:"h3"}}),oe=new u({props:{title:"Debugging Tips",local:"debugging-tips",headingTag:"h3"}}),ce=new Al({props:{source:"https://github.com/huggingface/lighteval/blob/main/docs/source/evaluating-a-custom-model.mdx"}}),{c(){h=r("meta"),U=n(),T=r("p"),re=n(),i(g.$$.fragment),Te=n(),f=r("p"),f.innerHTML=yl,we=n(),i(j.$$.fragment),Je=n(),i(b.$$.fragment),Ue=n(),$=r("p"),$.innerHTML=hl,ge=n(),C=r("p"),C.textContent=ul,fe=n(),i(I.$$.fragment),je=n(),i(G.$$.fragment),be=n(),Z=r("p"),Z.innerHTML=Tl,$e=n(),i(J.$$.fragment),Ce=n(),i(B.$$.fragment),Ie=n(),v=r("p"),v.textContent=wl,Ge=n(),i(W.$$.fragment),Ze=n(),i(V.$$.fragment),Be=n(),k=r("p"),k.textContent=Jl,ve=n(),x=r("ul"),x.innerHTML=Ul,We=n(),i(R.$$.fragment),Ve=n(),i(E.$$.fragment),ke=n(),i(_.$$.fragment),xe=n(),N=r("p"),N.textContent=gl,Re=n(),i(A.$$.fragment),Ee=n(),Q=r("p"),Q.textContent=fl,_e=n(),i(Y.$$.fragment),Ne=n(),i(S.$$.fragment),Ae=n(),X=r("p"),X.textContent=jl,Qe=n(),i(z.$$.fragment),Ye=n(),i(F.$$.fragment),Se=n(),H=r("p"),H.textContent=bl,Xe=n(),i(L.$$.fragment),ze=n(),q=r("p"),q.innerHTML=$l,Fe=n(),i(P.$$.fragment),He=n(),D=r("p"),D.textContent=Cl,Le=n(),i(K.$$.fragment),qe=n(),i(O.$$.fragment),Pe=n(),i(ee.$$.fragment),De=n(),i(le.$$.fragment),Ke=n(),te=r("ol"),de=r("li"),Ml=Rl(`Add cache decorators to your prediction methods:
	`),i(se.$$.fragment),Oe=n(),ne=r("p"),ne.innerHTML=Il,el=n(),i(ae.$$.fragment),ll=n(),i(ie.$$.fragment),tl=n(),pe=r("ol"),pe.innerHTML=Gl,sl=n(),i(oe.$$.fragment),nl=n(),me=r("ul"),me.innerHTML=Zl,al=n(),Me=r("p"),Me.innerHTML=Bl,il=n(),i(ce.$$.fragment),pl=n(),ye=r("p"),this.h()},l(e){const l=El("svelte-u9bgzb",document.head);h=d(l,"META",{name:!0,content:!0}),l.forEach(t),U=a(e),T=d(e,"P",{}),ml(T).forEach(t),re=a(e),p(g.$$.fragment,e),Te=a(e),f=d(e,"P",{"data-svelte-h":!0}),y(f)!=="svelte-15yahec"&&(f.innerHTML=yl),we=a(e),p(j.$$.fragment,e),Je=a(e),p(b.$$.fragment,e),Ue=a(e),$=d(e,"P",{"data-svelte-h":!0}),y($)!=="svelte-64btiy"&&($.innerHTML=hl),ge=a(e),C=d(e,"P",{"data-svelte-h":!0}),y(C)!=="svelte-1frc3d"&&(C.textContent=ul),fe=a(e),p(I.$$.fragment,e),je=a(e),p(G.$$.fragment,e),be=a(e),Z=d(e,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-4gi028"&&(Z.innerHTML=Tl),$e=a(e),p(J.$$.fragment,e),Ce=a(e),p(B.$$.fragment,e),Ie=a(e),v=d(e,"P",{"data-svelte-h":!0}),y(v)!=="svelte-md1ogy"&&(v.textContent=wl),Ge=a(e),p(W.$$.fragment,e),Ze=a(e),p(V.$$.fragment,e),Be=a(e),k=d(e,"P",{"data-svelte-h":!0}),y(k)!=="svelte-9ha93v"&&(k.textContent=Jl),ve=a(e),x=d(e,"UL",{"data-svelte-h":!0}),y(x)!=="svelte-7oyst4"&&(x.innerHTML=Ul),We=a(e),p(R.$$.fragment,e),Ve=a(e),p(E.$$.fragment,e),ke=a(e),p(_.$$.fragment,e),xe=a(e),N=d(e,"P",{"data-svelte-h":!0}),y(N)!=="svelte-abp4ax"&&(N.textContent=gl),Re=a(e),p(A.$$.fragment,e),Ee=a(e),Q=d(e,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-1nk29lo"&&(Q.textContent=fl),_e=a(e),p(Y.$$.fragment,e),Ne=a(e),p(S.$$.fragment,e),Ae=a(e),X=d(e,"P",{"data-svelte-h":!0}),y(X)!=="svelte-1bufz8k"&&(X.textContent=jl),Qe=a(e),p(z.$$.fragment,e),Ye=a(e),p(F.$$.fragment,e),Se=a(e),H=d(e,"P",{"data-svelte-h":!0}),y(H)!=="svelte-dqj7yp"&&(H.textContent=bl),Xe=a(e),p(L.$$.fragment,e),ze=a(e),q=d(e,"P",{"data-svelte-h":!0}),y(q)!=="svelte-845vib"&&(q.innerHTML=$l),Fe=a(e),p(P.$$.fragment,e),He=a(e),D=d(e,"P",{"data-svelte-h":!0}),y(D)!=="svelte-1eshig5"&&(D.textContent=Cl),Le=a(e),p(K.$$.fragment,e),qe=a(e),p(O.$$.fragment,e),Pe=a(e),p(ee.$$.fragment,e),De=a(e),p(le.$$.fragment,e),Ke=a(e),te=d(e,"OL",{start:!0});var he=ml(te);de=d(he,"LI",{});var cl=ml(de);Ml=_l(cl,`Add cache decorators to your prediction methods:
	`),p(se.$$.fragment,cl),cl.forEach(t),he.forEach(t),Oe=a(e),ne=d(e,"P",{"data-svelte-h":!0}),y(ne)!=="svelte-eqax9m"&&(ne.innerHTML=Il),el=a(e),p(ae.$$.fragment,e),ll=a(e),p(ie.$$.fragment,e),tl=a(e),pe=d(e,"OL",{"data-svelte-h":!0}),y(pe)!=="svelte-hifd4u"&&(pe.innerHTML=Gl),sl=a(e),p(oe.$$.fragment,e),nl=a(e),me=d(e,"UL",{"data-svelte-h":!0}),y(me)!=="svelte-1g8hpki"&&(me.innerHTML=Zl),al=a(e),Me=d(e,"P",{"data-svelte-h":!0}),y(Me)!=="svelte-15nhhnt"&&(Me.innerHTML=Bl),il=a(e),p(ce.$$.fragment,e),pl=a(e),ye=d(e,"P",{}),ml(ye).forEach(t),this.h()},h(){rl(h,"name","hf:doc:metadata"),rl(h,"content",Sl),rl(te,"start","3")},m(e,l){dl(document.head,h),s(e,U,l),s(e,T,l),s(e,re,l),o(g,e,l),s(e,Te,l),s(e,f,l),s(e,we,l),o(j,e,l),s(e,Je,l),o(b,e,l),s(e,Ue,l),s(e,$,l),s(e,ge,l),s(e,C,l),s(e,fe,l),o(I,e,l),s(e,je,l),o(G,e,l),s(e,be,l),s(e,Z,l),s(e,$e,l),o(J,e,l),s(e,Ce,l),o(B,e,l),s(e,Ie,l),s(e,v,l),s(e,Ge,l),o(W,e,l),s(e,Ze,l),o(V,e,l),s(e,Be,l),s(e,k,l),s(e,ve,l),s(e,x,l),s(e,We,l),o(R,e,l),s(e,Ve,l),o(E,e,l),s(e,ke,l),o(_,e,l),s(e,xe,l),s(e,N,l),s(e,Re,l),o(A,e,l),s(e,Ee,l),s(e,Q,l),s(e,_e,l),o(Y,e,l),s(e,Ne,l),o(S,e,l),s(e,Ae,l),s(e,X,l),s(e,Qe,l),o(z,e,l),s(e,Ye,l),o(F,e,l),s(e,Se,l),s(e,H,l),s(e,Xe,l),o(L,e,l),s(e,ze,l),s(e,q,l),s(e,Fe,l),o(P,e,l),s(e,He,l),s(e,D,l),s(e,Le,l),o(K,e,l),s(e,qe,l),o(O,e,l),s(e,Pe,l),o(ee,e,l),s(e,De,l),o(le,e,l),s(e,Ke,l),s(e,te,l),dl(te,de),dl(de,Ml),o(se,de,null),s(e,Oe,l),s(e,ne,l),s(e,el,l),o(ae,e,l),s(e,ll,l),o(ie,e,l),s(e,tl,l),s(e,pe,l),s(e,sl,l),o(oe,e,l),s(e,nl,l),s(e,me,l),s(e,al,l),s(e,Me,l),s(e,il,l),o(ce,e,l),s(e,pl,l),s(e,ye,l),ol=!0},p(e,[l]){const he={};l&2&&(he.$$scope={dirty:l,ctx:e}),J.$set(he)},i(e){ol||(m(g.$$.fragment,e),m(j.$$.fragment,e),m(b.$$.fragment,e),m(I.$$.fragment,e),m(G.$$.fragment,e),m(J.$$.fragment,e),m(B.$$.fragment,e),m(W.$$.fragment,e),m(V.$$.fragment,e),m(R.$$.fragment,e),m(E.$$.fragment,e),m(_.$$.fragment,e),m(A.$$.fragment,e),m(Y.$$.fragment,e),m(S.$$.fragment,e),m(z.$$.fragment,e),m(F.$$.fragment,e),m(L.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(se.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(oe.$$.fragment,e),m(ce.$$.fragment,e),ol=!0)},o(e){M(g.$$.fragment,e),M(j.$$.fragment,e),M(b.$$.fragment,e),M(I.$$.fragment,e),M(G.$$.fragment,e),M(J.$$.fragment,e),M(B.$$.fragment,e),M(W.$$.fragment,e),M(V.$$.fragment,e),M(R.$$.fragment,e),M(E.$$.fragment,e),M(_.$$.fragment,e),M(A.$$.fragment,e),M(Y.$$.fragment,e),M(S.$$.fragment,e),M(z.$$.fragment,e),M(F.$$.fragment,e),M(L.$$.fragment,e),M(P.$$.fragment,e),M(K.$$.fragment,e),M(O.$$.fragment,e),M(ee.$$.fragment,e),M(le.$$.fragment,e),M(se.$$.fragment,e),M(ae.$$.fragment,e),M(ie.$$.fragment,e),M(oe.$$.fragment,e),M(ce.$$.fragment,e),ol=!1},d(e){e&&(t(U),t(T),t(re),t(Te),t(f),t(we),t(Je),t(Ue),t($),t(ge),t(C),t(fe),t(je),t(be),t(Z),t($e),t(Ce),t(Ie),t(v),t(Ge),t(Ze),t(Be),t(k),t(ve),t(x),t(We),t(Ve),t(ke),t(xe),t(N),t(Re),t(Ee),t(Q),t(_e),t(Ne),t(Ae),t(X),t(Qe),t(Ye),t(Se),t(H),t(Xe),t(ze),t(q),t(Fe),t(He),t(D),t(Le),t(qe),t(Pe),t(De),t(Ke),t(te),t(Oe),t(ne),t(el),t(ll),t(tl),t(pe),t(sl),t(nl),t(me),t(al),t(Me),t(il),t(pl),t(ye)),t(h),c(g,e),c(j,e),c(b,e),c(I,e),c(G,e),c(J,e),c(B,e),c(W,e),c(V,e),c(R,e),c(E,e),c(_,e),c(A,e),c(Y,e),c(S,e),c(z,e),c(F,e),c(L,e),c(P,e),c(K,e),c(O,e),c(ee,e),c(le,e),c(se),c(ae,e),c(ie,e),c(oe,e),c(ce,e)}}}const Sl='{"title":"Evaluating Custom Models","local":"evaluating-custom-models","sections":[{"title":"Creating a Custom Model","local":"creating-a-custom-model","sections":[{"title":"Step 1: Create Your Model Implementation","local":"step-1-create-your-model-implementation","sections":[],"depth":3},{"title":"Step 2: Model File Requirements","local":"step-2-model-file-requirements","sections":[],"depth":3}],"depth":2},{"title":"Running the Evaluation","local":"running-the-evaluation","sections":[{"title":"Using the Command Line","local":"using-the-command-line","sections":[],"depth":3},{"title":"Using the Python API","local":"using-the-python-api","sections":[],"depth":3}],"depth":2},{"title":"Required Methods","local":"required-methods","sections":[{"title":"greedy_until","local":"greedyuntil","sections":[],"depth":3},{"title":"loglikelihood","local":"loglikelihood","sections":[],"depth":3},{"title":"loglikelihood_rolling","local":"loglikelihoodrolling","sections":[],"depth":3}],"depth":2},{"title":"Enabling Caching (Recommended)","local":"enabling-caching-recommended","sections":[{"title":"Step 1: Import Caching Components","local":"step-1-import-caching-components","sections":[],"depth":3},{"title":"Step 2: Initialize Cache in Constructor","local":"step-2-initialize-cache-in-constructor","sections":[],"depth":3}],"depth":2},{"title":"Troubleshooting","local":"troubleshooting","sections":[{"title":"Common Issues","local":"common-issues","sections":[],"depth":3},{"title":"Debugging Tips","local":"debugging-tips","sections":[],"depth":3}],"depth":2}],"depth":1}';function Xl(ue){return Wl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pl extends kl{constructor(h){super(),xl(this,h,Xl,Yl,vl,{})}}export{Pl as component};
