import{s as Ae,n as be,o as fe}from"../chunks/scheduler.008aaf19.js";import{S as Be,i as Ze,e as M,s as n,c as p,h as ke,a as i,d as s,b as a,f as ge,g as J,j as o,k as Vt,l as ve,m as e,n as T,t as y,o as w,p as j}from"../chunks/index.7c7f75b2.js";import{C as I}from"../chunks/CodeBlock.027569b9.js";import{H as c,E as xe}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.4f0ca956.js";function Ge(ds){let U,St,Ht,zt,m,Pt,g,ms="Now that we have our MCP server with tagging tools, we need to create a client that can interact with these tools. The MCP client serves as the bridge between our webhook handler and the MCP server, enabling our agent to use the Hub tagging functionality.",Lt,A,gs="For the sake of this project, we’ll build both an API and a Gradio app. The API will be used to test the MCP server and the webhook listener, and the Gradio app will be used to test the MCP client with simulated webhook events.",Kt,r,As="<p>For educational purposes, we will build the MCP Server and MCP Client in the same repo. In a real-world application, you would likely have a separate repo for the MCP Server and MCP Client. In fact, you might only build one of these components.</p>",Ot,b,Dt,f,bs="In our application, the MCP client is integrated into the main FastAPI application (<code>app.py</code>). It creates and manages connections to our MCP server, providing a seamless interface for tool execution.",tl,B,fs='<img src="https://huggingface.co/datasets/mcp-course/images/resolve/main/unit3/app.png" alt="MCP Client Integration"/>',ll,Z,sl,k,Bs="We use the <code>huggingface_hub</code> Agent class that has built-in MCP support. This provides both language model capabilities and MCP tool integration in a single component.",el,v,nl,x,Zs="Let’s start by setting up the agent configuration and understanding each component:",al,G,Ml,q,ks="We start with the necessary imports and configuration. The global <code>agent_instance</code> variable ensures we create the agent only once and reuse it across multiple requests. This is important for performance since agent initialization can be expensive.",il,E,vs="Now let’s implement the function that creates and manages our agent:",ol,W,pl,_,xs="The function starts by checking if we already have an agent instance. This singleton pattern prevents unnecessary recreations and ensures consistent state.",Jl,N,Gs="Let’s continue with the agent creation:",Tl,R,yl,Q,qs="This is where the important part happens! Let’s break down the Agent configuration:",wl,X,Es="<strong>Agent Parameters:</strong>",jl,$,Ws="<li><code>model</code>: The language model that will reason about tool usage</li> <li><code>provider</code>: How to access the model (Hugging Face Inference Providers)</li> <li><code>api_key</code>: Hugging Face API key</li>",cl,Y,_s="<strong>MCP Server Connection:</strong>",Ul,V,Ns="<li><code>type: &quot;stdio&quot;</code>: Connect to the MCP server via standard input/output</li> <li><code>command: &quot;python&quot;</code>: Run our MCP server as a Python subprocess</li> <li><code>args: [&quot;mcp_server.py&quot;]</code>: The script file to execute</li> <li><code>env</code>: Pass the HF_TOKEN to the server process</li>",Il,u,Rs="<p>The <code>stdio</code> connection type means the agent starts your MCP server as a subprocess and communicates with it through standard input/output. This is perfect for development and single-machine deployments.</p>",rl,H,Qs="The <code>load_tools()</code> call is crucial - it discovers what tools are available from the MCP server and makes them accessible to the agent’s reasoning engine.",ul,F,Xs="This completes our agent management function with proper error handling and logging.",Cl,S,hl,z,$s="Once the agent is created and tools are loaded, it can automatically discover and use the MCP tools. This is where the real power of the Agent approach shines.",dl,P,ml,L,Ys="The agent discovers our MCP tools automatically:",gl,K,Vs="<li><code>get_current_tags(repo_id: str)</code> - Retrieve existing repository tags</li> <li><code>add_new_tag(repo_id: str, new_tag: str)</code> - Add new tag via pull request</li>",Al,O,Hs="The agent doesn’t just call these tools blindly - it reasons about when and how to use them based on the prompt you give it.",bl,D,fl,tt,Fs="Here’s how the agent intelligently uses tools:",Bl,lt,Zl,st,Ss="Notice how we give the agent a natural language instruction, and it figures out:",kl,et,zs="<li>First call <code>get_current_tags</code> to see what tags exist</li> <li>Check if <code>conversational-ai</code> is already there</li> <li>If not, call <code>add_new_tag</code> to add it</li> <li>Provide a summary of what it did</li>",vl,nt,Ps="This is much more intelligent than calling tools directly!",xl,at,Gl,Mt,Ls="Now let’s see how the MCP client integrates into our webhook processing pipeline. This is where everything comes together.",ql,it,El,ot,Ks="Here’s the main function that processes webhook events and uses our MCP agent:",Wl,pt,_l,Jt,Os="This first part extracts and combines tags from both the comment content and discussion title. We use a set to deduplicate any tags that appear in both places.",Nl,C,Ds="<p>Processing both the comment and discussion title increases our chances of catching relevant tags. Users might mention tags in the title like “Missing pytorch tag” or in comments like “This needs #transformers”.</p>",Rl,Tt,te="Next, we get our agent and process each tag:",Ql,yt,Xl,wt,le="The key insight here is that we give the agent a clear, structured prompt for each tag. The agent then:",$l,jt,se="<li>Understands it needs to check the current tags first</li> <li>Compares with the new tag we want to add</li> <li>Creates a pull request if needed</li> <li>Returns a summary of its actions</li>",Yl,ct,ee="This approach handles the complexity of tool orchestration automatically.",Vl,Ut,Hl,It,ne="Let’s examine the tag extraction logic that feeds into our MCP processing:",Fl,rt,Sl,ut,ae="This curated list of recognized tags helps us focus on relevant ML/AI tags and avoid adding inappropriate tags to repositories.",zl,Ct,Me="Now the extraction function itself:",Pl,ht,Ll,dt,ie="This function uses multiple strategies to extract tags:",Kl,mt,oe="<li><strong>Explicit patterns</strong>: “tags: pytorch, transformers” or “tag: nlp”</li> <li><strong>Hashtags</strong>: “#pytorch #nlp”</li> <li><strong>Natural mentions</strong>: “This transformers model does text-generation”</li>",Ol,gt,pe="The validation step ensures we only suggest appropriate tags, preventing spam or irrelevant tags from being added.",Dl,At,ts,bt,Je="When building production MCP clients, performance is critical for maintaining responsive webhook processing. Let’s look at some of the considerations we’ve made.",ls,ft,ss,Bt,Te="The agent is created once and reused to avoid:",es,Zt,ye="<li>Repeated MCP server startup overhead</li> <li>Tool loading delays</li> <li>Connection establishment costs</li>",ns,kt,we="This pattern is essential for webhook handlers that need to respond quickly.",as,vt,Ms,xt,je="All MCP operations are async to:",is,Gt,ce="<li>Handle multiple webhook requests concurrently</li> <li>Avoid blocking the main FastAPI thread</li> <li>Provide responsive webhook responses</li>",os,qt,Ue="The async nature allows your webhook handler to accept new requests while processing tags in the background.",ps,Et,Js,Wt,Ie="FastAPI has a built in <code>BackgroundTasks</code> class that can be used to run tasks in the background. This is useful for running long running tasks without blocking the main thread.",Ts,_t,ys,Nt,re="This pattern ensures webhook responses are fast (under 1 second) while allowing complex tag processing to happen in the background.",ws,h,ue="<p>Webhook endpoints should respond within 10 seconds or the platform may consider them timed out. Using background tasks ensures you can always respond quickly while handling complex processing asynchronously.</p>",js,Rt,cs,Qt,Ce="With our MCP client implemented, we can now:",Us,Xt,he="<li><strong>Implement the Webhook Listener</strong> - Create the FastAPI endpoint that receives Hub events</li> <li><strong>Integrate Everything</strong> - Connect webhooks, client, and server into a complete system</li> <li><strong>Add Testing Interface</strong> - Create a Gradio interface for development and monitoring</li> <li><strong>Deploy and Test</strong> - Validate the complete system in production</li>",Is,$t,de="In the next section, we’ll implement the webhook listener that will trigger our MCP-powered tagging agent.",rs,d,me="<p>The Agent class from <code>huggingface_hub</code> provides both MCP tool integration and language model reasoning, making it perfect for building intelligent automation workflows like our PR agent.</p>",us,Yt,Cs,Ft,hs;return m=new c({props:{title:"MCP Client",local:"mcp-client",headingTag:"h1"}}),b=new c({props:{title:"Understanding the MCP Client Architecture",local:"understanding-the-mcp-client-architecture",headingTag:"h2"}}),Z=new c({props:{title:"Agent-Based MCP Client",local:"agent-based-mcp-client",headingTag:"h2"}}),v=new c({props:{title:"1. Agent Configuration",local:"1-agent-configuration",headingTag:"h3"}}),G=new I({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi5pbmZlcmVuY2UuX21jcC5hZ2VudCUyMGltcG9ydCUyMEFnZW50JTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyME9wdGlvbmFsJTJDJTIwTGl0ZXJhbCUwQSUwQSUyMyUyMENvbmZpZ3VyYXRpb24lMEFIRl9UT0tFTiUyMCUzRCUyMG9zLmdldGVudiglMjJIRl9UT0tFTiUyMiklMEFIRl9NT0RFTCUyMCUzRCUyMG9zLmdldGVudiglMjJIRl9NT0RFTCUyMiUyQyUyMCUyMm1pY3Jvc29mdCUyRkRpYWxvR1BULW1lZGl1bSUyMiklMEFERUZBVUxUX1BST1ZJREVSJTNBJTIwTGl0ZXJhbCU1QiUyMmhmLWluZmVyZW5jZSUyMiU1RCUyMCUzRCUyMCUyMmhmLWluZmVyZW5jZSUyMiUwQSUwQSUyMyUyMEdsb2JhbCUyMGFnZW50JTIwaW5zdGFuY2UlMEFhZ2VudF9pbnN0YW5jZSUzQSUyME9wdGlvbmFsJTVCQWdlbnQlNUQlMjAlM0QlMjBOb25l",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub.inference._mcp.agent <span class="hljs-keyword">import</span> Agent
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>, <span class="hljs-type">Literal</span>

<span class="hljs-comment"># Configuration</span>
HF_TOKEN = os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)
HF_MODEL = os.getenv(<span class="hljs-string">&quot;HF_MODEL&quot;</span>, <span class="hljs-string">&quot;microsoft/DialoGPT-medium&quot;</span>)
DEFAULT_PROVIDER: <span class="hljs-type">Literal</span>[<span class="hljs-string">&quot;hf-inference&quot;</span>] = <span class="hljs-string">&quot;hf-inference&quot;</span>

<span class="hljs-comment"># Global agent instance</span>
agent_instance: <span class="hljs-type">Optional</span>[Agent] = <span class="hljs-literal">None</span>`,wrap:!1}}),W=new I({props:{code:"YXN5bmMlMjBkZWYlMjBnZXRfYWdlbnQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkdldCUyMG9yJTIwY3JlYXRlJTIwQWdlbnQlMjBpbnN0YW5jZSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHByaW50KCUyMiVGMCU5RiVBNCU5NiUyMGdldF9hZ2VudCgpJTIwY2FsbGVkLi4uJTIyKSUwQSUyMCUyMCUyMCUyMGdsb2JhbCUyMGFnZW50X2luc3RhbmNlJTBBJTIwJTIwJTIwJTIwaWYlMjBhZ2VudF9pbnN0YW5jZSUyMGlzJTIwTm9uZSUyMGFuZCUyMEhGX1RPS0VOJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyJUYwJTlGJTk0JUE3JTIwQ3JlYXRpbmclMjBuZXclMjBBZ2VudCUyMGluc3RhbmNlLi4uJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjIlRjAlOUYlOTQlOTElMjBIRl9UT0tFTiUyMHByZXNlbnQlM0ElMjAlN0Jib29sKEhGX1RPS0VOKSU3RCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyJUYwJTlGJUE0JTk2JTIwTW9kZWwlM0ElMjAlN0JIRl9NT0RFTCU3RCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyJUYwJTlGJTk0JTk3JTIwUHJvdmlkZXIlM0ElMjAlN0JERUZBVUxUX1BST1ZJREVSJTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_agent</span>():
    <span class="hljs-string">&quot;&quot;&quot;Get or create Agent instance&quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🤖 get_agent() called...&quot;</span>)
    <span class="hljs-keyword">global</span> agent_instance
    <span class="hljs-keyword">if</span> agent_instance <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> HF_TOKEN:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🔧 Creating new Agent instance...&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔑 HF_TOKEN present: <span class="hljs-subst">{<span class="hljs-built_in">bool</span>(HF_TOKEN)}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🤖 Model: <span class="hljs-subst">{HF_MODEL}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔗 Provider: <span class="hljs-subst">{DEFAULT_PROVIDER}</span>&quot;</span>)`,wrap:!1}}),R=new I({props:{code:"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",highlighted:`        <span class="hljs-keyword">try</span>:
            agent_instance = Agent(
                model=HF_MODEL,
                provider=DEFAULT_PROVIDER,
                api_key=HF_TOKEN,
                servers=[
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;stdio&quot;</span>,
                        <span class="hljs-string">&quot;command&quot;</span>: <span class="hljs-string">&quot;python&quot;</span>,
                        <span class="hljs-string">&quot;args&quot;</span>: [<span class="hljs-string">&quot;mcp_server.py&quot;</span>],
                        <span class="hljs-string">&quot;cwd&quot;</span>: <span class="hljs-string">&quot;.&quot;</span>,
                        <span class="hljs-string">&quot;env&quot;</span>: {<span class="hljs-string">&quot;HF_TOKEN&quot;</span>: HF_TOKEN} <span class="hljs-keyword">if</span> HF_TOKEN <span class="hljs-keyword">else</span> {},
                    }
                ],
            )
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Agent instance created successfully&quot;</span>)
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🔧 Loading tools...&quot;</span>)
            <span class="hljs-keyword">await</span> agent_instance.load_tools()
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Tools loaded successfully&quot;</span>)
        <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ Error creating/loading agent: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>)
            agent_instance = <span class="hljs-literal">None</span>`,wrap:!1}}),S=new c({props:{title:"Tool Discovery and Usage",local:"tool-discovery-and-usage",headingTag:"h2"}}),P=new c({props:{title:"Available Tools",local:"available-tools",headingTag:"h3"}}),D=new c({props:{title:"Tool Execution Example",local:"tool-execution-example",headingTag:"h3"}}),lt=new I({props:{code:"JTIzJTIwRXhhbXBsZSUyMG9mJTIwaG93JTIwdGhlJTIwYWdlbnQlMjB3b3VsZCUyMHVzZSUyMHRvb2xzJTBBYXN5bmMlMjBkZWYlMjBleGFtcGxlX3Rvb2xfdXNhZ2UoKSUzQSUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwYXdhaXQlMjBnZXRfYWdlbnQoKSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMGlmJTIwYWdlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBUaGUlMjBhZ2VudCUyMGNhbiUyMHJlYXNvbiUyMGFib3V0JTIwd2hpY2glMjB0b29scyUyMHRvJTIwdXNlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBhd2FpdCUyMGFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJDaGVjayUyMHRoZSUyMGN1cnJlbnQlMjB0YWdzJTIwZm9yJTIwbWljcm9zb2Z0JTJGRGlhbG9HUFQtbWVkaXVtJTIwYW5kJTIwYWRkJTIwdGhlJTIwdGFnJTIwJ2NvbnZlcnNhdGlvbmFsLWFpJyUyMGlmJTIwaXQncyUyMG5vdCUyMGFscmVhZHklMjBwcmVzZW50JTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KHJlc3BvbnNlKQ==",highlighted:`<span class="hljs-comment"># Example of how the agent would use tools</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">example_tool_usage</span>():
    agent = <span class="hljs-keyword">await</span> get_agent()
    
    <span class="hljs-keyword">if</span> agent:
        <span class="hljs-comment"># The agent can reason about which tools to use</span>
        response = <span class="hljs-keyword">await</span> agent.run(
            <span class="hljs-string">&quot;Check the current tags for microsoft/DialoGPT-medium and add the tag &#x27;conversational-ai&#x27; if it&#x27;s not already present&quot;</span>
        )
        <span class="hljs-built_in">print</span>(response)`,wrap:!1}}),at=new c({props:{title:"Integration with Webhook Processing",local:"integration-with-webhook-processing",headingTag:"h2"}}),it=new c({props:{title:"1. Tag Extraction and Processing",local:"1-tag-extraction-and-processing",headingTag:"h3"}}),pt=new I({props:{code:"YXN5bmMlMjBkZWYlMjBwcm9jZXNzX3dlYmhvb2tfY29tbWVudCh3ZWJob29rX2RhdGElM0ElMjBEaWN0JTVCc3RyJTJDJTIwQW55JTVEKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMlByb2Nlc3MlMjB3ZWJob29rJTIwdG8lMjBkZXRlY3QlMjBhbmQlMjBhZGQlMjB0YWdzJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyJUYwJTlGJThGJUI3JUVGJUI4JThGJTIwU3RhcnRpbmclMjBwcm9jZXNzX3dlYmhvb2tfY29tbWVudC4uLiUyMiklMEElMEElMjAlMjAlMjAlMjB0cnklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb21tZW50X2NvbnRlbnQlMjAlM0QlMjB3ZWJob29rX2RhdGElNUIlMjJjb21tZW50JTIyJTVEJTVCJTIyY29udGVudCUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRpc2N1c3Npb25fdGl0bGUlMjAlM0QlMjB3ZWJob29rX2RhdGElNUIlMjJkaXNjdXNzaW9uJTIyJTVEJTVCJTIydGl0bGUlMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX25hbWUlMjAlM0QlMjB3ZWJob29rX2RhdGElNUIlMjJyZXBvJTIyJTVEJTVCJTIybmFtZSUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEV4dHJhY3QlMjBwb3RlbnRpYWwlMjB0YWdzJTIwZnJvbSUyMHRoZSUyMGNvbW1lbnQlMjBhbmQlMjBkaXNjdXNzaW9uJTIwdGl0bGUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb21tZW50X3RhZ3MlMjAlM0QlMjBleHRyYWN0X3RhZ3NfZnJvbV90ZXh0KGNvbW1lbnRfY29udGVudCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0aXRsZV90YWdzJTIwJTNEJTIwZXh0cmFjdF90YWdzX2Zyb21fdGV4dChkaXNjdXNzaW9uX3RpdGxlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFsbF90YWdzJTIwJTNEJTIwbGlzdChzZXQoY29tbWVudF90YWdzJTIwJTJCJTIwdGl0bGVfdGFncykpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVGMCU5RiU5NCU4RCUyMEFsbCUyMHVuaXF1ZSUyMHRhZ3MlM0ElMjAlN0JhbGxfdGFncyU3RCUyMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMG5vdCUyMGFsbF90YWdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCJTIyTm8lMjByZWNvZ25pemFibGUlMjB0YWdzJTIwZm91bmQlMjBpbiUyMHRoZSUyMGRpc2N1c3Npb24uJTIyJTVE",highlighted:`<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">process_webhook_comment</span>(<span class="hljs-params">webhook_data: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>):
    <span class="hljs-string">&quot;&quot;&quot;Process webhook to detect and add tags&quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🏷️ Starting process_webhook_comment...&quot;</span>)

    <span class="hljs-keyword">try</span>:
        comment_content = webhook_data[<span class="hljs-string">&quot;comment&quot;</span>][<span class="hljs-string">&quot;content&quot;</span>]
        discussion_title = webhook_data[<span class="hljs-string">&quot;discussion&quot;</span>][<span class="hljs-string">&quot;title&quot;</span>]
        repo_name = webhook_data[<span class="hljs-string">&quot;repo&quot;</span>][<span class="hljs-string">&quot;name&quot;</span>]
        
        <span class="hljs-comment"># Extract potential tags from the comment and discussion title</span>
        comment_tags = extract_tags_from_text(comment_content)
        title_tags = extract_tags_from_text(discussion_title)
        all_tags = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(comment_tags + title_tags))

        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔍 All unique tags: <span class="hljs-subst">{all_tags}</span>&quot;</span>)

        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> all_tags:
            <span class="hljs-keyword">return</span> [<span class="hljs-string">&quot;No recognizable tags found in the discussion.&quot;</span>]`,wrap:!1}}),yt=new I({props:{code:"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",highlighted:`        <span class="hljs-comment"># Get agent instance</span>
        agent = <span class="hljs-keyword">await</span> get_agent()
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> agent:
            <span class="hljs-keyword">return</span> [<span class="hljs-string">&quot;Error: Agent not configured (missing HF_TOKEN)&quot;</span>]

        <span class="hljs-comment"># Process each tag</span>
        result_messages = []
        <span class="hljs-keyword">for</span> tag <span class="hljs-keyword">in</span> all_tags:
            <span class="hljs-keyword">try</span>:
                <span class="hljs-comment"># Use agent to process the tag</span>
                prompt = <span class="hljs-string">f&quot;&quot;&quot;
                For the repository &#x27;<span class="hljs-subst">{repo_name}</span>&#x27;, check if the tag &#x27;<span class="hljs-subst">{tag}</span>&#x27; already exists.
                If it doesn&#x27;t exist, add it via a pull request.
                
                Repository: <span class="hljs-subst">{repo_name}</span>
                Tag to check/add: <span class="hljs-subst">{tag}</span>
                &quot;&quot;&quot;</span>
                
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🤖 Processing tag &#x27;<span class="hljs-subst">{tag}</span>&#x27; for repo &#x27;<span class="hljs-subst">{repo_name}</span>&#x27;&quot;</span>)
                response = <span class="hljs-keyword">await</span> agent.run(prompt)
                
                <span class="hljs-comment"># Parse agent response for success/failure</span>
                <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;success&quot;</span> <span class="hljs-keyword">in</span> response.lower():
                    result_messages.append(<span class="hljs-string">f&quot;✅ Tag &#x27;<span class="hljs-subst">{tag}</span>&#x27; processed successfully&quot;</span>)
                <span class="hljs-keyword">else</span>:
                    result_messages.append(<span class="hljs-string">f&quot;⚠️ Issue with tag &#x27;<span class="hljs-subst">{tag}</span>&#x27;: <span class="hljs-subst">{response}</span>&quot;</span>)
                    
            <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
                error_msg = <span class="hljs-string">f&quot;❌ Error processing tag &#x27;<span class="hljs-subst">{tag}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
                <span class="hljs-built_in">print</span>(error_msg)
                result_messages.append(error_msg)

        <span class="hljs-keyword">return</span> result_messages`,wrap:!1}}),Ut=new c({props:{title:"2. Tag Extraction Logic",local:"2-tag-extraction-logic",headingTag:"h3"}}),rt=new I({props:{code:"aW1wb3J0JTIwcmUlMEFmcm9tJTIwdHlwaW5nJTIwaW1wb3J0JTIwTGlzdCUwQSUwQSUyMyUyMFJlY29nbml6ZWQlMjBNTCUyRkFJJTIwdGFncyUyMGZvciUyMHZhbGlkYXRpb24lMEFSRUNPR05JWkVEX1RBR1MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJweXRvcmNoJTIyJTJDJTIwJTIydGVuc29yZmxvdyUyMiUyQyUyMCUyMmpheCUyMiUyQyUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUyMCUyMmRpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIlMkMlMjAlMjJxdWVzdGlvbi1hbnN3ZXJpbmclMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0ZXh0LXRvLWltYWdlJTIyJTJDJTIwJTIyaW1hZ2UtY2xhc3NpZmljYXRpb24lMjIlMkMlMjAlMjJvYmplY3QtZGV0ZWN0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZmlsbC1tYXNrJTIyJTJDJTIwJTIydG9rZW4tY2xhc3NpZmljYXRpb24lMjIlMkMlMjAlMjJ0cmFuc2xhdGlvbiUyMiUyQyUyMCUyMnN1bW1hcml6YXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjAlMjJzZW50ZW5jZS1zaW1pbGFyaXR5JTIyJTJDJTIwJTIyemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyaW1hZ2UtdG8tdGV4dCUyMiUyQyUyMCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjAlMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnZvaWNlLWFjdGl2aXR5LWRldGVjdGlvbiUyMiUyQyUyMCUyMmRlcHRoLWVzdGltYXRpb24lMjIlMkMlMjAlMjJpbWFnZS1zZWdtZW50YXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ2aWRlby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMCUyMnJlaW5mb3JjZW1lbnQtbGVhcm5pbmclMjIlMkMlMjAlMjJ0YWJ1bGFyLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydGFidWxhci1yZWdyZXNzaW9uJTIyJTJDJTIwJTIydGltZS1zZXJpZXMtZm9yZWNhc3RpbmclMjIlMkMlMjAlMjJncmFwaC1tbCUyMiUyQyUyMCUyMnJvYm90aWNzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29tcHV0ZXItdmlzaW9uJTIyJTJDJTIwJTIybmxwJTIyJTJDJTIwJTIyY3YlMjIlMkMlMjAlMjJtdWx0aW1vZGFsJTIyJTJDJTBBJTdE",highlighted:`<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>

<span class="hljs-comment"># Recognized ML/AI tags for validation</span>
RECOGNIZED_TAGS = {
    <span class="hljs-string">&quot;pytorch&quot;</span>, <span class="hljs-string">&quot;tensorflow&quot;</span>, <span class="hljs-string">&quot;jax&quot;</span>, <span class="hljs-string">&quot;transformers&quot;</span>, <span class="hljs-string">&quot;diffusers&quot;</span>,
    <span class="hljs-string">&quot;text-generation&quot;</span>, <span class="hljs-string">&quot;text-classification&quot;</span>, <span class="hljs-string">&quot;question-answering&quot;</span>,
    <span class="hljs-string">&quot;text-to-image&quot;</span>, <span class="hljs-string">&quot;image-classification&quot;</span>, <span class="hljs-string">&quot;object-detection&quot;</span>,
    <span class="hljs-string">&quot;fill-mask&quot;</span>, <span class="hljs-string">&quot;token-classification&quot;</span>, <span class="hljs-string">&quot;translation&quot;</span>, <span class="hljs-string">&quot;summarization&quot;</span>,
    <span class="hljs-string">&quot;feature-extraction&quot;</span>, <span class="hljs-string">&quot;sentence-similarity&quot;</span>, <span class="hljs-string">&quot;zero-shot-classification&quot;</span>,
    <span class="hljs-string">&quot;image-to-text&quot;</span>, <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, <span class="hljs-string">&quot;audio-classification&quot;</span>,
    <span class="hljs-string">&quot;voice-activity-detection&quot;</span>, <span class="hljs-string">&quot;depth-estimation&quot;</span>, <span class="hljs-string">&quot;image-segmentation&quot;</span>,
    <span class="hljs-string">&quot;video-classification&quot;</span>, <span class="hljs-string">&quot;reinforcement-learning&quot;</span>, <span class="hljs-string">&quot;tabular-classification&quot;</span>,
    <span class="hljs-string">&quot;tabular-regression&quot;</span>, <span class="hljs-string">&quot;time-series-forecasting&quot;</span>, <span class="hljs-string">&quot;graph-ml&quot;</span>, <span class="hljs-string">&quot;robotics&quot;</span>,
    <span class="hljs-string">&quot;computer-vision&quot;</span>, <span class="hljs-string">&quot;nlp&quot;</span>, <span class="hljs-string">&quot;cv&quot;</span>, <span class="hljs-string">&quot;multimodal&quot;</span>,
}`,wrap:!1}}),ht=new I({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_tags_from_text</span>(<span class="hljs-params">text: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>]:
    <span class="hljs-string">&quot;&quot;&quot;Extract potential tags from discussion text&quot;&quot;&quot;</span>
    text_lower = text.lower()
    explicit_tags = []

    <span class="hljs-comment"># Pattern 1: &quot;tag: something&quot; or &quot;tags: something&quot;</span>
    tag_pattern = <span class="hljs-string">r&quot;tags?:\\s*([a-zA-Z0-9-_,\\s]+)&quot;</span>
    matches = re.findall(tag_pattern, text_lower)
    <span class="hljs-keyword">for</span> <span class="hljs-keyword">match</span> <span class="hljs-keyword">in</span> matches:
        tags = [tag.strip() <span class="hljs-keyword">for</span> tag <span class="hljs-keyword">in</span> <span class="hljs-keyword">match</span>.split(<span class="hljs-string">&quot;,&quot;</span>)]
        explicit_tags.extend(tags)

    <span class="hljs-comment"># Pattern 2: &quot;#hashtag&quot; style</span>
    hashtag_pattern = <span class="hljs-string">r&quot;#([a-zA-Z0-9-_]+)&quot;</span>
    hashtag_matches = re.findall(hashtag_pattern, text_lower)
    explicit_tags.extend(hashtag_matches)

    <span class="hljs-comment"># Pattern 3: Look for recognized tags mentioned in natural text</span>
    mentioned_tags = []
    <span class="hljs-keyword">for</span> tag <span class="hljs-keyword">in</span> RECOGNIZED_TAGS:
        <span class="hljs-keyword">if</span> tag <span class="hljs-keyword">in</span> text_lower:
            mentioned_tags.append(tag)

    <span class="hljs-comment"># Combine and deduplicate</span>
    all_tags = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(explicit_tags + mentioned_tags))

    <span class="hljs-comment"># Filter to only include recognized tags or explicitly mentioned ones</span>
    valid_tags = []
    <span class="hljs-keyword">for</span> tag <span class="hljs-keyword">in</span> all_tags:
        <span class="hljs-keyword">if</span> tag <span class="hljs-keyword">in</span> RECOGNIZED_TAGS <span class="hljs-keyword">or</span> tag <span class="hljs-keyword">in</span> explicit_tags:
            valid_tags.append(tag)

    <span class="hljs-keyword">return</span> valid_tags`,wrap:!1}}),At=new c({props:{title:"Performance Considerations",local:"performance-considerations",headingTag:"h2"}}),ft=new c({props:{title:"1. Agent Singleton Pattern",local:"1-agent-singleton-pattern",headingTag:"h3"}}),vt=new c({props:{title:"2. Async Processing",local:"2-async-processing",headingTag:"h3"}}),Et=new c({props:{title:"3. Background Task Processing",local:"3-background-task-processing",headingTag:"h3"}}),_t=new I({props:{code:"ZnJvbSUyMGZhc3RhcGklMjBpbXBvcnQlMjBCYWNrZ3JvdW5kVGFza3MlMEElMEElNDBhcHAucG9zdCglMjIlMkZ3ZWJob29rJTIyKSUwQWFzeW5jJTIwZGVmJTIwd2ViaG9va19oYW5kbGVyKHJlcXVlc3QlM0ElMjBSZXF1ZXN0JTJDJTIwYmFja2dyb3VuZF90YXNrcyUzQSUyMEJhY2tncm91bmRUYXNrcyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJIYW5kbGUlMjB3ZWJob29rJTIwYW5kJTIwcHJvY2VzcyUyMGluJTIwYmFja2dyb3VuZCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFZhbGlkYXRlJTIwd2ViaG9vayUyMHF1aWNrbHklMEElMjAlMjAlMjAlMjBpZiUyMHJlcXVlc3QuaGVhZGVycy5nZXQoJTIyWC1XZWJob29rLVNlY3JldCUyMiklMjAhJTNEJTIwV0VCSE9PS19TRUNSRVQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJlcnJvciUyMiUzQSUyMCUyMkludmFsaWQlMjBzZWNyZXQlMjIlN0QlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjB3ZWJob29rX2RhdGElMjAlM0QlMjBhd2FpdCUyMHJlcXVlc3QuanNvbigpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwUHJvY2VzcyUyMGluJTIwYmFja2dyb3VuZCUyMHRvJTIwcmV0dXJuJTIwcXVpY2tseSUwQSUyMCUyMCUyMCUyMGJhY2tncm91bmRfdGFza3MuYWRkX3Rhc2socHJvY2Vzc193ZWJob29rX2NvbW1lbnQlMkMlMjB3ZWJob29rX2RhdGEpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyc3RhdHVzJTIyJTNBJTIwJTIyYWNjZXB0ZWQlMjIlN0Q=",highlighted:`<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> BackgroundTasks

<span class="hljs-meta">@app.post(<span class="hljs-params"><span class="hljs-string">&quot;/webhook&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">webhook_handler</span>(<span class="hljs-params">request: Request, background_tasks: BackgroundTasks</span>):
    <span class="hljs-string">&quot;&quot;&quot;Handle webhook and process in background&quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Validate webhook quickly</span>
    <span class="hljs-keyword">if</span> request.headers.get(<span class="hljs-string">&quot;X-Webhook-Secret&quot;</span>) != WEBHOOK_SECRET:
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;error&quot;</span>: <span class="hljs-string">&quot;Invalid secret&quot;</span>}
    
    webhook_data = <span class="hljs-keyword">await</span> request.json()
    
    <span class="hljs-comment"># Process in background to return quickly</span>
    background_tasks.add_task(process_webhook_comment, webhook_data)
    
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;accepted&quot;</span>}`,wrap:!1}}),Rt=new c({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),Yt=new xe({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit3_1/mcp-client.mdx"}}),{c(){U=M("meta"),St=n(),Ht=M("p"),zt=n(),p(m.$$.fragment),Pt=n(),g=M("p"),g.textContent=ms,Lt=n(),A=M("p"),A.textContent=gs,Kt=n(),r=M("blockquote"),r.innerHTML=As,Ot=n(),p(b.$$.fragment),Dt=n(),f=M("p"),f.innerHTML=bs,tl=n(),B=M("p"),B.innerHTML=fs,ll=n(),p(Z.$$.fragment),sl=n(),k=M("p"),k.innerHTML=Bs,el=n(),p(v.$$.fragment),nl=n(),x=M("p"),x.textContent=Zs,al=n(),p(G.$$.fragment),Ml=n(),q=M("p"),q.innerHTML=ks,il=n(),E=M("p"),E.textContent=vs,ol=n(),p(W.$$.fragment),pl=n(),_=M("p"),_.textContent=xs,Jl=n(),N=M("p"),N.textContent=Gs,Tl=n(),p(R.$$.fragment),yl=n(),Q=M("p"),Q.textContent=qs,wl=n(),X=M("p"),X.innerHTML=Es,jl=n(),$=M("ul"),$.innerHTML=Ws,cl=n(),Y=M("p"),Y.innerHTML=_s,Ul=n(),V=M("ul"),V.innerHTML=Ns,Il=n(),u=M("blockquote"),u.innerHTML=Rs,rl=n(),H=M("p"),H.innerHTML=Qs,ul=n(),F=M("p"),F.textContent=Xs,Cl=n(),p(S.$$.fragment),hl=n(),z=M("p"),z.textContent=$s,dl=n(),p(P.$$.fragment),ml=n(),L=M("p"),L.textContent=Ys,gl=n(),K=M("ul"),K.innerHTML=Vs,Al=n(),O=M("p"),O.textContent=Hs,bl=n(),p(D.$$.fragment),fl=n(),tt=M("p"),tt.textContent=Fs,Bl=n(),p(lt.$$.fragment),Zl=n(),st=M("p"),st.textContent=Ss,kl=n(),et=M("ol"),et.innerHTML=zs,vl=n(),nt=M("p"),nt.textContent=Ps,xl=n(),p(at.$$.fragment),Gl=n(),Mt=M("p"),Mt.textContent=Ls,ql=n(),p(it.$$.fragment),El=n(),ot=M("p"),ot.textContent=Ks,Wl=n(),p(pt.$$.fragment),_l=n(),Jt=M("p"),Jt.textContent=Os,Nl=n(),C=M("blockquote"),C.innerHTML=Ds,Rl=n(),Tt=M("p"),Tt.textContent=te,Ql=n(),p(yt.$$.fragment),Xl=n(),wt=M("p"),wt.textContent=le,$l=n(),jt=M("ol"),jt.innerHTML=se,Yl=n(),ct=M("p"),ct.textContent=ee,Vl=n(),p(Ut.$$.fragment),Hl=n(),It=M("p"),It.textContent=ne,Fl=n(),p(rt.$$.fragment),Sl=n(),ut=M("p"),ut.textContent=ae,zl=n(),Ct=M("p"),Ct.textContent=Me,Pl=n(),p(ht.$$.fragment),Ll=n(),dt=M("p"),dt.textContent=ie,Kl=n(),mt=M("ol"),mt.innerHTML=oe,Ol=n(),gt=M("p"),gt.textContent=pe,Dl=n(),p(At.$$.fragment),ts=n(),bt=M("p"),bt.textContent=Je,ls=n(),p(ft.$$.fragment),ss=n(),Bt=M("p"),Bt.textContent=Te,es=n(),Zt=M("ul"),Zt.innerHTML=ye,ns=n(),kt=M("p"),kt.textContent=we,as=n(),p(vt.$$.fragment),Ms=n(),xt=M("p"),xt.textContent=je,is=n(),Gt=M("ul"),Gt.innerHTML=ce,os=n(),qt=M("p"),qt.textContent=Ue,ps=n(),p(Et.$$.fragment),Js=n(),Wt=M("p"),Wt.innerHTML=Ie,Ts=n(),p(_t.$$.fragment),ys=n(),Nt=M("p"),Nt.textContent=re,ws=n(),h=M("blockquote"),h.innerHTML=ue,js=n(),p(Rt.$$.fragment),cs=n(),Qt=M("p"),Qt.textContent=Ce,Us=n(),Xt=M("ol"),Xt.innerHTML=he,Is=n(),$t=M("p"),$t.textContent=de,rs=n(),d=M("blockquote"),d.innerHTML=me,us=n(),p(Yt.$$.fragment),Cs=n(),Ft=M("p"),this.h()},l(t){const l=ke("svelte-u9bgzb",document.head);U=i(l,"META",{name:!0,content:!0}),l.forEach(s),St=a(t),Ht=i(t,"P",{}),ge(Ht).forEach(s),zt=a(t),J(m.$$.fragment,t),Pt=a(t),g=i(t,"P",{"data-svelte-h":!0}),o(g)!=="svelte-o5mfkz"&&(g.textContent=ms),Lt=a(t),A=i(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1tiz43l"&&(A.textContent=gs),Kt=a(t),r=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(r)!=="svelte-m0z4t"&&(r.innerHTML=As),Ot=a(t),J(b.$$.fragment,t),Dt=a(t),f=i(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-sk08k0"&&(f.innerHTML=bs),tl=a(t),B=i(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-g1jj0m"&&(B.innerHTML=fs),ll=a(t),J(Z.$$.fragment,t),sl=a(t),k=i(t,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1ipr9ey"&&(k.innerHTML=Bs),el=a(t),J(v.$$.fragment,t),nl=a(t),x=i(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-zgdnms"&&(x.textContent=Zs),al=a(t),J(G.$$.fragment,t),Ml=a(t),q=i(t,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1k99sys"&&(q.innerHTML=ks),il=a(t),E=i(t,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1kuar4n"&&(E.textContent=vs),ol=a(t),J(W.$$.fragment,t),pl=a(t),_=i(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1kzsmkd"&&(_.textContent=xs),Jl=a(t),N=i(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-d22zqt"&&(N.textContent=Gs),Tl=a(t),J(R.$$.fragment,t),yl=a(t),Q=i(t,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1uv0eq9"&&(Q.textContent=qs),wl=a(t),X=i(t,"P",{"data-svelte-h":!0}),o(X)!=="svelte-7oshyu"&&(X.innerHTML=Es),jl=a(t),$=i(t,"UL",{"data-svelte-h":!0}),o($)!=="svelte-r83xmx"&&($.innerHTML=Ws),cl=a(t),Y=i(t,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1872chq"&&(Y.innerHTML=_s),Ul=a(t),V=i(t,"UL",{"data-svelte-h":!0}),o(V)!=="svelte-s9520z"&&(V.innerHTML=Ns),Il=a(t),u=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(u)!=="svelte-bnxcff"&&(u.innerHTML=Rs),rl=a(t),H=i(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-h2m3sn"&&(H.innerHTML=Qs),ul=a(t),F=i(t,"P",{"data-svelte-h":!0}),o(F)!=="svelte-12j4xsp"&&(F.textContent=Xs),Cl=a(t),J(S.$$.fragment,t),hl=a(t),z=i(t,"P",{"data-svelte-h":!0}),o(z)!=="svelte-qaqek9"&&(z.textContent=$s),dl=a(t),J(P.$$.fragment,t),ml=a(t),L=i(t,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1b55wgg"&&(L.textContent=Ys),gl=a(t),K=i(t,"UL",{"data-svelte-h":!0}),o(K)!=="svelte-1uktuvs"&&(K.innerHTML=Vs),Al=a(t),O=i(t,"P",{"data-svelte-h":!0}),o(O)!=="svelte-k2412b"&&(O.textContent=Hs),bl=a(t),J(D.$$.fragment,t),fl=a(t),tt=i(t,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-1bm9ul5"&&(tt.textContent=Fs),Bl=a(t),J(lt.$$.fragment,t),Zl=a(t),st=i(t,"P",{"data-svelte-h":!0}),o(st)!=="svelte-hzu4xy"&&(st.textContent=Ss),kl=a(t),et=i(t,"OL",{"data-svelte-h":!0}),o(et)!=="svelte-1om1rwe"&&(et.innerHTML=zs),vl=a(t),nt=i(t,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-1pgsrpk"&&(nt.textContent=Ps),xl=a(t),J(at.$$.fragment,t),Gl=a(t),Mt=i(t,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-d5c1ft"&&(Mt.textContent=Ls),ql=a(t),J(it.$$.fragment,t),El=a(t),ot=i(t,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-xrdu6q"&&(ot.textContent=Ks),Wl=a(t),J(pt.$$.fragment,t),_l=a(t),Jt=i(t,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-4cm3gu"&&(Jt.textContent=Os),Nl=a(t),C=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(C)!=="svelte-15ymkn3"&&(C.innerHTML=Ds),Rl=a(t),Tt=i(t,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-65h1kx"&&(Tt.textContent=te),Ql=a(t),J(yt.$$.fragment,t),Xl=a(t),wt=i(t,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-ty7tki"&&(wt.textContent=le),$l=a(t),jt=i(t,"OL",{"data-svelte-h":!0}),o(jt)!=="svelte-e2mg28"&&(jt.innerHTML=se),Yl=a(t),ct=i(t,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-16ed2bp"&&(ct.textContent=ee),Vl=a(t),J(Ut.$$.fragment,t),Hl=a(t),It=i(t,"P",{"data-svelte-h":!0}),o(It)!=="svelte-1hplsxl"&&(It.textContent=ne),Fl=a(t),J(rt.$$.fragment,t),Sl=a(t),ut=i(t,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1q4pd90"&&(ut.textContent=ae),zl=a(t),Ct=i(t,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-149cgcf"&&(Ct.textContent=Me),Pl=a(t),J(ht.$$.fragment,t),Ll=a(t),dt=i(t,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-fgnove"&&(dt.textContent=ie),Kl=a(t),mt=i(t,"OL",{"data-svelte-h":!0}),o(mt)!=="svelte-1dk0z4o"&&(mt.innerHTML=oe),Ol=a(t),gt=i(t,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-1wl0e0h"&&(gt.textContent=pe),Dl=a(t),J(At.$$.fragment,t),ts=a(t),bt=i(t,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-1x0jdeh"&&(bt.textContent=Je),ls=a(t),J(ft.$$.fragment,t),ss=a(t),Bt=i(t,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-1bw24v8"&&(Bt.textContent=Te),es=a(t),Zt=i(t,"UL",{"data-svelte-h":!0}),o(Zt)!=="svelte-1j5mius"&&(Zt.innerHTML=ye),ns=a(t),kt=i(t,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-2opepg"&&(kt.textContent=we),as=a(t),J(vt.$$.fragment,t),Ms=a(t),xt=i(t,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-oqkbu0"&&(xt.textContent=je),is=a(t),Gt=i(t,"UL",{"data-svelte-h":!0}),o(Gt)!=="svelte-i1e590"&&(Gt.innerHTML=ce),os=a(t),qt=i(t,"P",{"data-svelte-h":!0}),o(qt)!=="svelte-lkn7k8"&&(qt.textContent=Ue),ps=a(t),J(Et.$$.fragment,t),Js=a(t),Wt=i(t,"P",{"data-svelte-h":!0}),o(Wt)!=="svelte-1h2ni44"&&(Wt.innerHTML=Ie),Ts=a(t),J(_t.$$.fragment,t),ys=a(t),Nt=i(t,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-fd134s"&&(Nt.textContent=re),ws=a(t),h=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(h)!=="svelte-1ai493v"&&(h.innerHTML=ue),js=a(t),J(Rt.$$.fragment,t),cs=a(t),Qt=i(t,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-1vyqah1"&&(Qt.textContent=Ce),Us=a(t),Xt=i(t,"OL",{"data-svelte-h":!0}),o(Xt)!=="svelte-p0gh2q"&&(Xt.innerHTML=he),Is=a(t),$t=i(t,"P",{"data-svelte-h":!0}),o($t)!=="svelte-qg9wgy"&&($t.textContent=de),rs=a(t),d=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(d)!=="svelte-2fggr3"&&(d.innerHTML=me),us=a(t),J(Yt.$$.fragment,t),Cs=a(t),Ft=i(t,"P",{}),ge(Ft).forEach(s),this.h()},h(){Vt(U,"name","hf:doc:metadata"),Vt(U,"content",qe),Vt(r,"class","tip"),Vt(u,"class","tip"),Vt(C,"class","tip"),Vt(h,"class","tip"),Vt(d,"class","tip")},m(t,l){ve(document.head,U),e(t,St,l),e(t,Ht,l),e(t,zt,l),T(m,t,l),e(t,Pt,l),e(t,g,l),e(t,Lt,l),e(t,A,l),e(t,Kt,l),e(t,r,l),e(t,Ot,l),T(b,t,l),e(t,Dt,l),e(t,f,l),e(t,tl,l),e(t,B,l),e(t,ll,l),T(Z,t,l),e(t,sl,l),e(t,k,l),e(t,el,l),T(v,t,l),e(t,nl,l),e(t,x,l),e(t,al,l),T(G,t,l),e(t,Ml,l),e(t,q,l),e(t,il,l),e(t,E,l),e(t,ol,l),T(W,t,l),e(t,pl,l),e(t,_,l),e(t,Jl,l),e(t,N,l),e(t,Tl,l),T(R,t,l),e(t,yl,l),e(t,Q,l),e(t,wl,l),e(t,X,l),e(t,jl,l),e(t,$,l),e(t,cl,l),e(t,Y,l),e(t,Ul,l),e(t,V,l),e(t,Il,l),e(t,u,l),e(t,rl,l),e(t,H,l),e(t,ul,l),e(t,F,l),e(t,Cl,l),T(S,t,l),e(t,hl,l),e(t,z,l),e(t,dl,l),T(P,t,l),e(t,ml,l),e(t,L,l),e(t,gl,l),e(t,K,l),e(t,Al,l),e(t,O,l),e(t,bl,l),T(D,t,l),e(t,fl,l),e(t,tt,l),e(t,Bl,l),T(lt,t,l),e(t,Zl,l),e(t,st,l),e(t,kl,l),e(t,et,l),e(t,vl,l),e(t,nt,l),e(t,xl,l),T(at,t,l),e(t,Gl,l),e(t,Mt,l),e(t,ql,l),T(it,t,l),e(t,El,l),e(t,ot,l),e(t,Wl,l),T(pt,t,l),e(t,_l,l),e(t,Jt,l),e(t,Nl,l),e(t,C,l),e(t,Rl,l),e(t,Tt,l),e(t,Ql,l),T(yt,t,l),e(t,Xl,l),e(t,wt,l),e(t,$l,l),e(t,jt,l),e(t,Yl,l),e(t,ct,l),e(t,Vl,l),T(Ut,t,l),e(t,Hl,l),e(t,It,l),e(t,Fl,l),T(rt,t,l),e(t,Sl,l),e(t,ut,l),e(t,zl,l),e(t,Ct,l),e(t,Pl,l),T(ht,t,l),e(t,Ll,l),e(t,dt,l),e(t,Kl,l),e(t,mt,l),e(t,Ol,l),e(t,gt,l),e(t,Dl,l),T(At,t,l),e(t,ts,l),e(t,bt,l),e(t,ls,l),T(ft,t,l),e(t,ss,l),e(t,Bt,l),e(t,es,l),e(t,Zt,l),e(t,ns,l),e(t,kt,l),e(t,as,l),T(vt,t,l),e(t,Ms,l),e(t,xt,l),e(t,is,l),e(t,Gt,l),e(t,os,l),e(t,qt,l),e(t,ps,l),T(Et,t,l),e(t,Js,l),e(t,Wt,l),e(t,Ts,l),T(_t,t,l),e(t,ys,l),e(t,Nt,l),e(t,ws,l),e(t,h,l),e(t,js,l),T(Rt,t,l),e(t,cs,l),e(t,Qt,l),e(t,Us,l),e(t,Xt,l),e(t,Is,l),e(t,$t,l),e(t,rs,l),e(t,d,l),e(t,us,l),T(Yt,t,l),e(t,Cs,l),e(t,Ft,l),hs=!0},p:be,i(t){hs||(y(m.$$.fragment,t),y(b.$$.fragment,t),y(Z.$$.fragment,t),y(v.$$.fragment,t),y(G.$$.fragment,t),y(W.$$.fragment,t),y(R.$$.fragment,t),y(S.$$.fragment,t),y(P.$$.fragment,t),y(D.$$.fragment,t),y(lt.$$.fragment,t),y(at.$$.fragment,t),y(it.$$.fragment,t),y(pt.$$.fragment,t),y(yt.$$.fragment,t),y(Ut.$$.fragment,t),y(rt.$$.fragment,t),y(ht.$$.fragment,t),y(At.$$.fragment,t),y(ft.$$.fragment,t),y(vt.$$.fragment,t),y(Et.$$.fragment,t),y(_t.$$.fragment,t),y(Rt.$$.fragment,t),y(Yt.$$.fragment,t),hs=!0)},o(t){w(m.$$.fragment,t),w(b.$$.fragment,t),w(Z.$$.fragment,t),w(v.$$.fragment,t),w(G.$$.fragment,t),w(W.$$.fragment,t),w(R.$$.fragment,t),w(S.$$.fragment,t),w(P.$$.fragment,t),w(D.$$.fragment,t),w(lt.$$.fragment,t),w(at.$$.fragment,t),w(it.$$.fragment,t),w(pt.$$.fragment,t),w(yt.$$.fragment,t),w(Ut.$$.fragment,t),w(rt.$$.fragment,t),w(ht.$$.fragment,t),w(At.$$.fragment,t),w(ft.$$.fragment,t),w(vt.$$.fragment,t),w(Et.$$.fragment,t),w(_t.$$.fragment,t),w(Rt.$$.fragment,t),w(Yt.$$.fragment,t),hs=!1},d(t){t&&(s(St),s(Ht),s(zt),s(Pt),s(g),s(Lt),s(A),s(Kt),s(r),s(Ot),s(Dt),s(f),s(tl),s(B),s(ll),s(sl),s(k),s(el),s(nl),s(x),s(al),s(Ml),s(q),s(il),s(E),s(ol),s(pl),s(_),s(Jl),s(N),s(Tl),s(yl),s(Q),s(wl),s(X),s(jl),s($),s(cl),s(Y),s(Ul),s(V),s(Il),s(u),s(rl),s(H),s(ul),s(F),s(Cl),s(hl),s(z),s(dl),s(ml),s(L),s(gl),s(K),s(Al),s(O),s(bl),s(fl),s(tt),s(Bl),s(Zl),s(st),s(kl),s(et),s(vl),s(nt),s(xl),s(Gl),s(Mt),s(ql),s(El),s(ot),s(Wl),s(_l),s(Jt),s(Nl),s(C),s(Rl),s(Tt),s(Ql),s(Xl),s(wt),s($l),s(jt),s(Yl),s(ct),s(Vl),s(Hl),s(It),s(Fl),s(Sl),s(ut),s(zl),s(Ct),s(Pl),s(Ll),s(dt),s(Kl),s(mt),s(Ol),s(gt),s(Dl),s(ts),s(bt),s(ls),s(ss),s(Bt),s(es),s(Zt),s(ns),s(kt),s(as),s(Ms),s(xt),s(is),s(Gt),s(os),s(qt),s(ps),s(Js),s(Wt),s(Ts),s(ys),s(Nt),s(ws),s(h),s(js),s(cs),s(Qt),s(Us),s(Xt),s(Is),s($t),s(rs),s(d),s(us),s(Cs),s(Ft)),s(U),j(m,t),j(b,t),j(Z,t),j(v,t),j(G,t),j(W,t),j(R,t),j(S,t),j(P,t),j(D,t),j(lt,t),j(at,t),j(it,t),j(pt,t),j(yt,t),j(Ut,t),j(rt,t),j(ht,t),j(At,t),j(ft,t),j(vt,t),j(Et,t),j(_t,t),j(Rt,t),j(Yt,t)}}}const qe='{"title":"MCP Client","local":"mcp-client","sections":[{"title":"Understanding the MCP Client Architecture","local":"understanding-the-mcp-client-architecture","sections":[],"depth":2},{"title":"Agent-Based MCP Client","local":"agent-based-mcp-client","sections":[{"title":"1. Agent Configuration","local":"1-agent-configuration","sections":[],"depth":3}],"depth":2},{"title":"Tool Discovery and Usage","local":"tool-discovery-and-usage","sections":[{"title":"Available Tools","local":"available-tools","sections":[],"depth":3},{"title":"Tool Execution Example","local":"tool-execution-example","sections":[],"depth":3}],"depth":2},{"title":"Integration with Webhook Processing","local":"integration-with-webhook-processing","sections":[{"title":"1. Tag Extraction and Processing","local":"1-tag-extraction-and-processing","sections":[],"depth":3},{"title":"2. Tag Extraction Logic","local":"2-tag-extraction-logic","sections":[],"depth":3}],"depth":2},{"title":"Performance Considerations","local":"performance-considerations","sections":[{"title":"1. Agent Singleton Pattern","local":"1-agent-singleton-pattern","sections":[],"depth":3},{"title":"2. Async Processing","local":"2-async-processing","sections":[],"depth":3},{"title":"3. Background Task Processing","local":"3-background-task-processing","sections":[],"depth":3}],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Ee(ds){return fe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qe extends Be{constructor(U){super(),Ze(this,U,Ee,Ge,Ae,{})}}export{Qe as component};
