# Building MCP Clients

In this section, we'll create clients that can interact with our MCP server using different programming languages. We'll implement both a JavaScript client using HuggingFace.js and a Python client using smolagents.

## Configuring MCP Clients

Effective deployment of MCP servers and clients requires proper configuration. The MCP specification is still evolving, so the configuration methods are subject to evolution. We'll focus on the current best practices for configuration.

### MCP Configuration Files

MCP hosts use configuration files to manage server connections. These files define which servers are available and how to connect to them.

The configuration files are very simple, easy to understand, and consistent across major MCP hosts.

#### `mcp.json` Structure

The standard configuration file for MCP is named `mcp.json`. Here's the basic structure:

```json
{
  "servers": [
    {
      "name": "MCP Server",
      "transport": {
        "type": "sse",
        "url": "http://localhost:7860/gradio_api/mcp/sse"
      }
    }
  ]
}
```

In this example, we have a single server configured to use SSE transport, connecting to a local Gradio server running on port 7860.

> [!TIP]
> We've connected to the Gradio app via SSE transport because we assume that the gradio app is running on a remote server. However, if you want to connect to a local script, `stdio` transport instead of `sse` transport is a better option.

#### Configuration for HTTP+SSE Transport

For remote servers using HTTP+SSE transport, the configuration includes the server URL:

```json
{
  "servers": [
    {
      "name": "Remote MCP Server",
      "transport": {
        "type": "sse",
        "url": "https://example.com/gradio_api/mcp/sse"
      }
    }
  ]
}
```

This configuration allows your UI client to communicate with the Gradio MCP server using the MCP protocol, enabling seamless integration between your frontend and the MCP service.

## Configuring a UI MCP Client

When working with Gradio MCP servers, you can configure your UI client to connect to the server using the MCP protocol. Here's how to set it up:

### Basic Configuration

Create a new file called `config.json` with the following configuration:

```json
{
  "mcpServers": {
    "mcp": {
      "url": "http://localhost:7860/gradio_api/mcp/sse"
    }
  }
}
```

This configuration allows your UI client to communicate with the Gradio MCP server using the MCP protocol, enabling seamless integration between your frontend and the MCP service.

## Configuring an MCP Client within Cursor IDE

Cursor provides built-in MCP support, allowing you to connect your deployed MCP servers directly to your development environment.

### Configuration

Open Cursor settings (`Ctrl + Shift + J` / `Cmd + Shift + J`) → **Tools & Integrations** tab → **Add Custom MCP**:

**macOS:**
```json
{
  "mcpServers": {
    "sentiment-analysis": {
      "command": "npx",
      "args": [
        "-y", 
        "mcp-remote", 
        "https://YOURUSENAME-mcp-sentiment.hf.space/gradio_api/mcp/sse", 
        "--transport", 
        "sse-only"
      ]
    }
  }
}
```

**Windows:**
```json
{
  "mcpServers": {
    "sentiment-analysis": {
      "command": "cmd",
      "args": [
        "/c", 
        "npx", 
        "-y", 
        "mcp-remote", 
        "https://YOURUSENAME-mcp-sentiment.hf.space/gradio_api/mcp/sse", 
        "--transport", 
        "sse-only"
      ]
    }
  }
}
```

### Why We Use `mcp-remote`

> **Note**: As of mid-2025, Cursor supports direct remote MCP connections via HTTP+SSE and OAuth. You may not need `mcp-remote` unless working with legacy setups or encountering specific compatibility issues.

Earlier versions of MCP clients, including Cursor, only supported local servers via `stdio` transport and lacked support for remote servers with authentication. The `mcp-remote` tool was introduced as a workaround that:

- Runs locally on your machine  
- Bridges Cursor with remote MCP servers  
- Handles transport and authentication implicitly  
- Uses the familiar configuration file format

While this is still useful in some edge cases, Cursor now supports native remote MCP integration. You can directly configure a remote server like this:

```json
{
  "mcpServers": {
    "my-server": {
      "url": "https://your-mcp-server.hf.space/gradio_api/mcp/sse"
    }
  }
}
```
> See [Cursor’s official documentation](https://docs.cursor.com/context/mcp) for up-to-date setup instructions.

Once configured, you can ask Cursor to use your sentiment analysis tool for tasks like analyzing code comments, user feedback, or pull request descriptions.


<EditOnGithub source="https://github.com/huggingface/mcp-course/blob/main/units/en/unit2/clients.mdx" />