# Configuration

The configuration classes are the way to specify how a task should be done. There are two tasks supported with the ONNX Runtime package:

1. Optimization: Performed by the [ORTOptimizer](/docs/optimum/main/en/onnxruntime/package_reference/optimization#optimum.onnxruntime.ORTOptimizer), this task can be tweaked using an [OptimizationConfig](/docs/optimum/main/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.OptimizationConfig).

2. Quantization: Performed by the [ORTQuantizer](/docs/optimum/main/en/onnxruntime/package_reference/quantization#optimum.onnxruntime.ORTQuantizer), quantization can be set using a [QuantizationConfig](/docs/optimum/main/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig). A calibration step is required in some cases (post training static quantization), which can be specified using a [CalibrationConfig](/docs/optimum/main/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.CalibrationConfig).

## OptimizationConfig[[optimum.onnxruntime.OptimizationConfig]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.onnxruntime.OptimizationConfig</name><anchor>optimum.onnxruntime.OptimizationConfig</anchor><source>https://github.com/huggingface/optimum-onnx/blob/main/optimum/onnxruntime/configuration.py#L709</source><parameters>[{"name": "optimization_level", "val": ": int = 1"}, {"name": "enable_transformers_specific_optimizations", "val": ": bool = True"}, {"name": "optimize_for_gpu", "val": ": bool = False"}, {"name": "fp16", "val": ": bool = False"}, {"name": "disable_gelu_fusion", "val": ": bool = False"}, {"name": "disable_attention_fusion", "val": ": bool = False"}, {"name": "disable_bias_gelu_fusion", "val": ": bool = False"}, {"name": "disable_layer_norm_fusion", "val": ": bool = False"}, {"name": "disable_rotary_embeddings", "val": ": bool = False"}, {"name": "disable_skip_layer_norm_fusion", "val": ": bool = False"}, {"name": "disable_bias_skip_layer_norm_fusion", "val": ": bool = False"}, {"name": "disable_skip_group_norm_fusion", "val": ": bool = False"}, {"name": "disable_bias_splitgelu_fusion", "val": ": bool = False"}, {"name": "disable_bias_add_fusion", "val": ": bool = False"}, {"name": "disable_group_norm_fusion", "val": ": bool = True"}, {"name": "disable_embed_layer_norm_fusion", "val": ": bool = True"}, {"name": "enable_gemm_fast_gelu_fusion", "val": ": bool = False"}, {"name": "use_mask_index", "val": ": bool = False"}, {"name": "disable_packed_kv", "val": ": bool = True"}, {"name": "no_attention_mask", "val": ": bool = False"}, {"name": "use_raw_attention_mask", "val": ": bool = False"}, {"name": "disable_shape_inference", "val": ": bool = False"}, {"name": "use_multi_head_attention", "val": ": bool = False"}, {"name": "enable_gelu_approximation", "val": ": bool = False"}, {"name": "use_group_norm_channels_first", "val": ": bool = False"}, {"name": "disable_packed_qkv", "val": ": bool = False"}, {"name": "disable_nhwc_conv", "val": ": bool = False"}]</parameters><paramsdesc>- **optimization_level** (`int`, defaults to 1) --
  Optimization level performed by ONNX Runtime of the loaded graph.
  Supported optimization level are 0, 1, 2 and 99.
  - 0: will disable all optimizations
  - 1: will enable basic optimizations
  - 2: will enable basic and extended optimizations, including complex node fusions applied to the nodes
  assigned to the CPU or CUDA execution provider, making the resulting optimized graph hardware dependent
  - 99: will enable all available optimizations including layout optimizations
- **optimize_for_gpu** (`bool`, defaults to `False`) --
  Whether to optimize the model for GPU inference.
  The optimized graph might contain operators for GPU or CPU only when `optimization_level` > 1.
- **fp16** (`bool`, defaults to `False`) --
  Whether all weights and nodes should be converted from float32 to float16.
- **enable_transformers_specific_optimizations** (`bool`, defaults to `True`) --
  Whether to only use `transformers` specific optimizations on top of ONNX Runtime general optimizations.
- **disable_gelu_fusion** (`bool`, defaults to `False`) --
  Whether to disable the Gelu fusion.
- **disable_layer_norm_fusion** (`bool`, defaults to `False`) --
  Whether to disable Layer Normalization fusion.
- **disable_attention_fusion** (`bool`, defaults to `False`) --
  Whether to disable Attention fusion.
- **disable_skip_layer_norm_fusion** (`bool`, defaults to `False`) --
  Whether to disable SkipLayerNormalization fusion.
- **disable_bias_skip_layer_norm_fusion** (`bool`, defaults to `False`) --
  Whether to disable Add Bias and SkipLayerNormalization fusion.
- **disable_bias_gelu_fusion** (`bool`, defaults to `False`) --
  Whether to disable Add Bias and Gelu / FastGelu fusion.
- **disable_embed_layer_norm_fusion** (`bool`, defaults to `True`) --
  Whether to disable EmbedLayerNormalization fusion.
  The default value is set to `True` since this fusion is incompatible with ONNX Runtime quantization.
- **enable_gelu_approximation** (`bool`, defaults to `False`) --
  Whether to enable Gelu / BiasGelu to FastGelu conversion.
  The default value is set to `False` since this approximation might slightly impact the model's accuracy.
- **use_mask_index** (`bool`, defaults to `False`) --
  Whether to use mask index instead of raw attention mask in the attention operator.
- **no_attention_mask** (`bool`, defaults to `False`) --
  Whether to not use attention masks. Only works for bert model type.
- **disable_embed_layer_norm** (`bool`, defaults to `True`) --
  Whether to disable EmbedLayerNormalization fusion.
  The default value is set to `True` since this fusion is incompatible with ONNX Runtime quantization
- **disable_shape_inference** (`bool`, defaults to `False`) --
  Whether to disable symbolic shape inference.
  The default value is set to `False` but symbolic shape inference might cause issues sometimes.
- **use_multi_head_attention** (`bool`, defaults to `False`) --
  Experimental argument. Use MultiHeadAttention instead of Attention operator, which has merged weights for Q/K/V projection,
  which might be faster in some cases since 3 MatMul is merged into one."
  "Note that MultiHeadAttention might be slower than Attention when qkv are not packed. "
- **enable_gemm_fast_gelu_fusion** (`bool`, defaults to `False`) --
  Enable GemmfastGelu fusion.
- **use_raw_attention_mask** (`bool`, defaults to `False`) --
  Use raw attention mask. Use this option if your input is not right-side padding. This might deactivate fused attention and get worse performance.
- **disable_group_norm_fusion** (`bool`, defaults to `True`) --
  Do not fuse GroupNorm. Only works for model_type=unet.
- **disable_packed_kv** (`bool`, defaults to `True`) --
  Do not use packed kv in cross attention. Only works for model_type=unet.
- **disable_rotary_embeddings** (`bool`, defaults to `False`) --
  Whether to disable Rotary Embedding fusion.</paramsdesc><paramgroups>0</paramgroups></docstring>
OptimizationConfig is the configuration class handling all the ONNX Runtime optimization parameters.
There are two stacks of optimizations:
1. The ONNX Runtime general-purpose optimization tool: it can work on any ONNX model.
2. The ONNX Runtime transformers optimization tool: it can only work on a subset of transformers models.




</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.onnxruntime.AutoOptimizationConfig</name><anchor>optimum.onnxruntime.AutoOptimizationConfig</anchor><source>https://github.com/huggingface/optimum-onnx/blob/main/optimum/onnxruntime/configuration.py#L823</source><parameters>[]</parameters></docstring>
Factory to create common `OptimizationConfig`.


<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>O1</name><anchor>optimum.onnxruntime.AutoOptimizationConfig.O1</anchor><source>https://github.com/huggingface/optimum-onnx/blob/main/optimum/onnxruntime/configuration.py#L880</source><parameters>[{"name": "for_gpu", "val": ": bool = False"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **for_gpu** (`bool`, defaults to `False`) --
  Whether the model to optimize will run on GPU, some optimizations depends on the hardware the model
  will run on. Only needed for optimization_level > 1.
- **kwargs** (`Dict[str, Any]`) --
  Arguments to provide to the `~OptimizationConfig` constructor.</paramsdesc><paramgroups>0</paramgroups><rettype>`OptimizationConfig`</rettype><retdesc>The `OptimizationConfig` corresponding to the O1 optimization level.</retdesc></docstring>
Creates an O1 `~OptimizationConfig`.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>O2</name><anchor>optimum.onnxruntime.AutoOptimizationConfig.O2</anchor><source>https://github.com/huggingface/optimum-onnx/blob/main/optimum/onnxruntime/configuration.py#L896</source><parameters>[{"name": "for_gpu", "val": ": bool = False"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **for_gpu** (`bool`, defaults to `False`) --
  Whether the model to optimize will run on GPU, some optimizations depends on the hardware the model
  will run on. Only needed for optimization_level > 1.
- **kwargs** (`Dict[str, Any]`) --
  Arguments to provide to the `~OptimizationConfig` constructor.</paramsdesc><paramgroups>0</paramgroups><rettype>`OptimizationConfig`</rettype><retdesc>The `OptimizationConfig` corresponding to the O2 optimization level.</retdesc></docstring>
Creates an O2 `~OptimizationConfig`.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>O3</name><anchor>optimum.onnxruntime.AutoOptimizationConfig.O3</anchor><source>https://github.com/huggingface/optimum-onnx/blob/main/optimum/onnxruntime/configuration.py#L912</source><parameters>[{"name": "for_gpu", "val": ": bool = False"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **for_gpu** (`bool`, defaults to `False`) --
  Whether the model to optimize will run on GPU, some optimizations depends on the hardware the model
  will run on. Only needed for optimization_level > 1.
- **kwargs** (`Dict[str, Any]`) --
  Arguments to provide to the `~OptimizationConfig` constructor.</paramsdesc><paramgroups>0</paramgroups><rettype>`OptimizationConfig`</rettype><retdesc>The `OptimizationConfig` corresponding to the O3 optimization level.</retdesc></docstring>
Creates an O3 `~OptimizationConfig`.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>O4</name><anchor>optimum.onnxruntime.AutoOptimizationConfig.O4</anchor><source>https://github.com/huggingface/optimum-onnx/blob/main/optimum/onnxruntime/configuration.py#L928</source><parameters>[{"name": "for_gpu", "val": ": bool = True"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **for_gpu** (`bool`, defaults to `False`) --
  Whether the model to optimize will run on GPU, some optimizations depends on the hardware the model
  will run on. Only needed for optimization_level > 1.
- **kwargs** (`Dict[str, Any]`) --
  Arguments to provide to the `~OptimizationConfig` constructor.</paramsdesc><paramgroups>0</paramgroups><rettype>`OptimizationConfig`</rettype><retdesc>The `OptimizationConfig` corresponding to the O4 optimization level.</retdesc></docstring>
Creates an O4 `~OptimizationConfig`.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>with_optimization_level</name><anchor>optimum.onnxruntime.AutoOptimizationConfig.with_optimization_level</anchor><source>https://github.com/huggingface/optimum-onnx/blob/main/optimum/onnxruntime/configuration.py#L848</source><parameters>[{"name": "optimization_level", "val": ": str"}, {"name": "for_gpu", "val": ": bool = False"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **optimization_level** (`str`) --
  The optimization level, the following values are allowed:
  - O1: Basic general optimizations
  - O2: Basic and extended general optimizations, transformers-specific fusions.
  - O3: Same as O2 with Fast Gelu approximation.
  - O4: Same as O3 with mixed precision.
- **for_gpu** (`bool`, defaults to `False`) --
  Whether the model to optimize will run on GPU, some optimizations depends on the hardware the model
  will run on. Only needed for optimization_level > 1.
- **kwargs** (`Dict[str, Any]`) --
  Arguments to provide to the `~OptimizationConfig` constructor.</paramsdesc><paramgroups>0</paramgroups><rettype>`OptimizationConfig`</rettype><retdesc>The `OptimizationConfig` corresponding to the requested optimization level.</retdesc></docstring>
Creates an `~OptimizationConfig` with pre-defined arguments according to an optimization level.








</div></div>

## QuantizationConfig[[optimum.onnxruntime.QuantizationConfig]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.onnxruntime.QuantizationConfig</name><anchor>optimum.onnxruntime.QuantizationConfig</anchor><source>https://github.com/huggingface/optimum-onnx/blob/main/optimum/onnxruntime/configuration.py#L225</source><parameters>[{"name": "is_static", "val": ": bool"}, {"name": "format", "val": ": QuantFormat"}, {"name": "mode", "val": ": QuantizationMode = <QuantizationMode.QLinearOps: 1>"}, {"name": "activations_dtype", "val": ": QuantType = <QuantType.QUInt8: 1>"}, {"name": "activations_symmetric", "val": ": bool = False"}, {"name": "weights_dtype", "val": ": QuantType = <QuantType.QInt8: 0>"}, {"name": "weights_symmetric", "val": ": bool = True"}, {"name": "per_channel", "val": ": bool = False"}, {"name": "reduce_range", "val": ": bool = False"}, {"name": "nodes_to_quantize", "val": ": list[str] = <factory>"}, {"name": "nodes_to_exclude", "val": ": list[str] = <factory>"}, {"name": "operators_to_quantize", "val": ": list[str] = <factory>"}, {"name": "qdq_add_pair_to_weight", "val": ": bool = False"}, {"name": "qdq_dedicated_pair", "val": ": bool = False"}, {"name": "qdq_op_type_per_channel_support_to_axis", "val": ": dict[str, int] = <factory>"}]</parameters><paramsdesc>- **is_static** (`bool`) --
  Whether to apply static quantization or dynamic quantization.
- **format** (`QuantFormat`) --
  Targeted ONNX Runtime quantization representation format.
  For the Operator Oriented (QOperator) format, all the quantized operators have their own ONNX definitions.
  For the Tensor Oriented (QDQ) format, the model is quantized by inserting QuantizeLinear / DeQuantizeLinear
  operators.
- **mode** (`QuantizationMode`, defaults to `QuantizationMode.QLinearOps`) --
  Targeted ONNX Runtime quantization mode, default is QLinearOps to match QDQ format.
  When targeting dynamic quantization mode, the default value is `QuantizationMode.IntegerOps` whereas the
  default value for static quantization mode is `QuantizationMode.QLinearOps`.
- **activations_dtype** (`QuantType`, defaults to `QuantType.QUInt8`) --
  The quantization data types to use for the activations.
- **activations_symmetric** (`bool`, defaults to `False`) --
  Whether to apply symmetric quantization on the activations.
- **weights_dtype** (`QuantType`, defaults to `QuantType.QInt8`) --
  The quantization data types to use for the weights.
- **weights_symmetric** (`bool`, defaults to `True`) --
  Whether to apply symmetric quantization on the weights.
- **per_channel** (`bool`, defaults to `False`) --
  Whether we should quantize per-channel (also known as "per-row"). Enabling this can increase overall
  accuracy while making the quantized model heavier.
- **reduce_range** (`bool`, defaults to `False`) --
  Whether to use reduce-range 7-bits integers instead of 8-bits integers.
- **nodes_to_quantize** (`List[str]`, defaults to `[]`) --
  List of the nodes names to quantize. When unspecified, all nodes will be quantized. If empty, all nodes being operators from `operators_to_quantize` will be quantized.
- **nodes_to_exclude** (`List[str]`, defaults to `[]`) --
  List of the nodes names to exclude when applying quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with [netron](https://github.com/lutzroeder/netron).
- **operators_to_quantize** (`List[str]`) --
  List of the operators types to quantize. Defaults to all quantizable operators for the given quantization mode and format. Quantizable operators can be found at https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py.
- **qdq_add_pair_to_weight** (`bool`, defaults to `False`) --
  By default, floating-point weights are quantized and feed to solely inserted DeQuantizeLinear node.
  If set to True, the floating-point weights will remain and both QuantizeLinear / DeQuantizeLinear nodes
  will be inserted.
- **qdq_dedicated_pair** (`bool`, defaults to `False`) --
  When inserting QDQ pair, multiple nodes can share a single QDQ pair as their inputs. If True, it will
  create an identical and dedicated QDQ pair for each node.
- **qdq_op_type_per_channel_support_to_axis** (`Dict[str, int]`) --
  Set the channel axis for a specific operator type. Effective only when per channel quantization is
  supported and `per_channel` is set to True.</paramsdesc><paramgroups>0</paramgroups></docstring>
QuantizationConfig is the configuration class handling all the ONNX Runtime quantization parameters.




</div>

## AutoQuantizationConfig[[optimum.onnxruntime.AutoQuantizationConfig]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.onnxruntime.AutoQuantizationConfig</name><anchor>optimum.onnxruntime.AutoQuantizationConfig</anchor><source>https://github.com/huggingface/optimum-onnx/blob/main/optimum/onnxruntime/configuration.py#L388</source><parameters>[]</parameters></docstring>



<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>arm64</name><anchor>optimum.onnxruntime.AutoQuantizationConfig.arm64</anchor><source>https://github.com/huggingface/optimum-onnx/blob/main/optimum/onnxruntime/configuration.py#L389</source><parameters>[{"name": "is_static", "val": ": bool"}, {"name": "use_symmetric_activations", "val": ": bool = False"}, {"name": "use_symmetric_weights", "val": ": bool = True"}, {"name": "per_channel", "val": ": bool = True"}, {"name": "nodes_to_quantize", "val": ": list[str] | None = None"}, {"name": "nodes_to_exclude", "val": ": list[str] | None = None"}, {"name": "operators_to_quantize", "val": ": list[str] | None = None"}]</parameters><paramsdesc>- **is_static** (`bool`) --
  Boolean flag to indicate whether we target static or dynamic quantization.
- **use_symmetric_activations** (`bool`, defaults to `False`) --
  Whether to use symmetric quantization for activations.
- **use_symmetric_weights** (`bool`, defaults to `True`) --
  Whether to use symmetric quantization for weights.
- **per_channel** (`bool`, defaults to `True`) --
  Whether we should quantize per-channel (also known as "per-row"). Enabling this can
  increase overall accuracy while making the quantized model heavier.
- **nodes_to_quantize** (`Optional[List[str]]`, defaults to `None`) --
  Specific nodes to quantize. If `None`, all nodes being operators from `operators_to_quantize` will be quantized.
- **nodes_to_exclude** (`Optional[List[str]]`, defaults to `None`) --
  Specific nodes to exclude from quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with [netron](https://github.com/lutzroeder/netron).
- **operators_to_quantize** (`Optional[List[str]]`, defaults to `None`) --
  Type of nodes to perform quantization on. By default, all the quantizable operators will be quantized. Quantizable operators can be found at https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py.</paramsdesc><paramgroups>0</paramgroups></docstring>
Creates a [QuantizationConfig](/docs/optimum/main/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig) fit for ARM64.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>avx2</name><anchor>optimum.onnxruntime.AutoQuantizationConfig.avx2</anchor><source>https://github.com/huggingface/optimum-onnx/blob/main/optimum/onnxruntime/configuration.py#L439</source><parameters>[{"name": "is_static", "val": ": bool"}, {"name": "use_symmetric_activations", "val": ": bool = False"}, {"name": "use_symmetric_weights", "val": ": bool = True"}, {"name": "per_channel", "val": ": bool = True"}, {"name": "reduce_range", "val": ": bool = False"}, {"name": "nodes_to_quantize", "val": ": list[str] | None = None"}, {"name": "nodes_to_exclude", "val": ": list[str] | None = None"}, {"name": "operators_to_quantize", "val": ": list[str] | None = None"}]</parameters><paramsdesc>- **is_static** (`bool`) --
  Boolean flag to indicate whether we target static or dynamic quantization.
- **use_symmetric_activations** (`bool`, defaults to `False`) --
  Whether to use symmetric quantization for activations.
- **use_symmetric_weights** (`bool`, defaults to `True`) --
  Whether to use symmetric quantization for weights.
- **per_channel** (`bool`, defaults to `True`) --
  Whether we should quantize per-channel (also known as "per-row"). Enabling this can
  increase overall accuracy while making the quantized model heavier.
- **reduce_range** (`bool`, defaults to `False`) --
  Indicate whether to use 8-bits integers (False) or reduce-range 7-bits integers (True).
  As a baseline, it is always recommended testing with full range (reduce_range = False) and then, if
  accuracy drop is significant, to try with reduced range (reduce_range = True).
  Intel's CPUs using AVX512 (non VNNI) can suffer from saturation issue when invoking
  the VPMADDUBSW instruction. To counter this, one should use 7-bits rather than 8-bits integers.
- **nodes_to_quantize** (`Optional[List[str]]`, defaults to `None`) --
  Specific nodes to quantize. If `None`, all nodes being operators from `operators_to_quantize` will be quantized.
- **nodes_to_exclude** (`Optional[List[str]]`, defaults to `None`) --
  Specific nodes to exclude from quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with [netron](https://github.com/lutzroeder/netron).
- **operators_to_quantize** (`Optional[List[str]]`, defaults to `None`) --
  Type of nodes to perform quantization on. By default, all the quantizable operators will be quantized. Quantizable operators can be found at https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py.</paramsdesc><paramgroups>0</paramgroups></docstring>
Creates a [QuantizationConfig](/docs/optimum/main/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig) fit for CPU with AVX2 instruction set.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>avx512</name><anchor>optimum.onnxruntime.AutoQuantizationConfig.avx512</anchor><source>https://github.com/huggingface/optimum-onnx/blob/main/optimum/onnxruntime/configuration.py#L494</source><parameters>[{"name": "is_static", "val": ": bool"}, {"name": "use_symmetric_activations", "val": ": bool = False"}, {"name": "use_symmetric_weights", "val": ": bool = True"}, {"name": "per_channel", "val": ": bool = True"}, {"name": "reduce_range", "val": ": bool = False"}, {"name": "nodes_to_quantize", "val": ": list[str] | None = None"}, {"name": "nodes_to_exclude", "val": ": list[str] | None = None"}, {"name": "operators_to_quantize", "val": ": list[str] | None = None"}]</parameters><paramsdesc>- **is_static** (`bool`) --
  Boolean flag to indicate whether we target static or dynamic quantization.
- **use_symmetric_activations** (`bool`, defaults to `False`) --
  Whether to use symmetric quantization for activations.
- **use_symmetric_weights** (`bool`, defaults to `True`) --
  Whether to use symmetric quantization for weights.
- **per_channel** (`bool`, defaults to `True`) --
  Whether we should quantize per-channel (also known as "per-row"). Enabling this can
  increase overall accuracy while making the quantized model heavier.
- **reduce_range** (`bool`, defaults to `False`) --
  Indicate whether to use 8-bits integers (False) or reduce-range 7-bits integers (True).
  As a baseline, it is always recommended testing with full range (reduce_range = False) and then, if
  accuracy drop is significant, to try with reduced range (reduce_range = True).
  Intel's CPUs using AVX512 (non VNNI) can suffer from saturation issue when invoking
  the VPMADDUBSW instruction. To counter this, one should use 7-bits rather than 8-bits integers.
- **nodes_to_quantize** (`Optional[List[str]]`, defaults to `None`) --
  Specific nodes to quantize. If `None`, all nodes being operators from `operators_to_quantize` will be quantized.
- **nodes_to_exclude** (`Optional[List[str]]`, defaults to `None`) --
  Specific nodes to exclude from quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with [netron](https://github.com/lutzroeder/netron).
- **operators_to_quantize** (`Optional[List[str]]`, defaults to `None`) --
  Type of nodes to perform quantization on. By default, all the quantizable operators will be quantized. Quantizable operators can be found at https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py.</paramsdesc><paramgroups>0</paramgroups></docstring>
Creates a [QuantizationConfig](/docs/optimum/main/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig) fit for CPU with AVX512 instruction set.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>avx512_vnni</name><anchor>optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni</anchor><source>https://github.com/huggingface/optimum-onnx/blob/main/optimum/onnxruntime/configuration.py#L549</source><parameters>[{"name": "is_static", "val": ": bool"}, {"name": "use_symmetric_activations", "val": ": bool = False"}, {"name": "use_symmetric_weights", "val": ": bool = True"}, {"name": "per_channel", "val": ": bool = True"}, {"name": "nodes_to_quantize", "val": ": list[str] | None = None"}, {"name": "nodes_to_exclude", "val": ": list[str] | None = None"}, {"name": "operators_to_quantize", "val": ": list[str] | None = None"}]</parameters><paramsdesc>- **is_static** (`bool`) --
  Boolean flag to indicate whether we target static or dynamic quantization.
- **use_symmetric_activations** (`bool`, defaults to `False`) --
  Whether to use symmetric quantization for activations.
- **use_symmetric_weights** (`bool`, defaults to `True`) --
  Whether to use symmetric quantization for weights.
- **per_channel** (`bool`, defaults to `True`) --
  Whether we should quantize per-channel (also known as "per-row"). Enabling this can
  increase overall accuracy while making the quantized model heavier.
- **nodes_to_quantize** (`Optional[List[str]]`, defaults to `None`) --
  Specific nodes to quantize. If `None`, all nodes being operators from `operators_to_quantize` will be quantized.
- **nodes_to_exclude** (`Optional[List[str]]`, defaults to `None`) --
  Specific nodes to exclude from quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with [netron](https://github.com/lutzroeder/netron).
- **operators_to_quantize** (`Optional[List[str]]`, defaults to `None`) --
  Type of nodes to perform quantization on. By default, all the quantizable operators will be quantized. Quantizable operators can be found at https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py.</paramsdesc><paramgroups>0</paramgroups></docstring>
Creates a [QuantizationConfig](/docs/optimum/main/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig) fit for CPU with AVX512-VNNI instruction set.

When targeting Intel AVX512-VNNI CPU underlying execution engine leverage the CPU instruction VPDPBUSD to
compute  \\i32 += i8(w) * u8(x)\\ within a single instruction.

AVX512-VNNI (AVX512 Vector Neural Network Instruction)
is an x86 extension Instruction set and is a part of the AVX-512 ISA.

AVX512 VNNI is designed to accelerate convolutional neural network for INT8 inference.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>ppc64le</name><anchor>optimum.onnxruntime.AutoQuantizationConfig.ppc64le</anchor><source>https://github.com/huggingface/optimum-onnx/blob/main/optimum/onnxruntime/configuration.py#L605</source><parameters>[{"name": "is_static", "val": ": bool"}, {"name": "use_symmetric_activations", "val": ": bool = False"}, {"name": "use_symmetric_weights", "val": ": bool = True"}, {"name": "per_channel", "val": ": bool = True"}, {"name": "nodes_to_quantize", "val": ": list[str] | None = None"}, {"name": "nodes_to_exclude", "val": ": list[str] | None = None"}, {"name": "operators_to_quantize", "val": ": list[str] | None = None"}]</parameters><paramsdesc>- **is_static** (`bool`) --
  Boolean flag to indicate whether we target static or dynamic quantization.
- **use_symmetric_activations** (`bool`, defaults to `False`) --
  Whether to use symmetric quantization for activations.
- **use_symmetric_weights** (`bool`, defaults to `True`) --
  Whether to use symmetric quantization for weights.
- **per_channel** (`bool`, defaults to `True`) --
  Whether we should quantize per-channel (also known as "per-row"). Enabling this can
  increase overall accuracy while making the quantized model heavier.
- **nodes_to_quantize** (`Optional[List[str]]`, defaults to `None`) --
  Specific nodes to quantize. If `None`, all nodes being operators from `operators_to_quantize` will be quantized.
- **nodes_to_exclude** (`Optional[List[str]]`, defaults to `None`) --
  Specific nodes to exclude from quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with [netron](https://github.com/lutzroeder/netron).
- **operators_to_quantize** (`Optional[List[str]]`, defaults to `None`) --
  Type of nodes to perform quantization on. By default, all the quantizable operators will be quantized. Quantizable operators can be found at https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py.</paramsdesc><paramgroups>0</paramgroups></docstring>
Creates a [QuantizationConfig](/docs/optimum/main/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig) fit for ppc64le.

When targeting IBM POWER10 ppc64le, the underlying execution engine leverages 8-bit outer-product instructions
(e.g., xvi8ger4pp and signed/unsigned variants) to compute fused byte dot-products and accumulate into 32-bit results, i.e.,
i32 += i8(w) * u8(x) at 4-way granularity per output element within a single instruction using a 512-bit MMA accumulator.

MMA (Matrix-Multiply Assist) is a POWER10 extension of the Power ISA and is part of the Power ISA v3.1 specification,
exposed via VSX-backed 512-bit accumulators and compiler intrinsics.

POWER10 MMA 8-bit outer-product instructions are designed to accelerate INT8 inference on ppc64le by fusing
multiply-accumulate data paths and minimizing instruction count.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>tensorrt</name><anchor>optimum.onnxruntime.AutoQuantizationConfig.tensorrt</anchor><source>https://github.com/huggingface/optimum-onnx/blob/main/optimum/onnxruntime/configuration.py#L663</source><parameters>[{"name": "per_channel", "val": ": bool = True"}, {"name": "nodes_to_quantize", "val": ": list[str] | None = None"}, {"name": "nodes_to_exclude", "val": ": list[str] | None = None"}, {"name": "operators_to_quantize", "val": ": list[str] | None = None"}]</parameters><paramsdesc>- **per_channel** (`bool`, defaults to `True`) --
  Whether we should quantize per-channel (also known as "per-row"). Enabling this can
  increase overall accuracy while making the quantized model heavier.
- **nodes_to_quantize** (`Optional[List[str]]`, defaults to `None`) --
  Specific nodes to quantize. If `None`, all nodes being operators from `operators_to_quantize` will be quantized.
- **nodes_to_exclude** (`Optional[List[str]]`, defaults to `None`) --
  Specific nodes to exclude from quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with [netron](https://github.com/lutzroeder/netron).
- **operators_to_quantize** (`Optional[List[str]]`, defaults to `None`) --
  Type of nodes to perform quantization on. By default, all the quantizable operators will be quantized. Quantizable operators can be found at https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py.</paramsdesc><paramgroups>0</paramgroups></docstring>
Creates a [QuantizationConfig](/docs/optimum/main/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig) fit for TensorRT static quantization, targeting NVIDIA GPUs.




</div></div>

### CalibrationConfig[[optimum.onnxruntime.CalibrationConfig]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.onnxruntime.CalibrationConfig</name><anchor>optimum.onnxruntime.CalibrationConfig</anchor><source>https://github.com/huggingface/optimum-onnx/blob/main/optimum/onnxruntime/configuration.py#L52</source><parameters>[{"name": "dataset_name", "val": ": str"}, {"name": "dataset_config_name", "val": ": str"}, {"name": "dataset_split", "val": ": str"}, {"name": "dataset_num_samples", "val": ": int"}, {"name": "method", "val": ": CalibrationMethod"}, {"name": "num_bins", "val": ": int | None = None"}, {"name": "num_quantized_bins", "val": ": int | None = None"}, {"name": "percentile", "val": ": float | None = None"}, {"name": "moving_average", "val": ": bool | None = None"}, {"name": "averaging_constant", "val": ": float | None = None"}]</parameters><paramsdesc>- **dataset_name** (`str`) --
  The name of the calibration dataset.
- **dataset_config_name** (`str`) --
  The name of the calibration dataset configuration.
- **dataset_split** (`str`) --
  Which split of the dataset is used to perform the calibration step.
- **dataset_num_samples** (`int`) --
  The number of samples composing the calibration dataset.
- **method** (`CalibrationMethod`) --
  The method chosen to calculate the activations quantization parameters using the calibration dataset.
- **num_bins** (`Optional[int]`, defaults to `None`) --
  The number of bins to use when creating the histogram when performing the calibration step using the
  Percentile or Entropy method.
- **num_quantized_bins** (`Optional[int]`, defaults to `None`) --
  The number of quantized bins to use when performing the calibration step using the Entropy method.
- **percentile** (`Optional[float]`, defaults to `None`) --
  The percentile to use when computing the activations quantization ranges when performing the calibration
  step using the Percentile method.
- **moving_average** (`Optional[bool]`, defaults to `None`) --
  Whether to compute the moving average of the minimum and maximum values when performing the calibration step
  using the MinMax method.
- **averaging_constant** (`Optional[float]`, defaults to `None`) --
  The constant smoothing factor to use when computing the moving average of the minimum and maximum values.
  Effective only when the MinMax calibration method is selected and `moving_average` is set to True.</paramsdesc><paramgroups>0</paramgroups></docstring>
CalibrationConfig is the configuration class handling all the ONNX Runtime parameters related to the calibration
step of static quantization.




</div>

## ORTConfig[[optimum.onnxruntime.ORTConfig]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.onnxruntime.ORTConfig</name><anchor>optimum.onnxruntime.ORTConfig</anchor><source>https://github.com/huggingface/optimum-onnx/blob/main/optimum/onnxruntime/configuration.py#L945</source><parameters>[{"name": "opset", "val": ": int | None = None"}, {"name": "use_external_data_format", "val": ": bool = False"}, {"name": "one_external_file", "val": ": bool = True"}, {"name": "optimization", "val": ": OptimizationConfig | None = None"}, {"name": "quantization", "val": ": QuantizationConfig | None = None"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **opset** (`Optional[int]`, defaults to `None`) --
  ONNX opset version to export the model with.
- **use_external_data_format** (`bool`, defaults to `False`) --
  Allow exporting model >= than 2Gb.
- **one_external_file** (`bool`, defaults to `True`) --
  When `use_external_data_format=True`, whether to save all tensors to one external file.
  If false, save each tensor to a file named with the tensor name.
  (Can not be set to `False` for the quantization)
- **optimization** (`Optional[OptimizationConfig]`, defaults to `None`) --
  Specify a configuration to optimize ONNX Runtime model
- **quantization** (`Optional[QuantizationConfig]`, defaults to `None`) --
  Specify a configuration to quantize ONNX Runtime model</paramsdesc><paramgroups>0</paramgroups></docstring>
ORTConfig is the configuration class handling all the ONNX Runtime parameters related to the ONNX IR model export,
optimization and quantization parameters.




</div>