import{s as Qt,b as qt,n as Zt,o as Gt}from"../chunks/scheduler.aec39e6a.js";import{S as Nt,i as Et,e as i,s,c as o,h as _t,a as r,d as a,b as n,f as Wt,g as p,j as m,k as f,l as xt,m as l,n as u,t as M,o as y,p as d}from"../chunks/index.4ee0a2d0.js";import{C as At,H as A,E as Ht}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.0729134f.js";import{C as Ut}from"../chunks/CodeBlock.9cdf99e9.js";function Ft(ft){let c,V,H,X,w,R,h,Y,J,z,j,wt='Amazon SageMaker JumpStart lets you deploy the most-popular open Hugging Face models with one click—inside your own AWS account. JumpStart offers a curated <a href="https://aws.amazon.com/sagemaker-ai/jumpstart/getting-started/?sagemaker-jumpstart-cards.sort-by=item.additionalFields.model-name&amp;sagemaker-jumpstart-cards.sort-order=asc&amp;awsf.sagemaker-jumpstart-filter-product-type=*all&amp;awsf.sagemaker-jumpstart-filter-text=*all&amp;awsf.sagemaker-jumpstart-filter-vision=*all&amp;awsf.sagemaker-jumpstart-filter-tabular=*all&amp;awsf.sagemaker-jumpstart-filter-audio-tasks=*all&amp;awsf.sagemaker-jumpstart-filter-multimodal=*all&amp;awsf.sagemaker-jumpstart-filter-RL=*all&amp;awsm.page-sagemaker-jumpstart-cards=1&amp;sagemaker-jumpstart-cards.q=qwen&amp;sagemaker-jumpstart-cards.q_operator=AND" rel="nofollow">selection</a> of model checkpoints for various tasks, including text generation, embeddings, vision, audio, and more. Most models are deployed using the official <a href="https://huggingface.co/docs/sagemaker/main/en/dlcs/introduction" rel="nofollow">Hugging Face Deep Learning Containers</a> with a sensible default instance type, so you can move from idea to production in minutes.',L,C,ht='In this quickstart guide, we will deploy <a href="https://huggingface.co/Qwen/Qwen2.5-14B-Instruct" rel="nofollow">Qwen/Qwen2.5-14B-Instruct</a>.',P,T,D,k,Jt='<thead><tr><th></th> <th>Requirement</th></tr></thead> <tbody><tr><td>AWS account with SageMaker enabled</td> <td>An AWS account that will contain all your AWS resources.</td></tr> <tr><td>An IAM role to access SageMaker AI</td> <td>Learn more about how IAM works with SageMaker AI in this <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam.html" rel="nofollow">guide</a>.</td></tr> <tr><td>SageMaker Studio domain and user profile</td> <td>We recommend using SageMaker Studio for straightforward deployment and inference. Follow this <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/onboard-quick-start.html" rel="nofollow">guide</a>.</td></tr> <tr><td>Service quotas</td> <td>Most LLMs need GPU instances (e.g. ml.g5). Verify you have quota for <code>ml.g5.24xlarge</code> or <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/canvas-requesting-quota-increases.html" rel="nofollow">request it</a>.</td></tr></tbody>',O,b,K,$,jt="Let’s explain how you would deploy a Hugging Face model to SageMaker browsing through the Jumpstart catalog:",tt,I,Ct="<li>Open SageMaker → JumpStart.</li> <li>Filter “Hugging Face” or search for your model (e.g. Qwen2.5-14B).</li> <li>Click Deploy → (optional) adjust instance size / count → Deploy.</li> <li>Wait until Endpoints shows In service.</li> <li>Copy the Endpoint name (or ARN) for later use.</li>",et,g,Tt,at,S,kt="Alternatively, you can also browse through the Hugging Face Model Hub:",lt,B,bt="<li>Open the model page → Click Deploy → SageMaker → Jumpstart tab if model is available.</li> <li>Copy the code snippet and use it from a SageMaker Notebook instance.</li>",st,U,$t,nt,v,it,q,It="The endpoint creation can take several minutes, depending on the size of the model.",rt,W,ot,Q,St="If you deployed through the console, you need to grab the endpoint ARN and reuse in your code.",pt,Z,mt,G,Bt="The endpoint support the Open AI API specification.",ut,N,Mt,E,vt="To avoid incurring unnecessary costs, when you’re done, delete the SageMaker endpoints in the Deployments → Endpoints console or using the following code snippets:",yt,_,dt,x,ct,F,gt;return w=new At({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),h=new A({props:{title:"Quickstart - Deploy Hugging Face Models with SageMaker Jumpstart",local:"quickstart---deploy-hugging-face-models-with-sagemaker-jumpstart",headingTag:"h1"}}),J=new A({props:{title:"Why use SageMaker JumpStart for Hugging Face models?",local:"why-use-sagemaker-jumpstart-for-hugging-face-models",headingTag:"h2"}}),T=new A({props:{title:"1. Prerequisites",local:"1-prerequisites",headingTag:"h2"}}),b=new A({props:{title:"2· Endpoint deployment",local:"2-endpoint-deployment",headingTag:"h2"}}),v=new Ut({props:{code:"JTIzJTIwU2FnZU1ha2VyJTIwSnVtcFN0YXJ0JTIwcHJvdmlkZXMlMjBBUElzJTIwYXMlMjBwYXJ0JTIwb2YlMjBTYWdlTWFrZXIlMjBTREslMjB0aGF0JTIwYWxsb3clMjB5b3UlMjB0byUyMGRlcGxveSUyMGFuZCUyMGZpbmUtdHVuZSUyMG1vZGVscyUyMGluJTIwbmV0d29yayUyMGlzb2xhdGlvbiUyMHVzaW5nJTIwc2NyaXB0cyUyMHRoYXQlMjBTYWdlTWFrZXIlMjBtYWludGFpbnMuJTBBJTBBZnJvbSUyMHNhZ2VtYWtlci5qdW1wc3RhcnQubW9kZWwlMjBpbXBvcnQlMjBKdW1wU3RhcnRNb2RlbCUwQSUwQSUwQW1vZGVsJTIwJTNEJTIwSnVtcFN0YXJ0TW9kZWwobW9kZWxfaWQlM0QlMjJodWdnaW5nZmFjZS1sbG0tcXdlbjItNS0xNGItaW5zdHJ1Y3QlMjIpJTBBZXhhbXBsZV9wYXlsb2FkcyUyMCUzRCUyMG1vZGVsLnJldHJpZXZlX2FsbF9leGFtcGxlcygpJTBBJTBBcHJlZGljdG9yJTIwJTNEJTIwbW9kZWwuZGVwbG95KCklMEElMEFmb3IlMjBwYXlsb2FkJTIwaW4lMjBleGFtcGxlX3BheWxvYWRzJTNBJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBwcmVkaWN0b3IucHJlZGljdChwYXlsb2FkLmJvZHkpJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIySW5wdXQlM0ElNUNuJTIyJTJDJTIwcGF5bG9hZC5ib2R5JTVCcGF5bG9hZC5wcm9tcHRfa2V5JTVEKSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMk91dHB1dCUzQSU1Q24lMjIlMkMlMjByZXNwb25zZSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCUyQyUyMCUyMiU1Q24lNUNuJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTVDbiUyMik=",highlighted:`<span class="hljs-comment"># SageMaker JumpStart provides APIs as part of SageMaker SDK that allow you to deploy and fine-tune models in network isolation using scripts that SageMaker maintains.</span>

<span class="hljs-keyword">from</span> sagemaker.jumpstart.model <span class="hljs-keyword">import</span> JumpStartModel


model = JumpStartModel(model_id=<span class="hljs-string">&quot;huggingface-llm-qwen2-5-14b-instruct&quot;</span>)
example_payloads = model.retrieve_all_examples()

predictor = model.deploy()

<span class="hljs-keyword">for</span> payload <span class="hljs-keyword">in</span> example_payloads:
    response = predictor.predict(payload.body)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Input:\\n&quot;</span>, payload.body[payload.prompt_key])
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Output:\\n&quot;</span>, response[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>], <span class="hljs-string">&quot;\\n\\n===============\\n&quot;</span>)`,wrap:!1}}),W=new A({props:{title:"3. Test interactively",local:"3-test-interactively",headingTag:"h2"}}),Z=new Ut({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5wcmVkaWN0b3IlMjBpbXBvcnQlMjByZXRyaWV2ZV9kZWZhdWx0JTBBZW5kcG9pbnRfbmFtZSUyMCUzRCUyMCUyMk1ZJTIwRU5EUE9JTlQlMjBOQU1FJTIyJTBBcHJlZGljdG9yJTIwJTNEJTIwcmV0cmlldmVfZGVmYXVsdChlbmRwb2ludF9uYW1lKSUwQXBheWxvYWQlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMHBhc3Npb25hdGUlMjBkYXRhJTIwc2NpZW50aXN0LiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMndoYXQlMjBpcyUyMG1hY2hpbmUlMjBsZWFybmluZyUzRiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMm1heF90b2tlbnMlMjIlM0ElMjAyMDQ4JTJDJTBBJTIwJTIwJTIwJTIwJTIydGVtcGVyYXR1cmUlMjIlM0ElMjAwLjclMkMlMEElMjAlMjAlMjAlMjAlMjJ0b3BfcCUyMiUzQSUyMDAuOSUyQyUwQSUyMCUyMCUyMCUyMCUyMnN0cmVhbSUyMiUzQSUyMEZhbHNlJTBBJTdEJTBBJTBBcmVzcG9uc2UlMjAlM0QlMjBwcmVkaWN0b3IucHJlZGljdChwYXlsb2FkKSUwQXByaW50KHJlc3BvbnNlKQ==",highlighted:`<span class="hljs-keyword">from</span> sagemaker.predictor <span class="hljs-keyword">import</span> retrieve_default
endpoint_name = <span class="hljs-string">&quot;MY ENDPOINT NAME&quot;</span>
predictor = retrieve_default(endpoint_name)
payload = {
    <span class="hljs-string">&quot;messages&quot;</span>: [
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a passionate data scientist.&quot;</span>
        },
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;what is machine learning?&quot;</span>
        }
    ],
    <span class="hljs-string">&quot;max_tokens&quot;</span>: <span class="hljs-number">2048</span>,
    <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>,
    <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">0.9</span>,
    <span class="hljs-string">&quot;stream&quot;</span>: <span class="hljs-literal">False</span>
}

response = predictor.predict(payload)
<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),N=new A({props:{title:"4. Clean‑up",local:"4-cleanup",headingTag:"h2"}}),_=new Ut({props:{code:"cHJlZGljdG9yLmRlbGV0ZV9tb2RlbCgpJTBBcHJlZGljdG9yLmRlbGV0ZV9lbmRwb2ludCgp",highlighted:`predictor.delete_model()
predictor.delete_endpoint()`,wrap:!1}}),x=new Ht({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/sagemaker/source/tutorials/jumpstart/jumpstart-quickstart.md"}}),{c(){c=i("meta"),V=s(),H=i("p"),X=s(),o(w.$$.fragment),R=s(),o(h.$$.fragment),Y=s(),o(J.$$.fragment),z=s(),j=i("p"),j.innerHTML=wt,L=s(),C=i("p"),C.innerHTML=ht,P=s(),o(T.$$.fragment),D=s(),k=i("table"),k.innerHTML=Jt,O=s(),o(b.$$.fragment),K=s(),$=i("p"),$.textContent=jt,tt=s(),I=i("ol"),I.innerHTML=Ct,et=s(),g=i("img"),at=s(),S=i("p"),S.textContent=kt,lt=s(),B=i("ol"),B.innerHTML=bt,st=s(),U=i("img"),nt=s(),o(v.$$.fragment),it=s(),q=i("p"),q.textContent=It,rt=s(),o(W.$$.fragment),ot=s(),Q=i("p"),Q.textContent=St,pt=s(),o(Z.$$.fragment),mt=s(),G=i("p"),G.textContent=Bt,ut=s(),o(N.$$.fragment),Mt=s(),E=i("p"),E.textContent=vt,yt=s(),o(_.$$.fragment),dt=s(),o(x.$$.fragment),ct=s(),F=i("p"),this.h()},l(t){const e=_t("svelte-u9bgzb",document.head);c=r(e,"META",{name:!0,content:!0}),e.forEach(a),V=n(t),H=r(t,"P",{}),Wt(H).forEach(a),X=n(t),p(w.$$.fragment,t),R=n(t),p(h.$$.fragment,t),Y=n(t),p(J.$$.fragment,t),z=n(t),j=r(t,"P",{"data-svelte-h":!0}),m(j)!=="svelte-c323bq"&&(j.innerHTML=wt),L=n(t),C=r(t,"P",{"data-svelte-h":!0}),m(C)!=="svelte-glhkwk"&&(C.innerHTML=ht),P=n(t),p(T.$$.fragment,t),D=n(t),k=r(t,"TABLE",{"data-svelte-h":!0}),m(k)!=="svelte-170vxk4"&&(k.innerHTML=Jt),O=n(t),p(b.$$.fragment,t),K=n(t),$=r(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-el0n8y"&&($.textContent=jt),tt=n(t),I=r(t,"OL",{"data-svelte-h":!0}),m(I)!=="svelte-7ng80t"&&(I.innerHTML=Ct),et=n(t),g=r(t,"IMG",{src:!0,alt:!0,width:!0}),at=n(t),S=r(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1lzsyqk"&&(S.textContent=kt),lt=n(t),B=r(t,"OL",{"data-svelte-h":!0}),m(B)!=="svelte-vh08fk"&&(B.innerHTML=bt),st=n(t),U=r(t,"IMG",{src:!0,alt:!0,width:!0}),nt=n(t),p(v.$$.fragment,t),it=n(t),q=r(t,"P",{"data-svelte-h":!0}),m(q)!=="svelte-knhstf"&&(q.textContent=It),rt=n(t),p(W.$$.fragment,t),ot=n(t),Q=r(t,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-v65zqa"&&(Q.textContent=St),pt=n(t),p(Z.$$.fragment,t),mt=n(t),G=r(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-r63eq3"&&(G.textContent=Bt),ut=n(t),p(N.$$.fragment,t),Mt=n(t),E=r(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-t814jl"&&(E.textContent=vt),yt=n(t),p(_.$$.fragment,t),dt=n(t),p(x.$$.fragment,t),ct=n(t),F=r(t,"P",{}),Wt(F).forEach(a),this.h()},h(){f(c,"name","hf:doc:metadata"),f(c,"content",Vt),qt(g.src,Tt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/sagemaker/jumpstart-deployment.gif")||f(g,"src",Tt),f(g,"alt","JumpStart deployment demo"),f(g,"width","500"),qt(U.src,$t="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/sagemaker/hf-jumpstart-deployment.gif")||f(U,"src",$t),f(U,"alt","JumpStart deployment demo"),f(U,"width","500")},m(t,e){xt(document.head,c),l(t,V,e),l(t,H,e),l(t,X,e),u(w,t,e),l(t,R,e),u(h,t,e),l(t,Y,e),u(J,t,e),l(t,z,e),l(t,j,e),l(t,L,e),l(t,C,e),l(t,P,e),u(T,t,e),l(t,D,e),l(t,k,e),l(t,O,e),u(b,t,e),l(t,K,e),l(t,$,e),l(t,tt,e),l(t,I,e),l(t,et,e),l(t,g,e),l(t,at,e),l(t,S,e),l(t,lt,e),l(t,B,e),l(t,st,e),l(t,U,e),l(t,nt,e),u(v,t,e),l(t,it,e),l(t,q,e),l(t,rt,e),u(W,t,e),l(t,ot,e),l(t,Q,e),l(t,pt,e),u(Z,t,e),l(t,mt,e),l(t,G,e),l(t,ut,e),u(N,t,e),l(t,Mt,e),l(t,E,e),l(t,yt,e),u(_,t,e),l(t,dt,e),u(x,t,e),l(t,ct,e),l(t,F,e),gt=!0},p:Zt,i(t){gt||(M(w.$$.fragment,t),M(h.$$.fragment,t),M(J.$$.fragment,t),M(T.$$.fragment,t),M(b.$$.fragment,t),M(v.$$.fragment,t),M(W.$$.fragment,t),M(Z.$$.fragment,t),M(N.$$.fragment,t),M(_.$$.fragment,t),M(x.$$.fragment,t),gt=!0)},o(t){y(w.$$.fragment,t),y(h.$$.fragment,t),y(J.$$.fragment,t),y(T.$$.fragment,t),y(b.$$.fragment,t),y(v.$$.fragment,t),y(W.$$.fragment,t),y(Z.$$.fragment,t),y(N.$$.fragment,t),y(_.$$.fragment,t),y(x.$$.fragment,t),gt=!1},d(t){t&&(a(V),a(H),a(X),a(R),a(Y),a(z),a(j),a(L),a(C),a(P),a(D),a(k),a(O),a(K),a($),a(tt),a(I),a(et),a(g),a(at),a(S),a(lt),a(B),a(st),a(U),a(nt),a(it),a(q),a(rt),a(ot),a(Q),a(pt),a(mt),a(G),a(ut),a(Mt),a(E),a(yt),a(dt),a(ct),a(F)),a(c),d(w,t),d(h,t),d(J,t),d(T,t),d(b,t),d(v,t),d(W,t),d(Z,t),d(N,t),d(_,t),d(x,t)}}}const Vt='{"title":"Quickstart - Deploy Hugging Face Models with SageMaker Jumpstart","local":"quickstart---deploy-hugging-face-models-with-sagemaker-jumpstart","sections":[{"title":"Why use SageMaker JumpStart for Hugging Face models?","local":"why-use-sagemaker-jumpstart-for-hugging-face-models","sections":[],"depth":2},{"title":"1. Prerequisites","local":"1-prerequisites","sections":[],"depth":2},{"title":"2· Endpoint deployment","local":"2-endpoint-deployment","sections":[],"depth":2},{"title":"3. Test interactively","local":"3-test-interactively","sections":[],"depth":2},{"title":"4. Clean‑up","local":"4-cleanup","sections":[],"depth":2}],"depth":1}';function Xt(ft){return Gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pt extends Nt{constructor(c){super(),Et(this,c,Xt,Ft,Qt,{})}}export{Pt as component};
