import{s as Tn,b as rs,n as wn,o as Jn}from"../chunks/scheduler.aec39e6a.js";import{S as hn,i as fn,e as M,s as n,c as r,h as bn,a as o,d as t,b as a,f as ml,g as p,j as i,k as U,l as In,m as s,n as y,t as d,o as m,p as c}from"../chunks/index.4ee0a2d0.js";import{C as gn,H as J,E as Cn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.0729134f.js";import{C as u}from"../chunks/CodeBlock.9cdf99e9.js";function Zn(ps){let h,cl,yl,ul,I,Ul,g,jl,C,ys="Deploying a 🤗 Transformers models in SageMaker for inference is as easy as:",Tl,Z,wl,B,ds='This guide will show you how to deploy models with zero-code using the <a href="https://github.com/aws/sagemaker-huggingface-inference-toolkit" rel="nofollow">Inference Toolkit</a>. The Inference Toolkit builds on top of the <a href="https://huggingface.co/docs/transformers/main_classes/pipelines" rel="nofollow"><code>pipeline</code> feature</a> from 🤗 Transformers. Learn how to:',Jl,k,ms='<li><a href="#installation-and-setup">Install and setup the Inference Toolkit</a>.</li> <li><a href="#deploy-a-transformer-model-trained-in-sagemaker">Deploy a 🤗 Transformers model trained in SageMaker</a>.</li> <li><a href="#deploy-a-model-from-the-hub">Deploy a 🤗 Transformers model from the Hugging Face [model Hub](https://huggingface.co/models)</a>.</li> <li><a href="#run-batch-transform-with-transformers-and-sagemaker">Run a Batch Transform Job using 🤗 Transformers and Amazon SageMaker</a>.</li> <li><a href="#user-defined-code-and-modules">Create a custom inference module</a>.</li>',hl,G,fl,W,cs='Before deploying a 🤗 Transformers model to SageMaker, you need to sign up for an AWS account. If you don’t have an AWS account yet, learn more <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-set-up.html" rel="nofollow">here</a>.',bl,A,us="Once you have an AWS account, get started using one of the following:",Il,v,Us='<li><a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-studio-onboard.html" rel="nofollow">SageMaker Studio</a></li> <li><a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-console.html" rel="nofollow">SageMaker notebook instance</a></li> <li>Local environment</li>',gl,$,js='To start training locally, you need to setup an appropriate <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html" rel="nofollow">IAM role</a>.',Cl,_,Ts="Upgrade to the latest <code>sagemaker</code> version.",Zl,S,Bl,H,ws="<strong>SageMaker environment</strong>",kl,R,Js="Setup your SageMaker environment as shown below:",Gl,E,Wl,x,hs="<em>Note: The execution role is only available when running a notebook within SageMaker. If you run <code>get_execution_role</code> in a notebook not on SageMaker, expect a <code>region</code> error.</em>",Al,V,fs="<strong>Local environment</strong>",vl,Y,bs="Setup your local environment as shown below:",$l,z,_l,N,Sl,j,Is,Hl,F,gs="There are two ways to deploy your Hugging Face model trained in SageMaker:",Rl,X,Cs="<li>Deploy it after your training has finished.</li> <li>Deploy your saved model at a later time from S3 with the <code>model_data</code>.</li>",El,Q,Zs='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/10_deploy_model_from_s3/deploy_transformer_model_from_s3.ipynb" rel="nofollow">deploy_transformer_model_from_s3.ipynb notebook</a> for an example of how to deploy a model from S3 to SageMaker for inference.',xl,L,Vl,q,Bs="To deploy your model directly after training, ensure all required files are saved in your training script, including the tokenizer and the model.",Yl,P,ks="If you use the Hugging Face <code>Trainer</code>, you can pass your tokenizer as an argument to the <code>Trainer</code>. It will be automatically saved when you call <code>trainer.save_model()</code>.",zl,D,Nl,K,Gs="After you run your request you can delete the endpoint as shown:",Fl,O,Xl,ee,Ql,le,Ws="If you’ve already trained your model and want to deploy it at a later time, use the <code>model_data</code> argument to specify the location of your tokenizer and model weights.",Ll,te,ql,se,As="After you run our request, you can delete the endpoint again with:",Pl,ne,Dl,ae,Kl,Me,vs="For later deployment, you can create a <code>model.tar.gz</code> file that contains all the required files, such as:",Ol,oe,$s="<li><code>pytorch_model.bin</code></li> <li><code>tf_model.h5</code></li> <li><code>tokenizer.json</code></li> <li><code>tokenizer_config.json</code></li>",et,ie,_s="For example, your file should look like this:",lt,re,tt,pe,Ss="Create your own <code>model.tar.gz</code> from a model from the 🤗 Hub:",st,ye,Hs="<li>Download a model:</li>",nt,de,at,f,Rs="<li>Create a <code>tar</code> file:</li>",Mt,me,ot,b,Es="<li>Upload <code>model.tar.gz</code> to S3:</li>",it,ce,rt,ue,xs="Now you can provide the S3 URI to the <code>model_data</code> argument to deploy your model later.",pt,Ue,yt,T,Vs,dt,je,Ys="To deploy a model directly from the 🤗 Hub to SageMaker, define two environment variables when you create a <code>HuggingFaceModel</code>:",mt,Te,zs='<li><code>HF_MODEL_ID</code> defines the model ID which is automatically loaded from <a href="http://huggingface.co/models" rel="nofollow">huggingface.co/models</a> when you create a SageMaker endpoint. Access 10,000+ models on he 🤗 Hub through this environment variable.</li> <li><code>HF_TASK</code> defines the task for the 🤗 Transformers <code>pipeline</code>. A complete list of tasks can be found <a href="https://huggingface.co/docs/transformers/main_classes/pipelines" rel="nofollow">here</a>.</li>',ct,we,Ns='<p>⚠️ ** Pipelines are not optimized for parallelism (multi-threading) and tend to consume a lot of RAM. For example, on a GPU-based instance, the pipeline operates on a single vCPU. When this vCPU becomes saturated with the inference requests preprocessing, it can create a bottleneck, preventing the GPU from being fully utilized for model inference. Learn more <a href="https://huggingface.co/docs/transformers/en/pipeline_webserver#using-pipelines-for-a-webserver" rel="nofollow">here</a></p>',ut,Je,Ut,he,Fs="After you run our request, you can delete the endpoint again with:",jt,fe,Tt,be,Xs='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/11_deploy_model_from_hf_hub/deploy_transformer_model_from_hf_hub.ipynb" rel="nofollow">deploy_transformer_model_from_hf_hub.ipynb notebook</a> for an example of how to deploy a model from the 🤗 Hub to SageMaker for inference.',wt,Ie,Jt,w,Qs,ht,ge,Ls='After training a model, you can use <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works-batch.html" rel="nofollow">SageMaker batch transform</a> to perform inference with the model. Batch transform accepts your inference data as an S3 URI  and then SageMaker will take care of downloading the data, running the prediction, and uploading the results to S3. For more details about batch transform, take a look <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html" rel="nofollow">here</a>.',ft,Ce,qs="⚠️ The Hugging Face Inference DLC currently only supports <code>.jsonl</code> for batch transform due to the complex structure of textual data.",bt,Ze,Ps="<em>Note: Make sure your <code>inputs</code> fit the <code>max_length</code> of the model during preprocessing.</em>",It,Be,Ds='If you trained a model using the Hugging Face Estimator, call the <code>transformer()</code> method to create a transform job for a model based on the training job (see <a href="https://sagemaker.readthedocs.io/en/stable/overview.html#sagemaker-batch-transform" rel="nofollow">here</a> for more details):',gt,ke,Ct,Ge,Ks="If you want to run your batch transform job later or with a model from the 🤗 Hub, create a <code>HuggingFaceModel</code> instance and then call the <code>transformer()</code> method:",Zt,We,Bt,Ae,Os="The <code>input.jsonl</code> looks like this:",kt,ve,Gt,$e,en='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/12_batch_transform_inference/sagemaker-notebook.ipynb" rel="nofollow">sagemaker-notebook.ipynb notebook</a> for an example of how to run a batch transform job for inference.',Wt,_e,At,Se,ln='If you are interested in using a high-performance serving container for LLMs, you can use the Hugging Face TGI container. This utilizes the <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">Text Generation Inference</a> library. A list of compatible models can be found <a href="https://huggingface.co/docs/text-generation-inference/supported_models#supported-models" rel="nofollow">here</a>.',vt,He,tn="First, make sure that the latest version of SageMaker SDK is installed:",$t,Re,_t,Ee,sn="Then, we import the SageMaker Python SDK and instantiate a sagemaker_session to find the current region and execution role.",St,xe,Ht,Ve,nn="Next we retrieve the LLM image URI. We use the helper function get_huggingface_llm_image_uri() to generate the appropriate image URI for the Hugging Face Large Language Model (LLM) inference. The function takes a required parameter backend and several optional parameters. The backend specifies the type of backend to use for the model:  “huggingface” refers to using Hugging Face TGI backend.",Rt,Ye,Et,ze,an="Now that we have the image uri, the next step is to configure the model object. We specify a unique name, the image_uri for the managed TGI container, and the execution role for the endpoint. Additionally, we specify a number of environment variables including the <code>HF_MODEL_ID</code> which corresponds to the model from the HuggingFace Hub that will be deployed, and the <code>HF_TASK</code> which configures the inference task to be performed by the model.",xt,Ne,Mn="You should also define <code>SM_NUM_GPUS</code>, which specifies the tensor parallelism degree of the model. Tensor parallelism can be used to split the model across multiple GPUs, which is necessary when working with LLMs that are too big for a single GPU. To learn more about tensor parallelism with inference, see our previous blog post. Here, you should set <code>SM_NUM_GPUS</code> to the number of available GPUs on your selected instance type. For example, in this tutorial, we set <code>SM_NUM_GPUS</code> to 4 because our selected instance type ml.g4dn.12xlarge has 4 available GPUs.",Vt,Fe,on="Note that you can optionally reduce the memory and computational footprint of the model by setting the <code>HF_MODEL_QUANTIZE</code> environment variable to <code>true</code>, but this lower weight precision could affect the quality of the output for some models.",Yt,Xe,zt,Qe,rn="Next, we invoke the deploy method to deploy the model.",Nt,Le,Ft,qe,pn="Once the model is deployed, we can invoke it to generate text. We pass an input prompt and run the predict method to generate a text response from the LLM running in the TGI container.",Xt,Pe,Qt,De,yn="We receive the following auto-generated text response:",Lt,Ke,qt,Oe,dn="Once we are done experimenting, we delete the endpoint and the model resources.",Pt,el,Dt,ll,Kt,tl,mn='The Hugging Face Inference Toolkit allows the user to override the default methods of the <code>HuggingFaceHandlerService</code>. You will need to create a folder named <code>code/</code> with an <code>inference.py</code> file in it. See <a href="#create-a-model-artifact-for-deployment">here</a> for more details on how to archive your model artifacts. For example:',Ot,sl,es,nl,cn="The <code>inference.py</code> file contains your custom inference module, and the <code>requirements.txt</code> file contains additional dependencies that should be added. The custom module can override the following methods:",ls,al,un="<li><code>model_fn(model_dir)</code> overrides the default method for loading a model. The return value <code>model</code> will be used in <code>predict</code> for predictions. <code>predict</code> receives argument the <code>model_dir</code>, the path to your unzipped <code>model.tar.gz</code>.</li> <li><code>transform_fn(model, data, content_type, accept_type)</code> overrides the default transform function with your custom implementation. You will need to implement your own <code>preprocess</code>, <code>predict</code> and <code>postprocess</code> steps in the <code>transform_fn</code>. This method can’t be combined with <code>input_fn</code>, <code>predict_fn</code> or <code>output_fn</code> mentioned below.</li> <li><code>input_fn(input_data, content_type)</code> overrides the default method for preprocessing. The return value <code>data</code> will be used in <code>predict</code> for predictions. The inputs are:<ul><li><code>input_data</code> is the raw body of your request.</li> <li><code>content_type</code> is the content type from the request header.</li></ul></li> <li><code>predict_fn(processed_data, model)</code> overrides the default method for predictions. The return value <code>predictions</code> will be used in <code>postprocess</code>. The input is <code>processed_data</code>, the result from <code>preprocess</code>.</li> <li><code>output_fn(prediction, accept)</code> overrides the default method for postprocessing. The return value <code>result</code> will be the response of your request (e.g.<code>JSON</code>). The inputs are:<ul><li><code>predictions</code> is the result from <code>predict</code>.</li> <li><code>accept</code> is the return accept type from the HTTP Request, e.g. <code>application/json</code>.</li></ul></li>",ts,Ml,Un="Here is an example of a custom inference module with <code>model_fn</code>, <code>input_fn</code>, <code>predict_fn</code>, and <code>output_fn</code>:",ss,ol,ns,il,jn="Customize your inference module with only <code>model_fn</code> and <code>transform_fn</code>:",as,rl,Ms,pl,os,dl,is;return I=new gn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new J({props:{title:"Deploy models to Amazon SageMaker",local:"deploy-models-to-amazon-sagemaker",headingTag:"h1"}}),Z=new u({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlTW9kZWwlMEElMEElMjMlMjBjcmVhdGUlMjBIdWdnaW5nJTIwRmFjZSUyME1vZGVsJTIwQ2xhc3MlMjBhbmQlMjBkZXBsb3klMjBpdCUyMGFzJTIwU2FnZU1ha2VyJTIwZW5kcG9pbnQlMEFodWdnaW5nZmFjZV9tb2RlbCUyMCUzRCUyMEh1Z2dpbmdGYWNlTW9kZWwoLi4uKS5kZXBsb3koKQ==",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># create Hugging Face Model Class and deploy it as SageMaker endpoint</span>
huggingface_model = HuggingFaceModel(...).deploy()`,wrap:!1}}),G=new J({props:{title:"Installation and setup",local:"installation-and-setup",headingTag:"h2"}}),S=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNhZ2VtYWtlciUyMC0tdXBncmFkZQ==",highlighted:"pip install sagemaker --upgrade",wrap:!1}}),E=new u({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBc2VzcyUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCklMEFyb2xlJTIwJTNEJTIwc2FnZW1ha2VyLmdldF9leGVjdXRpb25fcm9sZSgp",highlighted:`<span class="hljs-keyword">import</span> sagemaker
sess = sagemaker.Session()
role = sagemaker.get_execution_role()`,wrap:!1}}),z=new u({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBaW1wb3J0JTIwYm90bzMlMEElMEFpYW1fY2xpZW50JTIwJTNEJTIwYm90bzMuY2xpZW50KCdpYW0nKSUwQXJvbGUlMjAlM0QlMjBpYW1fY2xpZW50LmdldF9yb2xlKFJvbGVOYW1lJTNEJ3JvbGUtbmFtZS1vZi15b3VyLWlhbS1yb2xlLXdpdGgtcmlnaHQtcGVybWlzc2lvbnMnKSU1QidSb2xlJyU1RCU1QidBcm4nJTVEJTBBc2VzcyUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCk=",highlighted:`<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3

iam_client = boto3.client(<span class="hljs-string">&#x27;iam&#x27;</span>)
role = iam_client.get_role(RoleName=<span class="hljs-string">&#x27;role-name-of-your-iam-role-with-right-permissions&#x27;</span>)[<span class="hljs-string">&#x27;Role&#x27;</span>][<span class="hljs-string">&#x27;Arn&#x27;</span>]
sess = sagemaker.Session()`,wrap:!1}}),N=new J({props:{title:"Deploy a 🤗 Transformers model trained in SageMaker",local:"deploy-a--transformers-model-trained-in-sagemaker",headingTag:"h2"}}),L=new J({props:{title:"Deploy after training",local:"deploy-after-training",headingTag:"h3"}}),D=new u({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlJTBBJTBBJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIwcHNldWRvJTIwY29kZSUyMHN0YXJ0JTIwJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTBBJTBBJTIzJTIwY3JlYXRlJTIwSHVnZ2luZyUyMEZhY2UlMjBFc3RpbWF0b3IlMjBmb3IlMjB0cmFpbmluZyUwQWh1Z2dpbmdmYWNlX2VzdGltYXRvciUyMCUzRCUyMEh1Z2dpbmdGYWNlKC4uLi4pJTBBJTBBJTIzJTIwc3RhcnQlMjB0aGUlMjB0cmFpbiUyMGpvYiUyMHdpdGglMjBvdXIlMjB1cGxvYWRlZCUyMGRhdGFzZXRzJTIwYXMlMjBpbnB1dCUwQWh1Z2dpbmdmYWNlX2VzdGltYXRvci5maXQoLi4uKSUwQSUwQSUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMHBzZXVkbyUyMGNvZGUlMjBlbmQlMjAlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMEElMEElMjMlMjBkZXBsb3klMjBtb2RlbCUyMHRvJTIwU2FnZU1ha2VyJTIwSW5mZXJlbmNlJTBBcHJlZGljdG9yJTIwJTNEJTIwaGZfZXN0aW1hdG9yLmRlcGxveShpbml0aWFsX2luc3RhbmNlX2NvdW50JTNEMSUyQyUyMGluc3RhbmNlX3R5cGUlM0QlMjJtbC5tNS54bGFyZ2UlMjIpJTBBJTBBJTIzJTIwZXhhbXBsZSUyMHJlcXVlc3QlM0ElMjB5b3UlMjBhbHdheXMlMjBuZWVkJTIwdG8lMjBkZWZpbmUlMjAlMjJpbnB1dHMlMjIlMEFkYXRhJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyQ2FtZXJhJTIwLSUyMFlvdSUyMGFyZSUyMGF3YXJkZWQlMjBhJTIwU2lQaXglMjBEaWdpdGFsJTIwQ2FtZXJhISUyMGNhbGwlMjAwOTA2MTIyMTA2NiUyMGZyb20lMjBsYW5kbGluZS4lMjBEZWxpdmVyeSUyMHdpdGhpbiUyMDI4JTIwZGF5cy4lMjIlMEElN0QlMEElMEElMjMlMjByZXF1ZXN0JTBBcHJlZGljdG9yLnByZWRpY3QoZGF0YSk=",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFace

<span class="hljs-comment">############ pseudo code start ############</span>

<span class="hljs-comment"># create Hugging Face Estimator for training</span>
huggingface_estimator = HuggingFace(....)

<span class="hljs-comment"># start the train job with our uploaded datasets as input</span>
huggingface_estimator.fit(...)

<span class="hljs-comment">############ pseudo code end ############</span>

<span class="hljs-comment"># deploy model to SageMaker Inference</span>
predictor = hf_estimator.deploy(initial_instance_count=<span class="hljs-number">1</span>, instance_type=<span class="hljs-string">&quot;ml.m5.xlarge&quot;</span>)

<span class="hljs-comment"># example request: you always need to define &quot;inputs&quot;</span>
data = {
   <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;Camera - You are awarded a SiPix Digital Camera! call 09061221066 from landline. Delivery within 28 days.&quot;</span>
}

<span class="hljs-comment"># request</span>
predictor.predict(data)`,wrap:!1}}),O=new u({props:{code:"JTIzJTIwZGVsZXRlJTIwZW5kcG9pbnQlMEFwcmVkaWN0b3IuZGVsZXRlX2VuZHBvaW50KCk=",highlighted:`<span class="hljs-comment"># delete endpoint</span>
predictor.delete_endpoint()`,wrap:!1}}),ee=new J({props:{title:"Deploy with model_data",local:"deploy-with-modeldata",headingTag:"h3"}}),te=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface.model <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># create Hugging Face Model Class</span>
huggingface_model = HuggingFaceModel(
   model_data=<span class="hljs-string">&quot;s3://models/my-bert-model/model.tar.gz&quot;</span>,  <span class="hljs-comment"># path to your trained SageMaker model</span>
   role=role,                                            <span class="hljs-comment"># IAM role with permissions to create an endpoint</span>
   transformers_version=<span class="hljs-string">&quot;4.26&quot;</span>,                           <span class="hljs-comment"># Transformers version used</span>
   pytorch_version=<span class="hljs-string">&quot;1.13&quot;</span>,                                <span class="hljs-comment"># PyTorch version used</span>
   py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,                                    <span class="hljs-comment"># Python version used</span>
)

<span class="hljs-comment"># deploy model to SageMaker Inference</span>
predictor = huggingface_model.deploy(
   initial_instance_count=<span class="hljs-number">1</span>,
   instance_type=<span class="hljs-string">&quot;ml.m5.xlarge&quot;</span>
)

<span class="hljs-comment"># example request: you always need to define &quot;inputs&quot;</span>
data = {
   <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;Camera - You are awarded a SiPix Digital Camera! call 09061221066 from landline. Delivery within 28 days.&quot;</span>
}

<span class="hljs-comment"># request</span>
predictor.predict(data)`,wrap:!1}}),ne=new u({props:{code:"JTIzJTIwZGVsZXRlJTIwZW5kcG9pbnQlMEFwcmVkaWN0b3IuZGVsZXRlX2VuZHBvaW50KCk=",highlighted:`<span class="hljs-comment"># delete endpoint</span>
predictor.delete_endpoint()`,wrap:!1}}),ae=new J({props:{title:"Create a model artifact for deployment",local:"create-a-model-artifact-for-deployment",headingTag:"h3"}}),re=new u({props:{code:"bW9kZWwudGFyLmd6JTJGJTBBJTdDLSUyMHB5dG9yY2hfbW9kZWwuYmluJTBBJTdDLSUyMHZvY2FiLnR4dCUwQSU3Qy0lMjB0b2tlbml6ZXJfY29uZmlnLmpzb24lMEElN0MtJTIwY29uZmlnLmpzb24lMEElN0MtJTIwc3BlY2lhbF90b2tlbnNfbWFwLmpzb24=",highlighted:`model.tar.gz/
|- pytorch_model.bin
|- vocab.txt
|- tokenizer_config.json
|- config.json
|- special_tokens_map.json`,wrap:!1}}),de=new u({props:{code:"Z2l0JTIwbGZzJTIwaW5zdGFsbCUwQWdpdCUyMGNsb25lJTIwZ2l0JTQwaGYuY28lM0ElN0JyZXBvc2l0b3J5JTdE",highlighted:`git lfs install
git <span class="hljs-built_in">clone</span> git@hf.co:{repository}`,wrap:!1}}),me=new u({props:{code:"Y2QlMjAlN0JyZXBvc2l0b3J5JTdEJTBBdGFyJTIwemN2ZiUyMG1vZGVsLnRhci5neiUyMCo=",highlighted:`<span class="hljs-built_in">cd</span> {repository}
tar zcvf model.tar.gz *`,wrap:!1}}),ce=new u({props:{code:"YXdzJTIwczMlMjBjcCUyMG1vZGVsLnRhci5neiUyMCUzQ3MzJTNBJTJGJTJGJTdCbXktczMtcGF0aCU3RCUzRQ==",highlighted:'aws s3 <span class="hljs-built_in">cp</span> model.tar.gz &lt;s3://{my-s3-path}&gt;',wrap:!1}}),Ue=new J({props:{title:"Deploy a model from the 🤗 Hub",local:"deploy-a-model-from-the--hub",headingTag:"h2"}}),Je=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface.model <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># Hub model configuration &lt;https://huggingface.co/models&gt;</span>
hub = {
  <span class="hljs-string">&#x27;HF_MODEL_ID&#x27;</span>:<span class="hljs-string">&#x27;distilbert-base-uncased-distilled-squad&#x27;</span>, <span class="hljs-comment"># model_id from hf.co/models</span>
  <span class="hljs-string">&#x27;HF_TASK&#x27;</span>:<span class="hljs-string">&#x27;question-answering&#x27;</span>                           <span class="hljs-comment"># NLP task you want to use for predictions</span>
}

<span class="hljs-comment"># create Hugging Face Model Class</span>
huggingface_model = HuggingFaceModel(
   env=hub,                                                <span class="hljs-comment"># configuration for loading model from Hub</span>
   role=role,                                              <span class="hljs-comment"># IAM role with permissions to create an endpoint</span>
   transformers_version=<span class="hljs-string">&quot;4.26&quot;</span>,                             <span class="hljs-comment"># Transformers version used</span>
   pytorch_version=<span class="hljs-string">&quot;1.13&quot;</span>,                                  <span class="hljs-comment"># PyTorch version used</span>
   py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,                                      <span class="hljs-comment"># Python version used</span>
)

<span class="hljs-comment"># deploy model to SageMaker Inference</span>
predictor = huggingface_model.deploy(
   initial_instance_count=<span class="hljs-number">1</span>,
   instance_type=<span class="hljs-string">&quot;ml.m5.xlarge&quot;</span>
)

<span class="hljs-comment"># example request: you always need to define &quot;inputs&quot;</span>
data = {
<span class="hljs-string">&quot;inputs&quot;</span>: {
	<span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;What is used for inference?&quot;</span>,
	<span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;My Name is Philipp and I live in Nuremberg. This model is used with sagemaker for inference.&quot;</span>
	}
}

<span class="hljs-comment"># request</span>
predictor.predict(data)`,wrap:!1}}),fe=new u({props:{code:"JTIzJTIwZGVsZXRlJTIwZW5kcG9pbnQlMEFwcmVkaWN0b3IuZGVsZXRlX2VuZHBvaW50KCk=",highlighted:`<span class="hljs-comment"># delete endpoint</span>
predictor.delete_endpoint()`,wrap:!1}}),Ie=new J({props:{title:"Run batch transform with 🤗 Transformers and SageMaker",local:"run-batch-transform-with--transformers-and-sagemaker",headingTag:"h2"}}),ke=new u({props:{code:"YmF0Y2hfam9iJTIwJTNEJTIwaHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLnRyYW5zZm9ybWVyKCUwQSUyMCUyMCUyMCUyMGluc3RhbmNlX2NvdW50JTNEMSUyQyUwQSUyMCUyMCUyMCUyMGluc3RhbmNlX3R5cGUlM0QnbWwucDMuMnhsYXJnZSclMkMlMEElMjAlMjAlMjAlMjBzdHJhdGVneSUzRCdTaW5nbGVSZWNvcmQnKSUwQSUwQSUwQWJhdGNoX2pvYi50cmFuc2Zvcm0oJTBBJTIwJTIwJTIwJTIwZGF0YSUzRCdzMyUzQSUyRiUyRnMzLXVyaS10by1iYXRjaC1kYXRhJyUyQyUwQSUyMCUyMCUyMCUyMGNvbnRlbnRfdHlwZSUzRCdhcHBsaWNhdGlvbiUyRmpzb24nJTJDJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwc3BsaXRfdHlwZSUzRCdMaW5lJyk=",highlighted:`batch_job = huggingface_estimator.transformer(
    instance_count=<span class="hljs-number">1</span>,
    instance_type=<span class="hljs-string">&#x27;ml.p3.2xlarge&#x27;</span>,
    strategy=<span class="hljs-string">&#x27;SingleRecord&#x27;</span>)


batch_job.transform(
    data=<span class="hljs-string">&#x27;s3://s3-uri-to-batch-data&#x27;</span>,
    content_type=<span class="hljs-string">&#x27;application/json&#x27;</span>,    
    split_type=<span class="hljs-string">&#x27;Line&#x27;</span>)`,wrap:!1}}),We=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface.model <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># Hub model configuration &lt;https://huggingface.co/models&gt;</span>
hub = {
	<span class="hljs-string">&#x27;HF_MODEL_ID&#x27;</span>:<span class="hljs-string">&#x27;distilbert/distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>,
	<span class="hljs-string">&#x27;HF_TASK&#x27;</span>:<span class="hljs-string">&#x27;text-classification&#x27;</span>
}

<span class="hljs-comment"># create Hugging Face Model Class</span>
huggingface_model = HuggingFaceModel(
   env=hub,                                                <span class="hljs-comment"># configuration for loading model from Hub</span>
   role=role,                                              <span class="hljs-comment"># IAM role with permissions to create an endpoint</span>
   transformers_version=<span class="hljs-string">&quot;4.26&quot;</span>,                             <span class="hljs-comment"># Transformers version used</span>
   pytorch_version=<span class="hljs-string">&quot;1.13&quot;</span>,                                  <span class="hljs-comment"># PyTorch version used</span>
   py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,                                      <span class="hljs-comment"># Python version used</span>
)

<span class="hljs-comment"># create transformer to run a batch job</span>
batch_job = huggingface_model.transformer(
    instance_count=<span class="hljs-number">1</span>,
    instance_type=<span class="hljs-string">&#x27;ml.p3.2xlarge&#x27;</span>,
    strategy=<span class="hljs-string">&#x27;SingleRecord&#x27;</span>
)

<span class="hljs-comment"># starts batch transform job and uses S3 data as input</span>
batch_job.transform(
    data=<span class="hljs-string">&#x27;s3://sagemaker-s3-demo-test/samples/input.jsonl&#x27;</span>,
    content_type=<span class="hljs-string">&#x27;application/json&#x27;</span>,    
    split_type=<span class="hljs-string">&#x27;Line&#x27;</span>
)`,wrap:!1}}),ve=new u({props:{code:"JTdCJTIyaW5wdXRzJTIyJTNBJTIydGhpcyUyMG1vdmllJTIwaXMlMjB0ZXJyaWJsZSUyMiU3RCUwQSU3QiUyMmlucHV0cyUyMiUzQSUyMnRoaXMlMjBtb3ZpZSUyMGlzJTIwYW1hemluZyUyMiU3RCUwQSU3QiUyMmlucHV0cyUyMiUzQSUyMlNhZ2VNYWtlciUyMGlzJTIwcHJldHR5JTIwY29vbCUyMiU3RCUwQSU3QiUyMmlucHV0cyUyMiUzQSUyMlNhZ2VNYWtlciUyMGlzJTIwcHJldHR5JTIwY29vbCUyMiU3RCUwQSU3QiUyMmlucHV0cyUyMiUzQSUyMnRoaXMlMjBtb3ZpZSUyMGlzJTIwdGVycmlibGUlMjIlN0QlMEElN0IlMjJpbnB1dHMlMjIlM0ElMjJ0aGlzJTIwbW92aWUlMjBpcyUyMGFtYXppbmclMjIlN0Q=",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;this movie is terrible&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;this movie is amazing&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;SageMaker is pretty cool&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;SageMaker is pretty cool&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;this movie is terrible&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;this movie is amazing&quot;</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),_e=new J({props:{title:"Deploy an LLM to SageMaker using TGI",local:"deploy-an-llm-to-sagemaker-using-tgi",headingTag:"h2"}}),Re=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNhZ2VtYWtlciUzRSUzRDIuMjMxLjA=",highlighted:"pip install sagemaker&gt;=2.231.0",wrap:!1}}),xe=new u({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlTW9kZWwlMkMlMjBnZXRfaHVnZ2luZ2ZhY2VfbGxtX2ltYWdlX3VyaSUwQWltcG9ydCUyMHRpbWUlMEElMEFzYWdlbWFrZXJfc2Vzc2lvbiUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCklMEFyZWdpb24lMjAlM0QlMjBzYWdlbWFrZXJfc2Vzc2lvbi5ib3RvX3JlZ2lvbl9uYW1lJTBBcm9sZSUyMCUzRCUyMHNhZ2VtYWtlci5nZXRfZXhlY3V0aW9uX3JvbGUoKQ==",highlighted:`<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFaceModel, get_huggingface_llm_image_uri
<span class="hljs-keyword">import</span> time

sagemaker_session = sagemaker.Session()
region = sagemaker_session.boto_region_name
role = sagemaker.get_execution_role()`,wrap:!1}}),Ye=new u({props:{code:"aW1hZ2VfdXJpJTIwJTNEJTIwZ2V0X2h1Z2dpbmdmYWNlX2xsbV9pbWFnZV91cmkoJTBBJTIwJTIwYmFja2VuZCUzRCUyMmh1Z2dpbmdmYWNlJTIyJTJDJTBBJTIwJTIwcmVnaW9uJTNEcmVnaW9uJTBBKQ==",highlighted:`image_uri = get_huggingface_llm_image_uri(
  backend=<span class="hljs-string">&quot;huggingface&quot;</span>,
  region=region
)`,wrap:!1}}),Xe=new u({props:{code:"bW9kZWxfbmFtZSUyMCUzRCUyMCUyMmxsYW1hLTMtMS04Yi1pbnN0cnVjdCUyMiUyMCUyQiUyMHRpbWUuc3RyZnRpbWUoJTIyJTI1WS0lMjVtLSUyNWQtJTI1SC0lMjVNLSUyNVMlMjIlMkMlMjB0aW1lLmdtdGltZSgpKSUwQSUwQWh1YiUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCdIRl9NT0RFTF9JRCclM0EnbWV0YS1sbGFtYSUyRkxsYW1hLTMuMS04Qi1JbnN0cnVjdCclMkMlMEElMjAlMjAlMjAlMjAnU01fTlVNX0dQVVMnJTNBJzEnJTJDJTBBJTA5J0hVR0dJTkdfRkFDRV9IVUJfVE9LRU4nJTNBJTIwJyUzQ1JFUExBQ0UlMjBXSVRIJTIwWU9VUiUyMFRPS0VOJTNFJyUyQyUwQSU3RCUwQSUwQWFzc2VydCUyMGh1YiU1QidIVUdHSU5HX0ZBQ0VfSFVCX1RPS0VOJyU1RCUyMCElM0QlMjAnJTNDUkVQTEFDRSUyMFdJVEglMjBZT1VSJTIwVE9LRU4lM0UnJTJDJTIwJTIyWW91JTIwaGF2ZSUyMHRvJTIwcHJvdmlkZSUyMGElMjB0b2tlbi4lMjIlMEElMEElMEFtb2RlbCUyMCUzRCUyMEh1Z2dpbmdGYWNlTW9kZWwoJTBBJTIwJTIwJTIwJTIwbmFtZSUzRG1vZGVsX25hbWUlMkMlMEElMjAlMjAlMjAlMjBlbnYlM0RodWIlMkMlMEElMjAlMjAlMjAlMjByb2xlJTNEcm9sZSUyQyUwQSUyMCUyMCUyMCUyMGltYWdlX3VyaSUzRGltYWdlX3VyaSUwQSk=",highlighted:`model_name = <span class="hljs-string">&quot;llama-3-1-8b-instruct&quot;</span> + time.strftime(<span class="hljs-string">&quot;%Y-%m-%d-%H-%M-%S&quot;</span>, time.gmtime())

hub = {
    <span class="hljs-string">&#x27;HF_MODEL_ID&#x27;</span>:<span class="hljs-string">&#x27;meta-llama/Llama-3.1-8B-Instruct&#x27;</span>,
    <span class="hljs-string">&#x27;SM_NUM_GPUS&#x27;</span>:<span class="hljs-string">&#x27;1&#x27;</span>,
	<span class="hljs-string">&#x27;HUGGING_FACE_HUB_TOKEN&#x27;</span>: <span class="hljs-string">&#x27;&lt;REPLACE WITH YOUR TOKEN&gt;&#x27;</span>,
}

<span class="hljs-keyword">assert</span> hub[<span class="hljs-string">&#x27;HUGGING_FACE_HUB_TOKEN&#x27;</span>] != <span class="hljs-string">&#x27;&lt;REPLACE WITH YOUR TOKEN&gt;&#x27;</span>, <span class="hljs-string">&quot;You have to provide a token.&quot;</span>


model = HuggingFaceModel(
    name=model_name,
    env=hub,
    role=role,
    image_uri=image_uri
)`,wrap:!1}}),Le=new u({props:{code:"cHJlZGljdG9yJTIwJTNEJTIwbW9kZWwuZGVwbG95KCUwQSUyMCUyMGluaXRpYWxfaW5zdGFuY2VfY291bnQlM0QxJTJDJTBBJTIwJTIwaW5zdGFuY2VfdHlwZSUzRCUyMm1sLmc1LjJ4bGFyZ2UlMjIlMkMlMEElMjAlMjBlbmRwb2ludF9uYW1lJTNEbW9kZWxfbmFtZSUwQSk=",highlighted:`predictor = model.deploy(
  initial_instance_count=<span class="hljs-number">1</span>,
  instance_type=<span class="hljs-string">&quot;ml.g5.2xlarge&quot;</span>,
  endpoint_name=model_name
)`,wrap:!1}}),Pe=new u({props:{code:"aW5wdXRfZGF0YSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMmlucHV0cyUyMiUzQSUyMCUyMlRoZSUyMGRpYW1vbmRiYWNrJTIwdGVycmFwaW4lMjB3YXMlMjB0aGUlMjBmaXJzdCUyMHJlcHRpbGUlMjB0byUyMiUyQyUwQSUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJkb19zYW1wbGUlMjIlM0ElMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIybWF4X25ld190b2tlbnMlMjIlM0ElMjAxMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJ0ZW1wZXJhdHVyZSUyMiUzQSUyMDAuNyUyQyUwQSUyMCUyMCUyMCUyMCUyMndhdGVybWFyayUyMiUzQSUyMFRydWUlMEElMjAlMjAlN0QlMEElN0QlMEElMEFwcmVkaWN0b3IucHJlZGljdChpbnB1dF9kYXRhKQ==",highlighted:`input_data = {
  <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;The diamondback terrapin was the first reptile to&quot;</span>,
  <span class="hljs-string">&quot;parameters&quot;</span>: {
    <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">100</span>,
    <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>,
    <span class="hljs-string">&quot;watermark&quot;</span>: <span class="hljs-literal">True</span>
  }
}

predictor.predict(input_data)`,wrap:!1}}),Ke=new u({props:{code:"JTVCJTdCJ2dlbmVyYXRlZF90ZXh0JyUzQSUyMCdUaGUlMjBkaWFtb25kYmFjayUyMHRlcnJhcGluJTIwd2FzJTIwdGhlJTIwZmlyc3QlMjByZXB0aWxlJTIwdG8lMjBtYWtlJTIwdGhlJTIwbGlzdCUyQyUyMGZvbGxvd2VkJTIwYnklMjB0aGUlMjBBbWVyaWNhbiUyMGFsbGlnYXRvciUyQyUyMHRoZSUyMEFtZXJpY2FuJTIwY3JvY29kaWxlJTJDJTIwYW5kJTIwdGhlJTIwQW1lcmljYW4lMjBib3glMjB0dXJ0bGUuJTIwVGhlJTIwcG9sZWNhdCUyQyUyMGElMjBmZXJyZXQtbGlrZSUyMGFuaW1hbCUyQyUyMGFuZCUyMHRoZSUyMHNrdW5rJTIwcm91bmRlZCUyMG91dCUyMHRoZSUyMGxpc3QlMkMlMjBib3RoJTIwaGF2aW5nJTIwZ2FpbmVkJTIwdGhlaXIlMjBzbG90cyUyMGJlY2F1c2UlMjB0aGV5JTIwaGF2ZSUyMHByb3ZlbiUyMHRvJTIwYmUlMjBwYXJ0aWN1bGFybHklMjBkYW5nZXJvdXMlMjB0byUyMGh1bWFucy4lNUNuJTVDbkNhbGlmb3JuaWFucyUyMGFsc28lMjBzZWVtZWQlMjB0byUyMGFwcHJlY2lhdGUlMjB0aGUlMjBuZXclMjBsaXN0JTJDJTIwanVkZ2luZyUyMGJ5JTIwdGhlJTIwY29tbWVudHMlMjBsZWZ0JTIwYWZ0ZXIlMjB0aGUlMjBlbGVjdGlvbi4lNUNuJTVDbiVFMiU4MCU5Q1RoaXMlMjBpcyUyMGZhbnRhc3RpYyUyQyVFMiU4MCU5RCUyMG9uZSUyMGNvbW1lbnRlciUyMGRlY2xhcmVkLiU1Q24lNUNuJUUyJTgwJTlDQ2FsaWZvcm5pYSUyMGlzJTIwYSUyMHZlcnknJTdEJTVE",highlighted:'[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;The diamondback terrapin was the first reptile to make the list, followed by the American alligator, the American crocodile, and the American box turtle. The polecat, a ferret-like animal, and the skunk rounded out the list, both having gained their slots because they have proven to be particularly dangerous to humans.\\n\\nCalifornians also seemed to appreciate the new list, judging by the comments left after the election.\\n\\n“This is fantastic,” one commenter declared.\\n\\n“California is a very&#x27;</span>}]',wrap:!1}}),el=new u({props:{code:"cHJlZGljdG9yLmRlbGV0ZV9tb2RlbCgpJTBBcHJlZGljdG9yLmRlbGV0ZV9lbmRwb2ludCgp",highlighted:`predictor.delete_model()
predictor.delete_endpoint()`,wrap:!1}}),ll=new J({props:{title:"User defined code and modules",local:"user-defined-code-and-modules",headingTag:"h2"}}),sl=new u({props:{code:"bW9kZWwudGFyLmd6JTJGJTBBJTdDLSUyMHB5dG9yY2hfbW9kZWwuYmluJTBBJTdDLSUyMC4uLi4lMEElN0MtJTIwY29kZSUyRiUwQSUyMCUyMCU3Qy0lMjBpbmZlcmVuY2UucHklMEElMjAlMjAlN0MtJTIwcmVxdWlyZW1lbnRzLnR4dCUyMA==",highlighted:`model.tar.gz/
|- pytorch_model.bin
|- ....
|- code/
  |- inference.py
  |- requirements.txt `,wrap:!1}}),ol=new u({props:{code:"ZnJvbSUyMHNhZ2VtYWtlcl9odWdnaW5nZmFjZV9pbmZlcmVuY2VfdG9vbGtpdCUyMGltcG9ydCUyMGRlY29kZXJfZW5jb2RlciUwQSUwQWRlZiUyMG1vZGVsX2ZuKG1vZGVsX2RpciklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBpbXBsZW1lbnQlMjBjdXN0b20lMjBjb2RlJTIwdG8lMjBsb2FkJTIwdGhlJTIwbW9kZWwlMEElMjAlMjAlMjAlMjBsb2FkZWRfbW9kZWwlMjAlM0QlMjAuLi4lMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsb2FkZWRfbW9kZWwlMjAlMEElMEFkZWYlMjBpbnB1dF9mbihpbnB1dF9kYXRhJTJDJTIwY29udGVudF90eXBlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGRlY29kZSUyMHRoZSUyMGlucHV0JTIwZGF0YSUyMCUyMChlLmcuJTIwSlNPTiUyMHN0cmluZyUyMC0lM0UlMjBkaWN0KSUwQSUyMCUyMCUyMCUyMGRhdGElMjAlM0QlMjBkZWNvZGVyX2VuY29kZXIuZGVjb2RlKGlucHV0X2RhdGElMkMlMjBjb250ZW50X3R5cGUpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZGF0YSUwQSUwQWRlZiUyMHByZWRpY3RfZm4oZGF0YSUyQyUyMG1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGNhbGwlMjB5b3VyJTIwY3VzdG9tJTIwbW9kZWwlMjB3aXRoJTIwdGhlJTIwZGF0YSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChkYXRhJTIwJTJDJTIwLi4uJTIwKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByZWRpY3Rpb25zJTBBJTBBZGVmJTIwb3V0cHV0X2ZuKHByZWRpY3Rpb24lMkMlMjBhY2NlcHQpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwY29udmVydCUyMHRoZSUyMG1vZGVsJTIwb3V0cHV0JTIwdG8lMjB0aGUlMjBkZXNpcmVkJTIwb3V0cHV0JTIwZm9ybWF0JTIwKGUuZy4lMjBkaWN0JTIwLSUzRSUyMEpTT04lMjBzdHJpbmcpJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBkZWNvZGVyX2VuY29kZXIuZW5jb2RlKHByZWRpY3Rpb24lMkMlMjBhY2NlcHQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzcG9uc2U=",highlighted:`<span class="hljs-keyword">from</span> sagemaker_huggingface_inference_toolkit <span class="hljs-keyword">import</span> decoder_encoder

<span class="hljs-keyword">def</span> <span class="hljs-title function_">model_fn</span>(<span class="hljs-params">model_dir</span>):
    <span class="hljs-comment"># implement custom code to load the model</span>
    loaded_model = ...
    
    <span class="hljs-keyword">return</span> loaded_model 

<span class="hljs-keyword">def</span> <span class="hljs-title function_">input_fn</span>(<span class="hljs-params">input_data, content_type</span>):
    <span class="hljs-comment"># decode the input data  (e.g. JSON string -&gt; dict)</span>
    data = decoder_encoder.decode(input_data, content_type)
    <span class="hljs-keyword">return</span> data

<span class="hljs-keyword">def</span> <span class="hljs-title function_">predict_fn</span>(<span class="hljs-params">data, model</span>):
    <span class="hljs-comment"># call your custom model with the data</span>
    outputs = model(data , ... )
    <span class="hljs-keyword">return</span> predictions

<span class="hljs-keyword">def</span> <span class="hljs-title function_">output_fn</span>(<span class="hljs-params">prediction, accept</span>):
    <span class="hljs-comment"># convert the model output to the desired output format (e.g. dict -&gt; JSON string)</span>
    response = decoder_encoder.encode(prediction, accept)
    <span class="hljs-keyword">return</span> response`,wrap:!1}}),rl=new u({props:{code:"ZnJvbSUyMHNhZ2VtYWtlcl9odWdnaW5nZmFjZV9pbmZlcmVuY2VfdG9vbGtpdCUyMGltcG9ydCUyMGRlY29kZXJfZW5jb2RlciUwQSUwQWRlZiUyMG1vZGVsX2ZuKG1vZGVsX2RpciklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBpbXBsZW1lbnQlMjBjdXN0b20lMjBjb2RlJTIwdG8lMjBsb2FkJTIwdGhlJTIwbW9kZWwlMEElMjAlMjAlMjAlMjBsb2FkZWRfbW9kZWwlMjAlM0QlMjAuLi4lMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsb2FkZWRfbW9kZWwlMjAlMEElMEFkZWYlMjB0cmFuc2Zvcm1fZm4obW9kZWwlMkMlMjBpbnB1dF9kYXRhJTJDJTIwY29udGVudF90eXBlJTJDJTIwYWNjZXB0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMyUyMGRlY29kZSUyMHRoZSUyMGlucHV0JTIwZGF0YSUyMChlLmcuJTIwSlNPTiUyMHN0cmluZyUyMC0lM0UlMjBkaWN0KSUwQSUyMCUyMCUyMCUyMGRhdGElMjAlM0QlMjBkZWNvZGVyX2VuY29kZXIuZGVjb2RlKGlucHV0X2RhdGElMkMlMjBjb250ZW50X3R5cGUpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwY2FsbCUyMHlvdXIlMjBjdXN0b20lMjBtb2RlbCUyMHdpdGglMjB0aGUlMjBkYXRhJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGRhdGElMjAlMkMlMjAuLi4lMjApJTIwJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwY29udmVydCUyMHRoZSUyMG1vZGVsJTIwb3V0cHV0JTIwdG8lMjB0aGUlMjBkZXNpcmVkJTIwb3V0cHV0JTIwZm9ybWF0JTIwKGUuZy4lMjBkaWN0JTIwLSUzRSUyMEpTT04lMjBzdHJpbmcpJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBkZWNvZGVyX2VuY29kZXIuZW5jb2RlKG91dHB1dCUyQyUyMGFjY2VwdCklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXNwb25zZQ==",highlighted:`<span class="hljs-keyword">from</span> sagemaker_huggingface_inference_toolkit <span class="hljs-keyword">import</span> decoder_encoder

<span class="hljs-keyword">def</span> <span class="hljs-title function_">model_fn</span>(<span class="hljs-params">model_dir</span>):
    <span class="hljs-comment"># implement custom code to load the model</span>
    loaded_model = ...
    
    <span class="hljs-keyword">return</span> loaded_model 

<span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_fn</span>(<span class="hljs-params">model, input_data, content_type, accept</span>):
     <span class="hljs-comment"># decode the input data (e.g. JSON string -&gt; dict)</span>
    data = decoder_encoder.decode(input_data, content_type)

    <span class="hljs-comment"># call your custom model with the data</span>
    outputs = model(data , ... ) 

    <span class="hljs-comment"># convert the model output to the desired output format (e.g. dict -&gt; JSON string)</span>
    response = decoder_encoder.encode(output, accept)

    <span class="hljs-keyword">return</span> response`,wrap:!1}}),pl=new Cn({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/sagemaker/source/tutorials/sagemaker-sdk/deploy-sagemaker-sdk.md"}}),{c(){h=M("meta"),cl=n(),yl=M("p"),ul=n(),r(I.$$.fragment),Ul=n(),r(g.$$.fragment),jl=n(),C=M("p"),C.textContent=ys,Tl=n(),r(Z.$$.fragment),wl=n(),B=M("p"),B.innerHTML=ds,Jl=n(),k=M("ul"),k.innerHTML=ms,hl=n(),r(G.$$.fragment),fl=n(),W=M("p"),W.innerHTML=cs,bl=n(),A=M("p"),A.textContent=us,Il=n(),v=M("ul"),v.innerHTML=Us,gl=n(),$=M("p"),$.innerHTML=js,Cl=n(),_=M("p"),_.innerHTML=Ts,Zl=n(),r(S.$$.fragment),Bl=n(),H=M("p"),H.innerHTML=ws,kl=n(),R=M("p"),R.textContent=Js,Gl=n(),r(E.$$.fragment),Wl=n(),x=M("p"),x.innerHTML=hs,Al=n(),V=M("p"),V.innerHTML=fs,vl=n(),Y=M("p"),Y.textContent=bs,$l=n(),r(z.$$.fragment),_l=n(),r(N.$$.fragment),Sl=n(),j=M("iframe"),Hl=n(),F=M("p"),F.textContent=gs,Rl=n(),X=M("ul"),X.innerHTML=Cs,El=n(),Q=M("p"),Q.innerHTML=Zs,xl=n(),r(L.$$.fragment),Vl=n(),q=M("p"),q.textContent=Bs,Yl=n(),P=M("p"),P.innerHTML=ks,zl=n(),r(D.$$.fragment),Nl=n(),K=M("p"),K.textContent=Gs,Fl=n(),r(O.$$.fragment),Xl=n(),r(ee.$$.fragment),Ql=n(),le=M("p"),le.innerHTML=Ws,Ll=n(),r(te.$$.fragment),ql=n(),se=M("p"),se.textContent=As,Pl=n(),r(ne.$$.fragment),Dl=n(),r(ae.$$.fragment),Kl=n(),Me=M("p"),Me.innerHTML=vs,Ol=n(),oe=M("ul"),oe.innerHTML=$s,et=n(),ie=M("p"),ie.textContent=_s,lt=n(),r(re.$$.fragment),tt=n(),pe=M("p"),pe.innerHTML=Ss,st=n(),ye=M("ol"),ye.innerHTML=Hs,nt=n(),r(de.$$.fragment),at=n(),f=M("ol"),f.innerHTML=Rs,Mt=n(),r(me.$$.fragment),ot=n(),b=M("ol"),b.innerHTML=Es,it=n(),r(ce.$$.fragment),rt=n(),ue=M("p"),ue.innerHTML=xs,pt=n(),r(Ue.$$.fragment),yt=n(),T=M("iframe"),dt=n(),je=M("p"),je.innerHTML=Ys,mt=n(),Te=M("ul"),Te.innerHTML=zs,ct=n(),we=M("blockquote"),we.innerHTML=Ns,ut=n(),r(Je.$$.fragment),Ut=n(),he=M("p"),he.textContent=Fs,jt=n(),r(fe.$$.fragment),Tt=n(),be=M("p"),be.innerHTML=Xs,wt=n(),r(Ie.$$.fragment),Jt=n(),w=M("iframe"),ht=n(),ge=M("p"),ge.innerHTML=Ls,ft=n(),Ce=M("p"),Ce.innerHTML=qs,bt=n(),Ze=M("p"),Ze.innerHTML=Ps,It=n(),Be=M("p"),Be.innerHTML=Ds,gt=n(),r(ke.$$.fragment),Ct=n(),Ge=M("p"),Ge.innerHTML=Ks,Zt=n(),r(We.$$.fragment),Bt=n(),Ae=M("p"),Ae.innerHTML=Os,kt=n(),r(ve.$$.fragment),Gt=n(),$e=M("p"),$e.innerHTML=en,Wt=n(),r(_e.$$.fragment),At=n(),Se=M("p"),Se.innerHTML=ln,vt=n(),He=M("p"),He.textContent=tn,$t=n(),r(Re.$$.fragment),_t=n(),Ee=M("p"),Ee.textContent=sn,St=n(),r(xe.$$.fragment),Ht=n(),Ve=M("p"),Ve.textContent=nn,Rt=n(),r(Ye.$$.fragment),Et=n(),ze=M("p"),ze.innerHTML=an,xt=n(),Ne=M("p"),Ne.innerHTML=Mn,Vt=n(),Fe=M("p"),Fe.innerHTML=on,Yt=n(),r(Xe.$$.fragment),zt=n(),Qe=M("p"),Qe.textContent=rn,Nt=n(),r(Le.$$.fragment),Ft=n(),qe=M("p"),qe.textContent=pn,Xt=n(),r(Pe.$$.fragment),Qt=n(),De=M("p"),De.textContent=yn,Lt=n(),r(Ke.$$.fragment),qt=n(),Oe=M("p"),Oe.textContent=dn,Pt=n(),r(el.$$.fragment),Dt=n(),r(ll.$$.fragment),Kt=n(),tl=M("p"),tl.innerHTML=mn,Ot=n(),r(sl.$$.fragment),es=n(),nl=M("p"),nl.innerHTML=cn,ls=n(),al=M("ul"),al.innerHTML=un,ts=n(),Ml=M("p"),Ml.innerHTML=Un,ss=n(),r(ol.$$.fragment),ns=n(),il=M("p"),il.innerHTML=jn,as=n(),r(rl.$$.fragment),Ms=n(),r(pl.$$.fragment),os=n(),dl=M("p"),this.h()},l(e){const l=bn("svelte-u9bgzb",document.head);h=o(l,"META",{name:!0,content:!0}),l.forEach(t),cl=a(e),yl=o(e,"P",{}),ml(yl).forEach(t),ul=a(e),p(I.$$.fragment,e),Ul=a(e),p(g.$$.fragment,e),jl=a(e),C=o(e,"P",{"data-svelte-h":!0}),i(C)!=="svelte-ywypfi"&&(C.textContent=ys),Tl=a(e),p(Z.$$.fragment,e),wl=a(e),B=o(e,"P",{"data-svelte-h":!0}),i(B)!=="svelte-lx9xk7"&&(B.innerHTML=ds),Jl=a(e),k=o(e,"UL",{"data-svelte-h":!0}),i(k)!=="svelte-lmxuwx"&&(k.innerHTML=ms),hl=a(e),p(G.$$.fragment,e),fl=a(e),W=o(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-uia7yx"&&(W.innerHTML=cs),bl=a(e),A=o(e,"P",{"data-svelte-h":!0}),i(A)!=="svelte-14pz1nf"&&(A.textContent=us),Il=a(e),v=o(e,"UL",{"data-svelte-h":!0}),i(v)!=="svelte-nu9uzs"&&(v.innerHTML=Us),gl=a(e),$=o(e,"P",{"data-svelte-h":!0}),i($)!=="svelte-10vylvb"&&($.innerHTML=js),Cl=a(e),_=o(e,"P",{"data-svelte-h":!0}),i(_)!=="svelte-183wm56"&&(_.innerHTML=Ts),Zl=a(e),p(S.$$.fragment,e),Bl=a(e),H=o(e,"P",{"data-svelte-h":!0}),i(H)!=="svelte-aqpf90"&&(H.innerHTML=ws),kl=a(e),R=o(e,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1n86nit"&&(R.textContent=Js),Gl=a(e),p(E.$$.fragment,e),Wl=a(e),x=o(e,"P",{"data-svelte-h":!0}),i(x)!=="svelte-bmcgfj"&&(x.innerHTML=hs),Al=a(e),V=o(e,"P",{"data-svelte-h":!0}),i(V)!=="svelte-12o7543"&&(V.innerHTML=fs),vl=a(e),Y=o(e,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-qjt50s"&&(Y.textContent=bs),$l=a(e),p(z.$$.fragment,e),_l=a(e),p(N.$$.fragment,e),Sl=a(e),j=o(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),ml(j).forEach(t),Hl=a(e),F=o(e,"P",{"data-svelte-h":!0}),i(F)!=="svelte-gux9y"&&(F.textContent=gs),Rl=a(e),X=o(e,"UL",{"data-svelte-h":!0}),i(X)!=="svelte-g9t1l6"&&(X.innerHTML=Cs),El=a(e),Q=o(e,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1kzoo7i"&&(Q.innerHTML=Zs),xl=a(e),p(L.$$.fragment,e),Vl=a(e),q=o(e,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1bnjjtb"&&(q.textContent=Bs),Yl=a(e),P=o(e,"P",{"data-svelte-h":!0}),i(P)!=="svelte-qrjq9z"&&(P.innerHTML=ks),zl=a(e),p(D.$$.fragment,e),Nl=a(e),K=o(e,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1704hsx"&&(K.textContent=Gs),Fl=a(e),p(O.$$.fragment,e),Xl=a(e),p(ee.$$.fragment,e),Ql=a(e),le=o(e,"P",{"data-svelte-h":!0}),i(le)!=="svelte-xplu1m"&&(le.innerHTML=Ws),Ll=a(e),p(te.$$.fragment,e),ql=a(e),se=o(e,"P",{"data-svelte-h":!0}),i(se)!=="svelte-10df72h"&&(se.textContent=As),Pl=a(e),p(ne.$$.fragment,e),Dl=a(e),p(ae.$$.fragment,e),Kl=a(e),Me=o(e,"P",{"data-svelte-h":!0}),i(Me)!=="svelte-1bx7pn1"&&(Me.innerHTML=vs),Ol=a(e),oe=o(e,"UL",{"data-svelte-h":!0}),i(oe)!=="svelte-1yevczk"&&(oe.innerHTML=$s),et=a(e),ie=o(e,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-1fj2qwz"&&(ie.textContent=_s),lt=a(e),p(re.$$.fragment,e),tt=a(e),pe=o(e,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-6vx79s"&&(pe.innerHTML=Ss),st=a(e),ye=o(e,"OL",{"data-svelte-h":!0}),i(ye)!=="svelte-1oe4mbx"&&(ye.innerHTML=Hs),nt=a(e),p(de.$$.fragment,e),at=a(e),f=o(e,"OL",{start:!0,"data-svelte-h":!0}),i(f)!=="svelte-1dpsw5r"&&(f.innerHTML=Rs),Mt=a(e),p(me.$$.fragment,e),ot=a(e),b=o(e,"OL",{start:!0,"data-svelte-h":!0}),i(b)!=="svelte-1jup9fl"&&(b.innerHTML=Es),it=a(e),p(ce.$$.fragment,e),rt=a(e),ue=o(e,"P",{"data-svelte-h":!0}),i(ue)!=="svelte-fiqqyd"&&(ue.innerHTML=xs),pt=a(e),p(Ue.$$.fragment,e),yt=a(e),T=o(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),ml(T).forEach(t),dt=a(e),je=o(e,"P",{"data-svelte-h":!0}),i(je)!=="svelte-1rqi6h3"&&(je.innerHTML=Ys),mt=a(e),Te=o(e,"UL",{"data-svelte-h":!0}),i(Te)!=="svelte-24bif2"&&(Te.innerHTML=zs),ct=a(e),we=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),i(we)!=="svelte-1me1jis"&&(we.innerHTML=Ns),ut=a(e),p(Je.$$.fragment,e),Ut=a(e),he=o(e,"P",{"data-svelte-h":!0}),i(he)!=="svelte-10df72h"&&(he.textContent=Fs),jt=a(e),p(fe.$$.fragment,e),Tt=a(e),be=o(e,"P",{"data-svelte-h":!0}),i(be)!=="svelte-116ugu4"&&(be.innerHTML=Xs),wt=a(e),p(Ie.$$.fragment,e),Jt=a(e),w=o(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),ml(w).forEach(t),ht=a(e),ge=o(e,"P",{"data-svelte-h":!0}),i(ge)!=="svelte-6zcket"&&(ge.innerHTML=Ls),ft=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),i(Ce)!=="svelte-11i511d"&&(Ce.innerHTML=qs),bt=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),i(Ze)!=="svelte-1aa5m67"&&(Ze.innerHTML=Ps),It=a(e),Be=o(e,"P",{"data-svelte-h":!0}),i(Be)!=="svelte-h98oit"&&(Be.innerHTML=Ds),gt=a(e),p(ke.$$.fragment,e),Ct=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),i(Ge)!=="svelte-1ttbskl"&&(Ge.innerHTML=Ks),Zt=a(e),p(We.$$.fragment,e),Bt=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),i(Ae)!=="svelte-1pml3h7"&&(Ae.innerHTML=Os),kt=a(e),p(ve.$$.fragment,e),Gt=a(e),$e=o(e,"P",{"data-svelte-h":!0}),i($e)!=="svelte-1uayvx5"&&($e.innerHTML=en),Wt=a(e),p(_e.$$.fragment,e),At=a(e),Se=o(e,"P",{"data-svelte-h":!0}),i(Se)!=="svelte-oqngf7"&&(Se.innerHTML=ln),vt=a(e),He=o(e,"P",{"data-svelte-h":!0}),i(He)!=="svelte-kb3ib5"&&(He.textContent=tn),$t=a(e),p(Re.$$.fragment,e),_t=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),i(Ee)!=="svelte-1alenu9"&&(Ee.textContent=sn),St=a(e),p(xe.$$.fragment,e),Ht=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),i(Ve)!=="svelte-wr9zty"&&(Ve.textContent=nn),Rt=a(e),p(Ye.$$.fragment,e),Et=a(e),ze=o(e,"P",{"data-svelte-h":!0}),i(ze)!=="svelte-pyh7bd"&&(ze.innerHTML=an),xt=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),i(Ne)!=="svelte-w1qvv3"&&(Ne.innerHTML=Mn),Vt=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),i(Fe)!=="svelte-2gsa94"&&(Fe.innerHTML=on),Yt=a(e),p(Xe.$$.fragment,e),zt=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),i(Qe)!=="svelte-1dpe0gw"&&(Qe.textContent=rn),Nt=a(e),p(Le.$$.fragment,e),Ft=a(e),qe=o(e,"P",{"data-svelte-h":!0}),i(qe)!=="svelte-16le46z"&&(qe.textContent=pn),Xt=a(e),p(Pe.$$.fragment,e),Qt=a(e),De=o(e,"P",{"data-svelte-h":!0}),i(De)!=="svelte-v1a1yw"&&(De.textContent=yn),Lt=a(e),p(Ke.$$.fragment,e),qt=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),i(Oe)!=="svelte-1vaiyhh"&&(Oe.textContent=dn),Pt=a(e),p(el.$$.fragment,e),Dt=a(e),p(ll.$$.fragment,e),Kt=a(e),tl=o(e,"P",{"data-svelte-h":!0}),i(tl)!=="svelte-1ryqcdi"&&(tl.innerHTML=mn),Ot=a(e),p(sl.$$.fragment,e),es=a(e),nl=o(e,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-1jy9y33"&&(nl.innerHTML=cn),ls=a(e),al=o(e,"UL",{"data-svelte-h":!0}),i(al)!=="svelte-1m8cp8l"&&(al.innerHTML=un),ts=a(e),Ml=o(e,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-d9i7vl"&&(Ml.innerHTML=Un),ss=a(e),p(ol.$$.fragment,e),ns=a(e),il=o(e,"P",{"data-svelte-h":!0}),i(il)!=="svelte-1cih48j"&&(il.innerHTML=jn),as=a(e),p(rl.$$.fragment,e),Ms=a(e),p(pl.$$.fragment,e),os=a(e),dl=o(e,"P",{}),ml(dl).forEach(t),this.h()},h(){U(h,"name","hf:doc:metadata"),U(h,"content",Bn),U(j,"width","700"),U(j,"height","394"),rs(j.src,Is="https://www.youtube.com/embed/pfBGgSGnYLs")||U(j,"src",Is),U(j,"title","YouTube video player"),U(j,"frameborder","0"),U(j,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),j.allowFullscreen="",U(f,"start","2"),U(b,"start","3"),U(T,"width","700"),U(T,"height","394"),rs(T.src,Vs="https://www.youtube.com/embed/l9QZuazbzWM")||U(T,"src",Vs),U(T,"title","YouTube video player"),U(T,"frameborder","0"),U(T,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),T.allowFullscreen="",U(w,"width","700"),U(w,"height","394"),rs(w.src,Qs="https://www.youtube.com/embed/lnTixz0tUBg")||U(w,"src",Qs),U(w,"title","YouTube video player"),U(w,"frameborder","0"),U(w,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),w.allowFullscreen=""},m(e,l){In(document.head,h),s(e,cl,l),s(e,yl,l),s(e,ul,l),y(I,e,l),s(e,Ul,l),y(g,e,l),s(e,jl,l),s(e,C,l),s(e,Tl,l),y(Z,e,l),s(e,wl,l),s(e,B,l),s(e,Jl,l),s(e,k,l),s(e,hl,l),y(G,e,l),s(e,fl,l),s(e,W,l),s(e,bl,l),s(e,A,l),s(e,Il,l),s(e,v,l),s(e,gl,l),s(e,$,l),s(e,Cl,l),s(e,_,l),s(e,Zl,l),y(S,e,l),s(e,Bl,l),s(e,H,l),s(e,kl,l),s(e,R,l),s(e,Gl,l),y(E,e,l),s(e,Wl,l),s(e,x,l),s(e,Al,l),s(e,V,l),s(e,vl,l),s(e,Y,l),s(e,$l,l),y(z,e,l),s(e,_l,l),y(N,e,l),s(e,Sl,l),s(e,j,l),s(e,Hl,l),s(e,F,l),s(e,Rl,l),s(e,X,l),s(e,El,l),s(e,Q,l),s(e,xl,l),y(L,e,l),s(e,Vl,l),s(e,q,l),s(e,Yl,l),s(e,P,l),s(e,zl,l),y(D,e,l),s(e,Nl,l),s(e,K,l),s(e,Fl,l),y(O,e,l),s(e,Xl,l),y(ee,e,l),s(e,Ql,l),s(e,le,l),s(e,Ll,l),y(te,e,l),s(e,ql,l),s(e,se,l),s(e,Pl,l),y(ne,e,l),s(e,Dl,l),y(ae,e,l),s(e,Kl,l),s(e,Me,l),s(e,Ol,l),s(e,oe,l),s(e,et,l),s(e,ie,l),s(e,lt,l),y(re,e,l),s(e,tt,l),s(e,pe,l),s(e,st,l),s(e,ye,l),s(e,nt,l),y(de,e,l),s(e,at,l),s(e,f,l),s(e,Mt,l),y(me,e,l),s(e,ot,l),s(e,b,l),s(e,it,l),y(ce,e,l),s(e,rt,l),s(e,ue,l),s(e,pt,l),y(Ue,e,l),s(e,yt,l),s(e,T,l),s(e,dt,l),s(e,je,l),s(e,mt,l),s(e,Te,l),s(e,ct,l),s(e,we,l),s(e,ut,l),y(Je,e,l),s(e,Ut,l),s(e,he,l),s(e,jt,l),y(fe,e,l),s(e,Tt,l),s(e,be,l),s(e,wt,l),y(Ie,e,l),s(e,Jt,l),s(e,w,l),s(e,ht,l),s(e,ge,l),s(e,ft,l),s(e,Ce,l),s(e,bt,l),s(e,Ze,l),s(e,It,l),s(e,Be,l),s(e,gt,l),y(ke,e,l),s(e,Ct,l),s(e,Ge,l),s(e,Zt,l),y(We,e,l),s(e,Bt,l),s(e,Ae,l),s(e,kt,l),y(ve,e,l),s(e,Gt,l),s(e,$e,l),s(e,Wt,l),y(_e,e,l),s(e,At,l),s(e,Se,l),s(e,vt,l),s(e,He,l),s(e,$t,l),y(Re,e,l),s(e,_t,l),s(e,Ee,l),s(e,St,l),y(xe,e,l),s(e,Ht,l),s(e,Ve,l),s(e,Rt,l),y(Ye,e,l),s(e,Et,l),s(e,ze,l),s(e,xt,l),s(e,Ne,l),s(e,Vt,l),s(e,Fe,l),s(e,Yt,l),y(Xe,e,l),s(e,zt,l),s(e,Qe,l),s(e,Nt,l),y(Le,e,l),s(e,Ft,l),s(e,qe,l),s(e,Xt,l),y(Pe,e,l),s(e,Qt,l),s(e,De,l),s(e,Lt,l),y(Ke,e,l),s(e,qt,l),s(e,Oe,l),s(e,Pt,l),y(el,e,l),s(e,Dt,l),y(ll,e,l),s(e,Kt,l),s(e,tl,l),s(e,Ot,l),y(sl,e,l),s(e,es,l),s(e,nl,l),s(e,ls,l),s(e,al,l),s(e,ts,l),s(e,Ml,l),s(e,ss,l),y(ol,e,l),s(e,ns,l),s(e,il,l),s(e,as,l),y(rl,e,l),s(e,Ms,l),y(pl,e,l),s(e,os,l),s(e,dl,l),is=!0},p:wn,i(e){is||(d(I.$$.fragment,e),d(g.$$.fragment,e),d(Z.$$.fragment,e),d(G.$$.fragment,e),d(S.$$.fragment,e),d(E.$$.fragment,e),d(z.$$.fragment,e),d(N.$$.fragment,e),d(L.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(te.$$.fragment,e),d(ne.$$.fragment,e),d(ae.$$.fragment,e),d(re.$$.fragment,e),d(de.$$.fragment,e),d(me.$$.fragment,e),d(ce.$$.fragment,e),d(Ue.$$.fragment,e),d(Je.$$.fragment,e),d(fe.$$.fragment,e),d(Ie.$$.fragment,e),d(ke.$$.fragment,e),d(We.$$.fragment,e),d(ve.$$.fragment,e),d(_e.$$.fragment,e),d(Re.$$.fragment,e),d(xe.$$.fragment,e),d(Ye.$$.fragment,e),d(Xe.$$.fragment,e),d(Le.$$.fragment,e),d(Pe.$$.fragment,e),d(Ke.$$.fragment,e),d(el.$$.fragment,e),d(ll.$$.fragment,e),d(sl.$$.fragment,e),d(ol.$$.fragment,e),d(rl.$$.fragment,e),d(pl.$$.fragment,e),is=!0)},o(e){m(I.$$.fragment,e),m(g.$$.fragment,e),m(Z.$$.fragment,e),m(G.$$.fragment,e),m(S.$$.fragment,e),m(E.$$.fragment,e),m(z.$$.fragment,e),m(N.$$.fragment,e),m(L.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(te.$$.fragment,e),m(ne.$$.fragment,e),m(ae.$$.fragment,e),m(re.$$.fragment,e),m(de.$$.fragment,e),m(me.$$.fragment,e),m(ce.$$.fragment,e),m(Ue.$$.fragment,e),m(Je.$$.fragment,e),m(fe.$$.fragment,e),m(Ie.$$.fragment,e),m(ke.$$.fragment,e),m(We.$$.fragment,e),m(ve.$$.fragment,e),m(_e.$$.fragment,e),m(Re.$$.fragment,e),m(xe.$$.fragment,e),m(Ye.$$.fragment,e),m(Xe.$$.fragment,e),m(Le.$$.fragment,e),m(Pe.$$.fragment,e),m(Ke.$$.fragment,e),m(el.$$.fragment,e),m(ll.$$.fragment,e),m(sl.$$.fragment,e),m(ol.$$.fragment,e),m(rl.$$.fragment,e),m(pl.$$.fragment,e),is=!1},d(e){e&&(t(cl),t(yl),t(ul),t(Ul),t(jl),t(C),t(Tl),t(wl),t(B),t(Jl),t(k),t(hl),t(fl),t(W),t(bl),t(A),t(Il),t(v),t(gl),t($),t(Cl),t(_),t(Zl),t(Bl),t(H),t(kl),t(R),t(Gl),t(Wl),t(x),t(Al),t(V),t(vl),t(Y),t($l),t(_l),t(Sl),t(j),t(Hl),t(F),t(Rl),t(X),t(El),t(Q),t(xl),t(Vl),t(q),t(Yl),t(P),t(zl),t(Nl),t(K),t(Fl),t(Xl),t(Ql),t(le),t(Ll),t(ql),t(se),t(Pl),t(Dl),t(Kl),t(Me),t(Ol),t(oe),t(et),t(ie),t(lt),t(tt),t(pe),t(st),t(ye),t(nt),t(at),t(f),t(Mt),t(ot),t(b),t(it),t(rt),t(ue),t(pt),t(yt),t(T),t(dt),t(je),t(mt),t(Te),t(ct),t(we),t(ut),t(Ut),t(he),t(jt),t(Tt),t(be),t(wt),t(Jt),t(w),t(ht),t(ge),t(ft),t(Ce),t(bt),t(Ze),t(It),t(Be),t(gt),t(Ct),t(Ge),t(Zt),t(Bt),t(Ae),t(kt),t(Gt),t($e),t(Wt),t(At),t(Se),t(vt),t(He),t($t),t(_t),t(Ee),t(St),t(Ht),t(Ve),t(Rt),t(Et),t(ze),t(xt),t(Ne),t(Vt),t(Fe),t(Yt),t(zt),t(Qe),t(Nt),t(Ft),t(qe),t(Xt),t(Qt),t(De),t(Lt),t(qt),t(Oe),t(Pt),t(Dt),t(Kt),t(tl),t(Ot),t(es),t(nl),t(ls),t(al),t(ts),t(Ml),t(ss),t(ns),t(il),t(as),t(Ms),t(os),t(dl)),t(h),c(I,e),c(g,e),c(Z,e),c(G,e),c(S,e),c(E,e),c(z,e),c(N,e),c(L,e),c(D,e),c(O,e),c(ee,e),c(te,e),c(ne,e),c(ae,e),c(re,e),c(de,e),c(me,e),c(ce,e),c(Ue,e),c(Je,e),c(fe,e),c(Ie,e),c(ke,e),c(We,e),c(ve,e),c(_e,e),c(Re,e),c(xe,e),c(Ye,e),c(Xe,e),c(Le,e),c(Pe,e),c(Ke,e),c(el,e),c(ll,e),c(sl,e),c(ol,e),c(rl,e),c(pl,e)}}}const Bn='{"title":"Deploy models to Amazon SageMaker","local":"deploy-models-to-amazon-sagemaker","sections":[{"title":"Installation and setup","local":"installation-and-setup","sections":[],"depth":2},{"title":"Deploy a 🤗 Transformers model trained in SageMaker","local":"deploy-a--transformers-model-trained-in-sagemaker","sections":[{"title":"Deploy after training","local":"deploy-after-training","sections":[],"depth":3},{"title":"Deploy with model_data","local":"deploy-with-modeldata","sections":[],"depth":3},{"title":"Create a model artifact for deployment","local":"create-a-model-artifact-for-deployment","sections":[],"depth":3}],"depth":2},{"title":"Deploy a model from the 🤗 Hub","local":"deploy-a-model-from-the--hub","sections":[],"depth":2},{"title":"Run batch transform with 🤗 Transformers and SageMaker","local":"run-batch-transform-with--transformers-and-sagemaker","sections":[],"depth":2},{"title":"Deploy an LLM to SageMaker using TGI","local":"deploy-an-llm-to-sagemaker-using-tgi","sections":[],"depth":2},{"title":"User defined code and modules","local":"user-defined-code-and-modules","sections":[],"depth":2}],"depth":1}';function kn(ps){return Jn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $n extends hn{constructor(h){super(),fn(this,h,kn,Zn,Tn,{})}}export{$n as component};
