# Welcome to the 🤗 smol-course

![Fine-Tuning Course thumbnail](https://github.com/huggingface/smol-course/blob/main/banner.png?raw=true)

Welcome to the comprehensive (and smollest) course to **Fine-Tuning Language Models**!

This free course will take you on a journey, **from beginner to expert**, in understanding, implementing, and optimizing fine-tuning techniques for large language models.

This first unit will help you onboard:

* Discover the **course's syllabus**.
* **Get more information about the certification process and the schedule**.
* Get to know the team behind the course.
* Create your **account**.
* **Sign-up to our Discord server**, and meet your classmates and us.

Let's get started!

> [!TIP]
> This course is smol but fast! It's for software developers and engineers looking to fast track their LLM fine-tuning skills. If that's not you, check out the [LLM Course](https://huggingface.co/learn/llm-course/).

## What to expect from this course?

In this course, you will:

* 📖 Study instruction tuning, supervised fine-tuning, preference alignment, evaluation, vision language models… and more!
* 🧑‍💻 Learn to use established fine-tuning frameworks and tools like TRL and Transformers.
* 💾 Share your projects and explore fine-tuning applications created by the community.
* 🏆 Participate in challenges where you will evaluate your fine-tuned models against other students.
* 🎓 Earn a certificate of completion by completing assignments.

At the end of this course, you'll understand **how to fine-tune language models effectively and build specialized AI applications using the latest fine-tuning techniques**.

Don't forget to [**sign up to the course!**](https://huggingface.co/smol-course)

## What does the course look like?

The course is composed of:

* _Foundational Units_: where you learn fine-tuning **concepts in theory**.
* _Hands-on_: where you'll learn **to use established fine-tuning frameworks** to adapt your models. These hands-on sections will have pre-configured environments.
* _Use case assignments_: where you'll apply the concepts you've learned to solve a real-world problem that you'll choose.
* _Collaborations_: We're collaborating with Hugging Face's partners to give you the latest fine-tuning implementations and tools.
 
This **course is a living project, evolving with your feedback and contributions!** Feel free to open issues and PRs in GitHub, and engage in discussions in our Discord server.

## What's the syllabus?

Here is the **general syllabus for the course**. A more detailed list of topics will be released with each unit.

| # | Topic | Description | Released |
| - | ----- | ----------- | -------- |
| 1 | Instruction Tuning | Supervised fine-tuning, chat templates, instruction following | ✅ |
| 2 | Evaluation | Benchmarks and custom domain evaluation | ✅ |
| 3 | Preference Alignment | Aligning models to human preferences with algorithms like DPO. | ✅ |
| 4 | Vision Language Models | Adapt and use multimodal models | ✅ |
| 5 | Reinforcement Learning | Optimizing models with based on reinforcement policies. | October |
| 6 | Synthetic Data | Generate synthetic datasets for custom domains | November |
| 7 | Award Ceremony | Showcase projects and celebrate | December |

## What are the prerequisites?

To be able to follow this course, you should have:

* Basic understanding of AI and LLM concepts
* Familiarity with Python programming and machine learning fundamentals
* Experience with PyTorch or similar deep learning frameworks
* Understanding of transformers architecture basics

If you don't have any of these, don't worry. Check out the [LLM Course](https://huggingface.co/learn/llm-course/) to get started.

> [!TIP]
> The above courses are not prerequisites in themselves, so if you understand the concepts of LLMs and transformers, you can start the course now!

## What tools do I need?

You only need 2 things:

* _A computer_ with an internet connection and preferably GPU access ([Hugging Face Pro](https://huggingface.co/pro) works great).
* An _account_: to access the course resources and create projects. If you don't have an account yet, you can create one [here](https://huggingface.co/join) (it's free).

## The Certification Process

You can choose to follow this course _in audit mode_, or do the activities and _get one of the two certificates we'll issue_. If you audit the course, you can participate in all the challenges and do assignments if you want, and **you don't need to notify us**.

The certification process is **completely free**:

* _To get a certification for fundamentals_: you need to complete Unit 1 of the course. This is intended for students that want to understand instruction tuning basics without building advanced applications.
* _To get a certificate of completion_: you need to complete all course units and submit a final project. This is intended for students that want to demonstrate mastery of fine-tuning techniques.

## What is the recommended pace?

Each chapter in this course is designed **to be completed in 1 week, with approximately 3-4 hours of work per week**.

Since there's a deadline, we provide you a recommended pace:

![Fine-Tuning Course thumbnail](https://github.com/huggingface/smol-course/blob/rerelease-chapter-1/schedule.png?raw=true)

## How to get the most out of the course?

To get the most out of the course, we have some advice:

1. [Join study groups in Discord](https://discord.gg/UrrTSsSyjb): Studying in groups is always easier. To do that, you need to join our discord server and verify your account.
2. **Do the quizzes and assignments**: The best way to learn is through hands-on practice and self-assessment.
3. **Define a schedule to stay in sync**: You can use our recommended pace schedule below or create yours.

![Course advice](https://huggingface.co/datasets/mcp-course/images/resolve/main/unit0/3.png)

## Who are we

About the authors:

### Ben Burtenshaw

Ben is a Machine Learning Engineer at Hugging Face who focuses on building LLM applications, with post training and agentic approaches. [Follow Ben on the Hub](https://huggingface.co/burtenshaw) to see his latest projects.

## Acknowledgments

We would like to extend our gratitude to the following individuals and partners for their invaluable contributions and support:

- [Hugging Face Transformers](https://huggingface.co/docs/transformers)
- [TRL (Transformer Reinforcement Learning)](https://huggingface.co/docs/trl)
- [PEFT (Parameter-Efficient Fine-Tuning)](https://huggingface.co/docs/peft)

## I found a bug, or I want to improve the course

Contributions are **welcome** 🤗

* If you _found a bug 🐛 in a notebook_, please [open an issue](https://github.com/huggingface/smol-course/issues/new) and **describe the problem**.
* If you _want to improve the course_, you can [open a Pull Request](https://github.com/huggingface/smol-course/pulls).
* If you _want to add a full section or a new unit_, the best is to [open an issue](https://github.com/huggingface/smol-course/issues/new) and **describe what content you want to add before starting to write it so that we can guide you**.

## I still have questions

Please ask your question in our discord server #fine-tuning-course-questions.

Now that you have all the information, let's get on board ⛵


<EditOnGithub source="https://github.com/huggingface/smol-course/blob/main/units/en/unit0/1.mdx" />