# 自動ベンチマーク

<CourseFloatingBanner chapter={10}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/smol-course/blob/main/notebooks/ja/4_evaluation/lighteval_evaluate_and_analyse_your_LLM.ipynb"},
]} />
    
自動ベンチマークは、さまざまなタスクや能力にわたって言語モデルを評価するための標準化されたツールとして機能します。これらはモデルの性能を理解するための有用な出発点を提供しますが、包括的な評価戦略の一部に過ぎないことを認識することが重要です。

## 自動ベンチマークの理解

自動ベンチマークは通常、事前に定義されたタスクと評価指標を持つキュレーションされたデータセットで構成されます。これらのベンチマークは、基本的な言語理解から複雑な推論まで、モデルのさまざまな側面を評価することを目的としています。自動ベンチマークの主な利点はその標準化にあります。これにより、異なるモデル間で一貫した比較が可能となり、再現性のある結果が得られます。

ただし、ベンチマークの性能が必ずしも実世界での有効性に直結するわけではないことを理解することが重要です。学術的なベンチマークで優れた成績を収めたモデルでも、特定のドメインアプリケーションや実際のユースケースでは苦労することがあります。

## ベンチマークとその限界

### 一般知識ベンチマーク

MMLU（Massive Multitask Language Understanding）は、科学から人文科学まで57の科目にわたる知識をテストします。包括的ではありますが、特定のドメインに必要な専門知識の深さを反映しているわけではありません。TruthfulQAは、モデルが一般的な誤解を再現する傾向を評価しますが、すべての形態の誤情報を捉えることはできません。

### 推論ベンチマーク
BBH（Big Bench Hard）とGSM8Kは、複雑な推論タスクに焦点を当てています。BBHは論理的思考と計画をテストし、GSM8Kは特に数学的な問題解決を対象としています。これらのベンチマークは分析能力を評価するのに役立ちますが、実世界のシナリオで必要とされる微妙な推論を完全に捉えることはできません。

### 言語理解
HELMは包括的な評価フレームワークを提供し、WinoGrandeは代名詞の曖昧性解消を通じて常識をテストします。これらのベンチマークは言語処理能力に関する洞察を提供しますが、自然な会話やドメイン固有の用語の複雑さを完全に表現することはできません。

## 代替評価アプローチ

多くの組織は、標準ベンチマークの限界に対処するために代替評価方法を開発しています：

### LLM-as-Judge
ある言語モデルを使用して別のモデルの出力を評価する方法がますます人気を集めています。このアプローチは、従来の指標よりも微妙なフィードバックを提供することができますが、それ自体のバイアスと限界も伴います。

### 評価アリーナ
AnthropicのConstitutional AI Arenaのようなプラットフォームでは、モデルが相互に対話し、制御された環境で互いを評価することができます。これにより、従来のベンチマークでは明らかにならない強みと弱みが明らかになります。

### カスタムベンチマークスイート
組織は、特定のニーズやユースケースに合わせた内部ベンチマークスイートを開発することがよくあります。これには、ドメイン固有の知識テストや実際の展開条件を反映した評価シナリオが含まれることがあります。

## 独自の評価戦略の作成

LightEvalを使用して標準ベンチマークを実行するのは簡単ですが、ユースケースに特化した評価方法の開発にも時間を投資する必要があります。

標準ベンチマークは有用なベースラインを提供しますが、それだけが評価方法であってはなりません。より包括的なアプローチを開発する方法は次のとおりです：

1. 関連する標準ベンチマークから始めて、ベースラインを確立し、他のモデルとの比較を可能にします。

2. ユースケースの特定の要件と課題を特定します。モデルが実際に実行するタスクは何ですか？どのようなエラーが最も問題になりますか？

3. 実際のユースケースを反映したカスタム評価データセットを開発します。これには次のようなものが含まれるかもしれません：
   - ドメインからの実際のユーザークエリ
   - 遭遇した一般的なエッジケース
   - 特に挑戦的なシナリオの例

4. 多層評価戦略の実装を検討します：
   - クイックフィードバックのための自動指標
   - 微妙な理解のための人間の評価
   - 専門家によるレビュー
   - 制御された環境でのA/Bテスト

## LightEvalを使用したベンチマーク

LightEvalタスクは特定の形式を使用して定義されます：
```
{suite}|{task}|{num_few_shot}|{auto_reduce}
```

- **suite**: ベンチマークスイート（例：'mmlu', 'truthfulqa'）
- **task**: スイート内の特定のタスク（例：'abstract_algebra'）
- **num_few_shot**: プロンプトに含める例の数（ゼロショットの場合は0）
- **auto_reduce**: プロンプトが長すぎる場合に少数ショットの例を自動的に削減するかどうか（0または1）

例：`"mmlu|abstract_algebra|0|0"`は、ゼロショット推論でMMLUの抽象代数学タスクを評価します。

### 評価パイプラインの例

特定のドメインに関連する自動ベンチマークの評価を設定して実行する完全な例を次に示します：

```python
from lighteval.tasks import Task, Pipeline
from transformers import AutoModelForCausalLM

# 評価するタスクを定義
domain_tasks = [
    "mmlu|anatomy|0|0",
    "mmlu|high_school_biology|0|0", 
    "mmlu|high_school_chemistry|0|0",
    "mmlu|professional_medicine|0|0"
]

# パイプラインパラメータを設定
pipeline_params = {
    "max_samples": 40,  # 評価するサンプル数
    "batch_size": 1,    # 推論のバッチサイズ
    "num_workers": 4    # ワーカープロセスの数
}

# 評価トラッカーを作成
evaluation_tracker = EvaluationTracker(
    output_path="./results",
    save_generations=True
)

# モデルを読み込み、パイプラインを作成
model = AutoModelForCausalLM.from_pretrained("your-model-name")
pipeline = Pipeline(
    tasks=domain_tasks,
    pipeline_parameters=pipeline_params,
    evaluation_tracker=evaluation_tracker,
    model=model
)

# 評価を実行
pipeline.evaluate()

# 結果を取得して表示
results = pipeline.get_results()
pipeline.show_results()
```

結果は次のような表形式で表示されます：
```
|                  Task                  |Version|Metric|Value |   |Stderr|
|----------------------------------------|------:|------|-----:|---|-----:|
|all                                     |       |acc   |0.3333|±  |0.1169|
|leaderboard:mmlu:_average:5             |       |acc   |0.3400|±  |0.1121|
|leaderboard:mmlu:anatomy:5              |      0|acc   |0.4500|±  |0.1141|
|leaderboard:mmlu:high_school_biology:5  |      0|acc   |0.1500|±  |0.0819|
```

結果をpandas DataFrameで処理し、視覚化や表現を自由に行うこともできます。

# 次のステップ

⏩ [カスタムドメイン評価](./custom_evaluation.md)を探索し、特定のニーズに合わせた評価パイプラインの作成方法を学びましょう


<EditOnGithub source="https://github.com/huggingface/smol-course/blob/main/units/ja/unit4/2.md" />