# VLMファインチューニング
<CourseFloatingBanner chapter={10}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/smol-course/blob/main/notebooks/ja/5_vision_language_models/vlm_sft_sample.ipynb"},
]} />
    
## 効率的なファインチューニング

### 量子化
量子化は、モデルの重みとアクティベーションの精度を低下させ、メモリ使用量を大幅に削減し、計算速度を向上させます。たとえば、`float32`から`bfloat16`に切り替えると、パラメータごとのメモリ要件が半分になり、パフォーマンスを維持できます。より積極的な圧縮のために、8ビットおよび4ビットの量子化を使用してメモリ使用量をさらに削減できますが、精度が若干低下する可能性があります。これらの技術は、モデルとオプティマイザの設定の両方に適用でき、リソースが限られたハードウェアでの効率的なトレーニングを可能にします。

### PEFT & LoRA
モジュール3で紹介されたように、LoRA（Low-Rank Adaptation）は、元のモデルの重みを固定したまま、コンパクトなランク分解行列を学習することに焦点を当てています。これにより、トレーニング可能なパラメータの数が大幅に削減され、リソース要件が大幅に削減されます。LoRAはPEFTと統合されることで、大規模モデルのファインチューニングを可能にし、トレーニング可能なパラメータの小さなサブセットのみを調整します。このアプローチは、タスク固有の適応に特に効果的であり、数十億のトレーニング可能なパラメータを数百万に削減しながらパフォーマンスを維持します。

### バッチサイズの最適化
ファインチューニングのバッチサイズを最適化するには、大きな値から始め、メモリ不足（OOM）エラーが発生した場合は減らします。`gradient_accumulation_steps`を増やして補い、複数の更新にわたって合計バッチサイズを実質的に維持します。さらに、`gradient_checkpointing`を有効にして、逆伝播中に中間状態を再計算することでメモリ使用量を削減し、計算時間を犠牲にしてアクティベーションメモリ要件を削減します。これらの戦略は、ハードウェアの利用を最大化し、メモリ制約を克服するのに役立ちます。

```python
from transformers import TrainingArguments

training_args = TrainingArguments(
    output_dir="./fine_tuned_model",  # モデルチェックポイントのディレクトリ
    per_device_train_batch_size=4,   # デバイスごとのバッチサイズ（GPU/TPU）
    num_train_epochs=3,              # トレーニングの総エポック数
    learning_rate=5e-5,              # 学習率
    save_steps=1000,                 # 1000ステップごとにチェックポイントを保存
    bf16=True,                       # トレーニングに混合精度を使用
    gradient_checkpointing=True,     # アクティベーションメモリ使用量を削減するために有効にする
    gradient_accumulation_steps=16,  # 16ステップにわたって勾配を蓄積
    logging_steps=50                 # 50ステップごとにメトリクスをログ
)
```

## **教師ありファインチューニング（SFT）**

教師ありファインチューニング（SFT）は、事前トレーニングされたビジョン言語モデル（VLM）を特定のタスクに適応させるために、画像と対応するテキストを含むラベル付きデータセットを活用するプロセスです。この方法は、視覚質問応答、画像キャプション生成、チャート解釈などのドメイン固有またはタスク固有の機能を実行するモデルの能力を向上させます。

### **概要**
SFTは、ベースモデルの一般的な能力が不足する場合に、特定のドメインや特定の問題を解決するためにVLMを専門化する必要がある場合に不可欠です。たとえば、モデルが独自の視覚的特徴やドメイン固有の用語に苦労する場合、SFTはラベル付きデータから学習することでこれらの領域に焦点を当てることができます。

SFTは非常に効果的ですが、いくつかの制限があります：
- **データ依存性**：タスクに合わせた高品質のラベル付きデータセットが必要です。
- **計算リソース**：大規模なVLMのファインチューニングはリソース集約的です。
- **過学習のリスク**：モデルがあまりにも狭くファインチューニングされると、一般化能力を失う可能性があります。

これらの課題にもかかわらず、SFTは特定のコンテキストでのモデルパフォーマンスを向上させるための強力な手法です。

### **使用方法**
1. **データ準備**：画像とテキストのペアを含むラベル付きデータセットから始めます。たとえば、チャート分析のタスクでは、`HuggingFaceM4/ChartQA`データセットにはチャート画像、クエリ、および簡潔な応答が含まれています。

2. **モデル設定**：タスクに適した事前トレーニングされたVLM（例：`HuggingFaceTB/SmolVLM-Instruct`）と、テキストと画像の入力を準備するためのプロセッサをロードします。モデルを教師あり学習に設定し、ハードウェアに適した設定を行います。

3. **ファインチューニングプロセス**：
   - **データのフォーマット**：データセットをチャットボットのような形式に構造化し、システムメッセージ、ユーザークエリ、および対応する回答をペアにします。
   - **トレーニング設定**：Hugging Faceの`TrainingArguments`やTRLの`SFTConfig`などのツールを使用してトレーニングパラメータを設定します。これには、バッチサイズ、学習率、およびリソース使用を最適化するための勾配蓄積ステップが含まれます。
   - **最適化技術**：トレーニング中のメモリを節約するために**gradient checkpointing**を使用します。メモリ要件を削減し、計算速度を向上させるために量子化モデルを使用します。
   - TRLライブラリの`SFTTrainer`トレーナーを使用して、トレーニングプロセスを簡素化します。

## 好みの最適化

好みの最適化、特に直接好みの最適化（DPO）は、ビジョン言語モデル（VLM）を人間の好みに合わせるためのトレーニング手法です。事前定義された指示に厳密に従うのではなく、モデルは人間が主観的に好む出力を優先することを学習します。このアプローチは、創造的な判断、微妙な推論、または許容される回答が異なるタスクに特に有用です。

### **概要**
好みの最適化は、主観的な人間の好みがタスクの成功にとって重要なシナリオに対処します。好みをエンコードしたデータセットでファインチューニングすることで、DPOはモデルの応答生成能力を強化し、ユーザーの期待に文脈的およびスタイル的に一致させます。この方法は、創造的な執筆、顧客との対話、または複数の選択肢があるシナリオなどのタスクに特に効果的です。

その利点にもかかわらず、好みの最適化にはいくつかの課題があります：
- **データ品質**：高品質の好みが注釈されたデータセットが必要であり、データ収集がボトルネックになることがあります。
- **複雑さ**：トレーニングには、好みのペアワイズサンプリングや計算リソースのバランスなどの高度なプロセスが含まれることがあります。

好みのデータセットは、候補出力間の明確な好みをキャプチャする必要があります。たとえば、データセットは質問と2つの応答（1つは好まれ、もう1つは受け入れられない）をペアにすることがあります。モデルは、完全に正しくなくても、より人間の判断に一致する好ましい応答を予測することを学習します。

### **使用方法**
1. **データセットの準備**  
   トレーニングには、好みがラベル付けされたデータセットが重要です。各例は通常、プロンプト（例：画像と質問）と2つの候補応答（1つは選択され、もう1つは拒否される）で構成されます。たとえば：

   - **質問**：家族は何人ですか？  
     - **拒否**：画像には家族に関する情報はありません。  
     - **選択**：画像には18,000家族のユニオン組織のテーブル設定が表示されています。  

   データセットは、モデルに完全に正しくなくても、より人間の判断に一致する好ましい応答を優先することを教えます。

2. **モデル設定**  
   事前トレーニングされたVLMをロードし、DPOをサポートするHugging FaceのTRLライブラリと統合し、テキストと画像の入力を準備するためのプロセッサを使用します。モデルを教師あり学習に設定し、ハードウェアに適した設定を行います。

3. **トレーニングパイプライン**  
   トレーニングには、DPO固有のパラメータの設定が含まれます。プロセスの概要は次のとおりです：

   - **データセットのフォーマット**：各サンプルをプロンプト、画像、および候補応答で構成します。
   - **損失関数**：好みに基づく損失関数を使用して、好ましい出力を選択するようにモデルを最適化します。
   - **効率的なトレーニング**：量子化、勾配蓄積、LoRAアダプタなどの技術を組み合わせて、メモリと計算を最適化します。

## リソース

- [Hugging Face Learn: Supervised Fine-Tuning VLMs](https://huggingface.co/learn/cookbook/fine_tuning_vlm_trl) 
- [Hugging Face Learn: Supervised Fine-Tuning SmolVLM](https://huggingface.co/learn/cookbook/fine_tuning_smol_vlm_sft_trl)  
- [Hugging Face Learn: Preference Optimization Fine-Tuning SmolVLM](https://huggingface.co/learn/cookbook/fine_tuning_vlm_dpo_smolvlm_instruct)  
- [Hugging Face Blog: Preference Optimization for VLMs](https://huggingface.co/blog/dpo_vlm)

## 次のステップ

⏩ この統一アプローチを好みの最適化に実装するには、[vlm_finetune_sample.ipynb](../../../notebooks/ja/5_vision_language_models/vlm_finetune_sample.ipynb)を試してください。


<EditOnGithub source="https://github.com/huggingface/smol-course/blob/main/units/ja/unit5/3.md" />