import{s as $t,n as Zt,o as kt}from"../chunks/scheduler.85c25b89.js";import{S as xt,i as Ct,g as p,s as l,r as i,A as Wt,h as m,f as e,c as n,j as Ut,u as o,x as M,k as It,y as Nt,a,v as r,d as c,t as h,w as g}from"../chunks/index.c9837788.js";import{C as Q}from"../chunks/CodeBlock.52fa569e.js";import{H as R,E as Bt}from"../chunks/EditOnGithub.b65eee75.js";function vt(gt){let J,Y,X,S,j,A,d,Mt='<strong>SK ResNet</strong> is a variant of a <a href="https://www.paperswithcode.com/method/resnet" rel="nofollow">ResNet</a> that employs a <a href="https://paperswithcode.com/method/selective-kernel" rel="nofollow">Selective Kernel</a> unit. In general, all the large kernel convolutions in the original bottleneck blocks in ResNet are replaced by the proposed <a href="https://paperswithcode.com/method/selective-kernel-convolution" rel="nofollow">SK convolutions</a>, enabling the network to choose appropriate receptive field sizes in an adaptive manner.',z,w,H,T,Jt="To load a pretrained model:",F,y,L,u,jt="To load and preprocess the image:",q,f,D,b,dt="To get the model predictions:",P,U,K,I,wt="To get the top-5 predictions class names:",O,$,tt,Z,Tt="Replace the model name with the variant you want to use, e.g. <code>skresnet18</code>. You can find the IDs in the model summaries at the top of this page.",st,k,yt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',et,x,at,C,ut="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",lt,W,nt,N,ft=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,pt,B,mt,v,bt='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',it,G,ot,E,rt,V,ct,_,ht;return j=new R({props:{title:"SK-ResNet",local:"sk-resnet",headingTag:"h1"}}),w=new R({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),y=new Q({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3NrcmVzbmV0MTgnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;skresnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new Q({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),$=new Q({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),x=new R({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),W=new Q({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnc2tyZXNuZXQxOCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;skresnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),B=new R({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),G=new R({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new Q({props:{code:"JTQwbWlzYyU3QmxpMjAxOXNlbGVjdGl2ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCU2VsZWN0aXZlJTIwS2VybmVsJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JYaWFuZyUyMExpJTIwYW5kJTIwV2VuaGFpJTIwV2FuZyUyMGFuZCUyMFhpYW9saW4lMjBIdSUyMGFuZCUyMEppYW4lMjBZYW5nJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTAzLjA2NTg2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{li2019selective,
      title={Selective Kernel Networks}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Xiang Li and Wenhai Wang and Xiaolin Hu and Jian Yang}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1903.06586}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),V=new Bt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/skresnet.mdx"}}),{c(){J=p("meta"),Y=l(),X=p("p"),S=l(),i(j.$$.fragment),A=l(),d=p("p"),d.innerHTML=Mt,z=l(),i(w.$$.fragment),H=l(),T=p("p"),T.textContent=Jt,F=l(),i(y.$$.fragment),L=l(),u=p("p"),u.textContent=jt,q=l(),i(f.$$.fragment),D=l(),b=p("p"),b.textContent=dt,P=l(),i(U.$$.fragment),K=l(),I=p("p"),I.textContent=wt,O=l(),i($.$$.fragment),tt=l(),Z=p("p"),Z.innerHTML=Tt,st=l(),k=p("p"),k.innerHTML=yt,et=l(),i(x.$$.fragment),at=l(),C=p("p"),C.textContent=ut,lt=l(),i(W.$$.fragment),nt=l(),N=p("p"),N.innerHTML=ft,pt=l(),i(B.$$.fragment),mt=l(),v=p("p"),v.innerHTML=bt,it=l(),i(G.$$.fragment),ot=l(),i(E.$$.fragment),rt=l(),i(V.$$.fragment),ct=l(),_=p("p"),this.h()},l(t){const s=Wt("svelte-u9bgzb",document.head);J=m(s,"META",{name:!0,content:!0}),s.forEach(e),Y=n(t),X=m(t,"P",{}),Ut(X).forEach(e),S=n(t),o(j.$$.fragment,t),A=n(t),d=m(t,"P",{"data-svelte-h":!0}),M(d)!=="svelte-bj35wp"&&(d.innerHTML=Mt),z=n(t),o(w.$$.fragment,t),H=n(t),T=m(t,"P",{"data-svelte-h":!0}),M(T)!=="svelte-18ywhxh"&&(T.textContent=Jt),F=n(t),o(y.$$.fragment,t),L=n(t),u=m(t,"P",{"data-svelte-h":!0}),M(u)!=="svelte-1c2ipa8"&&(u.textContent=jt),q=n(t),o(f.$$.fragment,t),D=n(t),b=m(t,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1n9qsq1"&&(b.textContent=dt),P=n(t),o(U.$$.fragment,t),K=n(t),I=m(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-19cnvx1"&&(I.textContent=wt),O=n(t),o($.$$.fragment,t),tt=n(t),Z=m(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-17aafbm"&&(Z.innerHTML=Tt),st=n(t),k=m(t,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1wmi3ea"&&(k.innerHTML=yt),et=n(t),o(x.$$.fragment,t),at=n(t),C=m(t,"P",{"data-svelte-h":!0}),M(C)!=="svelte-9sr7nh"&&(C.textContent=ut),lt=n(t),o(W.$$.fragment,t),nt=n(t),N=m(t,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1kguc51"&&(N.innerHTML=ft),pt=n(t),o(B.$$.fragment,t),mt=n(t),v=m(t,"P",{"data-svelte-h":!0}),M(v)!=="svelte-xtxxu6"&&(v.innerHTML=bt),it=n(t),o(G.$$.fragment,t),ot=n(t),o(E.$$.fragment,t),rt=n(t),o(V.$$.fragment,t),ct=n(t),_=m(t,"P",{}),Ut(_).forEach(e),this.h()},h(){It(J,"name","hf:doc:metadata"),It(J,"content",Gt)},m(t,s){Nt(document.head,J),a(t,Y,s),a(t,X,s),a(t,S,s),r(j,t,s),a(t,A,s),a(t,d,s),a(t,z,s),r(w,t,s),a(t,H,s),a(t,T,s),a(t,F,s),r(y,t,s),a(t,L,s),a(t,u,s),a(t,q,s),r(f,t,s),a(t,D,s),a(t,b,s),a(t,P,s),r(U,t,s),a(t,K,s),a(t,I,s),a(t,O,s),r($,t,s),a(t,tt,s),a(t,Z,s),a(t,st,s),a(t,k,s),a(t,et,s),r(x,t,s),a(t,at,s),a(t,C,s),a(t,lt,s),r(W,t,s),a(t,nt,s),a(t,N,s),a(t,pt,s),r(B,t,s),a(t,mt,s),a(t,v,s),a(t,it,s),r(G,t,s),a(t,ot,s),r(E,t,s),a(t,rt,s),r(V,t,s),a(t,ct,s),a(t,_,s),ht=!0},p:Zt,i(t){ht||(c(j.$$.fragment,t),c(w.$$.fragment,t),c(y.$$.fragment,t),c(f.$$.fragment,t),c(U.$$.fragment,t),c($.$$.fragment,t),c(x.$$.fragment,t),c(W.$$.fragment,t),c(B.$$.fragment,t),c(G.$$.fragment,t),c(E.$$.fragment,t),c(V.$$.fragment,t),ht=!0)},o(t){h(j.$$.fragment,t),h(w.$$.fragment,t),h(y.$$.fragment,t),h(f.$$.fragment,t),h(U.$$.fragment,t),h($.$$.fragment,t),h(x.$$.fragment,t),h(W.$$.fragment,t),h(B.$$.fragment,t),h(G.$$.fragment,t),h(E.$$.fragment,t),h(V.$$.fragment,t),ht=!1},d(t){t&&(e(Y),e(X),e(S),e(A),e(d),e(z),e(H),e(T),e(F),e(L),e(u),e(q),e(D),e(b),e(P),e(K),e(I),e(O),e(tt),e(Z),e(st),e(k),e(et),e(at),e(C),e(lt),e(nt),e(N),e(pt),e(mt),e(v),e(it),e(ot),e(rt),e(ct),e(_)),e(J),g(j,t),g(w,t),g(y,t),g(f,t),g(U,t),g($,t),g(x,t),g(W,t),g(B,t),g(G,t),g(E,t),g(V,t)}}}const Gt='{"title":"SK-ResNet","local":"sk-resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Et(gt){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rt extends xt{constructor(J){super(),Ct(this,J,Et,vt,$t,{})}}export{Rt as component};
