import{s as Xa,o as Ra,n as P}from"../chunks/scheduler.182ea377.js";import{S as Ca,i as xa,g as m,s as n,r as Z,A as $a,h as d,f as t,c as p,j as va,u as U,x as u,k as x,y as Va,a,v as J,d as b,t as w,w as T}from"../chunks/index.abf12888.js";import{T as He}from"../chunks/Tip.230e2334.js";import{C}from"../chunks/CodeBlock.57fe6e13.js";import{H as L}from"../chunks/Heading.16916d63.js";import{H as Ya,a as At}from"../chunks/HfOption.fc88c804.js";function Ba(X){let i,j='Learn how to load an IP-Adapter in the <a href="../using-diffusers/loading_adapters#ip-adapter">Load adapters</a> guide, and make sure you check out the <a href="../using-diffusers/loading_adapters#ip-adapter-plus">IP-Adapter Plus</a> section which requires manually loading the image encoder.';return{c(){i=m("p"),i.innerHTML=j},l(r){i=d(r,"P",{"data-svelte-h":!0}),u(i)!=="svelte-1lc7m22"&&(i.innerHTML=j)},m(r,f){a(r,i,f)},p:P,d(r){r&&t(i)}}}function Fa(X){let i,j="Crafting the precise text prompt to generate the image you want can be difficult because it may not always capture what you’d like to express. Adding an image alongside the text prompt helps the model better understand what it should generate and can lead to more accurate results.",r,f,G='Load a Stable Diffusion XL (SDXL) model and insert an IP-Adapter into the model with the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method. Use the <code>subfolder</code> parameter to load the SDXL model weights.',_,M,I,o,y="Create a text prompt and load an image prompt before passing them to the pipeline to generate an image.",k,h,v,W,R='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner_2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',c;return M=new C({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIyaXAtYWRhcHRlcl9zZHhsLmJpbiUyMiklMEFwaXBlbGluZS5zZXRfaXBfYWRhcHRlcl9zY2FsZSgwLjYp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)`,wrap:!1}}),h=new C({props:{code:"aW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX2FkYXB0ZXJfZGluZXIucG5nJTIyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYSUyMHBvbGFyJTIwYmVhciUyMHNpdHRpbmclMjBpbiUyMGElMjBjaGFpciUyMGRyaW5raW5nJTIwYSUyMG1pbGtzaGFrZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmRlZm9ybWVkJTJDJTIwdWdseSUyQyUyMHdyb25nJTIwcHJvcG9ydGlvbiUyQyUyMGxvdyUyMHJlcyUyQyUyMGJhZCUyMGFuYXRvbXklMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBsb3clMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner.png&quot;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;a polar bear sitting in a chair drinking a milkshake&quot;</span>,
    ip_adapter_image=image,
    negative_prompt=<span class="hljs-string">&quot;deformed, ugly, wrong proportion, low res, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    generator=generator,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){i=m("p"),i.textContent=j,r=n(),f=m("p"),f.innerHTML=G,_=n(),Z(M.$$.fragment),I=n(),o=m("p"),o.textContent=y,k=n(),Z(h.$$.fragment),v=n(),W=m("div"),W.innerHTML=R,this.h()},l(s){i=d(s,"P",{"data-svelte-h":!0}),u(i)!=="svelte-1kuilfu"&&(i.textContent=j),r=p(s),f=d(s,"P",{"data-svelte-h":!0}),u(f)!=="svelte-10sdaqe"&&(f.innerHTML=G),_=p(s),U(M.$$.fragment,s),I=p(s),o=d(s,"P",{"data-svelte-h":!0}),u(o)!=="svelte-yvbljp"&&(o.textContent=y),k=p(s),U(h.$$.fragment,s),v=p(s),W=d(s,"DIV",{class:!0,"data-svelte-h":!0}),u(W)!=="svelte-4jgjc0"&&(W.innerHTML=R),this.h()},h(){x(W,"class","flex flex-row gap-4")},m(s,g){a(s,i,g),a(s,r,g),a(s,f,g),a(s,_,g),J(M,s,g),a(s,I,g),a(s,o,g),a(s,k,g),J(h,s,g),a(s,v,g),a(s,W,g),c=!0},p:P,i(s){c||(b(M.$$.fragment,s),b(h.$$.fragment,s),c=!0)},o(s){w(M.$$.fragment,s),w(h.$$.fragment,s),c=!1},d(s){s&&(t(i),t(r),t(f),t(_),t(I),t(o),t(k),t(v),t(W)),T(M,s),T(h,s)}}}function Ha(X){let i,j="IP-Adapter can also help with image-to-image by guiding the model to generate an image that resembles the original image and the image prompt.",r,f,G='Load a Stable Diffusion XL (SDXL) model and insert an IP-Adapter into the model with the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method. Use the <code>subfolder</code> parameter to load the SDXL model weights.',_,M,I,o,y="Pass the original image and the IP-Adapter image prompt to the pipeline to generate an image. Providing a text prompt to the pipeline is optional, but in this example, a text prompt is used to increase image quality.",k,h,v,W,R='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_3.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',c;return M=new C({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5sb2FkX2lwX2FkYXB0ZXIoJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNkeGxfbW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkeGwuYmluJTIyKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKDAuNik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForImage2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)`,wrap:!1}}),h=new C({props:{code:"aW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX2FkYXB0ZXJfYmVhcl8xLnBuZyUyMiklMEFpcF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9iZWFyXzIucG5nJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDQpJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYmVzdCUyMHF1YWxpdHklMkMlMjBoaWdoJTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEaXBfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEElMjAlMjAlMjAlMjBzdHJlbmd0aCUzRDAuNiUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png&quot;</span>)
ip_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_2.png&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">4</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;best quality, high quality&quot;</span>,
    image=image,
    ip_adapter_image=ip_image,
    generator=generator,
    strength=<span class="hljs-number">0.6</span>,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){i=m("p"),i.textContent=j,r=n(),f=m("p"),f.innerHTML=G,_=n(),Z(M.$$.fragment),I=n(),o=m("p"),o.textContent=y,k=n(),Z(h.$$.fragment),v=n(),W=m("div"),W.innerHTML=R,this.h()},l(s){i=d(s,"P",{"data-svelte-h":!0}),u(i)!=="svelte-avn1rr"&&(i.textContent=j),r=p(s),f=d(s,"P",{"data-svelte-h":!0}),u(f)!=="svelte-10sdaqe"&&(f.innerHTML=G),_=p(s),U(M.$$.fragment,s),I=p(s),o=d(s,"P",{"data-svelte-h":!0}),u(o)!=="svelte-10sbd9g"&&(o.textContent=y),k=p(s),U(h.$$.fragment,s),v=p(s),W=d(s,"DIV",{class:!0,"data-svelte-h":!0}),u(W)!=="svelte-8bse9r"&&(W.innerHTML=R),this.h()},h(){x(W,"class","flex gap-4")},m(s,g){a(s,i,g),a(s,r,g),a(s,f,g),a(s,_,g),J(M,s,g),a(s,I,g),a(s,o,g),a(s,k,g),J(h,s,g),a(s,v,g),a(s,W,g),c=!0},p:P,i(s){c||(b(M.$$.fragment,s),b(h.$$.fragment,s),c=!0)},o(s){w(M.$$.fragment,s),w(h.$$.fragment,s),c=!1},d(s){s&&(t(i),t(r),t(f),t(_),t(I),t(o),t(k),t(v),t(W)),T(M,s),T(h,s)}}}function Na(X){let i,j="IP-Adapter is also useful for inpainting because the image prompt allows you to be much more specific about what you’d like to generate.",r,f,G='Load a Stable Diffusion XL (SDXL) model and insert an IP-Adapter into the model with the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method. Use the <code>subfolder</code> parameter to load the SDXL model weights.',_,M,I,o,y="Pass a prompt, the original image, mask image, and the IP-Adapter image prompt to the pipeline to generate an image.",k,h,v,W,R='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_gummy.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',c;return M=new C({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMjJkaWZmdXNlcnMlMkZzdGFibGUtZGlmZnVzaW9uLXhsLTEuMC1pbnBhaW50aW5nLTAuMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5sb2FkX2lwX2FkYXB0ZXIoJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNkeGxfbW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkeGwuYmluJTIyKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKDAuNik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForInpainting.from_pretrained(<span class="hljs-string">&quot;diffusers/stable-diffusion-xl-1.0-inpainting-0.1&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)`,wrap:!1}}),h=new C({props:{code:"bWFza19pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9tYXNrLnBuZyUyMiklMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9iZWFyXzEucG5nJTIyKSUwQWlwX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpcF9hZGFwdGVyX2d1bW15LnBuZyUyMiklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCg0KSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBjdXRlJTIwZ3VtbXklMjBiZWFyJTIwd2F2aW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_mask.png&quot;</span>)
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png&quot;</span>)
ip_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_gummy.png&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">4</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;a cute gummy bear waving&quot;</span>,
    image=image,
    mask_image=mask_image,
    ip_adapter_image=ip_image,
    generator=generator,
    num_inference_steps=<span class="hljs-number">100</span>,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){i=m("p"),i.textContent=j,r=n(),f=m("p"),f.innerHTML=G,_=n(),Z(M.$$.fragment),I=n(),o=m("p"),o.textContent=y,k=n(),Z(h.$$.fragment),v=n(),W=m("div"),W.innerHTML=R,this.h()},l(s){i=d(s,"P",{"data-svelte-h":!0}),u(i)!=="svelte-11wjoqr"&&(i.textContent=j),r=p(s),f=d(s,"P",{"data-svelte-h":!0}),u(f)!=="svelte-10sdaqe"&&(f.innerHTML=G),_=p(s),U(M.$$.fragment,s),I=p(s),o=d(s,"P",{"data-svelte-h":!0}),u(o)!=="svelte-1wfeic0"&&(o.textContent=y),k=p(s),U(h.$$.fragment,s),v=p(s),W=d(s,"DIV",{class:!0,"data-svelte-h":!0}),u(W)!=="svelte-5iola2"&&(W.innerHTML=R),this.h()},h(){x(W,"class","flex gap-4")},m(s,g){a(s,i,g),a(s,r,g),a(s,f,g),a(s,_,g),J(M,s,g),a(s,I,g),a(s,o,g),a(s,k,g),J(h,s,g),a(s,v,g),a(s,W,g),c=!0},p:P,i(s){c||(b(M.$$.fragment,s),b(h.$$.fragment,s),c=!0)},o(s){w(M.$$.fragment,s),w(h.$$.fragment,s),c=!1},d(s){s&&(t(i),t(r),t(f),t(_),t(I),t(o),t(k),t(v),t(W)),T(M,s),T(h,s)}}}function Qa(X){let i,j='If you’re planning on offloading the model to the CPU, make sure you run it after you’ve loaded the IP-Adapter. When you call <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENTextImagePipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> before loading the IP-Adapter, it offloads the image encoder module to the CPU and it’ll return an error when you try to run the pipeline.';return{c(){i=m("p"),i.innerHTML=j},l(r){i=d(r,"P",{"data-svelte-h":!0}),u(i)!=="svelte-pqh7g3"&&(i.innerHTML=j)},m(r,f){a(r,i,f)},p:P,d(r){r&&t(i)}}}function Sa(X){let i,j='IP-Adapter can also help you generate videos that are more aligned with your text prompt. For example, let’s load <a href="../api/pipelines/animatediff">AnimateDiff</a> with its motion adapter and insert an IP-Adapter into the model with the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method.',r,f,G,_,M,I,o="Pass a prompt and an image prompt to the pipeline to generate a short video.",y,k,h,v,W='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/gummy_bear.gif"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated video</figcaption></div>',R;return f=new He({props:{warning:!0,$$slots:{default:[Qa]},$$scope:{ctx:X}}}),_=new C({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQW5pbWF0ZURpZmZQaXBlbGluZSUyQyUyMERESU1TY2hlZHVsZXIlMkMlMjBNb3Rpb25BZGFwdGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWFkYXB0ZXIlMjAlM0QlMjBNb3Rpb25BZGFwdGVyLmZyb21fcHJldHJhaW5lZCglMjJndW95d3clMkZhbmltYXRlZGlmZi1tb3Rpb24tYWRhcHRlci12MS01LTIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZWxpbmUlMjAlM0QlMjBBbmltYXRlRGlmZlBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJlbWlsaWFuSlIlMkZlcGlDUmVhbGlzbSUyMiUyQyUyMG1vdGlvbl9hZGFwdGVyJTNEYWRhcHRlciUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFzY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJlbWlsaWFuSlIlMkZlcGlDUmVhbGlzbSUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfc2FtcGxlJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjB0aW1lc3RlcF9zcGFjaW5nJTNEJTIybGluc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBiZXRhX3NjaGVkdWxlJTNEJTIybGluZWFyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3RlcHNfb2Zmc2V0JTNEMSUyQyUwQSklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBzY2hlZHVsZXIlMEFwaXBlbGluZS5lbmFibGVfdmFlX3NsaWNpbmcoKSUwQSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
pipeline = AnimateDiffPipeline.from_pretrained(<span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>, motion_adapter=adapter, torch_dtype=torch.float16)
scheduler = DDIMScheduler.from_pretrained(
    <span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipeline.scheduler = scheduler
pipeline.enable_vae_slicing()

pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),k=new C({props:{code:"aXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9pbnBhaW50LnBuZyUyMiklMEElMEFvdXRwdXQlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJBJTIwY3V0ZSUyMGd1bW15JTIwYmVhciUyMHdhdmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmJhZCUyMHF1YWxpdHklMkMlMjB3b3JzZSUyMHF1YWxpdHklMkMlMjBsb3clMjByZXNvbHV0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2FkYXB0ZXJfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuNSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTJDJTBBKSUwQWZyYW1lcyUyMCUzRCUyMG91dHB1dC5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX2dpZihmcmFtZXMlMkMlMjAlMjJndW1teV9iZWFyLmdpZiUyMik=",highlighted:`ip_adapter_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png&quot;</span>)

output = pipeline(
    prompt=<span class="hljs-string">&quot;A cute gummy bear waving&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality, low resolution&quot;</span>,
    ip_adapter_image=ip_adapter_image,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;gummy_bear.gif&quot;</span>)`,wrap:!1}}),{c(){i=m("p"),i.innerHTML=j,r=n(),Z(f.$$.fragment),G=n(),Z(_.$$.fragment),M=n(),I=m("p"),I.textContent=o,y=n(),Z(k.$$.fragment),h=n(),v=m("div"),v.innerHTML=W,this.h()},l(c){i=d(c,"P",{"data-svelte-h":!0}),u(i)!=="svelte-10zqvoq"&&(i.innerHTML=j),r=p(c),U(f.$$.fragment,c),G=p(c),U(_.$$.fragment,c),M=p(c),I=d(c,"P",{"data-svelte-h":!0}),u(I)!=="svelte-a6opnh"&&(I.textContent=o),y=p(c),U(k.$$.fragment,c),h=p(c),v=d(c,"DIV",{class:!0,"data-svelte-h":!0}),u(v)!=="svelte-ihoum9"&&(v.innerHTML=W),this.h()},h(){x(v,"class","flex flex-row gap-4")},m(c,s){a(c,i,s),a(c,r,s),J(f,c,s),a(c,G,s),J(_,c,s),a(c,M,s),a(c,I,s),a(c,y,s),J(k,c,s),a(c,h,s),a(c,v,s),R=!0},p(c,s){const g={};s&2&&(g.$$scope={dirty:s,ctx:c}),f.$set(g)},i(c){R||(b(f.$$.fragment,c),b(_.$$.fragment,c),b(k.$$.fragment,c),R=!0)},o(c){w(f.$$.fragment,c),w(_.$$.fragment,c),w(k.$$.fragment,c),R=!1},d(c){c&&(t(i),t(r),t(G),t(M),t(I),t(y),t(h),t(v)),T(f,c),T(_,c),T(k,c)}}}function za(X){let i,j,r,f,G,_,M,I;return i=new At({props:{id:"tasks",option:"Text-to-image",$$slots:{default:[Fa]},$$scope:{ctx:X}}}),r=new At({props:{id:"tasks",option:"Image-to-image",$$slots:{default:[Ha]},$$scope:{ctx:X}}}),G=new At({props:{id:"tasks",option:"Inpainting",$$slots:{default:[Na]},$$scope:{ctx:X}}}),M=new At({props:{id:"tasks",option:"Video",$$slots:{default:[Sa]},$$scope:{ctx:X}}}),{c(){Z(i.$$.fragment),j=n(),Z(r.$$.fragment),f=n(),Z(G.$$.fragment),_=n(),Z(M.$$.fragment)},l(o){U(i.$$.fragment,o),j=p(o),U(r.$$.fragment,o),f=p(o),U(G.$$.fragment,o),_=p(o),U(M.$$.fragment,o)},m(o,y){J(i,o,y),a(o,j,y),J(r,o,y),a(o,f,y),J(G,o,y),a(o,_,y),J(M,o,y),I=!0},p(o,y){const k={};y&2&&(k.$$scope={dirty:y,ctx:o}),i.$set(k);const h={};y&2&&(h.$$scope={dirty:y,ctx:o}),r.$set(h);const v={};y&2&&(v.$$scope={dirty:y,ctx:o}),G.$set(v);const W={};y&2&&(W.$$scope={dirty:y,ctx:o}),M.$set(W)},i(o){I||(b(i.$$.fragment,o),b(r.$$.fragment,o),b(G.$$.fragment,o),b(M.$$.fragment,o),I=!0)},o(o){w(i.$$.fragment,o),w(r.$$.fragment,o),w(G.$$.fragment,o),w(M.$$.fragment,o),I=!1},d(o){o&&(t(j),t(f),t(_)),T(i,o),T(r,o),T(G,o),T(M,o)}}}function Aa(X){let i,j="While calling <code>load_ip_adapter()</code>, pass <code>low_cpu_mem_usage=True</code> to speed up the loading time.";return{c(){i=m("p"),i.innerHTML=j},l(r){i=d(r,"P",{"data-svelte-h":!0}),u(i)!=="svelte-8g51iy"&&(i.innerHTML=j)},m(r,f){a(r,i,f)},p:P,d(r){r&&t(i)}}}function qa(X){let i,j='Read the <a href="../using-diffusers/loading_adapters#ip-adapter-plus">IP-Adapter Plus</a> section to learn why you need to manually load the image encoder.';return{c(){i=m("p"),i.innerHTML=j},l(r){i=d(r,"P",{"data-svelte-h":!0}),u(i)!=="svelte-apa7ha"&&(i.innerHTML=j)},m(r,f){a(r,i,f)},p:P,d(r){r&&t(i)}}}function Ea(X){let i,j="For optimal results, provide the output height and width to <code>IPAdapterMaskProcessor.preprocess()</code>. This ensures that masks with differing aspect ratios are appropriately stretched. If the input masks already match the aspect ratio of the generated image, specifying height and width can be omitted.";return{c(){i=m("p"),i.innerHTML=j},l(r){i=d(r,"P",{"data-svelte-h":!0}),u(i)!=="svelte-tm9bbs"&&(i.innerHTML=j)},m(r,f){a(r,i,f)},p:P,d(r){r&&t(i)}}}function La(X){let i,j,r,f,G,_,M,I='<a href="https://hf.co/papers/2308.06721" rel="nofollow">IP-Adapter</a> is an image prompt adapter that can be plugged into diffusion models to enable image prompting without any changes to the underlying model. Furthermore, this adapter can be reused with other models finetuned from the same base model and it can be combined with other adapters like <a href="../using-diffusers/controlnet">ControlNet</a>. The key idea behind IP-Adapter is the <em>decoupled cross-attention</em> mechanism which adds a separate cross-attention layer just for image features instead of using the same cross-attention layer for both text and image features. This allows the model to learn more image-specific features.',o,y,k,h,v="This guide will walk you through using IP-Adapter for various tasks and use cases.",W,R,c,s,g='Let’s take a look at how to use IP-Adapter’s image prompting capabilities with the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a> for tasks like text-to-image, image-to-image, and inpainting. We also encourage you to try out other pipelines such as Stable Diffusion, LCM-LoRA, ControlNet, T2I-Adapter, or AnimateDiff!',Ne,D,qt='In all the following examples, you’ll see the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.set_ip_adapter_scale">set_ip_adapter_scale()</a> method. This method controls the amount of text or image conditioning to apply to the model. A value of <code>1.0</code> means the model is only conditioned on the image prompt. Lowering this value encourages the model to produce more diverse images, but they may not be as aligned with the image prompt. Typically, a value of <code>0.5</code> achieves a good balance between the two prompt types and produces good results.',Qe,$,Se,V,ze,K,Ae,O,Et="IP-Adapter’s image prompting and compatibility with other adapters and models makes it a versatile tool for a variety of use cases. This section covers some of the more popular applications of IP-Adapter, and we can’t wait to see what you come up with!",qe,ee,Ee,te,Lt="Generating accurate faces is challenging because they are complex and nuanced. Diffusers supports two IP-Adapter checkpoints specifically trained to generate faces:",Le,ae,Pt='<li><a href="https://huggingface.co/h94/IP-Adapter/blob/main/models/ip-adapter-full-face_sd15.safetensors" rel="nofollow">ip-adapter-full-face_sd15.safetensors</a> is conditioned with images of cropped faces and removed backgrounds</li> <li><a href="https://huggingface.co/h94/IP-Adapter/blob/main/models/ip-adapter-plus-face_sd15.safetensors" rel="nofollow">ip-adapter-plus-face_sd15.safetensors</a> uses patch embeddings and is conditioned with images of cropped faces</li>',Pe,le,Dt='<p>[!TIP][IP-Adapter-FaceID](<a href="https://huggingface.co/h94/IP-Adapter-FaceID" rel="nofollow">https://huggingface.co/h94/IP-Adapter-FaceID</a>) is a face-specific IP-Adapter trained with face ID embeddings instead of CLIP image embeddings, allowing you to generate more consistent faces in different contexts and styles. Try out this popular <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#ip-adapter-face-id" rel="nofollow">community pipeline</a> and see how it compares to the other face IP-Adapters.</p>',De,se,Kt='For face models, use the <a href="https://huggingface.co/h94/IP-Adapter" rel="nofollow">h94/IP-Adapter</a> checkpoint. It is also recommended to use <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a> or <a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a> for face models.',Ke,ie,Oe,Y,Ot='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein_base.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',et,ne,tt,pe,ea="More than one IP-Adapter can be used at the same time to generate specific images in more diverse styles. For example, you can use IP-Adapter-Face to generate consistent faces and characters, and IP-Adapter Plus to generate those faces in a specific style.",at,B,lt,oe,ta='Load the image encoder with <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPVisionModelWithProjection" rel="nofollow">CLIPVisionModelWithProjection</a>.',st,re,it,me,aa="Next, you’ll load a base model, scheduler, and the IP-Adapters. The IP-Adapters to use are passed as a list to the <code>weight_name</code> parameter:",nt,de,la='<li><a href="https://huggingface.co/h94/IP-Adapter#ip-adapter-for-sdxl-10" rel="nofollow">ip-adapter-plus_sdxl_vit-h</a> uses patch embeddings and a ViT-H image encoder</li> <li><a href="https://huggingface.co/h94/IP-Adapter#ip-adapter-for-sdxl-10" rel="nofollow">ip-adapter-plus-face_sdxl_vit-h</a> has the same architecture but it is conditioned with images of cropped faces</li>',pt,ce,ot,ue,sa="Load an image prompt and a folder containing images of a certain style you want to use.",rt,fe,mt,F,ia='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/women_input.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image of face</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_style_grid.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter style images</figcaption></div>',dt,Me,na="Pass the image prompt and style images as a list to the <code>ip_adapter_image</code> parameter, and run the pipeline!",ct,ge,ut,H,pa='    <img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_multi_out.png"/>',ft,ye,Mt,he,oa='<a href="../using-diffusers/inference_with_lcm_lora">Latent Consistency Models (LCM)</a> are diffusion models that can generate images in as little as 4 steps compared to other diffusion models like SDXL that typically require way more steps. This is why image generation with an LCM feels “instantaneous”. IP-Adapters can be plugged into an LCM-LoRA model to instantly generate images with an image prompt.',gt,Ze,ra='The IP-Adapter weights need to be loaded first, then you can use <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> to load the LoRA style and weight you want to apply to your image.',yt,Ue,ht,Je,ma='Try using with a lower IP-Adapter scale to condition image generation more on the <a href="https://huggingface.co/sd-dreambooth-library/herge-style" rel="nofollow">herge_style</a> checkpoint, and remember to use the special token <code>herge_style</code> in your prompt to trigger and apply the style.',Zt,be,Ut,N,da='    <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_herge.png"/>',Jt,we,bt,Te,ca='To control image generation to an even greater degree, you can combine IP-Adapter with a model like <a href="../using-diffusers/controlnet">ControlNet</a>. A ControlNet is also an adapter that can be inserted into a diffusion model to allow for conditioning on an additional control image. The control image can be depth maps, edge maps, pose estimations, and more.',wt,We,ua='Load a <a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> checkpoint conditioned on depth maps, insert it into a diffusion model, and load the IP-Adapter.',Tt,je,Wt,_e,fa="Now load the IP-Adapter image and depth map.",jt,Ge,_t,Q,Ma='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/statue.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/depth.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">depth map</figcaption></div>',Gt,Ie,ga="Pass the depth map and IP-Adapter image to the pipeline to generate an image.",It,ke,kt,S,ya='    <img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ipa-controlnet-out.png"/>',vt,ve,Xt,Xe,ha=`Binary masks can be used to specify which portion of the output image should be assigned to an IP-Adapter.
For each input IP-Adapter image, a binary mask and an IP-Adapter must be provided.`,Rt,Re,Za="Before passing the masks to the pipeline, it’s essential to preprocess them using <code>IPAdapterMaskProcessor.preprocess()</code>.",Ct,z,xt,Ce,Ua="Here an example with two masks:",$t,xe,Vt,A,Ja='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_mask1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">mask one</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_mask2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">mask two</figcaption></div>',Yt,$e,ba="If you have more than one IP-Adapter image, load them into a list, ensuring each image is assigned to a different IP-Adapter.",Bt,Ve,Ft,q,wa='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_girl1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">ip adapter image one</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_girl2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">ip adapter image two</figcaption></div>',Ht,Ye,Ta="Pass preprocessed masks to the pipeline using <code>cross_attention_kwargs</code> as shown below:",Nt,Be,Qt,E,Wa='    <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_attention_mask_result_seed_0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">output image</figcaption>',St,Fe,zt;return G=new L({props:{title:"IP-Adapter",local:"ip-adapter",headingTag:"h1"}}),y=new He({props:{warning:!1,$$slots:{default:[Ba]},$$scope:{ctx:X}}}),R=new L({props:{title:"General tasks",local:"general-tasks",headingTag:"h2"}}),$=new Ya({props:{id:"tasks",options:["Text-to-image","Image-to-image","Inpainting","Video"],$$slots:{default:[za]},$$scope:{ctx:X}}}),V=new He({props:{warning:!1,$$slots:{default:[Aa]},$$scope:{ctx:X}}}),K=new L({props:{title:"Specific use cases",local:"specific-use-cases",headingTag:"h2"}}),ee=new L({props:{title:"Face model",local:"face-model",headingTag:"h3"}}),ie=new C({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBERElNU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJtb2RlbHMlMjIlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMmlwLWFkYXB0ZXItZnVsbC1mYWNlX3NkMTUuYmluJTIyKSUwQSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKDAuNSklMEElMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9laW5zdGVpbl9iYXNlLnBuZyUyMiklMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgyNiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMkElMjBwaG90byUyMG9mJTIwRWluc3RlaW4lMjBhcyUyMGElMjBjaGVmJTJDJTIwd2VhcmluZyUyMGFuJTIwYXByb24lMkMlMjBjb29raW5nJTIwaW4lMjBhJTIwRnJlbmNoJTIwcmVzdGF1cmFudCUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmxvd3JlcyUyQyUyMGJhZCUyMGFuYXRvbXklMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBsb3clMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter-full-face_sd15.bin&quot;</span>)

pipeline.set_ip_adapter_scale(<span class="hljs-number">0.5</span>)

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein_base.png&quot;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">26</span>)

image = pipeline(
    prompt=<span class="hljs-string">&quot;A photo of Einstein as a chef, wearing an apron, cooking in a French restaurant&quot;</span>,
    ip_adapter_image=image,
    negative_prompt=<span class="hljs-string">&quot;lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ne=new L({props:{title:"Multi IP-Adapter",local:"multi-ip-adapter",headingTag:"h3"}}),B=new He({props:{warning:!1,$$slots:{default:[qa]},$$scope:{ctx:X}}}),re=new C({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUyQyUyMERESU1TY2hlZHVsZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ0xJUFZpc2lvbk1vZGVsV2l0aFByb2plY3Rpb24lMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWltYWdlX2VuY29kZXIlMjAlM0QlMjBDTElQVmlzaW9uTW9kZWxXaXRoUHJvamVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMm1vZGVscyUyRmltYWdlX2VuY29kZXIlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, DDIMScheduler
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPVisionModelWithProjection
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

image_encoder = CLIPVisionModelWithProjection.from_pretrained(
    <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
    subfolder=<span class="hljs-string">&quot;models/image_encoder&quot;</span>,
    torch_dtype=torch.float16,
)`,wrap:!1}}),ce=new C({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBpbWFnZV9lbmNvZGVyJTNEaW1hZ2VfZW5jb2RlciUyQyUwQSklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUwQSUyMCUyMCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMEElMjAlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUwQSUyMCUyMHdlaWdodF9uYW1lJTNEJTVCJTIyaXAtYWRhcHRlci1wbHVzX3NkeGxfdml0LWguc2FmZXRlbnNvcnMlMjIlMkMlMjAlMjJpcC1hZGFwdGVyLXBsdXMtZmFjZV9zZHhsX3ZpdC1oLnNhZmV0ZW5zb3JzJTIyJTVEJTBBKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKCU1QjAuNyUyQyUyMDAuMyU1RCklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
    image_encoder=image_encoder,
)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.load_ip_adapter(
  <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
  subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>,
  weight_name=[<span class="hljs-string">&quot;ip-adapter-plus_sdxl_vit-h.safetensors&quot;</span>, <span class="hljs-string">&quot;ip-adapter-plus-face_sdxl_vit-h.safetensors&quot;</span>]
)
pipeline.set_ip_adapter_scale([<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>])
pipeline.enable_model_cpu_offload()`,wrap:!1}}),fe=new C({props:{code:"ZmFjZV9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRndvbWVuX2lucHV0LnBuZyUyMiklMEFzdHlsZV9mb2xkZXIlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZZaVlpWHUlMkZ0ZXN0aW5nLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGc3R5bGVfemlnZ3klMjIlMEFzdHlsZV9pbWFnZXMlMjAlM0QlMjAlNUJsb2FkX2ltYWdlKGYlMjIlN0JzdHlsZV9mb2xkZXIlN0QlMkZpbWclN0JpJTdELnBuZyUyMiklMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMCklNUQ=",highlighted:`face_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/women_input.png&quot;</span>)
style_folder = <span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/style_ziggy&quot;</span>
style_images = [load_image(<span class="hljs-string">f&quot;<span class="hljs-subst">{style_folder}</span>/img<span class="hljs-subst">{i}</span>.png&quot;</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>)]`,wrap:!1}}),ge=new C({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMCklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMndvbmRlcndvbWFuJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRCU1QnN0eWxlX2ltYWdlcyUyQyUyMGZhY2VfaW1hZ2UlNUQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJtb25vY2hyb21lJTJDJTIwbG93cmVzJTJDJTIwYmFkJTIwYW5hdG9teSUyQyUyMHdvcnN0JTIwcXVhbGl0eSUyQyUyMGxvdyUyMHF1YWxpdHklMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

image = pipeline(
    prompt=<span class="hljs-string">&quot;wonderwoman&quot;</span>,
    ip_adapter_image=[style_images, face_image],
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">50</span>, num_images_per_prompt=<span class="hljs-number">1</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ye=new L({props:{title:"Instant generation",local:"instant-generation",headingTag:"h3"}}),Ue=new C({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwTENNU2NoZWR1bGVyJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc2QtZHJlYW1ib290aC1saWJyYXJ5JTJGaGVyZ2Utc3R5bGUlMjIlMEFsY21fbG9yYV9pZCUyMCUzRCUyMCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1sb3JhLXNkdjEtNSUyMiUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKSUwQXBpcGVsaW5lLmxvYWRfbG9yYV93ZWlnaHRzKGxjbV9sb3JhX2lkKSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMExDTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, LCMScheduler
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

model_id = <span class="hljs-string">&quot;sd-dreambooth-library/herge-style&quot;</span>
lcm_lora_id = <span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>

pipeline = DiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16)

pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipeline.load_lora_weights(lcm_lora_id)
pipeline.scheduler = LCMScheduler.from_config(pipeline.scheduler.config)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),be=new C({props:{code:"cGlwZWxpbmUuc2V0X2lwX2FkYXB0ZXJfc2NhbGUoMC40KSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmhlcmdlX3N0eWxlJTIwd29tYW4lMjBpbiUyMGFybW9yJTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBoaWdoJTIwcXVhbGl0eSUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBJTBBaXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZ1c2VyLWltYWdlcy5naXRodWJ1c2VyY29udGVudC5jb20lMkYyNDczNDE0MiUyRjI2NjQ5Mjg3NS0yZDUwZDIyMy04NDc1LTQ0ZjAtYTdjNi0wOGI1MWNiNTM1NzIucG5nJTIyKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2FkYXB0ZXJfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMSUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`pipeline.set_ip_adapter_scale(<span class="hljs-number">0.4</span>)

prompt = <span class="hljs-string">&quot;herge_style woman in armor, best quality, high quality&quot;</span>
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

ip_adapter_image = load_image(<span class="hljs-string">&quot;https://user-images.githubusercontent.com/24734142/266492875-2d50d223-8475-44f0-a7c6-08b51cb53572.png&quot;</span>)
image = pipeline(
    prompt=prompt,
    ip_adapter_image=ip_adapter_image,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">1</span>,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),we=new L({props:{title:"Structural control",local:"structural-control",headingTag:"h3"}}),je=new C({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFjb250cm9sbmV0X21vZGVsX3BhdGglMjAlM0QlMjAlMjJsbGx5YXN2aWVsJTJGY29udHJvbF92MTFmMXBfc2QxNV9kZXB0aCUyMiUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGNvbnRyb2xuZXRfbW9kZWxfcGF0aCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

controlnet_model_path = <span class="hljs-string">&quot;lllyasviel/control_v11f1p_sd15_depth&quot;</span>
controlnet = ControlNetModel.from_pretrained(controlnet_model_path, torch_dtype=torch.float16)

pipeline = StableDiffusionControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)`,wrap:!1}}),Ge=new C({props:{code:"aXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnN0YXR1ZS5wbmclMjIpJTBBZGVwdGhfbWFwJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZZaVlpWHUlMkZ0ZXN0aW5nLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGVwdGgucG5nJTIyKQ==",highlighted:`ip_adapter_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/statue.png&quot;</span>)
depth_map = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/depth.png&quot;</span>)`,wrap:!1}}),ke=new C({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMzMpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJiZXN0JTIwcXVhbGl0eSUyQyUyMGhpZ2glMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RkZXB0aF9tYXAlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEaXBfYWRhcHRlcl9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMm1vbm9jaHJvbWUlMkMlMjBsb3dyZXMlMkMlMjBiYWQlMjBhbmF0b215JTJDJTIwd29yc3QlMjBxdWFsaXR5JTJDJTIwbG93JTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
image = pipeline(
    prompt=<span class="hljs-string">&quot;best quality, high quality&quot;</span>,
    image=depth_map,
    ip_adapter_image=ip_adapter_image,
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ve=new L({props:{title:"IP-Adapter masking",local:"ip-adapter-masking",headingTag:"h3"}}),z=new He({props:{warning:!1,$$slots:{default:[Ea]},$$scope:{ctx:X}}}),xe=new C({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5pbWFnZV9wcm9jZXNzb3IlMjBpbXBvcnQlMjBJUEFkYXB0ZXJNYXNrUHJvY2Vzc29yJTBBJTBBbWFzazElMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRllpWWlYdSUyRnRlc3RpbmctaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZpcF9tYXNrX21hc2sxLnBuZyUyMiklMEFtYXNrMiUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmlwX21hc2tfbWFzazIucG5nJTIyKSUwQSUwQW91dHB1dF9oZWlnaHQlMjAlM0QlMjAxMDI0JTBBb3V0cHV0X3dpZHRoJTIwJTNEJTIwMTAyNCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMElQQWRhcHRlck1hc2tQcm9jZXNzb3IoKSUwQW1hc2tzJTIwJTNEJTIwcHJvY2Vzc29yLnByZXByb2Nlc3MoJTVCbWFzazElMkMlMjBtYXNrMiU1RCUyQyUyMGhlaWdodCUzRG91dHB1dF9oZWlnaHQlMkMlMjB3aWR0aCUzRG91dHB1dF93aWR0aCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers.image_processor <span class="hljs-keyword">import</span> IPAdapterMaskProcessor

mask1 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_mask1.png&quot;</span>)
mask2 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_mask2.png&quot;</span>)

output_height = <span class="hljs-number">1024</span>
output_width = <span class="hljs-number">1024</span>

processor = IPAdapterMaskProcessor()
masks = processor.preprocess([mask1, mask2], height=output_height, width=output_width)`,wrap:!1}}),Ve=new C({props:{code:"ZmFjZV9pbWFnZTElMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRllpWWlYdSUyRnRlc3RpbmctaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZpcF9tYXNrX2dpcmwxLnBuZyUyMiklMEFmYWNlX2ltYWdlMiUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmlwX21hc2tfZ2lybDIucG5nJTIyKSUwQSUwQWlwX2ltYWdlcyUyMCUzRCUyMCU1QiU1QmZhY2VfaW1hZ2UxJTVEJTJDJTIwJTVCZmFjZV9pbWFnZTIlNUQlNUQ=",highlighted:`face_image1 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_girl1.png&quot;</span>)
face_image2 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_girl2.png&quot;</span>)

ip_images = [[face_image1], [face_image2]]`,wrap:!1}}),Be=new C({props:{code:"cGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTVCJTIyaXAtYWRhcHRlci1wbHVzLWZhY2Vfc2R4bF92aXQtaC5zYWZldGVuc29ycyUyMiU1RCUyMColMjAyKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKCU1QjAuNyU1RCUyMColMjAyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBbnVtX2ltYWdlcyUyMCUzRCUyMDElMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMjIlMjBnaXJscyUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpcF9pbWFnZXMlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJtb25vY2hyb21lJTJDJTIwbG93cmVzJTJDJTIwYmFkJTIwYW5hdG9teSUyQyUyMHdvcnN0JTIwcXVhbGl0eSUyQyUyMGxvdyUyMHF1YWxpdHklMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjAlMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0RudW1faW1hZ2VzJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwY3Jvc3NfYXR0ZW50aW9uX2t3YXJncyUzRCU3QiUyMmlwX2FkYXB0ZXJfbWFza3MlMjIlM0ElMjBtYXNrcyU3RCUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=[<span class="hljs-string">&quot;ip-adapter-plus-face_sdxl_vit-h.safetensors&quot;</span>] * <span class="hljs-number">2</span>)
pipeline.set_ip_adapter_scale([<span class="hljs-number">0.7</span>] * <span class="hljs-number">2</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
num_images = <span class="hljs-number">1</span>

image = pipeline(
    prompt=<span class="hljs-string">&quot;2 girls&quot;</span>,
    ip_adapter_image=ip_images,
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">20</span>, num_images_per_prompt=num_images,
    generator=generator, cross_attention_kwargs={<span class="hljs-string">&quot;ip_adapter_masks&quot;</span>: masks}
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),{c(){i=m("meta"),j=n(),r=m("p"),f=n(),Z(G.$$.fragment),_=n(),M=m("p"),M.innerHTML=I,o=n(),Z(y.$$.fragment),k=n(),h=m("p"),h.textContent=v,W=n(),Z(R.$$.fragment),c=n(),s=m("p"),s.innerHTML=g,Ne=n(),D=m("p"),D.innerHTML=qt,Qe=n(),Z($.$$.fragment),Se=n(),Z(V.$$.fragment),ze=n(),Z(K.$$.fragment),Ae=n(),O=m("p"),O.textContent=Et,qe=n(),Z(ee.$$.fragment),Ee=n(),te=m("p"),te.textContent=Lt,Le=n(),ae=m("ul"),ae.innerHTML=Pt,Pe=n(),le=m("blockquote"),le.innerHTML=Dt,De=n(),se=m("p"),se.innerHTML=Kt,Ke=n(),Z(ie.$$.fragment),Oe=n(),Y=m("div"),Y.innerHTML=Ot,et=n(),Z(ne.$$.fragment),tt=n(),pe=m("p"),pe.textContent=ea,at=n(),Z(B.$$.fragment),lt=n(),oe=m("p"),oe.innerHTML=ta,st=n(),Z(re.$$.fragment),it=n(),me=m("p"),me.innerHTML=aa,nt=n(),de=m("ul"),de.innerHTML=la,pt=n(),Z(ce.$$.fragment),ot=n(),ue=m("p"),ue.textContent=sa,rt=n(),Z(fe.$$.fragment),mt=n(),F=m("div"),F.innerHTML=ia,dt=n(),Me=m("p"),Me.innerHTML=na,ct=n(),Z(ge.$$.fragment),ut=n(),H=m("div"),H.innerHTML=pa,ft=n(),Z(ye.$$.fragment),Mt=n(),he=m("p"),he.innerHTML=oa,gt=n(),Ze=m("p"),Ze.innerHTML=ra,yt=n(),Z(Ue.$$.fragment),ht=n(),Je=m("p"),Je.innerHTML=ma,Zt=n(),Z(be.$$.fragment),Ut=n(),N=m("div"),N.innerHTML=da,Jt=n(),Z(we.$$.fragment),bt=n(),Te=m("p"),Te.innerHTML=ca,wt=n(),We=m("p"),We.innerHTML=ua,Tt=n(),Z(je.$$.fragment),Wt=n(),_e=m("p"),_e.textContent=fa,jt=n(),Z(Ge.$$.fragment),_t=n(),Q=m("div"),Q.innerHTML=Ma,Gt=n(),Ie=m("p"),Ie.textContent=ga,It=n(),Z(ke.$$.fragment),kt=n(),S=m("div"),S.innerHTML=ya,vt=n(),Z(ve.$$.fragment),Xt=n(),Xe=m("p"),Xe.textContent=ha,Rt=n(),Re=m("p"),Re.innerHTML=Za,Ct=n(),Z(z.$$.fragment),xt=n(),Ce=m("p"),Ce.textContent=Ua,$t=n(),Z(xe.$$.fragment),Vt=n(),A=m("div"),A.innerHTML=Ja,Yt=n(),$e=m("p"),$e.textContent=ba,Bt=n(),Z(Ve.$$.fragment),Ft=n(),q=m("div"),q.innerHTML=wa,Ht=n(),Ye=m("p"),Ye.innerHTML=Ta,Nt=n(),Z(Be.$$.fragment),Qt=n(),E=m("div"),E.innerHTML=Wa,St=n(),Fe=m("p"),this.h()},l(e){const l=$a("svelte-u9bgzb",document.head);i=d(l,"META",{name:!0,content:!0}),l.forEach(t),j=p(e),r=d(e,"P",{}),va(r).forEach(t),f=p(e),U(G.$$.fragment,e),_=p(e),M=d(e,"P",{"data-svelte-h":!0}),u(M)!=="svelte-rd9njz"&&(M.innerHTML=I),o=p(e),U(y.$$.fragment,e),k=p(e),h=d(e,"P",{"data-svelte-h":!0}),u(h)!=="svelte-1211s0v"&&(h.textContent=v),W=p(e),U(R.$$.fragment,e),c=p(e),s=d(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-49swfq"&&(s.innerHTML=g),Ne=p(e),D=d(e,"P",{"data-svelte-h":!0}),u(D)!=="svelte-1pmqs0j"&&(D.innerHTML=qt),Qe=p(e),U($.$$.fragment,e),Se=p(e),U(V.$$.fragment,e),ze=p(e),U(K.$$.fragment,e),Ae=p(e),O=d(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-3uurtn"&&(O.textContent=Et),qe=p(e),U(ee.$$.fragment,e),Ee=p(e),te=d(e,"P",{"data-svelte-h":!0}),u(te)!=="svelte-1md71yv"&&(te.textContent=Lt),Le=p(e),ae=d(e,"UL",{"data-svelte-h":!0}),u(ae)!=="svelte-1a56pqx"&&(ae.innerHTML=Pt),Pe=p(e),le=d(e,"BLOCKQUOTE",{"data-svelte-h":!0}),u(le)!=="svelte-1ibagyj"&&(le.innerHTML=Dt),De=p(e),se=d(e,"P",{"data-svelte-h":!0}),u(se)!=="svelte-1dtaqqk"&&(se.innerHTML=Kt),Ke=p(e),U(ie.$$.fragment,e),Oe=p(e),Y=d(e,"DIV",{class:!0,"data-svelte-h":!0}),u(Y)!=="svelte-lbwedl"&&(Y.innerHTML=Ot),et=p(e),U(ne.$$.fragment,e),tt=p(e),pe=d(e,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-1tk2m7v"&&(pe.textContent=ea),at=p(e),U(B.$$.fragment,e),lt=p(e),oe=d(e,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-qgg0iy"&&(oe.innerHTML=ta),st=p(e),U(re.$$.fragment,e),it=p(e),me=d(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-1vw2kqb"&&(me.innerHTML=aa),nt=p(e),de=d(e,"UL",{"data-svelte-h":!0}),u(de)!=="svelte-tpz2u9"&&(de.innerHTML=la),pt=p(e),U(ce.$$.fragment,e),ot=p(e),ue=d(e,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-1p6lwr0"&&(ue.textContent=sa),rt=p(e),U(fe.$$.fragment,e),mt=p(e),F=d(e,"DIV",{class:!0,"data-svelte-h":!0}),u(F)!=="svelte-im3du6"&&(F.innerHTML=ia),dt=p(e),Me=d(e,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-1kkzavx"&&(Me.innerHTML=na),ct=p(e),U(ge.$$.fragment,e),ut=p(e),H=d(e,"DIV",{class:!0,"data-svelte-h":!0}),u(H)!=="svelte-1t1eqqe"&&(H.innerHTML=pa),ft=p(e),U(ye.$$.fragment,e),Mt=p(e),he=d(e,"P",{"data-svelte-h":!0}),u(he)!=="svelte-1am74qu"&&(he.innerHTML=oa),gt=p(e),Ze=d(e,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-ntp5s3"&&(Ze.innerHTML=ra),yt=p(e),U(Ue.$$.fragment,e),ht=p(e),Je=d(e,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-13u2z8i"&&(Je.innerHTML=ma),Zt=p(e),U(be.$$.fragment,e),Ut=p(e),N=d(e,"DIV",{class:!0,"data-svelte-h":!0}),u(N)!=="svelte-1cw2b12"&&(N.innerHTML=da),Jt=p(e),U(we.$$.fragment,e),bt=p(e),Te=d(e,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-sz8jif"&&(Te.innerHTML=ca),wt=p(e),We=d(e,"P",{"data-svelte-h":!0}),u(We)!=="svelte-837b2y"&&(We.innerHTML=ua),Tt=p(e),U(je.$$.fragment,e),Wt=p(e),_e=d(e,"P",{"data-svelte-h":!0}),u(_e)!=="svelte-77tfin"&&(_e.textContent=fa),jt=p(e),U(Ge.$$.fragment,e),_t=p(e),Q=d(e,"DIV",{class:!0,"data-svelte-h":!0}),u(Q)!=="svelte-mjuwpp"&&(Q.innerHTML=Ma),Gt=p(e),Ie=d(e,"P",{"data-svelte-h":!0}),u(Ie)!=="svelte-12fzw16"&&(Ie.textContent=ga),It=p(e),U(ke.$$.fragment,e),kt=p(e),S=d(e,"DIV",{class:!0,"data-svelte-h":!0}),u(S)!=="svelte-kc4794"&&(S.innerHTML=ya),vt=p(e),U(ve.$$.fragment,e),Xt=p(e),Xe=d(e,"P",{"data-svelte-h":!0}),u(Xe)!=="svelte-1p0lqmp"&&(Xe.textContent=ha),Rt=p(e),Re=d(e,"P",{"data-svelte-h":!0}),u(Re)!=="svelte-5d5ag4"&&(Re.innerHTML=Za),Ct=p(e),U(z.$$.fragment,e),xt=p(e),Ce=d(e,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-1e0vtsw"&&(Ce.textContent=Ua),$t=p(e),U(xe.$$.fragment,e),Vt=p(e),A=d(e,"DIV",{class:!0,"data-svelte-h":!0}),u(A)!=="svelte-eifaa"&&(A.innerHTML=Ja),Yt=p(e),$e=d(e,"P",{"data-svelte-h":!0}),u($e)!=="svelte-ks78co"&&($e.textContent=ba),Bt=p(e),U(Ve.$$.fragment,e),Ft=p(e),q=d(e,"DIV",{class:!0,"data-svelte-h":!0}),u(q)!=="svelte-32e9xk"&&(q.innerHTML=wa),Ht=p(e),Ye=d(e,"P",{"data-svelte-h":!0}),u(Ye)!=="svelte-1lxdo5h"&&(Ye.innerHTML=Ta),Nt=p(e),U(Be.$$.fragment,e),Qt=p(e),E=d(e,"DIV",{class:!0,"data-svelte-h":!0}),u(E)!=="svelte-1125s53"&&(E.innerHTML=Wa),St=p(e),Fe=d(e,"P",{}),va(Fe).forEach(t),this.h()},h(){x(i,"name","hf:doc:metadata"),x(i,"content",Pa),x(Y,"class","flex flex-row gap-4"),x(F,"class","flex flex-row gap-4"),x(H,"class","flex justify-center"),x(N,"class","flex justify-center"),x(Q,"class","flex flex-row gap-4"),x(S,"class","flex justify-center"),x(A,"class","flex flex-row gap-4"),x(q,"class","flex flex-row gap-4"),x(E,"class","flex justify-center")},m(e,l){Va(document.head,i),a(e,j,l),a(e,r,l),a(e,f,l),J(G,e,l),a(e,_,l),a(e,M,l),a(e,o,l),J(y,e,l),a(e,k,l),a(e,h,l),a(e,W,l),J(R,e,l),a(e,c,l),a(e,s,l),a(e,Ne,l),a(e,D,l),a(e,Qe,l),J($,e,l),a(e,Se,l),J(V,e,l),a(e,ze,l),J(K,e,l),a(e,Ae,l),a(e,O,l),a(e,qe,l),J(ee,e,l),a(e,Ee,l),a(e,te,l),a(e,Le,l),a(e,ae,l),a(e,Pe,l),a(e,le,l),a(e,De,l),a(e,se,l),a(e,Ke,l),J(ie,e,l),a(e,Oe,l),a(e,Y,l),a(e,et,l),J(ne,e,l),a(e,tt,l),a(e,pe,l),a(e,at,l),J(B,e,l),a(e,lt,l),a(e,oe,l),a(e,st,l),J(re,e,l),a(e,it,l),a(e,me,l),a(e,nt,l),a(e,de,l),a(e,pt,l),J(ce,e,l),a(e,ot,l),a(e,ue,l),a(e,rt,l),J(fe,e,l),a(e,mt,l),a(e,F,l),a(e,dt,l),a(e,Me,l),a(e,ct,l),J(ge,e,l),a(e,ut,l),a(e,H,l),a(e,ft,l),J(ye,e,l),a(e,Mt,l),a(e,he,l),a(e,gt,l),a(e,Ze,l),a(e,yt,l),J(Ue,e,l),a(e,ht,l),a(e,Je,l),a(e,Zt,l),J(be,e,l),a(e,Ut,l),a(e,N,l),a(e,Jt,l),J(we,e,l),a(e,bt,l),a(e,Te,l),a(e,wt,l),a(e,We,l),a(e,Tt,l),J(je,e,l),a(e,Wt,l),a(e,_e,l),a(e,jt,l),J(Ge,e,l),a(e,_t,l),a(e,Q,l),a(e,Gt,l),a(e,Ie,l),a(e,It,l),J(ke,e,l),a(e,kt,l),a(e,S,l),a(e,vt,l),J(ve,e,l),a(e,Xt,l),a(e,Xe,l),a(e,Rt,l),a(e,Re,l),a(e,Ct,l),J(z,e,l),a(e,xt,l),a(e,Ce,l),a(e,$t,l),J(xe,e,l),a(e,Vt,l),a(e,A,l),a(e,Yt,l),a(e,$e,l),a(e,Bt,l),J(Ve,e,l),a(e,Ft,l),a(e,q,l),a(e,Ht,l),a(e,Ye,l),a(e,Nt,l),J(Be,e,l),a(e,Qt,l),a(e,E,l),a(e,St,l),a(e,Fe,l),zt=!0},p(e,[l]){const ja={};l&2&&(ja.$$scope={dirty:l,ctx:e}),y.$set(ja);const _a={};l&2&&(_a.$$scope={dirty:l,ctx:e}),$.$set(_a);const Ga={};l&2&&(Ga.$$scope={dirty:l,ctx:e}),V.$set(Ga);const Ia={};l&2&&(Ia.$$scope={dirty:l,ctx:e}),B.$set(Ia);const ka={};l&2&&(ka.$$scope={dirty:l,ctx:e}),z.$set(ka)},i(e){zt||(b(G.$$.fragment,e),b(y.$$.fragment,e),b(R.$$.fragment,e),b($.$$.fragment,e),b(V.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(ie.$$.fragment,e),b(ne.$$.fragment,e),b(B.$$.fragment,e),b(re.$$.fragment,e),b(ce.$$.fragment,e),b(fe.$$.fragment,e),b(ge.$$.fragment,e),b(ye.$$.fragment,e),b(Ue.$$.fragment,e),b(be.$$.fragment,e),b(we.$$.fragment,e),b(je.$$.fragment,e),b(Ge.$$.fragment,e),b(ke.$$.fragment,e),b(ve.$$.fragment,e),b(z.$$.fragment,e),b(xe.$$.fragment,e),b(Ve.$$.fragment,e),b(Be.$$.fragment,e),zt=!0)},o(e){w(G.$$.fragment,e),w(y.$$.fragment,e),w(R.$$.fragment,e),w($.$$.fragment,e),w(V.$$.fragment,e),w(K.$$.fragment,e),w(ee.$$.fragment,e),w(ie.$$.fragment,e),w(ne.$$.fragment,e),w(B.$$.fragment,e),w(re.$$.fragment,e),w(ce.$$.fragment,e),w(fe.$$.fragment,e),w(ge.$$.fragment,e),w(ye.$$.fragment,e),w(Ue.$$.fragment,e),w(be.$$.fragment,e),w(we.$$.fragment,e),w(je.$$.fragment,e),w(Ge.$$.fragment,e),w(ke.$$.fragment,e),w(ve.$$.fragment,e),w(z.$$.fragment,e),w(xe.$$.fragment,e),w(Ve.$$.fragment,e),w(Be.$$.fragment,e),zt=!1},d(e){e&&(t(j),t(r),t(f),t(_),t(M),t(o),t(k),t(h),t(W),t(c),t(s),t(Ne),t(D),t(Qe),t(Se),t(ze),t(Ae),t(O),t(qe),t(Ee),t(te),t(Le),t(ae),t(Pe),t(le),t(De),t(se),t(Ke),t(Oe),t(Y),t(et),t(tt),t(pe),t(at),t(lt),t(oe),t(st),t(it),t(me),t(nt),t(de),t(pt),t(ot),t(ue),t(rt),t(mt),t(F),t(dt),t(Me),t(ct),t(ut),t(H),t(ft),t(Mt),t(he),t(gt),t(Ze),t(yt),t(ht),t(Je),t(Zt),t(Ut),t(N),t(Jt),t(bt),t(Te),t(wt),t(We),t(Tt),t(Wt),t(_e),t(jt),t(_t),t(Q),t(Gt),t(Ie),t(It),t(kt),t(S),t(vt),t(Xt),t(Xe),t(Rt),t(Re),t(Ct),t(xt),t(Ce),t($t),t(Vt),t(A),t(Yt),t($e),t(Bt),t(Ft),t(q),t(Ht),t(Ye),t(Nt),t(Qt),t(E),t(St),t(Fe)),t(i),T(G,e),T(y,e),T(R,e),T($,e),T(V,e),T(K,e),T(ee,e),T(ie,e),T(ne,e),T(B,e),T(re,e),T(ce,e),T(fe,e),T(ge,e),T(ye,e),T(Ue,e),T(be,e),T(we,e),T(je,e),T(Ge,e),T(ke,e),T(ve,e),T(z,e),T(xe,e),T(Ve,e),T(Be,e)}}}const Pa='{"title":"IP-Adapter","local":"ip-adapter","sections":[{"title":"General tasks","local":"general-tasks","sections":[],"depth":2},{"title":"Specific use cases","local":"specific-use-cases","sections":[{"title":"Face model","local":"face-model","sections":[],"depth":3},{"title":"Multi IP-Adapter","local":"multi-ip-adapter","sections":[],"depth":3},{"title":"Instant generation","local":"instant-generation","sections":[],"depth":3},{"title":"Structural control","local":"structural-control","sections":[],"depth":3},{"title":"IP-Adapter masking","local":"ip-adapter-masking","sections":[],"depth":3}],"depth":2}],"depth":1}';function Da(X){return Ra(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sl extends Ca{constructor(i){super(),xa(this,i,Da,La,Xa,{})}}export{sl as component};
