import{s as Ge,o as Be,n as Ue}from"../chunks/scheduler.182ea377.js";import{S as Ie,i as Je,g as r,s as a,r as M,A as He,h as l,f as n,c as s,j as F,u as w,x as u,k as Y,y as h,a as o,v as y,d as x,t as T,w as $}from"../chunks/index.abf12888.js";import{T as Se}from"../chunks/Tip.230e2334.js";import{D as Me}from"../chunks/Docstring.93f6f462.js";import{C as Ne}from"../chunks/CodeBlock.57fe6e13.js";import{E as qe}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as me}from"../chunks/Heading.16916d63.js";function Ee(O){let i,b='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){i=r("p"),i.innerHTML=b},l(p){i=l(p,"P",{"data-svelte-h":!0}),u(i)!=="svelte-1wmc0l4"&&(i.innerHTML=b)},m(p,c){o(p,i,c)},p:Ue,d(p){p&&n(i)}}}function Oe(O){let i,b="Examples:",p,c,f;return c=new Ne({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1ZGlvTERNUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMHNjaXB5JTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmN2c3NwJTJGYXVkaW9sZG0tcy1mdWxsLXYyJTIyJTBBcGlwZSUyMCUzRCUyMEF1ZGlvTERNUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJUZWNobm8lMjBtdXNpYyUyMHdpdGglMjBhJTIwc3Ryb25nJTJDJTIwdXBiZWF0JTIwdGVtcG8lMjBhbmQlMjBoaWdoJTIwbWVsb2RpYyUyMHJpZmZzJTIyJTBBYXVkaW8lMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxMCUyQyUyMGF1ZGlvX2xlbmd0aF9pbl9zJTNENS4wKS5hdWRpb3MlNUIwJTVEJTBBJTBBJTIzJTIwc2F2ZSUyMHRoZSUyMGF1ZGlvJTIwc2FtcGxlJTIwYXMlMjBhJTIwLndhdiUyMGZpbGUlMEFzY2lweS5pby53YXZmaWxlLndyaXRlKCUyMnRlY2huby53YXYlMjIlMkMlMjByYXRlJTNEMTYwMDAlMkMlMjBkYXRhJTNEYXVkaW8p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AudioLDMPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> scipy

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;cvssp/audioldm-s-full-v2&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AudioLDMPipeline.from_pretrained(repo_id, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Techno music with a strong, upbeat tempo and high melodic riffs&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = pipe(prompt, num_inference_steps=<span class="hljs-number">10</span>, audio_length_in_s=<span class="hljs-number">5.0</span>).audios[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save the audio sample as a .wav file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>scipy.io.wavfile.write(<span class="hljs-string">&quot;techno.wav&quot;</span>, rate=<span class="hljs-number">16000</span>, data=audio)`,wrap:!1}}),{c(){i=r("p"),i.textContent=b,p=a(),M(c.$$.fragment)},l(d){i=l(d,"P",{"data-svelte-h":!0}),u(i)!=="svelte-kvfsh7"&&(i.textContent=b),p=s(d),w(c.$$.fragment,d)},m(d,g){o(d,i,g),o(d,p,g),y(c,d,g),f=!0},p:Ue,i(d){f||(x(c.$$.fragment,d),f=!0)},o(d){T(c.$$.fragment,d),f=!1},d(d){d&&(n(i),n(p)),$(c,d)}}}function Ze(O){let i,b,p,c,f,d,g,we=`AudioLDM was proposed in <a href="https://huggingface.co/papers/2301.12503" rel="nofollow">AudioLDM: Text-to-Audio Generation with Latent Diffusion Models</a> by Haohe Liu et al. Inspired by <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/overview" rel="nofollow">Stable Diffusion</a>, AudioLDM
is a text-to-audio <em>latent diffusion model (LDM)</em> that learns continuous audio representations from <a href="https://huggingface.co/docs/transformers/main/model_doc/clap" rel="nofollow">CLAP</a>
latents. AudioLDM takes a text prompt as input and predicts the corresponding audio. It can generate text-conditional
sound effects, human speech and music.`,X,C,ye="The abstract from the paper is:",Q,k,xe='<em>Text-to-audio (TTA) system has recently gained attention for its ability to synthesize general audio based on text descriptions. However, previous studies in TTA have limited generation quality with high computational costs. In this study, we propose AudioLDM, a TTA system that is built on a latent space to learn the continuous audio representations from contrastive language-audio pretraining (CLAP) latents. The pretrained CLAP models enable us to train LDMs with audio embedding while providing text embedding as a condition during sampling. By learning the latent representations of audio signals and their compositions without modeling the cross-modal relationship, AudioLDM is advantageous in both generation quality and computational efficiency. Trained on AudioCaps with a single GPU, AudioLDM achieves state-of-the-art TTA performance measured by both objective and subjective metrics (e.g., frechet distance). Moreover, AudioLDM is the first TTA system that enables various text-guided audio manipulations (e.g., style transfer) in a zero-shot fashion. Our implementation and demos are available at <a href="https://audioldm.github.io/" rel="nofollow">this https URL</a>.</em>',K,j,Te='The original codebase can be found at <a href="https://github.com/haoheliu/AudioLDM" rel="nofollow">haoheliu/AudioLDM</a>.',ee,U,te,G,$e="When constructing a prompt, keep in mind:",ne,B,Ae="<li>Descriptive prompt inputs work best; you can use adjectives to describe the sound (for example, “high quality” or “clear”) and make the prompt context specific (for example, “water stream in a forest” instead of “stream”).</li> <li>It’s best to use general terms like “cat” or “dog” instead of specific names or abstract objects the model may not be familiar with.</li>",oe,I,Le="During inference:",ie,J,Pe="<li>The <em>quality</em> of the predicted audio sample can be controlled by the <code>num_inference_steps</code> argument; higher steps give higher quality audio at the expense of slower inference.</li> <li>The <em>length</em> of the predicted audio sample can be controlled by varying the <code>audio_length_in_s</code> argument.</li>",ae,P,se,H,re,m,S,fe,Z,De="Pipeline for text-to-audio generation using AudioLDM.",he,z,Ce=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,ge,v,N,_e,R,ke="The call function to the pipeline for generation.",be,D,le,q,de,A,E,ve,V,je="Output class for audio pipelines.",pe,W,ce;return f=new me({props:{title:"AudioLDM",local:"audioldm",headingTag:"h1"}}),U=new me({props:{title:"Tips",local:"tips",headingTag:"h2"}}),P=new Se({props:{$$slots:{default:[Ee]},$$scope:{ctx:O}}}),H=new me({props:{title:"AudioLDMPipeline",local:"diffusers.AudioLDMPipeline",headingTag:"h2"}}),S=new Me({props:{name:"class diffusers.AudioLDMPipeline",anchor:"diffusers.AudioLDMPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": ClapTextModelWithProjection"},{name:"tokenizer",val:": Union"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"vocoder",val:": SpeechT5HifiGan"}],parametersDescription:[{anchor:"diffusers.AudioLDMPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.AudioLDMPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clap#transformers.ClapTextModelWithProjection" rel="nofollow">ClapTextModelWithProjection</a>) &#x2014;
Frozen text-encoder (<code>ClapTextModelWithProjection</code>, specifically the
<a href="https://huggingface.co/laion/clap-htsat-unfused" rel="nofollow">laion/clap-htsat-unfused</a> variant.`,name:"text_encoder"},{anchor:"diffusers.AudioLDMPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>PreTrainedTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizer" rel="nofollow">RobertaTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.AudioLDMPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded audio latents.`,name:"unet"},{anchor:"diffusers.AudioLDMPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded audio latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.AudioLDMPipeline.vocoder",description:`<strong>vocoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5HifiGan" rel="nofollow">SpeechT5HifiGan</a>) &#x2014;
Vocoder of class <code>SpeechT5HifiGan</code>.`,name:"vocoder"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm/pipeline_audioldm.py#L52"}}),N=new Me({props:{name:"__call__",anchor:"diffusers.AudioLDMPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"audio_length_in_s",val:": Optional = None"},{name:"num_inference_steps",val:": int = 10"},{name:"guidance_scale",val:": float = 2.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_waveforms_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": Optional = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"output_type",val:": Optional = 'np'"}],parametersDescription:[{anchor:"diffusers.AudioLDMPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide audio generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.AudioLDMPipeline.__call__.audio_length_in_s",description:`<strong>audio_length_in_s</strong> (<code>int</code>, <em>optional</em>, defaults to 5.12) &#x2014;
The length of the generated audio sample in seconds.`,name:"audio_length_in_s"},{anchor:"diffusers.AudioLDMPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality audio at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.AudioLDMPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 2.5) &#x2014;
A higher guidance scale value encourages the model to generate audio that is closely linked to the text
<code>prompt</code> at the expense of lower sound quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.AudioLDMPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in audio generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AudioLDMPipeline.__call__.num_waveforms_per_prompt",description:`<strong>num_waveforms_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of waveforms to generate per prompt.`,name:"num_waveforms_per_prompt"},{anchor:"diffusers.AudioLDMPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.AudioLDMPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.AudioLDMPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.AudioLDMPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AudioLDMPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AudioLDMPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/audioldm2#diffusers.AudioPipelineOutput">AudioPipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.AudioLDMPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.AudioLDMPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.AudioLDMPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AudioLDMPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>&quot;np&quot;</code> to return a NumPy <code>np.ndarray</code> or
<code>&quot;pt&quot;</code> to return a PyTorch <code>torch.Tensor</code> object.`,name:"output_type"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm/pipeline_audioldm.py#L351",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/audioldm2#diffusers.AudioPipelineOutput"
>AudioPipelineOutput</a> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/audioldm2#diffusers.AudioPipelineOutput"
>AudioPipelineOutput</a> or <code>tuple</code></p>
`}}),D=new qe({props:{anchor:"diffusers.AudioLDMPipeline.__call__.example",$$slots:{default:[Oe]},$$scope:{ctx:O}}}),q=new me({props:{title:"AudioPipelineOutput",local:"diffusers.AudioPipelineOutput",headingTag:"h2"}}),E=new Me({props:{name:"class diffusers.AudioPipelineOutput",anchor:"diffusers.AudioPipelineOutput",parameters:[{name:"audios",val:": ndarray"}],parametersDescription:[{anchor:"diffusers.AudioPipelineOutput.audios",description:`<strong>audios</strong> (<code>np.ndarray</code>) &#x2014;
List of denoised audio samples of a NumPy array of shape <code>(batch_size, num_channels, sample_rate)</code>.`,name:"audios"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L132"}}),{c(){i=r("meta"),b=a(),p=r("p"),c=a(),M(f.$$.fragment),d=a(),g=r("p"),g.innerHTML=we,X=a(),C=r("p"),C.textContent=ye,Q=a(),k=r("p"),k.innerHTML=xe,K=a(),j=r("p"),j.innerHTML=Te,ee=a(),M(U.$$.fragment),te=a(),G=r("p"),G.textContent=$e,ne=a(),B=r("ul"),B.innerHTML=Ae,oe=a(),I=r("p"),I.textContent=Le,ie=a(),J=r("ul"),J.innerHTML=Pe,ae=a(),M(P.$$.fragment),se=a(),M(H.$$.fragment),re=a(),m=r("div"),M(S.$$.fragment),fe=a(),Z=r("p"),Z.textContent=De,he=a(),z=r("p"),z.innerHTML=Ce,ge=a(),v=r("div"),M(N.$$.fragment),_e=a(),R=r("p"),R.textContent=ke,be=a(),M(D.$$.fragment),le=a(),M(q.$$.fragment),de=a(),A=r("div"),M(E.$$.fragment),ve=a(),V=r("p"),V.textContent=je,pe=a(),W=r("p"),this.h()},l(e){const t=He("svelte-u9bgzb",document.head);i=l(t,"META",{name:!0,content:!0}),t.forEach(n),b=s(e),p=l(e,"P",{}),F(p).forEach(n),c=s(e),w(f.$$.fragment,e),d=s(e),g=l(e,"P",{"data-svelte-h":!0}),u(g)!=="svelte-1ozr8g7"&&(g.innerHTML=we),X=s(e),C=l(e,"P",{"data-svelte-h":!0}),u(C)!=="svelte-1cwsb16"&&(C.textContent=ye),Q=s(e),k=l(e,"P",{"data-svelte-h":!0}),u(k)!=="svelte-64lmgc"&&(k.innerHTML=xe),K=s(e),j=l(e,"P",{"data-svelte-h":!0}),u(j)!=="svelte-1n8fwj9"&&(j.innerHTML=Te),ee=s(e),w(U.$$.fragment,e),te=s(e),G=l(e,"P",{"data-svelte-h":!0}),u(G)!=="svelte-1dvtu0c"&&(G.textContent=$e),ne=s(e),B=l(e,"UL",{"data-svelte-h":!0}),u(B)!=="svelte-msgw5q"&&(B.innerHTML=Ae),oe=s(e),I=l(e,"P",{"data-svelte-h":!0}),u(I)!=="svelte-1g0t9wk"&&(I.textContent=Le),ie=s(e),J=l(e,"UL",{"data-svelte-h":!0}),u(J)!=="svelte-jm9a2k"&&(J.innerHTML=Pe),ae=s(e),w(P.$$.fragment,e),se=s(e),w(H.$$.fragment,e),re=s(e),m=l(e,"DIV",{class:!0});var _=F(m);w(S.$$.fragment,_),fe=s(_),Z=l(_,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-1vrcpd4"&&(Z.textContent=De),he=s(_),z=l(_,"P",{"data-svelte-h":!0}),u(z)!=="svelte-496sm0"&&(z.innerHTML=Ce),ge=s(_),v=l(_,"DIV",{class:!0});var L=F(v);w(N.$$.fragment,L),_e=s(L),R=l(L,"P",{"data-svelte-h":!0}),u(R)!=="svelte-50j04k"&&(R.textContent=ke),be=s(L),w(D.$$.fragment,L),L.forEach(n),_.forEach(n),le=s(e),w(q.$$.fragment,e),de=s(e),A=l(e,"DIV",{class:!0});var ue=F(A);w(E.$$.fragment,ue),ve=s(ue),V=l(ue,"P",{"data-svelte-h":!0}),u(V)!=="svelte-19ryw33"&&(V.textContent=je),ue.forEach(n),pe=s(e),W=l(e,"P",{}),F(W).forEach(n),this.h()},h(){Y(i,"name","hf:doc:metadata"),Y(i,"content",ze),Y(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Y(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Y(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){h(document.head,i),o(e,b,t),o(e,p,t),o(e,c,t),y(f,e,t),o(e,d,t),o(e,g,t),o(e,X,t),o(e,C,t),o(e,Q,t),o(e,k,t),o(e,K,t),o(e,j,t),o(e,ee,t),y(U,e,t),o(e,te,t),o(e,G,t),o(e,ne,t),o(e,B,t),o(e,oe,t),o(e,I,t),o(e,ie,t),o(e,J,t),o(e,ae,t),y(P,e,t),o(e,se,t),y(H,e,t),o(e,re,t),o(e,m,t),y(S,m,null),h(m,fe),h(m,Z),h(m,he),h(m,z),h(m,ge),h(m,v),y(N,v,null),h(v,_e),h(v,R),h(v,be),y(D,v,null),o(e,le,t),y(q,e,t),o(e,de,t),o(e,A,t),y(E,A,null),h(A,ve),h(A,V),o(e,pe,t),o(e,W,t),ce=!0},p(e,[t]){const _={};t&2&&(_.$$scope={dirty:t,ctx:e}),P.$set(_);const L={};t&2&&(L.$$scope={dirty:t,ctx:e}),D.$set(L)},i(e){ce||(x(f.$$.fragment,e),x(U.$$.fragment,e),x(P.$$.fragment,e),x(H.$$.fragment,e),x(S.$$.fragment,e),x(N.$$.fragment,e),x(D.$$.fragment,e),x(q.$$.fragment,e),x(E.$$.fragment,e),ce=!0)},o(e){T(f.$$.fragment,e),T(U.$$.fragment,e),T(P.$$.fragment,e),T(H.$$.fragment,e),T(S.$$.fragment,e),T(N.$$.fragment,e),T(D.$$.fragment,e),T(q.$$.fragment,e),T(E.$$.fragment,e),ce=!1},d(e){e&&(n(b),n(p),n(c),n(d),n(g),n(X),n(C),n(Q),n(k),n(K),n(j),n(ee),n(te),n(G),n(ne),n(B),n(oe),n(I),n(ie),n(J),n(ae),n(se),n(re),n(m),n(le),n(de),n(A),n(pe),n(W)),n(i),$(f,e),$(U,e),$(P,e),$(H,e),$(S),$(N),$(D),$(q,e),$(E)}}}const ze='{"title":"AudioLDM","local":"audioldm","sections":[{"title":"Tips","local":"tips","sections":[],"depth":2},{"title":"AudioLDMPipeline","local":"diffusers.AudioLDMPipeline","sections":[],"depth":2},{"title":"AudioPipelineOutput","local":"diffusers.AudioPipelineOutput","sections":[],"depth":2}],"depth":1}';function Re(O){return Be(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class et extends Ie{constructor(i){super(),Je(this,i,Re,Ze,Ge,{})}}export{et as component};
