import{s as Zo,o as Vo,n as Mt}from"../chunks/scheduler.182ea377.js";import{S as Jo,i as jo,g as a,s,r as f,A as ko,h as r,f as o,c as i,j as S,u,x as p,k as C,y as d,a as n,v as h,d as g,t as _,w as v}from"../chunks/index.abf12888.js";import{T as yo}from"../chunks/Tip.230e2334.js";import{D as ye}from"../chunks/Docstring.93f6f462.js";import{C as Me}from"../chunks/CodeBlock.57fe6e13.js";import{E as Mo}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as B}from"../chunks/Heading.16916d63.js";function Uo(j){let l,Z="🧪 This pipeline is for research purposes only.";return{c(){l=a("p"),l.textContent=Z},l(m){l=r(m,"P",{"data-svelte-h":!0}),p(l)!=="svelte-1oxhjjd"&&(l.textContent=Z)},m(m,b){n(m,l,b)},p:Mt,d(m){m&&o(l)}}}function $o(j){let l,Z='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){l=a("p"),l.innerHTML=Z},l(m){l=r(m,"P",{"data-svelte-h":!0}),p(l)!=="svelte-1wmc0l4"&&(l.innerHTML=Z)},m(m,b){n(m,l,b)},p:Mt,d(m){m&&o(l)}}}function So(j){let l,Z="Examples:",m,b,x;return b=new Me({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVGV4dFRvVmlkZW9TRFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b192aWRlbyUwQSUwQXBpcGUlMjAlM0QlMjBUZXh0VG9WaWRlb1NEUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmRhbW8tdmlsYWIlMkZ0ZXh0LXRvLXZpZGVvLW1zLTEuN2IlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyU3BpZGVybWFuJTIwaXMlMjBzdXJmaW5nJTIyJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZShwcm9tcHQpLmZyYW1lcyUwQXZpZGVvX3BhdGglMjAlM0QlMjBleHBvcnRfdG9fdmlkZW8odmlkZW9fZnJhbWVzKSUwQXZpZGVvX3BhdGg=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> TextToVideoSDPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = TextToVideoSDPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Spiderman is surfing&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_frames = pipe(prompt).frames
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = export_to_video(video_frames)
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path`,wrap:!1}}),{c(){l=a("p"),l.textContent=Z,m=s(),f(b.$$.fragment)},l(c){l=r(c,"P",{"data-svelte-h":!0}),p(l)!=="svelte-kvfsh7"&&(l.textContent=Z),m=i(c),u(b.$$.fragment,c)},m(c,V){n(c,l,V),n(c,m,V),h(b,c,V),x=!0},p:Mt,i(c){x||(g(b.$$.fragment,c),x=!0)},o(c){_(b.$$.fragment,c),x=!1},d(c){c&&(o(l),o(m)),v(b,c)}}}function Co(j){let l,Z="Examples:",m,b,x;return b=new Me({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;cerspense/zeroscope_v2_576w&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;spiderman running in the desert&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_frames = pipe(prompt, num_inference_steps=<span class="hljs-number">40</span>, height=<span class="hljs-number">320</span>, width=<span class="hljs-number">576</span>, num_frames=<span class="hljs-number">24</span>).frames
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># safe low-res video</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = export_to_video(video_frames, output_video_path=<span class="hljs-string">&quot;./video_576_spiderman.mp4&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let&#x27;s offload the text-to-image model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cpu&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and load the image-to-image model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;cerspense/zeroscope_v2_XL&quot;</span>, torch_dtype=torch.float16, revision=<span class="hljs-string">&quot;refs/pr/15&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The VAE consumes A LOT of memory, let&#x27;s make sure we run it in sliced mode</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_slicing()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># now let&#x27;s upscale it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video = [Image.fromarray(frame).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>)) <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> video_frames]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and denoise it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_frames = pipe(prompt, video=video, strength=<span class="hljs-number">0.6</span>).frames
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = export_to_video(video_frames, output_video_path=<span class="hljs-string">&quot;./video_1024_spiderman.mp4&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path`,wrap:!1}}),{c(){l=a("p"),l.textContent=Z,m=s(),f(b.$$.fragment)},l(c){l=r(c,"P",{"data-svelte-h":!0}),p(l)!=="svelte-kvfsh7"&&(l.textContent=Z),m=i(c),u(b.$$.fragment,c)},m(c,V){n(c,l,V),n(c,m,V),h(b,c,V),x=!0},p:Mt,i(c){x||(g(b.$$.fragment,c),x=!0)},o(c){_(b.$$.fragment,c),x=!1},d(c){c&&(o(l),o(m)),v(b,c)}}}function Do(j){let l,Z,m,b,x,c,V,ze,X,Et='<a href="https://arxiv.org/abs/2308.06571" rel="nofollow">ModelScope Text-to-Video Technical Report</a> is by Jiuniu Wang, Hangjie Yuan, Dayou Chen, Yingya Zhang, Xiang Wang, Shiwei Zhang.',Re,L,Ht="The abstract from the paper is:",Ne,z,Ft='<em>This paper introduces ModelScopeT2V, a text-to-video synthesis model that evolves from a text-to-image synthesis model (i.e., Stable Diffusion). ModelScopeT2V incorporates spatio-temporal blocks to ensure consistent frame generation and smooth movement transitions. The model could adapt to varying frame numbers during training and inference, rendering it suitable for both image-text and video-text datasets. ModelScopeT2V brings together three components (i.e., VQGAN, a text encoder, and a denoising UNet), totally comprising 1.7 billion parameters, in which 0.5 billion parameters are dedicated to temporal capabilities. The model demonstrates superior performance over state-of-the-art methods across three evaluation metrics. The code and an online demo are available at <a href="https://modelscope.cn/models/damo/text-to-video-synthesis/summary" rel="nofollow">https://modelscope.cn/models/damo/text-to-video-synthesis/summary</a>.</em>',Ee,R,Yt='You can find additional information about Text-to-Video on the <a href="https://modelscope.cn/models/damo/text-to-video-synthesis/summary" rel="nofollow">project page</a>, <a href="https://github.com/modelscope/modelscope/" rel="nofollow">original codebase</a>, and try it out in a <a href="https://huggingface.co/spaces/damo-vilab/modelscope-text-to-video-synthesis" rel="nofollow">demo</a>. Official checkpoints can be found at <a href="https://huggingface.co/damo-vilab" rel="nofollow">damo-vilab</a> and <a href="https://huggingface.co/cerspense" rel="nofollow">cerspense</a>.',He,N,Fe,E,Ye,H,At="Let’s start by generating a short video with the default length of 16 frames (2s at 8 fps):",Ae,F,Qe,Y,Qt=`Diffusers supports different optimization techniques to improve the latency
and memory footprint of a pipeline. Since videos are often more memory-heavy than images,
we can enable CPU offloading and VAE slicing to keep the memory footprint at bay.`,qe,A,qt="Let’s generate a video of 8 seconds (64 frames) on the same GPU using CPU offloading and VAE slicing:",Oe,Q,Ke,q,Ot="It just takes <strong>7 GBs of GPU memory</strong> to generate the 64 video frames using PyTorch 2.0, “fp16” precision and the techniques mentioned above.",et,O,Kt="We can also use a different scheduler easily, using the same method we’d use for Stable Diffusion:",tt,K,ot,ee,eo="Here are some sample outputs:",nt,te,to=`<tbody><tr><td><center>An astronaut riding a horse.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/astr.gif" alt="An astronaut riding a horse." style="width: 300px;"/></center></td> <td><center>Darth vader surfing in waves.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/vader.gif" alt="Darth vader surfing in waves." style="width: 300px;"/></center></td></tr></tbody>`,st,oe,it,ne,oo=`Zeroscope are watermark-free model and have been trained on specific sizes such as <code>576x320</code> and <code>1024x576</code>.
One should first generate a video using the lower resolution checkpoint <a href="https://huggingface.co/cerspense/zeroscope_v2_576w" rel="nofollow"><code>cerspense/zeroscope_v2_576w</code></a> with <a href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.TextToVideoSDPipeline">TextToVideoSDPipeline</a>,
which can then be upscaled using <a href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.VideoToVideoSDPipeline">VideoToVideoSDPipeline</a> and <a href="https://huggingface.co/cerspense/zeroscope_v2_XL" rel="nofollow"><code>cerspense/zeroscope_v2_XL</code></a>.`,at,se,rt,ie,no="Now the video can be upscaled:",lt,ae,dt,re,so="Here are some sample outputs:",pt,le,io=`<tbody><tr><td><center>Darth vader surfing in waves.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/darthvader_cerpense.gif" alt="Darth vader surfing in waves." style="width: 576px;"/></center></td></tr></tbody>`,ct,de,mt,pe,ao="Video generation is memory-intensive and one way to reduce your memory usage is to set <code>enable_forward_chunking</code> on the pipeline’s UNet so you don’t run the entire feedforward layer at once. Breaking it up into chunks in a loop is more efficient.",ft,ce,ro='Check out the <a href="text-img2vid">Text or image-to-video</a> guide for more details about how certain parameters can affect video generation and how to optimize inference by reducing memory usage.',ut,D,ht,me,gt,T,fe,Zt,Ze,lo="Pipeline for text-to-video generation.",Vt,Ve,po=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Jt,Je,co="The pipeline also inherits the following loading methods:",jt,je,mo='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li>',kt,k,ue,Ut,ke,fo="The call function to the pipeline for generation.",$t,G,St,P,he,Ct,Ue,uo="Encodes the prompt into text encoder hidden states.",_t,ge,vt,w,_e,Dt,$e,ho="Pipeline for text-guided video-to-video generation.",Gt,Se,go=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Pt,Ce,_o="The pipeline also inherits the following loading methods:",It,De,vo='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li>',Wt,U,ve,Bt,Ge,bo="The call function to the pipeline for generation.",Xt,I,Lt,W,be,zt,Pe,To="Encodes the prompt into text encoder hidden states.",bt,Te,Tt,J,we,Rt,Ie,wo="Output class for text-to-video pipelines.",Nt,We,xo=`PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>`,wt,Le,xt;return x=new yo({props:{warning:!0,$$slots:{default:[Uo]},$$scope:{ctx:j}}}),V=new B({props:{title:"Text-to-video",local:"text-to-video",headingTag:"h1"}}),N=new B({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),E=new B({props:{title:"text-to-video-ms-1.7b",local:"text-to-video-ms-17b",headingTag:"h3"}}),F=new Me({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJkYW1vLXZpbGFiJTJGdGV4dC10by12aWRlby1tcy0xLjdiJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJTcGlkZXJtYW4lMjBpcyUyMHN1cmZpbmclMjIlMEF2aWRlb19mcmFtZXMlMjAlM0QlMjBwaXBlKHByb21wdCkuZnJhbWVzJTVCMCU1RCUwQXZpZGVvX3BhdGglMjAlM0QlMjBleHBvcnRfdG9fdmlkZW8odmlkZW9fZnJhbWVzKSUwQXZpZGVvX3BhdGg=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Spiderman is surfing&quot;</span>
video_frames = pipe(prompt).frames[<span class="hljs-number">0</span>]
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),Q=new Me({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJkYW1vLXZpbGFiJTJGdGV4dC10by12aWRlby1tcy0xLjdiJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQSUyMyUyMG1lbW9yeSUyMG9wdGltaXphdGlvbiUwQXBpcGUuZW5hYmxlX3ZhZV9zbGljaW5nKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJEYXJ0aCUyMFZhZGVyJTIwc3VyZmluZyUyMGElMjB3YXZlJTIyJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1fZnJhbWVzJTNENjQpLmZyYW1lcyU1QjAlNUQlMEF2aWRlb19wYXRoJTIwJTNEJTIwZXhwb3J0X3RvX3ZpZGVvKHZpZGVvX2ZyYW1lcyklMEF2aWRlb19wYXRo",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># memory optimization</span>
pipe.enable_vae_slicing()

prompt = <span class="hljs-string">&quot;Darth Vader surfing a wave&quot;</span>
video_frames = pipe(prompt, num_frames=<span class="hljs-number">64</span>).frames[<span class="hljs-number">0</span>]
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),K=new Me({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJkYW1vLXZpbGFiJTJGdGV4dC10by12aWRlby1tcy0xLjdiJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJTcGlkZXJtYW4lMjBpcyUyMHN1cmZpbmclMjIlMEF2aWRlb19mcmFtZXMlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSkuZnJhbWVzJTVCMCU1RCUwQXZpZGVvX3BhdGglMjAlM0QlMjBleHBvcnRfdG9fdmlkZW8odmlkZW9fZnJhbWVzKSUwQXZpZGVvX3BhdGg=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;Spiderman is surfing&quot;</span>
video_frames = pipe(prompt, num_inference_steps=<span class="hljs-number">25</span>).frames[<span class="hljs-number">0</span>]
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),oe=new B({props:{title:"cerspense/zeroscope_v2_576w & cerspense/zeroscope_v2_XL",local:"cerspensezeroscopev2576w--cerspensezeroscopev2xl",headingTag:"h3"}}),se=new Me({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJjZXJzcGVuc2UlMkZ6ZXJvc2NvcGVfdjJfNTc2dyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBJTIzJTIwbWVtb3J5JTIwb3B0aW1pemF0aW9uJTBBcGlwZS51bmV0LmVuYWJsZV9mb3J3YXJkX2NodW5raW5nKGNodW5rX3NpemUlM0QxJTJDJTIwZGltJTNEMSklMEFwaXBlLmVuYWJsZV92YWVfc2xpY2luZygpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyRGFydGglMjBWYWRlciUyMHN1cmZpbmclMjBhJTIwd2F2ZSUyMiUwQXZpZGVvX2ZyYW1lcyUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2ZyYW1lcyUzRDI0KS5mcmFtZXMlNUIwJTVEJTBBdmlkZW9fcGF0aCUyMCUzRCUyMGV4cG9ydF90b192aWRlbyh2aWRlb19mcmFtZXMpJTBBdmlkZW9fcGF0aA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;cerspense/zeroscope_v2_576w&quot;</span>, torch_dtype=torch.float16)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># memory optimization</span>
pipe.unet.enable_forward_chunking(chunk_size=<span class="hljs-number">1</span>, dim=<span class="hljs-number">1</span>)
pipe.enable_vae_slicing()

prompt = <span class="hljs-string">&quot;Darth Vader surfing a wave&quot;</span>
video_frames = pipe(prompt, num_frames=<span class="hljs-number">24</span>).frames[<span class="hljs-number">0</span>]
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),ae=new Me({props:{code:"cGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJjZXJzcGVuc2UlMkZ6ZXJvc2NvcGVfdjJfWEwlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEElMjMlMjBtZW1vcnklMjBvcHRpbWl6YXRpb24lMEFwaXBlLnVuZXQuZW5hYmxlX2ZvcndhcmRfY2h1bmtpbmcoY2h1bmtfc2l6ZSUzRDElMkMlMjBkaW0lM0QxKSUwQXBpcGUuZW5hYmxlX3ZhZV9zbGljaW5nKCklMEElMEF2aWRlbyUyMCUzRCUyMCU1QkltYWdlLmZyb21hcnJheShmcmFtZSkucmVzaXplKCgxMDI0JTJDJTIwNTc2KSklMjBmb3IlMjBmcmFtZSUyMGluJTIwdmlkZW9fZnJhbWVzJTVEJTBBJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjB2aWRlbyUzRHZpZGVvJTJDJTIwc3RyZW5ndGglM0QwLjYpLmZyYW1lcyU1QjAlNUQlMEF2aWRlb19wYXRoJTIwJTNEJTIwZXhwb3J0X3RvX3ZpZGVvKHZpZGVvX2ZyYW1lcyklMEF2aWRlb19wYXRo",highlighted:`pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;cerspense/zeroscope_v2_XL&quot;</span>, torch_dtype=torch.float16)
pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># memory optimization</span>
pipe.unet.enable_forward_chunking(chunk_size=<span class="hljs-number">1</span>, dim=<span class="hljs-number">1</span>)
pipe.enable_vae_slicing()

video = [Image.fromarray(frame).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>)) <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> video_frames]

video_frames = pipe(prompt, video=video, strength=<span class="hljs-number">0.6</span>).frames[<span class="hljs-number">0</span>]
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),de=new B({props:{title:"Tips",local:"tips",headingTag:"h2"}}),D=new yo({props:{$$slots:{default:[$o]},$$scope:{ctx:j}}}),me=new B({props:{title:"TextToVideoSDPipeline",local:"diffusers.TextToVideoSDPipeline",headingTag:"h2"}}),fe=new ye({props:{name:"class diffusers.TextToVideoSDPipeline",anchor:"diffusers.TextToVideoSDPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet3DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.TextToVideoSDPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.TextToVideoSDPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.TextToVideoSDPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.TextToVideoSDPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.TextToVideoSDPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L84"}}),ue=new ye({props:{name:"__call__",anchor:"diffusers.TextToVideoSDPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_frames",val:": int = 16"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 9.0"},{name:"negative_prompt",val:": Union = None"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'np'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoSDPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of video frames that are generated. Defaults to 16 frames which at 8 frames per seconds
amounts to 2 seconds of video.`,name:"num_frames"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.FloatTensor</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L454",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> or <code>tuple</code></p>
`}}),G=new Mo({props:{anchor:"diffusers.TextToVideoSDPipeline.__call__.example",$$slots:{default:[So]},$$scope:{ctx:j}}}),he=new ye({props:{name:"encode_prompt",anchor:"diffusers.TextToVideoSDPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L166"}}),ge=new B({props:{title:"VideoToVideoSDPipeline",local:"diffusers.VideoToVideoSDPipeline",headingTag:"h2"}}),_e=new ye({props:{name:"class diffusers.VideoToVideoSDPipeline",anchor:"diffusers.VideoToVideoSDPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet3DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.VideoToVideoSDPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.VideoToVideoSDPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.VideoToVideoSDPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.VideoToVideoSDPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.VideoToVideoSDPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L160"}}),ve=new ye({props:{name:"__call__",anchor:"diffusers.VideoToVideoSDPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"video",val:": Union = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 15.0"},{name:"negative_prompt",val:": Union = None"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'np'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.VideoToVideoSDPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.video",description:`<strong>video</strong> (<code>List[np.ndarray]</code> or <code>torch.FloatTensor</code>) &#x2014;
<code>video</code> frames or tensor representing a video batch to be used as the starting point for the process.
Can also accept video latents as <code>image</code>, if passing latents directly, it will not be encoded again.`,name:"video"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Indicates extent to transform the reference <code>video</code>. Must be between 0 and 1. <code>video</code> is used as a
starting point, adding more noise to it the larger the <code>strength</code>. The number of denoising steps
depends on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the
denoising process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of
1 essentially ignores <code>video</code>.`,name:"strength"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in video generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.FloatTensor</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L561",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> or <code>tuple</code></p>
`}}),I=new Mo({props:{anchor:"diffusers.VideoToVideoSDPipeline.__call__.example",$$slots:{default:[Co]},$$scope:{ctx:j}}}),be=new ye({props:{name:"encode_prompt",anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L242"}}),Te=new B({props:{title:"TextToVideoSDPipelineOutput",local:"diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput",headingTag:"h2"}}),we=new ye({props:{name:"class diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput",anchor:"diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput",parameters:[{name:"frames",val:": Union"}],parametersDescription:[{anchor:"diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing denoised`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_output.py#L13"}}),{c(){l=a("meta"),Z=s(),m=a("p"),b=s(),f(x.$$.fragment),c=s(),f(V.$$.fragment),ze=s(),X=a("p"),X.innerHTML=Et,Re=s(),L=a("p"),L.textContent=Ht,Ne=s(),z=a("p"),z.innerHTML=Ft,Ee=s(),R=a("p"),R.innerHTML=Yt,He=s(),f(N.$$.fragment),Fe=s(),f(E.$$.fragment),Ye=s(),H=a("p"),H.textContent=At,Ae=s(),f(F.$$.fragment),Qe=s(),Y=a("p"),Y.textContent=Qt,qe=s(),A=a("p"),A.textContent=qt,Oe=s(),f(Q.$$.fragment),Ke=s(),q=a("p"),q.innerHTML=Ot,et=s(),O=a("p"),O.textContent=Kt,tt=s(),f(K.$$.fragment),ot=s(),ee=a("p"),ee.textContent=eo,nt=s(),te=a("table"),te.innerHTML=to,st=s(),f(oe.$$.fragment),it=s(),ne=a("p"),ne.innerHTML=oo,at=s(),f(se.$$.fragment),rt=s(),ie=a("p"),ie.textContent=no,lt=s(),f(ae.$$.fragment),dt=s(),re=a("p"),re.textContent=so,pt=s(),le=a("table"),le.innerHTML=io,ct=s(),f(de.$$.fragment),mt=s(),pe=a("p"),pe.innerHTML=ao,ft=s(),ce=a("p"),ce.innerHTML=ro,ut=s(),f(D.$$.fragment),ht=s(),f(me.$$.fragment),gt=s(),T=a("div"),f(fe.$$.fragment),Zt=s(),Ze=a("p"),Ze.textContent=lo,Vt=s(),Ve=a("p"),Ve.innerHTML=po,Jt=s(),Je=a("p"),Je.textContent=co,jt=s(),je=a("ul"),je.innerHTML=mo,kt=s(),k=a("div"),f(ue.$$.fragment),Ut=s(),ke=a("p"),ke.textContent=fo,$t=s(),f(G.$$.fragment),St=s(),P=a("div"),f(he.$$.fragment),Ct=s(),Ue=a("p"),Ue.textContent=uo,_t=s(),f(ge.$$.fragment),vt=s(),w=a("div"),f(_e.$$.fragment),Dt=s(),$e=a("p"),$e.textContent=ho,Gt=s(),Se=a("p"),Se.innerHTML=go,Pt=s(),Ce=a("p"),Ce.textContent=_o,It=s(),De=a("ul"),De.innerHTML=vo,Wt=s(),U=a("div"),f(ve.$$.fragment),Bt=s(),Ge=a("p"),Ge.textContent=bo,Xt=s(),f(I.$$.fragment),Lt=s(),W=a("div"),f(be.$$.fragment),zt=s(),Pe=a("p"),Pe.textContent=To,bt=s(),f(Te.$$.fragment),Tt=s(),J=a("div"),f(we.$$.fragment),Rt=s(),Ie=a("p"),Ie.textContent=wo,Nt=s(),We=a("p"),We.innerHTML=xo,wt=s(),Le=a("p"),this.h()},l(e){const t=ko("svelte-u9bgzb",document.head);l=r(t,"META",{name:!0,content:!0}),t.forEach(o),Z=i(e),m=r(e,"P",{}),S(m).forEach(o),b=i(e),u(x.$$.fragment,e),c=i(e),u(V.$$.fragment,e),ze=i(e),X=r(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-17trsey"&&(X.innerHTML=Et),Re=i(e),L=r(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1cwsb16"&&(L.textContent=Ht),Ne=i(e),z=r(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1ovx0um"&&(z.innerHTML=Ft),Ee=i(e),R=r(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-9292p9"&&(R.innerHTML=Yt),He=i(e),u(N.$$.fragment,e),Fe=i(e),u(E.$$.fragment,e),Ye=i(e),H=r(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-a4ktac"&&(H.textContent=At),Ae=i(e),u(F.$$.fragment,e),Qe=i(e),Y=r(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1gwbshq"&&(Y.textContent=Qt),qe=i(e),A=r(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-yoc5w4"&&(A.textContent=qt),Oe=i(e),u(Q.$$.fragment,e),Ke=i(e),q=r(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-m9rmsr"&&(q.innerHTML=Ot),et=i(e),O=r(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1yxs7ur"&&(O.textContent=Kt),tt=i(e),u(K.$$.fragment,e),ot=i(e),ee=r(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1pxzje"&&(ee.textContent=eo),nt=i(e),te=r(e,"TABLE",{"data-svelte-h":!0}),p(te)!=="svelte-5s26g4"&&(te.innerHTML=to),st=i(e),u(oe.$$.fragment,e),it=i(e),ne=r(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-iil1ky"&&(ne.innerHTML=oo),at=i(e),u(se.$$.fragment,e),rt=i(e),ie=r(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-4ywac8"&&(ie.textContent=no),lt=i(e),u(ae.$$.fragment,e),dt=i(e),re=r(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1pxzje"&&(re.textContent=so),pt=i(e),le=r(e,"TABLE",{"data-svelte-h":!0}),p(le)!=="svelte-9iw63g"&&(le.innerHTML=io),ct=i(e),u(de.$$.fragment,e),mt=i(e),pe=r(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-op8wgu"&&(pe.innerHTML=ao),ft=i(e),ce=r(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1lb9rti"&&(ce.innerHTML=ro),ut=i(e),u(D.$$.fragment,e),ht=i(e),u(me.$$.fragment,e),gt=i(e),T=r(e,"DIV",{class:!0});var y=S(T);u(fe.$$.fragment,y),Zt=i(y),Ze=r(y,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-19ipoo4"&&(Ze.textContent=lo),Vt=i(y),Ve=r(y,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-496sm0"&&(Ve.innerHTML=po),Jt=i(y),Je=r(y,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-14s6m4u"&&(Je.textContent=co),jt=i(y),je=r(y,"UL",{"data-svelte-h":!0}),p(je)!=="svelte-ks5x56"&&(je.innerHTML=mo),kt=i(y),k=r(y,"DIV",{class:!0});var $=S(k);u(ue.$$.fragment,$),Ut=i($),ke=r($,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-50j04k"&&(ke.textContent=fo),$t=i($),u(G.$$.fragment,$),$.forEach(o),St=i(y),P=r(y,"DIV",{class:!0});var xe=S(P);u(he.$$.fragment,xe),Ct=i(xe),Ue=r(xe,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-16q0ax1"&&(Ue.textContent=uo),xe.forEach(o),y.forEach(o),_t=i(e),u(ge.$$.fragment,e),vt=i(e),w=r(e,"DIV",{class:!0});var M=S(w);u(_e.$$.fragment,M),Dt=i(M),$e=r(M,"P",{"data-svelte-h":!0}),p($e)!=="svelte-1oyadpc"&&($e.textContent=ho),Gt=i(M),Se=r(M,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-496sm0"&&(Se.innerHTML=go),Pt=i(M),Ce=r(M,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-14s6m4u"&&(Ce.textContent=_o),It=i(M),De=r(M,"UL",{"data-svelte-h":!0}),p(De)!=="svelte-ks5x56"&&(De.innerHTML=vo),Wt=i(M),U=r(M,"DIV",{class:!0});var Be=S(U);u(ve.$$.fragment,Be),Bt=i(Be),Ge=r(Be,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-50j04k"&&(Ge.textContent=bo),Xt=i(Be),u(I.$$.fragment,Be),Be.forEach(o),Lt=i(M),W=r(M,"DIV",{class:!0});var yt=S(W);u(be.$$.fragment,yt),zt=i(yt),Pe=r(yt,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-16q0ax1"&&(Pe.textContent=To),yt.forEach(o),M.forEach(o),bt=i(e),u(Te.$$.fragment,e),Tt=i(e),J=r(e,"DIV",{class:!0});var Xe=S(J);u(we.$$.fragment,Xe),Rt=i(Xe),Ie=r(Xe,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-1uuckb2"&&(Ie.textContent=wo),Nt=i(Xe),We=r(Xe,"P",{"data-svelte-h":!0}),p(We)!=="svelte-gk6g69"&&(We.innerHTML=xo),Xe.forEach(o),wt=i(e),Le=r(e,"P",{}),S(Le).forEach(o),this.h()},h(){C(l,"name","hf:doc:metadata"),C(l,"content",Go),C(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,l),n(e,Z,t),n(e,m,t),n(e,b,t),h(x,e,t),n(e,c,t),h(V,e,t),n(e,ze,t),n(e,X,t),n(e,Re,t),n(e,L,t),n(e,Ne,t),n(e,z,t),n(e,Ee,t),n(e,R,t),n(e,He,t),h(N,e,t),n(e,Fe,t),h(E,e,t),n(e,Ye,t),n(e,H,t),n(e,Ae,t),h(F,e,t),n(e,Qe,t),n(e,Y,t),n(e,qe,t),n(e,A,t),n(e,Oe,t),h(Q,e,t),n(e,Ke,t),n(e,q,t),n(e,et,t),n(e,O,t),n(e,tt,t),h(K,e,t),n(e,ot,t),n(e,ee,t),n(e,nt,t),n(e,te,t),n(e,st,t),h(oe,e,t),n(e,it,t),n(e,ne,t),n(e,at,t),h(se,e,t),n(e,rt,t),n(e,ie,t),n(e,lt,t),h(ae,e,t),n(e,dt,t),n(e,re,t),n(e,pt,t),n(e,le,t),n(e,ct,t),h(de,e,t),n(e,mt,t),n(e,pe,t),n(e,ft,t),n(e,ce,t),n(e,ut,t),h(D,e,t),n(e,ht,t),h(me,e,t),n(e,gt,t),n(e,T,t),h(fe,T,null),d(T,Zt),d(T,Ze),d(T,Vt),d(T,Ve),d(T,Jt),d(T,Je),d(T,jt),d(T,je),d(T,kt),d(T,k),h(ue,k,null),d(k,Ut),d(k,ke),d(k,$t),h(G,k,null),d(T,St),d(T,P),h(he,P,null),d(P,Ct),d(P,Ue),n(e,_t,t),h(ge,e,t),n(e,vt,t),n(e,w,t),h(_e,w,null),d(w,Dt),d(w,$e),d(w,Gt),d(w,Se),d(w,Pt),d(w,Ce),d(w,It),d(w,De),d(w,Wt),d(w,U),h(ve,U,null),d(U,Bt),d(U,Ge),d(U,Xt),h(I,U,null),d(w,Lt),d(w,W),h(be,W,null),d(W,zt),d(W,Pe),n(e,bt,t),h(Te,e,t),n(e,Tt,t),n(e,J,t),h(we,J,null),d(J,Rt),d(J,Ie),d(J,Nt),d(J,We),n(e,wt,t),n(e,Le,t),xt=!0},p(e,[t]){const y={};t&2&&(y.$$scope={dirty:t,ctx:e}),x.$set(y);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),D.$set($);const xe={};t&2&&(xe.$$scope={dirty:t,ctx:e}),G.$set(xe);const M={};t&2&&(M.$$scope={dirty:t,ctx:e}),I.$set(M)},i(e){xt||(g(x.$$.fragment,e),g(V.$$.fragment,e),g(N.$$.fragment,e),g(E.$$.fragment,e),g(F.$$.fragment,e),g(Q.$$.fragment,e),g(K.$$.fragment,e),g(oe.$$.fragment,e),g(se.$$.fragment,e),g(ae.$$.fragment,e),g(de.$$.fragment,e),g(D.$$.fragment,e),g(me.$$.fragment,e),g(fe.$$.fragment,e),g(ue.$$.fragment,e),g(G.$$.fragment,e),g(he.$$.fragment,e),g(ge.$$.fragment,e),g(_e.$$.fragment,e),g(ve.$$.fragment,e),g(I.$$.fragment,e),g(be.$$.fragment,e),g(Te.$$.fragment,e),g(we.$$.fragment,e),xt=!0)},o(e){_(x.$$.fragment,e),_(V.$$.fragment,e),_(N.$$.fragment,e),_(E.$$.fragment,e),_(F.$$.fragment,e),_(Q.$$.fragment,e),_(K.$$.fragment,e),_(oe.$$.fragment,e),_(se.$$.fragment,e),_(ae.$$.fragment,e),_(de.$$.fragment,e),_(D.$$.fragment,e),_(me.$$.fragment,e),_(fe.$$.fragment,e),_(ue.$$.fragment,e),_(G.$$.fragment,e),_(he.$$.fragment,e),_(ge.$$.fragment,e),_(_e.$$.fragment,e),_(ve.$$.fragment,e),_(I.$$.fragment,e),_(be.$$.fragment,e),_(Te.$$.fragment,e),_(we.$$.fragment,e),xt=!1},d(e){e&&(o(Z),o(m),o(b),o(c),o(ze),o(X),o(Re),o(L),o(Ne),o(z),o(Ee),o(R),o(He),o(Fe),o(Ye),o(H),o(Ae),o(Qe),o(Y),o(qe),o(A),o(Oe),o(Ke),o(q),o(et),o(O),o(tt),o(ot),o(ee),o(nt),o(te),o(st),o(it),o(ne),o(at),o(rt),o(ie),o(lt),o(dt),o(re),o(pt),o(le),o(ct),o(mt),o(pe),o(ft),o(ce),o(ut),o(ht),o(gt),o(T),o(_t),o(vt),o(w),o(bt),o(Tt),o(J),o(wt),o(Le)),o(l),v(x,e),v(V,e),v(N,e),v(E,e),v(F,e),v(Q,e),v(K,e),v(oe,e),v(se,e),v(ae,e),v(de,e),v(D,e),v(me,e),v(fe),v(ue),v(G),v(he),v(ge,e),v(_e),v(ve),v(I),v(be),v(Te,e),v(we)}}}const Go='{"title":"Text-to-video","local":"text-to-video","sections":[{"title":"Usage example","local":"usage-example","sections":[{"title":"text-to-video-ms-1.7b","local":"text-to-video-ms-17b","sections":[],"depth":3},{"title":"cerspense/zeroscope_v2_576w & cerspense/zeroscope_v2_XL","local":"cerspensezeroscopev2576w--cerspensezeroscopev2xl","sections":[],"depth":3}],"depth":2},{"title":"Tips","local":"tips","sections":[],"depth":2},{"title":"TextToVideoSDPipeline","local":"diffusers.TextToVideoSDPipeline","sections":[],"depth":2},{"title":"VideoToVideoSDPipeline","local":"diffusers.VideoToVideoSDPipeline","sections":[],"depth":2},{"title":"TextToVideoSDPipelineOutput","local":"diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput","sections":[],"depth":2}],"depth":1}';function Po(j){return Vo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class No extends Jo{constructor(l){super(),jo(this,l,Po,Do,Zo,{})}}export{No as component};
