import{s as fa,o as ga,n as re}from"../chunks/scheduler.9bc65507.js";import{S as _a,i as ka,g as i,s as n,r as p,A as ba,h as l,f as o,c as a,j as M,u,x as m,k as x,y as s,a as r,v as h,d as f,t as g,w as _}from"../chunks/index.707bf1b6.js";import{T as Co}from"../chunks/Tip.c2ecdbf4.js";import{D as q}from"../chunks/Docstring.17db21ae.js";import{C as At}from"../chunks/CodeBlock.54a9f38d.js";import{E as qo}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{P as ha}from"../chunks/PipelineTag.44585822.js";import{H as R}from"../chunks/Heading.342b1fa6.js";function va(C){let d,v=`The <code>Llama2</code> models were trained using <code>bfloat16</code>, but the original inference uses <code>float16</code>. The checkpoints uploaded on the Hub use <code>torch_dtype = &#39;float16&#39;</code>, which will be
used by the <code>AutoModel</code> API to cast the checkpoints from <code>torch.float32</code> to <code>torch.float16</code>.`,c,b,$="The <code>dtype</code> of the online weights is mostly irrelevant unless you are using <code>torch_dtype=&quot;auto&quot;</code> when initializing a model using <code>model = AutoModelForCausalLM.from_pretrained(&quot;path&quot;, torch_dtype = &quot;auto&quot;)</code>. The reason is that the model will first be downloaded ( using the <code>dtype</code> of the checkpoints online), then it will be casted to the default <code>dtype</code> of <code>torch</code> (becomes <code>torch.float32</code>), and finally, if there is a <code>torch_dtype</code> provided in the config, it will be used.",k,L,ie="Training the model in <code>float16</code> is not recommended and is known to produce <code>nan</code>; as such, the model should be trained in <code>bfloat16</code>.";return{c(){d=i("p"),d.innerHTML=v,c=n(),b=i("p"),b.innerHTML=$,k=n(),L=i("p"),L.innerHTML=ie},l(w){d=l(w,"P",{"data-svelte-h":!0}),m(d)!=="svelte-1ng8rlw"&&(d.innerHTML=v),c=a(w),b=l(w,"P",{"data-svelte-h":!0}),m(b)!=="svelte-17gt3kv"&&(b.innerHTML=$),k=a(w),L=l(w,"P",{"data-svelte-h":!0}),m(L)!=="svelte-wna3bo"&&(L.innerHTML=ie)},m(w,D){r(w,d,D),r(w,c,D),r(w,b,D),r(w,k,D),r(w,L,D)},p:re,d(w){w&&(o(d),o(c),o(b),o(k),o(L))}}}function ya(C){let d,v;return d=new At({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hTW9kZWwlMkMlMjBMbGFtYUNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBMTGFNQSUyMGxsYW1hLTdiJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMExsYW1hQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwbGxhbWEtN2IlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMExsYW1hTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaModel, LlamaConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a LLaMA llama-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = LlamaConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the llama-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlamaModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){p(d.$$.fragment)},l(c){u(d.$$.fragment,c)},m(c,b){h(d,c,b),v=!0},p:re,i(c){v||(f(d.$$.fragment,c),v=!0)},o(c){g(d.$$.fragment,c),v=!1},d(c){_(d,c)}}}function Ta(C){let d,v="sequence pair mask has the following format:",c,b,$;return b=new At({props:{code:"MCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMEElN0MlMjBmaXJzdCUyMHNlcXVlbmNlJTIwJTIwJTIwJTIwJTdDJTIwc2Vjb25kJTIwc2VxdWVuY2UlMjAlN0M=",highlighted:`0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1 1
| first sequence    | second sequence |`,wrap:!1}}),{c(){d=i("p"),d.textContent=v,c=n(),p(b.$$.fragment)},l(k){d=l(k,"P",{"data-svelte-h":!0}),m(d)!=="svelte-16klr56"&&(d.textContent=v),c=a(k),u(b.$$.fragment,k)},m(k,L){r(k,d,L),r(k,c,L),h(b,k,L),$=!0},p:re,i(k){$||(f(b.$$.fragment,k),$=!0)},o(k){g(b.$$.fragment,k),$=!1},d(k){k&&(o(d),o(c)),_(b,k)}}}function La(C){let d,v;return d=new At({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hVG9rZW5pemVyRmFzdCUwQSUwQXRva2VuaXplciUyMCUzRCUyMExsYW1hVG9rZW5pemVyRmFzdC5mcm9tX3ByZXRyYWluZWQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxsYW1hLXRva2VuaXplciUyMiklMEF0b2tlbml6ZXIuZW5jb2RlKCUyMkhlbGxvJTIwdGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaTokenizerFast

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = LlamaTokenizerFast.from_pretrained(<span class="hljs-string">&quot;hf-internal-testing/llama-tokenizer&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.encode(<span class="hljs-string">&quot;Hello this is a test&quot;</span>)
[<span class="hljs-number">1</span>, <span class="hljs-number">15043</span>, <span class="hljs-number">445</span>, <span class="hljs-number">338</span>, <span class="hljs-number">263</span>, <span class="hljs-number">1243</span>]`,wrap:!1}}),{c(){p(d.$$.fragment)},l(c){u(d.$$.fragment,c)},m(c,b){h(d,c,b),v=!0},p:re,i(c){v||(f(d.$$.fragment,c),v=!0)},o(c){g(d.$$.fragment,c),v=!1},d(c){_(d,c)}}}function wa(C){let d,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=i("p"),d.innerHTML=v},l(c){d=l(c,"P",{"data-svelte-h":!0}),m(d)!=="svelte-fincs2"&&(d.innerHTML=v)},m(c,b){r(c,d,b)},p:re,d(c){c&&o(d)}}}function $a(C){let d,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=i("p"),d.innerHTML=v},l(c){d=l(c,"P",{"data-svelte-h":!0}),m(d)!=="svelte-fincs2"&&(d.innerHTML=v)},m(c,b){r(c,d,b)},p:re,d(c){c&&o(d)}}}function Ma(C){let d,v="Example:",c,b,$;return b=new At({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBMbGFtYUZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGFtYUZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJIZXklMkMlMjBhcmUlMjB5b3UlMjBjb25zY2lvdXMlM0YlMjBDYW4lMjB5b3UlMjB0YWxrJTIwdG8lMjBtZSUzRiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzLmlucHV0X2lkcyUyQyUyMG1heF9sZW5ndGglM0QzMCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlJTJDJTIwY2xlYW5fdXBfdG9rZW5pemF0aW9uX3NwYWNlcyUzREZhbHNlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, LlamaForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlamaForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?\\nI&#x27;m not conscious, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){d=i("p"),d.textContent=v,c=n(),p(b.$$.fragment)},l(k){d=l(k,"P",{"data-svelte-h":!0}),m(d)!=="svelte-11lpom8"&&(d.textContent=v),c=a(k),u(b.$$.fragment,k)},m(k,L){r(k,d,L),r(k,c,L),h(b,k,L),$=!0},p:re,i(k){$||(f(b.$$.fragment,k),$=!0)},o(k){g(b.$$.fragment,k),$=!1},d(k){k&&(o(d),o(c)),_(b,k)}}}function xa(C){let d,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=i("p"),d.innerHTML=v},l(c){d=l(c,"P",{"data-svelte-h":!0}),m(d)!=="svelte-fincs2"&&(d.innerHTML=v)},m(c,b){r(c,d,b)},p:re,d(c){c&&o(d)}}}function za(C){let d,v,c,b,$,k,L,ie,w,D='The Llama2 model was proposed in <a href="https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/" rel="nofollow">LLaMA: Open Foundation and Fine-Tuned Chat Models</a> by Hugo Touvron, Louis Martin, Kevin Stone, Peter Albert, Amjad Almahairi, Yasmine Babaei, Nikolay Bashlykov, Soumya Batra, Prajjwal Bhargava, Shruti Bhosale, Dan Bikel, Lukas Blecher, Cristian Canton Ferrer, Moya Chen, Guillem Cucurull, David Esiobu, Jude Fernandes, Jeremy Fu, Wenyin Fu, Brian Fuller, Cynthia Gao, Vedanuj Goswami, Naman Goyal, Anthony Hartshorn, Saghar Hosseini, Rui Hou, Hakan Inan, Marcin Kardas, Viktor Kerkez Madian Khabsa, Isabel Kloumann, Artem Korenev, Punit Singh Koura, Marie-Anne Lachaux, Thibaut Lavril, Jenya Lee, Diana Liskovich, Yinghai Lu, Yuning Mao, Xavier Martinet, Todor Mihaylov, Pushka rMishra, Igor Molybog, Yixin Nie, Andrew Poulton, Jeremy Reizenstein, Rashi Rungta, Kalyan Saladi, Alan Schelten, Ruan Silva, Eric Michael Smith, Ranjan Subramanian, Xiaoqing EllenTan, Binh Tang, Ross Taylor, Adina Williams, Jian Xiang Kuan, Puxin Xu, Zheng Yan, Iliyan Zarov, Yuchen Zhang, Angela Fan, Melanie Kambadur, Sharan Narang, Aurelien Rodriguez, Robert Stojnic, Sergey Edunov, Thomas Scialom. It is a collection of foundation language models ranging from 7B to 70B parameters, with checkpoints finetuned for chat application!',Et,le,Ln="The abstract from the paper is the following:",Nt,de,wn="<em>In this work, we develop and release Llama 2, a collection of pretrained and fine-tuned large language models (LLMs) ranging in scale from 7 billion to 70 billion parameters. Our fine-tuned LLMs, called Llama 2-Chat, are optimized for dialogue use cases. Our models outperform open-source chat models on most benchmarks we tested, and based on our human evaluations for helpfulness and safety, may be a suitable substitute for closed-source models. We provide a detailed description of our approach to fine-tuning and safety improvements of Llama 2-Chat in order to enable the community to build on our work and contribute to the responsible development of LLMs.</em>",Bt,ce,$n=`Checkout all Llama2 model checkpoints <a href="https://huggingface.co/models?search=llama2" rel="nofollow">here</a>.
This model was contributed by <a href="https://huggingface.co/ArthurZ" rel="nofollow">Arthur Zucker</a> with contributions from <a href="https://huggingface.co/lysandre" rel="nofollow">Lysandre Debut</a>. The code of the implementation in Hugging Face is based on GPT-NeoX <a href="https://github.com/EleutherAI/gpt-neox" rel="nofollow">here</a>. The original code of the authors can be found <a href="https://github.com/facebookresearch/llama" rel="nofollow">here</a>.`,Jt,me,Rt,Z,Gt,pe,Mn="Tips:",Dt,ue,xn='<li>Weights for the Llama2 models can be obtained by filling out <a href="https://ai.meta.com/resources/models-and-libraries/llama-downloads/" rel="nofollow">this form</a></li> <li>The architecture is very similar to the first Llama, with the addition of Grouped Query Attention (GQA) following this <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">paper</a></li> <li>Setting <code>config.pretraining_tp</code> to a value different than 1 will activate the more accurate but slower computation of the linear layers, which should better match the original logits.</li> <li>The original model uses <code>pad_id = -1</code> which means that there is no padding token. We can’t have the same logic, make sure to add a padding token using <code>tokenizer.add_special_tokens({&quot;pad_token&quot;:&quot;&lt;pad&gt;&quot;})</code> and resize the token embedding accordingly. You should also set the <code>model.config.pad_token_id</code>. The <code>embed_tokens</code> layer of the model is initialized with <code>self.embed_tokens = nn.Embedding(config.vocab_size, config.hidden_size, self.config.padding_idx)</code>, which makes sure that encoding the padding token will output zeros, so passing it when initializing is recommended.</li> <li>After filling out the form and gaining access to the model checkpoints, you should be able to use the already converted checkpoints. Otherwise, if you are converting your own model, feel free to use the <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/convert_llama_weights_to_hf.py" rel="nofollow">conversion script</a>. The script can be called with the following (example) command:</li>',Zt,he,Vt,fe,zn="<li>After conversion, the model and tokenizer can be loaded via:</li>",Ot,ge,Xt,_e,Cn=`Note that executing the script requires enough CPU RAM to host the whole model in float16 precision (even if the biggest versions
come in several checkpoints they each contain a part of each weight of the model, so we need to load them all in RAM). For the 75B model, it’s thus 145GB of RAM needed.`,Yt,ke,qn='<li><p>The LLaMA tokenizer is a BPE model based on <a href="https://github.com/google/sentencepiece" rel="nofollow">sentencepiece</a>. One quirk of sentencepiece is that when decoding a sequence, if the first token is the start of the word (e.g. “Banana”), the tokenizer does not prepend the prefix space to the string.</p></li> <li><p>When using Flash Attention 2 via <code>attn_implementation=&quot;flash_attention_2&quot;</code>, don’t pass <code>torch_dtype</code> to the <code>from_pretrained</code> class method and use Automatic Mixed-Precision training. When using <code>Trainer</code>, it is simply specifying either <code>fp16</code> or <code>bf16</code> to <code>True</code>. Otherwise, make sure you are using <code>torch.autocast</code>. This is required because the Flash Attention only support <code>fp16</code> and <code>bf16</code> data type.</p></li>',Qt,be,Kt,ve,Fn="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with LLaMA2. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",eo,ye,Pn='<li><a href="https://huggingface.co/blog/llama2" rel="nofollow">Llama 2 is here - get it on Hugging Face</a>, a blog post about Llama 2 and how to use it with 🤗 Transformers and 🤗 PEFT.</li> <li><a href="https://www.philschmid.de/llama-2" rel="nofollow">LLaMA 2 - Every Resource you need</a>, a compilation of relevant resources to learn about LLaMA 2 and how to get started quickly.</li>',to,Te,oo,Le,jn='<li>A <a href="https://colab.research.google.com/drive/1PEQyJO1-f6j0S_XJ8DV50NkpzasXkrzd?usp=sharing" rel="nofollow">notebook</a> on how to fine-tune Llama 2 in Google Colab using QLoRA and 4-bit precision. 🌎</li> <li>A <a href="https://colab.research.google.com/drive/134o_cXcMe_lsvl15ZE_4Y75Kstepsntu?usp=sharing" rel="nofollow">notebook</a> on how to fine-tune the “Llama-v2-7b-guanaco” model with 4-bit QLoRA and generate Q&amp;A datasets from PDFs. 🌎</li>',no,we,ao,$e,In='<li>A <a href="https://colab.research.google.com/drive/1ggaa2oRFphdBmqIjSEbnb_HGkcIRC2ZB?usp=sharing" rel="nofollow">notebook</a> on how to fine-tune the Llama 2 model with QLoRa, TRL, and Korean text classification dataset. 🌎🇰🇷</li>',so,Me,Wn="⚗️ Optimization",ro,xe,An='<li><a href="https://huggingface.co/blog/dpo-trl" rel="nofollow">Fine-tune Llama 2 with DPO</a>, a guide to using the TRL library’s DPO method to fine tune Llama 2 on a specific dataset.</li> <li><a href="https://www.philschmid.de/instruction-tune-llama-2" rel="nofollow">Extended Guide: Instruction-tune Llama 2</a>, a guide to training Llama 2 to generate instructions from inputs, transforming the model from instruction-following to instruction-giving.</li> <li>A <a href="https://colab.research.google.com/drive/1SYpgFpcmtIUzdE7pxqknrM4ArCASfkFQ?usp=sharing" rel="nofollow">notebook</a> on how to fine-tune the Llama 2 model on a personal computer using QLoRa and TRL. 🌎</li>',io,ze,Hn="⚡️ Inference",lo,Ce,Un='<li>A <a href="https://colab.research.google.com/drive/1TC56ArKerXUpbgRy5vM3woRsbTEVNq7h?usp=sharing" rel="nofollow">notebook</a> on how to quantize the Llama 2 model using GPTQ from the AutoGPTQ library. 🌎</li> <li>A <a href="https://colab.research.google.com/drive/1X1z9Q6domMKl2CnEM0QGHNwidLfR4dW2?usp=sharing" rel="nofollow">notebook</a> on how to run the Llama 2 Chat Model with 4-bit quantization on a local computer or Google Colab. 🌎</li>',co,qe,Sn="🚀 Deploy",mo,Fe,En='<li><a href="https://www.philschmid.de/sagemaker-llama2-qlora" rel="nofollow">Fine-tune LLaMA 2 (7-70B) on Amazon SageMaker</a>, a complete guide from setup to QLoRA fine-tuning and deployment on Amazon SageMaker.</li> <li><a href="https://www.philschmid.de/sagemaker-llama-llm" rel="nofollow">Deploy Llama 2 7B/13B/70B on Amazon SageMaker</a>, a guide on using Hugging Face’s LLM DLC container for secure and scalable deployment.</li>',po,Pe,uo,W,je,Fo,at,Nn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaModel">LlamaModel</a>. It is used to instantiate an LLaMA
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the LLaMA-7B.`,Po,st,Bn=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,jo,V,ho,Ie,fo,F,We,Io,rt,Jn=`Construct a Llama tokenizer. Based on byte-level Byte-Pair-Encoding. The default padding token is unset as there is
no padding token in the original model.`,Wo,it,Ae,Ao,O,He,Ho,lt,Rn=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,Uo,A,Ue,So,dt,Gn="Creates a mask from the two sequences passed to be used in a sequence-pair classification task. An ALBERT",Eo,X,No,ct,Dn="if token_ids_1 is None, only returns the first portion of the mask (0s).",Bo,Y,Se,Jo,mt,Zn="Save the vocabulary and special tokens file to a directory.",go,Ee,_o,y,Ne,Ro,pt,Vn="Construct a Llama tokenizer. Based on byte-level Byte-Pair-Encoding.",Go,ut,On="This uses notably ByteFallback and no normalization.",Do,Q,Zo,ht,Xn=`If you want to change the <code>bos_token</code> or the <code>eos_token</code>, make sure to specify them when initializing the model, or
call <code>tokenizer.update_post_processor()</code> to make sure that the post-processing is correctly done (otherwise the
values of the first token and final token of an encoded sequence will not be correct). For more details, checkout
[post-processors] (<a href="https://huggingface.co/docs/tokenizers/api/post-processors" rel="nofollow">https://huggingface.co/docs/tokenizers/api/post-processors</a>) documentation.`,Vo,ft,Yn=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,Oo,gt,Be,Xo,K,Je,Yo,_t,Qn=`Retrieves sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> or <code>encode_plus</code> methods.`,Qo,E,Re,Ko,kt,Kn=`Create the token type IDs corresponding to the sequences passed. <a href="../glossary#token-type-ids">What are token type
IDs?</a>`,en,bt,ea="Should be overridden in a subclass if the model has a special way of building those.",tn,ee,Ge,on,vt,ta="Updates the underlying post processor with the current <code>bos_token</code> and <code>eos_token</code>.",nn,yt,De,ko,Ze,bo,P,Ve,an,Tt,oa=`The bare LLaMA Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,sn,Lt,na=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,rn,wt,aa="Transformer decoder consisting of <em>config.num_hidden_layers</em> layers. Each layer is a <code>LlamaDecoderLayer</code>",ln,N,Oe,dn,$t,sa='The <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaModel">LlamaModel</a> forward method, overrides the <code>__call__</code> special method.',cn,te,vo,Xe,yo,G,Ye,mn,H,Qe,pn,Mt,ra='The <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaForCausalLM">LlamaForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',un,oe,hn,ne,To,Ke,Lo,z,et,fn,xt,ia="The LLaMa Model transformer with a sequence classification head on top (linear layer).",gn,zt,la=`<a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaForSequenceClassification">LlamaForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-2) do.`,_n,Ct,da=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,kn,qt,ca=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,bn,Ft,ma=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,vn,B,tt,yn,Pt,pa='The <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaForSequenceClassification">LlamaForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Tn,ae,wo,Ht,$o;return $=new R({props:{title:"Llama2",local:"llama2",headingTag:"h1"}}),L=new R({props:{title:"Overview",local:"overview",headingTag:"h2"}}),me=new R({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),Z=new Co({props:{warning:!0,$$slots:{default:[va]},$$scope:{ctx:C}}}),he=new At({props:{code:"cHl0aG9uJTIwc3JjJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGbGxhbWElMkZjb252ZXJ0X2xsYW1hX3dlaWdodHNfdG9faGYucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLWlucHV0X2RpciUyMCUyRnBhdGglMkZ0byUyRmRvd25sb2FkZWQlMkZsbGFtYSUyRndlaWdodHMlMjAtLW1vZGVsX3NpemUlMjA3QiUyMC0tb3V0cHV0X2RpciUyMCUyRm91dHB1dCUyRnBhdGg=",highlighted:`python src/transformers/models/llama/convert_llama_weights_to_hf.py \\
    --input_dir /path/to/downloaded/llama/weights --model_size 7B --output_dir /output/path`,wrap:!1}}),ge=new At({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hRm9yQ2F1c2FsTE0lMkMlMjBMbGFtYVRva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMExsYW1hVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjIlMkZvdXRwdXQlMkZwYXRoJTIyKSUwQW1vZGVsJTIwJTNEJTIwTGxhbWFGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyJTJGb3V0cHV0JTJGcGF0aCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaForCausalLM, LlamaTokenizer

tokenizer = LlamaTokenizer.from_pretrained(<span class="hljs-string">&quot;/output/path&quot;</span>)
model = LlamaForCausalLM.from_pretrained(<span class="hljs-string">&quot;/output/path&quot;</span>)`,wrap:!1}}),be=new R({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Te=new ha({props:{pipeline:"text-generation"}}),we=new ha({props:{pipeline:"text-classification"}}),Pe=new R({props:{title:"LlamaConfig",local:"transformers.LlamaConfig",headingTag:"h2"}}),je=new q({props:{name:"class transformers.LlamaConfig",anchor:"transformers.LlamaConfig",parameters:[{name:"vocab_size",val:" = 32000"},{name:"hidden_size",val:" = 4096"},{name:"intermediate_size",val:" = 11008"},{name:"num_hidden_layers",val:" = 32"},{name:"num_attention_heads",val:" = 32"},{name:"num_key_value_heads",val:" = None"},{name:"hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 2048"},{name:"initializer_range",val:" = 0.02"},{name:"rms_norm_eps",val:" = 1e-06"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = None"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"pretraining_tp",val:" = 1"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 10000.0"},{name:"rope_scaling",val:" = None"},{name:"attention_bias",val:" = False"},{name:"attention_dropout",val:" = 0.0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlamaConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
Vocabulary size of the LLaMA model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaModel">LlamaModel</a>`,name:"vocab_size"},{anchor:"transformers.LlamaConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.LlamaConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 11008) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.LlamaConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"num_hidden_layers"},{anchor:"transformers.LlamaConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"num_attention_heads"},{anchor:"transformers.LlamaConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1 the model will use Multi Query Attention (MQA) otherwise GQA is used. When converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed by meanpooling all the original heads within that group. For more details checkout [this paper](https://arxiv.org/pdf/2305.13245.pdf). If it is not specified, will default to </code>num_attention_heads\`.`,name:"num_key_value_heads"},{anchor:"transformers.LlamaConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.LlamaConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that this model might ever be used with. Llama 1 supports up to 2048 tokens,
Llama 2 up to 4096, CodeLlama up to 16384.`,name:"max_position_embeddings"},{anchor:"transformers.LlamaConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.LlamaConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.LlamaConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.LlamaConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.LlamaConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.LlamaConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
End of stream token id.`,name:"eos_token_id"},{anchor:"transformers.LlamaConfig.pretraining_tp",description:`<strong>pretraining_tp</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Experimental feature. Tensor parallelism rank used during pretraining. Please refer to <a href="https://huggingface.co/docs/transformers/main/perf_train_gpu_many#tensor-parallelism" rel="nofollow">this
document</a> to understand more about it. This value is
necessary to ensure exact reproducibility of the pretraining results. Please refer to <a href="https://github.com/pytorch/pytorch/issues/76232" rel="nofollow">this
issue</a>.`,name:"pretraining_tp"},{anchor:"transformers.LlamaConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.LlamaConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.LlamaConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. Currently supports two scaling
strategies: linear and dynamic. Their scaling factor must be a float greater than 1. The expected format is
<code>{&quot;type&quot;: strategy name, &quot;factor&quot;: scaling factor}</code>. When using this flag, don&#x2019;t update
<code>max_position_embeddings</code> to the expected new maximum. See the following thread for more information on how
these scaling strategies behave:
<a href="https://www.reddit.com/r/LocalLLaMA/comments/14mrgpr/dynamically_scaled_rope_further_increases/" rel="nofollow">https://www.reddit.com/r/LocalLLaMA/comments/14mrgpr/dynamically_scaled_rope_further_increases/</a>. This is an
experimental feature, subject to breaking API changes in future versions.`,name:"rope_scaling"},{anchor:"transformers.LlamaConfig.attention_bias",description:`<strong>attention_bias</strong> (<code>bool</code>, defaults to <code>False</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in the query, key, value and output projection layers during self-attention.`,name:"attention_bias"},{anchor:"transformers.LlamaConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/configuration_llama.py#L32"}}),V=new qo({props:{anchor:"transformers.LlamaConfig.example",$$slots:{default:[ya]},$$scope:{ctx:C}}}),Ie=new R({props:{title:"LlamaTokenizer",local:"transformers.LlamaTokenizer",headingTag:"h2"}}),We=new q({props:{name:"class transformers.LlamaTokenizer",anchor:"transformers.LlamaTokenizer",parameters:[{name:"vocab_file",val:""},{name:"unk_token",val:" = '<unk>'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"pad_token",val:" = None"},{name:"sp_model_kwargs",val:": Optional = None"},{name:"add_bos_token",val:" = True"},{name:"add_eos_token",val:" = False"},{name:"clean_up_tokenization_spaces",val:" = False"},{name:"use_default_system_prompt",val:" = False"},{name:"spaces_between_special_tokens",val:" = False"},{name:"legacy",val:" = None"},{name:"add_prefix_space",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlamaTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.LlamaTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.LlamaTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.`,name:"bos_token"},{anchor:"transformers.LlamaTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.`,name:"eos_token"},{anchor:"transformers.LlamaTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>) &#x2014;
A special token used to make arrays of tokens the same size for batching purpose. Will then be ignored by
attention mechanisms or loss computation.`,name:"pad_token"},{anchor:"transformers.LlamaTokenizer.sp_model_kwargs",description:`<strong>sp_model_kwargs</strong> (<code>Dict[str, Any]</code>, <code>Optional</code>, <em>optional</em>) &#x2014;
Will be passed to the <code>SentencePieceProcessor.__init__()</code> method. The <a href="https://github.com/google/sentencepiece/tree/master/python" rel="nofollow">Python wrapper for
SentencePiece</a> can be used, among other things,
to set:</p>
<ul>
<li>
<p><code>enable_sampling</code>: Enable subword regularization.</p>
</li>
<li>
<p><code>nbest_size</code>: Sampling parameters for unigram. Invalid for BPE-Dropout.</p>
<ul>
<li><code>nbest_size = {0,1}</code>: No sampling is performed.</li>
<li><code>nbest_size &gt; 1</code>: samples from the nbest_size results.</li>
<li><code>nbest_size &lt; 0</code>: assuming that nbest_size is infinite and samples from the all hypothesis (lattice)
using forward-filtering-and-backward-sampling algorithm.</li>
</ul>
</li>
<li>
<p><code>alpha</code>: Smoothing parameter for unigram sampling, and dropout probability of merge operations for
BPE-dropout.</p>
</li>
</ul>`,name:"sp_model_kwargs"},{anchor:"transformers.LlamaTokenizer.add_bos_token",description:`<strong>add_bos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to add an <code>bos_token</code> at the start of sequences.`,name:"add_bos_token"},{anchor:"transformers.LlamaTokenizer.add_eos_token",description:`<strong>add_eos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add an <code>eos_token</code> at the end of sequences.`,name:"add_eos_token"},{anchor:"transformers.LlamaTokenizer.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to cleanup spaces after decoding, cleanup consists in removing potential artifacts like
extra spaces.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.LlamaTokenizer.use_default_system_prompt",description:`<strong>use_default_system_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the default system prompt for Llama should be used.`,name:"use_default_system_prompt"},{anchor:"transformers.LlamaTokenizer.spaces_between_special_tokens",description:`<strong>spaces_between_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add spaces between special tokens.`,name:"spaces_between_special_tokens"},{anchor:"transformers.LlamaTokenizer.legacy",description:`<strong>legacy</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the <code>legacy</code> behavior of the tokenizer should be used. Legacy is before the merge of #24622
and #25224 which includes fixes to properly handle tokens that appear after special tokens. A simple
example:</p>
<ul>
<li><code>legacy=True</code>:</li>
</ul>`,name:"legacy"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama.py#L55"}}),Ae=new q({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.LlamaTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama.py#L332"}}),He=new q({props:{name:"get_special_tokens_mask",anchor:"transformers.LlamaTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.LlamaTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.LlamaTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.LlamaTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama.py#L343",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Ue=new q({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.LlamaTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.LlamaTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids.`,name:"token_ids_0"},{anchor:"transformers.LlamaTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama.py#L380",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#token-type-ids">token type IDs</a> according to the given sequence(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),X=new qo({props:{anchor:"transformers.LlamaTokenizer.create_token_type_ids_from_sequences.example",$$slots:{default:[Ta]},$$scope:{ctx:C}}}),Se=new q({props:{name:"save_vocabulary",anchor:"transformers.LlamaTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:""},{name:"filename_prefix",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.LlamaTokenizer.save_vocabulary.save_directory",description:`<strong>save_directory</strong> (<code>str</code>) &#x2014;
The directory in which to save the vocabulary.`,name:"save_directory"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama.py#L305",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Paths to the files saved.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple(str)</code></p>
`}}),Ee=new R({props:{title:"LlamaTokenizerFast",local:"transformers.LlamaTokenizerFast",headingTag:"h2"}}),Ne=new q({props:{name:"class transformers.LlamaTokenizerFast",anchor:"transformers.LlamaTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"clean_up_tokenization_spaces",val:" = False"},{name:"unk_token",val:" = '<unk>'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"add_bos_token",val:" = True"},{name:"add_eos_token",val:" = False"},{name:"use_default_system_prompt",val:" = False"},{name:"add_prefix_space",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlamaTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a .model extension) that
contains the vocabulary necessary to instantiate a tokenizer.`,name:"vocab_file"},{anchor:"transformers.LlamaTokenizerFast.tokenizer_file",description:`<strong>tokenizer_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
<a href="https://github.com/huggingface/tokenizers" rel="nofollow">tokenizers</a> file (generally has a .json extension) that
contains everything needed to load the tokenizer.`,name:"tokenizer_file"},{anchor:"transformers.LlamaTokenizerFast.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to cleanup spaces after decoding, cleanup consists in removing potential artifacts like
extra spaces.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.LlamaTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.LlamaTokenizerFast.bos_token",description:`<strong>bos_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.`,name:"bos_token"},{anchor:"transformers.LlamaTokenizerFast.eos_token",description:`<strong>eos_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.`,name:"eos_token"},{anchor:"transformers.LlamaTokenizerFast.add_bos_token",description:`<strong>add_bos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to add an <code>bos_token</code> at the start of sequences.`,name:"add_bos_token"},{anchor:"transformers.LlamaTokenizerFast.add_eos_token",description:`<strong>add_eos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add an <code>eos_token</code> at the end of sequences.`,name:"add_eos_token"},{anchor:"transformers.LlamaTokenizerFast.use_default_system_prompt",description:`<strong>use_default_system_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the default system prompt for Llama should be used.`,name:"use_default_system_prompt"},{anchor:"transformers.LlamaTokenizerFast.add_prefix_space",description:`<strong>add_prefix_space</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the tokenizer should automatically add a prefix space`,name:"add_prefix_space"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama_fast.py#L49"}}),Q=new qo({props:{anchor:"transformers.LlamaTokenizerFast.example",$$slots:{default:[La]},$$scope:{ctx:C}}}),Be=new q({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.LlamaTokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama_fast.py#L273"}}),Je=new q({props:{name:"get_special_tokens_mask",anchor:"transformers.LlamaTokenizerFast.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.LlamaTokenizerFast.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids of the first sequence.`,name:"token_ids_0"},{anchor:"transformers.LlamaTokenizerFast.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
List of ids of the second sequence.`,name:"token_ids_1"},{anchor:"transformers.LlamaTokenizerFast.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tokenization_utils_base.py#L3828",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]</p>
`}}),Re=new q({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.LlamaTokenizerFast.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.LlamaTokenizerFast.create_token_type_ids_from_sequences.token_ids_0",description:"<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014; The first tokenized sequence.",name:"token_ids_0"},{anchor:"transformers.LlamaTokenizerFast.create_token_type_ids_from_sequences.token_ids_1",description:"<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014; The second tokenized sequence.",name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tokenization_utils_base.py#L3358",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The token type ids.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Ge=new q({props:{name:"update_post_processor",anchor:"transformers.LlamaTokenizerFast.update_post_processor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama_fast.py#L146"}}),De=new q({props:{name:"save_vocabulary",anchor:"transformers.LlamaTokenizerFast.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama_fast.py#L190"}}),Ze=new R({props:{title:"LlamaModel",local:"transformers.LlamaModel",headingTag:"h2"}}),Ve=new q({props:{name:"class transformers.LlamaModel",anchor:"transformers.LlamaModel",parameters:[{name:"config",val:": LlamaConfig"}],parametersDescription:[{anchor:"transformers.LlamaModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaConfig">LlamaConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.
config &#x2014; LlamaConfig`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/modeling_llama.py#L908"}}),Oe=new q({props:{name:"forward",anchor:"transformers.LlamaModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"cache_position",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.LlamaModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlamaModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.LlamaModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlamaModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlamaModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlamaModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlamaModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlamaModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlamaModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LlamaModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/modeling_llama.py#L941"}}),te=new Co({props:{$$slots:{default:[wa]},$$scope:{ctx:C}}}),Xe=new R({props:{title:"LlamaForCausalLM",local:"transformers.LlamaForCausalLM",headingTag:"h2"}}),Ye=new q({props:{name:"class transformers.LlamaForCausalLM",anchor:"transformers.LlamaForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/modeling_llama.py#L1130"}}),Qe=new q({props:{name:"forward",anchor:"transformers.LlamaForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"cache_position",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.LlamaForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlamaForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.LlamaForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlamaForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlamaForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlamaForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlamaForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlamaForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlamaForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LlamaForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/modeling_llama.py#L1160",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaConfig"
>LlamaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),oe=new Co({props:{$$slots:{default:[$a]},$$scope:{ctx:C}}}),ne=new qo({props:{anchor:"transformers.LlamaForCausalLM.forward.example",$$slots:{default:[Ma]},$$scope:{ctx:C}}}),Ke=new R({props:{title:"LlamaForSequenceClassification",local:"transformers.LlamaForSequenceClassification",headingTag:"h2"}}),et=new q({props:{name:"class transformers.LlamaForSequenceClassification",anchor:"transformers.LlamaForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.LlamaForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaConfig">LlamaConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/modeling_llama.py#L1354"}}),tt=new q({props:{name:"forward",anchor:"transformers.LlamaForSequenceClassification.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.LlamaForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlamaForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.LlamaForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlamaForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlamaForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlamaForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlamaForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlamaForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlamaForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LlamaForSequenceClassification.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.LlamaForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/modeling_llama.py#L1385"}}),ae=new Co({props:{$$slots:{default:[xa]},$$scope:{ctx:C}}}),{c(){d=i("meta"),v=n(),c=i("p"),b=n(),p($.$$.fragment),k=n(),p(L.$$.fragment),ie=n(),w=i("p"),w.innerHTML=D,Et=n(),le=i("p"),le.textContent=Ln,Nt=n(),de=i("p"),de.innerHTML=wn,Bt=n(),ce=i("p"),ce.innerHTML=$n,Jt=n(),p(me.$$.fragment),Rt=n(),p(Z.$$.fragment),Gt=n(),pe=i("p"),pe.textContent=Mn,Dt=n(),ue=i("ul"),ue.innerHTML=xn,Zt=n(),p(he.$$.fragment),Vt=n(),fe=i("ul"),fe.innerHTML=zn,Ot=n(),p(ge.$$.fragment),Xt=n(),_e=i("p"),_e.textContent=Cn,Yt=n(),ke=i("ul"),ke.innerHTML=qn,Qt=n(),p(be.$$.fragment),Kt=n(),ve=i("p"),ve.textContent=Fn,eo=n(),ye=i("ul"),ye.innerHTML=Pn,to=n(),p(Te.$$.fragment),oo=n(),Le=i("ul"),Le.innerHTML=jn,no=n(),p(we.$$.fragment),ao=n(),$e=i("ul"),$e.innerHTML=In,so=n(),Me=i("p"),Me.textContent=Wn,ro=n(),xe=i("ul"),xe.innerHTML=An,io=n(),ze=i("p"),ze.textContent=Hn,lo=n(),Ce=i("ul"),Ce.innerHTML=Un,co=n(),qe=i("p"),qe.textContent=Sn,mo=n(),Fe=i("ul"),Fe.innerHTML=En,po=n(),p(Pe.$$.fragment),uo=n(),W=i("div"),p(je.$$.fragment),Fo=n(),at=i("p"),at.innerHTML=Nn,Po=n(),st=i("p"),st.innerHTML=Bn,jo=n(),p(V.$$.fragment),ho=n(),p(Ie.$$.fragment),fo=n(),F=i("div"),p(We.$$.fragment),Io=n(),rt=i("p"),rt.textContent=Jn,Wo=n(),it=i("div"),p(Ae.$$.fragment),Ao=n(),O=i("div"),p(He.$$.fragment),Ho=n(),lt=i("p"),lt.innerHTML=Rn,Uo=n(),A=i("div"),p(Ue.$$.fragment),So=n(),dt=i("p"),dt.textContent=Gn,Eo=n(),p(X.$$.fragment),No=n(),ct=i("p"),ct.textContent=Dn,Bo=n(),Y=i("div"),p(Se.$$.fragment),Jo=n(),mt=i("p"),mt.textContent=Zn,go=n(),p(Ee.$$.fragment),_o=n(),y=i("div"),p(Ne.$$.fragment),Ro=n(),pt=i("p"),pt.textContent=Vn,Go=n(),ut=i("p"),ut.textContent=On,Do=n(),p(Q.$$.fragment),Zo=n(),ht=i("p"),ht.innerHTML=Xn,Vo=n(),ft=i("p"),ft.innerHTML=Yn,Oo=n(),gt=i("div"),p(Be.$$.fragment),Xo=n(),K=i("div"),p(Je.$$.fragment),Yo=n(),_t=i("p"),_t.innerHTML=Qn,Qo=n(),E=i("div"),p(Re.$$.fragment),Ko=n(),kt=i("p"),kt.innerHTML=Kn,en=n(),bt=i("p"),bt.textContent=ea,tn=n(),ee=i("div"),p(Ge.$$.fragment),on=n(),vt=i("p"),vt.innerHTML=ta,nn=n(),yt=i("div"),p(De.$$.fragment),ko=n(),p(Ze.$$.fragment),bo=n(),P=i("div"),p(Ve.$$.fragment),an=n(),Tt=i("p"),Tt.innerHTML=oa,sn=n(),Lt=i("p"),Lt.innerHTML=na,rn=n(),wt=i("p"),wt.innerHTML=aa,ln=n(),N=i("div"),p(Oe.$$.fragment),dn=n(),$t=i("p"),$t.innerHTML=sa,cn=n(),p(te.$$.fragment),vo=n(),p(Xe.$$.fragment),yo=n(),G=i("div"),p(Ye.$$.fragment),mn=n(),H=i("div"),p(Qe.$$.fragment),pn=n(),Mt=i("p"),Mt.innerHTML=ra,un=n(),p(oe.$$.fragment),hn=n(),p(ne.$$.fragment),To=n(),p(Ke.$$.fragment),Lo=n(),z=i("div"),p(et.$$.fragment),fn=n(),xt=i("p"),xt.textContent=ia,gn=n(),zt=i("p"),zt.innerHTML=la,_n=n(),Ct=i("p"),Ct.innerHTML=da,kn=n(),qt=i("p"),qt.innerHTML=ca,bn=n(),Ft=i("p"),Ft.innerHTML=ma,vn=n(),B=i("div"),p(tt.$$.fragment),yn=n(),Pt=i("p"),Pt.innerHTML=pa,Tn=n(),p(ae.$$.fragment),wo=n(),Ht=i("p"),this.h()},l(e){const t=ba("svelte-u9bgzb",document.head);d=l(t,"META",{name:!0,content:!0}),t.forEach(o),v=a(e),c=l(e,"P",{}),M(c).forEach(o),b=a(e),u($.$$.fragment,e),k=a(e),u(L.$$.fragment,e),ie=a(e),w=l(e,"P",{"data-svelte-h":!0}),m(w)!=="svelte-xm2zag"&&(w.innerHTML=D),Et=a(e),le=l(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-vfdo9a"&&(le.textContent=Ln),Nt=a(e),de=l(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-1wo3ztj"&&(de.innerHTML=wn),Bt=a(e),ce=l(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-19rh1s"&&(ce.innerHTML=$n),Jt=a(e),u(me.$$.fragment,e),Rt=a(e),u(Z.$$.fragment,e),Gt=a(e),pe=l(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-axv494"&&(pe.textContent=Mn),Dt=a(e),ue=l(e,"UL",{"data-svelte-h":!0}),m(ue)!=="svelte-tepalw"&&(ue.innerHTML=xn),Zt=a(e),u(he.$$.fragment,e),Vt=a(e),fe=l(e,"UL",{"data-svelte-h":!0}),m(fe)!=="svelte-yjbkch"&&(fe.innerHTML=zn),Ot=a(e),u(ge.$$.fragment,e),Xt=a(e),_e=l(e,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-199e5ee"&&(_e.textContent=Cn),Yt=a(e),ke=l(e,"UL",{"data-svelte-h":!0}),m(ke)!=="svelte-eq5y0y"&&(ke.innerHTML=qn),Qt=a(e),u(be.$$.fragment,e),Kt=a(e),ve=l(e,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-1l10g8k"&&(ve.textContent=Fn),eo=a(e),ye=l(e,"UL",{"data-svelte-h":!0}),m(ye)!=="svelte-189jef5"&&(ye.innerHTML=Pn),to=a(e),u(Te.$$.fragment,e),oo=a(e),Le=l(e,"UL",{"data-svelte-h":!0}),m(Le)!=="svelte-1txpvb1"&&(Le.innerHTML=jn),no=a(e),u(we.$$.fragment,e),ao=a(e),$e=l(e,"UL",{"data-svelte-h":!0}),m($e)!=="svelte-13c8j1g"&&($e.innerHTML=In),so=a(e),Me=l(e,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-liq2q7"&&(Me.textContent=Wn),ro=a(e),xe=l(e,"UL",{"data-svelte-h":!0}),m(xe)!=="svelte-1xuj4g0"&&(xe.innerHTML=An),io=a(e),ze=l(e,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-1wntqpp"&&(ze.textContent=Hn),lo=a(e),Ce=l(e,"UL",{"data-svelte-h":!0}),m(Ce)!=="svelte-gxsehz"&&(Ce.innerHTML=Un),co=a(e),qe=l(e,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-lk14e4"&&(qe.textContent=Sn),mo=a(e),Fe=l(e,"UL",{"data-svelte-h":!0}),m(Fe)!=="svelte-1f88qgk"&&(Fe.innerHTML=En),po=a(e),u(Pe.$$.fragment,e),uo=a(e),W=l(e,"DIV",{class:!0});var U=M(W);u(je.$$.fragment,U),Fo=a(U),at=l(U,"P",{"data-svelte-h":!0}),m(at)!=="svelte-20uyn0"&&(at.innerHTML=Nn),Po=a(U),st=l(U,"P",{"data-svelte-h":!0}),m(st)!=="svelte-o55m63"&&(st.innerHTML=Bn),jo=a(U),u(V.$$.fragment,U),U.forEach(o),ho=a(e),u(Ie.$$.fragment,e),fo=a(e),F=l(e,"DIV",{class:!0});var j=M(F);u(We.$$.fragment,j),Io=a(j),rt=l(j,"P",{"data-svelte-h":!0}),m(rt)!=="svelte-qfiu5a"&&(rt.textContent=Jn),Wo=a(j),it=l(j,"DIV",{class:!0});var Ut=M(it);u(Ae.$$.fragment,Ut),Ut.forEach(o),Ao=a(j),O=l(j,"DIV",{class:!0});var ot=M(O);u(He.$$.fragment,ot),Ho=a(ot),lt=l(ot,"P",{"data-svelte-h":!0}),m(lt)!=="svelte-1f4f5kp"&&(lt.innerHTML=Rn),ot.forEach(o),Uo=a(j),A=l(j,"DIV",{class:!0});var S=M(A);u(Ue.$$.fragment,S),So=a(S),dt=l(S,"P",{"data-svelte-h":!0}),m(dt)!=="svelte-13bfd60"&&(dt.textContent=Gn),Eo=a(S),u(X.$$.fragment,S),No=a(S),ct=l(S,"P",{"data-svelte-h":!0}),m(ct)!=="svelte-wtrslu"&&(ct.textContent=Dn),S.forEach(o),Bo=a(j),Y=l(j,"DIV",{class:!0});var nt=M(Y);u(Se.$$.fragment,nt),Jo=a(nt),mt=l(nt,"P",{"data-svelte-h":!0}),m(mt)!=="svelte-1slb66l"&&(mt.textContent=Zn),nt.forEach(o),j.forEach(o),go=a(e),u(Ee.$$.fragment,e),_o=a(e),y=l(e,"DIV",{class:!0});var T=M(y);u(Ne.$$.fragment,T),Ro=a(T),pt=l(T,"P",{"data-svelte-h":!0}),m(pt)!=="svelte-15tdcz8"&&(pt.textContent=Vn),Go=a(T),ut=l(T,"P",{"data-svelte-h":!0}),m(ut)!=="svelte-llhmpa"&&(ut.textContent=On),Do=a(T),u(Q.$$.fragment,T),Zo=a(T),ht=l(T,"P",{"data-svelte-h":!0}),m(ht)!=="svelte-cnb6q1"&&(ht.innerHTML=Xn),Vo=a(T),ft=l(T,"P",{"data-svelte-h":!0}),m(ft)!=="svelte-fh0aq"&&(ft.innerHTML=Yn),Oo=a(T),gt=l(T,"DIV",{class:!0});var St=M(gt);u(Be.$$.fragment,St),St.forEach(o),Xo=a(T),K=l(T,"DIV",{class:!0});var Mo=M(K);u(Je.$$.fragment,Mo),Yo=a(Mo),_t=l(Mo,"P",{"data-svelte-h":!0}),m(_t)!=="svelte-1wmjg8a"&&(_t.innerHTML=Qn),Mo.forEach(o),Qo=a(T),E=l(T,"DIV",{class:!0});var jt=M(E);u(Re.$$.fragment,jt),Ko=a(jt),kt=l(jt,"P",{"data-svelte-h":!0}),m(kt)!=="svelte-zj1vf1"&&(kt.innerHTML=Kn),en=a(jt),bt=l(jt,"P",{"data-svelte-h":!0}),m(bt)!=="svelte-9vptpw"&&(bt.textContent=ea),jt.forEach(o),tn=a(T),ee=l(T,"DIV",{class:!0});var xo=M(ee);u(Ge.$$.fragment,xo),on=a(xo),vt=l(xo,"P",{"data-svelte-h":!0}),m(vt)!=="svelte-nfci2w"&&(vt.innerHTML=ta),xo.forEach(o),nn=a(T),yt=l(T,"DIV",{class:!0});var ua=M(yt);u(De.$$.fragment,ua),ua.forEach(o),T.forEach(o),ko=a(e),u(Ze.$$.fragment,e),bo=a(e),P=l(e,"DIV",{class:!0});var J=M(P);u(Ve.$$.fragment,J),an=a(J),Tt=l(J,"P",{"data-svelte-h":!0}),m(Tt)!=="svelte-4n5ccz"&&(Tt.innerHTML=oa),sn=a(J),Lt=l(J,"P",{"data-svelte-h":!0}),m(Lt)!=="svelte-hswkmf"&&(Lt.innerHTML=na),rn=a(J),wt=l(J,"P",{"data-svelte-h":!0}),m(wt)!=="svelte-eom0yk"&&(wt.innerHTML=aa),ln=a(J),N=l(J,"DIV",{class:!0});var It=M(N);u(Oe.$$.fragment,It),dn=a(It),$t=l(It,"P",{"data-svelte-h":!0}),m($t)!=="svelte-1wmin46"&&($t.innerHTML=sa),cn=a(It),u(te.$$.fragment,It),It.forEach(o),J.forEach(o),vo=a(e),u(Xe.$$.fragment,e),yo=a(e),G=l(e,"DIV",{class:!0});var zo=M(G);u(Ye.$$.fragment,zo),mn=a(zo),H=l(zo,"DIV",{class:!0});var se=M(H);u(Qe.$$.fragment,se),pn=a(se),Mt=l(se,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-1jc6dk6"&&(Mt.innerHTML=ra),un=a(se),u(oe.$$.fragment,se),hn=a(se),u(ne.$$.fragment,se),se.forEach(o),zo.forEach(o),To=a(e),u(Ke.$$.fragment,e),Lo=a(e),z=l(e,"DIV",{class:!0});var I=M(z);u(et.$$.fragment,I),fn=a(I),xt=l(I,"P",{"data-svelte-h":!0}),m(xt)!=="svelte-62must"&&(xt.textContent=ia),gn=a(I),zt=l(I,"P",{"data-svelte-h":!0}),m(zt)!=="svelte-jn6jrd"&&(zt.innerHTML=la),_n=a(I),Ct=l(I,"P",{"data-svelte-h":!0}),m(Ct)!=="svelte-10ugs3m"&&(Ct.innerHTML=da),kn=a(I),qt=l(I,"P",{"data-svelte-h":!0}),m(qt)!=="svelte-6pahdo"&&(qt.innerHTML=ca),bn=a(I),Ft=l(I,"P",{"data-svelte-h":!0}),m(Ft)!=="svelte-hswkmf"&&(Ft.innerHTML=ma),vn=a(I),B=l(I,"DIV",{class:!0});var Wt=M(B);u(tt.$$.fragment,Wt),yn=a(Wt),Pt=l(Wt,"P",{"data-svelte-h":!0}),m(Pt)!=="svelte-151dzto"&&(Pt.innerHTML=pa),Tn=a(Wt),u(ae.$$.fragment,Wt),Wt.forEach(o),I.forEach(o),wo=a(e),Ht=l(e,"P",{}),M(Ht).forEach(o),this.h()},h(){x(d,"name","hf:doc:metadata"),x(d,"content",Ca),x(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){s(document.head,d),r(e,v,t),r(e,c,t),r(e,b,t),h($,e,t),r(e,k,t),h(L,e,t),r(e,ie,t),r(e,w,t),r(e,Et,t),r(e,le,t),r(e,Nt,t),r(e,de,t),r(e,Bt,t),r(e,ce,t),r(e,Jt,t),h(me,e,t),r(e,Rt,t),h(Z,e,t),r(e,Gt,t),r(e,pe,t),r(e,Dt,t),r(e,ue,t),r(e,Zt,t),h(he,e,t),r(e,Vt,t),r(e,fe,t),r(e,Ot,t),h(ge,e,t),r(e,Xt,t),r(e,_e,t),r(e,Yt,t),r(e,ke,t),r(e,Qt,t),h(be,e,t),r(e,Kt,t),r(e,ve,t),r(e,eo,t),r(e,ye,t),r(e,to,t),h(Te,e,t),r(e,oo,t),r(e,Le,t),r(e,no,t),h(we,e,t),r(e,ao,t),r(e,$e,t),r(e,so,t),r(e,Me,t),r(e,ro,t),r(e,xe,t),r(e,io,t),r(e,ze,t),r(e,lo,t),r(e,Ce,t),r(e,co,t),r(e,qe,t),r(e,mo,t),r(e,Fe,t),r(e,po,t),h(Pe,e,t),r(e,uo,t),r(e,W,t),h(je,W,null),s(W,Fo),s(W,at),s(W,Po),s(W,st),s(W,jo),h(V,W,null),r(e,ho,t),h(Ie,e,t),r(e,fo,t),r(e,F,t),h(We,F,null),s(F,Io),s(F,rt),s(F,Wo),s(F,it),h(Ae,it,null),s(F,Ao),s(F,O),h(He,O,null),s(O,Ho),s(O,lt),s(F,Uo),s(F,A),h(Ue,A,null),s(A,So),s(A,dt),s(A,Eo),h(X,A,null),s(A,No),s(A,ct),s(F,Bo),s(F,Y),h(Se,Y,null),s(Y,Jo),s(Y,mt),r(e,go,t),h(Ee,e,t),r(e,_o,t),r(e,y,t),h(Ne,y,null),s(y,Ro),s(y,pt),s(y,Go),s(y,ut),s(y,Do),h(Q,y,null),s(y,Zo),s(y,ht),s(y,Vo),s(y,ft),s(y,Oo),s(y,gt),h(Be,gt,null),s(y,Xo),s(y,K),h(Je,K,null),s(K,Yo),s(K,_t),s(y,Qo),s(y,E),h(Re,E,null),s(E,Ko),s(E,kt),s(E,en),s(E,bt),s(y,tn),s(y,ee),h(Ge,ee,null),s(ee,on),s(ee,vt),s(y,nn),s(y,yt),h(De,yt,null),r(e,ko,t),h(Ze,e,t),r(e,bo,t),r(e,P,t),h(Ve,P,null),s(P,an),s(P,Tt),s(P,sn),s(P,Lt),s(P,rn),s(P,wt),s(P,ln),s(P,N),h(Oe,N,null),s(N,dn),s(N,$t),s(N,cn),h(te,N,null),r(e,vo,t),h(Xe,e,t),r(e,yo,t),r(e,G,t),h(Ye,G,null),s(G,mn),s(G,H),h(Qe,H,null),s(H,pn),s(H,Mt),s(H,un),h(oe,H,null),s(H,hn),h(ne,H,null),r(e,To,t),h(Ke,e,t),r(e,Lo,t),r(e,z,t),h(et,z,null),s(z,fn),s(z,xt),s(z,gn),s(z,zt),s(z,_n),s(z,Ct),s(z,kn),s(z,qt),s(z,bn),s(z,Ft),s(z,vn),s(z,B),h(tt,B,null),s(B,yn),s(B,Pt),s(B,Tn),h(ae,B,null),r(e,wo,t),r(e,Ht,t),$o=!0},p(e,[t]){const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),Z.$set(U);const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),V.$set(j);const Ut={};t&2&&(Ut.$$scope={dirty:t,ctx:e}),X.$set(Ut);const ot={};t&2&&(ot.$$scope={dirty:t,ctx:e}),Q.$set(ot);const S={};t&2&&(S.$$scope={dirty:t,ctx:e}),te.$set(S);const nt={};t&2&&(nt.$$scope={dirty:t,ctx:e}),oe.$set(nt);const T={};t&2&&(T.$$scope={dirty:t,ctx:e}),ne.$set(T);const St={};t&2&&(St.$$scope={dirty:t,ctx:e}),ae.$set(St)},i(e){$o||(f($.$$.fragment,e),f(L.$$.fragment,e),f(me.$$.fragment,e),f(Z.$$.fragment,e),f(he.$$.fragment,e),f(ge.$$.fragment,e),f(be.$$.fragment,e),f(Te.$$.fragment,e),f(we.$$.fragment,e),f(Pe.$$.fragment,e),f(je.$$.fragment,e),f(V.$$.fragment,e),f(Ie.$$.fragment,e),f(We.$$.fragment,e),f(Ae.$$.fragment,e),f(He.$$.fragment,e),f(Ue.$$.fragment,e),f(X.$$.fragment,e),f(Se.$$.fragment,e),f(Ee.$$.fragment,e),f(Ne.$$.fragment,e),f(Q.$$.fragment,e),f(Be.$$.fragment,e),f(Je.$$.fragment,e),f(Re.$$.fragment,e),f(Ge.$$.fragment,e),f(De.$$.fragment,e),f(Ze.$$.fragment,e),f(Ve.$$.fragment,e),f(Oe.$$.fragment,e),f(te.$$.fragment,e),f(Xe.$$.fragment,e),f(Ye.$$.fragment,e),f(Qe.$$.fragment,e),f(oe.$$.fragment,e),f(ne.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(ae.$$.fragment,e),$o=!0)},o(e){g($.$$.fragment,e),g(L.$$.fragment,e),g(me.$$.fragment,e),g(Z.$$.fragment,e),g(he.$$.fragment,e),g(ge.$$.fragment,e),g(be.$$.fragment,e),g(Te.$$.fragment,e),g(we.$$.fragment,e),g(Pe.$$.fragment,e),g(je.$$.fragment,e),g(V.$$.fragment,e),g(Ie.$$.fragment,e),g(We.$$.fragment,e),g(Ae.$$.fragment,e),g(He.$$.fragment,e),g(Ue.$$.fragment,e),g(X.$$.fragment,e),g(Se.$$.fragment,e),g(Ee.$$.fragment,e),g(Ne.$$.fragment,e),g(Q.$$.fragment,e),g(Be.$$.fragment,e),g(Je.$$.fragment,e),g(Re.$$.fragment,e),g(Ge.$$.fragment,e),g(De.$$.fragment,e),g(Ze.$$.fragment,e),g(Ve.$$.fragment,e),g(Oe.$$.fragment,e),g(te.$$.fragment,e),g(Xe.$$.fragment,e),g(Ye.$$.fragment,e),g(Qe.$$.fragment,e),g(oe.$$.fragment,e),g(ne.$$.fragment,e),g(Ke.$$.fragment,e),g(et.$$.fragment,e),g(tt.$$.fragment,e),g(ae.$$.fragment,e),$o=!1},d(e){e&&(o(v),o(c),o(b),o(k),o(ie),o(w),o(Et),o(le),o(Nt),o(de),o(Bt),o(ce),o(Jt),o(Rt),o(Gt),o(pe),o(Dt),o(ue),o(Zt),o(Vt),o(fe),o(Ot),o(Xt),o(_e),o(Yt),o(ke),o(Qt),o(Kt),o(ve),o(eo),o(ye),o(to),o(oo),o(Le),o(no),o(ao),o($e),o(so),o(Me),o(ro),o(xe),o(io),o(ze),o(lo),o(Ce),o(co),o(qe),o(mo),o(Fe),o(po),o(uo),o(W),o(ho),o(fo),o(F),o(go),o(_o),o(y),o(ko),o(bo),o(P),o(vo),o(yo),o(G),o(To),o(Lo),o(z),o(wo),o(Ht)),o(d),_($,e),_(L,e),_(me,e),_(Z,e),_(he,e),_(ge,e),_(be,e),_(Te,e),_(we,e),_(Pe,e),_(je),_(V),_(Ie,e),_(We),_(Ae),_(He),_(Ue),_(X),_(Se),_(Ee,e),_(Ne),_(Q),_(Be),_(Je),_(Re),_(Ge),_(De),_(Ze,e),_(Ve),_(Oe),_(te),_(Xe,e),_(Ye),_(Qe),_(oe),_(ne),_(Ke,e),_(et),_(tt),_(ae)}}}const Ca='{"title":"Llama2","local":"llama2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"LlamaConfig","local":"transformers.LlamaConfig","sections":[],"depth":2},{"title":"LlamaTokenizer","local":"transformers.LlamaTokenizer","sections":[],"depth":2},{"title":"LlamaTokenizerFast","local":"transformers.LlamaTokenizerFast","sections":[],"depth":2},{"title":"LlamaModel","local":"transformers.LlamaModel","sections":[],"depth":2},{"title":"LlamaForCausalLM","local":"transformers.LlamaForCausalLM","sections":[],"depth":2},{"title":"LlamaForSequenceClassification","local":"transformers.LlamaForSequenceClassification","sections":[],"depth":2}],"depth":1}';function qa(C){return ga(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sa extends _a{constructor(d){super(),ka(this,d,qa,za,fa,{})}}export{Sa as component};
