import{s as ga,o as Ja,n as Hs}from"../chunks/scheduler.9991993c.js";import{S as ba,i as wa,g as m,s as n,r as M,A as Ua,h as o,f as a,c as p,j as ja,u as d,x as f,k as ya,y as Ta,a as l,v as h,d as j,t as y,w as u}from"../chunks/index.7fc9a5e7.js";import{T as Ht}from"../chunks/Tip.9de92fc6.js";import{Y as $a}from"../chunks/Youtube.7934cf81.js";import{C as T}from"../chunks/CodeBlock.e11cba92.js";import{D as _a}from"../chunks/DocNotebookDropdown.a0cb4c0f.js";import{F as ua,M as fa}from"../chunks/Markdown.87f31c7e.js";import{H as Bs}from"../chunks/Heading.e3de321f.js";function Ca(v){let e,J="本教程中展示的任务受以下模型架构的支持：",c,g,w='<a href="../model_doc/data2vec-audio">Data2VecAudio</a>, <a href="../model_doc/hubert">Hubert</a>, <a href="../model_doc/mctct">M-CTC-T</a>, <a href="../model_doc/sew">SEW</a>, <a href="../model_doc/sew-d">SEW-D</a>, <a href="../model_doc/unispeech">UniSpeech</a>, <a href="../model_doc/unispeech-sat">UniSpeechSat</a>, <a href="../model_doc/wav2vec2">Wav2Vec2</a>, <a href="../model_doc/wav2vec2-bert">Wav2Vec2-BERT</a>, <a href="../model_doc/wav2vec2-conformer">Wav2Vec2-Conformer</a>, <a href="../model_doc/wavlm">WavLM</a>';return{c(){e=m("p"),e.textContent=J,c=n(),g=m("p"),g.innerHTML=w},l(b){e=o(b,"P",{"data-svelte-h":!0}),f(e)!=="svelte-1npsmzj"&&(e.textContent=J),c=p(b),g=o(b,"P",{"data-svelte-h":!0}),f(g)!=="svelte-qabixr"&&(g.innerHTML=w)},m(b,I){l(b,e,I),l(b,c,I),l(b,g,I)},p:Hs,d(b){b&&(a(e),a(c),a(g))}}}function Ia(v){let e,J='如果您不熟悉使用<code>Trainer</code>微调模型，请查看这里的基本教程<a href="../training#train-with-pytorch-trainer">here</a>！';return{c(){e=m("p"),e.innerHTML=J},l(c){e=o(c,"P",{"data-svelte-h":!0}),f(e)!=="svelte-bisjpu"&&(e.innerHTML=J)},m(c,g){l(c,e,g)},p:Hs,d(c){c&&a(e)}}}function va(v){let e,J,c,g=`现在您已经准备好开始训练您的模型了！使用 <code>AutoModelForCTC</code> 加载 Wav2Vec2。
使用 <code>ctc_loss_reduction</code> 参数指定要应用的减少方式。通常最好使用平均值而不是默认的求和：`,w,b,I,Z,R="此时，只剩下 3 个步骤：",k,$,X=`<li>在 <code>TrainingArguments</code> 中定义您的训练参数。唯一必需的参数是 <code>output_dir</code>，用于指定保存模型的位置。
您可以通过设置 <code>push_to_hub=True</code> 将此模型推送到 Hub（您需要登录到 Hugging Face 才能上传您的模型）。
在每个 epoch 结束时，<code>Trainer</code> 将评估 WER 并保存训练检查点。</li> <li>将训练参数与模型、数据集、分词器、数据整理器和 <code>compute_metrics</code> 函数一起传递给 <code>Trainer</code>。</li> <li>调用 <code>train()</code> 来微调您的模型。</li>`,W,_,G,i,C="训练完成后，使用 <code>push_to_hub()</code> 方法将您的模型分享到 Hub，方便大家使用您的模型：",N,B,x;return e=new Ht({props:{$$slots:{default:[Ia]},$$scope:{ctx:v}}}),b=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNUQyUyQyUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRndhdjJ2ZWMyLWJhc2UlMjIlMkMlMEElMjAlMjAlMjAlMjBjdGNfbG9zc19yZWR1Y3Rpb24lM0QlMjJtZWFuJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGFkX3Rva2VuX2lkJTNEcHJvY2Vzc29yLnRva2VuaXplci5wYWRfdG9rZW5faWQlMkM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCTC, TrainingArguments, Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/wav2vec2-base&quot;</span>,
<span class="hljs-meta">... </span>    ctc_loss_reduction=<span class="hljs-string">&quot;mean&quot;</span>,
<span class="hljs-meta">... </span>    pad_token_id=processor.tokenizer.pad_token_id,
)`,wrap:!1}}),_=new T({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjJteV9hd2Vzb21lX2Fzcl9taW5kX21vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDIlMkMlMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNEMWUtNSUyQyUwQSUyMCUyMCUyMCUyMHdhcm11cF9zdGVwcyUzRDUwMCUyQyUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDIwMDAlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9jaGVja3BvaW50aW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGZwMTYlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZ3JvdXBfYnlfbGVuZ3RoJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9zdGVwcyUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Jlc3RfbW9kZWxfYXRfZW5kJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1ldHJpY19mb3JfYmVzdF9tb2RlbCUzRCUyMndlciUyMiUyQyUwQSUyMCUyMCUyMCUyMGdyZWF0ZXJfaXNfYmV0dGVyJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBwdXNoX3RvX2h1YiUzRFRydWUlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGVuY29kZWRfbWluZHMlNUIlMjJ0cmFpbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRGVuY29kZWRfbWluZHMlNUIlMjJ0ZXN0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(
<span class="hljs-meta">... </span>    output_dir=<span class="hljs-string">&quot;my_awesome_asr_mind_model&quot;</span>,
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>    gradient_accumulation_steps=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">1e-5</span>,
<span class="hljs-meta">... </span>    warmup_steps=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>    max_steps=<span class="hljs-number">2000</span>,
<span class="hljs-meta">... </span>    gradient_checkpointing=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    fp16=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    group_by_length=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    eval_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
<span class="hljs-meta">... </span>    per_device_eval_batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">1000</span>,
<span class="hljs-meta">... </span>    eval_steps=<span class="hljs-number">1000</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">25</span>,
<span class="hljs-meta">... </span>    load_best_model_at_end=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    metric_for_best_model=<span class="hljs-string">&quot;wer&quot;</span>,
<span class="hljs-meta">... </span>    greater_is_better=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    train_dataset=encoded_minds[<span class="hljs-string">&quot;train&quot;</span>],
<span class="hljs-meta">... </span>    eval_dataset=encoded_minds[<span class="hljs-string">&quot;test&quot;</span>],
<span class="hljs-meta">... </span>    tokenizer=processor,
<span class="hljs-meta">... </span>    data_collator=data_collator,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()`,wrap:!1}}),B=new T({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),{c(){M(e.$$.fragment),J=n(),c=m("p"),c.innerHTML=g,w=n(),M(b.$$.fragment),I=n(),Z=m("p"),Z.textContent=R,k=n(),$=m("ol"),$.innerHTML=X,W=n(),M(_.$$.fragment),G=n(),i=m("p"),i.innerHTML=C,N=n(),M(B.$$.fragment)},l(r){d(e.$$.fragment,r),J=p(r),c=o(r,"P",{"data-svelte-h":!0}),f(c)!=="svelte-1i9mog3"&&(c.innerHTML=g),w=p(r),d(b.$$.fragment,r),I=p(r),Z=o(r,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-1vzgb2k"&&(Z.textContent=R),k=p(r),$=o(r,"OL",{"data-svelte-h":!0}),f($)!=="svelte-o2regg"&&($.innerHTML=X),W=p(r),d(_.$$.fragment,r),G=p(r),i=o(r,"P",{"data-svelte-h":!0}),f(i)!=="svelte-10tsnqb"&&(i.innerHTML=C),N=p(r),d(B.$$.fragment,r)},m(r,U){h(e,r,U),l(r,J,U),l(r,c,U),l(r,w,U),h(b,r,U),l(r,I,U),l(r,Z,U),l(r,k,U),l(r,$,U),l(r,W,U),h(_,r,U),l(r,G,U),l(r,i,U),l(r,N,U),h(B,r,U),x=!0},p(r,U){const Xs={};U&2&&(Xs.$$scope={dirty:U,ctx:r}),e.$set(Xs)},i(r){x||(j(e.$$.fragment,r),j(b.$$.fragment,r),j(_.$$.fragment,r),j(B.$$.fragment,r),x=!0)},o(r){y(e.$$.fragment,r),y(b.$$.fragment,r),y(_.$$.fragment,r),y(B.$$.fragment,r),x=!1},d(r){r&&(a(J),a(c),a(w),a(I),a(Z),a(k),a($),a(W),a(G),a(i),a(N)),u(e,r),u(b,r),u(_,r),u(B,r)}}}function Ra(v){let e,J;return e=new fa({props:{$$slots:{default:[va]},$$scope:{ctx:v}}}),{c(){M(e.$$.fragment)},l(c){d(e.$$.fragment,c)},m(c,g){h(e,c,g),J=!0},p(c,g){const w={};g&2&&(w.$$scope={dirty:g,ctx:c}),e.$set(w)},i(c){J||(j(e.$$.fragment,c),J=!0)},o(c){y(e.$$.fragment,c),J=!1},d(c){u(e,c)}}}function Za(v){let e,J=`要深入了解如何微调模型进行自动语音识别，
请查看这篇博客<a href="https://huggingface.co/blog/fine-tune-wav2vec2-english" rel="nofollow">文章</a>以了解英语 ASR，
还可以参阅<a href="https://huggingface.co/blog/fine-tune-xlsr-wav2vec2" rel="nofollow">这篇文章</a>以了解多语言 ASR。`;return{c(){e=m("p"),e.innerHTML=J},l(c){e=o(c,"P",{"data-svelte-h":!0}),f(e)!=="svelte-1wfwd7q"&&(e.innerHTML=J)},m(c,g){l(c,e,g)},p:Hs,d(c){c&&a(e)}}}function ka(v){let e,J="转录结果还不错，但可以更好！尝试用更多示例微调您的模型，以获得更好的结果！";return{c(){e=m("p"),e.textContent=J},l(c){e=o(c,"P",{"data-svelte-h":!0}),f(e)!=="svelte-1bd4l8u"&&(e.textContent=J)},m(c,g){l(c,e,g)},p:Hs,d(c){c&&a(e)}}}function Wa(v){let e,J="加载一个处理器来预处理音频文件和转录，并将 <code>input</code> 返回为 PyTorch 张量：",c,g,w,b,I="将您的输入传递给模型并返回 logits：",Z,R,k,$,X="获取具有最高概率的预测 <code>input_ids</code>，并使用处理器将预测的 <code>input_ids</code> 解码回文本：",W,_,G;return g=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJzdGV2aGxpdSUyRm15X2F3ZXNvbWVfYXNyX21pbmRfbW9kZWwlMjIpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;stevhliu/my_awesome_asr_mind_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),R=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNUQyUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJzdGV2aGxpdSUyRm15X2F3ZXNvbWVfYXNyX21pbmRfbW9kZWwlMjIpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCTC

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(<span class="hljs-string">&quot;stevhliu/my_awesome_asr_mind_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits`,wrap:!1}}),_=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFwcmVkaWN0ZWRfaWRzJTIwJTNEJTIwdG9yY2guYXJnbWF4KGxvZ2l0cyUyQyUyMGRpbSUzRC0xKSUwQXRyYW5zY3JpcHRpb24lMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKHByZWRpY3RlZF9pZHMpJTBBdHJhbnNjcmlwdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription
[<span class="hljs-string">&#x27;I WOUL LIKE O SET UP JOINT ACOUNT WTH Y PARTNER&#x27;</span>]`,wrap:!1}}),{c(){e=m("p"),e.innerHTML=J,c=n(),M(g.$$.fragment),w=n(),b=m("p"),b.textContent=I,Z=n(),M(R.$$.fragment),k=n(),$=m("p"),$.innerHTML=X,W=n(),M(_.$$.fragment)},l(i){e=o(i,"P",{"data-svelte-h":!0}),f(e)!=="svelte-edj5mp"&&(e.innerHTML=J),c=p(i),d(g.$$.fragment,i),w=p(i),b=o(i,"P",{"data-svelte-h":!0}),f(b)!=="svelte-yh2snz"&&(b.textContent=I),Z=p(i),d(R.$$.fragment,i),k=p(i),$=o(i,"P",{"data-svelte-h":!0}),f($)!=="svelte-dawe82"&&($.innerHTML=X),W=p(i),d(_.$$.fragment,i)},m(i,C){l(i,e,C),l(i,c,C),h(g,i,C),l(i,w,C),l(i,b,C),l(i,Z,C),h(R,i,C),l(i,k,C),l(i,$,C),l(i,W,C),h(_,i,C),G=!0},p:Hs,i(i){G||(j(g.$$.fragment,i),j(R.$$.fragment,i),j(_.$$.fragment,i),G=!0)},o(i){y(g.$$.fragment,i),y(R.$$.fragment,i),y(_.$$.fragment,i),G=!1},d(i){i&&(a(e),a(c),a(w),a(b),a(Z),a(k),a($),a(W)),u(g,i),u(R,i),u(_,i)}}}function xa(v){let e,J;return e=new fa({props:{$$slots:{default:[Wa]},$$scope:{ctx:v}}}),{c(){M(e.$$.fragment)},l(c){d(e.$$.fragment,c)},m(c,g){h(e,c,g),J=!0},p(c,g){const w={};g&2&&(w.$$scope={dirty:g,ctx:c}),e.$set(w)},i(c){J||(j(e.$$.fragment,c),J=!0)},o(c){y(e.$$.fragment,c),J=!1},d(c){u(e,c)}}}function Ga(v){let e,J,c,g,w,b,I,Z,R,k,$,X=`自动语音识别（ASR）将语音信号转换为文本，将一系列音频输入映射到文本输出。
Siri 和 Alexa 这类虚拟助手使用 ASR 模型来帮助用户日常生活，还有许多其他面向用户的有用应用，如会议实时字幕和会议纪要。`,W,_,G="本指南将向您展示如何：",i,C,N=`<li>在 <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MInDS-14</a> 数据集上对
<a href="https://huggingface.co/facebook/wav2vec2-base" rel="nofollow">Wav2Vec2</a> 进行微调，以将音频转录为文本。</li> <li>使用微调后的模型进行推断。</li>`,B,x,r,U,Xs="在开始之前，请确保您已安装所有必要的库：",Ys,Q,zs,E,Yt=`我们鼓励您登录自己的 Hugging Face 账户，这样您就可以上传并与社区分享您的模型。
出现提示时，输入您的令牌登录：`,Ns,A,Qs,F,Es,q,zt=`首先从🤗 Datasets 库中加载 <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MInDS-14</a>
数据集的一个较小子集。这将让您有机会先进行实验，确保一切正常，然后再花更多时间在完整数据集上进行训练。`,As,S,Fs,L,Nt="使用 <code>~Dataset.train_test_split</code> 方法将数据集的 <code>train</code> 拆分为训练集和测试集：",qs,P,Ss,D,Qt="然后看看数据集：",Ls,K,Ps,O,Et=`虽然数据集包含 <code>lang_id </code>和 <code>english_transcription</code> 等许多有用的信息，但在本指南中，
您将专注于 <code>audio</code> 和 <code>transcription</code>。使用 <code>remove_columns</code> 方法删除其他列：`,Ds,ss,Ks,ts,At="再看看示例：",Os,as,st,ls,Ft="有 2 个字段：",tt,es,qt="<li><code>audio</code>：由语音信号形成的一维 <code>array</code>，用于加载和重新采样音频文件。</li> <li><code>transcription</code>：目标文本。</li>",at,ns,lt,ps,St="下一步是加载一个 Wav2Vec2 处理器来处理音频信号：",et,cs,nt,rs,Lt=`MInDS-14 数据集的采样率为 8000kHz（您可以在其<a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">数据集卡片</a>中找到此信息），
这意味着您需要将数据集重新采样为 16000kHz 以使用预训练的 Wav2Vec2 模型：`,pt,is,ct,ms,Pt=`如您在上面的 <code>transcription</code> 中所看到的，文本包含大小写字符的混合。
Wav2Vec2 分词器仅训练了大写字符，因此您需要确保文本与分词器的词汇表匹配：`,rt,os,it,Ms,Dt="现在创建一个预处理函数，该函数应该：",mt,ds,Kt="<li>调用 <code>audio</code> 列以加载和重新采样音频文件。</li> <li>从音频文件中提取 <code>input_values</code> 并使用处理器对 <code>transcription</code> 列执行 tokenizer 操作。</li>",ot,hs,Mt,js,Ot=`要在整个数据集上应用预处理函数，可以使用🤗 Datasets 的 <code>map</code> 函数。
您可以通过增加 <code>num_proc</code> 参数来加速 <code>map</code> 的处理进程数量。
使用 <code>remove_columns</code> 方法删除不需要的列：`,dt,ys,ht,us,sa=`🤗 Transformers 没有用于 ASR 的数据整理器，因此您需要调整 <a href="/docs/transformers/main/zh/main_classes/data_collator#transformers.DataCollatorWithPadding">DataCollatorWithPadding</a> 来创建一个示例批次。
它还会动态地将您的文本和标签填充到其批次中最长元素的长度（而不是整个数据集），以使它们具有统一的长度。
虽然可以通过在 <code>tokenizer</code> 函数中设置 <code>padding=True</code> 来填充文本，但动态填充更有效。`,jt,fs,ta="与其他数据整理器不同，这个特定的数据整理器需要对 <code>input_values</code> 和 <code>labels </code>应用不同的填充方法：",yt,gs,ut,Js,aa="现在实例化您的 <code>DataCollatorForCTCWithPadding</code>：",ft,bs,gt,ws,Jt,Us,la=`在训练过程中包含一个指标通常有助于评估模型的性能。
您可以通过🤗 <a href="https://huggingface.co/docs/evaluate/index" rel="nofollow">Evaluate</a> 库快速加载一个评估方法。
对于这个任务，加载 <a href="https://huggingface.co/spaces/evaluate-metric/wer" rel="nofollow">word error rate</a>（WER）指标
（请参阅🤗 Evaluate <a href="https://huggingface.co/docs/evaluate/a_quick_tour" rel="nofollow">快速上手</a>以了解如何加载和计算指标）：`,bt,Ts,wt,$s,ea="然后创建一个函数，将您的预测和标签传递给 <code>compute</code> 来计算 WER：",Ut,_s,Tt,Cs,na="您的 <code>compute_metrics</code> 函数现在已经准备就绪，当您设置好训练时将返回给此函数。",$t,Is,_t,V,Ct,H,It,vs,vt,Rs,pa="很好，现在您已经微调了一个模型，您可以用它进行推断了！",Rt,Zs,ca="加载您想要运行推断的音频文件。请记住，如果需要，将音频文件的采样率重新采样为与模型匹配的采样率！",Zt,ks,kt,Ws,ra=`尝试使用微调后的模型进行推断的最简单方法是使用 <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a>。
使用您的模型实例化一个用于自动语音识别的 <code>pipeline</code>，并将您的音频文件传递给它：`,Wt,xs,xt,Y,Gt,Gs,ia="如果您愿意，您也可以手动复制 <code>pipeline</code> 的结果：",Bt,z,Xt,Vs,Vt;return w=new Bs({props:{title:"自动语音识别",local:"自动语音识别",headingTag:"h1"}}),I=new _a({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/asr.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/pytorch/asr.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/tensorflow/asr.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/asr.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/pytorch/asr.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/tensorflow/asr.ipynb"}]}}),R=new $a({props:{id:"TksaY_FDgnk"}}),x=new Ht({props:{$$slots:{default:[Ca]},$$scope:{ctx:v}}}),Q=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwZXZhbHVhdGUlMjBqaXdlcg==",highlighted:"pip install transformers datasets evaluate jiwer",wrap:!1}}),A=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),F=new Bs({props:{title:"加载 MInDS-14 数据集",local:"加载-minds-14-数据集",headingTag:"h2"}}),S=new T({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJQb2x5QUklMkZtaW5kczE0JTIyJTJDJTIwbmFtZSUzRCUyMmVuLVVTJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiU1QiUzQTEwMCU1RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-US&quot;</span>, split=<span class="hljs-string">&quot;train[:100]&quot;</span>)`,wrap:!1}}),P=new T({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy50cmFpbl90ZXN0X3NwbGl0KHRlc3Rfc2l6ZSUzRDAuMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>minds = minds.train_test_split(test_size=<span class="hljs-number">0.2</span>)',wrap:!1}}),K=new T({props:{code:"bWluZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>minds
DatasetDict({
    train: Dataset({
        features: [<span class="hljs-string">&#x27;path&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;transcription&#x27;</span>, <span class="hljs-string">&#x27;english_transcription&#x27;</span>, <span class="hljs-string">&#x27;intent_class&#x27;</span>, <span class="hljs-string">&#x27;lang_id&#x27;</span>],
        num_rows: <span class="hljs-number">16</span>
    })
    test: Dataset({
        features: [<span class="hljs-string">&#x27;path&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;transcription&#x27;</span>, <span class="hljs-string">&#x27;english_transcription&#x27;</span>, <span class="hljs-string">&#x27;intent_class&#x27;</span>, <span class="hljs-string">&#x27;lang_id&#x27;</span>],
        num_rows: <span class="hljs-number">4</span>
    })
})`,wrap:!1}}),ss=new T({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyglNUIlMjJlbmdsaXNoX3RyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMjAlMjJsYW5nX2lkJTIyJTVEKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>minds = minds.remove_columns([<span class="hljs-string">&quot;english_transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>, <span class="hljs-string">&quot;lang_id&quot;</span>])',wrap:!1}}),as=new T({props:{code:"bWluZHMlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>minds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;audio&#x27;</span>: {<span class="hljs-string">&#x27;array&#x27;</span>: array([-<span class="hljs-number">0.00024414</span>,  <span class="hljs-number">0.</span>        ,  <span class="hljs-number">0.</span>        , ...,  <span class="hljs-number">0.00024414</span>,
          <span class="hljs-number">0.00024414</span>,  <span class="hljs-number">0.00024414</span>], dtype=float32),
  <span class="hljs-string">&#x27;path&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-US~APP_ERROR/602ba9e2963e11ccd901cd4f.wav&#x27;</span>,
  <span class="hljs-string">&#x27;sampling_rate&#x27;</span>: <span class="hljs-number">8000</span>},
 <span class="hljs-string">&#x27;path&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-US~APP_ERROR/602ba9e2963e11ccd901cd4f.wav&#x27;</span>,
 <span class="hljs-string">&#x27;transcription&#x27;</span>: <span class="hljs-string">&quot;hi I&#x27;m trying to use the banking app on my phone and currently my checking and savings account balance is not refreshing&quot;</span>}`,wrap:!1}}),ns=new Bs({props:{title:"预处理",local:"预处理",headingTag:"h2"}}),cs=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRndhdjJ2ZWMyLWJhc2UlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base&quot;</span>)`,wrap:!1}}),is=new T({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5jYXN0X2NvbHVtbiglMjJhdWRpbyUyMiUyQyUyMEF1ZGlvKHNhbXBsaW5nX3JhdGUlM0QxNl8wMDApKSUwQW1pbmRzJTVCJTIydHJhaW4lMjIlNUQlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>minds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;audio&#x27;</span>: {<span class="hljs-string">&#x27;array&#x27;</span>: array([-<span class="hljs-number">2.38064706e-04</span>, -<span class="hljs-number">1.58618059e-04</span>, -<span class="hljs-number">5.43987835e-06</span>, ...,
          <span class="hljs-number">2.78103951e-04</span>,  <span class="hljs-number">2.38446111e-04</span>,  <span class="hljs-number">1.18740834e-04</span>], dtype=float32),
  <span class="hljs-string">&#x27;path&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-US~APP_ERROR/602ba9e2963e11ccd901cd4f.wav&#x27;</span>,
  <span class="hljs-string">&#x27;sampling_rate&#x27;</span>: <span class="hljs-number">16000</span>},
 <span class="hljs-string">&#x27;path&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-US~APP_ERROR/602ba9e2963e11ccd901cd4f.wav&#x27;</span>,
 <span class="hljs-string">&#x27;transcription&#x27;</span>: <span class="hljs-string">&quot;hi I&#x27;m trying to use the banking app on my phone and currently my checking and savings account balance is not refreshing&quot;</span>}`,wrap:!1}}),os=new T({props:{code:"ZGVmJTIwdXBwZXJjYXNlKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIydHJhbnNjcmlwdGlvbiUyMiUzQSUyMGV4YW1wbGUlNUIlMjJ0cmFuc2NyaXB0aW9uJTIyJTVELnVwcGVyKCklN0QlMEElMEElMEFtaW5kcyUyMCUzRCUyMG1pbmRzLm1hcCh1cHBlcmNhc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">uppercase</span>(<span class="hljs-params">example</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;transcription&quot;</span>: example[<span class="hljs-string">&quot;transcription&quot;</span>].upper()}


<span class="hljs-meta">&gt;&gt;&gt; </span>minds = minds.<span class="hljs-built_in">map</span>(uppercase)`,wrap:!1}}),hs=new T({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGJhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwYmF0Y2glNUIlMjJhdWRpbyUyMiU1RCUwQSUyMCUyMCUyMCUyMGJhdGNoJTIwJTNEJTIwcHJvY2Vzc29yKGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTIwdGV4dCUzRGJhdGNoJTVCJTIydHJhbnNjcmlwdGlvbiUyMiU1RCklMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMmlucHV0X2xlbmd0aCUyMiU1RCUyMCUzRCUyMGxlbihiYXRjaCU1QiUyMmlucHV0X3ZhbHVlcyUyMiU1RCU1QjAlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYmF0Y2g=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    audio = batch[<span class="hljs-string">&quot;audio&quot;</span>]
<span class="hljs-meta">... </span>    batch = processor(audio[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>], text=batch[<span class="hljs-string">&quot;transcription&quot;</span>])
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;input_length&quot;</span>] = <span class="hljs-built_in">len</span>(batch[<span class="hljs-string">&quot;input_values&quot;</span>][<span class="hljs-number">0</span>])
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch`,wrap:!1}}),ys=new T({props:{code:"ZW5jb2RlZF9taW5kcyUyMCUzRCUyMG1pbmRzLm1hcChwcmVwYXJlX2RhdGFzZXQlMkMlMjByZW1vdmVfY29sdW1ucyUzRG1pbmRzLmNvbHVtbl9uYW1lcyU1QiUyMnRyYWluJTIyJTVEJTJDJTIwbnVtX3Byb2MlM0Q0KQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_minds = minds.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=minds.column_names[<span class="hljs-string">&quot;train&quot;</span>], num_proc=<span class="hljs-number">4</span>)',wrap:!1}}),gs=new T({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass, field
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Optional</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>@dataclass
<span class="hljs-meta">... </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">DataCollatorCTCWithPadding</span>:
<span class="hljs-meta">... </span>    processor: AutoProcessor
<span class="hljs-meta">... </span>    padding: <span class="hljs-type">Union</span>[<span class="hljs-built_in">bool</span>, <span class="hljs-built_in">str</span>] = <span class="hljs-string">&quot;longest&quot;</span>

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># split inputs and labels since they have to be of different lengths and need</span>
<span class="hljs-meta">... </span>        <span class="hljs-comment"># different padding methods</span>
<span class="hljs-meta">... </span>        input_features = [{<span class="hljs-string">&quot;input_values&quot;</span>: feature[<span class="hljs-string">&quot;input_values&quot;</span>][<span class="hljs-number">0</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
<span class="hljs-meta">... </span>        label_features = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]

<span class="hljs-meta">... </span>        batch = self.processor.pad(input_features, padding=self.padding, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">... </span>        labels_batch = self.processor.pad(labels=label_features, padding=self.padding, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># replace padding with -100 to ignore loss correctly</span>
<span class="hljs-meta">... </span>        labels = labels_batch[<span class="hljs-string">&quot;input_ids&quot;</span>].masked_fill(labels_batch.attention_mask.ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>)

<span class="hljs-meta">... </span>        batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels

<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> batch`,wrap:!1}}),bs=new T({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckNUQ1dpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3NvciUyQyUyMHBhZGRpbmclM0QlMjJsb25nZXN0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DataCollatorCTCWithPadding(processor=processor, padding=<span class="hljs-string">&quot;longest&quot;</span>)',wrap:!1}}),ws=new Bs({props:{title:"评估",local:"评估",headingTag:"h2"}}),Ts=new T({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEF3ZXIlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMndlciUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> evaluate

<span class="hljs-meta">&gt;&gt;&gt; </span>wer = evaluate.load(<span class="hljs-string">&quot;wer&quot;</span>)`,wrap:!1}}),_s=new T({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKHByZWQpJTNBJTBBJTIwJTIwJTIwJTIwcHJlZF9sb2dpdHMlMjAlM0QlMjBwcmVkLnByZWRpY3Rpb25zJTBBJTIwJTIwJTIwJTIwcHJlZF9pZHMlMjAlM0QlMjBucC5hcmdtYXgocHJlZF9sb2dpdHMlMkMlMjBheGlzJTNELTEpJTBBJTBBJTIwJTIwJTIwJTIwcHJlZC5sYWJlbF9pZHMlNUJwcmVkLmxhYmVsX2lkcyUyMCUzRCUzRCUyMC0xMDAlNUQlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyLnBhZF90b2tlbl9pZCUwQSUwQSUyMCUyMCUyMCUyMHByZWRfc3RyJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShwcmVkX2lkcyklMEElMjAlMjAlMjAlMjBsYWJlbF9zdHIlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKHByZWQubGFiZWxfaWRzJTJDJTIwZ3JvdXBfdG9rZW5zJTNERmFsc2UpJTBBJTBBJTIwJTIwJTIwJTIwd2VyJTIwJTNEJTIwd2VyLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkX3N0ciUyQyUyMHJlZmVyZW5jZXMlM0RsYWJlbF9zdHIpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyd2VyJTIyJTNBJTIwd2VyJTdE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">pred</span>):
<span class="hljs-meta">... </span>    pred_logits = pred.predictions
<span class="hljs-meta">... </span>    pred_ids = np.argmax(pred_logits, axis=-<span class="hljs-number">1</span>)

<span class="hljs-meta">... </span>    pred.label_ids[pred.label_ids == -<span class="hljs-number">100</span>] = processor.tokenizer.pad_token_id

<span class="hljs-meta">... </span>    pred_str = processor.batch_decode(pred_ids)
<span class="hljs-meta">... </span>    label_str = processor.batch_decode(pred.label_ids, group_tokens=<span class="hljs-literal">False</span>)

<span class="hljs-meta">... </span>    wer = wer.compute(predictions=pred_str, references=label_str)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;wer&quot;</span>: wer}`,wrap:!1}}),Is=new Bs({props:{title:"训练",local:"训练",headingTag:"h2"}}),V=new ua({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[Ra]},$$scope:{ctx:v}}}),H=new Ht({props:{$$slots:{default:[Za]},$$scope:{ctx:v}}}),vs=new Bs({props:{title:"推断",local:"推断",headingTag:"h2"}}),ks=new T({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMlBvbHlBSSUyRm1pbmRzMTQlMjIlMkMlMjAlMjJlbi1VUyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQWF1ZGlvX2ZpbGUlMjAlM0QlMjBkYXRhc2V0JTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIycGF0aCUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, <span class="hljs-string">&quot;en-US&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_file = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;path&quot;</span>]`,wrap:!1}}),xs=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZSglMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJzdGV2aGxpdSUyRm15X2F3ZXNvbWVfYXNyX21pbmRzX21vZGVsJTIyKSUwQXRyYW5zY3JpYmVyKGF1ZGlvX2ZpbGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;stevhliu/my_awesome_asr_minds_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(audio_file)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;I WOUD LIKE O SET UP JOINT ACOUNT WTH Y PARTNER&#x27;</span>}`,wrap:!1}}),Y=new Ht({props:{$$slots:{default:[ka]},$$scope:{ctx:v}}}),z=new ua({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[xa]},$$scope:{ctx:v}}}),{c(){e=m("meta"),J=n(),c=m("p"),g=n(),M(w.$$.fragment),b=n(),M(I.$$.fragment),Z=n(),M(R.$$.fragment),k=n(),$=m("p"),$.textContent=X,W=n(),_=m("p"),_.textContent=G,i=n(),C=m("ol"),C.innerHTML=N,B=n(),M(x.$$.fragment),r=n(),U=m("p"),U.textContent=Xs,Ys=n(),M(Q.$$.fragment),zs=n(),E=m("p"),E.textContent=Yt,Ns=n(),M(A.$$.fragment),Qs=n(),M(F.$$.fragment),Es=n(),q=m("p"),q.innerHTML=zt,As=n(),M(S.$$.fragment),Fs=n(),L=m("p"),L.innerHTML=Nt,qs=n(),M(P.$$.fragment),Ss=n(),D=m("p"),D.textContent=Qt,Ls=n(),M(K.$$.fragment),Ps=n(),O=m("p"),O.innerHTML=Et,Ds=n(),M(ss.$$.fragment),Ks=n(),ts=m("p"),ts.textContent=At,Os=n(),M(as.$$.fragment),st=n(),ls=m("p"),ls.textContent=Ft,tt=n(),es=m("ul"),es.innerHTML=qt,at=n(),M(ns.$$.fragment),lt=n(),ps=m("p"),ps.textContent=St,et=n(),M(cs.$$.fragment),nt=n(),rs=m("p"),rs.innerHTML=Lt,pt=n(),M(is.$$.fragment),ct=n(),ms=m("p"),ms.innerHTML=Pt,rt=n(),M(os.$$.fragment),it=n(),Ms=m("p"),Ms.textContent=Dt,mt=n(),ds=m("ol"),ds.innerHTML=Kt,ot=n(),M(hs.$$.fragment),Mt=n(),js=m("p"),js.innerHTML=Ot,dt=n(),M(ys.$$.fragment),ht=n(),us=m("p"),us.innerHTML=sa,jt=n(),fs=m("p"),fs.innerHTML=ta,yt=n(),M(gs.$$.fragment),ut=n(),Js=m("p"),Js.innerHTML=aa,ft=n(),M(bs.$$.fragment),gt=n(),M(ws.$$.fragment),Jt=n(),Us=m("p"),Us.innerHTML=la,bt=n(),M(Ts.$$.fragment),wt=n(),$s=m("p"),$s.innerHTML=ea,Ut=n(),M(_s.$$.fragment),Tt=n(),Cs=m("p"),Cs.innerHTML=na,$t=n(),M(Is.$$.fragment),_t=n(),M(V.$$.fragment),Ct=n(),M(H.$$.fragment),It=n(),M(vs.$$.fragment),vt=n(),Rs=m("p"),Rs.textContent=pa,Rt=n(),Zs=m("p"),Zs.textContent=ca,Zt=n(),M(ks.$$.fragment),kt=n(),Ws=m("p"),Ws.innerHTML=ra,Wt=n(),M(xs.$$.fragment),xt=n(),M(Y.$$.fragment),Gt=n(),Gs=m("p"),Gs.innerHTML=ia,Bt=n(),M(z.$$.fragment),Xt=n(),Vs=m("p"),this.h()},l(s){const t=Ua("svelte-u9bgzb",document.head);e=o(t,"META",{name:!0,content:!0}),t.forEach(a),J=p(s),c=o(s,"P",{}),ja(c).forEach(a),g=p(s),d(w.$$.fragment,s),b=p(s),d(I.$$.fragment,s),Z=p(s),d(R.$$.fragment,s),k=p(s),$=o(s,"P",{"data-svelte-h":!0}),f($)!=="svelte-1is3cg2"&&($.textContent=X),W=p(s),_=o(s,"P",{"data-svelte-h":!0}),f(_)!=="svelte-t113tb"&&(_.textContent=G),i=p(s),C=o(s,"OL",{"data-svelte-h":!0}),f(C)!=="svelte-14dko6t"&&(C.innerHTML=N),B=p(s),d(x.$$.fragment,s),r=p(s),U=o(s,"P",{"data-svelte-h":!0}),f(U)!=="svelte-tatoy7"&&(U.textContent=Xs),Ys=p(s),d(Q.$$.fragment,s),zs=p(s),E=o(s,"P",{"data-svelte-h":!0}),f(E)!=="svelte-kr9h35"&&(E.textContent=Yt),Ns=p(s),d(A.$$.fragment,s),Qs=p(s),d(F.$$.fragment,s),Es=p(s),q=o(s,"P",{"data-svelte-h":!0}),f(q)!=="svelte-1rjtqvw"&&(q.innerHTML=zt),As=p(s),d(S.$$.fragment,s),Fs=p(s),L=o(s,"P",{"data-svelte-h":!0}),f(L)!=="svelte-1m5ohtx"&&(L.innerHTML=Nt),qs=p(s),d(P.$$.fragment,s),Ss=p(s),D=o(s,"P",{"data-svelte-h":!0}),f(D)!=="svelte-1n374q4"&&(D.textContent=Qt),Ls=p(s),d(K.$$.fragment,s),Ps=p(s),O=o(s,"P",{"data-svelte-h":!0}),f(O)!=="svelte-nfc1p1"&&(O.innerHTML=Et),Ds=p(s),d(ss.$$.fragment,s),Ks=p(s),ts=o(s,"P",{"data-svelte-h":!0}),f(ts)!=="svelte-1pkn7jo"&&(ts.textContent=At),Os=p(s),d(as.$$.fragment,s),st=p(s),ls=o(s,"P",{"data-svelte-h":!0}),f(ls)!=="svelte-3uiz9"&&(ls.textContent=Ft),tt=p(s),es=o(s,"UL",{"data-svelte-h":!0}),f(es)!=="svelte-1pfos8g"&&(es.innerHTML=qt),at=p(s),d(ns.$$.fragment,s),lt=p(s),ps=o(s,"P",{"data-svelte-h":!0}),f(ps)!=="svelte-12o5whx"&&(ps.textContent=St),et=p(s),d(cs.$$.fragment,s),nt=p(s),rs=o(s,"P",{"data-svelte-h":!0}),f(rs)!=="svelte-1ri3w02"&&(rs.innerHTML=Lt),pt=p(s),d(is.$$.fragment,s),ct=p(s),ms=o(s,"P",{"data-svelte-h":!0}),f(ms)!=="svelte-msrpss"&&(ms.innerHTML=Pt),rt=p(s),d(os.$$.fragment,s),it=p(s),Ms=o(s,"P",{"data-svelte-h":!0}),f(Ms)!=="svelte-xedpbt"&&(Ms.textContent=Dt),mt=p(s),ds=o(s,"OL",{"data-svelte-h":!0}),f(ds)!=="svelte-1vt1wa"&&(ds.innerHTML=Kt),ot=p(s),d(hs.$$.fragment,s),Mt=p(s),js=o(s,"P",{"data-svelte-h":!0}),f(js)!=="svelte-1y8tefx"&&(js.innerHTML=Ot),dt=p(s),d(ys.$$.fragment,s),ht=p(s),us=o(s,"P",{"data-svelte-h":!0}),f(us)!=="svelte-a75skc"&&(us.innerHTML=sa),jt=p(s),fs=o(s,"P",{"data-svelte-h":!0}),f(fs)!=="svelte-1ulir2"&&(fs.innerHTML=ta),yt=p(s),d(gs.$$.fragment,s),ut=p(s),Js=o(s,"P",{"data-svelte-h":!0}),f(Js)!=="svelte-1lzy2ns"&&(Js.innerHTML=aa),ft=p(s),d(bs.$$.fragment,s),gt=p(s),d(ws.$$.fragment,s),Jt=p(s),Us=o(s,"P",{"data-svelte-h":!0}),f(Us)!=="svelte-zxn94k"&&(Us.innerHTML=la),bt=p(s),d(Ts.$$.fragment,s),wt=p(s),$s=o(s,"P",{"data-svelte-h":!0}),f($s)!=="svelte-tcc4mm"&&($s.innerHTML=ea),Ut=p(s),d(_s.$$.fragment,s),Tt=p(s),Cs=o(s,"P",{"data-svelte-h":!0}),f(Cs)!=="svelte-1ka9fc6"&&(Cs.innerHTML=na),$t=p(s),d(Is.$$.fragment,s),_t=p(s),d(V.$$.fragment,s),Ct=p(s),d(H.$$.fragment,s),It=p(s),d(vs.$$.fragment,s),vt=p(s),Rs=o(s,"P",{"data-svelte-h":!0}),f(Rs)!=="svelte-z5bkut"&&(Rs.textContent=pa),Rt=p(s),Zs=o(s,"P",{"data-svelte-h":!0}),f(Zs)!=="svelte-1vriigd"&&(Zs.textContent=ca),Zt=p(s),d(ks.$$.fragment,s),kt=p(s),Ws=o(s,"P",{"data-svelte-h":!0}),f(Ws)!=="svelte-1y9ko04"&&(Ws.innerHTML=ra),Wt=p(s),d(xs.$$.fragment,s),xt=p(s),d(Y.$$.fragment,s),Gt=p(s),Gs=o(s,"P",{"data-svelte-h":!0}),f(Gs)!=="svelte-10au8tt"&&(Gs.innerHTML=ia),Bt=p(s),d(z.$$.fragment,s),Xt=p(s),Vs=o(s,"P",{}),ja(Vs).forEach(a),this.h()},h(){ya(e,"name","hf:doc:metadata"),ya(e,"content",Ba)},m(s,t){Ta(document.head,e),l(s,J,t),l(s,c,t),l(s,g,t),h(w,s,t),l(s,b,t),h(I,s,t),l(s,Z,t),h(R,s,t),l(s,k,t),l(s,$,t),l(s,W,t),l(s,_,t),l(s,i,t),l(s,C,t),l(s,B,t),h(x,s,t),l(s,r,t),l(s,U,t),l(s,Ys,t),h(Q,s,t),l(s,zs,t),l(s,E,t),l(s,Ns,t),h(A,s,t),l(s,Qs,t),h(F,s,t),l(s,Es,t),l(s,q,t),l(s,As,t),h(S,s,t),l(s,Fs,t),l(s,L,t),l(s,qs,t),h(P,s,t),l(s,Ss,t),l(s,D,t),l(s,Ls,t),h(K,s,t),l(s,Ps,t),l(s,O,t),l(s,Ds,t),h(ss,s,t),l(s,Ks,t),l(s,ts,t),l(s,Os,t),h(as,s,t),l(s,st,t),l(s,ls,t),l(s,tt,t),l(s,es,t),l(s,at,t),h(ns,s,t),l(s,lt,t),l(s,ps,t),l(s,et,t),h(cs,s,t),l(s,nt,t),l(s,rs,t),l(s,pt,t),h(is,s,t),l(s,ct,t),l(s,ms,t),l(s,rt,t),h(os,s,t),l(s,it,t),l(s,Ms,t),l(s,mt,t),l(s,ds,t),l(s,ot,t),h(hs,s,t),l(s,Mt,t),l(s,js,t),l(s,dt,t),h(ys,s,t),l(s,ht,t),l(s,us,t),l(s,jt,t),l(s,fs,t),l(s,yt,t),h(gs,s,t),l(s,ut,t),l(s,Js,t),l(s,ft,t),h(bs,s,t),l(s,gt,t),h(ws,s,t),l(s,Jt,t),l(s,Us,t),l(s,bt,t),h(Ts,s,t),l(s,wt,t),l(s,$s,t),l(s,Ut,t),h(_s,s,t),l(s,Tt,t),l(s,Cs,t),l(s,$t,t),h(Is,s,t),l(s,_t,t),h(V,s,t),l(s,Ct,t),h(H,s,t),l(s,It,t),h(vs,s,t),l(s,vt,t),l(s,Rs,t),l(s,Rt,t),l(s,Zs,t),l(s,Zt,t),h(ks,s,t),l(s,kt,t),l(s,Ws,t),l(s,Wt,t),h(xs,s,t),l(s,xt,t),h(Y,s,t),l(s,Gt,t),l(s,Gs,t),l(s,Bt,t),h(z,s,t),l(s,Xt,t),l(s,Vs,t),Vt=!0},p(s,[t]){const ma={};t&2&&(ma.$$scope={dirty:t,ctx:s}),x.$set(ma);const oa={};t&2&&(oa.$$scope={dirty:t,ctx:s}),V.$set(oa);const Ma={};t&2&&(Ma.$$scope={dirty:t,ctx:s}),H.$set(Ma);const da={};t&2&&(da.$$scope={dirty:t,ctx:s}),Y.$set(da);const ha={};t&2&&(ha.$$scope={dirty:t,ctx:s}),z.$set(ha)},i(s){Vt||(j(w.$$.fragment,s),j(I.$$.fragment,s),j(R.$$.fragment,s),j(x.$$.fragment,s),j(Q.$$.fragment,s),j(A.$$.fragment,s),j(F.$$.fragment,s),j(S.$$.fragment,s),j(P.$$.fragment,s),j(K.$$.fragment,s),j(ss.$$.fragment,s),j(as.$$.fragment,s),j(ns.$$.fragment,s),j(cs.$$.fragment,s),j(is.$$.fragment,s),j(os.$$.fragment,s),j(hs.$$.fragment,s),j(ys.$$.fragment,s),j(gs.$$.fragment,s),j(bs.$$.fragment,s),j(ws.$$.fragment,s),j(Ts.$$.fragment,s),j(_s.$$.fragment,s),j(Is.$$.fragment,s),j(V.$$.fragment,s),j(H.$$.fragment,s),j(vs.$$.fragment,s),j(ks.$$.fragment,s),j(xs.$$.fragment,s),j(Y.$$.fragment,s),j(z.$$.fragment,s),Vt=!0)},o(s){y(w.$$.fragment,s),y(I.$$.fragment,s),y(R.$$.fragment,s),y(x.$$.fragment,s),y(Q.$$.fragment,s),y(A.$$.fragment,s),y(F.$$.fragment,s),y(S.$$.fragment,s),y(P.$$.fragment,s),y(K.$$.fragment,s),y(ss.$$.fragment,s),y(as.$$.fragment,s),y(ns.$$.fragment,s),y(cs.$$.fragment,s),y(is.$$.fragment,s),y(os.$$.fragment,s),y(hs.$$.fragment,s),y(ys.$$.fragment,s),y(gs.$$.fragment,s),y(bs.$$.fragment,s),y(ws.$$.fragment,s),y(Ts.$$.fragment,s),y(_s.$$.fragment,s),y(Is.$$.fragment,s),y(V.$$.fragment,s),y(H.$$.fragment,s),y(vs.$$.fragment,s),y(ks.$$.fragment,s),y(xs.$$.fragment,s),y(Y.$$.fragment,s),y(z.$$.fragment,s),Vt=!1},d(s){s&&(a(J),a(c),a(g),a(b),a(Z),a(k),a($),a(W),a(_),a(i),a(C),a(B),a(r),a(U),a(Ys),a(zs),a(E),a(Ns),a(Qs),a(Es),a(q),a(As),a(Fs),a(L),a(qs),a(Ss),a(D),a(Ls),a(Ps),a(O),a(Ds),a(Ks),a(ts),a(Os),a(st),a(ls),a(tt),a(es),a(at),a(lt),a(ps),a(et),a(nt),a(rs),a(pt),a(ct),a(ms),a(rt),a(it),a(Ms),a(mt),a(ds),a(ot),a(Mt),a(js),a(dt),a(ht),a(us),a(jt),a(fs),a(yt),a(ut),a(Js),a(ft),a(gt),a(Jt),a(Us),a(bt),a(wt),a($s),a(Ut),a(Tt),a(Cs),a($t),a(_t),a(Ct),a(It),a(vt),a(Rs),a(Rt),a(Zs),a(Zt),a(kt),a(Ws),a(Wt),a(xt),a(Gt),a(Gs),a(Bt),a(Xt),a(Vs)),a(e),u(w,s),u(I,s),u(R,s),u(x,s),u(Q,s),u(A,s),u(F,s),u(S,s),u(P,s),u(K,s),u(ss,s),u(as,s),u(ns,s),u(cs,s),u(is,s),u(os,s),u(hs,s),u(ys,s),u(gs,s),u(bs,s),u(ws,s),u(Ts,s),u(_s,s),u(Is,s),u(V,s),u(H,s),u(vs,s),u(ks,s),u(xs,s),u(Y,s),u(z,s)}}}const Ba='{"title":"自动语音识别","local":"自动语音识别","sections":[{"title":"加载 MInDS-14 数据集","local":"加载-minds-14-数据集","sections":[],"depth":2},{"title":"预处理","local":"预处理","sections":[],"depth":2},{"title":"评估","local":"评估","sections":[],"depth":2},{"title":"训练","local":"训练","sections":[],"depth":2},{"title":"推断","local":"推断","sections":[],"depth":2}],"depth":1}';function Xa(v){return Ja(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fa extends ba{constructor(e){super(),wa(this,e,Xa,Ga,ga,{})}}export{Fa as component};
