import{s as me,f as Me,n as ce,o as de}from"../chunks/scheduler.9039eef2.js";import{S as ue,i as he,g as o,s as a,r as U,A as we,h as i,f as t,c as n,j as pe,u as Z,x as W,k as K,y as ye,a as s,v as B,d as g,t as I,w as k}from"../chunks/index.ded8f90d.js";import{C as O}from"../chunks/CodeBlock.8580f3e8.js";import{H as D}from"../chunks/Heading.f027f30d.js";function Je(ee){let r,V,v,_,p,G,m,Q,M,le="Fine-tuning a language model via PPO consists of roughly three steps:",H,c,te="<li><strong>Rollout</strong>: The language model generates a response or continuation based on a query which could be the start of a sentence.</li> <li><strong>Evaluation</strong>: The query and response are evaluated with a function, model, human feedback, or some combination of them. The important thing is that this process should yield a scalar value for each query/response pair. The optimization will aim at maximizing this value.</li> <li><strong>Optimization</strong>: This is the most complex part. In the optimisation step the query/response pairs are used to calculate the log-probabilities of the tokens in the sequences. This is done with the model that is trained and a reference model, which is usually the pre-trained model before fine-tuning. The KL-divergence between the two outputs is used as an additional reward signal to make sure the generated responses don’t deviate too far from the reference language model. The active language model is then trained with PPO.</li>",E,d,se="The full process is illustrated in the following figure:",R,X,ae,$,u,F,h,ne="The following code illustrates the steps above.",x,w,N,y,oe="In general, you would run steps 3-6 in a for-loop and run it on many diverse queries. You can find more realistic examples in the examples section.",q,J,z,T,ie="After training a <code>AutoModelForCausalLMWithValueHead</code>, you can directly use the model in <code>transformers</code>.",S,j,A,b,re="You can also load your model with <code>AutoModelForCausalLMWithValueHead</code> if you want to use the value head, for example to continue training.",L,f,Y,C,P;return p=new D({props:{title:"Quickstart",local:"quickstart",headingTag:"h1"}}),m=new D({props:{title:"How does it work?",local:"how-does-it-work",headingTag:"h2"}}),u=new D({props:{title:"Minimal example",local:"minimal-example",headingTag:"h2"}}),w=new O({props:{code:"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",highlighted:`<span class="hljs-comment"># 0. imports</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer

<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> AutoModelForCausalLMWithValueHead, PPOConfig, PPOTrainer


<span class="hljs-comment"># 1. load a pretrained model</span>
model = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
model_ref = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
tokenizer.pad_token = tokenizer.eos_token

<span class="hljs-comment"># 2. initialize trainer</span>
ppo_config = {<span class="hljs-string">&quot;mini_batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>}
config = PPOConfig(**ppo_config)
ppo_trainer = PPOTrainer(config, model, model_ref, tokenizer)

<span class="hljs-comment"># 3. encode a query</span>
query_txt = <span class="hljs-string">&quot;This morning I went to the &quot;</span>
query_tensor = tokenizer.encode(query_txt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.pretrained_model.device)

<span class="hljs-comment"># 4. generate model response</span>
generation_kwargs = {
    <span class="hljs-string">&quot;min_length&quot;</span>: -<span class="hljs-number">1</span>,
    <span class="hljs-string">&quot;top_k&quot;</span>: <span class="hljs-number">0.0</span>,
    <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">1.0</span>,
    <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;pad_token_id&quot;</span>: tokenizer.eos_token_id,
    <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">20</span>,
}
response_tensor = ppo_trainer.generate([item <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> query_tensor], return_prompt=<span class="hljs-literal">False</span>, **generation_kwargs)
response_txt = tokenizer.decode(response_tensor[<span class="hljs-number">0</span>])

<span class="hljs-comment"># 5. define a reward for response</span>
<span class="hljs-comment"># (this could be any reward such as human feedback or output from another model)</span>
reward = [torch.tensor(<span class="hljs-number">1.0</span>, device=model.pretrained_model.device)]

<span class="hljs-comment"># 6. train model with ppo</span>
train_stats = ppo_trainer.step([query_tensor[<span class="hljs-number">0</span>]], [response_tensor[<span class="hljs-number">0</span>]], reward)`,wrap:!1}}),J=new D({props:{title:"How to use a trained model",local:"how-to-use-a-trained-model",headingTag:"h2"}}),j=new O({props:{code:"JTBBJTIzJTIwLi4lMjBMZXQncyUyMGFzc3VtZSUyMHdlJTIwaGF2ZSUyMGElMjB0cmFpbmVkJTIwbW9kZWwlMjB1c2luZyUyMCU2MFBQT1RyYWluZXIlNjAlMjBhbmQlMjAlNjBBdXRvTW9kZWxGb3JDYXVzYWxMTVdpdGhWYWx1ZUhlYWQlNjAlMEElMEElMjMlMjBwdXNoJTIwdGhlJTIwbW9kZWwlMjBvbiUyMHRoZSUyMEh1YiUwQW1vZGVsLnB1c2hfdG9faHViKCUyMm15LWZpbmUtdHVuZWQtbW9kZWwtcHBvJTIyKSUwQSUwQSUyMyUyMG9yJTIwc2F2ZSUyMGl0JTIwbG9jYWxseSUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJteS1maW5lLXR1bmVkLW1vZGVsLXBwbyUyMiklMEElMEElMjMlMjBsb2FkJTIwdGhlJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwSHViJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybXktZmluZS10dW5lZC1tb2RlbC1wcG8lMjIp",highlighted:`
<span class="hljs-comment"># .. Let&#x27;s assume we have a trained model using \`PPOTrainer\` and \`AutoModelForCausalLMWithValueHead\`</span>

<span class="hljs-comment"># push the model on the Hub</span>
model.push_to_hub(<span class="hljs-string">&quot;my-fine-tuned-model-ppo&quot;</span>)

<span class="hljs-comment"># or save it locally</span>
model.save_pretrained(<span class="hljs-string">&quot;my-fine-tuned-model-ppo&quot;</span>)

<span class="hljs-comment"># load the model from the Hub</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;my-fine-tuned-model-ppo&quot;</span>)`,wrap:!1}}),f=new O({props:{code:"ZnJvbSUyMHRybC5tb2RlbCUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkLmZyb21fcHJldHJhaW5lZCglMjJteS1maW5lLXR1bmVkLW1vZGVsLXBwbyUyMik=",highlighted:`<span class="hljs-keyword">from</span> trl.model <span class="hljs-keyword">import</span> AutoModelForCausalLMWithValueHead

model = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&quot;my-fine-tuned-model-ppo&quot;</span>)`,wrap:!1}}),{c(){r=o("meta"),V=a(),v=o("p"),_=a(),U(p.$$.fragment),G=a(),U(m.$$.fragment),Q=a(),M=o("p"),M.textContent=le,H=a(),c=o("ol"),c.innerHTML=te,E=a(),d=o("p"),d.textContent=se,R=a(),X=o("img"),$=a(),U(u.$$.fragment),F=a(),h=o("p"),h.textContent=ne,x=a(),U(w.$$.fragment),N=a(),y=o("p"),y.textContent=oe,q=a(),U(J.$$.fragment),z=a(),T=o("p"),T.innerHTML=ie,S=a(),U(j.$$.fragment),A=a(),b=o("p"),b.innerHTML=re,L=a(),U(f.$$.fragment),Y=a(),C=o("p"),this.h()},l(e){const l=we("svelte-u9bgzb",document.head);r=i(l,"META",{name:!0,content:!0}),l.forEach(t),V=n(e),v=i(e,"P",{}),pe(v).forEach(t),_=n(e),Z(p.$$.fragment,e),G=n(e),Z(m.$$.fragment,e),Q=n(e),M=i(e,"P",{"data-svelte-h":!0}),W(M)!=="svelte-79li59"&&(M.textContent=le),H=n(e),c=i(e,"OL",{"data-svelte-h":!0}),W(c)!=="svelte-1uekaot"&&(c.innerHTML=te),E=n(e),d=i(e,"P",{"data-svelte-h":!0}),W(d)!=="svelte-62xfzx"&&(d.textContent=se),R=n(e),X=i(e,"IMG",{src:!0}),$=n(e),Z(u.$$.fragment,e),F=n(e),h=i(e,"P",{"data-svelte-h":!0}),W(h)!=="svelte-11erqnm"&&(h.textContent=ne),x=n(e),Z(w.$$.fragment,e),N=n(e),y=i(e,"P",{"data-svelte-h":!0}),W(y)!=="svelte-1rp76uw"&&(y.textContent=oe),q=n(e),Z(J.$$.fragment,e),z=n(e),T=i(e,"P",{"data-svelte-h":!0}),W(T)!=="svelte-znbdcu"&&(T.innerHTML=ie),S=n(e),Z(j.$$.fragment,e),A=n(e),b=i(e,"P",{"data-svelte-h":!0}),W(b)!=="svelte-12cg6c8"&&(b.innerHTML=re),L=n(e),Z(f.$$.fragment,e),Y=n(e),C=i(e,"P",{}),pe(C).forEach(t),this.h()},h(){K(r,"name","hf:doc:metadata"),K(r,"content",Te),Me(X.src,ae="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl_overview.png")||K(X,"src",ae)},m(e,l){ye(document.head,r),s(e,V,l),s(e,v,l),s(e,_,l),B(p,e,l),s(e,G,l),B(m,e,l),s(e,Q,l),s(e,M,l),s(e,H,l),s(e,c,l),s(e,E,l),s(e,d,l),s(e,R,l),s(e,X,l),s(e,$,l),B(u,e,l),s(e,F,l),s(e,h,l),s(e,x,l),B(w,e,l),s(e,N,l),s(e,y,l),s(e,q,l),B(J,e,l),s(e,z,l),s(e,T,l),s(e,S,l),B(j,e,l),s(e,A,l),s(e,b,l),s(e,L,l),B(f,e,l),s(e,Y,l),s(e,C,l),P=!0},p:ce,i(e){P||(g(p.$$.fragment,e),g(m.$$.fragment,e),g(u.$$.fragment,e),g(w.$$.fragment,e),g(J.$$.fragment,e),g(j.$$.fragment,e),g(f.$$.fragment,e),P=!0)},o(e){I(p.$$.fragment,e),I(m.$$.fragment,e),I(u.$$.fragment,e),I(w.$$.fragment,e),I(J.$$.fragment,e),I(j.$$.fragment,e),I(f.$$.fragment,e),P=!1},d(e){e&&(t(V),t(v),t(_),t(G),t(Q),t(M),t(H),t(c),t(E),t(d),t(R),t(X),t($),t(F),t(h),t(x),t(N),t(y),t(q),t(z),t(T),t(S),t(A),t(b),t(L),t(Y),t(C)),t(r),k(p,e),k(m,e),k(u,e),k(w,e),k(J,e),k(j,e),k(f,e)}}}const Te='{"title":"Quickstart","local":"quickstart","sections":[{"title":"How does it work?","local":"how-does-it-work","sections":[],"depth":2},{"title":"Minimal example","local":"minimal-example","sections":[],"depth":2},{"title":"How to use a trained model","local":"how-to-use-a-trained-model","sections":[],"depth":2}],"depth":1}';function je(ee){return de(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class We extends ue{constructor(r){super(),he(this,r,je,Je,me,{})}}export{We as component};
