import{s as jt,o as Jt,n as Ut}from"../chunks/scheduler.182ea377.js";import{S as Zt,i as Dt,g as a,s,r as g,A as Wt,h as r,f as n,c as o,j as L,u,x as m,k as $,y as t,a as l,v as h,d as _,t as v,w as b}from"../chunks/index.abf12888.js";import{T as Et}from"../chunks/Tip.230e2334.js";import{D as P}from"../chunks/Docstring.93f6f462.js";import{C as Ht}from"../chunks/CodeBlock.57fe6e13.js";import{E as St}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as ze}from"../chunks/Heading.16916d63.js";function zt(ae){let d,V='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines. Also, to know more about reducing the memory usage of this pipeline, refer to the [“Reduce memory usage”] section <a href="../../using-diffusers/svd#reduce-memory-usage">here</a>.';return{c(){d=a("p"),d.innerHTML=V},l(x){d=r(x,"P",{"data-svelte-h":!0}),m(d)!=="svelte-12x7hfk"&&(d.innerHTML=V)},m(x,y){l(x,d,y)},p:Ut,d(x){x&&n(d)}}}function At(ae){let d,V="Examples:",x,y,w;return y=new Ht({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwSTJWR2VuWExQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fZ2lmJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwSTJWR2VuWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyYWxpLXZpbGFiJTJGaTJ2Z2VuLXhsJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFpbWFnZV91cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZkaWZmdXNlcnMlMkZkb2NzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGaTJ2Z2VuX3hsX2ltYWdlcyUyRmltZ18wMDA5LnBuZyUyMiUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWFnZV91cmwpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMlBhcGVycyUyMHdlcmUlMjBmbG9hdGluZyUyMGluJTIwdGhlJTIwYWlyJTIwb24lMjBhJTIwdGFibGUlMjBpbiUyMHRoZSUyMGxpYnJhcnklMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJEaXN0b3J0ZWQlMkMlMjBkaXNjb250aW51b3VzJTJDJTIwVWdseSUyQyUyMGJsdXJyeSUyQyUyMGxvdyUyMHJlc29sdXRpb24lMkMlMjBtb3Rpb25sZXNzJTJDJTIwc3RhdGljJTJDJTIwZGlzZmlndXJlZCUyQyUyMGRpc2Nvbm5lY3RlZCUyMGxpbWJzJTJDJTIwVWdseSUyMGZhY2VzJTJDJTIwaW5jb21wbGV0ZSUyMGFybXMlMjIlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCg4ODg4KSUwQSUwQWZyYW1lcyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDkuMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUwQSkuZnJhbWVzJTVCMCU1RCUwQXZpZGVvX3BhdGglMjAlM0QlMjBleHBvcnRfdG9fZ2lmKGZyYW1lcyUyQyUyMCUyMmkydi5naWYlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> I2VGenXLPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif, load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = I2VGenXLPipeline.from_pretrained(<span class="hljs-string">&quot;ali-vilab/i2vgen-xl&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span>image_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/docs-images/resolve/main/i2vgen_xl_images/img_0009.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(image_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Papers were floating in the air on a table in the library&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;Distorted, discontinuous, Ugly, blurry, low resolution, motionless, static, disfigured, disconnected limbs, Ugly faces, incomplete arms&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.manual_seed(<span class="hljs-number">8888</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>frames = pipeline(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">9.0</span>,
<span class="hljs-meta">... </span>    generator=generator
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = export_to_gif(frames, <span class="hljs-string">&quot;i2v.gif&quot;</span>)`,wrap:!1}}),{c(){d=a("p"),d.textContent=V,x=s(),g(y.$$.fragment)},l(f){d=r(f,"P",{"data-svelte-h":!0}),m(d)!=="svelte-kvfsh7"&&(d.textContent=V),x=o(f),u(y.$$.fragment,f)},m(f,M){l(f,d,M),l(f,x,M),h(y,f,M),w=!0},p:Ut,i(f){w||(_(y.$$.fragment,f),w=!0)},o(f){v(y.$$.fragment,f),w=!1},d(f){f&&(n(d),n(x)),b(y,f)}}}function Nt(ae){let d,V,x,y,w,f,M,ft='<a href="https://hf.co/papers/2311.04145.pdf" rel="nofollow">I2VGen-XL: High-Quality Image-to-Video Synthesis via Cascaded Diffusion Models</a> by Shiwei Zhang, Jiayu Wang, Yingya Zhang, Kang Zhao, Hangjie Yuan, Zhiwu Qin, Xiang Wang, Deli Zhao, and Jingren Zhou.',Ie,H,gt="The abstract from the paper is:",Le,S,ut='<em>Video synthesis has recently made remarkable strides benefiting from the rapid development of diffusion models. However, it still encounters challenges in terms of semantic accuracy, clarity and spatio-temporal continuity. They primarily arise from the scarcity of well-aligned text-video data and the complex inherent structure of videos, making it difficult for the model to simultaneously ensure semantic and qualitative excellence. In this report, we propose a cascaded I2VGen-XL approach that enhances model performance by decoupling these two factors and ensures the alignment of the input data by utilizing static images as a form of crucial guidance. I2VGen-XL consists of two stages: i) the base stage guarantees coherent semantics and preserves content from input images by using two hierarchical encoders, and ii) the refinement stage enhances the video’s details by incorporating an additional brief text and improves the resolution to 1280×720. To improve the diversity, we collect around 35 million single-shot text-video pairs and 6 billion text-image pairs to optimize the model. By this means, I2VGen-XL can simultaneously enhance the semantic accuracy, continuity of details and clarity of generated videos. Through extensive experiments, we have investigated the underlying principles of I2VGen-XL and compared it with current top methods, which can demonstrate its effectiveness on diverse data. The source code and models will be publicly available at <a href="https://i2vgen-xl.github.io/" rel="nofollow">this https URL</a>.</em>',$e,z,ht='The original codebase can be found <a href="https://github.com/ali-vilab/i2vgen-xl/" rel="nofollow">here</a>. The model checkpoints can be found <a href="https://huggingface.co/ali-vilab/" rel="nofollow">here</a>.',Me,C,Ge,A,_t="Sample output with I2VGenXL:",Ve,N,vt=`<tbody><tr><td><center>library.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/i2vgen-xl-example.gif" alt="library" style="width: 300px;"/></center></td></tr></tbody>`,Te,B,Pe,Q,bt='<li>I2VGenXL always uses a <code>clip_skip</code> value of 1. This means it leverages the penultimate layer representations from the text encoder of CLIP.</li> <li>It can generate videos of quality that is often on par with <a href="../../using-diffusers/svd">Stable Video Diffusion</a> (SVD).</li> <li>Unlike SVD, it additionally accepts text prompts as inputs.</li> <li>It can generate higher resolution videos.</li> <li>When using the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a> (which is default for this pipeline), less than 50 steps for inference leads to bad results.</li>',Xe,R,Ce,p,F,Ae,re,xt='Pipeline for image-to-video generation as proposed in <a href="https://i2vgen-xl.github.io/" rel="nofollow">I2VGenXL</a>.',Ne,le,yt=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Be,T,O,Qe,pe,wt='The call function to the pipeline for image-to-video generation with <a href="/docs/diffusers/main/en/api/pipelines/i2vgenxl#diffusers.I2VGenXLPipeline">I2VGenXLPipeline</a>.',Re,k,Fe,U,Y,Oe,de,It="Disables the FreeU mechanism if enabled.",Ye,j,q,qe,ce,Lt=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ke,J,K,et,me,$t=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,tt,I,ee,nt,fe,Mt='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',it,ge,Gt="The suffixes after the scaling factors represent the stages where they are being applied.",st,ue,Vt=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,ot,Z,te,at,he,Tt=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,rt,D,ne,lt,_e,Pt=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,pt,W,ie,dt,ve,Xt="Encodes the prompt into text encoder hidden states.",ke,se,Ue,G,oe,ct,be,Ct="Output class for image-to-video pipeline.",mt,xe,kt=`PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>`,je,we,Je;return w=new ze({props:{title:"I2VGen-XL",local:"i2vgen-xl",headingTag:"h1"}}),C=new Et({props:{$$slots:{default:[zt]},$$scope:{ctx:ae}}}),B=new ze({props:{title:"Notes",local:"notes",headingTag:"h2"}}),R=new ze({props:{title:"I2VGenXLPipeline",local:"diffusers.I2VGenXLPipeline",headingTag:"h2"}}),F=new P({props:{name:"class diffusers.I2VGenXLPipeline",anchor:"diffusers.I2VGenXLPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"unet",val:": I2VGenXLUNet"},{name:"scheduler",val:": DDIMScheduler"}],parametersDescription:[{anchor:"diffusers.I2VGenXLPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.I2VGenXLPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.I2VGenXLPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.I2VGenXLPipeline.unet",description:`<strong>unet</strong> (<code>I2VGenXLUNet</code>) &#x2014;
A <code>I2VGenXLUNet</code> to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.I2VGenXLPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L106"}}),O=new P({props:{name:"__call__",anchor:"diffusers.I2VGenXLPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"image",val:": Union = None"},{name:"height",val:": Optional = 704"},{name:"width",val:": Optional = 1280"},{name:"target_fps",val:": Optional = 16"},{name:"num_frames",val:": int = 16"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 9.0"},{name:"negative_prompt",val:": Union = None"},{name:"eta",val:": float = 0.0"},{name:"num_videos_per_prompt",val:": Optional = 1"},{name:"decode_chunk_size",val:": Optional = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = 1"}],parametersDescription:[{anchor:"diffusers.I2VGenXLPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.I2VGenXLPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code> or <code>List[PIL.Image.Image]</code> or <code>torch.FloatTensor</code>) &#x2014;
Image or images to guide image generation. If you provide a tensor, it needs to be compatible with
<a href="https://huggingface.co/lambdalabs/sd-image-variations-diffusers/blob/main/feature_extractor/preprocessor_config.json" rel="nofollow"><code>CLIPImageProcessor</code></a>.`,name:"image"},{anchor:"diffusers.I2VGenXLPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.I2VGenXLPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.I2VGenXLPipeline.__call__.target_fps",description:`<strong>target_fps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Frames per second. The rate at which the generated images shall be exported to a video after generation. This is also used as a &#x201C;micro-condition&#x201D; while generation.`,name:"target_fps"},{anchor:"diffusers.I2VGenXLPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of video frames to generate.`,name:"num_frames"},{anchor:"diffusers.I2VGenXLPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps.`,name:"num_inference_steps"},{anchor:"diffusers.I2VGenXLPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.I2VGenXLPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.I2VGenXLPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.I2VGenXLPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.I2VGenXLPipeline.__call__.decode_chunk_size",description:`<strong>decode_chunk_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of frames to decode at a time. The higher the chunk size, the higher the temporal consistency
between frames, but also the higher the memory consumption. By default, the decoder will decode all frames at once
for maximal quality. Reduce <code>decode_chunk_size</code> to reduce memory usage.`,name:"decode_chunk_size"},{anchor:"diffusers.I2VGenXLPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.I2VGenXLPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.I2VGenXLPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.I2VGenXLPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.I2VGenXLPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.I2VGenXLPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.I2VGenXLPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.I2VGenXLPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L573",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/i2vgenxl#diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput"
>pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/i2vgenxl#diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput"
>pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput</a> or <code>tuple</code></p>
`}}),k=new St({props:{anchor:"diffusers.I2VGenXLPipeline.__call__.example",$$slots:{default:[At]},$$scope:{ctx:ae}}}),Y=new P({props:{name:"disable_freeu",anchor:"diffusers.I2VGenXLPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L569"}}),q=new P({props:{name:"disable_vae_slicing",anchor:"diffusers.I2VGenXLPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L173"}}),K=new P({props:{name:"disable_vae_tiling",anchor:"diffusers.I2VGenXLPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L190"}}),ee=new P({props:{name:"enable_freeu",anchor:"diffusers.I2VGenXLPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.I2VGenXLPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.I2VGenXLPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.I2VGenXLPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.I2VGenXLPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L546"}}),te=new P({props:{name:"enable_vae_slicing",anchor:"diffusers.I2VGenXLPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L165"}}),ne=new P({props:{name:"enable_vae_tiling",anchor:"diffusers.I2VGenXLPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L181"}}),ie=new P({props:{name:"encode_prompt",anchor:"diffusers.I2VGenXLPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_videos_per_prompt",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_videos_per_prompt"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L197"}}),se=new ze({props:{title:"I2VGenXLPipelineOutput",local:"diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput",headingTag:"h2"}}),oe=new P({props:{name:"class diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput",anchor:"diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput",parameters:[{name:"frames",val:": Union"}],parametersDescription:[{anchor:"diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing denoised`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L91"}}),{c(){d=a("meta"),V=s(),x=a("p"),y=s(),g(w.$$.fragment),f=s(),M=a("p"),M.innerHTML=ft,Ie=s(),H=a("p"),H.textContent=gt,Le=s(),S=a("p"),S.innerHTML=ut,$e=s(),z=a("p"),z.innerHTML=ht,Me=s(),g(C.$$.fragment),Ge=s(),A=a("p"),A.textContent=_t,Ve=s(),N=a("table"),N.innerHTML=vt,Te=s(),g(B.$$.fragment),Pe=s(),Q=a("ul"),Q.innerHTML=bt,Xe=s(),g(R.$$.fragment),Ce=s(),p=a("div"),g(F.$$.fragment),Ae=s(),re=a("p"),re.innerHTML=xt,Ne=s(),le=a("p"),le.innerHTML=yt,Be=s(),T=a("div"),g(O.$$.fragment),Qe=s(),pe=a("p"),pe.innerHTML=wt,Re=s(),g(k.$$.fragment),Fe=s(),U=a("div"),g(Y.$$.fragment),Oe=s(),de=a("p"),de.textContent=It,Ye=s(),j=a("div"),g(q.$$.fragment),qe=s(),ce=a("p"),ce.innerHTML=Lt,Ke=s(),J=a("div"),g(K.$$.fragment),et=s(),me=a("p"),me.innerHTML=$t,tt=s(),I=a("div"),g(ee.$$.fragment),nt=s(),fe=a("p"),fe.innerHTML=Mt,it=s(),ge=a("p"),ge.textContent=Gt,st=s(),ue=a("p"),ue.innerHTML=Vt,ot=s(),Z=a("div"),g(te.$$.fragment),at=s(),he=a("p"),he.textContent=Tt,rt=s(),D=a("div"),g(ne.$$.fragment),lt=s(),_e=a("p"),_e.textContent=Pt,pt=s(),W=a("div"),g(ie.$$.fragment),dt=s(),ve=a("p"),ve.textContent=Xt,ke=s(),g(se.$$.fragment),Ue=s(),G=a("div"),g(oe.$$.fragment),ct=s(),be=a("p"),be.textContent=Ct,mt=s(),xe=a("p"),xe.innerHTML=kt,je=s(),we=a("p"),this.h()},l(e){const i=Wt("svelte-u9bgzb",document.head);d=r(i,"META",{name:!0,content:!0}),i.forEach(n),V=o(e),x=r(e,"P",{}),L(x).forEach(n),y=o(e),u(w.$$.fragment,e),f=o(e),M=r(e,"P",{"data-svelte-h":!0}),m(M)!=="svelte-1wrjkyv"&&(M.innerHTML=ft),Ie=o(e),H=r(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1cwsb16"&&(H.textContent=gt),Le=o(e),S=r(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-uj6rwn"&&(S.innerHTML=ut),$e=o(e),z=r(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1okzf4k"&&(z.innerHTML=ht),Me=o(e),u(C.$$.fragment,e),Ge=o(e),A=r(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-e24chm"&&(A.textContent=_t),Ve=o(e),N=r(e,"TABLE",{"data-svelte-h":!0}),m(N)!=="svelte-1d0ljr7"&&(N.innerHTML=vt),Te=o(e),u(B.$$.fragment,e),Pe=o(e),Q=r(e,"UL",{"data-svelte-h":!0}),m(Q)!=="svelte-1h7r1o4"&&(Q.innerHTML=bt),Xe=o(e),u(R.$$.fragment,e),Ce=o(e),p=r(e,"DIV",{class:!0});var c=L(p);u(F.$$.fragment,c),Ae=o(c),re=r(c,"P",{"data-svelte-h":!0}),m(re)!=="svelte-va7c9e"&&(re.innerHTML=xt),Ne=o(c),le=r(c,"P",{"data-svelte-h":!0}),m(le)!=="svelte-496sm0"&&(le.innerHTML=yt),Be=o(c),T=r(c,"DIV",{class:!0});var X=L(T);u(O.$$.fragment,X),Qe=o(X),pe=r(X,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-wf4rrn"&&(pe.innerHTML=wt),Re=o(X),u(k.$$.fragment,X),X.forEach(n),Fe=o(c),U=r(c,"DIV",{class:!0});var Ze=L(U);u(Y.$$.fragment,Ze),Oe=o(Ze),de=r(Ze,"P",{"data-svelte-h":!0}),m(de)!=="svelte-psupw6"&&(de.textContent=It),Ze.forEach(n),Ye=o(c),j=r(c,"DIV",{class:!0});var De=L(j);u(q.$$.fragment,De),qe=o(De),ce=r(De,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-1s3c06i"&&(ce.innerHTML=Lt),De.forEach(n),Ke=o(c),J=r(c,"DIV",{class:!0});var We=L(J);u(K.$$.fragment,We),et=o(We),me=r(We,"P",{"data-svelte-h":!0}),m(me)!=="svelte-pkn4ui"&&(me.innerHTML=$t),We.forEach(n),tt=o(c),I=r(c,"DIV",{class:!0});var E=L(I);u(ee.$$.fragment,E),nt=o(E),fe=r(E,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-1f3tmq1"&&(fe.innerHTML=Mt),it=o(E),ge=r(E,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-xjijlp"&&(ge.textContent=Gt),st=o(E),ue=r(E,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-hy0nzs"&&(ue.innerHTML=Vt),E.forEach(n),ot=o(c),Z=r(c,"DIV",{class:!0});var Ee=L(Z);u(te.$$.fragment,Ee),at=o(Ee),he=r(Ee,"P",{"data-svelte-h":!0}),m(he)!=="svelte-14bnrb6"&&(he.textContent=Tt),Ee.forEach(n),rt=o(c),D=r(c,"DIV",{class:!0});var He=L(D);u(ne.$$.fragment,He),lt=o(He),_e=r(He,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-1xwrf7t"&&(_e.textContent=Pt),He.forEach(n),pt=o(c),W=r(c,"DIV",{class:!0});var Se=L(W);u(ie.$$.fragment,Se),dt=o(Se),ve=r(Se,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-16q0ax1"&&(ve.textContent=Xt),Se.forEach(n),c.forEach(n),ke=o(e),u(se.$$.fragment,e),Ue=o(e),G=r(e,"DIV",{class:!0});var ye=L(G);u(oe.$$.fragment,ye),ct=o(ye),be=r(ye,"P",{"data-svelte-h":!0}),m(be)!=="svelte-ulnuw9"&&(be.textContent=Ct),mt=o(ye),xe=r(ye,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-gk6g69"&&(xe.innerHTML=kt),ye.forEach(n),je=o(e),we=r(e,"P",{}),L(we).forEach(n),this.h()},h(){$(d,"name","hf:doc:metadata"),$(d,"content",Bt),$(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,d),l(e,V,i),l(e,x,i),l(e,y,i),h(w,e,i),l(e,f,i),l(e,M,i),l(e,Ie,i),l(e,H,i),l(e,Le,i),l(e,S,i),l(e,$e,i),l(e,z,i),l(e,Me,i),h(C,e,i),l(e,Ge,i),l(e,A,i),l(e,Ve,i),l(e,N,i),l(e,Te,i),h(B,e,i),l(e,Pe,i),l(e,Q,i),l(e,Xe,i),h(R,e,i),l(e,Ce,i),l(e,p,i),h(F,p,null),t(p,Ae),t(p,re),t(p,Ne),t(p,le),t(p,Be),t(p,T),h(O,T,null),t(T,Qe),t(T,pe),t(T,Re),h(k,T,null),t(p,Fe),t(p,U),h(Y,U,null),t(U,Oe),t(U,de),t(p,Ye),t(p,j),h(q,j,null),t(j,qe),t(j,ce),t(p,Ke),t(p,J),h(K,J,null),t(J,et),t(J,me),t(p,tt),t(p,I),h(ee,I,null),t(I,nt),t(I,fe),t(I,it),t(I,ge),t(I,st),t(I,ue),t(p,ot),t(p,Z),h(te,Z,null),t(Z,at),t(Z,he),t(p,rt),t(p,D),h(ne,D,null),t(D,lt),t(D,_e),t(p,pt),t(p,W),h(ie,W,null),t(W,dt),t(W,ve),l(e,ke,i),h(se,e,i),l(e,Ue,i),l(e,G,i),h(oe,G,null),t(G,ct),t(G,be),t(G,mt),t(G,xe),l(e,je,i),l(e,we,i),Je=!0},p(e,[i]){const c={};i&2&&(c.$$scope={dirty:i,ctx:e}),C.$set(c);const X={};i&2&&(X.$$scope={dirty:i,ctx:e}),k.$set(X)},i(e){Je||(_(w.$$.fragment,e),_(C.$$.fragment,e),_(B.$$.fragment,e),_(R.$$.fragment,e),_(F.$$.fragment,e),_(O.$$.fragment,e),_(k.$$.fragment,e),_(Y.$$.fragment,e),_(q.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(ne.$$.fragment,e),_(ie.$$.fragment,e),_(se.$$.fragment,e),_(oe.$$.fragment,e),Je=!0)},o(e){v(w.$$.fragment,e),v(C.$$.fragment,e),v(B.$$.fragment,e),v(R.$$.fragment,e),v(F.$$.fragment,e),v(O.$$.fragment,e),v(k.$$.fragment,e),v(Y.$$.fragment,e),v(q.$$.fragment,e),v(K.$$.fragment,e),v(ee.$$.fragment,e),v(te.$$.fragment,e),v(ne.$$.fragment,e),v(ie.$$.fragment,e),v(se.$$.fragment,e),v(oe.$$.fragment,e),Je=!1},d(e){e&&(n(V),n(x),n(y),n(f),n(M),n(Ie),n(H),n(Le),n(S),n($e),n(z),n(Me),n(Ge),n(A),n(Ve),n(N),n(Te),n(Pe),n(Q),n(Xe),n(Ce),n(p),n(ke),n(Ue),n(G),n(je),n(we)),n(d),b(w,e),b(C,e),b(B,e),b(R,e),b(F),b(O),b(k),b(Y),b(q),b(K),b(ee),b(te),b(ne),b(ie),b(se,e),b(oe)}}}const Bt='{"title":"I2VGen-XL","local":"i2vgen-xl","sections":[{"title":"Notes","local":"notes","sections":[],"depth":2},{"title":"I2VGenXLPipeline","local":"diffusers.I2VGenXLPipeline","sections":[],"depth":2},{"title":"I2VGenXLPipelineOutput","local":"diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput","sections":[],"depth":2}],"depth":1}';function Qt(ae){return Jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tn extends Zt{constructor(d){super(),Dt(this,d,Qt,Nt,jt,{})}}export{tn as component};
