import{s as xe,o as Ee}from"../chunks/scheduler.6062bdaf.js";import{S as Pe,i as Fe,g as c,s as a,r as o,A as ze,h as f,f as s,c as n,j as Le,u as r,x as y,k as qe,y as Ae,a as l,v as m,d as p,t as i,w as d,m as Ke,n as De}from"../chunks/index.4bca734e.js";import{T as Oe}from"../chunks/Tip.b9ac1f03.js";import{C as w}from"../chunks/CodeBlock.fa01571c.js";import{H as z}from"../chunks/Heading.723dceba.js";function et(K){let u;return{c(){u=Ke("Sometimes you can directly load your model on your GPU devices using `accelerate` library, therefore you can optionally try out the following command:")},l(b){u=De(b,"Sometimes you can directly load your model on your GPU devices using `accelerate` library, therefore you can optionally try out the following command:")},m(b,g){l(b,u,g)},d(b){b&&s(u)}}}function tt(K){let u,b,g,D,$,O,T,ee,M,ke="You can easily use the <code>BetterTransformer</code> integration with 🤗 Optimum, first install the dependencies as follows:",te,J,se,v,Be=`Also, make sure to install the latest version of PyTorch by following the guidelines on the <a href="https://pytorch.org/get-started/locally/" rel="nofollow">PyTorch official website</a>. Note that <code>BetterTransformer</code> API is only compatible with <code>torch&gt;=1.13</code>, so make sure to have this version installed on your environement before starting.
If you want to benefit from the <code>scaled_dot_product_attention</code> function (for decoder-based models), make sure to use at least <code>torch&gt;=2.0</code>.`,le,j,ae,Z,We="First, load your Hugging Face model using 🤗 Transformers. Make sure to download one of the models that is supported by the <code>BetterTransformer</code> API:",ne,U,oe,h,re,G,me,I,pe,k,Ve="If you did not used <code>device_map=&quot;auto&quot;</code> to load your model (or if your model does not support <code>device_map=&quot;auto&quot;</code>), you can manually set your model to a GPU:",ie,B,de,W,ce,V,Xe="Now time to convert your model using <code>BetterTransformer</code> API! You can run the commands below:",fe,X,ue,C,Ce="By default, <code>BetterTransformer.transform</code> will overwrite your model, which means that your previous native model cannot be used anymore. If you want to keep it for some reasons, just add the flag <code>keep_original_model=True</code>!",ye,_,be,H,_e="If your model does not support the <code>BetterTransformer</code> API, this will be displayed on an error trace. Note also that decoder-based models (OPT, BLOOM, etc.) are not supported yet but this is in the roadmap of PyTorch for the future.",we,R,he,S,He='<a href="https://huggingface.co/docs/transformers/main_classes/pipelines" rel="nofollow">Transformer’s pipeline</a> is also compatible with this integration and you can use <code>BetterTransformer</code> as an accelerator for your pipelines. The code snippet below shows how:',ge,Y,$e,N,Re="If you want to run a pipeline on a GPU device, run:",Te,Q,Me,L,Se="You can also use <code>transformers.pipeline</code> as usual and pass the converted model directly:",Je,q,ve,x,Ye='Please refer to the <a href="https://huggingface.co/docs/transformers/main_classes/pipelines" rel="nofollow">official documentation of <code>pipeline</code></a> for further usage. If you face into any issue, do not hesitate to open an isse on GitHub!',je,E,Ze,P,Ne=`You can now benefit from the <code>BetterTransformer</code> API for your training scripts. Just make sure to convert back your model to its original version by calling <code>BetterTransformer.reverse</code> before saving your model.
The code snippet below shows how:`,Ue,F,Ge,A,Ie;return $=new z({props:{title:"How to use optimum and BetterTransformer ?",local:"how-to-use-optimum-and-bettertransformer-",headingTag:"h1"}}),T=new z({props:{title:"Install dependencies",local:"install-dependencies",headingTag:"h2"}}),J=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGFjY2VsZXJhdGUlMjBvcHRpbXVt",highlighted:"pip install transformers accelerate optimum",wrap:!1}}),j=new z({props:{title:"Step 1: Load your model",local:"step-1-load-your-model",headingTag:"h2"}}),U=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIycm9iZXJ0YS1iYXNlJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;roberta-base&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(model_id)`,wrap:!1}}),h=new Oe({props:{$$slots:{default:[et]},$$scope:{ctx:K}}}),G=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIycm9iZXJ0YS1iYXNlJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;roberta-base&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),I=new z({props:{title:"Step 2: Set your model on your preferred device",local:"step-2-set-your-model-on-your-preferred-device",headingTag:"h2"}}),B=new w({props:{code:"bW9kZWwlMjAlM0QlMjBtb2RlbC50bygwKSUyMCUyMyUyMG9yJTIwbW9kZWwudG8oJTIyY3VkYSUzQTAlMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = model.to(<span class="hljs-number">0</span>) <span class="hljs-comment"># or model.to(&quot;cuda:0&quot;)</span>',wrap:!1}}),W=new z({props:{title:"Step 3: Convert your model to BetterTransformer!",local:"step-3-convert-your-model-to-bettertransformer",headingTag:"h2"}}),X=new w({props:{code:"ZnJvbSUyMG9wdGltdW0uYmV0dGVydHJhbnNmb3JtZXIlMjBpbXBvcnQlMjBCZXR0ZXJUcmFuc2Zvcm1lciUwQSUwQW1vZGVsJTIwJTNEJTIwQmV0dGVyVHJhbnNmb3JtZXIudHJhbnNmb3JtKG1vZGVsKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.bettertransformer <span class="hljs-keyword">import</span> BetterTransformer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = BetterTransformer.transform(model)`,wrap:!1}}),_=new w({props:{code:"ZnJvbSUyMG9wdGltdW0uYmV0dGVydHJhbnNmb3JtZXIlMjBpbXBvcnQlMjBCZXR0ZXJUcmFuc2Zvcm1lciUwQSUwQW1vZGVsX2J0JTIwJTNEJTIwQmV0dGVyVHJhbnNmb3JtZXIudHJhbnNmb3JtKG1vZGVsJTJDJTIwa2VlcF9vcmlnaW5hbF9tb2RlbCUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.bettertransformer <span class="hljs-keyword">import</span> BetterTransformer

<span class="hljs-meta">&gt;&gt;&gt; </span>model_bt = BetterTransformer.transform(model, keep_original_model=<span class="hljs-literal">True</span>)`,wrap:!1}}),R=new z({props:{title:"Pipeline compatibility",local:"pipeline-compatibility",headingTag:"h2"}}),Y=new w({props:{code:"ZnJvbSUyMG9wdGltdW0ucGlwZWxpbmVzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTIyZmlsbC1tYXNrJTIyJTJDJTIwJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQlMjIlMkMlMjBhY2NlbGVyYXRvciUzRCUyMmJldHRlcnRyYW5zZm9ybWVyJTIyKSUwQXBpcGUoJTIySSUyMGFtJTIwYSUyMHN0dWRlbnQlMjBhdCUyMCU1Qk1BU0slNUQlMjBVbml2ZXJzaXR5LiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.pipelines <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;fill-mask&quot;</span>, <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>, accelerator=<span class="hljs-string">&quot;bettertransformer&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;I am a student at [MASK] University.&quot;</span>)`,wrap:!1}}),Q=new w({props:{code:"ZnJvbSUyMG9wdGltdW0ucGlwZWxpbmVzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTIyZmlsbC1tYXNrJTIyJTJDJTIwJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQlMjIlMkMlMjBhY2NlbGVyYXRvciUzRCUyMmJldHRlcnRyYW5zZm9ybWVyJTIyJTJDJTIwZGV2aWNlJTNEMCklMEEuLi4=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.pipelines <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;fill-mask&quot;</span>, <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>, accelerator=<span class="hljs-string">&quot;bettertransformer&quot;</span>, device=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>...`,wrap:!1}}),q=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmZpbGwtbWFzayUyMiUyQyUyMG1vZGVsJTNEbW9kZWxfYnQlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjBkZXZpY2UlM0QwKSUwQS4uLg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;fill-mask&quot;</span>, model=model_bt, tokenizer=tokenizer, device=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>...`,wrap:!1}}),E=new z({props:{title:"Training compatibility",local:"training-compatibility",headingTag:"h2"}}),F=new w({props:{code:"ZnJvbSUyMG9wdGltdW0uYmV0dGVydHJhbnNmb3JtZXIlMjBpbXBvcnQlMjBCZXR0ZXJUcmFuc2Zvcm1lciUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXdpdGglMjB0b3JjaC5kZXZpY2UoJUUyJTgwJTlDY3VkYSVFMiU4MCU5RCklM0ElMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglRTIlODAlOUNncHQyLWxhcmdlJUUyJTgwJTlEJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQW1vZGVsJTIwJTNEJTIwQmV0dGVyVHJhbnNmb3JtZXIudHJhbnNmb3JtKG1vZGVsKSUwQSUwQSUyMyUyMGRvJTIweW91ciUyMGluZmVyZW5jZSUyMG9yJTIwdHJhaW5pbmclMjBoZXJlJTBBJTBBJTIzJTIwaWYlMjB0cmFpbmluZyUyMGFuZCUyMHdhbnQlMjB0byUyMHNhdmUlMjB0aGUlMjBtb2RlbCUwQW1vZGVsJTIwJTNEJTIwQmV0dGVyVHJhbnNmb3JtZXIucmV2ZXJzZShtb2RlbCklMEFtb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIyZmluZV90dW5lZF9tb2RlbCUyMiklMEFtb2RlbC5wdXNoX3RvX2h1YiglMjJmaW5lX3R1bmVkX21vZGVsJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.bettertransformer <span class="hljs-keyword">import</span> BetterTransformer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-keyword">with</span> torch.device(“cuda”):
    model = AutoModelForCausalLM.from_pretrained(“gpt2-large”, torch_dtype=torch.float16)

model = BetterTransformer.transform(model)

<span class="hljs-comment"># do your inference or training here</span>

<span class="hljs-comment"># if training and want to save the model</span>
model = BetterTransformer.reverse(model)
model.save_pretrained(<span class="hljs-string">&quot;fine_tuned_model&quot;</span>)
model.push_to_hub(<span class="hljs-string">&quot;fine_tuned_model&quot;</span>)`,wrap:!1}}),{c(){u=c("meta"),b=a(),g=c("p"),D=a(),o($.$$.fragment),O=a(),o(T.$$.fragment),ee=a(),M=c("p"),M.innerHTML=ke,te=a(),o(J.$$.fragment),se=a(),v=c("p"),v.innerHTML=Be,le=a(),o(j.$$.fragment),ae=a(),Z=c("p"),Z.innerHTML=We,ne=a(),o(U.$$.fragment),oe=a(),o(h.$$.fragment),re=a(),o(G.$$.fragment),me=a(),o(I.$$.fragment),pe=a(),k=c("p"),k.innerHTML=Ve,ie=a(),o(B.$$.fragment),de=a(),o(W.$$.fragment),ce=a(),V=c("p"),V.innerHTML=Xe,fe=a(),o(X.$$.fragment),ue=a(),C=c("p"),C.innerHTML=Ce,ye=a(),o(_.$$.fragment),be=a(),H=c("p"),H.innerHTML=_e,we=a(),o(R.$$.fragment),he=a(),S=c("p"),S.innerHTML=He,ge=a(),o(Y.$$.fragment),$e=a(),N=c("p"),N.textContent=Re,Te=a(),o(Q.$$.fragment),Me=a(),L=c("p"),L.innerHTML=Se,Je=a(),o(q.$$.fragment),ve=a(),x=c("p"),x.innerHTML=Ye,je=a(),o(E.$$.fragment),Ze=a(),P=c("p"),P.innerHTML=Ne,Ue=a(),o(F.$$.fragment),Ge=a(),A=c("p"),this.h()},l(e){const t=ze("svelte-u9bgzb",document.head);u=f(t,"META",{name:!0,content:!0}),t.forEach(s),b=n(e),g=f(e,"P",{}),Le(g).forEach(s),D=n(e),r($.$$.fragment,e),O=n(e),r(T.$$.fragment,e),ee=n(e),M=f(e,"P",{"data-svelte-h":!0}),y(M)!=="svelte-ru6tm1"&&(M.innerHTML=ke),te=n(e),r(J.$$.fragment,e),se=n(e),v=f(e,"P",{"data-svelte-h":!0}),y(v)!=="svelte-145xob6"&&(v.innerHTML=Be),le=n(e),r(j.$$.fragment,e),ae=n(e),Z=f(e,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-xrdjj2"&&(Z.innerHTML=We),ne=n(e),r(U.$$.fragment,e),oe=n(e),r(h.$$.fragment,e),re=n(e),r(G.$$.fragment,e),me=n(e),r(I.$$.fragment,e),pe=n(e),k=f(e,"P",{"data-svelte-h":!0}),y(k)!=="svelte-8iq36i"&&(k.innerHTML=Ve),ie=n(e),r(B.$$.fragment,e),de=n(e),r(W.$$.fragment,e),ce=n(e),V=f(e,"P",{"data-svelte-h":!0}),y(V)!=="svelte-o5se92"&&(V.innerHTML=Xe),fe=n(e),r(X.$$.fragment,e),ue=n(e),C=f(e,"P",{"data-svelte-h":!0}),y(C)!=="svelte-1ch6tri"&&(C.innerHTML=Ce),ye=n(e),r(_.$$.fragment,e),be=n(e),H=f(e,"P",{"data-svelte-h":!0}),y(H)!=="svelte-1uomn7a"&&(H.innerHTML=_e),we=n(e),r(R.$$.fragment,e),he=n(e),S=f(e,"P",{"data-svelte-h":!0}),y(S)!=="svelte-1667xui"&&(S.innerHTML=He),ge=n(e),r(Y.$$.fragment,e),$e=n(e),N=f(e,"P",{"data-svelte-h":!0}),y(N)!=="svelte-vdlog2"&&(N.textContent=Re),Te=n(e),r(Q.$$.fragment,e),Me=n(e),L=f(e,"P",{"data-svelte-h":!0}),y(L)!=="svelte-116cdvy"&&(L.innerHTML=Se),Je=n(e),r(q.$$.fragment,e),ve=n(e),x=f(e,"P",{"data-svelte-h":!0}),y(x)!=="svelte-1vf7e1h"&&(x.innerHTML=Ye),je=n(e),r(E.$$.fragment,e),Ze=n(e),P=f(e,"P",{"data-svelte-h":!0}),y(P)!=="svelte-1cgj0dh"&&(P.innerHTML=Ne),Ue=n(e),r(F.$$.fragment,e),Ge=n(e),A=f(e,"P",{}),Le(A).forEach(s),this.h()},h(){qe(u,"name","hf:doc:metadata"),qe(u,"content",st)},m(e,t){Ae(document.head,u),l(e,b,t),l(e,g,t),l(e,D,t),m($,e,t),l(e,O,t),m(T,e,t),l(e,ee,t),l(e,M,t),l(e,te,t),m(J,e,t),l(e,se,t),l(e,v,t),l(e,le,t),m(j,e,t),l(e,ae,t),l(e,Z,t),l(e,ne,t),m(U,e,t),l(e,oe,t),m(h,e,t),l(e,re,t),m(G,e,t),l(e,me,t),m(I,e,t),l(e,pe,t),l(e,k,t),l(e,ie,t),m(B,e,t),l(e,de,t),m(W,e,t),l(e,ce,t),l(e,V,t),l(e,fe,t),m(X,e,t),l(e,ue,t),l(e,C,t),l(e,ye,t),m(_,e,t),l(e,be,t),l(e,H,t),l(e,we,t),m(R,e,t),l(e,he,t),l(e,S,t),l(e,ge,t),m(Y,e,t),l(e,$e,t),l(e,N,t),l(e,Te,t),m(Q,e,t),l(e,Me,t),l(e,L,t),l(e,Je,t),m(q,e,t),l(e,ve,t),l(e,x,t),l(e,je,t),m(E,e,t),l(e,Ze,t),l(e,P,t),l(e,Ue,t),m(F,e,t),l(e,Ge,t),l(e,A,t),Ie=!0},p(e,[t]){const Qe={};t&2&&(Qe.$$scope={dirty:t,ctx:e}),h.$set(Qe)},i(e){Ie||(p($.$$.fragment,e),p(T.$$.fragment,e),p(J.$$.fragment,e),p(j.$$.fragment,e),p(U.$$.fragment,e),p(h.$$.fragment,e),p(G.$$.fragment,e),p(I.$$.fragment,e),p(B.$$.fragment,e),p(W.$$.fragment,e),p(X.$$.fragment,e),p(_.$$.fragment,e),p(R.$$.fragment,e),p(Y.$$.fragment,e),p(Q.$$.fragment,e),p(q.$$.fragment,e),p(E.$$.fragment,e),p(F.$$.fragment,e),Ie=!0)},o(e){i($.$$.fragment,e),i(T.$$.fragment,e),i(J.$$.fragment,e),i(j.$$.fragment,e),i(U.$$.fragment,e),i(h.$$.fragment,e),i(G.$$.fragment,e),i(I.$$.fragment,e),i(B.$$.fragment,e),i(W.$$.fragment,e),i(X.$$.fragment,e),i(_.$$.fragment,e),i(R.$$.fragment,e),i(Y.$$.fragment,e),i(Q.$$.fragment,e),i(q.$$.fragment,e),i(E.$$.fragment,e),i(F.$$.fragment,e),Ie=!1},d(e){e&&(s(b),s(g),s(D),s(O),s(ee),s(M),s(te),s(se),s(v),s(le),s(ae),s(Z),s(ne),s(oe),s(re),s(me),s(pe),s(k),s(ie),s(de),s(ce),s(V),s(fe),s(ue),s(C),s(ye),s(be),s(H),s(we),s(he),s(S),s(ge),s($e),s(N),s(Te),s(Me),s(L),s(Je),s(ve),s(x),s(je),s(Ze),s(P),s(Ue),s(Ge),s(A)),s(u),d($,e),d(T,e),d(J,e),d(j,e),d(U,e),d(h,e),d(G,e),d(I,e),d(B,e),d(W,e),d(X,e),d(_,e),d(R,e),d(Y,e),d(Q,e),d(q,e),d(E,e),d(F,e)}}}const st='{"title":"How to use optimum and BetterTransformer ?","local":"how-to-use-optimum-and-bettertransformer-","sections":[{"title":"Install dependencies","local":"install-dependencies","sections":[],"depth":2},{"title":"Step 1: Load your model","local":"step-1-load-your-model","sections":[],"depth":2},{"title":"Step 2: Set your model on your preferred device","local":"step-2-set-your-model-on-your-preferred-device","sections":[],"depth":2},{"title":"Step 3: Convert your model to BetterTransformer!","local":"step-3-convert-your-model-to-bettertransformer","sections":[],"depth":2},{"title":"Pipeline compatibility","local":"pipeline-compatibility","sections":[],"depth":2},{"title":"Training compatibility","local":"training-compatibility","sections":[],"depth":2}],"depth":1}';function lt(K){return Ee(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pt extends Pe{constructor(u){super(),Fe(this,u,lt,tt,xe,{})}}export{pt as component};
