import{s as Jt,n as Ht,o as xt}from"../chunks/scheduler.22bf70d2.js";import{S as Wt,i as At,g as n,s,r as d,A as Ut,h as r,f as l,c as i,j as Ft,u as p,x as o,k as Rt,y as Gt,a,v as c,d as f,t as m,w as h}from"../chunks/index.59178e06.js";import{C as _}from"../chunks/CodeBlock.f7047b13.js";import{H as ne,E as kt}from"../chunks/EditOnGithub.86314611.js";function Pt(tt){let u,de,re,pe,w,ce,M,lt=`To accelerate training huge models on larger batch sizes, we can use a fully sharded data parallel model.
This type of data parallel paradigm enables fitting more data and larger models by sharding the optimizer states, gradients and parameters.
To read more about it and the benefits, check out the <a href="https://pytorch.org/blog/introducing-pytorch-fully-sharded-data-parallel-api/" rel="nofollow">Fully Sharded Data Parallel blog</a>.
We have integrated the latest PyTorch’s Fully Sharded Data Parallel (FSDP) training feature.
All you need to do is enable it through the config.`,fe,T,me,y,at="On your machine(s) just run:",he,g,ue,b,st=`and answer the questions asked. This will generate a config file that will be used automatically to properly set the
default options when doing`,_e,$,we,B,it="For instance, here is how you would run <code>examples/nlp_example.py</code> (from the root of the repo) with FSDP enabled:",Me,v,Te,Z,ye,j,nt="Currently, <code>Accelerate</code> supports the following config through the CLI:",ge,S,rt='<code>fsdp_sharding_strategy</code>: [1] FULL_SHARD (shards optimizer states, gradients and parameters), [2] SHARD_GRAD_OP (shards optimizer states and gradients), [3] NO_SHARD (DDP), [4] HYBRID_SHARD (shards optimizer states, gradients and parameters within each node while each node has full copy), [5] HYBRID_SHARD_ZERO2 (shards optimizer states and gradients within each node while each node has full copy). For more information, please refer the official <a href="https://pytorch.org/docs/stable/fsdp.html#torch.distributed.fsdp.ShardingStrategy" rel="nofollow">PyTorch docs</a>.',be,F,ot="<code>fsdp_offload_params</code> : Decides Whether to offload parameters and gradients to CPU",$e,R,dt="<code>fsdp_auto_wrap_policy</code>: [1] TRANSFORMER_BASED_WRAP, [2] SIZE_BASED_WRAP, [3] NO_WRAP",Be,J,pt="<code>fsdp_transformer_layer_cls_to_wrap</code>: Only applicable for 🤗 Transformers. When using <code>fsdp_auto_wrap_policy=TRANSFORMER_BASED_WRAP</code>, a user may provide a comma-separated string of transformer layer class names (case-sensitive) to wrap, e.g., <code>BertLayer</code>, <code>GPTJBlock</code>, <code>T5Block</code>, <code>BertLayer,BertEmbeddings,BertSelfOutput</code>. This is important because submodules that share weights (e.g., embedding layers) should not end up in different FSDP wrapped units. Using this policy, wrapping happens for each block containing Multi-Head Attention followed by a couple of MLP layers. Remaining layers including the shared embeddings are conveniently wrapped in same outermost FSDP unit. Therefore, use this for transformer-based models. You can use the <code>model._no_split_modules</code> for 🤗 Transformer models by answering <code>yes</code> to <code>Do you want to use the model&#39;s </code>_no_split_modules<code>to wrap. It will try to use</code>model._no_split_modules` when possible.",ve,H,ct="<code>fsdp_min_num_params</code>: minimum number of parameters when using <code>fsdp_auto_wrap_policy=SIZE_BASED_WRAP</code>.",Ze,x,ft="<code>fsdp_backward_prefetch_policy</code>: [1] BACKWARD_PRE, [2] BACKWARD_POST, [3] NO_PREFETCH",je,W,mt="<code>fsdp_forward_prefetch</code>: if True, then FSDP explicitly prefetches the next upcoming all-gather while executing in the forward pass. Should only be used for static-graph models since the prefetching follows the first iteration’s execution order. i.e., if the sub-modules’ order changes dynamically during the model’s execution do not enable this feature.",Se,A,ht="<code>fsdp_state_dict_type</code>: [1] FULL_STATE_DICT, [2] LOCAL_STATE_DICT, [3] SHARDED_STATE_DICT",Fe,U,ut='<code>fsdp_use_orig_params</code>: If True, allows non-uniform <code>requires_grad</code> during init, which means support for interspersed frozen and trainable parameters. This setting is useful in cases such as parameter-efficient fine-tuning as discussed in <a href="https://dev-discuss.pytorch.org/t/rethinking-pytorch-fully-sharded-data-parallel-fsdp-from-first-principles/1019" rel="nofollow">this post</a>. This option also allows one to have multiple optimizer param groups. This should be <code>True</code> when creating an optimizer before preparing/wrapping the model with FSDP.',Re,G,_t="<code>fsdp_cpu_ram_efficient_loading</code>: Only applicable for 🤗 Transformers models. If True, only the first process loads the pretrained model checkpoint while all other processes have empty weights. This should be set to False if you experience errors when loading the pretrained 🤗 Transformers model via <code>from_pretrained</code> method. When this setting is True <code>fsdp_sync_module_states</code> also must to be True, otherwise all the processes except the main process would have random weights leading to unexpected behaviour during training. For this to work, make sure the distributed process group is initialized before calling Transformers <code>from_pretrained</code> method. When using 🤗 Trainer API, the distributed process group is initialized when you create an instance of <code>TrainingArguments</code> class.",Je,k,wt="<code>fsdp_sync_module_states</code>: If True, each individually wrapped FSDP unit will broadcast module parameters from rank 0.",He,P,Mt=`For additional and more nuanced control, you can specify other FSDP parameters via <code>FullyShardedDataParallelPlugin</code>.
When creating <code>FullyShardedDataParallelPlugin</code> object, pass it the parameters that weren’t part of the accelerate config or if you want to override them.
The FSDP parameters will be picked based on the accelerate config file or launch command arguments and other parameters that you will pass directly through the <code>FullyShardedDataParallelPlugin</code> object will set/override that.`,xe,C,Tt="Below is an example:",We,E,Ae,N,Ue,z,yt=`The new recommended way of checkpointing when using FSDP models is to use <code>SHARDED_STATE_DICT</code> as <code>StateDictType</code> when setting up the accelerate config.
Below is the code snippet to save using <code>save_state</code> utility of accelerate.`,Ge,D,ke,X,gt="Inspect the checkpoint folder to see model and optimizer as shards per process:",Pe,L,Ce,Y,bt="To load them back for resuming the training, use the <code>load_state</code> utility of accelerate",Ee,I,Ne,V,$t=`When using transformers <code>save_pretrained</code>, pass <code>state_dict=accelerator.get_state_dict(model)</code> to save the model state dict.
Below is an example:`,ze,Q,De,O,Xe,q,Bt="<code>accelerator.get_state_dict</code> will call the underlying <code>model.state_dict</code> implementation using <code>FullStateDictConfig(offload_to_cpu=True, rank0_only=True)</code> context manager to get the state dict only for rank 0 and it will be offloaded to CPU.",Le,K,vt='You can then pass <code>state</code> into the <code>save_pretrained</code> method.  There are several modes for <code>StateDictType</code> and <code>FullStateDictConfig</code> that you can use to control the behavior of <code>state_dict</code>.  For more information, see the <a href="https://pytorch.org/docs/stable/fsdp.html" rel="nofollow">PyTorch documentation</a>.',Ye,ee,Ie,te,Zt="<li><code>FULL_SHARD</code> maps to the DeepSpeed <code>ZeRO Stage-3</code>. Shards optimizer states, gradients and parameters.</li> <li><code>SHARD_GRAD_OP</code> maps to the DeepSpeed <code>ZeRO Stage-2</code>. Shards optimizer states and gradients.</li> <li><code>NO_SHARD</code> maps to <code>ZeRO Stage-0</code>. No sharding wherein each GPU has full copy of model, optimizer states and gradients.</li> <li><code>HYBRID_SHARD</code> maps to <code>ZeRO++ Stage-3</code> wherein <code>zero_hpz_partition_size=&lt;num_gpus_per_node&gt;</code>. Here, this will shard optimizer states, gradients and parameters within each node while each node has full copy.</li>",Ve,le,Qe,ae,jt="<li>In case of multiple models, pass the optimizers to the prepare call in the same order as corresponding models else <code>accelerator.save_state()</code> and <code>accelerator.load_state()</code> will result in wrong/unexpected behaviour.</li> <li>This feature is incompatible with <code>--predict_with_generate</code> in the <code>run_translation.py</code> script of 🤗 <code>Transformers</code> library.</li>",Oe,se,St=`For more control, users can leverage the <code>FullyShardedDataParallelPlugin</code>. After creating an instance of this class, users can pass it to the Accelerator class instantiation.
For more information on these options, please refer to the PyTorch <a href="https://github.com/pytorch/pytorch/blob/0df2e863fbd5993a7b9e652910792bd21a516ff3/torch/distributed/fsdp/fully_sharded_data_parallel.py#L236" rel="nofollow">FullyShardedDataParallel</a> code.`,qe,ie,Ke,oe,et;return w=new ne({props:{title:"Fully Sharded Data Parallel",local:"fully-sharded-data-parallel",headingTag:"h1"}}),T=new ne({props:{title:"How it works out of the box",local:"how-it-works-out-of-the-box",headingTag:"h2"}}),g=new _({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),$=new _({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMG15X3NjcmlwdC5weSUyMC0tYXJnc190b19teV9zY3JpcHQ=",highlighted:"accelerate launch my_script.py --args_to_my_script",wrap:!1}}),v=new _({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWJ1ZyUzQSUyMGZhbHNlJTBBZGlzdHJpYnV0ZWRfdHlwZSUzQSUyMEZTRFAlMEFkb3duY2FzdF9iZjE2JTNBJTIwJ25vJyUwQWZzZHBfY29uZmlnJTNBJTBBJTIwJTIwZnNkcF9hdXRvX3dyYXBfcG9saWN5JTNBJTIwVFJBTlNGT1JNRVJfQkFTRURfV1JBUCUwQSUyMCUyMGZzZHBfYmFja3dhcmRfcHJlZmV0Y2hfcG9saWN5JTNBJTIwQkFDS1dBUkRfUFJFJTBBJTIwJTIwZnNkcF9mb3J3YXJkX3ByZWZldGNoJTNBJTIwZmFsc2UlMEElMjAlMjBmc2RwX2NwdV9yYW1fZWZmaWNpZW50X2xvYWRpbmclM0ElMjB0cnVlJTBBJTIwJTIwZnNkcF9vZmZsb2FkX3BhcmFtcyUzQSUyMGZhbHNlJTBBJTIwJTIwZnNkcF9zaGFyZGluZ19zdHJhdGVneSUzQSUyMEZVTExfU0hBUkQlMEElMjAlMjBmc2RwX3N0YXRlX2RpY3RfdHlwZSUzQSUyMFNIQVJERURfU1RBVEVfRElDVCUwQSUyMCUyMGZzZHBfc3luY19tb2R1bGVfc3RhdGVzJTNBJTIwdHJ1ZSUwQSUyMCUyMGZzZHBfdHJhbnNmb3JtZXJfbGF5ZXJfY2xzX3RvX3dyYXAlM0ElMjBCZXJ0TGF5ZXIlMEElMjAlMjBmc2RwX3VzZV9vcmlnX3BhcmFtcyUzQSUyMHRydWUlMEFtYWNoaW5lX3JhbmslM0ElMjAwJTBBbWFpbl90cmFpbmluZ19mdW5jdGlvbiUzQSUyMG1haW4lMEFtaXhlZF9wcmVjaXNpb24lM0ElMjBiZjE2JTBBbnVtX21hY2hpbmVzJTNBJTIwMSUwQW51bV9wcm9jZXNzZXMlM0ElMjAyJTBBcmR6dl9iYWNrZW5kJTNBJTIwc3RhdGljJTBBc2FtZV9uZXR3b3JrJTNBJTIwdHJ1ZSUwQXRwdV9lbnYlM0ElMjAlNUIlNUQlMEF0cHVfdXNlX2NsdXN0ZXIlM0ElMjBmYWxzZSUwQXRwdV91c2Vfc3VkbyUzQSUyMGZhbHNlJTBBdXNlX2NwdSUzQSUyMGZhbHNl",highlighted:`compute_environment: LOCAL_MACHINE
debug: <span class="hljs-literal">false</span>
distributed_type: FSDP
downcast_bf16: <span class="hljs-string">&#x27;no&#x27;</span>
fsdp_config:
  fsdp_auto_wrap_policy: TRANSFORMER_BASED_WRAP
  fsdp_backward_prefetch_policy: BACKWARD_PRE
  fsdp_forward_prefetch: <span class="hljs-literal">false</span>
  fsdp_cpu_ram_efficient_loading: <span class="hljs-literal">true</span>
  fsdp_offload_params: <span class="hljs-literal">false</span>
  fsdp_sharding_strategy: FULL_SHARD
  fsdp_state_dict_type: SHARDED_STATE_DICT
  fsdp_sync_module_states: <span class="hljs-literal">true</span>
  fsdp_transformer_layer_cls_to_wrap: BertLayer
  fsdp_use_orig_params: <span class="hljs-literal">true</span>
machine_rank: 0
main_training_function: main
mixed_precision: bf16
num_machines: 1
num_processes: 2
rdzv_backend: static
same_network: <span class="hljs-literal">true</span>
tpu_env: []
tpu_use_cluster: <span class="hljs-literal">false</span>
tpu_use_sudo: <span class="hljs-literal">false</span>
use_cpu: <span class="hljs-literal">false</span>`,wrap:!1}}),Z=new _({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMGV4YW1wbGVzJTJGbmxwX2V4YW1wbGUucHk=",highlighted:"accelerate launch examples/nlp_example.py",wrap:!1}}),E=new _({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBGdWxseVNoYXJkZWREYXRhUGFyYWxsZWxQbHVnaW4lMEFmcm9tJTIwdG9yY2guZGlzdHJpYnV0ZWQuZnNkcC5mdWxseV9zaGFyZGVkX2RhdGFfcGFyYWxsZWwlMjBpbXBvcnQlMjBGdWxsT3B0aW1TdGF0ZURpY3RDb25maWclMkMlMjBGdWxsU3RhdGVEaWN0Q29uZmlnJTBBJTBBZnNkcF9wbHVnaW4lMjAlM0QlMjBGdWxseVNoYXJkZWREYXRhUGFyYWxsZWxQbHVnaW4oJTBBJTIwJTIwJTIwJTIwc3RhdGVfZGljdF9jb25maWclM0RGdWxsU3RhdGVEaWN0Q29uZmlnKG9mZmxvYWRfdG9fY3B1JTNERmFsc2UlMkMlMjByYW5rMF9vbmx5JTNERmFsc2UpJTJDJTBBJTIwJTIwJTIwJTIwb3B0aW1fc3RhdGVfZGljdF9jb25maWclM0RGdWxsT3B0aW1TdGF0ZURpY3RDb25maWcob2ZmbG9hZF90b19jcHUlM0RGYWxzZSUyQyUyMHJhbmswX29ubHklM0RGYWxzZSklMkMlMEEpJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihmc2RwX3BsdWdpbiUzRGZzZHBfcGx1Z2luKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> FullyShardedDataParallelPlugin
<span class="hljs-keyword">from</span> torch.distributed.fsdp.fully_sharded_data_parallel <span class="hljs-keyword">import</span> FullOptimStateDictConfig, FullStateDictConfig

fsdp_plugin = FullyShardedDataParallelPlugin(
    state_dict_config=FullStateDictConfig(offload_to_cpu=<span class="hljs-literal">False</span>, rank0_only=<span class="hljs-literal">False</span>),
    optim_state_dict_config=FullOptimStateDictConfig(offload_to_cpu=<span class="hljs-literal">False</span>, rank0_only=<span class="hljs-literal">False</span>),
)

accelerator = Accelerator(fsdp_plugin=fsdp_plugin)`,wrap:!1}}),N=new ne({props:{title:"Saving and loading",local:"saving-and-loading",headingTag:"h2"}}),D=new _({props:{code:"YWNjZWxlcmF0b3Iuc2F2ZV9zdGF0ZSglMjJja3B0JTIyKQ==",highlighted:'accelerator.save_state(<span class="hljs-string">&quot;ckpt&quot;</span>)',wrap:!1}}),L=new _({props:{code:"bHMlMjBja3B0JTBBJTIzJTIwb3B0aW1pemVyXzAlMjAlMjBweXRvcmNoX21vZGVsXzAlMjAlMjByYW5kb21fc3RhdGVzXzAucGtsJTIwJTIwcmFuZG9tX3N0YXRlc18xLnBrbCUyMCUyMHNjaGVkdWxlci5iaW4lMEElMEFjZCUyMGNrcHQlMEElMEFscyUyMG9wdGltaXplcl8wJTBBJTIzJTIwX18wXzAuZGlzdGNwJTIwJTIwX18xXzAuZGlzdGNwJTBBJTBBbHMlMjBweXRvcmNoX21vZGVsXzAlMEElMjMlMjBfXzBfMC5kaXN0Y3AlMjAlMjBfXzFfMC5kaXN0Y3A=",highlighted:`<span class="hljs-built_in">ls</span> ckpt
<span class="hljs-comment"># optimizer_0  pytorch_model_0  random_states_0.pkl  random_states_1.pkl  scheduler.bin</span>

<span class="hljs-built_in">cd</span> ckpt

<span class="hljs-built_in">ls</span> optimizer_0
<span class="hljs-comment"># __0_0.distcp  __1_0.distcp</span>

<span class="hljs-built_in">ls</span> pytorch_model_0
<span class="hljs-comment"># __0_0.distcp  __1_0.distcp</span>`,wrap:!1}}),I=new _({props:{code:"YWNjZWxlcmF0b3IubG9hZF9zdGF0ZSglMjJja3B0JTIyKQ==",highlighted:'accelerator.load_state(<span class="hljs-string">&quot;ckpt&quot;</span>)',wrap:!1}}),Q=new _({props:{code:"JTIwJTIwdW53cmFwcGVkX21vZGVsLnNhdmVfcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjBhcmdzLm91dHB1dF9kaXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBpc19tYWluX3Byb2Nlc3MlM0RhY2NlbGVyYXRvci5pc19tYWluX3Byb2Nlc3MlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBzYXZlX2Z1bmN0aW9uJTNEYWNjZWxlcmF0b3Iuc2F2ZSUyQyUwQSUyQiUyMCUyMCUyMCUyMCUyMHN0YXRlX2RpY3QlM0RhY2NlbGVyYXRvci5nZXRfc3RhdGVfZGljdChtb2RlbCklMkMlMEEp",highlighted:`  unwrapped_model.save_pretrained(
      args.output_dir,
      is_main_process=accelerator.is_main_process,
      save_function=accelerator.save,
<span class="hljs-addition">+     state_dict=accelerator.get_state_dict(model),</span>
)`,wrap:!1}}),O=new ne({props:{title:"State Dict",local:"state-dict",headingTag:"h3"}}),ee=new ne({props:{title:"Mapping between FSDP sharding strategies and DeepSpeed ZeRO Stages",local:"mapping-between-fsdp-sharding-strategies-and-deepspeed-zero-stages",headingTag:"h2"}}),le=new ne({props:{title:"A few caveats to be aware of",local:"a-few-caveats-to-be-aware-of",headingTag:"h2"}}),ie=new kt({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/usage_guides/fsdp.md"}}),{c(){u=n("meta"),de=s(),re=n("p"),pe=s(),d(w.$$.fragment),ce=s(),M=n("p"),M.innerHTML=lt,fe=s(),d(T.$$.fragment),me=s(),y=n("p"),y.textContent=at,he=s(),d(g.$$.fragment),ue=s(),b=n("p"),b.textContent=st,_e=s(),d($.$$.fragment),we=s(),B=n("p"),B.innerHTML=it,Me=s(),d(v.$$.fragment),Te=s(),d(Z.$$.fragment),ye=s(),j=n("p"),j.innerHTML=nt,ge=s(),S=n("p"),S.innerHTML=rt,be=s(),F=n("p"),F.innerHTML=ot,$e=s(),R=n("p"),R.innerHTML=dt,Be=s(),J=n("p"),J.innerHTML=pt,ve=s(),H=n("p"),H.innerHTML=ct,Ze=s(),x=n("p"),x.innerHTML=ft,je=s(),W=n("p"),W.innerHTML=mt,Se=s(),A=n("p"),A.innerHTML=ht,Fe=s(),U=n("p"),U.innerHTML=ut,Re=s(),G=n("p"),G.innerHTML=_t,Je=s(),k=n("p"),k.innerHTML=wt,He=s(),P=n("p"),P.innerHTML=Mt,xe=s(),C=n("p"),C.textContent=Tt,We=s(),d(E.$$.fragment),Ae=s(),d(N.$$.fragment),Ue=s(),z=n("p"),z.innerHTML=yt,Ge=s(),d(D.$$.fragment),ke=s(),X=n("p"),X.textContent=gt,Pe=s(),d(L.$$.fragment),Ce=s(),Y=n("p"),Y.innerHTML=bt,Ee=s(),d(I.$$.fragment),Ne=s(),V=n("p"),V.innerHTML=$t,ze=s(),d(Q.$$.fragment),De=s(),d(O.$$.fragment),Xe=s(),q=n("p"),q.innerHTML=Bt,Le=s(),K=n("p"),K.innerHTML=vt,Ye=s(),d(ee.$$.fragment),Ie=s(),te=n("ul"),te.innerHTML=Zt,Ve=s(),d(le.$$.fragment),Qe=s(),ae=n("ul"),ae.innerHTML=jt,Oe=s(),se=n("p"),se.innerHTML=St,qe=s(),d(ie.$$.fragment),Ke=s(),oe=n("p"),this.h()},l(e){const t=Ut("svelte-u9bgzb",document.head);u=r(t,"META",{name:!0,content:!0}),t.forEach(l),de=i(e),re=r(e,"P",{}),Ft(re).forEach(l),pe=i(e),p(w.$$.fragment,e),ce=i(e),M=r(e,"P",{"data-svelte-h":!0}),o(M)!=="svelte-qnvjvw"&&(M.innerHTML=lt),fe=i(e),p(T.$$.fragment,e),me=i(e),y=r(e,"P",{"data-svelte-h":!0}),o(y)!=="svelte-3pof6s"&&(y.textContent=at),he=i(e),p(g.$$.fragment,e),ue=i(e),b=r(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-ovz84c"&&(b.textContent=st),_e=i(e),p($.$$.fragment,e),we=i(e),B=r(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-109sebi"&&(B.innerHTML=it),Me=i(e),p(v.$$.fragment,e),Te=i(e),p(Z.$$.fragment,e),ye=i(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-aporbc"&&(j.innerHTML=nt),ge=i(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-mtvmo1"&&(S.innerHTML=rt),be=i(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-173mpds"&&(F.innerHTML=ot),$e=i(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-56dvve"&&(R.innerHTML=dt),Be=i(e),J=r(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-9h1xw0"&&(J.innerHTML=pt),ve=i(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-fbrtfo"&&(H.innerHTML=ct),Ze=i(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-gnni23"&&(x.innerHTML=ft),je=i(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1b8s7mr"&&(W.innerHTML=mt),Se=i(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1bw4fgg"&&(A.innerHTML=ht),Fe=i(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1hsz8jb"&&(U.innerHTML=ut),Re=i(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1lu06m7"&&(G.innerHTML=_t),Je=i(e),k=r(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-9z96c5"&&(k.innerHTML=wt),He=i(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1mlu7qv"&&(P.innerHTML=Mt),xe=i(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-ks9e2y"&&(C.textContent=Tt),We=i(e),p(E.$$.fragment,e),Ae=i(e),p(N.$$.fragment,e),Ue=i(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-105rpu1"&&(z.innerHTML=yt),Ge=i(e),p(D.$$.fragment,e),ke=i(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-zz881x"&&(X.textContent=gt),Pe=i(e),p(L.$$.fragment,e),Ce=i(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1v7i9ht"&&(Y.innerHTML=bt),Ee=i(e),p(I.$$.fragment,e),Ne=i(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1y7f54p"&&(V.innerHTML=$t),ze=i(e),p(Q.$$.fragment,e),De=i(e),p(O.$$.fragment,e),Xe=i(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-y5myy"&&(q.innerHTML=Bt),Le=i(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-57zs50"&&(K.innerHTML=vt),Ye=i(e),p(ee.$$.fragment,e),Ie=i(e),te=r(e,"UL",{"data-svelte-h":!0}),o(te)!=="svelte-1mojn5u"&&(te.innerHTML=Zt),Ve=i(e),p(le.$$.fragment,e),Qe=i(e),ae=r(e,"UL",{"data-svelte-h":!0}),o(ae)!=="svelte-125fftf"&&(ae.innerHTML=jt),Oe=i(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1dlu8nc"&&(se.innerHTML=St),qe=i(e),p(ie.$$.fragment,e),Ke=i(e),oe=r(e,"P",{}),Ft(oe).forEach(l),this.h()},h(){Rt(u,"name","hf:doc:metadata"),Rt(u,"content",Ct)},m(e,t){Gt(document.head,u),a(e,de,t),a(e,re,t),a(e,pe,t),c(w,e,t),a(e,ce,t),a(e,M,t),a(e,fe,t),c(T,e,t),a(e,me,t),a(e,y,t),a(e,he,t),c(g,e,t),a(e,ue,t),a(e,b,t),a(e,_e,t),c($,e,t),a(e,we,t),a(e,B,t),a(e,Me,t),c(v,e,t),a(e,Te,t),c(Z,e,t),a(e,ye,t),a(e,j,t),a(e,ge,t),a(e,S,t),a(e,be,t),a(e,F,t),a(e,$e,t),a(e,R,t),a(e,Be,t),a(e,J,t),a(e,ve,t),a(e,H,t),a(e,Ze,t),a(e,x,t),a(e,je,t),a(e,W,t),a(e,Se,t),a(e,A,t),a(e,Fe,t),a(e,U,t),a(e,Re,t),a(e,G,t),a(e,Je,t),a(e,k,t),a(e,He,t),a(e,P,t),a(e,xe,t),a(e,C,t),a(e,We,t),c(E,e,t),a(e,Ae,t),c(N,e,t),a(e,Ue,t),a(e,z,t),a(e,Ge,t),c(D,e,t),a(e,ke,t),a(e,X,t),a(e,Pe,t),c(L,e,t),a(e,Ce,t),a(e,Y,t),a(e,Ee,t),c(I,e,t),a(e,Ne,t),a(e,V,t),a(e,ze,t),c(Q,e,t),a(e,De,t),c(O,e,t),a(e,Xe,t),a(e,q,t),a(e,Le,t),a(e,K,t),a(e,Ye,t),c(ee,e,t),a(e,Ie,t),a(e,te,t),a(e,Ve,t),c(le,e,t),a(e,Qe,t),a(e,ae,t),a(e,Oe,t),a(e,se,t),a(e,qe,t),c(ie,e,t),a(e,Ke,t),a(e,oe,t),et=!0},p:Ht,i(e){et||(f(w.$$.fragment,e),f(T.$$.fragment,e),f(g.$$.fragment,e),f($.$$.fragment,e),f(v.$$.fragment,e),f(Z.$$.fragment,e),f(E.$$.fragment,e),f(N.$$.fragment,e),f(D.$$.fragment,e),f(L.$$.fragment,e),f(I.$$.fragment,e),f(Q.$$.fragment,e),f(O.$$.fragment,e),f(ee.$$.fragment,e),f(le.$$.fragment,e),f(ie.$$.fragment,e),et=!0)},o(e){m(w.$$.fragment,e),m(T.$$.fragment,e),m(g.$$.fragment,e),m($.$$.fragment,e),m(v.$$.fragment,e),m(Z.$$.fragment,e),m(E.$$.fragment,e),m(N.$$.fragment,e),m(D.$$.fragment,e),m(L.$$.fragment,e),m(I.$$.fragment,e),m(Q.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(ie.$$.fragment,e),et=!1},d(e){e&&(l(de),l(re),l(pe),l(ce),l(M),l(fe),l(me),l(y),l(he),l(ue),l(b),l(_e),l(we),l(B),l(Me),l(Te),l(ye),l(j),l(ge),l(S),l(be),l(F),l($e),l(R),l(Be),l(J),l(ve),l(H),l(Ze),l(x),l(je),l(W),l(Se),l(A),l(Fe),l(U),l(Re),l(G),l(Je),l(k),l(He),l(P),l(xe),l(C),l(We),l(Ae),l(Ue),l(z),l(Ge),l(ke),l(X),l(Pe),l(Ce),l(Y),l(Ee),l(Ne),l(V),l(ze),l(De),l(Xe),l(q),l(Le),l(K),l(Ye),l(Ie),l(te),l(Ve),l(Qe),l(ae),l(Oe),l(se),l(qe),l(Ke),l(oe)),l(u),h(w,e),h(T,e),h(g,e),h($,e),h(v,e),h(Z,e),h(E,e),h(N,e),h(D,e),h(L,e),h(I,e),h(Q,e),h(O,e),h(ee,e),h(le,e),h(ie,e)}}}const Ct='{"title":"Fully Sharded Data Parallel","local":"fully-sharded-data-parallel","sections":[{"title":"How it works out of the box","local":"how-it-works-out-of-the-box","sections":[],"depth":2},{"title":"Saving and loading","local":"saving-and-loading","sections":[{"title":"State Dict","local":"state-dict","sections":[],"depth":3}],"depth":2},{"title":"Mapping between FSDP sharding strategies and DeepSpeed ZeRO Stages","local":"mapping-between-fsdp-sharding-strategies-and-deepspeed-zero-stages","sections":[],"depth":2},{"title":"A few caveats to be aware of","local":"a-few-caveats-to-be-aware-of","sections":[],"depth":2}],"depth":1}';function Et(tt){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Lt extends Wt{constructor(u){super(),At(this,u,Et,Pt,Jt,{})}}export{Lt as component};
