import{s as at,o as lt,n as xe}from"../chunks/scheduler.d6170356.js";import{S as st,i as nt,g as o,s as n,r as d,A as it,h as p,f as a,c as i,j as et,u as f,x as c,k as tt,y as ot,a as l,v as m,d as g,t as w,w as $}from"../chunks/index.fcd4cc08.js";import{T as Ce}from"../chunks/Tip.b09c67cf.js";import{C as pt}from"../chunks/CodeBlock.7b16bdef.js";import{H as D}from"../chunks/Heading.8660bd0e.js";function rt(v){let s,u='This guide will take you through the process of integrating a <em>Sign-In with HF</em> button into any Space. If you’re seeking a fast and simple method to implement this in a <strong>Gradio</strong> Space, take a look at its <a href="https://www.gradio.app/guides/sharing-your-app#o-auth-login-via-hugging-face" rel="nofollow">built-in integration</a>.';return{c(){s=o("p"),s.innerHTML=u},l(r){s=p(r,"P",{"data-svelte-h":!0}),c(s)!=="svelte-1nqltc0"&&(s.innerHTML=u)},m(r,h){l(r,s,h)},p:xe,d(r){r&&a(s)}}}function ct(v){let s,u='You can also use the HF OAuth flow to create a “Sign in with HF” flow in any website or App, outside of Spaces. <a href="./oauth">Read our general OAuth page</a>.';return{c(){s=o("p"),s.innerHTML=u},l(r){s=p(r,"P",{"data-svelte-h":!0}),c(s)!=="svelte-138wjpm"&&(s.innerHTML=u)},m(r,h){l(r,s,h)},p:xe,d(r){r&&a(s)}}}function ut(v){let s,u="You should use <code>target=_blank</code> on the button to open the sign-in page in a new tab, unless you run the space outside its <code>iframe</code>. Otherwise, you might encounter issues with cookies on some browsers.";return{c(){s=o("p"),s.innerHTML=u},l(r){s=p(r,"P",{"data-svelte-h":!0}),c(s)!=="svelte-9c51kn"&&(s.innerHTML=u)},m(r,h){l(r,s,h)},p:xe,d(r){r&&a(s)}}}function ht(v){let s,u,r,h,M,V,y,Ue='You can enable a built-in sign-in flow in your Space by seamlessly creating and associating an <a href="https://developer.okta.com/blog/2019/10/21/illustrated-guide-to-oauth-and-oidc" rel="nofollow">OAuth/OpenID connect</a> app so users can log in with their HF account.',K,j,ke='This enables new use cases for your Space. For instance, when combined with <a href="https://huggingface.co/docs/hub/spaces-storage" rel="nofollow">Persistent Storage</a>, a generative AI Space could allow users to log in to access their previous generations, only accessible to them.',ee,T,te,b,ae,H,le,S,Ie="All you need to do is add <code>hf_oauth: true</code> to your Space’s metadata inside your <code>README.md</code> file.",se,L,Ae="Here’s an example of metadata for a Gradio Space:",ne,C,ie,x,Ee='You can check out the <a href="./spaces-config-reference">configuration reference docs</a> for more information.',oe,U,Pe='This will add the following <a href="https://huggingface.co/docs/hub/spaces-overview#helper-environment-variables" rel="nofollow">environment variables</a> to your space:',pe,k,Je='<li><code>OAUTH_CLIENT_ID</code>: the client ID of your OAuth app (public)</li> <li><code>OAUTH_CLIENT_SECRET</code>: the client secret of your OAuth app</li> <li><code>OAUTH_SCOPES</code>: scopes accessible by your OAuth app.</li> <li><code>OPENID_PROVIDER_URL</code>: The URL of the OpenID provider. The OpenID metadata will be available at <a href="https://huggingface.co/.well-known/openid-configuration" rel="nofollow"><code>{OPENID_PROVIDER_URL}/.well-known/openid-configuration</code></a>.</li>',re,I,Re="As for any other environment variable, you can use them in your code by using <code>os.getenv(&quot;OAUTH_CLIENT_ID&quot;)</code>, for example.",ce,A,ue,E,Oe="The allowed redirect URIs for your OAuth app are:",he,P,Be="<li><code>https://{SPACE_HOST}/auth/callback</code></li> <li><code>https://{SPACE_HOST}/login/callback</code></li>",de,J,Ge='Note that <code>SPACE_HOST</code> is also <a href="https://huggingface.co/docs/hub/spaces-overview#helper-environment-variables" rel="nofollow">available</a> as an environment variable.',fe,R,Fe="You can add a custom relative redirect path by setting <code>hf_oauth_redirect_path</code> in your Space’s metadata.",me,O,ge,B,Ne="The following scopes are always included for Spaces:",we,G,Xe="<li><code>openid</code>: Get the ID token in addition to the access token.</li> <li><code>profile</code>: Get the user’s profile information (username, avatar, etc.)</li>",$e,F,We="Those scopes are optional and can be added by setting <code>hf_oauth_scopes</code> in your Space’s metadata:",ve,N,Ye='<li><code>email</code>: Get the user’s email address.</li> <li><code>read-repos</code>: Get read access to the user’s personal repos.</li> <li><code>write-repos</code>: Get write access to the user’s personal repos. Does not grant read access on its own, you need to include <code>read-repos</code> as well.</li> <li><code>manage-repos</code>: Get access to a repo’s settings. Also grants repo creation and deletion.</li> <li><code>inference-api</code>: Get access to the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>, you will be able to make inference requests on behalf of the user.</li>',Te,X,be,W,qe='You now have all the information to add a “Sign-in with HF” button to your Space. Some libraries (<a href="https://github.com/lepture/authlib" rel="nofollow">Python</a>, <a href="https://github.com/panva/node-openid-client" rel="nofollow">NodeJS</a>) can help you implement the OpenID/OAuth protocol. Gradio also provides <strong>built-in support</strong>, making implementing the Sign-in with HF button a breeze; you can <a href="https://www.gradio.app/guides/sharing-your-app#o-auth-login-via-hugging-face" rel="nofollow">check out the associated guide</a>.',_e,Y,ze="Basically, you need to:",Me,q,Ze="<li>Redirect the user to <code>https://huggingface.co/oauth/authorize?redirect_uri={REDIRECT_URI}&amp;scope=openid%20profile&amp;client_id={CLIENT_ID}&amp;state={STATE}</code>, where <code>STATE</code> is a random string that you will need to verify later.</li> <li>Handle the callback on <code>/auth/callback</code> or <code>/login/callback</code> (or your own custom callback URL) and verify the <code>state</code> parameter.</li> <li>Use the <code>code</code> query parameter to get an access token and id token from <code>https://huggingface.co/oauth/token</code> (POST request with <code>client_id</code>, <code>code</code>, <code>grant_type=authorization_code</code> and <code>redirect_uri</code> as form data, and with <code>Authorization: Basic {base64(client_id:client_secret)}</code> as a header).</li>",ye,_,je,z,He,Z,De='<li><a href="https://huggingface.co/spaces/Wauplin/gradio-oauth-test" rel="nofollow">Gradio test app</a></li> <li><a href="https://huggingface.co/spaces/huggingchat/chat-ui" rel="nofollow">Hugging Chat (NodeJS/SvelteKit)</a></li> <li><a href="https://huggingface.co/spaces/huggingfacejs/inference-widgets" rel="nofollow">Inference Widgets (Auth.js/SvelteKit)</a>, uses the <code>inference-api</code> scope to make inference requests on behalf of the user.</li>',Se,Q,Le;return M=new D({props:{title:"Adding a Sign-In with HF button to your Space",local:"adding-a-sign-in-with-hf-button-to-your-space",headingTag:"h1"}}),T=new Ce({props:{$$slots:{default:[rt]},$$scope:{ctx:v}}}),b=new Ce({props:{$$slots:{default:[ct]},$$scope:{ctx:v}}}),H=new D({props:{title:"Create an OAuth app",local:"create-an-oauth-app",headingTag:"h2"}}),C=new pt({props:{code:"dGl0bGUlM0ElMjBHcmFkaW8lMjBPYXV0aCUyMFRlc3QlMEFlbW9qaSUzQSUyMCVGMCU5RiU4RiU4NiUwQWNvbG9yRnJvbSUzQSUyMHBpbmslMEFjb2xvclRvJTNBJTIwcGluayUwQXNkayUzQSUyMGdyYWRpbyUwQXNka192ZXJzaW9uJTNBJTIwMy40MC4wJTBBcHl0aG9uX3ZlcnNpb24lM0ElMjAzLjEwLjYlMEFhcHBfZmlsZSUzQSUyMGFwcC5weSUwQSUwQWhmX29hdXRoJTNBJTIwdHJ1ZSUwQSUyMyUyMG9wdGlvbmFsJTJDJTIwc2VlJTIwJTIyUmVkaXJlY3QlMjBVUkxzJTIyJTIwYmVsb3clMEFoZl9vYXV0aF9yZWRpcmVjdF9wYXRoJTNBJTIwJTJGY3VzdG9tX2NhbGxiYWNrX3JvdXRlJTBBJTIzJTIwb3B0aW9uYWwlMkMlMjBzZWUlMjAlMjJTY29wZXMlMjIlMjBiZWxvdy4lMjAlMjJvcGVuaWQlMjBwcm9maWxlJTIyJTIwaXMlMjBhbHdheXMlMjBpbmNsdWRlZC4lMEFoZl9vYXV0aF9zY29wZXMlM0ElMEElMjAtJTIwcmVhZC1yZXBvcyUwQSUyMC0lMjB3cml0ZS1yZXBvcyUwQSUyMC0lMjBtYW5hZ2UtcmVwb3MlMEElMjAtJTIwaW5mZXJlbmNlLWFwaQ==",highlighted:`<span class="hljs-attr">title:</span> <span class="hljs-string">Gradio</span> <span class="hljs-string">Oauth</span> <span class="hljs-string">Test</span>
<span class="hljs-attr">emoji:</span> <span class="hljs-string">🏆</span>
<span class="hljs-attr">colorFrom:</span> <span class="hljs-string">pink</span>
<span class="hljs-attr">colorTo:</span> <span class="hljs-string">pink</span>
<span class="hljs-attr">sdk:</span> <span class="hljs-string">gradio</span>
<span class="hljs-attr">sdk_version:</span> <span class="hljs-number">3.40</span><span class="hljs-number">.0</span>
<span class="hljs-attr">python_version:</span> <span class="hljs-number">3.10</span><span class="hljs-number">.6</span>
<span class="hljs-attr">app_file:</span> <span class="hljs-string">app.py</span>

<span class="hljs-attr">hf_oauth:</span> <span class="hljs-literal">true</span>
<span class="hljs-comment"># optional, see &quot;Redirect URLs&quot; below</span>
<span class="hljs-attr">hf_oauth_redirect_path:</span> <span class="hljs-string">/custom_callback_route</span>
<span class="hljs-comment"># optional, see &quot;Scopes&quot; below. &quot;openid profile&quot; is always included.</span>
<span class="hljs-attr">hf_oauth_scopes:</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">read-repos</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">write-repos</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">manage-repos</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">inference-api</span>`,wrap:!1}}),A=new D({props:{title:"Redirect URLs",local:"redirect-urls",headingTag:"h2"}}),O=new D({props:{title:"Scopes",local:"scopes",headingTag:"h2"}}),X=new D({props:{title:"Adding the button to your Space",local:"adding-the-button-to-your-space",headingTag:"h2"}}),_=new Ce({props:{warning:!0,$$slots:{default:[ut]},$$scope:{ctx:v}}}),z=new D({props:{title:"Examples:",local:"examples",headingTag:"h2"}}),{c(){s=o("meta"),u=n(),r=o("p"),h=n(),d(M.$$.fragment),V=n(),y=o("p"),y.innerHTML=Ue,K=n(),j=o("p"),j.innerHTML=ke,ee=n(),d(T.$$.fragment),te=n(),d(b.$$.fragment),ae=n(),d(H.$$.fragment),le=n(),S=o("p"),S.innerHTML=Ie,se=n(),L=o("p"),L.textContent=Ae,ne=n(),d(C.$$.fragment),ie=n(),x=o("p"),x.innerHTML=Ee,oe=n(),U=o("p"),U.innerHTML=Pe,pe=n(),k=o("ul"),k.innerHTML=Je,re=n(),I=o("p"),I.innerHTML=Re,ce=n(),d(A.$$.fragment),ue=n(),E=o("p"),E.textContent=Oe,he=n(),P=o("ul"),P.innerHTML=Be,de=n(),J=o("p"),J.innerHTML=Ge,fe=n(),R=o("p"),R.innerHTML=Fe,me=n(),d(O.$$.fragment),ge=n(),B=o("p"),B.textContent=Ne,we=n(),G=o("ul"),G.innerHTML=Xe,$e=n(),F=o("p"),F.innerHTML=We,ve=n(),N=o("ul"),N.innerHTML=Ye,Te=n(),d(X.$$.fragment),be=n(),W=o("p"),W.innerHTML=qe,_e=n(),Y=o("p"),Y.textContent=ze,Me=n(),q=o("ul"),q.innerHTML=Ze,ye=n(),d(_.$$.fragment),je=n(),d(z.$$.fragment),He=n(),Z=o("ul"),Z.innerHTML=De,Se=n(),Q=o("p"),this.h()},l(e){const t=it("svelte-u9bgzb",document.head);s=p(t,"META",{name:!0,content:!0}),t.forEach(a),u=i(e),r=p(e,"P",{}),et(r).forEach(a),h=i(e),f(M.$$.fragment,e),V=i(e),y=p(e,"P",{"data-svelte-h":!0}),c(y)!=="svelte-1nfjaew"&&(y.innerHTML=Ue),K=i(e),j=p(e,"P",{"data-svelte-h":!0}),c(j)!=="svelte-1t83yje"&&(j.innerHTML=ke),ee=i(e),f(T.$$.fragment,e),te=i(e),f(b.$$.fragment,e),ae=i(e),f(H.$$.fragment,e),le=i(e),S=p(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-1u00faw"&&(S.innerHTML=Ie),se=i(e),L=p(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-vlpqut"&&(L.textContent=Ae),ne=i(e),f(C.$$.fragment,e),ie=i(e),x=p(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-ml9rcy"&&(x.innerHTML=Ee),oe=i(e),U=p(e,"P",{"data-svelte-h":!0}),c(U)!=="svelte-12m1u10"&&(U.innerHTML=Pe),pe=i(e),k=p(e,"UL",{"data-svelte-h":!0}),c(k)!=="svelte-k73zcv"&&(k.innerHTML=Je),re=i(e),I=p(e,"P",{"data-svelte-h":!0}),c(I)!=="svelte-qqxlx3"&&(I.innerHTML=Re),ce=i(e),f(A.$$.fragment,e),ue=i(e),E=p(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-jvpuh2"&&(E.textContent=Oe),he=i(e),P=p(e,"UL",{"data-svelte-h":!0}),c(P)!=="svelte-eg7dcn"&&(P.innerHTML=Be),de=i(e),J=p(e,"P",{"data-svelte-h":!0}),c(J)!=="svelte-lo8fiy"&&(J.innerHTML=Ge),fe=i(e),R=p(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-vk1fk7"&&(R.innerHTML=Fe),me=i(e),f(O.$$.fragment,e),ge=i(e),B=p(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-sd96qs"&&(B.textContent=Ne),we=i(e),G=p(e,"UL",{"data-svelte-h":!0}),c(G)!=="svelte-3wn6r0"&&(G.innerHTML=Xe),$e=i(e),F=p(e,"P",{"data-svelte-h":!0}),c(F)!=="svelte-181zoj"&&(F.innerHTML=We),ve=i(e),N=p(e,"UL",{"data-svelte-h":!0}),c(N)!=="svelte-34w51"&&(N.innerHTML=Ye),Te=i(e),f(X.$$.fragment,e),be=i(e),W=p(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-olbs7n"&&(W.innerHTML=qe),_e=i(e),Y=p(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-g0kxak"&&(Y.textContent=ze),Me=i(e),q=p(e,"UL",{"data-svelte-h":!0}),c(q)!=="svelte-159xo4d"&&(q.innerHTML=Ze),ye=i(e),f(_.$$.fragment,e),je=i(e),f(z.$$.fragment,e),He=i(e),Z=p(e,"UL",{"data-svelte-h":!0}),c(Z)!=="svelte-154zvxo"&&(Z.innerHTML=De),Se=i(e),Q=p(e,"P",{}),et(Q).forEach(a),this.h()},h(){tt(s,"name","hf:doc:metadata"),tt(s,"content",dt)},m(e,t){ot(document.head,s),l(e,u,t),l(e,r,t),l(e,h,t),m(M,e,t),l(e,V,t),l(e,y,t),l(e,K,t),l(e,j,t),l(e,ee,t),m(T,e,t),l(e,te,t),m(b,e,t),l(e,ae,t),m(H,e,t),l(e,le,t),l(e,S,t),l(e,se,t),l(e,L,t),l(e,ne,t),m(C,e,t),l(e,ie,t),l(e,x,t),l(e,oe,t),l(e,U,t),l(e,pe,t),l(e,k,t),l(e,re,t),l(e,I,t),l(e,ce,t),m(A,e,t),l(e,ue,t),l(e,E,t),l(e,he,t),l(e,P,t),l(e,de,t),l(e,J,t),l(e,fe,t),l(e,R,t),l(e,me,t),m(O,e,t),l(e,ge,t),l(e,B,t),l(e,we,t),l(e,G,t),l(e,$e,t),l(e,F,t),l(e,ve,t),l(e,N,t),l(e,Te,t),m(X,e,t),l(e,be,t),l(e,W,t),l(e,_e,t),l(e,Y,t),l(e,Me,t),l(e,q,t),l(e,ye,t),m(_,e,t),l(e,je,t),m(z,e,t),l(e,He,t),l(e,Z,t),l(e,Se,t),l(e,Q,t),Le=!0},p(e,[t]){const Qe={};t&2&&(Qe.$$scope={dirty:t,ctx:e}),T.$set(Qe);const Ve={};t&2&&(Ve.$$scope={dirty:t,ctx:e}),b.$set(Ve);const Ke={};t&2&&(Ke.$$scope={dirty:t,ctx:e}),_.$set(Ke)},i(e){Le||(g(M.$$.fragment,e),g(T.$$.fragment,e),g(b.$$.fragment,e),g(H.$$.fragment,e),g(C.$$.fragment,e),g(A.$$.fragment,e),g(O.$$.fragment,e),g(X.$$.fragment,e),g(_.$$.fragment,e),g(z.$$.fragment,e),Le=!0)},o(e){w(M.$$.fragment,e),w(T.$$.fragment,e),w(b.$$.fragment,e),w(H.$$.fragment,e),w(C.$$.fragment,e),w(A.$$.fragment,e),w(O.$$.fragment,e),w(X.$$.fragment,e),w(_.$$.fragment,e),w(z.$$.fragment,e),Le=!1},d(e){e&&(a(u),a(r),a(h),a(V),a(y),a(K),a(j),a(ee),a(te),a(ae),a(le),a(S),a(se),a(L),a(ne),a(ie),a(x),a(oe),a(U),a(pe),a(k),a(re),a(I),a(ce),a(ue),a(E),a(he),a(P),a(de),a(J),a(fe),a(R),a(me),a(ge),a(B),a(we),a(G),a($e),a(F),a(ve),a(N),a(Te),a(be),a(W),a(_e),a(Y),a(Me),a(q),a(ye),a(je),a(He),a(Z),a(Se),a(Q)),a(s),$(M,e),$(T,e),$(b,e),$(H,e),$(C,e),$(A,e),$(O,e),$(X,e),$(_,e),$(z,e)}}}const dt='{"title":"Adding a Sign-In with HF button to your Space","local":"adding-a-sign-in-with-hf-button-to-your-space","sections":[{"title":"Create an OAuth app","local":"create-an-oauth-app","sections":[],"depth":2},{"title":"Redirect URLs","local":"redirect-urls","sections":[],"depth":2},{"title":"Scopes","local":"scopes","sections":[],"depth":2},{"title":"Adding the button to your Space","local":"adding-the-button-to-your-space","sections":[],"depth":2},{"title":"Examples:","local":"examples","sections":[],"depth":2}],"depth":1}';function ft(v){return lt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tt extends st{constructor(s){super(),nt(this,s,ft,ht,at,{})}}export{Tt as component};
