import{s as $e,n as Ue,o as ve}from"../chunks/scheduler.d6170356.js";import{S as Ge,i as Ce,g as i,s as o,r as c,A as _e,h as l,f as a,c as n,j as Je,u as h,x as r,k as re,y as Ie,a as s,v as g,d as f,t as u,w as m}from"../chunks/index.fcd4cc08.js";import{C as je}from"../chunks/CodeBlock.7b16bdef.js";import{H as Z}from"../chunks/Heading.8660bd0e.js";function ke(pe){let p,Q,x,R,w,Y,y,de='<strong>Gradio</strong> provides an easy and intuitive interface for running a model from a list of inputs and displaying the outputs in formats such as images, audio, 3D objects, and more. Gradio now even has a <a href="https://gradio.app/docs/#o_plot" rel="nofollow">Plot output component</a> for creating data visualizations with Matplotlib, Bokeh, and Plotly! For more details, take a look at the <a href="https://gradio.app/getting_started/" rel="nofollow">Getting started</a> guide from the Gradio team.',q,M,ce='Selecting <strong>Gradio</strong> as the SDK when <a href="https://huggingface.co/new-space" rel="nofollow">creating a new Space</a> will initialize your Space with the latest version of Gradio by setting the <code>sdk</code> property to <code>gradio</code> in your <code>README.md</code> file’s YAML block. If you’d like to change the Gradio version, you can edit the <code>sdk_version</code> property.',z,T,he='Visit the <a href="https://gradio.app/docs/" rel="nofollow">Gradio documentation</a> to learn all about its features and check out the <a href="https://gradio.app/guides/" rel="nofollow">Gradio Guides</a> for some handy tutorials to help you get started!',P,b,N,J,ge='In the following sections, you’ll learn the basics of creating a Space, configuring it, and deploying your code to it. We’ll create a <strong>Hot Dog Classifier</strong> Space with Gradio that’ll be used to demo the <a href="https://huggingface.co/julien-c/hotdog-not-hotdog" rel="nofollow">julien-c/hotdog-not-hotdog</a> model, which can detect whether a given picture contains a hot dog 🌭',E,j,fe='You can find a completed version of this hosted at <a href="https://huggingface.co/spaces/NimaBoscarino/hotdog-gradio" rel="nofollow">NimaBoscarino/hotdog-gradio</a>.',V,$,X,U,ue='We’ll start by <a href="https://huggingface.co/new-space" rel="nofollow">creating a brand new Space</a> and choosing <strong>Gradio</strong> as our SDK. Hugging Face Spaces are Git repositories, meaning that you can work on your Space incrementally (and collaboratively) by pushing commits. Take a look at the <a href="./repositories-getting-started">Getting Started with Repositories</a> guide to learn about how you can create and edit files before continuing.',F,v,A,G,me='For the <strong>Hot Dog Classifier</strong> we’ll be using a <a href="https://huggingface.co/docs/transformers/pipeline_tutorial" rel="nofollow">🤗 Transformers pipeline</a> to use the model, so we need to start by installing a few dependencies. This can be done by creating a <strong>requirements.txt</strong> file in our repository, and adding the following dependencies to it:',D,C,K,_,we="The Spaces runtime will handle installing the dependencies!",O,I,ee,k,ye="To create the Gradio app, make a new file in the repository called <strong>app.py</strong>, and add the following code:",te,H,ae,S,Me='This Python script uses a <a href="https://huggingface.co/docs/transformers/pipeline_tutorial" rel="nofollow">🤗 Transformers pipeline</a> to load the <a href="https://huggingface.co/julien-c/hotdog-not-hotdog" rel="nofollow">julien-c/hotdog-not-hotdog</a> model, which is used by the Gradio interface. The Gradio app will expect you to upload an image, which it’ll then classify as <em>hot dog</em> or <em>not hot dog</em>. Once you’ve saved the code to the <strong>app.py</strong> file, visit the <strong>App</strong> tab to see your app in action!',se,d,Te='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/spaces-hot-dog-gradio.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/spaces-hot-dog-gradio-dark.png"/>',oe,W,ne,B,be='You can embed a Gradio Space on other webpages by using either Web Components or the HTML <code>&lt;iframe&gt;</code> tag. Check out <a href="./spaces-embed">our documentation</a> or the <a href="https://gradio.app/sharing_your_app/#embedding-hosted-spaces" rel="nofollow">Gradio documentation</a> for more details.',ie,L,le;return w=new Z({props:{title:"Gradio Spaces",local:"gradio-spaces",headingTag:"h1"}}),b=new Z({props:{title:"Your First Gradio Space: Hot Dog Classifier",local:"your-first-gradio-space-hot-dog-classifier",headingTag:"h2"}}),$=new Z({props:{title:"Create a new Gradio Space",local:"create-a-new-gradio-space",headingTag:"h2"}}),v=new Z({props:{title:"Add the dependencies",local:"add-the-dependencies",headingTag:"h2"}}),C=new je({props:{code:"dHJhbnNmb3JtZXJzJTBBdG9yY2g=",highlighted:`<span class="hljs-attribute">transformers
torch</span>`,wrap:!1}}),I=new Z({props:{title:"Create the Gradio interface",local:"create-the-gradio-interface",headingTag:"h2"}}),H=new je({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmltYWdlLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJqdWxpZW4tYyUyRmhvdGRvZy1ub3QtaG90ZG9nJTIyKSUwQSUwQWRlZiUyMHByZWRpY3QoaW5wdXRfaW1nKSUzQSUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwcGlwZWxpbmUoaW5wdXRfaW1nKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGlucHV0X2ltZyUyQyUyMCU3QnAlNUIlMjJsYWJlbCUyMiU1RCUzQSUyMHAlNUIlMjJzY29yZSUyMiU1RCUyMGZvciUyMHAlMjBpbiUyMHByZWRpY3Rpb25zJTdEJTIwJTBBJTBBZ3JhZGlvX2FwcCUyMCUzRCUyMGdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBwcmVkaWN0JTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEZ3IuSW1hZ2UobGFiZWwlM0QlMjJTZWxlY3QlMjBob3QlMjBkb2clMjBjYW5kaWRhdGUlMjIlMkMlMjBzb3VyY2VzJTNEJTVCJ3VwbG9hZCclMkMlMjAnd2ViY2FtJyU1RCUyQyUyMHR5cGUlM0QlMjJwaWwlMjIpJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUzRCU1QmdyLkltYWdlKGxhYmVsJTNEJTIyUHJvY2Vzc2VkJTIwSW1hZ2UlMjIpJTJDJTIwZ3IuTGFiZWwobGFiZWwlM0QlMjJSZXN1bHQlMjIlMkMlMjBudW1fdG9wX2NsYXNzZXMlM0QyKSU1RCUyQyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIySG90JTIwRG9nJTNGJTIwT3IlMjBOb3QlM0YlMjIlMkMlMEEpJTBBJTBBaWYlMjBfX25hbWVfXyUyMCUzRCUzRCUyMCUyMl9fbWFpbl9fJTIyJTNBJTBBJTIwJTIwJTIwJTIwZ3JhZGlvX2FwcC5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipeline = pipeline(task=<span class="hljs-string">&quot;image-classification&quot;</span>, model=<span class="hljs-string">&quot;julien-c/hotdog-not-hotdog&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">predict</span>(<span class="hljs-params">input_img</span>):
    predictions = pipeline(input_img)
    <span class="hljs-keyword">return</span> input_img, {p[<span class="hljs-string">&quot;label&quot;</span>]: p[<span class="hljs-string">&quot;score&quot;</span>] <span class="hljs-keyword">for</span> p <span class="hljs-keyword">in</span> predictions} 

gradio_app = gr.Interface(
    predict,
    inputs=gr.Image(label=<span class="hljs-string">&quot;Select hot dog candidate&quot;</span>, sources=[<span class="hljs-string">&#x27;upload&#x27;</span>, <span class="hljs-string">&#x27;webcam&#x27;</span>], <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;pil&quot;</span>),
    outputs=[gr.Image(label=<span class="hljs-string">&quot;Processed Image&quot;</span>), gr.Label(label=<span class="hljs-string">&quot;Result&quot;</span>, num_top_classes=<span class="hljs-number">2</span>)],
    title=<span class="hljs-string">&quot;Hot Dog? Or Not?&quot;</span>,
)

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    gradio_app.launch()`,wrap:!1}}),W=new Z({props:{title:"Embed Gradio Spaces on other webpages",local:"embed-gradio-spaces-on-other-webpages",headingTag:"h2"}}),{c(){p=i("meta"),Q=o(),x=i("p"),R=o(),c(w.$$.fragment),Y=o(),y=i("p"),y.innerHTML=de,q=o(),M=i("p"),M.innerHTML=ce,z=o(),T=i("p"),T.innerHTML=he,P=o(),c(b.$$.fragment),N=o(),J=i("p"),J.innerHTML=ge,E=o(),j=i("p"),j.innerHTML=fe,V=o(),c($.$$.fragment),X=o(),U=i("p"),U.innerHTML=ue,F=o(),c(v.$$.fragment),A=o(),G=i("p"),G.innerHTML=me,D=o(),c(C.$$.fragment),K=o(),_=i("p"),_.textContent=we,O=o(),c(I.$$.fragment),ee=o(),k=i("p"),k.innerHTML=ye,te=o(),c(H.$$.fragment),ae=o(),S=i("p"),S.innerHTML=Me,se=o(),d=i("div"),d.innerHTML=Te,oe=o(),c(W.$$.fragment),ne=o(),B=i("p"),B.innerHTML=be,ie=o(),L=i("p"),this.h()},l(e){const t=_e("svelte-u9bgzb",document.head);p=l(t,"META",{name:!0,content:!0}),t.forEach(a),Q=n(e),x=l(e,"P",{}),Je(x).forEach(a),R=n(e),h(w.$$.fragment,e),Y=n(e),y=l(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-3238v8"&&(y.innerHTML=de),q=n(e),M=l(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-hz5eql"&&(M.innerHTML=ce),z=n(e),T=l(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-sn7344"&&(T.innerHTML=he),P=n(e),h(b.$$.fragment,e),N=n(e),J=l(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-dlhtlz"&&(J.innerHTML=ge),E=n(e),j=l(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-zok0xa"&&(j.innerHTML=fe),V=n(e),h($.$$.fragment,e),X=n(e),U=l(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1jimeij"&&(U.innerHTML=ue),F=n(e),h(v.$$.fragment,e),A=n(e),G=l(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-12qvnza"&&(G.innerHTML=me),D=n(e),h(C.$$.fragment,e),K=n(e),_=l(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-pc1ide"&&(_.textContent=we),O=n(e),h(I.$$.fragment,e),ee=n(e),k=l(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-d6vm11"&&(k.innerHTML=ye),te=n(e),h(H.$$.fragment,e),ae=n(e),S=l(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-kmqyjo"&&(S.innerHTML=Me),se=n(e),d=l(e,"DIV",{class:!0,"data-svelte-h":!0}),r(d)!=="svelte-d7yd7v"&&(d.innerHTML=Te),oe=n(e),h(W.$$.fragment,e),ne=n(e),B=l(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-xeezyp"&&(B.innerHTML=be),ie=n(e),L=l(e,"P",{}),Je(L).forEach(a),this.h()},h(){re(p,"name","hf:doc:metadata"),re(p,"content",He),re(d,"class","flex justify-center")},m(e,t){Ie(document.head,p),s(e,Q,t),s(e,x,t),s(e,R,t),g(w,e,t),s(e,Y,t),s(e,y,t),s(e,q,t),s(e,M,t),s(e,z,t),s(e,T,t),s(e,P,t),g(b,e,t),s(e,N,t),s(e,J,t),s(e,E,t),s(e,j,t),s(e,V,t),g($,e,t),s(e,X,t),s(e,U,t),s(e,F,t),g(v,e,t),s(e,A,t),s(e,G,t),s(e,D,t),g(C,e,t),s(e,K,t),s(e,_,t),s(e,O,t),g(I,e,t),s(e,ee,t),s(e,k,t),s(e,te,t),g(H,e,t),s(e,ae,t),s(e,S,t),s(e,se,t),s(e,d,t),s(e,oe,t),g(W,e,t),s(e,ne,t),s(e,B,t),s(e,ie,t),s(e,L,t),le=!0},p:Ue,i(e){le||(f(w.$$.fragment,e),f(b.$$.fragment,e),f($.$$.fragment,e),f(v.$$.fragment,e),f(C.$$.fragment,e),f(I.$$.fragment,e),f(H.$$.fragment,e),f(W.$$.fragment,e),le=!0)},o(e){u(w.$$.fragment,e),u(b.$$.fragment,e),u($.$$.fragment,e),u(v.$$.fragment,e),u(C.$$.fragment,e),u(I.$$.fragment,e),u(H.$$.fragment,e),u(W.$$.fragment,e),le=!1},d(e){e&&(a(Q),a(x),a(R),a(Y),a(y),a(q),a(M),a(z),a(T),a(P),a(N),a(J),a(E),a(j),a(V),a(X),a(U),a(F),a(A),a(G),a(D),a(K),a(_),a(O),a(ee),a(k),a(te),a(ae),a(S),a(se),a(d),a(oe),a(ne),a(B),a(ie),a(L)),a(p),m(w,e),m(b,e),m($,e),m(v,e),m(C,e),m(I,e),m(H,e),m(W,e)}}}const He='{"title":"Gradio Spaces","local":"gradio-spaces","sections":[{"title":"Your First Gradio Space: Hot Dog Classifier","local":"your-first-gradio-space-hot-dog-classifier","sections":[],"depth":2},{"title":"Create a new Gradio Space","local":"create-a-new-gradio-space","sections":[],"depth":2},{"title":"Add the dependencies","local":"add-the-dependencies","sections":[],"depth":2},{"title":"Create the Gradio interface","local":"create-the-gradio-interface","sections":[],"depth":2},{"title":"Embed Gradio Spaces on other webpages","local":"embed-gradio-spaces-on-other-webpages","sections":[],"depth":2}],"depth":1}';function Se(pe){return ve(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Le extends Ge{constructor(p){super(),Ce(this,p,Se,ke,$e,{})}}export{Le as component};
