import{s as Ee,o as He,n as _e}from"../chunks/scheduler.d6170356.js";import{S as Se,i as $e,g as o,s as l,r as u,A as Ze,h as i,f as s,c as n,j as Ie,u as r,x as p,k as it,y as Re,a,v as d,d as m,t as M,w as T}from"../chunks/index.fcd4cc08.js";import{T as Ve}from"../chunks/Tip.b09c67cf.js";import{C as pt}from"../chunks/CodeBlock.7b16bdef.js";import{H as ct}from"../chunks/Heading.8660bd0e.js";function xe(ht){let c,J="Webhooks are now publicly available!";return{c(){c=o("p"),c.textContent=J},l(h){c=i(h,"P",{"data-svelte-h":!0}),p(c)!=="svelte-s7j76s"&&(c.textContent=J)},m(h,nt){a(h,c,nt)},p:_e,d(h){h&&s(c)}}}function Le(ht){let c,J,h,nt,b,ut,w,rt,g,Kt=`This guide will help walk you through the setup of an automatic training pipeline on the Hugging Face platform
using HF Datasets, Webhooks, Spaces, and AutoTrain.`,dt,U,te=`We will build a Webhook that listens to changes on an image classification dataset and triggers a fine-tuning
of <a href="https://huggingface.co/microsoft/resnet-50" rel="nofollow">microsoft/resnet-50</a> using <a href="https://huggingface.co/autotrain" rel="nofollow">AutoTrain</a>.`,mt,k,Mt,v,ee=`We will use a <a href="https://huggingface.co/datasets/huggingface-projects/auto-retrain-input-dataset" rel="nofollow">simple image classification dataset</a> for the sake
of the example. Learn more about uploading your data to the Hub <a href="https://huggingface.co/docs/datasets/upload_dataset" rel="nofollow">here</a>.`,Tt,B,se='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/002-auto-retrain/dataset.png" alt="dataset"/>',wt,C,jt,W,ae='First, let’s create a Webhook from your <a href="https://huggingface.co/settings/webhooks" rel="nofollow">settings</a>.',ft,I,le='<li>Select your dataset as the target repository. We will target <a href="https://huggingface.co/datasets/huggingface-projects/input-dataset" rel="nofollow">huggingface-projects/input-dataset</a> in this example.</li> <li>You can put a dummy Webhook URL for now. Defining your Webhook will let you look at the events that will be sent to it. You can also replay them, which will be useful for debugging!</li> <li>Input a secret to make it more secure.</li> <li>Subscribe to “Repo update” events as we want to react to data changes</li>',yt,E,ne="Your Webhook will look like this:",Jt,H,oe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/002-auto-retrain/webhook-creation.png" alt="webhook-creation"/>',bt,_,gt,S,ie='We now need a way to react to your Webhook events. An easy way to do this is to use a <a href="https://huggingface.co/docs/hub/spaces-overview" rel="nofollow">Space</a>!',Ut,$,pe='You can find an example Space <a href="https://huggingface.co/spaces/huggingface-projects/auto-retrain/tree/main" rel="nofollow">here</a>.',kt,Z,ce='This Space uses Docker, Python, <a href="https://fastapi.tiangolo.com/" rel="nofollow">FastAPI</a>, and <a href="https://www.uvicorn.org" rel="nofollow">uvicorn</a> to run a simple HTTP server. Read more about Docker Spaces <a href="https://huggingface.co/docs/hub/spaces-sdks-docker" rel="nofollow">here</a>.',vt,R,he='The entry point is <a href="https://huggingface.co/spaces/huggingface-projects/auto-retrain/blob/main/src/main.py" rel="nofollow">src/main.py</a>. Let’s walk through this file and detail what it does:',Bt,V,ue="<li>It spawns a FastAPI app that will listen to HTTP <code>POST</code> requests on <code>/webhook</code>:</li>",Ct,x,Wt,j,re='<li><ol start="2"><li>This route checks that the <code>X-Webhook-Secret</code> header is present and that its value is the same as the one you set in your Webhook’s settings. The <code>WEBHOOK_SECRET</code> secret must be set in the Space’s settings and be the same as the secret set in your Webhook.</li></ol></li>',It,L,Et,f,de="<li>The event’s payload is encoded as JSON. Here, we’ll be using pydantic models to parse the event payload. We also specify that we will run our Webhook only when:</li>",Ht,G,me="<li>the event concerns the input dataset</li> <li>the event is an update on the repo’s content, i.e., there has been a new commit</li>",_t,Q,St,y,Me="<li>If the payload is valid, the next step is to create a project on AutoTrain, schedule a fine-tuning of the input model (<code>microsoft/resnet-50</code> in our example) on the input dataset, and create a discussion on the dataset when it’s done!</li>",$t,q,Zt,Y,Te="Visit the link inside the comment to review the training cost estimate, and start fine-tuning the model!",Rt,X,we='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/002-auto-retrain/notification.png" alt="community tab notification"/>',Vt,A,je="In this example, we used Hugging Face AutoTrain to fine-tune our model quickly, but you can of course plug in your training infrastructure!",xt,N,fe="Feel free to duplicate the Space to your personal namespace and play with it. You will need to provide two secrets:",Lt,z,ye='<li><code>WEBHOOK_SECRET</code> : the secret from your Webhook.</li> <li><code>HF_ACCESS_TOKEN</code> : a User Access Token with <code>write</code> rights. You can create one <a href="https://huggingface.co/settings/tokens" rel="nofollow">from your settings</a>.</li>',Gt,F,Je='You will also need to tweak the <a href="https://huggingface.co/spaces/huggingface-projects/auto-retrain/blob/main/config.json" rel="nofollow"><code>config.json</code> file</a> to use the dataset and model of you choice:',Qt,P,qt,O,Yt,D,be="Last but not least, you’ll need to configure your webhook to send POST requests to your Space.",Xt,K,ge="Let’s first grab our Space’s “direct URL” from the contextual menu. Click on “Embed this Space” and copy the “Direct URL”.",At,tt,Ue='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/002-auto-retrain/duplicate-space.png" alt="embed this Space"/>',Nt,et,ke='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/002-auto-retrain/direct-url.png" alt="direct URL"/>',zt,st,ve="Update your Webhook to send requests to that URL:",Ft,at,Be='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/002-auto-retrain/update-webhook.png" alt="webhook settings"/>',Pt,lt,Ce="And that’s it! Now every commit to the input dataset will trigger a fine-tuning of ResNet-50 with AutoTrain 🎉",Ot,ot,Dt;return b=new ct({props:{title:"Webhook guide: Setup an automatic system to re-train a model when a dataset changes",local:"webhook-guide-setup-an-automatic-system-to-re-train-a-model-when-a-dataset-changes",headingTag:"h1"}}),w=new Ve({props:{$$slots:{default:[xe]},$$scope:{ctx:ht}}}),k=new ct({props:{title:"Prerequisite: Upload your dataset to the Hub",local:"prerequisite-upload-your-dataset-to-the-hub",headingTag:"h2"}}),C=new ct({props:{title:"Create a Webhook to react to the dataset’s changes",local:"create-a-webhook-to-react-to-the-datasets-changes",headingTag:"h2"}}),_=new ct({props:{title:"Create a Space to react to your Webhook",local:"create-a-space-to-react-to-your-webhook",headingTag:"h2"}}),x=new pt({props:{code:"ZnJvbSUyMGZhc3RhcGklMjBpbXBvcnQlMjBGYXN0QVBJJTBBJTBBJTIzJTIwJTVCLi4uJTVEJTBBJTQwYXBwLnBvc3QoJTIyJTJGd2ViaG9vayUyMiklMEFhc3luYyUyMGRlZiUyMHBvc3Rfd2ViaG9vayglMEElMDklMjMlMjAuLi4lMEEpJTNBJTBBJTBBJTIzJTIwLi4u",highlighted:`<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> FastAPI

<span class="hljs-comment"># [...]</span>
<span class="hljs-meta">@app.post(<span class="hljs-params"><span class="hljs-string">&quot;/webhook&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">post_webhook</span>(<span class="hljs-params">
	<span class="hljs-comment"># ...</span>
</span>):

<span class="hljs-comment"># ...</span>`,wrap:!1}}),L=new pt({props:{code:"JTIzJTIwJTVCLi4uJTVEJTBBJTBBV0VCSE9PS19TRUNSRVQlMjAlM0QlMjBvcy5nZXRlbnYoJTIyV0VCSE9PS19TRUNSRVQlMjIpJTBBJTBBJTIzJTIwJTVCLi4uJTVEJTBBJTBBJTQwYXBwLnBvc3QoJTIyJTJGd2ViaG9vayUyMiklMEFhc3luYyUyMGRlZiUyMHBvc3Rfd2ViaG9vayglMEElMDklMjMlMjAlNUIuLi4lNUQlMEElMDl4X3dlYmhvb2tfc2VjcmV0JTNBJTIwJTIwT3B0aW9uYWwlNUJzdHIlNUQlMjAlM0QlMjBIZWFkZXIoZGVmYXVsdCUzRE5vbmUpJTJDJTBBJTA5JTIzJTIwJTVFJTIwY2hlY2tzJTIwZm9yJTIwdGhlJTIwWC1XZWJob29rLVNlY3JldCUyMEhUVFAlMjBoZWFkZXIlMEEpJTNBJTBBJTA5aWYlMjB4X3dlYmhvb2tfc2VjcmV0JTIwaXMlMjBOb25lJTNBJTBBJTA5JTA5cmFpc2UlMjBIVFRQRXhjZXB0aW9uKDQwMSklMEElMDlpZiUyMHhfd2ViaG9va19zZWNyZXQlMjAhJTNEJTIwV0VCSE9PS19TRUNSRVQlM0ElMEElMDklMDlyYWlzZSUyMEhUVFBFeGNlcHRpb24oNDAzKSUwQSUwOSUyMyUyMCU1Qi4uLiU1RA==",highlighted:`<span class="hljs-comment"># [...]</span>

WEBHOOK_SECRET = os.getenv(<span class="hljs-string">&quot;WEBHOOK_SECRET&quot;</span>)

<span class="hljs-comment"># [...]</span>

<span class="hljs-meta">@app.post(<span class="hljs-params"><span class="hljs-string">&quot;/webhook&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">post_webhook</span>(<span class="hljs-params">
	<span class="hljs-comment"># [...]</span>
	x_webhook_secret:  <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>] = Header(<span class="hljs-params">default=<span class="hljs-literal">None</span></span>),
	<span class="hljs-comment"># ^ checks for the X-Webhook-Secret HTTP header</span>
</span>):
	<span class="hljs-keyword">if</span> x_webhook_secret <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
		<span class="hljs-keyword">raise</span> HTTPException(<span class="hljs-number">401</span>)
	<span class="hljs-keyword">if</span> x_webhook_secret != WEBHOOK_SECRET:
		<span class="hljs-keyword">raise</span> HTTPException(<span class="hljs-number">403</span>)
	<span class="hljs-comment"># [...]</span>`,wrap:!1}}),Q=new pt({props:{code:"JTIzJTIwZGVmaW5lZCUyMGluJTIwc3JjJTJGbW9kZWxzLnB5JTBBY2xhc3MlMjBXZWJob29rUGF5bG9hZEV2ZW50KEJhc2VNb2RlbCklM0ElMEElMDlhY3Rpb24lM0ElMjBMaXRlcmFsJTVCJTIyY3JlYXRlJTIyJTJDJTIwJTIydXBkYXRlJTIyJTJDJTIwJTIyZGVsZXRlJTIyJTVEJTBBJTA5c2NvcGUlM0ElMjBzdHIlMEElMEFjbGFzcyUyMFdlYmhvb2tQYXlsb2FkUmVwbyhCYXNlTW9kZWwpJTNBJTBBJTA5dHlwZSUzQSUyMExpdGVyYWwlNUIlMjJkYXRhc2V0JTIyJTJDJTIwJTIybW9kZWwlMjIlMkMlMjAlMjJzcGFjZSUyMiU1RCUwQSUwOW5hbWUlM0ElMjBzdHIlMEElMDlpZCUzQSUyMHN0ciUwQSUwOXByaXZhdGUlM0ElMjBib29sJTBBJTA5aGVhZFNoYSUzQSUyMHN0ciUwQSUwQWNsYXNzJTIwV2ViaG9va1BheWxvYWQoQmFzZU1vZGVsKSUzQSUwQSUwOWV2ZW50JTNBJTIwV2ViaG9va1BheWxvYWRFdmVudCUwQSUwOXJlcG8lM0ElMjBXZWJob29rUGF5bG9hZFJlcG8lMEElMEElMjMlMjAlNUIuLi4lNUQlMEElMEElNDBhcHAucG9zdCglMjIlMkZ3ZWJob29rJTIyKSUwQWFzeW5jJTIwZGVmJTIwcG9zdF93ZWJob29rKCUwQSUwOSUyMyUyMCU1Qi4uLiU1RCUwQSUwOXBheWxvYWQlM0ElMjBXZWJob29rUGF5bG9hZCUyQyUwQSUwOSUyMyUyMCU1RSUyMFB5ZGFudGljJTIwbW9kZWwlMjBkZWZpbmluZyUyMHRoZSUyMHBheWxvYWQlMjBmb3JtYXQlMEEpJTNBJTBBJTA5JTIzJTIwJTVCLi4uJTVEJTBBJTA5aWYlMjBub3QlMjAoJTBBJTA5JTA5cGF5bG9hZC5ldmVudC5hY3Rpb24lMjAlM0QlM0QlMjAlMjJ1cGRhdGUlMjIlMEElMDklMDlhbmQlMjBwYXlsb2FkLmV2ZW50LnNjb3BlLnN0YXJ0c3dpdGgoJTIycmVwby5jb250ZW50JTIyKSUwQSUwOSUwOWFuZCUyMHBheWxvYWQucmVwby5uYW1lJTIwJTNEJTNEJTIwY29uZmlnLmlucHV0X2RhdGFzZXQlMEElMDklMDlhbmQlMjBwYXlsb2FkLnJlcG8udHlwZSUyMCUzRCUzRCUyMCUyMmRhdGFzZXQlMjIlMEElMDkpJTNBJTBBJTA5JTA5JTIzJTIwbm8tb3AlMjBpZiUyMHRoZSUyMHBheWxvYWQlMjBkb2VzJTIwbm90JTIwbWF0Y2glMjBvdXIlMjBleHBlY3RhdGlvbnMlMEElMDklMDlyZXR1cm4lMjAlN0IlMjJwcm9jZXNzZWQlMjIlM0ElMjBGYWxzZSU3RCUwQSUwOSUyMyU1Qi4uLiU1RA==",highlighted:`<span class="hljs-comment"># defined in src/models.py</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">WebhookPayloadEvent</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
	action: <span class="hljs-type">Literal</span>[<span class="hljs-string">&quot;create&quot;</span>, <span class="hljs-string">&quot;update&quot;</span>, <span class="hljs-string">&quot;delete&quot;</span>]
	scope: <span class="hljs-built_in">str</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">WebhookPayloadRepo</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
	<span class="hljs-built_in">type</span>: <span class="hljs-type">Literal</span>[<span class="hljs-string">&quot;dataset&quot;</span>, <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-string">&quot;space&quot;</span>]
	name: <span class="hljs-built_in">str</span>
	<span class="hljs-built_in">id</span>: <span class="hljs-built_in">str</span>
	private: <span class="hljs-built_in">bool</span>
	headSha: <span class="hljs-built_in">str</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">WebhookPayload</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
	event: WebhookPayloadEvent
	repo: WebhookPayloadRepo

<span class="hljs-comment"># [...]</span>

<span class="hljs-meta">@app.post(<span class="hljs-params"><span class="hljs-string">&quot;/webhook&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">post_webhook</span>(<span class="hljs-params">
	<span class="hljs-comment"># [...]</span>
	payload: WebhookPayload,
	<span class="hljs-comment"># ^ Pydantic model defining the payload format</span>
</span>):
	<span class="hljs-comment"># [...]</span>
	<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> (
		payload.event.action == <span class="hljs-string">&quot;update&quot;</span>
		<span class="hljs-keyword">and</span> payload.event.scope.startswith(<span class="hljs-string">&quot;repo.content&quot;</span>)
		<span class="hljs-keyword">and</span> payload.repo.name == config.input_dataset
		<span class="hljs-keyword">and</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;dataset&quot;</span>
	):
		<span class="hljs-comment"># no-op if the payload does not match our expectations</span>
		<span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;processed&quot;</span>: <span class="hljs-literal">False</span>}
	<span class="hljs-comment">#[...]</span>`,wrap:!1}}),q=new pt({props:{code:"ZGVmJTIwc2NoZWR1bGVfcmV0cmFpbihwYXlsb2FkJTNBJTIwV2ViaG9va1BheWxvYWQpJTNBJTBBJTA5JTIzJTIwQ3JlYXRlJTIwdGhlJTIwYXV0b3RyYWluJTIwcHJvamVjdCUwQSUwOXRyeSUzQSUwQSUwOSUwOXByb2plY3QlMjAlM0QlMjBBdXRvVHJhaW4uY3JlYXRlX3Byb2plY3QocGF5bG9hZCklMEElMDklMDlBdXRvVHJhaW4uYWRkX2RhdGEocHJvamVjdF9pZCUzRHByb2plY3QlNUIlMjJpZCUyMiU1RCklMEElMDklMDlBdXRvVHJhaW4uc3RhcnRfcHJvY2Vzc2luZyhwcm9qZWN0X2lkJTNEcHJvamVjdCU1QiUyMmlkJTIyJTVEKSUwQSUwOWV4Y2VwdCUyMHJlcXVlc3RzLkhUVFBFcnJvciUyMGFzJTIwZXJyJTNBJTBBJTA5JTA5cHJpbnQoJTIyRVJST1IlMjB3aGlsZSUyMHJlcXVlc3RpbmclMjBBdXRvVHJhaW4lMjBBUEklM0ElMjIpJTBBJTA5JTA5cHJpbnQoZiUyMiUyMCUyMGNvZGUlM0ElMjAlN0JlcnIucmVzcG9uc2Uuc3RhdHVzX2NvZGUlN0QlMjIpJTBBJTA5JTA5cHJpbnQoZiUyMiUyMCUyMCU3QmVyci5yZXNwb25zZS5qc29uKCklN0QlMjIpJTBBJTA5JTA5cmFpc2UlMEElMDklMjMlMjBOb3RpZnklMjBpbiUyMHRoZSUyMGNvbW11bml0eSUyMHRhYiUwQSUwOW5vdGlmeV9zdWNjZXNzKHByb2plY3QlNUIlMjJpZCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">schedule_retrain</span>(<span class="hljs-params">payload: WebhookPayload</span>):
	<span class="hljs-comment"># Create the autotrain project</span>
	<span class="hljs-keyword">try</span>:
		project = AutoTrain.create_project(payload)
		AutoTrain.add_data(project_id=project[<span class="hljs-string">&quot;id&quot;</span>])
		AutoTrain.start_processing(project_id=project[<span class="hljs-string">&quot;id&quot;</span>])
	<span class="hljs-keyword">except</span> requests.HTTPError <span class="hljs-keyword">as</span> err:
		<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;ERROR while requesting AutoTrain API:&quot;</span>)
		<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;  code: <span class="hljs-subst">{err.response.status_code}</span>&quot;</span>)
		<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;  <span class="hljs-subst">{err.response.json()}</span>&quot;</span>)
		<span class="hljs-keyword">raise</span>
	<span class="hljs-comment"># Notify in the community tab</span>
	notify_success(project[<span class="hljs-string">&quot;id&quot;</span>])`,wrap:!1}}),P=new pt({props:{code:"JTdCJTBBJTA5JTIydGFyZ2V0X25hbWVzcGFjZSUyMiUzQSUyMCUyMnRoZSUyMG5hbWVzcGFjZSUyMHdoZXJlJTIwdGhlJTIwdHJhaW5lZCUyMG1vZGVsJTIwc2hvdWxkJTIwZW5kJTIwdXAlMjIlMkMlMEElMDklMjJpbnB1dF9kYXRhc2V0JTIyJTNBJTIwJTIydGhlJTIwZGF0YXNldCUyMG9uJTIwd2hpY2glMjB0aGUlMjBtb2RlbCUyMHdpbGwlMjBiZSUyMHRyYWluZWQlMjIlMkMlMEElMDklMjJpbnB1dF9tb2RlbCUyMiUzQSUyMCUyMnRoZSUyMGJhc2UlMjBtb2RlbCUyMHRvJTIwcmUtdHJhaW4lMjIlMkMlMEElMDklMjJhdXRvdHJhaW5fcHJvamVjdF9wcmVmaXglMjIlM0ElMjAlMjJBJTIwcHJlZml4JTIwZm9yJTIwdGhlJTIwQXV0b1RyYWluJTIwcHJvamVjdCUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
	<span class="hljs-attr">&quot;target_namespace&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;the namespace where the trained model should end up&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;input_dataset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;the dataset on which the model will be trained&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;input_model&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;the base model to re-train&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;autotrain_project_prefix&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;A prefix for the AutoTrain project&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),O=new ct({props:{title:"Configure your Webhook to send events to your Space",local:"configure-your-webhook-to-send-events-to-your-space",headingTag:"h2"}}),{c(){c=o("meta"),J=l(),h=o("p"),nt=l(),u(b.$$.fragment),ut=l(),u(w.$$.fragment),rt=l(),g=o("p"),g.textContent=Kt,dt=l(),U=o("p"),U.innerHTML=te,mt=l(),u(k.$$.fragment),Mt=l(),v=o("p"),v.innerHTML=ee,Tt=l(),B=o("p"),B.innerHTML=se,wt=l(),u(C.$$.fragment),jt=l(),W=o("p"),W.innerHTML=ae,ft=l(),I=o("ul"),I.innerHTML=le,yt=l(),E=o("p"),E.textContent=ne,Jt=l(),H=o("p"),H.innerHTML=oe,bt=l(),u(_.$$.fragment),gt=l(),S=o("p"),S.innerHTML=ie,Ut=l(),$=o("p"),$.innerHTML=pe,kt=l(),Z=o("p"),Z.innerHTML=ce,vt=l(),R=o("p"),R.innerHTML=he,Bt=l(),V=o("ol"),V.innerHTML=ue,Ct=l(),u(x.$$.fragment),Wt=l(),j=o("ol"),j.innerHTML=re,It=l(),u(L.$$.fragment),Et=l(),f=o("ol"),f.innerHTML=de,Ht=l(),G=o("ul"),G.innerHTML=me,_t=l(),u(Q.$$.fragment),St=l(),y=o("ol"),y.innerHTML=Me,$t=l(),u(q.$$.fragment),Zt=l(),Y=o("p"),Y.textContent=Te,Rt=l(),X=o("p"),X.innerHTML=we,Vt=l(),A=o("p"),A.textContent=je,xt=l(),N=o("p"),N.textContent=fe,Lt=l(),z=o("ul"),z.innerHTML=ye,Gt=l(),F=o("p"),F.innerHTML=Je,Qt=l(),u(P.$$.fragment),qt=l(),u(O.$$.fragment),Yt=l(),D=o("p"),D.textContent=be,Xt=l(),K=o("p"),K.textContent=ge,At=l(),tt=o("p"),tt.innerHTML=Ue,Nt=l(),et=o("p"),et.innerHTML=ke,zt=l(),st=o("p"),st.textContent=ve,Ft=l(),at=o("p"),at.innerHTML=Be,Pt=l(),lt=o("p"),lt.textContent=Ce,Ot=l(),ot=o("p"),this.h()},l(t){const e=Ze("svelte-u9bgzb",document.head);c=i(e,"META",{name:!0,content:!0}),e.forEach(s),J=n(t),h=i(t,"P",{}),Ie(h).forEach(s),nt=n(t),r(b.$$.fragment,t),ut=n(t),r(w.$$.fragment,t),rt=n(t),g=i(t,"P",{"data-svelte-h":!0}),p(g)!=="svelte-ze8gh0"&&(g.textContent=Kt),dt=n(t),U=i(t,"P",{"data-svelte-h":!0}),p(U)!=="svelte-8my4lw"&&(U.innerHTML=te),mt=n(t),r(k.$$.fragment,t),Mt=n(t),v=i(t,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1bbg0un"&&(v.innerHTML=ee),Tt=n(t),B=i(t,"P",{"data-svelte-h":!0}),p(B)!=="svelte-l6l0rz"&&(B.innerHTML=se),wt=n(t),r(C.$$.fragment,t),jt=n(t),W=i(t,"P",{"data-svelte-h":!0}),p(W)!=="svelte-15jch62"&&(W.innerHTML=ae),ft=n(t),I=i(t,"UL",{"data-svelte-h":!0}),p(I)!=="svelte-vx6oz2"&&(I.innerHTML=le),yt=n(t),E=i(t,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1kjjv0e"&&(E.textContent=ne),Jt=n(t),H=i(t,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1lz55rf"&&(H.innerHTML=oe),bt=n(t),r(_.$$.fragment,t),gt=n(t),S=i(t,"P",{"data-svelte-h":!0}),p(S)!=="svelte-fqh90s"&&(S.innerHTML=ie),Ut=n(t),$=i(t,"P",{"data-svelte-h":!0}),p($)!=="svelte-sual4m"&&($.innerHTML=pe),kt=n(t),Z=i(t,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-j52eq3"&&(Z.innerHTML=ce),vt=n(t),R=i(t,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1euo8xv"&&(R.innerHTML=he),Bt=n(t),V=i(t,"OL",{"data-svelte-h":!0}),p(V)!=="svelte-1xhscr8"&&(V.innerHTML=ue),Ct=n(t),r(x.$$.fragment,t),Wt=n(t),j=i(t,"OL",{start:!0,"data-svelte-h":!0}),p(j)!=="svelte-147ibmb"&&(j.innerHTML=re),It=n(t),r(L.$$.fragment,t),Et=n(t),f=i(t,"OL",{start:!0,"data-svelte-h":!0}),p(f)!=="svelte-18lnge2"&&(f.innerHTML=de),Ht=n(t),G=i(t,"UL",{"data-svelte-h":!0}),p(G)!=="svelte-1gbdb1z"&&(G.innerHTML=me),_t=n(t),r(Q.$$.fragment,t),St=n(t),y=i(t,"OL",{start:!0,"data-svelte-h":!0}),p(y)!=="svelte-1jgt1rb"&&(y.innerHTML=Me),$t=n(t),r(q.$$.fragment,t),Zt=n(t),Y=i(t,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-2wkt37"&&(Y.textContent=Te),Rt=n(t),X=i(t,"P",{"data-svelte-h":!0}),p(X)!=="svelte-17amjt1"&&(X.innerHTML=we),Vt=n(t),A=i(t,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1upb8bg"&&(A.textContent=je),xt=n(t),N=i(t,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1ieosw8"&&(N.textContent=fe),Lt=n(t),z=i(t,"UL",{"data-svelte-h":!0}),p(z)!=="svelte-1mva7ee"&&(z.innerHTML=ye),Gt=n(t),F=i(t,"P",{"data-svelte-h":!0}),p(F)!=="svelte-ch6cio"&&(F.innerHTML=Je),Qt=n(t),r(P.$$.fragment,t),qt=n(t),r(O.$$.fragment,t),Yt=n(t),D=i(t,"P",{"data-svelte-h":!0}),p(D)!=="svelte-14g7hz7"&&(D.textContent=be),Xt=n(t),K=i(t,"P",{"data-svelte-h":!0}),p(K)!=="svelte-51uzae"&&(K.textContent=ge),At=n(t),tt=i(t,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-1gxz68g"&&(tt.innerHTML=Ue),Nt=n(t),et=i(t,"P",{"data-svelte-h":!0}),p(et)!=="svelte-h01i34"&&(et.innerHTML=ke),zt=n(t),st=i(t,"P",{"data-svelte-h":!0}),p(st)!=="svelte-1w4uowt"&&(st.textContent=ve),Ft=n(t),at=i(t,"P",{"data-svelte-h":!0}),p(at)!=="svelte-lpgybe"&&(at.innerHTML=Be),Pt=n(t),lt=i(t,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-9f0m9n"&&(lt.textContent=Ce),Ot=n(t),ot=i(t,"P",{}),Ie(ot).forEach(s),this.h()},h(){it(c,"name","hf:doc:metadata"),it(c,"content",Ge),it(j,"start","2"),it(f,"start","3"),it(y,"start","4")},m(t,e){Re(document.head,c),a(t,J,e),a(t,h,e),a(t,nt,e),d(b,t,e),a(t,ut,e),d(w,t,e),a(t,rt,e),a(t,g,e),a(t,dt,e),a(t,U,e),a(t,mt,e),d(k,t,e),a(t,Mt,e),a(t,v,e),a(t,Tt,e),a(t,B,e),a(t,wt,e),d(C,t,e),a(t,jt,e),a(t,W,e),a(t,ft,e),a(t,I,e),a(t,yt,e),a(t,E,e),a(t,Jt,e),a(t,H,e),a(t,bt,e),d(_,t,e),a(t,gt,e),a(t,S,e),a(t,Ut,e),a(t,$,e),a(t,kt,e),a(t,Z,e),a(t,vt,e),a(t,R,e),a(t,Bt,e),a(t,V,e),a(t,Ct,e),d(x,t,e),a(t,Wt,e),a(t,j,e),a(t,It,e),d(L,t,e),a(t,Et,e),a(t,f,e),a(t,Ht,e),a(t,G,e),a(t,_t,e),d(Q,t,e),a(t,St,e),a(t,y,e),a(t,$t,e),d(q,t,e),a(t,Zt,e),a(t,Y,e),a(t,Rt,e),a(t,X,e),a(t,Vt,e),a(t,A,e),a(t,xt,e),a(t,N,e),a(t,Lt,e),a(t,z,e),a(t,Gt,e),a(t,F,e),a(t,Qt,e),d(P,t,e),a(t,qt,e),d(O,t,e),a(t,Yt,e),a(t,D,e),a(t,Xt,e),a(t,K,e),a(t,At,e),a(t,tt,e),a(t,Nt,e),a(t,et,e),a(t,zt,e),a(t,st,e),a(t,Ft,e),a(t,at,e),a(t,Pt,e),a(t,lt,e),a(t,Ot,e),a(t,ot,e),Dt=!0},p(t,[e]){const We={};e&2&&(We.$$scope={dirty:e,ctx:t}),w.$set(We)},i(t){Dt||(m(b.$$.fragment,t),m(w.$$.fragment,t),m(k.$$.fragment,t),m(C.$$.fragment,t),m(_.$$.fragment,t),m(x.$$.fragment,t),m(L.$$.fragment,t),m(Q.$$.fragment,t),m(q.$$.fragment,t),m(P.$$.fragment,t),m(O.$$.fragment,t),Dt=!0)},o(t){M(b.$$.fragment,t),M(w.$$.fragment,t),M(k.$$.fragment,t),M(C.$$.fragment,t),M(_.$$.fragment,t),M(x.$$.fragment,t),M(L.$$.fragment,t),M(Q.$$.fragment,t),M(q.$$.fragment,t),M(P.$$.fragment,t),M(O.$$.fragment,t),Dt=!1},d(t){t&&(s(J),s(h),s(nt),s(ut),s(rt),s(g),s(dt),s(U),s(mt),s(Mt),s(v),s(Tt),s(B),s(wt),s(jt),s(W),s(ft),s(I),s(yt),s(E),s(Jt),s(H),s(bt),s(gt),s(S),s(Ut),s($),s(kt),s(Z),s(vt),s(R),s(Bt),s(V),s(Ct),s(Wt),s(j),s(It),s(Et),s(f),s(Ht),s(G),s(_t),s(St),s(y),s($t),s(Zt),s(Y),s(Rt),s(X),s(Vt),s(A),s(xt),s(N),s(Lt),s(z),s(Gt),s(F),s(Qt),s(qt),s(Yt),s(D),s(Xt),s(K),s(At),s(tt),s(Nt),s(et),s(zt),s(st),s(Ft),s(at),s(Pt),s(lt),s(Ot),s(ot)),s(c),T(b,t),T(w,t),T(k,t),T(C,t),T(_,t),T(x,t),T(L,t),T(Q,t),T(q,t),T(P,t),T(O,t)}}}const Ge='{"title":"Webhook guide: Setup an automatic system to re-train a model when a dataset changes","local":"webhook-guide-setup-an-automatic-system-to-re-train-a-model-when-a-dataset-changes","sections":[{"title":"Prerequisite: Upload your dataset to the Hub","local":"prerequisite-upload-your-dataset-to-the-hub","sections":[],"depth":2},{"title":"Create a Webhook to react to the dataset’s changes","local":"create-a-webhook-to-react-to-the-datasets-changes","sections":[],"depth":2},{"title":"Create a Space to react to your Webhook","local":"create-a-space-to-react-to-your-webhook","sections":[],"depth":2},{"title":"Configure your Webhook to send events to your Space","local":"configure-your-webhook-to-send-events-to-your-space","sections":[],"depth":2}],"depth":1}';function Qe(ht){return He(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ze extends Se{constructor(c){super(),$e(this,c,Qe,Le,Ee,{})}}export{ze as component};
