import{s as ls,o as ds,n as F}from"../chunks/scheduler.182ea377.js";import{S as ps,i as cs,g as o,s,r as g,A as fs,h as r,f as l,c as i,j as T,u as h,x as m,k as J,y as t,a as y,v as _,d as b,t as v,w}from"../chunks/index.abf12888.js";import{T as Nt}from"../chunks/Tip.230e2334.js";import{D as k}from"../chunks/Docstring.93f6f462.js";import{C as Vt}from"../chunks/CodeBlock.57fe6e13.js";import{E as Bt}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as Xt}from"../chunks/Heading.16916d63.js";function ms(M){let n,x='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!',d,p,$='If you’re interested in using one of the official checkpoints for a task, explore the <a href="https://huggingface.co/CompVis" rel="nofollow">CompVis</a>, <a href="https://huggingface.co/runwayml" rel="nofollow">Runway</a>, and <a href="https://huggingface.co/stabilityai" rel="nofollow">Stability AI</a> Hub organizations!';return{c(){n=o("p"),n.innerHTML=x,d=s(),p=o("p"),p.innerHTML=$},l(a){n=r(a,"P",{"data-svelte-h":!0}),m(n)!=="svelte-1j961ct"&&(n.innerHTML=x),d=i(a),p=r(a,"P",{"data-svelte-h":!0}),m(p)!=="svelte-z4pn9c"&&(p.innerHTML=$)},m(a,I){y(a,n,I),y(a,d,I),y(a,p,I)},p:F,d(a){a&&(l(n),l(d),l(p))}}}function us(M){let n,x="Examples:",d,p,$;return p=new Vt({props:{code:"aW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lJTBBJTBBJTBBZGVmJTIwZG93bmxvYWRfaW1hZ2UodXJsKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBQSUwuSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW8ucG5nJTIyJTBBbWFza191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1b19tYXNrLnBuZyUyMiUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBkb3dubG9hZF9pbWFnZShpbWdfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBbWFza19pbWFnZSUyMCUzRCUyMGRvd25sb2FkX2ltYWdlKG1hc2tfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLWlucGFpbnRpbmclMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJGYWNlJTIwb2YlMjBhJTIweWVsbG93JTIwY2F0JTJDJTIwaGlnaCUyMHJlc29sdXRpb24lMkMlMjBzaXR0aW5nJTIwb24lMjBhJTIwcGFyayUyMGJlbmNoJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInpaintPipeline


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
<span class="hljs-meta">... </span>    response = requests.get(url)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionInpaintPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=o("p"),n.textContent=x,d=s(),g(p.$$.fragment)},l(a){n=r(a,"P",{"data-svelte-h":!0}),m(n)!=="svelte-kvfsh7"&&(n.textContent=x),d=i(a),h(p.$$.fragment,a)},m(a,I){y(a,n,I),y(a,d,I),_(p,a,I),$=!0},p:F,i(a){$||(b(p.$$.fragment,a),$=!0)},o(a){v(p.$$.fragment,a),$=!1},d(a){a&&(l(n),l(d)),w(p,a)}}}function gs(M){let n,x=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=o("p"),n.innerHTML=x},l(d){n=r(d,"P",{"data-svelte-h":!0}),m(n)!=="svelte-ackzsn"&&(n.innerHTML=x)},m(d,p){y(d,n,p)},p:F,d(d){d&&l(n)}}}function hs(M){let n,x="Examples:",d,p,$;return p=new Vt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=o("p"),n.textContent=x,d=s(),g(p.$$.fragment)},l(a){n=r(a,"P",{"data-svelte-h":!0}),m(n)!=="svelte-kvfsh7"&&(n.textContent=x),d=i(a),h(p.$$.fragment,a)},m(a,I){y(a,n,I),y(a,d,I),_(p,a,I),$=!0},p:F,i(a){$||(b(p.$$.fragment,a),$=!0)},o(a){v(p.$$.fragment,a),$=!1},d(a){a&&(l(n),l(d)),w(p,a)}}}function _s(M){let n,x=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=o("p"),n.textContent=x},l(d){n=r(d,"P",{"data-svelte-h":!0}),m(n)!=="svelte-17p1lpg"&&(n.textContent=x)},m(d,p){y(d,n,p)},p:F,d(d){d&&l(n)}}}function bs(M){let n,x="Examples:",d,p,$;return p=new Vt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=o("p"),n.textContent=x,d=s(),g(p.$$.fragment)},l(a){n=r(a,"P",{"data-svelte-h":!0}),m(n)!=="svelte-kvfsh7"&&(n.textContent=x),d=i(a),h(p.$$.fragment,a)},m(a,I){y(a,n,I),y(a,d,I),_(p,a,I),$=!0},p:F,i(a){$||(b(p.$$.fragment,a),$=!0)},o(a){v(p.$$.fragment,a),$=!1},d(a){a&&(l(n),l(d)),w(p,a)}}}function vs(M){let n,x="To load a Textual Inversion embedding vector in 🤗 Diffusers format:",d,p,$;return p=new Vt({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){n=o("p"),n.textContent=x,d=s(),g(p.$$.fragment)},l(a){n=r(a,"P",{"data-svelte-h":!0}),m(n)!=="svelte-1gc783q"&&(n.textContent=x),d=i(a),h(p.$$.fragment,a)},m(a,I){y(a,n,I),y(a,d,I),_(p,a,I),$=!0},p:F,i(a){$||(b(p.$$.fragment,a),$=!0)},o(a){v(p.$$.fragment,a),$=!1},d(a){a&&(l(n),l(d)),w(p,a)}}}function ws(M){let n,x="locally:",d,p,$;return p=new Vt({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){n=o("p"),n.textContent=x,d=s(),g(p.$$.fragment)},l(a){n=r(a,"P",{"data-svelte-h":!0}),m(n)!=="svelte-4c75kq"&&(n.textContent=x),d=i(a),h(p.$$.fragment,a)},m(a,I){y(a,n,I),y(a,d,I),_(p,a,I),$=!0},p:F,i(a){$||(b(p.$$.fragment,a),$=!0)},o(a){v(p.$$.fragment,a),$=!1},d(a){a&&(l(n),l(d)),w(p,a)}}}function ys(M){let n,x="This API is 🧪 experimental.";return{c(){n=o("p"),n.textContent=x},l(d){n=r(d,"P",{"data-svelte-h":!0}),m(n)!=="svelte-89q1io"&&(n.textContent=x)},m(d,p){y(d,n,p)},p:F,d(d){d&&l(n)}}}function xs(M){let n,x="This API is 🧪 experimental.";return{c(){n=o("p"),n.textContent=x},l(d){n=r(d,"P",{"data-svelte-h":!0}),m(n)!=="svelte-89q1io"&&(n.textContent=x)},m(d,p){y(d,n,p)},p:F,d(d){d&&l(n)}}}function $s(M){let n,x="🧪 This is an experimental feature!";return{c(){n=o("p"),n.textContent=x},l(d){n=r(d,"P",{"data-svelte-h":!0}),m(n)!=="svelte-15q3ih4"&&(n.textContent=x)},m(d,p){y(d,n,p)},p:F,d(d){d&&l(n)}}}function Is(M){let n,x="Examples:",d,p,$;return p=new Vt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionInpaintPipeline


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
<span class="hljs-meta">... </span>    response = requests.get(url)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline, params = FlaxStableDiffusionInpaintPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;xvjiarui/stable-diffusion-2-inpainting&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prng_seed = jax.random.PRNGKey(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>num_inference_steps = <span class="hljs-number">50</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>num_samples = jax.device_count()
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = num_samples * [prompt]
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = num_samples * [init_image]
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = num_samples * [mask_image]
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids, processed_masked_images, processed_masks = pipeline.prepare_inputs(
<span class="hljs-meta">... </span>    prompt, init_image, mask_image
<span class="hljs-meta">... </span>)
<span class="hljs-comment"># shard inputs and rng</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>params = replicate(params)
<span class="hljs-meta">&gt;&gt;&gt; </span>prng_seed = jax.random.split(prng_seed, jax.device_count())
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids = shard(prompt_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>processed_masked_images = shard(processed_masked_images)
<span class="hljs-meta">&gt;&gt;&gt; </span>processed_masks = shard(processed_masks)

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipeline(
<span class="hljs-meta">... </span>    prompt_ids, processed_masks, processed_masked_images, params, prng_seed, num_inference_steps, jit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipeline.numpy_to_pil(np.asarray(images.reshape((num_samples,) + images.shape[-<span class="hljs-number">3</span>:])))`,wrap:!1}}),{c(){n=o("p"),n.textContent=x,d=s(),g(p.$$.fragment)},l(a){n=r(a,"P",{"data-svelte-h":!0}),m(n)!=="svelte-kvfsh7"&&(n.textContent=x),d=i(a),h(p.$$.fragment,a)},m(a,I){y(a,n,I),y(a,d,I),_(p,a,I),$=!0},p:F,i(a){$||(b(p.$$.fragment,a),$=!0)},o(a){v(p.$$.fragment,a),$=!1},d(a){a&&(l(n),l(d)),w(p,a)}}}function Ms(M){let n,x,d,p,$,a,I,Ia="The Stable Diffusion model can also be applied to inpainting which lets you edit specific parts of an image by providing a mask and a text prompt using Stable Diffusion.",zt,be,Rt,ve,Ma=`It is recommended to use this pipeline with checkpoints that have been specifically fine-tuned for inpainting, such
as <a href="https://huggingface.co/runwayml/stable-diffusion-inpainting" rel="nofollow">runwayml/stable-diffusion-inpainting</a>. Default
text-to-image Stable Diffusion checkpoints, such as
<a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">runwayml/stable-diffusion-v1-5</a> are also compatible but they might be less performant.`,Ht,Y,Yt,we,At,f,ye,cn,et,Ta="Pipeline for text-guided image inpainting using Stable Diffusion.",fn,tt,Ja=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,mn,nt,ka="The pipeline also inherits the following loading methods:",un,at,Sa='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li> <li><a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li>',gn,B,xe,hn,st,Pa="The call function to the pipeline for generation.",_n,A,bn,C,$e,vn,it,ja=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,wn,Q,yn,q,xn,O,Ie,$n,ot,Da=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,In,Z,Me,Mn,rt,Ua=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Tn,K,Jn,ee,kn,te,Te,Sn,lt,Ca='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',Pn,S,Je,jn,dt,Za=`Load Textual Inversion embeddings into the text encoder of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,Dn,pt,Wa="Example:",Un,ne,Cn,ct,Fa=`To load a Textual Inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,Zn,ae,Wn,P,ke,Fn,ft,La=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,Ln,mt,Ga="All kwargs are forwarded to <code>self.lora_state_dict</code>.",Gn,ut,Na='See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is loaded.',Nn,gt,Ba=`See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is loaded into
<code>self.unet</code>.`,Bn,ht,Xa=`See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state dict is loaded
into <code>self.text_encoder</code>.`,Xn,se,Se,Vn,_t,Va="Save the LoRA parameters corresponding to the UNet and text encoder.",En,ie,Pe,zn,bt,Ea="Disables the FreeU mechanism if enabled.",Rn,oe,je,Hn,vt,za=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Yn,re,De,An,wt,Ra=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Qn,W,Ue,qn,yt,Ha='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',On,xt,Ya="The suffixes after the scaling factors represent the stages where they are being applied.",Kn,$t,Aa=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,ea,le,Ce,ta,It,Qa=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,na,de,Ze,aa,Mt,qa=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,sa,pe,We,ia,Tt,Oa="Encodes the prompt into text encoder hidden states.",oa,X,Fe,ra,Jt,Ka=`Enables fused QKV projections. For self-attention modules, all projection matrices (i.e., query,
key, value) are fused. For cross-attention modules, key and value projection matrices are fused.`,la,ce,da,fe,Le,pa,kt,es='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',ca,V,Ge,fa,St,ts="Disable QKV projection fusion if enabled.",ma,me,Qt,Ne,qt,R,Be,ua,Pt,ns="Output class for Stable Diffusion pipelines.",Ot,Xe,Kt,j,Ve,ga,jt,as="Flax-based pipeline for text-guided image inpainting using Stable Diffusion.",ha,ue,_a,Dt,ss=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline">FlaxDiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,ba,E,Ee,va,Ut,is="Function invoked when calling the pipeline for generation.",wa,ge,en,ze,tn,L,Re,ya,Ct,os="Output class for Flax-based Stable Diffusion pipelines.",xa,he,He,$a,Zt,rs="“Returns a new object replacing the specified fields with new values.",nn,Et,an;return $=new Xt({props:{title:"Inpainting",local:"inpainting",headingTag:"h1"}}),be=new Xt({props:{title:"Tips",local:"tips",headingTag:"h2"}}),Y=new Nt({props:{$$slots:{default:[ms]},$$scope:{ctx:M}}}),we=new Xt({props:{title:"StableDiffusionInpaintPipeline",local:"diffusers.StableDiffusionInpaintPipeline",headingTag:"h2"}}),ye=new k({props:{name:"class diffusers.StableDiffusionInpaintPipeline",anchor:"diffusers.StableDiffusionInpaintPipeline",parameters:[{name:"vae",val:": Union"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInpaintPipeline.vae",description:`<strong>vae</strong> ([<code>AutoencoderKL</code>, <code>AsymmetricAutoencoderKL</code>]) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionInpaintPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionInpaintPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionInpaintPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_inpaint.py#L222"}}),xe=new k({props:{name:"__call__",anchor:"diffusers.StableDiffusionInpaintPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"image",val:": Union = None"},{name:"mask_image",val:": Union = None"},{name:"masked_image_latents",val:": FloatTensor = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"padding_mask_crop",val:": Optional = None"},{name:"strength",val:": float = 1.0"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": List = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": int = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be inpainted (which parts of the image to
be masked out with <code>mask_image</code> and repainted according to <code>prompt</code>). For both numpy array and pytorch
tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list or tensors, the
expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a list of arrays, the
expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image latents as <code>image</code>, but
if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to mask <code>image</code>. White pixels in the mask
are repainted while black pixels are preserved. If <code>mask_image</code> is a PIL image, it is converted to a
single channel (luminance) before use. If it&#x2019;s a numpy array or pytorch tensor, it should contain one
color channel (L) instead of 3, so the expected shape for pytorch tensor would be <code>(B, 1, H, W)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code>, <code>(H, W)</code>. And for numpy array would be for <code>(B, H, W, 1)</code>, <code>(B, H, W)</code>, <code>(H, W, 1)</code>, or <code>(H, W)</code>.`,name:"mask_image"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.padding_mask_crop",description:`<strong>padding_mask_crop</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The size of margin in the crop to be applied to the image and masking. If <code>None</code>, no crop is applied to image and mask_image. If
<code>padding_mask_crop</code> is not <code>None</code>, it will first find a rectangular region with the same aspect ration of the image and
contains all masked area, and then expand that area based on <code>padding_mask_crop</code>. The image and mask_image will then be cropped based on
the expanded area before resizing to the original image size for inpainting. This is useful when the masked area is small while the image is large
and contain information inreleant for inpainging, such as background.`,name:"padding_mask_crop"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. This parameter is modulated by <code>strength</code>.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_inpaint.py#L1058",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),A=new Bt({props:{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.example",$$slots:{default:[us]},$$scope:{ctx:M}}}),$e=new k({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionInpaintPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInpaintPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2041"}}),Q=new Nt({props:{warning:!0,$$slots:{default:[gs]},$$scope:{ctx:M}}}),q=new Bt({props:{anchor:"diffusers.StableDiffusionInpaintPipeline.enable_attention_slicing.example",$$slots:{default:[hs]},$$scope:{ctx:M}}}),Ie=new k({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionInpaintPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2081"}}),Me=new k({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionInpaintPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInpaintPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1980"}}),K=new Nt({props:{warning:!0,$$slots:{default:[_s]},$$scope:{ctx:M}}}),ee=new Bt({props:{anchor:"diffusers.StableDiffusionInpaintPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[bs]},$$scope:{ctx:M}}}),Te=new k({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionInpaintPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2015"}}),Je=new k({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"token",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"text_encoder",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/textual_inversion.py#L265"}}),ne=new Bt({props:{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.example",$$slots:{default:[vs]},$$scope:{ctx:M}}}),ae=new Bt({props:{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.example-2",$$slots:{default:[ws]},$$scope:{ctx:M}}}),ke=new k({props:{name:"load_lora_weights",anchor:"diffusers.StableDiffusionInpaintPipeline.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": Union"},{name:"adapter_name",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionInpaintPipeline.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L80"}}),Se=new k({props:{name:"save_lora_weights",anchor:"diffusers.StableDiffusionInpaintPipeline.save_lora_weights",parameters:[{name:"save_directory",val:": Union"},{name:"unet_lora_layers",val:": Dict = None"},{name:"text_encoder_lora_layers",val:": Dict = None"},{name:"transformer_lora_layers",val:": Dict = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": Callable = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInpaintPipeline.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.StableDiffusionInpaintPipeline.save_lora_weights.unet_lora_layers",description:`<strong>unet_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>unet</code>.`,name:"unet_lora_layers"},{anchor:"diffusers.StableDiffusionInpaintPipeline.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.StableDiffusionInpaintPipeline.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.StableDiffusionInpaintPipeline.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.StableDiffusionInpaintPipeline.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L707"}}),Pe=new k({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionInpaintPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_inpaint.py#L937"}}),je=new k({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionInpaintPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_inpaint.py#L372"}}),De=new k({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionInpaintPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_inpaint.py#L389"}}),Ue=new k({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionInpaintPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInpaintPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionInpaintPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionInpaintPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionInpaintPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_inpaint.py#L914"}}),Ce=new k({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionInpaintPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_inpaint.py#L364"}}),Ze=new k({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionInpaintPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_inpaint.py#L380"}}),We=new k({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionInpaintPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInpaintPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionInpaintPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionInpaintPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionInpaintPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionInpaintPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionInpaintPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionInpaintPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionInpaintPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_inpaint.py#L430"}}),Fe=new k({props:{name:"fuse_qkv_projections",anchor:"diffusers.StableDiffusionInpaintPipeline.fuse_qkv_projections",parameters:[{name:"unet",val:": bool = True"},{name:"vae",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInpaintPipeline.fuse_qkv_projections.unet",description:"<strong>unet</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014; To apply fusion on the UNet.",name:"unet"},{anchor:"diffusers.StableDiffusionInpaintPipeline.fuse_qkv_projections.vae",description:"<strong>vae</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014; To apply fusion on the VAE.",name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_inpaint.py#L942"}}),ce=new Nt({props:{warning:!0,$$slots:{default:[ys]},$$scope:{ctx:M}}}),Le=new k({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.StableDiffusionInpaintPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:""},{name:"embedding_dim",val:" = 512"},{name:"dtype",val:" = torch.float32"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInpaintPipeline.get_guidance_scale_embedding.timesteps",description:`<strong>timesteps</strong> (<code>torch.Tensor</code>) &#x2014;
generate embedding vectors at these timesteps`,name:"timesteps"},{anchor:"diffusers.StableDiffusionInpaintPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
dimension of the embeddings to generate
dtype &#x2014;
data type of the generated embeddings`,name:"embedding_dim"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_inpaint.py#L1003",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(timesteps), embedding_dim)</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),Ge=new k({props:{name:"unfuse_qkv_projections",anchor:"diffusers.StableDiffusionInpaintPipeline.unfuse_qkv_projections",parameters:[{name:"unet",val:": bool = True"},{name:"vae",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInpaintPipeline.unfuse_qkv_projections.unet",description:"<strong>unet</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014; To apply fusion on the UNet.",name:"unet"},{anchor:"diffusers.StableDiffusionInpaintPipeline.unfuse_qkv_projections.vae",description:"<strong>vae</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014; To apply fusion on the VAE.",name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_inpaint.py#L974"}}),me=new Nt({props:{warning:!0,$$slots:{default:[xs]},$$scope:{ctx:M}}}),Ne=new Xt({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),Be=new k({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": Union"},{name:"nsfw_content_detected",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L10"}}),Xe=new Xt({props:{title:"FlaxStableDiffusionInpaintPipeline",local:"diffusers.FlaxStableDiffusionInpaintPipeline",headingTag:"h2"}}),Ve=new k({props:{name:"class diffusers.FlaxStableDiffusionInpaintPipeline",anchor:"diffusers.FlaxStableDiffusionInpaintPipeline",parameters:[{name:"vae",val:": FlaxAutoencoderKL"},{name:"text_encoder",val:": FlaxCLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": FlaxUNet2DConditionModel"},{name:"scheduler",val:": Union"},{name:"safety_checker",val:": FlaxStableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.FlaxAutoencoderKL">FlaxAutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.FlaxCLIPTextModel" rel="nofollow">FlaxCLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.FlaxUNet2DConditionModel">FlaxUNet2DConditionModel</a>) &#x2014;
A <code>FlaxUNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<code>FlaxDDIMScheduler</code>, <code>FlaxLMSDiscreteScheduler</code>, <code>FlaxPNDMScheduler</code>, or
<code>FlaxDPMSolverMultistepScheduler</code>.`,name:"scheduler"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>FlaxStableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_flax_stable_diffusion_inpaint.py#L102"}}),ue=new Nt({props:{warning:!0,$$slots:{default:[$s]},$$scope:{ctx:M}}}),Ee=new k({props:{name:"__call__",anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.__call__",parameters:[{name:"prompt_ids",val:": Array"},{name:"mask",val:": Array"},{name:"masked_image",val:": Array"},{name:"params",val:": Union"},{name:"prng_seed",val:": Array"},{name:"num_inference_steps",val:": int = 50"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"guidance_scale",val:": Union = 7.5"},{name:"latents",val:": Array = None"},{name:"neg_prompt_ids",val:": Array = None"},{name:"return_dict",val:": bool = True"},{name:"jit",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide image generation.`,name:"prompt"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. This parameter is modulated by <code>strength</code>.`,name:"num_inference_steps"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>jnp.ndarray</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
array is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.__call__.jit",description:`<strong>jit</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to run <code>pmap</code> versions of the generation and safety scoring functions.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>This argument exists because <code>__call__</code> is not yet end-to-end pmap-able. It will be removed in a
future release.</p>

					</div>`,name:"jit"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput">FlaxStableDiffusionPipelineOutput</a> instead of
a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_flax_stable_diffusion_inpaint.py#L394",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated images
and the second element is a list of <code>bool</code>s indicating whether the corresponding generated image
contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),ge=new Bt({props:{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.__call__.example",$$slots:{default:[Is]},$$scope:{ctx:M}}}),ze=new Xt({props:{title:"FlaxStableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",headingTag:"h2"}}),Re=new k({props:{name:"class diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",parameters:[{name:"images",val:": ndarray"},{name:"nsfw_content_detected",val:": List"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>np.ndarray</code>) &#x2014;
Denoised images of array shape of <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content
or <code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L31"}}),He=new k({props:{name:"replace",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/flax/struct.py#L111"}}),{c(){n=o("meta"),x=s(),d=o("p"),p=s(),g($.$$.fragment),a=s(),I=o("p"),I.textContent=Ia,zt=s(),g(be.$$.fragment),Rt=s(),ve=o("p"),ve.innerHTML=Ma,Ht=s(),g(Y.$$.fragment),Yt=s(),g(we.$$.fragment),At=s(),f=o("div"),g(ye.$$.fragment),cn=s(),et=o("p"),et.textContent=Ta,fn=s(),tt=o("p"),tt.innerHTML=Ja,mn=s(),nt=o("p"),nt.textContent=ka,un=s(),at=o("ul"),at.innerHTML=Sa,gn=s(),B=o("div"),g(xe.$$.fragment),hn=s(),st=o("p"),st.textContent=Pa,_n=s(),g(A.$$.fragment),bn=s(),C=o("div"),g($e.$$.fragment),vn=s(),it=o("p"),it.textContent=ja,wn=s(),g(Q.$$.fragment),yn=s(),g(q.$$.fragment),xn=s(),O=o("div"),g(Ie.$$.fragment),$n=s(),ot=o("p"),ot.innerHTML=Da,In=s(),Z=o("div"),g(Me.$$.fragment),Mn=s(),rt=o("p"),rt.innerHTML=Ua,Tn=s(),g(K.$$.fragment),Jn=s(),g(ee.$$.fragment),kn=s(),te=o("div"),g(Te.$$.fragment),Sn=s(),lt=o("p"),lt.innerHTML=Ca,Pn=s(),S=o("div"),g(Je.$$.fragment),jn=s(),dt=o("p"),dt.innerHTML=Za,Dn=s(),pt=o("p"),pt.textContent=Wa,Un=s(),g(ne.$$.fragment),Cn=s(),ct=o("p"),ct.innerHTML=Fa,Zn=s(),g(ae.$$.fragment),Wn=s(),P=o("div"),g(ke.$$.fragment),Fn=s(),ft=o("p"),ft.innerHTML=La,Ln=s(),mt=o("p"),mt.innerHTML=Ga,Gn=s(),ut=o("p"),ut.innerHTML=Na,Nn=s(),gt=o("p"),gt.innerHTML=Ba,Bn=s(),ht=o("p"),ht.innerHTML=Xa,Xn=s(),se=o("div"),g(Se.$$.fragment),Vn=s(),_t=o("p"),_t.textContent=Va,En=s(),ie=o("div"),g(Pe.$$.fragment),zn=s(),bt=o("p"),bt.textContent=Ea,Rn=s(),oe=o("div"),g(je.$$.fragment),Hn=s(),vt=o("p"),vt.innerHTML=za,Yn=s(),re=o("div"),g(De.$$.fragment),An=s(),wt=o("p"),wt.innerHTML=Ra,Qn=s(),W=o("div"),g(Ue.$$.fragment),qn=s(),yt=o("p"),yt.innerHTML=Ha,On=s(),xt=o("p"),xt.textContent=Ya,Kn=s(),$t=o("p"),$t.innerHTML=Aa,ea=s(),le=o("div"),g(Ce.$$.fragment),ta=s(),It=o("p"),It.textContent=Qa,na=s(),de=o("div"),g(Ze.$$.fragment),aa=s(),Mt=o("p"),Mt.textContent=qa,sa=s(),pe=o("div"),g(We.$$.fragment),ia=s(),Tt=o("p"),Tt.textContent=Oa,oa=s(),X=o("div"),g(Fe.$$.fragment),ra=s(),Jt=o("p"),Jt.textContent=Ka,la=s(),g(ce.$$.fragment),da=s(),fe=o("div"),g(Le.$$.fragment),pa=s(),kt=o("p"),kt.innerHTML=es,ca=s(),V=o("div"),g(Ge.$$.fragment),fa=s(),St=o("p"),St.textContent=ts,ma=s(),g(me.$$.fragment),Qt=s(),g(Ne.$$.fragment),qt=s(),R=o("div"),g(Be.$$.fragment),ua=s(),Pt=o("p"),Pt.textContent=ns,Ot=s(),g(Xe.$$.fragment),Kt=s(),j=o("div"),g(Ve.$$.fragment),ga=s(),jt=o("p"),jt.textContent=as,ha=s(),g(ue.$$.fragment),_a=s(),Dt=o("p"),Dt.innerHTML=ss,ba=s(),E=o("div"),g(Ee.$$.fragment),va=s(),Ut=o("p"),Ut.textContent=is,wa=s(),g(ge.$$.fragment),en=s(),g(ze.$$.fragment),tn=s(),L=o("div"),g(Re.$$.fragment),ya=s(),Ct=o("p"),Ct.textContent=os,xa=s(),he=o("div"),g(He.$$.fragment),$a=s(),Zt=o("p"),Zt.textContent=rs,nn=s(),Et=o("p"),this.h()},l(e){const c=fs("svelte-u9bgzb",document.head);n=r(c,"META",{name:!0,content:!0}),c.forEach(l),x=i(e),d=r(e,"P",{}),T(d).forEach(l),p=i(e),h($.$$.fragment,e),a=i(e),I=r(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-duffv7"&&(I.textContent=Ia),zt=i(e),h(be.$$.fragment,e),Rt=i(e),ve=r(e,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-92b9uj"&&(ve.innerHTML=Ma),Ht=i(e),h(Y.$$.fragment,e),Yt=i(e),h(we.$$.fragment,e),At=i(e),f=r(e,"DIV",{class:!0});var u=T(f);h(ye.$$.fragment,u),cn=i(u),et=r(u,"P",{"data-svelte-h":!0}),m(et)!=="svelte-80nqwb"&&(et.textContent=Ta),fn=i(u),tt=r(u,"P",{"data-svelte-h":!0}),m(tt)!=="svelte-496sm0"&&(tt.innerHTML=Ja),mn=i(u),nt=r(u,"P",{"data-svelte-h":!0}),m(nt)!=="svelte-14s6m4u"&&(nt.textContent=ka),un=i(u),at=r(u,"UL",{"data-svelte-h":!0}),m(at)!=="svelte-t3myqb"&&(at.innerHTML=Sa),gn=i(u),B=r(u,"DIV",{class:!0});var H=T(B);h(xe.$$.fragment,H),hn=i(H),st=r(H,"P",{"data-svelte-h":!0}),m(st)!=="svelte-50j04k"&&(st.textContent=Pa),_n=i(H),h(A.$$.fragment,H),H.forEach(l),bn=i(u),C=r(u,"DIV",{class:!0});var G=T(C);h($e.$$.fragment,G),vn=i(G),it=r(G,"P",{"data-svelte-h":!0}),m(it)!=="svelte-10jaql7"&&(it.textContent=ja),wn=i(G),h(Q.$$.fragment,G),yn=i(G),h(q.$$.fragment,G),G.forEach(l),xn=i(u),O=r(u,"DIV",{class:!0});var Ye=T(O);h(Ie.$$.fragment,Ye),$n=i(Ye),ot=r(Ye,"P",{"data-svelte-h":!0}),m(ot)!=="svelte-1lh0nh5"&&(ot.innerHTML=Da),Ye.forEach(l),In=i(u),Z=r(u,"DIV",{class:!0});var N=T(Z);h(Me.$$.fragment,N),Mn=i(N),rt=r(N,"P",{"data-svelte-h":!0}),m(rt)!=="svelte-e03q3e"&&(rt.innerHTML=Ua),Tn=i(N),h(K.$$.fragment,N),Jn=i(N),h(ee.$$.fragment,N),N.forEach(l),kn=i(u),te=r(u,"DIV",{class:!0});var Ae=T(te);h(Te.$$.fragment,Ae),Sn=i(Ae),lt=r(Ae,"P",{"data-svelte-h":!0}),m(lt)!=="svelte-1vfte1e"&&(lt.innerHTML=Ca),Ae.forEach(l),Pn=i(u),S=r(u,"DIV",{class:!0});var D=T(S);h(Je.$$.fragment,D),jn=i(D),dt=r(D,"P",{"data-svelte-h":!0}),m(dt)!=="svelte-1lv88wo"&&(dt.innerHTML=Za),Dn=i(D),pt=r(D,"P",{"data-svelte-h":!0}),m(pt)!=="svelte-11lpom8"&&(pt.textContent=Wa),Un=i(D),h(ne.$$.fragment,D),Cn=i(D),ct=r(D,"P",{"data-svelte-h":!0}),m(ct)!=="svelte-15d7mv5"&&(ct.innerHTML=Fa),Zn=i(D),h(ae.$$.fragment,D),D.forEach(l),Wn=i(u),P=r(u,"DIV",{class:!0});var U=T(P);h(ke.$$.fragment,U),Fn=i(U),ft=r(U,"P",{"data-svelte-h":!0}),m(ft)!=="svelte-vs7s0z"&&(ft.innerHTML=La),Ln=i(U),mt=r(U,"P",{"data-svelte-h":!0}),m(mt)!=="svelte-15b960v"&&(mt.innerHTML=Ga),Gn=i(U),ut=r(U,"P",{"data-svelte-h":!0}),m(ut)!=="svelte-12uyc98"&&(ut.innerHTML=Na),Nn=i(U),gt=r(U,"P",{"data-svelte-h":!0}),m(gt)!=="svelte-1q3yzk7"&&(gt.innerHTML=Ba),Bn=i(U),ht=r(U,"P",{"data-svelte-h":!0}),m(ht)!=="svelte-10xxjud"&&(ht.innerHTML=Xa),U.forEach(l),Xn=i(u),se=r(u,"DIV",{class:!0});var Qe=T(se);h(Se.$$.fragment,Qe),Vn=i(Qe),_t=r(Qe,"P",{"data-svelte-h":!0}),m(_t)!=="svelte-1ufq5ot"&&(_t.textContent=Va),Qe.forEach(l),En=i(u),ie=r(u,"DIV",{class:!0});var qe=T(ie);h(Pe.$$.fragment,qe),zn=i(qe),bt=r(qe,"P",{"data-svelte-h":!0}),m(bt)!=="svelte-psupw6"&&(bt.textContent=Ea),qe.forEach(l),Rn=i(u),oe=r(u,"DIV",{class:!0});var Oe=T(oe);h(je.$$.fragment,Oe),Hn=i(Oe),vt=r(Oe,"P",{"data-svelte-h":!0}),m(vt)!=="svelte-1s3c06i"&&(vt.innerHTML=za),Oe.forEach(l),Yn=i(u),re=r(u,"DIV",{class:!0});var Ke=T(re);h(De.$$.fragment,Ke),An=i(Ke),wt=r(Ke,"P",{"data-svelte-h":!0}),m(wt)!=="svelte-pkn4ui"&&(wt.innerHTML=Ra),Ke.forEach(l),Qn=i(u),W=r(u,"DIV",{class:!0});var _e=T(W);h(Ue.$$.fragment,_e),qn=i(_e),yt=r(_e,"P",{"data-svelte-h":!0}),m(yt)!=="svelte-1f3tmq1"&&(yt.innerHTML=Ha),On=i(_e),xt=r(_e,"P",{"data-svelte-h":!0}),m(xt)!=="svelte-xjijlp"&&(xt.textContent=Ya),Kn=i(_e),$t=r(_e,"P",{"data-svelte-h":!0}),m($t)!=="svelte-hy0nzs"&&($t.innerHTML=Aa),_e.forEach(l),ea=i(u),le=r(u,"DIV",{class:!0});var sn=T(le);h(Ce.$$.fragment,sn),ta=i(sn),It=r(sn,"P",{"data-svelte-h":!0}),m(It)!=="svelte-14bnrb6"&&(It.textContent=Qa),sn.forEach(l),na=i(u),de=r(u,"DIV",{class:!0});var on=T(de);h(Ze.$$.fragment,on),aa=i(on),Mt=r(on,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-1xwrf7t"&&(Mt.textContent=qa),on.forEach(l),sa=i(u),pe=r(u,"DIV",{class:!0});var rn=T(pe);h(We.$$.fragment,rn),ia=i(rn),Tt=r(rn,"P",{"data-svelte-h":!0}),m(Tt)!=="svelte-16q0ax1"&&(Tt.textContent=Oa),rn.forEach(l),oa=i(u),X=r(u,"DIV",{class:!0});var Wt=T(X);h(Fe.$$.fragment,Wt),ra=i(Wt),Jt=r(Wt,"P",{"data-svelte-h":!0}),m(Jt)!=="svelte-le0q9u"&&(Jt.textContent=Ka),la=i(Wt),h(ce.$$.fragment,Wt),Wt.forEach(l),da=i(u),fe=r(u,"DIV",{class:!0});var ln=T(fe);h(Le.$$.fragment,ln),pa=i(ln),kt=r(ln,"P",{"data-svelte-h":!0}),m(kt)!=="svelte-vo59ec"&&(kt.innerHTML=es),ln.forEach(l),ca=i(u),V=r(u,"DIV",{class:!0});var Ft=T(V);h(Ge.$$.fragment,Ft),fa=i(Ft),St=r(Ft,"P",{"data-svelte-h":!0}),m(St)!=="svelte-fohozp"&&(St.textContent=ts),ma=i(Ft),h(me.$$.fragment,Ft),Ft.forEach(l),u.forEach(l),Qt=i(e),h(Ne.$$.fragment,e),qt=i(e),R=r(e,"DIV",{class:!0});var dn=T(R);h(Be.$$.fragment,dn),ua=i(dn),Pt=r(dn,"P",{"data-svelte-h":!0}),m(Pt)!=="svelte-1qpjiuf"&&(Pt.textContent=ns),dn.forEach(l),Ot=i(e),h(Xe.$$.fragment,e),Kt=i(e),j=r(e,"DIV",{class:!0});var z=T(j);h(Ve.$$.fragment,z),ga=i(z),jt=r(z,"P",{"data-svelte-h":!0}),m(jt)!=="svelte-1ieif9y"&&(jt.textContent=as),ha=i(z),h(ue.$$.fragment,z),_a=i(z),Dt=r(z,"P",{"data-svelte-h":!0}),m(Dt)!=="svelte-knddhk"&&(Dt.innerHTML=ss),ba=i(z),E=r(z,"DIV",{class:!0});var Lt=T(E);h(Ee.$$.fragment,Lt),va=i(Lt),Ut=r(Lt,"P",{"data-svelte-h":!0}),m(Ut)!=="svelte-v78lg8"&&(Ut.textContent=is),wa=i(Lt),h(ge.$$.fragment,Lt),Lt.forEach(l),z.forEach(l),en=i(e),h(ze.$$.fragment,e),tn=i(e),L=r(e,"DIV",{class:!0});var Gt=T(L);h(Re.$$.fragment,Gt),ya=i(Gt),Ct=r(Gt,"P",{"data-svelte-h":!0}),m(Ct)!=="svelte-wzv2jc"&&(Ct.textContent=os),xa=i(Gt),he=r(Gt,"DIV",{class:!0});var pn=T(he);h(He.$$.fragment,pn),$a=i(pn),Zt=r(pn,"P",{"data-svelte-h":!0}),m(Zt)!=="svelte-5ihtpa"&&(Zt.textContent=rs),pn.forEach(l),Gt.forEach(l),nn=i(e),Et=r(e,"P",{}),T(Et).forEach(l),this.h()},h(){J(n,"name","hf:doc:metadata"),J(n,"content",Ts),J(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){t(document.head,n),y(e,x,c),y(e,d,c),y(e,p,c),_($,e,c),y(e,a,c),y(e,I,c),y(e,zt,c),_(be,e,c),y(e,Rt,c),y(e,ve,c),y(e,Ht,c),_(Y,e,c),y(e,Yt,c),_(we,e,c),y(e,At,c),y(e,f,c),_(ye,f,null),t(f,cn),t(f,et),t(f,fn),t(f,tt),t(f,mn),t(f,nt),t(f,un),t(f,at),t(f,gn),t(f,B),_(xe,B,null),t(B,hn),t(B,st),t(B,_n),_(A,B,null),t(f,bn),t(f,C),_($e,C,null),t(C,vn),t(C,it),t(C,wn),_(Q,C,null),t(C,yn),_(q,C,null),t(f,xn),t(f,O),_(Ie,O,null),t(O,$n),t(O,ot),t(f,In),t(f,Z),_(Me,Z,null),t(Z,Mn),t(Z,rt),t(Z,Tn),_(K,Z,null),t(Z,Jn),_(ee,Z,null),t(f,kn),t(f,te),_(Te,te,null),t(te,Sn),t(te,lt),t(f,Pn),t(f,S),_(Je,S,null),t(S,jn),t(S,dt),t(S,Dn),t(S,pt),t(S,Un),_(ne,S,null),t(S,Cn),t(S,ct),t(S,Zn),_(ae,S,null),t(f,Wn),t(f,P),_(ke,P,null),t(P,Fn),t(P,ft),t(P,Ln),t(P,mt),t(P,Gn),t(P,ut),t(P,Nn),t(P,gt),t(P,Bn),t(P,ht),t(f,Xn),t(f,se),_(Se,se,null),t(se,Vn),t(se,_t),t(f,En),t(f,ie),_(Pe,ie,null),t(ie,zn),t(ie,bt),t(f,Rn),t(f,oe),_(je,oe,null),t(oe,Hn),t(oe,vt),t(f,Yn),t(f,re),_(De,re,null),t(re,An),t(re,wt),t(f,Qn),t(f,W),_(Ue,W,null),t(W,qn),t(W,yt),t(W,On),t(W,xt),t(W,Kn),t(W,$t),t(f,ea),t(f,le),_(Ce,le,null),t(le,ta),t(le,It),t(f,na),t(f,de),_(Ze,de,null),t(de,aa),t(de,Mt),t(f,sa),t(f,pe),_(We,pe,null),t(pe,ia),t(pe,Tt),t(f,oa),t(f,X),_(Fe,X,null),t(X,ra),t(X,Jt),t(X,la),_(ce,X,null),t(f,da),t(f,fe),_(Le,fe,null),t(fe,pa),t(fe,kt),t(f,ca),t(f,V),_(Ge,V,null),t(V,fa),t(V,St),t(V,ma),_(me,V,null),y(e,Qt,c),_(Ne,e,c),y(e,qt,c),y(e,R,c),_(Be,R,null),t(R,ua),t(R,Pt),y(e,Ot,c),_(Xe,e,c),y(e,Kt,c),y(e,j,c),_(Ve,j,null),t(j,ga),t(j,jt),t(j,ha),_(ue,j,null),t(j,_a),t(j,Dt),t(j,ba),t(j,E),_(Ee,E,null),t(E,va),t(E,Ut),t(E,wa),_(ge,E,null),y(e,en,c),_(ze,e,c),y(e,tn,c),y(e,L,c),_(Re,L,null),t(L,ya),t(L,Ct),t(L,xa),t(L,he),_(He,he,null),t(he,$a),t(he,Zt),y(e,nn,c),y(e,Et,c),an=!0},p(e,[c]){const u={};c&2&&(u.$$scope={dirty:c,ctx:e}),Y.$set(u);const H={};c&2&&(H.$$scope={dirty:c,ctx:e}),A.$set(H);const G={};c&2&&(G.$$scope={dirty:c,ctx:e}),Q.$set(G);const Ye={};c&2&&(Ye.$$scope={dirty:c,ctx:e}),q.$set(Ye);const N={};c&2&&(N.$$scope={dirty:c,ctx:e}),K.$set(N);const Ae={};c&2&&(Ae.$$scope={dirty:c,ctx:e}),ee.$set(Ae);const D={};c&2&&(D.$$scope={dirty:c,ctx:e}),ne.$set(D);const U={};c&2&&(U.$$scope={dirty:c,ctx:e}),ae.$set(U);const Qe={};c&2&&(Qe.$$scope={dirty:c,ctx:e}),ce.$set(Qe);const qe={};c&2&&(qe.$$scope={dirty:c,ctx:e}),me.$set(qe);const Oe={};c&2&&(Oe.$$scope={dirty:c,ctx:e}),ue.$set(Oe);const Ke={};c&2&&(Ke.$$scope={dirty:c,ctx:e}),ge.$set(Ke)},i(e){an||(b($.$$.fragment,e),b(be.$$.fragment,e),b(Y.$$.fragment,e),b(we.$$.fragment,e),b(ye.$$.fragment,e),b(xe.$$.fragment,e),b(A.$$.fragment,e),b($e.$$.fragment,e),b(Q.$$.fragment,e),b(q.$$.fragment,e),b(Ie.$$.fragment,e),b(Me.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(Te.$$.fragment,e),b(Je.$$.fragment,e),b(ne.$$.fragment,e),b(ae.$$.fragment,e),b(ke.$$.fragment,e),b(Se.$$.fragment,e),b(Pe.$$.fragment,e),b(je.$$.fragment,e),b(De.$$.fragment,e),b(Ue.$$.fragment,e),b(Ce.$$.fragment,e),b(Ze.$$.fragment,e),b(We.$$.fragment,e),b(Fe.$$.fragment,e),b(ce.$$.fragment,e),b(Le.$$.fragment,e),b(Ge.$$.fragment,e),b(me.$$.fragment,e),b(Ne.$$.fragment,e),b(Be.$$.fragment,e),b(Xe.$$.fragment,e),b(Ve.$$.fragment,e),b(ue.$$.fragment,e),b(Ee.$$.fragment,e),b(ge.$$.fragment,e),b(ze.$$.fragment,e),b(Re.$$.fragment,e),b(He.$$.fragment,e),an=!0)},o(e){v($.$$.fragment,e),v(be.$$.fragment,e),v(Y.$$.fragment,e),v(we.$$.fragment,e),v(ye.$$.fragment,e),v(xe.$$.fragment,e),v(A.$$.fragment,e),v($e.$$.fragment,e),v(Q.$$.fragment,e),v(q.$$.fragment,e),v(Ie.$$.fragment,e),v(Me.$$.fragment,e),v(K.$$.fragment,e),v(ee.$$.fragment,e),v(Te.$$.fragment,e),v(Je.$$.fragment,e),v(ne.$$.fragment,e),v(ae.$$.fragment,e),v(ke.$$.fragment,e),v(Se.$$.fragment,e),v(Pe.$$.fragment,e),v(je.$$.fragment,e),v(De.$$.fragment,e),v(Ue.$$.fragment,e),v(Ce.$$.fragment,e),v(Ze.$$.fragment,e),v(We.$$.fragment,e),v(Fe.$$.fragment,e),v(ce.$$.fragment,e),v(Le.$$.fragment,e),v(Ge.$$.fragment,e),v(me.$$.fragment,e),v(Ne.$$.fragment,e),v(Be.$$.fragment,e),v(Xe.$$.fragment,e),v(Ve.$$.fragment,e),v(ue.$$.fragment,e),v(Ee.$$.fragment,e),v(ge.$$.fragment,e),v(ze.$$.fragment,e),v(Re.$$.fragment,e),v(He.$$.fragment,e),an=!1},d(e){e&&(l(x),l(d),l(p),l(a),l(I),l(zt),l(Rt),l(ve),l(Ht),l(Yt),l(At),l(f),l(Qt),l(qt),l(R),l(Ot),l(Kt),l(j),l(en),l(tn),l(L),l(nn),l(Et)),l(n),w($,e),w(be,e),w(Y,e),w(we,e),w(ye),w(xe),w(A),w($e),w(Q),w(q),w(Ie),w(Me),w(K),w(ee),w(Te),w(Je),w(ne),w(ae),w(ke),w(Se),w(Pe),w(je),w(De),w(Ue),w(Ce),w(Ze),w(We),w(Fe),w(ce),w(Le),w(Ge),w(me),w(Ne,e),w(Be),w(Xe,e),w(Ve),w(ue),w(Ee),w(ge),w(ze,e),w(Re),w(He)}}}const Ts='{"title":"Inpainting","local":"inpainting","sections":[{"title":"Tips","local":"tips","sections":[],"depth":2},{"title":"StableDiffusionInpaintPipeline","local":"diffusers.StableDiffusionInpaintPipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2},{"title":"FlaxStableDiffusionInpaintPipeline","local":"diffusers.FlaxStableDiffusionInpaintPipeline","sections":[],"depth":2},{"title":"FlaxStableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function Js(M){return ds(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zs extends ps{constructor(n){super(),cs(this,n,Js,Ms,ls,{})}}export{Zs as component};
