import{s as al,o as il,n as us}from"../chunks/scheduler.182ea377.js";import{S as ol,i as pl,g as i,s as n,r as u,A as rl,h as o,f as s,c as a,j as nl,u as f,x as p,k as ps,y as ul,a as l,v as d,d as m,t as c,w as h}from"../chunks/index.abf12888.js";import{T as rs}from"../chunks/Tip.230e2334.js";import{C as y}from"../chunks/CodeBlock.57fe6e13.js";import{D as fl}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as De}from"../chunks/Heading.16916d63.js";function dl(M){let r,b='The quicktour is a simplified version of the introductory 🧨 Diffusers <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers/diffusers_intro.ipynb" rel="nofollow">notebook</a> to help you get started quickly. If you want to learn more about 🧨 Diffusers’ goal, design philosophy, and additional details about its core API, check out the notebook!';return{c(){r=i("p"),r.innerHTML=b},l(g){r=o(g,"P",{"data-svelte-h":!0}),p(r)!=="svelte-10po4bc"&&(r.innerHTML=b)},m(g,w){l(g,r,w)},p:us,d(g){g&&s(r)}}}function ml(M){let r,b='For <a href="https://huggingface.co/CompVis/stable-diffusion" rel="nofollow">Stable Diffusion</a> models, please carefully read the <a href="https://huggingface.co/spaces/CompVis/stable-diffusion-license" rel="nofollow">license</a> first before running the model. 🧨 Diffusers implements a <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/safety_checker.py" rel="nofollow"><code>safety_checker</code></a> to prevent offensive or harmful content, but the model’s improved image generation capabilities can still produce potentially harmful content.';return{c(){r=i("p"),r.innerHTML=b},l(g){r=o(g,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1rkwh7b"&&(r.innerHTML=b)},m(g,w){l(g,r,w)},p:us,d(g){g&&s(r)}}}function cl(M){let r,b='🧨 Diffusers is a toolbox for building diffusion systems. While the <a href="/docs/diffusers/v0.22.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> is a convenient way to get started with a pre-built diffusion system, you can also choose your own model and scheduler components separately to build a custom diffusion system.';return{c(){r=i("p"),r.innerHTML=b},l(g){r=o(g,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1jox9qh"&&(r.innerHTML=b)},m(g,w){l(g,r,w)},p:us,d(g){g&&s(r)}}}function hl(M){let r,b="💡 Unlike a model, a scheduler does not have trainable weights and is parameter-free!";return{c(){r=i("p"),r.textContent=b},l(g){r=o(g,"P",{"data-svelte-h":!0}),p(r)!=="svelte-12uexhh"&&(r.textContent=b)},m(g,w){l(g,r,w)},p:us,d(g){g&&s(r)}}}function gl(M){let r,b,g,w,k,Ne,C,Ve,x,fs="Diffusion models are trained to denoise random Gaussian noise step-by-step to generate a sample of interest, such as an image or audio. This has sparked a tremendous amount of interest in generative AI, and you have probably seen examples of diffusion generated images on the internet. 🧨 Diffusers is a library aimed at making diffusion models widely accessible to everyone.",ze,Z,ds="Whether you’re a developer or an everyday user, this quicktour will introduce you to 🧨 Diffusers and help you get up and generating quickly! There are three main components of the library to know about:",Xe,J,ms='<li>The <a href="/docs/diffusers/v0.22.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> is a high-level end-to-end class designed to rapidly generate samples from pretrained diffusion models for inference.</li> <li>Popular pretrained <a href="./api/models">model</a> architectures and modules that can be used as building blocks for creating diffusion systems.</li> <li>Many different <a href="./api/schedulers/overview">schedulers</a> - algorithms that control how noise is added for training, and how to generate denoised images during inference.</li>',Ye,G,cs='The quicktour will show you how to use the <a href="/docs/diffusers/v0.22.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> for inference, and then walk you through how to combine a model and scheduler to replicate what’s happening inside the <a href="/docs/diffusers/v0.22.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>.',Re,$,Ee,q,hs="Before you begin, make sure you have all the necessary libraries installed:",Fe,W,Qe,S,gs='<li><a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">🤗 Accelerate</a> speeds up model loading for inference and training.</li> <li><a href="https://huggingface.co/docs/transformers/index" rel="nofollow">🤗 Transformers</a> is required to run the most popular diffusion models, such as <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/overview" rel="nofollow">Stable Diffusion</a>.</li>',Ae,H,Ke,I,ys='The <a href="/docs/diffusers/v0.22.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> is the easiest way to use a pretrained diffusion system for inference. It is an end-to-end system containing the model and the scheduler. You can use the <a href="/docs/diffusers/v0.22.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> out-of-the-box for many tasks. Take a look at the table below for some supported tasks, and for a complete list of supported tasks, check out the <a href="./api/pipelines/overview#diffusers-summary">🧨 Diffusers Summary</a> table.',Oe,P,bs='<thead><tr><th><strong>Task</strong></th> <th><strong>Description</strong></th> <th><strong>Pipeline</strong></th></tr></thead> <tbody><tr><td>Unconditional Image Generation</td> <td>generate an image from Gaussian noise</td> <td><a href="./using-diffusers/unconditional_image_generation">unconditional_image_generation</a></td></tr> <tr><td>Text-Guided Image Generation</td> <td>generate an image given a text prompt</td> <td><a href="./using-diffusers/conditional_image_generation">conditional_image_generation</a></td></tr> <tr><td>Text-Guided Image-to-Image Translation</td> <td>adapt an image guided by a text prompt</td> <td><a href="./using-diffusers/img2img">img2img</a></td></tr> <tr><td>Text-Guided Image-Inpainting</td> <td>fill the masked part of an image given the image, the mask and a text prompt</td> <td><a href="./using-diffusers/inpaint">inpaint</a></td></tr> <tr><td>Text-Guided Depth-to-Image Translation</td> <td>adapt parts of an image guided by a text prompt while preserving structure via depth estimation</td> <td><a href="./using-diffusers/depth2img">depth2img</a></td></tr></tbody>',et,L,ws=`Start by creating an instance of a <a href="/docs/diffusers/v0.22.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> and specify which pipeline checkpoint you would like to download.
You can use the <a href="/docs/diffusers/v0.22.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> for any <a href="https://huggingface.co/models?library=diffusers&amp;sort=downloads" rel="nofollow">checkpoint</a> stored on the Hugging Face Hub.
In this quicktour, you’ll load the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>stable-diffusion-v1-5</code></a> checkpoint for text-to-image generation.`,tt,j,st,D,Ms='Load the model with the <a href="/docs/diffusers/v0.22.1/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method:',lt,B,nt,N,$s='The <a href="/docs/diffusers/v0.22.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> downloads and caches all modeling, tokenization, and scheduling components. You’ll see that the Stable Diffusion pipeline is composed of the <a href="/docs/diffusers/v0.22.1/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> and <a href="/docs/diffusers/v0.22.1/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a> among other things:',at,V,it,z,js=`We strongly recommend running the pipeline on a GPU because the model consists of roughly 1.4 billion parameters.
You can move the generator object to a GPU, just like you would in PyTorch:`,ot,X,pt,Y,vs='Now you can pass a text prompt to the <code>pipeline</code> to generate an image, and then access the denoised image. By default, the image output is wrapped in a <a href="https://pillow.readthedocs.io/en/stable/reference/Image.html?highlight=image#the-image-class" rel="nofollow"><code>PIL.Image</code></a> object.',rt,R,ut,v,Ts='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/image_of_squirrel_painting.png"/>',ft,E,_s="Save the image by calling <code>save</code>:",dt,F,mt,Q,ct,A,Us="You can also use the pipeline locally. The only difference is you need to download the weights first:",ht,K,gt,O,ks="Then load the saved weights into the pipeline:",yt,ee,bt,te,Cs="Now, you can run the pipeline as you would in the section above.",wt,se,Mt,le,xs='Different schedulers come with different denoising speeds and quality trade-offs. The best way to find out which one works best for you is to try them out! One of the main features of 🧨 Diffusers is to allow you to easily switch between schedulers. For example, to replace the default <a href="/docs/diffusers/v0.22.1/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a> with the <a href="/docs/diffusers/v0.22.1/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a>, load it with the <a href="/docs/diffusers/v0.22.1/en/api/configuration#diffusers.ConfigMixin.from_config">from_config()</a> method:',$t,ne,jt,ae,Zs="Try generating an image with the new scheduler and see if you notice a difference!",vt,ie,Js='In the next section, you’ll take a closer look at the components - the model and scheduler - that make up the <a href="/docs/diffusers/v0.22.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> and learn how to use these components to generate an image of a cat.',Tt,oe,_t,pe,Gs='Most models take a noisy sample, and at each timestep it predicts the <em>noise residual</em> (other models learn to predict the previous sample directly or the velocity or <a href="https://github.com/huggingface/diffusers/blob/5e5ce13e2f89ac45a0066cb3f369462a3cf1d9ef/src/diffusers/schedulers/scheduling_ddim.py#L110" rel="nofollow"><code>v-prediction</code></a>), the difference between a less noisy image and the input image. You can mix and match models to create other diffusion systems.',Ut,re,qs='Models are initiated with the <a href="/docs/diffusers/v0.22.1/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> method which also locally caches the model weights so it is faster the next time you load the model. For the quicktour, you’ll load the <a href="/docs/diffusers/v0.22.1/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a>, a basic unconditional image generation model with a checkpoint trained on cat images:',kt,ue,Ct,fe,Ws="To access the model parameters, call <code>model.config</code>:",xt,de,Zt,me,Ss="The model configuration is a 🧊 frozen 🧊 dictionary, which means those parameters can’t be changed after the model is created. This is intentional and ensures that the parameters used to define the model architecture at the start remain the same, while other parameters can still be adjusted during inference.",Jt,ce,Hs="Some of the most important parameters are:",Gt,he,Is="<li><code>sample_size</code>: the height and width dimension of the input sample.</li> <li><code>in_channels</code>: the number of input channels of the input sample.</li> <li><code>down_block_types</code> and <code>up_block_types</code>: the type of down- and upsampling blocks used to create the UNet architecture.</li> <li><code>block_out_channels</code>: the number of output channels of the downsampling blocks; also used in reverse order for the number of input channels of the upsampling blocks.</li> <li><code>layers_per_block</code>: the number of ResNet blocks present in each UNet block.</li>",qt,ge,Ps="To use the model for inference, create the image shape with random Gaussian noise. It should have a <code>batch</code> axis because the model can receive multiple random noises, a <code>channel</code> axis corresponding to the number of input channels, and a <code>sample_size</code> axis for the height and width of the image:",Wt,ye,St,be,Ls="For inference, pass the noisy image and a <code>timestep</code> to the model. The <code>timestep</code> indicates how noisy the input image is, with more noise at the beginning and less at the end. This helps the model determine its position in the diffusion process, whether it is closer to the start or the end. Use the <code>sample</code> method to get the model output:",Ht,we,It,Me,Ds="To generate actual examples though, you’ll need a scheduler to guide the denoising process. In the next section, you’ll learn how to couple a model with a scheduler.",Pt,$e,Lt,je,Bs="Schedulers manage going from a noisy sample to a less noisy sample given the model output - in this case, it is the <code>noisy_residual</code>.",Dt,T,Bt,ve,Ns='For the quicktour, you’ll instantiate the <a href="/docs/diffusers/v0.22.1/en/api/schedulers/ddpm#diffusers.DDPMScheduler">DDPMScheduler</a> with its <a href="/docs/diffusers/v0.22.1/en/api/configuration#diffusers.ConfigMixin.from_config">from_config()</a> method:',Nt,Te,Vt,_,zt,_e,Vs="Some of the most important parameters are:",Xt,Ue,zs="<li><code>num_train_timesteps</code>: the length of the denoising process or, in other words, the number of timesteps required to process random Gaussian noise into a data sample.</li> <li><code>beta_schedule</code>: the type of noise schedule to use for inference and training.</li> <li><code>beta_start</code> and <code>beta_end</code>: the start and end noise values for the noise schedule.</li>",Yt,ke,Xs='To predict a slightly less noisy image, pass the following to the scheduler’s <a href="/docs/diffusers/v0.22.1/en/api/schedulers/ddpm#diffusers.DDPMScheduler.step">step()</a> method: model output, <code>timestep</code>, and current <code>sample</code>.',Rt,Ce,Et,xe,Ys="The <code>less_noisy_sample</code> can be passed to the next <code>timestep</code> where it’ll get even less noisy! Let’s bring it all together now and visualize the entire denoising process.",Ft,Ze,Rs="First, create a function that postprocesses and displays the denoised image as a <code>PIL.Image</code>:",Qt,Je,At,Ge,Es="To speed up the denoising process, move the input and model to a GPU:",Kt,qe,Ot,We,Fs="Now create a denoising loop that predicts the residual of the less noisy sample, and computes the less noisy sample with the scheduler:",es,Se,ts,He,Qs="Sit back and watch as a cat is generated from nothing but noise! 😻",ss,U,As='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/diffusion-quicktour.png"/>',ls,Ie,ns,Pe,Ks="Hopefully, you generated some cool images with 🧨 Diffusers in this quicktour! For your next steps, you can:",as,Le,Os='<li>Train or finetune a model to generate your own images in the <a href="./tutorials/basic_training">training</a> tutorial.</li> <li>See example official and community <a href="https://github.com/huggingface/diffusers/tree/main/examples#-diffusers-examples" rel="nofollow">training or finetuning scripts</a> for a variety of use cases.</li> <li>Learn more about loading, accessing, changing, and comparing schedulers in the <a href="./using-diffusers/schedulers">Using different Schedulers</a> guide.</li> <li>Explore prompt engineering, speed and memory optimizations, and tips and tricks for generating higher-quality images with the <a href="./stable_diffusion">Stable Diffusion</a> guide.</li> <li>Dive deeper into speeding up 🧨 Diffusers with guides on <a href="./optimization/fp16">optimized PyTorch on a GPU</a>, and inference guides for running <a href="./optimization/mps">Stable Diffusion on Apple Silicon (M1/M2)</a> and <a href="./optimization/onnx">ONNX Runtime</a>.</li>',is,Be,os;return k=new fl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/quicktour.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/quicktour.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/quicktour.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/quicktour.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/quicktour.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/quicktour.ipynb"}]}}),C=new De({props:{title:"Quicktour",local:"quicktour",headingTag:"h1"}}),$=new rs({props:{$$slots:{default:[dl]},$$scope:{ctx:M}}}),W=new y({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwLS11cGdyYWRlJTIwZGlmZnVzZXJzJTIwYWNjZWxlcmF0ZSUyMHRyYW5zZm9ybWVycw==",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install --upgrade diffusers accelerate transformers</span>`,wrap:!1}}),H=new De({props:{title:"DiffusionPipeline",local:"diffusionpipeline",headingTag:"h2"}}),j=new rs({props:{warning:!0,$$slots:{default:[ml]},$$scope:{ctx:M}}}),B=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),V=new y({props:{code:"cGlwZWxpbmU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline
StableDiffusionPipeline {
  <span class="hljs-string">&quot;_class_name&quot;</span>: <span class="hljs-string">&quot;StableDiffusionPipeline&quot;</span>,
  <span class="hljs-string">&quot;_diffusers_version&quot;</span>: <span class="hljs-string">&quot;0.21.4&quot;</span>,
  ...,
  <span class="hljs-string">&quot;scheduler&quot;</span>: [
    <span class="hljs-string">&quot;diffusers&quot;</span>,
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  ],
  ...,
  <span class="hljs-string">&quot;unet&quot;</span>: [
    <span class="hljs-string">&quot;diffusers&quot;</span>,
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  ],
  <span class="hljs-string">&quot;vae&quot;</span>: [
    <span class="hljs-string">&quot;diffusers&quot;</span>,
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  ]
}`,wrap:!1}}),X=new y({props:{code:"cGlwZWxpbmUudG8oJTIyY3VkYSUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),R=new y({props:{code:"aW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMjJBbiUyMGltYWdlJTIwb2YlMjBhJTIwc3F1aXJyZWwlMjBpbiUyMFBpY2Fzc28lMjBzdHlsZSUyMikuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipeline(<span class="hljs-string">&quot;An image of a squirrel in Picasso style&quot;</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),F=new y({props:{code:"aW1hZ2Uuc2F2ZSglMjJpbWFnZV9vZl9zcXVpcnJlbF9wYWludGluZy5wbmclMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;image_of_squirrel_painting.png&quot;</span>)',wrap:!1}}),Q=new De({props:{title:"Local pipeline",local:"local-pipeline",headingTag:"h3"}}),K=new y({props:{code:"IWdpdCUyMGxmcyUyMGluc3RhbGwlMEEhZ2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGcnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTU=",highlighted:`!git lfs install
!git <span class="hljs-built_in">clone</span> https://huggingface.co/runwayml/stable-diffusion-v1-5`,wrap:!1}}),ee=new y({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)',wrap:!1}}),se=new De({props:{title:"Swapping schedulers",local:"swapping-schedulers",headingTag:"h3"}}),ne=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwRXVsZXJEaXNjcmV0ZVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> EulerDiscreteScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.scheduler = EulerDiscreteScheduler.from_config(pipeline.scheduler.config)`,wrap:!1}}),oe=new De({props:{title:"Models",local:"models",headingTag:"h2"}}),ue=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRE1vZGVsJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmdvb2dsZSUyRmRkcG0tY2F0LTI1NiUyMiUwQW1vZGVsJTIwJTNEJTIwVU5ldDJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DModel

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DModel.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),de=new y({props:{code:"bW9kZWwuY29uZmln",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.config',wrap:!1}}),ye=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF0b3JjaC5tYW51YWxfc2VlZCgwKSUwQSUwQW5vaXN5X3NhbXBsZSUyMCUzRCUyMHRvcmNoLnJhbmRuKDElMkMlMjBtb2RlbC5jb25maWcuaW5fY2hhbm5lbHMlMkMlMjBtb2RlbC5jb25maWcuc2FtcGxlX3NpemUlMkMlMjBtb2RlbC5jb25maWcuc2FtcGxlX3NpemUpJTBBbm9pc3lfc2FtcGxlLnNoYXBl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_sample = torch.randn(<span class="hljs-number">1</span>, model.config.in_channels, model.config.sample_size, model.config.sample_size)
<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_sample.shape
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">256</span>, <span class="hljs-number">256</span>])`,wrap:!1}}),we=new y({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG5vaXN5X3Jlc2lkdWFsJTIwJTNEJTIwbW9kZWwoc2FtcGxlJTNEbm9pc3lfc2FtcGxlJTJDJTIwdGltZXN0ZXAlM0QyKS5zYW1wbGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    noisy_residual = model(sample=noisy_sample, timestep=<span class="hljs-number">2</span>).sample`,wrap:!1}}),$e=new De({props:{title:"Schedulers",local:"schedulers",headingTag:"h2"}}),T=new rs({props:{$$slots:{default:[cl]},$$scope:{ctx:M}}}),Te=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1TY2hlZHVsZXIlMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBERFBNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkKSUwQXNjaGVkdWxlcg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = DDPMScheduler.from_pretrained(repo_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler
DDPMScheduler {
  <span class="hljs-string">&quot;_class_name&quot;</span>: <span class="hljs-string">&quot;DDPMScheduler&quot;</span>,
  <span class="hljs-string">&quot;_diffusers_version&quot;</span>: <span class="hljs-string">&quot;0.21.4&quot;</span>,
  <span class="hljs-string">&quot;beta_end&quot;</span>: <span class="hljs-number">0.02</span>,
  <span class="hljs-string">&quot;beta_schedule&quot;</span>: <span class="hljs-string">&quot;linear&quot;</span>,
  <span class="hljs-string">&quot;beta_start&quot;</span>: <span class="hljs-number">0.0001</span>,
  <span class="hljs-string">&quot;clip_sample&quot;</span>: true,
  <span class="hljs-string">&quot;clip_sample_range&quot;</span>: <span class="hljs-number">1.0</span>,
  <span class="hljs-string">&quot;dynamic_thresholding_ratio&quot;</span>: <span class="hljs-number">0.995</span>,
  <span class="hljs-string">&quot;num_train_timesteps&quot;</span>: <span class="hljs-number">1000</span>,
  <span class="hljs-string">&quot;prediction_type&quot;</span>: <span class="hljs-string">&quot;epsilon&quot;</span>,
  <span class="hljs-string">&quot;sample_max_value&quot;</span>: <span class="hljs-number">1.0</span>,
  <span class="hljs-string">&quot;steps_offset&quot;</span>: <span class="hljs-number">0</span>,
  <span class="hljs-string">&quot;thresholding&quot;</span>: false,
  <span class="hljs-string">&quot;timestep_spacing&quot;</span>: <span class="hljs-string">&quot;leading&quot;</span>,
  <span class="hljs-string">&quot;trained_betas&quot;</span>: null,
  <span class="hljs-string">&quot;variance_type&quot;</span>: <span class="hljs-string">&quot;fixed_small&quot;</span>
}`,wrap:!1}}),_=new rs({props:{$$slots:{default:[hl]},$$scope:{ctx:M}}}),Ce=new y({props:{code:"bGVzc19ub2lzeV9zYW1wbGUlMjAlM0QlMjBzY2hlZHVsZXIuc3RlcChtb2RlbF9vdXRwdXQlM0Rub2lzeV9yZXNpZHVhbCUyQyUyMHRpbWVzdGVwJTNEMiUyQyUyMHNhbXBsZSUzRG5vaXN5X3NhbXBsZSkucHJldl9zYW1wbGUlMEFsZXNzX25vaXN5X3NhbXBsZS5zaGFwZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>less_noisy_sample = scheduler.step(model_output=noisy_residual, timestep=<span class="hljs-number">2</span>, sample=noisy_sample).prev_sample
<span class="hljs-meta">&gt;&gt;&gt; </span>less_noisy_sample.shape
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">256</span>, <span class="hljs-number">256</span>])`,wrap:!1}}),Je=new y({props:{code:"aW1wb3J0JTIwUElMLkltYWdlJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwZGlzcGxheV9zYW1wbGUoc2FtcGxlJTJDJTIwaSklM0ElMEElMjAlMjAlMjAlMjBpbWFnZV9wcm9jZXNzZWQlMjAlM0QlMjBzYW1wbGUuY3B1KCkucGVybXV0ZSgwJTJDJTIwMiUyQyUyMDMlMkMlMjAxKSUwQSUyMCUyMCUyMCUyMGltYWdlX3Byb2Nlc3NlZCUyMCUzRCUyMChpbWFnZV9wcm9jZXNzZWQlMjAlMkIlMjAxLjApJTIwKiUyMDEyNy41JTBBJTIwJTIwJTIwJTIwaW1hZ2VfcHJvY2Vzc2VkJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc2VkLm51bXB5KCkuYXN0eXBlKG5wLnVpbnQ4KSUwQSUwQSUyMCUyMCUyMCUyMGltYWdlX3BpbCUyMCUzRCUyMFBJTC5JbWFnZS5mcm9tYXJyYXkoaW1hZ2VfcHJvY2Vzc2VkJTVCMCU1RCklMEElMjAlMjAlMjAlMjBkaXNwbGF5KGYlMjJJbWFnZSUyMGF0JTIwc3RlcCUyMCU3QmklN0QlMjIpJTBBJTIwJTIwJTIwJTIwZGlzcGxheShpbWFnZV9waWwp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL.Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">display_sample</span>(<span class="hljs-params">sample, i</span>):
<span class="hljs-meta">... </span>    image_processed = sample.cpu().permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    image_processed = (image_processed + <span class="hljs-number">1.0</span>) * <span class="hljs-number">127.5</span>
<span class="hljs-meta">... </span>    image_processed = image_processed.numpy().astype(np.uint8)

<span class="hljs-meta">... </span>    image_pil = PIL.Image.fromarray(image_processed[<span class="hljs-number">0</span>])
<span class="hljs-meta">... </span>    display(<span class="hljs-string">f&quot;Image at step <span class="hljs-subst">{i}</span>&quot;</span>)
<span class="hljs-meta">... </span>    display(image_pil)`,wrap:!1}}),qe=new y({props:{code:"bW9kZWwudG8oJTIyY3VkYSUyMiklMEFub2lzeV9zYW1wbGUlMjAlM0QlMjBub2lzeV9zYW1wbGUudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_sample = noisy_sample.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Se=new y({props:{code:"aW1wb3J0JTIwdHFkbSUwQSUwQXNhbXBsZSUyMCUzRCUyMG5vaXN5X3NhbXBsZSUwQSUwQWZvciUyMGklMkMlMjB0JTIwaW4lMjBlbnVtZXJhdGUodHFkbS50cWRtKHNjaGVkdWxlci50aW1lc3RlcHMpKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMDEuJTIwcHJlZGljdCUyMG5vaXNlJTIwcmVzaWR1YWwlMEElMjAlMjAlMjAlMjB3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzaWR1YWwlMjAlM0QlMjBtb2RlbChzYW1wbGUlMkMlMjB0KS5zYW1wbGUlMEElMEElMjAlMjAlMjAlMjAlMjMlMjAyLiUyMGNvbXB1dGUlMjBsZXNzJTIwbm9pc3klMjBpbWFnZSUyMGFuZCUyMHNldCUyMHhfdCUyMC0lM0UlMjB4X3QtMSUwQSUyMCUyMCUyMCUyMHNhbXBsZSUyMCUzRCUyMHNjaGVkdWxlci5zdGVwKHJlc2lkdWFsJTJDJTIwdCUyQyUyMHNhbXBsZSkucHJldl9zYW1wbGUlMEElMEElMjAlMjAlMjAlMjAlMjMlMjAzLiUyMG9wdGlvbmFsbHklMjBsb29rJTIwYXQlMjBpbWFnZSUwQSUyMCUyMCUyMCUyMGlmJTIwKGklMjAlMkIlMjAxKSUyMCUyNSUyMDUwJTIwJTNEJTNEJTIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRpc3BsYXlfc2FtcGxlKHNhbXBsZSUyQyUyMGklMjAlMkIlMjAxKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>sample = noisy_sample

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, t <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm.tqdm(scheduler.timesteps)):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># 1. predict noise residual</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        residual = model(sample, t).sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># 2. compute less noisy image and set x_t -&gt; x_t-1</span>
<span class="hljs-meta">... </span>    sample = scheduler.step(residual, t, sample).prev_sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># 3. optionally look at image</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> (i + <span class="hljs-number">1</span>) % <span class="hljs-number">50</span> == <span class="hljs-number">0</span>:
<span class="hljs-meta">... </span>        display_sample(sample, i + <span class="hljs-number">1</span>)`,wrap:!1}}),Ie=new De({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){r=i("meta"),b=n(),g=i("p"),w=n(),u(k.$$.fragment),Ne=n(),u(C.$$.fragment),Ve=n(),x=i("p"),x.textContent=fs,ze=n(),Z=i("p"),Z.textContent=ds,Xe=n(),J=i("ul"),J.innerHTML=ms,Ye=n(),G=i("p"),G.innerHTML=cs,Re=n(),u($.$$.fragment),Ee=n(),q=i("p"),q.textContent=hs,Fe=n(),u(W.$$.fragment),Qe=n(),S=i("ul"),S.innerHTML=gs,Ae=n(),u(H.$$.fragment),Ke=n(),I=i("p"),I.innerHTML=ys,Oe=n(),P=i("table"),P.innerHTML=bs,et=n(),L=i("p"),L.innerHTML=ws,tt=n(),u(j.$$.fragment),st=n(),D=i("p"),D.innerHTML=Ms,lt=n(),u(B.$$.fragment),nt=n(),N=i("p"),N.innerHTML=$s,at=n(),u(V.$$.fragment),it=n(),z=i("p"),z.textContent=js,ot=n(),u(X.$$.fragment),pt=n(),Y=i("p"),Y.innerHTML=vs,rt=n(),u(R.$$.fragment),ut=n(),v=i("div"),v.innerHTML=Ts,ft=n(),E=i("p"),E.innerHTML=_s,dt=n(),u(F.$$.fragment),mt=n(),u(Q.$$.fragment),ct=n(),A=i("p"),A.textContent=Us,ht=n(),u(K.$$.fragment),gt=n(),O=i("p"),O.textContent=ks,yt=n(),u(ee.$$.fragment),bt=n(),te=i("p"),te.textContent=Cs,wt=n(),u(se.$$.fragment),Mt=n(),le=i("p"),le.innerHTML=xs,$t=n(),u(ne.$$.fragment),jt=n(),ae=i("p"),ae.textContent=Zs,vt=n(),ie=i("p"),ie.innerHTML=Js,Tt=n(),u(oe.$$.fragment),_t=n(),pe=i("p"),pe.innerHTML=Gs,Ut=n(),re=i("p"),re.innerHTML=qs,kt=n(),u(ue.$$.fragment),Ct=n(),fe=i("p"),fe.innerHTML=Ws,xt=n(),u(de.$$.fragment),Zt=n(),me=i("p"),me.textContent=Ss,Jt=n(),ce=i("p"),ce.textContent=Hs,Gt=n(),he=i("ul"),he.innerHTML=Is,qt=n(),ge=i("p"),ge.innerHTML=Ps,Wt=n(),u(ye.$$.fragment),St=n(),be=i("p"),be.innerHTML=Ls,Ht=n(),u(we.$$.fragment),It=n(),Me=i("p"),Me.textContent=Ds,Pt=n(),u($e.$$.fragment),Lt=n(),je=i("p"),je.innerHTML=Bs,Dt=n(),u(T.$$.fragment),Bt=n(),ve=i("p"),ve.innerHTML=Ns,Nt=n(),u(Te.$$.fragment),Vt=n(),u(_.$$.fragment),zt=n(),_e=i("p"),_e.textContent=Vs,Xt=n(),Ue=i("ul"),Ue.innerHTML=zs,Yt=n(),ke=i("p"),ke.innerHTML=Xs,Rt=n(),u(Ce.$$.fragment),Et=n(),xe=i("p"),xe.innerHTML=Ys,Ft=n(),Ze=i("p"),Ze.innerHTML=Rs,Qt=n(),u(Je.$$.fragment),At=n(),Ge=i("p"),Ge.textContent=Es,Kt=n(),u(qe.$$.fragment),Ot=n(),We=i("p"),We.textContent=Fs,es=n(),u(Se.$$.fragment),ts=n(),He=i("p"),He.textContent=Qs,ss=n(),U=i("div"),U.innerHTML=As,ls=n(),u(Ie.$$.fragment),ns=n(),Pe=i("p"),Pe.textContent=Ks,as=n(),Le=i("ul"),Le.innerHTML=Os,is=n(),Be=i("p"),this.h()},l(e){const t=rl("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(s),b=a(e),g=o(e,"P",{}),nl(g).forEach(s),w=a(e),f(k.$$.fragment,e),Ne=a(e),f(C.$$.fragment,e),Ve=a(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1cpm7jx"&&(x.textContent=fs),ze=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-3g0auf"&&(Z.textContent=ds),Xe=a(e),J=o(e,"UL",{"data-svelte-h":!0}),p(J)!=="svelte-1yyanfb"&&(J.innerHTML=ms),Ye=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1a1t6xv"&&(G.innerHTML=cs),Re=a(e),f($.$$.fragment,e),Ee=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1c9nexd"&&(q.textContent=hs),Fe=a(e),f(W.$$.fragment,e),Qe=a(e),S=o(e,"UL",{"data-svelte-h":!0}),p(S)!=="svelte-1iag7i0"&&(S.innerHTML=gs),Ae=a(e),f(H.$$.fragment,e),Ke=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-132t8o3"&&(I.innerHTML=ys),Oe=a(e),P=o(e,"TABLE",{"data-svelte-h":!0}),p(P)!=="svelte-1jwscsx"&&(P.innerHTML=bs),et=a(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1c2kh73"&&(L.innerHTML=ws),tt=a(e),f(j.$$.fragment,e),st=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1egeh6m"&&(D.innerHTML=Ms),lt=a(e),f(B.$$.fragment,e),nt=a(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-oyfj0x"&&(N.innerHTML=$s),at=a(e),f(V.$$.fragment,e),it=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1vgclnr"&&(z.textContent=js),ot=a(e),f(X.$$.fragment,e),pt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1p83go0"&&(Y.innerHTML=vs),rt=a(e),f(R.$$.fragment,e),ut=a(e),v=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(v)!=="svelte-6cjtp1"&&(v.innerHTML=Ts),ft=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-10baso4"&&(E.innerHTML=_s),dt=a(e),f(F.$$.fragment,e),mt=a(e),f(Q.$$.fragment,e),ct=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1hfw8pu"&&(A.textContent=Us),ht=a(e),f(K.$$.fragment,e),gt=a(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1fgahuv"&&(O.textContent=ks),yt=a(e),f(ee.$$.fragment,e),bt=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1c18le1"&&(te.textContent=Cs),wt=a(e),f(se.$$.fragment,e),Mt=a(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1ubq4rl"&&(le.innerHTML=xs),$t=a(e),f(ne.$$.fragment,e),jt=a(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-hnrydi"&&(ae.textContent=Zs),vt=a(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-14b1wuy"&&(ie.innerHTML=Js),Tt=a(e),f(oe.$$.fragment,e),_t=a(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-tok5h3"&&(pe.innerHTML=Gs),Ut=a(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1rjww0k"&&(re.innerHTML=qs),kt=a(e),f(ue.$$.fragment,e),Ct=a(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-13d7r4d"&&(fe.innerHTML=Ws),xt=a(e),f(de.$$.fragment,e),Zt=a(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-yz2ttj"&&(me.textContent=Ss),Jt=a(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1xmzk7t"&&(ce.textContent=Hs),Gt=a(e),he=o(e,"UL",{"data-svelte-h":!0}),p(he)!=="svelte-1t4snl"&&(he.innerHTML=Is),qt=a(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-18dlapv"&&(ge.innerHTML=Ps),Wt=a(e),f(ye.$$.fragment,e),St=a(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-u37s0p"&&(be.innerHTML=Ls),Ht=a(e),f(we.$$.fragment,e),It=a(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1c3hoxe"&&(Me.textContent=Ds),Pt=a(e),f($e.$$.fragment,e),Lt=a(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-vj25k8"&&(je.innerHTML=Bs),Dt=a(e),f(T.$$.fragment,e),Bt=a(e),ve=o(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-14k7qjz"&&(ve.innerHTML=Ns),Nt=a(e),f(Te.$$.fragment,e),Vt=a(e),f(_.$$.fragment,e),zt=a(e),_e=o(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1xmzk7t"&&(_e.textContent=Vs),Xt=a(e),Ue=o(e,"UL",{"data-svelte-h":!0}),p(Ue)!=="svelte-7zrky5"&&(Ue.innerHTML=zs),Yt=a(e),ke=o(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-1a2m6d7"&&(ke.innerHTML=Xs),Rt=a(e),f(Ce.$$.fragment,e),Et=a(e),xe=o(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-4pgx4n"&&(xe.innerHTML=Ys),Ft=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1hb61xc"&&(Ze.innerHTML=Rs),Qt=a(e),f(Je.$$.fragment,e),At=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-12lvw8p"&&(Ge.textContent=Es),Kt=a(e),f(qe.$$.fragment,e),Ot=a(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-vtqbzo"&&(We.textContent=Fs),es=a(e),f(Se.$$.fragment,e),ts=a(e),He=o(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-ho6yui"&&(He.textContent=Qs),ss=a(e),U=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(U)!=="svelte-1yzsrw6"&&(U.innerHTML=As),ls=a(e),f(Ie.$$.fragment,e),ns=a(e),Pe=o(e,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-1qc5p28"&&(Pe.textContent=Ks),as=a(e),Le=o(e,"UL",{"data-svelte-h":!0}),p(Le)!=="svelte-32wm8b"&&(Le.innerHTML=Os),is=a(e),Be=o(e,"P",{}),nl(Be).forEach(s),this.h()},h(){ps(r,"name","hf:doc:metadata"),ps(r,"content",yl),ps(v,"class","flex justify-center"),ps(U,"class","flex justify-center")},m(e,t){ul(document.head,r),l(e,b,t),l(e,g,t),l(e,w,t),d(k,e,t),l(e,Ne,t),d(C,e,t),l(e,Ve,t),l(e,x,t),l(e,ze,t),l(e,Z,t),l(e,Xe,t),l(e,J,t),l(e,Ye,t),l(e,G,t),l(e,Re,t),d($,e,t),l(e,Ee,t),l(e,q,t),l(e,Fe,t),d(W,e,t),l(e,Qe,t),l(e,S,t),l(e,Ae,t),d(H,e,t),l(e,Ke,t),l(e,I,t),l(e,Oe,t),l(e,P,t),l(e,et,t),l(e,L,t),l(e,tt,t),d(j,e,t),l(e,st,t),l(e,D,t),l(e,lt,t),d(B,e,t),l(e,nt,t),l(e,N,t),l(e,at,t),d(V,e,t),l(e,it,t),l(e,z,t),l(e,ot,t),d(X,e,t),l(e,pt,t),l(e,Y,t),l(e,rt,t),d(R,e,t),l(e,ut,t),l(e,v,t),l(e,ft,t),l(e,E,t),l(e,dt,t),d(F,e,t),l(e,mt,t),d(Q,e,t),l(e,ct,t),l(e,A,t),l(e,ht,t),d(K,e,t),l(e,gt,t),l(e,O,t),l(e,yt,t),d(ee,e,t),l(e,bt,t),l(e,te,t),l(e,wt,t),d(se,e,t),l(e,Mt,t),l(e,le,t),l(e,$t,t),d(ne,e,t),l(e,jt,t),l(e,ae,t),l(e,vt,t),l(e,ie,t),l(e,Tt,t),d(oe,e,t),l(e,_t,t),l(e,pe,t),l(e,Ut,t),l(e,re,t),l(e,kt,t),d(ue,e,t),l(e,Ct,t),l(e,fe,t),l(e,xt,t),d(de,e,t),l(e,Zt,t),l(e,me,t),l(e,Jt,t),l(e,ce,t),l(e,Gt,t),l(e,he,t),l(e,qt,t),l(e,ge,t),l(e,Wt,t),d(ye,e,t),l(e,St,t),l(e,be,t),l(e,Ht,t),d(we,e,t),l(e,It,t),l(e,Me,t),l(e,Pt,t),d($e,e,t),l(e,Lt,t),l(e,je,t),l(e,Dt,t),d(T,e,t),l(e,Bt,t),l(e,ve,t),l(e,Nt,t),d(Te,e,t),l(e,Vt,t),d(_,e,t),l(e,zt,t),l(e,_e,t),l(e,Xt,t),l(e,Ue,t),l(e,Yt,t),l(e,ke,t),l(e,Rt,t),d(Ce,e,t),l(e,Et,t),l(e,xe,t),l(e,Ft,t),l(e,Ze,t),l(e,Qt,t),d(Je,e,t),l(e,At,t),l(e,Ge,t),l(e,Kt,t),d(qe,e,t),l(e,Ot,t),l(e,We,t),l(e,es,t),d(Se,e,t),l(e,ts,t),l(e,He,t),l(e,ss,t),l(e,U,t),l(e,ls,t),d(Ie,e,t),l(e,ns,t),l(e,Pe,t),l(e,as,t),l(e,Le,t),l(e,is,t),l(e,Be,t),os=!0},p(e,[t]){const el={};t&2&&(el.$$scope={dirty:t,ctx:e}),$.$set(el);const tl={};t&2&&(tl.$$scope={dirty:t,ctx:e}),j.$set(tl);const sl={};t&2&&(sl.$$scope={dirty:t,ctx:e}),T.$set(sl);const ll={};t&2&&(ll.$$scope={dirty:t,ctx:e}),_.$set(ll)},i(e){os||(m(k.$$.fragment,e),m(C.$$.fragment,e),m($.$$.fragment,e),m(W.$$.fragment,e),m(H.$$.fragment,e),m(j.$$.fragment,e),m(B.$$.fragment,e),m(V.$$.fragment,e),m(X.$$.fragment,e),m(R.$$.fragment,e),m(F.$$.fragment,e),m(Q.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(oe.$$.fragment,e),m(ue.$$.fragment,e),m(de.$$.fragment,e),m(ye.$$.fragment,e),m(we.$$.fragment,e),m($e.$$.fragment,e),m(T.$$.fragment,e),m(Te.$$.fragment,e),m(_.$$.fragment,e),m(Ce.$$.fragment,e),m(Je.$$.fragment,e),m(qe.$$.fragment,e),m(Se.$$.fragment,e),m(Ie.$$.fragment,e),os=!0)},o(e){c(k.$$.fragment,e),c(C.$$.fragment,e),c($.$$.fragment,e),c(W.$$.fragment,e),c(H.$$.fragment,e),c(j.$$.fragment,e),c(B.$$.fragment,e),c(V.$$.fragment,e),c(X.$$.fragment,e),c(R.$$.fragment,e),c(F.$$.fragment,e),c(Q.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(se.$$.fragment,e),c(ne.$$.fragment,e),c(oe.$$.fragment,e),c(ue.$$.fragment,e),c(de.$$.fragment,e),c(ye.$$.fragment,e),c(we.$$.fragment,e),c($e.$$.fragment,e),c(T.$$.fragment,e),c(Te.$$.fragment,e),c(_.$$.fragment,e),c(Ce.$$.fragment,e),c(Je.$$.fragment,e),c(qe.$$.fragment,e),c(Se.$$.fragment,e),c(Ie.$$.fragment,e),os=!1},d(e){e&&(s(b),s(g),s(w),s(Ne),s(Ve),s(x),s(ze),s(Z),s(Xe),s(J),s(Ye),s(G),s(Re),s(Ee),s(q),s(Fe),s(Qe),s(S),s(Ae),s(Ke),s(I),s(Oe),s(P),s(et),s(L),s(tt),s(st),s(D),s(lt),s(nt),s(N),s(at),s(it),s(z),s(ot),s(pt),s(Y),s(rt),s(ut),s(v),s(ft),s(E),s(dt),s(mt),s(ct),s(A),s(ht),s(gt),s(O),s(yt),s(bt),s(te),s(wt),s(Mt),s(le),s($t),s(jt),s(ae),s(vt),s(ie),s(Tt),s(_t),s(pe),s(Ut),s(re),s(kt),s(Ct),s(fe),s(xt),s(Zt),s(me),s(Jt),s(ce),s(Gt),s(he),s(qt),s(ge),s(Wt),s(St),s(be),s(Ht),s(It),s(Me),s(Pt),s(Lt),s(je),s(Dt),s(Bt),s(ve),s(Nt),s(Vt),s(zt),s(_e),s(Xt),s(Ue),s(Yt),s(ke),s(Rt),s(Et),s(xe),s(Ft),s(Ze),s(Qt),s(At),s(Ge),s(Kt),s(Ot),s(We),s(es),s(ts),s(He),s(ss),s(U),s(ls),s(ns),s(Pe),s(as),s(Le),s(is),s(Be)),s(r),h(k,e),h(C,e),h($,e),h(W,e),h(H,e),h(j,e),h(B,e),h(V,e),h(X,e),h(R,e),h(F,e),h(Q,e),h(K,e),h(ee,e),h(se,e),h(ne,e),h(oe,e),h(ue,e),h(de,e),h(ye,e),h(we,e),h($e,e),h(T,e),h(Te,e),h(_,e),h(Ce,e),h(Je,e),h(qe,e),h(Se,e),h(Ie,e)}}}const yl='{"title":"Quicktour","local":"quicktour","sections":[{"title":"DiffusionPipeline","local":"diffusionpipeline","sections":[{"title":"Local pipeline","local":"local-pipeline","sections":[],"depth":3},{"title":"Swapping schedulers","local":"swapping-schedulers","sections":[],"depth":3}],"depth":2},{"title":"Models","local":"models","sections":[],"depth":2},{"title":"Schedulers","local":"schedulers","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function bl(M){return il(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _l extends ol{constructor(r){super(),pl(this,r,bl,gl,al,{})}}export{_l as component};
