import{s as Hp,o as Ep,n as Ip}from"../chunks/scheduler.9bc65507.js";import{S as Qp,i as Rp,g as d,s as n,r as u,A as Up,h as i,f as t,c as s,j as g,u as l,x as f,k as _,y as r,a,v as c,d as p,t as h,w as m}from"../chunks/index.707bf1b6.js";import{T as Dp}from"../chunks/Tip.c2ecdbf4.js";import{D as T}from"../chunks/Docstring.17db21ae.js";import{C as Vp}from"../chunks/CodeBlock.54a9f38d.js";import{H as b}from"../chunks/Heading.342b1fa6.js";function Xp(Rn){let y,W=`When passing <code>output_hidden_states=True</code> you may expect the <code>outputs.hidden_states[-1]</code> to match <code>outputs.last_hidden_states</code> exactly.
However, this is not always the case. Some models apply normalization or subsequent process to the last hidden state when it’s returned.`;return{c(){y=d("p"),y.innerHTML=W},l(v){y=i(v,"P",{"data-svelte-h":!0}),f(y)!=="svelte-7cxjzb"&&(y.innerHTML=W)},m(v,Ae){a(v,y,Ae)},p:Ip,d(v){v&&t(y)}}}function Jp(Rn){let y,W=`You can’t unpack a <code>ModelOutput</code> directly. Use the <a href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.utils.ModelOutput.to_tuple">to_tuple()</a> method to convert it to a tuple
before.`;return{c(){y=d("p"),y.innerHTML=W},l(v){y=i(v,"P",{"data-svelte-h":!0}),f(y)!=="svelte-38zpok"&&(y.innerHTML=W)},m(v,Ae){a(v,y,Ae)},p:Ip,d(v){v&&t(y)}}}function Zp(Rn){let y,W,v,Ae,Ye,ka,Ke,dc=`All models have outputs that are instances of subclasses of <a href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a>. Those are
data structures containing all the information returned by the model, but that can also be used as tuples or
dictionaries.`,Pa,et,ic="Let’s see how this looks in an example:",La,tt,Ba,ot,uc=`The <code>outputs</code> object is a <a href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput">SequenceClassifierOutput</a>, as we can see in the
documentation of that class below, it means it has an optional <code>loss</code>, a <code>logits</code>, an optional <code>hidden_states</code> and
an optional <code>attentions</code> attribute. Here we have the <code>loss</code> since we passed along <code>labels</code>, but we don’t have
<code>hidden_states</code> and <code>attentions</code> because we didn’t pass <code>output_hidden_states=True</code> or
<code>output_attentions=True</code>.`,ja,ke,Wa,nt,lc=`You can access each attribute as you would usually do, and if that attribute has not been returned by the model, you
will get <code>None</code>. Here for instance <code>outputs.loss</code> is the loss computed by the model, and <code>outputs.attentions</code> is
<code>None</code>.`,Da,st,cc=`When considering our <code>outputs</code> object as tuple, it only considers the attributes that don’t have <code>None</code> values.
Here for instance, it has two elements, <code>loss</code> then <code>logits</code>, so`,Va,at,Ia,rt,pc="will return the tuple <code>(outputs.loss, outputs.logits)</code> for instance.",Ha,dt,hc=`When considering our <code>outputs</code> object as dictionary, it only considers the attributes that don’t have <code>None</code>
values. Here for instance, it has two keys that are <code>loss</code> and <code>logits</code>.`,Ea,it,mc=`We document here the generic model outputs that are used by more than one model type. Specific output types are
documented on their corresponding model page.`,Qa,ut,Ra,x,lt,bu,Un,fc=`Base class for all model outputs as dataclass. Has a <code>__getitem__</code> that allows indexing by integer or slice (like a
tuple) or strings (like a dictionary) that will ignore the <code>None</code> attributes. Otherwise behaves like a regular
python dictionary.`,yu,Pe,vu,Le,ct,xu,Xn,gc="Convert self to a tuple containing all the attributes/keys that are not <code>None</code>.",Ua,pt,Xa,D,ht,$u,Jn,_c="Base class for model’s outputs, with potential hidden states and attentions.",Ja,mt,Za,V,ft,qu,Zn,Tc="Base class for model’s outputs that also contains a pooling of the last hidden states.",Ga,gt,Ya,I,_t,wu,Gn,bc="Base class for model’s outputs, with potential hidden states and attentions.",Ka,Tt,er,H,bt,Ou,Yn,yc="Base class for model’s outputs that also contains a pooling of the last hidden states.",tr,yt,or,E,vt,Fu,Kn,vc="Base class for model’s outputs that may also contain a past key/values (to speed up sequential decoding).",nr,xt,sr,Q,$t,Su,es,xc="Base class for model’s outputs that may also contain a past key/values (to speed up sequential decoding).",ar,qt,rr,R,wt,Mu,ts,$c=`Base class for model encoder’s outputs that also contains : pre-computed hidden states that can speed up sequential
decoding.`,dr,Ot,ir,U,Ft,Cu,os,qc="Base class for causal language model (or autoregressive) outputs.",ur,St,lr,X,Mt,zu,ns,wc="Base class for causal language model (or autoregressive) outputs.",cr,Ct,pr,J,zt,Nu,ss,Oc="Base class for causal language model (or autoregressive) outputs.",hr,Nt,mr,Z,At,Au,as,Fc="Base class for masked language models outputs.",fr,kt,gr,G,Pt,ku,rs,Sc="Base class for sequence-to-sequence language models outputs.",_r,Lt,Tr,Y,Bt,Pu,ds,Mc="Base class for outputs of models predicting if two sentences are consecutive or not.",br,jt,yr,K,Wt,Lu,is,Cc="Base class for outputs of sentence classification models.",vr,Dt,xr,ee,Vt,Bu,us,zc="Base class for outputs of sequence-to-sequence sentence classification models.",$r,It,qr,te,Ht,ju,ls,Nc="Base class for outputs of multiple choice models.",wr,Et,Or,oe,Qt,Wu,cs,Ac="Base class for outputs of token classification models.",Fr,Rt,Sr,ne,Ut,Du,ps,kc="Base class for outputs of question answering models.",Mr,Xt,Cr,se,Jt,Vu,hs,Pc="Base class for outputs of sequence-to-sequence question answering models.",zr,Zt,Nr,ae,Gt,Iu,ms,Lc="Base class for sequence-to-sequence spectrogram outputs.",Ar,Yt,kr,re,Kt,Hu,fs,Bc="Base class for outputs of semantic segmentation models.",Pr,eo,Lr,de,to,Eu,gs,jc="Base class for outputs of image classification models.",Br,oo,jr,ie,no,Qu,_s,Wc="Base class for outputs of image classification models.",Wr,so,Dr,ue,ao,Ru,Ts,Dc="Base class for outputs of depth estimation models.",Vr,ro,Ir,le,io,Uu,bs,Vc="Base class for models that have been trained with the Wav2Vec2 loss objective.",Hr,uo,Er,ce,lo,Xu,ys,Ic='Output type of <a href="/docs/transformers/v4.34.1/en/model_doc/wav2vec2#transformers.Wav2Vec2ForXVector">Wav2Vec2ForXVector</a>.',Qr,co,Rr,pe,po,Ju,vs,Hc=`Base class for time series model’s encoder outputs that also contains pre-computed hidden states that can speed up
sequential decoding.`,Ur,ho,Xr,he,mo,Zu,xs,Ec=`Base class for time series model’s decoder outputs that also contain the loss as well as the parameters of the
chosen distribution.`,Jr,fo,Zr,me,go,Gu,$s,Qc=`Base class for time series model’s predictions outputs that contains the sampled values from the chosen
distribution.`,Gr,_o,Yr,fe,To,Yu,qs,Rc="Base class for model’s outputs, with potential hidden states and attentions.",Kr,bo,ed,ge,yo,Ku,ws,Uc="Base class for model’s outputs that also contains a pooling of the last hidden states.",td,vo,od,_e,xo,el,Os,Xc="Base class for model’s outputs that also contains a pooling of the last hidden states.",nd,$o,sd,Te,qo,tl,Fs,Jc="Base class for model’s outputs that may also contain a past key/values (to speed up sequential decoding).",ad,wo,rd,be,Oo,ol,Ss,Zc="Base class for model’s outputs that may also contain a past key/values (to speed up sequential decoding).",dd,Fo,id,ye,So,nl,Ms,Gc=`Base class for model encoder’s outputs that also contains : pre-computed hidden states that can speed up sequential
decoding.`,ud,Mo,ld,ve,Co,sl,Cs,Yc="Base class for causal language model (or autoregressive) outputs.",cd,zo,pd,xe,No,al,zs,Kc="Base class for causal language model (or autoregressive) outputs.",hd,Ao,md,$e,ko,rl,Ns,ep="Base class for causal language model (or autoregressive) outputs.",fd,Po,gd,qe,Lo,dl,As,tp="Base class for masked language models outputs.",_d,Bo,Td,we,jo,il,ks,op="Base class for sequence-to-sequence language models outputs.",bd,Wo,yd,Oe,Do,ul,Ps,np="Base class for outputs of models predicting if two sentences are consecutive or not.",vd,Vo,xd,Fe,Io,ll,Ls,sp="Base class for outputs of sentence classification models.",$d,Ho,qd,Se,Eo,cl,Bs,ap="Base class for outputs of sequence-to-sequence sentence classification models.",wd,Qo,Od,Me,Ro,pl,js,rp="Base class for outputs of multiple choice models.",Fd,Uo,Sd,Ce,Xo,hl,Ws,dp="Base class for outputs of token classification models.",Md,Jo,Cd,ze,Zo,ml,Ds,ip="Base class for outputs of question answering models.",zd,Go,Nd,Ne,Yo,fl,Vs,up="Base class for outputs of sequence-to-sequence question answering models.",Ad,Ko,kd,$,en,gl,Is,lp="Base class for model’s outputs, with potential hidden states and attentions.",_l,Be,tn,Tl,Hs,cp="“Returns a new object replacing the specified fields with new values.",Pd,on,Ld,q,nn,bl,Es,pp="Base class for model’s outputs, with potential hidden states and attentions.",yl,je,sn,vl,Qs,hp="“Returns a new object replacing the specified fields with new values.",Bd,an,jd,w,rn,xl,Rs,mp="Base class for model’s outputs that also contains a pooling of the last hidden states.",$l,We,dn,ql,Us,fp="“Returns a new object replacing the specified fields with new values.",Wd,un,Dd,O,ln,wl,Xs,gp="Base class for model’s outputs that may also contain a past key/values (to speed up sequential decoding).",Ol,De,cn,Fl,Js,_p="“Returns a new object replacing the specified fields with new values.",Vd,pn,Id,F,hn,Sl,Zs,Tp=`Base class for model encoder’s outputs that also contains : pre-computed hidden states that can speed up sequential
decoding.`,Ml,Ve,mn,Cl,Gs,bp="“Returns a new object replacing the specified fields with new values.",Hd,fn,Ed,S,gn,zl,Ys,yp="Base class for causal language model (or autoregressive) outputs.",Nl,Ie,_n,Al,Ks,vp="“Returns a new object replacing the specified fields with new values.",Qd,Tn,Rd,M,bn,kl,ea,xp="Base class for masked language models outputs.",Pl,He,yn,Ll,ta,$p="“Returns a new object replacing the specified fields with new values.",Ud,vn,Xd,C,xn,Bl,oa,qp="Base class for sequence-to-sequence language models outputs.",jl,Ee,$n,Wl,na,wp="“Returns a new object replacing the specified fields with new values.",Jd,qn,Zd,z,wn,Dl,sa,Op="Base class for outputs of models predicting if two sentences are consecutive or not.",Vl,Qe,On,Il,aa,Fp="“Returns a new object replacing the specified fields with new values.",Gd,Fn,Yd,N,Sn,Hl,ra,Sp="Base class for outputs of sentence classification models.",El,Re,Mn,Ql,da,Mp="“Returns a new object replacing the specified fields with new values.",Kd,Cn,ei,A,zn,Rl,ia,Cp="Base class for outputs of sequence-to-sequence sentence classification models.",Ul,Ue,Nn,Xl,ua,zp="“Returns a new object replacing the specified fields with new values.",ti,An,oi,k,kn,Jl,la,Np="Base class for outputs of multiple choice models.",Zl,Xe,Pn,Gl,ca,Ap="“Returns a new object replacing the specified fields with new values.",ni,Ln,si,P,Bn,Yl,pa,kp="Base class for outputs of token classification models.",Kl,Je,jn,ec,ha,Pp="“Returns a new object replacing the specified fields with new values.",ai,Wn,ri,L,Dn,tc,ma,Lp="Base class for outputs of question answering models.",oc,Ze,Vn,nc,fa,Bp="“Returns a new object replacing the specified fields with new values.",di,In,ii,B,Hn,sc,ga,jp="Base class for outputs of sequence-to-sequence question answering models.",ac,Ge,En,rc,_a,Wp="“Returns a new object replacing the specified fields with new values.",ui,Aa,li;return Ye=new b({props:{title:"Model outputs",local:"model-outputs",headingTag:"h1"}}),tt=new Vp({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXIlMkMlMjBCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQmVydFRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKS51bnNxdWVlemUoMCklMjAlMjAlMjMlMjBCYXRjaCUyMHNpemUlMjAxJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizer, BertForSequenceClassification
<span class="hljs-keyword">import</span> torch

tokenizer = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
model = BertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)

inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
labels = torch.tensor([<span class="hljs-number">1</span>]).unsqueeze(<span class="hljs-number">0</span>)  <span class="hljs-comment"># Batch size 1</span>
outputs = model(**inputs, labels=labels)`,wrap:!1}}),ke=new Dp({props:{$$slots:{default:[Xp]},$$scope:{ctx:Rn}}}),at=new Vp({props:{code:"b3V0cHV0cyU1QiUzQTIlNUQ=",highlighted:'outputs[:<span class="hljs-number">2</span>]',wrap:!1}}),ut=new b({props:{title:"ModelOutput",local:"transformers.utils.ModelOutput",headingTag:"h2"}}),lt=new T({props:{name:"class transformers.utils.ModelOutput",anchor:"transformers.utils.ModelOutput",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/utils/generic.py#L288"}}),Pe=new Dp({props:{warning:!0,$$slots:{default:[Jp]},$$scope:{ctx:Rn}}}),ct=new T({props:{name:"to_tuple",anchor:"transformers.utils.ModelOutput.to_tuple",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/utils/generic.py#L419"}}),pt=new b({props:{title:"BaseModelOutput",local:"transformers.modeling_outputs.BaseModelOutput",headingTag:"h2"}}),ht=new T({props:{name:"class transformers.modeling_outputs.BaseModelOutput",anchor:"transformers.modeling_outputs.BaseModelOutput",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.BaseModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.BaseModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.BaseModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L25"}}),mt=new b({props:{title:"BaseModelOutputWithPooling",local:"transformers.modeling_outputs.BaseModelOutputWithPooling",headingTag:"h2"}}),ft=new T({props:{name:"class transformers.modeling_outputs.BaseModelOutputWithPooling",anchor:"transformers.modeling_outputs.BaseModelOutputWithPooling",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"pooler_output",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.BaseModelOutputWithPooling.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPooling.pooler_output",description:`<strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.`,name:"pooler_output"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPooling.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPooling.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L70"}}),gt=new b({props:{title:"BaseModelOutputWithCrossAttentions",local:"transformers.modeling_outputs.BaseModelOutputWithCrossAttentions",headingTag:"h2"}}),_t=new T({props:{name:"class transformers.modeling_outputs.BaseModelOutputWithCrossAttentions",anchor:"transformers.modeling_outputs.BaseModelOutputWithCrossAttentions",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.BaseModelOutputWithCrossAttentions.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L163"}}),Tt=new b({props:{title:"BaseModelOutputWithPoolingAndCrossAttentions",local:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions",headingTag:"h2"}}),bt=new T({props:{name:"class transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions",anchor:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"pooler_output",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions.pooler_output",description:`<strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.`,name:"pooler_output"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L196"}}),yt=new b({props:{title:"BaseModelOutputWithPast",local:"transformers.modeling_outputs.BaseModelOutputWithPast",headingTag:"h2"}}),vt=new T({props:{name:"class transformers.modeling_outputs.BaseModelOutputWithPast",anchor:"transformers.modeling_outputs.BaseModelOutputWithPast",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.BaseModelOutputWithPast.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPast.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPast.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPast.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L124"}}),xt=new b({props:{title:"BaseModelOutputWithPastAndCrossAttentions",local:"transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions",headingTag:"h2"}}),$t=new T({props:{name:"class transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions",anchor:"transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L245"}}),qt=new b({props:{title:"Seq2SeqModelOutput",local:"transformers.modeling_outputs.Seq2SeqModelOutput",headingTag:"h2"}}),wt=new T({props:{name:"class transformers.modeling_outputs.Seq2SeqModelOutput",anchor:"transformers.modeling_outputs.Seq2SeqModelOutput",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the optional initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the optional initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L425"}}),Ot=new b({props:{title:"CausalLMOutput",local:"transformers.modeling_outputs.CausalLMOutput",headingTag:"h2"}}),Ft=new T({props:{name:"class transformers.modeling_outputs.CausalLMOutput",anchor:"transformers.modeling_outputs.CausalLMOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.CausalLMOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss (for next-token prediction).`,name:"loss"},{anchor:"transformers.modeling_outputs.CausalLMOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.CausalLMOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.CausalLMOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L558"}}),St=new b({props:{title:"CausalLMOutputWithCrossAttentions",local:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions",headingTag:"h2"}}),Mt=new T({props:{name:"class transformers.modeling_outputs.CausalLMOutputWithCrossAttentions",anchor:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss (for next-token prediction).`,name:"loss"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key,
value states of the self-attention and the cross-attention layers if model is used in encoder-decoder
setting. Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L623"}}),Ct=new b({props:{title:"CausalLMOutputWithPast",local:"transformers.modeling_outputs.CausalLMOutputWithPast",headingTag:"h2"}}),zt=new T({props:{name:"class transformers.modeling_outputs.CausalLMOutputWithPast",anchor:"transformers.modeling_outputs.CausalLMOutputWithPast",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.CausalLMOutputWithPast.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss (for next-token prediction).`,name:"loss"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithPast.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithPast.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithPast.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithPast.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L587"}}),Nt=new b({props:{title:"MaskedLMOutput",local:"transformers.modeling_outputs.MaskedLMOutput",headingTag:"h2"}}),At=new T({props:{name:"class transformers.modeling_outputs.MaskedLMOutput",anchor:"transformers.modeling_outputs.MaskedLMOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.MaskedLMOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Masked language modeling (MLM) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.MaskedLMOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.MaskedLMOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.MaskedLMOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L703"}}),kt=new b({props:{title:"Seq2SeqLMOutput",local:"transformers.modeling_outputs.Seq2SeqLMOutput",headingTag:"h2"}}),Pt=new T({props:{name:"class transformers.modeling_outputs.Seq2SeqLMOutput",anchor:"transformers.modeling_outputs.Seq2SeqLMOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L732"}}),Lt=new b({props:{title:"NextSentencePredictorOutput",local:"transformers.modeling_outputs.NextSentencePredictorOutput",headingTag:"h2"}}),Bt=new T({props:{name:"class transformers.modeling_outputs.NextSentencePredictorOutput",anchor:"transformers.modeling_outputs.NextSentencePredictorOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.NextSentencePredictorOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>next_sentence_label</code> is provided) &#x2014;
Next sequence prediction (classification) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.NextSentencePredictorOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2)</code>) &#x2014;
Prediction scores of the next sequence prediction (classification) head (scores of True/False continuation
before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.NextSentencePredictorOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.NextSentencePredictorOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L867"}}),jt=new b({props:{title:"SequenceClassifierOutput",local:"transformers.modeling_outputs.SequenceClassifierOutput",headingTag:"h2"}}),Wt=new T({props:{name:"class transformers.modeling_outputs.SequenceClassifierOutput",anchor:"transformers.modeling_outputs.SequenceClassifierOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.SequenceClassifierOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.SequenceClassifierOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.SequenceClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.SequenceClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L897"}}),Dt=new b({props:{title:"Seq2SeqSequenceClassifierOutput",local:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput",headingTag:"h2"}}),Vt=new T({props:{name:"class transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput",anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>label</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L926"}}),It=new b({props:{title:"MultipleChoiceModelOutput",local:"transformers.modeling_outputs.MultipleChoiceModelOutput",headingTag:"h2"}}),Ht=new T({props:{name:"class transformers.modeling_outputs.MultipleChoiceModelOutput",anchor:"transformers.modeling_outputs.MultipleChoiceModelOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.MultipleChoiceModelOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <em>(1,)</em>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.MultipleChoiceModelOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices)</code>) &#x2014;
<em>num_choices</em> is the second dimension of the input tensors. (see <em>input_ids</em> above).</p>
<p>Classification scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.MultipleChoiceModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.MultipleChoiceModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L986"}}),Et=new b({props:{title:"TokenClassifierOutput",local:"transformers.modeling_outputs.TokenClassifierOutput",headingTag:"h2"}}),Qt=new T({props:{name:"class transformers.modeling_outputs.TokenClassifierOutput",anchor:"transformers.modeling_outputs.TokenClassifierOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.TokenClassifierOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  &#x2014;
Classification loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.TokenClassifierOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) &#x2014;
Classification scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.TokenClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.TokenClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L1017"}}),Rt=new b({props:{title:"QuestionAnsweringModelOutput",local:"transformers.modeling_outputs.QuestionAnsweringModelOutput",headingTag:"h2"}}),Ut=new T({props:{name:"class transformers.modeling_outputs.QuestionAnsweringModelOutput",anchor:"transformers.modeling_outputs.QuestionAnsweringModelOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"start_logits",val:": FloatTensor = None"},{name:"end_logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.QuestionAnsweringModelOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.`,name:"loss"},{anchor:"transformers.modeling_outputs.QuestionAnsweringModelOutput.start_logits",description:`<strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-start scores (before SoftMax).`,name:"start_logits"},{anchor:"transformers.modeling_outputs.QuestionAnsweringModelOutput.end_logits",description:`<strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-end scores (before SoftMax).`,name:"end_logits"},{anchor:"transformers.modeling_outputs.QuestionAnsweringModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.QuestionAnsweringModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L1046"}}),Xt=new b({props:{title:"Seq2SeqQuestionAnsweringModelOutput",local:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput",headingTag:"h2"}}),Jt=new T({props:{name:"class transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput",anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"start_logits",val:": FloatTensor = None"},{name:"end_logits",val:": FloatTensor = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.`,name:"loss"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.start_logits",description:`<strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-start scores (before SoftMax).`,name:"start_logits"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.end_logits",description:`<strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-end scores (before SoftMax).`,name:"end_logits"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L1078"}}),Zt=new b({props:{title:"Seq2SeqSpectrogramOutput",local:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput",headingTag:"h2"}}),Gt=new T({props:{name:"class transformers.modeling_outputs.Seq2SeqSpectrogramOutput",anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"spectrogram",val:": FloatTensor = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Spectrogram generation loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.spectrogram",description:`<strong>spectrogram</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, num_bins)</code>) &#x2014;
The predicted spectrogram.`,name:"spectrogram"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L1411"}}),Yt=new b({props:{title:"SemanticSegmenterOutput",local:"transformers.modeling_outputs.SemanticSegmenterOutput",headingTag:"h2"}}),Kt=new T({props:{name:"class transformers.modeling_outputs.SemanticSegmenterOutput",anchor:"transformers.modeling_outputs.SemanticSegmenterOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.SemanticSegmenterOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.SemanticSegmenterOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels, logits_height, logits_width)</code>) &#x2014;
Classification scores for each pixel.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The logits returned do not necessarily have the same size as the <code>pixel_values</code> passed as inputs. This is
to avoid doing two interpolations and lose some quality when a user needs to resize the logits to the
original image size as post-processing. You should always check your logits shape and resize as needed.</p>

					</div>`,name:"logits"},{anchor:"transformers.modeling_outputs.SemanticSegmenterOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, patch_size, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.SemanticSegmenterOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L1141"}}),eo=new b({props:{title:"ImageClassifierOutput",local:"transformers.modeling_outputs.ImageClassifierOutput",headingTag:"h2"}}),to=new T({props:{name:"class transformers.modeling_outputs.ImageClassifierOutput",anchor:"transformers.modeling_outputs.ImageClassifierOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.ImageClassifierOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.ImageClassifierOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.ImageClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.ImageClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L1179"}}),oo=new b({props:{title:"ImageClassifierOutputWithNoAttention",local:"transformers.modeling_outputs.ImageClassifierOutputWithNoAttention",headingTag:"h2"}}),no=new T({props:{name:"class transformers.modeling_outputs.ImageClassifierOutputWithNoAttention",anchor:"transformers.modeling_outputs.ImageClassifierOutputWithNoAttention",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.ImageClassifierOutputWithNoAttention.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.ImageClassifierOutputWithNoAttention.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.ImageClassifierOutputWithNoAttention.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also
called feature maps) of the model at the output of each stage.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L1207"}}),so=new b({props:{title:"DepthEstimatorOutput",local:"transformers.modeling_outputs.DepthEstimatorOutput",headingTag:"h2"}}),ao=new T({props:{name:"class transformers.modeling_outputs.DepthEstimatorOutput",anchor:"transformers.modeling_outputs.DepthEstimatorOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"predicted_depth",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.DepthEstimatorOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.DepthEstimatorOutput.predicted_depth",description:`<strong>predicted_depth</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>) &#x2014;
Predicted depth for each pixel.`,name:"predicted_depth"},{anchor:"transformers.modeling_outputs.DepthEstimatorOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.DepthEstimatorOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L1228"}}),ro=new b({props:{title:"Wav2Vec2BaseModelOutput",local:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput",headingTag:"h2"}}),io=new T({props:{name:"class transformers.modeling_outputs.Wav2Vec2BaseModelOutput",anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"extract_features",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput.extract_features",description:`<strong>extract_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, conv_dim[-1])</code>) &#x2014;
Sequence of extracted feature vectors of the last convolutional layer of the model.`,name:"extract_features"},{anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L1286"}}),uo=new b({props:{title:"XVectorOutput",local:"transformers.modeling_outputs.XVectorOutput",headingTag:"h2"}}),lo=new T({props:{name:"class transformers.modeling_outputs.XVectorOutput",anchor:"transformers.modeling_outputs.XVectorOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"embeddings",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.XVectorOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.XVectorOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.xvector_output_dim)</code>) &#x2014;
Classification hidden states before AMSoftmax.`,name:"logits"},{anchor:"transformers.modeling_outputs.XVectorOutput.embeddings",description:`<strong>embeddings</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.xvector_output_dim)</code>) &#x2014;
Utterance embeddings used for vector similarity-based retrieval.`,name:"embeddings"},{anchor:"transformers.modeling_outputs.XVectorOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.XVectorOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L1315"}}),co=new b({props:{title:"Seq2SeqTSModelOutput",local:"transformers.modeling_outputs.Seq2SeqTSModelOutput",headingTag:"h2"}}),po=new T({props:{name:"class transformers.modeling_outputs.Seq2SeqTSModelOutput",anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"loc",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scale",val:": typing.Optional[torch.FloatTensor] = None"},{name:"static_features",val:": typing.Optional[torch.FloatTensor] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the optional initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the optional initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.loc",description:`<strong>loc</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size,)</code> or <code>(batch_size, input_size)</code>, <em>optional</em>) &#x2014;
Shift values of each time series&#x2019; context window which is used to give the model inputs of the same
magnitude and then used to shift back to the original magnitude.`,name:"loc"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.scale",description:`<strong>scale</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size,)</code> or <code>(batch_size, input_size)</code>, <em>optional</em>) &#x2014;
Scaling values of each time series&#x2019; context window which is used to give the model inputs of the same
magnitude and then used to rescale back to the original magnitude.`,name:"scale"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.static_features",description:`<strong>static_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, feature size)</code>, <em>optional</em>) &#x2014;
Static features of each time series&#x2019; in a batch which are copied to the covariates at inference time.`,name:"static_features"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L1471"}}),ho=new b({props:{title:"Seq2SeqTSPredictionOutput",local:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput",headingTag:"h2"}}),mo=new T({props:{name:"class transformers.modeling_outputs.Seq2SeqTSPredictionOutput",anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"params",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"loc",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scale",val:": typing.Optional[torch.FloatTensor] = None"},{name:"static_features",val:": typing.Optional[torch.FloatTensor] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when a <code>future_values</code> is provided) &#x2014;
Distributional loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.params",description:`<strong>params</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_samples, num_params)</code>) &#x2014;
Parameters of the chosen distribution.`,name:"params"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.loc",description:`<strong>loc</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size,)</code> or <code>(batch_size, input_size)</code>, <em>optional</em>) &#x2014;
Shift values of each time series&#x2019; context window which is used to give the model inputs of the same
magnitude and then used to shift back to the original magnitude.`,name:"loc"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.scale",description:`<strong>scale</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size,)</code> or <code>(batch_size, input_size)</code>, <em>optional</em>) &#x2014;
Scaling values of each time series&#x2019; context window which is used to give the model inputs of the same
magnitude and then used to rescale back to the original magnitude.`,name:"scale"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.static_features",description:`<strong>static_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, feature size)</code>, <em>optional</em>) &#x2014;
Static features of each time series&#x2019; in a batch which are copied to the covariates at inference time.`,name:"static_features"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L1543"}}),fo=new b({props:{title:"SampleTSPredictionOutput",local:"transformers.modeling_outputs.SampleTSPredictionOutput",headingTag:"h2"}}),go=new T({props:{name:"class transformers.modeling_outputs.SampleTSPredictionOutput",anchor:"transformers.modeling_outputs.SampleTSPredictionOutput",parameters:[{name:"sequences",val:": FloatTensor = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.SampleTSPredictionOutput.sequences",description:`<strong>sequences</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_samples, prediction_length)</code> or <code>(batch_size, num_samples, prediction_length, input_size)</code>) &#x2014;
Sampled values from the chosen distribution.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_outputs.py#L1615"}}),_o=new b({props:{title:"TFBaseModelOutput",local:"transformers.modeling_tf_outputs.TFBaseModelOutput",headingTag:"h2"}}),To=new T({props:{name:"class transformers.modeling_tf_outputs.TFBaseModelOutput",anchor:"transformers.modeling_tf_outputs.TFBaseModelOutput",parameters:[{name:"last_hidden_state",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_tf_outputs.py#L27"}}),bo=new b({props:{title:"TFBaseModelOutputWithPooling",local:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling",headingTag:"h2"}}),yo=new T({props:{name:"class transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling",anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling",parameters:[{name:"last_hidden_state",val:": tf.Tensor = None"},{name:"pooler_output",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling.pooler_output",description:`<strong>pooler_output</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Last layer hidden-state of the first token of the sequence (classification token) further processed by a
Linear layer and a Tanh activation function. The Linear layer weights are trained from the next sentence
prediction (classification) objective during pretraining.</p>
<p>This output is usually <em>not</em> a good summary of the semantic content of the input, you&#x2019;re often better with
averaging or pooling the sequence of hidden-states for the whole input sequence.`,name:"pooler_output"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_tf_outputs.py#L72"}}),vo=new b({props:{title:"TFBaseModelOutputWithPoolingAndCrossAttentions",local:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions",headingTag:"h2"}}),xo=new T({props:{name:"class transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions",anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions",parameters:[{name:"last_hidden_state",val:": tf.Tensor = None"},{name:"pooler_output",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"cross_attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions.pooler_output",description:`<strong>pooler_output</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Last layer hidden-state of the first token of the sequence (classification token) further processed by a
Linear layer and a Tanh activation function. The Linear layer weights are trained from the next sentence
prediction (classification) objective during pretraining.</p>
<p>This output is usually <em>not</em> a good summary of the semantic content of the input, you&#x2019;re often better with
averaging or pooling the sequence of hidden-states for the whole input sequence.`,name:"pooler_output"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_tf_outputs.py#L128"}}),$o=new b({props:{title:"TFBaseModelOutputWithPast",local:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPast",headingTag:"h2"}}),qo=new T({props:{name:"class transformers.modeling_tf_outputs.TFBaseModelOutputWithPast",anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPast",parameters:[{name:"last_hidden_state",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPast.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPast.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPast.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPast.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_tf_outputs.py#L176"}}),wo=new b({props:{title:"TFBaseModelOutputWithPastAndCrossAttentions",local:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions",headingTag:"h2"}}),Oo=new T({props:{name:"class transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions",anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions",parameters:[{name:"last_hidden_state",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"cross_attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_tf_outputs.py#L245"}}),Fo=new b({props:{title:"TFSeq2SeqModelOutput",local:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput",headingTag:"h2"}}),So=new T({props:{name:"class transformers.modeling_tf_outputs.TFSeq2SeqModelOutput",anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput",parameters:[{name:"last_hidden_state",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"decoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"decoder_attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"cross_attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_last_hidden_state",val:": tf.Tensor | None = None"},{name:"encoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) of the decoder that can be
used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_tf_outputs.py#L288"}}),Mo=new b({props:{title:"TFCausalLMOutput",local:"transformers.modeling_tf_outputs.TFCausalLMOutput",headingTag:"h2"}}),Co=new T({props:{name:"class transformers.modeling_tf_outputs.TFCausalLMOutput",anchor:"transformers.modeling_tf_outputs.TFCausalLMOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss (for next-token prediction).`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_tf_outputs.py#L348"}}),zo=new b({props:{title:"TFCausalLMOutputWithCrossAttentions",local:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions",headingTag:"h2"}}),No=new T({props:{name:"class transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions",anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"cross_attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss (for next-token prediction).`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_tf_outputs.py#L413"}}),Ao=new b({props:{title:"TFCausalLMOutputWithPast",local:"transformers.modeling_tf_outputs.TFCausalLMOutputWithPast",headingTag:"h2"}}),ko=new T({props:{name:"class transformers.modeling_tf_outputs.TFCausalLMOutputWithPast",anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithPast",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithPast.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss (for next-token prediction).`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithPast.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithPast.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithPast.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithPast.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_tf_outputs.py#L377"}}),Po=new b({props:{title:"TFMaskedLMOutput",local:"transformers.modeling_tf_outputs.TFMaskedLMOutput",headingTag:"h2"}}),Lo=new T({props:{name:"class transformers.modeling_tf_outputs.TFMaskedLMOutput",anchor:"transformers.modeling_tf_outputs.TFMaskedLMOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFMaskedLMOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) &#x2014;
Masked language modeling (MLM) loss.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFMaskedLMOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFMaskedLMOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFMaskedLMOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_tf_outputs.py#L456"}}),Bo=new b({props:{title:"TFSeq2SeqLMOutput",local:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput",headingTag:"h2"}}),jo=new T({props:{name:"class transformers.modeling_tf_outputs.TFSeq2SeqLMOutput",anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"decoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"decoder_attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"cross_attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_last_hidden_state",val:": tf.Tensor | None = None"},{name:"encoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) of the decoder that can be
used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_tf_outputs.py#L485"}}),Wo=new b({props:{title:"TFNextSentencePredictorOutput",local:"transformers.modeling_tf_outputs.TFNextSentencePredictorOutput",headingTag:"h2"}}),Do=new T({props:{name:"class transformers.modeling_tf_outputs.TFNextSentencePredictorOutput",anchor:"transformers.modeling_tf_outputs.TFNextSentencePredictorOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFNextSentencePredictorOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>next_sentence_label</code> is provided) &#x2014;
Next sentence prediction loss.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFNextSentencePredictorOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, 2)</code>) &#x2014;
Prediction scores of the next sequence prediction (classification) head (scores of True/False continuation
before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFNextSentencePredictorOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFNextSentencePredictorOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_tf_outputs.py#L544"}}),Vo=new b({props:{title:"TFSequenceClassifierOutput",local:"transformers.modeling_tf_outputs.TFSequenceClassifierOutput",headingTag:"h2"}}),Io=new T({props:{name:"class transformers.modeling_tf_outputs.TFSequenceClassifierOutput",anchor:"transformers.modeling_tf_outputs.TFSequenceClassifierOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFSequenceClassifierOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFSequenceClassifierOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFSequenceClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSequenceClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_tf_outputs.py#L574"}}),Ho=new b({props:{title:"TFSeq2SeqSequenceClassifierOutput",local:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput",headingTag:"h2"}}),Eo=new T({props:{name:"class transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput",anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"decoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"decoder_attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"cross_attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_last_hidden_state",val:": tf.Tensor | None = None"},{name:"encoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>label</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) of the decoder that can be
used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>`,name:"cross_attentions"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_tf_outputs.py#L603"}}),Qo=new b({props:{title:"TFMultipleChoiceModelOutput",local:"transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput",headingTag:"h2"}}),Ro=new T({props:{name:"class transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput",anchor:"transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <em>(batch_size, )</em>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification loss.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_choices)</code>) &#x2014;
<em>num_choices</em> is the second dimension of the input tensors. (see <em>input_ids</em> above).</p>
<p>Classification scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_tf_outputs.py#L754"}}),Uo=new b({props:{title:"TFTokenClassifierOutput",local:"transformers.modeling_tf_outputs.TFTokenClassifierOutput",headingTag:"h2"}}),Xo=new T({props:{name:"class transformers.modeling_tf_outputs.TFTokenClassifierOutput",anchor:"transformers.modeling_tf_outputs.TFTokenClassifierOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFTokenClassifierOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of unmasked labels, returned when <code>labels</code> is provided)  &#x2014;
Classification loss.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFTokenClassifierOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) &#x2014;
Classification scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFTokenClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFTokenClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_tf_outputs.py#L785"}}),Jo=new b({props:{title:"TFQuestionAnsweringModelOutput",local:"transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput",headingTag:"h2"}}),Zo=new T({props:{name:"class transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput",anchor:"transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"start_logits",val:": tf.Tensor = None"},{name:"end_logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>, returned when <code>start_positions</code> and <code>end_positions</code> are provided) &#x2014;
Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput.start_logits",description:`<strong>start_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-start scores (before SoftMax).`,name:"start_logits"},{anchor:"transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput.end_logits",description:`<strong>end_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-end scores (before SoftMax).`,name:"end_logits"},{anchor:"transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_tf_outputs.py#L814"}}),Go=new b({props:{title:"TFSeq2SeqQuestionAnsweringModelOutput",local:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput",headingTag:"h2"}}),Yo=new T({props:{name:"class transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput",anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"start_logits",val:": tf.Tensor = None"},{name:"end_logits",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"decoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"decoder_attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_last_hidden_state",val:": tf.Tensor | None = None"},{name:"encoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.start_logits",description:`<strong>start_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-start scores (before SoftMax).`,name:"start_logits"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.end_logits",description:`<strong>end_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-end scores (before SoftMax).`,name:"end_logits"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) of the decoder that can be
used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_tf_outputs.py#L846"}}),Ko=new b({props:{title:"FlaxBaseModelOutput",local:"transformers.modeling_flax_outputs.FlaxBaseModelOutput",headingTag:"h2"}}),en=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxBaseModelOutput",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutput",parameters:[{name:"last_hidden_state",val:": Array = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_flax_outputs.py#L23"}}),tn=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/flax/struct.py#L111"}}),on=new b({props:{title:"FlaxBaseModelOutputWithPast",local:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast",headingTag:"h2"}}),nn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast",parameters:[{name:"last_hidden_state",val:": Array = None"},{name:"past_key_values",val:": typing.Union[typing.Dict[str, jax.Array], NoneType] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast.past_key_values",description:`<strong>past_key_values</strong> (<code>Dict[str, jnp.ndarray]</code>) &#x2014;
Dictionary of pre-computed hidden-states (key and values in the attention blocks) that can be used for fast
auto-regressive decoding. Pre-computed key and value hidden-states are of shape <em>[batch_size, max_length]</em>.`,name:"past_key_values"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_flax_outputs.py#L107"}}),sn=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/flax/struct.py#L111"}}),an=new b({props:{title:"FlaxBaseModelOutputWithPooling",local:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling",headingTag:"h2"}}),rn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling",parameters:[{name:"last_hidden_state",val:": Array = None"},{name:"pooler_output",val:": Array = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling.pooler_output",description:`<strong>pooler_output</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Last layer hidden-state of the first token of the sequence (classification token) further processed by a
Linear layer and a Tanh activation function. The Linear layer weights are trained from the next sentence
prediction (classification) objective during pretraining.`,name:"pooler_output"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_flax_outputs.py#L137"}}),dn=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/flax/struct.py#L111"}}),un=new b({props:{title:"FlaxBaseModelOutputWithPastAndCrossAttentions",local:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions",headingTag:"h2"}}),ln=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions",parameters:[{name:"last_hidden_state",val:": Array = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[jax.Array]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(jnp.ndarray)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_flax_outputs.py#L217"}}),cn=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/flax/struct.py#L111"}}),pn=new b({props:{title:"FlaxSeq2SeqModelOutput",local:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput",headingTag:"h2"}}),hn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput",parameters:[{name:"last_hidden_state",val:": Array = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[jax.Array]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[jax.Array] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(jnp.ndarray)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_flax_outputs.py#L263"}}),mn=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/flax/struct.py#L111"}}),fn=new b({props:{title:"FlaxCausalLMOutputWithCrossAttentions",local:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions",headingTag:"h2"}}),gn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions",anchor:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions",parameters:[{name:"logits",val:": Array = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[jax.Array]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key, value
states of the self-attention and the cross-attention layers if model is used in encoder-decoder setting.
Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_flax_outputs.py#L324"}}),_n=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/flax/struct.py#L111"}}),Tn=new b({props:{title:"FlaxMaskedLMOutput",local:"transformers.modeling_flax_outputs.FlaxMaskedLMOutput",headingTag:"h2"}}),bn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxMaskedLMOutput",anchor:"transformers.modeling_flax_outputs.FlaxMaskedLMOutput",parameters:[{name:"logits",val:": Array = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxMaskedLMOutput.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxMaskedLMOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxMaskedLMOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_flax_outputs.py#L365"}}),yn=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxMaskedLMOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/flax/struct.py#L111"}}),vn=new b({props:{title:"FlaxSeq2SeqLMOutput",local:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput",headingTag:"h2"}}),xn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput",parameters:[{name:"logits",val:": Array = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[jax.Array]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[jax.Array] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(jnp.ndarray)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_flax_outputs.py#L394"}}),$n=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/flax/struct.py#L111"}}),qn=new b({props:{title:"FlaxNextSentencePredictorOutput",local:"transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput",headingTag:"h2"}}),wn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput",anchor:"transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput",parameters:[{name:"logits",val:": Array = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, 2)</code>) &#x2014;
Prediction scores of the next sequence prediction (classification) head (scores of True/False continuation
before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_flax_outputs.py#L451"}}),On=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/flax/struct.py#L111"}}),Fn=new b({props:{title:"FlaxSequenceClassifierOutput",local:"transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput",headingTag:"h2"}}),Sn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput",anchor:"transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput",parameters:[{name:"logits",val:": Array = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_flax_outputs.py#L478"}}),Mn=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/flax/struct.py#L111"}}),Cn=new b({props:{title:"FlaxSeq2SeqSequenceClassifierOutput",local:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput",headingTag:"h2"}}),zn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput",parameters:[{name:"logits",val:": Array = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[jax.Array]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[jax.Array] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(jnp.ndarray)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_flax_outputs.py#L504"}}),Nn=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/flax/struct.py#L111"}}),An=new b({props:{title:"FlaxMultipleChoiceModelOutput",local:"transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput",headingTag:"h2"}}),kn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput",anchor:"transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput",parameters:[{name:"logits",val:": Array = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, num_choices)</code>) &#x2014;
<em>num_choices</em> is the second dimension of the input tensors. (see <em>input_ids</em> above).</p>
<p>Classification scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_flax_outputs.py#L561"}}),Pn=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/flax/struct.py#L111"}}),Ln=new b({props:{title:"FlaxTokenClassifierOutput",local:"transformers.modeling_flax_outputs.FlaxTokenClassifierOutput",headingTag:"h2"}}),Bn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxTokenClassifierOutput",anchor:"transformers.modeling_flax_outputs.FlaxTokenClassifierOutput",parameters:[{name:"logits",val:": Array = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxTokenClassifierOutput.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) &#x2014;
Classification scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxTokenClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxTokenClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_flax_outputs.py#L589"}}),jn=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxTokenClassifierOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/flax/struct.py#L111"}}),Wn=new b({props:{title:"FlaxQuestionAnsweringModelOutput",local:"transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput",headingTag:"h2"}}),Dn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput",anchor:"transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput",parameters:[{name:"start_logits",val:": Array = None"},{name:"end_logits",val:": Array = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput.start_logits",description:`<strong>start_logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-start scores (before SoftMax).`,name:"start_logits"},{anchor:"transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput.end_logits",description:`<strong>end_logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-end scores (before SoftMax).`,name:"end_logits"},{anchor:"transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_flax_outputs.py#L615"}}),Vn=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/flax/struct.py#L111"}}),In=new b({props:{title:"FlaxSeq2SeqQuestionAnsweringModelOutput",local:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput",headingTag:"h2"}}),Hn=new T({props:{name:"class transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput",parameters:[{name:"start_logits",val:": Array = None"},{name:"end_logits",val:": Array = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[jax.Array]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[jax.Array] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.start_logits",description:`<strong>start_logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-start scores (before SoftMax).`,name:"start_logits"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.end_logits",description:`<strong>end_logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-end scores (before SoftMax).`,name:"end_logits"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(jnp.ndarray)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/modeling_flax_outputs.py#L644"}}),En=new T({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/flax/struct.py#L111"}}),{c(){y=d("meta"),W=n(),v=d("p"),Ae=n(),u(Ye.$$.fragment),ka=n(),Ke=d("p"),Ke.innerHTML=dc,Pa=n(),et=d("p"),et.textContent=ic,La=n(),u(tt.$$.fragment),Ba=n(),ot=d("p"),ot.innerHTML=uc,ja=n(),u(ke.$$.fragment),Wa=n(),nt=d("p"),nt.innerHTML=lc,Da=n(),st=d("p"),st.innerHTML=cc,Va=n(),u(at.$$.fragment),Ia=n(),rt=d("p"),rt.innerHTML=pc,Ha=n(),dt=d("p"),dt.innerHTML=hc,Ea=n(),it=d("p"),it.textContent=mc,Qa=n(),u(ut.$$.fragment),Ra=n(),x=d("div"),u(lt.$$.fragment),bu=n(),Un=d("p"),Un.innerHTML=fc,yu=n(),u(Pe.$$.fragment),vu=n(),Le=d("div"),u(ct.$$.fragment),xu=n(),Xn=d("p"),Xn.innerHTML=gc,Ua=n(),u(pt.$$.fragment),Xa=n(),D=d("div"),u(ht.$$.fragment),$u=n(),Jn=d("p"),Jn.textContent=_c,Ja=n(),u(mt.$$.fragment),Za=n(),V=d("div"),u(ft.$$.fragment),qu=n(),Zn=d("p"),Zn.textContent=Tc,Ga=n(),u(gt.$$.fragment),Ya=n(),I=d("div"),u(_t.$$.fragment),wu=n(),Gn=d("p"),Gn.textContent=bc,Ka=n(),u(Tt.$$.fragment),er=n(),H=d("div"),u(bt.$$.fragment),Ou=n(),Yn=d("p"),Yn.textContent=yc,tr=n(),u(yt.$$.fragment),or=n(),E=d("div"),u(vt.$$.fragment),Fu=n(),Kn=d("p"),Kn.textContent=vc,nr=n(),u(xt.$$.fragment),sr=n(),Q=d("div"),u($t.$$.fragment),Su=n(),es=d("p"),es.textContent=xc,ar=n(),u(qt.$$.fragment),rr=n(),R=d("div"),u(wt.$$.fragment),Mu=n(),ts=d("p"),ts.textContent=$c,dr=n(),u(Ot.$$.fragment),ir=n(),U=d("div"),u(Ft.$$.fragment),Cu=n(),os=d("p"),os.textContent=qc,ur=n(),u(St.$$.fragment),lr=n(),X=d("div"),u(Mt.$$.fragment),zu=n(),ns=d("p"),ns.textContent=wc,cr=n(),u(Ct.$$.fragment),pr=n(),J=d("div"),u(zt.$$.fragment),Nu=n(),ss=d("p"),ss.textContent=Oc,hr=n(),u(Nt.$$.fragment),mr=n(),Z=d("div"),u(At.$$.fragment),Au=n(),as=d("p"),as.textContent=Fc,fr=n(),u(kt.$$.fragment),gr=n(),G=d("div"),u(Pt.$$.fragment),ku=n(),rs=d("p"),rs.textContent=Sc,_r=n(),u(Lt.$$.fragment),Tr=n(),Y=d("div"),u(Bt.$$.fragment),Pu=n(),ds=d("p"),ds.textContent=Mc,br=n(),u(jt.$$.fragment),yr=n(),K=d("div"),u(Wt.$$.fragment),Lu=n(),is=d("p"),is.textContent=Cc,vr=n(),u(Dt.$$.fragment),xr=n(),ee=d("div"),u(Vt.$$.fragment),Bu=n(),us=d("p"),us.textContent=zc,$r=n(),u(It.$$.fragment),qr=n(),te=d("div"),u(Ht.$$.fragment),ju=n(),ls=d("p"),ls.textContent=Nc,wr=n(),u(Et.$$.fragment),Or=n(),oe=d("div"),u(Qt.$$.fragment),Wu=n(),cs=d("p"),cs.textContent=Ac,Fr=n(),u(Rt.$$.fragment),Sr=n(),ne=d("div"),u(Ut.$$.fragment),Du=n(),ps=d("p"),ps.textContent=kc,Mr=n(),u(Xt.$$.fragment),Cr=n(),se=d("div"),u(Jt.$$.fragment),Vu=n(),hs=d("p"),hs.textContent=Pc,zr=n(),u(Zt.$$.fragment),Nr=n(),ae=d("div"),u(Gt.$$.fragment),Iu=n(),ms=d("p"),ms.textContent=Lc,Ar=n(),u(Yt.$$.fragment),kr=n(),re=d("div"),u(Kt.$$.fragment),Hu=n(),fs=d("p"),fs.textContent=Bc,Pr=n(),u(eo.$$.fragment),Lr=n(),de=d("div"),u(to.$$.fragment),Eu=n(),gs=d("p"),gs.textContent=jc,Br=n(),u(oo.$$.fragment),jr=n(),ie=d("div"),u(no.$$.fragment),Qu=n(),_s=d("p"),_s.textContent=Wc,Wr=n(),u(so.$$.fragment),Dr=n(),ue=d("div"),u(ao.$$.fragment),Ru=n(),Ts=d("p"),Ts.textContent=Dc,Vr=n(),u(ro.$$.fragment),Ir=n(),le=d("div"),u(io.$$.fragment),Uu=n(),bs=d("p"),bs.textContent=Vc,Hr=n(),u(uo.$$.fragment),Er=n(),ce=d("div"),u(lo.$$.fragment),Xu=n(),ys=d("p"),ys.innerHTML=Ic,Qr=n(),u(co.$$.fragment),Rr=n(),pe=d("div"),u(po.$$.fragment),Ju=n(),vs=d("p"),vs.textContent=Hc,Ur=n(),u(ho.$$.fragment),Xr=n(),he=d("div"),u(mo.$$.fragment),Zu=n(),xs=d("p"),xs.textContent=Ec,Jr=n(),u(fo.$$.fragment),Zr=n(),me=d("div"),u(go.$$.fragment),Gu=n(),$s=d("p"),$s.textContent=Qc,Gr=n(),u(_o.$$.fragment),Yr=n(),fe=d("div"),u(To.$$.fragment),Yu=n(),qs=d("p"),qs.textContent=Rc,Kr=n(),u(bo.$$.fragment),ed=n(),ge=d("div"),u(yo.$$.fragment),Ku=n(),ws=d("p"),ws.textContent=Uc,td=n(),u(vo.$$.fragment),od=n(),_e=d("div"),u(xo.$$.fragment),el=n(),Os=d("p"),Os.textContent=Xc,nd=n(),u($o.$$.fragment),sd=n(),Te=d("div"),u(qo.$$.fragment),tl=n(),Fs=d("p"),Fs.textContent=Jc,ad=n(),u(wo.$$.fragment),rd=n(),be=d("div"),u(Oo.$$.fragment),ol=n(),Ss=d("p"),Ss.textContent=Zc,dd=n(),u(Fo.$$.fragment),id=n(),ye=d("div"),u(So.$$.fragment),nl=n(),Ms=d("p"),Ms.textContent=Gc,ud=n(),u(Mo.$$.fragment),ld=n(),ve=d("div"),u(Co.$$.fragment),sl=n(),Cs=d("p"),Cs.textContent=Yc,cd=n(),u(zo.$$.fragment),pd=n(),xe=d("div"),u(No.$$.fragment),al=n(),zs=d("p"),zs.textContent=Kc,hd=n(),u(Ao.$$.fragment),md=n(),$e=d("div"),u(ko.$$.fragment),rl=n(),Ns=d("p"),Ns.textContent=ep,fd=n(),u(Po.$$.fragment),gd=n(),qe=d("div"),u(Lo.$$.fragment),dl=n(),As=d("p"),As.textContent=tp,_d=n(),u(Bo.$$.fragment),Td=n(),we=d("div"),u(jo.$$.fragment),il=n(),ks=d("p"),ks.textContent=op,bd=n(),u(Wo.$$.fragment),yd=n(),Oe=d("div"),u(Do.$$.fragment),ul=n(),Ps=d("p"),Ps.textContent=np,vd=n(),u(Vo.$$.fragment),xd=n(),Fe=d("div"),u(Io.$$.fragment),ll=n(),Ls=d("p"),Ls.textContent=sp,$d=n(),u(Ho.$$.fragment),qd=n(),Se=d("div"),u(Eo.$$.fragment),cl=n(),Bs=d("p"),Bs.textContent=ap,wd=n(),u(Qo.$$.fragment),Od=n(),Me=d("div"),u(Ro.$$.fragment),pl=n(),js=d("p"),js.textContent=rp,Fd=n(),u(Uo.$$.fragment),Sd=n(),Ce=d("div"),u(Xo.$$.fragment),hl=n(),Ws=d("p"),Ws.textContent=dp,Md=n(),u(Jo.$$.fragment),Cd=n(),ze=d("div"),u(Zo.$$.fragment),ml=n(),Ds=d("p"),Ds.textContent=ip,zd=n(),u(Go.$$.fragment),Nd=n(),Ne=d("div"),u(Yo.$$.fragment),fl=n(),Vs=d("p"),Vs.textContent=up,Ad=n(),u(Ko.$$.fragment),kd=n(),$=d("div"),u(en.$$.fragment),gl=n(),Is=d("p"),Is.textContent=lp,_l=n(),Be=d("div"),u(tn.$$.fragment),Tl=n(),Hs=d("p"),Hs.textContent=cp,Pd=n(),u(on.$$.fragment),Ld=n(),q=d("div"),u(nn.$$.fragment),bl=n(),Es=d("p"),Es.textContent=pp,yl=n(),je=d("div"),u(sn.$$.fragment),vl=n(),Qs=d("p"),Qs.textContent=hp,Bd=n(),u(an.$$.fragment),jd=n(),w=d("div"),u(rn.$$.fragment),xl=n(),Rs=d("p"),Rs.textContent=mp,$l=n(),We=d("div"),u(dn.$$.fragment),ql=n(),Us=d("p"),Us.textContent=fp,Wd=n(),u(un.$$.fragment),Dd=n(),O=d("div"),u(ln.$$.fragment),wl=n(),Xs=d("p"),Xs.textContent=gp,Ol=n(),De=d("div"),u(cn.$$.fragment),Fl=n(),Js=d("p"),Js.textContent=_p,Vd=n(),u(pn.$$.fragment),Id=n(),F=d("div"),u(hn.$$.fragment),Sl=n(),Zs=d("p"),Zs.textContent=Tp,Ml=n(),Ve=d("div"),u(mn.$$.fragment),Cl=n(),Gs=d("p"),Gs.textContent=bp,Hd=n(),u(fn.$$.fragment),Ed=n(),S=d("div"),u(gn.$$.fragment),zl=n(),Ys=d("p"),Ys.textContent=yp,Nl=n(),Ie=d("div"),u(_n.$$.fragment),Al=n(),Ks=d("p"),Ks.textContent=vp,Qd=n(),u(Tn.$$.fragment),Rd=n(),M=d("div"),u(bn.$$.fragment),kl=n(),ea=d("p"),ea.textContent=xp,Pl=n(),He=d("div"),u(yn.$$.fragment),Ll=n(),ta=d("p"),ta.textContent=$p,Ud=n(),u(vn.$$.fragment),Xd=n(),C=d("div"),u(xn.$$.fragment),Bl=n(),oa=d("p"),oa.textContent=qp,jl=n(),Ee=d("div"),u($n.$$.fragment),Wl=n(),na=d("p"),na.textContent=wp,Jd=n(),u(qn.$$.fragment),Zd=n(),z=d("div"),u(wn.$$.fragment),Dl=n(),sa=d("p"),sa.textContent=Op,Vl=n(),Qe=d("div"),u(On.$$.fragment),Il=n(),aa=d("p"),aa.textContent=Fp,Gd=n(),u(Fn.$$.fragment),Yd=n(),N=d("div"),u(Sn.$$.fragment),Hl=n(),ra=d("p"),ra.textContent=Sp,El=n(),Re=d("div"),u(Mn.$$.fragment),Ql=n(),da=d("p"),da.textContent=Mp,Kd=n(),u(Cn.$$.fragment),ei=n(),A=d("div"),u(zn.$$.fragment),Rl=n(),ia=d("p"),ia.textContent=Cp,Ul=n(),Ue=d("div"),u(Nn.$$.fragment),Xl=n(),ua=d("p"),ua.textContent=zp,ti=n(),u(An.$$.fragment),oi=n(),k=d("div"),u(kn.$$.fragment),Jl=n(),la=d("p"),la.textContent=Np,Zl=n(),Xe=d("div"),u(Pn.$$.fragment),Gl=n(),ca=d("p"),ca.textContent=Ap,ni=n(),u(Ln.$$.fragment),si=n(),P=d("div"),u(Bn.$$.fragment),Yl=n(),pa=d("p"),pa.textContent=kp,Kl=n(),Je=d("div"),u(jn.$$.fragment),ec=n(),ha=d("p"),ha.textContent=Pp,ai=n(),u(Wn.$$.fragment),ri=n(),L=d("div"),u(Dn.$$.fragment),tc=n(),ma=d("p"),ma.textContent=Lp,oc=n(),Ze=d("div"),u(Vn.$$.fragment),nc=n(),fa=d("p"),fa.textContent=Bp,di=n(),u(In.$$.fragment),ii=n(),B=d("div"),u(Hn.$$.fragment),sc=n(),ga=d("p"),ga.textContent=jp,ac=n(),Ge=d("div"),u(En.$$.fragment),rc=n(),_a=d("p"),_a.textContent=Wp,ui=n(),Aa=d("p"),this.h()},l(e){const o=Up("svelte-u9bgzb",document.head);y=i(o,"META",{name:!0,content:!0}),o.forEach(t),W=s(e),v=i(e,"P",{}),g(v).forEach(t),Ae=s(e),l(Ye.$$.fragment,e),ka=s(e),Ke=i(e,"P",{"data-svelte-h":!0}),f(Ke)!=="svelte-rt2932"&&(Ke.innerHTML=dc),Pa=s(e),et=i(e,"P",{"data-svelte-h":!0}),f(et)!=="svelte-zk7t5e"&&(et.textContent=ic),La=s(e),l(tt.$$.fragment,e),Ba=s(e),ot=i(e,"P",{"data-svelte-h":!0}),f(ot)!=="svelte-36rrjh"&&(ot.innerHTML=uc),ja=s(e),l(ke.$$.fragment,e),Wa=s(e),nt=i(e,"P",{"data-svelte-h":!0}),f(nt)!=="svelte-ww282k"&&(nt.innerHTML=lc),Da=s(e),st=i(e,"P",{"data-svelte-h":!0}),f(st)!=="svelte-qrkykg"&&(st.innerHTML=cc),Va=s(e),l(at.$$.fragment,e),Ia=s(e),rt=i(e,"P",{"data-svelte-h":!0}),f(rt)!=="svelte-sv5ldg"&&(rt.innerHTML=pc),Ha=s(e),dt=i(e,"P",{"data-svelte-h":!0}),f(dt)!=="svelte-1tp97x6"&&(dt.innerHTML=hc),Ea=s(e),it=i(e,"P",{"data-svelte-h":!0}),f(it)!=="svelte-1b6en9a"&&(it.textContent=mc),Qa=s(e),l(ut.$$.fragment,e),Ra=s(e),x=i(e,"DIV",{class:!0});var j=g(x);l(lt.$$.fragment,j),bu=s(j),Un=i(j,"P",{"data-svelte-h":!0}),f(Un)!=="svelte-1q6gwat"&&(Un.innerHTML=fc),yu=s(j),l(Pe.$$.fragment,j),vu=s(j),Le=i(j,"DIV",{class:!0});var Qn=g(Le);l(ct.$$.fragment,Qn),xu=s(Qn),Xn=i(Qn,"P",{"data-svelte-h":!0}),f(Xn)!=="svelte-1gdpts"&&(Xn.innerHTML=gc),Qn.forEach(t),j.forEach(t),Ua=s(e),l(pt.$$.fragment,e),Xa=s(e),D=i(e,"DIV",{class:!0});var ci=g(D);l(ht.$$.fragment,ci),$u=s(ci),Jn=i(ci,"P",{"data-svelte-h":!0}),f(Jn)!=="svelte-19jpj19"&&(Jn.textContent=_c),ci.forEach(t),Ja=s(e),l(mt.$$.fragment,e),Za=s(e),V=i(e,"DIV",{class:!0});var pi=g(V);l(ft.$$.fragment,pi),qu=s(pi),Zn=i(pi,"P",{"data-svelte-h":!0}),f(Zn)!=="svelte-rzpgnp"&&(Zn.textContent=Tc),pi.forEach(t),Ga=s(e),l(gt.$$.fragment,e),Ya=s(e),I=i(e,"DIV",{class:!0});var hi=g(I);l(_t.$$.fragment,hi),wu=s(hi),Gn=i(hi,"P",{"data-svelte-h":!0}),f(Gn)!=="svelte-19jpj19"&&(Gn.textContent=bc),hi.forEach(t),Ka=s(e),l(Tt.$$.fragment,e),er=s(e),H=i(e,"DIV",{class:!0});var mi=g(H);l(bt.$$.fragment,mi),Ou=s(mi),Yn=i(mi,"P",{"data-svelte-h":!0}),f(Yn)!=="svelte-rzpgnp"&&(Yn.textContent=yc),mi.forEach(t),tr=s(e),l(yt.$$.fragment,e),or=s(e),E=i(e,"DIV",{class:!0});var fi=g(E);l(vt.$$.fragment,fi),Fu=s(fi),Kn=i(fi,"P",{"data-svelte-h":!0}),f(Kn)!=="svelte-1kt4x95"&&(Kn.textContent=vc),fi.forEach(t),nr=s(e),l(xt.$$.fragment,e),sr=s(e),Q=i(e,"DIV",{class:!0});var gi=g(Q);l($t.$$.fragment,gi),Su=s(gi),es=i(gi,"P",{"data-svelte-h":!0}),f(es)!=="svelte-1kt4x95"&&(es.textContent=xc),gi.forEach(t),ar=s(e),l(qt.$$.fragment,e),rr=s(e),R=i(e,"DIV",{class:!0});var _i=g(R);l(wt.$$.fragment,_i),Mu=s(_i),ts=i(_i,"P",{"data-svelte-h":!0}),f(ts)!=="svelte-k12cko"&&(ts.textContent=$c),_i.forEach(t),dr=s(e),l(Ot.$$.fragment,e),ir=s(e),U=i(e,"DIV",{class:!0});var Ti=g(U);l(Ft.$$.fragment,Ti),Cu=s(Ti),os=i(Ti,"P",{"data-svelte-h":!0}),f(os)!=="svelte-3npkmq"&&(os.textContent=qc),Ti.forEach(t),ur=s(e),l(St.$$.fragment,e),lr=s(e),X=i(e,"DIV",{class:!0});var bi=g(X);l(Mt.$$.fragment,bi),zu=s(bi),ns=i(bi,"P",{"data-svelte-h":!0}),f(ns)!=="svelte-3npkmq"&&(ns.textContent=wc),bi.forEach(t),cr=s(e),l(Ct.$$.fragment,e),pr=s(e),J=i(e,"DIV",{class:!0});var yi=g(J);l(zt.$$.fragment,yi),Nu=s(yi),ss=i(yi,"P",{"data-svelte-h":!0}),f(ss)!=="svelte-3npkmq"&&(ss.textContent=Oc),yi.forEach(t),hr=s(e),l(Nt.$$.fragment,e),mr=s(e),Z=i(e,"DIV",{class:!0});var vi=g(Z);l(At.$$.fragment,vi),Au=s(vi),as=i(vi,"P",{"data-svelte-h":!0}),f(as)!=="svelte-1xezu93"&&(as.textContent=Fc),vi.forEach(t),fr=s(e),l(kt.$$.fragment,e),gr=s(e),G=i(e,"DIV",{class:!0});var xi=g(G);l(Pt.$$.fragment,xi),ku=s(xi),rs=i(xi,"P",{"data-svelte-h":!0}),f(rs)!=="svelte-1dobm33"&&(rs.textContent=Sc),xi.forEach(t),_r=s(e),l(Lt.$$.fragment,e),Tr=s(e),Y=i(e,"DIV",{class:!0});var $i=g(Y);l(Bt.$$.fragment,$i),Pu=s($i),ds=i($i,"P",{"data-svelte-h":!0}),f(ds)!=="svelte-1bm2i0r"&&(ds.textContent=Mc),$i.forEach(t),br=s(e),l(jt.$$.fragment,e),yr=s(e),K=i(e,"DIV",{class:!0});var qi=g(K);l(Wt.$$.fragment,qi),Lu=s(qi),is=i(qi,"P",{"data-svelte-h":!0}),f(is)!=="svelte-o4u80u"&&(is.textContent=Cc),qi.forEach(t),vr=s(e),l(Dt.$$.fragment,e),xr=s(e),ee=i(e,"DIV",{class:!0});var wi=g(ee);l(Vt.$$.fragment,wi),Bu=s(wi),us=i(wi,"P",{"data-svelte-h":!0}),f(us)!=="svelte-1kfw2sn"&&(us.textContent=zc),wi.forEach(t),$r=s(e),l(It.$$.fragment,e),qr=s(e),te=i(e,"DIV",{class:!0});var Oi=g(te);l(Ht.$$.fragment,Oi),ju=s(Oi),ls=i(Oi,"P",{"data-svelte-h":!0}),f(ls)!=="svelte-yql1ve"&&(ls.textContent=Nc),Oi.forEach(t),wr=s(e),l(Et.$$.fragment,e),Or=s(e),oe=i(e,"DIV",{class:!0});var Fi=g(oe);l(Qt.$$.fragment,Fi),Wu=s(Fi),cs=i(Fi,"P",{"data-svelte-h":!0}),f(cs)!=="svelte-1iv9pso"&&(cs.textContent=Ac),Fi.forEach(t),Fr=s(e),l(Rt.$$.fragment,e),Sr=s(e),ne=i(e,"DIV",{class:!0});var Si=g(ne);l(Ut.$$.fragment,Si),Du=s(Si),ps=i(Si,"P",{"data-svelte-h":!0}),f(ps)!=="svelte-w7415f"&&(ps.textContent=kc),Si.forEach(t),Mr=s(e),l(Xt.$$.fragment,e),Cr=s(e),se=i(e,"DIV",{class:!0});var Mi=g(se);l(Jt.$$.fragment,Mi),Vu=s(Mi),hs=i(Mi,"P",{"data-svelte-h":!0}),f(hs)!=="svelte-dhzux4"&&(hs.textContent=Pc),Mi.forEach(t),zr=s(e),l(Zt.$$.fragment,e),Nr=s(e),ae=i(e,"DIV",{class:!0});var Ci=g(ae);l(Gt.$$.fragment,Ci),Iu=s(Ci),ms=i(Ci,"P",{"data-svelte-h":!0}),f(ms)!=="svelte-8u8l5m"&&(ms.textContent=Lc),Ci.forEach(t),Ar=s(e),l(Yt.$$.fragment,e),kr=s(e),re=i(e,"DIV",{class:!0});var zi=g(re);l(Kt.$$.fragment,zi),Hu=s(zi),fs=i(zi,"P",{"data-svelte-h":!0}),f(fs)!=="svelte-kob7ff"&&(fs.textContent=Bc),zi.forEach(t),Pr=s(e),l(eo.$$.fragment,e),Lr=s(e),de=i(e,"DIV",{class:!0});var Ni=g(de);l(to.$$.fragment,Ni),Eu=s(Ni),gs=i(Ni,"P",{"data-svelte-h":!0}),f(gs)!=="svelte-sv2ymo"&&(gs.textContent=jc),Ni.forEach(t),Br=s(e),l(oo.$$.fragment,e),jr=s(e),ie=i(e,"DIV",{class:!0});var Ai=g(ie);l(no.$$.fragment,Ai),Qu=s(Ai),_s=i(Ai,"P",{"data-svelte-h":!0}),f(_s)!=="svelte-sv2ymo"&&(_s.textContent=Wc),Ai.forEach(t),Wr=s(e),l(so.$$.fragment,e),Dr=s(e),ue=i(e,"DIV",{class:!0});var ki=g(ue);l(ao.$$.fragment,ki),Ru=s(ki),Ts=i(ki,"P",{"data-svelte-h":!0}),f(Ts)!=="svelte-1rjgll"&&(Ts.textContent=Dc),ki.forEach(t),Vr=s(e),l(ro.$$.fragment,e),Ir=s(e),le=i(e,"DIV",{class:!0});var Pi=g(le);l(io.$$.fragment,Pi),Uu=s(Pi),bs=i(Pi,"P",{"data-svelte-h":!0}),f(bs)!=="svelte-1tmia4b"&&(bs.textContent=Vc),Pi.forEach(t),Hr=s(e),l(uo.$$.fragment,e),Er=s(e),ce=i(e,"DIV",{class:!0});var Li=g(ce);l(lo.$$.fragment,Li),Xu=s(Li),ys=i(Li,"P",{"data-svelte-h":!0}),f(ys)!=="svelte-14zaoly"&&(ys.innerHTML=Ic),Li.forEach(t),Qr=s(e),l(co.$$.fragment,e),Rr=s(e),pe=i(e,"DIV",{class:!0});var Bi=g(pe);l(po.$$.fragment,Bi),Ju=s(Bi),vs=i(Bi,"P",{"data-svelte-h":!0}),f(vs)!=="svelte-dz9ong"&&(vs.textContent=Hc),Bi.forEach(t),Ur=s(e),l(ho.$$.fragment,e),Xr=s(e),he=i(e,"DIV",{class:!0});var ji=g(he);l(mo.$$.fragment,ji),Zu=s(ji),xs=i(ji,"P",{"data-svelte-h":!0}),f(xs)!=="svelte-os2t7w"&&(xs.textContent=Ec),ji.forEach(t),Jr=s(e),l(fo.$$.fragment,e),Zr=s(e),me=i(e,"DIV",{class:!0});var Wi=g(me);l(go.$$.fragment,Wi),Gu=s(Wi),$s=i(Wi,"P",{"data-svelte-h":!0}),f($s)!=="svelte-1iolpnx"&&($s.textContent=Qc),Wi.forEach(t),Gr=s(e),l(_o.$$.fragment,e),Yr=s(e),fe=i(e,"DIV",{class:!0});var Di=g(fe);l(To.$$.fragment,Di),Yu=s(Di),qs=i(Di,"P",{"data-svelte-h":!0}),f(qs)!=="svelte-19jpj19"&&(qs.textContent=Rc),Di.forEach(t),Kr=s(e),l(bo.$$.fragment,e),ed=s(e),ge=i(e,"DIV",{class:!0});var Vi=g(ge);l(yo.$$.fragment,Vi),Ku=s(Vi),ws=i(Vi,"P",{"data-svelte-h":!0}),f(ws)!=="svelte-rzpgnp"&&(ws.textContent=Uc),Vi.forEach(t),td=s(e),l(vo.$$.fragment,e),od=s(e),_e=i(e,"DIV",{class:!0});var Ii=g(_e);l(xo.$$.fragment,Ii),el=s(Ii),Os=i(Ii,"P",{"data-svelte-h":!0}),f(Os)!=="svelte-rzpgnp"&&(Os.textContent=Xc),Ii.forEach(t),nd=s(e),l($o.$$.fragment,e),sd=s(e),Te=i(e,"DIV",{class:!0});var Hi=g(Te);l(qo.$$.fragment,Hi),tl=s(Hi),Fs=i(Hi,"P",{"data-svelte-h":!0}),f(Fs)!=="svelte-1kt4x95"&&(Fs.textContent=Jc),Hi.forEach(t),ad=s(e),l(wo.$$.fragment,e),rd=s(e),be=i(e,"DIV",{class:!0});var Ei=g(be);l(Oo.$$.fragment,Ei),ol=s(Ei),Ss=i(Ei,"P",{"data-svelte-h":!0}),f(Ss)!=="svelte-1kt4x95"&&(Ss.textContent=Zc),Ei.forEach(t),dd=s(e),l(Fo.$$.fragment,e),id=s(e),ye=i(e,"DIV",{class:!0});var Qi=g(ye);l(So.$$.fragment,Qi),nl=s(Qi),Ms=i(Qi,"P",{"data-svelte-h":!0}),f(Ms)!=="svelte-k12cko"&&(Ms.textContent=Gc),Qi.forEach(t),ud=s(e),l(Mo.$$.fragment,e),ld=s(e),ve=i(e,"DIV",{class:!0});var Ri=g(ve);l(Co.$$.fragment,Ri),sl=s(Ri),Cs=i(Ri,"P",{"data-svelte-h":!0}),f(Cs)!=="svelte-3npkmq"&&(Cs.textContent=Yc),Ri.forEach(t),cd=s(e),l(zo.$$.fragment,e),pd=s(e),xe=i(e,"DIV",{class:!0});var Ui=g(xe);l(No.$$.fragment,Ui),al=s(Ui),zs=i(Ui,"P",{"data-svelte-h":!0}),f(zs)!=="svelte-3npkmq"&&(zs.textContent=Kc),Ui.forEach(t),hd=s(e),l(Ao.$$.fragment,e),md=s(e),$e=i(e,"DIV",{class:!0});var Xi=g($e);l(ko.$$.fragment,Xi),rl=s(Xi),Ns=i(Xi,"P",{"data-svelte-h":!0}),f(Ns)!=="svelte-3npkmq"&&(Ns.textContent=ep),Xi.forEach(t),fd=s(e),l(Po.$$.fragment,e),gd=s(e),qe=i(e,"DIV",{class:!0});var Ji=g(qe);l(Lo.$$.fragment,Ji),dl=s(Ji),As=i(Ji,"P",{"data-svelte-h":!0}),f(As)!=="svelte-1xezu93"&&(As.textContent=tp),Ji.forEach(t),_d=s(e),l(Bo.$$.fragment,e),Td=s(e),we=i(e,"DIV",{class:!0});var Zi=g(we);l(jo.$$.fragment,Zi),il=s(Zi),ks=i(Zi,"P",{"data-svelte-h":!0}),f(ks)!=="svelte-1dobm33"&&(ks.textContent=op),Zi.forEach(t),bd=s(e),l(Wo.$$.fragment,e),yd=s(e),Oe=i(e,"DIV",{class:!0});var Gi=g(Oe);l(Do.$$.fragment,Gi),ul=s(Gi),Ps=i(Gi,"P",{"data-svelte-h":!0}),f(Ps)!=="svelte-1bm2i0r"&&(Ps.textContent=np),Gi.forEach(t),vd=s(e),l(Vo.$$.fragment,e),xd=s(e),Fe=i(e,"DIV",{class:!0});var Yi=g(Fe);l(Io.$$.fragment,Yi),ll=s(Yi),Ls=i(Yi,"P",{"data-svelte-h":!0}),f(Ls)!=="svelte-o4u80u"&&(Ls.textContent=sp),Yi.forEach(t),$d=s(e),l(Ho.$$.fragment,e),qd=s(e),Se=i(e,"DIV",{class:!0});var Ki=g(Se);l(Eo.$$.fragment,Ki),cl=s(Ki),Bs=i(Ki,"P",{"data-svelte-h":!0}),f(Bs)!=="svelte-1kfw2sn"&&(Bs.textContent=ap),Ki.forEach(t),wd=s(e),l(Qo.$$.fragment,e),Od=s(e),Me=i(e,"DIV",{class:!0});var eu=g(Me);l(Ro.$$.fragment,eu),pl=s(eu),js=i(eu,"P",{"data-svelte-h":!0}),f(js)!=="svelte-yql1ve"&&(js.textContent=rp),eu.forEach(t),Fd=s(e),l(Uo.$$.fragment,e),Sd=s(e),Ce=i(e,"DIV",{class:!0});var tu=g(Ce);l(Xo.$$.fragment,tu),hl=s(tu),Ws=i(tu,"P",{"data-svelte-h":!0}),f(Ws)!=="svelte-1iv9pso"&&(Ws.textContent=dp),tu.forEach(t),Md=s(e),l(Jo.$$.fragment,e),Cd=s(e),ze=i(e,"DIV",{class:!0});var ou=g(ze);l(Zo.$$.fragment,ou),ml=s(ou),Ds=i(ou,"P",{"data-svelte-h":!0}),f(Ds)!=="svelte-w7415f"&&(Ds.textContent=ip),ou.forEach(t),zd=s(e),l(Go.$$.fragment,e),Nd=s(e),Ne=i(e,"DIV",{class:!0});var nu=g(Ne);l(Yo.$$.fragment,nu),fl=s(nu),Vs=i(nu,"P",{"data-svelte-h":!0}),f(Vs)!=="svelte-dhzux4"&&(Vs.textContent=up),nu.forEach(t),Ad=s(e),l(Ko.$$.fragment,e),kd=s(e),$=i(e,"DIV",{class:!0});var Ta=g($);l(en.$$.fragment,Ta),gl=s(Ta),Is=i(Ta,"P",{"data-svelte-h":!0}),f(Is)!=="svelte-19jpj19"&&(Is.textContent=lp),_l=s(Ta),Be=i(Ta,"DIV",{class:!0});var su=g(Be);l(tn.$$.fragment,su),Tl=s(su),Hs=i(su,"P",{"data-svelte-h":!0}),f(Hs)!=="svelte-5ihtpa"&&(Hs.textContent=cp),su.forEach(t),Ta.forEach(t),Pd=s(e),l(on.$$.fragment,e),Ld=s(e),q=i(e,"DIV",{class:!0});var ba=g(q);l(nn.$$.fragment,ba),bl=s(ba),Es=i(ba,"P",{"data-svelte-h":!0}),f(Es)!=="svelte-19jpj19"&&(Es.textContent=pp),yl=s(ba),je=i(ba,"DIV",{class:!0});var au=g(je);l(sn.$$.fragment,au),vl=s(au),Qs=i(au,"P",{"data-svelte-h":!0}),f(Qs)!=="svelte-5ihtpa"&&(Qs.textContent=hp),au.forEach(t),ba.forEach(t),Bd=s(e),l(an.$$.fragment,e),jd=s(e),w=i(e,"DIV",{class:!0});var ya=g(w);l(rn.$$.fragment,ya),xl=s(ya),Rs=i(ya,"P",{"data-svelte-h":!0}),f(Rs)!=="svelte-rzpgnp"&&(Rs.textContent=mp),$l=s(ya),We=i(ya,"DIV",{class:!0});var ru=g(We);l(dn.$$.fragment,ru),ql=s(ru),Us=i(ru,"P",{"data-svelte-h":!0}),f(Us)!=="svelte-5ihtpa"&&(Us.textContent=fp),ru.forEach(t),ya.forEach(t),Wd=s(e),l(un.$$.fragment,e),Dd=s(e),O=i(e,"DIV",{class:!0});var va=g(O);l(ln.$$.fragment,va),wl=s(va),Xs=i(va,"P",{"data-svelte-h":!0}),f(Xs)!=="svelte-1kt4x95"&&(Xs.textContent=gp),Ol=s(va),De=i(va,"DIV",{class:!0});var du=g(De);l(cn.$$.fragment,du),Fl=s(du),Js=i(du,"P",{"data-svelte-h":!0}),f(Js)!=="svelte-5ihtpa"&&(Js.textContent=_p),du.forEach(t),va.forEach(t),Vd=s(e),l(pn.$$.fragment,e),Id=s(e),F=i(e,"DIV",{class:!0});var xa=g(F);l(hn.$$.fragment,xa),Sl=s(xa),Zs=i(xa,"P",{"data-svelte-h":!0}),f(Zs)!=="svelte-k12cko"&&(Zs.textContent=Tp),Ml=s(xa),Ve=i(xa,"DIV",{class:!0});var iu=g(Ve);l(mn.$$.fragment,iu),Cl=s(iu),Gs=i(iu,"P",{"data-svelte-h":!0}),f(Gs)!=="svelte-5ihtpa"&&(Gs.textContent=bp),iu.forEach(t),xa.forEach(t),Hd=s(e),l(fn.$$.fragment,e),Ed=s(e),S=i(e,"DIV",{class:!0});var $a=g(S);l(gn.$$.fragment,$a),zl=s($a),Ys=i($a,"P",{"data-svelte-h":!0}),f(Ys)!=="svelte-3npkmq"&&(Ys.textContent=yp),Nl=s($a),Ie=i($a,"DIV",{class:!0});var uu=g(Ie);l(_n.$$.fragment,uu),Al=s(uu),Ks=i(uu,"P",{"data-svelte-h":!0}),f(Ks)!=="svelte-5ihtpa"&&(Ks.textContent=vp),uu.forEach(t),$a.forEach(t),Qd=s(e),l(Tn.$$.fragment,e),Rd=s(e),M=i(e,"DIV",{class:!0});var qa=g(M);l(bn.$$.fragment,qa),kl=s(qa),ea=i(qa,"P",{"data-svelte-h":!0}),f(ea)!=="svelte-1xezu93"&&(ea.textContent=xp),Pl=s(qa),He=i(qa,"DIV",{class:!0});var lu=g(He);l(yn.$$.fragment,lu),Ll=s(lu),ta=i(lu,"P",{"data-svelte-h":!0}),f(ta)!=="svelte-5ihtpa"&&(ta.textContent=$p),lu.forEach(t),qa.forEach(t),Ud=s(e),l(vn.$$.fragment,e),Xd=s(e),C=i(e,"DIV",{class:!0});var wa=g(C);l(xn.$$.fragment,wa),Bl=s(wa),oa=i(wa,"P",{"data-svelte-h":!0}),f(oa)!=="svelte-1dobm33"&&(oa.textContent=qp),jl=s(wa),Ee=i(wa,"DIV",{class:!0});var cu=g(Ee);l($n.$$.fragment,cu),Wl=s(cu),na=i(cu,"P",{"data-svelte-h":!0}),f(na)!=="svelte-5ihtpa"&&(na.textContent=wp),cu.forEach(t),wa.forEach(t),Jd=s(e),l(qn.$$.fragment,e),Zd=s(e),z=i(e,"DIV",{class:!0});var Oa=g(z);l(wn.$$.fragment,Oa),Dl=s(Oa),sa=i(Oa,"P",{"data-svelte-h":!0}),f(sa)!=="svelte-1bm2i0r"&&(sa.textContent=Op),Vl=s(Oa),Qe=i(Oa,"DIV",{class:!0});var pu=g(Qe);l(On.$$.fragment,pu),Il=s(pu),aa=i(pu,"P",{"data-svelte-h":!0}),f(aa)!=="svelte-5ihtpa"&&(aa.textContent=Fp),pu.forEach(t),Oa.forEach(t),Gd=s(e),l(Fn.$$.fragment,e),Yd=s(e),N=i(e,"DIV",{class:!0});var Fa=g(N);l(Sn.$$.fragment,Fa),Hl=s(Fa),ra=i(Fa,"P",{"data-svelte-h":!0}),f(ra)!=="svelte-o4u80u"&&(ra.textContent=Sp),El=s(Fa),Re=i(Fa,"DIV",{class:!0});var hu=g(Re);l(Mn.$$.fragment,hu),Ql=s(hu),da=i(hu,"P",{"data-svelte-h":!0}),f(da)!=="svelte-5ihtpa"&&(da.textContent=Mp),hu.forEach(t),Fa.forEach(t),Kd=s(e),l(Cn.$$.fragment,e),ei=s(e),A=i(e,"DIV",{class:!0});var Sa=g(A);l(zn.$$.fragment,Sa),Rl=s(Sa),ia=i(Sa,"P",{"data-svelte-h":!0}),f(ia)!=="svelte-1kfw2sn"&&(ia.textContent=Cp),Ul=s(Sa),Ue=i(Sa,"DIV",{class:!0});var mu=g(Ue);l(Nn.$$.fragment,mu),Xl=s(mu),ua=i(mu,"P",{"data-svelte-h":!0}),f(ua)!=="svelte-5ihtpa"&&(ua.textContent=zp),mu.forEach(t),Sa.forEach(t),ti=s(e),l(An.$$.fragment,e),oi=s(e),k=i(e,"DIV",{class:!0});var Ma=g(k);l(kn.$$.fragment,Ma),Jl=s(Ma),la=i(Ma,"P",{"data-svelte-h":!0}),f(la)!=="svelte-yql1ve"&&(la.textContent=Np),Zl=s(Ma),Xe=i(Ma,"DIV",{class:!0});var fu=g(Xe);l(Pn.$$.fragment,fu),Gl=s(fu),ca=i(fu,"P",{"data-svelte-h":!0}),f(ca)!=="svelte-5ihtpa"&&(ca.textContent=Ap),fu.forEach(t),Ma.forEach(t),ni=s(e),l(Ln.$$.fragment,e),si=s(e),P=i(e,"DIV",{class:!0});var Ca=g(P);l(Bn.$$.fragment,Ca),Yl=s(Ca),pa=i(Ca,"P",{"data-svelte-h":!0}),f(pa)!=="svelte-1iv9pso"&&(pa.textContent=kp),Kl=s(Ca),Je=i(Ca,"DIV",{class:!0});var gu=g(Je);l(jn.$$.fragment,gu),ec=s(gu),ha=i(gu,"P",{"data-svelte-h":!0}),f(ha)!=="svelte-5ihtpa"&&(ha.textContent=Pp),gu.forEach(t),Ca.forEach(t),ai=s(e),l(Wn.$$.fragment,e),ri=s(e),L=i(e,"DIV",{class:!0});var za=g(L);l(Dn.$$.fragment,za),tc=s(za),ma=i(za,"P",{"data-svelte-h":!0}),f(ma)!=="svelte-w7415f"&&(ma.textContent=Lp),oc=s(za),Ze=i(za,"DIV",{class:!0});var _u=g(Ze);l(Vn.$$.fragment,_u),nc=s(_u),fa=i(_u,"P",{"data-svelte-h":!0}),f(fa)!=="svelte-5ihtpa"&&(fa.textContent=Bp),_u.forEach(t),za.forEach(t),di=s(e),l(In.$$.fragment,e),ii=s(e),B=i(e,"DIV",{class:!0});var Na=g(B);l(Hn.$$.fragment,Na),sc=s(Na),ga=i(Na,"P",{"data-svelte-h":!0}),f(ga)!=="svelte-dhzux4"&&(ga.textContent=jp),ac=s(Na),Ge=i(Na,"DIV",{class:!0});var Tu=g(Ge);l(En.$$.fragment,Tu),rc=s(Tu),_a=i(Tu,"P",{"data-svelte-h":!0}),f(_a)!=="svelte-5ihtpa"&&(_a.textContent=Wp),Tu.forEach(t),Na.forEach(t),ui=s(e),Aa=i(e,"P",{}),g(Aa).forEach(t),this.h()},h(){_(y,"name","hf:doc:metadata"),_(y,"content",Gp),_(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){r(document.head,y),a(e,W,o),a(e,v,o),a(e,Ae,o),c(Ye,e,o),a(e,ka,o),a(e,Ke,o),a(e,Pa,o),a(e,et,o),a(e,La,o),c(tt,e,o),a(e,Ba,o),a(e,ot,o),a(e,ja,o),c(ke,e,o),a(e,Wa,o),a(e,nt,o),a(e,Da,o),a(e,st,o),a(e,Va,o),c(at,e,o),a(e,Ia,o),a(e,rt,o),a(e,Ha,o),a(e,dt,o),a(e,Ea,o),a(e,it,o),a(e,Qa,o),c(ut,e,o),a(e,Ra,o),a(e,x,o),c(lt,x,null),r(x,bu),r(x,Un),r(x,yu),c(Pe,x,null),r(x,vu),r(x,Le),c(ct,Le,null),r(Le,xu),r(Le,Xn),a(e,Ua,o),c(pt,e,o),a(e,Xa,o),a(e,D,o),c(ht,D,null),r(D,$u),r(D,Jn),a(e,Ja,o),c(mt,e,o),a(e,Za,o),a(e,V,o),c(ft,V,null),r(V,qu),r(V,Zn),a(e,Ga,o),c(gt,e,o),a(e,Ya,o),a(e,I,o),c(_t,I,null),r(I,wu),r(I,Gn),a(e,Ka,o),c(Tt,e,o),a(e,er,o),a(e,H,o),c(bt,H,null),r(H,Ou),r(H,Yn),a(e,tr,o),c(yt,e,o),a(e,or,o),a(e,E,o),c(vt,E,null),r(E,Fu),r(E,Kn),a(e,nr,o),c(xt,e,o),a(e,sr,o),a(e,Q,o),c($t,Q,null),r(Q,Su),r(Q,es),a(e,ar,o),c(qt,e,o),a(e,rr,o),a(e,R,o),c(wt,R,null),r(R,Mu),r(R,ts),a(e,dr,o),c(Ot,e,o),a(e,ir,o),a(e,U,o),c(Ft,U,null),r(U,Cu),r(U,os),a(e,ur,o),c(St,e,o),a(e,lr,o),a(e,X,o),c(Mt,X,null),r(X,zu),r(X,ns),a(e,cr,o),c(Ct,e,o),a(e,pr,o),a(e,J,o),c(zt,J,null),r(J,Nu),r(J,ss),a(e,hr,o),c(Nt,e,o),a(e,mr,o),a(e,Z,o),c(At,Z,null),r(Z,Au),r(Z,as),a(e,fr,o),c(kt,e,o),a(e,gr,o),a(e,G,o),c(Pt,G,null),r(G,ku),r(G,rs),a(e,_r,o),c(Lt,e,o),a(e,Tr,o),a(e,Y,o),c(Bt,Y,null),r(Y,Pu),r(Y,ds),a(e,br,o),c(jt,e,o),a(e,yr,o),a(e,K,o),c(Wt,K,null),r(K,Lu),r(K,is),a(e,vr,o),c(Dt,e,o),a(e,xr,o),a(e,ee,o),c(Vt,ee,null),r(ee,Bu),r(ee,us),a(e,$r,o),c(It,e,o),a(e,qr,o),a(e,te,o),c(Ht,te,null),r(te,ju),r(te,ls),a(e,wr,o),c(Et,e,o),a(e,Or,o),a(e,oe,o),c(Qt,oe,null),r(oe,Wu),r(oe,cs),a(e,Fr,o),c(Rt,e,o),a(e,Sr,o),a(e,ne,o),c(Ut,ne,null),r(ne,Du),r(ne,ps),a(e,Mr,o),c(Xt,e,o),a(e,Cr,o),a(e,se,o),c(Jt,se,null),r(se,Vu),r(se,hs),a(e,zr,o),c(Zt,e,o),a(e,Nr,o),a(e,ae,o),c(Gt,ae,null),r(ae,Iu),r(ae,ms),a(e,Ar,o),c(Yt,e,o),a(e,kr,o),a(e,re,o),c(Kt,re,null),r(re,Hu),r(re,fs),a(e,Pr,o),c(eo,e,o),a(e,Lr,o),a(e,de,o),c(to,de,null),r(de,Eu),r(de,gs),a(e,Br,o),c(oo,e,o),a(e,jr,o),a(e,ie,o),c(no,ie,null),r(ie,Qu),r(ie,_s),a(e,Wr,o),c(so,e,o),a(e,Dr,o),a(e,ue,o),c(ao,ue,null),r(ue,Ru),r(ue,Ts),a(e,Vr,o),c(ro,e,o),a(e,Ir,o),a(e,le,o),c(io,le,null),r(le,Uu),r(le,bs),a(e,Hr,o),c(uo,e,o),a(e,Er,o),a(e,ce,o),c(lo,ce,null),r(ce,Xu),r(ce,ys),a(e,Qr,o),c(co,e,o),a(e,Rr,o),a(e,pe,o),c(po,pe,null),r(pe,Ju),r(pe,vs),a(e,Ur,o),c(ho,e,o),a(e,Xr,o),a(e,he,o),c(mo,he,null),r(he,Zu),r(he,xs),a(e,Jr,o),c(fo,e,o),a(e,Zr,o),a(e,me,o),c(go,me,null),r(me,Gu),r(me,$s),a(e,Gr,o),c(_o,e,o),a(e,Yr,o),a(e,fe,o),c(To,fe,null),r(fe,Yu),r(fe,qs),a(e,Kr,o),c(bo,e,o),a(e,ed,o),a(e,ge,o),c(yo,ge,null),r(ge,Ku),r(ge,ws),a(e,td,o),c(vo,e,o),a(e,od,o),a(e,_e,o),c(xo,_e,null),r(_e,el),r(_e,Os),a(e,nd,o),c($o,e,o),a(e,sd,o),a(e,Te,o),c(qo,Te,null),r(Te,tl),r(Te,Fs),a(e,ad,o),c(wo,e,o),a(e,rd,o),a(e,be,o),c(Oo,be,null),r(be,ol),r(be,Ss),a(e,dd,o),c(Fo,e,o),a(e,id,o),a(e,ye,o),c(So,ye,null),r(ye,nl),r(ye,Ms),a(e,ud,o),c(Mo,e,o),a(e,ld,o),a(e,ve,o),c(Co,ve,null),r(ve,sl),r(ve,Cs),a(e,cd,o),c(zo,e,o),a(e,pd,o),a(e,xe,o),c(No,xe,null),r(xe,al),r(xe,zs),a(e,hd,o),c(Ao,e,o),a(e,md,o),a(e,$e,o),c(ko,$e,null),r($e,rl),r($e,Ns),a(e,fd,o),c(Po,e,o),a(e,gd,o),a(e,qe,o),c(Lo,qe,null),r(qe,dl),r(qe,As),a(e,_d,o),c(Bo,e,o),a(e,Td,o),a(e,we,o),c(jo,we,null),r(we,il),r(we,ks),a(e,bd,o),c(Wo,e,o),a(e,yd,o),a(e,Oe,o),c(Do,Oe,null),r(Oe,ul),r(Oe,Ps),a(e,vd,o),c(Vo,e,o),a(e,xd,o),a(e,Fe,o),c(Io,Fe,null),r(Fe,ll),r(Fe,Ls),a(e,$d,o),c(Ho,e,o),a(e,qd,o),a(e,Se,o),c(Eo,Se,null),r(Se,cl),r(Se,Bs),a(e,wd,o),c(Qo,e,o),a(e,Od,o),a(e,Me,o),c(Ro,Me,null),r(Me,pl),r(Me,js),a(e,Fd,o),c(Uo,e,o),a(e,Sd,o),a(e,Ce,o),c(Xo,Ce,null),r(Ce,hl),r(Ce,Ws),a(e,Md,o),c(Jo,e,o),a(e,Cd,o),a(e,ze,o),c(Zo,ze,null),r(ze,ml),r(ze,Ds),a(e,zd,o),c(Go,e,o),a(e,Nd,o),a(e,Ne,o),c(Yo,Ne,null),r(Ne,fl),r(Ne,Vs),a(e,Ad,o),c(Ko,e,o),a(e,kd,o),a(e,$,o),c(en,$,null),r($,gl),r($,Is),r($,_l),r($,Be),c(tn,Be,null),r(Be,Tl),r(Be,Hs),a(e,Pd,o),c(on,e,o),a(e,Ld,o),a(e,q,o),c(nn,q,null),r(q,bl),r(q,Es),r(q,yl),r(q,je),c(sn,je,null),r(je,vl),r(je,Qs),a(e,Bd,o),c(an,e,o),a(e,jd,o),a(e,w,o),c(rn,w,null),r(w,xl),r(w,Rs),r(w,$l),r(w,We),c(dn,We,null),r(We,ql),r(We,Us),a(e,Wd,o),c(un,e,o),a(e,Dd,o),a(e,O,o),c(ln,O,null),r(O,wl),r(O,Xs),r(O,Ol),r(O,De),c(cn,De,null),r(De,Fl),r(De,Js),a(e,Vd,o),c(pn,e,o),a(e,Id,o),a(e,F,o),c(hn,F,null),r(F,Sl),r(F,Zs),r(F,Ml),r(F,Ve),c(mn,Ve,null),r(Ve,Cl),r(Ve,Gs),a(e,Hd,o),c(fn,e,o),a(e,Ed,o),a(e,S,o),c(gn,S,null),r(S,zl),r(S,Ys),r(S,Nl),r(S,Ie),c(_n,Ie,null),r(Ie,Al),r(Ie,Ks),a(e,Qd,o),c(Tn,e,o),a(e,Rd,o),a(e,M,o),c(bn,M,null),r(M,kl),r(M,ea),r(M,Pl),r(M,He),c(yn,He,null),r(He,Ll),r(He,ta),a(e,Ud,o),c(vn,e,o),a(e,Xd,o),a(e,C,o),c(xn,C,null),r(C,Bl),r(C,oa),r(C,jl),r(C,Ee),c($n,Ee,null),r(Ee,Wl),r(Ee,na),a(e,Jd,o),c(qn,e,o),a(e,Zd,o),a(e,z,o),c(wn,z,null),r(z,Dl),r(z,sa),r(z,Vl),r(z,Qe),c(On,Qe,null),r(Qe,Il),r(Qe,aa),a(e,Gd,o),c(Fn,e,o),a(e,Yd,o),a(e,N,o),c(Sn,N,null),r(N,Hl),r(N,ra),r(N,El),r(N,Re),c(Mn,Re,null),r(Re,Ql),r(Re,da),a(e,Kd,o),c(Cn,e,o),a(e,ei,o),a(e,A,o),c(zn,A,null),r(A,Rl),r(A,ia),r(A,Ul),r(A,Ue),c(Nn,Ue,null),r(Ue,Xl),r(Ue,ua),a(e,ti,o),c(An,e,o),a(e,oi,o),a(e,k,o),c(kn,k,null),r(k,Jl),r(k,la),r(k,Zl),r(k,Xe),c(Pn,Xe,null),r(Xe,Gl),r(Xe,ca),a(e,ni,o),c(Ln,e,o),a(e,si,o),a(e,P,o),c(Bn,P,null),r(P,Yl),r(P,pa),r(P,Kl),r(P,Je),c(jn,Je,null),r(Je,ec),r(Je,ha),a(e,ai,o),c(Wn,e,o),a(e,ri,o),a(e,L,o),c(Dn,L,null),r(L,tc),r(L,ma),r(L,oc),r(L,Ze),c(Vn,Ze,null),r(Ze,nc),r(Ze,fa),a(e,di,o),c(In,e,o),a(e,ii,o),a(e,B,o),c(Hn,B,null),r(B,sc),r(B,ga),r(B,ac),r(B,Ge),c(En,Ge,null),r(Ge,rc),r(Ge,_a),a(e,ui,o),a(e,Aa,o),li=!0},p(e,[o]){const j={};o&2&&(j.$$scope={dirty:o,ctx:e}),ke.$set(j);const Qn={};o&2&&(Qn.$$scope={dirty:o,ctx:e}),Pe.$set(Qn)},i(e){li||(p(Ye.$$.fragment,e),p(tt.$$.fragment,e),p(ke.$$.fragment,e),p(at.$$.fragment,e),p(ut.$$.fragment,e),p(lt.$$.fragment,e),p(Pe.$$.fragment,e),p(ct.$$.fragment,e),p(pt.$$.fragment,e),p(ht.$$.fragment,e),p(mt.$$.fragment,e),p(ft.$$.fragment,e),p(gt.$$.fragment,e),p(_t.$$.fragment,e),p(Tt.$$.fragment,e),p(bt.$$.fragment,e),p(yt.$$.fragment,e),p(vt.$$.fragment,e),p(xt.$$.fragment,e),p($t.$$.fragment,e),p(qt.$$.fragment,e),p(wt.$$.fragment,e),p(Ot.$$.fragment,e),p(Ft.$$.fragment,e),p(St.$$.fragment,e),p(Mt.$$.fragment,e),p(Ct.$$.fragment,e),p(zt.$$.fragment,e),p(Nt.$$.fragment,e),p(At.$$.fragment,e),p(kt.$$.fragment,e),p(Pt.$$.fragment,e),p(Lt.$$.fragment,e),p(Bt.$$.fragment,e),p(jt.$$.fragment,e),p(Wt.$$.fragment,e),p(Dt.$$.fragment,e),p(Vt.$$.fragment,e),p(It.$$.fragment,e),p(Ht.$$.fragment,e),p(Et.$$.fragment,e),p(Qt.$$.fragment,e),p(Rt.$$.fragment,e),p(Ut.$$.fragment,e),p(Xt.$$.fragment,e),p(Jt.$$.fragment,e),p(Zt.$$.fragment,e),p(Gt.$$.fragment,e),p(Yt.$$.fragment,e),p(Kt.$$.fragment,e),p(eo.$$.fragment,e),p(to.$$.fragment,e),p(oo.$$.fragment,e),p(no.$$.fragment,e),p(so.$$.fragment,e),p(ao.$$.fragment,e),p(ro.$$.fragment,e),p(io.$$.fragment,e),p(uo.$$.fragment,e),p(lo.$$.fragment,e),p(co.$$.fragment,e),p(po.$$.fragment,e),p(ho.$$.fragment,e),p(mo.$$.fragment,e),p(fo.$$.fragment,e),p(go.$$.fragment,e),p(_o.$$.fragment,e),p(To.$$.fragment,e),p(bo.$$.fragment,e),p(yo.$$.fragment,e),p(vo.$$.fragment,e),p(xo.$$.fragment,e),p($o.$$.fragment,e),p(qo.$$.fragment,e),p(wo.$$.fragment,e),p(Oo.$$.fragment,e),p(Fo.$$.fragment,e),p(So.$$.fragment,e),p(Mo.$$.fragment,e),p(Co.$$.fragment,e),p(zo.$$.fragment,e),p(No.$$.fragment,e),p(Ao.$$.fragment,e),p(ko.$$.fragment,e),p(Po.$$.fragment,e),p(Lo.$$.fragment,e),p(Bo.$$.fragment,e),p(jo.$$.fragment,e),p(Wo.$$.fragment,e),p(Do.$$.fragment,e),p(Vo.$$.fragment,e),p(Io.$$.fragment,e),p(Ho.$$.fragment,e),p(Eo.$$.fragment,e),p(Qo.$$.fragment,e),p(Ro.$$.fragment,e),p(Uo.$$.fragment,e),p(Xo.$$.fragment,e),p(Jo.$$.fragment,e),p(Zo.$$.fragment,e),p(Go.$$.fragment,e),p(Yo.$$.fragment,e),p(Ko.$$.fragment,e),p(en.$$.fragment,e),p(tn.$$.fragment,e),p(on.$$.fragment,e),p(nn.$$.fragment,e),p(sn.$$.fragment,e),p(an.$$.fragment,e),p(rn.$$.fragment,e),p(dn.$$.fragment,e),p(un.$$.fragment,e),p(ln.$$.fragment,e),p(cn.$$.fragment,e),p(pn.$$.fragment,e),p(hn.$$.fragment,e),p(mn.$$.fragment,e),p(fn.$$.fragment,e),p(gn.$$.fragment,e),p(_n.$$.fragment,e),p(Tn.$$.fragment,e),p(bn.$$.fragment,e),p(yn.$$.fragment,e),p(vn.$$.fragment,e),p(xn.$$.fragment,e),p($n.$$.fragment,e),p(qn.$$.fragment,e),p(wn.$$.fragment,e),p(On.$$.fragment,e),p(Fn.$$.fragment,e),p(Sn.$$.fragment,e),p(Mn.$$.fragment,e),p(Cn.$$.fragment,e),p(zn.$$.fragment,e),p(Nn.$$.fragment,e),p(An.$$.fragment,e),p(kn.$$.fragment,e),p(Pn.$$.fragment,e),p(Ln.$$.fragment,e),p(Bn.$$.fragment,e),p(jn.$$.fragment,e),p(Wn.$$.fragment,e),p(Dn.$$.fragment,e),p(Vn.$$.fragment,e),p(In.$$.fragment,e),p(Hn.$$.fragment,e),p(En.$$.fragment,e),li=!0)},o(e){h(Ye.$$.fragment,e),h(tt.$$.fragment,e),h(ke.$$.fragment,e),h(at.$$.fragment,e),h(ut.$$.fragment,e),h(lt.$$.fragment,e),h(Pe.$$.fragment,e),h(ct.$$.fragment,e),h(pt.$$.fragment,e),h(ht.$$.fragment,e),h(mt.$$.fragment,e),h(ft.$$.fragment,e),h(gt.$$.fragment,e),h(_t.$$.fragment,e),h(Tt.$$.fragment,e),h(bt.$$.fragment,e),h(yt.$$.fragment,e),h(vt.$$.fragment,e),h(xt.$$.fragment,e),h($t.$$.fragment,e),h(qt.$$.fragment,e),h(wt.$$.fragment,e),h(Ot.$$.fragment,e),h(Ft.$$.fragment,e),h(St.$$.fragment,e),h(Mt.$$.fragment,e),h(Ct.$$.fragment,e),h(zt.$$.fragment,e),h(Nt.$$.fragment,e),h(At.$$.fragment,e),h(kt.$$.fragment,e),h(Pt.$$.fragment,e),h(Lt.$$.fragment,e),h(Bt.$$.fragment,e),h(jt.$$.fragment,e),h(Wt.$$.fragment,e),h(Dt.$$.fragment,e),h(Vt.$$.fragment,e),h(It.$$.fragment,e),h(Ht.$$.fragment,e),h(Et.$$.fragment,e),h(Qt.$$.fragment,e),h(Rt.$$.fragment,e),h(Ut.$$.fragment,e),h(Xt.$$.fragment,e),h(Jt.$$.fragment,e),h(Zt.$$.fragment,e),h(Gt.$$.fragment,e),h(Yt.$$.fragment,e),h(Kt.$$.fragment,e),h(eo.$$.fragment,e),h(to.$$.fragment,e),h(oo.$$.fragment,e),h(no.$$.fragment,e),h(so.$$.fragment,e),h(ao.$$.fragment,e),h(ro.$$.fragment,e),h(io.$$.fragment,e),h(uo.$$.fragment,e),h(lo.$$.fragment,e),h(co.$$.fragment,e),h(po.$$.fragment,e),h(ho.$$.fragment,e),h(mo.$$.fragment,e),h(fo.$$.fragment,e),h(go.$$.fragment,e),h(_o.$$.fragment,e),h(To.$$.fragment,e),h(bo.$$.fragment,e),h(yo.$$.fragment,e),h(vo.$$.fragment,e),h(xo.$$.fragment,e),h($o.$$.fragment,e),h(qo.$$.fragment,e),h(wo.$$.fragment,e),h(Oo.$$.fragment,e),h(Fo.$$.fragment,e),h(So.$$.fragment,e),h(Mo.$$.fragment,e),h(Co.$$.fragment,e),h(zo.$$.fragment,e),h(No.$$.fragment,e),h(Ao.$$.fragment,e),h(ko.$$.fragment,e),h(Po.$$.fragment,e),h(Lo.$$.fragment,e),h(Bo.$$.fragment,e),h(jo.$$.fragment,e),h(Wo.$$.fragment,e),h(Do.$$.fragment,e),h(Vo.$$.fragment,e),h(Io.$$.fragment,e),h(Ho.$$.fragment,e),h(Eo.$$.fragment,e),h(Qo.$$.fragment,e),h(Ro.$$.fragment,e),h(Uo.$$.fragment,e),h(Xo.$$.fragment,e),h(Jo.$$.fragment,e),h(Zo.$$.fragment,e),h(Go.$$.fragment,e),h(Yo.$$.fragment,e),h(Ko.$$.fragment,e),h(en.$$.fragment,e),h(tn.$$.fragment,e),h(on.$$.fragment,e),h(nn.$$.fragment,e),h(sn.$$.fragment,e),h(an.$$.fragment,e),h(rn.$$.fragment,e),h(dn.$$.fragment,e),h(un.$$.fragment,e),h(ln.$$.fragment,e),h(cn.$$.fragment,e),h(pn.$$.fragment,e),h(hn.$$.fragment,e),h(mn.$$.fragment,e),h(fn.$$.fragment,e),h(gn.$$.fragment,e),h(_n.$$.fragment,e),h(Tn.$$.fragment,e),h(bn.$$.fragment,e),h(yn.$$.fragment,e),h(vn.$$.fragment,e),h(xn.$$.fragment,e),h($n.$$.fragment,e),h(qn.$$.fragment,e),h(wn.$$.fragment,e),h(On.$$.fragment,e),h(Fn.$$.fragment,e),h(Sn.$$.fragment,e),h(Mn.$$.fragment,e),h(Cn.$$.fragment,e),h(zn.$$.fragment,e),h(Nn.$$.fragment,e),h(An.$$.fragment,e),h(kn.$$.fragment,e),h(Pn.$$.fragment,e),h(Ln.$$.fragment,e),h(Bn.$$.fragment,e),h(jn.$$.fragment,e),h(Wn.$$.fragment,e),h(Dn.$$.fragment,e),h(Vn.$$.fragment,e),h(In.$$.fragment,e),h(Hn.$$.fragment,e),h(En.$$.fragment,e),li=!1},d(e){e&&(t(W),t(v),t(Ae),t(ka),t(Ke),t(Pa),t(et),t(La),t(Ba),t(ot),t(ja),t(Wa),t(nt),t(Da),t(st),t(Va),t(Ia),t(rt),t(Ha),t(dt),t(Ea),t(it),t(Qa),t(Ra),t(x),t(Ua),t(Xa),t(D),t(Ja),t(Za),t(V),t(Ga),t(Ya),t(I),t(Ka),t(er),t(H),t(tr),t(or),t(E),t(nr),t(sr),t(Q),t(ar),t(rr),t(R),t(dr),t(ir),t(U),t(ur),t(lr),t(X),t(cr),t(pr),t(J),t(hr),t(mr),t(Z),t(fr),t(gr),t(G),t(_r),t(Tr),t(Y),t(br),t(yr),t(K),t(vr),t(xr),t(ee),t($r),t(qr),t(te),t(wr),t(Or),t(oe),t(Fr),t(Sr),t(ne),t(Mr),t(Cr),t(se),t(zr),t(Nr),t(ae),t(Ar),t(kr),t(re),t(Pr),t(Lr),t(de),t(Br),t(jr),t(ie),t(Wr),t(Dr),t(ue),t(Vr),t(Ir),t(le),t(Hr),t(Er),t(ce),t(Qr),t(Rr),t(pe),t(Ur),t(Xr),t(he),t(Jr),t(Zr),t(me),t(Gr),t(Yr),t(fe),t(Kr),t(ed),t(ge),t(td),t(od),t(_e),t(nd),t(sd),t(Te),t(ad),t(rd),t(be),t(dd),t(id),t(ye),t(ud),t(ld),t(ve),t(cd),t(pd),t(xe),t(hd),t(md),t($e),t(fd),t(gd),t(qe),t(_d),t(Td),t(we),t(bd),t(yd),t(Oe),t(vd),t(xd),t(Fe),t($d),t(qd),t(Se),t(wd),t(Od),t(Me),t(Fd),t(Sd),t(Ce),t(Md),t(Cd),t(ze),t(zd),t(Nd),t(Ne),t(Ad),t(kd),t($),t(Pd),t(Ld),t(q),t(Bd),t(jd),t(w),t(Wd),t(Dd),t(O),t(Vd),t(Id),t(F),t(Hd),t(Ed),t(S),t(Qd),t(Rd),t(M),t(Ud),t(Xd),t(C),t(Jd),t(Zd),t(z),t(Gd),t(Yd),t(N),t(Kd),t(ei),t(A),t(ti),t(oi),t(k),t(ni),t(si),t(P),t(ai),t(ri),t(L),t(di),t(ii),t(B),t(ui),t(Aa)),t(y),m(Ye,e),m(tt,e),m(ke,e),m(at,e),m(ut,e),m(lt),m(Pe),m(ct),m(pt,e),m(ht),m(mt,e),m(ft),m(gt,e),m(_t),m(Tt,e),m(bt),m(yt,e),m(vt),m(xt,e),m($t),m(qt,e),m(wt),m(Ot,e),m(Ft),m(St,e),m(Mt),m(Ct,e),m(zt),m(Nt,e),m(At),m(kt,e),m(Pt),m(Lt,e),m(Bt),m(jt,e),m(Wt),m(Dt,e),m(Vt),m(It,e),m(Ht),m(Et,e),m(Qt),m(Rt,e),m(Ut),m(Xt,e),m(Jt),m(Zt,e),m(Gt),m(Yt,e),m(Kt),m(eo,e),m(to),m(oo,e),m(no),m(so,e),m(ao),m(ro,e),m(io),m(uo,e),m(lo),m(co,e),m(po),m(ho,e),m(mo),m(fo,e),m(go),m(_o,e),m(To),m(bo,e),m(yo),m(vo,e),m(xo),m($o,e),m(qo),m(wo,e),m(Oo),m(Fo,e),m(So),m(Mo,e),m(Co),m(zo,e),m(No),m(Ao,e),m(ko),m(Po,e),m(Lo),m(Bo,e),m(jo),m(Wo,e),m(Do),m(Vo,e),m(Io),m(Ho,e),m(Eo),m(Qo,e),m(Ro),m(Uo,e),m(Xo),m(Jo,e),m(Zo),m(Go,e),m(Yo),m(Ko,e),m(en),m(tn),m(on,e),m(nn),m(sn),m(an,e),m(rn),m(dn),m(un,e),m(ln),m(cn),m(pn,e),m(hn),m(mn),m(fn,e),m(gn),m(_n),m(Tn,e),m(bn),m(yn),m(vn,e),m(xn),m($n),m(qn,e),m(wn),m(On),m(Fn,e),m(Sn),m(Mn),m(Cn,e),m(zn),m(Nn),m(An,e),m(kn),m(Pn),m(Ln,e),m(Bn),m(jn),m(Wn,e),m(Dn),m(Vn),m(In,e),m(Hn),m(En)}}}const Gp='{"title":"Model outputs","local":"model-outputs","sections":[{"title":"ModelOutput","local":"transformers.utils.ModelOutput","sections":[],"depth":2},{"title":"BaseModelOutput","local":"transformers.modeling_outputs.BaseModelOutput","sections":[],"depth":2},{"title":"BaseModelOutputWithPooling","local":"transformers.modeling_outputs.BaseModelOutputWithPooling","sections":[],"depth":2},{"title":"BaseModelOutputWithCrossAttentions","local":"transformers.modeling_outputs.BaseModelOutputWithCrossAttentions","sections":[],"depth":2},{"title":"BaseModelOutputWithPoolingAndCrossAttentions","local":"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions","sections":[],"depth":2},{"title":"BaseModelOutputWithPast","local":"transformers.modeling_outputs.BaseModelOutputWithPast","sections":[],"depth":2},{"title":"BaseModelOutputWithPastAndCrossAttentions","local":"transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions","sections":[],"depth":2},{"title":"Seq2SeqModelOutput","local":"transformers.modeling_outputs.Seq2SeqModelOutput","sections":[],"depth":2},{"title":"CausalLMOutput","local":"transformers.modeling_outputs.CausalLMOutput","sections":[],"depth":2},{"title":"CausalLMOutputWithCrossAttentions","local":"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions","sections":[],"depth":2},{"title":"CausalLMOutputWithPast","local":"transformers.modeling_outputs.CausalLMOutputWithPast","sections":[],"depth":2},{"title":"MaskedLMOutput","local":"transformers.modeling_outputs.MaskedLMOutput","sections":[],"depth":2},{"title":"Seq2SeqLMOutput","local":"transformers.modeling_outputs.Seq2SeqLMOutput","sections":[],"depth":2},{"title":"NextSentencePredictorOutput","local":"transformers.modeling_outputs.NextSentencePredictorOutput","sections":[],"depth":2},{"title":"SequenceClassifierOutput","local":"transformers.modeling_outputs.SequenceClassifierOutput","sections":[],"depth":2},{"title":"Seq2SeqSequenceClassifierOutput","local":"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput","sections":[],"depth":2},{"title":"MultipleChoiceModelOutput","local":"transformers.modeling_outputs.MultipleChoiceModelOutput","sections":[],"depth":2},{"title":"TokenClassifierOutput","local":"transformers.modeling_outputs.TokenClassifierOutput","sections":[],"depth":2},{"title":"QuestionAnsweringModelOutput","local":"transformers.modeling_outputs.QuestionAnsweringModelOutput","sections":[],"depth":2},{"title":"Seq2SeqQuestionAnsweringModelOutput","local":"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput","sections":[],"depth":2},{"title":"Seq2SeqSpectrogramOutput","local":"transformers.modeling_outputs.Seq2SeqSpectrogramOutput","sections":[],"depth":2},{"title":"SemanticSegmenterOutput","local":"transformers.modeling_outputs.SemanticSegmenterOutput","sections":[],"depth":2},{"title":"ImageClassifierOutput","local":"transformers.modeling_outputs.ImageClassifierOutput","sections":[],"depth":2},{"title":"ImageClassifierOutputWithNoAttention","local":"transformers.modeling_outputs.ImageClassifierOutputWithNoAttention","sections":[],"depth":2},{"title":"DepthEstimatorOutput","local":"transformers.modeling_outputs.DepthEstimatorOutput","sections":[],"depth":2},{"title":"Wav2Vec2BaseModelOutput","local":"transformers.modeling_outputs.Wav2Vec2BaseModelOutput","sections":[],"depth":2},{"title":"XVectorOutput","local":"transformers.modeling_outputs.XVectorOutput","sections":[],"depth":2},{"title":"Seq2SeqTSModelOutput","local":"transformers.modeling_outputs.Seq2SeqTSModelOutput","sections":[],"depth":2},{"title":"Seq2SeqTSPredictionOutput","local":"transformers.modeling_outputs.Seq2SeqTSPredictionOutput","sections":[],"depth":2},{"title":"SampleTSPredictionOutput","local":"transformers.modeling_outputs.SampleTSPredictionOutput","sections":[],"depth":2},{"title":"TFBaseModelOutput","local":"transformers.modeling_tf_outputs.TFBaseModelOutput","sections":[],"depth":2},{"title":"TFBaseModelOutputWithPooling","local":"transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling","sections":[],"depth":2},{"title":"TFBaseModelOutputWithPoolingAndCrossAttentions","local":"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions","sections":[],"depth":2},{"title":"TFBaseModelOutputWithPast","local":"transformers.modeling_tf_outputs.TFBaseModelOutputWithPast","sections":[],"depth":2},{"title":"TFBaseModelOutputWithPastAndCrossAttentions","local":"transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions","sections":[],"depth":2},{"title":"TFSeq2SeqModelOutput","local":"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput","sections":[],"depth":2},{"title":"TFCausalLMOutput","local":"transformers.modeling_tf_outputs.TFCausalLMOutput","sections":[],"depth":2},{"title":"TFCausalLMOutputWithCrossAttentions","local":"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions","sections":[],"depth":2},{"title":"TFCausalLMOutputWithPast","local":"transformers.modeling_tf_outputs.TFCausalLMOutputWithPast","sections":[],"depth":2},{"title":"TFMaskedLMOutput","local":"transformers.modeling_tf_outputs.TFMaskedLMOutput","sections":[],"depth":2},{"title":"TFSeq2SeqLMOutput","local":"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput","sections":[],"depth":2},{"title":"TFNextSentencePredictorOutput","local":"transformers.modeling_tf_outputs.TFNextSentencePredictorOutput","sections":[],"depth":2},{"title":"TFSequenceClassifierOutput","local":"transformers.modeling_tf_outputs.TFSequenceClassifierOutput","sections":[],"depth":2},{"title":"TFSeq2SeqSequenceClassifierOutput","local":"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput","sections":[],"depth":2},{"title":"TFMultipleChoiceModelOutput","local":"transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput","sections":[],"depth":2},{"title":"TFTokenClassifierOutput","local":"transformers.modeling_tf_outputs.TFTokenClassifierOutput","sections":[],"depth":2},{"title":"TFQuestionAnsweringModelOutput","local":"transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput","sections":[],"depth":2},{"title":"TFSeq2SeqQuestionAnsweringModelOutput","local":"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput","sections":[],"depth":2},{"title":"FlaxBaseModelOutput","local":"transformers.modeling_flax_outputs.FlaxBaseModelOutput","sections":[],"depth":2},{"title":"FlaxBaseModelOutputWithPast","local":"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast","sections":[],"depth":2},{"title":"FlaxBaseModelOutputWithPooling","local":"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling","sections":[],"depth":2},{"title":"FlaxBaseModelOutputWithPastAndCrossAttentions","local":"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions","sections":[],"depth":2},{"title":"FlaxSeq2SeqModelOutput","local":"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput","sections":[],"depth":2},{"title":"FlaxCausalLMOutputWithCrossAttentions","local":"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions","sections":[],"depth":2},{"title":"FlaxMaskedLMOutput","local":"transformers.modeling_flax_outputs.FlaxMaskedLMOutput","sections":[],"depth":2},{"title":"FlaxSeq2SeqLMOutput","local":"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput","sections":[],"depth":2},{"title":"FlaxNextSentencePredictorOutput","local":"transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput","sections":[],"depth":2},{"title":"FlaxSequenceClassifierOutput","local":"transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput","sections":[],"depth":2},{"title":"FlaxSeq2SeqSequenceClassifierOutput","local":"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput","sections":[],"depth":2},{"title":"FlaxMultipleChoiceModelOutput","local":"transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput","sections":[],"depth":2},{"title":"FlaxTokenClassifierOutput","local":"transformers.modeling_flax_outputs.FlaxTokenClassifierOutput","sections":[],"depth":2},{"title":"FlaxQuestionAnsweringModelOutput","local":"transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput","sections":[],"depth":2},{"title":"FlaxSeq2SeqQuestionAnsweringModelOutput","local":"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput","sections":[],"depth":2}],"depth":1}';function Yp(Rn){return Ep(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ah extends Qp{constructor(y){super(),Rp(this,y,Yp,Zp,Hp,{})}}export{ah as component};
