import{s as Bt,o as It,n as St}from"../chunks/scheduler.9bc65507.js";import{S as Ht,i as Et,g as a,s,r as d,A as Nt,h as i,f as n,c as o,j as xt,u as p,x as r,k as kt,y as Rt,a as l,v as c,d as m,t as h,w as f}from"../chunks/index.707bf1b6.js";import{H as y,g as zt}from"../chunks/Heading.98cce615.js";import{T as Qt}from"../chunks/Tip.c2ecdbf4.js";import{C as pe}from"../chunks/CodeBlock.54a9f38d.js";function Vt(me){let u,b=`This is the very beginning of our experiments with TorchScript and we are still
exploring its capabilities with variable-input-size models. It is a focus of interest to
us and we will deepen our analysis in upcoming releases, with more code examples, a more
flexible implementation, and benchmarks comparing Python-based codes with compiled
TorchScript.`;return{c(){u=a("p"),u.textContent=b},l(M){u=i(M,"P",{"data-svelte-h":!0}),r(u)!=="svelte-3gxwq2"&&(u.textContent=b)},m(M,de){l(M,u,de)},p:St,d(M){M&&n(u)}}}function Gt(me){let u,b,M,de,T,he,w,fe,g,st='According to the <a href="https://pytorch.org/docs/stable/jit.html" rel="nofollow">TorchScript documentation</a>:',ue,U,ot="<p>TorchScript is a way to create serializable and optimizable models from PyTorch code.</p>",Me,j,at=`There are two PyTorch modules, <a href="https://pytorch.org/docs/stable/jit.html" rel="nofollow">JIT and
TRACE</a>, that allow developers to export their
models to be reused in other programs like efficiency-oriented C++ programs.`,ye,J,it=`We provide an interface that allows you to export 🤗 Transformers models to TorchScript
so they can be reused in a different environment than PyTorch-based Python programs.
Here, we explain how to export and use our models using TorchScript.`,we,$,rt="Exporting a model requires two things:",be,v,dt="<li>model instantiation with the <code>torchscript</code> flag</li> <li>a forward pass with dummy inputs</li>",Te,C,pt=`These necessities imply several things developers should be careful about as detailed
below.`,ge,W,Ue,_,ct=`The <code>torchscript</code> flag is necessary because most of the 🤗 Transformers language models
have tied weights between their <code>Embedding</code> layer and their <code>Decoding</code> layer.
TorchScript does not allow you to export models that have tied weights, so it is
necessary to untie and clone the weights beforehand.`,je,Z,mt=`Models instantiated with the <code>torchscript</code> flag have their <code>Embedding</code> layer and
<code>Decoding</code> layer separated, which means that they should not be trained down the line.
Training would desynchronize the two layers, leading to unexpected results.`,Je,x,ht=`This is not the case for models that do not have a language model head, as those do not
have tied weights. These models can be safely exported without the <code>torchscript</code> flag.`,$e,k,ve,B,ft=`The dummy inputs are used for a models forward pass. While the inputs’ values are
propagated through the layers, PyTorch keeps track of the different operations executed
on each tensor. These recorded operations are then used to create the <em>trace</em> of the
model.`,Ce,I,ut=`The trace is created relative to the inputs’ dimensions. It is therefore constrained by
the dimensions of the dummy input, and will not work for any other sequence length or
batch size. When trying with a different size, the following error is raised:`,We,S,_e,H,Mt=`We recommended you trace the model with a dummy input size at least as large as the
largest input that will be fed to the model during inference. Padding can help fill the
missing values. However, since the model is traced with a larger input size, the
dimensions of the matrix will also be large, resulting in more calculations.`,Ze,E,yt=`Be careful of the total number of operations done on each input and follow the
performance closely when exporting varying sequence-length models.`,xe,N,ke,R,wt=`This section demonstrates how to save and load models as well as how to use the trace
for inference.`,Be,z,Ie,Q,bt=`To export a <code>BertModel</code> with TorchScript, instantiate <code>BertModel</code> from the <code>BertConfig</code>
class and then save it to disk under the filename <code>traced_bert.pt</code>:`,Se,V,He,G,Ee,X,Tt=`Now you can load the previously saved <code>BertModel</code>, <code>traced_bert.pt</code>, from disk and use
it on the previously initialised <code>dummy_input</code>:`,Ne,L,Re,A,ze,P,gt="Use the traced model for inference by using its <code>__call__</code> dunder method:",Qe,F,Ve,Y,Ge,q,Ut=`AWS introduced the <a href="https://aws.amazon.com/ec2/instance-types/inf1/" rel="nofollow">Amazon EC2 Inf1</a>
instance family for low cost, high performance machine learning inference in the cloud.
The Inf1 instances are powered by the AWS Inferentia chip, a custom-built hardware
accelerator, specializing in deep learning inferencing workloads. <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/#" rel="nofollow">AWS
Neuron</a> is the SDK for
Inferentia that supports tracing and optimizing transformers models for deployment on
Inf1. The Neuron SDK provides:`,Xe,D,jt=`<li>Easy-to-use API with one line of code change to trace and optimize a TorchScript
model for inference in the cloud.</li> <li>Out of the box performance optimizations for <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/neuron-guide/benchmark/%3E" rel="nofollow">improved
cost-performance</a>.</li> <li>Support for Hugging Face transformers models built with either
<a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/src/examples/pytorch/bert_tutorial/tutorial_pretrained_bert.html" rel="nofollow">PyTorch</a>
or
<a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/src/examples/tensorflow/huggingface_bert/huggingface_bert.html" rel="nofollow">TensorFlow</a>.</li>`,Le,K,Ae,O,Jt=`Transformers models based on the <a href="https://huggingface.co/docs/transformers/main/model_doc/bert" rel="nofollow">BERT (Bidirectional Encoder Representations from
Transformers)</a>
architecture, or its variants such as
<a href="https://huggingface.co/docs/transformers/main/model_doc/distilbert" rel="nofollow">distilBERT</a> and
<a href="https://huggingface.co/docs/transformers/main/model_doc/roberta" rel="nofollow">roBERTa</a> run best on
Inf1 for non-generative tasks such as extractive question answering, sequence
classification, and token classification. However, text generation tasks can still be
adapted to run on Inf1 according to this <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/src/examples/pytorch/transformers-marianmt.html" rel="nofollow">AWS Neuron MarianMT
tutorial</a>.
More information about models that can be converted out of the box on Inferentia can be
found in the <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/neuron-guide/models/models-inferentia.html#models-inferentia" rel="nofollow">Model Architecture
Fit</a>
section of the Neuron documentation.`,Pe,ee,Fe,te,$t=`Using AWS Neuron to convert models requires a <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/neuron-guide/neuron-frameworks/pytorch-neuron/index.html#installation-guide" rel="nofollow">Neuron SDK
environment</a>
which comes preconfigured on <a href="https://docs.aws.amazon.com/dlami/latest/devguide/tutorial-inferentia-launching.html" rel="nofollow">AWS Deep Learning
AMI</a>.`,Ye,ne,qe,le,vt=`Convert a model for AWS NEURON using the same code from <a href="torchscript#using-torchscript-in-python">Using TorchScript in
Python</a> to trace a <code>BertModel</code>. Import the
<code>torch.neuron</code> framework extension to access the components of the Neuron SDK through a
Python API:`,De,se,Ke,oe,Ct="You only need to modify the following line:",Oe,ae,et,ie,Wt="This enables the Neuron SDK to trace the model and optimize it for Inf1 instances.",tt,re,_t=`To learn more about AWS Neuron SDK features, tools, example tutorials and latest
updates, please see the <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/index.html" rel="nofollow">AWS NeuronSDK
documentation</a>.`,nt,ce,lt;return T=new y({props:{title:"Export to TorchScript",local:"export-to-torchscript",headingTag:"h1"}}),w=new Qt({props:{$$slots:{default:[Vt]},$$scope:{ctx:me}}}),W=new y({props:{title:"TorchScript flag and tied weights",local:"torchscript-flag-and-tied-weights",headingTag:"h2"}}),k=new y({props:{title:"Dummy inputs and standard lengths",local:"dummy-inputs-and-standard-lengths",headingTag:"h2"}}),S=new pe({props:{code:"JTYwVGhlJTIwZXhwYW5kZWQlMjBzaXplJTIwb2YlMjB0aGUlMjB0ZW5zb3IlMjAoMyklMjBtdXN0JTIwbWF0Y2glMjB0aGUlMjBleGlzdGluZyUyMHNpemUlMjAoNyklMjBhdCUyMG5vbi1zaW5nbGV0b24lMjBkaW1lbnNpb24lMjAyJTYw",highlighted:'`The expanded <span class="hljs-built_in">size</span> of the tensor (<span class="hljs-number">3</span>) must match the existing <span class="hljs-built_in">size</span> (<span class="hljs-number">7</span>) at non-singleton <span class="hljs-keyword">dimension</span> <span class="hljs-number">2</span>`',wrap:!1}}),N=new y({props:{title:"Using TorchScript in Python",local:"using-torchscript-in-python",headingTag:"h2"}}),z=new y({props:{title:"Saving a model",local:"saving-a-model",headingTag:"h3"}}),V=new pe({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertModel, BertTokenizer, BertConfig
<span class="hljs-keyword">import</span> torch

enc = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)

<span class="hljs-comment"># Tokenizing input text</span>
text = <span class="hljs-string">&quot;[CLS] Who was Jim Henson ? [SEP] Jim Henson was a puppeteer [SEP]&quot;</span>
tokenized_text = enc.tokenize(text)

<span class="hljs-comment"># Masking one of the input tokens</span>
masked_index = <span class="hljs-number">8</span>
tokenized_text[masked_index] = <span class="hljs-string">&quot;[MASK]&quot;</span>
indexed_tokens = enc.convert_tokens_to_ids(tokenized_text)
segments_ids = [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]

<span class="hljs-comment"># Creating a dummy input</span>
tokens_tensor = torch.tensor([indexed_tokens])
segments_tensors = torch.tensor([segments_ids])
dummy_input = [tokens_tensor, segments_tensors]

<span class="hljs-comment"># Initializing the model with the torchscript flag</span>
<span class="hljs-comment"># Flag set to True even though it is not necessary as this model does not have an LM Head.</span>
config = BertConfig(
    vocab_size_or_config_json_file=<span class="hljs-number">32000</span>,
    hidden_size=<span class="hljs-number">768</span>,
    num_hidden_layers=<span class="hljs-number">12</span>,
    num_attention_heads=<span class="hljs-number">12</span>,
    intermediate_size=<span class="hljs-number">3072</span>,
    torchscript=<span class="hljs-literal">True</span>,
)

<span class="hljs-comment"># Instantiating the model</span>
model = BertModel(config)

<span class="hljs-comment"># The model needs to be in evaluation mode</span>
model.<span class="hljs-built_in">eval</span>()

<span class="hljs-comment"># If you are instantiating the model with *from_pretrained* you can also easily set the TorchScript flag</span>
model = BertModel.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, torchscript=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Creating the trace</span>
traced_model = torch.jit.trace(model, [tokens_tensor, segments_tensors])
torch.jit.save(traced_model, <span class="hljs-string">&quot;traced_bert.pt&quot;</span>)`,wrap:!1}}),G=new y({props:{title:"Loading a model",local:"loading-a-model",headingTag:"h3"}}),L=new pe({props:{code:"bG9hZGVkX21vZGVsJTIwJTNEJTIwdG9yY2guaml0LmxvYWQoJTIydHJhY2VkX2JlcnQucHQlMjIpJTBBbG9hZGVkX21vZGVsLmV2YWwoKSUwQSUwQWFsbF9lbmNvZGVyX2xheWVycyUyQyUyMHBvb2xlZF9vdXRwdXQlMjAlM0QlMjBsb2FkZWRfbW9kZWwoKmR1bW15X2lucHV0KQ==",highlighted:`loaded_model = torch.jit.load(<span class="hljs-string">&quot;traced_bert.pt&quot;</span>)
loaded_model.<span class="hljs-built_in">eval</span>()

all_encoder_layers, pooled_output = loaded_model(*dummy_input)`,wrap:!1}}),A=new y({props:{title:"Using a traced model for inference",local:"using-a-traced-model-for-inference",headingTag:"h3"}}),F=new pe({props:{code:"dHJhY2VkX21vZGVsKHRva2Vuc190ZW5zb3IlMkMlMjBzZWdtZW50c190ZW5zb3JzKQ==",highlighted:"traced_model(tokens_tensor, segments_tensors)",wrap:!1}}),Y=new y({props:{title:"Deploy Hugging Face TorchScript models to AWS with the Neuron SDK",local:"deploy-hugging-face-torchscript-models-to-aws-with-the-neuron-sdk",headingTag:"h2"}}),K=new y({props:{title:"Implications",local:"implications",headingTag:"h3"}}),ee=new y({props:{title:"Dependencies",local:"dependencies",headingTag:"h3"}}),ne=new y({props:{title:"Converting a model for AWS Neuron",local:"converting-a-model-for-aws-neuron",headingTag:"h3"}}),se=new pe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRNb2RlbCUyQyUyMEJlcnRUb2tlbml6ZXIlMkMlMjBCZXJ0Q29uZmlnJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5uZXVyb24=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertModel, BertTokenizer, BertConfig
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.neuron`,wrap:!1}}),ae=new pe({props:{code:"LSUyMHRvcmNoLmppdC50cmFjZShtb2RlbCUyQyUyMCU1QnRva2Vuc190ZW5zb3IlMkMlMjBzZWdtZW50c190ZW5zb3JzJTVEKSUwQSUyQiUyMHRvcmNoLm5ldXJvbi50cmFjZShtb2RlbCUyQyUyMCU1QnRva2VuX3RlbnNvciUyQyUyMHNlZ21lbnRzX3RlbnNvcnMlNUQp",highlighted:`<span class="hljs-deletion">- torch.jit.trace(model, [tokens_tensor, segments_tensors])</span>
<span class="hljs-addition">+ torch.neuron.trace(model, [token_tensor, segments_tensors])</span>`,wrap:!1}}),{c(){u=a("meta"),b=s(),M=a("p"),de=s(),d(T.$$.fragment),he=s(),d(w.$$.fragment),fe=s(),g=a("p"),g.innerHTML=st,ue=s(),U=a("blockquote"),U.innerHTML=ot,Me=s(),j=a("p"),j.innerHTML=at,ye=s(),J=a("p"),J.textContent=it,we=s(),$=a("p"),$.textContent=rt,be=s(),v=a("ul"),v.innerHTML=dt,Te=s(),C=a("p"),C.textContent=pt,ge=s(),d(W.$$.fragment),Ue=s(),_=a("p"),_.innerHTML=ct,je=s(),Z=a("p"),Z.innerHTML=mt,Je=s(),x=a("p"),x.innerHTML=ht,$e=s(),d(k.$$.fragment),ve=s(),B=a("p"),B.innerHTML=ft,Ce=s(),I=a("p"),I.textContent=ut,We=s(),d(S.$$.fragment),_e=s(),H=a("p"),H.textContent=Mt,Ze=s(),E=a("p"),E.textContent=yt,xe=s(),d(N.$$.fragment),ke=s(),R=a("p"),R.textContent=wt,Be=s(),d(z.$$.fragment),Ie=s(),Q=a("p"),Q.innerHTML=bt,Se=s(),d(V.$$.fragment),He=s(),d(G.$$.fragment),Ee=s(),X=a("p"),X.innerHTML=Tt,Ne=s(),d(L.$$.fragment),Re=s(),d(A.$$.fragment),ze=s(),P=a("p"),P.innerHTML=gt,Qe=s(),d(F.$$.fragment),Ve=s(),d(Y.$$.fragment),Ge=s(),q=a("p"),q.innerHTML=Ut,Xe=s(),D=a("ol"),D.innerHTML=jt,Le=s(),d(K.$$.fragment),Ae=s(),O=a("p"),O.innerHTML=Jt,Pe=s(),d(ee.$$.fragment),Fe=s(),te=a("p"),te.innerHTML=$t,Ye=s(),d(ne.$$.fragment),qe=s(),le=a("p"),le.innerHTML=vt,De=s(),d(se.$$.fragment),Ke=s(),oe=a("p"),oe.textContent=Ct,Oe=s(),d(ae.$$.fragment),et=s(),ie=a("p"),ie.textContent=Wt,tt=s(),re=a("p"),re.innerHTML=_t,nt=s(),ce=a("p"),this.h()},l(e){const t=Nt("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(n),b=o(e),M=i(e,"P",{}),xt(M).forEach(n),de=o(e),p(T.$$.fragment,e),he=o(e),p(w.$$.fragment,e),fe=o(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-16vv52d"&&(g.innerHTML=st),ue=o(e),U=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(U)!=="svelte-143rw8d"&&(U.innerHTML=ot),Me=o(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1ntf3wg"&&(j.innerHTML=at),ye=o(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-3e4o7k"&&(J.textContent=it),we=o(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1mmf9kh"&&($.textContent=rt),be=o(e),v=i(e,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-1yusujd"&&(v.innerHTML=dt),Te=o(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-9awfof"&&(C.textContent=pt),ge=o(e),p(W.$$.fragment,e),Ue=o(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-qq8y9a"&&(_.innerHTML=ct),je=o(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-rijh7h"&&(Z.innerHTML=mt),Je=o(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1cg0vrq"&&(x.innerHTML=ht),$e=o(e),p(k.$$.fragment,e),ve=o(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1an8gt1"&&(B.innerHTML=ft),Ce=o(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1pagcqs"&&(I.textContent=ut),We=o(e),p(S.$$.fragment,e),_e=o(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-e7h40q"&&(H.textContent=Mt),Ze=o(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-k3vdvp"&&(E.textContent=yt),xe=o(e),p(N.$$.fragment,e),ke=o(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-3ddxtn"&&(R.textContent=wt),Be=o(e),p(z.$$.fragment,e),Ie=o(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1y405n0"&&(Q.innerHTML=bt),Se=o(e),p(V.$$.fragment,e),He=o(e),p(G.$$.fragment,e),Ee=o(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-uqg1ob"&&(X.innerHTML=Tt),Ne=o(e),p(L.$$.fragment,e),Re=o(e),p(A.$$.fragment,e),ze=o(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1prvnq1"&&(P.innerHTML=gt),Qe=o(e),p(F.$$.fragment,e),Ve=o(e),p(Y.$$.fragment,e),Ge=o(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1kac3or"&&(q.innerHTML=Ut),Xe=o(e),D=i(e,"OL",{"data-svelte-h":!0}),r(D)!=="svelte-1h435mi"&&(D.innerHTML=jt),Le=o(e),p(K.$$.fragment,e),Ae=o(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1kv7oct"&&(O.innerHTML=Jt),Pe=o(e),p(ee.$$.fragment,e),Fe=o(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-f2qubg"&&(te.innerHTML=$t),Ye=o(e),p(ne.$$.fragment,e),qe=o(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1flzoza"&&(le.innerHTML=vt),De=o(e),p(se.$$.fragment,e),Ke=o(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-uv51ic"&&(oe.textContent=Ct),Oe=o(e),p(ae.$$.fragment,e),et=o(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1dylit2"&&(ie.textContent=Wt),tt=o(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-u8nslf"&&(re.innerHTML=_t),nt=o(e),ce=i(e,"P",{}),xt(ce).forEach(n),this.h()},h(){kt(u,"name","hf:doc:metadata"),kt(u,"content",Xt)},m(e,t){Rt(document.head,u),l(e,b,t),l(e,M,t),l(e,de,t),c(T,e,t),l(e,he,t),c(w,e,t),l(e,fe,t),l(e,g,t),l(e,ue,t),l(e,U,t),l(e,Me,t),l(e,j,t),l(e,ye,t),l(e,J,t),l(e,we,t),l(e,$,t),l(e,be,t),l(e,v,t),l(e,Te,t),l(e,C,t),l(e,ge,t),c(W,e,t),l(e,Ue,t),l(e,_,t),l(e,je,t),l(e,Z,t),l(e,Je,t),l(e,x,t),l(e,$e,t),c(k,e,t),l(e,ve,t),l(e,B,t),l(e,Ce,t),l(e,I,t),l(e,We,t),c(S,e,t),l(e,_e,t),l(e,H,t),l(e,Ze,t),l(e,E,t),l(e,xe,t),c(N,e,t),l(e,ke,t),l(e,R,t),l(e,Be,t),c(z,e,t),l(e,Ie,t),l(e,Q,t),l(e,Se,t),c(V,e,t),l(e,He,t),c(G,e,t),l(e,Ee,t),l(e,X,t),l(e,Ne,t),c(L,e,t),l(e,Re,t),c(A,e,t),l(e,ze,t),l(e,P,t),l(e,Qe,t),c(F,e,t),l(e,Ve,t),c(Y,e,t),l(e,Ge,t),l(e,q,t),l(e,Xe,t),l(e,D,t),l(e,Le,t),c(K,e,t),l(e,Ae,t),l(e,O,t),l(e,Pe,t),c(ee,e,t),l(e,Fe,t),l(e,te,t),l(e,Ye,t),c(ne,e,t),l(e,qe,t),l(e,le,t),l(e,De,t),c(se,e,t),l(e,Ke,t),l(e,oe,t),l(e,Oe,t),c(ae,e,t),l(e,et,t),l(e,ie,t),l(e,tt,t),l(e,re,t),l(e,nt,t),l(e,ce,t),lt=!0},p(e,[t]){const Zt={};t&2&&(Zt.$$scope={dirty:t,ctx:e}),w.$set(Zt)},i(e){lt||(m(T.$$.fragment,e),m(w.$$.fragment,e),m(W.$$.fragment,e),m(k.$$.fragment,e),m(S.$$.fragment,e),m(N.$$.fragment,e),m(z.$$.fragment,e),m(V.$$.fragment,e),m(G.$$.fragment,e),m(L.$$.fragment,e),m(A.$$.fragment,e),m(F.$$.fragment,e),m(Y.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(ne.$$.fragment,e),m(se.$$.fragment,e),m(ae.$$.fragment,e),lt=!0)},o(e){h(T.$$.fragment,e),h(w.$$.fragment,e),h(W.$$.fragment,e),h(k.$$.fragment,e),h(S.$$.fragment,e),h(N.$$.fragment,e),h(z.$$.fragment,e),h(V.$$.fragment,e),h(G.$$.fragment,e),h(L.$$.fragment,e),h(A.$$.fragment,e),h(F.$$.fragment,e),h(Y.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(ne.$$.fragment,e),h(se.$$.fragment,e),h(ae.$$.fragment,e),lt=!1},d(e){e&&(n(b),n(M),n(de),n(he),n(fe),n(g),n(ue),n(U),n(Me),n(j),n(ye),n(J),n(we),n($),n(be),n(v),n(Te),n(C),n(ge),n(Ue),n(_),n(je),n(Z),n(Je),n(x),n($e),n(ve),n(B),n(Ce),n(I),n(We),n(_e),n(H),n(Ze),n(E),n(xe),n(ke),n(R),n(Be),n(Ie),n(Q),n(Se),n(He),n(Ee),n(X),n(Ne),n(Re),n(ze),n(P),n(Qe),n(Ve),n(Ge),n(q),n(Xe),n(D),n(Le),n(Ae),n(O),n(Pe),n(Fe),n(te),n(Ye),n(qe),n(le),n(De),n(Ke),n(oe),n(Oe),n(et),n(ie),n(tt),n(re),n(nt),n(ce)),n(u),f(T,e),f(w,e),f(W,e),f(k,e),f(S,e),f(N,e),f(z,e),f(V,e),f(G,e),f(L,e),f(A,e),f(F,e),f(Y,e),f(K,e),f(ee,e),f(ne,e),f(se,e),f(ae,e)}}}const Xt='{"title":"Export to TorchScript","local":"export-to-torchscript","sections":[{"title":"TorchScript flag and tied weights","local":"torchscript-flag-and-tied-weights","sections":[],"depth":2},{"title":"Dummy inputs and standard lengths","local":"dummy-inputs-and-standard-lengths","sections":[],"depth":2},{"title":"Using TorchScript in Python","local":"using-torchscript-in-python","sections":[{"title":"Saving a model","local":"saving-a-model","sections":[],"depth":3},{"title":"Loading a model","local":"loading-a-model","sections":[],"depth":3},{"title":"Using a traced model for inference","local":"using-a-traced-model-for-inference","sections":[],"depth":3}],"depth":2},{"title":"Deploy Hugging Face TorchScript models to AWS with the Neuron SDK","local":"deploy-hugging-face-torchscript-models-to-aws-with-the-neuron-sdk","sections":[{"title":"Implications","local":"implications","sections":[],"depth":3},{"title":"Dependencies","local":"dependencies","sections":[],"depth":3},{"title":"Converting a model for AWS Neuron","local":"converting-a-model-for-aws-neuron","sections":[],"depth":3}],"depth":2}],"depth":1}';function Lt(me){return It(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=zt}),[]}class Dt extends Ht{constructor(u){super(),Et(this,u,Lt,Gt,Bt,{})}}export{Dt as component};
