import{s as Dt,n as Kt,o as Ot}from"../chunks/scheduler.36a0863c.js";import{S as el,i as tl,g as s,s as a,r as p,A as ll,h as o,f as l,c as i,j as Pt,u as r,x as m,k as St,y as nl,a as n,v as u,d as g,t as d,w as c}from"../chunks/index.9c13489a.js";import{C as M}from"../chunks/CodeBlock.05d8ec32.js";import{D as al}from"../chunks/DocNotebookDropdown.653c9eec.js";import{H as f}from"../chunks/Heading.7a254a62.js";function il(ft){let b,fe,Me,Je,J,Te,T,he,h,Jt='Ci sono diversi modelli multilingue in 🤗 Transformers, e il loro utilizzo per l’inferenza differisce da quello dei modelli monolingua. Non <em>tutti</em> gli utilizzi dei modelli multilingue sono però diversi. Alcuni modelli, come <a href="https://huggingface.co/google-bert/bert-base-multilingual-uncased" rel="nofollow">google-bert/bert-base-multilingual-uncased</a>, possono essere usati come un modello monolingua. Questa guida ti mostrerà come utilizzare modelli multilingue che utilizzano un modo diverso per fare l’inferenza.',ye,y,Ue,U,Tt="XLM ha dieci diversi checkpoint, di cui solo uno è monolingua. I nove checkpoint rimanenti possono essere suddivisi in due categorie: i checkpoint che utilizzano i language embeddings e quelli che non li utilizzano.",ke,k,$e,$,ht="I seguenti modelli XLM utilizzano gli embeddings linguistici per specificare la lingua utilizzata per l’inferenza:",je,j,yt="<li><code>FacebookAI/xlm-mlm-ende-1024</code> (Modellazione mascherata del linguaggio (Masked language modeling, in inglese), Inglese-Tedesco)</li> <li><code>FacebookAI/xlm-mlm-enfr-1024</code> (Modellazione mascherata del linguaggio, Inglese-Francese)</li> <li><code>FacebookAI/xlm-mlm-enro-1024</code> (Modellazione mascherata del linguaggio, Inglese-Rumeno)</li> <li><code>FacebookAI/xlm-mlm-xnli15-1024</code> (Modellazione mascherata del linguaggio, lingue XNLI)</li> <li><code>FacebookAI/xlm-mlm-tlm-xnli15-1024</code> (Modellazione mascherata del linguaggio + traduzione, lingue XNLI)</li> <li><code>FacebookAI/xlm-clm-enfr-1024</code> (Modellazione causale del linguaggio, Inglese-Francese)</li> <li><code>FacebookAI/xlm-clm-ende-1024</code> (Modellazione causale del linguaggio, Inglese-Tedesco)</li>",we,w,Ut="Gli embeddings linguistici sono rappresentati come un tensore delle stesse dimensioni dell’ <code>input_ids</code> passato al modello. I valori in questi tensori dipendono dal linguaggio usato e sono identificati dagli attributi <code>lang2id</code> e <code>id2lang</code> del tokenizer.",ve,v,kt="In questo esempio, carica il checkpoint <code>FacebookAI/xlm-clm-enfr-1024</code> (Modellazione causale del linguaggio, Inglese-Francese):",ze,z,xe,x,$t="L’attributo <code>lang2id</code> del tokenizer mostra il linguaggio del modello e il suo ids:",Ie,I,Ze,Z,jt="Poi, crea un esempio di input:",_e,_,Ce,C,wt="Imposta l’id del linguaggio a <code>&quot;en&quot;</code> e usalo per definire il language embedding. Il language embedding è un tensore riempito con <code>0</code> perché questo è il language id per l’inglese. Questo tensore dovrebbe avere la stessa dimensione di <code>input_ids</code>.",Xe,X,Ge,G,vt="Adesso puoi inserire <code>input_ids</code> e language embedding nel modello:",We,W,Ve,V,zt='Lo script <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-generation/run_generation.py" rel="nofollow">run_generation.py</a> può generare testo tramite i language embeddings usando i checkpoints <code>xlm-clm</code>.',Le,L,Re,R,xt="I seguenti modelli XLM non richiedono l’utilizzo dei language embeddings per fare inferenza:",Be,B,It="<li><code>FacebookAI/xlm-mlm-17-1280</code> (Modellazione mascherata del linguaggio, 17 lingue)</li> <li><code>FacebookAI/xlm-mlm-100-1280</code> (Modellazione mascherata del linguaggio, 100 lingue)</li>",Fe,F,Zt="Questi modelli sono utilizzati per rappresentazioni generiche di frasi, a differenza dei precedenti checkpoints XML.",Ee,E,He,H,_t="Il seguente modello BERT può essere usato per compiti multilingue:",qe,q,Ct="<li><code>google-bert/bert-base-multilingual-uncased</code> (Modellazione mascherata del linguaggio + Previsione della prossima frase, 102 lingue)</li> <li><code>google-bert/bert-base-multilingual-cased</code> (Modellazione mascherata del linguaggio + Previsione della prossima frase, 104 lingue)</li>",Qe,Q,Xt="Questi modelli non richiedono language embeddings per fare inferenza. Riescono ad identificare il linguaggio dal contesto e inferire di conseguenza.",Ye,Y,Ne,N,Gt="Il seguente modello XLM-RoBERTa può essere usato per compiti multilingue:",Ae,A,Wt="<li><code>FacebookAI/xlm-roberta-base</code> (Modellazione mascherata del linguaggio, 100 lingue)</li> <li><code>FacebookAI/xlm-roberta-large</code> (Modellazione mascherata del linguaggio, 100 lingue)</li>",Pe,P,Vt="XLM-RoBERTa è stato addestrato su 2.5TB di dati CommonCrawl appena creati e puliti in 100 lingue. Offre notevoli vantaggi rispetto ai modelli multilingue rilasciati in precedenza, come mBERT o XLM, in compiti come la classificazione, l’etichettatura delle sequenze e la risposta alle domande.",Se,S,De,D,Lt="Il seguente modello M2M100 può essere usato per compiti multilingue:",Ke,K,Rt="<li><code>facebook/m2m100_418M</code> (Traduzione)</li> <li><code>facebook/m2m100_1.2B</code> (Traduzione)</li>",Oe,O,Bt="In questo esempio, carica il checkpoint <code>facebook/m2m100_418M</code>  per tradurre dal cinese all’inglese. Puoi impostare la lingua di partenza nel tokenizer:",et,ee,tt,te,Ft="Applica il tokenizer al testo:",lt,le,nt,ne,Et="M2M100 forza l’id della lingua obiettivo come primo token generato per tradurre nella lingua obiettivo. Imposta il parametro <code>forced_bos_token_id</code> a <code>en</code> nel metodo <code>generate</code> per tradurre in inglese:",at,ae,it,ie,st,se,Ht="Il seguente modello MBart può essere usato per compiti multilingue:",ot,oe,qt="<li><code>facebook/mbart-large-50-one-to-many-mmt</code> (Traduzione automatica multilingue uno-a-molti, 50 lingue)</li> <li><code>facebook/mbart-large-50-many-to-many-mmt</code> (Traduzione automatica multilingue molti-a-molti, 50 lingue)</li> <li><code>facebook/mbart-large-50-many-to-one-mmt</code> (Traduzione automatica multilingue molti-a-uno, 50 lingue)</li> <li><code>facebook/mbart-large-50</code> (Traduzione multilingue, 50 lingue)</li> <li><code>facebook/mbart-large-cc25</code></li>",mt,me,Qt="In questo esempio, carica il checkpoint <code>facebook/mbart-large-50-many-to-many-mmt</code> per tradurre dal finlandese all’inglese. Puoi impostare la lingua di partenza nel tokenizer:",pt,pe,rt,re,Yt="Applica il tokenizer sul testo:",ut,ue,gt,ge,Nt="MBart forza l’id della lingua obiettivo come primo token generato per tradurre nella lingua obiettivo. Imposta il parametro <code>forced_bos_token_id</code> a <code>en</code> nel metodo <code>generate</code> per tradurre in inglese:",dt,de,ct,ce,At="Se stai usando il checkpoint <code>facebook/mbart-large-50-many-to-one-mmt</code>, non hai bisogno di forzare l’id della lingua obiettivo come primo token generato altrimenti l’uso è lo stesso.",Mt,be,bt;return J=new f({props:{title:"Modelli multilingue per l’inferenza",local:"modelli-multilingue-per-linferenza",headingTag:"h1"}}),T=new al({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/it/multilingual.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/it/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/it/tensorflow/multilingual.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/it/multilingual.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/it/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/it/tensorflow/multilingual.ipynb"}]}}),y=new f({props:{title:"XLM",local:"xlm",headingTag:"h2"}}),k=new f({props:{title:"XLM con language embeddings",local:"xlm-con-language-embeddings",headingTag:"h3"}}),z=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwWExNVG9rZW5pemVyJTJDJTIwWExNV2l0aExNSGVhZE1vZGVsJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwWExNVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJGYWNlYm9va0FJJTJGeGxtLWNsbS1lbmZyLTEwMjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBYTE1XaXRoTE1IZWFkTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMkZhY2Vib29rQUklMkZ4bG0tY2xtLWVuZnItMTAyNCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLMTokenizer, XLMWithLMHeadModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = XLMTokenizer.from_pretrained(<span class="hljs-string">&quot;FacebookAI/xlm-clm-enfr-1024&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = XLMWithLMHeadModel.from_pretrained(<span class="hljs-string">&quot;FacebookAI/xlm-clm-enfr-1024&quot;</span>)`,wrap:!1}}),I=new M({props:{code:"cHJpbnQodG9rZW5pemVyLmxhbmcyaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.lang2id)
{<span class="hljs-string">&#x27;en&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;fr&#x27;</span>: <span class="hljs-number">1</span>}`,wrap:!1}}),_=new M({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QnRva2VuaXplci5lbmNvZGUoJTIyV2lraXBlZGlhJTIwd2FzJTIwdXNlZCUyMHRvJTIyKSU1RCklMjAlMjAlMjMlMjBiYXRjaCUyMHNpemUlMjBvZiUyMDE=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor([tokenizer.encode(<span class="hljs-string">&quot;Wikipedia was used to&quot;</span>)])  <span class="hljs-comment"># batch size of 1</span>',wrap:!1}}),X=new M({props:{code:"bGFuZ3VhZ2VfaWQlMjAlM0QlMjB0b2tlbml6ZXIubGFuZzJpZCU1QiUyMmVuJTIyJTVEJTIwJTIwJTIzJTIwMCUwQWxhbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1Qmxhbmd1YWdlX2lkJTVEJTIwKiUyMGlucHV0X2lkcy5zaGFwZSU1QjElNUQpJTIwJTIwJTIzJTIwdG9yY2gudGVuc29yKCU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMC4uLiUyQyUyMDAlNUQpJTBBJTBBJTIzJTIwV2UlMjByZXNoYXBlJTIwaXQlMjB0byUyMGJlJTIwb2YlMjBzaXplJTIwKGJhdGNoX3NpemUlMkMlMjBzZXF1ZW5jZV9sZW5ndGgpJTBBbGFuZ3MlMjAlM0QlMjBsYW5ncy52aWV3KDElMkMlMjAtMSklMjAlMjAlMjMlMjBpcyUyMG5vdyUyMG9mJTIwc2hhcGUlMjAlNUIxJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTVEJTIwKHdlJTIwaGF2ZSUyMGElMjBiYXRjaCUyMHNpemUlMjBvZiUyMDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>language_id = tokenizer.lang2id[<span class="hljs-string">&quot;en&quot;</span>]  <span class="hljs-comment"># 0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = torch.tensor([language_id] * input_ids.shape[<span class="hljs-number">1</span>])  <span class="hljs-comment"># torch.tensor([0, 0, 0, ..., 0])</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We reshape it to be of size (batch_size, sequence_length)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = langs.view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>)  <span class="hljs-comment"># is now of shape [1, sequence_length] (we have a batch size of 1)</span>`,wrap:!1}}),W=new M({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUyQyUyMGxhbmdzJTNEbGFuZ3Mp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids, langs=langs)',wrap:!1}}),L=new f({props:{title:"XLM senza language embeddings",local:"xlm-senza-language-embeddings",headingTag:"h3"}}),E=new f({props:{title:"BERT",local:"bert",headingTag:"h2"}}),Y=new f({props:{title:"XLM-RoBERTa",local:"xlm-roberta",headingTag:"h2"}}),S=new f({props:{title:"M2M100",local:"m2m100",headingTag:"h2"}}),ee=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME0yTTEwMEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyME0yTTEwMFRva2VuaXplciUwQSUwQWVuX3RleHQlMjAlM0QlMjAlMjJEbyUyMG5vdCUyMG1lZGRsZSUyMGluJTIwdGhlJTIwYWZmYWlycyUyMG9mJTIwd2l6YXJkcyUyQyUyMGZvciUyMHRoZXklMjBhcmUlMjBzdWJ0bGUlMjBhbmQlMjBxdWljayUyMHRvJTIwYW5nZXIuJTIyJTBBY2hpbmVzZV90ZXh0JTIwJTNEJTIwJTIyJUU0JUI4JThEJUU4JUE2JTgxJUU2JThGJTkyJUU2JTg5JThCJUU1JUI3JUFCJUU1JUI4JUFCJUU3JTlBJTg0JUU0JUJBJThCJUU1JThCJTk5JTJDJTIwJUU1JTlCJUEwJUU3JTgyJUJBJUU0JUJCJTk2JUU1JTgwJTkxJUU2JTk4JUFGJUU1JUJFJUFFJUU1JUE2JTk5JUU3JTlBJTg0JTJDJTIwJUU1JUJFJTg4JUU1JUJGJUFCJUU1JUIwJUIxJUU2JTlDJTgzJUU3JTk5JUJDJUU2JTgwJTkyLiUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyME0yTTEwMFRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtMm0xMDBfNDE4TSUyMiUyQyUyMHNyY19sYW5nJTNEJTIyemglMjIpJTBBbW9kZWwlMjAlM0QlMjBNMk0xMDBGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbTJtMTAwXzQxOE0lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> M2M100ForConditionalGeneration, M2M100Tokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chinese_text = <span class="hljs-string">&quot;不要插手巫師的事務, 因為他們是微妙的, 很快就會發怒.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = M2M100Tokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>, src_lang=<span class="hljs-string">&quot;zh&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = M2M100ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>)`,wrap:!1}}),le=new M({props:{code:"ZW5jb2RlZF96aCUyMCUzRCUyMHRva2VuaXplcihjaGluZXNlX3RleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_zh = tokenizer(chinese_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ae=new M({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF96aCUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIuZ2V0X2xhbmdfaWQoJTIyZW4lMjIpKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX3Rva2VucyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_zh, forced_bos_token_id=tokenizer.get_lang_id(<span class="hljs-string">&quot;en&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;Do not interfere with the matters of the witches, because they are delicate and will soon be angry.&#x27;</span>`,wrap:!1}}),ie=new f({props:{title:"MBart",local:"mbart",headingTag:"h2"}}),pe=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFlbl90ZXh0JTIwJTNEJTIwJTIyRG8lMjBub3QlMjBtZWRkbGUlMjBpbiUyMHRoZSUyMGFmZmFpcnMlMjBvZiUyMHdpemFyZHMlMkMlMjBmb3IlMjB0aGV5JTIwYXJlJTIwc3VidGxlJTIwYW5kJTIwcXVpY2slMjB0byUyMGFuZ2VyLiUyMiUwQWZpX3RleHQlMjAlM0QlMjAlMjIlQzMlODRsJUMzJUE0JTIwc2VrYWFubnUlMjB2ZWxob2plbiUyMGFzaW9paGluJTJDJTIwc2lsbCVDMyVBNCUyMG5lJTIwb3ZhdCUyMGhpZW5vdmFyYWlzaWElMjBqYSUyMG5vcGVhc3RpJTIwdmloYWlzaWEuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJmaV9GSSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fi_text = <span class="hljs-string">&quot;Älä sekaannu velhojen asioihin, sillä ne ovat hienovaraisia ja nopeasti vihaisia.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;fi_FI&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>)`,wrap:!1}}),ue=new M({props:{code:"ZW5jb2RlZF9lbiUyMCUzRCUyMHRva2VuaXplcihlbl90ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_en = tokenizer(en_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),de=new M({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF9lbiUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIubGFuZ19jb2RlX3RvX2lkKCUyMmVuX1hYJTIyKSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF90b2tlbnMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_en, forced_bos_token_id=tokenizer.lang_code_to_id(<span class="hljs-string">&quot;en_XX&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;Don&#x27;t interfere with the wizard&#x27;s affairs, because they are subtle, will soon get angry.&quot;</span>`,wrap:!1}}),{c(){b=s("meta"),fe=a(),Me=s("p"),Je=a(),p(J.$$.fragment),Te=a(),p(T.$$.fragment),he=a(),h=s("p"),h.innerHTML=Jt,ye=a(),p(y.$$.fragment),Ue=a(),U=s("p"),U.textContent=Tt,ke=a(),p(k.$$.fragment),$e=a(),$=s("p"),$.textContent=ht,je=a(),j=s("ul"),j.innerHTML=yt,we=a(),w=s("p"),w.innerHTML=Ut,ve=a(),v=s("p"),v.innerHTML=kt,ze=a(),p(z.$$.fragment),xe=a(),x=s("p"),x.innerHTML=$t,Ie=a(),p(I.$$.fragment),Ze=a(),Z=s("p"),Z.textContent=jt,_e=a(),p(_.$$.fragment),Ce=a(),C=s("p"),C.innerHTML=wt,Xe=a(),p(X.$$.fragment),Ge=a(),G=s("p"),G.innerHTML=vt,We=a(),p(W.$$.fragment),Ve=a(),V=s("p"),V.innerHTML=zt,Le=a(),p(L.$$.fragment),Re=a(),R=s("p"),R.textContent=xt,Be=a(),B=s("ul"),B.innerHTML=It,Fe=a(),F=s("p"),F.textContent=Zt,Ee=a(),p(E.$$.fragment),He=a(),H=s("p"),H.textContent=_t,qe=a(),q=s("ul"),q.innerHTML=Ct,Qe=a(),Q=s("p"),Q.textContent=Xt,Ye=a(),p(Y.$$.fragment),Ne=a(),N=s("p"),N.textContent=Gt,Ae=a(),A=s("ul"),A.innerHTML=Wt,Pe=a(),P=s("p"),P.textContent=Vt,Se=a(),p(S.$$.fragment),De=a(),D=s("p"),D.textContent=Lt,Ke=a(),K=s("ul"),K.innerHTML=Rt,Oe=a(),O=s("p"),O.innerHTML=Bt,et=a(),p(ee.$$.fragment),tt=a(),te=s("p"),te.textContent=Ft,lt=a(),p(le.$$.fragment),nt=a(),ne=s("p"),ne.innerHTML=Et,at=a(),p(ae.$$.fragment),it=a(),p(ie.$$.fragment),st=a(),se=s("p"),se.textContent=Ht,ot=a(),oe=s("ul"),oe.innerHTML=qt,mt=a(),me=s("p"),me.innerHTML=Qt,pt=a(),p(pe.$$.fragment),rt=a(),re=s("p"),re.textContent=Yt,ut=a(),p(ue.$$.fragment),gt=a(),ge=s("p"),ge.innerHTML=Nt,dt=a(),p(de.$$.fragment),ct=a(),ce=s("p"),ce.innerHTML=At,Mt=a(),be=s("p"),this.h()},l(e){const t=ll("svelte-u9bgzb",document.head);b=o(t,"META",{name:!0,content:!0}),t.forEach(l),fe=i(e),Me=o(e,"P",{}),Pt(Me).forEach(l),Je=i(e),r(J.$$.fragment,e),Te=i(e),r(T.$$.fragment,e),he=i(e),h=o(e,"P",{"data-svelte-h":!0}),m(h)!=="svelte-1y2uj2f"&&(h.innerHTML=Jt),ye=i(e),r(y.$$.fragment,e),Ue=i(e),U=o(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-b0zdcx"&&(U.textContent=Tt),ke=i(e),r(k.$$.fragment,e),$e=i(e),$=o(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-6flhpc"&&($.textContent=ht),je=i(e),j=o(e,"UL",{"data-svelte-h":!0}),m(j)!=="svelte-hwtd9h"&&(j.innerHTML=yt),we=i(e),w=o(e,"P",{"data-svelte-h":!0}),m(w)!=="svelte-1o9s8ae"&&(w.innerHTML=Ut),ve=i(e),v=o(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-tnbb9o"&&(v.innerHTML=kt),ze=i(e),r(z.$$.fragment,e),xe=i(e),x=o(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1lvsgdy"&&(x.innerHTML=$t),Ie=i(e),r(I.$$.fragment,e),Ze=i(e),Z=o(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1gs48v1"&&(Z.textContent=jt),_e=i(e),r(_.$$.fragment,e),Ce=i(e),C=o(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1lqmqx6"&&(C.innerHTML=wt),Xe=i(e),r(X.$$.fragment,e),Ge=i(e),G=o(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1257czm"&&(G.innerHTML=vt),We=i(e),r(W.$$.fragment,e),Ve=i(e),V=o(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-docsh6"&&(V.innerHTML=zt),Le=i(e),r(L.$$.fragment,e),Re=i(e),R=o(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1fsmnuh"&&(R.textContent=xt),Be=i(e),B=o(e,"UL",{"data-svelte-h":!0}),m(B)!=="svelte-1r1fxak"&&(B.innerHTML=It),Fe=i(e),F=o(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-18famm0"&&(F.textContent=Zt),Ee=i(e),r(E.$$.fragment,e),He=i(e),H=o(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-16x26sb"&&(H.textContent=_t),qe=i(e),q=o(e,"UL",{"data-svelte-h":!0}),m(q)!=="svelte-1ufkrdp"&&(q.innerHTML=Ct),Qe=i(e),Q=o(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-nozyay"&&(Q.textContent=Xt),Ye=i(e),r(Y.$$.fragment,e),Ne=i(e),N=o(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-6sllth"&&(N.textContent=Gt),Ae=i(e),A=o(e,"UL",{"data-svelte-h":!0}),m(A)!=="svelte-1h2reme"&&(A.innerHTML=Wt),Pe=i(e),P=o(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1t17k0a"&&(P.textContent=Vt),Se=i(e),r(S.$$.fragment,e),De=i(e),D=o(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-sftpup"&&(D.textContent=Lt),Ke=i(e),K=o(e,"UL",{"data-svelte-h":!0}),m(K)!=="svelte-13d4mst"&&(K.innerHTML=Rt),Oe=i(e),O=o(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-13sr045"&&(O.innerHTML=Bt),et=i(e),r(ee.$$.fragment,e),tt=i(e),te=o(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-1ysq4ea"&&(te.textContent=Ft),lt=i(e),r(le.$$.fragment,e),nt=i(e),ne=o(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-1hcjl5u"&&(ne.innerHTML=Et),at=i(e),r(ae.$$.fragment,e),it=i(e),r(ie.$$.fragment,e),st=i(e),se=o(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-hqe28c"&&(se.textContent=Ht),ot=i(e),oe=o(e,"UL",{"data-svelte-h":!0}),m(oe)!=="svelte-15l5ps7"&&(oe.innerHTML=qt),mt=i(e),me=o(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-niv51s"&&(me.innerHTML=Qt),pt=i(e),r(pe.$$.fragment,e),rt=i(e),re=o(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-5lihjd"&&(re.textContent=Yt),ut=i(e),r(ue.$$.fragment,e),gt=i(e),ge=o(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-21vlhj"&&(ge.innerHTML=Nt),dt=i(e),r(de.$$.fragment,e),ct=i(e),ce=o(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-m0bu83"&&(ce.innerHTML=At),Mt=i(e),be=o(e,"P",{}),Pt(be).forEach(l),this.h()},h(){St(b,"name","hf:doc:metadata"),St(b,"content",sl)},m(e,t){nl(document.head,b),n(e,fe,t),n(e,Me,t),n(e,Je,t),u(J,e,t),n(e,Te,t),u(T,e,t),n(e,he,t),n(e,h,t),n(e,ye,t),u(y,e,t),n(e,Ue,t),n(e,U,t),n(e,ke,t),u(k,e,t),n(e,$e,t),n(e,$,t),n(e,je,t),n(e,j,t),n(e,we,t),n(e,w,t),n(e,ve,t),n(e,v,t),n(e,ze,t),u(z,e,t),n(e,xe,t),n(e,x,t),n(e,Ie,t),u(I,e,t),n(e,Ze,t),n(e,Z,t),n(e,_e,t),u(_,e,t),n(e,Ce,t),n(e,C,t),n(e,Xe,t),u(X,e,t),n(e,Ge,t),n(e,G,t),n(e,We,t),u(W,e,t),n(e,Ve,t),n(e,V,t),n(e,Le,t),u(L,e,t),n(e,Re,t),n(e,R,t),n(e,Be,t),n(e,B,t),n(e,Fe,t),n(e,F,t),n(e,Ee,t),u(E,e,t),n(e,He,t),n(e,H,t),n(e,qe,t),n(e,q,t),n(e,Qe,t),n(e,Q,t),n(e,Ye,t),u(Y,e,t),n(e,Ne,t),n(e,N,t),n(e,Ae,t),n(e,A,t),n(e,Pe,t),n(e,P,t),n(e,Se,t),u(S,e,t),n(e,De,t),n(e,D,t),n(e,Ke,t),n(e,K,t),n(e,Oe,t),n(e,O,t),n(e,et,t),u(ee,e,t),n(e,tt,t),n(e,te,t),n(e,lt,t),u(le,e,t),n(e,nt,t),n(e,ne,t),n(e,at,t),u(ae,e,t),n(e,it,t),u(ie,e,t),n(e,st,t),n(e,se,t),n(e,ot,t),n(e,oe,t),n(e,mt,t),n(e,me,t),n(e,pt,t),u(pe,e,t),n(e,rt,t),n(e,re,t),n(e,ut,t),u(ue,e,t),n(e,gt,t),n(e,ge,t),n(e,dt,t),u(de,e,t),n(e,ct,t),n(e,ce,t),n(e,Mt,t),n(e,be,t),bt=!0},p:Kt,i(e){bt||(g(J.$$.fragment,e),g(T.$$.fragment,e),g(y.$$.fragment,e),g(k.$$.fragment,e),g(z.$$.fragment,e),g(I.$$.fragment,e),g(_.$$.fragment,e),g(X.$$.fragment,e),g(W.$$.fragment,e),g(L.$$.fragment,e),g(E.$$.fragment,e),g(Y.$$.fragment,e),g(S.$$.fragment,e),g(ee.$$.fragment,e),g(le.$$.fragment,e),g(ae.$$.fragment,e),g(ie.$$.fragment,e),g(pe.$$.fragment,e),g(ue.$$.fragment,e),g(de.$$.fragment,e),bt=!0)},o(e){d(J.$$.fragment,e),d(T.$$.fragment,e),d(y.$$.fragment,e),d(k.$$.fragment,e),d(z.$$.fragment,e),d(I.$$.fragment,e),d(_.$$.fragment,e),d(X.$$.fragment,e),d(W.$$.fragment,e),d(L.$$.fragment,e),d(E.$$.fragment,e),d(Y.$$.fragment,e),d(S.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(ie.$$.fragment,e),d(pe.$$.fragment,e),d(ue.$$.fragment,e),d(de.$$.fragment,e),bt=!1},d(e){e&&(l(fe),l(Me),l(Je),l(Te),l(he),l(h),l(ye),l(Ue),l(U),l(ke),l($e),l($),l(je),l(j),l(we),l(w),l(ve),l(v),l(ze),l(xe),l(x),l(Ie),l(Ze),l(Z),l(_e),l(Ce),l(C),l(Xe),l(Ge),l(G),l(We),l(Ve),l(V),l(Le),l(Re),l(R),l(Be),l(B),l(Fe),l(F),l(Ee),l(He),l(H),l(qe),l(q),l(Qe),l(Q),l(Ye),l(Ne),l(N),l(Ae),l(A),l(Pe),l(P),l(Se),l(De),l(D),l(Ke),l(K),l(Oe),l(O),l(et),l(tt),l(te),l(lt),l(nt),l(ne),l(at),l(it),l(st),l(se),l(ot),l(oe),l(mt),l(me),l(pt),l(rt),l(re),l(ut),l(gt),l(ge),l(dt),l(ct),l(ce),l(Mt),l(be)),l(b),c(J,e),c(T,e),c(y,e),c(k,e),c(z,e),c(I,e),c(_,e),c(X,e),c(W,e),c(L,e),c(E,e),c(Y,e),c(S,e),c(ee,e),c(le,e),c(ae,e),c(ie,e),c(pe,e),c(ue,e),c(de,e)}}}const sl='{"title":"Modelli multilingue per l’inferenza","local":"modelli-multilingue-per-linferenza","sections":[{"title":"XLM","local":"xlm","sections":[{"title":"XLM con language embeddings","local":"xlm-con-language-embeddings","sections":[],"depth":3},{"title":"XLM senza language embeddings","local":"xlm-senza-language-embeddings","sections":[],"depth":3}],"depth":2},{"title":"BERT","local":"bert","sections":[],"depth":2},{"title":"XLM-RoBERTa","local":"xlm-roberta","sections":[],"depth":2},{"title":"M2M100","local":"m2m100","sections":[],"depth":2},{"title":"MBart","local":"mbart","sections":[],"depth":2}],"depth":1}';function ol(ft){return Ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dl extends el{constructor(b){super(),tl(this,b,ol,il,Dt,{})}}export{dl as component};
