import{s as al,o as ll,n as tl}from"../chunks/scheduler.c57aa7ef.js";import{S as sl,i as nl,g as i,s,r as p,A as il,h as o,f as a,c as n,j as Ka,u as d,x as r,k as Oa,y as ol,a as l,v as m,d as h,t as f,w as u}from"../chunks/index.c50cb18e.js";import{T as el}from"../chunks/Tip.9268b0ca.js";import{C as M}from"../chunks/CodeBlock.34f0a53d.js";import{H as w,E as rl}from"../chunks/EditOnGithub.958a8a49.js";function pl(Fe){let c,T='Learn more about how PEFT works with quantization in the <a href="quantization">Quantization</a> guide.';return{c(){c=i("p"),c.innerHTML=T},l(y){c=o(y,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1nbpolx"&&(c.innerHTML=T)},m(y,b){l(y,c,b)},p:tl,d(y){y&&a(c)}}}function dl(Fe){let c,T='There are several supported methods for <code>combination_type</code>. Refer to the <a href="../package_reference/lora#peft.LoraModel.add_weighted_adapter">documentation</a> for more details. Note that “svd” as the <code>combination_type</code> is not supported when using <code>torch.float16</code> or <code>torch.bfloat16</code> as the datatype.';return{c(){c=i("p"),c.innerHTML=T},l(y){c=o(y,"P",{"data-svelte-h":!0}),r(c)!=="svelte-19y7vpj"&&(c.innerHTML=T)},m(y,b){l(y,c,b)},p:tl,d(y){y&&a(c)}}}function ml(Fe){let c,T,y,b,_,xe,$,ha='LoRA is low-rank decomposition method to reduce the number of trainable parameters which speeds up finetuning large models and uses less memory. In PEFT, using LoRA is as easy as setting up a <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> and wrapping it with <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> to create a trainable <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',ze,Z,fa="This guide explores in more detail other options and features for using LoRA.",Ee,j,Ye,v,ua='The initialization of LoRA weights is controlled by the parameter <code>init_lora_weights</code> in <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. By default, PEFT initializes LoRA weights with Kaiming-uniform for weight A and zeros for weight B resulting in an identity transform (same as the reference <a href="https://github.com/microsoft/LoRA" rel="nofollow">implementation</a>).',Ne,U,ca='It is also possible to pass <code>init_lora_weights=&quot;gaussian&quot;</code>. As the name suggests, this initializes weight A with a Gaussian distribution and zeros for weight B (this is how <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">Diffusers</a> initializes LoRA weights).',Se,k,Pe,R,Ma="There is also an option to set <code>init_lora_weights=False</code> which is useful for debugging and testing. This should be the only time you use this option. When choosing this option, the LoRA weights are initialized such that they do <em>not</em> result in an identity transform.",De,B,Ke,C,Oe,I,ya='<a href="https://arxiv.org/abs/2404.02948" rel="nofollow">PiSSA</a> initializes the LoRA adapter using the principal singular values and singular vectors. This straightforward modification allows PiSSA to converge more rapidly than LoRA and ultimately attain superior performance. Moreover, PiSSA reduces the quantization error compared to QLoRA, leading to further enhancements.',et,L,wa="Configure the initialization method to “pissa”, which may take several minutes to execute SVD on the pre-trained model:",tt,W,at,G,Ta="Alternatively, execute fast SVD, which takes only a few seconds. The number of iterations determines the trade-off between the error and computation time:",lt,A,st,X,ba='For detailed instruction on using PiSSA, please follow <a href="https://github.com/fxmeng/peft/tree/main/examples/pissa_finetuning" rel="nofollow">these instructions</a>.',nt,Q,it,V,ot,q,ga='When quantizing the base model for QLoRA training, consider using the <a href="https://arxiv.org/abs/2310.08659" rel="nofollow">LoftQ initialization</a>, which has been shown to improve performance when training quantized models. The idea is that the LoRA weights are initialized such that the quantization error is minimized. To use LoftQ, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',rt,F,Ja="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",pt,H,dt,x,_a="An easier but more limited way to apply LoftQ initialization is to use the convenience function <code>replace_lora_weights_loftq</code>. This takes the quantized PEFT model as input and replaces the LoRA weights in-place with their LoftQ-initialized counterparts.",mt,z,ht,E,$a='<code>replace_lora_weights_loftq</code> also allows you to pass a <code>callback</code> argument to give you more control over which layers should be modified or not, which empirically can improve the results quite a lot. To see a more elaborate example of this, check out <a href="https://github.com/huggingface/peft/blob/main/examples/loftq_finetuning/LoftQ_weight_replacement.ipynb" rel="nofollow">this notebook</a>.',ft,Y,Za="<code>replace_lora_weights_loftq</code> implements only one iteration step of LoftQ. This means that only the LoRA weights are updated, instead of iteratevily updating LoRA weights and quantized base model weights. This may lead to lower performance but has the advantage that we can use the original quantized weights derived from the base model, instead of having to keep an extra copy of modified quantized weights. Whether this tradeoff is worthwhile depends on the use case.",ut,N,ja="At the moment, <code>replace_lora_weights_loftq</code> has these additional limitations:",ct,S,va="<li>Model files must be stored as a <code>safetensors</code> file.</li> <li>Only bitsandbytes 4bit quantization is supported.</li>",Mt,g,yt,P,wt,D,Ua='Another way to initialize <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> is with the <a href="https://huggingface.co/papers/2312.03732" rel="nofollow">rank-stabilized LoRA (rsLoRA)</a> method. The LoRA architecture scales each adapter during every forward pass by a fixed scalar which is set at initialization and depends on the rank <code>r</code>. The scalar is given by <code>lora_alpha/r</code> in the original implementation, but rsLoRA uses <code>lora_alpha/math.sqrt(r)</code> which stabilizes the adapters and increases the performance potential from using a higher <code>r</code>.',Tt,K,bt,O,gt,ee,ka='This technique decomposes the updates of the weights into two parts, magnitude and direction. Direction is handled by normal LoRA, whereas the magnitude is handled by a separate learnable parameter. This can improve the performance of LoRA, especially at low ranks. For more information on DoRA, see  <a href="https://arxiv.org/abs/2402.09353" rel="nofollow">https://arxiv.org/abs/2402.09353</a>.',Jt,te,_t,ae,$t,le,Ra='<li>DoRA only supports linear and Conv2d layers at the momement.</li> <li>DoRA introduces a bigger overhead than pure LoRA, so it is recommended to merge weights for inference, see <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">LoraModel.merge_and_unload()</a>.</li> <li>DoRA should work with weights quantized with bitsandbytes (“QDoRA”). However, issues have been reported when using QDoRA with DeepSpeed Zero2.</li>',Zt,se,jt,ne,Ba='The default LoRA settings in PEFT add trainable weights to the query and value layers of each attention block. But <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a>, which adds trainable weights to all the linear layers of a transformer model, can provide performance equal to a fully finetuned model. To apply LoRA to all the linear layers, like in QLoRA, set <code>target_modules=&quot;all-linear&quot;</code> (easier than specifying individual modules by name which can vary depending on the architecture).',vt,ie,Ut,oe,kt,re,Ca='An approach used to improve the performance of models is to expand a model by duplicating layers in the model to build a larger model from a pretrained model of a given size. For example increasing a 7B model to a 10B model as described in the <a href="https://arxiv.org/abs/2312.15166" rel="nofollow">SOLAR</a> paper. PEFT LoRA supports this kind of expansion in a memory efficient manner that supports further fine-tuning using LoRA adapters attached to the layers post replication of the layers. The replicated layers do not take additional memory as they share the underlying weights so the only additional memory required is the memory for the adapter weights. To use this feature you would create a config with the <code>layer_replication</code> argument.',Rt,pe,Bt,de,Ia='Assuming the original model had 5 layers <code>[0, 1, 2 ,3, 4]</code>, this would create a model with 7 layers arranged as <code>[0, 1, 2, 3, 2, 3, 4]</code>. This follows the <a href="https://github.com/arcee-ai/mergekit" rel="nofollow">mergekit</a> pass through merge convention where sequences of layers specified as start inclusive and end exclusive tuples are stacked to build the final model. Each layer in the final model gets its own distinct set of LoRA adpaters.',Ct,me,La=`<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B" rel="nofollow">Fewshot-Metamath-OrcaVicuna-Mistral-10B</a> is an example of a model trained using this method on Mistral-7B expanded to 10B. The
<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B/blob/main/adapter_config.json" rel="nofollow">adapter_config.json</a> shows a sample LoRA adapter config applying this method for fine-tuning.`,It,he,Lt,fe,Wa='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA adapter. To eliminate latency, use the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model. This allows you to use the newly merged model as a standalone model. The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function doesn’t keep the adapter weights in memory.',Wt,ue,Gt,ce,Ga='If you need to keep a copy of the weights so you can unmerge the adapter later or delete and load different ones, you should use the <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_adapter">merge_adapter()</a> function instead. Now you have the option to use <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unmerge_adapter">unmerge_adapter()</a> to return the base model.',At,Me,Xt,ye,Aa='The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> function is useful for merging multiple LoRAs into a new adapter based on a user provided weighting scheme in the <code>weights</code> parameter. Below is an end-to-end example.',Qt,we,Xa="First load the base model:",Vt,Te,qt,be,Qa="Then we load the first adapter:",Ft,ge,Ht,Je,Va="Then load a different adapter and merge it with the first one:",xt,_e,zt,J,Et,$e,qa="Now, perform inference:",Yt,Ze,Nt,je,St,ve,Fa='Adapters can be loaded onto a pretrained model with <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>, which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.set_adapter">set_adapter()</a> function.',Pt,Ue,Dt,ke,Ha='To return the base model, you could use <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.unload">unload()</a> to unload all of the LoRA modules or <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.delete_adapter">delete_adapter()</a> to delete the adapter entirely.',Kt,Re,Ot,Be,ea,Ce,xa="Normally, each inference batch has to use the same adapter(s) in PEFT. This can sometimes be annoying, because we may have batches that contain samples intended to be used with different LoRA adapters. For example, we could have a base model that works well in English and two more LoRA adapters, one for French and one for German. Usually, we would have to split our batches such that each batch only contains samples of one of the languages, we cannot combine different languages in the same batch.",ta,Ie,za="Thankfully, it is possible to mix different LoRA adapters in the same batch using the <code>adapter_name</code> argument. Below, we show an examle of how this works in practice. First, let’s load the base model, English, and the two adapters, French and German, like this:",aa,Le,la,We,Ea="Now, we want to generate text on a sample that contains all three languages: The first three samples are in English, the next three are in French, and the last three are in German. We can use the <code>adapter_names</code> argument to specify which adapter to use for each sample. Since our base model is used for English, we use the special string <code>&quot;__base__&quot;</code> for these samples. For the next three samples, we indicate the adapter name of the French LoRA fine-tune, in this case <code>&quot;adapter_fr&quot;</code>. For the last three samples, we indicate the adapter name of the German LoRA fine-tune, in this case <code>&quot;adapter_de&quot;</code>. This way, we can use the base model and the two adapters in a single batch.",sa,Ge,na,Ae,Ya="Note that the order does not matter here, i.e. the samples in the batch don’t need to be grouped by adapter as in the example above. We just need to ensure that the <code>adapter_names</code> argument is aligned correctly with the samples.",ia,Xe,oa,Qe,Na="Using this features has some drawbacks, namely:",ra,Ve,Sa='<li>It only works for inference, not for training.</li> <li>Disabling adapters using the <code>with model.disable_adapter()</code> context takes precedence over <code>adapter_names</code>.</li> <li>You cannot pass <code>adapter_names</code> when some adapter weights where merged with base weight using the <code>merge_adapter</code> method. Please unmerge all adapters first by calling <code>model.unmerge_adapter()</code>.</li> <li>For obvious reasons, this cannot be used after calling <code>merge_and_unload()</code>, since all the LoRA adapters will be merged into the base weights in this case.</li> <li>This feature does not currently work with DoRA, so set <code>use_dora=False</code> in your <code>LoraConfig</code> if you want to use it.</li> <li>There is an expected overhead for inference with <code>adapter_names</code>, especially if the amount of different adapters in the batch is high. This is because the batch size is effectively reduced to the number of samples per adapter. If runtime performance is your top priority, try the following:<ul><li>Increase the batch size.</li> <li>Try to avoid having a large number of different adapters in the same batch, prefer homogeneous batches. This can be achieved by buffering samples with the same adapter and only perform inference with a small handfull of different adapters.</li> <li>Take a look at alternative implementations such as <a href="https://github.com/predibase/lorax" rel="nofollow">LoRAX</a>, <a href="https://github.com/punica-ai/punica" rel="nofollow">punica</a>, or <a href="https://github.com/S-LoRA/S-LoRA" rel="nofollow">S-LoRA</a>, which are specialized to work with a large number of different adapters.</li></ul></li>',pa,qe,da,He,ma;return _=new w({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),j=new w({props:{title:"Initialization",local:"initialization",headingTag:"h2"}}),k=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmdhdXNzaWFuJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;gaussian&quot;</span>, ...)`,wrap:!1}}),B=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzREZhbHNlJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-literal">False</span>, ...)`,wrap:!1}}),C=new w({props:{title:"PiSSA",local:"pissa",headingTag:"h3"}}),W=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMnBpc3NhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa&quot;</span>, ...)`,wrap:!1}}),A=new M({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKGluaXRfbG9yYV93ZWlnaHRzJTNEJTIycGlzc2Ffbml0ZXJfJTVCbnVtYmVyJTIwb2YlMjBpdGVycyU1RCUyMiUyQyUyMC4uLiklMjA=",highlighted:'lora_config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa_niter_[number of iters]&quot;</span>, ...) ',wrap:!1}}),Q=new w({props:{title:"LoftQ",local:"loftq",headingTag:"h3"}}),V=new w({props:{title:"Standard approach",local:"standard-approach",headingTag:"h4"}}),H=new w({props:{title:"A more convienient way",local:"a-more-convienient-way",headingTag:"h4"}}),z=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjByZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjAuLi4pJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCguLi4lMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyklMEElMjMlMjBub3RlJTNBJTIwZG9uJ3QlMjBwYXNzJTIwaW5pdF9sb3JhX3dlaWdodHMlM0QlMjJsb2Z0cSUyMiUyMG9yJTIwbG9mdHFfY29uZmlnISUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIpJTBBcGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBsb3JhX2NvbmZpZyklMEFyZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cShwZWZ0X21vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> replace_lora_weights_loftq
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

bnb_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, ...)
base_model = AutoModelForCausalLM.from_pretrained(..., quantization_config=bnb_config)
<span class="hljs-comment"># note: don&#x27;t pass init_lora_weights=&quot;loftq&quot; or loftq_config!</span>
lora_config = LoraConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>)
peft_model = get_peft_model(base_model, lora_config)
replace_lora_weights_loftq(peft_model)`,wrap:!1}}),g=new el({props:{$$slots:{default:[pl]},$$scope:{ctx:Fe}}}),P=new w({props:{title:"Rank-stabilized LoRA",local:"rank-stabilized-lora",headingTag:"h3"}}),K=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfcnNsb3JhJTNEVHJ1ZSUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_rslora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),O=new w({props:{title:"Weight-Decomposed Low-Rank Adaptation (DoRA)",local:"weight-decomposed-low-rank-adaptation-dora",headingTag:"h3"}}),te=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfZG9yYSUzRFRydWUlMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),ae=new w({props:{title:"Caveats",local:"caveats",headingTag:"h4"}}),se=new w({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),ie=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),oe=new w({props:{title:"Memory efficient Layer Replication with LoRA",local:"memory-efficient-layer-replication-with-lora",headingTag:"h3"}}),pe=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhsYXllcl9yZXBsaWNhdGlvbiUzRCU1QiU1QjAlMkM0JTVEJTJDJTIwJTVCMiUyQzUlNUQlNUQlMkMlMjAuLi4p",highlighted:'config = LoraConfig(layer_replication=[[<span class="hljs-number">0</span>,<span class="hljs-number">4</span>], [<span class="hljs-number">2</span>,<span class="hljs-number">5</span>]], ...)',wrap:!1}}),he=new w({props:{title:"Merge adapters",local:"merge-adapters",headingTag:"h2"}}),ue=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FuZF91bmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_and_unload()`,wrap:!1}}),Me=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FkYXB0ZXIoKSUwQSUwQSUyMyUyMHVubWVyZ2UlMjB0aGUlMjBMb1JBJTIwbGF5ZXJzJTIwZnJvbSUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsLnVubWVyZ2VfYWRhcHRlcigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_adapter()

<span class="hljs-comment"># unmerge the LoRA layers from the base model</span>
model.unmerge_adapter()`,wrap:!1}}),Te=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">import</span> torch

base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),ge=new M({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1zZnQtbG9yYSUyMiUwQW1vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnNmdCUyMik=",highlighted:`peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id, adapter_name=<span class="hljs-string">&quot;sft&quot;</span>)`,wrap:!1}}),_e=new M({props:{code:"d2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTIwJTNEJTIwJTIyc2Z0LWRwbyUyMiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjJhbGlnbm1lbnQtaGFuZGJvb2slMkZ6ZXBoeXItN2ItZHBvLWxvcmElMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJkcG8lMjIpJTBBbW9kZWwuYWRkX3dlaWdodGVkX2FkYXB0ZXIoJTBBJTIwJTIwJTIwJTIwYWRhcHRlcnMlM0QlNUIlMjJzZnQlMjIlMkMlMjAlMjJkcG8lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTNEJTVCMC43JTJDJTIwMC4zJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEd2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwY29tYmluYXRpb25fdHlwZSUzRCUyMmxpbmVhciUyMiUwQSklMEFtb2RlbC5zZXRfYWRhcHRlcih3ZWlnaHRlZF9hZGFwdGVyX25hbWUp",highlighted:`weighted_adapter_name = <span class="hljs-string">&quot;sft-dpo&quot;</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)
model.add_weighted_adapter(
    adapters=[<span class="hljs-string">&quot;sft&quot;</span>, <span class="hljs-string">&quot;dpo&quot;</span>],
    weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>],
    adapter_name=weighted_adapter_name,
    combination_type=<span class="hljs-string">&quot;linear&quot;</span>
)
model.set_adapter(weighted_adapter_name)`,wrap:!1}}),J=new el({props:{$$slots:{default:[dl]},$$scope:{ctx:Fe}}}),Ze=new M({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oJTIyY3VkYSUyMiklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBb3V0cHV0cyUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQXByaW50KG91dHB1dHMp",highlighted:`tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
outputs = tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(outputs)`,wrap:!1}}),je=new w({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),Ue=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQSUwQSUyMyUyMGxvYWQlMjBkaWZmZXJlbnQlMjBhZGFwdGVyJTBBbW9kZWwubG9hZF9hZGFwdGVyKCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1kcG8tbG9yYSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRwbyUyMiklMEElMEElMjMlMjBzZXQlMjBhZGFwdGVyJTIwYXMlMjBhY3RpdmUlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJkcG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)

<span class="hljs-comment"># load different adapter</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)

<span class="hljs-comment"># set adapter as active</span>
model.set_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),Re=new M({props:{code:"JTIzJTIwdW5sb2FkJTIwYWRhcHRlciUwQW1vZGVsLnVubG9hZCgpJTBBJTBBJTIzJTIwZGVsZXRlJTIwYWRhcHRlciUwQW1vZGVsLmRlbGV0ZV9hZGFwdGVyKCUyMmRwbyUyMik=",highlighted:`<span class="hljs-comment"># unload adapter</span>
model.unload()

<span class="hljs-comment"># delete adapter</span>
model.delete_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),Be=new w({props:{title:"Inference with different LoRA adapters in the same batch",local:"inference-with-different-lora-adapters-in-the-same-batch",headingTag:"h2"}}),Le=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMjMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBGcmVuY2glMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMCUzQ3BhdGglM0UlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJhZGFwdGVyX2ZyJTIyKSUwQSUyMyUyMG5leHQlMkMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBHZXJtYW4lMEFwZWZ0X21vZGVsLmxvYWRfYWRhcHRlciglM0NwYXRoJTNFJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlcl9kZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model_id = ...
tokenizer = AutoTokenizer.from_pretrained(model_id)

model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-comment"># load the LoRA adapter for French</span>
peft_model = PeftModel.from_pretrained(model, &lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_fr&quot;</span>)
<span class="hljs-comment"># next, load the LoRA adapter for German</span>
peft_model.load_adapter(&lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_de&quot;</span>)`,wrap:!1}}),Ge=new M({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIZWxsbyUyQyUyMG15JTIwY2F0JTIwaXMlMjBhd2Vzb21lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySGVsbG8lMkMlMjBteSUyMGZpc2glMjBpcyUyMGdyZWF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBjaGllbiUyMGVzdCUyMG1pZ25vbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlNhbHV0JTJDJTIwbW9uJTIwY2hhdCUyMGVzdCUyMGclQzMlQTluaWFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBwb2lzc29uJTIwZXN0JTIwc3VwZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBIdW5kJTIwaXN0JTIwcyVDMyVCQyVDMyU5RiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhhbGxvJTJDJTIwbWVpbmUlMjBLYXR6ZSUyMGlzdCUyMHRvbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBGaXNjaCUyMGlzdCUyMGdybyVDMyU5RmFydGlnJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBKSUwQSUwQWFkYXB0ZXJfbmFtZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJfX2Jhc2VfXyUyMiUyQyUyMCUyMl9fYmFzZV9fJTIyJTJDJTIwJTIyX19iYXNlX18lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2ZyJTIyJTJDJTIwJTIyYWRhcHRlcl9mciUyMiUyQyUyMCUyMmFkYXB0ZXJfZnIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2RlJTIyJTJDJTIwJTIyYWRhcHRlcl9kZSUyMiUyQyUyMCUyMmFkYXB0ZXJfZGUlMjIlMkMlMEElNUQlMEFvdXRwdXQlMjAlM0QlMjBwZWZ0X21vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYWRhcHRlcl9uYW1lcyUzRGFkYXB0ZXJfbmFtZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKQ==",highlighted:`inputs = tokenizer(
    [
        <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>,
        <span class="hljs-string">&quot;Hello, my cat is awesome&quot;</span>,
        <span class="hljs-string">&quot;Hello, my fish is great&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chien est mignon&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chat est génial&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon poisson est super&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Hund ist süß&quot;</span>,
        <span class="hljs-string">&quot;Hallo, meine Katze ist toll&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Fisch ist großartig&quot;</span>,
    ],
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    padding=<span class="hljs-literal">True</span>,
)

adapter_names = [
    <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>,
    <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>,
    <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>,
]
output = peft_model.generate(**inputs, adapter_names=adapter_names, max_new_tokens=<span class="hljs-number">20</span>)`,wrap:!1}}),Xe=new w({props:{title:"Caveats",local:"caveats",headingTag:"h3"}}),qe=new rl({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/lora.md"}}),{c(){c=i("meta"),T=s(),y=i("p"),b=s(),p(_.$$.fragment),xe=s(),$=i("p"),$.innerHTML=ha,ze=s(),Z=i("p"),Z.textContent=fa,Ee=s(),p(j.$$.fragment),Ye=s(),v=i("p"),v.innerHTML=ua,Ne=s(),U=i("p"),U.innerHTML=ca,Se=s(),p(k.$$.fragment),Pe=s(),R=i("p"),R.innerHTML=Ma,De=s(),p(B.$$.fragment),Ke=s(),p(C.$$.fragment),Oe=s(),I=i("p"),I.innerHTML=ya,et=s(),L=i("p"),L.textContent=wa,tt=s(),p(W.$$.fragment),at=s(),G=i("p"),G.textContent=Ta,lt=s(),p(A.$$.fragment),st=s(),X=i("p"),X.innerHTML=ba,nt=s(),p(Q.$$.fragment),it=s(),p(V.$$.fragment),ot=s(),q=i("p"),q.innerHTML=ga,rt=s(),F=i("p"),F.innerHTML=Ja,pt=s(),p(H.$$.fragment),dt=s(),x=i("p"),x.innerHTML=_a,mt=s(),p(z.$$.fragment),ht=s(),E=i("p"),E.innerHTML=$a,ft=s(),Y=i("p"),Y.innerHTML=Za,ut=s(),N=i("p"),N.innerHTML=ja,ct=s(),S=i("ul"),S.innerHTML=va,Mt=s(),p(g.$$.fragment),yt=s(),p(P.$$.fragment),wt=s(),D=i("p"),D.innerHTML=Ua,Tt=s(),p(K.$$.fragment),bt=s(),p(O.$$.fragment),gt=s(),ee=i("p"),ee.innerHTML=ka,Jt=s(),p(te.$$.fragment),_t=s(),p(ae.$$.fragment),$t=s(),le=i("ul"),le.innerHTML=Ra,Zt=s(),p(se.$$.fragment),jt=s(),ne=i("p"),ne.innerHTML=Ba,vt=s(),p(ie.$$.fragment),Ut=s(),p(oe.$$.fragment),kt=s(),re=i("p"),re.innerHTML=Ca,Rt=s(),p(pe.$$.fragment),Bt=s(),de=i("p"),de.innerHTML=Ia,Ct=s(),me=i("p"),me.innerHTML=La,It=s(),p(he.$$.fragment),Lt=s(),fe=i("p"),fe.innerHTML=Wa,Wt=s(),p(ue.$$.fragment),Gt=s(),ce=i("p"),ce.innerHTML=Ga,At=s(),p(Me.$$.fragment),Xt=s(),ye=i("p"),ye.innerHTML=Aa,Qt=s(),we=i("p"),we.textContent=Xa,Vt=s(),p(Te.$$.fragment),qt=s(),be=i("p"),be.textContent=Qa,Ft=s(),p(ge.$$.fragment),Ht=s(),Je=i("p"),Je.textContent=Va,xt=s(),p(_e.$$.fragment),zt=s(),p(J.$$.fragment),Et=s(),$e=i("p"),$e.textContent=qa,Yt=s(),p(Ze.$$.fragment),Nt=s(),p(je.$$.fragment),St=s(),ve=i("p"),ve.innerHTML=Fa,Pt=s(),p(Ue.$$.fragment),Dt=s(),ke=i("p"),ke.innerHTML=Ha,Kt=s(),p(Re.$$.fragment),Ot=s(),p(Be.$$.fragment),ea=s(),Ce=i("p"),Ce.textContent=xa,ta=s(),Ie=i("p"),Ie.innerHTML=za,aa=s(),p(Le.$$.fragment),la=s(),We=i("p"),We.innerHTML=Ea,sa=s(),p(Ge.$$.fragment),na=s(),Ae=i("p"),Ae.innerHTML=Ya,ia=s(),p(Xe.$$.fragment),oa=s(),Qe=i("p"),Qe.textContent=Na,ra=s(),Ve=i("ul"),Ve.innerHTML=Sa,pa=s(),p(qe.$$.fragment),da=s(),He=i("p"),this.h()},l(e){const t=il("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(a),T=n(e),y=o(e,"P",{}),Ka(y).forEach(a),b=n(e),d(_.$$.fragment,e),xe=n(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-38uxl6"&&($.innerHTML=ha),ze=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-ovsn32"&&(Z.textContent=fa),Ee=n(e),d(j.$$.fragment,e),Ye=n(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-j883mf"&&(v.innerHTML=ua),Ne=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1fujb7a"&&(U.innerHTML=ca),Se=n(e),d(k.$$.fragment,e),Pe=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-mwvui1"&&(R.innerHTML=Ma),De=n(e),d(B.$$.fragment,e),Ke=n(e),d(C.$$.fragment,e),Oe=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1skluc"&&(I.innerHTML=ya),et=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1hy0lgx"&&(L.textContent=wa),tt=n(e),d(W.$$.fragment,e),at=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-auzrbb"&&(G.textContent=Ta),lt=n(e),d(A.$$.fragment,e),st=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-u5znzv"&&(X.innerHTML=ba),nt=n(e),d(Q.$$.fragment,e),it=n(e),d(V.$$.fragment,e),ot=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1ts8vpq"&&(q.innerHTML=ga),rt=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-7f0aai"&&(F.innerHTML=Ja),pt=n(e),d(H.$$.fragment,e),dt=n(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-14vtcq9"&&(x.innerHTML=_a),mt=n(e),d(z.$$.fragment,e),ht=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1nywyxh"&&(E.innerHTML=$a),ft=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1d2jix1"&&(Y.innerHTML=Za),ut=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-yl8kok"&&(N.innerHTML=ja),ct=n(e),S=o(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-12tl4fy"&&(S.innerHTML=va),Mt=n(e),d(g.$$.fragment,e),yt=n(e),d(P.$$.fragment,e),wt=n(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-omuw13"&&(D.innerHTML=Ua),Tt=n(e),d(K.$$.fragment,e),bt=n(e),d(O.$$.fragment,e),gt=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1ukfkwt"&&(ee.innerHTML=ka),Jt=n(e),d(te.$$.fragment,e),_t=n(e),d(ae.$$.fragment,e),$t=n(e),le=o(e,"UL",{"data-svelte-h":!0}),r(le)!=="svelte-1lkjk8m"&&(le.innerHTML=Ra),Zt=n(e),d(se.$$.fragment,e),jt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-15vxux2"&&(ne.innerHTML=Ba),vt=n(e),d(ie.$$.fragment,e),Ut=n(e),d(oe.$$.fragment,e),kt=n(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1mosto0"&&(re.innerHTML=Ca),Rt=n(e),d(pe.$$.fragment,e),Bt=n(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1safyei"&&(de.innerHTML=Ia),Ct=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-foj0wd"&&(me.innerHTML=La),It=n(e),d(he.$$.fragment,e),Lt=n(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1c3h9aa"&&(fe.innerHTML=Wa),Wt=n(e),d(ue.$$.fragment,e),Gt=n(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-m3cr6r"&&(ce.innerHTML=Ga),At=n(e),d(Me.$$.fragment,e),Xt=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-kbqhpl"&&(ye.innerHTML=Aa),Qt=n(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1mwdwt1"&&(we.textContent=Xa),Vt=n(e),d(Te.$$.fragment,e),qt=n(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-nuhu05"&&(be.textContent=Qa),Ft=n(e),d(ge.$$.fragment,e),Ht=n(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1n53hd9"&&(Je.textContent=Va),xt=n(e),d(_e.$$.fragment,e),zt=n(e),d(J.$$.fragment,e),Et=n(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-qwbdkg"&&($e.textContent=qa),Yt=n(e),d(Ze.$$.fragment,e),Nt=n(e),d(je.$$.fragment,e),St=n(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-ke62q2"&&(ve.innerHTML=Fa),Pt=n(e),d(Ue.$$.fragment,e),Dt=n(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-cvmoj6"&&(ke.innerHTML=Ha),Kt=n(e),d(Re.$$.fragment,e),Ot=n(e),d(Be.$$.fragment,e),ea=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1fq5tpu"&&(Ce.textContent=xa),ta=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-6zt8d6"&&(Ie.innerHTML=za),aa=n(e),d(Le.$$.fragment,e),la=n(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-6wkyom"&&(We.innerHTML=Ea),sa=n(e),d(Ge.$$.fragment,e),na=n(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1o40ch6"&&(Ae.innerHTML=Ya),ia=n(e),d(Xe.$$.fragment,e),oa=n(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-fpz5mj"&&(Qe.textContent=Na),ra=n(e),Ve=o(e,"UL",{"data-svelte-h":!0}),r(Ve)!=="svelte-1jk1r7d"&&(Ve.innerHTML=Sa),pa=n(e),d(qe.$$.fragment,e),da=n(e),He=o(e,"P",{}),Ka(He).forEach(a),this.h()},h(){Oa(c,"name","hf:doc:metadata"),Oa(c,"content",hl)},m(e,t){ol(document.head,c),l(e,T,t),l(e,y,t),l(e,b,t),m(_,e,t),l(e,xe,t),l(e,$,t),l(e,ze,t),l(e,Z,t),l(e,Ee,t),m(j,e,t),l(e,Ye,t),l(e,v,t),l(e,Ne,t),l(e,U,t),l(e,Se,t),m(k,e,t),l(e,Pe,t),l(e,R,t),l(e,De,t),m(B,e,t),l(e,Ke,t),m(C,e,t),l(e,Oe,t),l(e,I,t),l(e,et,t),l(e,L,t),l(e,tt,t),m(W,e,t),l(e,at,t),l(e,G,t),l(e,lt,t),m(A,e,t),l(e,st,t),l(e,X,t),l(e,nt,t),m(Q,e,t),l(e,it,t),m(V,e,t),l(e,ot,t),l(e,q,t),l(e,rt,t),l(e,F,t),l(e,pt,t),m(H,e,t),l(e,dt,t),l(e,x,t),l(e,mt,t),m(z,e,t),l(e,ht,t),l(e,E,t),l(e,ft,t),l(e,Y,t),l(e,ut,t),l(e,N,t),l(e,ct,t),l(e,S,t),l(e,Mt,t),m(g,e,t),l(e,yt,t),m(P,e,t),l(e,wt,t),l(e,D,t),l(e,Tt,t),m(K,e,t),l(e,bt,t),m(O,e,t),l(e,gt,t),l(e,ee,t),l(e,Jt,t),m(te,e,t),l(e,_t,t),m(ae,e,t),l(e,$t,t),l(e,le,t),l(e,Zt,t),m(se,e,t),l(e,jt,t),l(e,ne,t),l(e,vt,t),m(ie,e,t),l(e,Ut,t),m(oe,e,t),l(e,kt,t),l(e,re,t),l(e,Rt,t),m(pe,e,t),l(e,Bt,t),l(e,de,t),l(e,Ct,t),l(e,me,t),l(e,It,t),m(he,e,t),l(e,Lt,t),l(e,fe,t),l(e,Wt,t),m(ue,e,t),l(e,Gt,t),l(e,ce,t),l(e,At,t),m(Me,e,t),l(e,Xt,t),l(e,ye,t),l(e,Qt,t),l(e,we,t),l(e,Vt,t),m(Te,e,t),l(e,qt,t),l(e,be,t),l(e,Ft,t),m(ge,e,t),l(e,Ht,t),l(e,Je,t),l(e,xt,t),m(_e,e,t),l(e,zt,t),m(J,e,t),l(e,Et,t),l(e,$e,t),l(e,Yt,t),m(Ze,e,t),l(e,Nt,t),m(je,e,t),l(e,St,t),l(e,ve,t),l(e,Pt,t),m(Ue,e,t),l(e,Dt,t),l(e,ke,t),l(e,Kt,t),m(Re,e,t),l(e,Ot,t),m(Be,e,t),l(e,ea,t),l(e,Ce,t),l(e,ta,t),l(e,Ie,t),l(e,aa,t),m(Le,e,t),l(e,la,t),l(e,We,t),l(e,sa,t),m(Ge,e,t),l(e,na,t),l(e,Ae,t),l(e,ia,t),m(Xe,e,t),l(e,oa,t),l(e,Qe,t),l(e,ra,t),l(e,Ve,t),l(e,pa,t),m(qe,e,t),l(e,da,t),l(e,He,t),ma=!0},p(e,[t]){const Pa={};t&2&&(Pa.$$scope={dirty:t,ctx:e}),g.$set(Pa);const Da={};t&2&&(Da.$$scope={dirty:t,ctx:e}),J.$set(Da)},i(e){ma||(h(_.$$.fragment,e),h(j.$$.fragment,e),h(k.$$.fragment,e),h(B.$$.fragment,e),h(C.$$.fragment,e),h(W.$$.fragment,e),h(A.$$.fragment,e),h(Q.$$.fragment,e),h(V.$$.fragment,e),h(H.$$.fragment,e),h(z.$$.fragment,e),h(g.$$.fragment,e),h(P.$$.fragment,e),h(K.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(se.$$.fragment,e),h(ie.$$.fragment,e),h(oe.$$.fragment,e),h(pe.$$.fragment,e),h(he.$$.fragment,e),h(ue.$$.fragment,e),h(Me.$$.fragment,e),h(Te.$$.fragment,e),h(ge.$$.fragment,e),h(_e.$$.fragment,e),h(J.$$.fragment,e),h(Ze.$$.fragment,e),h(je.$$.fragment,e),h(Ue.$$.fragment,e),h(Re.$$.fragment,e),h(Be.$$.fragment,e),h(Le.$$.fragment,e),h(Ge.$$.fragment,e),h(Xe.$$.fragment,e),h(qe.$$.fragment,e),ma=!0)},o(e){f(_.$$.fragment,e),f(j.$$.fragment,e),f(k.$$.fragment,e),f(B.$$.fragment,e),f(C.$$.fragment,e),f(W.$$.fragment,e),f(A.$$.fragment,e),f(Q.$$.fragment,e),f(V.$$.fragment,e),f(H.$$.fragment,e),f(z.$$.fragment,e),f(g.$$.fragment,e),f(P.$$.fragment,e),f(K.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(ae.$$.fragment,e),f(se.$$.fragment,e),f(ie.$$.fragment,e),f(oe.$$.fragment,e),f(pe.$$.fragment,e),f(he.$$.fragment,e),f(ue.$$.fragment,e),f(Me.$$.fragment,e),f(Te.$$.fragment,e),f(ge.$$.fragment,e),f(_e.$$.fragment,e),f(J.$$.fragment,e),f(Ze.$$.fragment,e),f(je.$$.fragment,e),f(Ue.$$.fragment,e),f(Re.$$.fragment,e),f(Be.$$.fragment,e),f(Le.$$.fragment,e),f(Ge.$$.fragment,e),f(Xe.$$.fragment,e),f(qe.$$.fragment,e),ma=!1},d(e){e&&(a(T),a(y),a(b),a(xe),a($),a(ze),a(Z),a(Ee),a(Ye),a(v),a(Ne),a(U),a(Se),a(Pe),a(R),a(De),a(Ke),a(Oe),a(I),a(et),a(L),a(tt),a(at),a(G),a(lt),a(st),a(X),a(nt),a(it),a(ot),a(q),a(rt),a(F),a(pt),a(dt),a(x),a(mt),a(ht),a(E),a(ft),a(Y),a(ut),a(N),a(ct),a(S),a(Mt),a(yt),a(wt),a(D),a(Tt),a(bt),a(gt),a(ee),a(Jt),a(_t),a($t),a(le),a(Zt),a(jt),a(ne),a(vt),a(Ut),a(kt),a(re),a(Rt),a(Bt),a(de),a(Ct),a(me),a(It),a(Lt),a(fe),a(Wt),a(Gt),a(ce),a(At),a(Xt),a(ye),a(Qt),a(we),a(Vt),a(qt),a(be),a(Ft),a(Ht),a(Je),a(xt),a(zt),a(Et),a($e),a(Yt),a(Nt),a(St),a(ve),a(Pt),a(Dt),a(ke),a(Kt),a(Ot),a(ea),a(Ce),a(ta),a(Ie),a(aa),a(la),a(We),a(sa),a(na),a(Ae),a(ia),a(oa),a(Qe),a(ra),a(Ve),a(pa),a(da),a(He)),a(c),u(_,e),u(j,e),u(k,e),u(B,e),u(C,e),u(W,e),u(A,e),u(Q,e),u(V,e),u(H,e),u(z,e),u(g,e),u(P,e),u(K,e),u(O,e),u(te,e),u(ae,e),u(se,e),u(ie,e),u(oe,e),u(pe,e),u(he,e),u(ue,e),u(Me,e),u(Te,e),u(ge,e),u(_e,e),u(J,e),u(Ze,e),u(je,e),u(Ue,e),u(Re,e),u(Be,e),u(Le,e),u(Ge,e),u(Xe,e),u(qe,e)}}}const hl='{"title":"LoRA","local":"lora","sections":[{"title":"Initialization","local":"initialization","sections":[{"title":"PiSSA","local":"pissa","sections":[],"depth":3},{"title":"LoftQ","local":"loftq","sections":[{"title":"Standard approach","local":"standard-approach","sections":[],"depth":4},{"title":"A more convienient way","local":"a-more-convienient-way","sections":[],"depth":4}],"depth":3},{"title":"Rank-stabilized LoRA","local":"rank-stabilized-lora","sections":[],"depth":3},{"title":"Weight-Decomposed Low-Rank Adaptation (DoRA)","local":"weight-decomposed-low-rank-adaptation-dora","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":4}],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3},{"title":"Memory efficient Layer Replication with LoRA","local":"memory-efficient-layer-replication-with-lora","sections":[],"depth":3}],"depth":2},{"title":"Merge adapters","local":"merge-adapters","sections":[],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[],"depth":2},{"title":"Inference with different LoRA adapters in the same batch","local":"inference-with-different-lora-adapters-in-the-same-batch","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":3}],"depth":2}],"depth":1}';function fl(Fe){return ll(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tl extends sl{constructor(c){super(),nl(this,c,fl,ml,al,{})}}export{Tl as component};
