import{s as wl,o as gl,n as Ul}from"../chunks/scheduler.7da89386.js";import{S as bl,i as Jl,g as i,s,r,A as Tl,h as o,f as l,c as n,j as yl,u,x as p,k as Zt,y as vl,a,v as d,d as h,t as m,w as M}from"../chunks/index.20910acc.js";import{T as fl}from"../chunks/Tip.53e22153.js";import{C as w}from"../chunks/CodeBlock.cde23137.js";import{H as f,E as jl}from"../chunks/EditOnGithub.ba36cbd0.js";function Cl(je){let c,U="Without specifying a device, the default for model inference will be the first GPU on the machine if one is available, and else CPU. If you want to use a specific device you can pass <code>device</code> to <code>compute</code> where -1 will use the GPU and a positive integer (starting with 0) will use the associated CUDA device.";return{c(){c=i("p"),c.innerHTML=U},l(y){c=o(y,"P",{"data-svelte-h":!0}),p(c)!=="svelte-9djnxx"&&(c.innerHTML=U)},m(y,g){a(y,c,g)},p:Ul,d(y){y&&l(c)}}}function xl(je){let c,U="The time performances can give useful indication on model speed for inference but should be taken with a grain of salt: they include all the processing that goes on in the pipeline. This may include tokenizing, post-processing, that may be different depending on the model. Furthermore, it depends a lot on the hardware you are running the evaluation on and you may be able to improve the performance by optimizing things like the batch size.";return{c(){c=i("p"),c.textContent=U},l(y){c=o(y,"P",{"data-svelte-h":!0}),p(c)!=="svelte-1etb7h"&&(c.textContent=U)},m(y,g){a(y,c,g)},p:Ul,d(y){y&&l(c)}}}function Il(je){let c,U,y,g,v,xe,j,Wt='The <code>Evaluator</code> classes allow to evaluate a  triplet of model, dataset, and metric. The models wrapped in a pipeline, responsible for handling all preprocessing and post-processing and out-of-the-box, <code>Evaluator</code>s support transformers pipelines for the supported tasks, but custom pipelines can be passed, as showcased in the section <a href="custom_evaluator">Using the <code>evaluator</code> with custom pipelines</a>.',Ie,C,qt="Currently supported tasks are:",_e,x,Gt='<li><code>&quot;text-classification&quot;</code>: will use the <a href="/docs/evaluate/main/en/package_reference/evaluator_classes#evaluate.TextClassificationEvaluator">TextClassificationEvaluator</a>.</li> <li><code>&quot;token-classification&quot;</code>: will use the <a href="/docs/evaluate/main/en/package_reference/evaluator_classes#evaluate.TokenClassificationEvaluator">TokenClassificationEvaluator</a>.</li> <li><code>&quot;question-answering&quot;</code>: will use the <a href="/docs/evaluate/main/en/package_reference/evaluator_classes#evaluate.QuestionAnsweringEvaluator">QuestionAnsweringEvaluator</a>.</li> <li><code>&quot;image-classification&quot;</code>: will use the <a href="/docs/evaluate/main/en/package_reference/evaluator_classes#evaluate.ImageClassificationEvaluator">ImageClassificationEvaluator</a>.</li> <li><code>&quot;text-generation&quot;</code>: will use the <a href="/docs/evaluate/main/en/package_reference/evaluator_classes#evaluate.TextGenerationEvaluator">TextGenerationEvaluator</a>.</li> <li><code>&quot;text2text-generation&quot;</code>: will use the <a href="/docs/evaluate/main/en/package_reference/evaluator_classes#evaluate.Text2TextGenerationEvaluator">Text2TextGenerationEvaluator</a>.</li> <li><code>&quot;summarization&quot;</code>: will use the <a href="/docs/evaluate/main/en/package_reference/evaluator_classes#evaluate.SummarizationEvaluator">SummarizationEvaluator</a>.</li> <li><code>&quot;translation&quot;</code>: will use the <a href="/docs/evaluate/main/en/package_reference/evaluator_classes#evaluate.TranslationEvaluator">TranslationEvaluator</a>.</li> <li><code>&quot;automatic-speech-recognition&quot;</code>: will use the <a href="/docs/evaluate/main/en/package_reference/evaluator_classes#evaluate.AutomaticSpeechRecognitionEvaluator">AutomaticSpeechRecognitionEvaluator</a>.</li> <li><code>&quot;audio-classification&quot;</code>: will use the <a href="/docs/evaluate/main/en/package_reference/evaluator_classes#evaluate.AudioClassificationEvaluator">AudioClassificationEvaluator</a>.</li>',ke,I,Bt='To run an <code>Evaluator</code> with several tasks in a single call, use the <a href="evaluation_suite">EvaluationSuite</a>, which runs evaluations on a collection of <code>SubTask</code>s.',$e,_,Et="Each task has its own set of requirements for the dataset format and pipeline output, make sure to check them out for your custom use case. Let’s have a look at some of them and see how you can use the evaluator to evalute a single or multiple of models, datasets, and metrics at the same time.",Ze,k,We,$,Qt="The text classification evaluator can be used to evaluate text models on classification datasets such as IMDb. Beside the model, data, and metric inputs it takes the following optional inputs:",qe,Z,Rt="<li><code>input_column=&quot;text&quot;</code>: with this argument the column with the data for the pipeline can be specified.</li> <li><code>label_column=&quot;label&quot;</code>: with this argument the column with the labels for the evaluation can be specified.</li> <li><code>label_mapping=None</code>: the label mapping aligns the labels in the pipeline output with the labels need for evaluation. E.g. the labels in <code>label_column</code> can be integers (<code>0</code>/<code>1</code>) whereas the pipeline can produce label names such as <code>&quot;positive&quot;</code>/<code>&quot;negative&quot;</code>. With that dictionary the pipeline outputs are mapped to the labels.</li>",Ge,W,Xt="By default the <code>&quot;accuracy&quot;</code> metric is computed.",Be,q,Ee,G,Yt="There are several ways to pass a model to the evaluator: you can pass the name of a model on the Hub, you can load a <code>transformers</code> model and pass it to the evaluator or you can pass an initialized <code>transformers.Pipeline</code>. Alternatively you can pass any callable function that behaves like a <code>pipeline</code> call for the task in any framework.",Qe,B,St="So any of the following works:",Re,E,Xe,b,Ye,Q,Vt="The results will look as follows:",Se,R,Ve,X,Nt="Note that evaluation results include both the requested metric, and information about the time it took to obtain predictions through the pipeline.",Ne,J,ze,Y,Fe,S,zt='With the <a href="/docs/evaluate/main/en/package_reference/main_classes#evaluate.combine">combine()</a> function one can bundle several metrics into an object that behaves like a single metric. We can use this to evaluate several metrics at once with the evaluator:',Ae,V,He,N,Ft="The results will look as follows:",Le,z,De,F,At="Next let’s have a look at token classification.",Pe,A,Ke,H,Ht="With the token classification evaluator one can evaluate models for tasks such as NER or POS tagging. It has the following specific arguments:",Oe,L,Lt="<li><code>input_column=&quot;text&quot;</code>: with this argument the column with the data for the pipeline can be specified.</li> <li><code>label_column=&quot;label&quot;</code>: with this argument the column with the labels for the evaluation can be specified.</li> <li><code>label_mapping=None</code>: the label mapping aligns the labels in the pipeline output with the labels need for evaluation. E.g. the labels in <code>label_column</code> can be integers (<code>0</code>/<code>1</code>) whereas the pipeline can produce label names such as <code>&quot;positive&quot;</code>/<code>&quot;negative&quot;</code>. With that dictionary the pipeline outputs are mapped to the labels.</li> <li><code>join_by=&quot; &quot;</code>: While most datasets are already tokenized the pipeline expects a string. Thus the tokens need to be joined before passing to the pipeline. By default they are joined with a whitespace.</li>",et,D,Dt="Let’s have a look how we can use the evaluator to benchmark several models.",tt,P,lt,K,Pt="Here is an example where several models can be compared thanks to the <code>evaluator</code> in only a few lines of code, abstracting away the preprocessing, inference, postprocessing, metric computation:",at,O,st,ee,Kt="The result is a table that looks like this:",nt,te,Ot='<thead><tr><th align="left">model</th> <th align="right">overall_f1</th> <th align="right">overall_accuracy</th> <th align="right">total_time_in_seconds</th> <th align="right">samples_per_second</th> <th align="right">latency_in_seconds</th></tr></thead> <tbody><tr><td align="left">Jorgeutd/albert-base-v2-finetuned-ner</td> <td align="right">0.941</td> <td align="right">0.989</td> <td align="right">4.515</td> <td align="right">221.468</td> <td align="right">0.005</td></tr> <tr><td align="left">dbmdz/bert-large-cased-finetuned-conll03-english</td> <td align="right">0.962</td> <td align="right">0.881</td> <td align="right">11.648</td> <td align="right">85.850</td> <td align="right">0.012</td></tr> <tr><td align="left">dbmdz/electra-large-discriminator-finetuned-conll03-english</td> <td align="right">0.965</td> <td align="right">0.881</td> <td align="right">11.456</td> <td align="right">87.292</td> <td align="right">0.011</td></tr> <tr><td align="left">elastic/distilbert-base-uncased-finetuned-conll03-english</td> <td align="right">0.940</td> <td align="right">0.989</td> <td align="right">2.318</td> <td align="right">431.378</td> <td align="right">0.002</td></tr> <tr><td align="left">gunghio/distilbert-base-multilingual-cased-finetuned-conll2003-ner</td> <td align="right">0.947</td> <td align="right">0.991</td> <td align="right">2.376</td> <td align="right">420.873</td> <td align="right">0.002</td></tr> <tr><td align="left">philschmid/distilroberta-base-ner-conll2003</td> <td align="right">0.961</td> <td align="right">0.994</td> <td align="right">2.436</td> <td align="right">410.579</td> <td align="right">0.002</td></tr> <tr><td align="left">xlm-roberta-large-finetuned-conll03-english</td> <td align="right">0.969</td> <td align="right">0.882</td> <td align="right">11.996</td> <td align="right">83.359</td> <td align="right">0.012</td></tr></tbody>',it,le,ot,ae,el="You can feed in the <code>results</code> list above into the <code>plot_radar()</code> function to visualize different aspects of their performance and choose the model that is the best fit, depending on the metric(s) that are relevant to your use case:",pt,se,ct,T,tl='<img src="https://huggingface.co/datasets/evaluate/media/resolve/main/viz.png" width="400"/>',rt,ne,ll="Don’t forget to specify <code>invert_range</code> for metrics for which smaller is better (such as the case for latency in seconds).",ut,ie,al="If you want to save the plot locally, you can use the <code>plot.savefig()</code> function with the option <code>bbox_inches=&#39;tight&#39;</code>, to make sure no part of the image gets cut off.",dt,oe,ht,pe,sl="With the question-answering evaluator one can evaluate models for QA without needing to worry about the complicated pre- and post-processing that’s required for these models. It has the following specific arguments:",mt,ce,nl="<li><code>question_column=&quot;question&quot;</code>: the name of the column containing the question in the dataset</li> <li><code>context_column=&quot;context&quot;</code>: the name of the column containing the context</li> <li><code>id_column=&quot;id&quot;</code>: the name of the column cointaing the identification field of the question and answer pair</li> <li><code>label_column=&quot;answers&quot;</code>: the name of the column containing the answers</li> <li><code>squad_v2_format=None</code>: whether the dataset follows the format of squad_v2 dataset where a question may have no answer in the context. If this parameter is not provided, the format will be automatically inferred.</li>",Mt,re,il="Let’s have a look how we can evaluate QA models and compute confidence intervals at the same time.",yt,ue,ft,de,ol='Every evaluator comes with the options to compute confidence intervals using <a href="https://docs.scipy.org/doc/scipy/reference/generated/scipy.stats.bootstrap.html" rel="nofollow">bootstrapping</a>. Simply pass <code>strategy=&quot;bootstrap&quot;</code> and set the number of resanmples with <code>n_resamples</code>.',Ut,he,wt,me,pl="Results include confidence intervals as well as error estimates as follows:",gt,Me,bt,ye,Jt,fe,cl="With the image classification evaluator we can evaluate any image classifier. It uses the same keyword arguments at the text classifier:",Tt,Ue,rl="<li><code>input_column=&quot;image&quot;</code>: the name of the column containing the images as PIL ImageFile</li> <li><code>label_column=&quot;label&quot;</code>: the name of the column containing the labels</li> <li><code>label_mapping=None</code>: We want to map class labels defined by the model in the pipeline to values consistent with those defined in the <code>label_column</code></li>",vt,we,ul="Let’s have a look at how can evaluate image classification models on large datasets.",jt,ge,Ct,be,dl="The evaluator can be used on large datasets! Below, an example shows how to use it on ImageNet-1k for image classification. Beware that this example will require to download ~150 GB.",xt,Je,It,Te,hl="Since we are using <code>datasets</code> to store data we make use of a technique called memory mappings. This means that the dataset is never fully loaded into memory which saves a lot of RAM. Running the above code only uses roughly 1.5 GB of RAM while the validation split is more than 30 GB big.",_t,ve,kt,Ce,$t;return v=new f({props:{title:"Using the evaluator",local:"using-the-evaluator",headingTag:"h1"}}),k=new f({props:{title:"Text classification",local:"text-classification",headingTag:"h2"}}),q=new f({props:{title:"Evaluate models on the Hub",local:"evaluate-models-on-the-hub",headingTag:"h3"}}),E=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMGV2YWx1YXRlJTIwaW1wb3J0JTIwZXZhbHVhdG9yJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBwaXBlbGluZSUwQSUwQWRhdGElMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTIydGVzdCUyMikuc2h1ZmZsZShzZWVkJTNENDIpLnNlbGVjdChyYW5nZSgxMDAwKSklMEF0YXNrX2V2YWx1YXRvciUyMCUzRCUyMGV2YWx1YXRvciglMjJ0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyKSUwQSUwQSUyMyUyMDEuJTIwUGFzcyUyMGElMjBtb2RlbCUyMG5hbWUlMjBvciUyMHBhdGglMEFldmFsX3Jlc3VsdHMlMjAlM0QlMjB0YXNrX2V2YWx1YXRvci5jb21wdXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsX29yX3BpcGVsaW5lJTNEJTIybHZ3ZXJyYSUyRmRpc3RpbGJlcnQtaW1kYiUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGElM0RkYXRhJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxfbWFwcGluZyUzRCU3QiUyMk5FR0FUSVZFJTIyJTNBJTIwMCUyQyUyMCUyMlBPU0lUSVZFJTIyJTNBJTIwMSU3RCUwQSklMEElMEElMjMlMjAyLiUyMFBhc3MlMjBhbiUyMGluc3RhbnRpYXRlZCUyMG1vZGVsJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJsdndlcnJhJTJGZGlzdGlsYmVydC1pbWRiJTIyKSUwQSUwQWV2YWxfcmVzdWx0cyUyMCUzRCUyMHRhc2tfZXZhbHVhdG9yLmNvbXB1dGUoJTBBJTIwJTIwJTIwJTIwbW9kZWxfb3JfcGlwZWxpbmUlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGRhdGElM0RkYXRhJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxfbWFwcGluZyUzRCU3QiUyMk5FR0FUSVZFJTIyJTNBJTIwMCUyQyUyMCUyMlBPU0lUSVZFJTIyJTNBJTIwMSU3RCUwQSklMEElMEElMjMlMjAzLiUyMFBhc3MlMjBhbiUyMGluc3RhbnRpYXRlZCUyMHBpcGVsaW5lJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmx2d2VycmElMkZkaXN0aWxiZXJ0LWltZGIlMjIpJTBBJTBBZXZhbF9yZXN1bHRzJTIwJTNEJTIwdGFza19ldmFsdWF0b3IuY29tcHV0ZSglMEElMjAlMjAlMjAlMjBtb2RlbF9vcl9waXBlbGluZSUzRHBpcGUlMkMlMEElMjAlMjAlMjAlMjBkYXRhJTNEZGF0YSUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX21hcHBpbmclM0QlN0IlMjJORUdBVElWRSUyMiUzQSUyMDAlMkMlMjAlMjJQT1NJVElWRSUyMiUzQSUyMDElN0QlMEEpJTBBcHJpbnQoZXZhbF9yZXN1bHRzKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> evaluate <span class="hljs-keyword">import</span> evaluator
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, pipeline

data = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>).shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))
task_evaluator = evaluator(<span class="hljs-string">&quot;text-classification&quot;</span>)

<span class="hljs-comment"># 1. Pass a model name or path</span>
eval_results = task_evaluator.compute(
    model_or_pipeline=<span class="hljs-string">&quot;lvwerra/distilbert-imdb&quot;</span>,
    data=data,
    label_mapping={<span class="hljs-string">&quot;NEGATIVE&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;POSITIVE&quot;</span>: <span class="hljs-number">1</span>}
)

<span class="hljs-comment"># 2. Pass an instantiated model</span>
model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;lvwerra/distilbert-imdb&quot;</span>)

eval_results = task_evaluator.compute(
    model_or_pipeline=model,
    data=data,
    label_mapping={<span class="hljs-string">&quot;NEGATIVE&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;POSITIVE&quot;</span>: <span class="hljs-number">1</span>}
)

<span class="hljs-comment"># 3. Pass an instantiated pipeline</span>
pipe = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=<span class="hljs-string">&quot;lvwerra/distilbert-imdb&quot;</span>)

eval_results = task_evaluator.compute(
    model_or_pipeline=pipe,
    data=data,
    label_mapping={<span class="hljs-string">&quot;NEGATIVE&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;POSITIVE&quot;</span>: <span class="hljs-number">1</span>}
)
<span class="hljs-built_in">print</span>(eval_results)`,wrap:!1}}),b=new fl({props:{$$slots:{default:[Cl]},$$scope:{ctx:je}}}),R=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJ2FjY3VyYWN5JyUzQSUyMDAuOTE4JTJDJTBBJTIwJTIwJTIwJTIwJ2xhdGVuY3lfaW5fc2Vjb25kcyclM0ElMjAwLjAxMyUyQyUwQSUyMCUyMCUyMCUyMCdzYW1wbGVzX3Blcl9zZWNvbmQnJTNBJTIwNzguODg3JTJDJTBBJTIwJTIwJTIwJTIwJ3RvdGFsX3RpbWVfaW5fc2Vjb25kcyclM0ElMjAxMi42NzYlMEElN0Q=",highlighted:`{
    <span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.918</span>,
    <span class="hljs-string">&#x27;latency_in_seconds&#x27;</span>: <span class="hljs-number">0.013</span>,
    <span class="hljs-string">&#x27;samples_per_second&#x27;</span>: <span class="hljs-number">78.887</span>,
    <span class="hljs-string">&#x27;total_time_in_seconds&#x27;</span>: <span class="hljs-number">12.676</span>
}`,wrap:!1}}),J=new fl({props:{$$slots:{default:[xl]},$$scope:{ctx:je}}}),Y=new f({props:{title:"Evaluate multiple metrics",local:"evaluate-multiple-metrics",headingTag:"h3"}}),V=new w({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFldmFsX3Jlc3VsdHMlMjAlM0QlMjB0YXNrX2V2YWx1YXRvci5jb21wdXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsX29yX3BpcGVsaW5lJTNEJTIybHZ3ZXJyYSUyRmRpc3RpbGJlcnQtaW1kYiUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGElM0RkYXRhJTJDJTBBJTIwJTIwJTIwJTIwbWV0cmljJTNEZXZhbHVhdGUuY29tYmluZSglNUIlMjJhY2N1cmFjeSUyMiUyQyUyMCUyMnJlY2FsbCUyMiUyQyUyMCUyMnByZWNpc2lvbiUyMiUyQyUyMCUyMmYxJTIyJTVEKSUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX21hcHBpbmclM0QlN0IlMjJORUdBVElWRSUyMiUzQSUyMDAlMkMlMjAlMjJQT1NJVElWRSUyMiUzQSUyMDElN0QlMEEpJTBBcHJpbnQoZXZhbF9yZXN1bHRzKSUwQQ==",highlighted:`<span class="hljs-keyword">import</span> evaluate

eval_results = task_evaluator.compute(
    model_or_pipeline=<span class="hljs-string">&quot;lvwerra/distilbert-imdb&quot;</span>,
    data=data,
    metric=evaluate.combine([<span class="hljs-string">&quot;accuracy&quot;</span>, <span class="hljs-string">&quot;recall&quot;</span>, <span class="hljs-string">&quot;precision&quot;</span>, <span class="hljs-string">&quot;f1&quot;</span>]),
    label_mapping={<span class="hljs-string">&quot;NEGATIVE&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;POSITIVE&quot;</span>: <span class="hljs-number">1</span>}
)
<span class="hljs-built_in">print</span>(eval_results)
`,wrap:!1}}),z=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJ2FjY3VyYWN5JyUzQSUyMDAuOTE4JTJDJTBBJTIwJTIwJTIwJTIwJ2YxJyUzQSUyMDAuOTE2JTJDJTBBJTIwJTIwJTIwJTIwJ3ByZWNpc2lvbiclM0ElMjAwLjkxNDclMkMlMEElMjAlMjAlMjAlMjAncmVjYWxsJyUzQSUyMDAuOTE4NyUyQyUwQSUyMCUyMCUyMCUyMCdsYXRlbmN5X2luX3NlY29uZHMnJTNBJTIwMC4wMTMlMkMlMEElMjAlMjAlMjAlMjAnc2FtcGxlc19wZXJfc2Vjb25kJyUzQSUyMDc4Ljg4NyUyQyUwQSUyMCUyMCUyMCUyMCd0b3RhbF90aW1lX2luX3NlY29uZHMnJTNBJTIwMTIuNjc2JTBBJTdE",highlighted:`{
    <span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.918</span>,
    <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.916</span>,
    <span class="hljs-string">&#x27;precision&#x27;</span>: <span class="hljs-number">0.9147</span>,
    <span class="hljs-string">&#x27;recall&#x27;</span>: <span class="hljs-number">0.9187</span>,
    <span class="hljs-string">&#x27;latency_in_seconds&#x27;</span>: <span class="hljs-number">0.013</span>,
    <span class="hljs-string">&#x27;samples_per_second&#x27;</span>: <span class="hljs-number">78.887</span>,
    <span class="hljs-string">&#x27;total_time_in_seconds&#x27;</span>: <span class="hljs-number">12.676</span>
}`,wrap:!1}}),A=new f({props:{title:"Token Classification",local:"token-classification",headingTag:"h2"}}),P=new f({props:{title:"Benchmarking several models",local:"benchmarking-several-models",headingTag:"h3"}}),O=new w({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjBldmFsdWF0ZSUyMGltcG9ydCUyMGV2YWx1YXRvciUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQW1vZGVscyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnhsbS1yb2JlcnRhLWxhcmdlLWZpbmV0dW5lZC1jb25sbDAzLWVuZ2xpc2glMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJkYm1keiUyRmJlcnQtbGFyZ2UtY2FzZWQtZmluZXR1bmVkLWNvbmxsMDMtZW5nbGlzaCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmVsYXN0aWMlMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtY29ubGwwMy1lbmdsaXNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZGJtZHolMkZlbGVjdHJhLWxhcmdlLWRpc2NyaW1pbmF0b3ItZmluZXR1bmVkLWNvbmxsMDMtZW5nbGlzaCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmd1bmdoaW8lMkZkaXN0aWxiZXJ0LWJhc2UtbXVsdGlsaW5ndWFsLWNhc2VkLWZpbmV0dW5lZC1jb25sbDIwMDMtbmVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIycGhpbHNjaG1pZCUyRmRpc3RpbHJvYmVydGEtYmFzZS1uZXItY29ubGwyMDAzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIySm9yZ2V1dGQlMkZhbGJlcnQtYmFzZS12Mi1maW5ldHVuZWQtbmVyJTIyJTJDJTBBJTVEJTBBJTBBZGF0YSUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJjb25sbDIwMDMlMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpLnNodWZmbGUoKS5zZWxlY3QocmFuZ2UoMTAwMCkpJTBBdGFza19ldmFsdWF0b3IlMjAlM0QlMjBldmFsdWF0b3IoJTIydG9rZW4tY2xhc3NpZmljYXRpb24lMjIpJTBBJTBBcmVzdWx0cyUyMCUzRCUyMCU1QiU1RCUwQWZvciUyMG1vZGVsJTIwaW4lMjBtb2RlbHMlM0ElMEElMjAlMjAlMjAlMjByZXN1bHRzLmFwcGVuZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXNrX2V2YWx1YXRvci5jb21wdXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsX29yX3BpcGVsaW5lJTNEbW9kZWwlMkMlMjBkYXRhJTNEZGF0YSUyQyUyMG1ldHJpYyUzRCUyMnNlcWV2YWwlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQWRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lKHJlc3VsdHMlMkMlMjBpbmRleCUzRG1vZGVscyklMEFkZiU1QiU1QiUyMm92ZXJhbGxfZjElMjIlMkMlMjAlMjJvdmVyYWxsX2FjY3VyYWN5JTIyJTJDJTIwJTIydG90YWxfdGltZV9pbl9zZWNvbmRzJTIyJTJDJTIwJTIyc2FtcGxlc19wZXJfc2Vjb25kJTIyJTJDJTIwJTIybGF0ZW5jeV9pbl9zZWNvbmRzJTIyJTVEJTVE",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> evaluate <span class="hljs-keyword">import</span> evaluator
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

models = [
    <span class="hljs-string">&quot;xlm-roberta-large-finetuned-conll03-english&quot;</span>,
    <span class="hljs-string">&quot;dbmdz/bert-large-cased-finetuned-conll03-english&quot;</span>,
    <span class="hljs-string">&quot;elastic/distilbert-base-uncased-finetuned-conll03-english&quot;</span>,
    <span class="hljs-string">&quot;dbmdz/electra-large-discriminator-finetuned-conll03-english&quot;</span>,
    <span class="hljs-string">&quot;gunghio/distilbert-base-multilingual-cased-finetuned-conll2003-ner&quot;</span>,
    <span class="hljs-string">&quot;philschmid/distilroberta-base-ner-conll2003&quot;</span>,
    <span class="hljs-string">&quot;Jorgeutd/albert-base-v2-finetuned-ner&quot;</span>,
]

data = load_dataset(<span class="hljs-string">&quot;conll2003&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>).shuffle().select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))
task_evaluator = evaluator(<span class="hljs-string">&quot;token-classification&quot;</span>)

results = []
<span class="hljs-keyword">for</span> model <span class="hljs-keyword">in</span> models:
    results.append(
        task_evaluator.compute(
            model_or_pipeline=model, data=data, metric=<span class="hljs-string">&quot;seqeval&quot;</span>
            )
        )

df = pd.DataFrame(results, index=models)
df[[<span class="hljs-string">&quot;overall_f1&quot;</span>, <span class="hljs-string">&quot;overall_accuracy&quot;</span>, <span class="hljs-string">&quot;total_time_in_seconds&quot;</span>, <span class="hljs-string">&quot;samples_per_second&quot;</span>, <span class="hljs-string">&quot;latency_in_seconds&quot;</span>]]`,wrap:!1}}),le=new f({props:{title:"Visualizing results",local:"visualizing-results",headingTag:"h3"}}),se=new w({props:{code:"JTBBcGxvdCUyMCUzRCUyMHJhZGFyX3Bsb3QoZGF0YSUzRHJlc3VsdHMlMkMlMjBtb2RlbF9uYW1lcyUzRG1vZGVscyUyQyUyMGludmVydF9yYW5nZSUzRCU1QiUyMmxhdGVuY3lfaW5fc2Vjb25kcyUyMiU1RCklMEFwbG90LnNob3coKQ==",highlighted:`<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> evaluate.visualization <span class="hljs-keyword">import</span> radar_plot

<span class="hljs-meta">&gt;&gt;&gt; </span>plot = radar_plot(data=results, model_names=models, invert_range=[<span class="hljs-string">&quot;latency_in_seconds&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>plot.show()`,wrap:!1}}),oe=new f({props:{title:"Question Answering",local:"question-answering",headingTag:"h2"}}),ue=new f({props:{title:"Confidence intervals",local:"confidence-intervals",headingTag:"h3"}}),he=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMGV2YWx1YXRlJTIwaW1wb3J0JTIwZXZhbHVhdG9yJTBBJTBBdGFza19ldmFsdWF0b3IlMjAlM0QlMjBldmFsdWF0b3IoJTIycXVlc3Rpb24tYW5zd2VyaW5nJTIyKSUwQSUwQWRhdGElMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyc3F1YWQlMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lNUIlM0ExMDAwJTVEJTIyKSUwQWV2YWxfcmVzdWx0cyUyMCUzRCUyMHRhc2tfZXZhbHVhdG9yLmNvbXB1dGUoJTBBJTIwJTIwJTIwJTIwbW9kZWxfb3JfcGlwZWxpbmUlM0QlMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1kaXN0aWxsZWQtc3F1YWQlMjIlMkMlMEElMjAlMjAlMjAlMjBkYXRhJTNEZGF0YSUyQyUwQSUyMCUyMCUyMCUyMG1ldHJpYyUzRCUyMnNxdWFkJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3RyYXRlZ3klM0QlMjJib290c3RyYXAlMjIlMkMlMEElMjAlMjAlMjAlMjBuX3Jlc2FtcGxlcyUzRDMwJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> evaluate <span class="hljs-keyword">import</span> evaluator

task_evaluator = evaluator(<span class="hljs-string">&quot;question-answering&quot;</span>)

data = load_dataset(<span class="hljs-string">&quot;squad&quot;</span>, split=<span class="hljs-string">&quot;validation[:1000]&quot;</span>)
eval_results = task_evaluator.compute(
    model_or_pipeline=<span class="hljs-string">&quot;distilbert-base-uncased-distilled-squad&quot;</span>,
    data=data,
    metric=<span class="hljs-string">&quot;squad&quot;</span>,
    strategy=<span class="hljs-string">&quot;bootstrap&quot;</span>,
    n_resamples=<span class="hljs-number">30</span>
)`,wrap:!1}}),Me=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJ2V4YWN0X21hdGNoJyUzQSUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdjb25maWRlbmNlX2ludGVydmFsJyUzQSUyMCg3OS42NyUyQyUyMDg0LjU0KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdzY29yZSclM0ElMjA4Mi4zMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdzdGFuZGFyZF9lcnJvciclM0ElMjAxLjI4JTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJ2YxJyUzQSUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdjb25maWRlbmNlX2ludGVydmFsJyUzQSUyMCg4NS4zMCUyQyUyMDg4Ljg4KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdzY29yZSclM0ElMjA4Ny4yMyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdzdGFuZGFyZF9lcnJvciclM0ElMjAwLjk3JTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJ2xhdGVuY3lfaW5fc2Vjb25kcyclM0ElMjAwLjAwODUlMkMlMEElMjAlMjAlMjAlMjAnc2FtcGxlc19wZXJfc2Vjb25kJyUzQSUyMDExNy4zMSUyQyUwQSUyMCUyMCUyMCUyMCd0b3RhbF90aW1lX2luX3NlY29uZHMnJTNBJTIwOC41MiUwQSUyMCU3RA==",highlighted:`{
    <span class="hljs-string">&#x27;exact_match&#x27;</span>:
    {
        <span class="hljs-string">&#x27;confidence_interval&#x27;</span>: (<span class="hljs-number">79.67</span>, <span class="hljs-number">84.54</span>),
        <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">82.30</span>,
        <span class="hljs-string">&#x27;standard_error&#x27;</span>: <span class="hljs-number">1.28</span>
    },
    <span class="hljs-string">&#x27;f1&#x27;</span>:
    {
        <span class="hljs-string">&#x27;confidence_interval&#x27;</span>: (<span class="hljs-number">85.30</span>, <span class="hljs-number">88.88</span>),
        <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">87.23</span>,
        <span class="hljs-string">&#x27;standard_error&#x27;</span>: <span class="hljs-number">0.97</span>
    },
    <span class="hljs-string">&#x27;latency_in_seconds&#x27;</span>: <span class="hljs-number">0.0085</span>,
    <span class="hljs-string">&#x27;samples_per_second&#x27;</span>: <span class="hljs-number">117.31</span>,
    <span class="hljs-string">&#x27;total_time_in_seconds&#x27;</span>: <span class="hljs-number">8.52</span>
 }`,wrap:!1}}),ye=new f({props:{title:"Image classification",local:"image-classification",headingTag:"h2"}}),ge=new f({props:{title:"Handling large datasets",local:"handling-large-datasets",headingTag:"h3"}}),Je=new w({props:{code:"ZGF0YSUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJpbWFnZW5ldC0xayUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiUyQyUyMHRva2VuJTNEVHJ1ZSklMEElMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwdGFzayUzRCUyMmltYWdlLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJmYWNlYm9vayUyRmRlaXQtc21hbGwtZGlzdGlsbGVkLXBhdGNoMTYtMjI0JTIyJTBBKSUwQSUwQXRhc2tfZXZhbHVhdG9yJTIwJTNEJTIwZXZhbHVhdG9yKCUyMmltYWdlLWNsYXNzaWZpY2F0aW9uJTIyKSUwQWV2YWxfcmVzdWx0cyUyMCUzRCUyMHRhc2tfZXZhbHVhdG9yLmNvbXB1dGUoJTBBJTIwJTIwJTIwJTIwbW9kZWxfb3JfcGlwZWxpbmUlM0RwaXBlJTJDJTBBJTIwJTIwJTIwJTIwZGF0YSUzRGRhdGElMkMlMEElMjAlMjAlMjAlMjBtZXRyaWMlM0QlMjJhY2N1cmFjeSUyMiUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX21hcHBpbmclM0RwaXBlLm1vZGVsLmNvbmZpZy5sYWJlbDJpZCUwQSk=",highlighted:`data = load_dataset(<span class="hljs-string">&quot;imagenet-1k&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, token=<span class="hljs-literal">True</span>)

pipe = pipeline(
    task=<span class="hljs-string">&quot;image-classification&quot;</span>,
    model=<span class="hljs-string">&quot;facebook/deit-small-distilled-patch16-224&quot;</span>
)

task_evaluator = evaluator(<span class="hljs-string">&quot;image-classification&quot;</span>)
eval_results = task_evaluator.compute(
    model_or_pipeline=pipe,
    data=data,
    metric=<span class="hljs-string">&quot;accuracy&quot;</span>,
    label_mapping=pipe.model.config.label2id
)`,wrap:!1}}),ve=new jl({props:{source:"https://github.com/huggingface/evaluate/blob/main/docs/source/base_evaluator.mdx"}}),{c(){c=i("meta"),U=s(),y=i("p"),g=s(),r(v.$$.fragment),xe=s(),j=i("p"),j.innerHTML=Wt,Ie=s(),C=i("p"),C.textContent=qt,_e=s(),x=i("ul"),x.innerHTML=Gt,ke=s(),I=i("p"),I.innerHTML=Bt,$e=s(),_=i("p"),_.textContent=Et,Ze=s(),r(k.$$.fragment),We=s(),$=i("p"),$.textContent=Qt,qe=s(),Z=i("ul"),Z.innerHTML=Rt,Ge=s(),W=i("p"),W.innerHTML=Xt,Be=s(),r(q.$$.fragment),Ee=s(),G=i("p"),G.innerHTML=Yt,Qe=s(),B=i("p"),B.textContent=St,Re=s(),r(E.$$.fragment),Xe=s(),r(b.$$.fragment),Ye=s(),Q=i("p"),Q.textContent=Vt,Se=s(),r(R.$$.fragment),Ve=s(),X=i("p"),X.textContent=Nt,Ne=s(),r(J.$$.fragment),ze=s(),r(Y.$$.fragment),Fe=s(),S=i("p"),S.innerHTML=zt,Ae=s(),r(V.$$.fragment),He=s(),N=i("p"),N.textContent=Ft,Le=s(),r(z.$$.fragment),De=s(),F=i("p"),F.textContent=At,Pe=s(),r(A.$$.fragment),Ke=s(),H=i("p"),H.textContent=Ht,Oe=s(),L=i("ul"),L.innerHTML=Lt,et=s(),D=i("p"),D.textContent=Dt,tt=s(),r(P.$$.fragment),lt=s(),K=i("p"),K.innerHTML=Pt,at=s(),r(O.$$.fragment),st=s(),ee=i("p"),ee.textContent=Kt,nt=s(),te=i("table"),te.innerHTML=Ot,it=s(),r(le.$$.fragment),ot=s(),ae=i("p"),ae.innerHTML=el,pt=s(),r(se.$$.fragment),ct=s(),T=i("div"),T.innerHTML=tl,rt=s(),ne=i("p"),ne.innerHTML=ll,ut=s(),ie=i("p"),ie.innerHTML=al,dt=s(),r(oe.$$.fragment),ht=s(),pe=i("p"),pe.textContent=sl,mt=s(),ce=i("ul"),ce.innerHTML=nl,Mt=s(),re=i("p"),re.textContent=il,yt=s(),r(ue.$$.fragment),ft=s(),de=i("p"),de.innerHTML=ol,Ut=s(),r(he.$$.fragment),wt=s(),me=i("p"),me.textContent=pl,gt=s(),r(Me.$$.fragment),bt=s(),r(ye.$$.fragment),Jt=s(),fe=i("p"),fe.textContent=cl,Tt=s(),Ue=i("ul"),Ue.innerHTML=rl,vt=s(),we=i("p"),we.textContent=ul,jt=s(),r(ge.$$.fragment),Ct=s(),be=i("p"),be.textContent=dl,xt=s(),r(Je.$$.fragment),It=s(),Te=i("p"),Te.innerHTML=hl,_t=s(),r(ve.$$.fragment),kt=s(),Ce=i("p"),this.h()},l(e){const t=Tl("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(l),U=n(e),y=o(e,"P",{}),yl(y).forEach(l),g=n(e),u(v.$$.fragment,e),xe=n(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-qprdpr"&&(j.innerHTML=Wt),Ie=n(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-15teb2a"&&(C.textContent=qt),_e=n(e),x=o(e,"UL",{"data-svelte-h":!0}),p(x)!=="svelte-1srkakb"&&(x.innerHTML=Gt),ke=n(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-7bnn4r"&&(I.innerHTML=Bt),$e=n(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-4inrih"&&(_.textContent=Et),Ze=n(e),u(k.$$.fragment,e),We=n(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1gxq28j"&&($.textContent=Qt),qe=n(e),Z=o(e,"UL",{"data-svelte-h":!0}),p(Z)!=="svelte-1qzzvz5"&&(Z.innerHTML=Rt),Ge=n(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-15gevtk"&&(W.innerHTML=Xt),Be=n(e),u(q.$$.fragment,e),Ee=n(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-154vxj0"&&(G.innerHTML=Yt),Qe=n(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1b2vk7d"&&(B.textContent=St),Re=n(e),u(E.$$.fragment,e),Xe=n(e),u(b.$$.fragment,e),Ye=n(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-15lc2ym"&&(Q.textContent=Vt),Se=n(e),u(R.$$.fragment,e),Ve=n(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-15s0v89"&&(X.textContent=Nt),Ne=n(e),u(J.$$.fragment,e),ze=n(e),u(Y.$$.fragment,e),Fe=n(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1sfvd91"&&(S.innerHTML=zt),Ae=n(e),u(V.$$.fragment,e),He=n(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-15lc2ym"&&(N.textContent=Ft),Le=n(e),u(z.$$.fragment,e),De=n(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-dtvqwy"&&(F.textContent=At),Pe=n(e),u(A.$$.fragment,e),Ke=n(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-geubj8"&&(H.textContent=Ht),Oe=n(e),L=o(e,"UL",{"data-svelte-h":!0}),p(L)!=="svelte-1el9bak"&&(L.innerHTML=Lt),et=n(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1ufl7ls"&&(D.textContent=Dt),tt=n(e),u(P.$$.fragment,e),lt=n(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-yjocce"&&(K.innerHTML=Pt),at=n(e),u(O.$$.fragment,e),st=n(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-xdkq6d"&&(ee.textContent=Kt),nt=n(e),te=o(e,"TABLE",{"data-svelte-h":!0}),p(te)!=="svelte-w5xmg2"&&(te.innerHTML=Ot),it=n(e),u(le.$$.fragment,e),ot=n(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-105xi6e"&&(ae.innerHTML=el),pt=n(e),u(se.$$.fragment,e),ct=n(e),T=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(T)!=="svelte-gubqhj"&&(T.innerHTML=tl),rt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-6fiehk"&&(ne.innerHTML=ll),ut=n(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-13ag5wi"&&(ie.innerHTML=al),dt=n(e),u(oe.$$.fragment,e),ht=n(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1b3dqfk"&&(pe.textContent=sl),mt=n(e),ce=o(e,"UL",{"data-svelte-h":!0}),p(ce)!=="svelte-tbjiyo"&&(ce.innerHTML=nl),Mt=n(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-vay9sj"&&(re.textContent=il),yt=n(e),u(ue.$$.fragment,e),ft=n(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-mw7fge"&&(de.innerHTML=ol),Ut=n(e),u(he.$$.fragment,e),wt=n(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-x62g11"&&(me.textContent=pl),gt=n(e),u(Me.$$.fragment,e),bt=n(e),u(ye.$$.fragment,e),Jt=n(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-ksrm73"&&(fe.textContent=cl),Tt=n(e),Ue=o(e,"UL",{"data-svelte-h":!0}),p(Ue)!=="svelte-y0u0z3"&&(Ue.innerHTML=rl),vt=n(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-wu4hrz"&&(we.textContent=ul),jt=n(e),u(ge.$$.fragment,e),Ct=n(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-1ewtkuj"&&(be.textContent=dl),xt=n(e),u(Je.$$.fragment,e),It=n(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-1lgn5m5"&&(Te.innerHTML=hl),_t=n(e),u(ve.$$.fragment,e),kt=n(e),Ce=o(e,"P",{}),yl(Ce).forEach(l),this.h()},h(){Zt(c,"name","hf:doc:metadata"),Zt(c,"content",_l),Zt(T,"class","flex justify-center")},m(e,t){vl(document.head,c),a(e,U,t),a(e,y,t),a(e,g,t),d(v,e,t),a(e,xe,t),a(e,j,t),a(e,Ie,t),a(e,C,t),a(e,_e,t),a(e,x,t),a(e,ke,t),a(e,I,t),a(e,$e,t),a(e,_,t),a(e,Ze,t),d(k,e,t),a(e,We,t),a(e,$,t),a(e,qe,t),a(e,Z,t),a(e,Ge,t),a(e,W,t),a(e,Be,t),d(q,e,t),a(e,Ee,t),a(e,G,t),a(e,Qe,t),a(e,B,t),a(e,Re,t),d(E,e,t),a(e,Xe,t),d(b,e,t),a(e,Ye,t),a(e,Q,t),a(e,Se,t),d(R,e,t),a(e,Ve,t),a(e,X,t),a(e,Ne,t),d(J,e,t),a(e,ze,t),d(Y,e,t),a(e,Fe,t),a(e,S,t),a(e,Ae,t),d(V,e,t),a(e,He,t),a(e,N,t),a(e,Le,t),d(z,e,t),a(e,De,t),a(e,F,t),a(e,Pe,t),d(A,e,t),a(e,Ke,t),a(e,H,t),a(e,Oe,t),a(e,L,t),a(e,et,t),a(e,D,t),a(e,tt,t),d(P,e,t),a(e,lt,t),a(e,K,t),a(e,at,t),d(O,e,t),a(e,st,t),a(e,ee,t),a(e,nt,t),a(e,te,t),a(e,it,t),d(le,e,t),a(e,ot,t),a(e,ae,t),a(e,pt,t),d(se,e,t),a(e,ct,t),a(e,T,t),a(e,rt,t),a(e,ne,t),a(e,ut,t),a(e,ie,t),a(e,dt,t),d(oe,e,t),a(e,ht,t),a(e,pe,t),a(e,mt,t),a(e,ce,t),a(e,Mt,t),a(e,re,t),a(e,yt,t),d(ue,e,t),a(e,ft,t),a(e,de,t),a(e,Ut,t),d(he,e,t),a(e,wt,t),a(e,me,t),a(e,gt,t),d(Me,e,t),a(e,bt,t),d(ye,e,t),a(e,Jt,t),a(e,fe,t),a(e,Tt,t),a(e,Ue,t),a(e,vt,t),a(e,we,t),a(e,jt,t),d(ge,e,t),a(e,Ct,t),a(e,be,t),a(e,xt,t),d(Je,e,t),a(e,It,t),a(e,Te,t),a(e,_t,t),d(ve,e,t),a(e,kt,t),a(e,Ce,t),$t=!0},p(e,[t]){const ml={};t&2&&(ml.$$scope={dirty:t,ctx:e}),b.$set(ml);const Ml={};t&2&&(Ml.$$scope={dirty:t,ctx:e}),J.$set(Ml)},i(e){$t||(h(v.$$.fragment,e),h(k.$$.fragment,e),h(q.$$.fragment,e),h(E.$$.fragment,e),h(b.$$.fragment,e),h(R.$$.fragment,e),h(J.$$.fragment,e),h(Y.$$.fragment,e),h(V.$$.fragment,e),h(z.$$.fragment,e),h(A.$$.fragment,e),h(P.$$.fragment,e),h(O.$$.fragment,e),h(le.$$.fragment,e),h(se.$$.fragment,e),h(oe.$$.fragment,e),h(ue.$$.fragment,e),h(he.$$.fragment,e),h(Me.$$.fragment,e),h(ye.$$.fragment,e),h(ge.$$.fragment,e),h(Je.$$.fragment,e),h(ve.$$.fragment,e),$t=!0)},o(e){m(v.$$.fragment,e),m(k.$$.fragment,e),m(q.$$.fragment,e),m(E.$$.fragment,e),m(b.$$.fragment,e),m(R.$$.fragment,e),m(J.$$.fragment,e),m(Y.$$.fragment,e),m(V.$$.fragment,e),m(z.$$.fragment,e),m(A.$$.fragment,e),m(P.$$.fragment,e),m(O.$$.fragment,e),m(le.$$.fragment,e),m(se.$$.fragment,e),m(oe.$$.fragment,e),m(ue.$$.fragment,e),m(he.$$.fragment,e),m(Me.$$.fragment,e),m(ye.$$.fragment,e),m(ge.$$.fragment,e),m(Je.$$.fragment,e),m(ve.$$.fragment,e),$t=!1},d(e){e&&(l(U),l(y),l(g),l(xe),l(j),l(Ie),l(C),l(_e),l(x),l(ke),l(I),l($e),l(_),l(Ze),l(We),l($),l(qe),l(Z),l(Ge),l(W),l(Be),l(Ee),l(G),l(Qe),l(B),l(Re),l(Xe),l(Ye),l(Q),l(Se),l(Ve),l(X),l(Ne),l(ze),l(Fe),l(S),l(Ae),l(He),l(N),l(Le),l(De),l(F),l(Pe),l(Ke),l(H),l(Oe),l(L),l(et),l(D),l(tt),l(lt),l(K),l(at),l(st),l(ee),l(nt),l(te),l(it),l(ot),l(ae),l(pt),l(ct),l(T),l(rt),l(ne),l(ut),l(ie),l(dt),l(ht),l(pe),l(mt),l(ce),l(Mt),l(re),l(yt),l(ft),l(de),l(Ut),l(wt),l(me),l(gt),l(bt),l(Jt),l(fe),l(Tt),l(Ue),l(vt),l(we),l(jt),l(Ct),l(be),l(xt),l(It),l(Te),l(_t),l(kt),l(Ce)),l(c),M(v,e),M(k,e),M(q,e),M(E,e),M(b,e),M(R,e),M(J,e),M(Y,e),M(V,e),M(z,e),M(A,e),M(P,e),M(O,e),M(le,e),M(se,e),M(oe,e),M(ue,e),M(he,e),M(Me,e),M(ye,e),M(ge,e),M(Je,e),M(ve,e)}}}const _l='{"title":"Using the evaluator","local":"using-the-evaluator","sections":[{"title":"Text classification","local":"text-classification","sections":[{"title":"Evaluate models on the Hub","local":"evaluate-models-on-the-hub","sections":[],"depth":3},{"title":"Evaluate multiple metrics","local":"evaluate-multiple-metrics","sections":[],"depth":3}],"depth":2},{"title":"Token Classification","local":"token-classification","sections":[{"title":"Benchmarking several models","local":"benchmarking-several-models","sections":[],"depth":3},{"title":"Visualizing results","local":"visualizing-results","sections":[],"depth":3}],"depth":2},{"title":"Question Answering","local":"question-answering","sections":[{"title":"Confidence intervals","local":"confidence-intervals","sections":[],"depth":3}],"depth":2},{"title":"Image classification","local":"image-classification","sections":[{"title":"Handling large datasets","local":"handling-large-datasets","sections":[],"depth":3}],"depth":2}],"depth":1}';function kl(je){return gl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bl extends bl{constructor(c){super(),Jl(this,c,kl,Il,wl,{})}}export{Bl as component};
