import{s as pt,o as ht,n as Re}from"../chunks/scheduler.6062bdaf.js";import{S as ct,i as dt,g as i,s as n,r as c,A as ut,h as r,f as a,c as o,j as rt,u as d,x as h,k as Ve,y as wt,a as s,v as u,d as w,t as y,w as b}from"../chunks/index.4bca734e.js";import{T as Fe}from"../chunks/Tip.b9ac1f03.js";import{C as ae}from"../chunks/CodeBlock.fa01571c.js";import{H as ee,E as yt}from"../chunks/EditOnGithub.74ab2baa.js";function bt(M){let l,g=`To see a running example of a webhook server, check out the <a href="https://huggingface.co/spaces/spaces-ci-bot/webhook" rel="nofollow">Spaces CI Bot</a>
one. It is a Space that launches ephemeral environments when a PR is opened on a Space.`;return{c(){l=i("p"),l.innerHTML=g},l(p){l=r(p,"P",{"data-svelte-h":!0}),h(l)!=="svelte-18sko4t"&&(l.innerHTML=g)},m(p,f){s(p,l,f)},p:Re,d(p){p&&a(l)}}}function gt(M){let l,g=`This is an <a href="../package_reference/environment_variables#hfhubdisableexperimentalwarning">experimental feature</a>. This
means that we are still working on improving the API. Breaking changes might be introduced in the future without prior
notice. Make sure to pin the version of <code>huggingface_hub</code> in your requirements.`;return{c(){l=i("p"),l.innerHTML=g},l(p){l=r(p,"P",{"data-svelte-h":!0}),h(l)!=="svelte-fuzk6g"&&(l.innerHTML=g)},m(p,f){s(p,l,f)},p:Re,d(p){p&&a(l)}}}function ft(M){let l,g=`By default, the server is started at the end of your script. If you are running it in a notebook, you can start the
server manually by calling <code>decorated_function.run()</code>. Since a unique server is used, you only have to start the server
once even if you have multiple endpoints.`;return{c(){l=i("p"),l.innerHTML=g},l(p){l=r(p,"P",{"data-svelte-h":!0}),h(l)!=="svelte-1jc349n"&&(l.innerHTML=g)},m(p,f){s(p,l,f)},p:Re,d(p){p&&a(l)}}}function Mt(M){let l,g,p,f,U,se,v,Qe=`Webhooks are a foundation for MLOps-related features. They allow you to listen for new changes on specific repos or to
all repos belonging to particular users/organizations you’re interested in following. This guide will explain how to
leverage <code>huggingface_hub</code> to create a server listening to webhooks and deploy it to a Space. It assumes you are
familiar with the concept of webhooks on the Huggingface Hub. To learn more about webhooks themselves, you can read
this <a href="https://huggingface.co/docs/hub/webhooks" rel="nofollow">guide</a> first.`,ne,j,Xe=`The base class that we will use in this guide is <a href="/docs/huggingface_hub/v0.23.3/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a>. It is a class for easily configuring a server that
can receive webhooks from the Huggingface Hub. The server is based on a <a href="https://gradio.app/" rel="nofollow">Gradio</a> app. It has a UI
to display instructions for you or your users and an API to listen to webhooks.`,oe,m,le,T,ie,I,re,W,xe=`Implementing a webhook endpoint is as simple as decorating a function. Let’s see a first example to explain the main
concepts:`,pe,$,he,Z,Le="Save this snippet in a file called <code>&#39;app.py&#39;</code> and run it with <code>&#39;python app.py&#39;</code>. You should see a message like this:",ce,G,de,B,Ee="Good job! You just launched a webhook server! Let’s break down what happened exactly:",ue,C,Ne=`<li>By decorating a function with <a href="/docs/huggingface_hub/v0.23.3/en/package_reference/webhooks_server#huggingface_hub.webhook_endpoint">webhook_endpoint()</a>, a <a href="/docs/huggingface_hub/v0.23.3/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a> object has been created in the background.
As you can see, this server is a Gradio app running on <a href="http://127.0.0.1:7860" rel="nofollow">http://127.0.0.1:7860</a>. If you open this URL in your browser, you
will see a landing page with instructions about the registered webhooks.</li> <li>A Gradio app is a FastAPI server under the hood. A new POST route <code>/webhooks/trigger_training</code> has been added to it.
This is the route that will listen to webhooks and run the <code>trigger_training</code> function when triggered. FastAPI will
automatically parse the payload and pass it to the function as a <a href="/docs/huggingface_hub/v0.23.3/en/package_reference/webhooks_server#huggingface_hub.WebhookPayload">WebhookPayload</a> object. This is a <code>pydantic</code> object
that contains all the information about the event that triggered the webhook.</li> <li>The Gradio app also opened a tunnel to receive requests from the internet. This is the interesting part: you can
configure a Webhook on <a href="https://huggingface.co/settings/webhooks" rel="nofollow">https://huggingface.co/settings/webhooks</a> pointing to your local machine. This is useful for
debugging your webhook server and quickly iterating before deploying it to a Space.</li> <li>Finally, the logs also tell you that your server is currently not secured by a secret. This is not problematic for
local debugging but is to keep in mind for later.</li>`,we,k,ye,_,be,S,ze=`Now that you have a webhook server running, you want to configure a Webhook to start receiving messages.
Go to <a href="https://huggingface.co/settings/webhooks" rel="nofollow">https://huggingface.co/settings/webhooks</a>, click on “Add a new webhook” and configure your Webhook. Set the target
repositories you want to watch and the Webhook URL, here <code>https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_training</code>.`,ge,J,Pe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/configure_webhook.png"/>',fe,H,qe=`And that’s it! You can now trigger that webhook by updating the target repository (e.g. push a commit). Check the
Activity tab of your Webhook to see the events that have been triggered. Now that you have a working setup, you can
test it and quickly iterate. If you modify your code and restart the server, your public URL might change. Make sure
to update the webhook configuration on the Hub if needed.`,Me,Y,me,V,Ae=`Now that you have a working webhook server, the goal is to deploy it to a Space. Go to <a href="https://huggingface.co/new-space" rel="nofollow">https://huggingface.co/new-space</a>
to create a Space. Give it a name, select the Gradio SDK and click on “Create Space”. Upload your code to the Space
in a file called <code>app.py</code>. Your Space will start automatically! For more details about Spaces, please refer to this
<a href="https://huggingface.co/docs/hub/spaces-overview" rel="nofollow">guide</a>.`,Te,F,Oe=`Your webhook server is now running on a public Space. If most cases, you will want to secure it with a secret. Go to
your Space settings &gt; Section “Repository secrets” &gt; “Add a secret”. Set the <code>WEBHOOK_SECRET</code> environment variable to
the value of your choice. Go back to the <a href="https://huggingface.co/settings/webhooks" rel="nofollow">Webhooks settings</a> and set the
secret in the webhook configuration. Now, only requests with the correct secret will be accepted by your server.`,ke,R,Ke=`And this is it! Your Space is now ready to receive webhooks from the Hub. Please keep in mind that if you run the Space
on a free ‘cpu-basic’ hardware, it will be shut down after 48 hours of inactivity. If you need a permanent Space, you
should consider setting to an <a href="https://huggingface.co/docs/hub/spaces-gpus#hardware-specs" rel="nofollow">upgraded hardware</a>.`,Je,Q,Ue,X,De=`The guide above explained the quickest way to setup a <a href="/docs/huggingface_hub/v0.23.3/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a>. In this section, we will see how to customize
it further.`,ve,x,je,L,et=`You can register multiple endpoints on the same server. For example, you might want to have one endpoint to trigger
a training job and another one to trigger a model evaluation. You can do this by adding multiple <code>@webhook_endpoint</code>
decorators:`,Ie,E,We,N,tt="Which will create two endpoints:",$e,z,Ze,P,Ge,q,at=`To get more flexibility, you can also create a <a href="/docs/huggingface_hub/v0.23.3/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a> object directly. This is useful if you want to
customize the landing page of your server. You can do this by passing a <a href="https://gradio.app/docs/#blocks" rel="nofollow">Gradio UI</a>
that will overwrite the default one. For example, you can add instructions for your users or add a form to manually
trigger the webhooks. When creating a <a href="/docs/huggingface_hub/v0.23.3/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a>, you can register new webhooks using the
<code>add_webhook()</code> decorator.`,Be,A,st="Here is a complete example:",Ce,O,_e,K,nt=`<li>We define a custom UI using Gradio blocks. This UI will be displayed on the landing page of the server.</li> <li>We create a <a href="/docs/huggingface_hub/v0.23.3/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a> object with a custom UI and a secret. The secret is optional and can be set with
the <code>WEBHOOK_SECRET</code> environment variable.</li> <li>We register a webhook with an explicit name. This will create an endpoint at <code>/webhooks/say_hello</code>.</li> <li>We register a webhook with an implicit name. This will create an endpoint at <code>/webhooks/goodbye</code>.</li> <li>We start the server. This is optional as your server will automatically be started at the end of the script.</li>`,Se,D,He,te,Ye;return U=new ee({props:{title:"Webhooks Server",local:"webhooks-server",headingTag:"h1"}}),m=new Fe({props:{$$slots:{default:[bt]},$$scope:{ctx:M}}}),T=new Fe({props:{warning:!0,$$slots:{default:[gt]},$$scope:{ctx:M}}}),I=new ee({props:{title:"Create an endpoint",local:"create-an-endpoint",headingTag:"h2"}}),$=new ae({props:{code:"JTIzJTIwYXBwLnB5JTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHdlYmhvb2tfZW5kcG9pbnQlMkMlMjBXZWJob29rUGF5bG9hZCUwQSUwQSU0MHdlYmhvb2tfZW5kcG9pbnQlMEFhc3luYyUyMGRlZiUyMHRyaWdnZXJfdHJhaW5pbmcocGF5bG9hZCUzQSUyMFdlYmhvb2tQYXlsb2FkKSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBwYXlsb2FkLnJlcG8udHlwZSUyMCUzRCUzRCUyMCUyMmRhdGFzZXQlMjIlMjBhbmQlMjBwYXlsb2FkLmV2ZW50LmFjdGlvbiUyMCUzRCUzRCUyMCUyMnVwZGF0ZSUyMiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFRyaWdnZXIlMjBhJTIwdHJhaW5pbmclMjBqb2IlMjBpZiUyMGElMjBkYXRhc2V0JTIwaXMlMjB1cGRhdGVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-comment"># app.py</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> webhook_endpoint, WebhookPayload

<span class="hljs-meta">@webhook_endpoint</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">trigger_training</span>(<span class="hljs-params">payload: WebhookPayload</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;dataset&quot;</span> <span class="hljs-keyword">and</span> payload.event.action == <span class="hljs-string">&quot;update&quot;</span>:
        <span class="hljs-comment"># Trigger a training job if a dataset is updated</span>
        ...`,wrap:!1}}),G=new ae({props:{code:"V2ViaG9vayUyMHNlY3JldCUyMGlzJTIwbm90JTIwZGVmaW5lZC4lMjBUaGlzJTIwbWVhbnMlMjB5b3VyJTIwd2ViaG9vayUyMGVuZHBvaW50cyUyMHdpbGwlMjBiZSUyMG9wZW4lMjB0byUyMGV2ZXJ5b25lLiUwQVRvJTIwYWRkJTIwYSUyMHNlY3JldCUyQyUyMHNldCUyMCU2MFdFQkhPT0tfU0VDUkVUJTYwJTIwYXMlMjBlbnZpcm9ubWVudCUyMHZhcmlhYmxlJTIwb3IlMjBwYXNzJTIwaXQlMjBhdCUyMGluaXRpYWxpemF0aW9uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTYwYXBwJTIwJTNEJTIwV2ViaG9va3NTZXJ2ZXIod2ViaG9va19zZWNyZXQlM0QnbXlfc2VjcmV0JyUyQyUyMC4uLiklNjAlMEFGb3IlMjBtb3JlJTIwZGV0YWlscyUyMGFib3V0JTIwd2ViaG9vayUyMHNlY3JldHMlMkMlMjBwbGVhc2UlMjByZWZlciUyMHRvJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRvY3MlMkZodWIlMkZ3ZWJob29rcyUyM3dlYmhvb2stc2VjcmV0LiUwQVJ1bm5pbmclMjBvbiUyMGxvY2FsJTIwVVJMJTNBJTIwJTIwaHR0cCUzQSUyRiUyRjEyNy4wLjAuMSUzQTc4NjAlMEFSdW5uaW5nJTIwb24lMjBwdWJsaWMlMjBVUkwlM0ElMjBodHRwcyUzQSUyRiUyRjFmYWRiMGY1MmQ4YmY4MjVmYy5ncmFkaW8ubGl2ZSUwQSUwQVRoaXMlMjBzaGFyZSUyMGxpbmslMjBleHBpcmVzJTIwaW4lMjA3MiUyMGhvdXJzLiUyMEZvciUyMGZyZWUlMjBwZXJtYW5lbnQlMjBob3N0aW5nJTIwYW5kJTIwR1BVJTIwdXBncmFkZXMlMjAoTkVXISklMkMlMjBjaGVjayUyMG91dCUyMFNwYWNlcyUzQSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMEElMEFXZWJob29rcyUyMGFyZSUyMGNvcnJlY3RseSUyMHNldHVwJTIwYW5kJTIwcmVhZHklMjB0byUyMHVzZSUzQSUwQSUyMCUyMC0lMjBQT1NUJTIwaHR0cHMlM0ElMkYlMkYxZmFkYjBmNTJkOGJmODI1ZmMuZ3JhZGlvLmxpdmUlMkZ3ZWJob29rcyUyRnRyaWdnZXJfdHJhaW5pbmclMEFHbyUyMHRvJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnNldHRpbmdzJTJGd2ViaG9va3MlMjB0byUyMHNldHVwJTIweW91ciUyMHdlYmhvb2tzLg==",highlighted:`Webhook secret is not defined. This means your webhook endpoints will be open to everyone.
To add a secret, set \`WEBHOOK_SECRET\` as environment variable or pass it at initialization:
        \`app = WebhooksServer(webhook_secret=&#x27;my_secret&#x27;, ...)\`
For more details about webhook secrets, please refer to https://huggingface.co/docs/hub/webhooks#webhook-secret.
Running on local URL:  http://127.0.0.1:7860
Running on public URL: https://1fadb0f52d8bf825fc.gradio.live

This share link expires in 72 hours. For free permanent hosting and GPU upgrades (NEW!), check out Spaces: https://huggingface.co/spaces

Webhooks are correctly setup and ready to use:
  - POST https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_training
Go to https://huggingface.co/settings/webhooks to setup your webhooks.`,wrap:!1}}),k=new Fe({props:{warning:!0,$$slots:{default:[ft]},$$scope:{ctx:M}}}),_=new ee({props:{title:"Configure a Webhook",local:"configure-a-webhook",headingTag:"h2"}}),Y=new ee({props:{title:"Deploy to a Space",local:"deploy-to-a-space",headingTag:"h2"}}),Q=new ee({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h2"}}),x=new ee({props:{title:"Multiple endpoints",local:"multiple-endpoints",headingTag:"h3"}}),E=new ae({props:{code:"JTIzJTIwYXBwLnB5JTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHdlYmhvb2tfZW5kcG9pbnQlMkMlMjBXZWJob29rUGF5bG9hZCUwQSUwQSU0MHdlYmhvb2tfZW5kcG9pbnQlMEFhc3luYyUyMGRlZiUyMHRyaWdnZXJfdHJhaW5pbmcocGF5bG9hZCUzQSUyMFdlYmhvb2tQYXlsb2FkKSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBwYXlsb2FkLnJlcG8udHlwZSUyMCUzRCUzRCUyMCUyMmRhdGFzZXQlMjIlMjBhbmQlMjBwYXlsb2FkLmV2ZW50LmFjdGlvbiUyMCUzRCUzRCUyMCUyMnVwZGF0ZSUyMiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFRyaWdnZXIlMjBhJTIwdHJhaW5pbmclMjBqb2IlMjBpZiUyMGElMjBkYXRhc2V0JTIwaXMlMjB1cGRhdGVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTBBJTQwd2ViaG9va19lbmRwb2ludCUwQWFzeW5jJTIwZGVmJTIwdHJpZ2dlcl9ldmFsdWF0aW9uKHBheWxvYWQlM0ElMjBXZWJob29rUGF5bG9hZCklMjAtJTNFJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwcGF5bG9hZC5yZXBvLnR5cGUlMjAlM0QlM0QlMjAlMjJtb2RlbCUyMiUyMGFuZCUyMHBheWxvYWQuZXZlbnQuYWN0aW9uJTIwJTNEJTNEJTIwJTIydXBkYXRlJTIyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwVHJpZ2dlciUyMGFuJTIwZXZhbHVhdGlvbiUyMGpvYiUyMGlmJTIwYSUyMG1vZGVsJTIwaXMlMjB1cGRhdGVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-comment"># app.py</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> webhook_endpoint, WebhookPayload

<span class="hljs-meta">@webhook_endpoint</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">trigger_training</span>(<span class="hljs-params">payload: WebhookPayload</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;dataset&quot;</span> <span class="hljs-keyword">and</span> payload.event.action == <span class="hljs-string">&quot;update&quot;</span>:
        <span class="hljs-comment"># Trigger a training job if a dataset is updated</span>
        ...

<span class="hljs-meta">@webhook_endpoint</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">trigger_evaluation</span>(<span class="hljs-params">payload: WebhookPayload</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;model&quot;</span> <span class="hljs-keyword">and</span> payload.event.action == <span class="hljs-string">&quot;update&quot;</span>:
        <span class="hljs-comment"># Trigger an evaluation job if a model is updated</span>
        ...`,wrap:!1}}),z=new ae({props:{code:"KC4uLiklMEFXZWJob29rcyUyMGFyZSUyMGNvcnJlY3RseSUyMHNldHVwJTIwYW5kJTIwcmVhZHklMjB0byUyMHVzZSUzQSUwQSUyMCUyMC0lMjBQT1NUJTIwaHR0cHMlM0ElMkYlMkYxZmFkYjBmNTJkOGJmODI1ZmMuZ3JhZGlvLmxpdmUlMkZ3ZWJob29rcyUyRnRyaWdnZXJfdHJhaW5pbmclMEElMjAlMjAtJTIwUE9TVCUyMGh0dHBzJTNBJTJGJTJGMWZhZGIwZjUyZDhiZjgyNWZjLmdyYWRpby5saXZlJTJGd2ViaG9va3MlMkZ0cmlnZ2VyX2V2YWx1YXRpb24=",highlighted:`(...)
Webhooks are correctly setup and ready to use:
  - POST https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_training
  - POST https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_evaluation`,wrap:!1}}),P=new ee({props:{title:"Custom server",local:"custom-server",headingTag:"h3"}}),O=new ae({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWZyb20lMjBmYXN0YXBpJTIwaW1wb3J0JTIwUmVxdWVzdCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBXZWJob29rc1NlcnZlciUyQyUyMFdlYmhvb2tQYXlsb2FkJTBBJTBBJTIzJTIwMS4lMjBEZWZpbmUlMjAlMjBVSSUwQXdpdGglMjBnci5CbG9ja3MoKSUyMGFzJTIwdWklM0ElMEElMjAlMjAlMjAlMjAuLi4lMEElMEElMjMlMjAyLiUyMENyZWF0ZSUyMFdlYmhvb2tzU2VydmVyJTIwd2l0aCUyMGN1c3RvbSUyMFVJJTIwYW5kJTIwc2VjcmV0JTBBYXBwJTIwJTNEJTIwV2ViaG9va3NTZXJ2ZXIodWklM0R1aSUyQyUyMHdlYmhvb2tfc2VjcmV0JTNEJTIybXlfc2VjcmV0X2tleSUyMiklMEElMEElMjMlMjAzLiUyMFJlZ2lzdGVyJTIwd2ViaG9vayUyMHdpdGglMjBleHBsaWNpdCUyMG5hbWUlMEElNDBhcHAuYWRkX3dlYmhvb2soJTIyJTJGc2F5X2hlbGxvJTIyKSUwQWFzeW5jJTIwZGVmJTIwaGVsbG8ocGF5bG9hZCUzQSUyMFdlYmhvb2tQYXlsb2FkKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMm1lc3NhZ2UlMjIlM0ElMjAlMjJoZWxsbyUyMiU3RCUwQSUwQSUyMyUyMDQuJTIwUmVnaXN0ZXIlMjB3ZWJob29rJTIwd2l0aCUyMGltcGxpY2l0JTIwbmFtZSUwQSU0MGFwcC5hZGRfd2ViaG9vayUwQWFzeW5jJTIwZGVmJTIwZ29vZGJ5ZShwYXlsb2FkJTNBJTIwV2ViaG9va1BheWxvYWQpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybWVzc2FnZSUyMiUzQSUyMCUyMmdvb2RieWUlMjIlN0QlMEElMEElMjMlMjA1LiUyMFN0YXJ0JTIwc2VydmVyJTIwKG9wdGlvbmFsKSUwQWFwcC5ydW4oKQ==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> Request
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> WebhooksServer, WebhookPayload

<span class="hljs-comment"># 1. Define  UI</span>
<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> ui:
    ...

<span class="hljs-comment"># 2. Create WebhooksServer with custom UI and secret</span>
app = WebhooksServer(ui=ui, webhook_secret=<span class="hljs-string">&quot;my_secret_key&quot;</span>)

<span class="hljs-comment"># 3. Register webhook with explicit name</span>
<span class="hljs-meta">@app.add_webhook(<span class="hljs-params"><span class="hljs-string">&quot;/say_hello&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">hello</span>(<span class="hljs-params">payload: WebhookPayload</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;message&quot;</span>: <span class="hljs-string">&quot;hello&quot;</span>}

<span class="hljs-comment"># 4. Register webhook with implicit name</span>
<span class="hljs-meta">@app.add_webhook</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">goodbye</span>(<span class="hljs-params">payload: WebhookPayload</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;message&quot;</span>: <span class="hljs-string">&quot;goodbye&quot;</span>}

<span class="hljs-comment"># 5. Start server (optional)</span>
app.run()`,wrap:!1}}),D=new yt({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/webhooks_server.md"}}),{c(){l=i("meta"),g=n(),p=i("p"),f=n(),c(U.$$.fragment),se=n(),v=i("p"),v.innerHTML=Qe,ne=n(),j=i("p"),j.innerHTML=Xe,oe=n(),c(m.$$.fragment),le=n(),c(T.$$.fragment),ie=n(),c(I.$$.fragment),re=n(),W=i("p"),W.textContent=xe,pe=n(),c($.$$.fragment),he=n(),Z=i("p"),Z.innerHTML=Le,ce=n(),c(G.$$.fragment),de=n(),B=i("p"),B.textContent=Ee,ue=n(),C=i("ol"),C.innerHTML=Ne,we=n(),c(k.$$.fragment),ye=n(),c(_.$$.fragment),be=n(),S=i("p"),S.innerHTML=ze,ge=n(),J=i("div"),J.innerHTML=Pe,fe=n(),H=i("p"),H.textContent=qe,Me=n(),c(Y.$$.fragment),me=n(),V=i("p"),V.innerHTML=Ae,Te=n(),F=i("p"),F.innerHTML=Oe,ke=n(),R=i("p"),R.innerHTML=Ke,Je=n(),c(Q.$$.fragment),Ue=n(),X=i("p"),X.innerHTML=De,ve=n(),c(x.$$.fragment),je=n(),L=i("p"),L.innerHTML=et,Ie=n(),c(E.$$.fragment),We=n(),N=i("p"),N.textContent=tt,$e=n(),c(z.$$.fragment),Ze=n(),c(P.$$.fragment),Ge=n(),q=i("p"),q.innerHTML=at,Be=n(),A=i("p"),A.textContent=st,Ce=n(),c(O.$$.fragment),_e=n(),K=i("ol"),K.innerHTML=nt,Se=n(),c(D.$$.fragment),He=n(),te=i("p"),this.h()},l(e){const t=ut("svelte-u9bgzb",document.head);l=r(t,"META",{name:!0,content:!0}),t.forEach(a),g=o(e),p=r(e,"P",{}),rt(p).forEach(a),f=o(e),d(U.$$.fragment,e),se=o(e),v=r(e,"P",{"data-svelte-h":!0}),h(v)!=="svelte-1si55wx"&&(v.innerHTML=Qe),ne=o(e),j=r(e,"P",{"data-svelte-h":!0}),h(j)!=="svelte-1wqn2us"&&(j.innerHTML=Xe),oe=o(e),d(m.$$.fragment,e),le=o(e),d(T.$$.fragment,e),ie=o(e),d(I.$$.fragment,e),re=o(e),W=r(e,"P",{"data-svelte-h":!0}),h(W)!=="svelte-1dl6tkz"&&(W.textContent=xe),pe=o(e),d($.$$.fragment,e),he=o(e),Z=r(e,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-nkdywa"&&(Z.innerHTML=Le),ce=o(e),d(G.$$.fragment,e),de=o(e),B=r(e,"P",{"data-svelte-h":!0}),h(B)!=="svelte-bjh0uv"&&(B.textContent=Ee),ue=o(e),C=r(e,"OL",{"data-svelte-h":!0}),h(C)!=="svelte-1wznvz4"&&(C.innerHTML=Ne),we=o(e),d(k.$$.fragment,e),ye=o(e),d(_.$$.fragment,e),be=o(e),S=r(e,"P",{"data-svelte-h":!0}),h(S)!=="svelte-febs9a"&&(S.innerHTML=ze),ge=o(e),J=r(e,"DIV",{class:!0,"data-svelte-h":!0}),h(J)!=="svelte-9ld38f"&&(J.innerHTML=Pe),fe=o(e),H=r(e,"P",{"data-svelte-h":!0}),h(H)!=="svelte-1sr65c9"&&(H.textContent=qe),Me=o(e),d(Y.$$.fragment,e),me=o(e),V=r(e,"P",{"data-svelte-h":!0}),h(V)!=="svelte-apq0kg"&&(V.innerHTML=Ae),Te=o(e),F=r(e,"P",{"data-svelte-h":!0}),h(F)!=="svelte-1h3f73"&&(F.innerHTML=Oe),ke=o(e),R=r(e,"P",{"data-svelte-h":!0}),h(R)!=="svelte-1cxtt3c"&&(R.innerHTML=Ke),Je=o(e),d(Q.$$.fragment,e),Ue=o(e),X=r(e,"P",{"data-svelte-h":!0}),h(X)!=="svelte-l765n9"&&(X.innerHTML=De),ve=o(e),d(x.$$.fragment,e),je=o(e),L=r(e,"P",{"data-svelte-h":!0}),h(L)!=="svelte-gotrx0"&&(L.innerHTML=et),Ie=o(e),d(E.$$.fragment,e),We=o(e),N=r(e,"P",{"data-svelte-h":!0}),h(N)!=="svelte-o8x9sv"&&(N.textContent=tt),$e=o(e),d(z.$$.fragment,e),Ze=o(e),d(P.$$.fragment,e),Ge=o(e),q=r(e,"P",{"data-svelte-h":!0}),h(q)!=="svelte-y619li"&&(q.innerHTML=at),Be=o(e),A=r(e,"P",{"data-svelte-h":!0}),h(A)!=="svelte-1plkp10"&&(A.textContent=st),Ce=o(e),d(O.$$.fragment,e),_e=o(e),K=r(e,"OL",{"data-svelte-h":!0}),h(K)!=="svelte-fnd8yp"&&(K.innerHTML=nt),Se=o(e),d(D.$$.fragment,e),He=o(e),te=r(e,"P",{}),rt(te).forEach(a),this.h()},h(){Ve(l,"name","hf:doc:metadata"),Ve(l,"content",mt),Ve(J,"class","flex justify-center")},m(e,t){wt(document.head,l),s(e,g,t),s(e,p,t),s(e,f,t),u(U,e,t),s(e,se,t),s(e,v,t),s(e,ne,t),s(e,j,t),s(e,oe,t),u(m,e,t),s(e,le,t),u(T,e,t),s(e,ie,t),u(I,e,t),s(e,re,t),s(e,W,t),s(e,pe,t),u($,e,t),s(e,he,t),s(e,Z,t),s(e,ce,t),u(G,e,t),s(e,de,t),s(e,B,t),s(e,ue,t),s(e,C,t),s(e,we,t),u(k,e,t),s(e,ye,t),u(_,e,t),s(e,be,t),s(e,S,t),s(e,ge,t),s(e,J,t),s(e,fe,t),s(e,H,t),s(e,Me,t),u(Y,e,t),s(e,me,t),s(e,V,t),s(e,Te,t),s(e,F,t),s(e,ke,t),s(e,R,t),s(e,Je,t),u(Q,e,t),s(e,Ue,t),s(e,X,t),s(e,ve,t),u(x,e,t),s(e,je,t),s(e,L,t),s(e,Ie,t),u(E,e,t),s(e,We,t),s(e,N,t),s(e,$e,t),u(z,e,t),s(e,Ze,t),u(P,e,t),s(e,Ge,t),s(e,q,t),s(e,Be,t),s(e,A,t),s(e,Ce,t),u(O,e,t),s(e,_e,t),s(e,K,t),s(e,Se,t),u(D,e,t),s(e,He,t),s(e,te,t),Ye=!0},p(e,[t]){const ot={};t&2&&(ot.$$scope={dirty:t,ctx:e}),m.$set(ot);const lt={};t&2&&(lt.$$scope={dirty:t,ctx:e}),T.$set(lt);const it={};t&2&&(it.$$scope={dirty:t,ctx:e}),k.$set(it)},i(e){Ye||(w(U.$$.fragment,e),w(m.$$.fragment,e),w(T.$$.fragment,e),w(I.$$.fragment,e),w($.$$.fragment,e),w(G.$$.fragment,e),w(k.$$.fragment,e),w(_.$$.fragment,e),w(Y.$$.fragment,e),w(Q.$$.fragment,e),w(x.$$.fragment,e),w(E.$$.fragment,e),w(z.$$.fragment,e),w(P.$$.fragment,e),w(O.$$.fragment,e),w(D.$$.fragment,e),Ye=!0)},o(e){y(U.$$.fragment,e),y(m.$$.fragment,e),y(T.$$.fragment,e),y(I.$$.fragment,e),y($.$$.fragment,e),y(G.$$.fragment,e),y(k.$$.fragment,e),y(_.$$.fragment,e),y(Y.$$.fragment,e),y(Q.$$.fragment,e),y(x.$$.fragment,e),y(E.$$.fragment,e),y(z.$$.fragment,e),y(P.$$.fragment,e),y(O.$$.fragment,e),y(D.$$.fragment,e),Ye=!1},d(e){e&&(a(g),a(p),a(f),a(se),a(v),a(ne),a(j),a(oe),a(le),a(ie),a(re),a(W),a(pe),a(he),a(Z),a(ce),a(de),a(B),a(ue),a(C),a(we),a(ye),a(be),a(S),a(ge),a(J),a(fe),a(H),a(Me),a(me),a(V),a(Te),a(F),a(ke),a(R),a(Je),a(Ue),a(X),a(ve),a(je),a(L),a(Ie),a(We),a(N),a($e),a(Ze),a(Ge),a(q),a(Be),a(A),a(Ce),a(_e),a(K),a(Se),a(He),a(te)),a(l),b(U,e),b(m,e),b(T,e),b(I,e),b($,e),b(G,e),b(k,e),b(_,e),b(Y,e),b(Q,e),b(x,e),b(E,e),b(z,e),b(P,e),b(O,e),b(D,e)}}}const mt='{"title":"Webhooks Server","local":"webhooks-server","sections":[{"title":"Create an endpoint","local":"create-an-endpoint","sections":[],"depth":2},{"title":"Configure a Webhook","local":"configure-a-webhook","sections":[],"depth":2},{"title":"Deploy to a Space","local":"deploy-to-a-space","sections":[],"depth":2},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Multiple endpoints","local":"multiple-endpoints","sections":[],"depth":3},{"title":"Custom server","local":"custom-server","sections":[],"depth":3}],"depth":2}],"depth":1}';function Tt(M){return ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class It extends ct{constructor(l){super(),dt(this,l,Tt,Mt,pt,{})}}export{It as component};
