import{s as ql,o as Ll,n as il}from"../chunks/scheduler.37c15a92.js";import{S as Dl,i as Pl,g as o,s as n,r as M,A as Kl,h as i,f as l,c as a,j as El,u as p,x as r,k as Ae,y as Ol,a as s,v as d,d as y,t as c,w as u}from"../chunks/index.2bf4358c.js";import{T as nl}from"../chunks/Tip.363c041f.js";import{Y as al}from"../chunks/Youtube.1e50a667.js";import{C as h}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as es}from"../chunks/CourseFloatingBanner.15ba07e6.js";import{H as ol}from"../chunks/Heading.8ada512a.js";function ts(U){let m,f="🚨 See that blue box around “6 frames” in the traceback from Google Colab? That’s a special feature of Colab, which  compresses the traceback into “frames.” If you can’t seem to find the source of an error, make sure you expand the full traceback by clicking on those two little arrows.";return{c(){m=o("p"),m.textContent=f},l(w){m=i(w,"P",{"data-svelte-h":!0}),r(m)!=="svelte-mpbnk5"&&(m.textContent=f)},m(w,J){s(w,m,J)},p:il,d(w){w&&l(m)}}}function ls(U){let m,f='💡 If you encounter an error message that is difficult to understand, just copy and paste the message into the Google or <a href="https://stackoverflow.com/" rel="nofollow">Stack Overflow</a> search bar (yes, really!). There’s a good chance that you’re not the first person to encounter the error, and this is a good way to find solutions that others in the community have posted. For example, searching for <code>OSError: Can&#39;t load config for</code> on Stack Overflow gives several <a href="https://stackoverflow.com/search?q=OSError%3A+Can%27t+load+config+for+" rel="nofollow">hits</a> that could be used as a starting point for solving the problem.';return{c(){m=o("p"),m.innerHTML=f},l(w){m=i(w,"P",{"data-svelte-h":!0}),r(m)!=="svelte-hqov2a"&&(m.innerHTML=f)},m(w,J){s(w,m,J)},p:il,d(w){w&&l(m)}}}function ss(U){let m,f="🚨 The approach we’re taking here is not foolproof, since our colleague may have tweaked the configuration of <code>distilbert-base-uncased</code> before fine-tuning the model. In real life, we’d want to check with them first, but for the purposes of this section we’ll assume they used the default configuration.";return{c(){m=o("p"),m.innerHTML=f},l(w){m=i(w,"P",{"data-svelte-h":!0}),r(m)!=="svelte-y8710l"&&(m.innerHTML=f)},m(w,J){s(w,m,J)},p:il,d(w){w&&l(m)}}}function ns(U){let m,f,w,J,I,Ve,W,ze,G,rl='In this section we’ll look at some common errors that can occur when you’re trying to generate predictions from your freshly tuned Transformer model. This will prepare you for <a href="/course/chapter8/section4">section 4</a>, where we’ll explore how to debug the training phase itself.',Ye,X,He,_,Ml='We’ve prepared a <a href="https://huggingface.co/lewtun/distilbert-base-uncased-finetuned-squad-d5716d28" rel="nofollow">template model repository</a> for this section, and if you want to run the code in this chapter you’ll first need to copy the model to your account on the <a href="https://huggingface.co" rel="nofollow">Hugging Face Hub</a>. To do so, first log in by running either the following in a Jupyter notebook:',Fe,B,Qe,v,pl="or the following in your favorite terminal:",Se,$,Ee,R,dl="This will prompt you to enter your username and password, and will save a token under <em>~/.cache/huggingface/</em>. Once you’ve logged in, you can copy the template repository with the following function:",qe,x,Le,A,yl="Now when you call <code>copy_repository_template()</code>, it will create a copy of the template repository under your account.",De,N,Pe,V,cl="To kick off our journey into the wonderful world of debugging Transformer models, consider the following scenario: you’re working with a colleague on a question answering project to help the customers of an e-commerce website find answers about consumer products. Your colleague shoots you a message like:",Ke,z,ul='<p>G’day! I just ran an experiment using the techniques in <a href="/course/chapter7/7">Chapter 7</a> of the Hugging Face course and got some great results on SQuAD! I think we can use this model as a starting point for our project. The model ID on the Hub is “lewtun/distillbert-base-uncased-finetuned-squad-d5716d28”. Feel free to test it out :)</p>',Oe,Y,ml="and the first thing you think of is to load the model using the <code>pipeline</code> from 🤗 Transformers:",et,H,tt,F,lt,Q,hl="Oh no, something seems to have gone wrong! If you’re new to programming, these kind of errors can seem a bit cryptic at first (what even is an <code>OSError</code>?!). The error displayed here is just the last part of a much larger error report called a <em>Python traceback</em> (aka stack trace). For example, if you’re running this code on Google Colab, you should see something like the following screenshot:",st,b,wl='<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/traceback.png" alt="A Python traceback." width="100%"/>',nt,S,fl='There’s a lot of information contained in these reports, so let’s walk through the key parts together. The first thing to note is that tracebacks should be read <em>from bottom to top</em>. This might sound weird if you’re used to reading English text from top to bottom, but it reflects the fact that the traceback shows the sequence of function calls that the <code>pipeline</code> makes when downloading the model and tokenizer. (Check out <a href="/course/chapter2">Chapter 2</a> for more details on how the <code>pipeline</code> works under the hood.)',at,j,ot,E,Jl="This means that the last line of the traceback indicates the last error message and gives the name of the exception that was raised. In this case, the exception type is <code>OSError</code>, which indicates a system-related error. If we read the accompanying error message, we can see that there seems to be a problem with the model’s <em>config.json</em> file, and we’re given two suggestions to fix it:",it,q,rt,T,Mt,L,Ul="The first suggestion is asking us to check whether the model ID is actually correct, so the first order of business is to copy the identifier and paste it into the Hub’s search bar:",pt,g,bl='<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/wrong-model-id.png" alt="The wrong model name." width="100%"/>',dt,D,jl="Hmm, it indeed looks like our colleague’s model is not on the Hub… aha, but there’s a typo in the name of the model! DistilBERT only has one “l” in its name, so let’s fix that and look for “lewtun/distilbert-base-uncased-finetuned-squad-d5716d28” instead:",yt,Z,Tl='<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/true-model-id.png" alt="The right model name." width="100%"/>',ct,P,gl="Okay, this got a hit. Now let’s try to download the model again with the correct model ID:",ut,K,mt,O,ht,ee,Zl="Argh, foiled again — welcome to the daily life of a machine learning engineer! Since we’ve fixed the model ID, the problem must lie in the repository itself. A quick way to access the contents of a repository on the 🤗 Hub is via the <code>list_repo_files()</code> function of the <code>huggingface_hub</code> library:",wt,te,ft,le,Jt,se,Cl='Interesting — there doesn’t seem to be a <em>config.json</em> file in the repository! No wonder our <code>pipeline</code> couldn’t load the model; our colleague must have forgotten to push this file to the Hub after they fine-tuned it. In this case, the problem seems pretty straightforward to fix: we could ask them to add the file, or, since we can see from the model ID that the pretrained model used was <a href="https://huggingface.co/distilbert-base-uncased" rel="nofollow"><code>distilbert-base-uncased</code></a>, we can download the config for this model and push it to our repo to see if that resolves the problem. Let’s try that. Using the techniques we learned in <a href="/course/chapter2">Chapter 2</a>, we can download the model’s configuration with the <code>AutoConfig</code> class:',Ut,ne,bt,C,jt,ae,kl="We can then push this to our model repository with the configuration’s <code>push_to_hub()</code> function:",Tt,oe,gt,ie,Il="Now we can test if this worked by loading the model from the latest commit on the <code>main</code> branch:",Zt,re,Ct,Me,kt,pe,Wl="Woohoo, it worked! Let’s recap what you’ve just learned:",It,de,Gl=`<li>The error messages in Python are known as <em>tracebacks</em> and are read from bottom to top. The last line of the error message usually contains the information you need to locate the source of the problem.</li> <li>If the last line does not contain sufficient information, work your way up the traceback and see if you can identify where in the source code the error occurs.</li> <li>If none of the error messages can help you debug the problem, try searching online for a solution to a similar issue.</li> <li>The <code>huggingface_hub</code>
// 🤗 Hub?
library provides a suite of tools that you can use to interact with and debug repositories on the Hub.</li>`,Wt,ye,Xl="Now that you know how to debug a pipeline, let’s take a look at a trickier example in the forward pass of the model itself.",Gt,ce,Xt,ue,_l="Although the <code>pipeline</code> is great for most applications where you need to quickly generate predictions, sometimes you’ll need to access the model’s logits (say, if you have some custom post-processing that you’d like to apply). To see what can go wrong in this case, let’s first grab the model and tokenizer from our <code>pipeline</code>:",_t,me,Bt,he,Bl="Next we need a question, so let’s see if our favorite frameworks are supported:",vt,we,$t,fe,vl='As we saw in <a href="/course/chapter7">Chapter 7</a>, the usual steps we need to take are tokenizing the inputs, extracting the logits of the start and end tokens, and then decoding the answer span:',Rt,Je,xt,Ue,At,be,$l="Oh dear, it looks like we have a bug in our code! But we’re not afraid of a little debugging. You can use the Python debugger in a notebook:",Nt,je,Vt,Te,Rl="or in a terminal:",zt,ge,Yt,Ze,xl="Here, reading the error message tells us that <code>&#39;list&#39; object has no attribute &#39;size&#39;</code>, and we can see a <code>--&gt;</code> arrow pointing to the line where the problem was raised in <code>model(**inputs)</code>.You can debug this interactively using the Python debugger, but for now we’ll simply print out a slice of <code>inputs</code> to see what we have:",Ht,Ce,Ft,ke,Qt,Ie,Al="This certainly looks like an ordinary Python <code>list</code>, but let’s double-check the type:",St,We,Et,Ge,qt,Xe,Nl='Yep, that’s a Python <code>list</code> for sure. So what went wrong? Recall from <a href="/course/chapter2">Chapter 2</a> that the <code>AutoModelForXxx</code> classes in 🤗 Transformers operate on <em>tensors</em> (either in PyTorch or TensorFlow), and a common operation is to extract the dimensions of a tensor using <code>Tensor.size()</code> in, say, PyTorch. Let’s take another look at the traceback, to see which line triggered the exception:',Lt,_e,Dt,Be,Vl='It looks like our code tried to call <code>input_ids.size()</code>, but this clearly won’t work for a Python <code>list</code>, which is just a container. How can we solve this problem? Searching for the error message on Stack Overflow gives quite a few relevant <a href="https://stackoverflow.com/search?q=AttributeError%3A+%27list%27+object+has+no+attribute+%27size%27&amp;s=c15ec54c-63cb-481d-a749-408920073e8f" rel="nofollow">hits</a>. Clicking on the first one displays a similar question to ours, with the answer shown in the screenshot below:',Pt,k,zl='<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/stack-overflow.png" alt="An answer from Stack Overflow." width="100%"/>',Kt,ve,Yl="The answer recommends that we add <code>return_tensors=&#39;pt&#39;</code> to the tokenizer, so let’s see if that works for us:",Ot,$e,el,Re,tl,xe,Hl='Nice, it worked! This is a great example of how useful Stack Overflow can be: by identifying a similar problem, we were able to benefit from the experience of others in the community. However, a search like this won’t always yield a relevant answer, so what can you do in such cases? Fortunately, there is a welcoming community of developers on the <a href="https://discuss.huggingface.co/" rel="nofollow">Hugging Face forums</a> that can help you out! In the next section, we’ll take a look at how you can craft good forum questions that are likely to get answered.',ll,Ne,sl;return I=new ol({props:{title:"What to do when you get an error",local:"what-to-do-when-you-get-an-error",headingTag:"h1"}}),W=new es({props:{chapter:8,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter8/section2.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter8/section2.ipynb"}]}}),X=new al({props:{id:"DQ-CpJn6Rc4"}}),B=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),$=new h({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),x=new h({props:{code:"ZnJvbSUyMGRpc3R1dGlscy5kaXJfdXRpbCUyMGltcG9ydCUyMGNvcHlfdHJlZSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBSZXBvc2l0b3J5JTJDJTIwc25hcHNob3RfZG93bmxvYWQlMkMlMjBjcmVhdGVfcmVwbyUyQyUyMGdldF9mdWxsX3JlcG9fbmFtZSUwQSUwQSUwQWRlZiUyMGNvcHlfcmVwb3NpdG9yeV90ZW1wbGF0ZSgpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwQ2xvbmUlMjB0aGUlMjByZXBvJTIwYW5kJTIwZXh0cmFjdCUyMHRoZSUyMGxvY2FsJTIwcGF0aCUwQSUyMCUyMCUyMCUyMHRlbXBsYXRlX3JlcG9faWQlMjAlM0QlMjAlMjJsZXd0dW4lMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3F1YWQtZDU3MTZkMjglMjIlMEElMjAlMjAlMjAlMjBjb21taXRfaGFzaCUyMCUzRCUyMCUyMmJlM2VhZmZjMjg2NjlkNzkzMjQ5MjY4MWNkNWYzZTg5MDVlMzU4YjQlMjIlMEElMjAlMjAlMjAlMjB0ZW1wbGF0ZV9yZXBvX2RpciUyMCUzRCUyMHNuYXBzaG90X2Rvd25sb2FkKHRlbXBsYXRlX3JlcG9faWQlMkMlMjByZXZpc2lvbiUzRGNvbW1pdF9oYXNoKSUwQSUyMCUyMCUyMCUyMCUyMyUyMENyZWF0ZSUyMGFuJTIwZW1wdHklMjByZXBvJTIwb24lMjB0aGUlMjBIdWIlMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTIwJTNEJTIwdGVtcGxhdGVfcmVwb19pZC5zcGxpdCglMjIlMkYlMjIpJTVCMSU1RCUwQSUyMCUyMCUyMCUyMGNyZWF0ZV9yZXBvKG1vZGVsX25hbWUlMkMlMjBleGlzdF9vayUzRFRydWUpJTBBJTIwJTIwJTIwJTIwJTIzJTIwQ2xvbmUlMjB0aGUlMjBlbXB0eSUyMHJlcG8lMEElMjAlMjAlMjAlMjBuZXdfcmVwb19pZCUyMCUzRCUyMGdldF9mdWxsX3JlcG9fbmFtZShtb2RlbF9uYW1lKSUwQSUyMCUyMCUyMCUyMG5ld19yZXBvX2RpciUyMCUzRCUyMG1vZGVsX25hbWUlMEElMjAlMjAlMjAlMjByZXBvJTIwJTNEJTIwUmVwb3NpdG9yeShsb2NhbF9kaXIlM0RuZXdfcmVwb19kaXIlMkMlMjBjbG9uZV9mcm9tJTNEbmV3X3JlcG9faWQpJTBBJTIwJTIwJTIwJTIwJTIzJTIwQ29weSUyMGZpbGVzJTBBJTIwJTIwJTIwJTIwY29weV90cmVlKHRlbXBsYXRlX3JlcG9fZGlyJTJDJTIwbmV3X3JlcG9fZGlyKSUwQSUyMCUyMCUyMCUyMCUyMyUyMFB1c2glMjB0byUyMEh1YiUwQSUyMCUyMCUyMCUyMHJlcG8ucHVzaF90b19odWIoKQ==",highlighted:`<span class="hljs-keyword">from</span> distutils.dir_util <span class="hljs-keyword">import</span> copy_tree
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository, snapshot_download, create_repo, get_full_repo_name


<span class="hljs-keyword">def</span> <span class="hljs-title function_">copy_repository_template</span>():
    <span class="hljs-comment"># Clone the repo and extract the local path</span>
    template_repo_id = <span class="hljs-string">&quot;lewtun/distilbert-base-uncased-finetuned-squad-d5716d28&quot;</span>
    commit_hash = <span class="hljs-string">&quot;be3eaffc28669d7932492681cd5f3e8905e358b4&quot;</span>
    template_repo_dir = snapshot_download(template_repo_id, revision=commit_hash)
    <span class="hljs-comment"># Create an empty repo on the Hub</span>
    model_name = template_repo_id.split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]
    create_repo(model_name, exist_ok=<span class="hljs-literal">True</span>)
    <span class="hljs-comment"># Clone the empty repo</span>
    new_repo_id = get_full_repo_name(model_name)
    new_repo_dir = model_name
    repo = Repository(local_dir=new_repo_dir, clone_from=new_repo_id)
    <span class="hljs-comment"># Copy files</span>
    copy_tree(template_repo_dir, new_repo_dir)
    <span class="hljs-comment"># Push to Hub</span>
    repo.push_to_hub()`,wrap:!1}}),N=new ol({props:{title:"Debugging the pipeline from 🤗 Transformers",local:"debugging-the-pipeline-from-transformers",headingTag:"h2"}}),H=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBbW9kZWxfY2hlY2twb2ludCUyMCUzRCUyMGdldF9mdWxsX3JlcG9fbmFtZSglMjJkaXN0aWxsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNxdWFkLWQ1NzE2ZDI4JTIyKSUwQXJlYWRlciUyMCUzRCUyMHBpcGVsaW5lKCUyMnF1ZXN0aW9uLWFuc3dlcmluZyUyMiUyQyUyMG1vZGVsJTNEbW9kZWxfY2hlY2twb2ludCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

model_checkpoint = get_full_repo_name(<span class="hljs-string">&quot;distillbert-base-uncased-finetuned-squad-d5716d28&quot;</span>)
reader = pipeline(<span class="hljs-string">&quot;question-answering&quot;</span>, model=model_checkpoint)`,wrap:!1}}),F=new h({props:{code:"JTIyJTIyJTIyJTBBT1NFcnJvciUzQSUyMENhbid0JTIwbG9hZCUyMGNvbmZpZyUyMGZvciUyMCdsZXd0dW4lMkZkaXN0aWxsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNxdWFkLWQ1NzE2ZDI4Jy4lMjBNYWtlJTIwc3VyZSUyMHRoYXQlM0ElMEElMEEtJTIwJ2xld3R1biUyRmRpc3RpbGxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3F1YWQtZDU3MTZkMjgnJTIwaXMlMjBhJTIwY29ycmVjdCUyMG1vZGVsJTIwaWRlbnRpZmllciUyMGxpc3RlZCUyMG9uJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZtb2RlbHMnJTBBJTBBLSUyMG9yJTIwJ2xld3R1biUyRmRpc3RpbGxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3F1YWQtZDU3MTZkMjgnJTIwaXMlMjB0aGUlMjBjb3JyZWN0JTIwcGF0aCUyMHRvJTIwYSUyMGRpcmVjdG9yeSUyMGNvbnRhaW5pbmclMjBhJTIwY29uZmlnLmpzb24lMjBmaWxlJTBBJTIyJTIyJTIy",highlighted:`<span class="hljs-string">&quot;&quot;&quot;
OSError: Can&#x27;t load config for &#x27;lewtun/distillbert-base-uncased-finetuned-squad-d5716d28&#x27;. Make sure that:

- &#x27;lewtun/distillbert-base-uncased-finetuned-squad-d5716d28&#x27; is a correct model identifier listed on &#x27;https://huggingface.co/models&#x27;

- or &#x27;lewtun/distillbert-base-uncased-finetuned-squad-d5716d28&#x27; is the correct path to a directory containing a config.json file
&quot;&quot;&quot;</span>`,wrap:!1}}),j=new nl({props:{$$slots:{default:[ts]},$$scope:{ctx:U}}}),q=new h({props:{code:"JTIyJTIyJTIyJTBBTWFrZSUyMHN1cmUlMjB0aGF0JTNBJTBBJTBBLSUyMCdsZXd0dW4lMkZkaXN0aWxsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNxdWFkLWQ1NzE2ZDI4JyUyMGlzJTIwYSUyMGNvcnJlY3QlMjBtb2RlbCUyMGlkZW50aWZpZXIlMjBsaXN0ZWQlMjBvbiUyMCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJyUwQSUwQS0lMjBvciUyMCdsZXd0dW4lMkZkaXN0aWxsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNxdWFkLWQ1NzE2ZDI4JyUyMGlzJTIwdGhlJTIwY29ycmVjdCUyMHBhdGglMjB0byUyMGElMjBkaXJlY3RvcnklMjBjb250YWluaW5nJTIwYSUyMGNvbmZpZy5qc29uJTIwZmlsZSUwQSUyMiUyMiUyMg==",highlighted:`<span class="hljs-string">&quot;&quot;&quot;
Make sure that:

- &#x27;lewtun/distillbert-base-uncased-finetuned-squad-d5716d28&#x27; is a correct model identifier listed on &#x27;https://huggingface.co/models&#x27;

- or &#x27;lewtun/distillbert-base-uncased-finetuned-squad-d5716d28&#x27; is the correct path to a directory containing a config.json file
&quot;&quot;&quot;</span>`,wrap:!1}}),T=new nl({props:{$$slots:{default:[ls]},$$scope:{ctx:U}}}),K=new h({props:{code:"bW9kZWxfY2hlY2twb2ludCUyMCUzRCUyMGdldF9mdWxsX3JlcG9fbmFtZSglMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3F1YWQtZDU3MTZkMjglMjIpJTBBcmVhZGVyJTIwJTNEJTIwcGlwZWxpbmUoJTIycXVlc3Rpb24tYW5zd2VyaW5nJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbF9jaGVja3BvaW50KQ==",highlighted:`model_checkpoint = get_full_repo_name(<span class="hljs-string">&quot;distilbert-base-uncased-finetuned-squad-d5716d28&quot;</span>)
reader = pipeline(<span class="hljs-string">&quot;question-answering&quot;</span>, model=model_checkpoint)`,wrap:!1}}),O=new h({props:{code:"JTIyJTIyJTIyJTBBT1NFcnJvciUzQSUyMENhbid0JTIwbG9hZCUyMGNvbmZpZyUyMGZvciUyMCdsZXd0dW4lMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3F1YWQtZDU3MTZkMjgnLiUyME1ha2UlMjBzdXJlJTIwdGhhdCUzQSUwQSUwQS0lMjAnbGV3dHVuJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNxdWFkLWQ1NzE2ZDI4JyUyMGlzJTIwYSUyMGNvcnJlY3QlMjBtb2RlbCUyMGlkZW50aWZpZXIlMjBsaXN0ZWQlMjBvbiUyMCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJyUwQSUwQS0lMjBvciUyMCdsZXd0dW4lMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3F1YWQtZDU3MTZkMjgnJTIwaXMlMjB0aGUlMjBjb3JyZWN0JTIwcGF0aCUyMHRvJTIwYSUyMGRpcmVjdG9yeSUyMGNvbnRhaW5pbmclMjBhJTIwY29uZmlnLmpzb24lMjBmaWxlJTBBJTIyJTIyJTIy",highlighted:`<span class="hljs-string">&quot;&quot;&quot;
OSError: Can&#x27;t load config for &#x27;lewtun/distilbert-base-uncased-finetuned-squad-d5716d28&#x27;. Make sure that:

- &#x27;lewtun/distilbert-base-uncased-finetuned-squad-d5716d28&#x27; is a correct model identifier listed on &#x27;https://huggingface.co/models&#x27;

- or &#x27;lewtun/distilbert-base-uncased-finetuned-squad-d5716d28&#x27; is the correct path to a directory containing a config.json file
&quot;&quot;&quot;</span>`,wrap:!1}}),te=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcmVwb19maWxlcyUwQSUwQWxpc3RfcmVwb19maWxlcyhyZXBvX2lkJTNEbW9kZWxfY2hlY2twb2ludCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_repo_files

list_repo_files(repo_id=model_checkpoint)`,wrap:!1}}),le=new h({props:{code:"JTVCJy5naXRhdHRyaWJ1dGVzJyUyQyUyMCdSRUFETUUubWQnJTJDJTIwJ3B5dG9yY2hfbW9kZWwuYmluJyUyQyUyMCdzcGVjaWFsX3Rva2Vuc19tYXAuanNvbiclMkMlMjAndG9rZW5pemVyX2NvbmZpZy5qc29uJyUyQyUyMCd0cmFpbmluZ19hcmdzLmJpbiclMkMlMjAndm9jYWIudHh0JyU1RA==",highlighted:'[<span class="hljs-string">&#x27;.gitattributes&#x27;</span>, <span class="hljs-string">&#x27;README.md&#x27;</span>, <span class="hljs-string">&#x27;pytorch_model.bin&#x27;</span>, <span class="hljs-string">&#x27;special_tokens_map.json&#x27;</span>, <span class="hljs-string">&#x27;tokenizer_config.json&#x27;</span>, <span class="hljs-string">&#x27;training_args.bin&#x27;</span>, <span class="hljs-string">&#x27;vocab.txt&#x27;</span>]',wrap:!1}}),ne=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMEElMEFwcmV0cmFpbmVkX2NoZWNrcG9pbnQlMjAlM0QlMjAlMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZCUyMiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKHByZXRyYWluZWRfY2hlY2twb2ludCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig

pretrained_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
config = AutoConfig.from_pretrained(pretrained_checkpoint)`,wrap:!1}}),C=new nl({props:{warning:!0,$$slots:{default:[ss]},$$scope:{ctx:U}}}),oe=new h({props:{code:"Y29uZmlnLnB1c2hfdG9faHViKG1vZGVsX2NoZWNrcG9pbnQlMkMlMjBjb21taXRfbWVzc2FnZSUzRCUyMkFkZCUyMGNvbmZpZy5qc29uJTIyKQ==",highlighted:'config.push_to_hub(model_checkpoint, commit_message=<span class="hljs-string">&quot;Add config.json&quot;</span>)',wrap:!1}}),re=new h({props:{code:"cmVhZGVyJTIwJTNEJTIwcGlwZWxpbmUoJTIycXVlc3Rpb24tYW5zd2VyaW5nJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbF9jaGVja3BvaW50JTJDJTIwcmV2aXNpb24lM0QlMjJtYWluJTIyKSUwQSUwQWNvbnRleHQlMjAlM0QlMjByJTIyJTIyJTIyJTBBRXh0cmFjdGl2ZSUyMFF1ZXN0aW9uJTIwQW5zd2VyaW5nJTIwaXMlMjB0aGUlMjB0YXNrJTIwb2YlMjBleHRyYWN0aW5nJTIwYW4lMjBhbnN3ZXIlMjBmcm9tJTIwYSUyMHRleHQlMEFnaXZlbiUyMGElMjBxdWVzdGlvbi4lMjBBbiUyMGV4YW1wbGUlMjBvZiUyMGElMjBxdWVzdGlvbiUyMGFuc3dlcmluZyUyMGRhdGFzZXQlMjBpcyUyMHRoZSUyMFNRdUFEJTBBZGF0YXNldCUyQyUyMHdoaWNoJTIwaXMlMjBlbnRpcmVseSUyMGJhc2VkJTIwb24lMjB0aGF0JTIwdGFzay4lMjBJZiUyMHlvdSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwZmluZS10dW5lJTIwYSUwQW1vZGVsJTIwb24lMjBhJTIwU1F1QUQlMjB0YXNrJTJDJTIweW91JTIwbWF5JTIwbGV2ZXJhZ2UlMjB0aGUlMEFleGFtcGxlcyUyRnB5dG9yY2glMkZxdWVzdGlvbi1hbnN3ZXJpbmclMkZydW5fc3F1YWQucHklMjBzY3JpcHQuJTBBJTBBJUYwJTlGJUE0JTk3JTIwVHJhbnNmb3JtZXJzJTIwaXMlMjBpbnRlcm9wZXJhYmxlJTIwd2l0aCUyMHRoZSUyMFB5VG9yY2glMkMlMjBUZW5zb3JGbG93JTJDJTIwYW5kJTIwSkFYJTBBZnJhbWV3b3JrcyUyQyUyMHNvJTIweW91JTIwY2FuJTIwdXNlJTIweW91ciUyMGZhdm91cml0ZSUyMHRvb2xzJTIwZm9yJTIwYSUyMHdpZGUlMjB2YXJpZXR5JTIwb2YlMjB0YXNrcyElMEElMjIlMjIlMjIlMEElMEFxdWVzdGlvbiUyMCUzRCUyMCUyMldoYXQlMjBpcyUyMGV4dHJhY3RpdmUlMjBxdWVzdGlvbiUyMGFuc3dlcmluZyUzRiUyMiUwQXJlYWRlcihxdWVzdGlvbiUzRHF1ZXN0aW9uJTJDJTIwY29udGV4dCUzRGNvbnRleHQp",highlighted:`reader = pipeline(<span class="hljs-string">&quot;question-answering&quot;</span>, model=model_checkpoint, revision=<span class="hljs-string">&quot;main&quot;</span>)

context = <span class="hljs-string">r&quot;&quot;&quot;
Extractive Question Answering is the task of extracting an answer from a text
given a question. An example of a question answering dataset is the SQuAD
dataset, which is entirely based on that task. If you would like to fine-tune a
model on a SQuAD task, you may leverage the
examples/pytorch/question-answering/run_squad.py script.

🤗 Transformers is interoperable with the PyTorch, TensorFlow, and JAX
frameworks, so you can use your favourite tools for a wide variety of tasks!
&quot;&quot;&quot;</span>

question = <span class="hljs-string">&quot;What is extractive question answering?&quot;</span>
reader(question=question, context=context)`,wrap:!1}}),Me=new h({props:{code:"JTdCJ3Njb3JlJyUzQSUyMDAuMzg2Njk1MzU1MTc2OTI1NjYlMkMlMEElMjAnc3RhcnQnJTNBJTIwMzQlMkMlMEElMjAnZW5kJyUzQSUyMDk1JTJDJTBBJTIwJ2Fuc3dlciclM0ElMjAndGhlJTIwdGFzayUyMG9mJTIwZXh0cmFjdGluZyUyMGFuJTIwYW5zd2VyJTIwZnJvbSUyMGElMjB0ZXh0JTIwZ2l2ZW4lMjBhJTIwcXVlc3Rpb24nJTdE",highlighted:`{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.38669535517692566</span>,
 <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">34</span>,
 <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">95</span>,
 <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;the task of extracting an answer from a text given a question&#x27;</span>}`,wrap:!1}}),ce=new ol({props:{title:"Debugging the forward pass of your model",local:"debugging-the-forward-pass-of-your-model",headingTag:"h2"}}),me=new h({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwcmVhZGVyLnRva2VuaXplciUwQW1vZGVsJTIwJTNEJTIwcmVhZGVyLm1vZGVs",highlighted:`tokenizer = reader.tokenizer
model = reader.model`,wrap:!1}}),we=new h({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAlMjJXaGljaCUyMGZyYW1ld29ya3MlMjBjYW4lMjBJJTIwdXNlJTNGJTIy",highlighted:'question = <span class="hljs-string">&quot;Which frameworks can I use?&quot;</span>',wrap:!1}}),Je=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocXVlc3Rpb24lMkMlMjBjb250ZXh0JTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEFpbnB1dF9pZHMlMjAlM0QlMjBpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlNUIwJTVEJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWFuc3dlcl9zdGFydF9zY29yZXMlMjAlM0QlMjBvdXRwdXRzLnN0YXJ0X2xvZ2l0cyUwQWFuc3dlcl9lbmRfc2NvcmVzJTIwJTNEJTIwb3V0cHV0cy5lbmRfbG9naXRzJTBBJTIzJTIwR2V0JTIwdGhlJTIwbW9zdCUyMGxpa2VseSUyMGJlZ2lubmluZyUyMG9mJTIwYW5zd2VyJTIwd2l0aCUyMHRoZSUyMGFyZ21heCUyMG9mJTIwdGhlJTIwc2NvcmUlMEFhbnN3ZXJfc3RhcnQlMjAlM0QlMjB0b3JjaC5hcmdtYXgoYW5zd2VyX3N0YXJ0X3Njb3JlcyklMEElMjMlMjBHZXQlMjB0aGUlMjBtb3N0JTIwbGlrZWx5JTIwZW5kJTIwb2YlMjBhbnN3ZXIlMjB3aXRoJTIwdGhlJTIwYXJnbWF4JTIwb2YlMjB0aGUlMjBzY29yZSUwQWFuc3dlcl9lbmQlMjAlM0QlMjB0b3JjaC5hcmdtYXgoYW5zd2VyX2VuZF9zY29yZXMpJTIwJTJCJTIwMSUwQWFuc3dlciUyMCUzRCUyMHRva2VuaXplci5jb252ZXJ0X3Rva2Vuc190b19zdHJpbmcoJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyLmNvbnZlcnRfaWRzX3RvX3Rva2VucyhpbnB1dF9pZHMlNUJhbnN3ZXJfc3RhcnQlM0FhbnN3ZXJfZW5kJTVEKSUwQSklMEFwcmludChmJTIyUXVlc3Rpb24lM0ElMjAlN0JxdWVzdGlvbiU3RCUyMiklMEFwcmludChmJTIyQW5zd2VyJTNBJTIwJTdCYW5zd2VyJTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch

inputs = tokenizer(question, context, add_special_tokens=<span class="hljs-literal">True</span>)
input_ids = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>]
outputs = model(**inputs)
answer_start_scores = outputs.start_logits
answer_end_scores = outputs.end_logits
<span class="hljs-comment"># Get the most likely beginning of answer with the argmax of the score</span>
answer_start = torch.argmax(answer_start_scores)
<span class="hljs-comment"># Get the most likely end of answer with the argmax of the score</span>
answer_end = torch.argmax(answer_end_scores) + <span class="hljs-number">1</span>
answer = tokenizer.convert_tokens_to_string(
    tokenizer.convert_ids_to_tokens(input_ids[answer_start:answer_end])
)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Question: <span class="hljs-subst">{question}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Answer: <span class="hljs-subst">{answer}</span>&quot;</span>)`,wrap:!1}}),Ue=new h({props:{code:"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",highlighted:`<span class="hljs-string">&quot;&quot;&quot;
---------------------------------------------------------------------------
AttributeError                            Traceback (most recent call last)
/var/folders/28/k4cy5q7s2hs92xq7_h89_vgm0000gn/T/ipykernel_75743/2725838073.py in &lt;module&gt;
      1 inputs = tokenizer(question, text, add_special_tokens=True)
      2 input_ids = inputs[&quot;input_ids&quot;]
----&gt; 3 outputs = model(**inputs)
      4 answer_start_scores = outputs.start_logits
      5 answer_end_scores = outputs.end_logits

~/miniconda3/envs/huggingface/lib/python3.8/site-packages/torch/nn/modules/module.py in _call_impl(self, *input, **kwargs)
   1049         if not (self._backward_hooks or self._forward_hooks or self._forward_pre_hooks or _global_backward_hooks
   1050                 or _global_forward_hooks or _global_forward_pre_hooks):
-&gt; 1051             return forward_call(*input, **kwargs)
   1052         # Do not call functions when jit is used
   1053         full_backward_hooks, non_full_backward_hooks = [], []

~/miniconda3/envs/huggingface/lib/python3.8/site-packages/transformers/models/distilbert/modeling_distilbert.py in forward(self, input_ids, attention_mask, head_mask, inputs_embeds, start_positions, end_positions, output_attentions, output_hidden_states, return_dict)
    723         return_dict = return_dict if return_dict is not None else self.config.use_return_dict
    724
--&gt; 725         distilbert_output = self.distilbert(
    726             input_ids=input_ids,
    727             attention_mask=attention_mask,

~/miniconda3/envs/huggingface/lib/python3.8/site-packages/torch/nn/modules/module.py in _call_impl(self, *input, **kwargs)
   1049         if not (self._backward_hooks or self._forward_hooks or self._forward_pre_hooks or _global_backward_hooks
   1050                 or _global_forward_hooks or _global_forward_pre_hooks):
-&gt; 1051             return forward_call(*input, **kwargs)
   1052         # Do not call functions when jit is used
   1053         full_backward_hooks, non_full_backward_hooks = [], []

~/miniconda3/envs/huggingface/lib/python3.8/site-packages/transformers/models/distilbert/modeling_distilbert.py in forward(self, input_ids, attention_mask, head_mask, inputs_embeds, output_attentions, output_hidden_states, return_dict)
    471             raise ValueError(&quot;You cannot specify both input_ids and inputs_embeds at the same time&quot;)
    472         elif input_ids is not None:
--&gt; 473             input_shape = input_ids.size()
    474         elif inputs_embeds is not None:
    475             input_shape = inputs_embeds.size()[:-1]

AttributeError: &#x27;list&#x27; object has no attribute &#x27;size&#x27;
&quot;&quot;&quot;</span>`,wrap:!1}}),je=new al({props:{id:"rSPyvPw0p9k"}}),ge=new al({props:{id:"5PkZ4rbHL6c"}}),Ce=new h({props:{code:"aW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTVCJTNBNSU1RA==",highlighted:'inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][:<span class="hljs-number">5</span>]',wrap:!1}}),ke=new h({props:{code:"JTVCMTAxJTJDJTIwMjAyOSUyQyUyMDc3MDUlMkMlMjAyMDE1JTJDJTIwMjA2NCU1RA==",highlighted:'[<span class="hljs-number">101</span>, <span class="hljs-number">2029</span>, <span class="hljs-number">7705</span>, <span class="hljs-number">2015</span>, <span class="hljs-number">2064</span>]',wrap:!1}}),We=new h({props:{code:"dHlwZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQp",highlighted:'<span class="hljs-built_in">type</span>(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])',wrap:!1}}),Ge=new h({props:{code:"bGlzdA==",highlighted:'<span class="hljs-built_in">list</span>',wrap:!1}}),_e=new h({props:{code:"fiUyRm1pbmljb25kYTMlMkZlbnZzJTJGaHVnZ2luZ2ZhY2UlMkZsaWIlMkZweXRob24zLjglMkZzaXRlLXBhY2thZ2VzJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGZGlzdGlsYmVydCUyRm1vZGVsaW5nX2Rpc3RpbGJlcnQucHklMjBpbiUyMGZvcndhcmQoc2VsZiUyQyUyMGlucHV0X2lkcyUyQyUyMGF0dGVudGlvbl9tYXNrJTJDJTIwaGVhZF9tYXNrJTJDJTIwaW5wdXRzX2VtYmVkcyUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTJDJTIwb3V0cHV0X2hpZGRlbl9zdGF0ZXMlMkMlMjByZXR1cm5fZGljdCklMEElMjAlMjAlMjAlMjA0NzElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByYWlzZSUyMFZhbHVlRXJyb3IoJTIyWW91JTIwY2Fubm90JTIwc3BlY2lmeSUyMGJvdGglMjBpbnB1dF9pZHMlMjBhbmQlMjBpbnB1dHNfZW1iZWRzJTIwYXQlMjB0aGUlMjBzYW1lJTIwdGltZSUyMiklMEElMjAlMjAlMjAlMjA0NzIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbGlmJTIwaW5wdXRfaWRzJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBLS0lM0UlMjA0NzMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dF9zaGFwZSUyMCUzRCUyMGlucHV0X2lkcy5zaXplKCklMEElMjAlMjAlMjAlMjA0NzQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbGlmJTIwaW5wdXRzX2VtYmVkcyUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMDQ3NSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0X3NoYXBlJTIwJTNEJTIwaW5wdXRzX2VtYmVkcy5zaXplKCklNUIlM0EtMSU1RCUwQSUwQUF0dHJpYnV0ZUVycm9yJTNBJTIwJ2xpc3QnJTIwb2JqZWN0JTIwaGFzJTIwbm8lMjBhdHRyaWJ1dGUlMjAnc2l6ZSc=",highlighted:`~<span class="hljs-regexp">/miniconda3/</span>envs<span class="hljs-regexp">/huggingface/</span>lib<span class="hljs-regexp">/python3.8/</span>site-packages<span class="hljs-regexp">/transformers/m</span>odels<span class="hljs-regexp">/distilbert/m</span>odeling_distilbert.py in forward(self, input_ids, attention_mask, head_mask, inputs_embeds, output_attentions, output_hidden_states, return_dict)
    <span class="hljs-number">471</span>             raise ValueError(<span class="hljs-string">&quot;You cannot specify both input_ids and inputs_embeds at the same time&quot;</span>)
    <span class="hljs-number">472</span>         elif input_ids is not None:
--&gt; <span class="hljs-number">473</span>             input_shape = input_ids.<span class="hljs-keyword">size</span>()
    <span class="hljs-number">474</span>         elif inputs_embeds is not None:
    <span class="hljs-number">475</span>             input_shape = inputs_embeds.<span class="hljs-keyword">size</span>()[:-<span class="hljs-number">1</span>]

AttributeError: <span class="hljs-string">&#x27;list&#x27;</span> object has no attribute <span class="hljs-string">&#x27;size&#x27;</span>`,wrap:!1}}),$e=new h({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHF1ZXN0aW9uJTJDJTIwY29udGV4dCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWlucHV0X2lkcyUyMCUzRCUyMGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCU1QjAlNUQlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBYW5zd2VyX3N0YXJ0X3Njb3JlcyUyMCUzRCUyMG91dHB1dHMuc3RhcnRfbG9naXRzJTBBYW5zd2VyX2VuZF9zY29yZXMlMjAlM0QlMjBvdXRwdXRzLmVuZF9sb2dpdHMlMEElMjMlMjBHZXQlMjB0aGUlMjBtb3N0JTIwbGlrZWx5JTIwYmVnaW5uaW5nJTIwb2YlMjBhbnN3ZXIlMjB3aXRoJTIwdGhlJTIwYXJnbWF4JTIwb2YlMjB0aGUlMjBzY29yZSUwQWFuc3dlcl9zdGFydCUyMCUzRCUyMHRvcmNoLmFyZ21heChhbnN3ZXJfc3RhcnRfc2NvcmVzKSUwQSUyMyUyMEdldCUyMHRoZSUyMG1vc3QlMjBsaWtlbHklMjBlbmQlMjBvZiUyMGFuc3dlciUyMHdpdGglMjB0aGUlMjBhcmdtYXglMjBvZiUyMHRoZSUyMHNjb3JlJTBBYW5zd2VyX2VuZCUyMCUzRCUyMHRvcmNoLmFyZ21heChhbnN3ZXJfZW5kX3Njb3JlcyklMjAlMkIlMjAxJTBBYW5zd2VyJTIwJTNEJTIwdG9rZW5pemVyLmNvbnZlcnRfdG9rZW5zX3RvX3N0cmluZyglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIuY29udmVydF9pZHNfdG9fdG9rZW5zKGlucHV0X2lkcyU1QmFuc3dlcl9zdGFydCUzQWFuc3dlcl9lbmQlNUQpJTBBKSUwQXByaW50KGYlMjJRdWVzdGlvbiUzQSUyMCU3QnF1ZXN0aW9uJTdEJTIyKSUwQXByaW50KGYlMjJBbnN3ZXIlM0ElMjAlN0JhbnN3ZXIlN0QlMjIp",highlighted:`inputs = tokenizer(question, context, add_special_tokens=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
input_ids = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>]
outputs = model(**inputs)
answer_start_scores = outputs.start_logits
answer_end_scores = outputs.end_logits
<span class="hljs-comment"># Get the most likely beginning of answer with the argmax of the score</span>
answer_start = torch.argmax(answer_start_scores)
<span class="hljs-comment"># Get the most likely end of answer with the argmax of the score</span>
answer_end = torch.argmax(answer_end_scores) + <span class="hljs-number">1</span>
answer = tokenizer.convert_tokens_to_string(
    tokenizer.convert_ids_to_tokens(input_ids[answer_start:answer_end])
)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Question: <span class="hljs-subst">{question}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Answer: <span class="hljs-subst">{answer}</span>&quot;</span>)`,wrap:!1}}),Re=new h({props:{code:"JTIyJTIyJTIyJTBBUXVlc3Rpb24lM0ElMjBXaGljaCUyMGZyYW1ld29ya3MlMjBjYW4lMjBJJTIwdXNlJTNGJTBBQW5zd2VyJTNBJTIwcHl0b3JjaCUyQyUyMHRlbnNvcmZsb3clMkMlMjBhbmQlMjBqYXglMEElMjIlMjIlMjI=",highlighted:`<span class="hljs-string">&quot;&quot;&quot;
Question: Which frameworks can I use?
Answer: pytorch, tensorflow, and jax
&quot;&quot;&quot;</span>`,wrap:!1}}),{c(){m=o("meta"),f=n(),w=o("p"),J=n(),M(I.$$.fragment),Ve=n(),M(W.$$.fragment),ze=n(),G=o("p"),G.innerHTML=rl,Ye=n(),M(X.$$.fragment),He=n(),_=o("p"),_.innerHTML=Ml,Fe=n(),M(B.$$.fragment),Qe=n(),v=o("p"),v.textContent=pl,Se=n(),M($.$$.fragment),Ee=n(),R=o("p"),R.innerHTML=dl,qe=n(),M(x.$$.fragment),Le=n(),A=o("p"),A.innerHTML=yl,De=n(),M(N.$$.fragment),Pe=n(),V=o("p"),V.textContent=cl,Ke=n(),z=o("blockquote"),z.innerHTML=ul,Oe=n(),Y=o("p"),Y.innerHTML=ml,et=n(),M(H.$$.fragment),tt=n(),M(F.$$.fragment),lt=n(),Q=o("p"),Q.innerHTML=hl,st=n(),b=o("div"),b.innerHTML=wl,nt=n(),S=o("p"),S.innerHTML=fl,at=n(),M(j.$$.fragment),ot=n(),E=o("p"),E.innerHTML=Jl,it=n(),M(q.$$.fragment),rt=n(),M(T.$$.fragment),Mt=n(),L=o("p"),L.textContent=Ul,pt=n(),g=o("div"),g.innerHTML=bl,dt=n(),D=o("p"),D.textContent=jl,yt=n(),Z=o("div"),Z.innerHTML=Tl,ct=n(),P=o("p"),P.textContent=gl,ut=n(),M(K.$$.fragment),mt=n(),M(O.$$.fragment),ht=n(),ee=o("p"),ee.innerHTML=Zl,wt=n(),M(te.$$.fragment),ft=n(),M(le.$$.fragment),Jt=n(),se=o("p"),se.innerHTML=Cl,Ut=n(),M(ne.$$.fragment),bt=n(),M(C.$$.fragment),jt=n(),ae=o("p"),ae.innerHTML=kl,Tt=n(),M(oe.$$.fragment),gt=n(),ie=o("p"),ie.innerHTML=Il,Zt=n(),M(re.$$.fragment),Ct=n(),M(Me.$$.fragment),kt=n(),pe=o("p"),pe.textContent=Wl,It=n(),de=o("ul"),de.innerHTML=Gl,Wt=n(),ye=o("p"),ye.textContent=Xl,Gt=n(),M(ce.$$.fragment),Xt=n(),ue=o("p"),ue.innerHTML=_l,_t=n(),M(me.$$.fragment),Bt=n(),he=o("p"),he.textContent=Bl,vt=n(),M(we.$$.fragment),$t=n(),fe=o("p"),fe.innerHTML=vl,Rt=n(),M(Je.$$.fragment),xt=n(),M(Ue.$$.fragment),At=n(),be=o("p"),be.textContent=$l,Nt=n(),M(je.$$.fragment),Vt=n(),Te=o("p"),Te.textContent=Rl,zt=n(),M(ge.$$.fragment),Yt=n(),Ze=o("p"),Ze.innerHTML=xl,Ht=n(),M(Ce.$$.fragment),Ft=n(),M(ke.$$.fragment),Qt=n(),Ie=o("p"),Ie.innerHTML=Al,St=n(),M(We.$$.fragment),Et=n(),M(Ge.$$.fragment),qt=n(),Xe=o("p"),Xe.innerHTML=Nl,Lt=n(),M(_e.$$.fragment),Dt=n(),Be=o("p"),Be.innerHTML=Vl,Pt=n(),k=o("div"),k.innerHTML=zl,Kt=n(),ve=o("p"),ve.innerHTML=Yl,Ot=n(),M($e.$$.fragment),el=n(),M(Re.$$.fragment),tl=n(),xe=o("p"),xe.innerHTML=Hl,ll=n(),Ne=o("p"),this.h()},l(e){const t=Kl("svelte-u9bgzb",document.head);m=i(t,"META",{name:!0,content:!0}),t.forEach(l),f=a(e),w=i(e,"P",{}),El(w).forEach(l),J=a(e),p(I.$$.fragment,e),Ve=a(e),p(W.$$.fragment,e),ze=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-19619h"&&(G.innerHTML=rl),Ye=a(e),p(X.$$.fragment,e),He=a(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-181tebn"&&(_.innerHTML=Ml),Fe=a(e),p(B.$$.fragment,e),Qe=a(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-18urlzn"&&(v.textContent=pl),Se=a(e),p($.$$.fragment,e),Ee=a(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-qcgiqj"&&(R.innerHTML=dl),qe=a(e),p(x.$$.fragment,e),Le=a(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-enwpwn"&&(A.innerHTML=yl),De=a(e),p(N.$$.fragment,e),Pe=a(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-6s3juy"&&(V.textContent=cl),Ke=a(e),z=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(z)!=="svelte-10kuw1g"&&(z.innerHTML=ul),Oe=a(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-8epf3g"&&(Y.innerHTML=ml),et=a(e),p(H.$$.fragment,e),tt=a(e),p(F.$$.fragment,e),lt=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-12wq0e4"&&(Q.innerHTML=hl),st=a(e),b=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-1196hzp"&&(b.innerHTML=wl),nt=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-11rtaxb"&&(S.innerHTML=fl),at=a(e),p(j.$$.fragment,e),ot=a(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-wqjf75"&&(E.innerHTML=Jl),it=a(e),p(q.$$.fragment,e),rt=a(e),p(T.$$.fragment,e),Mt=a(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1jztis4"&&(L.textContent=Ul),pt=a(e),g=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-6ebc1j"&&(g.innerHTML=bl),dt=a(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1pnb2v0"&&(D.textContent=jl),yt=a(e),Z=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(Z)!=="svelte-1b95mxr"&&(Z.innerHTML=Tl),ct=a(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1o5t96w"&&(P.textContent=gl),ut=a(e),p(K.$$.fragment,e),mt=a(e),p(O.$$.fragment,e),ht=a(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-k08cqt"&&(ee.innerHTML=Zl),wt=a(e),p(te.$$.fragment,e),ft=a(e),p(le.$$.fragment,e),Jt=a(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1woc07i"&&(se.innerHTML=Cl),Ut=a(e),p(ne.$$.fragment,e),bt=a(e),p(C.$$.fragment,e),jt=a(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-16x8fi0"&&(ae.innerHTML=kl),Tt=a(e),p(oe.$$.fragment,e),gt=a(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-14almhj"&&(ie.innerHTML=Il),Zt=a(e),p(re.$$.fragment,e),Ct=a(e),p(Me.$$.fragment,e),kt=a(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1z0t5d5"&&(pe.textContent=Wl),It=a(e),de=i(e,"UL",{"data-svelte-h":!0}),r(de)!=="svelte-1toi74m"&&(de.innerHTML=Gl),Wt=a(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-103qql1"&&(ye.textContent=Xl),Gt=a(e),p(ce.$$.fragment,e),Xt=a(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1j6rget"&&(ue.innerHTML=_l),_t=a(e),p(me.$$.fragment,e),Bt=a(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-eorl0c"&&(he.textContent=Bl),vt=a(e),p(we.$$.fragment,e),$t=a(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-7ef49m"&&(fe.innerHTML=vl),Rt=a(e),p(Je.$$.fragment,e),xt=a(e),p(Ue.$$.fragment,e),At=a(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-5a2oif"&&(be.textContent=$l),Nt=a(e),p(je.$$.fragment,e),Vt=a(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1k0vfs9"&&(Te.textContent=Rl),zt=a(e),p(ge.$$.fragment,e),Yt=a(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-kcsozo"&&(Ze.innerHTML=xl),Ht=a(e),p(Ce.$$.fragment,e),Ft=a(e),p(ke.$$.fragment,e),Qt=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-lhz31j"&&(Ie.innerHTML=Al),St=a(e),p(We.$$.fragment,e),Et=a(e),p(Ge.$$.fragment,e),qt=a(e),Xe=i(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1q4c6uw"&&(Xe.innerHTML=Nl),Lt=a(e),p(_e.$$.fragment,e),Dt=a(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-d9peos"&&(Be.innerHTML=Vl),Pt=a(e),k=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(k)!=="svelte-1i8wi5i"&&(k.innerHTML=zl),Kt=a(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1fi1m6j"&&(ve.innerHTML=Yl),Ot=a(e),p($e.$$.fragment,e),el=a(e),p(Re.$$.fragment,e),tl=a(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-hr9zsw"&&(xe.innerHTML=Hl),ll=a(e),Ne=i(e,"P",{}),El(Ne).forEach(l),this.h()},h(){Ae(m,"name","hf:doc:metadata"),Ae(m,"content",as),Ae(b,"class","flex justify-center"),Ae(g,"class","flex justify-center"),Ae(Z,"class","flex justify-center"),Ae(k,"class","flex justify-center")},m(e,t){Ol(document.head,m),s(e,f,t),s(e,w,t),s(e,J,t),d(I,e,t),s(e,Ve,t),d(W,e,t),s(e,ze,t),s(e,G,t),s(e,Ye,t),d(X,e,t),s(e,He,t),s(e,_,t),s(e,Fe,t),d(B,e,t),s(e,Qe,t),s(e,v,t),s(e,Se,t),d($,e,t),s(e,Ee,t),s(e,R,t),s(e,qe,t),d(x,e,t),s(e,Le,t),s(e,A,t),s(e,De,t),d(N,e,t),s(e,Pe,t),s(e,V,t),s(e,Ke,t),s(e,z,t),s(e,Oe,t),s(e,Y,t),s(e,et,t),d(H,e,t),s(e,tt,t),d(F,e,t),s(e,lt,t),s(e,Q,t),s(e,st,t),s(e,b,t),s(e,nt,t),s(e,S,t),s(e,at,t),d(j,e,t),s(e,ot,t),s(e,E,t),s(e,it,t),d(q,e,t),s(e,rt,t),d(T,e,t),s(e,Mt,t),s(e,L,t),s(e,pt,t),s(e,g,t),s(e,dt,t),s(e,D,t),s(e,yt,t),s(e,Z,t),s(e,ct,t),s(e,P,t),s(e,ut,t),d(K,e,t),s(e,mt,t),d(O,e,t),s(e,ht,t),s(e,ee,t),s(e,wt,t),d(te,e,t),s(e,ft,t),d(le,e,t),s(e,Jt,t),s(e,se,t),s(e,Ut,t),d(ne,e,t),s(e,bt,t),d(C,e,t),s(e,jt,t),s(e,ae,t),s(e,Tt,t),d(oe,e,t),s(e,gt,t),s(e,ie,t),s(e,Zt,t),d(re,e,t),s(e,Ct,t),d(Me,e,t),s(e,kt,t),s(e,pe,t),s(e,It,t),s(e,de,t),s(e,Wt,t),s(e,ye,t),s(e,Gt,t),d(ce,e,t),s(e,Xt,t),s(e,ue,t),s(e,_t,t),d(me,e,t),s(e,Bt,t),s(e,he,t),s(e,vt,t),d(we,e,t),s(e,$t,t),s(e,fe,t),s(e,Rt,t),d(Je,e,t),s(e,xt,t),d(Ue,e,t),s(e,At,t),s(e,be,t),s(e,Nt,t),d(je,e,t),s(e,Vt,t),s(e,Te,t),s(e,zt,t),d(ge,e,t),s(e,Yt,t),s(e,Ze,t),s(e,Ht,t),d(Ce,e,t),s(e,Ft,t),d(ke,e,t),s(e,Qt,t),s(e,Ie,t),s(e,St,t),d(We,e,t),s(e,Et,t),d(Ge,e,t),s(e,qt,t),s(e,Xe,t),s(e,Lt,t),d(_e,e,t),s(e,Dt,t),s(e,Be,t),s(e,Pt,t),s(e,k,t),s(e,Kt,t),s(e,ve,t),s(e,Ot,t),d($e,e,t),s(e,el,t),d(Re,e,t),s(e,tl,t),s(e,xe,t),s(e,ll,t),s(e,Ne,t),sl=!0},p(e,[t]){const Fl={};t&2&&(Fl.$$scope={dirty:t,ctx:e}),j.$set(Fl);const Ql={};t&2&&(Ql.$$scope={dirty:t,ctx:e}),T.$set(Ql);const Sl={};t&2&&(Sl.$$scope={dirty:t,ctx:e}),C.$set(Sl)},i(e){sl||(y(I.$$.fragment,e),y(W.$$.fragment,e),y(X.$$.fragment,e),y(B.$$.fragment,e),y($.$$.fragment,e),y(x.$$.fragment,e),y(N.$$.fragment,e),y(H.$$.fragment,e),y(F.$$.fragment,e),y(j.$$.fragment,e),y(q.$$.fragment,e),y(T.$$.fragment,e),y(K.$$.fragment,e),y(O.$$.fragment,e),y(te.$$.fragment,e),y(le.$$.fragment,e),y(ne.$$.fragment,e),y(C.$$.fragment,e),y(oe.$$.fragment,e),y(re.$$.fragment,e),y(Me.$$.fragment,e),y(ce.$$.fragment,e),y(me.$$.fragment,e),y(we.$$.fragment,e),y(Je.$$.fragment,e),y(Ue.$$.fragment,e),y(je.$$.fragment,e),y(ge.$$.fragment,e),y(Ce.$$.fragment,e),y(ke.$$.fragment,e),y(We.$$.fragment,e),y(Ge.$$.fragment,e),y(_e.$$.fragment,e),y($e.$$.fragment,e),y(Re.$$.fragment,e),sl=!0)},o(e){c(I.$$.fragment,e),c(W.$$.fragment,e),c(X.$$.fragment,e),c(B.$$.fragment,e),c($.$$.fragment,e),c(x.$$.fragment,e),c(N.$$.fragment,e),c(H.$$.fragment,e),c(F.$$.fragment,e),c(j.$$.fragment,e),c(q.$$.fragment,e),c(T.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(C.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(Me.$$.fragment,e),c(ce.$$.fragment,e),c(me.$$.fragment,e),c(we.$$.fragment,e),c(Je.$$.fragment,e),c(Ue.$$.fragment,e),c(je.$$.fragment,e),c(ge.$$.fragment,e),c(Ce.$$.fragment,e),c(ke.$$.fragment,e),c(We.$$.fragment,e),c(Ge.$$.fragment,e),c(_e.$$.fragment,e),c($e.$$.fragment,e),c(Re.$$.fragment,e),sl=!1},d(e){e&&(l(f),l(w),l(J),l(Ve),l(ze),l(G),l(Ye),l(He),l(_),l(Fe),l(Qe),l(v),l(Se),l(Ee),l(R),l(qe),l(Le),l(A),l(De),l(Pe),l(V),l(Ke),l(z),l(Oe),l(Y),l(et),l(tt),l(lt),l(Q),l(st),l(b),l(nt),l(S),l(at),l(ot),l(E),l(it),l(rt),l(Mt),l(L),l(pt),l(g),l(dt),l(D),l(yt),l(Z),l(ct),l(P),l(ut),l(mt),l(ht),l(ee),l(wt),l(ft),l(Jt),l(se),l(Ut),l(bt),l(jt),l(ae),l(Tt),l(gt),l(ie),l(Zt),l(Ct),l(kt),l(pe),l(It),l(de),l(Wt),l(ye),l(Gt),l(Xt),l(ue),l(_t),l(Bt),l(he),l(vt),l($t),l(fe),l(Rt),l(xt),l(At),l(be),l(Nt),l(Vt),l(Te),l(zt),l(Yt),l(Ze),l(Ht),l(Ft),l(Qt),l(Ie),l(St),l(Et),l(qt),l(Xe),l(Lt),l(Dt),l(Be),l(Pt),l(k),l(Kt),l(ve),l(Ot),l(el),l(tl),l(xe),l(ll),l(Ne)),l(m),u(I,e),u(W,e),u(X,e),u(B,e),u($,e),u(x,e),u(N,e),u(H,e),u(F,e),u(j,e),u(q,e),u(T,e),u(K,e),u(O,e),u(te,e),u(le,e),u(ne,e),u(C,e),u(oe,e),u(re,e),u(Me,e),u(ce,e),u(me,e),u(we,e),u(Je,e),u(Ue,e),u(je,e),u(ge,e),u(Ce,e),u(ke,e),u(We,e),u(Ge,e),u(_e,e),u($e,e),u(Re,e)}}}const as='{"title":"What to do when you get an error","local":"what-to-do-when-you-get-an-error","sections":[{"title":"Debugging the pipeline from 🤗 Transformers","local":"debugging-the-pipeline-from-transformers","sections":[],"depth":2},{"title":"Debugging the forward pass of your model","local":"debugging-the-forward-pass-of-your-model","sections":[],"depth":2}],"depth":1}';function os(U){return Ll(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class us extends Dl{constructor(m){super(),Pl(this,m,os,ns,ql,{})}}export{us as component};
