import{s as Is,n as Zs,o as $s}from"../chunks/scheduler.85c25b89.js";import{S as ks,i as Bs,g as p,s as a,r as i,A as Ws,h as m,f as l,c as n,j as fs,u as M,x as h,k as Cs,y as Es,a as e,v as o,d as r,t as c,w as y}from"../chunks/index.c9837788.js";import{C as v}from"../chunks/CodeBlock.52fa569e.js";import{H as V,E as Ns}from"../chunks/EditOnGithub.b65eee75.js";function Qs(ys){let J,Y,R,X,j,_,w,hs='<strong>MobileNetV2</strong> is a convolutional neural network architecture that seeks to perform well on mobile devices. It is based on an <a href="https://paperswithcode.com/method/inverted-residual-block" rel="nofollow">inverted residual structure</a> where the residual connections are between the bottleneck layers.  The intermediate expansion layer uses lightweight depthwise convolutions to filter features as a source of non-linearity. As a whole, the architecture of MobileNetV2 contains the initial fully convolution layer with 32 filters, followed by 19 residual bottleneck layers.',H,T,z,d,Js="To load a pretrained model:",F,g,D,b,js="To load and preprocess the image:",L,U,q,u,ws="To get the model predictions:",P,f,K,C,Ts="To get the top-5 predictions class names:",O,I,ss,Z,ds="Replace the model name with the variant you want to use, e.g. <code>mobilenetv2_100</code>. You can find the IDs in the model summaries at the top of this page.",ts,$,gs='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ls,k,es,B,bs="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",as,W,ns,E,Us=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ps,N,ms,Q,us='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',is,G,Ms,x,os,A,rs,S,cs;return j=new V({props:{title:"MobileNet v2",local:"mobilenet-v2",headingTag:"h1"}}),T=new V({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),g=new v({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ21vYmlsZW5ldHYyXzEwMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mobilenetv2_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),U=new v({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),f=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),I=new v({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),k=new V({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),W=new v({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbW9iaWxlbmV0djJfMTAwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mobilenetv2_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),N=new V({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),G=new V({props:{title:"Citation",local:"citation",headingTag:"h2"}}),x=new v({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZhYnMtMTgwMS0wNDM4MSUyQyUwQSUyMCUyMGF1dGhvciUyMCUyMCUyMCUyMCUzRCUyMCU3Qk1hcmslMjBTYW5kbGVyJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQW5kcmV3JTIwRy4lMjBIb3dhcmQlMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBNZW5nbG9uZyUyMFpodSUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEFuZHJleSUyMFpobW9naW5vdiUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMExpYW5nJTdCLSU3RENoaWVoJTIwQ2hlbiU3RCUyQyUwQSUyMCUyMHRpdGxlJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCSW52ZXJ0ZWQlMjBSZXNpZHVhbHMlMjBhbmQlMjBMaW5lYXIlMjBCb3R0bGVuZWNrcyUzQSUyME1vYmlsZSUyME5ldHdvcmtzJTIwZm9yJTIwQ2xhc3NpZmljYXRpb24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBEZXRlY3Rpb24lMjBhbmQlMjBTZWdtZW50YXRpb24lN0QlMkMlMEElMjAlMjBqb3VybmFsJTIwJTIwJTIwJTNEJTIwJTdCQ29SUiU3RCUyQyUwQSUyMCUyMHZvbHVtZSUyMCUyMCUyMCUyMCUzRCUyMCU3QmFicyUyRjE4MDEuMDQzODElN0QlMkMlMEElMjAlMjB5ZWFyJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCMjAxOCU3RCUyQyUwQSUyMCUyMHVybCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3Qmh0dHAlM0ElMkYlMkZhcnhpdi5vcmclMkZhYnMlMkYxODAxLjA0MzgxJTdEJTJDJTBBJTIwJTIwYXJjaGl2ZVByZWZpeCUyMCUzRCUyMCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwZXByaW50JTIwJTIwJTIwJTIwJTNEJTIwJTdCMTgwMS4wNDM4MSU3RCUyQyUwQSUyMCUyMHRpbWVzdGFtcCUyMCUzRCUyMCU3QlR1ZSUyQyUyMDEyJTIwSmFuJTIwMjAyMSUyMDE1JTNBMzAlM0EwNiUyMCUyQjAxMDAlN0QlMkMlMEElMjAlMjBiaWJ1cmwlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwcyUzQSUyRiUyRmRibHAub3JnJTJGcmVjJTJGam91cm5hbHMlMkZjb3JyJTJGYWJzLTE4MDEtMDQzODEuYmliJTdEJTJDJTBBJTIwJTIwYmlic291cmNlJTIwJTNEJTIwJTdCZGJscCUyMGNvbXB1dGVyJTIwc2NpZW5jZSUyMGJpYmxpb2dyYXBoeSUyQyUyMGh0dHBzJTNBJTJGJTJGZGJscC5vcmclN0QlMEElN0Q=",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>abs-<span class="hljs-number">1801</span>-<span class="hljs-number">04381</span>,
  author    = {Mark Sandler and
               Andrew G. Howard and
               Menglong Zhu and
               Andrey Zhmoginov and
               Liang{-}Chieh Chen},
  title     = {Inverted Residuals and Linear Bottlenecks: Mobile Networks <span class="hljs-keyword">for</span> Classification,
               Detection and Segmentation},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1801.04381</span>},
  year      = {<span class="hljs-number">2018</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1801.04381</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1801.04381</span>},
  timestamp = {Tue, <span class="hljs-number">12</span> Jan <span class="hljs-number">2021</span> <span class="hljs-number">15</span>:<span class="hljs-number">30</span>:<span class="hljs-number">06</span> +<span class="hljs-number">0100</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>abs-<span class="hljs-number">1801</span>-<span class="hljs-number">04381</span>.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`,wrap:!1}}),A=new Ns({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/mobilenet-v2.mdx"}}),{c(){J=p("meta"),Y=a(),R=p("p"),X=a(),i(j.$$.fragment),_=a(),w=p("p"),w.innerHTML=hs,H=a(),i(T.$$.fragment),z=a(),d=p("p"),d.textContent=Js,F=a(),i(g.$$.fragment),D=a(),b=p("p"),b.textContent=js,L=a(),i(U.$$.fragment),q=a(),u=p("p"),u.textContent=ws,P=a(),i(f.$$.fragment),K=a(),C=p("p"),C.textContent=Ts,O=a(),i(I.$$.fragment),ss=a(),Z=p("p"),Z.innerHTML=ds,ts=a(),$=p("p"),$.innerHTML=gs,ls=a(),i(k.$$.fragment),es=a(),B=p("p"),B.textContent=bs,as=a(),i(W.$$.fragment),ns=a(),E=p("p"),E.innerHTML=Us,ps=a(),i(N.$$.fragment),ms=a(),Q=p("p"),Q.innerHTML=us,is=a(),i(G.$$.fragment),Ms=a(),i(x.$$.fragment),os=a(),i(A.$$.fragment),rs=a(),S=p("p"),this.h()},l(s){const t=Ws("svelte-u9bgzb",document.head);J=m(t,"META",{name:!0,content:!0}),t.forEach(l),Y=n(s),R=m(s,"P",{}),fs(R).forEach(l),X=n(s),M(j.$$.fragment,s),_=n(s),w=m(s,"P",{"data-svelte-h":!0}),h(w)!=="svelte-fgcsw6"&&(w.innerHTML=hs),H=n(s),M(T.$$.fragment,s),z=n(s),d=m(s,"P",{"data-svelte-h":!0}),h(d)!=="svelte-18ywhxh"&&(d.textContent=Js),F=n(s),M(g.$$.fragment,s),D=n(s),b=m(s,"P",{"data-svelte-h":!0}),h(b)!=="svelte-1c2ipa8"&&(b.textContent=js),L=n(s),M(U.$$.fragment,s),q=n(s),u=m(s,"P",{"data-svelte-h":!0}),h(u)!=="svelte-1n9qsq1"&&(u.textContent=ws),P=n(s),M(f.$$.fragment,s),K=n(s),C=m(s,"P",{"data-svelte-h":!0}),h(C)!=="svelte-19cnvx1"&&(C.textContent=Ts),O=n(s),M(I.$$.fragment,s),ss=n(s),Z=m(s,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-11s0yt3"&&(Z.innerHTML=ds),ts=n(s),$=m(s,"P",{"data-svelte-h":!0}),h($)!=="svelte-1wmi3ea"&&($.innerHTML=gs),ls=n(s),M(k.$$.fragment,s),es=n(s),B=m(s,"P",{"data-svelte-h":!0}),h(B)!=="svelte-9sr7nh"&&(B.textContent=bs),as=n(s),M(W.$$.fragment,s),ns=n(s),E=m(s,"P",{"data-svelte-h":!0}),h(E)!=="svelte-1kguc51"&&(E.innerHTML=Us),ps=n(s),M(N.$$.fragment,s),ms=n(s),Q=m(s,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-1n0coha"&&(Q.innerHTML=us),is=n(s),M(G.$$.fragment,s),Ms=n(s),M(x.$$.fragment,s),os=n(s),M(A.$$.fragment,s),rs=n(s),S=m(s,"P",{}),fs(S).forEach(l),this.h()},h(){Cs(J,"name","hf:doc:metadata"),Cs(J,"content",Gs)},m(s,t){Es(document.head,J),e(s,Y,t),e(s,R,t),e(s,X,t),o(j,s,t),e(s,_,t),e(s,w,t),e(s,H,t),o(T,s,t),e(s,z,t),e(s,d,t),e(s,F,t),o(g,s,t),e(s,D,t),e(s,b,t),e(s,L,t),o(U,s,t),e(s,q,t),e(s,u,t),e(s,P,t),o(f,s,t),e(s,K,t),e(s,C,t),e(s,O,t),o(I,s,t),e(s,ss,t),e(s,Z,t),e(s,ts,t),e(s,$,t),e(s,ls,t),o(k,s,t),e(s,es,t),e(s,B,t),e(s,as,t),o(W,s,t),e(s,ns,t),e(s,E,t),e(s,ps,t),o(N,s,t),e(s,ms,t),e(s,Q,t),e(s,is,t),o(G,s,t),e(s,Ms,t),o(x,s,t),e(s,os,t),o(A,s,t),e(s,rs,t),e(s,S,t),cs=!0},p:Zs,i(s){cs||(r(j.$$.fragment,s),r(T.$$.fragment,s),r(g.$$.fragment,s),r(U.$$.fragment,s),r(f.$$.fragment,s),r(I.$$.fragment,s),r(k.$$.fragment,s),r(W.$$.fragment,s),r(N.$$.fragment,s),r(G.$$.fragment,s),r(x.$$.fragment,s),r(A.$$.fragment,s),cs=!0)},o(s){c(j.$$.fragment,s),c(T.$$.fragment,s),c(g.$$.fragment,s),c(U.$$.fragment,s),c(f.$$.fragment,s),c(I.$$.fragment,s),c(k.$$.fragment,s),c(W.$$.fragment,s),c(N.$$.fragment,s),c(G.$$.fragment,s),c(x.$$.fragment,s),c(A.$$.fragment,s),cs=!1},d(s){s&&(l(Y),l(R),l(X),l(_),l(w),l(H),l(z),l(d),l(F),l(D),l(b),l(L),l(q),l(u),l(P),l(K),l(C),l(O),l(ss),l(Z),l(ts),l($),l(ls),l(es),l(B),l(as),l(ns),l(E),l(ps),l(ms),l(Q),l(is),l(Ms),l(os),l(rs),l(S)),l(J),y(j,s),y(T,s),y(g,s),y(U,s),y(f,s),y(I,s),y(k,s),y(W,s),y(N,s),y(G,s),y(x,s),y(A,s)}}}const Gs='{"title":"MobileNet v2","local":"mobilenet-v2","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function xs(ys){return $s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vs extends ks{constructor(J){super(),Bs(this,J,xs,Qs,Is,{})}}export{Vs as component};
