import{s as Ct,o as $t,n as Tt}from"../chunks/scheduler.9bc65507.js";import{S as Pt,i as Ut,g as a,s,r as p,A as Jt,h as i,f as o,c as r,j as k,u,x as d,k as W,y as c,a as n,v as f,d as h,t as g,w as y}from"../chunks/index.707bf1b6.js";import{T as St}from"../chunks/Tip.c2ecdbf4.js";import{D as ge}from"../chunks/Docstring.17db21ae.js";import{C as Ee}from"../chunks/CodeBlock.54a9f38d.js";import{E as jt}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as ye}from"../chunks/Heading.342b1fa6.js";function It(ae){let l,U="Example:",_,b,T;return b=new Ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN1cGVyUG9pbnRDb25maWclMkMlMjBTdXBlclBvaW50TW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwU3VwZXJQb2ludCUyMHN1cGVycG9pbnQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwU3VwZXJQb2ludENvbmZpZygpJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMHN1cGVycG9pbnQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFN1cGVyUG9pbnRNb2RlbChjb25maWd1cmF0aW9uKSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SuperPointConfig, SuperPointModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SuperPoint superpoint style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SuperPointConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the superpoint style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SuperPointModel(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){l=a("p"),l.textContent=U,_=s(),p(b.$$.fragment)},l(m){l=i(m,"P",{"data-svelte-h":!0}),d(l)!=="svelte-11lpom8"&&(l.textContent=U),_=r(m),u(b.$$.fragment,m)},m(m,C){n(m,l,C),n(m,_,C),f(b,m,C),T=!0},p:Tt,i(m){T||(h(b.$$.fragment,m),T=!0)},o(m){g(b.$$.fragment,m),T=!1},d(m){m&&(o(l),o(_)),y(b,m)}}}function xt(ae){let l,U=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=a("p"),l.innerHTML=U},l(_){l=i(_,"P",{"data-svelte-h":!0}),d(l)!=="svelte-fincs2"&&(l.innerHTML=U)},m(_,b){n(_,l,b)},p:Tt,d(_){_&&o(l)}}}function zt(ae){let l,U,_,b,T,m,C,be,Z,st=`The SuperPoint model was proposed
in <a href="https://arxiv.org/abs/1712.07629" rel="nofollow">SuperPoint: Self-Supervised Interest Point Detection and Description</a> by Daniel
DeTone, Tomasz Malisiewicz and Andrew Rabinovich.`,Me,V,rt=`This model is the result of a self-supervised training of a fully-convolutional network for interest point detection and
description. The model is able to detect interest points that are repeatable under homographic transformations and
provide a descriptor for each point. The use of the model in its own is limited, but it can be used as a feature
extractor for other tasks such as homography estimation, image matching, etc.`,we,R,at="The abstract from the paper is the following:",ve,N,it=`<em>This paper presents a self-supervised framework for training interest point detectors and descriptors suitable for a
large number of multiple-view geometry problems in computer vision. As opposed to patch-based neural networks, our
fully-convolutional model operates on full-sized images and jointly computes pixel-level interest point locations and
associated descriptors in one forward pass. We introduce Homographic Adaptation, a multi-scale, multi-homography
approach for boosting interest point detection repeatability and performing cross-domain adaptation (e.g.,
synthetic-to-real). Our model, when trained on the MS-COCO generic image dataset using Homographic Adaptation, is able
to repeatedly detect a much richer set of interest points than the initial pre-adapted deep model and any other
traditional corner detector. The final system gives rise to state-of-the-art homography estimation results on HPatches
when compared to LIFT, SIFT and ORB.</em>`,Te,G,Ce,B,lt="Here is a quick example of using the model to detect interest points in an image:",$e,H,Pe,q,ct="The outputs contain the list of keypoint coordinates with their respective score and description (a 256-long vector).",Ue,E,dt=`You can also feed multiple images to the model. Due to the nature of SuperPoint, to output a dynamic number of keypoints,
you will need to use the mask attribute to retrieve the respective information :`,Je,D,Se,X,mt="You can then print the keypoints on the image to visualize the result :",je,Y,Ie,L,pt=`This model was contributed by <a href="https://huggingface.co/stevenbucaille" rel="nofollow">stevenbucaille</a>.
The original code can be found <a href="https://github.com/magicleap/SuperPointPretrainedNetwork" rel="nofollow">here</a>.`,xe,F,ze,M,A,De,ie,ut=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointModel">SuperPointModel</a>. It is used to instantiate a
SuperPoint model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the SuperPoint
<a href="https://huggingface.co/magic-leap-community/superpoint" rel="nofollow">magic-leap-community/superpoint</a> architecture.`,Xe,le,ft=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ye,S,ke,Q,We,w,O,Le,ce,ht="Constructs a SuperPoint image processor.",Fe,j,K,Ae,de,gt="Preprocess an image or batch of images.",Qe,I,ee,Oe,me,yt="Resize an image.",Ze,te,_t="<li>preprocess</li>",Ve,oe,Re,v,ne,Ke,pe,bt=`SuperPoint model outputting keypoints and descriptors.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,et,ue,Mt=`SuperPoint model. It consists of a SuperPointEncoder, a SuperPointInterestPointDecoder and a
SuperPointDescriptorDecoder. SuperPoint was proposed in <code>SuperPoint: Self-Supervised Interest Point Detection and Description &lt;https://arxiv.org/abs/1712.07629&gt;</code>__ by Daniel DeTone, Tomasz Malisiewicz, and Andrew Rabinovich. It
is a fully convolutional neural network that extracts keypoints and descriptors from an image. It is trained in a
self-supervised manner, using a combination of a photometric loss and a loss based on the homographic adaptation of
keypoints. It is made of a convolutional encoder and two decoders: one for keypoints and one for descriptors.`,tt,J,se,ot,fe,wt='The <a href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointModel">SuperPointModel</a> forward method, overrides the <code>__call__</code> special method.',nt,x,Ne,re,vt="<li>forward</li>",Ge,_e,Be;return T=new ye({props:{title:"SuperPoint",local:"superpoint",headingTag:"h1"}}),C=new ye({props:{title:"Overview",local:"overview",headingTag:"h2"}}),G=new ye({props:{title:"How to use",local:"how-to-use",headingTag:"h2"}}),H=new Ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtYWdpYy1sZWFwLWNvbW11bml0eSUyRnN1cGVycG9pbnQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm1hZ2ljLWxlYXAtY29tbXVuaXR5JTJGc3VwZXJwb2ludCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModel
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)
model = AutoModel.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)

inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
outputs = model(**inputs)`,wrap:!1}}),D=new Ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmxfaW1hZ2VfMSUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZV8xJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsX2ltYWdlXzElMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBdXJsX2ltYWdlXzIlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnRlc3Qtc3R1ZmYyMDE3JTJGMDAwMDAwMDAwNTY4LmpwZyUyMiUwQWltYWdlXzIlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmxfaW1hZ2VfMiUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZXMlMjAlM0QlMjAlNUJpbWFnZV8xJTJDJTIwaW1hZ2VfMiU1RCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWFnaWMtbGVhcC1jb21tdW5pdHklMkZzdXBlcnBvaW50JTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJtYWdpYy1sZWFwLWNvbW11bml0eSUyRnN1cGVycG9pbnQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihpbWFnZXMpKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlX21hc2slMjAlM0QlMjBvdXRwdXRzLm1hc2slNUJpJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2VfaW5kaWNlcyUyMCUzRCUyMHRvcmNoLm5vbnplcm8oaW1hZ2VfbWFzaykuc3F1ZWV6ZSgpJTBBJTIwJTIwJTIwJTIwaW1hZ2Vfa2V5cG9pbnRzJTIwJTNEJTIwb3V0cHV0cy5rZXlwb2ludHMlNUJpJTVEJTVCaW1hZ2VfaW5kaWNlcyU1RCUwQSUyMCUyMCUyMCUyMGltYWdlX3Njb3JlcyUyMCUzRCUyMG91dHB1dHMuc2NvcmVzJTVCaSU1RCU1QmltYWdlX2luZGljZXMlNUQlMEElMjAlMjAlMjAlMjBpbWFnZV9kZXNjcmlwdG9ycyUyMCUzRCUyMG91dHB1dHMuZGVzY3JpcHRvcnMlNUJpJTVEJTVCaW1hZ2VfaW5kaWNlcyU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModel
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url_image_1 = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image_1 = Image.<span class="hljs-built_in">open</span>(requests.get(url_image_1, stream=<span class="hljs-literal">True</span>).raw)
url_image_2 = <span class="hljs-string">&quot;http://images.cocodataset.org/test-stuff2017/000000000568.jpg&quot;</span>
image_2 = Image.<span class="hljs-built_in">open</span>(requests.get(url_image_2, stream=<span class="hljs-literal">True</span>).raw)

images = [image_1, image_2]

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)
model = AutoModel.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)

inputs = processor(images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
outputs = model(**inputs)

<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(images)):
    image_mask = outputs.mask[i]
    image_indices = torch.nonzero(image_mask).squeeze()
    image_keypoints = outputs.keypoints[i][image_indices]
    image_scores = outputs.scores[i][image_indices]
    image_descriptors = outputs.descriptors[i][image_indices]`,wrap:!1}}),Y=new Ee({props:{code:"aW1wb3J0JTIwY3YyJTBBZm9yJTIwa2V5cG9pbnQlMkMlMjBzY29yZSUyMGluJTIwemlwKGltYWdlX2tleXBvaW50cyUyQyUyMGltYWdlX3Njb3JlcyklM0ElMEElMjAlMjAlMjAlMjBrZXlwb2ludF94JTJDJTIwa2V5cG9pbnRfeSUyMCUzRCUyMGludChrZXlwb2ludCU1QjAlNUQuaXRlbSgpKSUyQyUyMGludChrZXlwb2ludCU1QjElNUQuaXRlbSgpKSUwQSUyMCUyMCUyMCUyMGNvbG9yJTIwJTNEJTIwdHVwbGUoJTVCc2NvcmUuaXRlbSgpJTIwKiUyMDI1NSU1RCUyMColMjAzKSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwY3YyLmNpcmNsZShpbWFnZSUyQyUyMChrZXlwb2ludF94JTJDJTIwa2V5cG9pbnRfeSklMkMlMjAyJTJDJTIwY29sb3IpJTBBY3YyLmltd3JpdGUoJTIyb3V0cHV0X2ltYWdlLnBuZyUyMiUyQyUyMGltYWdlKQ==",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">for</span> keypoint, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(image_keypoints, image_scores):
    keypoint_x, keypoint_y = <span class="hljs-built_in">int</span>(keypoint[<span class="hljs-number">0</span>].item()), <span class="hljs-built_in">int</span>(keypoint[<span class="hljs-number">1</span>].item())
    color = <span class="hljs-built_in">tuple</span>([score.item() * <span class="hljs-number">255</span>] * <span class="hljs-number">3</span>)
    image = cv2.circle(image, (keypoint_x, keypoint_y), <span class="hljs-number">2</span>, color)
cv2.imwrite(<span class="hljs-string">&quot;output_image.png&quot;</span>, image)`,wrap:!1}}),F=new ye({props:{title:"SuperPointConfig",local:"transformers.SuperPointConfig",headingTag:"h2"}}),A=new ge({props:{name:"class transformers.SuperPointConfig",anchor:"transformers.SuperPointConfig",parameters:[{name:"encoder_hidden_sizes",val:": List = [64, 64, 128, 128]"},{name:"decoder_hidden_size",val:": int = 256"},{name:"keypoint_decoder_dim",val:": int = 65"},{name:"descriptor_decoder_dim",val:": int = 256"},{name:"keypoint_threshold",val:": float = 0.005"},{name:"max_keypoints",val:": int = -1"},{name:"nms_radius",val:": int = 4"},{name:"border_removal_distance",val:": int = 4"},{name:"initializer_range",val:" = 0.02"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointConfig.encoder_hidden_sizes",description:`<strong>encoder_hidden_sizes</strong> (<code>List</code>, <em>optional</em>, defaults to <code>[64, 64, 128, 128]</code>) &#x2014;
The number of channels in each convolutional layer in the encoder.`,name:"encoder_hidden_sizes"},{anchor:"transformers.SuperPointConfig.decoder_hidden_size",description:"<strong>decoder_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014; The hidden size of the decoder.",name:"decoder_hidden_size"},{anchor:"transformers.SuperPointConfig.keypoint_decoder_dim",description:"<strong>keypoint_decoder_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 65) &#x2014; The output dimension of the keypoint decoder.",name:"keypoint_decoder_dim"},{anchor:"transformers.SuperPointConfig.descriptor_decoder_dim",description:"<strong>descriptor_decoder_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014; The output dimension of the descriptor decoder.",name:"descriptor_decoder_dim"},{anchor:"transformers.SuperPointConfig.keypoint_threshold",description:`<strong>keypoint_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.005) &#x2014;
The threshold to use for extracting keypoints.`,name:"keypoint_threshold"},{anchor:"transformers.SuperPointConfig.max_keypoints",description:`<strong>max_keypoints</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
The maximum number of keypoints to extract. If <code>-1</code>, will extract all keypoints.`,name:"max_keypoints"},{anchor:"transformers.SuperPointConfig.nms_radius",description:`<strong>nms_radius</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The radius for non-maximum suppression.`,name:"nms_radius"},{anchor:"transformers.SuperPointConfig.border_removal_distance",description:`<strong>border_removal_distance</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The distance from the border to remove keypoints.`,name:"border_removal_distance"},{anchor:"transformers.SuperPointConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/configuration_superpoint.py#L27"}}),S=new jt({props:{anchor:"transformers.SuperPointConfig.example",$$slots:{default:[It]},$$scope:{ctx:ae}}}),Q=new ye({props:{title:"SuperPointImageProcessor",local:"transformers.SuperPointImageProcessor",headingTag:"h2"}}),O=new ge({props:{name:"class transformers.SuperPointImageProcessor",anchor:"transformers.SuperPointImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overriden
by <code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.SuperPointImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 480, &quot;width&quot;: 640}</code>):
Resolution of the output image after <code>resize</code> is applied. Only has an effect if <code>do_resize</code> is set to
<code>True</code>. Can be overriden by <code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.SuperPointImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overriden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.SuperPointImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overriden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/image_processing_superpoint.py#L87"}}),K=new ge({props:{name:"preprocess",anchor:"transformers.SuperPointImageProcessor.preprocess",parameters:[{name:"images",val:""},{name:"do_resize",val:": bool = None"},{name:"size",val:": Dict = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.SuperPointImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.SuperPointImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the output image after <code>resize</code> has been applied. If <code>size[&quot;shortest_edge&quot;]</code> &gt;= 384, the image
is resized to <code>(size[&quot;shortest_edge&quot;], size[&quot;shortest_edge&quot;])</code>. Otherwise, the smaller edge of the
image will be matched to <code>int(size[&quot;shortest_edge&quot;]/ crop_pct)</code>, after which the image is cropped to
<code>(size[&quot;shortest_edge&quot;], size[&quot;shortest_edge&quot;])</code>. Only has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"size"},{anchor:"transformers.SuperPointImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.SuperPointImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.SuperPointImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.SuperPointImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.SuperPointImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/image_processing_superpoint.py#L164"}}),ee=new ge({props:{name:"resize",anchor:"transformers.SuperPointImageProcessor.resize",parameters:[{name:"image",val:": ndarray"},{name:"size",val:": Dict"},{name:"data_format",val:": Union = None"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointImageProcessor.resize.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to resize.`,name:"image"},{anchor:"transformers.SuperPointImageProcessor.resize.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>) &#x2014;
Dictionary of the form <code>{&quot;height&quot;: int, &quot;width&quot;: int}</code>, specifying the size of the output image.`,name:"size"},{anchor:"transformers.SuperPointImageProcessor.resize.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the output image. If not provided, it will be inferred from the input
image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.SuperPointImageProcessor.resize.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/image_processing_superpoint.py#L125"}}),oe=new ye({props:{title:"SuperPointModel",local:"transformers.SuperPointModel",headingTag:"h2"}}),ne=new ge({props:{name:"class transformers.SuperPointModel",anchor:"transformers.SuperPointModel",parameters:[{name:"config",val:": SuperPointConfig"}],parametersDescription:[{anchor:"transformers.SuperPointModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointConfig">SuperPointConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/modeling_superpoint.py#L389"}}),se=new ge({props:{name:"forward",anchor:"transformers.SuperPointModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor = None"},{name:"labels",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.SuperPointModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointImageProcessor">SuperPointImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">SuperPointImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.SuperPointModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for more
detail.`,name:"output_hidden_states"},{anchor:"transformers.SuperPointModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.</p>
<p>Examples:`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/modeling_superpoint.py#L414"}}),x=new St({props:{$$slots:{default:[xt]},$$scope:{ctx:ae}}}),{c(){l=a("meta"),U=s(),_=a("p"),b=s(),p(T.$$.fragment),m=s(),p(C.$$.fragment),be=s(),Z=a("p"),Z.innerHTML=st,Me=s(),V=a("p"),V.textContent=rt,we=s(),R=a("p"),R.textContent=at,ve=s(),N=a("p"),N.innerHTML=it,Te=s(),p(G.$$.fragment),Ce=s(),B=a("p"),B.textContent=lt,$e=s(),p(H.$$.fragment),Pe=s(),q=a("p"),q.textContent=ct,Ue=s(),E=a("p"),E.textContent=dt,Je=s(),p(D.$$.fragment),Se=s(),X=a("p"),X.textContent=mt,je=s(),p(Y.$$.fragment),Ie=s(),L=a("p"),L.innerHTML=pt,xe=s(),p(F.$$.fragment),ze=s(),M=a("div"),p(A.$$.fragment),De=s(),ie=a("p"),ie.innerHTML=ut,Xe=s(),le=a("p"),le.innerHTML=ft,Ye=s(),p(S.$$.fragment),ke=s(),p(Q.$$.fragment),We=s(),w=a("div"),p(O.$$.fragment),Le=s(),ce=a("p"),ce.textContent=ht,Fe=s(),j=a("div"),p(K.$$.fragment),Ae=s(),de=a("p"),de.textContent=gt,Qe=s(),I=a("div"),p(ee.$$.fragment),Oe=s(),me=a("p"),me.textContent=yt,Ze=s(),te=a("ul"),te.innerHTML=_t,Ve=s(),p(oe.$$.fragment),Re=s(),v=a("div"),p(ne.$$.fragment),Ke=s(),pe=a("p"),pe.innerHTML=bt,et=s(),ue=a("p"),ue.innerHTML=Mt,tt=s(),J=a("div"),p(se.$$.fragment),ot=s(),fe=a("p"),fe.innerHTML=wt,nt=s(),p(x.$$.fragment),Ne=s(),re=a("ul"),re.innerHTML=vt,Ge=s(),_e=a("p"),this.h()},l(e){const t=Jt("svelte-u9bgzb",document.head);l=i(t,"META",{name:!0,content:!0}),t.forEach(o),U=r(e),_=i(e,"P",{}),k(_).forEach(o),b=r(e),u(T.$$.fragment,e),m=r(e),u(C.$$.fragment,e),be=r(e),Z=i(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-3y1k2h"&&(Z.innerHTML=st),Me=r(e),V=i(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-113tmz"&&(V.textContent=rt),we=r(e),R=i(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-vfdo9a"&&(R.textContent=at),ve=r(e),N=i(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-110fra1"&&(N.innerHTML=it),Te=r(e),u(G.$$.fragment,e),Ce=r(e),B=i(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-u2cob9"&&(B.textContent=lt),$e=r(e),u(H.$$.fragment,e),Pe=r(e),q=i(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-qs9qlh"&&(q.textContent=ct),Ue=r(e),E=i(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-g88i9e"&&(E.textContent=dt),Je=r(e),u(D.$$.fragment,e),Se=r(e),X=i(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1ma1uoo"&&(X.textContent=mt),je=r(e),u(Y.$$.fragment,e),Ie=r(e),L=i(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1s32sqj"&&(L.innerHTML=pt),xe=r(e),u(F.$$.fragment,e),ze=r(e),M=i(e,"DIV",{class:!0});var $=k(M);u(A.$$.fragment,$),De=r($),ie=i($,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1escmys"&&(ie.innerHTML=ut),Xe=r($),le=i($,"P",{"data-svelte-h":!0}),d(le)!=="svelte-o55m63"&&(le.innerHTML=ft),Ye=r($),u(S.$$.fragment,$),$.forEach(o),ke=r(e),u(Q.$$.fragment,e),We=r(e),w=i(e,"DIV",{class:!0});var P=k(w);u(O.$$.fragment,P),Le=r(P),ce=i(P,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-bn94yj"&&(ce.textContent=ht),Fe=r(P),j=i(P,"DIV",{class:!0});var He=k(j);u(K.$$.fragment,He),Ae=r(He),de=i(He,"P",{"data-svelte-h":!0}),d(de)!=="svelte-1x3yxsa"&&(de.textContent=gt),He.forEach(o),Qe=r(P),I=i(P,"DIV",{class:!0});var qe=k(I);u(ee.$$.fragment,qe),Oe=r(qe),me=i(qe,"P",{"data-svelte-h":!0}),d(me)!=="svelte-1eb2h1k"&&(me.textContent=yt),qe.forEach(o),P.forEach(o),Ze=r(e),te=i(e,"UL",{"data-svelte-h":!0}),d(te)!=="svelte-j0c82d"&&(te.innerHTML=_t),Ve=r(e),u(oe.$$.fragment,e),Re=r(e),v=i(e,"DIV",{class:!0});var z=k(v);u(ne.$$.fragment,z),Ke=r(z),pe=i(z,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-1jukl7g"&&(pe.innerHTML=bt),et=r(z),ue=i(z,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1177mku"&&(ue.innerHTML=Mt),tt=r(z),J=i(z,"DIV",{class:!0});var he=k(J);u(se.$$.fragment,he),ot=r(he),fe=i(he,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-1ym4x9a"&&(fe.innerHTML=wt),nt=r(he),u(x.$$.fragment,he),he.forEach(o),z.forEach(o),Ne=r(e),re=i(e,"UL",{"data-svelte-h":!0}),d(re)!=="svelte-n3ow4o"&&(re.innerHTML=vt),Ge=r(e),_e=i(e,"P",{}),k(_e).forEach(o),this.h()},h(){W(l,"name","hf:doc:metadata"),W(l,"content",kt),W(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){c(document.head,l),n(e,U,t),n(e,_,t),n(e,b,t),f(T,e,t),n(e,m,t),f(C,e,t),n(e,be,t),n(e,Z,t),n(e,Me,t),n(e,V,t),n(e,we,t),n(e,R,t),n(e,ve,t),n(e,N,t),n(e,Te,t),f(G,e,t),n(e,Ce,t),n(e,B,t),n(e,$e,t),f(H,e,t),n(e,Pe,t),n(e,q,t),n(e,Ue,t),n(e,E,t),n(e,Je,t),f(D,e,t),n(e,Se,t),n(e,X,t),n(e,je,t),f(Y,e,t),n(e,Ie,t),n(e,L,t),n(e,xe,t),f(F,e,t),n(e,ze,t),n(e,M,t),f(A,M,null),c(M,De),c(M,ie),c(M,Xe),c(M,le),c(M,Ye),f(S,M,null),n(e,ke,t),f(Q,e,t),n(e,We,t),n(e,w,t),f(O,w,null),c(w,Le),c(w,ce),c(w,Fe),c(w,j),f(K,j,null),c(j,Ae),c(j,de),c(w,Qe),c(w,I),f(ee,I,null),c(I,Oe),c(I,me),n(e,Ze,t),n(e,te,t),n(e,Ve,t),f(oe,e,t),n(e,Re,t),n(e,v,t),f(ne,v,null),c(v,Ke),c(v,pe),c(v,et),c(v,ue),c(v,tt),c(v,J),f(se,J,null),c(J,ot),c(J,fe),c(J,nt),f(x,J,null),n(e,Ne,t),n(e,re,t),n(e,Ge,t),n(e,_e,t),Be=!0},p(e,[t]){const $={};t&2&&($.$$scope={dirty:t,ctx:e}),S.$set($);const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),x.$set(P)},i(e){Be||(h(T.$$.fragment,e),h(C.$$.fragment,e),h(G.$$.fragment,e),h(H.$$.fragment,e),h(D.$$.fragment,e),h(Y.$$.fragment,e),h(F.$$.fragment,e),h(A.$$.fragment,e),h(S.$$.fragment,e),h(Q.$$.fragment,e),h(O.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(oe.$$.fragment,e),h(ne.$$.fragment,e),h(se.$$.fragment,e),h(x.$$.fragment,e),Be=!0)},o(e){g(T.$$.fragment,e),g(C.$$.fragment,e),g(G.$$.fragment,e),g(H.$$.fragment,e),g(D.$$.fragment,e),g(Y.$$.fragment,e),g(F.$$.fragment,e),g(A.$$.fragment,e),g(S.$$.fragment,e),g(Q.$$.fragment,e),g(O.$$.fragment,e),g(K.$$.fragment,e),g(ee.$$.fragment,e),g(oe.$$.fragment,e),g(ne.$$.fragment,e),g(se.$$.fragment,e),g(x.$$.fragment,e),Be=!1},d(e){e&&(o(U),o(_),o(b),o(m),o(be),o(Z),o(Me),o(V),o(we),o(R),o(ve),o(N),o(Te),o(Ce),o(B),o($e),o(Pe),o(q),o(Ue),o(E),o(Je),o(Se),o(X),o(je),o(Ie),o(L),o(xe),o(ze),o(M),o(ke),o(We),o(w),o(Ze),o(te),o(Ve),o(Re),o(v),o(Ne),o(re),o(Ge),o(_e)),o(l),y(T,e),y(C,e),y(G,e),y(H,e),y(D,e),y(Y,e),y(F,e),y(A),y(S),y(Q,e),y(O),y(K),y(ee),y(oe,e),y(ne),y(se),y(x)}}}const kt='{"title":"SuperPoint","local":"superpoint","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"How to use","local":"how-to-use","sections":[],"depth":2},{"title":"SuperPointConfig","local":"transformers.SuperPointConfig","sections":[],"depth":2},{"title":"SuperPointImageProcessor","local":"transformers.SuperPointImageProcessor","sections":[],"depth":2},{"title":"SuperPointModel","local":"transformers.SuperPointModel","sections":[],"depth":2}],"depth":1}';function Wt(ae){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qt extends Pt{constructor(l){super(),Ut(this,l,Wt,zt,Ct,{})}}export{qt as component};
