import{s as Ot,o as el,n as Kt}from"../chunks/scheduler.182ea377.js";import{S as tl,i as ll,g as i,s as a,r as m,A as sl,h as p,f as l,c as n,j as Pt,u as c,x as o,k as qt,y as al,a as s,v as u,d,t as h,w as M}from"../chunks/index.abf12888.js";import{T as Dt}from"../chunks/Tip.230e2334.js";import{C as y}from"../chunks/CodeBlock.57fe6e13.js";import{D as nl}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as Te}from"../chunks/Heading.16916d63.js";function il(ye){let r,w='Learn more details in the <a href="#how-does-parallelization-work">How does parallelization work?</a> section.';return{c(){r=i("p"),r.innerHTML=w},l(f){r=p(f,"P",{"data-svelte-h":!0}),o(r)!=="svelte-5pbnhk"&&(r.innerHTML=w)},m(f,T){s(f,r,T)},p:Kt,d(f){f&&l(r)}}}function pl(ye){let r,w="You need to ensure all your inputs have the same shape in subsequent calls, otherwise JAX will need to recompile the code which is slower.";return{c(){r=i("p"),r.textContent=w},l(f){r=p(f,"P",{"data-svelte-h":!0}),o(r)!=="svelte-jgm5rf"&&(r.textContent=w)},m(f,T){s(f,r,T)},p:Kt,d(f){f&&l(r)}}}function ol(ye){let r,w,f,T,j,be,U,Je,g,wt="🤗 Diffusers supports Flax for super fast inference on Google TPUs, such as those available in Colab, Kaggle or Google Cloud Platform. This guide shows you how to run inference with Stable Diffusion using JAX/Flax.",je,$,Tt="Before you begin, make sure you have the necessary libraries installed:",Ue,v,ge,B,bt="You should also make sure you’re using a TPU backend. While JAX does not run exclusively on TPUs, you’ll get the best performance on a TPU because each server has 8 TPU accelerators working in parallel.",$e,_,Jt="If you are running this guide in Colab, select <em>Runtime</em> in the menu above, select the option <em>Change runtime type</em>, and then select <em>TPU</em> under the <em>Hardware accelerator</em> setting. Import JAX and quickly check whether you’re using a TPU:",ve,C,Be,I,jt="Great, now you can import the rest of the dependencies you’ll need:",_e,x,Ce,k,Ie,W,Ut="Flax is a functional framework, so models are stateless and parameters are stored outside of them. Loading a pretrained Flax pipeline returns <em>both</em> the pipeline and the model weights (or parameters). In this guide, you’ll use <code>bfloat16</code>, a more efficient half-float type that is supported by TPUs (you can also use <code>float32</code> for full precision if you want).",xe,G,ke,X,We,Z,gt="TPUs usually have 8 devices working in parallel, so let’s use the same prompt for each device. This means you can perform inference on 8 devices at once, with each device generating one image. As a result, you’ll get 8 images in the same amount of time it takes for one chip to generate a single image!",Ge,b,Xe,H,$t="After replicating the prompt, get the tokenized text ids by calling the <code>prepare_inputs</code> function on the pipeline. The length of the tokenized text is set to 77 tokens as required by the configuration of the underlying CLIP text model.",Ze,F,He,Y,vt='Model parameters and inputs have to be replicated across the 8 parallel devices. The parameters dictionary is replicated with <a href="https://flax.readthedocs.io/en/latest/api_reference/flax.jax_utils.html#flax.jax_utils.replicate" rel="nofollow"><code>flax.jax_utils.replicate</code></a> which traverses the dictionary and changes the shape of the weights so they are repeated 8 times. Arrays are replicated using <code>shard</code>.',Fe,Q,Ye,z,Bt="This shape means each one of the 8 devices receives as an input a <code>jnp</code> array with shape <code>(1, 77)</code>, where <code>1</code> is the batch size per device. On TPUs with sufficient memory, you could have a batch size larger than <code>1</code> if you want to generate multiple images (per chip) at once.",Qe,E,_t="Next, create a random number generator to pass to the generation function. This is standard procedure in Flax, which is very serious and opinionated about random numbers. All functions that deal with random numbers are expected to receive a generator to ensure reproducibility, even when you’re training across multiple distributed devices.",ze,R,Ct="The helper function below uses a seed to initialize a random number generator. As long as you use the same seed, you’ll get the exact same results. Feel free to use different seeds when exploring results later in the guide.",Ee,N,Re,L,It="The helper function, or <code>rng</code>, is split 8 times so each device receives a different generator and generates a different image.",Ne,V,Le,S,xt="To take advantage of JAX’s optimized speed on a TPU, pass <code>jit=True</code> to the pipeline to compile the JAX code into an efficient representation and to ensure the model runs in parallel across the 8 devices.",Ve,J,Se,A,kt="The first inference run takes more time because it needs to compile the code, but subsequent calls (even with different inputs) are much faster. For example, it took more than a minute to compile on a TPU v2-8, but then it takes about <strong>7s</strong> on a future inference run!",Ae,P,Pe,q,Wt='The returned array has shape <code>(8, 1, 512, 512, 3)</code> which should be reshaped to remove the second dimension and get 8 images of <code>512 × 512 × 3</code>. Then you can use the <a href="/docs/diffusers/v0.26.2/en/api/utilities#diffusers.utils.numpy_to_pil">numpy_to_pil()</a> function to convert the arrays into images.',qe,D,De,K,Gt='<img src="https://huggingface.co/datasets/YiYiXu/test-doc-assets/resolve/main/stable_diffusion_jax_how_to_cell_38_output_0.jpeg" alt="img"/>',Ke,O,Oe,ee,Xt="You don’t necessarily have to use the same prompt on all devices. For example, to generate 8 different prompts:",et,te,tt,le,Zt='<img src="https://huggingface.co/datasets/YiYiXu/test-doc-assets/resolve/main/stable_diffusion_jax_how_to_cell_43_output_0.jpeg" alt="img"/>',lt,se,st,ae,Ht="The Flax pipeline in 🤗 Diffusers automatically compiles the model and runs it in parallel on all available devices. Let’s take a closer look at how that process works.",at,ne,Ft='JAX parallelization can be done in multiple ways. The easiest one revolves around using the <a href="https://jax.readthedocs.io/en/latest/_autosummary/jax.pmap.html" rel="nofollow"><code>jax.pmap</code></a> function to achieve single-program multiple-data (SPMD) parallelization. It means running several copies of the same code, each on different data inputs. More sophisticated approaches are possible, and you can go over to the JAX <a href="https://jax.readthedocs.io/en/latest/index.html" rel="nofollow">documentation</a> to explore this topic in more detail if you are interested!',nt,ie,Yt="<code>jax.pmap</code> does two things:",it,pe,Qt="<li>Compiles (or ”<code>jit</code>s”) the code which is similar to <code>jax.jit()</code>. This does not happen when you call <code>pmap</code>, and only the first time the <code>pmap</code>ped function is called.</li> <li>Ensures the compiled code runs in parallel on all available devices.</li>",pt,oe,zt="To demonstrate, call <code>pmap</code> on the pipeline’s <code>_generate</code> method (this is a private method that generates images and may be renamed or removed in future releases of 🤗 Diffusers):",ot,re,rt,me,Et="After calling <code>pmap</code>, the prepared function <code>p_generate</code> will:",mt,ce,Rt="<li>Make a copy of the underlying function, <code>pipeline._generate</code>, on each device.</li> <li>Send each device a different portion of the input arguments (this is why it’s necessary to call the <em>shard</em> function). In this case, <code>prompt_ids</code> has shape <code>(8, 1, 77, 768)</code> so the array is split into 8 and each copy of <code>_generate</code> receives an input with shape <code>(1, 77, 768)</code>.</li>",ct,ue,Nt="The most important thing to pay attention to here is the batch size (1 in this example), and the input dimensions that make sense for your code. You don’t have to change anything else to make the code work in parallel.",ut,de,Lt="The first time you call the pipeline takes more time, but the calls afterward are much faster. The <code>block_until_ready</code> function is used to correctly measure inference time because JAX uses asynchronous dispatch and returns control to the Python loop as soon as it can. You don’t need to use that in your code; blocking occurs automatically when you want to use the result of a computation that has not yet been materialized.",dt,he,ht,Me,Vt="Check your image dimensions to see if they’re correct:",Mt,fe,ft,we,yt;return j=new Te({props:{title:"JAX/Flax",local:"jaxflax",headingTag:"h1"}}),U=new nl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/stable_diffusion_jax_how_to.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/stable_diffusion_jax_how_to.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/stable_diffusion_jax_how_to.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/stable_diffusion_jax_how_to.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/stable_diffusion_jax_how_to.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/stable_diffusion_jax_how_to.ipynb"}]}}),v=new y({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwLXElMjBqYXglM0QlM0QwLjMuMjUlMjBqYXhsaWIlM0QlM0QwLjMuMjUlMjBmbGF4JTIwdHJhbnNmb3JtZXJzJTIwZnRmeSUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwLXElMjBkaWZmdXNlcnM=",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install -q jax==0.3.25 jaxlib==0.3.25 flax transformers ftfy</span>
<span class="hljs-comment">#!pip install -q diffusers</span>`,wrap:!1}}),C=new y({props:{code:"aW1wb3J0JTIwamF4JTBBaW1wb3J0JTIwamF4LnRvb2xzLmNvbGFiX3RwdSUwQWpheC50b29scy5jb2xhYl90cHUuc2V0dXBfdHB1KCklMEElMEFudW1fZGV2aWNlcyUyMCUzRCUyMGpheC5kZXZpY2VfY291bnQoKSUwQWRldmljZV90eXBlJTIwJTNEJTIwamF4LmRldmljZXMoKSU1QjAlNUQuZGV2aWNlX2tpbmQlMEElMEFwcmludChmJTIyRm91bmQlMjAlN0JudW1fZGV2aWNlcyU3RCUyMEpBWCUyMGRldmljZXMlMjBvZiUyMHR5cGUlMjAlN0JkZXZpY2VfdHlwZSU3RC4lMjIpJTBBYXNzZXJ0JTIwKCUwQSUyMCUyMCUyMCUyMCUyMlRQVSUyMiUyMGluJTIwZGV2aWNlX3R5cGUlMkMlMEElMjAlMjAlMjAlMjAlMjJBdmFpbGFibGUlMjBkZXZpY2UlMjBpcyUyMG5vdCUyMGElMjBUUFUlMkMlMjBwbGVhc2UlMjBzZWxlY3QlMjBUUFUlMjBmcm9tJTIwUnVudGltZSUyMCUzRSUyMENoYW5nZSUyMHJ1bnRpbWUlMjB0eXBlJTIwJTNFJTIwSGFyZHdhcmUlMjBhY2NlbGVyYXRvciUyMiUwQSklMEElMjMlMjBGb3VuZCUyMDglMjBKQVglMjBkZXZpY2VzJTIwb2YlMjB0eXBlJTIwQ2xvdWQlMjBUUFUu",highlighted:`<span class="hljs-keyword">import</span> jax
<span class="hljs-keyword">import</span> jax.tools.colab_tpu
jax.tools.colab_tpu.setup_tpu()

num_devices = jax.device_count()
device_type = jax.devices()[<span class="hljs-number">0</span>].device_kind

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Found <span class="hljs-subst">{num_devices}</span> JAX devices of type <span class="hljs-subst">{device_type}</span>.&quot;</span>)
<span class="hljs-keyword">assert</span> (
    <span class="hljs-string">&quot;TPU&quot;</span> <span class="hljs-keyword">in</span> device_type,
    <span class="hljs-string">&quot;Available device is not a TPU, please select TPU from Runtime &gt; Change runtime type &gt; Hardware accelerator&quot;</span>
)
<span class="hljs-comment"># Found 8 JAX devices of type Cloud TPU.</span>`,wrap:!1}}),x=new y({props:{code:"aW1wb3J0JTIwamF4Lm51bXB5JTIwYXMlMjBqbnAlMEFmcm9tJTIwamF4JTIwaW1wb3J0JTIwcG1hcCUwQWZyb20lMjBmbGF4LmpheF91dGlscyUyMGltcG9ydCUyMHJlcGxpY2F0ZSUwQWZyb20lMjBmbGF4LnRyYWluaW5nLmNvbW1vbl91dGlscyUyMGltcG9ydCUyMHNoYXJkJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhTdGFibGVEaWZmdXNpb25QaXBlbGluZQ==",highlighted:`<span class="hljs-keyword">import</span> jax.numpy <span class="hljs-keyword">as</span> jnp
<span class="hljs-keyword">from</span> jax <span class="hljs-keyword">import</span> pmap
<span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionPipeline`,wrap:!1}}),k=new Te({props:{title:"Load a model",local:"load-a-model",headingTag:"h2"}}),G=new y({props:{code:"ZHR5cGUlMjAlM0QlMjBqbnAuYmZsb2F0MTYlMEFwaXBlbGluZSUyQyUyMHBhcmFtcyUyMCUzRCUyMEZsYXhTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUyQyUwQSUyMCUyMCUyMCUyMHJldmlzaW9uJTNEJTIyYmYxNiUyMiUyQyUwQSUyMCUyMCUyMCUyMGR0eXBlJTNEZHR5cGUlMkMlMEEp",highlighted:`dtype = jnp.bfloat16
pipeline, params = FlaxStableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>,
    revision=<span class="hljs-string">&quot;bf16&quot;</span>,
    dtype=dtype,
)`,wrap:!1}}),X=new Te({props:{title:"Inference",local:"inference",headingTag:"h2"}}),b=new Dt({props:{$$slots:{default:[il]},$$scope:{ctx:ye}}}),F=new y({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQSUyMGNpbmVtYXRpYyUyMGZpbG0lMjBzdGlsbCUyMG9mJTIwTW9yZ2FuJTIwRnJlZW1hbiUyMHN0YXJyaW5nJTIwYXMlMjBKaW1pJTIwSGVuZHJpeCUyQyUyMHBvcnRyYWl0JTJDJTIwNDBtbSUyMGxlbnMlMkMlMjBzaGFsbG93JTIwZGVwdGglMjBvZiUyMGZpZWxkJTJDJTIwY2xvc2UlMjB1cCUyQyUyMHNwbGl0JTIwbGlnaHRpbmclMkMlMjBjaW5lbWF0aWMlMjIlMEFwcm9tcHQlMjAlM0QlMjAlNUJwcm9tcHQlNUQlMjAqJTIwamF4LmRldmljZV9jb3VudCgpJTBBcHJvbXB0X2lkcyUyMCUzRCUyMHBpcGVsaW5lLnByZXBhcmVfaW5wdXRzKHByb21wdCklMEFwcm9tcHRfaWRzLnNoYXBlJTBBJTIzJTIwKDglMkMlMjA3Nyk=",highlighted:`prompt = <span class="hljs-string">&quot;A cinematic film still of Morgan Freeman starring as Jimi Hendrix, portrait, 40mm lens, shallow depth of field, close up, split lighting, cinematic&quot;</span>
prompt = [prompt] * jax.device_count()
prompt_ids = pipeline.prepare_inputs(prompt)
prompt_ids.shape
<span class="hljs-comment"># (8, 77)</span>`,wrap:!1}}),Q=new y({props:{code:"JTIzJTIwcGFyYW1ldGVycyUwQXBfcGFyYW1zJTIwJTNEJTIwcmVwbGljYXRlKHBhcmFtcyklMEElMEElMjMlMjBhcnJheXMlMEFwcm9tcHRfaWRzJTIwJTNEJTIwc2hhcmQocHJvbXB0X2lkcyklMEFwcm9tcHRfaWRzLnNoYXBlJTBBJTIzJTIwKDglMkMlMjAxJTJDJTIwNzcp",highlighted:`<span class="hljs-comment"># parameters</span>
p_params = replicate(params)

<span class="hljs-comment"># arrays</span>
prompt_ids = shard(prompt_ids)
prompt_ids.shape
<span class="hljs-comment"># (8, 1, 77)</span>`,wrap:!1}}),N=new y({props:{code:"ZGVmJTIwY3JlYXRlX2tleShzZWVkJTNEMCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBqYXgucmFuZG9tLlBSTkdLZXkoc2VlZCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_key</span>(<span class="hljs-params">seed=<span class="hljs-number">0</span></span>):
    <span class="hljs-keyword">return</span> jax.random.PRNGKey(seed)`,wrap:!1}}),V=new y({props:{code:"cm5nJTIwJTNEJTIwY3JlYXRlX2tleSgwKSUwQXJuZyUyMCUzRCUyMGpheC5yYW5kb20uc3BsaXQocm5nJTJDJTIwamF4LmRldmljZV9jb3VudCgpKQ==",highlighted:`rng = create_key(<span class="hljs-number">0</span>)
rng = jax.random.split(rng, jax.device_count())`,wrap:!1}}),J=new Dt({props:{warning:!0,$$slots:{default:[pl]},$$scope:{ctx:ye}}}),P=new y({props:{code:"JTI1JTI1dGltZSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKHByb21wdF9pZHMlMkMlMjBwX3BhcmFtcyUyQyUyMHJuZyUyQyUyMGppdCUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMENQVSUyMHRpbWVzJTNBJTIwdXNlciUyMDU2LjIlMjBzJTJDJTIwc3lzJTNBJTIwNDIuNSUyMHMlMkMlMjB0b3RhbCUzQSUyMDFtaW4lMjAzOHMlMEElMjMlMjBXYWxsJTIwdGltZSUzQSUyMDFtaW4lMjAyOXM=",highlighted:`%%time
images = pipeline(prompt_ids, p_params, rng, jit=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]

<span class="hljs-comment"># CPU times: user 56.2 s, sys: 42.5 s, total: 1min 38s</span>
<span class="hljs-comment"># Wall time: 1min 29s</span>`,wrap:!1}}),D=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQWltYWdlcyUyMCUzRCUyMGltYWdlcy5yZXNoYXBlKChpbWFnZXMuc2hhcGUlNUIwJTVEJTIwKiUyMGltYWdlcy5zaGFwZSU1QjElNUQlMkMpJTIwJTJCJTIwaW1hZ2VzLnNoYXBlJTVCLTMlM0ElNUQpJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUubnVtcHlfdG9fcGlsKGltYWdlcyklMEFtYWtlX2ltYWdlX2dyaWQoaW1hZ2VzJTJDJTIwcm93cyUzRDIlMkMlMjBjb2xzJTNENCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid

images = images.reshape((images.shape[<span class="hljs-number">0</span>] * images.shape[<span class="hljs-number">1</span>],) + images.shape[-<span class="hljs-number">3</span>:])
images = pipeline.numpy_to_pil(images)
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),O=new Te({props:{title:"Using different prompts",local:"using-different-prompts",headingTag:"h2"}}),te=new y({props:{code:"cHJvbXB0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMkxhYnJhZG9yJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwSG9rdXNhaSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlBhaW50aW5nJTIwb2YlMjBhJTIwc3F1aXJyZWwlMjBza2F0aW5nJTIwaW4lMjBOZXclMjBZb3JrJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIySEFMLTkwMDAlMjBpbiUyMHRoZSUyMHN0eWxlJTIwb2YlMjBWYW4lMjBHb2doJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVGltZXMlMjBTcXVhcmUlMjB1bmRlciUyMHdhdGVyJTJDJTIwd2l0aCUyMGZpc2glMjBhbmQlMjBhJTIwZG9scGhpbiUyMHN3aW1taW5nJTIwYXJvdW5kJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQW5jaWVudCUyMFJvbWFuJTIwZnJlc2NvJTIwc2hvd2luZyUyMGElMjBtYW4lMjB3b3JraW5nJTIwb24lMjBoaXMlMjBsYXB0b3AlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDbG9zZS11cCUyMHBob3RvZ3JhcGglMjBvZiUyMHlvdW5nJTIwYmxhY2slMjB3b21hbiUyMGFnYWluc3QlMjB1cmJhbiUyMGJhY2tncm91bmQlMkMlMjBoaWdoJTIwcXVhbGl0eSUyQyUyMGJva2VoJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQXJtY2hhaXIlMjBpbiUyMHRoZSUyMHNoYXBlJTIwb2YlMjBhbiUyMGF2b2NhZG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDbG93biUyMGFzdHJvbmF1dCUyMGluJTIwc3BhY2UlMkMlMjB3aXRoJTIwRWFydGglMjBpbiUyMHRoZSUyMGJhY2tncm91bmQlMjIlMkMlMEElNUQlMEElMEFwcm9tcHRfaWRzJTIwJTNEJTIwcGlwZWxpbmUucHJlcGFyZV9pbnB1dHMocHJvbXB0cyklMEFwcm9tcHRfaWRzJTIwJTNEJTIwc2hhcmQocHJvbXB0X2lkcyklMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlbGluZShwcm9tcHRfaWRzJTJDJTIwcF9wYXJhbXMlMkMlMjBybmclMkMlMjBqaXQlM0RUcnVlKS5pbWFnZXMlMEFpbWFnZXMlMjAlM0QlMjBpbWFnZXMucmVzaGFwZSgoaW1hZ2VzLnNoYXBlJTVCMCU1RCUyMColMjBpbWFnZXMuc2hhcGUlNUIxJTVEJTJDKSUyMCUyQiUyMGltYWdlcy5zaGFwZSU1Qi0zJTNBJTVEKSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lLm51bXB5X3RvX3BpbChpbWFnZXMpJTBBJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMDIlMkMlMjA0KQ==",highlighted:`prompts = [
    <span class="hljs-string">&quot;Labrador in the style of Hokusai&quot;</span>,
    <span class="hljs-string">&quot;Painting of a squirrel skating in New York&quot;</span>,
    <span class="hljs-string">&quot;HAL-9000 in the style of Van Gogh&quot;</span>,
    <span class="hljs-string">&quot;Times Square under water, with fish and a dolphin swimming around&quot;</span>,
    <span class="hljs-string">&quot;Ancient Roman fresco showing a man working on his laptop&quot;</span>,
    <span class="hljs-string">&quot;Close-up photograph of young black woman against urban background, high quality, bokeh&quot;</span>,
    <span class="hljs-string">&quot;Armchair in the shape of an avocado&quot;</span>,
    <span class="hljs-string">&quot;Clown astronaut in space, with Earth in the background&quot;</span>,
]

prompt_ids = pipeline.prepare_inputs(prompts)
prompt_ids = shard(prompt_ids)

images = pipeline(prompt_ids, p_params, rng, jit=<span class="hljs-literal">True</span>).images
images = images.reshape((images.shape[<span class="hljs-number">0</span>] * images.shape[<span class="hljs-number">1</span>],) + images.shape[-<span class="hljs-number">3</span>:])
images = pipeline.numpy_to_pil(images)

make_image_grid(images, <span class="hljs-number">2</span>, <span class="hljs-number">4</span>)`,wrap:!1}}),se=new Te({props:{title:"How does parallelization work?",local:"how-does-parallelization-work",headingTag:"h2"}}),re=new y({props:{code:"cF9nZW5lcmF0ZSUyMCUzRCUyMHBtYXAocGlwZWxpbmUuX2dlbmVyYXRlKQ==",highlighted:"p_generate = pmap(pipeline._generate)",wrap:!1}}),he=new y({props:{code:"JTI1JTI1dGltZSUwQWltYWdlcyUyMCUzRCUyMHBfZ2VuZXJhdGUocHJvbXB0X2lkcyUyQyUyMHBfcGFyYW1zJTJDJTIwcm5nKSUwQWltYWdlcyUyMCUzRCUyMGltYWdlcy5ibG9ja191bnRpbF9yZWFkeSgpJTBBJTBBJTIzJTIwQ1BVJTIwdGltZXMlM0ElMjB1c2VyJTIwMW1pbiUyMDE1cyUyQyUyMHN5cyUzQSUyMDE4LjIlMjBzJTJDJTIwdG90YWwlM0ElMjAxbWluJTIwMzRzJTBBJTIzJTIwV2FsbCUyMHRpbWUlM0ElMjAxbWluJTIwMTVz",highlighted:`%%time
images = p_generate(prompt_ids, p_params, rng)
images = images.block_until_ready()

<span class="hljs-comment"># CPU times: user 1min 15s, sys: 18.2 s, total: 1min 34s</span>
<span class="hljs-comment"># Wall time: 1min 15s</span>`,wrap:!1}}),fe=new y({props:{code:"aW1hZ2VzLnNoYXBlJTBBJTIzJTIwKDglMkMlMjAxJTJDJTIwNTEyJTJDJTIwNTEyJTJDJTIwMyk=",highlighted:`images.shape
<span class="hljs-comment"># (8, 1, 512, 512, 3)</span>`,wrap:!1}}),{c(){r=i("meta"),w=a(),f=i("p"),T=a(),m(j.$$.fragment),be=a(),m(U.$$.fragment),Je=a(),g=i("p"),g.textContent=wt,je=a(),$=i("p"),$.textContent=Tt,Ue=a(),m(v.$$.fragment),ge=a(),B=i("p"),B.textContent=bt,$e=a(),_=i("p"),_.innerHTML=Jt,ve=a(),m(C.$$.fragment),Be=a(),I=i("p"),I.textContent=jt,_e=a(),m(x.$$.fragment),Ce=a(),m(k.$$.fragment),Ie=a(),W=i("p"),W.innerHTML=Ut,xe=a(),m(G.$$.fragment),ke=a(),m(X.$$.fragment),We=a(),Z=i("p"),Z.textContent=gt,Ge=a(),m(b.$$.fragment),Xe=a(),H=i("p"),H.innerHTML=$t,Ze=a(),m(F.$$.fragment),He=a(),Y=i("p"),Y.innerHTML=vt,Fe=a(),m(Q.$$.fragment),Ye=a(),z=i("p"),z.innerHTML=Bt,Qe=a(),E=i("p"),E.textContent=_t,ze=a(),R=i("p"),R.textContent=Ct,Ee=a(),m(N.$$.fragment),Re=a(),L=i("p"),L.innerHTML=It,Ne=a(),m(V.$$.fragment),Le=a(),S=i("p"),S.innerHTML=xt,Ve=a(),m(J.$$.fragment),Se=a(),A=i("p"),A.innerHTML=kt,Ae=a(),m(P.$$.fragment),Pe=a(),q=i("p"),q.innerHTML=Wt,qe=a(),m(D.$$.fragment),De=a(),K=i("p"),K.innerHTML=Gt,Ke=a(),m(O.$$.fragment),Oe=a(),ee=i("p"),ee.textContent=Xt,et=a(),m(te.$$.fragment),tt=a(),le=i("p"),le.innerHTML=Zt,lt=a(),m(se.$$.fragment),st=a(),ae=i("p"),ae.textContent=Ht,at=a(),ne=i("p"),ne.innerHTML=Ft,nt=a(),ie=i("p"),ie.innerHTML=Yt,it=a(),pe=i("ol"),pe.innerHTML=Qt,pt=a(),oe=i("p"),oe.innerHTML=zt,ot=a(),m(re.$$.fragment),rt=a(),me=i("p"),me.innerHTML=Et,mt=a(),ce=i("ol"),ce.innerHTML=Rt,ct=a(),ue=i("p"),ue.textContent=Nt,ut=a(),de=i("p"),de.innerHTML=Lt,dt=a(),m(he.$$.fragment),ht=a(),Me=i("p"),Me.textContent=Vt,Mt=a(),m(fe.$$.fragment),ft=a(),we=i("p"),this.h()},l(e){const t=sl("svelte-u9bgzb",document.head);r=p(t,"META",{name:!0,content:!0}),t.forEach(l),w=n(e),f=p(e,"P",{}),Pt(f).forEach(l),T=n(e),c(j.$$.fragment,e),be=n(e),c(U.$$.fragment,e),Je=n(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-12svr29"&&(g.textContent=wt),je=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-vd07ss"&&($.textContent=Tt),Ue=n(e),c(v.$$.fragment,e),ge=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-15famve"&&(B.textContent=bt),$e=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1jp1nmd"&&(_.innerHTML=Jt),ve=n(e),c(C.$$.fragment,e),Be=n(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-5ufrkr"&&(I.textContent=jt),_e=n(e),c(x.$$.fragment,e),Ce=n(e),c(k.$$.fragment,e),Ie=n(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-349jsc"&&(W.innerHTML=Ut),xe=n(e),c(G.$$.fragment,e),ke=n(e),c(X.$$.fragment,e),We=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-19grb2g"&&(Z.textContent=gt),Ge=n(e),c(b.$$.fragment,e),Xe=n(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-ih3iqi"&&(H.innerHTML=$t),Ze=n(e),c(F.$$.fragment,e),He=n(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-b3wqu4"&&(Y.innerHTML=vt),Fe=n(e),c(Q.$$.fragment,e),Ye=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-18q6dmb"&&(z.innerHTML=Bt),Qe=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-j1l5pg"&&(E.textContent=_t),ze=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1kfts0e"&&(R.textContent=Ct),Ee=n(e),c(N.$$.fragment,e),Re=n(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-bsl0kg"&&(L.innerHTML=It),Ne=n(e),c(V.$$.fragment,e),Le=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1sp1ijt"&&(S.innerHTML=xt),Ve=n(e),c(J.$$.fragment,e),Se=n(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1xv75ai"&&(A.innerHTML=kt),Ae=n(e),c(P.$$.fragment,e),Pe=n(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1998uti"&&(q.innerHTML=Wt),qe=n(e),c(D.$$.fragment,e),De=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-e1s2k"&&(K.innerHTML=Gt),Ke=n(e),c(O.$$.fragment,e),Oe=n(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-9e9hdw"&&(ee.textContent=Xt),et=n(e),c(te.$$.fragment,e),tt=n(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1nea4f2"&&(le.innerHTML=Zt),lt=n(e),c(se.$$.fragment,e),st=n(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1217ir9"&&(ae.textContent=Ht),at=n(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1toapy0"&&(ne.innerHTML=Ft),nt=n(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1pwzekg"&&(ie.innerHTML=Yt),it=n(e),pe=p(e,"OL",{"data-svelte-h":!0}),o(pe)!=="svelte-12i8xv7"&&(pe.innerHTML=Qt),pt=n(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1gtj740"&&(oe.innerHTML=zt),ot=n(e),c(re.$$.fragment,e),rt=n(e),me=p(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-1774hdu"&&(me.innerHTML=Et),mt=n(e),ce=p(e,"OL",{"data-svelte-h":!0}),o(ce)!=="svelte-12ig0qf"&&(ce.innerHTML=Rt),ct=n(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-w1m4t9"&&(ue.textContent=Nt),ut=n(e),de=p(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1ue3hjw"&&(de.innerHTML=Lt),dt=n(e),c(he.$$.fragment,e),ht=n(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-735q12"&&(Me.textContent=Vt),Mt=n(e),c(fe.$$.fragment,e),ft=n(e),we=p(e,"P",{}),Pt(we).forEach(l),this.h()},h(){qt(r,"name","hf:doc:metadata"),qt(r,"content",rl)},m(e,t){al(document.head,r),s(e,w,t),s(e,f,t),s(e,T,t),u(j,e,t),s(e,be,t),u(U,e,t),s(e,Je,t),s(e,g,t),s(e,je,t),s(e,$,t),s(e,Ue,t),u(v,e,t),s(e,ge,t),s(e,B,t),s(e,$e,t),s(e,_,t),s(e,ve,t),u(C,e,t),s(e,Be,t),s(e,I,t),s(e,_e,t),u(x,e,t),s(e,Ce,t),u(k,e,t),s(e,Ie,t),s(e,W,t),s(e,xe,t),u(G,e,t),s(e,ke,t),u(X,e,t),s(e,We,t),s(e,Z,t),s(e,Ge,t),u(b,e,t),s(e,Xe,t),s(e,H,t),s(e,Ze,t),u(F,e,t),s(e,He,t),s(e,Y,t),s(e,Fe,t),u(Q,e,t),s(e,Ye,t),s(e,z,t),s(e,Qe,t),s(e,E,t),s(e,ze,t),s(e,R,t),s(e,Ee,t),u(N,e,t),s(e,Re,t),s(e,L,t),s(e,Ne,t),u(V,e,t),s(e,Le,t),s(e,S,t),s(e,Ve,t),u(J,e,t),s(e,Se,t),s(e,A,t),s(e,Ae,t),u(P,e,t),s(e,Pe,t),s(e,q,t),s(e,qe,t),u(D,e,t),s(e,De,t),s(e,K,t),s(e,Ke,t),u(O,e,t),s(e,Oe,t),s(e,ee,t),s(e,et,t),u(te,e,t),s(e,tt,t),s(e,le,t),s(e,lt,t),u(se,e,t),s(e,st,t),s(e,ae,t),s(e,at,t),s(e,ne,t),s(e,nt,t),s(e,ie,t),s(e,it,t),s(e,pe,t),s(e,pt,t),s(e,oe,t),s(e,ot,t),u(re,e,t),s(e,rt,t),s(e,me,t),s(e,mt,t),s(e,ce,t),s(e,ct,t),s(e,ue,t),s(e,ut,t),s(e,de,t),s(e,dt,t),u(he,e,t),s(e,ht,t),s(e,Me,t),s(e,Mt,t),u(fe,e,t),s(e,ft,t),s(e,we,t),yt=!0},p(e,[t]){const St={};t&2&&(St.$$scope={dirty:t,ctx:e}),b.$set(St);const At={};t&2&&(At.$$scope={dirty:t,ctx:e}),J.$set(At)},i(e){yt||(d(j.$$.fragment,e),d(U.$$.fragment,e),d(v.$$.fragment,e),d(C.$$.fragment,e),d(x.$$.fragment,e),d(k.$$.fragment,e),d(G.$$.fragment,e),d(X.$$.fragment,e),d(b.$$.fragment,e),d(F.$$.fragment,e),d(Q.$$.fragment,e),d(N.$$.fragment,e),d(V.$$.fragment,e),d(J.$$.fragment,e),d(P.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(re.$$.fragment,e),d(he.$$.fragment,e),d(fe.$$.fragment,e),yt=!0)},o(e){h(j.$$.fragment,e),h(U.$$.fragment,e),h(v.$$.fragment,e),h(C.$$.fragment,e),h(x.$$.fragment,e),h(k.$$.fragment,e),h(G.$$.fragment,e),h(X.$$.fragment,e),h(b.$$.fragment,e),h(F.$$.fragment,e),h(Q.$$.fragment,e),h(N.$$.fragment,e),h(V.$$.fragment,e),h(J.$$.fragment,e),h(P.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(se.$$.fragment,e),h(re.$$.fragment,e),h(he.$$.fragment,e),h(fe.$$.fragment,e),yt=!1},d(e){e&&(l(w),l(f),l(T),l(be),l(Je),l(g),l(je),l($),l(Ue),l(ge),l(B),l($e),l(_),l(ve),l(Be),l(I),l(_e),l(Ce),l(Ie),l(W),l(xe),l(ke),l(We),l(Z),l(Ge),l(Xe),l(H),l(Ze),l(He),l(Y),l(Fe),l(Ye),l(z),l(Qe),l(E),l(ze),l(R),l(Ee),l(Re),l(L),l(Ne),l(Le),l(S),l(Ve),l(Se),l(A),l(Ae),l(Pe),l(q),l(qe),l(De),l(K),l(Ke),l(Oe),l(ee),l(et),l(tt),l(le),l(lt),l(st),l(ae),l(at),l(ne),l(nt),l(ie),l(it),l(pe),l(pt),l(oe),l(ot),l(rt),l(me),l(mt),l(ce),l(ct),l(ue),l(ut),l(de),l(dt),l(ht),l(Me),l(Mt),l(ft),l(we)),l(r),M(j,e),M(U,e),M(v,e),M(C,e),M(x,e),M(k,e),M(G,e),M(X,e),M(b,e),M(F,e),M(Q,e),M(N,e),M(V,e),M(J,e),M(P,e),M(D,e),M(O,e),M(te,e),M(se,e),M(re,e),M(he,e),M(fe,e)}}}const rl='{"title":"JAX/Flax","local":"jaxflax","sections":[{"title":"Load a model","local":"load-a-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2},{"title":"Using different prompts","local":"using-different-prompts","sections":[],"depth":2},{"title":"How does parallelization work?","local":"how-does-parallelization-work","sections":[],"depth":2}],"depth":1}';function ml(ye){return el(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yl extends tl{constructor(r){super(),ll(this,r,ml,ol,Ot,{})}}export{yl as component};
