import{s as ne,n as le,o as ae}from"../chunks/scheduler.9bc65507.js";import{S as se,i as oe,g as o,s as a,r as j,A as ie,h as i,f as n,c as s,j as ee,u as k,x as v,k as te,y as re,a as l,v as _,d as L,t as J,w as Z}from"../chunks/index.707bf1b6.js";import{C as pe}from"../chunks/CodeBlock.54a9f38d.js";import{H as A}from"../chunks/Heading.342b1fa6.js";function me(S){let r,U,b,I,p,x,m,F,c,V=`Flan-UL2 is an encoder decoder model based on the T5 architecture. It uses the same configuration as the <a href="ul2">UL2</a> model released earlier last year.
It was fine tuned using the “Flan” prompt tuning and dataset collection. Similar to <code>Flan-T5</code>,  one can directly use FLAN-UL2 weights without finetuning the model:`,q,u,P="According to the original blog here are the notable improvements:",B,d,Y=`<li>The original UL2 model was only trained with receptive field of 512, which made it non-ideal for N-shot prompting where N is large.</li> <li>The Flan-UL2 checkpoint uses a receptive field of 2048 which makes it more usable for few-shot in-context learning.</li> <li>The original UL2 model also had mode switch tokens that was rather mandatory to get good performance. However, they were a little cumbersome as this requires often some changes during inference or finetuning. In this update/change, we continue training UL2 20B for an additional 100k steps (with small batch) to forget “mode tokens” before applying Flan instruction tuning. This Flan-UL2 checkpoint does not require mode tokens anymore.
Google has released the following variants:</li>`,C,h,Q='One can refer to <a href="t5">T5’s documentation page</a> for all tips, code examples and notebooks. As well as the FLAN-T5 model card for more details regarding training and evaluation of the model.',G,f,O='The original checkpoints can be found <a href="https://github.com/google-research/t5x/blob/main/docs/models.md#flan-ul2-checkpoints" rel="nofollow">here</a>.',H,g,z,T,K="The model is pretty heavy (~40GB in half precision) so if you just want to run the model, make sure you load your model in 8bit, and use <code>device_map=&quot;auto&quot;</code> to make sure  you don’t have any OOM issue!",E,w,X,M,R,y,D='The inference protocol is exactly the same as any <code>T5</code> model, please have a look at the <a href="t5">T5’s documentation page</a> for more details.',N,$,W;return p=new A({props:{title:"FLAN-UL2",local:"flan-ul2",headingTag:"h1"}}),m=new A({props:{title:"Overview",local:"overview",headingTag:"h2"}}),g=new A({props:{title:"Running on low resource devices",local:"running-on-low-resource-devices",headingTag:"h2"}}),w=new pe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTSUyQyUyMEF1dG9Ub2tlbml6ZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZmxhbi11bDIlMjIlMkMlMjBsb2FkX2luXzhiaXQlM0RUcnVlJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZmxhbi11bDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzdGVwJTIwYnklMjBzdGVwJTIwcmVjaXBlJTIwdG8lMjBtYWtlJTIwYm9sb2duZXNlJTIwcGFzdGElM0ElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSeq2SeqLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google/flan-ul2&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/flan-ul2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A step by step recipe to make bolognese pasta:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;In a large skillet, brown the ground beef and onion over medium heat. Add the garlic&#x27;</span>]`,wrap:!1}}),M=new A({props:{title:"Inference",local:"inference",headingTag:"h2"}}),{c(){r=o("meta"),U=a(),b=o("p"),I=a(),j(p.$$.fragment),x=a(),j(m.$$.fragment),F=a(),c=o("p"),c.innerHTML=V,q=a(),u=o("p"),u.textContent=P,B=a(),d=o("ul"),d.innerHTML=Y,C=a(),h=o("p"),h.innerHTML=Q,G=a(),f=o("p"),f.innerHTML=O,H=a(),j(g.$$.fragment),z=a(),T=o("p"),T.innerHTML=K,E=a(),j(w.$$.fragment),X=a(),j(M.$$.fragment),R=a(),y=o("p"),y.innerHTML=D,N=a(),$=o("p"),this.h()},l(e){const t=ie("svelte-u9bgzb",document.head);r=i(t,"META",{name:!0,content:!0}),t.forEach(n),U=s(e),b=i(e,"P",{}),ee(b).forEach(n),I=s(e),k(p.$$.fragment,e),x=s(e),k(m.$$.fragment,e),F=s(e),c=i(e,"P",{"data-svelte-h":!0}),v(c)!=="svelte-gpwdss"&&(c.innerHTML=V),q=s(e),u=i(e,"P",{"data-svelte-h":!0}),v(u)!=="svelte-10cnwdi"&&(u.textContent=P),B=s(e),d=i(e,"UL",{"data-svelte-h":!0}),v(d)!=="svelte-145gzzg"&&(d.innerHTML=Y),C=s(e),h=i(e,"P",{"data-svelte-h":!0}),v(h)!=="svelte-lmluq6"&&(h.innerHTML=Q),G=s(e),f=i(e,"P",{"data-svelte-h":!0}),v(f)!=="svelte-tjdjai"&&(f.innerHTML=O),H=s(e),k(g.$$.fragment,e),z=s(e),T=i(e,"P",{"data-svelte-h":!0}),v(T)!=="svelte-1qrqz37"&&(T.innerHTML=K),E=s(e),k(w.$$.fragment,e),X=s(e),k(M.$$.fragment,e),R=s(e),y=i(e,"P",{"data-svelte-h":!0}),v(y)!=="svelte-5dcgrc"&&(y.innerHTML=D),N=s(e),$=i(e,"P",{}),ee($).forEach(n),this.h()},h(){te(r,"name","hf:doc:metadata"),te(r,"content",ce)},m(e,t){re(document.head,r),l(e,U,t),l(e,b,t),l(e,I,t),_(p,e,t),l(e,x,t),_(m,e,t),l(e,F,t),l(e,c,t),l(e,q,t),l(e,u,t),l(e,B,t),l(e,d,t),l(e,C,t),l(e,h,t),l(e,G,t),l(e,f,t),l(e,H,t),_(g,e,t),l(e,z,t),l(e,T,t),l(e,E,t),_(w,e,t),l(e,X,t),_(M,e,t),l(e,R,t),l(e,y,t),l(e,N,t),l(e,$,t),W=!0},p:le,i(e){W||(L(p.$$.fragment,e),L(m.$$.fragment,e),L(g.$$.fragment,e),L(w.$$.fragment,e),L(M.$$.fragment,e),W=!0)},o(e){J(p.$$.fragment,e),J(m.$$.fragment,e),J(g.$$.fragment,e),J(w.$$.fragment,e),J(M.$$.fragment,e),W=!1},d(e){e&&(n(U),n(b),n(I),n(x),n(F),n(c),n(q),n(u),n(B),n(d),n(C),n(h),n(G),n(f),n(H),n(z),n(T),n(E),n(X),n(R),n(y),n(N),n($)),n(r),Z(p,e),Z(m,e),Z(g,e),Z(w,e),Z(M,e)}}}const ce='{"title":"FLAN-UL2","local":"flan-ul2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Running on low resource devices","local":"running-on-low-resource-devices","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function ue(S){return ae(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Te extends se{constructor(r){super(),oe(this,r,ue,me,ne,{})}}export{Te as component};
