import{s as ht,o as ut,n as Le}from"../chunks/scheduler.25b97de1.js";import{S as ft,i as gt,g as d,s as o,r as f,A as _t,h as c,f as n,c as a,j as ee,u as g,x as h,k as te,y as l,a as r,v as _,d as v,t as b,w}from"../chunks/index.d9030fc9.js";import{T as vt}from"../chunks/Tip.baa67368.js";import{D as he}from"../chunks/Docstring.e257edda.js";import{C as Qe}from"../chunks/CodeBlock.e6cd0d95.js";import{E as pt}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as ue,E as bt}from"../chunks/EditOnGithub.91d95064.js";function wt(j){let i,M="Example:",p,m,u;return m=new Qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFVuaXZOZXRNb2RlbCUyQyUyMFVuaXZOZXRDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwVG9ydG9pc2UlMjBUVFMlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwVW5pdk5ldENvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBUb3J0b2lzZSUyMFRUUyUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwVW5pdk5ldE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> UnivNetModel, UnivNetConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Tortoise TTS style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = UnivNetConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the Tortoise TTS style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = UnivNetModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){i=d("p"),i.textContent=M,p=o(),f(m.$$.fragment)},l(s){i=c(s,"P",{"data-svelte-h":!0}),h(i)!=="svelte-11lpom8"&&(i.textContent=M),p=a(s),g(m.$$.fragment,s)},m(s,y){r(s,i,y),r(s,p,y),_(m,s,y),u=!0},p:Le,i(s){u||(v(m.$$.fragment,s),u=!0)},o(s){b(m.$$.fragment,s),u=!1},d(s){s&&(n(i),n(p)),w(m,s)}}}function yt(j){let i,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=d("p"),i.innerHTML=M},l(p){i=c(p,"P",{"data-svelte-h":!0}),h(i)!=="svelte-fincs2"&&(i.innerHTML=M)},m(p,m){r(p,i,m)},p:Le,d(p){p&&n(i)}}}function Tt(j){let i,M="Example:",p,m,u;return m=new Qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFVuaXZOZXRGZWF0dXJlRXh0cmFjdG9yJTJDJTIwVW5pdk5ldE1vZGVsJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFtb2RlbCUyMCUzRCUyMFVuaXZOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZGc4NDUlMkZ1bml2bmV0LWRldiUyMiklMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMFVuaXZOZXRGZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJkZzg0NSUyRnVuaXZuZXQtZGV2JTIyKSUwQSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEElMjMlMjBSZXNhbXBsZSUyMHRoZSUyMGF1ZGlvJTIwdG8lMjB0aGUlMjBmZWF0dXJlJTIwZXh0cmFjdG9yJ3MlMjBzYW1wbGluZyUyMHJhdGUuJTBBZHMlMjAlM0QlMjBkcy5jYXN0X2NvbHVtbiglMjJhdWRpbyUyMiUyQyUyMEF1ZGlvKHNhbXBsaW5nX3JhdGUlM0RmZWF0dXJlX2V4dHJhY3Rvci5zYW1wbGluZ19yYXRlKSklMEFpbnB1dHMlMjAlM0QlMjBmZWF0dXJlX2V4dHJhY3RvciglMEElMjAlMjAlMjAlMjBkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRGRzJTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpJTBBYXVkaW8lMjAlM0QlMjBtb2RlbCgqKmlucHV0cykud2F2ZWZvcm1zJTBBbGlzdChhdWRpby5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> UnivNetFeatureExtractor, UnivNetModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>model = UnivNetModel.from_pretrained(<span class="hljs-string">&quot;dg845/univnet-dev&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = UnivNetFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;dg845/univnet-dev&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Resample the audio to the feature extractor&#x27;s sampling rate.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=feature_extractor.sampling_rate))
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(
<span class="hljs-meta">... </span>    ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = model(**inputs).waveforms
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(audio.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">140288</span>]`,wrap:!1}}),{c(){i=d("p"),i.textContent=M,p=o(),f(m.$$.fragment)},l(s){i=c(s,"P",{"data-svelte-h":!0}),h(i)!=="svelte-11lpom8"&&(i.textContent=M),p=a(s),g(m.$$.fragment,s)},m(s,y){r(s,i,y),r(s,p,y),_(m,s,y),u=!0},p:Le,i(s){u||(v(m.$$.fragment,s),u=!0)},o(s){b(m.$$.fragment,s),u=!1},d(s){s&&(n(i),n(p)),w(m,s)}}}function Ut(j){let i,M,p,m,u,s,y,fe,G,Pe=`The UnivNet model was proposed in <a href="https://arxiv.org/abs/2106.07889" rel="nofollow">UnivNet: A Neural Vocoder with Multi-Resolution Spectrogram Discriminators for High-Fidelity Waveform Generation</a> by Won Jang, Dan Lim, Jaesam Yoon, Bongwan Kin, and Juntae Kim.
The UnivNet model is a generative adversarial network (GAN) trained to synthesize high fidelity speech waveforms. The UnivNet model shared in <code>transformers</code> is the <em>generator</em>, which maps a conditioning log-mel spectrogram and optional noise sequence to a speech waveform (e.g. a vocoder). Only the generator is required for inference. The <em>discriminator</em> used to train the <code>generator</code> is not implemented.`,ge,C,Ae="The abstract from the paper is the following:",_e,W,De="<em>Most neural vocoders employ band-limited mel-spectrograms to generate waveforms. If full-band spectral features are used as the input, the vocoder can be provided with as much acoustic information as possible. However, in some models employing full-band mel-spectrograms, an over-smoothing problem occurs as part of which non-sharp spectrograms are generated. To address this problem, we propose UnivNet, a neural vocoder that synthesizes high-fidelity waveforms in real time. Inspired by works in the field of voice activity detection, we added a multi-resolution spectrogram discriminator that employs multiple linear spectrogram magnitudes computed using various parameter sets. Using full-band mel-spectrograms as input, we expect to generate high-resolution signals by adding a discriminator that employs spectrograms of multiple resolutions as the input. In an evaluation on a dataset containing information on hundreds of speakers, UnivNet obtained the best objective and subjective results among competing models for both seen and unseen speakers. These results, including the best subjective score for text-to-speech, demonstrate the potential for fast adaptation to new speakers without a need for training from scratch.</em>",ve,B,Oe="Tips:",be,X,Ke='<li>The <code>noise_sequence</code> argument for <a href="/docs/transformers/v4.43.0/en/model_doc/univnet#transformers.UnivNetModel.forward">UnivNetModel.forward()</a> should be standard Gaussian noise (such as from <code>torch.randn</code>) of shape <code>([batch_size], noise_length, model.config.model_in_channels)</code>, where <code>noise_length</code> should match the length dimension (dimension 1) of the <code>input_features</code> argument. If not supplied, it will be randomly generated; a <code>torch.Generator</code> can be supplied to the <code>generator</code> argument so that the forward pass can be reproduced. (Note that <a href="/docs/transformers/v4.43.0/en/model_doc/univnet#transformers.UnivNetFeatureExtractor">UnivNetFeatureExtractor</a> will return generated noise by default, so it shouldn’t be necessary to generate <code>noise_sequence</code> manually.)</li> <li>Padding added by <a href="/docs/transformers/v4.43.0/en/model_doc/univnet#transformers.UnivNetFeatureExtractor">UnivNetFeatureExtractor</a> can be removed from the <a href="/docs/transformers/v4.43.0/en/model_doc/univnet#transformers.UnivNetModel">UnivNetModel</a> output through the <code>UnivNetFeatureExtractor.batch_decode()</code> method, as shown in the usage example below.</li> <li>Padding the end of each waveform with silence can reduce artifacts at the end of the generated audio sample. This can be done by supplying <code>pad_end = True</code> to <a href="/docs/transformers/v4.43.0/en/model_doc/univnet#transformers.UnivNetFeatureExtractor.__call__">UnivNetFeatureExtractor.<strong>call</strong>()</a>. See <a href="https://github.com/seungwonpark/melgan/issues/8" rel="nofollow">this issue</a> for more details.</li>',we,R,et="Usage Example:",ye,q,Te,V,tt=`This model was contributed by <a href="https://huggingface.co/dg845" rel="nofollow">dg845</a>.
To the best of my knowledge, there is no official code release, but an unofficial implementation can be found at <a href="https://github.com/maum-ai/univnet" rel="nofollow">maum-ai/univnet</a> with pretrained checkpoints <a href="https://github.com/maum-ai/univnet#pre-trained-model" rel="nofollow">here</a>.`,Ue,H,Me,x,Y,Ze,ne,nt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.43.0/en/model_doc/univnet#transformers.UnivNetModel">UnivNetModel</a>. It is used to instantiate a
UnivNet vocoder model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the UnivNet
<a href="https://huggingface.co/dg845/univnet-dev" rel="nofollow">dg845/univnet-dev</a> architecture, which corresponds to the ‘c32’
architecture in <a href="https://github.com/maum-ai/univnet/blob/master/config/default_c32.yaml" rel="nofollow">maum-ai/univnet</a>.`,Ee,oe,ot=`Configuration objects inherit from <a href="/docs/transformers/v4.43.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.43.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ze,$,xe,S,Ne,T,L,Ie,ae,at="Constructs a UnivNet feature extractor.",Ge,re,rt=`This class extracts log-mel-filter bank features from raw speech using the short time Fourier Transform (STFT). The
STFT implementation follows that of TacoTron 2 and Hifi-GAN.`,Ce,se,st=`This feature extractor inherits from <a href="/docs/transformers/v4.43.0/en/main_classes/feature_extractor#transformers.SequenceFeatureExtractor">SequenceFeatureExtractor</a> which contains
most of the main methods. Users should refer to this superclass for more information regarding those methods.`,We,Z,Q,Be,ie,it="Main method to featurize and prepare for the model one or several sequence(s).",ke,P,Je,N,A,Xe,le,lt=`UnivNet GAN vocoder.
This model inherits from <a href="/docs/transformers/v4.43.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Re,de,dt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,qe,U,D,Ve,ce,ct='The <a href="/docs/transformers/v4.43.0/en/model_doc/univnet#transformers.UnivNetModel">UnivNetModel</a> forward method, overrides the <code>__call__</code> special method.',He,E,Ye,me,mt=`Converts a noise waveform and a conditioning spectrogram to a speech waveform. Passing a batch of log-mel
spectrograms returns a batch of speech waveforms. Passing a single, un-batched log-mel spectrogram returns a
single, un-batched speech waveform.`,Se,z,Fe,O,je,pe,$e;return u=new ue({props:{title:"UnivNet",local:"univnet",headingTag:"h1"}}),y=new ue({props:{title:"Overview",local:"overview",headingTag:"h2"}}),q=new Qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwc2NpcHkuaW8ud2F2ZmlsZSUyMGltcG9ydCUyMHdyaXRlJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMkMlMjBsb2FkX2RhdGFzZXQlMEElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVW5pdk5ldEZlYXR1cmVFeHRyYWN0b3IlMkMlMjBVbml2TmV0TW9kZWwlMEElMEFtb2RlbF9pZF9vcl9wYXRoJTIwJTNEJTIwJTIyZGc4NDUlMkZ1bml2bmV0LWRldiUyMiUwQW1vZGVsJTIwJTNEJTIwVW5pdk5ldE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZF9vcl9wYXRoKSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwVW5pdk5ldEZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkX29yX3BhdGgpJTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQSUyMyUyMFJlc2FtcGxlJTIwdGhlJTIwYXVkaW8lMjB0byUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwZmVhdHVyZSUyMGV4dHJhY3RvcidzJTIwc2FtcGxpbmclMjByYXRlLiUwQWRzJTIwJTNEJTIwZHMuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEZmVhdHVyZV9leHRyYWN0b3Iuc2FtcGxpbmdfcmF0ZSkpJTBBJTIzJTIwUGFkJTIwdGhlJTIwZW5kJTIwb2YlMjB0aGUlMjBjb252ZXJ0ZWQlMjB3YXZlZm9ybXMlMjB0byUyMHJlZHVjZSUyMGFydGlmYWN0cyUyMGF0JTIwdGhlJTIwZW5kJTIwb2YlMjB0aGUlMjBvdXRwdXQlMjBhdWRpbyUyMHNhbXBsZXMuJTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoJTBBJTIwJTIwJTIwJTIwZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMjBwYWRfZW5kJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwUmVtb3ZlJTIwdGhlJTIwZXh0cmElMjBwYWRkaW5nJTIwYXQlMjB0aGUlMjBlbmQlMjBvZiUyMHRoZSUyMG91dHB1dC4lMEFhdWRpbyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yLmJhdGNoX2RlY29kZSgqKmF1ZGlvKSU1QjAlNUQlMEElMjMlMjBDb252ZXJ0JTIwdG8lMjB3YXYlMjBmaWxlJTBBd3JpdGUoJTIyc2FtcGxlX2F1ZGlvLndhdiUyMiUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yLnNhbXBsaW5nX3JhdGUlMkMlMjBhdWRpbyk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> scipy.io.wavfile <span class="hljs-keyword">import</span> write
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio, load_dataset

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> UnivNetFeatureExtractor, UnivNetModel

model_id_or_path = <span class="hljs-string">&quot;dg845/univnet-dev&quot;</span>
model = UnivNetModel.from_pretrained(model_id_or_path)
feature_extractor = UnivNetFeatureExtractor.from_pretrained(model_id_or_path)

ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-comment"># Resample the audio to the model and feature extractor&#x27;s sampling rate.</span>
ds = ds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=feature_extractor.sampling_rate))
<span class="hljs-comment"># Pad the end of the converted waveforms to reduce artifacts at the end of the output audio samples.</span>
inputs = feature_extractor(
    ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>], pad_end=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
)

<span class="hljs-keyword">with</span> torch.no_grad():
    audio = model(**inputs)

<span class="hljs-comment"># Remove the extra padding at the end of the output.</span>
audio = feature_extractor.batch_decode(**audio)[<span class="hljs-number">0</span>]
<span class="hljs-comment"># Convert to wav file</span>
write(<span class="hljs-string">&quot;sample_audio.wav&quot;</span>, feature_extractor.sampling_rate, audio)`,wrap:!1}}),H=new ue({props:{title:"UnivNetConfig",local:"transformers.UnivNetConfig",headingTag:"h2"}}),Y=new he({props:{name:"class transformers.UnivNetConfig",anchor:"transformers.UnivNetConfig",parameters:[{name:"model_in_channels",val:" = 64"},{name:"model_hidden_channels",val:" = 32"},{name:"num_mel_bins",val:" = 100"},{name:"resblock_kernel_sizes",val:" = [3, 3, 3]"},{name:"resblock_stride_sizes",val:" = [8, 8, 4]"},{name:"resblock_dilation_sizes",val:" = [[1, 3, 9, 27], [1, 3, 9, 27], [1, 3, 9, 27]]"},{name:"kernel_predictor_num_blocks",val:" = 3"},{name:"kernel_predictor_hidden_channels",val:" = 64"},{name:"kernel_predictor_conv_size",val:" = 3"},{name:"kernel_predictor_dropout",val:" = 0.0"},{name:"initializer_range",val:" = 0.01"},{name:"leaky_relu_slope",val:" = 0.2"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.UnivNetConfig.model_in_channels",description:`<strong>model_in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
The number of input channels for the UnivNet residual network. This should correspond to
<code>noise_sequence.shape[1]</code> and the value used in the <a href="/docs/transformers/v4.43.0/en/model_doc/univnet#transformers.UnivNetFeatureExtractor">UnivNetFeatureExtractor</a> class.`,name:"model_in_channels"},{anchor:"transformers.UnivNetConfig.model_hidden_channels",description:`<strong>model_hidden_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The number of hidden channels of each residual block in the UnivNet residual network.`,name:"model_hidden_channels"},{anchor:"transformers.UnivNetConfig.num_mel_bins",description:`<strong>num_mel_bins</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of frequency bins in the conditioning log-mel spectrogram. This should correspond to the value
used in the <a href="/docs/transformers/v4.43.0/en/model_doc/univnet#transformers.UnivNetFeatureExtractor">UnivNetFeatureExtractor</a> class.`,name:"num_mel_bins"},{anchor:"transformers.UnivNetConfig.resblock_kernel_sizes",description:`<strong>resblock_kernel_sizes</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>[3, 3, 3]</code>) &#x2014;
A tuple of integers defining the kernel sizes of the 1D convolutional layers in the UnivNet residual
network. The length of <code>resblock_kernel_sizes</code> defines the number of resnet blocks and should match that of
<code>resblock_stride_sizes</code> and <code>resblock_dilation_sizes</code>.`,name:"resblock_kernel_sizes"},{anchor:"transformers.UnivNetConfig.resblock_stride_sizes",description:`<strong>resblock_stride_sizes</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>[8, 8, 4]</code>) &#x2014;
A tuple of integers defining the stride sizes of the 1D convolutional layers in the UnivNet residual
network. The length of <code>resblock_stride_sizes</code> should match that of <code>resblock_kernel_sizes</code> and
<code>resblock_dilation_sizes</code>.`,name:"resblock_stride_sizes"},{anchor:"transformers.UnivNetConfig.resblock_dilation_sizes",description:`<strong>resblock_dilation_sizes</strong> (<code>Tuple[Tuple[int]]</code> or <code>List[List[int]]</code>, <em>optional</em>, defaults to <code>[[1, 3, 9, 27], [1, 3, 9, 27], [1, 3, 9, 27]]</code>) &#x2014;
A nested tuple of integers defining the dilation rates of the dilated 1D convolutional layers in the
UnivNet residual network. The length of <code>resblock_dilation_sizes</code> should match that of
<code>resblock_kernel_sizes</code> and <code>resblock_stride_sizes</code>. The length of each nested list in
<code>resblock_dilation_sizes</code> defines the number of convolutional layers per resnet block.`,name:"resblock_dilation_sizes"},{anchor:"transformers.UnivNetConfig.kernel_predictor_num_blocks",description:`<strong>kernel_predictor_num_blocks</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of residual blocks in the kernel predictor network, which calculates the kernel and bias for
each location variable convolution layer in the UnivNet residual network.`,name:"kernel_predictor_num_blocks"},{anchor:"transformers.UnivNetConfig.kernel_predictor_hidden_channels",description:`<strong>kernel_predictor_hidden_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
The number of hidden channels for each residual block in the kernel predictor network.`,name:"kernel_predictor_hidden_channels"},{anchor:"transformers.UnivNetConfig.kernel_predictor_conv_size",description:`<strong>kernel_predictor_conv_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The kernel size of each 1D convolutional layer in the kernel predictor network.`,name:"kernel_predictor_conv_size"},{anchor:"transformers.UnivNetConfig.kernel_predictor_dropout",description:`<strong>kernel_predictor_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for each residual block in the kernel predictor network.`,name:"kernel_predictor_dropout"},{anchor:"transformers.UnivNetConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.01) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.UnivNetConfig.leaky_relu_slope",description:`<strong>leaky_relu_slope</strong> (<code>float</code>, <em>optional</em>, defaults to 0.2) &#x2014;
The angle of the negative slope used by the leaky ReLU activation.`,name:"leaky_relu_slope"}],source:"https://github.com/huggingface/transformers/blob/v4.43.0/src/transformers/models/univnet/configuration_univnet.py#L23"}}),$=new pt({props:{anchor:"transformers.UnivNetConfig.example",$$slots:{default:[wt]},$$scope:{ctx:j}}}),S=new ue({props:{title:"UnivNetFeatureExtractor",local:"transformers.UnivNetFeatureExtractor",headingTag:"h2"}}),L=new he({props:{name:"class transformers.UnivNetFeatureExtractor",anchor:"transformers.UnivNetFeatureExtractor",parameters:[{name:"feature_size",val:": int = 1"},{name:"sampling_rate",val:": int = 24000"},{name:"padding_value",val:": float = 0.0"},{name:"do_normalize",val:": bool = False"},{name:"num_mel_bins",val:": int = 100"},{name:"hop_length",val:": int = 256"},{name:"win_length",val:": int = 1024"},{name:"win_function",val:": str = 'hann_window'"},{name:"filter_length",val:": Optional = 1024"},{name:"max_length_s",val:": int = 10"},{name:"fmin",val:": float = 0.0"},{name:"fmax",val:": Optional = None"},{name:"mel_floor",val:": float = 1e-09"},{name:"center",val:": bool = False"},{name:"compression_factor",val:": float = 1.0"},{name:"compression_clip_val",val:": float = 1e-05"},{name:"normalize_min",val:": float = -11.512925148010254"},{name:"normalize_max",val:": float = 2.3143386840820312"},{name:"model_in_channels",val:": int = 64"},{name:"pad_end_length",val:": int = 10"},{name:"return_attention_mask",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.UnivNetFeatureExtractor.feature_size",description:`<strong>feature_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The feature dimension of the extracted features.`,name:"feature_size"},{anchor:"transformers.UnivNetFeatureExtractor.sampling_rate",description:`<strong>sampling_rate</strong> (<code>int</code>, <em>optional</em>, defaults to 24000) &#x2014;
The sampling rate at which the audio files should be digitalized expressed in hertz (Hz).`,name:"sampling_rate"},{anchor:"transformers.UnivNetFeatureExtractor.padding_value",description:`<strong>padding_value</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The value to pad with when applying the padding strategy defined by the <code>padding</code> argument to
<a href="/docs/transformers/v4.43.0/en/model_doc/univnet#transformers.UnivNetFeatureExtractor.__call__">UnivNetFeatureExtractor.<strong>call</strong>()</a>. Should correspond to audio silence. The <code>pad_end</code> argument to
<code>__call__</code> will also use this padding value.`,name:"padding_value"},{anchor:"transformers.UnivNetFeatureExtractor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to perform Tacotron 2 normalization on the input. Normalizing can help to significantly improve the
performance for some models.`,name:"do_normalize"},{anchor:"transformers.UnivNetFeatureExtractor.num_mel_bins",description:`<strong>num_mel_bins</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of mel-frequency bins in the extracted spectrogram features. This should match
<code>UnivNetModel.config.num_mel_bins</code>.`,name:"num_mel_bins"},{anchor:"transformers.UnivNetFeatureExtractor.hop_length",description:`<strong>hop_length</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The direct number of samples between sliding windows. Otherwise referred to as &#x201C;shift&#x201D; in many papers. Note
that this is different from other audio feature extractors such as <a href="/docs/transformers/v4.43.0/en/model_doc/speecht5#transformers.SpeechT5FeatureExtractor">SpeechT5FeatureExtractor</a> which take
the <code>hop_length</code> in ms.`,name:"hop_length"},{anchor:"transformers.UnivNetFeatureExtractor.win_length",description:`<strong>win_length</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The direct number of samples for each sliding window. Note that this is different from other audio feature
extractors such as <a href="/docs/transformers/v4.43.0/en/model_doc/speecht5#transformers.SpeechT5FeatureExtractor">SpeechT5FeatureExtractor</a> which take the <code>win_length</code> in ms.`,name:"win_length"},{anchor:"transformers.UnivNetFeatureExtractor.win_function",description:`<strong>win_function</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;hann_window&quot;</code>) &#x2014;
Name for the window function used for windowing, must be accessible via <code>torch.{win_function}</code>`,name:"win_function"},{anchor:"transformers.UnivNetFeatureExtractor.filter_length",description:`<strong>filter_length</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The number of FFT components to use. If <code>None</code>, this is determined using
<code>transformers.audio_utils.optimal_fft_length</code>.`,name:"filter_length"},{anchor:"transformers.UnivNetFeatureExtractor.max_length_s",description:`<strong>max_length_s</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
The maximum input lenght of the model in seconds. This is used to pad the audio.`,name:"max_length_s"},{anchor:"transformers.UnivNetFeatureExtractor.fmin",description:`<strong>fmin</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Minimum mel frequency in Hz.`,name:"fmin"},{anchor:"transformers.UnivNetFeatureExtractor.fmax",description:`<strong>fmax</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Maximum mel frequency in Hz. If not set, defaults to <code>sampling_rate / 2</code>.`,name:"fmax"},{anchor:"transformers.UnivNetFeatureExtractor.mel_floor",description:`<strong>mel_floor</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-09) &#x2014;
Minimum value of mel frequency banks. Note that the way <a href="/docs/transformers/v4.43.0/en/model_doc/univnet#transformers.UnivNetFeatureExtractor">UnivNetFeatureExtractor</a> uses <code>mel_floor</code> is
different than in <a href="/docs/transformers/v4.43.0/en/internal/audio_utils#transformers.audio_utils.spectrogram">transformers.audio_utils.spectrogram()</a>.`,name:"mel_floor"},{anchor:"transformers.UnivNetFeatureExtractor.center",description:`<strong>center</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to pad the waveform so that frame <code>t</code> is centered around time <code>t * hop_length</code>. If <code>False</code>, frame
<code>t</code> will start at time <code>t * hop_length</code>.`,name:"center"},{anchor:"transformers.UnivNetFeatureExtractor.compression_factor",description:`<strong>compression_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The multiplicative compression factor for dynamic range compression during spectral normalization.`,name:"compression_factor"},{anchor:"transformers.UnivNetFeatureExtractor.compression_clip_val",description:`<strong>compression_clip_val</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The clip value applied to the waveform before applying dynamic range compression during spectral
normalization.`,name:"compression_clip_val"},{anchor:"transformers.UnivNetFeatureExtractor.normalize_min",description:`<strong>normalize_min</strong> (<code>float</code>, <em>optional</em>, defaults to -11.512925148010254) &#x2014;
The min value used for Tacotron 2-style linear normalization. The default is the original value from the
Tacotron 2 implementation.`,name:"normalize_min"},{anchor:"transformers.UnivNetFeatureExtractor.normalize_max",description:`<strong>normalize_max</strong> (<code>float</code>, <em>optional</em>, defaults to 2.3143386840820312) &#x2014;
The max value used for Tacotron 2-style linear normalization. The default is the original value from the
Tacotron 2 implementation.`,name:"normalize_max"},{anchor:"transformers.UnivNetFeatureExtractor.model_in_channels",description:`<strong>model_in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
The number of input channels to the <a href="/docs/transformers/v4.43.0/en/model_doc/univnet#transformers.UnivNetModel">UnivNetModel</a> model. This should match
<code>UnivNetModel.config.model_in_channels</code>.`,name:"model_in_channels"},{anchor:"transformers.UnivNetFeatureExtractor.pad_end_length",description:`<strong>pad_end_length</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
If padding the end of each waveform, the number of spectrogram frames worth of samples to append. The
number of appended samples will be <code>pad_end_length * hop_length</code>.`,name:"pad_end_length"},{anchor:"transformers.UnivNetFeatureExtractor.return_attention_mask",description:`<strong>return_attention_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not <a href="/docs/transformers/v4.43.0/en/model_doc/univnet#transformers.UnivNetFeatureExtractor.__call__"><strong>call</strong>()</a> should return <code>attention_mask</code>.`,name:"return_attention_mask"}],source:"https://github.com/huggingface/transformers/blob/v4.43.0/src/transformers/models/univnet/feature_extraction_univnet.py#L29"}}),Q=new he({props:{name:"__call__",anchor:"transformers.UnivNetFeatureExtractor.__call__",parameters:[{name:"raw_speech",val:": Union"},{name:"sampling_rate",val:": Optional = None"},{name:"padding",val:": Union = True"},{name:"max_length",val:": Optional = None"},{name:"truncation",val:": bool = True"},{name:"pad_to_multiple_of",val:": Optional = None"},{name:"return_noise",val:": bool = True"},{name:"generator",val:": Optional = None"},{name:"pad_end",val:": bool = False"},{name:"pad_length",val:": Optional = None"},{name:"do_normalize",val:": Optional = None"},{name:"return_attention_mask",val:": Optional = None"},{name:"return_tensors",val:": Union = None"}],parametersDescription:[{anchor:"transformers.UnivNetFeatureExtractor.__call__.raw_speech",description:`<strong>raw_speech</strong> (<code>np.ndarray</code>, <code>List[float]</code>, <code>List[np.ndarray]</code>, <code>List[List[float]]</code>) &#x2014;
The sequence or batch of sequences to be padded. Each sequence can be a numpy array, a list of float
values, a list of numpy arrays or a list of list of float values. Must be mono channel audio, not
stereo, i.e. single float per timestep.`,name:"raw_speech"},{anchor:"transformers.UnivNetFeatureExtractor.__call__.sampling_rate",description:`<strong>sampling_rate</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The sampling rate at which the <code>raw_speech</code> input was sampled. It is strongly recommended to pass
<code>sampling_rate</code> at the forward call to prevent silent errors and allow automatic speech recognition
pipeline.`,name:"sampling_rate"},{anchor:"transformers.UnivNetFeatureExtractor.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/v4.43.0/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Select a strategy to pad the input <code>raw_speech</code> waveforms (according to the model&#x2019;s padding side and
padding index) among:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>
<p>If <code>pad_end = True</code>, that padding will occur before the <code>padding</code> strategy is applied.`,name:"padding"},{anchor:"transformers.UnivNetFeatureExtractor.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum length of the returned list and optionally padding length (see above).`,name:"max_length"},{anchor:"transformers.UnivNetFeatureExtractor.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Activates truncation to cut input sequences longer than <code>max_length</code> to <code>max_length</code>.`,name:"truncation"},{anchor:"transformers.UnivNetFeatureExtractor.__call__.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value.</p>
<p>This is especially useful to enable the use of Tensor Cores on NVIDIA hardware with compute capability
<code>&gt;= 7.5</code> (Volta), or on TPUs which benefit from having sequence lengths be a multiple of 128.`,name:"pad_to_multiple_of"},{anchor:"transformers.UnivNetFeatureExtractor.__call__.return_noise",description:`<strong>return_noise</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to generate and return a noise waveform for use in <a href="/docs/transformers/v4.43.0/en/model_doc/univnet#transformers.UnivNetModel.forward">UnivNetModel.forward()</a>.`,name:"return_noise"},{anchor:"transformers.UnivNetFeatureExtractor.__call__.generator",description:`<strong>generator</strong> (<code>numpy.random.Generator</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
An optional <code>numpy.random.Generator</code> random number generator to use when generating noise.`,name:"generator"},{anchor:"transformers.UnivNetFeatureExtractor.__call__.pad_end",description:`<strong>pad_end</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to pad the end of each waveform with silence. This can help reduce artifacts at the end of the
generated audio sample; see <a href="https://github.com/seungwonpark/melgan/issues/8" rel="nofollow">https://github.com/seungwonpark/melgan/issues/8</a> for more details. This
padding will be done before the padding strategy specified in <code>padding</code> is performed.`,name:"pad_end"},{anchor:"transformers.UnivNetFeatureExtractor.__call__.pad_length",description:`<strong>pad_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If padding the end of each waveform, the length of the padding in spectrogram frames. If not set, this
will default to <code>self.config.pad_end_length</code>.`,name:"pad_length"},{anchor:"transformers.UnivNetFeatureExtractor.__call__.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to perform Tacotron 2 normalization on the input. Normalizing can help to significantly improve
the performance for some models. If not set, this will default to <code>self.config.do_normalize</code>.`,name:"do_normalize"},{anchor:"transformers.UnivNetFeatureExtractor.__call__.return_attention_mask",description:`<strong>return_attention_mask</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return the attention mask. If left to the default, will return the attention mask according
to the specific feature_extractor&#x2019;s default.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"return_attention_mask"},{anchor:"transformers.UnivNetFeatureExtractor.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/v4.43.0/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.np.array</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/v4.43.0/src/transformers/models/univnet/feature_extraction_univnet.py#L286"}}),P=new ue({props:{title:"UnivNetModel",local:"transformers.UnivNetModel",headingTag:"h2"}}),A=new he({props:{name:"class transformers.UnivNetModel",anchor:"transformers.UnivNetModel",parameters:[{name:"config",val:": UnivNetConfig"}],parametersDescription:[{anchor:"transformers.UnivNetModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.43.0/en/model_doc/univnet#transformers.UnivNetConfig">UnivNetConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.43.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.43.0/src/transformers/models/univnet/modeling_univnet.py#L459"}}),D=new he({props:{name:"forward",anchor:"transformers.UnivNetModel.forward",parameters:[{name:"input_features",val:": FloatTensor"},{name:"noise_sequence",val:": Optional = None"},{name:"padding_mask",val:": Optional = None"},{name:"generator",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.UnivNetModel.forward.input_features",description:`<strong>input_features</strong> (<code>torch.FloatTensor</code>) &#x2014;
Tensor containing the log-mel spectrograms. Can be batched and of shape <code>(batch_size, sequence_length, config.num_mel_channels)</code>, or un-batched and of shape <code>(sequence_length, config.num_mel_channels)</code>.`,name:"input_features"},{anchor:"transformers.UnivNetModel.forward.noise_sequence",description:`<strong>noise_sequence</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Tensor containing a noise sequence of standard Gaussian noise. Can be batched and of shape <code>(batch_size, sequence_length, config.model_in_channels)</code>, or un-batched and of shape (sequence_length,
config.model_in_channels)\`. If not supplied, will be randomly generated.`,name:"noise_sequence"},{anchor:"transformers.UnivNetModel.forward.padding_mask",description:`<strong>padding_mask</strong> (<code>torch.BoolTensor</code>, <em>optional</em>) &#x2014;
Mask indicating which parts of each sequence are padded. Mask values are selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong></li>
<li>0 for tokens that are <strong>masked</strong></li>
</ul>
<p>The mask can be batched and of shape <code>(batch_size, sequence_length)</code> or un-batched and of shape
<code>(sequence_length,)</code>.`,name:"padding_mask"},{anchor:"transformers.UnivNetModel.forward.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator</a> to make generation
deterministic.
return_dict &#x2014;
Whether to return a <a href="/docs/transformers/v4.43.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> subclass instead of a plain tuple.`,name:"generator"}],source:"https://github.com/huggingface/transformers/blob/v4.43.0/src/transformers/models/univnet/modeling_univnet.py#L506",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.univnet.modeling_univnet.UnivNetModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.43.0/en/model_doc/univnet#transformers.UnivNetConfig"
>UnivNetConfig</a>) and inputs.</p>
<ul>
<li><strong>waveforms</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Batched 1D (mono-channel) output audio waveforms.</li>
<li><strong>waveform_lengths</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size,)</code>) — The batched length in samples of each unpadded waveform in <code>waveforms</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.univnet.modeling_univnet.UnivNetModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),E=new vt({props:{$$slots:{default:[yt]},$$scope:{ctx:j}}}),z=new pt({props:{anchor:"transformers.UnivNetModel.forward.example",$$slots:{default:[Tt]},$$scope:{ctx:j}}}),O=new bt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/univnet.md"}}),{c(){i=d("meta"),M=o(),p=d("p"),m=o(),f(u.$$.fragment),s=o(),f(y.$$.fragment),fe=o(),G=d("p"),G.innerHTML=Pe,ge=o(),C=d("p"),C.textContent=Ae,_e=o(),W=d("p"),W.innerHTML=De,ve=o(),B=d("p"),B.textContent=Oe,be=o(),X=d("ul"),X.innerHTML=Ke,we=o(),R=d("p"),R.textContent=et,ye=o(),f(q.$$.fragment),Te=o(),V=d("p"),V.innerHTML=tt,Ue=o(),f(H.$$.fragment),Me=o(),x=d("div"),f(Y.$$.fragment),Ze=o(),ne=d("p"),ne.innerHTML=nt,Ee=o(),oe=d("p"),oe.innerHTML=ot,ze=o(),f($.$$.fragment),xe=o(),f(S.$$.fragment),Ne=o(),T=d("div"),f(L.$$.fragment),Ie=o(),ae=d("p"),ae.textContent=at,Ge=o(),re=d("p"),re.textContent=rt,Ce=o(),se=d("p"),se.innerHTML=st,We=o(),Z=d("div"),f(Q.$$.fragment),Be=o(),ie=d("p"),ie.textContent=it,ke=o(),f(P.$$.fragment),Je=o(),N=d("div"),f(A.$$.fragment),Xe=o(),le=d("p"),le.innerHTML=lt,Re=o(),de=d("p"),de.innerHTML=dt,qe=o(),U=d("div"),f(D.$$.fragment),Ve=o(),ce=d("p"),ce.innerHTML=ct,He=o(),f(E.$$.fragment),Ye=o(),me=d("p"),me.textContent=mt,Se=o(),f(z.$$.fragment),Fe=o(),f(O.$$.fragment),je=o(),pe=d("p"),this.h()},l(e){const t=_t("svelte-u9bgzb",document.head);i=c(t,"META",{name:!0,content:!0}),t.forEach(n),M=a(e),p=c(e,"P",{}),ee(p).forEach(n),m=a(e),g(u.$$.fragment,e),s=a(e),g(y.$$.fragment,e),fe=a(e),G=c(e,"P",{"data-svelte-h":!0}),h(G)!=="svelte-gr1nfd"&&(G.innerHTML=Pe),ge=a(e),C=c(e,"P",{"data-svelte-h":!0}),h(C)!=="svelte-vfdo9a"&&(C.textContent=Ae),_e=a(e),W=c(e,"P",{"data-svelte-h":!0}),h(W)!=="svelte-1uiu21e"&&(W.innerHTML=De),ve=a(e),B=c(e,"P",{"data-svelte-h":!0}),h(B)!=="svelte-axv494"&&(B.textContent=Oe),be=a(e),X=c(e,"UL",{"data-svelte-h":!0}),h(X)!=="svelte-scu79d"&&(X.innerHTML=Ke),we=a(e),R=c(e,"P",{"data-svelte-h":!0}),h(R)!=="svelte-knisyv"&&(R.textContent=et),ye=a(e),g(q.$$.fragment,e),Te=a(e),V=c(e,"P",{"data-svelte-h":!0}),h(V)!=="svelte-vb7l6k"&&(V.innerHTML=tt),Ue=a(e),g(H.$$.fragment,e),Me=a(e),x=c(e,"DIV",{class:!0});var J=ee(x);g(Y.$$.fragment,J),Ze=a(J),ne=c(J,"P",{"data-svelte-h":!0}),h(ne)!=="svelte-kq67q9"&&(ne.innerHTML=nt),Ee=a(J),oe=c(J,"P",{"data-svelte-h":!0}),h(oe)!=="svelte-w5ddnh"&&(oe.innerHTML=ot),ze=a(J),g($.$$.fragment,J),J.forEach(n),xe=a(e),g(S.$$.fragment,e),Ne=a(e),T=c(e,"DIV",{class:!0});var k=ee(T);g(L.$$.fragment,k),Ie=a(k),ae=c(k,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-a7avru"&&(ae.textContent=at),Ge=a(k),re=c(k,"P",{"data-svelte-h":!0}),h(re)!=="svelte-v863cv"&&(re.textContent=rt),Ce=a(k),se=c(k,"P",{"data-svelte-h":!0}),h(se)!=="svelte-3b8ywz"&&(se.innerHTML=st),We=a(k),Z=c(k,"DIV",{class:!0});var K=ee(Z);g(Q.$$.fragment,K),Be=a(K),ie=c(K,"P",{"data-svelte-h":!0}),h(ie)!=="svelte-1a6wgfx"&&(ie.textContent=it),K.forEach(n),k.forEach(n),ke=a(e),g(P.$$.fragment,e),Je=a(e),N=c(e,"DIV",{class:!0});var I=ee(N);g(A.$$.fragment,I),Xe=a(I),le=c(I,"P",{"data-svelte-h":!0}),h(le)!=="svelte-139zisz"&&(le.innerHTML=lt),Re=a(I),de=c(I,"P",{"data-svelte-h":!0}),h(de)!=="svelte-hswkmf"&&(de.innerHTML=dt),qe=a(I),U=c(I,"DIV",{class:!0});var F=ee(U);g(D.$$.fragment,F),Ve=a(F),ce=c(F,"P",{"data-svelte-h":!0}),h(ce)!=="svelte-1fu851u"&&(ce.innerHTML=ct),He=a(F),g(E.$$.fragment,F),Ye=a(F),me=c(F,"P",{"data-svelte-h":!0}),h(me)!=="svelte-33iv5v"&&(me.textContent=mt),Se=a(F),g(z.$$.fragment,F),F.forEach(n),I.forEach(n),Fe=a(e),g(O.$$.fragment,e),je=a(e),pe=c(e,"P",{}),ee(pe).forEach(n),this.h()},h(){te(i,"name","hf:doc:metadata"),te(i,"content",Mt),te(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),te(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),te(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),te(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),te(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,i),r(e,M,t),r(e,p,t),r(e,m,t),_(u,e,t),r(e,s,t),_(y,e,t),r(e,fe,t),r(e,G,t),r(e,ge,t),r(e,C,t),r(e,_e,t),r(e,W,t),r(e,ve,t),r(e,B,t),r(e,be,t),r(e,X,t),r(e,we,t),r(e,R,t),r(e,ye,t),_(q,e,t),r(e,Te,t),r(e,V,t),r(e,Ue,t),_(H,e,t),r(e,Me,t),r(e,x,t),_(Y,x,null),l(x,Ze),l(x,ne),l(x,Ee),l(x,oe),l(x,ze),_($,x,null),r(e,xe,t),_(S,e,t),r(e,Ne,t),r(e,T,t),_(L,T,null),l(T,Ie),l(T,ae),l(T,Ge),l(T,re),l(T,Ce),l(T,se),l(T,We),l(T,Z),_(Q,Z,null),l(Z,Be),l(Z,ie),r(e,ke,t),_(P,e,t),r(e,Je,t),r(e,N,t),_(A,N,null),l(N,Xe),l(N,le),l(N,Re),l(N,de),l(N,qe),l(N,U),_(D,U,null),l(U,Ve),l(U,ce),l(U,He),_(E,U,null),l(U,Ye),l(U,me),l(U,Se),_(z,U,null),r(e,Fe,t),_(O,e,t),r(e,je,t),r(e,pe,t),$e=!0},p(e,[t]){const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),$.$set(J);const k={};t&2&&(k.$$scope={dirty:t,ctx:e}),E.$set(k);const K={};t&2&&(K.$$scope={dirty:t,ctx:e}),z.$set(K)},i(e){$e||(v(u.$$.fragment,e),v(y.$$.fragment,e),v(q.$$.fragment,e),v(H.$$.fragment,e),v(Y.$$.fragment,e),v($.$$.fragment,e),v(S.$$.fragment,e),v(L.$$.fragment,e),v(Q.$$.fragment,e),v(P.$$.fragment,e),v(A.$$.fragment,e),v(D.$$.fragment,e),v(E.$$.fragment,e),v(z.$$.fragment,e),v(O.$$.fragment,e),$e=!0)},o(e){b(u.$$.fragment,e),b(y.$$.fragment,e),b(q.$$.fragment,e),b(H.$$.fragment,e),b(Y.$$.fragment,e),b($.$$.fragment,e),b(S.$$.fragment,e),b(L.$$.fragment,e),b(Q.$$.fragment,e),b(P.$$.fragment,e),b(A.$$.fragment,e),b(D.$$.fragment,e),b(E.$$.fragment,e),b(z.$$.fragment,e),b(O.$$.fragment,e),$e=!1},d(e){e&&(n(M),n(p),n(m),n(s),n(fe),n(G),n(ge),n(C),n(_e),n(W),n(ve),n(B),n(be),n(X),n(we),n(R),n(ye),n(Te),n(V),n(Ue),n(Me),n(x),n(xe),n(Ne),n(T),n(ke),n(Je),n(N),n(Fe),n(je),n(pe)),n(i),w(u,e),w(y,e),w(q,e),w(H,e),w(Y),w($),w(S,e),w(L),w(Q),w(P,e),w(A),w(D),w(E),w(z),w(O,e)}}}const Mt='{"title":"UnivNet","local":"univnet","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"UnivNetConfig","local":"transformers.UnivNetConfig","sections":[],"depth":2},{"title":"UnivNetFeatureExtractor","local":"transformers.UnivNetFeatureExtractor","sections":[],"depth":2},{"title":"UnivNetModel","local":"transformers.UnivNetModel","sections":[],"depth":2}],"depth":1}';function xt(j){return ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Et extends ft{constructor(i){super(),gt(this,i,xt,Ut,ht,{})}}export{Et as component};
