import{s as un,f as pn,o as hn,n as We}from"../chunks/scheduler.9bc65507.js";import{S as fn,i as _n,g as c,s as t,r as u,A as bn,h as l,f as n,c as s,j as z,u as p,x as v,k as D,y as i,a as d,v as h,d as f,t as _,w as b}from"../chunks/index.707bf1b6.js";import{T as gn}from"../chunks/Tip.c2ecdbf4.js";import{D as N}from"../chunks/Docstring.570ddb64.js";import{C as uo}from"../chunks/CodeBlock.54a9f38d.js";import{E as qo}from"../chunks/ExampleCodeBlock.bc2be6bc.js";import{H as X,E as vn}from"../chunks/EditOnGithub.922df6ba.js";function yn(C){let r,T="Examples:",m,g,y;return g=new uo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdyb3VuZGluZ0Rpbm9Db25maWclMkMlMjBHcm91bmRpbmdEaW5vTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwR3JvdW5kaW5nJTIwRElOTyUyMElERUEtUmVzZWFyY2glMkZncm91bmRpbmctZGluby10aW55JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMEdyb3VuZGluZ0Rpbm9Db25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwSURFQS1SZXNlYXJjaCUyRmdyb3VuZGluZy1kaW5vLXRpbnklMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMEdyb3VuZGluZ0Rpbm9Nb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GroundingDinoConfig, GroundingDinoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Grounding DINO IDEA-Research/grounding-dino-tiny style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = GroundingDinoConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the IDEA-Research/grounding-dino-tiny style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GroundingDinoModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){r=c("p"),r.textContent=T,m=t(),u(g.$$.fragment)},l(a){r=l(a,"P",{"data-svelte-h":!0}),v(r)!=="svelte-kvfsh7"&&(r.textContent=T),m=s(a),p(g.$$.fragment,a)},m(a,w){d(a,r,w),d(a,m,w),h(g,a,w),y=!0},p:We,i(a){y||(f(g.$$.fragment,a),y=!0)},o(a){_(g.$$.fragment,a),y=!1},d(a){a&&(n(r),n(m)),b(g,a)}}}function Tn(C){let r,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=c("p"),r.innerHTML=T},l(m){r=l(m,"P",{"data-svelte-h":!0}),v(r)!=="svelte-fincs2"&&(r.innerHTML=T)},m(m,g){d(m,r,g)},p:We,d(m){m&&n(r)}}}function wn(C){let r,T="Examples:",m,g,y;return g=new uo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWwlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEF0ZXh0JTIwJTNEJTIwJTIyYSUyMGNhdC4lMjIlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJJREVBLVJlc2VhcmNoJTJGZ3JvdW5kaW5nLWRpbm8tdGlueSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIySURFQS1SZXNlYXJjaCUyRmdyb3VuZGluZy1kaW5vLXRpbnklMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwdGV4dCUzRHRleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;a cat.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;IDEA-Research/grounding-dino-tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;IDEA-Research/grounding-dino-tiny&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">900</span>, <span class="hljs-number">256</span>]`,wrap:!1}}),{c(){r=c("p"),r.textContent=T,m=t(),u(g.$$.fragment)},l(a){r=l(a,"P",{"data-svelte-h":!0}),v(r)!=="svelte-kvfsh7"&&(r.textContent=T),m=s(a),p(g.$$.fragment,a)},m(a,w){d(a,r,w),d(a,m,w),h(g,a,w),y=!0},p:We,i(a){y||(f(g.$$.fragment,a),y=!0)},o(a){_(g.$$.fragment,a),y=!1},d(a){a&&(n(r),n(m)),b(g,a)}}}function xn(C){let r,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=c("p"),r.innerHTML=T},l(m){r=l(m,"P",{"data-svelte-h":!0}),v(r)!=="svelte-fincs2"&&(r.innerHTML=T)},m(m,g){d(m,r,g)},p:We,d(m){m&&n(r)}}}function Mn(C){let r,T="Examples:",m,g,y;return g=new uo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBHcm91bmRpbmdEaW5vRm9yT2JqZWN0RGV0ZWN0aW9uJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBdGV4dCUyMCUzRCUyMCUyMmElMjBjYXQuJTIyJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIySURFQS1SZXNlYXJjaCUyRmdyb3VuZGluZy1kaW5vLXRpbnklMjIpJTBBbW9kZWwlMjAlM0QlMjBHcm91bmRpbmdEaW5vRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJJREVBLVJlc2VhcmNoJTJGZ3JvdW5kaW5nLWRpbm8tdGlueSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjB0ZXh0JTNEdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMGNvbnZlcnQlMjBvdXRwdXRzJTIwKGJvdW5kaW5nJTIwYm94ZXMlMjBhbmQlMjBjbGFzcyUyMGxvZ2l0cyklMjB0byUyMENPQ08lMjBBUEklMEF0YXJnZXRfc2l6ZXMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCaW1hZ2Uuc2l6ZSU1QiUzQSUzQS0xJTVEJTVEKSUwQXJlc3VsdHMlMjAlM0QlMjBwcm9jZXNzb3IuaW1hZ2VfcHJvY2Vzc29yLnBvc3RfcHJvY2Vzc19vYmplY3RfZGV0ZWN0aW9uKCUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMkMlMjB0aHJlc2hvbGQlM0QwLjM1JTJDJTIwdGFyZ2V0X3NpemVzJTNEdGFyZ2V0X3NpemVzJTBBKSU1QjAlNUQlMEFmb3IlMjBzY29yZSUyQyUyMGxhYmVsJTJDJTIwYm94JTIwaW4lMjB6aXAocmVzdWx0cyU1QiUyMnNjb3JlcyUyMiU1RCUyQyUyMHJlc3VsdHMlNUIlMjJsYWJlbHMlMjIlNUQlMkMlMjByZXN1bHRzJTVCJTIyYm94ZXMlMjIlNUQpJTNBJTBBJTIwJTIwJTIwJTIwYm94JTIwJTNEJTIwJTVCcm91bmQoaSUyQyUyMDEpJTIwZm9yJTIwaSUyMGluJTIwYm94LnRvbGlzdCgpJTVEJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMkRldGVjdGVkJTIwJTdCbGFiZWwuaXRlbSgpJTdEJTIwd2l0aCUyMGNvbmZpZGVuY2UlMjAlMjIlMjBmJTIyJTdCcm91bmQoc2NvcmUuaXRlbSgpJTJDJTIwMiklN0QlMjBhdCUyMGxvY2F0aW9uJTIwJTdCYm94JTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, GroundingDinoForObjectDetection
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;a cat.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;IDEA-Research/grounding-dino-tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GroundingDinoForObjectDetection.from_pretrained(<span class="hljs-string">&quot;IDEA-Research/grounding-dino-tiny&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># convert outputs (bounding boxes and class logits) to COCO API</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span>results = processor.image_processor.post_process_object_detection(
<span class="hljs-meta">... </span>    outputs, threshold=<span class="hljs-number">0.35</span>, target_sizes=target_sizes
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">1</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Detected <span class="hljs-subst">{label.item()}</span> with confidence &quot;</span> <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">2</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>)
Detected <span class="hljs-number">1</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.45</span> at location [<span class="hljs-number">344.8</span>, <span class="hljs-number">23.2</span>, <span class="hljs-number">637.4</span>, <span class="hljs-number">373.8</span>]
Detected <span class="hljs-number">1</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.41</span> at location [<span class="hljs-number">11.9</span>, <span class="hljs-number">51.6</span>, <span class="hljs-number">316.6</span>, <span class="hljs-number">472.9</span>]`,wrap:!1}}),{c(){r=c("p"),r.textContent=T,m=t(),u(g.$$.fragment)},l(a){r=l(a,"P",{"data-svelte-h":!0}),v(r)!=="svelte-kvfsh7"&&(r.textContent=T),m=s(a),p(g.$$.fragment,a)},m(a,w){d(a,r,w),d(a,m,w),h(g,a,w),y=!0},p:We,i(a){y||(f(g.$$.fragment,a),y=!0)},o(a){_(g.$$.fragment,a),y=!1},d(a){a&&(n(r),n(m)),b(g,a)}}}function Dn(C){let r,T,m,g,y,a,w,Be,Q,Eo='The Grounding DINO model was proposed in <a href="https://arxiv.org/abs/2303.05499" rel="nofollow">Grounding DINO: Marrying DINO with Grounded Pre-Training for Open-Set Object Detection</a> by Shilong Liu, Zhaoyang Zeng, Tianhe Ren, Feng Li, Hao Zhang, Jie Yang, Chunyuan Li, Jianwei Yang, Hang Su, Jun Zhu, Lei Zhang. Grounding DINO extends a closed-set object detection model with a text encoder, enabling open-set object detection. The model achieves remarkable results, such as 52.5 AP on COCO zero-shot.',Le,Y,Wo="The abstract from the paper is the following:",Ve,K,Bo="<em>In this paper, we present an open-set object detector, called Grounding DINO, by marrying Transformer-based detector DINO with grounded pre-training, which can detect arbitrary objects with human inputs such as category names or referring expressions. The key solution of open-set object detection is introducing language to a closed-set detector for open-set concept generalization. To effectively fuse language and vision modalities, we conceptually divide a closed-set detector into three phases and propose a tight fusion solution, which includes a feature enhancer, a language-guided query selection, and a cross-modality decoder for cross-modality fusion. While previous works mainly evaluate open-set object detection on novel categories, we propose to also perform evaluations on referring expression comprehension for objects specified with attributes. Grounding DINO performs remarkably well on all three settings, including benchmarks on COCO, LVIS, ODinW, and RefCOCO/+/g. Grounding DINO achieves a 52.5 AP on the COCO detection zero-shot transfer benchmark, i.e., without any training data from COCO. It sets a new record on the ODinW zero-shot benchmark with a mean 26.1 AP.</em>",Oe,Z,Lo,He,ee,Vo='Grounding DINO overview. Taken from the <a href="https://arxiv.org/abs/2303.05499">original paper</a>.',Ae,oe,Oo=`This model was contributed by <a href="https://huggingface.co/EduardoPacheco" rel="nofollow">EduardoPacheco</a> and <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/IDEA-Research/GroundingDINO" rel="nofollow">here</a>.`,Se,ne,Xe,te,Ho='<li>One can use <a href="/docs/transformers/v4.40.1/en/model_doc/grounding-dino#transformers.GroundingDinoProcessor">GroundingDinoProcessor</a> to prepare image-text pairs for the model.</li> <li>To separate classes in the text use a period e.g. “a cat. a dog.”</li> <li>When using multiple classes (e.g. <code>&quot;a cat. a dog.&quot;</code>), use <code>post_process_grounded_object_detection</code> from <a href="/docs/transformers/v4.40.1/en/model_doc/grounding-dino#transformers.GroundingDinoProcessor">GroundingDinoProcessor</a> to post process outputs. Since, the labels returned from <code>post_process_object_detection</code> represent the indices from the model dimension where prob &gt; threshold.</li>',Qe,se,Ao="Here’s how to use the model for zero-shot object detection:",Ye,re,Ke,ae,eo,j,ie,po,De,So="Constructs a Grounding DINO image processor.",ho,R,de,fo,je,Xo="Preprocess an image or a batch of images so that it can be used by the model.",_o,q,ce,bo,Ge,Qo=`Converts the raw output of <a href="/docs/transformers/v4.40.1/en/model_doc/grounding-dino#transformers.GroundingDinoForObjectDetection">GroundingDinoForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format.`,oo,le,no,G,me,vo,ke,Yo=`Constructs a Grounding DINO processor which wraps a Deformable DETR image processor and a BERT tokenizer into a
single processor.`,yo,Ce,Ko=`<a href="/docs/transformers/v4.40.1/en/model_doc/grounding-dino#transformers.GroundingDinoProcessor">GroundingDinoProcessor</a> offers all the functionalities of <a href="/docs/transformers/v4.40.1/en/model_doc/grounding-dino#transformers.GroundingDinoImageProcessor">GroundingDinoImageProcessor</a> and
<a href="/docs/transformers/v4.40.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See the docstring of <code>__call__()</code> and <code>decode()</code>
for more information.`,To,E,ge,wo,Ie,en=`Converts the raw output of <a href="/docs/transformers/v4.40.1/en/model_doc/grounding-dino#transformers.GroundingDinoForObjectDetection">GroundingDinoForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format and get the associated text label.`,to,ue,so,k,pe,xo,$e,on=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.40.1/en/model_doc/grounding-dino#transformers.GroundingDinoModel">GroundingDinoModel</a>. It is used to instantiate a
Grounding DINO model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Grounding DINO
<a href="https://huggingface.co/IDEA-Research/grounding-dino-tiny" rel="nofollow">IDEA-Research/grounding-dino-tiny</a> architecture.`,Mo,ze,nn=`Configuration objects inherit from <a href="/docs/transformers/v4.40.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.40.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Do,W,ro,he,ao,x,fe,jo,Je,tn=`The bare Grounding DINO Model (consisting of a backbone and encoder-decoder Transformer) outputting raw
hidden-states without any specific head on top.`,Go,Ue,sn=`This model inherits from <a href="/docs/transformers/v4.40.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ko,Fe,rn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Co,I,_e,Io,Pe,an='The <a href="/docs/transformers/v4.40.1/en/model_doc/grounding-dino#transformers.GroundingDinoModel">GroundingDinoModel</a> forward method, overrides the <code>__call__</code> special method.',$o,B,zo,L,io,be,co,M,ve,Jo,Ne,dn=`Grounding DINO Model (consisting of a backbone and encoder-decoder Transformer) with object detection heads on top,
for tasks such as COCO detection.`,Uo,Ze,cn=`This model inherits from <a href="/docs/transformers/v4.40.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Fo,Re,ln=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Po,$,ye,No,qe,mn='The <a href="/docs/transformers/v4.40.1/en/model_doc/grounding-dino#transformers.GroundingDinoForObjectDetection">GroundingDinoForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',Zo,V,Ro,O,lo,Te,mo,Ee,go;return y=new X({props:{title:"Grounding DINO",local:"grounding-dino",headingTag:"h1"}}),w=new X({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ne=new X({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),re=new uo({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvUHJvY2Vzc29yJTJDJTIwQXV0b01vZGVsRm9yWmVyb1Nob3RPYmplY3REZXRlY3Rpb24lMkMlMjAlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMklERUEtUmVzZWFyY2glMkZncm91bmRpbmctZGluby10aW55JTIyJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdE9iamVjdERldGVjdGlvbi5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpLnRvKGRldmljZSklMEElMEFpbWFnZV91cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldChpbWFnZV91cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTIzJTIwQ2hlY2slMjBmb3IlMjBjYXRzJTIwYW5kJTIwcmVtb3RlJTIwY29udHJvbHMlMEF0ZXh0JTIwJTNEJTIwJTIyYSUyMGNhdC4lMjBhJTIwcmVtb3RlJTIwY29udHJvbC4lMjIlMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjB0ZXh0JTNEdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQXJlc3VsdHMlMjAlM0QlMjBwcm9jZXNzb3IucG9zdF9wcm9jZXNzX2dyb3VuZGVkX29iamVjdF9kZXRlY3Rpb24oJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyQyUwQSUyMCUyMCUyMCUyMGlucHV0cy5pbnB1dF9pZHMlMkMlMEElMjAlMjAlMjAlMjBib3hfdGhyZXNob2xkJTNEMC40JTJDJTBBJTIwJTIwJTIwJTIwdGV4dF90aHJlc2hvbGQlM0QwLjMlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfc2l6ZXMlM0QlNUJpbWFnZS5zaXplJTVCJTNBJTNBLTElNUQlNUQlMEEp",highlighted:`<span class="hljs-keyword">import</span> requests

<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForZeroShotObjectDetection, 

model_id = <span class="hljs-string">&quot;IDEA-Research/grounding-dino-tiny&quot;</span>

processor = AutoProcessor.from_pretrained(model_id)
model = AutoModelForZeroShotObjectDetection.from_pretrained(model_id).to(device)

image_url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(image_url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-comment"># Check for cats and remote controls</span>
text = <span class="hljs-string">&quot;a cat. a remote control.&quot;</span>

inputs = processor(images=image, text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**inputs)

results = processor.post_process_grounded_object_detection(
    outputs,
    inputs.input_ids,
    box_threshold=<span class="hljs-number">0.4</span>,
    text_threshold=<span class="hljs-number">0.3</span>,
    target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
)`,wrap:!1}}),ae=new X({props:{title:"GroundingDinoImageProcessor",local:"transformers.GroundingDinoImageProcessor",headingTag:"h2"}}),ie=new N({props:{name:"class transformers.GroundingDinoImageProcessor",anchor:"transformers.GroundingDinoImageProcessor",parameters:[{name:"format",val:": Union = <AnnotationFormat.COCO_DETECTION: 'coco_detection'>"},{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_convert_annotations",val:": Optional = None"},{name:"do_pad",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GroundingDinoImageProcessor.format",description:`<strong>format</strong> (<code>str</code>, <em>optional</em>, defaults to <code>AnnotationFormat.COCO_DETECTION</code>) &#x2014;
Data format of the annotations. One of &#x201C;coco_detection&#x201D; or &#x201C;coco_panoptic&#x201D;.`,name:"format"},{anchor:"transformers.GroundingDinoImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be
overridden by the <code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.GroundingDinoImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 800, &quot;longest_edge&quot;: 1333}</code>):
Size of the image&#x2019;s (height, width) dimensions after resizing. Can be overridden by the <code>size</code> parameter in
the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.GroundingDinoImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image.`,name:"resample"},{anchor:"transformers.GroundingDinoImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.GroundingDinoImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method. Controls whether to normalize the image. Can be overridden by the <code>do_normalize</code>
parameter in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.GroundingDinoImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.GroundingDinoImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_MEAN</code>) &#x2014;
Mean values to use when normalizing the image. Can be a single value or a list of values, one for each
channel. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.GroundingDinoImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_STD</code>) &#x2014;
Standard deviation values to use when normalizing the image. Can be a single value or a list of values, one
for each channel. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.GroundingDinoImageProcessor.do_convert_annotations",description:`<strong>do_convert_annotations</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to convert the annotations to the format expected by the DETR model. Converts the
bounding boxes to the format <code>(center_x, center_y, width, height)</code> and in the range <code>[0, 1]</code>.
Can be overridden by the <code>do_convert_annotations</code> parameter in the <code>preprocess</code> method.`,name:"do_convert_annotations"},{anchor:"transformers.GroundingDinoImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to pad the image to the largest image in a batch and create a pixel mask. Can be
overridden by the <code>do_pad</code> parameter in the <code>preprocess</code> method.`,name:"do_pad"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/models/grounding_dino/image_processing_grounding_dino.py#L765"}}),de=new N({props:{name:"preprocess",anchor:"transformers.GroundingDinoImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"annotations",val:": Union = None"},{name:"return_segmentation_masks",val:": bool = None"},{name:"masks_path",val:": Union = None"},{name:"do_resize",val:": Optional = None"},{name:"size",val:": Optional = None"},{name:"resample",val:" = None"},{name:"do_rescale",val:": Optional = None"},{name:"rescale_factor",val:": Union = None"},{name:"do_normalize",val:": Optional = None"},{name:"do_convert_annotations",val:": Optional = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_pad",val:": Optional = None"},{name:"format",val:": Union = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Union = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GroundingDinoImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image or batch of images to preprocess. Expects a single or batch of images with pixel values ranging
from 0 to 255. If passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.annotations",description:`<strong>annotations</strong> (<code>AnnotationType</code> or <code>List[AnnotationType]</code>, <em>optional</em>) &#x2014;
List of annotations associated with the image or batch of images. If annotation is for object
detection, the annotations should be a dictionary with the following keys:<ul>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;annotations&#x201D; (<code>List[Dict]</code>): List of annotations for an image. Each annotation should be a
dictionary. An image can have no annotations, in which case the list should be empty.
If annotation is for segmentation, the annotations should be a dictionary with the following keys:</li>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;segments_info&#x201D; (<code>List[Dict]</code>): List of segments for an image. Each segment should be a dictionary.
An image can have no segments, in which case the list should be empty.</li>
<li>&#x201C;file_name&#x201D; (<code>str</code>): The file name of the image.</li>
</ul>`,name:"annotations"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.return_segmentation_masks",description:`<strong>return_segmentation_masks</strong> (<code>bool</code>, <em>optional</em>, defaults to self.return_segmentation_masks) &#x2014;
Whether to return segmentation masks.`,name:"return_segmentation_masks"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.masks_path",description:`<strong>masks_path</strong> (<code>str</code> or <code>pathlib.Path</code>, <em>optional</em>) &#x2014;
Path to the directory containing the segmentation masks.`,name:"masks_path"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_resize) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to self.size) &#x2014;
Size of the image after resizing.`,name:"size"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to self.resample) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_rescale) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to self.rescale_factor) &#x2014;
Rescale factor to use when rescaling the image.`,name:"rescale_factor"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_normalize) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.do_convert_annotations",description:`<strong>do_convert_annotations</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_convert_annotations) &#x2014;
Whether to convert the annotations to the format expected by the model. Converts the bounding
boxes from the format <code>(top_left_x, top_left_y, width, height)</code> to <code>(center_x, center_y, width, height)</code>
and in relative coordinates.`,name:"do_convert_annotations"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_mean) &#x2014;
Mean to use when normalizing the image.`,name:"image_mean"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_std) &#x2014;
Standard deviation to use when normalizing the image.`,name:"image_std"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_pad) &#x2014;
Whether to pad the image. If <code>True</code> will pad the images in the batch to the largest image in the batch
and create a pixel mask. Padding will be applied to the bottom and right of the image with zeros.`,name:"do_pad"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.format",description:`<strong>format</strong> (<code>str</code> or <code>AnnotationFormat</code>, <em>optional</em>, defaults to self.format) &#x2014;
Format of the annotations.`,name:"format"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to self.return_tensors) &#x2014;
Type of tensors to return. If <code>None</code>, will return the list of images.`,name:"return_tensors"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/models/grounding_dino/image_processing_grounding_dino.py#L1208"}}),ce=new N({props:{name:"post_process_object_detection",anchor:"transformers.GroundingDinoImageProcessor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.1"},{name:"target_sizes",val:": Union = None"}],parametersDescription:[{anchor:"transformers.GroundingDinoImageProcessor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>GroundingDinoObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.GroundingDinoImageProcessor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.GroundingDinoImageProcessor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/models/grounding_dino/image_processing_grounding_dino.py#L1458",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),le=new X({props:{title:"GroundingDinoProcessor",local:"transformers.GroundingDinoProcessor",headingTag:"h2"}}),me=new N({props:{name:"class transformers.GroundingDinoProcessor",anchor:"transformers.GroundingDinoProcessor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:""}],parametersDescription:[{anchor:"transformers.GroundingDinoProcessor.image_processor",description:`<strong>image_processor</strong> (<code>GroundingDinoImageProcessor</code>) &#x2014;
An instance of <a href="/docs/transformers/v4.40.1/en/model_doc/grounding-dino#transformers.GroundingDinoImageProcessor">GroundingDinoImageProcessor</a>. The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.GroundingDinoProcessor.tokenizer",description:"<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;\nAn instance of [&#x2018;PreTrainedTokenizer`]. The tokenizer is a required input.",name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/models/grounding_dino/processing_grounding_dino.py#L59"}}),ge=new N({props:{name:"post_process_grounded_object_detection",anchor:"transformers.GroundingDinoProcessor.post_process_grounded_object_detection",parameters:[{name:"outputs",val:""},{name:"input_ids",val:""},{name:"box_threshold",val:": float = 0.25"},{name:"text_threshold",val:": float = 0.25"},{name:"target_sizes",val:": Union = None"}],parametersDescription:[{anchor:"transformers.GroundingDinoProcessor.post_process_grounded_object_detection.outputs",description:`<strong>outputs</strong> (<code>GroundingDinoObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.GroundingDinoProcessor.post_process_grounded_object_detection.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The token ids of the input text.`,name:"input_ids"},{anchor:"transformers.GroundingDinoProcessor.post_process_grounded_object_detection.box_threshold",description:`<strong>box_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.25) &#x2014;
Score threshold to keep object detection predictions.`,name:"box_threshold"},{anchor:"transformers.GroundingDinoProcessor.post_process_grounded_object_detection.text_threshold",description:`<strong>text_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.25) &#x2014;
Score threshold to keep text detection predictions.`,name:"text_threshold"},{anchor:"transformers.GroundingDinoProcessor.post_process_grounded_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/models/grounding_dino/processing_grounding_dino.py#L166",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),ue=new X({props:{title:"GroundingDinoConfig",local:"transformers.GroundingDinoConfig",headingTag:"h2"}}),pe=new N({props:{name:"class transformers.GroundingDinoConfig",anchor:"transformers.GroundingDinoConfig",parameters:[{name:"backbone_config",val:" = None"},{name:"backbone",val:" = None"},{name:"use_pretrained_backbone",val:" = False"},{name:"use_timm_backbone",val:" = False"},{name:"backbone_kwargs",val:" = None"},{name:"text_config",val:" = None"},{name:"num_queries",val:" = 900"},{name:"encoder_layers",val:" = 6"},{name:"encoder_ffn_dim",val:" = 2048"},{name:"encoder_attention_heads",val:" = 8"},{name:"decoder_layers",val:" = 6"},{name:"decoder_ffn_dim",val:" = 2048"},{name:"decoder_attention_heads",val:" = 8"},{name:"is_encoder_decoder",val:" = True"},{name:"activation_function",val:" = 'relu'"},{name:"d_model",val:" = 256"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"auxiliary_loss",val:" = False"},{name:"position_embedding_type",val:" = 'sine'"},{name:"num_feature_levels",val:" = 4"},{name:"encoder_n_points",val:" = 4"},{name:"decoder_n_points",val:" = 4"},{name:"two_stage",val:" = True"},{name:"class_cost",val:" = 1.0"},{name:"bbox_cost",val:" = 5.0"},{name:"giou_cost",val:" = 2.0"},{name:"bbox_loss_coefficient",val:" = 5.0"},{name:"giou_loss_coefficient",val:" = 2.0"},{name:"focal_alpha",val:" = 0.25"},{name:"disable_custom_kernels",val:" = False"},{name:"max_text_len",val:" = 256"},{name:"text_enhancer_dropout",val:" = 0.0"},{name:"fusion_droppath",val:" = 0.1"},{name:"fusion_dropout",val:" = 0.0"},{name:"embedding_init_target",val:" = True"},{name:"query_dim",val:" = 4"},{name:"decoder_bbox_embed_share",val:" = True"},{name:"two_stage_bbox_embed_share",val:" = False"},{name:"positional_embedding_temperature",val:" = 20"},{name:"init_std",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GroundingDinoConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>, defaults to <code>ResNetConfig()</code>) &#x2014;
The configuration of the backbone model.`,name:"backbone_config"},{anchor:"transformers.GroundingDinoConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.GroundingDinoConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.GroundingDinoConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to load <code>backbone</code> from the timm library. If <code>False</code>, the backbone is loaded from the transformers
library.`,name:"use_timm_backbone"},{anchor:"transformers.GroundingDinoConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.GroundingDinoConfig.text_config",description:`<strong>text_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>, defaults to <code>BertConfig</code>) &#x2014;
The config object or dictionary of the text backbone.`,name:"text_config"},{anchor:"transformers.GroundingDinoConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 900) &#x2014;
Number of object queries, i.e. detection slots. This is the maximal number of objects
<a href="/docs/transformers/v4.40.1/en/model_doc/grounding-dino#transformers.GroundingDinoModel">GroundingDinoModel</a> can detect in a single image.`,name:"num_queries"},{anchor:"transformers.GroundingDinoConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of encoder layers.`,name:"encoder_layers"},{anchor:"transformers.GroundingDinoConfig.encoder_ffn_dim",description:`<strong>encoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"encoder_ffn_dim"},{anchor:"transformers.GroundingDinoConfig.encoder_attention_heads",description:`<strong>encoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"encoder_attention_heads"},{anchor:"transformers.GroundingDinoConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of decoder layers.`,name:"decoder_layers"},{anchor:"transformers.GroundingDinoConfig.decoder_ffn_dim",description:`<strong>decoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"decoder_ffn_dim"},{anchor:"transformers.GroundingDinoConfig.decoder_attention_heads",description:`<strong>decoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_attention_heads"},{anchor:"transformers.GroundingDinoConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the model is used as an encoder/decoder or not.`,name:"is_encoder_decoder"},{anchor:"transformers.GroundingDinoConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.GroundingDinoConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension of the layers.`,name:"d_model"},{anchor:"transformers.GroundingDinoConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"dropout"},{anchor:"transformers.GroundingDinoConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.GroundingDinoConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.GroundingDinoConfig.auxiliary_loss",description:`<strong>auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether auxiliary decoding losses (loss at each decoder layer) are to be used.`,name:"auxiliary_loss"},{anchor:"transformers.GroundingDinoConfig.position_embedding_type",description:`<strong>position_embedding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sine&quot;</code>) &#x2014;
Type of position embeddings to be used on top of the image features. One of <code>&quot;sine&quot;</code> or <code>&quot;learned&quot;</code>.`,name:"position_embedding_type"},{anchor:"transformers.GroundingDinoConfig.num_feature_levels",description:`<strong>num_feature_levels</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of input feature levels.`,name:"num_feature_levels"},{anchor:"transformers.GroundingDinoConfig.encoder_n_points",description:`<strong>encoder_n_points</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of sampled keys in each feature level for each attention head in the encoder.`,name:"encoder_n_points"},{anchor:"transformers.GroundingDinoConfig.decoder_n_points",description:`<strong>decoder_n_points</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of sampled keys in each feature level for each attention head in the decoder.`,name:"decoder_n_points"},{anchor:"transformers.GroundingDinoConfig.two_stage",description:`<strong>two_stage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to apply a two-stage deformable DETR, where the region proposals are also generated by a variant of
Grounding DINO, which are further fed into the decoder for iterative bounding box refinement.`,name:"two_stage"},{anchor:"transformers.GroundingDinoConfig.class_cost",description:`<strong>class_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Relative weight of the classification error in the Hungarian matching cost.`,name:"class_cost"},{anchor:"transformers.GroundingDinoConfig.bbox_cost",description:`<strong>bbox_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Relative weight of the L1 error of the bounding box coordinates in the Hungarian matching cost.`,name:"bbox_cost"},{anchor:"transformers.GroundingDinoConfig.giou_cost",description:`<strong>giou_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
Relative weight of the generalized IoU loss of the bounding box in the Hungarian matching cost.`,name:"giou_cost"},{anchor:"transformers.GroundingDinoConfig.bbox_loss_coefficient",description:`<strong>bbox_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Relative weight of the L1 bounding box loss in the object detection loss.`,name:"bbox_loss_coefficient"},{anchor:"transformers.GroundingDinoConfig.giou_loss_coefficient",description:`<strong>giou_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
Relative weight of the generalized IoU loss in the object detection loss.`,name:"giou_loss_coefficient"},{anchor:"transformers.GroundingDinoConfig.focal_alpha",description:`<strong>focal_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to 0.25) &#x2014;
Alpha parameter in the focal loss.`,name:"focal_alpha"},{anchor:"transformers.GroundingDinoConfig.disable_custom_kernels",description:`<strong>disable_custom_kernels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Disable the use of custom CUDA and CPU kernels. This option is necessary for the ONNX export, as custom
kernels are not supported by PyTorch ONNX export.`,name:"disable_custom_kernels"},{anchor:"transformers.GroundingDinoConfig.max_text_len",description:`<strong>max_text_len</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The maximum length of the text input.`,name:"max_text_len"},{anchor:"transformers.GroundingDinoConfig.text_enhancer_dropout",description:`<strong>text_enhancer_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the text enhancer.`,name:"text_enhancer_dropout"},{anchor:"transformers.GroundingDinoConfig.fusion_droppath",description:`<strong>fusion_droppath</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The droppath ratio for the fusion module.`,name:"fusion_droppath"},{anchor:"transformers.GroundingDinoConfig.fusion_dropout",description:`<strong>fusion_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the fusion module.`,name:"fusion_dropout"},{anchor:"transformers.GroundingDinoConfig.embedding_init_target",description:`<strong>embedding_init_target</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to initialize the target with Embedding weights.`,name:"embedding_init_target"},{anchor:"transformers.GroundingDinoConfig.query_dim",description:`<strong>query_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The dimension of the query vector.`,name:"query_dim"},{anchor:"transformers.GroundingDinoConfig.decoder_bbox_embed_share",description:`<strong>decoder_bbox_embed_share</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to share the bbox regression head for all decoder layers.`,name:"decoder_bbox_embed_share"},{anchor:"transformers.GroundingDinoConfig.two_stage_bbox_embed_share",description:`<strong>two_stage_bbox_embed_share</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to share the bbox embedding between the two-stage bbox generator and the region proposal
generation.`,name:"two_stage_bbox_embed_share"},{anchor:"transformers.GroundingDinoConfig.positional_embedding_temperature",description:`<strong>positional_embedding_temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 20) &#x2014;
The temperature for Sine Positional Embedding that is used together with vision backbone.`,name:"positional_embedding_temperature"},{anchor:"transformers.GroundingDinoConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.GroundingDinoConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/models/grounding_dino/configuration_grounding_dino.py#L29"}}),W=new qo({props:{anchor:"transformers.GroundingDinoConfig.example",$$slots:{default:[yn]},$$scope:{ctx:C}}}),he=new X({props:{title:"GroundingDinoModel",local:"transformers.GroundingDinoModel",headingTag:"h2"}}),fe=new N({props:{name:"class transformers.GroundingDinoModel",anchor:"transformers.GroundingDinoModel",parameters:[{name:"config",val:": GroundingDinoConfig"}],parametersDescription:[{anchor:"transformers.GroundingDinoModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.40.1/en/model_doc/grounding-dino#transformers.GroundingDinoConfig">GroundingDinoConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.40.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/models/grounding_dino/modeling_grounding_dino.py#L2059"}}),_e=new N({props:{name:"forward",anchor:"transformers.GroundingDinoModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"input_ids",val:": Tensor"},{name:"token_type_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"pixel_mask",val:": Optional = None"},{name:"encoder_outputs",val:" = None"},{name:"output_attentions",val:" = None"},{name:"output_hidden_states",val:" = None"},{name:"return_dict",val:" = None"}],parametersDescription:[{anchor:"transformers.GroundingDinoModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/v4.40.1/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.40.1/en/model_doc/fuyu#transformers.FuyuImageProcessor.__call__">GroundingDinoImageProcessor.<strong>call</strong>()</a> for
details.`,name:"pixel_values"},{anchor:"transformers.GroundingDinoModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, text_sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.40.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <code>GroundingDinoTokenizer.__call__</code> for details.`,name:"input_ids"},{anchor:"transformers.GroundingDinoModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, text_sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>: 0 corresponds to a <code>sentence A</code> token, 1 corresponds to a <code>sentence B</code> token</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.GroundingDinoModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, text_sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for tokens that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.GroundingDinoModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.GroundingDinoModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state_vision</code>, <em>optional</em>: <code>last_hidden_state_text</code>, <em>optional</em>:
<code>vision_hidden_states</code>, <em>optional</em>: <code>text_hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state_vision</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence
of hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the
decoder.`,name:"encoder_outputs"},{anchor:"transformers.GroundingDinoModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GroundingDinoModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GroundingDinoModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.40.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/models/grounding_dino/modeling_grounding_dino.py#L2214",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.grounding_dino.modeling_grounding_dino.GroundingDinoModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.40.1/en/model_doc/grounding-dino#transformers.GroundingDinoConfig"
>GroundingDinoConfig</a>) and inputs.</p>
<ul>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>init_reference_points</strong> (<code>torch.FloatTensor</code> of shape  <code>(batch_size, num_queries, 4)</code>) — Initial reference points sent through the Transformer decoder.</li>
<li><strong>intermediate_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, hidden_size)</code>) — Stacked intermediate hidden states (output of each layer of the decoder).</li>
<li><strong>intermediate_reference_points</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, 4)</code>) — Stacked intermediate reference points (reference points of each layer of the decoder).</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, num_queries, hidden_size)</code>. Hidden-states of the decoder at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of tuples of <code>torch.FloatTensor</code> (one for attention for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the
weighted average in the self-attention, cross-attention and multi-scale deformable attention heads.</li>
<li><strong>encoder_last_hidden_state_vision</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_last_hidden_state_text</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_vision_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the vision embeddings + one for the output of each
layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the vision encoder at the
output of each layer plus the initial embedding outputs.</li>
<li><strong>encoder_text_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the text embeddings + one for the output of each layer)
of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the text encoder at the output of
each layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of tuples of <code>torch.FloatTensor</code> (one for attention for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the
weighted average in the text-vision attention, vision-text attention, text-enhancer (self-attention) and
multi-scale deformable attention heads. attention softmax, used to compute the weighted average in the
bi-attention heads.</li>
<li><strong>enc_outputs_class</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>, <em>optional</em>, returned when <code>config.two_stage=True</code>) — Predicted bounding boxes scores where the top <code>config.num_queries</code> scoring bounding boxes are picked as
region proposals in the first stage. Output of bounding box binary classification (i.e. foreground and
background).</li>
<li><strong>enc_outputs_coord_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, 4)</code>, <em>optional</em>, returned when <code>config.two_stage=True</code>) — Logits of predicted bounding boxes coordinates in the first stage.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.grounding_dino.modeling_grounding_dino.GroundingDinoModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),B=new gn({props:{$$slots:{default:[Tn]},$$scope:{ctx:C}}}),L=new qo({props:{anchor:"transformers.GroundingDinoModel.forward.example",$$slots:{default:[wn]},$$scope:{ctx:C}}}),be=new X({props:{title:"GroundingDinoForObjectDetection",local:"transformers.GroundingDinoForObjectDetection",headingTag:"h2"}}),ve=new N({props:{name:"class transformers.GroundingDinoForObjectDetection",anchor:"transformers.GroundingDinoForObjectDetection",parameters:[{name:"config",val:": GroundingDinoConfig"}],parametersDescription:[{anchor:"transformers.GroundingDinoForObjectDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.40.1/en/model_doc/grounding-dino#transformers.GroundingDinoConfig">GroundingDinoConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.40.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/models/grounding_dino/modeling_grounding_dino.py#L2906"}}),ye=new N({props:{name:"forward",anchor:"transformers.GroundingDinoForObjectDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"input_ids",val:": LongTensor"},{name:"token_type_ids",val:": LongTensor = None"},{name:"attention_mask",val:": LongTensor = None"},{name:"pixel_mask",val:": Optional = None"},{name:"encoder_outputs",val:": Union = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"labels",val:": List = None"}],parametersDescription:[{anchor:"transformers.GroundingDinoForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/v4.40.1/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.40.1/en/model_doc/fuyu#transformers.FuyuImageProcessor.__call__">GroundingDinoImageProcessor.<strong>call</strong>()</a> for
details.`,name:"pixel_values"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, text_sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.40.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <code>GroundingDinoTokenizer.__call__</code> for details.`,name:"input_ids"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, text_sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>: 0 corresponds to a <code>sentence A</code> token, 1 corresponds to a <code>sentence B</code> token</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, text_sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for tokens that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state_vision</code>, <em>optional</em>: <code>last_hidden_state_text</code>, <em>optional</em>:
<code>vision_hidden_states</code>, <em>optional</em>: <code>text_hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state_vision</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence
of hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the
decoder.`,name:"encoder_outputs"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.40.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.labels",description:`<strong>labels</strong> (<code>List[Dict]</code> of len <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the bipartite matching loss. List of dicts, each dictionary containing at least the
following 2 keys: &#x2018;class_labels&#x2019; and &#x2018;boxes&#x2019; (the class labels and bounding boxes of an image in the batch
respectively). The class labels themselves should be a <code>torch.LongTensor</code> of len <code>(number of bounding boxes in the image,)</code> and the boxes a <code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, 4)</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/models/grounding_dino/modeling_grounding_dino.py#L2952",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.grounding_dino.modeling_grounding_dino.GroundingDinoObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.40.1/en/model_doc/grounding-dino#transformers.GroundingDinoConfig"
>GroundingDinoConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <code>~GroundingDinoProcessor.post_process_object_detection</code> to retrieve the
unnormalized bounding boxes.</li>
<li><strong>auxiliary_outputs</strong> (<code>List[Dict]</code>, <em>optional</em>) — Optional, only returned when auxilary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, num_queries, hidden_size)</code>. Hidden-states of the decoder at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of tuples of <code>torch.FloatTensor</code> (one for attention for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the
weighted average in the self-attention, cross-attention and multi-scale deformable attention heads.</li>
<li><strong>encoder_last_hidden_state_vision</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_last_hidden_state_text</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_vision_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the vision embeddings + one for the output of each
layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the vision encoder at the
output of each layer plus the initial embedding outputs.</li>
<li><strong>encoder_text_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the text embeddings + one for the output of each layer)
of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the text encoder at the output of
each layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of tuples of <code>torch.FloatTensor</code> (one for attention for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the
weighted average in the text-vision attention, vision-text attention, text-enhancer (self-attention) and
multi-scale deformable attention heads.</li>
<li><strong>intermediate_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, hidden_size)</code>) — Stacked intermediate hidden states (output of each layer of the decoder).</li>
<li><strong>intermediate_reference_points</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, 4)</code>) — Stacked intermediate reference points (reference points of each layer of the decoder).</li>
<li><strong>init_reference_points</strong> (<code>torch.FloatTensor</code> of shape  <code>(batch_size, num_queries, 4)</code>) — Initial reference points sent through the Transformer decoder.</li>
<li><strong>enc_outputs_class</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>, <em>optional</em>, returned when <code>config.two_stage=True</code>) — Predicted bounding boxes scores where the top <code>config.num_queries</code> scoring bounding boxes are picked as
region proposals in the first stage. Output of bounding box binary classification (i.e. foreground and
background).</li>
<li><strong>enc_outputs_coord_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, 4)</code>, <em>optional</em>, returned when <code>config.two_stage=True</code>) — Logits of predicted bounding boxes coordinates in the first stage.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.grounding_dino.modeling_grounding_dino.GroundingDinoObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),V=new gn({props:{$$slots:{default:[xn]},$$scope:{ctx:C}}}),O=new qo({props:{anchor:"transformers.GroundingDinoForObjectDetection.forward.example",$$slots:{default:[Mn]},$$scope:{ctx:C}}}),Te=new vn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/grounding-dino.md"}}),{c(){r=c("meta"),T=t(),m=c("p"),g=t(),u(y.$$.fragment),a=t(),u(w.$$.fragment),Be=t(),Q=c("p"),Q.innerHTML=Eo,Le=t(),Y=c("p"),Y.textContent=Wo,Ve=t(),K=c("p"),K.innerHTML=Bo,Oe=t(),Z=c("img"),He=t(),ee=c("small"),ee.innerHTML=Vo,Ae=t(),oe=c("p"),oe.innerHTML=Oo,Se=t(),u(ne.$$.fragment),Xe=t(),te=c("ul"),te.innerHTML=Ho,Qe=t(),se=c("p"),se.textContent=Ao,Ye=t(),u(re.$$.fragment),Ke=t(),u(ae.$$.fragment),eo=t(),j=c("div"),u(ie.$$.fragment),po=t(),De=c("p"),De.textContent=So,ho=t(),R=c("div"),u(de.$$.fragment),fo=t(),je=c("p"),je.textContent=Xo,_o=t(),q=c("div"),u(ce.$$.fragment),bo=t(),Ge=c("p"),Ge.innerHTML=Qo,oo=t(),u(le.$$.fragment),no=t(),G=c("div"),u(me.$$.fragment),vo=t(),ke=c("p"),ke.textContent=Yo,yo=t(),Ce=c("p"),Ce.innerHTML=Ko,To=t(),E=c("div"),u(ge.$$.fragment),wo=t(),Ie=c("p"),Ie.innerHTML=en,to=t(),u(ue.$$.fragment),so=t(),k=c("div"),u(pe.$$.fragment),xo=t(),$e=c("p"),$e.innerHTML=on,Mo=t(),ze=c("p"),ze.innerHTML=nn,Do=t(),u(W.$$.fragment),ro=t(),u(he.$$.fragment),ao=t(),x=c("div"),u(fe.$$.fragment),jo=t(),Je=c("p"),Je.textContent=tn,Go=t(),Ue=c("p"),Ue.innerHTML=sn,ko=t(),Fe=c("p"),Fe.innerHTML=rn,Co=t(),I=c("div"),u(_e.$$.fragment),Io=t(),Pe=c("p"),Pe.innerHTML=an,$o=t(),u(B.$$.fragment),zo=t(),u(L.$$.fragment),io=t(),u(be.$$.fragment),co=t(),M=c("div"),u(ve.$$.fragment),Jo=t(),Ne=c("p"),Ne.textContent=dn,Uo=t(),Ze=c("p"),Ze.innerHTML=cn,Fo=t(),Re=c("p"),Re.innerHTML=ln,Po=t(),$=c("div"),u(ye.$$.fragment),No=t(),qe=c("p"),qe.innerHTML=mn,Zo=t(),u(V.$$.fragment),Ro=t(),u(O.$$.fragment),lo=t(),u(Te.$$.fragment),mo=t(),Ee=c("p"),this.h()},l(e){const o=bn("svelte-u9bgzb",document.head);r=l(o,"META",{name:!0,content:!0}),o.forEach(n),T=s(e),m=l(e,"P",{}),z(m).forEach(n),g=s(e),p(y.$$.fragment,e),a=s(e),p(w.$$.fragment,e),Be=s(e),Q=l(e,"P",{"data-svelte-h":!0}),v(Q)!=="svelte-1usvly6"&&(Q.innerHTML=Eo),Le=s(e),Y=l(e,"P",{"data-svelte-h":!0}),v(Y)!=="svelte-vfdo9a"&&(Y.textContent=Wo),Ve=s(e),K=l(e,"P",{"data-svelte-h":!0}),v(K)!=="svelte-14ayby0"&&(K.innerHTML=Bo),Oe=s(e),Z=l(e,"IMG",{src:!0,alt:!0,width:!0}),He=s(e),ee=l(e,"SMALL",{"data-svelte-h":!0}),v(ee)!=="svelte-1o9330u"&&(ee.innerHTML=Vo),Ae=s(e),oe=l(e,"P",{"data-svelte-h":!0}),v(oe)!=="svelte-1p2elqj"&&(oe.innerHTML=Oo),Se=s(e),p(ne.$$.fragment,e),Xe=s(e),te=l(e,"UL",{"data-svelte-h":!0}),v(te)!=="svelte-abgtyu"&&(te.innerHTML=Ho),Qe=s(e),se=l(e,"P",{"data-svelte-h":!0}),v(se)!=="svelte-ffyfwo"&&(se.textContent=Ao),Ye=s(e),p(re.$$.fragment,e),Ke=s(e),p(ae.$$.fragment,e),eo=s(e),j=l(e,"DIV",{class:!0});var J=z(j);p(ie.$$.fragment,J),po=s(J),De=l(J,"P",{"data-svelte-h":!0}),v(De)!=="svelte-1k24st3"&&(De.textContent=So),ho=s(J),R=l(J,"DIV",{class:!0});var we=z(R);p(de.$$.fragment,we),fo=s(we),je=l(we,"P",{"data-svelte-h":!0}),v(je)!=="svelte-jgz2ra"&&(je.textContent=Xo),we.forEach(n),_o=s(J),q=l(J,"DIV",{class:!0});var xe=z(q);p(ce.$$.fragment,xe),bo=s(xe),Ge=l(xe,"P",{"data-svelte-h":!0}),v(Ge)!=="svelte-j5z3qw"&&(Ge.innerHTML=Qo),xe.forEach(n),J.forEach(n),oo=s(e),p(le.$$.fragment,e),no=s(e),G=l(e,"DIV",{class:!0});var U=z(G);p(me.$$.fragment,U),vo=s(U),ke=l(U,"P",{"data-svelte-h":!0}),v(ke)!=="svelte-6v5vrh"&&(ke.textContent=Yo),yo=s(U),Ce=l(U,"P",{"data-svelte-h":!0}),v(Ce)!=="svelte-ix438h"&&(Ce.innerHTML=Ko),To=s(U),E=l(U,"DIV",{class:!0});var Me=z(E);p(ge.$$.fragment,Me),wo=s(Me),Ie=l(Me,"P",{"data-svelte-h":!0}),v(Ie)!=="svelte-1hklwxj"&&(Ie.innerHTML=en),Me.forEach(n),U.forEach(n),to=s(e),p(ue.$$.fragment,e),so=s(e),k=l(e,"DIV",{class:!0});var H=z(k);p(pe.$$.fragment,H),xo=s(H),$e=l(H,"P",{"data-svelte-h":!0}),v($e)!=="svelte-ovnupr"&&($e.innerHTML=on),Mo=s(H),ze=l(H,"P",{"data-svelte-h":!0}),v(ze)!=="svelte-9mxlq9"&&(ze.innerHTML=nn),Do=s(H),p(W.$$.fragment,H),H.forEach(n),ro=s(e),p(he.$$.fragment,e),ao=s(e),x=l(e,"DIV",{class:!0});var F=z(x);p(fe.$$.fragment,F),jo=s(F),Je=l(F,"P",{"data-svelte-h":!0}),v(Je)!=="svelte-7hyzcp"&&(Je.textContent=tn),Go=s(F),Ue=l(F,"P",{"data-svelte-h":!0}),v(Ue)!=="svelte-6s86kk"&&(Ue.innerHTML=sn),ko=s(F),Fe=l(F,"P",{"data-svelte-h":!0}),v(Fe)!=="svelte-hswkmf"&&(Fe.innerHTML=rn),Co=s(F),I=l(F,"DIV",{class:!0});var A=z(I);p(_e.$$.fragment,A),Io=s(A),Pe=l(A,"P",{"data-svelte-h":!0}),v(Pe)!=="svelte-zan1z1"&&(Pe.innerHTML=an),$o=s(A),p(B.$$.fragment,A),zo=s(A),p(L.$$.fragment,A),A.forEach(n),F.forEach(n),io=s(e),p(be.$$.fragment,e),co=s(e),M=l(e,"DIV",{class:!0});var P=z(M);p(ve.$$.fragment,P),Jo=s(P),Ne=l(P,"P",{"data-svelte-h":!0}),v(Ne)!=="svelte-hgz8xq"&&(Ne.textContent=dn),Uo=s(P),Ze=l(P,"P",{"data-svelte-h":!0}),v(Ze)!=="svelte-6s86kk"&&(Ze.innerHTML=cn),Fo=s(P),Re=l(P,"P",{"data-svelte-h":!0}),v(Re)!=="svelte-hswkmf"&&(Re.innerHTML=ln),Po=s(P),$=l(P,"DIV",{class:!0});var S=z($);p(ye.$$.fragment,S),No=s(S),qe=l(S,"P",{"data-svelte-h":!0}),v(qe)!=="svelte-1v3lkxp"&&(qe.innerHTML=mn),Zo=s(S),p(V.$$.fragment,S),Ro=s(S),p(O.$$.fragment,S),S.forEach(n),P.forEach(n),lo=s(e),p(Te.$$.fragment,e),mo=s(e),Ee=l(e,"P",{}),z(Ee).forEach(n),this.h()},h(){D(r,"name","hf:doc:metadata"),D(r,"content",jn),pn(Z.src,Lo="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/grouding_dino_architecture.png")||D(Z,"src",Lo),D(Z,"alt","drawing"),D(Z,"width","600"),D(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){i(document.head,r),d(e,T,o),d(e,m,o),d(e,g,o),h(y,e,o),d(e,a,o),h(w,e,o),d(e,Be,o),d(e,Q,o),d(e,Le,o),d(e,Y,o),d(e,Ve,o),d(e,K,o),d(e,Oe,o),d(e,Z,o),d(e,He,o),d(e,ee,o),d(e,Ae,o),d(e,oe,o),d(e,Se,o),h(ne,e,o),d(e,Xe,o),d(e,te,o),d(e,Qe,o),d(e,se,o),d(e,Ye,o),h(re,e,o),d(e,Ke,o),h(ae,e,o),d(e,eo,o),d(e,j,o),h(ie,j,null),i(j,po),i(j,De),i(j,ho),i(j,R),h(de,R,null),i(R,fo),i(R,je),i(j,_o),i(j,q),h(ce,q,null),i(q,bo),i(q,Ge),d(e,oo,o),h(le,e,o),d(e,no,o),d(e,G,o),h(me,G,null),i(G,vo),i(G,ke),i(G,yo),i(G,Ce),i(G,To),i(G,E),h(ge,E,null),i(E,wo),i(E,Ie),d(e,to,o),h(ue,e,o),d(e,so,o),d(e,k,o),h(pe,k,null),i(k,xo),i(k,$e),i(k,Mo),i(k,ze),i(k,Do),h(W,k,null),d(e,ro,o),h(he,e,o),d(e,ao,o),d(e,x,o),h(fe,x,null),i(x,jo),i(x,Je),i(x,Go),i(x,Ue),i(x,ko),i(x,Fe),i(x,Co),i(x,I),h(_e,I,null),i(I,Io),i(I,Pe),i(I,$o),h(B,I,null),i(I,zo),h(L,I,null),d(e,io,o),h(be,e,o),d(e,co,o),d(e,M,o),h(ve,M,null),i(M,Jo),i(M,Ne),i(M,Uo),i(M,Ze),i(M,Fo),i(M,Re),i(M,Po),i(M,$),h(ye,$,null),i($,No),i($,qe),i($,Zo),h(V,$,null),i($,Ro),h(O,$,null),d(e,lo,o),h(Te,e,o),d(e,mo,o),d(e,Ee,o),go=!0},p(e,[o]){const J={};o&2&&(J.$$scope={dirty:o,ctx:e}),W.$set(J);const we={};o&2&&(we.$$scope={dirty:o,ctx:e}),B.$set(we);const xe={};o&2&&(xe.$$scope={dirty:o,ctx:e}),L.$set(xe);const U={};o&2&&(U.$$scope={dirty:o,ctx:e}),V.$set(U);const Me={};o&2&&(Me.$$scope={dirty:o,ctx:e}),O.$set(Me)},i(e){go||(f(y.$$.fragment,e),f(w.$$.fragment,e),f(ne.$$.fragment,e),f(re.$$.fragment,e),f(ae.$$.fragment,e),f(ie.$$.fragment,e),f(de.$$.fragment,e),f(ce.$$.fragment,e),f(le.$$.fragment,e),f(me.$$.fragment,e),f(ge.$$.fragment,e),f(ue.$$.fragment,e),f(pe.$$.fragment,e),f(W.$$.fragment,e),f(he.$$.fragment,e),f(fe.$$.fragment,e),f(_e.$$.fragment,e),f(B.$$.fragment,e),f(L.$$.fragment,e),f(be.$$.fragment,e),f(ve.$$.fragment,e),f(ye.$$.fragment,e),f(V.$$.fragment,e),f(O.$$.fragment,e),f(Te.$$.fragment,e),go=!0)},o(e){_(y.$$.fragment,e),_(w.$$.fragment,e),_(ne.$$.fragment,e),_(re.$$.fragment,e),_(ae.$$.fragment,e),_(ie.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(le.$$.fragment,e),_(me.$$.fragment,e),_(ge.$$.fragment,e),_(ue.$$.fragment,e),_(pe.$$.fragment,e),_(W.$$.fragment,e),_(he.$$.fragment,e),_(fe.$$.fragment,e),_(_e.$$.fragment,e),_(B.$$.fragment,e),_(L.$$.fragment,e),_(be.$$.fragment,e),_(ve.$$.fragment,e),_(ye.$$.fragment,e),_(V.$$.fragment,e),_(O.$$.fragment,e),_(Te.$$.fragment,e),go=!1},d(e){e&&(n(T),n(m),n(g),n(a),n(Be),n(Q),n(Le),n(Y),n(Ve),n(K),n(Oe),n(Z),n(He),n(ee),n(Ae),n(oe),n(Se),n(Xe),n(te),n(Qe),n(se),n(Ye),n(Ke),n(eo),n(j),n(oo),n(no),n(G),n(to),n(so),n(k),n(ro),n(ao),n(x),n(io),n(co),n(M),n(lo),n(mo),n(Ee)),n(r),b(y,e),b(w,e),b(ne,e),b(re,e),b(ae,e),b(ie),b(de),b(ce),b(le,e),b(me),b(ge),b(ue,e),b(pe),b(W),b(he,e),b(fe),b(_e),b(B),b(L),b(be,e),b(ve),b(ye),b(V),b(O),b(Te,e)}}}const jn='{"title":"Grounding DINO","local":"grounding-dino","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"GroundingDinoImageProcessor","local":"transformers.GroundingDinoImageProcessor","sections":[],"depth":2},{"title":"GroundingDinoProcessor","local":"transformers.GroundingDinoProcessor","sections":[],"depth":2},{"title":"GroundingDinoConfig","local":"transformers.GroundingDinoConfig","sections":[],"depth":2},{"title":"GroundingDinoModel","local":"transformers.GroundingDinoModel","sections":[],"depth":2},{"title":"GroundingDinoForObjectDetection","local":"transformers.GroundingDinoForObjectDetection","sections":[],"depth":2}],"depth":1}';function Gn(C){return hn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fn extends fn{constructor(r){super(),_n(this,r,Gn,Dn,un,{})}}export{Fn as component};
