import{S as Wn,i as Xn,s as Vn,e as r,k as m,w as M,t as a,M as Gn,c as i,d as s,m as c,a as n,x as y,h as l,b as p,G as o,g as d,y as J,q as w,o as v,B as b,v as Yn}from"../chunks/vendor-hf-doc-builder.js";import{T as li}from"../chunks/Tip-hf-doc-builder.js";import{I as Uo}from"../chunks/IconCopyLink-hf-doc-builder.js";import{C as U}from"../chunks/CodeBlock-hf-doc-builder.js";function Qn(K){let u,_;return{c(){u=r("p"),_=a("Se o seu modelo for muito semelhante a um modelo dentro da biblioteca, voc\xEA poder\xE1 reutilizar a mesma configura\xE7\xE3o desse modelo.")},l(f){u=i(f,"P",{});var j=n(u);_=l(j,"Se o seu modelo for muito semelhante a um modelo dentro da biblioteca, voc\xEA poder\xE1 reutilizar a mesma configura\xE7\xE3o desse modelo."),j.forEach(s)},m(f,j){d(f,u,j),o(u,_)},d(f){f&&s(u)}}}function Fn(K){let u,_;return{c(){u=r("p"),_=a("Esta API \xE9 experimental e pode ter algumas pequenas altera\xE7\xF5es nas pr\xF3ximas vers\xF5es.")},l(f){u=i(f,"P",{});var j=n(u);_=l(j,"Esta API \xE9 experimental e pode ter algumas pequenas altera\xE7\xF5es nas pr\xF3ximas vers\xF5es."),j.forEach(s)},m(f,j){d(f,u,j),o(u,_)},d(f){f&&s(u)}}}function Dn(K){let u,_,f,j,F;return{c(){u=r("p"),_=a(`Se estiver copiando arquivos de modelagem da biblioteca, voc\xEA precisar\xE1 substituir todas as importa\xE7\xF5es relativas na parte superior do arquivo
para importar do pacote `),f=r("code"),j=a("transformers"),F=a(".")},l(I){u=i(I,"P",{});var $=n(u);_=l($,`Se estiver copiando arquivos de modelagem da biblioteca, voc\xEA precisar\xE1 substituir todas as importa\xE7\xF5es relativas na parte superior do arquivo
para importar do pacote `),f=i($,"CODE",{});var ee=n(f);j=l(ee,"transformers"),ee.forEach(s),F=l($,"."),$.forEach(s)},m(I,$){d(I,u,$),o(u,_),o(u,f),o(f,j),o(u,F)},d(I){I&&s(u)}}}function Sn(K){let u,_,f,j,F,I,$,ee,sl,$s,Se,al,Ns,He,ll,ks,N,tl,be,rl,il,_o,nl,dl,Rs,D,oe,Co,je,ml,ho,cl,zs,se,pl,Io,ul,fl,Bs,xe,Ml,Ws,Te,Xs,Pe,yl,Vs,k,Ue,Jl,Eo,wl,vl,bl,S,jl,go,Tl,Ul,Zo,_l,Cl,hl,H,Il,Ao,El,gl,qo,Zl,Al,Gs,R,ql,$o,$l,Nl,No,kl,Rl,Ys,z,zl,ko,Bl,Wl,Ro,Xl,Vl,Qs,Oe,Gl,Fs,_e,Ds,E,Yl,zo,Ql,Fl,Bo,Dl,Sl,Wo,Hl,xl,Ss,Ce,Hs,B,Pl,Xo,Ol,Ll,Vo,Kl,et,xs,x,ae,Go,he,ot,Yo,st,Ps,W,at,Qo,lt,tt,Fo,rt,it,Os,le,nt,Do,dt,mt,Ls,Ie,Ks,Le,ct,ea,Ee,oa,h,pt,So,ut,ft,Ho,Mt,yt,xo,Jt,wt,Po,vt,bt,sa,te,aa,X,jt,Oo,Tt,Ut,Lo,_t,Ct,la,Ke,ht,ta,ge,ra,g,It,Ko,Et,gt,es,Zt,At,os,qt,$t,ia,eo,Nt,na,Ze,da,V,kt,ss,Rt,zt,as,Bt,Wt,ma,P,re,ls,Ae,Xt,ts,Vt,ca,ie,pa,T,Gt,rs,Yt,Qt,is,Ft,Dt,ns,St,Ht,ds,xt,Pt,ms,Ot,Lt,cs,Kt,er,ps,or,sr,ua,qe,fa,G,ar,us,lr,tr,fs,rr,ir,Ma,ne,ya,oo,nr,Ja,so,dr,wa,$e,va,de,mr,Ms,cr,pr,ba,Ne,ja,me,ur,ys,fr,Mr,Ta,ao,yr,Ua,ke,_a,lo,Jr,Ca,Re,ha,to,wr,Ia,ze,Ea,ro,vr,ga,Be,Za,Z,br,Js,jr,Tr,ws,Ur,_r,We,Cr,hr,Aa,ce,Ir,io,Er,gr,qa,O,pe,vs,Xe,Zr,bs,Ar,$a,A,qr,js,$r,Nr,Ve,kr,Rr,Ts,zr,Br,Na,Ge,ka,ue,Wr,Us,Xr,Vr,Ra,Ye,za,no,Gr,Ba,L,fe,_s,Qe,Yr,Cs,Qr,Wa,mo,Fr,Xa,Y,Dr,hs,Sr,Hr,Is,xr,Pr,Va,Fe,Ga,q,Or,Es,Lr,Kr,gs,ei,oi,Zs,si,ai,Ya;return I=new Uo({}),je=new Uo({}),Te=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`}}),_e=new U({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`}}),Ce=new U({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)'}}),he=new Uo({}),Ie=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`}}),Ee=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`}}),te=new li({props:{$$slots:{default:[Qn]},$$scope:{ctx:K}}}),ge=new U({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)"}}),Ze=new U({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`}}),Ae=new Uo({}),ie=new li({props:{warning:!0,$$slots:{default:[Fn]},$$scope:{ctx:K}}}),qe=new U({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
\u2514\u2500\u2500 resnet_model
    \u251C\u2500\u2500 __init__.<span class="hljs-keyword">py</span>
    \u251C\u2500\u2500 configuration_resnet.<span class="hljs-keyword">py</span>
    \u2514\u2500\u2500 modeling_resnet.<span class="hljs-keyword">py</span>`}}),ne=new li({props:{warning:!0,$$slots:{default:[Dn]},$$scope:{ctx:K}}}),$e=new U({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`}}),Ne=new U({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`}}),ke=new U({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`}}),Re=new U({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login"}}),ze=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`}}),Be=new U({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)'}}),Xe=new Uo({}),Ge=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`}}),Ye=new U({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`}}),Qe=new Uo({}),Fe=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`}}),{c(){u=r("meta"),_=m(),f=r("h1"),j=r("a"),F=r("span"),M(I.$$.fragment),$=m(),ee=r("span"),sl=a("Compartilhando modelos customizados"),$s=m(),Se=r("p"),al=a(`A biblioteca \u{1F917} Transformers foi projetada para ser facilmente extens\xEDvel. Cada modelo \xE9 totalmente codificado em uma determinada subpasta
do reposit\xF3rio sem abstra\xE7\xE3o, para que voc\xEA possa copiar facilmente um arquivo de modelagem e ajust\xE1-lo \xE0s suas necessidades.`),Ns=m(),He=r("p"),ll=a(`Se voc\xEA estiver escrevendo um modelo totalmente novo, pode ser mais f\xE1cil come\xE7ar do zero. Neste tutorial, mostraremos
como escrever um modelo customizado e sua configura\xE7\xE3o para que possa ser usado com Transformers, e como voc\xEA pode compartilh\xE1-lo
com a comunidade (com o c\xF3digo em que se baseia) para que qualquer pessoa possa us\xE1-lo, mesmo se n\xE3o estiver presente na biblioteca \u{1F917} Transformers.`),ks=m(),N=r("p"),tl=a(`Ilustraremos tudo isso em um modelo ResNet, envolvendo a classe ResNet do
`),be=r("a"),rl=a("biblioteca timm"),il=a(" em um "),_o=r("code"),nl=a("PreTrainedModel"),dl=a("."),Rs=m(),D=r("h2"),oe=r("a"),Co=r("span"),M(je.$$.fragment),ml=m(),ho=r("span"),cl=a("Escrevendo uma configura\xE7\xE3o customizada"),zs=m(),se=r("p"),pl=a(`Antes de mergulharmos no modelo, vamos primeiro escrever sua configura\xE7\xE3o. A configura\xE7\xE3o de um modelo \xE9 um objeto que
ter\xE1 todas as informa\xE7\xF5es necess\xE1rias para construir o modelo. Como veremos na pr\xF3xima se\xE7\xE3o, o modelo s\xF3 pode
ter um `),Io=r("code"),ul=a("config"),fl=a(" para ser inicializado, ent\xE3o realmente precisamos que esse objeto seja o mais completo poss\xEDvel."),Bs=m(),xe=r("p"),Ml=a(`Em nosso exemplo, pegaremos alguns argumentos da classe ResNet que podemos querer ajustar. Diferentes
configura\xE7\xF5es nos dar\xE1 os diferentes tipos de ResNets que s\xE3o poss\xEDveis. Em seguida, apenas armazenamos esses argumentos,
ap\xF3s verificar a validade de alguns deles.`),Ws=m(),M(Te.$$.fragment),Xs=m(),Pe=r("p"),yl=a("As tr\xEAs coisas importantes a serem lembradas ao escrever sua pr\xF3pria configura\xE7\xE3o s\xE3o:"),Vs=m(),k=r("ul"),Ue=r("li"),Jl=a("voc\xEA tem que herdar de "),Eo=r("code"),wl=a("PretrainedConfig"),vl=a(","),bl=m(),S=r("li"),jl=a("o "),go=r("code"),Tl=a("__init__"),Ul=a(" do seu "),Zo=r("code"),_l=a("PretrainedConfig"),Cl=a(" deve aceitar quaisquer kwargs,"),hl=m(),H=r("li"),Il=a("esses "),Ao=r("code"),El=a("kwargs"),gl=a(" precisam ser passados para a superclasse "),qo=r("code"),Zl=a("__init__"),Al=a("."),Gs=m(),R=r("p"),ql=a(`A heran\xE7a \xE9 para garantir que voc\xEA obtenha todas as funcionalidades da biblioteca \u{1F917} Transformers, enquanto as outras duas
restri\xE7\xF5es v\xEAm do fato de um `),$o=r("code"),$l=a("PretrainedConfig"),Nl=a(` ter mais campos do que os que voc\xEA est\xE1 configurando. Ao recarregar um
config com o m\xE9todo `),No=r("code"),kl=a("from_pretrained"),Rl=a(`, esses campos precisam ser aceitos pelo seu config e ent\xE3o enviados para a
superclasse.`),Ys=m(),z=r("p"),zl=a("Definir um "),ko=r("code"),Bl=a("model_type"),Wl=a(" para sua configura\xE7\xE3o (aqui "),Ro=r("code"),Xl=a('model_type="resnet"'),Vl=a(`) n\xE3o \xE9 obrigat\xF3rio, a menos que voc\xEA queira
registrar seu modelo com as classes autom\xE1ticas (veja a \xFAltima se\xE7\xE3o).`),Qs=m(),Oe=r("p"),Gl=a(`Com isso feito, voc\xEA pode facilmente criar e salvar sua configura\xE7\xE3o como faria com qualquer outra configura\xE7\xE3o de modelo da
biblioteca. Aqui est\xE1 como podemos criar uma configura\xE7\xE3o resnet50d e salv\xE1-la:`),Fs=m(),M(_e.$$.fragment),Ds=m(),E=r("p"),Yl=a("Isso salvar\xE1 um arquivo chamado "),zo=r("code"),Ql=a("config.json"),Fl=a(" dentro da pasta "),Bo=r("code"),Dl=a("custom-resnet"),Sl=a(`. Voc\xEA pode ent\xE3o recarregar sua configura\xE7\xE3o com o
m\xE9todo `),Wo=r("code"),Hl=a("from_pretrained"),xl=a(":"),Ss=m(),M(Ce.$$.fragment),Hs=m(),B=r("p"),Pl=a("Voc\xEA tamb\xE9m pode usar qualquer outro m\xE9todo da classe "),Xo=r("code"),Ol=a("PretrainedConfig"),Ll=a(", como "),Vo=r("code"),Kl=a("push_to_hub()"),et=a(` para
carregar diretamente sua configura\xE7\xE3o para o Hub.`),xs=m(),x=r("h2"),ae=r("a"),Go=r("span"),M(he.$$.fragment),ot=m(),Yo=r("span"),st=a("Escrevendo um modelo customizado"),Ps=m(),W=r("p"),at=a(`Agora que temos nossa configura\xE7\xE3o ResNet, podemos continuar escrevendo o modelo. Na verdade, escreveremos dois: um que
extrai os recursos ocultos de um lote de imagens (como `),Qo=r("code"),lt=a("BertModel"),tt=a(`) e um que \xE9 adequado para classifica\xE7\xE3o de imagem
(como `),Fo=r("code"),rt=a("BertForSequenceClassification"),it=a(")."),Os=m(),le=r("p"),nt=a(`Como mencionamos antes, escreveremos apenas um wrapper solto do modelo para mant\xEA-lo simples para este exemplo. A \xFAnica
coisa que precisamos fazer antes de escrever esta classe \xE9 um mapa entre os tipos de bloco e as classes de bloco reais. Ent\xE3o o
modelo \xE9 definido a partir da configura\xE7\xE3o passando tudo para a classe `),Do=r("code"),dt=a("ResNet"),mt=a(":"),Ls=m(),M(Ie.$$.fragment),Ks=m(),Le=r("p"),ct=a("Para o modelo que ir\xE1 classificar as imagens, vamos apenas alterar o m\xE9todo forward:"),ea=m(),M(Ee.$$.fragment),oa=m(),h=r("p"),pt=a("Em ambos os casos, observe como herdamos de "),So=r("code"),ut=a("PreTrainedModel"),ft=a(" e chamamos a inicializa\xE7\xE3o da superclasse com o "),Ho=r("code"),Mt=a("config"),yt=a(`
(um pouco parecido quando voc\xEA escreve um `),xo=r("code"),Jt=a("torch.nn.Module"),wt=a("). A linha que define o "),Po=r("code"),vt=a("config_class"),bt=a(` n\xE3o \xE9 obrigat\xF3ria, a menos que
voc\xEA deseje registrar seu modelo com as classes autom\xE1ticas (consulte a \xFAltima se\xE7\xE3o).`),sa=m(),M(te.$$.fragment),aa=m(),X=r("p"),jt=a(`Voc\xEA pode fazer com que seu modelo retorne o que voc\xEA quiser,por\xE9m retornando um dicion\xE1rio como fizemos para
`),Oo=r("code"),Tt=a("ResnetModelForImageClassification"),Ut=a(`, com a fun\xE7\xE3o de perda inclu\xEDda quando os r\xF3tulos s\xE3o passados, vai tornar seu modelo diretamente
utiliz\xE1vel dentro da classe `),Lo=r("code"),_t=a("Trainer"),Ct=a(`. Voc\xEA pode usar outro formato de sa\xEDda, desde que esteja planejando usar seu pr\xF3prio
la\xE7o de treinamento ou outra biblioteca para treinamento.`),la=m(),Ke=r("p"),ht=a("Agora que temos nossa classe do modelo, vamos criar uma:"),ta=m(),M(ge.$$.fragment),ra=m(),g=r("p"),It=a("Novamente, voc\xEA pode usar qualquer um dos m\xE9todos do "),Ko=r("code"),Et=a("PreTrainedModel"),gt=a(", como "),es=r("code"),Zt=a("save_pretrained()"),At=a(` ou
`),os=r("code"),qt=a("push_to_hub()"),$t=a(`. Usaremos o segundo na pr\xF3xima se\xE7\xE3o e veremos como enviar os pesos e
o c\xF3digo do nosso modelo. Mas primeiro, vamos carregar alguns pesos pr\xE9-treinados dentro do nosso modelo.`),ia=m(),eo=r("p"),Nt=a(`Em seu pr\xF3prio caso de uso, voc\xEA provavelmente estar\xE1 treinando seu modelo customizado em seus pr\xF3prios dados. Para este tutorial ser r\xE1pido,
usaremos a vers\xE3o pr\xE9-treinada do resnet50d. Como nosso modelo \xE9 apenas um wrapper em torno dele, ser\xE1
f\xE1cil de transferir esses pesos:`),na=m(),M(Ze.$$.fragment),da=m(),V=r("p"),kt=a("Agora vamos ver como ter certeza de que quando fazemos "),ss=r("code"),Rt=a("save_pretrained()"),zt=a(" ou "),as=r("code"),Bt=a("push_to_hub()"),Wt=a(`, o
c\xF3digo do modelo \xE9 salvo.`),ma=m(),P=r("h2"),re=r("a"),ls=r("span"),M(Ae.$$.fragment),Xt=m(),ts=r("span"),Vt=a("Enviando o c\xF3digo para o Hub"),ca=m(),M(ie.$$.fragment),pa=m(),T=r("p"),Gt=a("Primeiro, certifique-se de que seu modelo esteja totalmente definido em um arquivo "),rs=r("code"),Yt=a(".py"),Qt=a(`. Ele pode contar com importa\xE7\xF5es relativas para alguns outros arquivos
desde que todos os arquivos estejam no mesmo diret\xF3rio (ainda n\xE3o suportamos subm\xF3dulos para este recurso). Para o nosso exemplo,
vamos definir um arquivo `),is=r("code"),Ft=a("modeling_resnet.py"),Dt=a(" e um arquivo "),ns=r("code"),St=a("configuration_resnet.py"),Ht=a(` em uma pasta no
diret\xF3rio de trabalho atual chamado `),ds=r("code"),xt=a("resnet_model"),Pt=a(". O arquivo de configura\xE7\xE3o cont\xE9m o c\xF3digo para "),ms=r("code"),Ot=a("ResnetConfig"),Lt=a(` e o arquivo de modelagem
cont\xE9m o c\xF3digo do `),cs=r("code"),Kt=a("ResnetModel"),er=a(" e "),ps=r("code"),or=a("ResnetModelForImageClassification"),sr=a("."),ua=m(),M(qe.$$.fragment),fa=m(),G=r("p"),ar=a("O "),us=r("code"),lr=a("__init__.py"),tr=a(" pode estar vazio, apenas est\xE1 l\xE1 para que o Python detecte que o "),fs=r("code"),rr=a("resnet_model"),ir=a(" possa ser usado como um m\xF3dulo."),Ma=m(),M(ne.$$.fragment),ya=m(),oo=r("p"),nr=a("Observe que voc\xEA pode reutilizar (ou subclasse) uma configura\xE7\xE3o/modelo existente."),Ja=m(),so=r("p"),dr=a(`Para compartilhar seu modelo com a comunidade, siga estas etapas: primeiro importe o modelo ResNet e a configura\xE7\xE3o do
arquivos criados:`),wa=m(),M($e.$$.fragment),va=m(),de=r("p"),mr=a("Ent\xE3o voc\xEA tem que dizer \xE0 biblioteca que deseja copiar os arquivos de c\xF3digo desses objetos ao usar o "),Ms=r("code"),cr=a("save_pretrained"),pr=a(`
e registr\xE1-los corretamente com uma determinada classe autom\xE1ticas (especialmente para modelos), basta executar:`),ba=m(),M(Ne.$$.fragment),ja=m(),me=r("p"),ur=a(`Observe que n\xE3o h\xE1 necessidade de especificar uma classe autom\xE1tica para a configura\xE7\xE3o (h\xE1 apenas uma classe autom\xE1tica,
`),ys=r("code"),fr=a("AutoConfig"),Mr=a(`), mas \xE9 diferente para os modelos. Seu modelo customizado pode ser adequado para muitas tarefas diferentes, ent\xE3o voc\xEA
tem que especificar qual das classes autom\xE1ticas \xE9 a correta para o seu modelo.`),Ta=m(),ao=r("p"),yr=a("Em seguida, vamos criar a configura\xE7\xE3o e os modelos como fizemos antes:"),Ua=m(),M(ke.$$.fragment),_a=m(),lo=r("p"),Jr=a("Agora para enviar o modelo para o Hub, certifique-se de estar logado. Ou execute no seu terminal:"),Ca=m(),M(Re.$$.fragment),ha=m(),to=r("p"),wr=a("ou a partir do notebook:"),Ia=m(),M(ze.$$.fragment),Ea=m(),ro=r("p"),vr=a("Voc\xEA pode ent\xE3o enviar para seu pr\xF3prio namespace (ou uma organiza\xE7\xE3o da qual voc\xEA \xE9 membro) assim:"),ga=m(),M(Be.$$.fragment),Za=m(),Z=r("p"),br=a(`Al\xE9m dos pesos do modelo e da configura\xE7\xE3o no formato json, isso tamb\xE9m copiou o modelo e
configura\xE7\xE3o `),Js=r("code"),jr=a(".py"),Tr=a(" na pasta "),ws=r("code"),Ur=a("custom-resnet50d"),_r=a(` e carregou o resultado para o Hub. Voc\xEA pode conferir o resultado
neste `),We=r("a"),Cr=a("reposit\xF3rio de modelos"),hr=a("."),Aa=m(),ce=r("p"),Ir=a("Consulte o "),io=r("a"),Er=a("tutorial de compartilhamento"),gr=a(" para obter mais informa\xE7\xF5es sobre o m\xE9todo push_to_hub."),qa=m(),O=r("h2"),pe=r("a"),vs=r("span"),M(Xe.$$.fragment),Zr=m(),bs=r("span"),Ar=a("Usando um modelo com c\xF3digo customizado"),$a=m(),A=r("p"),qr=a(`Voc\xEA pode usar qualquer configura\xE7\xE3o, modelo ou tokenizador com arquivos de c\xF3digo customizados em seu reposit\xF3rio com as classes autom\xE1ticas e
o m\xE9todo `),js=r("code"),$r=a("from_pretrained"),Nr=a(". Todos os arquivos e c\xF3digos carregados no Hub s\xE3o verificados quanto a malware (consulte a documenta\xE7\xE3o de "),Ve=r("a"),kr=a("Seguran\xE7a do Hub"),Rr=a(` para obter mais informa\xE7\xF5es), mas voc\xEA ainda deve
revisar o c\xF3digo do modelo e o autor para evitar a execu\xE7\xE3o de c\xF3digo malicioso em sua m\xE1quina. Defina `),Ts=r("code"),zr=a("trust_remote_code=True"),Br=a(` para usar
um modelo com c\xF3digo customizado:`),Na=m(),M(Ge.$$.fragment),ka=m(),ue=r("p"),Wr=a("Tamb\xE9m \xE9 fortemente recomendado passar um hash de confirma\xE7\xE3o como uma "),Us=r("code"),Xr=a("revis\xE3o"),Vr=a(` para garantir que o autor dos modelos n\xE3o
atualize o c\xF3digo com novas linhas maliciosas (a menos que voc\xEA confie totalmente nos autores dos modelos).`),Ra=m(),M(Ye.$$.fragment),za=m(),no=r("p"),Gr=a(`Observe que ao navegar no hist\xF3rico de commits do reposit\xF3rio do modelo no Hub, h\xE1 um bot\xE3o para copiar facilmente o commit
hash de qualquer commit.`),Ba=m(),L=r("h2"),fe=r("a"),_s=r("span"),M(Qe.$$.fragment),Yr=m(),Cs=r("span"),Qr=a("Registrando um modelo com c\xF3digo customizado para as classes autom\xE1ticas"),Wa=m(),mo=r("p"),Fr=a(`Se voc\xEA estiver escrevendo uma biblioteca que estende \u{1F917} Transformers, talvez queira estender as classes autom\xE1ticas para incluir seus pr\xF3prios
modelos. Isso \xE9 diferente de enviar o c\xF3digo para o Hub no sentido de que os usu\xE1rios precisar\xE3o importar sua biblioteca para
obter os modelos customizados (ao contr\xE1rio de baixar automaticamente o c\xF3digo do modelo do Hub).`),Xa=m(),Y=r("p"),Dr=a("Desde que sua configura\xE7\xE3o tenha um atributo "),hs=r("code"),Sr=a("model_type"),Hr=a(` diferente dos tipos de modelo existentes e que as classes do seu modelo
tenha os atributos `),Is=r("code"),xr=a("config_class"),Pr=a(" corretos, voc\xEA pode simplesmente adicion\xE1-los \xE0s classes autom\xE1ticas assim:"),Va=m(),M(Fe.$$.fragment),Ga=m(),q=r("p"),Or=a("Observe que o primeiro argumento usado ao registrar sua configura\xE7\xE3o customizada para "),Es=r("code"),Lr=a("AutoConfig"),Kr=a(" precisa corresponder ao "),gs=r("code"),ei=a("model_type"),oi=a(`
de sua configura\xE7\xE3o customizada. E o primeiro argumento usado ao registrar seus modelos customizados, para qualquer necessidade de classe de modelo autom\xE1tico
deve corresponder ao `),Zs=r("code"),si=a("config_class"),ai=a(" desses modelos."),this.h()},l(e){const t=Gn('[data-svelte="svelte-1phssyn"]',document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(s),_=c(e),f=i(e,"H1",{class:!0});var De=n(f);j=i(De,"A",{id:!0,class:!0,href:!0});var As=n(j);F=i(As,"SPAN",{});var qs=n(F);y(I.$$.fragment,qs),qs.forEach(s),As.forEach(s),$=c(De),ee=i(De,"SPAN",{});var ti=n(ee);sl=l(ti,"Compartilhando modelos customizados"),ti.forEach(s),De.forEach(s),$s=c(e),Se=i(e,"P",{});var ri=n(Se);al=l(ri,`A biblioteca \u{1F917} Transformers foi projetada para ser facilmente extens\xEDvel. Cada modelo \xE9 totalmente codificado em uma determinada subpasta
do reposit\xF3rio sem abstra\xE7\xE3o, para que voc\xEA possa copiar facilmente um arquivo de modelagem e ajust\xE1-lo \xE0s suas necessidades.`),ri.forEach(s),Ns=c(e),He=i(e,"P",{});var ii=n(He);ll=l(ii,`Se voc\xEA estiver escrevendo um modelo totalmente novo, pode ser mais f\xE1cil come\xE7ar do zero. Neste tutorial, mostraremos
como escrever um modelo customizado e sua configura\xE7\xE3o para que possa ser usado com Transformers, e como voc\xEA pode compartilh\xE1-lo
com a comunidade (com o c\xF3digo em que se baseia) para que qualquer pessoa possa us\xE1-lo, mesmo se n\xE3o estiver presente na biblioteca \u{1F917} Transformers.`),ii.forEach(s),ks=c(e),N=i(e,"P",{});var co=n(N);tl=l(co,`Ilustraremos tudo isso em um modelo ResNet, envolvendo a classe ResNet do
`),be=i(co,"A",{href:!0,rel:!0});var ni=n(be);rl=l(ni,"biblioteca timm"),ni.forEach(s),il=l(co," em um "),_o=i(co,"CODE",{});var di=n(_o);nl=l(di,"PreTrainedModel"),di.forEach(s),dl=l(co,"."),co.forEach(s),Rs=c(e),D=i(e,"H2",{class:!0});var Qa=n(D);oe=i(Qa,"A",{id:!0,class:!0,href:!0});var mi=n(oe);Co=i(mi,"SPAN",{});var ci=n(Co);y(je.$$.fragment,ci),ci.forEach(s),mi.forEach(s),ml=c(Qa),ho=i(Qa,"SPAN",{});var pi=n(ho);cl=l(pi,"Escrevendo uma configura\xE7\xE3o customizada"),pi.forEach(s),Qa.forEach(s),zs=c(e),se=i(e,"P",{});var Fa=n(se);pl=l(Fa,`Antes de mergulharmos no modelo, vamos primeiro escrever sua configura\xE7\xE3o. A configura\xE7\xE3o de um modelo \xE9 um objeto que
ter\xE1 todas as informa\xE7\xF5es necess\xE1rias para construir o modelo. Como veremos na pr\xF3xima se\xE7\xE3o, o modelo s\xF3 pode
ter um `),Io=i(Fa,"CODE",{});var ui=n(Io);ul=l(ui,"config"),ui.forEach(s),fl=l(Fa," para ser inicializado, ent\xE3o realmente precisamos que esse objeto seja o mais completo poss\xEDvel."),Fa.forEach(s),Bs=c(e),xe=i(e,"P",{});var fi=n(xe);Ml=l(fi,`Em nosso exemplo, pegaremos alguns argumentos da classe ResNet que podemos querer ajustar. Diferentes
configura\xE7\xF5es nos dar\xE1 os diferentes tipos de ResNets que s\xE3o poss\xEDveis. Em seguida, apenas armazenamos esses argumentos,
ap\xF3s verificar a validade de alguns deles.`),fi.forEach(s),Ws=c(e),y(Te.$$.fragment,e),Xs=c(e),Pe=i(e,"P",{});var Mi=n(Pe);yl=l(Mi,"As tr\xEAs coisas importantes a serem lembradas ao escrever sua pr\xF3pria configura\xE7\xE3o s\xE3o:"),Mi.forEach(s),Vs=c(e),k=i(e,"UL",{});var po=n(k);Ue=i(po,"LI",{});var Da=n(Ue);Jl=l(Da,"voc\xEA tem que herdar de "),Eo=i(Da,"CODE",{});var yi=n(Eo);wl=l(yi,"PretrainedConfig"),yi.forEach(s),vl=l(Da,","),Da.forEach(s),bl=c(po),S=i(po,"LI",{});var uo=n(S);jl=l(uo,"o "),go=i(uo,"CODE",{});var Ji=n(go);Tl=l(Ji,"__init__"),Ji.forEach(s),Ul=l(uo," do seu "),Zo=i(uo,"CODE",{});var wi=n(Zo);_l=l(wi,"PretrainedConfig"),wi.forEach(s),Cl=l(uo," deve aceitar quaisquer kwargs,"),uo.forEach(s),hl=c(po),H=i(po,"LI",{});var fo=n(H);Il=l(fo,"esses "),Ao=i(fo,"CODE",{});var vi=n(Ao);El=l(vi,"kwargs"),vi.forEach(s),gl=l(fo," precisam ser passados para a superclasse "),qo=i(fo,"CODE",{});var bi=n(qo);Zl=l(bi,"__init__"),bi.forEach(s),Al=l(fo,"."),fo.forEach(s),po.forEach(s),Gs=c(e),R=i(e,"P",{});var Mo=n(R);ql=l(Mo,`A heran\xE7a \xE9 para garantir que voc\xEA obtenha todas as funcionalidades da biblioteca \u{1F917} Transformers, enquanto as outras duas
restri\xE7\xF5es v\xEAm do fato de um `),$o=i(Mo,"CODE",{});var ji=n($o);$l=l(ji,"PretrainedConfig"),ji.forEach(s),Nl=l(Mo,` ter mais campos do que os que voc\xEA est\xE1 configurando. Ao recarregar um
config com o m\xE9todo `),No=i(Mo,"CODE",{});var Ti=n(No);kl=l(Ti,"from_pretrained"),Ti.forEach(s),Rl=l(Mo,`, esses campos precisam ser aceitos pelo seu config e ent\xE3o enviados para a
superclasse.`),Mo.forEach(s),Ys=c(e),z=i(e,"P",{});var yo=n(z);zl=l(yo,"Definir um "),ko=i(yo,"CODE",{});var Ui=n(ko);Bl=l(Ui,"model_type"),Ui.forEach(s),Wl=l(yo," para sua configura\xE7\xE3o (aqui "),Ro=i(yo,"CODE",{});var _i=n(Ro);Xl=l(_i,'model_type="resnet"'),_i.forEach(s),Vl=l(yo,`) n\xE3o \xE9 obrigat\xF3rio, a menos que voc\xEA queira
registrar seu modelo com as classes autom\xE1ticas (veja a \xFAltima se\xE7\xE3o).`),yo.forEach(s),Qs=c(e),Oe=i(e,"P",{});var Ci=n(Oe);Gl=l(Ci,`Com isso feito, voc\xEA pode facilmente criar e salvar sua configura\xE7\xE3o como faria com qualquer outra configura\xE7\xE3o de modelo da
biblioteca. Aqui est\xE1 como podemos criar uma configura\xE7\xE3o resnet50d e salv\xE1-la:`),Ci.forEach(s),Fs=c(e),y(_e.$$.fragment,e),Ds=c(e),E=i(e,"P",{});var Me=n(E);Yl=l(Me,"Isso salvar\xE1 um arquivo chamado "),zo=i(Me,"CODE",{});var hi=n(zo);Ql=l(hi,"config.json"),hi.forEach(s),Fl=l(Me," dentro da pasta "),Bo=i(Me,"CODE",{});var Ii=n(Bo);Dl=l(Ii,"custom-resnet"),Ii.forEach(s),Sl=l(Me,`. Voc\xEA pode ent\xE3o recarregar sua configura\xE7\xE3o com o
m\xE9todo `),Wo=i(Me,"CODE",{});var Ei=n(Wo);Hl=l(Ei,"from_pretrained"),Ei.forEach(s),xl=l(Me,":"),Me.forEach(s),Ss=c(e),y(Ce.$$.fragment,e),Hs=c(e),B=i(e,"P",{});var Jo=n(B);Pl=l(Jo,"Voc\xEA tamb\xE9m pode usar qualquer outro m\xE9todo da classe "),Xo=i(Jo,"CODE",{});var gi=n(Xo);Ol=l(gi,"PretrainedConfig"),gi.forEach(s),Ll=l(Jo,", como "),Vo=i(Jo,"CODE",{});var Zi=n(Vo);Kl=l(Zi,"push_to_hub()"),Zi.forEach(s),et=l(Jo,` para
carregar diretamente sua configura\xE7\xE3o para o Hub.`),Jo.forEach(s),xs=c(e),x=i(e,"H2",{class:!0});var Sa=n(x);ae=i(Sa,"A",{id:!0,class:!0,href:!0});var Ai=n(ae);Go=i(Ai,"SPAN",{});var qi=n(Go);y(he.$$.fragment,qi),qi.forEach(s),Ai.forEach(s),ot=c(Sa),Yo=i(Sa,"SPAN",{});var $i=n(Yo);st=l($i,"Escrevendo um modelo customizado"),$i.forEach(s),Sa.forEach(s),Ps=c(e),W=i(e,"P",{});var wo=n(W);at=l(wo,`Agora que temos nossa configura\xE7\xE3o ResNet, podemos continuar escrevendo o modelo. Na verdade, escreveremos dois: um que
extrai os recursos ocultos de um lote de imagens (como `),Qo=i(wo,"CODE",{});var Ni=n(Qo);lt=l(Ni,"BertModel"),Ni.forEach(s),tt=l(wo,`) e um que \xE9 adequado para classifica\xE7\xE3o de imagem
(como `),Fo=i(wo,"CODE",{});var ki=n(Fo);rt=l(ki,"BertForSequenceClassification"),ki.forEach(s),it=l(wo,")."),wo.forEach(s),Os=c(e),le=i(e,"P",{});var Ha=n(le);nt=l(Ha,`Como mencionamos antes, escreveremos apenas um wrapper solto do modelo para mant\xEA-lo simples para este exemplo. A \xFAnica
coisa que precisamos fazer antes de escrever esta classe \xE9 um mapa entre os tipos de bloco e as classes de bloco reais. Ent\xE3o o
modelo \xE9 definido a partir da configura\xE7\xE3o passando tudo para a classe `),Do=i(Ha,"CODE",{});var Ri=n(Do);dt=l(Ri,"ResNet"),Ri.forEach(s),mt=l(Ha,":"),Ha.forEach(s),Ls=c(e),y(Ie.$$.fragment,e),Ks=c(e),Le=i(e,"P",{});var zi=n(Le);ct=l(zi,"Para o modelo que ir\xE1 classificar as imagens, vamos apenas alterar o m\xE9todo forward:"),zi.forEach(s),ea=c(e),y(Ee.$$.fragment,e),oa=c(e),h=i(e,"P",{});var Q=n(h);pt=l(Q,"Em ambos os casos, observe como herdamos de "),So=i(Q,"CODE",{});var Bi=n(So);ut=l(Bi,"PreTrainedModel"),Bi.forEach(s),ft=l(Q," e chamamos a inicializa\xE7\xE3o da superclasse com o "),Ho=i(Q,"CODE",{});var Wi=n(Ho);Mt=l(Wi,"config"),Wi.forEach(s),yt=l(Q,`
(um pouco parecido quando voc\xEA escreve um `),xo=i(Q,"CODE",{});var Xi=n(xo);Jt=l(Xi,"torch.nn.Module"),Xi.forEach(s),wt=l(Q,"). A linha que define o "),Po=i(Q,"CODE",{});var Vi=n(Po);vt=l(Vi,"config_class"),Vi.forEach(s),bt=l(Q,` n\xE3o \xE9 obrigat\xF3ria, a menos que
voc\xEA deseje registrar seu modelo com as classes autom\xE1ticas (consulte a \xFAltima se\xE7\xE3o).`),Q.forEach(s),sa=c(e),y(te.$$.fragment,e),aa=c(e),X=i(e,"P",{});var vo=n(X);jt=l(vo,`Voc\xEA pode fazer com que seu modelo retorne o que voc\xEA quiser,por\xE9m retornando um dicion\xE1rio como fizemos para
`),Oo=i(vo,"CODE",{});var Gi=n(Oo);Tt=l(Gi,"ResnetModelForImageClassification"),Gi.forEach(s),Ut=l(vo,`, com a fun\xE7\xE3o de perda inclu\xEDda quando os r\xF3tulos s\xE3o passados, vai tornar seu modelo diretamente
utiliz\xE1vel dentro da classe `),Lo=i(vo,"CODE",{});var Yi=n(Lo);_t=l(Yi,"Trainer"),Yi.forEach(s),Ct=l(vo,`. Voc\xEA pode usar outro formato de sa\xEDda, desde que esteja planejando usar seu pr\xF3prio
la\xE7o de treinamento ou outra biblioteca para treinamento.`),vo.forEach(s),la=c(e),Ke=i(e,"P",{});var Qi=n(Ke);ht=l(Qi,"Agora que temos nossa classe do modelo, vamos criar uma:"),Qi.forEach(s),ta=c(e),y(ge.$$.fragment,e),ra=c(e),g=i(e,"P",{});var ye=n(g);It=l(ye,"Novamente, voc\xEA pode usar qualquer um dos m\xE9todos do "),Ko=i(ye,"CODE",{});var Fi=n(Ko);Et=l(Fi,"PreTrainedModel"),Fi.forEach(s),gt=l(ye,", como "),es=i(ye,"CODE",{});var Di=n(es);Zt=l(Di,"save_pretrained()"),Di.forEach(s),At=l(ye,` ou
`),os=i(ye,"CODE",{});var Si=n(os);qt=l(Si,"push_to_hub()"),Si.forEach(s),$t=l(ye,`. Usaremos o segundo na pr\xF3xima se\xE7\xE3o e veremos como enviar os pesos e
o c\xF3digo do nosso modelo. Mas primeiro, vamos carregar alguns pesos pr\xE9-treinados dentro do nosso modelo.`),ye.forEach(s),ia=c(e),eo=i(e,"P",{});var Hi=n(eo);Nt=l(Hi,`Em seu pr\xF3prio caso de uso, voc\xEA provavelmente estar\xE1 treinando seu modelo customizado em seus pr\xF3prios dados. Para este tutorial ser r\xE1pido,
usaremos a vers\xE3o pr\xE9-treinada do resnet50d. Como nosso modelo \xE9 apenas um wrapper em torno dele, ser\xE1
f\xE1cil de transferir esses pesos:`),Hi.forEach(s),na=c(e),y(Ze.$$.fragment,e),da=c(e),V=i(e,"P",{});var bo=n(V);kt=l(bo,"Agora vamos ver como ter certeza de que quando fazemos "),ss=i(bo,"CODE",{});var xi=n(ss);Rt=l(xi,"save_pretrained()"),xi.forEach(s),zt=l(bo," ou "),as=i(bo,"CODE",{});var Pi=n(as);Bt=l(Pi,"push_to_hub()"),Pi.forEach(s),Wt=l(bo,`, o
c\xF3digo do modelo \xE9 salvo.`),bo.forEach(s),ma=c(e),P=i(e,"H2",{class:!0});var xa=n(P);re=i(xa,"A",{id:!0,class:!0,href:!0});var Oi=n(re);ls=i(Oi,"SPAN",{});var Li=n(ls);y(Ae.$$.fragment,Li),Li.forEach(s),Oi.forEach(s),Xt=c(xa),ts=i(xa,"SPAN",{});var Ki=n(ts);Vt=l(Ki,"Enviando o c\xF3digo para o Hub"),Ki.forEach(s),xa.forEach(s),ca=c(e),y(ie.$$.fragment,e),pa=c(e),T=i(e,"P",{});var C=n(T);Gt=l(C,"Primeiro, certifique-se de que seu modelo esteja totalmente definido em um arquivo "),rs=i(C,"CODE",{});var en=n(rs);Yt=l(en,".py"),en.forEach(s),Qt=l(C,`. Ele pode contar com importa\xE7\xF5es relativas para alguns outros arquivos
desde que todos os arquivos estejam no mesmo diret\xF3rio (ainda n\xE3o suportamos subm\xF3dulos para este recurso). Para o nosso exemplo,
vamos definir um arquivo `),is=i(C,"CODE",{});var on=n(is);Ft=l(on,"modeling_resnet.py"),on.forEach(s),Dt=l(C," e um arquivo "),ns=i(C,"CODE",{});var sn=n(ns);St=l(sn,"configuration_resnet.py"),sn.forEach(s),Ht=l(C,` em uma pasta no
diret\xF3rio de trabalho atual chamado `),ds=i(C,"CODE",{});var an=n(ds);xt=l(an,"resnet_model"),an.forEach(s),Pt=l(C,". O arquivo de configura\xE7\xE3o cont\xE9m o c\xF3digo para "),ms=i(C,"CODE",{});var ln=n(ms);Ot=l(ln,"ResnetConfig"),ln.forEach(s),Lt=l(C,` e o arquivo de modelagem
cont\xE9m o c\xF3digo do `),cs=i(C,"CODE",{});var tn=n(cs);Kt=l(tn,"ResnetModel"),tn.forEach(s),er=l(C," e "),ps=i(C,"CODE",{});var rn=n(ps);or=l(rn,"ResnetModelForImageClassification"),rn.forEach(s),sr=l(C,"."),C.forEach(s),ua=c(e),y(qe.$$.fragment,e),fa=c(e),G=i(e,"P",{});var jo=n(G);ar=l(jo,"O "),us=i(jo,"CODE",{});var nn=n(us);lr=l(nn,"__init__.py"),nn.forEach(s),tr=l(jo," pode estar vazio, apenas est\xE1 l\xE1 para que o Python detecte que o "),fs=i(jo,"CODE",{});var dn=n(fs);rr=l(dn,"resnet_model"),dn.forEach(s),ir=l(jo," possa ser usado como um m\xF3dulo."),jo.forEach(s),Ma=c(e),y(ne.$$.fragment,e),ya=c(e),oo=i(e,"P",{});var mn=n(oo);nr=l(mn,"Observe que voc\xEA pode reutilizar (ou subclasse) uma configura\xE7\xE3o/modelo existente."),mn.forEach(s),Ja=c(e),so=i(e,"P",{});var cn=n(so);dr=l(cn,`Para compartilhar seu modelo com a comunidade, siga estas etapas: primeiro importe o modelo ResNet e a configura\xE7\xE3o do
arquivos criados:`),cn.forEach(s),wa=c(e),y($e.$$.fragment,e),va=c(e),de=i(e,"P",{});var Pa=n(de);mr=l(Pa,"Ent\xE3o voc\xEA tem que dizer \xE0 biblioteca que deseja copiar os arquivos de c\xF3digo desses objetos ao usar o "),Ms=i(Pa,"CODE",{});var pn=n(Ms);cr=l(pn,"save_pretrained"),pn.forEach(s),pr=l(Pa,`
e registr\xE1-los corretamente com uma determinada classe autom\xE1ticas (especialmente para modelos), basta executar:`),Pa.forEach(s),ba=c(e),y(Ne.$$.fragment,e),ja=c(e),me=i(e,"P",{});var Oa=n(me);ur=l(Oa,`Observe que n\xE3o h\xE1 necessidade de especificar uma classe autom\xE1tica para a configura\xE7\xE3o (h\xE1 apenas uma classe autom\xE1tica,
`),ys=i(Oa,"CODE",{});var un=n(ys);fr=l(un,"AutoConfig"),un.forEach(s),Mr=l(Oa,`), mas \xE9 diferente para os modelos. Seu modelo customizado pode ser adequado para muitas tarefas diferentes, ent\xE3o voc\xEA
tem que especificar qual das classes autom\xE1ticas \xE9 a correta para o seu modelo.`),Oa.forEach(s),Ta=c(e),ao=i(e,"P",{});var fn=n(ao);yr=l(fn,"Em seguida, vamos criar a configura\xE7\xE3o e os modelos como fizemos antes:"),fn.forEach(s),Ua=c(e),y(ke.$$.fragment,e),_a=c(e),lo=i(e,"P",{});var Mn=n(lo);Jr=l(Mn,"Agora para enviar o modelo para o Hub, certifique-se de estar logado. Ou execute no seu terminal:"),Mn.forEach(s),Ca=c(e),y(Re.$$.fragment,e),ha=c(e),to=i(e,"P",{});var yn=n(to);wr=l(yn,"ou a partir do notebook:"),yn.forEach(s),Ia=c(e),y(ze.$$.fragment,e),Ea=c(e),ro=i(e,"P",{});var Jn=n(ro);vr=l(Jn,"Voc\xEA pode ent\xE3o enviar para seu pr\xF3prio namespace (ou uma organiza\xE7\xE3o da qual voc\xEA \xE9 membro) assim:"),Jn.forEach(s),ga=c(e),y(Be.$$.fragment,e),Za=c(e),Z=i(e,"P",{});var Je=n(Z);br=l(Je,`Al\xE9m dos pesos do modelo e da configura\xE7\xE3o no formato json, isso tamb\xE9m copiou o modelo e
configura\xE7\xE3o `),Js=i(Je,"CODE",{});var wn=n(Js);jr=l(wn,".py"),wn.forEach(s),Tr=l(Je," na pasta "),ws=i(Je,"CODE",{});var vn=n(ws);Ur=l(vn,"custom-resnet50d"),vn.forEach(s),_r=l(Je,` e carregou o resultado para o Hub. Voc\xEA pode conferir o resultado
neste `),We=i(Je,"A",{href:!0,rel:!0});var bn=n(We);Cr=l(bn,"reposit\xF3rio de modelos"),bn.forEach(s),hr=l(Je,"."),Je.forEach(s),Aa=c(e),ce=i(e,"P",{});var La=n(ce);Ir=l(La,"Consulte o "),io=i(La,"A",{href:!0});var jn=n(io);Er=l(jn,"tutorial de compartilhamento"),jn.forEach(s),gr=l(La," para obter mais informa\xE7\xF5es sobre o m\xE9todo push_to_hub."),La.forEach(s),qa=c(e),O=i(e,"H2",{class:!0});var Ka=n(O);pe=i(Ka,"A",{id:!0,class:!0,href:!0});var Tn=n(pe);vs=i(Tn,"SPAN",{});var Un=n(vs);y(Xe.$$.fragment,Un),Un.forEach(s),Tn.forEach(s),Zr=c(Ka),bs=i(Ka,"SPAN",{});var _n=n(bs);Ar=l(_n,"Usando um modelo com c\xF3digo customizado"),_n.forEach(s),Ka.forEach(s),$a=c(e),A=i(e,"P",{});var we=n(A);qr=l(we,`Voc\xEA pode usar qualquer configura\xE7\xE3o, modelo ou tokenizador com arquivos de c\xF3digo customizados em seu reposit\xF3rio com as classes autom\xE1ticas e
o m\xE9todo `),js=i(we,"CODE",{});var Cn=n(js);$r=l(Cn,"from_pretrained"),Cn.forEach(s),Nr=l(we,". Todos os arquivos e c\xF3digos carregados no Hub s\xE3o verificados quanto a malware (consulte a documenta\xE7\xE3o de "),Ve=i(we,"A",{href:!0,rel:!0});var hn=n(Ve);kr=l(hn,"Seguran\xE7a do Hub"),hn.forEach(s),Rr=l(we,` para obter mais informa\xE7\xF5es), mas voc\xEA ainda deve
revisar o c\xF3digo do modelo e o autor para evitar a execu\xE7\xE3o de c\xF3digo malicioso em sua m\xE1quina. Defina `),Ts=i(we,"CODE",{});var In=n(Ts);zr=l(In,"trust_remote_code=True"),In.forEach(s),Br=l(we,` para usar
um modelo com c\xF3digo customizado:`),we.forEach(s),Na=c(e),y(Ge.$$.fragment,e),ka=c(e),ue=i(e,"P",{});var el=n(ue);Wr=l(el,"Tamb\xE9m \xE9 fortemente recomendado passar um hash de confirma\xE7\xE3o como uma "),Us=i(el,"CODE",{});var En=n(Us);Xr=l(En,"revis\xE3o"),En.forEach(s),Vr=l(el,` para garantir que o autor dos modelos n\xE3o
atualize o c\xF3digo com novas linhas maliciosas (a menos que voc\xEA confie totalmente nos autores dos modelos).`),el.forEach(s),Ra=c(e),y(Ye.$$.fragment,e),za=c(e),no=i(e,"P",{});var gn=n(no);Gr=l(gn,`Observe que ao navegar no hist\xF3rico de commits do reposit\xF3rio do modelo no Hub, h\xE1 um bot\xE3o para copiar facilmente o commit
hash de qualquer commit.`),gn.forEach(s),Ba=c(e),L=i(e,"H2",{class:!0});var ol=n(L);fe=i(ol,"A",{id:!0,class:!0,href:!0});var Zn=n(fe);_s=i(Zn,"SPAN",{});var An=n(_s);y(Qe.$$.fragment,An),An.forEach(s),Zn.forEach(s),Yr=c(ol),Cs=i(ol,"SPAN",{});var qn=n(Cs);Qr=l(qn,"Registrando um modelo com c\xF3digo customizado para as classes autom\xE1ticas"),qn.forEach(s),ol.forEach(s),Wa=c(e),mo=i(e,"P",{});var $n=n(mo);Fr=l($n,`Se voc\xEA estiver escrevendo uma biblioteca que estende \u{1F917} Transformers, talvez queira estender as classes autom\xE1ticas para incluir seus pr\xF3prios
modelos. Isso \xE9 diferente de enviar o c\xF3digo para o Hub no sentido de que os usu\xE1rios precisar\xE3o importar sua biblioteca para
obter os modelos customizados (ao contr\xE1rio de baixar automaticamente o c\xF3digo do modelo do Hub).`),$n.forEach(s),Xa=c(e),Y=i(e,"P",{});var To=n(Y);Dr=l(To,"Desde que sua configura\xE7\xE3o tenha um atributo "),hs=i(To,"CODE",{});var Nn=n(hs);Sr=l(Nn,"model_type"),Nn.forEach(s),Hr=l(To,` diferente dos tipos de modelo existentes e que as classes do seu modelo
tenha os atributos `),Is=i(To,"CODE",{});var kn=n(Is);xr=l(kn,"config_class"),kn.forEach(s),Pr=l(To," corretos, voc\xEA pode simplesmente adicion\xE1-los \xE0s classes autom\xE1ticas assim:"),To.forEach(s),Va=c(e),y(Fe.$$.fragment,e),Ga=c(e),q=i(e,"P",{});var ve=n(q);Or=l(ve,"Observe que o primeiro argumento usado ao registrar sua configura\xE7\xE3o customizada para "),Es=i(ve,"CODE",{});var Rn=n(Es);Lr=l(Rn,"AutoConfig"),Rn.forEach(s),Kr=l(ve," precisa corresponder ao "),gs=i(ve,"CODE",{});var zn=n(gs);ei=l(zn,"model_type"),zn.forEach(s),oi=l(ve,`
de sua configura\xE7\xE3o customizada. E o primeiro argumento usado ao registrar seus modelos customizados, para qualquer necessidade de classe de modelo autom\xE1tico
deve corresponder ao `),Zs=i(ve,"CODE",{});var Bn=n(Zs);si=l(Bn,"config_class"),Bn.forEach(s),ai=l(ve," desses modelos."),ve.forEach(s),this.h()},h(){p(u,"name","hf:doc:metadata"),p(u,"content",JSON.stringify(Hn)),p(j,"id","compartilhando-modelos-customizados"),p(j,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(j,"href","#compartilhando-modelos-customizados"),p(f,"class","relative group"),p(be,"href","https://github.com/rwightman/pytorch-image-models"),p(be,"rel","nofollow"),p(oe,"id","escrevendo-uma-configurao-customizada"),p(oe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(oe,"href","#escrevendo-uma-configurao-customizada"),p(D,"class","relative group"),p(ae,"id","escrevendo-um-modelo-customizado"),p(ae,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ae,"href","#escrevendo-um-modelo-customizado"),p(x,"class","relative group"),p(re,"id","enviando-o-cdigo-para-o-hub"),p(re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(re,"href","#enviando-o-cdigo-para-o-hub"),p(P,"class","relative group"),p(We,"href","https://huggingface.co/sgugger/custom-resnet50d"),p(We,"rel","nofollow"),p(io,"href","model_sharing"),p(pe,"id","usando-um-modelo-com-cdigo-customizado"),p(pe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(pe,"href","#usando-um-modelo-com-cdigo-customizado"),p(O,"class","relative group"),p(Ve,"href","https://huggingface.co/docs/hub/security#malware-scanning"),p(Ve,"rel","nofollow"),p(fe,"id","registrando-um-modelo-com-cdigo-customizado-para-as-classes-automticas"),p(fe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(fe,"href","#registrando-um-modelo-com-cdigo-customizado-para-as-classes-automticas"),p(L,"class","relative group")},m(e,t){o(document.head,u),d(e,_,t),d(e,f,t),o(f,j),o(j,F),J(I,F,null),o(f,$),o(f,ee),o(ee,sl),d(e,$s,t),d(e,Se,t),o(Se,al),d(e,Ns,t),d(e,He,t),o(He,ll),d(e,ks,t),d(e,N,t),o(N,tl),o(N,be),o(be,rl),o(N,il),o(N,_o),o(_o,nl),o(N,dl),d(e,Rs,t),d(e,D,t),o(D,oe),o(oe,Co),J(je,Co,null),o(D,ml),o(D,ho),o(ho,cl),d(e,zs,t),d(e,se,t),o(se,pl),o(se,Io),o(Io,ul),o(se,fl),d(e,Bs,t),d(e,xe,t),o(xe,Ml),d(e,Ws,t),J(Te,e,t),d(e,Xs,t),d(e,Pe,t),o(Pe,yl),d(e,Vs,t),d(e,k,t),o(k,Ue),o(Ue,Jl),o(Ue,Eo),o(Eo,wl),o(Ue,vl),o(k,bl),o(k,S),o(S,jl),o(S,go),o(go,Tl),o(S,Ul),o(S,Zo),o(Zo,_l),o(S,Cl),o(k,hl),o(k,H),o(H,Il),o(H,Ao),o(Ao,El),o(H,gl),o(H,qo),o(qo,Zl),o(H,Al),d(e,Gs,t),d(e,R,t),o(R,ql),o(R,$o),o($o,$l),o(R,Nl),o(R,No),o(No,kl),o(R,Rl),d(e,Ys,t),d(e,z,t),o(z,zl),o(z,ko),o(ko,Bl),o(z,Wl),o(z,Ro),o(Ro,Xl),o(z,Vl),d(e,Qs,t),d(e,Oe,t),o(Oe,Gl),d(e,Fs,t),J(_e,e,t),d(e,Ds,t),d(e,E,t),o(E,Yl),o(E,zo),o(zo,Ql),o(E,Fl),o(E,Bo),o(Bo,Dl),o(E,Sl),o(E,Wo),o(Wo,Hl),o(E,xl),d(e,Ss,t),J(Ce,e,t),d(e,Hs,t),d(e,B,t),o(B,Pl),o(B,Xo),o(Xo,Ol),o(B,Ll),o(B,Vo),o(Vo,Kl),o(B,et),d(e,xs,t),d(e,x,t),o(x,ae),o(ae,Go),J(he,Go,null),o(x,ot),o(x,Yo),o(Yo,st),d(e,Ps,t),d(e,W,t),o(W,at),o(W,Qo),o(Qo,lt),o(W,tt),o(W,Fo),o(Fo,rt),o(W,it),d(e,Os,t),d(e,le,t),o(le,nt),o(le,Do),o(Do,dt),o(le,mt),d(e,Ls,t),J(Ie,e,t),d(e,Ks,t),d(e,Le,t),o(Le,ct),d(e,ea,t),J(Ee,e,t),d(e,oa,t),d(e,h,t),o(h,pt),o(h,So),o(So,ut),o(h,ft),o(h,Ho),o(Ho,Mt),o(h,yt),o(h,xo),o(xo,Jt),o(h,wt),o(h,Po),o(Po,vt),o(h,bt),d(e,sa,t),J(te,e,t),d(e,aa,t),d(e,X,t),o(X,jt),o(X,Oo),o(Oo,Tt),o(X,Ut),o(X,Lo),o(Lo,_t),o(X,Ct),d(e,la,t),d(e,Ke,t),o(Ke,ht),d(e,ta,t),J(ge,e,t),d(e,ra,t),d(e,g,t),o(g,It),o(g,Ko),o(Ko,Et),o(g,gt),o(g,es),o(es,Zt),o(g,At),o(g,os),o(os,qt),o(g,$t),d(e,ia,t),d(e,eo,t),o(eo,Nt),d(e,na,t),J(Ze,e,t),d(e,da,t),d(e,V,t),o(V,kt),o(V,ss),o(ss,Rt),o(V,zt),o(V,as),o(as,Bt),o(V,Wt),d(e,ma,t),d(e,P,t),o(P,re),o(re,ls),J(Ae,ls,null),o(P,Xt),o(P,ts),o(ts,Vt),d(e,ca,t),J(ie,e,t),d(e,pa,t),d(e,T,t),o(T,Gt),o(T,rs),o(rs,Yt),o(T,Qt),o(T,is),o(is,Ft),o(T,Dt),o(T,ns),o(ns,St),o(T,Ht),o(T,ds),o(ds,xt),o(T,Pt),o(T,ms),o(ms,Ot),o(T,Lt),o(T,cs),o(cs,Kt),o(T,er),o(T,ps),o(ps,or),o(T,sr),d(e,ua,t),J(qe,e,t),d(e,fa,t),d(e,G,t),o(G,ar),o(G,us),o(us,lr),o(G,tr),o(G,fs),o(fs,rr),o(G,ir),d(e,Ma,t),J(ne,e,t),d(e,ya,t),d(e,oo,t),o(oo,nr),d(e,Ja,t),d(e,so,t),o(so,dr),d(e,wa,t),J($e,e,t),d(e,va,t),d(e,de,t),o(de,mr),o(de,Ms),o(Ms,cr),o(de,pr),d(e,ba,t),J(Ne,e,t),d(e,ja,t),d(e,me,t),o(me,ur),o(me,ys),o(ys,fr),o(me,Mr),d(e,Ta,t),d(e,ao,t),o(ao,yr),d(e,Ua,t),J(ke,e,t),d(e,_a,t),d(e,lo,t),o(lo,Jr),d(e,Ca,t),J(Re,e,t),d(e,ha,t),d(e,to,t),o(to,wr),d(e,Ia,t),J(ze,e,t),d(e,Ea,t),d(e,ro,t),o(ro,vr),d(e,ga,t),J(Be,e,t),d(e,Za,t),d(e,Z,t),o(Z,br),o(Z,Js),o(Js,jr),o(Z,Tr),o(Z,ws),o(ws,Ur),o(Z,_r),o(Z,We),o(We,Cr),o(Z,hr),d(e,Aa,t),d(e,ce,t),o(ce,Ir),o(ce,io),o(io,Er),o(ce,gr),d(e,qa,t),d(e,O,t),o(O,pe),o(pe,vs),J(Xe,vs,null),o(O,Zr),o(O,bs),o(bs,Ar),d(e,$a,t),d(e,A,t),o(A,qr),o(A,js),o(js,$r),o(A,Nr),o(A,Ve),o(Ve,kr),o(A,Rr),o(A,Ts),o(Ts,zr),o(A,Br),d(e,Na,t),J(Ge,e,t),d(e,ka,t),d(e,ue,t),o(ue,Wr),o(ue,Us),o(Us,Xr),o(ue,Vr),d(e,Ra,t),J(Ye,e,t),d(e,za,t),d(e,no,t),o(no,Gr),d(e,Ba,t),d(e,L,t),o(L,fe),o(fe,_s),J(Qe,_s,null),o(L,Yr),o(L,Cs),o(Cs,Qr),d(e,Wa,t),d(e,mo,t),o(mo,Fr),d(e,Xa,t),d(e,Y,t),o(Y,Dr),o(Y,hs),o(hs,Sr),o(Y,Hr),o(Y,Is),o(Is,xr),o(Y,Pr),d(e,Va,t),J(Fe,e,t),d(e,Ga,t),d(e,q,t),o(q,Or),o(q,Es),o(Es,Lr),o(q,Kr),o(q,gs),o(gs,ei),o(q,oi),o(q,Zs),o(Zs,si),o(q,ai),Ya=!0},p(e,[t]){const De={};t&2&&(De.$$scope={dirty:t,ctx:e}),te.$set(De);const As={};t&2&&(As.$$scope={dirty:t,ctx:e}),ie.$set(As);const qs={};t&2&&(qs.$$scope={dirty:t,ctx:e}),ne.$set(qs)},i(e){Ya||(w(I.$$.fragment,e),w(je.$$.fragment,e),w(Te.$$.fragment,e),w(_e.$$.fragment,e),w(Ce.$$.fragment,e),w(he.$$.fragment,e),w(Ie.$$.fragment,e),w(Ee.$$.fragment,e),w(te.$$.fragment,e),w(ge.$$.fragment,e),w(Ze.$$.fragment,e),w(Ae.$$.fragment,e),w(ie.$$.fragment,e),w(qe.$$.fragment,e),w(ne.$$.fragment,e),w($e.$$.fragment,e),w(Ne.$$.fragment,e),w(ke.$$.fragment,e),w(Re.$$.fragment,e),w(ze.$$.fragment,e),w(Be.$$.fragment,e),w(Xe.$$.fragment,e),w(Ge.$$.fragment,e),w(Ye.$$.fragment,e),w(Qe.$$.fragment,e),w(Fe.$$.fragment,e),Ya=!0)},o(e){v(I.$$.fragment,e),v(je.$$.fragment,e),v(Te.$$.fragment,e),v(_e.$$.fragment,e),v(Ce.$$.fragment,e),v(he.$$.fragment,e),v(Ie.$$.fragment,e),v(Ee.$$.fragment,e),v(te.$$.fragment,e),v(ge.$$.fragment,e),v(Ze.$$.fragment,e),v(Ae.$$.fragment,e),v(ie.$$.fragment,e),v(qe.$$.fragment,e),v(ne.$$.fragment,e),v($e.$$.fragment,e),v(Ne.$$.fragment,e),v(ke.$$.fragment,e),v(Re.$$.fragment,e),v(ze.$$.fragment,e),v(Be.$$.fragment,e),v(Xe.$$.fragment,e),v(Ge.$$.fragment,e),v(Ye.$$.fragment,e),v(Qe.$$.fragment,e),v(Fe.$$.fragment,e),Ya=!1},d(e){s(u),e&&s(_),e&&s(f),b(I),e&&s($s),e&&s(Se),e&&s(Ns),e&&s(He),e&&s(ks),e&&s(N),e&&s(Rs),e&&s(D),b(je),e&&s(zs),e&&s(se),e&&s(Bs),e&&s(xe),e&&s(Ws),b(Te,e),e&&s(Xs),e&&s(Pe),e&&s(Vs),e&&s(k),e&&s(Gs),e&&s(R),e&&s(Ys),e&&s(z),e&&s(Qs),e&&s(Oe),e&&s(Fs),b(_e,e),e&&s(Ds),e&&s(E),e&&s(Ss),b(Ce,e),e&&s(Hs),e&&s(B),e&&s(xs),e&&s(x),b(he),e&&s(Ps),e&&s(W),e&&s(Os),e&&s(le),e&&s(Ls),b(Ie,e),e&&s(Ks),e&&s(Le),e&&s(ea),b(Ee,e),e&&s(oa),e&&s(h),e&&s(sa),b(te,e),e&&s(aa),e&&s(X),e&&s(la),e&&s(Ke),e&&s(ta),b(ge,e),e&&s(ra),e&&s(g),e&&s(ia),e&&s(eo),e&&s(na),b(Ze,e),e&&s(da),e&&s(V),e&&s(ma),e&&s(P),b(Ae),e&&s(ca),b(ie,e),e&&s(pa),e&&s(T),e&&s(ua),b(qe,e),e&&s(fa),e&&s(G),e&&s(Ma),b(ne,e),e&&s(ya),e&&s(oo),e&&s(Ja),e&&s(so),e&&s(wa),b($e,e),e&&s(va),e&&s(de),e&&s(ba),b(Ne,e),e&&s(ja),e&&s(me),e&&s(Ta),e&&s(ao),e&&s(Ua),b(ke,e),e&&s(_a),e&&s(lo),e&&s(Ca),b(Re,e),e&&s(ha),e&&s(to),e&&s(Ia),b(ze,e),e&&s(Ea),e&&s(ro),e&&s(ga),b(Be,e),e&&s(Za),e&&s(Z),e&&s(Aa),e&&s(ce),e&&s(qa),e&&s(O),b(Xe),e&&s($a),e&&s(A),e&&s(Na),b(Ge,e),e&&s(ka),e&&s(ue),e&&s(Ra),b(Ye,e),e&&s(za),e&&s(no),e&&s(Ba),e&&s(L),b(Qe),e&&s(Wa),e&&s(mo),e&&s(Xa),e&&s(Y),e&&s(Va),b(Fe,e),e&&s(Ga),e&&s(q)}}}const Hn={local:"compartilhando-modelos-customizados",sections:[{local:"escrevendo-uma-configurao-customizada",title:"Escrevendo uma configura\xE7\xE3o customizada"},{local:"escrevendo-um-modelo-customizado",title:"Escrevendo um modelo customizado"},{local:"enviando-o-cdigo-para-o-hub",title:"Enviando o c\xF3digo para o Hub"},{local:"usando-um-modelo-com-cdigo-customizado",title:"Usando um modelo com c\xF3digo customizado"},{local:"registrando-um-modelo-com-cdigo-customizado-para-as-classes-automticas",title:"Registrando um modelo com c\xF3digo customizado para as classes autom\xE1ticas"}],title:"Compartilhando modelos customizados"};function xn(K){return Yn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ed extends Wn{constructor(u){super();Xn(this,u,xn,Sn,Vn,{})}}export{ed as default,Hn as metadata};
