import{s as zn,o as Dn,n as Hl}from"../chunks/scheduler.b108d059.js";import{S as Pn,i as On,g as o,s,r as c,A as Kn,h as i,f as l,c as a,j as Yn,u as M,x as p,k as qn,y as es,a as n,v as d,d as m,t as u,w as h}from"../chunks/index.008de539.js";import{T as Ql}from"../chunks/Tip.aeb15ab7.js";import{C as T}from"../chunks/CodeBlock.3968c746.js";import{H as J,E as ts}from"../chunks/EditOnGithub.d1c48e3d.js";function ls(U){let r,g='Starting from TGI 2.3 DLC i.e. <code>us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-text-generation-inference-cu124.2-3.ubuntu2204.py311</code>, and onwards, you can set the environment variable value <code>MESSAGES_API_ENABLED=&quot;true&quot;</code> to deploy the <a href="https://huggingface.co/docs/text-generation-inference/main/en/messages_api" rel="nofollow">Messages API</a> on Vertex AI, otherwise, the <a href="https://huggingface.co/docs/text-generation-inference/main/en/quicktour#consuming-tgi" rel="nofollow">Generate API</a> will be deployed instead.';return{c(){r=o("p"),r.innerHTML=g},l(y){r=i(y,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1jcnsbw"&&(r.innerHTML=g)},m(y,w){n(y,r,w)},p:Hl,d(y){y&&l(r)}}}function ns(U){let r,g="You will need to either retrieve the resource name i.e. the <code>projects/{PROJECT_ID}/locations/{LOCATION}/endpoints/{ENDPOINT_ID}</code> URL yourself via the Google Cloud Console, or just replace the <code>ENDPOINT_ID</code> below that can either be found via the previously instantiated <code>endpoint</code> as <code>endpoint.id</code> or via the Google Cloud Console under the Online predictions where the endpoint is listed.";return{c(){r=o("p"),r.innerHTML=g},l(y){r=i(y,"P",{"data-svelte-h":!0}),p(r)!=="svelte-10r1du6"&&(r.innerHTML=g)},m(y,w){n(y,r,w)},p:Hl,d(y){y&&l(r)}}}function ss(U){let r,g="When deleting the model from Vertex AI, as it’s stored within a GCS Bucket, neither the bucket nor its contents will be removed when removing the model from Vertex AI.";return{c(){r=o("p"),r.textContent=g},l(y){r=i(y,"P",{"data-svelte-h":!0}),p(r)!=="svelte-uo7qbi"&&(r.textContent=g)},m(y,w){n(y,r,w)},p:Hl,d(y){y&&l(r)}}}function as(U){let r,g='📍 Find the complete example on GitHub <a href="https://github.com/huggingface/Google-Cloud-Containers/tree/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai" rel="nofollow">here</a>!';return{c(){r=o("p"),r.innerHTML=g},l(y){r=i(y,"P",{"data-svelte-h":!0}),p(r)!=="svelte-gcq6cl"&&(r.innerHTML=g)},m(y,w){n(y,r,w)},p:Hl,d(y){y&&l(r)}}}function os(U){let r,g,y,w,C,ot,v,Ll="Gemma is a family of lightweight, state-of-the-art open models built from the same research and technology used to create the Gemini models, developed by Google DeepMind and other teams across Google. Text Generation Inference (TGI) is a toolkit developed by Hugging Face for deploying and serving LLMs, with high performance text generation. And, Google Vertex AI is a Machine Learning (ML) platform that lets you train and deploy ML models and AI applications, and customize large language models (LLMs) for use in your AI-powered applications.",it,Z,Yl='This example showcases how to deploy any supported text-generation model, in this case <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a>, downloaded from the Hugging Face Hub and uploaded to a Google Cloud Storage (GCS) Bucket, on Vertex AI using the Hugging Face DLC for TGI available in Google Cloud Platform (GCP).',pt,G,ql='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/model-in-hf-hub.png" alt="&#39;google/gemma-7b-it&#39; in the Hugging Face Hub"/>',rt,$,ct,A,zl='First, you need to install <code>gcloud</code> in your local machine, which is the command-line tool for Google Cloud, following the instructions at <a href="https://cloud.google.com/sdk/docs/install" rel="nofollow">Cloud SDK Documentation - Install the gcloud CLI</a>.',Mt,V,Dl="Then, you also need to install the <code>google-cloud-aiplatform</code> Python SDK, required to programmatically create the Vertex AI model, register it, acreate the endpoint, and deploy it on Vertex AI.",dt,B,mt,x,Pl="Optionally, to ease the usage of the commands within this tutorial, you need to set the following environment variables for GCP:",ut,k,ht,R,Ol="Then you need to login into your GCP account and set the project ID to the one you want to use to register and deploy the models on Vertex AI.",yt,_,Tt,W,Kl="Once you are logged in, you need to enable the necessary service APIs in GCP, such as the Vertex AI API, the Compute Engine API, and Google Container Registry related APIs.",gt,N,Jt,E,wt,X,en="Unless you already have a GCS Bucket with the artifact that you want to serve, please follow the instructions below in order to create a new bucket and download and upload the model weights into it.",Ut,S,tn="To create the bucket on Google Cloud Storage (GCS), you first need to ensure that the name is unique for the new bucket or if a bucket with the same name already exists. To do so, both the <code>gsutil</code> SDK and the <code>crcmod</code> Python package need to be installed in advance as follows:",ft,F,jt,Q,ln="Then you can check whether the bucket exists in GCS, and create it if it doesn’t, with the following bash script:",bt,H,It,L,nn='If either the bucket was created or if the bucket existed in advance, you can already upload <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a> from either the Hugging Face Hub, or local storage.',Ct,Y,vt,q,sn="If the model is available locally, e.g. under the Hugging Face cache path at <code>~/.cache/huggingface/hub/models--google--gemma-7b-it/snapshots/8adab6a35fdbcdae0ae41ab1f711b1bc8d05727e</code>, you should run the following script to upload it to the GCS Bucket.",Zt,z,Gt,D,$t,P,an='Alternatively, you can also upload the model to the GCS Bucket from the Hugging Face Hub. As <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a> is a gated model, you need to login into your Hugging Face Hub account with a read-access token either fine-grained with access to the gated model, or just overall read-access to your account.',At,O,on='More information on how to generate a read-only access token for the Hugging Face Hub in the instructions at <a href="https://huggingface.co/docs/hub/en/security-tokens" rel="nofollow">https://huggingface.co/docs/hub/en/security-tokens</a>.',Vt,K,Bt,ee,xt,te,pn="After <code>huggingface_hub</code> installation and login are completed, you can run the following bash script to download the model locally within a temporary directory, and then upload those to the GCS Bucket.",kt,le,Rt,ne,rn='To see the end to end script, please check <a href="https://github.com/huggingface/Google-Cloud-Containers/blob/main/scripts/upload_model_to_gcs.sh" rel="nofollow"><code>./scripts/upload_model_to_gcs.sh</code></a> within the root directory of this repository.',_t,se,cn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/gcs-model-artifact.png" alt="GCS Bucket with model artifact"/>',Wt,ae,Nt,oe,Mn="Once everything is set up, you can already initialize the Vertex AI session via the <code>google-cloud-aiplatform</code> Python SDK as follows:",Et,ie,Xt,pe,dn="Then you can already “upload” the model i.e. register the model on Vertex AI. It is not an upload per se, since the model will be automatically downloaded from the GCS Bucket URI on startup, so what is uploaded is only the configuration, not the model weights.",St,re,mn="Before going into the code, let’s quickly review the arguments provided to the <code>upload</code> method:",Ft,ce,un='<li><p><strong><code>display_name</code></strong> is the name that will be shown in the Vertex AI Model Registry.</p></li> <li><p><strong><code>artifact_uri</code></strong> is the path to the directory with the artifact within the GCS Bucket.</p></li> <li><p><strong><code>serving_container_image_uri</code></strong> is the location of the Hugging Face DLC for TGI that will be used for serving the model.</p></li> <li><p><strong><code>serving_container_environment_variables</code></strong> are the environment variables that will be used during the container runtime, so these are aligned with the environment variables defined by <code>text-generation-inference</code>, which are analog to the <a href="https://huggingface.co/docs/text-generation-inference/en/basic_tutorials/launcher" rel="nofollow"><code>text-generation-launcher</code> arguments</a>. Additionally, the Hugging Face DLCs for TGI also capture the <code>AIP_</code> environment variables from Vertex AI as in <a href="https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements" rel="nofollow">Vertex AI Documentation - Custom container requirements for prediction</a>.</p> <ul><li><code>NUM_SHARD</code> is the number of shards to use if you don’t want to use all GPUs on a given machine e.g. if you have two GPUs but you just want to use one for TGI then <code>NUM_SHARD=1</code>, otherwise it matches the <code>CUDA_VISIBLE_DEVICES</code>.</li> <li><code>MAX_INPUT_TOKENS</code> is the maximum allowed input length (expressed in number of tokens), the larger it is, the larger the prompt can be, but also more memory will be consumed.</li> <li><code>MAX_TOTAL_TOKENS</code> is the most important value to set as it defines the “memory budget” of running clients requests, the larger this value, the larger amount each request will be in your RAM and the less effective batching can be.</li> <li><code>MAX_BATCH_PREFILL_TOKENS</code> limits the number of tokens for the prefill operation, as it takes the most memory and is compute bound, it is interesting to limit the number of requests that can be sent.</li> <li><code>HUGGING_FACE_HUB_TOKEN</code> is the Hugging Face Hub token, required as <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a> is a gated model.</li></ul></li> <li><p>(optional) <strong><code>serving_container_ports</code></strong> is the port where the Vertex AI endpoint will be exposed, by default 8080.</p></li>',Qt,Me,hn='For more information on the supported <code>aiplatform.Model.upload</code> arguments, check its Python reference at <a href="https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_upload" rel="nofollow">https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_upload</a>.',Ht,f,Lt,de,Yt,me,yn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-model.png" alt="Model on Vertex AI Model Registry"/>',qt,ue,Tn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-model-path.png" alt="Model on Vertex AI Model Registry with path to GCS"/>',zt,he,Dt,ye,gn="After the model is registered on Vertex AI, you need to define the endpoint that you want to deploy the model to, and then link the model deployment to that endpoint resource.",Pt,Te,Jn="To do so, you need to call the method <code>aiplatform.Endpoint.create</code> to create a new Vertex AI endpoint resource (which is not linked to a model or anything usable yet).",Ot,ge,Kt,Je,wn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-endpoint.png" alt="Vertex AI Endpoint created"/>',el,we,Un="Now you can deploy the registered model in an endpoint on Vertex AI.",tl,Ue,fn="The <code>deploy</code> method will link the previously created endpoint resource with the model that contains the configuration of the serving container, and then, it will deploy the model on Vertex AI in the specified instance.",ll,fe,jn="Before going into the code, let’s quicklyl review the arguments provided to the <code>deploy</code> method:",nl,je,bn='<li><strong><code>endpoint</code></strong> is the endpoint to deploy the model to, which is optional, and by default will be set to the model display name with the <code>_endpoint</code> suffix.</li> <li><strong><code>machine_type</code></strong>, <strong><code>accelerator_type</code></strong> and <strong><code>accelerator_count</code></strong> are arguments that define which instance to use, and additionally, the accelerator to use and the number of accelerators, respectively. The <code>machine_type</code> and the <code>accelerator_type</code> are tied together, so you will need to select an instance that supports the accelerator that you are using and vice-versa. More information about the different instances at <a href="https://cloud.google.com/compute/docs/gpus" rel="nofollow">Compute Engine Documentation - GPU machine types</a>, and about the <code>accelerator_type</code> naming at <a href="https://cloud.google.com/vertex-ai/docs/reference/rest/v1/MachineSpec" rel="nofollow">Vertex AI Documentation - MachineSpec</a>.</li>',sl,be,In='For more information on the supported <code>aiplatform.Model.deploy</code> arguments, you can check its Python reference at <a href="https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_deploy" rel="nofollow">https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_deploy</a>.',al,Ie,ol,Ce,Cn="<strong>WARNING</strong>: <em>The Vertex AI endpoint deployment via the <code>deploy</code> method may take from 15 to 25 minutes.</em>",il,ve,vn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-endpoint-run.png" alt="Vertex AI Endpoint running the model"/>',pl,Ze,Zn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-endpoint-logs.png" alt="Vertex AI Endpoint logs in Cloud Logging"/>',rl,Ge,cl,$e,Gn="Finally, you can run the online predictions on Vertex AI using the <code>predict</code> method, which will send the requests to the running endpoint in the <code>/predict</code> route specified within the container following Vertex AI I/O payload formatting.",Ml,Ae,$n='As you are serving a <code>text-generation</code> model, you will need to make sure that the chat template, if any, is applied correctly to the input conversation; meaning that <code>transformers</code> need to be installed so as to instantiate the <code>tokenizer</code> for <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a> and run the <code>apply_chat_template</code> method over the input conversation before sending the input within the payload to the Vertex AI endpoint.',dl,Ve,ml,Be,An="After the installation is complete, the following snippet will apply the chat template to the conversation:",ul,xe,hl,ke,Vn='Which is what you will be sending within the payload to the deployed Vertex AI Endpoint, as well as the generation parameters as in <a href="https://huggingface.co/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation" rel="nofollow">https://huggingface.co/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation</a>.',yl,Re,Tl,_e,gl,We,Bn="If you are willing to run the online prediction within the current session, you can send requests programmatically via the <code>aiplatform.Endpoint</code> (returned by the <code>aiplatform.Model.deploy</code> method) as in the following snippet:",Jl,Ne,wl,Ee,xn="Producing the following <code>output</code>:",Ul,Xe,fl,Se,jl,Fe,kn="If the Vertex AI Endpoint was deployed in a different session and you want to use it but don’t have access to the <code>deployed_model</code> variable returned by the <code>aiplatform.Model.deploy</code> method as in the previous section; you can also run the following snippet to instantiate the deployed <code>aiplatform.Endpoint</code> via its resource name as <code>projects/{PROJECT_ID}/locations/{LOCATION}/endpoints/{ENDPOINT_ID}</code>.",bl,j,Il,Qe,Cl,He,vl,Le,Rn="Alternatively, for testing purposes you can also use the Vertex AI Online Prediction UI, that provides a field that expects the JSON payload formatted according to the Vertex AI specification (as in the examples above) being:",Zl,Ye,Gl,qe,_n='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-online-prediction.png" alt="Vertex AI Endpoint online inference"/>',$l,ze,Al,De,Wn="Finally, you can already release the resources that you’ve created as follows, to avoid unnecessary costs:",Vl,Pe,Nn="<li><code>deployed_model.undeploy_all</code> to undeploy the model from all the endpoints.</li> <li><code>deployed_model.delete</code> to delete the endpoint/s where the model was deployed gracefully, after the <code>undeploy_all</code> method.</li> <li><code>model.delete</code> to delete the model from the registry.</li>",Bl,b,xl,Oe,kl,Ke,En="Alternatively, you can also remove those from the Google Cloud Console following the steps:",Rl,et,Xn="<li>Go to Vertex AI in Google Cloud</li> <li>Go to Deploy and use -&gt; Online prediction</li> <li>Click on the endpoint and then on the deployed model/s to “Undeploy model from endpoint”</li> <li>Then go back to the endpoint list and remove the endpoint</li> <li>Finally, go to Deploy and use -&gt; Model Registry, and remove the model</li>",_l,tt,Sn="Additionally, you may also want to remove the GCS Bucket, to do so, you can use the following <code>gcloud</code> command:",Wl,lt,Nl,nt,El,I,Xl,st,Sl,at,Fl;return C=new J({props:{title:"Deploy Gemma 7B with TGI DLC from GCS on Vertex AI",local:"deploy-gemma-7b-with-tgi-dlc-from-gcs-on-vertex-ai",headingTag:"h1"}}),$=new J({props:{title:"Setup / Configuration",local:"setup--configuration",headingTag:"h2"}}),B=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwZ29vZ2xlLWNsb3VkLWFpcGxhdGZvcm0=",highlighted:"!pip install --upgrade --quiet google-cloud-aiplatform",wrap:!1}}),k=new T({props:{code:"JTI1ZW52JTIwUFJPSkVDVF9JRCUzRHlvdXItcHJvamVjdC1pZCUwQSUyNWVudiUyMExPQ0FUSU9OJTNEeW91ci1sb2NhdGlvbiUwQSUyNWVudiUyMEJVQ0tFVF9VUkklM0RncyUzQSUyRiUyRnlvdXItYnVja2V0JTBBJTI1ZW52JTIwQVJUSUZBQ1RfTkFNRSUzRGdvb2dsZS0tZ2VtbWEtN2ItaXQlMEElMjVlbnYlMjBDT05UQUlORVJfVVJJJTNEdXMtZG9ja2VyLnBrZy5kZXYlMkZkZWVwbGVhcm5pbmctcGxhdGZvcm0tcmVsZWFzZSUyRmdjci5pbyUyRmh1Z2dpbmdmYWNlLXRleHQtZ2VuZXJhdGlvbi1pbmZlcmVuY2UtY3UxMjQuMi0zLnVidW50dTIyMDQucHkzMTE=",highlighted:`%env PROJECT_ID=your-project-<span class="hljs-built_in">id</span>
%env LOCATION=your-location
%env BUCKET_URI=gs://your-bucket
%env ARTIFACT_NAME=google--gemma-7b-it
%env CONTAINER_URI=us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-text-generation-inference-cu124<span class="hljs-number">.2</span>-<span class="hljs-number">3.</span>ubuntu2204.py311`,wrap:!1}}),_=new T({props:{code:"IWdjbG91ZCUyMGF1dGglMjBsb2dpbiUwQSFnY2xvdWQlMjBhdXRoJTIwYXBwbGljYXRpb24tZGVmYXVsdCUyMGxvZ2luJTIwJTIwJTIzJTIwRm9yJTIwbG9jYWwlMjBkZXZlbG9wbWVudCUwQSFnY2xvdWQlMjBjb25maWclMjBzZXQlMjBwcm9qZWN0JTIwJTI0UFJPSkVDVF9JRA==",highlighted:`!gcloud auth login
!gcloud auth application-default login  <span class="hljs-comment"># For local development</span>
!gcloud config <span class="hljs-built_in">set</span> project $PROJECT_ID`,wrap:!1}}),N=new T({props:{code:"IWdjbG91ZCUyMHNlcnZpY2VzJTIwZW5hYmxlJTIwYWlwbGF0Zm9ybS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbXB1dGUuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXIuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXJyZWdpc3RyeS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbnRhaW5lcmZpbGVzeXN0ZW0uZ29vZ2xlYXBpcy5jb20=",highlighted:`!gcloud services enable aiplatform.googleapis.com
!gcloud services enable compute.googleapis.com
!gcloud services enable container.googleapis.com
!gcloud services enable containerregistry.googleapis.com
!gcloud services enable containerfilesystem.googleapis.com`,wrap:!1}}),E=new J({props:{title:"Optional: Create bucket and upload model from Hub in GCS",local:"optional-create-bucket-and-upload-model-from-hub-in-gcs",headingTag:"h2"}}),F=new T({props:{code:"IWdjbG91ZCUyMGNvbXBvbmVudHMlMjBpbnN0YWxsJTIwZ3N1dGlsJTBBIXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwY3JjbW9k",highlighted:`!gcloud components install gsutil
!pip install --upgrade --quiet crcmod`,wrap:!1}}),H=new T({props:{code:"JTI1JTI1YmFzaCUwQSUwQSUyMyUyMFBhcnNlJTIwdGhlJTIwYnVja2V0JTIwZnJvbSUyMHRoZSUyMHByb3ZpZGVkJTIwJTI0QlVDS0VUX1VSSSUyMHBhdGglMjBpLmUuJTIwZ2l2ZW4lMjBncyUzQSUyRiUyRmJ1Y2tldC1uYW1lJTJGZGlyJTJDJTIwZXh0cmFjdCUyMGJ1Y2tldC1uYW1lJTBBQlVDS0VUX05BTUUlM0QlMjQoZWNobyUyMCUyNEJVQ0tFVF9VUkklMjAlN0MlMjBjdXQlMjAtZCclMkYnJTIwLWYzKSUwQSUyMyUyMENoZWNrJTIwaWYlMjB0aGUlMjBidWNrZXQlMjBleGlzdHMlMkMlMjBpZiUyMG5vdCUyMGNyZWF0ZSUyMGl0JTBBaWYlMjAlNUIlMjAteiUyMCUyMiUyNChnc3V0aWwlMjBscyUyMCU3QyUyMGdyZXAlMjBncyUzQSUyRiUyRiUyNEJVQ0tFVF9OQU1FKSUyMiUyMCU1RCUzQiUyMHRoZW4lMEElMjAlMjAlMjAlMjBnY2xvdWQlMjBzdG9yYWdlJTIwYnVja2V0cyUyMGNyZWF0ZSUyMGdzJTNBJTJGJTJGJTI0QlVDS0VUX05BTUUlMjAtLXByb2plY3QlM0QlMjRQUk9KRUNUX0lEJTIwLS1sb2NhdGlvbiUzRCUyNExPQ0FUSU9OJTIwLS1kZWZhdWx0LXN0b3JhZ2UtY2xhc3MlM0RTVEFOREFSRCUyMC0tdW5pZm9ybS1idWNrZXQtbGV2ZWwtYWNjZXNzJTBBZmk=",highlighted:`%%bash

<span class="hljs-comment"># Parse the bucket from the provided $BUCKET_URI path i.e. given gs://bucket-name/dir, extract bucket-name</span>
BUCKET_NAME=$(echo $BUCKET_URI | cut -d<span class="hljs-string">&#x27;/&#x27;</span> -f3)
<span class="hljs-comment"># Check if the bucket exists, if not create it</span>
<span class="hljs-keyword">if</span> [ -z <span class="hljs-string">&quot;$(gsutil ls | grep gs://$BUCKET_NAME)&quot;</span> ]; then
    gcloud storage buckets create gs://$BUCKET_NAME --project=$PROJECT_ID --location=$LOCATION --default-storage-<span class="hljs-keyword">class</span>=STANDARD --uniform-bucket-level-access
fi`,wrap:!1}}),Y=new J({props:{title:"Artifact from disk / local storage",local:"artifact-from-disk--local-storage",headingTag:"h3"}}),z=new T({props:{code:"JTI1JTI1YmFzaCUwQSUyMyUyMFVwbG9hZCUyMHRoZSUyMG1vZGVsJTIwdG8lMjBHb29nbGUlMjBDbG91ZCUyMFN0b3JhZ2UlMEFMT0NBTF9ESVIlM0R+JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLWdvb2dsZS0tZ2VtbWEtN2ItaXQlMkZzbmFwc2hvdHMlMkY4YWRhYjZhMzVmZGJjZGFlMGFlNDFhYjFmNzExYjFiYzhkMDU3MjdlJTBBaWYlMjAlNUIlMjAtZCUyMCUyMiUyNExPQ0FMX0RJUiUyMiUyMCU1RCUzQiUyMHRoZW4lMEElMjAlMjAlMjAlMjBnc3V0aWwlMjAtbyUyMEdTVXRpbCUzQXBhcmFsbGVsX2NvbXBvc2l0ZV91cGxvYWRfdGhyZXNob2xkJTNEMTUwTSUyMC1tJTIwY3AlMjAtciUyMCUyNExPQ0FMX0RJUiUyRiolMjAlMjRCVUNLRVRfVVJJJTJGJTI0QVJUSUZBQ1RfTkFNRSUwQWZp",highlighted:`%%bash
<span class="hljs-comment"># Upload the model to Google Cloud Storage</span>
LOCAL_DIR=~/.cache/huggingface/hub/models--google--gemma-7b-it/snapshots/8adab6a35fdbcdae0ae41ab1f711b1bc8d05727e
<span class="hljs-keyword">if</span> [ -d <span class="hljs-string">&quot;$LOCAL_DIR&quot;</span> ]; then
    gsutil -o GSUtil:parallel_composite_upload_threshold=150M -m cp -r $LOCAL_DIR/* $BUCKET_URI/$ARTIFACT_NAME
fi`,wrap:!1}}),D=new J({props:{title:"Artifact from Hugging Face Hub",local:"artifact-from-hugging-face-hub",headingTag:"h3"}}),K=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJodWdnaW5nZmFjZV9odWIlNUJoZl90cmFuc2ZlciU1RCUyMiUyMC0tdXBncmFkZSUyMC0tcXVpZXQ=",highlighted:'!pip install <span class="hljs-string">&quot;huggingface_hub[hf_transfer]&quot;</span> --upgrade --quiet',wrap:!1}}),ee=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGludGVycHJldGVyX2xvZ2luJTBBJTBBaW50ZXJwcmV0ZXJfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> interpreter_login

interpreter_login()`,wrap:!1}}),le=new T({props:{code:"JTI1JTI1YmFzaCUwQSUyMyUyMEVuc3VyZSUyMHRoZSUyMG5lY2Vzc2FyeSUyMGVudmlyb25tZW50JTIwdmFyaWFibGVzJTIwYXJlJTIwc2V0JTBBZXhwb3J0JTIwSEZfSFVCX0VOQUJMRV9IRl9UUkFOU0ZFUiUzRDElMEElMEElMjMlMjAlMjMlMjBDcmVhdGUlMjBhJTIwbG9jYWwlMjBkaXJlY3RvcnklMjB0byUyMHN0b3JlJTIwdGhlJTIwZG93bmxvYWRlZCUyMG1vZGVscyUwQUxPQ0FMX0RJUiUzRCUyMnRtcCUyRmdvb2dsZS0tZ2VtbWEtN2ItaXQlMjIlMEFta2RpciUyMC1wJTIwJTI0TE9DQUxfRElSJTBBJTBBJTIzJTIwJTIzJTIwRG93bmxvYWQlMjBtb2RlbHMlMjBmcm9tJTIwSHVnZ2luZ0ZhY2UlMkMlMjBleGNsdWRpbmclMjBjZXJ0YWluJTIwZmlsZSUyMHR5cGVzJTBBaHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBnb29nbGUlMkZnZW1tYS03Yi1pdCUyMC0tZXhjbHVkZSUyMCUyMiouYmluJTIyJTIwJTIyKi5wdGglMjIlMjAlMjIqLmdndWYlMjIlMjAlMjIuZ2l0YXR0cmlidXRlcyUyMiUyMC0tbG9jYWwtZGlyJTIwJTI0TE9DQUxfRElSJTBBJTBBJTIzJTIwVXBsb2FkJTIwdGhlJTIwZG93bmxvYWRlZCUyMG1vZGVscyUyMHRvJTIwR29vZ2xlJTIwQ2xvdWQlMjBTdG9yYWdlJTBBZ3N1dGlsJTIwLW8lMjBHU1V0aWwlM0FwYXJhbGxlbF9jb21wb3NpdGVfdXBsb2FkX3RocmVzaG9sZCUzRDE1ME0lMjAtbSUyMGNwJTIwLWUlMjAtciUyMCUyNExPQ0FMX0RJUiUyRiolMjAlMjRCVUNLRVRfVVJJJTJGJTI0QVJUSUZBQ1RfTkFNRSUwQSUwQSUyMyUyMFJlbW92ZSUyMGFsbCUyMGZpbGVzJTIwYW5kJTIwaGlkZGVuJTIwZmlsZXMlMjBpbiUyMHRoZSUyMHRhcmdldCUyMGRpcmVjdG9yeSUwQXJtJTIwLXJmJTIwdG1wJTJG",highlighted:`%%bash
<span class="hljs-comment"># Ensure the necessary environment variables are set</span>
export HF_HUB_ENABLE_HF_TRANSFER=<span class="hljs-number">1</span>

<span class="hljs-comment"># # Create a local directory to store the downloaded models</span>
LOCAL_DIR=<span class="hljs-string">&quot;tmp/google--gemma-7b-it&quot;</span>
mkdir -p $LOCAL_DIR

<span class="hljs-comment"># # Download models from HuggingFace, excluding certain file types</span>
huggingface-cli download google/gemma-7b-it --exclude <span class="hljs-string">&quot;*.bin&quot;</span> <span class="hljs-string">&quot;*.pth&quot;</span> <span class="hljs-string">&quot;*.gguf&quot;</span> <span class="hljs-string">&quot;.gitattributes&quot;</span> --local-<span class="hljs-built_in">dir</span> $LOCAL_DIR

<span class="hljs-comment"># Upload the downloaded models to Google Cloud Storage</span>
gsutil -o GSUtil:parallel_composite_upload_threshold=150M -m cp -e -r $LOCAL_DIR/* $BUCKET_URI/$ARTIFACT_NAME

<span class="hljs-comment"># Remove all files and hidden files in the target directory</span>
rm -rf tmp/`,wrap:!1}}),ae=new J({props:{title:"Register model on Vertex AI",local:"register-model-on-vertex-ai",headingTag:"h2"}}),ie=new T({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwZ29vZ2xlLmNsb3VkJTIwaW1wb3J0JTIwYWlwbGF0Zm9ybSUwQSUwQWFpcGxhdGZvcm0uaW5pdCglMEElMjAlMjAlMjAlMjBwcm9qZWN0JTNEb3MuZ2V0ZW52KCUyMlBST0pFQ1RfSUQlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbG9jYXRpb24lM0Rvcy5nZXRlbnYoJTIyTE9DQVRJT04lMjIpJTJDJTBBJTIwJTIwJTIwJTIwc3RhZ2luZ19idWNrZXQlM0Rvcy5nZXRlbnYoJTIyQlVDS0VUX1VSSSUyMiklMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(
    project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>),
    location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>),
    staging_bucket=os.getenv(<span class="hljs-string">&quot;BUCKET_URI&quot;</span>),
)`,wrap:!1}}),f=new Ql({props:{$$slots:{default:[ls]},$$scope:{ctx:U}}}),de=new T({props:{code:"bW9kZWwlMjAlM0QlMjBhaXBsYXRmb3JtLk1vZGVsLnVwbG9hZCglMEElMjAlMjAlMjAlMjBkaXNwbGF5X25hbWUlM0QlMjJnb29nbGUtLWdlbW1hLTdiLWl0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJ0aWZhY3RfdXJpJTNEZiUyMiU3Qm9zLmdldGVudignQlVDS0VUX1VSSScpJTdEJTJGJTdCb3MuZ2V0ZW52KCdBUlRJRkFDVF9OQU1FJyklN0QlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXJ2aW5nX2NvbnRhaW5lcl9pbWFnZV91cmklM0Rvcy5nZXRlbnYoJTIyQ09OVEFJTkVSX1VSSSUyMiklMkMlMEElMjAlMjAlMjAlMjBzZXJ2aW5nX2NvbnRhaW5lcl9lbnZpcm9ubWVudF92YXJpYWJsZXMlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJOVU1fU0hBUkQlMjIlM0ElMjAlMjIxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0lOUFVUX1RPS0VOUyUyMiUzQSUyMCUyMjUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1BWF9UT1RBTF9UT0tFTlMlMjIlM0ElMjAlMjIxMDI0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0JBVENIX1BSRUZJTExfVE9LRU5TJTIyJTNBJTIwJTIyMTUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMHNlcnZpbmdfY29udGFpbmVyX3BvcnRzJTNEJTVCODA4MCU1RCUyQyUwQSklMEFtb2RlbC53YWl0KCk=",highlighted:`model = aiplatform.Model.upload(
    display_name=<span class="hljs-string">&quot;google--gemma-7b-it&quot;</span>,
    artifact_uri=<span class="hljs-string">f&quot;<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;BUCKET_URI&#x27;</span>)}</span>/<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;ARTIFACT_NAME&#x27;</span>)}</span>&quot;</span>,
    serving_container_image_uri=os.getenv(<span class="hljs-string">&quot;CONTAINER_URI&quot;</span>),
    serving_container_environment_variables={
        <span class="hljs-string">&quot;NUM_SHARD&quot;</span>: <span class="hljs-string">&quot;1&quot;</span>,
        <span class="hljs-string">&quot;MAX_INPUT_TOKENS&quot;</span>: <span class="hljs-string">&quot;512&quot;</span>,
        <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1024&quot;</span>,
        <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1512&quot;</span>,
    },
    serving_container_ports=[<span class="hljs-number">8080</span>],
)
model.wait()`,wrap:!1}}),he=new J({props:{title:"Deploy model on Vertex AI",local:"deploy-model-on-vertex-ai",headingTag:"h2"}}),ge=new T({props:{code:"ZW5kcG9pbnQlMjAlM0QlMjBhaXBsYXRmb3JtLkVuZHBvaW50LmNyZWF0ZShkaXNwbGF5X25hbWUlM0QlMjJnb29nbGUtLWdlbW1hLTdiLWl0LWVuZHBvaW50JTIyKQ==",highlighted:'endpoint = aiplatform.Endpoint.create(display_name=<span class="hljs-string">&quot;google--gemma-7b-it-endpoint&quot;</span>)',wrap:!1}}),Ie=new T({props:{code:"ZGVwbG95ZWRfbW9kZWwlMjAlM0QlMjBtb2RlbC5kZXBsb3koJTBBJTIwJTIwJTIwJTIwZW5kcG9pbnQlM0RlbmRwb2ludCUyQyUwQSUyMCUyMCUyMCUyMG1hY2hpbmVfdHlwZSUzRCUyMmcyLXN0YW5kYXJkLTQlMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvcl90eXBlJTNEJTIyTlZJRElBX0w0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3JfY291bnQlM0QxJTJDJTBBKQ==",highlighted:`deployed_model = model.deploy(
    endpoint=endpoint,
    machine_type=<span class="hljs-string">&quot;g2-standard-4&quot;</span>,
    accelerator_type=<span class="hljs-string">&quot;NVIDIA_L4&quot;</span>,
    accelerator_count=<span class="hljs-number">1</span>,
)`,wrap:!1}}),Ge=new J({props:{title:"Online predictions on Vertex AI",local:"online-predictions-on-vertex-ai",headingTag:"h2"}}),Ve=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwdHJhbnNmb3JtZXJz",highlighted:"!pip install --upgrade --quiet transformers",wrap:!1}}),xe=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF90b2tlbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZ2VtbWEtN2ItaXQlMjIlMkMlMjB0b2tlbiUzRGdldF90b2tlbigpKSUwQSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCdzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTIyJTdEJTJDJTBBJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUwQSklMEElMjMlMjAlM0Nib3MlM0UlM0NzdGFydF9vZl90dXJuJTNFdXNlciU1Q25XaGF0J3MlMjBEZWVwJTIwTGVhcm5pbmclM0YlM0NlbmRfb2ZfdHVybiUzRSU1Q24lM0NzdGFydF9vZl90dXJuJTNFbW9kZWwlNUNu",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_token
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-7b-it&quot;</span>, token=get_token())

messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s Deep Learning?&quot;</span>},
]

inputs = tokenizer.apply_chat_template(
    messages,
    tokenize=<span class="hljs-literal">False</span>,
    add_generation_prompt=<span class="hljs-literal">True</span>,
)
<span class="hljs-comment"># &lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n</span>`,wrap:!1}}),Re=new J({props:{title:"Via Python",local:"via-python",headingTag:"h3"}}),_e=new J({props:{title:"Within the same session",local:"within-the-same-session",headingTag:"h4"}}),Ne=new T({props:{code:"b3V0cHV0JTIwJTNEJTIwZGVwbG95ZWRfbW9kZWwucHJlZGljdCglMEElMjAlMjAlMjAlMjBpbnN0YW5jZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnB1dHMlMjIlM0ElMjAlMjIlM0Nib3MlM0UlM0NzdGFydF9vZl90dXJuJTNFdXNlciU1Q25XaGF0J3MlMjBEZWVwJTIwTGVhcm5pbmclM0YlM0NlbmRfb2ZfdHVybiUzRSU1Q24lM0NzdGFydF9vZl90dXJuJTNFbW9kZWwlNUNuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1ldGVycyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1heF9uZXdfdG9rZW5zJTIyJTNBJTIwMjU2JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZG9fc2FtcGxlJTIyJTNBJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRvcF9wJTIyJTNBJTIwMC45NSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRlbXBlcmF0dXJlJTIyJTNBJTIwMS4wJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQXByaW50KG91dHB1dC5wcmVkaWN0aW9ucyU1QjAlNUQp",highlighted:`output = deployed_model.predict(
    instances=[
        {
            <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;&lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">256</span>,
                <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
                <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">0.95</span>,
                <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>,
            },
        },
    ]
)
<span class="hljs-built_in">print</span>(output.predictions[<span class="hljs-number">0</span>])`,wrap:!1}}),Xe=new T({props:{code:"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",highlighted:'<span class="hljs-constructor">Prediction(<span class="hljs-params">predictions</span>=[&#x27;\\<span class="hljs-params">n</span>\\<span class="hljs-params">nDeep</span> <span class="hljs-params">learning</span> <span class="hljs-params">is</span> <span class="hljs-params">a</span> <span class="hljs-params">type</span> <span class="hljs-params">of</span> <span class="hljs-params">machine</span> <span class="hljs-params">learning</span> <span class="hljs-params">that</span> <span class="hljs-params">uses</span> <span class="hljs-params">artificial</span> <span class="hljs-params">neural</span> <span class="hljs-params">networks</span> <span class="hljs-params">to</span> <span class="hljs-params">learn</span> <span class="hljs-params">from</span> <span class="hljs-params">large</span> <span class="hljs-params">amounts</span> <span class="hljs-params">of</span> <span class="hljs-params">data</span>, <span class="hljs-params">making</span> <span class="hljs-params">it</span> <span class="hljs-params">a</span> <span class="hljs-params">powerful</span> <span class="hljs-params">tool</span> <span class="hljs-params">for</span> <span class="hljs-params">various</span> <span class="hljs-params">tasks</span>, <span class="hljs-params">including</span> <span class="hljs-params">image</span> <span class="hljs-params">recognition</span>, <span class="hljs-params">natural</span> <span class="hljs-params">language</span> <span class="hljs-params">processing</span>, <span class="hljs-params">and</span> <span class="hljs-params">speech</span> <span class="hljs-params">recognition</span>.\\<span class="hljs-params">n</span>\\<span class="hljs-params">n</span><span class="hljs-operator">**</span>Key Concepts:<span class="hljs-operator">**</span>\\<span class="hljs-params">n</span>\\<span class="hljs-params">n</span><span class="hljs-operator">*</span> <span class="hljs-operator">**</span>Artificial Neural Networks (ANNs)</span>:** Structures that mimic the interconnected neurons <span class="hljs-keyword">in</span> the brain.\\n* **Deep Learning Architectures:** Multi-layered ANNs that learn hierarchical features from data.\\n* **Transfer Learning:** Reusing learned features from one task <span class="hljs-keyword">to</span> improve performance on another.\\n\\n**Types <span class="hljs-keyword">of</span> Deep Learning:**\\n\\n* **Supervised Learning:** Models are trained on labeled data, where inputs are paired <span class="hljs-keyword">with</span> corresponding outputs.\\n* **Unsupervised Learning:** Models learn patterns from unlabeled data, such <span class="hljs-keyword">as</span> clustering <span class="hljs-keyword">or</span> dimensionality reduction.\\n* **Reinforcement Learning:** Models learn through trial-<span class="hljs-keyword">and</span>-error by interacting <span class="hljs-keyword">with</span> an environment <span class="hljs-keyword">to</span> optimize a task.\\n\\n**Benefits:**\\n\\n* **High Accuracy:** Deep learning models can achieve high accuracy on complex tasks.\\n* **Adaptability:** Deep learning models can adapt <span class="hljs-keyword">to</span> <span class="hljs-keyword">new</span> data <span class="hljs-keyword">and</span> tasks.\\n* **Scalability:** Deep learning models can handle large amounts <span class="hljs-keyword">of</span> data.\\n\\n**Applications:**\\n\\n* Image recognition\\n* Natural language processing (NLP)\\n&#x27;], deployed_model_id=&#x27;***&#x27;, metadata=None, model_version_id=<span class="hljs-character">&#x27;1&#x27;</span>, model_resource_name=&#x27;projects<span class="hljs-comment">/***/</span>locations/us-central1/models<span class="hljs-comment">/***&#x27;, explanations=None)</span>',wrap:!1}}),Se=new J({props:{title:"From a different session",local:"from-a-different-session",headingTag:"h4"}}),j=new Ql({props:{$$slots:{default:[ns]},$$scope:{ctx:U}}}),Qe=new T({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwZ29vZ2xlLmNsb3VkJTIwaW1wb3J0JTIwYWlwbGF0Zm9ybSUwQSUwQWFpcGxhdGZvcm0uaW5pdChwcm9qZWN0JTNEb3MuZ2V0ZW52KCUyMlBST0pFQ1RfSUQlMjIpJTJDJTIwbG9jYXRpb24lM0Rvcy5nZXRlbnYoJTIyTE9DQVRJT04lMjIpKSUwQSUwQWVuZHBvaW50X2Rpc3BsYXlfbmFtZSUyMCUzRCUyMCUyMmdvb2dsZS0tZ2VtbWEtN2ItaXQtZW5kcG9pbnQlMjIlMjAlMjAlMjMlMjBUT0RPJTNBJTIwY2hhbmdlJTIwdG8lMjB5b3VyJTIwZW5kcG9pbnQlMjBkaXNwbGF5JTIwbmFtZSUwQSUwQSUyMyUyMEl0ZXJhdGVzJTIwb3ZlciUyMGFsbCUyMHRoZSUyMFZlcnRleCUyMEFJJTIwRW5kcG9pbnRzJTIwd2l0aGluJTIwdGhlJTIwY3VycmVudCUyMHByb2plY3QlMjBhbmQlMjBrZWVwcyUyMHRoZSUyMGZpcnN0JTIwbWF0Y2glMjAoaWYlMjBhbnkpJTJDJTIwb3RoZXJ3aXNlJTIwc2V0JTIwdG8lMjBOb25lJTBBRU5EUE9JTlRfSUQlMjAlM0QlMjBuZXh0KCUwQSUyMCUyMCUyMCUyMChlbmRwb2ludC5uYW1lJTIwZm9yJTIwZW5kcG9pbnQlMjBpbiUyMGFpcGxhdGZvcm0uRW5kcG9pbnQubGlzdCgpJTIwaWYlMjBlbmRwb2ludC5kaXNwbGF5X25hbWUlMjAlM0QlM0QlMjBlbmRwb2ludF9kaXNwbGF5X25hbWUpJTJDJTIwTm9uZSUwQSklMEFhc3NlcnQlMjBFTkRQT0lOVF9JRCUyQyUyMCglMEElMjAlMjAlMjAlMjAlMjIlNjBFTkRQT0lOVF9JRCU2MCUyMGlzJTIwbm90JTIwc2V0JTJDJTIwcGxlYXNlJTIwbWFrZSUyMHN1cmUlMjB0aGF0JTIwdGhlJTIwJTYwZW5kcG9pbnRfZGlzcGxheV9uYW1lJTYwJTIwaXMlMjBjb3JyZWN0JTIwYXQlMjAlMjIlMEElMjAlMjAlMjAlMjBmJTIyaHR0cHMlM0ElMkYlMkZjb25zb2xlLmNsb3VkLmdvb2dsZS5jb20lMkZ2ZXJ0ZXgtYWklMkZvbmxpbmUtcHJlZGljdGlvbiUyRmVuZHBvaW50cyUzRnByb2plY3QlM0QlN0Jvcy5nZXRlbnYoJ1BST0pFQ1RfSUQnKSU3RCUyMiUwQSklMEElMEFlbmRwb2ludCUyMCUzRCUyMGFpcGxhdGZvcm0uRW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwZiUyMnByb2plY3RzJTJGJTdCb3MuZ2V0ZW52KCdQUk9KRUNUX0lEJyklN0QlMkZsb2NhdGlvbnMlMkYlN0Jvcy5nZXRlbnYoJ0xPQ0FUSU9OJyklN0QlMkZlbmRwb2ludHMlMkYlN0JFTkRQT0lOVF9JRCU3RCUyMiUwQSklMEFvdXRwdXQlMjAlM0QlMjBlbmRwb2ludC5wcmVkaWN0KCUwQSUyMCUyMCUyMCUyMGluc3RhbmNlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmlucHV0cyUyMiUzQSUyMCUyMiUzQ2JvcyUzRSUzQ3N0YXJ0X29mX3R1cm4lM0V1c2VyJTVDbldoYXQncyUyMERlZXAlMjBMZWFybmluZyUzRiUzQ2VuZF9vZl90dXJuJTNFJTVDbiUzQ3N0YXJ0X29mX3R1cm4lM0Vtb2RlbCU1Q24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwYXJhbWV0ZXJzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWF4X25ld190b2tlbnMlMjIlM0ElMjAxMjglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkb19zYW1wbGUlMjIlM0ElMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydG9wX3AlMjIlM0ElMjAwLjk1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGVtcGVyYXR1cmUlMjIlM0ElMjAwLjclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEEpJTBBcHJpbnQob3V0cHV0LnByZWRpY3Rpb25zJTVCMCU1RCk=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>), location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>))

endpoint_display_name = <span class="hljs-string">&quot;google--gemma-7b-it-endpoint&quot;</span>  <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> change to your endpoint display name</span>

<span class="hljs-comment"># Iterates over all the Vertex AI Endpoints within the current project and keeps the first match (if any), otherwise set to None</span>
ENDPOINT_ID = <span class="hljs-built_in">next</span>(
    (endpoint.name <span class="hljs-keyword">for</span> endpoint <span class="hljs-keyword">in</span> aiplatform.Endpoint.<span class="hljs-built_in">list</span>() <span class="hljs-keyword">if</span> endpoint.display_name == endpoint_display_name), <span class="hljs-literal">None</span>
)
<span class="hljs-keyword">assert</span> ENDPOINT_ID, (
    <span class="hljs-string">&quot;\`ENDPOINT_ID\` is not set, please make sure that the \`endpoint_display_name\` is correct at &quot;</span>
    <span class="hljs-string">f&quot;https://console.cloud.google.com/vertex-ai/online-prediction/endpoints?project=<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;PROJECT_ID&#x27;</span>)}</span>&quot;</span>
)

endpoint = aiplatform.Endpoint(
    <span class="hljs-string">f&quot;projects/<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;PROJECT_ID&#x27;</span>)}</span>/locations/<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;LOCATION&#x27;</span>)}</span>/endpoints/<span class="hljs-subst">{ENDPOINT_ID}</span>&quot;</span>
)
output = endpoint.predict(
    instances=[
        {
            <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;&lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">128</span>,
                <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
                <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">0.95</span>,
                <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>,
            },
        },
    ],
)
<span class="hljs-built_in">print</span>(output.predictions[<span class="hljs-number">0</span>])`,wrap:!1}}),He=new J({props:{title:"Via the Vertex AI Online Prediction UI",local:"via-the-vertex-ai-online-prediction-ui",headingTag:"h3"}}),Ye=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyaW5zdGFuY2VzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyJTNDYm9zJTNFJTNDc3RhcnRfb2ZfdHVybiUzRXVzZXIlNUNuV2hhdCdzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTNDZW5kX29mX3R1cm4lM0UlNUNuJTNDc3RhcnRfb2ZfdHVybiUzRW1vZGVsJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDEyOCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRvX3NhbXBsZSUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b3BfcCUyMiUzQSUyMDAuOTUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZW1wZXJhdHVyZSUyMiUzQSUyMDAuNyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;instances&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                <span class="hljs-attr">&quot;max_new_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">128</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;do_sample&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;top_p&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.95</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;temperature&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.7</span>
            <span class="hljs-punctuation">}</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ze=new J({props:{title:"Resource clean-up",local:"resource-clean-up",headingTag:"h2"}}),b=new Ql({props:{$$slots:{default:[ss]},$$scope:{ctx:U}}}),Oe=new T({props:{code:"ZGVwbG95ZWRfbW9kZWwudW5kZXBsb3lfYWxsKCklMEFkZXBsb3llZF9tb2RlbC5kZWxldGUoKSUwQW1vZGVsLmRlbGV0ZSgp",highlighted:`deployed_model.undeploy_all()
deployed_model.delete()
model.delete()`,wrap:!1}}),lt=new T({props:{code:"IWdjbG91ZCUyMHN0b3JhZ2UlMjBybSUyMC1yJTIwJTI0QlVDS0VUX1VSSQ==",highlighted:"!gcloud storage rm -r $BUCKET_URI",wrap:!1}}),nt=new J({props:{title:"Or, alternatively, just remove the bucket and/or its contents from the Google Cloud Console.",local:"or-alternatively-just-remove-the-bucket-andor-its-contents-from-the-google-cloud-console",headingTag:"h2"}}),I=new Ql({props:{$$slots:{default:[as]},$$scope:{ctx:U}}}),st=new ts({props:{source:"https://github.com/huggingface/Google-Cloud-Containers/blob/main/docs/source/examples/vertex-ai-notebooks-deploy-gemma-from-gcs-on-vertex-ai.mdx"}}),{c(){r=o("meta"),g=s(),y=o("p"),w=s(),c(C.$$.fragment),ot=s(),v=o("p"),v.textContent=Ll,it=s(),Z=o("p"),Z.innerHTML=Yl,pt=s(),G=o("p"),G.innerHTML=ql,rt=s(),c($.$$.fragment),ct=s(),A=o("p"),A.innerHTML=zl,Mt=s(),V=o("p"),V.innerHTML=Dl,dt=s(),c(B.$$.fragment),mt=s(),x=o("p"),x.textContent=Pl,ut=s(),c(k.$$.fragment),ht=s(),R=o("p"),R.textContent=Ol,yt=s(),c(_.$$.fragment),Tt=s(),W=o("p"),W.textContent=Kl,gt=s(),c(N.$$.fragment),Jt=s(),c(E.$$.fragment),wt=s(),X=o("p"),X.textContent=en,Ut=s(),S=o("p"),S.innerHTML=tn,ft=s(),c(F.$$.fragment),jt=s(),Q=o("p"),Q.textContent=ln,bt=s(),c(H.$$.fragment),It=s(),L=o("p"),L.innerHTML=nn,Ct=s(),c(Y.$$.fragment),vt=s(),q=o("p"),q.innerHTML=sn,Zt=s(),c(z.$$.fragment),Gt=s(),c(D.$$.fragment),$t=s(),P=o("p"),P.innerHTML=an,At=s(),O=o("p"),O.innerHTML=on,Vt=s(),c(K.$$.fragment),Bt=s(),c(ee.$$.fragment),xt=s(),te=o("p"),te.innerHTML=pn,kt=s(),c(le.$$.fragment),Rt=s(),ne=o("p"),ne.innerHTML=rn,_t=s(),se=o("p"),se.innerHTML=cn,Wt=s(),c(ae.$$.fragment),Nt=s(),oe=o("p"),oe.innerHTML=Mn,Et=s(),c(ie.$$.fragment),Xt=s(),pe=o("p"),pe.textContent=dn,St=s(),re=o("p"),re.innerHTML=mn,Ft=s(),ce=o("ul"),ce.innerHTML=un,Qt=s(),Me=o("p"),Me.innerHTML=hn,Ht=s(),c(f.$$.fragment),Lt=s(),c(de.$$.fragment),Yt=s(),me=o("p"),me.innerHTML=yn,qt=s(),ue=o("p"),ue.innerHTML=Tn,zt=s(),c(he.$$.fragment),Dt=s(),ye=o("p"),ye.textContent=gn,Pt=s(),Te=o("p"),Te.innerHTML=Jn,Ot=s(),c(ge.$$.fragment),Kt=s(),Je=o("p"),Je.innerHTML=wn,el=s(),we=o("p"),we.textContent=Un,tl=s(),Ue=o("p"),Ue.innerHTML=fn,ll=s(),fe=o("p"),fe.innerHTML=jn,nl=s(),je=o("ul"),je.innerHTML=bn,sl=s(),be=o("p"),be.innerHTML=In,al=s(),c(Ie.$$.fragment),ol=s(),Ce=o("p"),Ce.innerHTML=Cn,il=s(),ve=o("p"),ve.innerHTML=vn,pl=s(),Ze=o("p"),Ze.innerHTML=Zn,rl=s(),c(Ge.$$.fragment),cl=s(),$e=o("p"),$e.innerHTML=Gn,Ml=s(),Ae=o("p"),Ae.innerHTML=$n,dl=s(),c(Ve.$$.fragment),ml=s(),Be=o("p"),Be.textContent=An,ul=s(),c(xe.$$.fragment),hl=s(),ke=o("p"),ke.innerHTML=Vn,yl=s(),c(Re.$$.fragment),Tl=s(),c(_e.$$.fragment),gl=s(),We=o("p"),We.innerHTML=Bn,Jl=s(),c(Ne.$$.fragment),wl=s(),Ee=o("p"),Ee.innerHTML=xn,Ul=s(),c(Xe.$$.fragment),fl=s(),c(Se.$$.fragment),jl=s(),Fe=o("p"),Fe.innerHTML=kn,bl=s(),c(j.$$.fragment),Il=s(),c(Qe.$$.fragment),Cl=s(),c(He.$$.fragment),vl=s(),Le=o("p"),Le.textContent=Rn,Zl=s(),c(Ye.$$.fragment),Gl=s(),qe=o("p"),qe.innerHTML=_n,$l=s(),c(ze.$$.fragment),Al=s(),De=o("p"),De.textContent=Wn,Vl=s(),Pe=o("ul"),Pe.innerHTML=Nn,Bl=s(),c(b.$$.fragment),xl=s(),c(Oe.$$.fragment),kl=s(),Ke=o("p"),Ke.textContent=En,Rl=s(),et=o("ul"),et.innerHTML=Xn,_l=s(),tt=o("p"),tt.innerHTML=Sn,Wl=s(),c(lt.$$.fragment),Nl=s(),c(nt.$$.fragment),El=s(),c(I.$$.fragment),Xl=s(),c(st.$$.fragment),Sl=s(),at=o("p"),this.h()},l(e){const t=Kn("svelte-u9bgzb",document.head);r=i(t,"META",{name:!0,content:!0}),t.forEach(l),g=a(e),y=i(e,"P",{}),Yn(y).forEach(l),w=a(e),M(C.$$.fragment,e),ot=a(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-9afh3f"&&(v.textContent=Ll),it=a(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-ghxzxz"&&(Z.innerHTML=Yl),pt=a(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1tfb3hf"&&(G.innerHTML=ql),rt=a(e),M($.$$.fragment,e),ct=a(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1o67gfb"&&(A.innerHTML=zl),Mt=a(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1ebrquh"&&(V.innerHTML=Dl),dt=a(e),M(B.$$.fragment,e),mt=a(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1i8n6rq"&&(x.textContent=Pl),ut=a(e),M(k.$$.fragment,e),ht=a(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-15nvzfz"&&(R.textContent=Ol),yt=a(e),M(_.$$.fragment,e),Tt=a(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1nm8o2l"&&(W.textContent=Kl),gt=a(e),M(N.$$.fragment,e),Jt=a(e),M(E.$$.fragment,e),wt=a(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1ytajks"&&(X.textContent=en),Ut=a(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-e12o6k"&&(S.innerHTML=tn),ft=a(e),M(F.$$.fragment,e),jt=a(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-cxcyab"&&(Q.textContent=ln),bt=a(e),M(H.$$.fragment,e),It=a(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-d11vo2"&&(L.innerHTML=nn),Ct=a(e),M(Y.$$.fragment,e),vt=a(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-sdydm2"&&(q.innerHTML=sn),Zt=a(e),M(z.$$.fragment,e),Gt=a(e),M(D.$$.fragment,e),$t=a(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-p7l1hu"&&(P.innerHTML=an),At=a(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1c2zn5r"&&(O.innerHTML=on),Vt=a(e),M(K.$$.fragment,e),Bt=a(e),M(ee.$$.fragment,e),xt=a(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1mqzlv7"&&(te.innerHTML=pn),kt=a(e),M(le.$$.fragment,e),Rt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1nja5im"&&(ne.innerHTML=rn),_t=a(e),se=i(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1kl2jg3"&&(se.innerHTML=cn),Wt=a(e),M(ae.$$.fragment,e),Nt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-14aynbe"&&(oe.innerHTML=Mn),Et=a(e),M(ie.$$.fragment,e),Xt=a(e),pe=i(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-nto2bx"&&(pe.textContent=dn),St=a(e),re=i(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-zklutt"&&(re.innerHTML=mn),Ft=a(e),ce=i(e,"UL",{"data-svelte-h":!0}),p(ce)!=="svelte-1fb4x93"&&(ce.innerHTML=un),Qt=a(e),Me=i(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1flszm1"&&(Me.innerHTML=hn),Ht=a(e),M(f.$$.fragment,e),Lt=a(e),M(de.$$.fragment,e),Yt=a(e),me=i(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-wh1hoy"&&(me.innerHTML=yn),qt=a(e),ue=i(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1qp0mlv"&&(ue.innerHTML=Tn),zt=a(e),M(he.$$.fragment,e),Dt=a(e),ye=i(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-2nwexf"&&(ye.textContent=gn),Pt=a(e),Te=i(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-1lovlvw"&&(Te.innerHTML=Jn),Ot=a(e),M(ge.$$.fragment,e),Kt=a(e),Je=i(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-1oxifpd"&&(Je.innerHTML=wn),el=a(e),we=i(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-it668a"&&(we.textContent=Un),tl=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-njbdvc"&&(Ue.innerHTML=fn),ll=a(e),fe=i(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-v5hhrl"&&(fe.innerHTML=jn),nl=a(e),je=i(e,"UL",{"data-svelte-h":!0}),p(je)!=="svelte-1mv29i5"&&(je.innerHTML=bn),sl=a(e),be=i(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-9p37qa"&&(be.innerHTML=In),al=a(e),M(Ie.$$.fragment,e),ol=a(e),Ce=i(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-mraq68"&&(Ce.innerHTML=Cn),il=a(e),ve=i(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-10wybi0"&&(ve.innerHTML=vn),pl=a(e),Ze=i(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-ffexfv"&&(Ze.innerHTML=Zn),rl=a(e),M(Ge.$$.fragment,e),cl=a(e),$e=i(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-166ya0u"&&($e.innerHTML=Gn),Ml=a(e),Ae=i(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-17alodq"&&(Ae.innerHTML=$n),dl=a(e),M(Ve.$$.fragment,e),ml=a(e),Be=i(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-rj4r5t"&&(Be.textContent=An),ul=a(e),M(xe.$$.fragment,e),hl=a(e),ke=i(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-nq4b4r"&&(ke.innerHTML=Vn),yl=a(e),M(Re.$$.fragment,e),Tl=a(e),M(_e.$$.fragment,e),gl=a(e),We=i(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-hnmp6i"&&(We.innerHTML=Bn),Jl=a(e),M(Ne.$$.fragment,e),wl=a(e),Ee=i(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-d9pmg3"&&(Ee.innerHTML=xn),Ul=a(e),M(Xe.$$.fragment,e),fl=a(e),M(Se.$$.fragment,e),jl=a(e),Fe=i(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-gm5hxo"&&(Fe.innerHTML=kn),bl=a(e),M(j.$$.fragment,e),Il=a(e),M(Qe.$$.fragment,e),Cl=a(e),M(He.$$.fragment,e),vl=a(e),Le=i(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-1ajbcx5"&&(Le.textContent=Rn),Zl=a(e),M(Ye.$$.fragment,e),Gl=a(e),qe=i(e,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-13ph86t"&&(qe.innerHTML=_n),$l=a(e),M(ze.$$.fragment,e),Al=a(e),De=i(e,"P",{"data-svelte-h":!0}),p(De)!=="svelte-l6tvv1"&&(De.textContent=Wn),Vl=a(e),Pe=i(e,"UL",{"data-svelte-h":!0}),p(Pe)!=="svelte-16ibgml"&&(Pe.innerHTML=Nn),Bl=a(e),M(b.$$.fragment,e),xl=a(e),M(Oe.$$.fragment,e),kl=a(e),Ke=i(e,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-sgegyq"&&(Ke.textContent=En),Rl=a(e),et=i(e,"UL",{"data-svelte-h":!0}),p(et)!=="svelte-1p833nz"&&(et.innerHTML=Xn),_l=a(e),tt=i(e,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-1akxsu0"&&(tt.innerHTML=Sn),Wl=a(e),M(lt.$$.fragment,e),Nl=a(e),M(nt.$$.fragment,e),El=a(e),M(I.$$.fragment,e),Xl=a(e),M(st.$$.fragment,e),Sl=a(e),at=i(e,"P",{}),Yn(at).forEach(l),this.h()},h(){qn(r,"name","hf:doc:metadata"),qn(r,"content",is)},m(e,t){es(document.head,r),n(e,g,t),n(e,y,t),n(e,w,t),d(C,e,t),n(e,ot,t),n(e,v,t),n(e,it,t),n(e,Z,t),n(e,pt,t),n(e,G,t),n(e,rt,t),d($,e,t),n(e,ct,t),n(e,A,t),n(e,Mt,t),n(e,V,t),n(e,dt,t),d(B,e,t),n(e,mt,t),n(e,x,t),n(e,ut,t),d(k,e,t),n(e,ht,t),n(e,R,t),n(e,yt,t),d(_,e,t),n(e,Tt,t),n(e,W,t),n(e,gt,t),d(N,e,t),n(e,Jt,t),d(E,e,t),n(e,wt,t),n(e,X,t),n(e,Ut,t),n(e,S,t),n(e,ft,t),d(F,e,t),n(e,jt,t),n(e,Q,t),n(e,bt,t),d(H,e,t),n(e,It,t),n(e,L,t),n(e,Ct,t),d(Y,e,t),n(e,vt,t),n(e,q,t),n(e,Zt,t),d(z,e,t),n(e,Gt,t),d(D,e,t),n(e,$t,t),n(e,P,t),n(e,At,t),n(e,O,t),n(e,Vt,t),d(K,e,t),n(e,Bt,t),d(ee,e,t),n(e,xt,t),n(e,te,t),n(e,kt,t),d(le,e,t),n(e,Rt,t),n(e,ne,t),n(e,_t,t),n(e,se,t),n(e,Wt,t),d(ae,e,t),n(e,Nt,t),n(e,oe,t),n(e,Et,t),d(ie,e,t),n(e,Xt,t),n(e,pe,t),n(e,St,t),n(e,re,t),n(e,Ft,t),n(e,ce,t),n(e,Qt,t),n(e,Me,t),n(e,Ht,t),d(f,e,t),n(e,Lt,t),d(de,e,t),n(e,Yt,t),n(e,me,t),n(e,qt,t),n(e,ue,t),n(e,zt,t),d(he,e,t),n(e,Dt,t),n(e,ye,t),n(e,Pt,t),n(e,Te,t),n(e,Ot,t),d(ge,e,t),n(e,Kt,t),n(e,Je,t),n(e,el,t),n(e,we,t),n(e,tl,t),n(e,Ue,t),n(e,ll,t),n(e,fe,t),n(e,nl,t),n(e,je,t),n(e,sl,t),n(e,be,t),n(e,al,t),d(Ie,e,t),n(e,ol,t),n(e,Ce,t),n(e,il,t),n(e,ve,t),n(e,pl,t),n(e,Ze,t),n(e,rl,t),d(Ge,e,t),n(e,cl,t),n(e,$e,t),n(e,Ml,t),n(e,Ae,t),n(e,dl,t),d(Ve,e,t),n(e,ml,t),n(e,Be,t),n(e,ul,t),d(xe,e,t),n(e,hl,t),n(e,ke,t),n(e,yl,t),d(Re,e,t),n(e,Tl,t),d(_e,e,t),n(e,gl,t),n(e,We,t),n(e,Jl,t),d(Ne,e,t),n(e,wl,t),n(e,Ee,t),n(e,Ul,t),d(Xe,e,t),n(e,fl,t),d(Se,e,t),n(e,jl,t),n(e,Fe,t),n(e,bl,t),d(j,e,t),n(e,Il,t),d(Qe,e,t),n(e,Cl,t),d(He,e,t),n(e,vl,t),n(e,Le,t),n(e,Zl,t),d(Ye,e,t),n(e,Gl,t),n(e,qe,t),n(e,$l,t),d(ze,e,t),n(e,Al,t),n(e,De,t),n(e,Vl,t),n(e,Pe,t),n(e,Bl,t),d(b,e,t),n(e,xl,t),d(Oe,e,t),n(e,kl,t),n(e,Ke,t),n(e,Rl,t),n(e,et,t),n(e,_l,t),n(e,tt,t),n(e,Wl,t),d(lt,e,t),n(e,Nl,t),d(nt,e,t),n(e,El,t),d(I,e,t),n(e,Xl,t),d(st,e,t),n(e,Sl,t),n(e,at,t),Fl=!0},p(e,[t]){const Fn={};t&2&&(Fn.$$scope={dirty:t,ctx:e}),f.$set(Fn);const Qn={};t&2&&(Qn.$$scope={dirty:t,ctx:e}),j.$set(Qn);const Hn={};t&2&&(Hn.$$scope={dirty:t,ctx:e}),b.$set(Hn);const Ln={};t&2&&(Ln.$$scope={dirty:t,ctx:e}),I.$set(Ln)},i(e){Fl||(m(C.$$.fragment,e),m($.$$.fragment,e),m(B.$$.fragment,e),m(k.$$.fragment,e),m(_.$$.fragment,e),m(N.$$.fragment,e),m(E.$$.fragment,e),m(F.$$.fragment,e),m(H.$$.fragment,e),m(Y.$$.fragment,e),m(z.$$.fragment,e),m(D.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(f.$$.fragment,e),m(de.$$.fragment,e),m(he.$$.fragment,e),m(ge.$$.fragment,e),m(Ie.$$.fragment,e),m(Ge.$$.fragment,e),m(Ve.$$.fragment,e),m(xe.$$.fragment,e),m(Re.$$.fragment,e),m(_e.$$.fragment,e),m(Ne.$$.fragment,e),m(Xe.$$.fragment,e),m(Se.$$.fragment,e),m(j.$$.fragment,e),m(Qe.$$.fragment,e),m(He.$$.fragment,e),m(Ye.$$.fragment,e),m(ze.$$.fragment,e),m(b.$$.fragment,e),m(Oe.$$.fragment,e),m(lt.$$.fragment,e),m(nt.$$.fragment,e),m(I.$$.fragment,e),m(st.$$.fragment,e),Fl=!0)},o(e){u(C.$$.fragment,e),u($.$$.fragment,e),u(B.$$.fragment,e),u(k.$$.fragment,e),u(_.$$.fragment,e),u(N.$$.fragment,e),u(E.$$.fragment,e),u(F.$$.fragment,e),u(H.$$.fragment,e),u(Y.$$.fragment,e),u(z.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(f.$$.fragment,e),u(de.$$.fragment,e),u(he.$$.fragment,e),u(ge.$$.fragment,e),u(Ie.$$.fragment,e),u(Ge.$$.fragment,e),u(Ve.$$.fragment,e),u(xe.$$.fragment,e),u(Re.$$.fragment,e),u(_e.$$.fragment,e),u(Ne.$$.fragment,e),u(Xe.$$.fragment,e),u(Se.$$.fragment,e),u(j.$$.fragment,e),u(Qe.$$.fragment,e),u(He.$$.fragment,e),u(Ye.$$.fragment,e),u(ze.$$.fragment,e),u(b.$$.fragment,e),u(Oe.$$.fragment,e),u(lt.$$.fragment,e),u(nt.$$.fragment,e),u(I.$$.fragment,e),u(st.$$.fragment,e),Fl=!1},d(e){e&&(l(g),l(y),l(w),l(ot),l(v),l(it),l(Z),l(pt),l(G),l(rt),l(ct),l(A),l(Mt),l(V),l(dt),l(mt),l(x),l(ut),l(ht),l(R),l(yt),l(Tt),l(W),l(gt),l(Jt),l(wt),l(X),l(Ut),l(S),l(ft),l(jt),l(Q),l(bt),l(It),l(L),l(Ct),l(vt),l(q),l(Zt),l(Gt),l($t),l(P),l(At),l(O),l(Vt),l(Bt),l(xt),l(te),l(kt),l(Rt),l(ne),l(_t),l(se),l(Wt),l(Nt),l(oe),l(Et),l(Xt),l(pe),l(St),l(re),l(Ft),l(ce),l(Qt),l(Me),l(Ht),l(Lt),l(Yt),l(me),l(qt),l(ue),l(zt),l(Dt),l(ye),l(Pt),l(Te),l(Ot),l(Kt),l(Je),l(el),l(we),l(tl),l(Ue),l(ll),l(fe),l(nl),l(je),l(sl),l(be),l(al),l(ol),l(Ce),l(il),l(ve),l(pl),l(Ze),l(rl),l(cl),l($e),l(Ml),l(Ae),l(dl),l(ml),l(Be),l(ul),l(hl),l(ke),l(yl),l(Tl),l(gl),l(We),l(Jl),l(wl),l(Ee),l(Ul),l(fl),l(jl),l(Fe),l(bl),l(Il),l(Cl),l(vl),l(Le),l(Zl),l(Gl),l(qe),l($l),l(Al),l(De),l(Vl),l(Pe),l(Bl),l(xl),l(kl),l(Ke),l(Rl),l(et),l(_l),l(tt),l(Wl),l(Nl),l(El),l(Xl),l(Sl),l(at)),l(r),h(C,e),h($,e),h(B,e),h(k,e),h(_,e),h(N,e),h(E,e),h(F,e),h(H,e),h(Y,e),h(z,e),h(D,e),h(K,e),h(ee,e),h(le,e),h(ae,e),h(ie,e),h(f,e),h(de,e),h(he,e),h(ge,e),h(Ie,e),h(Ge,e),h(Ve,e),h(xe,e),h(Re,e),h(_e,e),h(Ne,e),h(Xe,e),h(Se,e),h(j,e),h(Qe,e),h(He,e),h(Ye,e),h(ze,e),h(b,e),h(Oe,e),h(lt,e),h(nt,e),h(I,e),h(st,e)}}}const is='{"title":"Deploy Gemma 7B with TGI DLC from GCS on Vertex AI","local":"deploy-gemma-7b-with-tgi-dlc-from-gcs-on-vertex-ai","sections":[{"title":"Setup / Configuration","local":"setup--configuration","sections":[],"depth":2},{"title":"Optional: Create bucket and upload model from Hub in GCS","local":"optional-create-bucket-and-upload-model-from-hub-in-gcs","sections":[{"title":"Artifact from disk / local storage","local":"artifact-from-disk--local-storage","sections":[],"depth":3},{"title":"Artifact from Hugging Face Hub","local":"artifact-from-hugging-face-hub","sections":[],"depth":3}],"depth":2},{"title":"Register model on Vertex AI","local":"register-model-on-vertex-ai","sections":[],"depth":2},{"title":"Deploy model on Vertex AI","local":"deploy-model-on-vertex-ai","sections":[],"depth":2},{"title":"Online predictions on Vertex AI","local":"online-predictions-on-vertex-ai","sections":[{"title":"Via Python","local":"via-python","sections":[{"title":"Within the same session","local":"within-the-same-session","sections":[],"depth":4},{"title":"From a different session","local":"from-a-different-session","sections":[],"depth":4}],"depth":3},{"title":"Via the Vertex AI Online Prediction UI","local":"via-the-vertex-ai-online-prediction-ui","sections":[],"depth":3}],"depth":2},{"title":"Resource clean-up","local":"resource-clean-up","sections":[],"depth":2},{"title":"Or, alternatively, just remove the bucket and/or its contents from the Google Cloud Console.","local":"or-alternatively-just-remove-the-bucket-andor-its-contents-from-the-google-cloud-console","sections":[],"depth":2}],"depth":1}';function ps(U){return Dn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class us extends Pn{constructor(r){super(),On(this,r,ps,os,zn,{})}}export{us as component};
