import{s as Ct,n as At,o as $t}from"../chunks/scheduler.7bc62968.js";import{S as It,i as vt,g as i,s as l,r,A as xt,h as o,f as n,c as a,j as Ut,u as d,x as c,k as Jt,y as kt,a as s,v as h,d as m,t as p,w as M}from"../chunks/index.66556066.js";import{C as u}from"../chunks/CodeBlock.a759539a.js";import{H as f}from"../chunks/Heading.3f0870db.js";function _t(tt){let b,de,oe,he,y,me,w,pe,T,nt=`DETR is mainly used for object detection tasks, which is the process of detecting objects in an image. For example, the input of the model would be an image of a road, and the output of the model could be <code>[(&#39;car&#39;,X1,Y1,W1,H1),(&#39;pedestrian&#39;,X2,Y2,W2,H2)]</code>, in which X, Y, W, H represent the x, y coordinates denoting the location of the bounding box, as well as the width and height of the box.
A traditional object detection model like YOLO consists of hand-crafted features like anchor box priors, which requires initial guesses of object locations and shapes, affecting downstream training. Post-processing steps are then used to remove overlapping bounding boxes, which require careful selection of its filtering heuristics.
DEtection TRansformer, DETR for short, simplifies the detector by using an encoder-decoder transformer after the feature extraction backbone to directly predict bounding boxes in parallel, requiring minimal post-processing.`,Me,j,st=`<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/DETR.png" alt="Architecture Diagram of DETR"/>
The model architecture of DETR begins with a CNN backbone, similar to other image-based networks, the output of which is processed and fed into a transformer encoder, resulting in N embeddings. The encoder embeddings are added to learned positional embeddings (called object queries) and used in a transformer decoder, generating another N embeddings. As a final step, each of the N embeddings are put through individual feed forward layers to predict the width, height, coordinates of the bounding box, as well as the object class (or whether there is an object).`,ce,g,fe,U,ue,J,lt=`As with other transformers, the transformer encoder expects the output of the CNN backbone to be a sequence. Thus, the feature map of size <code>[dimension, height, width]</code> is downsized and then flattened to <code>[dimension, less than height x width]</code>.
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/DETR_FeatureMaps.png" alt="Feature Maps of Encoder"/> <em><strong>Left</strong>: 12 out of 256 dimensions in the feature maps are visualized. Each dimension extracts some features of the original cat image while downsizing the original image. Some dimensions have a higher focus on the patterns on the cat; some have a higher focus on the bed sheets.</em> <em><strong>Right</strong>: Keeping the original feature dimension of size 256, the width and height are further downsized and flattened into size 850.</em><br/>
Since transformers are permutation invariant, positional embeddings are added to both the encoder and decoder to remind the model where on the image the embeddings come from. In the encoder, fixed positional encodings are used, while in the decoder, learned positional encodings (object queries) are used. Fixed encodings are similar to the ones used in the original Transformer paper, in which the encodings are defined by sinusoidal functions of varying frequencies at different feature dimensions. It gives the sense of position without having any learned parameters, indexed by the position on the image. Learned encodings are also indexed by the positions, but each position has a separate encoding that is learned throughout training to denote the positions in a way that the model understands.`,be,C,ye,A,at="In YOLO, a popular object detection model, the loss function comprises the bounding box, objectness (ie. the probability of an object existing in a region of interest), and class loss. The loss is calculated over multiple bounding boxes per each grid cell, which is a fixed number. On the other hand, in DETR, the architecture is expected to generate unique bounding boxes in a permutation-invariant manner (i.e., the order of the detections does not matter in the output, and the bounding boxes must vary and cannot all be the same). Thus, matching is required to assess how good the predictions are.",we,$,it=`<strong>Bipartite Matching</strong><br/>
Bipartite matching is a way to compute one-on-one matching between the ground truth bounding boxes and the predicted boxes. It finds matches with the highest similarity between ground truth and predicted bounding boxes, as well as classes. This ensures the closest prediction would be matched with the corresponding ground truth in order to properly adjust the boxes and classes in the loss function. If matching is not done, predictions not aligned with the order of the ground truth would be marked as incorrect even if it were correct.`,Te,I,je,v,ot="To see an example of how you can perform inference with DETR using Hugging Face transformers, see <code>DETR.ipynb</code>.",ge,x,Ue,k,Je,_,rt=`Two of the main problems of DETR are a long and slow process of convergence and suboptimal small object detection.
<strong>Deformable Attention</strong><br/>
The first problem is resolved by using deformable attention, which reduces the amount of sampling points to pay attention to. Traditional attention is inefficient due to global attention and heavily limit the resolution that the image can have. The model only attends to a fixed amount of sampling points around each reference point, and the reference points are learned by the model based on the input. For example, in an image of a dog, a reference point may be in the center of the dog, with sampling points near the ears, mouth, tail, etc.`,Ce,E,dt=`<strong>Multi-scale Deformable Attention Module</strong><br/>
The second problem is resolved similarly to YOLOv3, in which multi-scale feature maps are introduced. In convolutional neural networks, earlier layers extract smaller details (ex. lines) while later layers extract larger details (ex. wheels, ears). In a similar manner, different layers of deformable attention result in different levels of resolution. By connecting the outputs of some of these layers from the encoder to the decoder, it allows for the model to detect objects of a multitude of sizes.`,Ae,Z,$e,R,ht=`Conditional DETR also sets out to resolve the problem of slow training convergence in the original DETR, resulting in convergence that is over 6.7 times faster. The authors found that the object queries are general and are not specific to the input image. Using <strong>Conditional Cross-Attention</strong> in the decoder, the queries can better localize the areas for bounding box regression.
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/DETR_DecoderLayer.png" alt="A decoder layer for Deformable DETR"/> <em>Left: DETR Decoder Layer. Right: Deformable DETR Decoder Layer</em><br/>
The original DETR and Deformable DETR decoder layers are compared in the figure above, with the main difference being the query input of the cross-attention block. The authors make a distinction between content query c<sub>q</sub> (decoder self attention output) and spatial query p<sub>q</sub>. The original DETR simply adds them together. In Deformable DETR, they are concatenated, with c<sub>q</sub> focusing on the content of the object and p<sub>q</sub> focusing on the bounding box regions.<br/>
The spatial query p<sub>q</sub> is the result of both the decoder embeddings and object queries projecting to the same space (to become T and p<sub>s</sub> respectively) and multiplied together. The previous layers’ decoder embeddings contain information for the bounding box regions, and the object queries contains information of learned reference points for each bounding box. Thus, their projections combine into a representation that allows for cross-attention to measure their similarities with the encoder input and sinusoidal positional embedding. This is more effective than DETR which only uses object queries and fixed reference points.`,Ie,W,ve,D,mt="The implementation of DETR from the original paper is shown below:",xe,G,ke,B,_e,L,pt=`<strong>Backbone</strong><br/>
The input image is first put through a ResNet backbone and then a convolution layer, which reduces the dimension to the <code>hidden_dim</code>`,Ee,Q,Ze,z,Mt="they are declared in the <code>__init__</code> function",Re,V,We,H,ct="<strong>Positional Embeddings</strong>",De,N,ft="While in the paper fixed and trained embeddings are used in the encoder and decoder respectively, the authors used trained embeddings for both in the implementation for simplicity.",Ge,S,Be,Y,ut="They are declared here as <code>nn.Parameter</code>. The row and column embeddings combined denote the locations in the image.",Le,X,Qe,F,bt=`<strong>Resize</strong><br/>
Before going into the transformer, the features with size <code>(batch size, hidden_dim, H, W)</code> are reshaped to <code>(hidden_dim, batch size, H*W)</code>. This makes them a sequential input for the transformer`,ze,K,Ve,q,yt=`<strong>Transformer</strong><br/>
The <code>nn.Transformer</code> function takes in the first parameter as the input to the encoder, and the second parameter as the input of the encoder. As you can see, the encoder takes in the resized features added to the positional embeddings, while the decoder takes in <code>query_pos</code>, which is the decoder positional embedding.`,He,P,Ne,O,wt=`<strong>Feed-Forward Network</strong><br/>
In the end, the outputs, which is a tensor of size <code>(query_pos_dim, batch size, hidden_dim)</code>, is fed through two linear layers.`,Se,ee,Ye,te,Tt="The first of which predicts the class. An additional class is added for the <code>No Object</code> class",Xe,ne,Fe,se,jt="The second linear layer predicts the bounding box with an output size 4 for the xy coordinates, height and width.",Ke,le,qe,ae,Pe,ie,gt='<li><a href="https://arxiv.org/abs/2005.12872" rel="nofollow">DETR</a></li> <li><a href="https://arxiv.org/abs/1506.02640" rel="nofollow">YOLO</a></li> <li><a href="https://arxiv.org/abs/1804.02767" rel="nofollow">YOLOv3</a></li> <li><a href="https://arxiv.org/abs/2108.06152" rel="nofollow">Conditional DETR</a></li> <li><a href="https://arxiv.org/abs/2010.04159" rel="nofollow">Deformable DETR</a></li> <li><a href="https://huggingface.co/facebook/detr-resnet-50" rel="nofollow"><code>facebook/detr-resnet-50</code></a></li>',Oe,re,et;return y=new f({props:{title:"DEtection TRansformer (DETR)",local:"detection-transformer-detr",headingTag:"h1"}}),w=new f({props:{title:"Overview of architecture",local:"overview-of-architecture",headingTag:"h2"}}),g=new f({props:{title:"Key Features",local:"key-features",headingTag:"h2"}}),U=new f({props:{title:"Encoder-Decoder",local:"encoder-decoder",headingTag:"h3"}}),C=new f({props:{title:"Set-based Global Loss Function",local:"set-based-global-loss-function",headingTag:"h3"}}),I=new f({props:{title:"Using DETR to Detect Objects",local:"using-detr-to-detect-objects",headingTag:"h2"}}),x=new f({props:{title:"Evolution of DETR",local:"evolution-of-detr",headingTag:"h2"}}),k=new f({props:{title:"Deformable DETR",local:"deformable-detr",headingTag:"h3"}}),Z=new f({props:{title:"Conditional DETR",local:"conditional-detr",headingTag:"h3"}}),W=new f({props:{title:"PyTorch Implementation of DETR",local:"pytorch-implementation-of-detr",headingTag:"h2"}}),G=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">from</span> torchvision.models <span class="hljs-keyword">import</span> resnet50


<span class="hljs-keyword">class</span> <span class="hljs-title class_">DETR</span>(nn.Module):

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self, num_classes, hidden_dim, nheads, num_encoder_layers, num_decoder_layers
    </span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.backbone = nn.Sequential(*<span class="hljs-built_in">list</span>(resnet50(pretrained=<span class="hljs-literal">True</span>).children())[:-<span class="hljs-number">2</span>])
        self.conv = nn.Conv2d(<span class="hljs-number">2048</span>, hidden_dim, <span class="hljs-number">1</span>)
        self.transformer = nn.Transformer(
            hidden_dim, nheads, num_encoder_layers, num_decoder_layers
        )
        self.linear_class = nn.Linear(hidden_dim, num_classes + <span class="hljs-number">1</span>)
        self.linear_bbox = nn.Linear(hidden_dim, <span class="hljs-number">4</span>)
        self.query_pos = nn.Parameter(torch.rand(<span class="hljs-number">100</span>, hidden_dim))
        self.row_embed = nn.Parameter(torch.rand(<span class="hljs-number">50</span>, hidden_dim // <span class="hljs-number">2</span>))
        self.col_embed = nn.Parameter(torch.rand(<span class="hljs-number">50</span>, hidden_dim // <span class="hljs-number">2</span>))

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, inputs</span>):
        x = self.backbone(inputs)
        h = self.conv(x)
        H, W = h.shape[-<span class="hljs-number">2</span>:]
        pos = (
            torch.cat(
                [
                    self.col_embed[:W].unsqueeze(<span class="hljs-number">0</span>).repeat(H, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
                    self.row_embed[:H].unsqueeze(<span class="hljs-number">1</span>).repeat(<span class="hljs-number">1</span>, W, <span class="hljs-number">1</span>),
                ],
                dim=-<span class="hljs-number">1</span>,
            )
            .flatten(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>)
            .unsqueeze(<span class="hljs-number">1</span>)
        )
        h = self.transformer(
            pos + h.flatten(<span class="hljs-number">2</span>).permute(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>), self.query_pos.unsqueeze(<span class="hljs-number">1</span>)
        )
        <span class="hljs-keyword">return</span> self.linear_class(h), self.linear_bbox(h).sigmoid()`,wrap:!1}}),B=new f({props:{title:"Going line by line in the forward function:",local:"going-line-by-line-in-the-forward-function",headingTag:"h3"}}),Q=new u({props:{code:"eCUyMCUzRCUyMHNlbGYuYmFja2JvbmUoaW5wdXRzKSUwQWglMjAlM0QlMjBzZWxmLmNvbnYoeCk=",highlighted:`x = self.backbone(inputs)
h = self.conv(x)`,wrap:!1}}),V=new u({props:{code:"c2VsZi5iYWNrYm9uZSUyMCUzRCUyMG5uLlNlcXVlbnRpYWwoKmxpc3QocmVzbmV0NTAocHJldHJhaW5lZCUzRFRydWUpLmNoaWxkcmVuKCkpJTVCJTNBLTIlNUQpJTBBc2VsZi5jb252JTIwJTNEJTIwbm4uQ29udjJkKDIwNDglMkMlMjBoaWRkZW5fZGltJTJDJTIwMSk=",highlighted:`self.backbone = nn.Sequential(*<span class="hljs-built_in">list</span>(resnet50(pretrained=<span class="hljs-literal">True</span>).children())[:-<span class="hljs-number">2</span>])
self.conv = nn.Conv2d(<span class="hljs-number">2048</span>, hidden_dim, <span class="hljs-number">1</span>)`,wrap:!1}}),S=new u({props:{code:"cG9zJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMHRvcmNoLmNhdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmNvbF9lbWJlZCU1QiUzQVclNUQudW5zcXVlZXplKDApLnJlcGVhdChIJTJDJTIwMSUyQyUyMDEpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5yb3dfZW1iZWQlNUIlM0FIJTVELnVuc3F1ZWV6ZSgxKS5yZXBlYXQoMSUyQyUyMFclMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRpbSUzRC0xJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMC5mbGF0dGVuKDAlMkMlMjAxKSUwQSUyMCUyMCUyMCUyMC51bnNxdWVlemUoMSklMEEp",highlighted:`pos = (
    torch.cat(
        [
            self.col_embed[:W].unsqueeze(<span class="hljs-number">0</span>).repeat(H, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
            self.row_embed[:H].unsqueeze(<span class="hljs-number">1</span>).repeat(<span class="hljs-number">1</span>, W, <span class="hljs-number">1</span>),
        ],
        dim=-<span class="hljs-number">1</span>,
    )
    .flatten(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>)
    .unsqueeze(<span class="hljs-number">1</span>)
)`,wrap:!1}}),X=new u({props:{code:"c2VsZi5yb3dfZW1iZWQlMjAlM0QlMjBubi5QYXJhbWV0ZXIodG9yY2gucmFuZCg1MCUyQyUyMGhpZGRlbl9kaW0lMjAlMkYlMkYlMjAyKSklMEFzZWxmLmNvbF9lbWJlZCUyMCUzRCUyMG5uLlBhcmFtZXRlcih0b3JjaC5yYW5kKDUwJTJDJTIwaGlkZGVuX2RpbSUyMCUyRiUyRiUyMDIpKQ==",highlighted:`self.row_embed = nn.Parameter(torch.rand(<span class="hljs-number">50</span>, hidden_dim // <span class="hljs-number">2</span>))
self.col_embed = nn.Parameter(torch.rand(<span class="hljs-number">50</span>, hidden_dim // <span class="hljs-number">2</span>))`,wrap:!1}}),K=new u({props:{code:"aC5mbGF0dGVuKDIpLnBlcm11dGUoMiUyQyUyMDAlMkMlMjAxKQ==",highlighted:'h.flatten(<span class="hljs-number">2</span>).permute(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>)',wrap:!1}}),P=new u({props:{code:"aCUyMCUzRCUyMHNlbGYudHJhbnNmb3JtZXIocG9zJTIwJTJCJTIwaC5mbGF0dGVuKDIpLnBlcm11dGUoMiUyQyUyMDAlMkMlMjAxKSUyQyUyMHNlbGYucXVlcnlfcG9zLnVuc3F1ZWV6ZSgxKSk=",highlighted:'h = self.transformer(pos + h.flatten(<span class="hljs-number">2</span>).permute(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>), self.query_pos.unsqueeze(<span class="hljs-number">1</span>))',wrap:!1}}),ee=new u({props:{code:"cmV0dXJuJTIwc2VsZi5saW5lYXJfY2xhc3MoaCklMkMlMjBzZWxmLmxpbmVhcl9iYm94KGgpLnNpZ21vaWQoKQ==",highlighted:'<span class="hljs-keyword">return</span> self.linear_class(h), self.linear_bbox(h).sigmoid()',wrap:!1}}),ne=new u({props:{code:"c2VsZi5saW5lYXJfY2xhc3MlMjAlM0QlMjBubi5MaW5lYXIoaGlkZGVuX2RpbSUyQyUyMG51bV9jbGFzc2VzJTIwJTJCJTIwMSk=",highlighted:'self.linear_class = nn.Linear(hidden_dim, num_classes + <span class="hljs-number">1</span>)',wrap:!1}}),le=new u({props:{code:"c2VsZi5saW5lYXJfYmJveCUyMCUzRCUyMG5uLkxpbmVhcihoaWRkZW5fZGltJTJDJTIwNCk=",highlighted:'self.linear_bbox = nn.Linear(hidden_dim, <span class="hljs-number">4</span>)',wrap:!1}}),ae=new f({props:{title:"References",local:"references",headingTag:"h2"}}),{c(){b=i("meta"),de=l(),oe=i("p"),he=l(),r(y.$$.fragment),me=l(),r(w.$$.fragment),pe=l(),T=i("p"),T.innerHTML=nt,Me=l(),j=i("p"),j.innerHTML=st,ce=l(),r(g.$$.fragment),fe=l(),r(U.$$.fragment),ue=l(),J=i("p"),J.innerHTML=lt,be=l(),r(C.$$.fragment),ye=l(),A=i("p"),A.textContent=at,we=l(),$=i("p"),$.innerHTML=it,Te=l(),r(I.$$.fragment),je=l(),v=i("p"),v.innerHTML=ot,ge=l(),r(x.$$.fragment),Ue=l(),r(k.$$.fragment),Je=l(),_=i("p"),_.innerHTML=rt,Ce=l(),E=i("p"),E.innerHTML=dt,Ae=l(),r(Z.$$.fragment),$e=l(),R=i("p"),R.innerHTML=ht,Ie=l(),r(W.$$.fragment),ve=l(),D=i("p"),D.textContent=mt,xe=l(),r(G.$$.fragment),ke=l(),r(B.$$.fragment),_e=l(),L=i("p"),L.innerHTML=pt,Ee=l(),r(Q.$$.fragment),Ze=l(),z=i("p"),z.innerHTML=Mt,Re=l(),r(V.$$.fragment),We=l(),H=i("p"),H.innerHTML=ct,De=l(),N=i("p"),N.textContent=ft,Ge=l(),r(S.$$.fragment),Be=l(),Y=i("p"),Y.innerHTML=ut,Le=l(),r(X.$$.fragment),Qe=l(),F=i("p"),F.innerHTML=bt,ze=l(),r(K.$$.fragment),Ve=l(),q=i("p"),q.innerHTML=yt,He=l(),r(P.$$.fragment),Ne=l(),O=i("p"),O.innerHTML=wt,Se=l(),r(ee.$$.fragment),Ye=l(),te=i("p"),te.innerHTML=Tt,Xe=l(),r(ne.$$.fragment),Fe=l(),se=i("p"),se.textContent=jt,Ke=l(),r(le.$$.fragment),qe=l(),r(ae.$$.fragment),Pe=l(),ie=i("ul"),ie.innerHTML=gt,Oe=l(),re=i("p"),this.h()},l(e){const t=xt("svelte-u9bgzb",document.head);b=o(t,"META",{name:!0,content:!0}),t.forEach(n),de=a(e),oe=o(e,"P",{}),Ut(oe).forEach(n),he=a(e),d(y.$$.fragment,e),me=a(e),d(w.$$.fragment,e),pe=a(e),T=o(e,"P",{"data-svelte-h":!0}),c(T)!=="svelte-1uea2cx"&&(T.innerHTML=nt),Me=a(e),j=o(e,"P",{"data-svelte-h":!0}),c(j)!=="svelte-1mj736s"&&(j.innerHTML=st),ce=a(e),d(g.$$.fragment,e),fe=a(e),d(U.$$.fragment,e),ue=a(e),J=o(e,"P",{"data-svelte-h":!0}),c(J)!=="svelte-t8og7r"&&(J.innerHTML=lt),be=a(e),d(C.$$.fragment,e),ye=a(e),A=o(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-12feezj"&&(A.textContent=at),we=a(e),$=o(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-1obgrh7"&&($.innerHTML=it),Te=a(e),d(I.$$.fragment,e),je=a(e),v=o(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-f2wazx"&&(v.innerHTML=ot),ge=a(e),d(x.$$.fragment,e),Ue=a(e),d(k.$$.fragment,e),Je=a(e),_=o(e,"P",{"data-svelte-h":!0}),c(_)!=="svelte-w2zzks"&&(_.innerHTML=rt),Ce=a(e),E=o(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-vzcbkx"&&(E.innerHTML=dt),Ae=a(e),d(Z.$$.fragment,e),$e=a(e),R=o(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1eux0rj"&&(R.innerHTML=ht),Ie=a(e),d(W.$$.fragment,e),ve=a(e),D=o(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-d0cg5t"&&(D.textContent=mt),xe=a(e),d(G.$$.fragment,e),ke=a(e),d(B.$$.fragment,e),_e=a(e),L=o(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-49p96y"&&(L.innerHTML=pt),Ee=a(e),d(Q.$$.fragment,e),Ze=a(e),z=o(e,"P",{"data-svelte-h":!0}),c(z)!=="svelte-1g4lk9n"&&(z.innerHTML=Mt),Re=a(e),d(V.$$.fragment,e),We=a(e),H=o(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-1afjwf9"&&(H.innerHTML=ct),De=a(e),N=o(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-1e5n46h"&&(N.textContent=ft),Ge=a(e),d(S.$$.fragment,e),Be=a(e),Y=o(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-xpw6n2"&&(Y.innerHTML=ut),Le=a(e),d(X.$$.fragment,e),Qe=a(e),F=o(e,"P",{"data-svelte-h":!0}),c(F)!=="svelte-15swqve"&&(F.innerHTML=bt),ze=a(e),d(K.$$.fragment,e),Ve=a(e),q=o(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-b0wrkd"&&(q.innerHTML=yt),He=a(e),d(P.$$.fragment,e),Ne=a(e),O=o(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-bczn5d"&&(O.innerHTML=wt),Se=a(e),d(ee.$$.fragment,e),Ye=a(e),te=o(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-14uu8gr"&&(te.innerHTML=Tt),Xe=a(e),d(ne.$$.fragment,e),Fe=a(e),se=o(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-yoo56g"&&(se.textContent=jt),Ke=a(e),d(le.$$.fragment,e),qe=a(e),d(ae.$$.fragment,e),Pe=a(e),ie=o(e,"UL",{"data-svelte-h":!0}),c(ie)!=="svelte-1ie7nnc"&&(ie.innerHTML=gt),Oe=a(e),re=o(e,"P",{}),Ut(re).forEach(n),this.h()},h(){Jt(b,"name","hf:doc:metadata"),Jt(b,"content",Et)},m(e,t){kt(document.head,b),s(e,de,t),s(e,oe,t),s(e,he,t),h(y,e,t),s(e,me,t),h(w,e,t),s(e,pe,t),s(e,T,t),s(e,Me,t),s(e,j,t),s(e,ce,t),h(g,e,t),s(e,fe,t),h(U,e,t),s(e,ue,t),s(e,J,t),s(e,be,t),h(C,e,t),s(e,ye,t),s(e,A,t),s(e,we,t),s(e,$,t),s(e,Te,t),h(I,e,t),s(e,je,t),s(e,v,t),s(e,ge,t),h(x,e,t),s(e,Ue,t),h(k,e,t),s(e,Je,t),s(e,_,t),s(e,Ce,t),s(e,E,t),s(e,Ae,t),h(Z,e,t),s(e,$e,t),s(e,R,t),s(e,Ie,t),h(W,e,t),s(e,ve,t),s(e,D,t),s(e,xe,t),h(G,e,t),s(e,ke,t),h(B,e,t),s(e,_e,t),s(e,L,t),s(e,Ee,t),h(Q,e,t),s(e,Ze,t),s(e,z,t),s(e,Re,t),h(V,e,t),s(e,We,t),s(e,H,t),s(e,De,t),s(e,N,t),s(e,Ge,t),h(S,e,t),s(e,Be,t),s(e,Y,t),s(e,Le,t),h(X,e,t),s(e,Qe,t),s(e,F,t),s(e,ze,t),h(K,e,t),s(e,Ve,t),s(e,q,t),s(e,He,t),h(P,e,t),s(e,Ne,t),s(e,O,t),s(e,Se,t),h(ee,e,t),s(e,Ye,t),s(e,te,t),s(e,Xe,t),h(ne,e,t),s(e,Fe,t),s(e,se,t),s(e,Ke,t),h(le,e,t),s(e,qe,t),h(ae,e,t),s(e,Pe,t),s(e,ie,t),s(e,Oe,t),s(e,re,t),et=!0},p:At,i(e){et||(m(y.$$.fragment,e),m(w.$$.fragment,e),m(g.$$.fragment,e),m(U.$$.fragment,e),m(C.$$.fragment,e),m(I.$$.fragment,e),m(x.$$.fragment,e),m(k.$$.fragment,e),m(Z.$$.fragment,e),m(W.$$.fragment,e),m(G.$$.fragment,e),m(B.$$.fragment,e),m(Q.$$.fragment,e),m(V.$$.fragment,e),m(S.$$.fragment,e),m(X.$$.fragment,e),m(K.$$.fragment,e),m(P.$$.fragment,e),m(ee.$$.fragment,e),m(ne.$$.fragment,e),m(le.$$.fragment,e),m(ae.$$.fragment,e),et=!0)},o(e){p(y.$$.fragment,e),p(w.$$.fragment,e),p(g.$$.fragment,e),p(U.$$.fragment,e),p(C.$$.fragment,e),p(I.$$.fragment,e),p(x.$$.fragment,e),p(k.$$.fragment,e),p(Z.$$.fragment,e),p(W.$$.fragment,e),p(G.$$.fragment,e),p(B.$$.fragment,e),p(Q.$$.fragment,e),p(V.$$.fragment,e),p(S.$$.fragment,e),p(X.$$.fragment,e),p(K.$$.fragment,e),p(P.$$.fragment,e),p(ee.$$.fragment,e),p(ne.$$.fragment,e),p(le.$$.fragment,e),p(ae.$$.fragment,e),et=!1},d(e){e&&(n(de),n(oe),n(he),n(me),n(pe),n(T),n(Me),n(j),n(ce),n(fe),n(ue),n(J),n(be),n(ye),n(A),n(we),n($),n(Te),n(je),n(v),n(ge),n(Ue),n(Je),n(_),n(Ce),n(E),n(Ae),n($e),n(R),n(Ie),n(ve),n(D),n(xe),n(ke),n(_e),n(L),n(Ee),n(Ze),n(z),n(Re),n(We),n(H),n(De),n(N),n(Ge),n(Be),n(Y),n(Le),n(Qe),n(F),n(ze),n(Ve),n(q),n(He),n(Ne),n(O),n(Se),n(Ye),n(te),n(Xe),n(Fe),n(se),n(Ke),n(qe),n(Pe),n(ie),n(Oe),n(re)),n(b),M(y,e),M(w,e),M(g,e),M(U,e),M(C,e),M(I,e),M(x,e),M(k,e),M(Z,e),M(W,e),M(G,e),M(B,e),M(Q,e),M(V,e),M(S,e),M(X,e),M(K,e),M(P,e),M(ee,e),M(ne,e),M(le,e),M(ae,e)}}}const Et='{"title":"DEtection TRansformer (DETR)","local":"detection-transformer-detr","sections":[{"title":"Overview of architecture","local":"overview-of-architecture","sections":[],"depth":2},{"title":"Key Features","local":"key-features","sections":[{"title":"Encoder-Decoder","local":"encoder-decoder","sections":[],"depth":3},{"title":"Set-based Global Loss Function","local":"set-based-global-loss-function","sections":[],"depth":3}],"depth":2},{"title":"Using DETR to Detect Objects","local":"using-detr-to-detect-objects","sections":[],"depth":2},{"title":"Evolution of DETR","local":"evolution-of-detr","sections":[{"title":"Deformable DETR","local":"deformable-detr","sections":[],"depth":3},{"title":"Conditional DETR","local":"conditional-detr","sections":[],"depth":3}],"depth":2},{"title":"PyTorch Implementation of DETR","local":"pytorch-implementation-of-detr","sections":[{"title":"Going line by line in the forward function:","local":"going-line-by-line-in-the-forward-function","sections":[],"depth":3}],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function Zt(tt){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bt extends It{constructor(b){super(),vt(this,b,Zt,_t,Ct,{})}}export{Bt as component};
