import{s as ze,f as He,n as Ve,o as qe}from"../chunks/scheduler.7bc62968.js";import{S as Ye,i as Oe,g as i,s as a,r as M,A as Le,h as o,f as s,c as l,j as $e,u as m,x as r,k as H,y as Pe,a as n,v as c,d as p,t as y,w as u}from"../chunks/index.66556066.js";import{C as Ke}from"../chunks/CodeBlock.a759539a.js";import{H as d}from"../chunks/Heading.3f0870db.js";function De(Ie){let U,Y,V,O,w,L,h,be,P,J,K,T,ke="OneFormer is a groundbreaking approach to image segmentation, a computer vision task that involves dividing an image into meaningful segments. Traditional methods used separate models and architectures for different segmentation tasks, like identifying objects (instance segmentation) or labeling regions (semantic segmentation). More recent attempts aimed to unify these tasks using shared architectures but still required separate training for each task.",D,g,ve="Enter OneFormer, a universal image segmentation framework designed to overcome these challenges. It introduces a unique multi-task approach, allowing a single model to handle semantic, instance, and panoptic segmentation tasks without the need for separate training on each. The key innovation lies in a task-conditioned joint training strategy, where the model is guided by a task input, making it dynamic and adaptive to different tasks during both training and inference.",ee,f,Be="This breakthrough not only simplifies the training process but also outperforms existing models across various datasets. OneFormer achieves this by using panoptic annotations, unifying the ground truth information needed for all tasks. Additionally, the framework introduces query-text contrastive learning to better distinguish between tasks and improve overall performance.",te,j,se,C,Ze=`<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/oneformer/oneformer.svg" alt="Oneformer Method"/>
To understand OneFormer’s significance, let’s look into the background of image segmentation. In image processing, segmentation involves dividing an image into different parts, which is crucial for tasks like recognizing objects and understanding the content of a scene. Traditionally, two main types of segmentation tasks were semantic segmentation, where pixels are labeled with categories like “road” or “sky,” and instance segmentation, which identifies objects with well-defined boundaries.`,ne,I,We="Over time, researchers proposed panoptic segmentation as a way to unify semantic and instance segmentation tasks. However, even with these advancements, there were challenges. Existing models designed for panoptic segmentation still required separate training for each task, making them semi-universal at best.",ae,b,Ae="This is where OneFormer comes in as a game-changer. It introduces a novel approach – a multi-task universal architecture. The idea is to train this framework only once, using a single universal architecture, a lone model, and just one dataset. The magic happens as OneFormer outperforms specialized frameworks across semantic, instance, and panoptic segmentation tasks. This breakthrough is not just about improving accuracy; it’s about making image segmentation more universal and efficient. With OneFormer, the need for extensive resources and separate training for different tasks becomes a thing of the past.",le,k,ie,v,Re=`<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/oneformer/text_gen.svg" alt="Task Conditioned Joint Training"/>
Now, let’s break down the key features of OneFormer that make it stand out:`,oe,B,re,Z,Ge="OneFormer uses a clever trick called “Task-Dynamic Mask” to better understand and tackle different types of image segmentation tasks. So, when the model encounters an image, it uses this “Task-Dynamic Mask” to decide whether to pay attention to the overall scene, identify specific objects with clear boundaries, or do a combination of both.",Me,W,me,A,_e="One of the groundbreaking features of OneFormer is its task-conditioned joint training strategy. Instead of training separately for semantic, instance, and panoptic segmentation, OneFormer uniformly samples the task during training. This strategy enables the model to learn and generalize across different segmentation tasks simultaneously. By conditioning the architecture on the specific task through the task token, OneFormer unifies the training process, reducing the need for task-specific architectures, models, and datasets. This innovative approach significantly streamlines the training pipeline and resource requirements.",ce,R,pe,G,Se="Lastly, let’s talk about “Query-Text Contrastive Loss.” Think of it as a way for OneFormer to teach itself about the differences between tasks and classes. In the training process, the model compares the features it extracts from the image (queries) with the corresponding text descriptions (like “a photo with a car”). This helps the model understand the unique characteristics of each task and reduces confusion between different classes. OneFormer’s “Task-Dynamic Mask” allows it to be versatile like a multitasking assistant, and the “Query-Text Contrastive Loss” helps it learn the specifics of each task by comparing visual features with textual descriptions.",ye,_,xe="By combining these core concepts, OneFormer becomes a smart and efficient tool for image segmentation, making the process more universal and accessible.",ue,S,de,x,Ee='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/oneformer/plots.svg" alt="result comperison"/>',Ue,E,Fe="In conclusion, the OneFormer framework represents a groundbreaking approach in the field of image segmentation, aiming to simplify and unify the task across various domains. Unlike traditional methods that rely on specialized architectures for each segmentation task, OneFormer introduces a novel multi-task universal architecture that requires only a single model, trained once on a universal dataset, to outperform existing frameworks. Additionally, the incorporation of query-text contrastive loss during training enhances the model’s ability to learn inter-task and inter-class differences. OneFormer utilizes transformer-based architectures, inspired by recent successes in computer vision, and introduces task-guided queries to improve task sensitivity. The results are impressive, as OneFormer surpasses state-of-the-art models across semantic, instance, and panoptic segmentation tasks on benchmark datasets like ADE20k, Cityscapes, and COCO. The framework’s performance is further enhanced with new ConvNeXt and DiNAT backbones.",he,F,Ne="In summary, OneFormer represents a significant step towards universal and accessible image segmentation. By introducing a single model capable of handling diverse segmentation tasks, the framework streamlines the segmentation process and reduces resource requirements.",we,N,Je,X,Te,Q,Xe='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/oneformer/oneformer_semantic.png" alt="semantic segmentation"/>',ge,$,fe,z,Qe=`[1][OneFormer Paper](<a href="https://arxiv.org/pdf/2211.06220.pdf" rel="nofollow">https://arxiv.org/pdf/2211.06220.pdf</a>)<br/>
[2][HuggingFace OneFormer model](<a href="https://huggingface.co/shi-labs/oneformer_ade20k_dinat_large" rel="nofollow">https://huggingface.co/shi-labs/oneformer_ade20k_dinat_large</a>)`,je,q,Ce;return w=new d({props:{title:"OneFormer: One Transformer to Rule Universal Image Segmentation",local:"oneformer-one-transformer-to-rule-universal-image-segmentation",headingTag:"h1"}}),J=new d({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),j=new d({props:{title:"Background of OneFormer",local:"background-of-oneformer",headingTag:"h2"}}),k=new d({props:{title:"Core Concepts of OneFormer",local:"core-concepts-of-oneformer",headingTag:"h2"}}),B=new d({props:{title:"Task-Dynamic Mask",local:"task-dynamic-mask",headingTag:"h3"}}),W=new d({props:{title:"Task-Conditioned Joint Training",local:"task-conditioned-joint-training",headingTag:"h3"}}),R=new d({props:{title:"Query-Text Contrastive Loss",local:"query-text-contrastive-loss",headingTag:"h3"}}),S=new d({props:{title:"Conculison",local:"conculison",headingTag:"h2"}}),N=new d({props:{title:"Example use of model",local:"example-use-of-model",headingTag:"h2"}}),X=new Ke({props:{code:"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",highlighted:`!pip install -q natten <span class="hljs-comment"># Dinat backbone requires Natten library, which may take a while to install.</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OneFormerProcessor, OneFormerForUniversalSegmentation
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt


<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_segmentation</span>(<span class="hljs-params">image, task_type</span>):
    <span class="hljs-string">&quot;&quot;&quot;Performs image segmentation based on the given task type.

    Args:
        image (PIL.Image): The input image.
        task_type (str): The type of segmentation to perform (&#x27;semantic&#x27;, &#x27;instance&#x27;, or &#x27;panoptic&#x27;).

    Returns:
        PIL.Image: The segmented image.

    Raises:
        ValueError: If the task type is invalid.
    &quot;&quot;&quot;</span>

    processor = OneFormerProcessor.from_pretrained(
        <span class="hljs-string">&quot;shi-labs/oneformer_ade20k_dinat_large&quot;</span>
    )  <span class="hljs-comment"># Load once here</span>
    model = OneFormerForUniversalSegmentation.from_pretrained(
        <span class="hljs-string">&quot;shi-labs/oneformer_ade20k_dinat_large&quot;</span>
    )

    <span class="hljs-keyword">if</span> task_type == <span class="hljs-string">&quot;semantic&quot;</span>:
        inputs = processor(images=image, task_inputs=[<span class="hljs-string">&quot;semantic&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
        outputs = model(**inputs)
        predicted_map = processor.post_process_semantic_segmentation(
            outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
        )[<span class="hljs-number">0</span>]

    <span class="hljs-keyword">elif</span> task_type == <span class="hljs-string">&quot;instance&quot;</span>:
        inputs = processor(images=image, task_inputs=[<span class="hljs-string">&quot;instance&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
        outputs = model(**inputs)
        predicted_map = processor.post_process_instance_segmentation(
            outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
        )[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]

    <span class="hljs-keyword">elif</span> task_type == <span class="hljs-string">&quot;panoptic&quot;</span>:
        inputs = processor(images=image, task_inputs=[<span class="hljs-string">&quot;panoptic&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
        outputs = model(**inputs)
        predicted_map = processor.post_process_panoptic_segmentation(
            outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
        )[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]

    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">raise</span> ValueError(
            <span class="hljs-string">&quot;Invalid task type. Choose from &#x27;semantic&#x27;, &#x27;instance&#x27;, or &#x27;panoptic&#x27;&quot;</span>
        )

    <span class="hljs-keyword">return</span> predicted_map


<span class="hljs-keyword">def</span> <span class="hljs-title function_">show_image_comparison</span>(<span class="hljs-params">image, predicted_map, segmentation_title</span>):
    <span class="hljs-string">&quot;&quot;&quot;Displays the original image and the segmented image side-by-side.

    Args:
        image (PIL.Image): The original image.
        predicted_map (PIL.Image): The segmented image.
        segmentation_title (str): The title for the segmented image.
    &quot;&quot;&quot;</span>

    plt.figure(figsize=(<span class="hljs-number">12</span>, <span class="hljs-number">6</span>))
    plt.subplot(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">1</span>)
    plt.imshow(image)
    plt.title(<span class="hljs-string">&quot;Original Image&quot;</span>)
    plt.axis(<span class="hljs-string">&quot;off&quot;</span>)
    plt.subplot(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>)
    plt.imshow(predicted_map)
    plt.title(segmentation_title + <span class="hljs-string">&quot; Segmentation&quot;</span>)
    plt.axis(<span class="hljs-string">&quot;off&quot;</span>)
    plt.show()


url = <span class="hljs-string">&quot;https://huggingface.co/datasets/shi-labs/oneformer_demo/resolve/main/ade20k.jpeg&quot;</span>
response = requests.get(url, stream=<span class="hljs-literal">True</span>)
response.raise_for_status()  <span class="hljs-comment"># Check for HTTP errors</span>
image = Image.<span class="hljs-built_in">open</span>(response.raw)

task_to_run = <span class="hljs-string">&quot;semantic&quot;</span>
predicted_map = run_segmentation(image, task_to_run)
show_image_comparison(image, predicted_map, task_to_run)`,wrap:!1}}),$=new d({props:{title:"References",local:"references",headingTag:"h2"}}),{c(){U=i("meta"),Y=a(),V=i("p"),O=a(),M(w.$$.fragment),L=a(),h=i("img"),P=a(),M(J.$$.fragment),K=a(),T=i("p"),T.textContent=ke,D=a(),g=i("p"),g.textContent=ve,ee=a(),f=i("p"),f.textContent=Be,te=a(),M(j.$$.fragment),se=a(),C=i("p"),C.innerHTML=Ze,ne=a(),I=i("p"),I.textContent=We,ae=a(),b=i("p"),b.textContent=Ae,le=a(),M(k.$$.fragment),ie=a(),v=i("p"),v.innerHTML=Re,oe=a(),M(B.$$.fragment),re=a(),Z=i("p"),Z.textContent=Ge,Me=a(),M(W.$$.fragment),me=a(),A=i("p"),A.textContent=_e,ce=a(),M(R.$$.fragment),pe=a(),G=i("p"),G.textContent=Se,ye=a(),_=i("p"),_.textContent=xe,ue=a(),M(S.$$.fragment),de=a(),x=i("p"),x.innerHTML=Ee,Ue=a(),E=i("p"),E.textContent=Fe,he=a(),F=i("p"),F.textContent=Ne,we=a(),M(N.$$.fragment),Je=a(),M(X.$$.fragment),Te=a(),Q=i("p"),Q.innerHTML=Xe,ge=a(),M($.$$.fragment),fe=a(),z=i("p"),z.innerHTML=Qe,je=a(),q=i("p"),this.h()},l(e){const t=Le("svelte-u9bgzb",document.head);U=o(t,"META",{name:!0,content:!0}),t.forEach(s),Y=l(e),V=o(e,"P",{}),$e(V).forEach(s),O=l(e),m(w.$$.fragment,e),L=l(e),h=o(e,"IMG",{align:!0,width:!0,height:!0,src:!0}),P=l(e),m(J.$$.fragment,e),K=l(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1hf6o1y"&&(T.textContent=ke),D=l(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1ty30hf"&&(g.textContent=ve),ee=l(e),f=o(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1lma2v6"&&(f.textContent=Be),te=l(e),m(j.$$.fragment,e),se=l(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-dc6j7d"&&(C.innerHTML=Ze),ne=l(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-n6259b"&&(I.textContent=We),ae=l(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1ujmywj"&&(b.textContent=Ae),le=l(e),m(k.$$.fragment,e),ie=l(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-53l8w5"&&(v.innerHTML=Re),oe=l(e),m(B.$$.fragment,e),re=l(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-iru73r"&&(Z.textContent=Ge),Me=l(e),m(W.$$.fragment,e),me=l(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-fq7603"&&(A.textContent=_e),ce=l(e),m(R.$$.fragment,e),pe=l(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1iagkck"&&(G.textContent=Se),ye=l(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-xjljcp"&&(_.textContent=xe),ue=l(e),m(S.$$.fragment,e),de=l(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1cuyqyz"&&(x.innerHTML=Ee),Ue=l(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-glyvcc"&&(E.textContent=Fe),he=l(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1fzjv2z"&&(F.textContent=Ne),we=l(e),m(N.$$.fragment,e),Je=l(e),m(X.$$.fragment,e),Te=l(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1ihn2fs"&&(Q.innerHTML=Xe),ge=l(e),m($.$$.fragment,e),fe=l(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-nb2mvi"&&(z.innerHTML=Qe),je=l(e),q=o(e,"P",{}),$e(q).forEach(s),this.h()},h(){H(U,"name","hf:doc:metadata"),H(U,"content",et),H(h,"align","center"),H(h,"width","1050"),H(h,"height","303"),He(h.src,be="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/oneformer/teaser.svg")||H(h,"src",be)},m(e,t){Pe(document.head,U),n(e,Y,t),n(e,V,t),n(e,O,t),c(w,e,t),n(e,L,t),n(e,h,t),n(e,P,t),c(J,e,t),n(e,K,t),n(e,T,t),n(e,D,t),n(e,g,t),n(e,ee,t),n(e,f,t),n(e,te,t),c(j,e,t),n(e,se,t),n(e,C,t),n(e,ne,t),n(e,I,t),n(e,ae,t),n(e,b,t),n(e,le,t),c(k,e,t),n(e,ie,t),n(e,v,t),n(e,oe,t),c(B,e,t),n(e,re,t),n(e,Z,t),n(e,Me,t),c(W,e,t),n(e,me,t),n(e,A,t),n(e,ce,t),c(R,e,t),n(e,pe,t),n(e,G,t),n(e,ye,t),n(e,_,t),n(e,ue,t),c(S,e,t),n(e,de,t),n(e,x,t),n(e,Ue,t),n(e,E,t),n(e,he,t),n(e,F,t),n(e,we,t),c(N,e,t),n(e,Je,t),c(X,e,t),n(e,Te,t),n(e,Q,t),n(e,ge,t),c($,e,t),n(e,fe,t),n(e,z,t),n(e,je,t),n(e,q,t),Ce=!0},p:Ve,i(e){Ce||(p(w.$$.fragment,e),p(J.$$.fragment,e),p(j.$$.fragment,e),p(k.$$.fragment,e),p(B.$$.fragment,e),p(W.$$.fragment,e),p(R.$$.fragment,e),p(S.$$.fragment,e),p(N.$$.fragment,e),p(X.$$.fragment,e),p($.$$.fragment,e),Ce=!0)},o(e){y(w.$$.fragment,e),y(J.$$.fragment,e),y(j.$$.fragment,e),y(k.$$.fragment,e),y(B.$$.fragment,e),y(W.$$.fragment,e),y(R.$$.fragment,e),y(S.$$.fragment,e),y(N.$$.fragment,e),y(X.$$.fragment,e),y($.$$.fragment,e),Ce=!1},d(e){e&&(s(Y),s(V),s(O),s(L),s(h),s(P),s(K),s(T),s(D),s(g),s(ee),s(f),s(te),s(se),s(C),s(ne),s(I),s(ae),s(b),s(le),s(ie),s(v),s(oe),s(re),s(Z),s(Me),s(me),s(A),s(ce),s(pe),s(G),s(ye),s(_),s(ue),s(de),s(x),s(Ue),s(E),s(he),s(F),s(we),s(Je),s(Te),s(Q),s(ge),s(fe),s(z),s(je),s(q)),s(U),u(w,e),u(J,e),u(j,e),u(k,e),u(B,e),u(W,e),u(R,e),u(S,e),u(N,e),u(X,e),u($,e)}}}const et='{"title":"OneFormer: One Transformer to Rule Universal Image Segmentation","local":"oneformer-one-transformer-to-rule-universal-image-segmentation","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"Background of OneFormer","local":"background-of-oneformer","sections":[],"depth":2},{"title":"Core Concepts of OneFormer","local":"core-concepts-of-oneformer","sections":[{"title":"Task-Dynamic Mask","local":"task-dynamic-mask","sections":[],"depth":3},{"title":"Task-Conditioned Joint Training","local":"task-conditioned-joint-training","sections":[],"depth":3},{"title":"Query-Text Contrastive Loss","local":"query-text-contrastive-loss","sections":[],"depth":3}],"depth":2},{"title":"Conculison","local":"conculison","sections":[],"depth":2},{"title":"Example use of model","local":"example-use-of-model","sections":[],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function tt(Ie){return qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class it extends Ye{constructor(U){super(),Oe(this,U,tt,De,ze,{})}}export{it as component};
