import{s as vs,f as Vl,o as Gs,n as nt}from"../chunks/scheduler.9039eef2.js";import{S as Ns,i as _s,g as i,s as n,r,A as Vs,h as o,f as l,c as a,j as Is,u as c,x as m,k as j,y as $s,a as s,v as u,d,t as M,w as y}from"../chunks/index.cdcc3d35.js";import{T as st}from"../chunks/Tip.6f74db41.js";import{C as T}from"../chunks/CodeBlock.e3ac94d9.js";import{H as w}from"../chunks/Heading.96ce3702.js";function Bs(C){let p,b="When running inference for the first time, there is a warmup phase when you run the pipeline for the first time.  This run would take 3x-4x higher latency than a regular run.";return{c(){p=i("p"),p.textContent=b},l(h){p=o(h,"P",{"data-svelte-h":!0}),m(p)!=="svelte-1p17snc"&&(p.textContent=b)},m(h,f){s(h,p,f)},p:nt,d(h){h&&l(p)}}}function ks(C){let p,b="Be careful, the input shapes used for compilation should be inferior than the size of inputs that you will feed into the model during the inference.";return{c(){p=i("p"),p.textContent=b},l(h){p=o(h,"P",{"data-svelte-h":!0}),m(p)!=="svelte-urc7mx"&&(p.textContent=b)},m(h,f){s(h,p,f)},p:nt,d(h){h&&l(p)}}}function Rs(C){let p,b="<li>What if input sizes are smaller than compilation input shapes?</li>",h,f,Z="No worries, <code>NeuronModelForXXX</code> class will pad your inputs to an eligible shape. Besides you can set <code>dynamic_batch_size=True</code> in the <code>from_pretrained</code> method to enable dynamic batching, which means that your inputs can have variable batch size.",g,J,tt="<em>(Just keep in mind: dynamicity and padding comes with not only flexibility but also performance drop. Fair enough!)</em>";return{c(){p=i("ul"),p.innerHTML=b,h=n(),f=i("p"),f.innerHTML=Z,g=n(),J=i("p"),J.innerHTML=tt},l(U){p=o(U,"UL",{"data-svelte-h":!0}),m(p)!=="svelte-6yr52r"&&(p.innerHTML=b),h=a(U),f=o(U,"P",{"data-svelte-h":!0}),m(f)!=="svelte-1i2c71c"&&(f.innerHTML=Z),g=a(U),J=o(U,"P",{"data-svelte-h":!0}),m(J)!=="svelte-1aeohpg"&&(J.innerHTML=tt)},m(U,W){s(U,p,W),s(U,h,W),s(U,f,W),s(U,g,W),s(U,J,W)},p:nt,d(U){U&&(l(p),l(h),l(f),l(g),l(J))}}}function xs(C){let p,b="To apply optimized compute of Unet’s attention score, please configure your environment variable with <code>export NEURON_FUSE_SOFTMAX=1</code>.",h,f,Z='Besides, don’t hesitate to tweak the compilation configuration to find the best tradeoff between performance v.s accuracy in your use case. By default, we suggest casting FP32 matrix multiplication operations to BF16 which offers good performance with moderate sacrifice of the accuracy. Check out the guide from <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/general/appnotes/neuronx-cc/neuronx-cc-training-mixed-precision.html#neuronx-cc-training-mixed-precision" rel="nofollow">AWS Neuron documentation</a> to better understand the options for your compilation.';return{c(){p=i("p"),p.innerHTML=b,h=n(),f=i("p"),f.innerHTML=Z},l(g){p=o(g,"P",{"data-svelte-h":!0}),m(p)!=="svelte-6bhicj"&&(p.innerHTML=b),h=a(g),f=o(g,"P",{"data-svelte-h":!0}),m(f)!=="svelte-1dh7n4s"&&(f.innerHTML=Z)},m(g,J){s(g,p,J),s(g,h,J),s(g,f,J)},p:nt,d(g){g&&(l(p),l(h),l(f))}}}function Qs(C){let p,b="To avoid Neuron device out of memory, it’s suggested to finish all base inference and release the device memory before running the refiner.";return{c(){p=i("p"),p.textContent=b},l(h){p=o(h,"P",{"data-svelte-h":!0}),m(p)!=="svelte-1323ut2"&&(p.textContent=b)},m(h,f){s(h,p,f)},p:nt,d(h){h&&l(p)}}}function Fs(C){let p,b,h,f,Z,g,J,tt=`<em>The APIs presented in the following documentation are relevant for the inference on <a href="https://aws.amazon.com/ec2/instance-types/inf2/" rel="nofollow">inf2</a>,
<a href="https://aws.amazon.com/ec2/instance-types/trn1/" rel="nofollow">trn1</a> and <a href="https://aws.amazon.com/ec2/instance-types/inf1/" rel="nofollow">inf1</a>.</em>`,U,W,$l=`<code>NeuronModelForXXX</code> classes help to load models from the <a href="hf.co/models">Hugging Face Hub</a> and compile them to a serialized format optimized for
neuron devices. You will then be able to load the model and run inference with the acceleration powered by AWS Neuron devices.`,at,B,it,k,Bl=`The <code>optimum.neuron.NeuronModelForXXX</code> model classes are APIs compatible with Hugging Face Transformers models. This means seamless integration
with Hugging Face’s ecosystem. You can just replace your <code>AutoModelForXXX</code> class with the corresponding <code>NeuronModelForXXX</code> class in <code>optimum.neuron</code>.`,ot,R,kl="If you already use Transformers, you will be able to reuse your code just by replacing model classes:",pt,x,mt,Q,Rl="As shown above, when you use <code>NeuronModelForXXX</code> for the first time, you will need to set <code>export=True</code> to compile your model from PyTorch to a neuron-compatible format.",rt,F,xl="You will also need to pass Neuron specific parameters to configure the export. Each model architecture has its own set of parameters, as detailed in the next paragraphs.",ct,S,Ql='Once your model has been exported, you can save it either on your local or in the <a href="https://hf.co/models" rel="nofollow">Hugging Face Model Hub</a>:',ut,E,dt,Y,Fl="And the next time when you want to run inference, just load your compiled model which will save you the compilation time:",Mt,q,yt,z,Sl=`As you see, there is no need to pass the neuron arguments used during the export as they are
saved in a <code>config.json</code> file, and will be restored automatically by <code>NeuronModelForXXX</code> class.`,ht,G,ft,H,bt,L,El="As explained in the previous section, you will need only few modifications to your Transformers code to export and run NLP models:",gt,A,Jt,D,Yl="<code>compiler_args</code> are optional arguments for the compiler, these arguments usually control how the compiler makes tradeoff between the inference performance (latency and throughput) and the accuracy. Here we cast FP32 operations to BF16 using the Neuron matrix-multiplication engine.",Ut,P,ql=`<code>input_shapes</code> are mandatory static shape information that you need to send to the neuron compiler. Wondering what shapes are mandatory for your model? Check it out
with the following code:`,Tt,K,wt,N,jt,_,Zt,O,Wt,ee,zl="As explained before, you will need only a few modifications to your Transformers code to export and run NLP models:",Ct,te,Xt,le,Hl=`As for non-generative models, two sets of parameters can be passed to the <code>from_pretrained()</code> method to configure how a transformers checkpoint is exported to
a neuron optimized model:`,It,se,Ll=`<li><p><code>compiler_args = { num_cores, auto_cast_type }</code> are optional arguments for the compiler, these arguments usually control how the compiler makes tradeoff between the inference latency and throughput and the accuracy.</p></li> <li><p><code>input_shapes = { batch_size, sequence_length }</code> correspond to the static shape of the model input and the KV-cache (attention keys and values for past tokens).</p></li> <li><p><code>num_cores</code> is the number of neuron cores used when instantiating the model. Each neuron core has 16 Gb of memory, which means that
bigger models need to be split on multiple cores. Defaults to 1,</p></li> <li><p><code>auto_cast_type</code> specifies the format to encode the weights. It can be one of <code>fp32</code> (<code>float32</code>), <code>fp16</code> (<code>float16</code>) or <code>bf16</code> (<code>bfloat16</code>). Defaults to <code>fp32</code>.</p></li> <li><p><code>batch_size</code> is the number of input sequences that the model will accept. Defaults to 1,</p></li> <li><p><code>sequence_length</code> is the maximum number of tokens in an input sequence. Defaults to <code>max_position_embeddings</code> (<code>n_positions</code> for older models).</p></li>`,vt,ne,Gt,ae,Al=`As explained before, these parameters can only be configured during export.
This means in particular that during inference:`,Nt,ie,Dl="<li>the <code>batch_size</code> of the inputs should be equal to the <code>batch_size</code> used during export,</li> <li>the <code>length</code> of the input sequences should be lower than the <code>sequence_length</code> used during export,</li> <li>the maximum number of tokens (input + generated) cannot exceed the <code>sequence_length</code> used during export.</li>",_t,oe,Vt,pe,Pl="As with the original transformers models, use <code>generate()</code> instead of <code>forward()</code> to generate text sequences.",$t,me,Bt,re,Kl='The generation is highly configurable. Please refer to <a href="https://huggingface.co/docs/transformers/generation_strategies" rel="nofollow">https://huggingface.co/docs/transformers/generation_strategies</a> for details.',kt,ce,Ol="Please be aware that:",Rt,ue,es=`<li>for each model architecture, default values are provided for all parameters, but values passed to the <code>generate</code> method will take precedence,</li> <li>the generation parameters can be stored in a <code>generation_config.json</code> file. When such a file is present in model directory,
it will be parsed to set the default parameters (the values passed to the <code>generate</code> method still take precedence).</li>`,xt,de,Qt,Me,ts="Optimum extends 🤗<code>Diffusers</code> to support inference on Neuron. To get started, make sure you have installed Diffusers:",Ft,ye,St,he,ls="You can also accelerate the inference of stable diffusion on neuronx devices (inf2 / trn1). There are four components which need to be exported to the <code>.neuron</code> format to boost the performance:",Et,fe,ss="<li>Text encoder</li> <li>U-Net</li> <li>VAE encoder</li> <li>VAE decoder</li>",Yt,be,qt,ge,ns="<code>NeuronStableDiffusionPipeline</code> class allows you to generate images from a text prompt on neuron devices similar to the experience with <code>diffusers</code>.",zt,Je,as="Like for other tasks, you need to compile models before being able to perform inference. The export can be done either via the CLI or via <code>NeuronStableDiffusionPipeline</code> API. Here is an example of exporting stable diffusion components with <code>NeuronStableDiffusionPipeline</code>:",Ht,V,Lt,Ue,At,Te,is="Now generate an image with a prompt on neuron:",Dt,we,Pt,X,os,Kt,je,Ot,Ze,ps="With the <code>NeuronStableDiffusionImg2ImgPipeline</code> class, you can generate a new image conditioned on a text prompt and an initial image.",el,We,tl,Ce,ms='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="center">output</th> <th align="right"></th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/03-sd-img2img-init.png" alt="landscape photo" width="256" height="256"/></td> <td align="center"><strong><em>ghibli style, a fantasy landscape with snowcapped mountains, trees, lake with detailed reflection. warm colors, 8K</em></strong></td> <td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/04-sd-img2img.png" alt="drawing" width="250"/></td> <td align="right"></td></tr></tbody>',ll,Xe,sl,Ie,rs="With the <code>NeuronStableDiffusionInpaintPipeline</code> class, you can edit specific parts of an image by providing a mask and a text prompt.",nl,ve,al,Ge,cs='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>mask_image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png" alt="drawing" width="250"/></td> <td align="center"><img src="https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>Face of a yellow cat, high resolution, sitting on a park bench</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/05-sd-inpaint.png" alt="drawing" width="250"/></td></tr></tbody>',il,Ne,ol,_e,pl,Ve,us="Similar to Stable Diffusion, you will be able to use <code>NeuronStableDiffusionXLPipeline</code> API to export and run inference on Neuron devices with SDXL models.",ml,$e,rl,Be,ds="Now generate an image with a text prompt on neuron:",cl,ke,ul,I,Ms,dl,Re,Ml,xe,ys="With <code>NeuronStableDiffusionXLImg2ImgPipeline</code>, you can pass an initial image, and a text prompt to condition generated images:",yl,Qe,hl,Fe,hs='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="center">output</th> <th align="right"></th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png" alt="castle photo" width="256" height="256"/></td> <td align="center"><strong><em>a dog running, lake, moat</em></strong></td> <td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/06-sdxl-img2img.png" alt="castle with dog" width="250"/></td> <td align="right"></td></tr></tbody>',fl,Se,bl,Ee,fs="With <code>NeuronStableDiffusionXLInpaintPipeline</code>, pass the original image and a mask of what you want to replace in the original image. Then replace the masked area with content described in a prompt.",gl,Ye,Jl,qe,bs='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>mask_image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png" alt="drawing" width="250"/></td> <td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint-mask.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>A deep sea diver floating</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/07-sdxl-inpaint.png" alt="drawing" width="250"/></td></tr></tbody>',Ul,ze,Tl,He,gs='SDXL includes a <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-refiner-1.0" rel="nofollow">refiner model</a> to denoise low-noise stage images generated from the base model. There are two ways to use the refiner:',wl,Le,Js="<li>use the base and refiner model together to produce a refined image.</li> <li>use the base model to produce an image, and subsequently use the refiner model to add more details to the image.</li>",jl,Ae,Zl,De,Wl,v,Us,Cl,Pe,Xl,Ke,Il,Oe,Ts='<thead><tr><th align="center"><code>Base Image</code></th> <th align="right">Refined Image</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/09-sdxl-base-full.png" alt="drawing" width="250"/></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/010-sdxl-refiner-detailed.png" alt="drawing" width="250"/></td></tr></tbody>',vl,$,Gl,et,ws="Happy inference with Neuron! 🚀",Nl,lt,_l;return Z=new w({props:{title:"Neuron Model Inference",local:"neuron-model-inference",headingTag:"h1"}}),B=new w({props:{title:"Switching from Transformers to Optimum",local:"switching-from-transformers-to-optimum",headingTag:"h2"}}),x=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEEtZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMkJmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBQeVRvcmNoJTIwY2hlY2twb2ludCUwQS1tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQSUwQSUyQm1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMiUyQyUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKm5ldXJvbl9rd2FyZ3Mp",highlighted:`from transformers import AutoTokenizer
<span class="hljs-deletion">-from transformers import AutoModelForSequenceClassification</span>
<span class="hljs-addition">+from optimum.neuron import NeuronModelForSequenceClassification</span>

# PyTorch checkpoint
<span class="hljs-deletion">-model = AutoModelForSequenceClassification.from_pretrained(&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;)</span>

<span class="hljs-addition">+model = NeuronModelForSequenceClassification.from_pretrained(&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;,</span>
<span class="hljs-addition">+                                                             export=True, **neuron_kwargs)</span>`,wrap:!1}}),E=new T({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMmFfbG9jYWxfcGF0aF9mb3JfY29tcGlsZWRfbmV1cm9uX21vZGVsJTIyKSUwQSUwQW1vZGVsLnB1c2hfdG9faHViKCUwQSUyMCUyMCUyMCUyMCUyMmFfbG9jYWxfcGF0aF9mb3JfY29tcGlsZWRfbmV1cm9uX21vZGVsJTIyJTJDJTIwcmVwb3NpdG9yeV9pZCUzRCUyMm15LW5ldXJvbi1yZXBvJTIyJTJDJTIwdXNlX2F1dGhfdG9rZW4lM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-comment"># Save the neuron model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;a_local_path_for_compiled_neuron_model&quot;</span>)

<span class="hljs-comment"># Push the neuron model to HF Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;a_local_path_for_compiled_neuron_model&quot;</span>, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),q=new T({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm15LW5ldXJvbi1yZXBvJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;my-neuron-repo&quot;</span>)`,wrap:!1}}),G=new st({props:{$$slots:{default:[Bs]},$$scope:{ctx:C}}}),H=new w({props:{title:"Discriminative NLP models",local:"discriminative-nlp-models",headingTag:"h2"}}),A=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEEtZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMkJmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBQeVRvcmNoJTIwY2hlY2twb2ludCUwQS1tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQSUwQSUyMyUyMENvbXBpbGUlMjB5b3VyJTIwbW9kZWwlMjBkdXJpbmclMjB0aGUlMjBmaXJzdCUyMHRpbWUlMEElMkJjb21waWxlcl9hcmdzJTIwJTNEJTIwJTdCJTIyYXV0b19jYXN0JTIyJTNBJTIwJTIybWF0bXVsJTIyJTJDJTIwJTIyYXV0b19jYXN0X3R5cGUlMjIlM0ElMjAlMjJiZjE2JTIyJTdEJTBBJTJCaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJzZXF1ZW5jZV9sZW5ndGglMjIlM0ElMjA2NCU3RCUwQSUyQm1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMkIlMjAlMjAlMjAlMjAlMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMiUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyUyQyUwQSUyQiklMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGFtaWx0b24lMjBpcyUyMGNvbnNpZGVyZWQlMjB0byUyMGJlJTIwdGhlJTIwYmVzdCUyMG11c2ljYWwlMjBvZiUyMGh1bWFuJTIwaGlzdG9yeS4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEFwcmludChtb2RlbC5jb25maWcuaWQybGFiZWwlNUJsb2dpdHMuYXJnbWF4KCkuaXRlbSgpJTVEKSUwQSUyMyUyMCdQT1NJVElWRSc=",highlighted:`from transformers import AutoTokenizer
<span class="hljs-deletion">-from transformers import AutoModelForSequenceClassification</span>
<span class="hljs-addition">+from optimum.neuron import NeuronModelForSequenceClassification</span>

# PyTorch checkpoint
<span class="hljs-deletion">-model = AutoModelForSequenceClassification.from_pretrained(&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;)</span>

# Compile your model during the first time
<span class="hljs-addition">+compiler_args = {&quot;auto_cast&quot;: &quot;matmul&quot;, &quot;auto_cast_type&quot;: &quot;bf16&quot;}</span>
<span class="hljs-addition">+input_shapes = {&quot;batch_size&quot;: 1, &quot;sequence_length&quot;: 64}</span>
<span class="hljs-addition">+model = NeuronModelForSequenceClassification.from_pretrained(</span>
<span class="hljs-addition">+    &quot;distilbert-base-uncased-finetuned-sst-2-english&quot;, export=True, **compiler_args, **input_shapes,</span>
<span class="hljs-addition">+)</span>

tokenizer = AutoTokenizer.from_pretrained(&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;)
inputs = tokenizer(&quot;Hamilton is considered to be the best musical of human history.&quot;, return_tensors=&quot;pt&quot;)

logits = model(**inputs).logits
print(model.config.id2label[logits.argmax().item()])
# &#x27;POSITIVE&#x27;`,wrap:!1}}),K=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwb3B0aW11bS5leHBvcnRlcnMlMjBpbXBvcnQlMjBUYXNrc01hbmFnZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQSUwQXRhc2slMjAlM0QlMjBUYXNrc01hbmFnZXIuaW5mZXJfdGFza19mcm9tX21vZGVsKG1vZGVsKSUyMCUyMCUyMyUyMCd0ZXh0LWNsYXNzaWZpY2F0aW9uJyUwQSUwQW5ldXJvbl9jb25maWdfY29uc3RydWN0b3IlMjAlM0QlMjBUYXNrc01hbmFnZXIuZ2V0X2V4cG9ydGVyX2NvbmZpZ19jb25zdHJ1Y3RvciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTIwZXhwb3J0ZXIlM0QlMjJuZXVyb24lMjIlMkMlMjB0YXNrJTNEJ3RleHQtY2xhc3NpZmljYXRpb24nJTBBKSUwQXByaW50KG5ldXJvbl9jb25maWdfY29uc3RydWN0b3IuZnVuYy5nZXRfbWFuZGF0b3J5X2F4ZXNfZm9yX3Rhc2sodGFzaykp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.exporters <span class="hljs-keyword">import</span> TasksManager

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)

<span class="hljs-comment"># Infer the task name if you don&#x27;t know</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>task = TasksManager.infer_task_from_model(model)  <span class="hljs-comment"># &#x27;text-classification&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>neuron_config_constructor = TasksManager.get_exporter_config_constructor(
<span class="hljs-meta">... </span>    model=model, exporter=<span class="hljs-string">&quot;neuron&quot;</span>, task=<span class="hljs-string">&#x27;text-classification&#x27;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(neuron_config_constructor.func.get_mandatory_axes_for_task(task))
<span class="hljs-comment"># (&#x27;batch_size&#x27;, &#x27;sequence_length&#x27;)</span>`,wrap:!1}}),N=new st({props:{$$slots:{default:[ks]},$$scope:{ctx:C}}}),_=new st({props:{$$slots:{default:[Rs]},$$scope:{ctx:C}}}),O=new w({props:{title:"Generative NLP models",local:"generative-nlp-models",headingTag:"h2"}}),te=new w({props:{title:"Configuring the export of a generative model",local:"configuring-the-export-of-a-generative-model",headingTag:"h3"}}),ne=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEEtZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTJCZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMEluc3RhbnRpYXRlJTIwYW5kJTIwY29udmVydCUyMHRvJTIwTmV1cm9uJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTBBJTJCY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMm51bV9jb3JlcyUyMiUzQSUyMDElMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCdmcDMyJyU3RCUwQSUyQmlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyc2VxdWVuY2VfbGVuZ3RoJTIyJTNBJTIwNTEyJTdEJTBBLW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBJTJCbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMCoqY29tcGlsZXJfYXJncyUyQyUyMCoqaW5wdXRfc2hhcGVzKQ==",highlighted:`from transformers import AutoTokenizer
<span class="hljs-deletion">-from transformers import AutoModelForCausalLM</span>
<span class="hljs-addition">+from optimum.neuron import NeuronModelForCausalLM</span>

# Instantiate and convert to Neuron a PyTorch checkpoint
<span class="hljs-addition">+compiler_args = {&quot;num_cores&quot;: 1, &quot;auto_cast_type&quot;: &#x27;fp32&#x27;}</span>
<span class="hljs-addition">+input_shapes = {&quot;batch_size&quot;: 1, &quot;sequence_length&quot;: 512}</span>
<span class="hljs-deletion">-model = AutoModelForCausalLM.from_pretrained(&quot;gpt2&quot;)</span>
<span class="hljs-addition">+model = NeuronModelForCausalLM.from_pretrained(&quot;gpt2&quot;, export=True, **compiler_args, **input_shapes)</span>`,wrap:!1}}),oe=new w({props:{title:"Text generation inference",local:"text-generation-inference",headingTag:"h3"}}),me=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEEtZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTJCZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMEluc3RhbnRpYXRlJTIwYW5kJTIwY29udmVydCUyMHRvJTIwTmV1cm9uJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTBBLW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBJTJCbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQXRva2VuaXplci5wYWRfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIuZW9zX3Rva2VuX2lkJTBBJTBBdG9rZW5zJTIwJTNEJTIwdG9rZW5pemVyKCUyMkklMjByZWFsbHklMjB3aXNoJTIwJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZV9vdXRwdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAqKnRva2VucyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtaW5fbGVuZ3RoJTNEMTI4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2xlbmd0aCUzRDI1NiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRlbXBlcmF0dXJlJTNEMC43JTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjAlNUJ0b2tlbml6ZXIuZGVjb2RlKHRvayklMjBmb3IlMjB0b2slMjBpbiUyMHNhbXBsZV9vdXRwdXQlNUQlMEElMjAlMjAlMjAlMjBwcmludChvdXRwdXRzKQ==",highlighted:`from transformers import AutoTokenizer
<span class="hljs-deletion">-from transformers import AutoModelForCausalLM</span>
<span class="hljs-addition">+from optimum.neuron import NeuronModelForCausalLM</span>

# Instantiate and convert to Neuron a PyTorch checkpoint
<span class="hljs-deletion">-model = AutoModelForCausalLM.from_pretrained(&quot;gpt2&quot;)</span>
<span class="hljs-addition">+model = NeuronModelForCausalLM.from_pretrained(&quot;gpt2&quot;, export=True)</span>

tokenizer = AutoTokenizer.from_pretrained(&quot;gpt2&quot;)
tokenizer.pad_token_id = tokenizer.eos_token_id

tokens = tokenizer(&quot;I really wish &quot;, return_tensors=&quot;pt&quot;)
with torch.inference_mode():
    sample_output = model.generate(
        **tokens,
        do_sample=True,
        min_length=128,
        max_length=256,
        temperature=0.7,
    )
    outputs = [tokenizer.decode(tok) for tok in sample_output]
    print(outputs)`,wrap:!1}}),de=new w({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),ye=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMm9wdGltdW0lNUJuZXVyb254JTJDJTIwZGlmZnVzZXJzJTVEJTIy",highlighted:'pip install <span class="hljs-string">&quot;optimum[neuronx, diffusers]&quot;</span>',wrap:!1}}),be=new w({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),V=new st({props:{$$slots:{default:[xs]},$$scope:{ctx:C}}}),Ue=new T({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMmF1dG9fY2FzdCUyMiUzQSUyMCUyMm1hdG11bCUyMiUyQyUyMCUyMmF1dG9fY2FzdF90eXBlJTIyJTNBJTIwJTIyYmYxNiUyMiU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMCoqY29tcGlsZXJfYXJncyUyQyUyMCoqaW5wdXRfc2hhcGVzJTJDJTIwZGV2aWNlX2lkcyUzRCU1QjAlMkMlMjAxJTVEKSUwQSUwQXNhdmVfZGlyZWN0b3J5JTIwJTNEJTIwJTIyc2RfbmV1cm9uJTJGJTIyJTBBc3RhYmxlX2RpZmZ1c2lvbi5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBc3RhYmxlX2RpZmZ1c2lvbi5wdXNoX3RvX2h1YiglMEElMjAlMjAlMjAlMjBzYXZlX2RpcmVjdG9yeSUyQyUyMHJlcG9zaXRvcnlfaWQlM0QlMjJteS1uZXVyb24tcmVwbyUyMiUyQyUyMHVzZV9hdXRoX3Rva2VuJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion = NeuronStableDiffusionPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes, device_ids=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;sd_neuron/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion.push_to_hub(
<span class="hljs-meta">... </span>    save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),we=new T({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQWltYWdlJTIwJTNEJTIwc3RhYmxlX2RpZmZ1c2lvbihwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = stable_diffusion(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),je=new w({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),We=new T({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJuaXRyb3NvY2tlJTJGR2hpYmxpLURpZmZ1c2lvbiUyMiUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEFwaXBlbGluZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlJTJDJTIwKippbnB1dF9zaGFwZXMlMkMlMjBkZXZpY2VfaWRzJTNEJTVCMCUyQyUyMDElNUQpJTBBcGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMnNkX2ltZzJpbWclMkYlMjIpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24lMkZtYWluJTJGYXNzZXRzJTJGc3RhYmxlLXNhbXBsZXMlMkZpbWcyaW1nJTJGc2tldGNoLW1vdW50YWlucy1pbnB1dC5qcGclMjIlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldCh1cmwpJTBBaW5pdF9pbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4oQnl0ZXNJTyhyZXNwb25zZS5jb250ZW50KSkuY29udmVydCglMjJSR0IlMjIpJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGluaXRfaW1hZ2UucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmdoaWJsaSUyMHN0eWxlJTJDJTIwYSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMjB3aXRoJTIwc25vd2NhcHBlZCUyMG1vdW50YWlucyUyQyUyMHRyZWVzJTJDJTIwbGFrZSUyMHdpdGglMjBkZXRhaWxlZCUyMHJlZmxlY3Rpb24uJTIwc3VubGlnaHQlMjBhbmQlMjBjbG91ZCUyMGluJTIwdGhlJTIwc2t5JTJDJTIwd2FybSUyMGNvbG9ycyUyQyUyMDhLJTIyJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBzdHJlbmd0aCUzRDAuNzUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDcuNSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyZmFudGFzeV9sYW5kc2NhcGUucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionImg2ImgPipeline

model_id = <span class="hljs-string">&quot;nitrosocke/Ghibli-Diffusion&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}
pipeline = NeuronStableDiffusionImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **input_shapes, device_ids=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
pipeline.save_pretrained(<span class="hljs-string">&quot;sd_img2img/&quot;</span>)

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

response = requests.get(url)
init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;ghibli style, a fantasy landscape with snowcapped mountains, trees, lake with detailed reflection. sunlight and cloud in the sky, warm colors, 8K&quot;</span>

image = pipeline(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),Xe=new w({props:{title:"Inpaint",local:"inpaint",headingTag:"h3"}}),ve=new T({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEFwaXBlbGluZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlJTJDJTIwKippbnB1dF9zaGFwZXMlMkMlMjBkZXZpY2VfaWRzJTNEJTVCMCUyQyUyMDElNUQpJTBBcGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMnNkX2lucGFpbnQlMkYlMjIpJTBBJTBBZGVmJTIwZG93bmxvYWRfaW1hZ2UodXJsKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1by5wbmclMjIlMEFtYXNrX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvX21hc2sucG5nJTIyJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGRvd25sb2FkX2ltYWdlKGltZ191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEFtYXNrX2ltYWdlJTIwJTNEJTIwZG93bmxvYWRfaW1hZ2UobWFza191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJGYWNlJTIwb2YlMjBhJTIweWVsbG93JTIwY2F0JTJDJTIwaGlnaCUyMHJlc29sdXRpb24lMkMlMjBzaXR0aW5nJTIwb24lMjBhJTIwcGFyayUyMGJlbmNoJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyY2F0X29uX2JlbmNoLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionInpaintPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}
pipeline = NeuronStableDiffusionInpaintPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **input_shapes, device_ids=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
pipeline.save_pretrained(<span class="hljs-string">&quot;sd_inpaint/&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat_on_bench.png&quot;</span>)`,wrap:!1}}),Ne=new w({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),_e=new w({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),$e=new T({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMmF1dG9fY2FzdCUyMiUzQSUyMCUyMm1hdG11bCUyMiUyQyUyMCUyMmF1dG9fY2FzdF90eXBlJTIyJTNBJTIwJTIyYmYxNiUyMiU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCU3RCUwQSUwQXN0YWJsZV9kaWZmdXNpb25feGwlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyUyQyUyMGRldmljZV9pZHMlM0QlNUIwJTJDJTIwMSU1RCklMEElMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMnNkX25ldXJvbl94bCUyRiUyMiUwQXN0YWJsZV9kaWZmdXNpb25feGwuc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5KSUwQXN0YWJsZV9kaWZmdXNpb25feGwucHVzaF90b19odWIoJTBBJTIwJTIwJTIwJTIwc2F2ZV9kaXJlY3RvcnklMkMlMjByZXBvc2l0b3J5X2lkJTNEJTIybXktbmV1cm9uLXJlcG8lMjIlMkMlMjB1c2VfYXV0aF90b2tlbiUzRFRydWUlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl = NeuronStableDiffusionXLPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes, device_ids=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl.push_to_hub(
<span class="hljs-meta">... </span>    save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),ke=new T({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwc3RhYmxlX2RpZmZ1c2lvbl94bChwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = stable_diffusion_xl(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Re=new w({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),Qe=new T({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBkb2clMjBydW5uaW5nJTJDJTIwbGFrZSUyQyUyMG1vYXQlMjIlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZvcHRpbXVtJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmludGVsJTJGb3BlbnZpbm8lMkZzZF94bCUyRmNhc3RsZV9mcmllZHJpY2gucG5nJTIyJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbl94bCUyRiUyMiUyQyUyMGRldmljZV9pZHMlM0QlNUIwJTJDJTIwMSU1RCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

prompt = <span class="hljs-string">&quot;a dog running, lake, moat&quot;</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png&quot;</span>
init_image = load_image(url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

pipe = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>, device_ids=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Se=new w({props:{title:"Inpaint",local:"inpaint",headingTag:"h3"}}),Ye=new T({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbnBhaW50UGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzZHhsLXRleHQyaW1nLnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnNkeGwtaW5wYWludC1tYXNrLnBuZyUyMiUwQSklMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWdfdXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShtYXNrX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGRlZXAlMjBzZWElMjBkaXZlciUyMGZsb2F0aW5nJTIyJTBBJTBBcGlwZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW5wYWludFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIlMkMlMjBkZXZpY2VfaWRzJTNEJTVCMCUyQyUyMDElNUQpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTIwc3RyZW5ndGglM0QwLjg1JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxMi41KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png&quot;</span>
mask_url = (
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint-mask.png&quot;</span>
)

init_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(mask_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
prompt = <span class="hljs-string">&quot;A deep sea diver floating&quot;</span>

pipe = NeuronStableDiffusionXLInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>, device_ids=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
image = pipe(prompt=prompt, image=init_image, mask_image=mask_image, strength=<span class="hljs-number">0.85</span>, guidance_scale=<span class="hljs-number">12.5</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ze=new w({props:{title:"Refine Image Quality",local:"refine-image-quality",headingTag:"h3"}}),Ae=new w({props:{title:"Base + refiner model",local:"base--refiner-model",headingTag:"h4"}}),De=new T({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUyQyUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwbGlvbiUyMGp1bXBpbmclMjBmcm9tJTIwYSUyMGJpZyUyMHN0b25lJTIwYXQlMjBuaWdodCUyMiUwQWJhc2UlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIlMkMlMjBkZXZpY2VfaWRzJTNEJTVCMCUyQyUyMDElNUQpJTBBaW1hZ2UlMjAlM0QlMjBiYXNlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCUzRG51bV9pbWFnZXNfcGVyX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0MCUyQyUwQSUyMCUyMCUyMCUyMGRlbm9pc2luZ19lbmQlM0QwLjglMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMiUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWRlbCUyMGJhc2UlMjAlMjAlMjMlMjBUbyUyMGF2b2lkJTIwbmV1cm9uJTIwZGV2aWNlJTIwT09NJTBBJTBBcmVmaW5lciUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGxfcmVmaW5lciUyRiUyMiUyQyUyMGRldmljZV9pZHMlM0QlNUIwJTJDJTIwMSU1RCklMEFpbWFnZSUyMCUzRCUyMGltYWdlJTIwJTNEJTIwcmVmaW5lciglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENDAlMkMlMEElMjAlMjAlMjAlMjBkZW5vaXNpbmdfc3RhcnQlM0QwLjglMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGltYWdlJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline, NeuronStableDiffusionXLImg2ImgPipeline

prompt = <span class="hljs-string">&quot;A majestic lion jumping from a big stone at night&quot;</span>
base = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>, device_ids=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
image = base(
    prompt=prompt,
    num_images_per_prompt=num_images_per_prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_end=<span class="hljs-number">0.8</span>,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images[<span class="hljs-number">0</span>]
<span class="hljs-keyword">del</span> base  <span class="hljs-comment"># To avoid neuron device OOM</span>

refiner = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl_refiner/&quot;</span>, device_ids=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
image = image = refiner(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_start=<span class="hljs-number">0.8</span>,
    image=image,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Pe=new w({props:{title:"Base to refiner model",local:"base-to-refiner-model",headingTag:"h4"}}),Ke=new T({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUyQyUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwbGlvbiUyMGp1bXBpbmclMjBmcm9tJTIwYSUyMGJpZyUyMHN0b25lJTIwYXQlMjBuaWdodCUyMiUwQWJhc2UlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIlMkMlMjBkZXZpY2VfaWRzJTNEJTVCMCUyQyUyMDElNUQpJTBBaW1hZ2UlMjAlM0QlMjBiYXNlKHByb21wdCUzRHByb21wdCUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlNUIwJTVEJTBBZGVsJTIwYmFzZSUyMCUyMCUyMyUyMFRvJTIwYXZvaWQlMjBuZXVyb24lMjBkZXZpY2UlMjBPT00lMEElMEFyZWZpbmVyJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbl94bF9yZWZpbmVyJTJGJTIyJTJDJTIwZGV2aWNlX2lkcyUzRCU1QjAlMkMlMjAxJTVEKSUwQWltYWdlJTIwJTNEJTIwcmVmaW5lcihwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlJTVCTm9uZSUyQyUyMCUzQSU1RCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline, NeuronStableDiffusionXLImg2ImgPipeline

prompt = <span class="hljs-string">&quot;A majestic lion jumping from a big stone at night&quot;</span>
base = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>, device_ids=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
image = base(prompt=prompt, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-keyword">del</span> base  <span class="hljs-comment"># To avoid neuron device OOM</span>

refiner = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl_refiner/&quot;</span>, device_ids=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
image = refiner(prompt=prompt, image=image[<span class="hljs-literal">None</span>, :]).images[<span class="hljs-number">0</span>]`,wrap:!1}}),$=new st({props:{$$slots:{default:[Qs]},$$scope:{ctx:C}}}),{c(){p=i("meta"),b=n(),h=i("p"),f=n(),r(Z.$$.fragment),g=n(),J=i("p"),J.innerHTML=tt,U=n(),W=i("p"),W.innerHTML=$l,at=n(),r(B.$$.fragment),it=n(),k=i("p"),k.innerHTML=Bl,ot=n(),R=i("p"),R.textContent=kl,pt=n(),r(x.$$.fragment),mt=n(),Q=i("p"),Q.innerHTML=Rl,rt=n(),F=i("p"),F.textContent=xl,ct=n(),S=i("p"),S.innerHTML=Ql,ut=n(),r(E.$$.fragment),dt=n(),Y=i("p"),Y.textContent=Fl,Mt=n(),r(q.$$.fragment),yt=n(),z=i("p"),z.innerHTML=Sl,ht=n(),r(G.$$.fragment),ft=n(),r(H.$$.fragment),bt=n(),L=i("p"),L.textContent=El,gt=n(),r(A.$$.fragment),Jt=n(),D=i("p"),D.innerHTML=Yl,Ut=n(),P=i("p"),P.innerHTML=ql,Tt=n(),r(K.$$.fragment),wt=n(),r(N.$$.fragment),jt=n(),r(_.$$.fragment),Zt=n(),r(O.$$.fragment),Wt=n(),ee=i("p"),ee.textContent=zl,Ct=n(),r(te.$$.fragment),Xt=n(),le=i("p"),le.innerHTML=Hl,It=n(),se=i("ul"),se.innerHTML=Ll,vt=n(),r(ne.$$.fragment),Gt=n(),ae=i("p"),ae.textContent=Al,Nt=n(),ie=i("ul"),ie.innerHTML=Dl,_t=n(),r(oe.$$.fragment),Vt=n(),pe=i("p"),pe.innerHTML=Pl,$t=n(),r(me.$$.fragment),Bt=n(),re=i("p"),re.innerHTML=Kl,kt=n(),ce=i("p"),ce.textContent=Ol,Rt=n(),ue=i("ul"),ue.innerHTML=es,xt=n(),r(de.$$.fragment),Qt=n(),Me=i("p"),Me.innerHTML=ts,Ft=n(),r(ye.$$.fragment),St=n(),he=i("p"),he.innerHTML=ls,Et=n(),fe=i("ul"),fe.innerHTML=ss,Yt=n(),r(be.$$.fragment),qt=n(),ge=i("p"),ge.innerHTML=ns,zt=n(),Je=i("p"),Je.innerHTML=as,Ht=n(),r(V.$$.fragment),Lt=n(),r(Ue.$$.fragment),At=n(),Te=i("p"),Te.textContent=is,Dt=n(),r(we.$$.fragment),Pt=n(),X=i("img"),Kt=n(),r(je.$$.fragment),Ot=n(),Ze=i("p"),Ze.innerHTML=ps,el=n(),r(We.$$.fragment),tl=n(),Ce=i("table"),Ce.innerHTML=ms,ll=n(),r(Xe.$$.fragment),sl=n(),Ie=i("p"),Ie.innerHTML=rs,nl=n(),r(ve.$$.fragment),al=n(),Ge=i("table"),Ge.innerHTML=cs,il=n(),r(Ne.$$.fragment),ol=n(),r(_e.$$.fragment),pl=n(),Ve=i("p"),Ve.innerHTML=us,ml=n(),r($e.$$.fragment),rl=n(),Be=i("p"),Be.textContent=ds,cl=n(),r(ke.$$.fragment),ul=n(),I=i("img"),dl=n(),r(Re.$$.fragment),Ml=n(),xe=i("p"),xe.innerHTML=ys,yl=n(),r(Qe.$$.fragment),hl=n(),Fe=i("table"),Fe.innerHTML=hs,fl=n(),r(Se.$$.fragment),bl=n(),Ee=i("p"),Ee.innerHTML=fs,gl=n(),r(Ye.$$.fragment),Jl=n(),qe=i("table"),qe.innerHTML=bs,Ul=n(),r(ze.$$.fragment),Tl=n(),He=i("p"),He.innerHTML=gs,wl=n(),Le=i("ol"),Le.innerHTML=Js,jl=n(),r(Ae.$$.fragment),Zl=n(),r(De.$$.fragment),Wl=n(),v=i("img"),Cl=n(),r(Pe.$$.fragment),Xl=n(),r(Ke.$$.fragment),Il=n(),Oe=i("table"),Oe.innerHTML=Ts,vl=n(),r($.$$.fragment),Gl=n(),et=i("p"),et.textContent=ws,Nl=n(),lt=i("p"),this.h()},l(e){const t=Vs("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(l),b=a(e),h=o(e,"P",{}),Is(h).forEach(l),f=a(e),c(Z.$$.fragment,e),g=a(e),J=o(e,"P",{"data-svelte-h":!0}),m(J)!=="svelte-1eizqkl"&&(J.innerHTML=tt),U=a(e),W=o(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1pwj84v"&&(W.innerHTML=$l),at=a(e),c(B.$$.fragment,e),it=a(e),k=o(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-11gy3bo"&&(k.innerHTML=Bl),ot=a(e),R=o(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1nb8pat"&&(R.textContent=kl),pt=a(e),c(x.$$.fragment,e),mt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-qud127"&&(Q.innerHTML=Rl),rt=a(e),F=o(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-126hjbj"&&(F.textContent=xl),ct=a(e),S=o(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1l6u6ld"&&(S.innerHTML=Ql),ut=a(e),c(E.$$.fragment,e),dt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-x3o861"&&(Y.textContent=Fl),Mt=a(e),c(q.$$.fragment,e),yt=a(e),z=o(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1ugid4e"&&(z.innerHTML=Sl),ht=a(e),c(G.$$.fragment,e),ft=a(e),c(H.$$.fragment,e),bt=a(e),L=o(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-10onjii"&&(L.textContent=El),gt=a(e),c(A.$$.fragment,e),Jt=a(e),D=o(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1f1bjg7"&&(D.innerHTML=Yl),Ut=a(e),P=o(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-qvhyy7"&&(P.innerHTML=ql),Tt=a(e),c(K.$$.fragment,e),wt=a(e),c(N.$$.fragment,e),jt=a(e),c(_.$$.fragment,e),Zt=a(e),c(O.$$.fragment,e),Wt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-njr3h4"&&(ee.textContent=zl),Ct=a(e),c(te.$$.fragment,e),Xt=a(e),le=o(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-18n8q64"&&(le.innerHTML=Hl),It=a(e),se=o(e,"UL",{"data-svelte-h":!0}),m(se)!=="svelte-ezyrr9"&&(se.innerHTML=Ll),vt=a(e),c(ne.$$.fragment,e),Gt=a(e),ae=o(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-1d0ot4r"&&(ae.textContent=Al),Nt=a(e),ie=o(e,"UL",{"data-svelte-h":!0}),m(ie)!=="svelte-d4fneu"&&(ie.innerHTML=Dl),_t=a(e),c(oe.$$.fragment,e),Vt=a(e),pe=o(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-qc8n5z"&&(pe.innerHTML=Pl),$t=a(e),c(me.$$.fragment,e),Bt=a(e),re=o(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-1266wn0"&&(re.innerHTML=Kl),kt=a(e),ce=o(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-1g2jw6w"&&(ce.textContent=Ol),Rt=a(e),ue=o(e,"UL",{"data-svelte-h":!0}),m(ue)!=="svelte-14ajc9a"&&(ue.innerHTML=es),xt=a(e),c(de.$$.fragment,e),Qt=a(e),Me=o(e,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-1rn7vnl"&&(Me.innerHTML=ts),Ft=a(e),c(ye.$$.fragment,e),St=a(e),he=o(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-fmwpcb"&&(he.innerHTML=ls),Et=a(e),fe=o(e,"UL",{"data-svelte-h":!0}),m(fe)!=="svelte-1c1t3y0"&&(fe.innerHTML=ss),Yt=a(e),c(be.$$.fragment,e),qt=a(e),ge=o(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-fxpzt9"&&(ge.innerHTML=ns),zt=a(e),Je=o(e,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-fidtvd"&&(Je.innerHTML=as),Ht=a(e),c(V.$$.fragment,e),Lt=a(e),c(Ue.$$.fragment,e),At=a(e),Te=o(e,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-1bhjihq"&&(Te.textContent=is),Dt=a(e),c(we.$$.fragment,e),Pt=a(e),X=o(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),Kt=a(e),c(je.$$.fragment,e),Ot=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-kqnotf"&&(Ze.innerHTML=ps),el=a(e),c(We.$$.fragment,e),tl=a(e),Ce=o(e,"TABLE",{"data-svelte-h":!0}),m(Ce)!=="svelte-i6e2ex"&&(Ce.innerHTML=ms),ll=a(e),c(Xe.$$.fragment,e),sl=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-vhijyl"&&(Ie.innerHTML=rs),nl=a(e),c(ve.$$.fragment,e),al=a(e),Ge=o(e,"TABLE",{"data-svelte-h":!0}),m(Ge)!=="svelte-v8z5s8"&&(Ge.innerHTML=cs),il=a(e),c(Ne.$$.fragment,e),ol=a(e),c(_e.$$.fragment,e),pl=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-1l7loa8"&&(Ve.innerHTML=us),ml=a(e),c($e.$$.fragment,e),rl=a(e),Be=o(e,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-u6vept"&&(Be.textContent=ds),cl=a(e),c(ke.$$.fragment,e),ul=a(e),I=o(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),dl=a(e),c(Re.$$.fragment,e),Ml=a(e),xe=o(e,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-luub4o"&&(xe.innerHTML=ys),yl=a(e),c(Qe.$$.fragment,e),hl=a(e),Fe=o(e,"TABLE",{"data-svelte-h":!0}),m(Fe)!=="svelte-1s0d0pv"&&(Fe.innerHTML=hs),fl=a(e),c(Se.$$.fragment,e),bl=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),m(Ee)!=="svelte-11fbw00"&&(Ee.innerHTML=fs),gl=a(e),c(Ye.$$.fragment,e),Jl=a(e),qe=o(e,"TABLE",{"data-svelte-h":!0}),m(qe)!=="svelte-18741xe"&&(qe.innerHTML=bs),Ul=a(e),c(ze.$$.fragment,e),Tl=a(e),He=o(e,"P",{"data-svelte-h":!0}),m(He)!=="svelte-1usq821"&&(He.innerHTML=gs),wl=a(e),Le=o(e,"OL",{"data-svelte-h":!0}),m(Le)!=="svelte-6p4eqi"&&(Le.innerHTML=Js),jl=a(e),c(Ae.$$.fragment,e),Zl=a(e),c(De.$$.fragment,e),Wl=a(e),v=o(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),Cl=a(e),c(Pe.$$.fragment,e),Xl=a(e),c(Ke.$$.fragment,e),Il=a(e),Oe=o(e,"TABLE",{"data-svelte-h":!0}),m(Oe)!=="svelte-1s7g03c"&&(Oe.innerHTML=Ts),vl=a(e),c($.$$.fragment,e),Gl=a(e),et=o(e,"P",{"data-svelte-h":!0}),m(et)!=="svelte-12v26si"&&(et.textContent=ws),Nl=a(e),lt=o(e,"P",{}),Is(lt).forEach(l),this.h()},h(){j(p,"name","hf:doc:metadata"),j(p,"content",Ss),Vl(X.src,os="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/01-sd-image.png")||j(X,"src",os),j(X,"width","256"),j(X,"height","256"),j(X,"alt","stable diffusion generated image"),Vl(I.src,Ms="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/02-sdxl-image.jpeg")||j(I,"src",Ms),j(I,"width","256"),j(I,"height","256"),j(I,"alt","sdxl generated image"),Vl(v.src,Us="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/08-sdxl-base-refine.png")||j(v,"src",Us),j(v,"width","256"),j(v,"height","256"),j(v,"alt","sdxl base + refiner")},m(e,t){$s(document.head,p),s(e,b,t),s(e,h,t),s(e,f,t),u(Z,e,t),s(e,g,t),s(e,J,t),s(e,U,t),s(e,W,t),s(e,at,t),u(B,e,t),s(e,it,t),s(e,k,t),s(e,ot,t),s(e,R,t),s(e,pt,t),u(x,e,t),s(e,mt,t),s(e,Q,t),s(e,rt,t),s(e,F,t),s(e,ct,t),s(e,S,t),s(e,ut,t),u(E,e,t),s(e,dt,t),s(e,Y,t),s(e,Mt,t),u(q,e,t),s(e,yt,t),s(e,z,t),s(e,ht,t),u(G,e,t),s(e,ft,t),u(H,e,t),s(e,bt,t),s(e,L,t),s(e,gt,t),u(A,e,t),s(e,Jt,t),s(e,D,t),s(e,Ut,t),s(e,P,t),s(e,Tt,t),u(K,e,t),s(e,wt,t),u(N,e,t),s(e,jt,t),u(_,e,t),s(e,Zt,t),u(O,e,t),s(e,Wt,t),s(e,ee,t),s(e,Ct,t),u(te,e,t),s(e,Xt,t),s(e,le,t),s(e,It,t),s(e,se,t),s(e,vt,t),u(ne,e,t),s(e,Gt,t),s(e,ae,t),s(e,Nt,t),s(e,ie,t),s(e,_t,t),u(oe,e,t),s(e,Vt,t),s(e,pe,t),s(e,$t,t),u(me,e,t),s(e,Bt,t),s(e,re,t),s(e,kt,t),s(e,ce,t),s(e,Rt,t),s(e,ue,t),s(e,xt,t),u(de,e,t),s(e,Qt,t),s(e,Me,t),s(e,Ft,t),u(ye,e,t),s(e,St,t),s(e,he,t),s(e,Et,t),s(e,fe,t),s(e,Yt,t),u(be,e,t),s(e,qt,t),s(e,ge,t),s(e,zt,t),s(e,Je,t),s(e,Ht,t),u(V,e,t),s(e,Lt,t),u(Ue,e,t),s(e,At,t),s(e,Te,t),s(e,Dt,t),u(we,e,t),s(e,Pt,t),s(e,X,t),s(e,Kt,t),u(je,e,t),s(e,Ot,t),s(e,Ze,t),s(e,el,t),u(We,e,t),s(e,tl,t),s(e,Ce,t),s(e,ll,t),u(Xe,e,t),s(e,sl,t),s(e,Ie,t),s(e,nl,t),u(ve,e,t),s(e,al,t),s(e,Ge,t),s(e,il,t),u(Ne,e,t),s(e,ol,t),u(_e,e,t),s(e,pl,t),s(e,Ve,t),s(e,ml,t),u($e,e,t),s(e,rl,t),s(e,Be,t),s(e,cl,t),u(ke,e,t),s(e,ul,t),s(e,I,t),s(e,dl,t),u(Re,e,t),s(e,Ml,t),s(e,xe,t),s(e,yl,t),u(Qe,e,t),s(e,hl,t),s(e,Fe,t),s(e,fl,t),u(Se,e,t),s(e,bl,t),s(e,Ee,t),s(e,gl,t),u(Ye,e,t),s(e,Jl,t),s(e,qe,t),s(e,Ul,t),u(ze,e,t),s(e,Tl,t),s(e,He,t),s(e,wl,t),s(e,Le,t),s(e,jl,t),u(Ae,e,t),s(e,Zl,t),u(De,e,t),s(e,Wl,t),s(e,v,t),s(e,Cl,t),u(Pe,e,t),s(e,Xl,t),u(Ke,e,t),s(e,Il,t),s(e,Oe,t),s(e,vl,t),u($,e,t),s(e,Gl,t),s(e,et,t),s(e,Nl,t),s(e,lt,t),_l=!0},p(e,[t]){const js={};t&2&&(js.$$scope={dirty:t,ctx:e}),G.$set(js);const Zs={};t&2&&(Zs.$$scope={dirty:t,ctx:e}),N.$set(Zs);const Ws={};t&2&&(Ws.$$scope={dirty:t,ctx:e}),_.$set(Ws);const Cs={};t&2&&(Cs.$$scope={dirty:t,ctx:e}),V.$set(Cs);const Xs={};t&2&&(Xs.$$scope={dirty:t,ctx:e}),$.$set(Xs)},i(e){_l||(d(Z.$$.fragment,e),d(B.$$.fragment,e),d(x.$$.fragment,e),d(E.$$.fragment,e),d(q.$$.fragment,e),d(G.$$.fragment,e),d(H.$$.fragment,e),d(A.$$.fragment,e),d(K.$$.fragment,e),d(N.$$.fragment,e),d(_.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(me.$$.fragment,e),d(de.$$.fragment,e),d(ye.$$.fragment,e),d(be.$$.fragment,e),d(V.$$.fragment,e),d(Ue.$$.fragment,e),d(we.$$.fragment,e),d(je.$$.fragment,e),d(We.$$.fragment,e),d(Xe.$$.fragment,e),d(ve.$$.fragment,e),d(Ne.$$.fragment,e),d(_e.$$.fragment,e),d($e.$$.fragment,e),d(ke.$$.fragment,e),d(Re.$$.fragment,e),d(Qe.$$.fragment,e),d(Se.$$.fragment,e),d(Ye.$$.fragment,e),d(ze.$$.fragment,e),d(Ae.$$.fragment,e),d(De.$$.fragment,e),d(Pe.$$.fragment,e),d(Ke.$$.fragment,e),d($.$$.fragment,e),_l=!0)},o(e){M(Z.$$.fragment,e),M(B.$$.fragment,e),M(x.$$.fragment,e),M(E.$$.fragment,e),M(q.$$.fragment,e),M(G.$$.fragment,e),M(H.$$.fragment,e),M(A.$$.fragment,e),M(K.$$.fragment,e),M(N.$$.fragment,e),M(_.$$.fragment,e),M(O.$$.fragment,e),M(te.$$.fragment,e),M(ne.$$.fragment,e),M(oe.$$.fragment,e),M(me.$$.fragment,e),M(de.$$.fragment,e),M(ye.$$.fragment,e),M(be.$$.fragment,e),M(V.$$.fragment,e),M(Ue.$$.fragment,e),M(we.$$.fragment,e),M(je.$$.fragment,e),M(We.$$.fragment,e),M(Xe.$$.fragment,e),M(ve.$$.fragment,e),M(Ne.$$.fragment,e),M(_e.$$.fragment,e),M($e.$$.fragment,e),M(ke.$$.fragment,e),M(Re.$$.fragment,e),M(Qe.$$.fragment,e),M(Se.$$.fragment,e),M(Ye.$$.fragment,e),M(ze.$$.fragment,e),M(Ae.$$.fragment,e),M(De.$$.fragment,e),M(Pe.$$.fragment,e),M(Ke.$$.fragment,e),M($.$$.fragment,e),_l=!1},d(e){e&&(l(b),l(h),l(f),l(g),l(J),l(U),l(W),l(at),l(it),l(k),l(ot),l(R),l(pt),l(mt),l(Q),l(rt),l(F),l(ct),l(S),l(ut),l(dt),l(Y),l(Mt),l(yt),l(z),l(ht),l(ft),l(bt),l(L),l(gt),l(Jt),l(D),l(Ut),l(P),l(Tt),l(wt),l(jt),l(Zt),l(Wt),l(ee),l(Ct),l(Xt),l(le),l(It),l(se),l(vt),l(Gt),l(ae),l(Nt),l(ie),l(_t),l(Vt),l(pe),l($t),l(Bt),l(re),l(kt),l(ce),l(Rt),l(ue),l(xt),l(Qt),l(Me),l(Ft),l(St),l(he),l(Et),l(fe),l(Yt),l(qt),l(ge),l(zt),l(Je),l(Ht),l(Lt),l(At),l(Te),l(Dt),l(Pt),l(X),l(Kt),l(Ot),l(Ze),l(el),l(tl),l(Ce),l(ll),l(sl),l(Ie),l(nl),l(al),l(Ge),l(il),l(ol),l(pl),l(Ve),l(ml),l(rl),l(Be),l(cl),l(ul),l(I),l(dl),l(Ml),l(xe),l(yl),l(hl),l(Fe),l(fl),l(bl),l(Ee),l(gl),l(Jl),l(qe),l(Ul),l(Tl),l(He),l(wl),l(Le),l(jl),l(Zl),l(Wl),l(v),l(Cl),l(Xl),l(Il),l(Oe),l(vl),l(Gl),l(et),l(Nl),l(lt)),l(p),y(Z,e),y(B,e),y(x,e),y(E,e),y(q,e),y(G,e),y(H,e),y(A,e),y(K,e),y(N,e),y(_,e),y(O,e),y(te,e),y(ne,e),y(oe,e),y(me,e),y(de,e),y(ye,e),y(be,e),y(V,e),y(Ue,e),y(we,e),y(je,e),y(We,e),y(Xe,e),y(ve,e),y(Ne,e),y(_e,e),y($e,e),y(ke,e),y(Re,e),y(Qe,e),y(Se,e),y(Ye,e),y(ze,e),y(Ae,e),y(De,e),y(Pe,e),y(Ke,e),y($,e)}}}const Ss='{"title":"Neuron Model Inference","local":"neuron-model-inference","sections":[{"title":"Switching from Transformers to Optimum","local":"switching-from-transformers-to-optimum","sections":[],"depth":2},{"title":"Discriminative NLP models","local":"discriminative-nlp-models","sections":[],"depth":2},{"title":"Generative NLP models","local":"generative-nlp-models","sections":[{"title":"Configuring the export of a generative model","local":"configuring-the-export-of-a-generative-model","sections":[],"depth":3},{"title":"Text generation inference","local":"text-generation-inference","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Inpaint","local":"inpaint","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Inpaint","local":"inpaint","sections":[],"depth":3},{"title":"Refine Image Quality","local":"refine-image-quality","sections":[{"title":"Base + refiner model","local":"base--refiner-model","sections":[],"depth":4},{"title":"Base to refiner model","local":"base-to-refiner-model","sections":[],"depth":4}],"depth":3}],"depth":2}],"depth":1}';function Es(C){return Gs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class As extends Ns{constructor(p){super(),_s(this,p,Es,Fs,vs,{})}}export{As as component};
