import{s as Bs,o as Xs,n as Y}from"../chunks/scheduler.9bc65507.js";import{S as Gs,i as Rs,g as c,s,r as u,A as Ns,h as d,f as l,c as r,j as $,u as f,x as m,k as C,l as qs,y as a,a as p,v as g,d as _,t as v,w as b}from"../chunks/index.707bf1b6.js";import{T as ft}from"../chunks/Tip.c2ecdbf4.js";import{D as U}from"../chunks/Docstring.570ddb64.js";import{C as dt}from"../chunks/CodeBlock.54a9f38d.js";import{F as Ys,M as fs}from"../chunks/Markdown.fef84341.js";import{E as Ct}from"../chunks/ExampleCodeBlock.bc2be6bc.js";import{P as Is}from"../chunks/PipelineTag.44585822.js";import{H as te,E as Hs}from"../chunks/EditOnGithub.922df6ba.js";function Ls(x){let t,y="Example:",n,i,M;return i=new dt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdhdjJWZWMyQ29uZmlnJTJDJTIwV2F2MlZlYzJNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBXYXYyVmVjMiUyMGZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS05NjBoJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFdhdjJWZWMyQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMGZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS05NjBoJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBXYXYyVmVjMk1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Wav2Vec2Config, Wav2Vec2Model

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Wav2Vec2 facebook/wav2vec2-base-960h style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Wav2Vec2Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the facebook/wav2vec2-base-960h style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Wav2Vec2Model(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=c("p"),t.textContent=y,n=s(),u(i.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),m(t)!=="svelte-11lpom8"&&(t.textContent=y),n=r(o),f(i.$$.fragment,o)},m(o,j){p(o,t,j),p(o,n,j),g(i,o,j),M=!0},p:Y,i(o){M||(_(i.$$.fragment,o),M=!0)},o(o){v(i.$$.fragment,o),M=!1},d(o){o&&(l(t),l(n)),b(i,o)}}}function Es(x){let t,y="Example:",n,i,M;return i=new dt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Let&#x27;s see how to retrieve time steps for a model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoFeatureExtractor, AutoModelForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> datasets
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># import model, feature extractor, tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load first sample of English common_voice</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;mozilla-foundation/common_voice_11_0&quot;</span>, <span class="hljs-string">&quot;en&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, datasets.Audio(sampling_rate=<span class="hljs-number">16_000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_iter = <span class="hljs-built_in">iter</span>(dataset)
<span class="hljs-meta">&gt;&gt;&gt; </span>sample = <span class="hljs-built_in">next</span>(dataset_iter)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward sample through model to get greedily predicted transcription ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = feature_extractor(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_values
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(input_values).logits[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>pred_ids = torch.argmax(logits, axis=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># retrieve word stamps (analogous commands for \`output_char_offsets\`)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = tokenizer.decode(pred_ids, output_word_offsets=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute \`time_offset\` in seconds as product of downsampling ratio and sampling_rate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>time_offset = model.config.inputs_to_logits_ratio / feature_extractor.sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>word_offsets = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;word&quot;</span>: d[<span class="hljs-string">&quot;word&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;start_time&quot;</span>: <span class="hljs-built_in">round</span>(d[<span class="hljs-string">&quot;start_offset&quot;</span>] * time_offset, <span class="hljs-number">2</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;end_time&quot;</span>: <span class="hljs-built_in">round</span>(d[<span class="hljs-string">&quot;end_offset&quot;</span>] * time_offset, <span class="hljs-number">2</span>),
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> d <span class="hljs-keyword">in</span> outputs.word_offsets
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compare word offsets with audio \`en_train_0/common_voice_en_19121553.mp3\` online on the dataset viewer:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># https://huggingface.co/datasets/mozilla-foundation/common_voice_11_0/viewer/en</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>word_offsets[:<span class="hljs-number">3</span>]
[{<span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;THE&#x27;</span>, <span class="hljs-string">&#x27;start_time&#x27;</span>: <span class="hljs-number">0.7</span>, <span class="hljs-string">&#x27;end_time&#x27;</span>: <span class="hljs-number">0.78</span>}, {<span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;TRICK&#x27;</span>, <span class="hljs-string">&#x27;start_time&#x27;</span>: <span class="hljs-number">0.88</span>, <span class="hljs-string">&#x27;end_time&#x27;</span>: <span class="hljs-number">1.08</span>}, {<span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;APPEARS&#x27;</span>, <span class="hljs-string">&#x27;start_time&#x27;</span>: <span class="hljs-number">1.2</span>, <span class="hljs-string">&#x27;end_time&#x27;</span>: <span class="hljs-number">1.64</span>}]`,wrap:!1}}),{c(){t=c("p"),t.textContent=y,n=s(),u(i.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),m(t)!=="svelte-11lpom8"&&(t.textContent=y),n=r(o),f(i.$$.fragment,o)},m(o,j){p(o,t,j),p(o,n,j),g(i,o,j),M=!0},p:Y,i(o){M||(_(i.$$.fragment,o),M=!0)},o(o){v(i.$$.fragment,o),M=!1},d(o){o&&(l(t),l(n)),b(i,o)}}}function Ps(x){let t,y=`This class method is simply calling <a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a>. Please refer to the docstrings of the
methods above for more information.`;return{c(){t=c("p"),t.innerHTML=y},l(n){t=d(n,"P",{"data-svelte-h":!0}),m(t)!=="svelte-1qvfzw2"&&(t.innerHTML=y)},m(n,i){p(n,t,i)},p:Y,d(n){n&&l(t)}}}function Qs(x){let t,y=`This class method is simply calling Wav2Vec2FeatureExtractor’s
<a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a>, Wav2Vec2CTCTokenizer’s
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.from_pretrained">from_pretrained()</a>, and
<code>pyctcdecode.BeamSearchDecoderCTC.load_from_hf_hub</code>.`,n,i,M="Please refer to the docstrings of the methods above for more information.";return{c(){t=c("p"),t.innerHTML=y,n=s(),i=c("p"),i.textContent=M},l(o){t=d(o,"P",{"data-svelte-h":!0}),m(t)!=="svelte-1njkgj5"&&(t.innerHTML=y),n=r(o),i=d(o,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1v5a8ev"&&(i.textContent=M)},m(o,j){p(o,t,j),p(o,n,j),p(o,i,j)},p:Y,d(o){o&&(l(t),l(n),l(i))}}}function Ss(x){let t,y=`This function makes use of Python’s multiprocessing. Currently, multiprocessing is available only on Unix
systems (see this <a href="https://github.com/kensho-technologies/pyctcdecode/issues/65" rel="nofollow">issue</a>).`,n,i,M=`If you are decoding multiple batches, consider creating a <code>Pool</code> and passing it to <code>batch_decode</code>. Otherwise,
<code>batch_decode</code> will be very slow since it will create a fresh <code>Pool</code> for each call. See usage example below.`;return{c(){t=c("p"),t.innerHTML=y,n=s(),i=c("p"),i.innerHTML=M},l(o){t=d(o,"P",{"data-svelte-h":!0}),m(t)!=="svelte-mir1wd"&&(t.innerHTML=y),n=r(o),i=d(o,"P",{"data-svelte-h":!0}),m(i)!=="svelte-4v42s1"&&(i.innerHTML=M)},m(o,j){p(o,t,j),p(o,n,j),p(o,i,j)},p:Y,d(o){o&&(l(t),l(n),l(i))}}}function As(x){let t,y="Example:",n,i,M;return i=new dt({props:{code:"JTIzJTIwTGV0J3MlMjBzZWUlMjBob3clMjB0byUyMHJldHJpZXZlJTIwdGltZSUyMHN0ZXBzJTIwZm9yJTIwYSUyMG1vZGVsJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvUHJvY2Vzc29yJTJDJTIwQXV0b01vZGVsRm9yQ1RDJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwZGF0YXNldHMlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQSUyMyUyMGltcG9ydCUyMG1vZGVsJTJDJTIwZmVhdHVyZSUyMGV4dHJhY3RvciUyQyUyMHRva2VuaXplciUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJwYXRyaWNrdm9ucGxhdGVuJTJGd2F2MnZlYzItYmFzZS0xMDBoLXdpdGgtbG0lMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIycGF0cmlja3ZvbnBsYXRlbiUyRndhdjJ2ZWMyLWJhc2UtMTAwaC13aXRoLWxtJTIyKSUwQSUwQSUyMyUyMGxvYWQlMjBmaXJzdCUyMHNhbXBsZSUyMG9mJTIwRW5nbGlzaCUyMGNvbW1vbl92b2ljZSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybW96aWxsYS1mb3VuZGF0aW9uJTJGY29tbW9uX3ZvaWNlXzExXzAlMjIlMkMlMjAlMjJlbiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwZGF0YXNldHMuQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCkpJTBBZGF0YXNldF9pdGVyJTIwJTNEJTIwaXRlcihkYXRhc2V0KSUwQXNhbXBsZSUyMCUzRCUyMG5leHQoZGF0YXNldF9pdGVyKSUwQSUwQSUyMyUyMGZvcndhcmQlMjBzYW1wbGUlMjB0aHJvdWdoJTIwbW9kZWwlMjB0byUyMGdldCUyMGdyZWVkaWx5JTIwcHJlZGljdGVkJTIwdHJhbnNjcmlwdGlvbiUyMGlkcyUwQWlucHV0X3ZhbHVlcyUyMCUzRCUyMHByb2Nlc3NvcihzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikuaW5wdXRfdmFsdWVzJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKGlucHV0X3ZhbHVlcykubG9naXRzJTVCMCU1RC5jcHUoKS5udW1weSgpJTBBJTBBJTIzJTIwcmV0cmlldmUlMjB3b3JkJTIwc3RhbXBzJTIwKGFuYWxvZ291cyUyMGNvbW1hbmRzJTIwZm9yJTIwJTYwb3V0cHV0X2NoYXJfb2Zmc2V0cyU2MCklMEFvdXRwdXRzJTIwJTNEJTIwcHJvY2Vzc29yLmRlY29kZShsb2dpdHMlMkMlMjBvdXRwdXRfd29yZF9vZmZzZXRzJTNEVHJ1ZSklMEElMjMlMjBjb21wdXRlJTIwJTYwdGltZV9vZmZzZXQlNjAlMjBpbiUyMHNlY29uZHMlMjBhcyUyMHByb2R1Y3QlMjBvZiUyMGRvd25zYW1wbGluZyUyMHJhdGlvJTIwYW5kJTIwc2FtcGxpbmdfcmF0ZSUwQXRpbWVfb2Zmc2V0JTIwJTNEJTIwbW9kZWwuY29uZmlnLmlucHV0c190b19sb2dpdHNfcmF0aW8lMjAlMkYlMjBwcm9jZXNzb3IuZmVhdHVyZV9leHRyYWN0b3Iuc2FtcGxpbmdfcmF0ZSUwQSUwQXdvcmRfb2Zmc2V0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMndvcmQlMjIlM0ElMjBkJTVCJTIyd29yZCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0YXJ0X3RpbWUlMjIlM0ElMjByb3VuZChkJTVCJTIyc3RhcnRfb2Zmc2V0JTIyJTVEJTIwKiUyMHRpbWVfb2Zmc2V0JTJDJTIwMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmRfdGltZSUyMiUzQSUyMHJvdW5kKGQlNUIlMjJlbmRfb2Zmc2V0JTIyJTVEJTIwKiUyMHRpbWVfb2Zmc2V0JTJDJTIwMiklMkMlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjBmb3IlMjBkJTIwaW4lMjBvdXRwdXRzLndvcmRfb2Zmc2V0cyUwQSU1RCUwQSUyMyUyMGNvbXBhcmUlMjB3b3JkJTIwb2Zmc2V0cyUyMHdpdGglMjBhdWRpbyUyMCU2MGVuX3RyYWluXzAlMkZjb21tb25fdm9pY2VfZW5fMTkxMjE1NTMubXAzJTYwJTIwb25saW5lJTIwb24lMjB0aGUlMjBkYXRhc2V0JTIwdmlld2VyJTNBJTBBJTIzJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGbW96aWxsYS1mb3VuZGF0aW9uJTJGY29tbW9uX3ZvaWNlXzExXzAlMkZ2aWV3ZXIlMkZlbiUwQXdvcmRfb2Zmc2V0cyU1QiUzQTQlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Let&#x27;s see how to retrieve time steps for a model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoProcessor, AutoModelForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> datasets
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># import model, feature extractor, tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(<span class="hljs-string">&quot;patrickvonplaten/wav2vec2-base-100h-with-lm&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;patrickvonplaten/wav2vec2-base-100h-with-lm&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load first sample of English common_voice</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;mozilla-foundation/common_voice_11_0&quot;</span>, <span class="hljs-string">&quot;en&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, datasets.Audio(sampling_rate=<span class="hljs-number">16_000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_iter = <span class="hljs-built_in">iter</span>(dataset)
<span class="hljs-meta">&gt;&gt;&gt; </span>sample = <span class="hljs-built_in">next</span>(dataset_iter)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward sample through model to get greedily predicted transcription ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = processor(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_values
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(input_values).logits[<span class="hljs-number">0</span>].cpu().numpy()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># retrieve word stamps (analogous commands for \`output_char_offsets\`)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.decode(logits, output_word_offsets=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute \`time_offset\` in seconds as product of downsampling ratio and sampling_rate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>time_offset = model.config.inputs_to_logits_ratio / processor.feature_extractor.sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>word_offsets = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;word&quot;</span>: d[<span class="hljs-string">&quot;word&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;start_time&quot;</span>: <span class="hljs-built_in">round</span>(d[<span class="hljs-string">&quot;start_offset&quot;</span>] * time_offset, <span class="hljs-number">2</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;end_time&quot;</span>: <span class="hljs-built_in">round</span>(d[<span class="hljs-string">&quot;end_offset&quot;</span>] * time_offset, <span class="hljs-number">2</span>),
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> d <span class="hljs-keyword">in</span> outputs.word_offsets
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compare word offsets with audio \`en_train_0/common_voice_en_19121553.mp3\` online on the dataset viewer:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># https://huggingface.co/datasets/mozilla-foundation/common_voice_11_0/viewer/en</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>word_offsets[:<span class="hljs-number">4</span>]
[{<span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;THE&#x27;</span>, <span class="hljs-string">&#x27;start_time&#x27;</span>: <span class="hljs-number">0.68</span>, <span class="hljs-string">&#x27;end_time&#x27;</span>: <span class="hljs-number">0.78</span>}, {<span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;TRACK&#x27;</span>, <span class="hljs-string">&#x27;start_time&#x27;</span>: <span class="hljs-number">0.88</span>, <span class="hljs-string">&#x27;end_time&#x27;</span>: <span class="hljs-number">1.1</span>}, {<span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;APPEARS&#x27;</span>, <span class="hljs-string">&#x27;start_time&#x27;</span>: <span class="hljs-number">1.18</span>, <span class="hljs-string">&#x27;end_time&#x27;</span>: <span class="hljs-number">1.66</span>}, {<span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;ON&#x27;</span>, <span class="hljs-string">&#x27;start_time&#x27;</span>: <span class="hljs-number">1.86</span>, <span class="hljs-string">&#x27;end_time&#x27;</span>: <span class="hljs-number">1.92</span>}]`,wrap:!1}}),{c(){t=c("p"),t.textContent=y,n=s(),u(i.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),m(t)!=="svelte-11lpom8"&&(t.textContent=y),n=r(o),f(i.$$.fragment,o)},m(o,j){p(o,t,j),p(o,n,j),g(i,o,j),M=!0},p:Y,i(o){M||(_(i.$$.fragment,o),M=!0)},o(o){v(i.$$.fragment,o),M=!1},d(o){o&&(l(t),l(n)),b(i,o)}}}function Ds(x){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=y},l(n){t=d(n,"P",{"data-svelte-h":!0}),m(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(n,i){p(n,t,i)},p:Y,d(n){n&&l(t)}}}function Os(x){let t,y="Example:",n,i,M;return i=new dt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXYXYyVmVjMk1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZGVtbyUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNvcnQoJTIyaWQlMjIpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGRhdGFzZXQuZmVhdHVyZXMlNUIlMjJhdWRpbyUyMiU1RC5zYW1wbGluZ19yYXRlJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZ3YXYydmVjMi1iYXNlLTk2MGglMjIpJTBBbW9kZWwlMjAlM0QlMjBXYXYyVmVjMk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRndhdjJ2ZWMyLWJhc2UtOTYwaCUyMiklMEElMEElMjMlMjBhdWRpbyUyMGZpbGUlMjBpcyUyMGRlY29kZWQlMjBvbiUyMHRoZSUyMGZseSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihkYXRhc2V0JTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEc2FtcGxpbmdfcmF0ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Wav2Vec2Model
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Wav2Vec2Model.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">292</span>, <span class="hljs-number">768</span>]`,wrap:!1}}),{c(){t=c("p"),t.textContent=y,n=s(),u(i.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),m(t)!=="svelte-11lpom8"&&(t.textContent=y),n=r(o),f(i.$$.fragment,o)},m(o,j){p(o,t,j),p(o,n,j),g(i,o,j),M=!0},p:Y,i(o){M||(_(i.$$.fragment,o),M=!0)},o(o){v(i.$$.fragment,o),M=!1},d(o){o&&(l(t),l(n)),b(i,o)}}}function Ks(x){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=y},l(n){t=d(n,"P",{"data-svelte-h":!0}),m(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(n,i){p(n,t,i)},p:Y,d(n){n&&l(t)}}}function er(x){let t,y="Example:",n,i,M;return i=new dt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXYXYyVmVjMkZvckNUQyUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS05NjBoJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2F2MlZlYzJGb3JDVEMuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS05NjBoJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQXByZWRpY3RlZF9pZHMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpJTBBJTBBJTIzJTIwdHJhbnNjcmliZSUyMHNwZWVjaCUwQXRyYW5zY3JpcHRpb24lMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKHByZWRpY3RlZF9pZHMpJTBBdHJhbnNjcmlwdGlvbiU1QjAlNUQlMEElMEFpbnB1dHMlNUIlMjJsYWJlbHMlMjIlNUQlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRGRhdGFzZXQlNUIwJTVEJTVCJTIydGV4dCUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLmlucHV0X2lkcyUwQSUwQSUyMyUyMGNvbXB1dGUlMjBsb3NzJTBBbG9zcyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb3NzJTBBcm91bmQobG9zcy5pdGVtKCklMkMlMjAyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Wav2Vec2ForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Wav2Vec2ForCTC.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># transcribe speech</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;MISTER QUILTER IS THE APOSTLE OF THE MIDDLE CLASSES AND WE ARE GLAD TO WELCOME HIS GOSPEL&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs[<span class="hljs-string">&quot;labels&quot;</span>] = processor(text=dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute loss</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">53.48</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=y,n=s(),u(i.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),m(t)!=="svelte-11lpom8"&&(t.textContent=y),n=r(o),f(i.$$.fragment,o)},m(o,j){p(o,t,j),p(o,n,j),g(i,o,j),M=!0},p:Y,i(o){M||(_(i.$$.fragment,o),M=!0)},o(o){v(i.$$.fragment,o),M=!1},d(o){o&&(l(t),l(n)),b(i,o)}}}function tr(x){let t,y=`Activate the special <a href="https://huggingface.co/transformers/installation.html#offline-mode" rel="nofollow">“offline-mode”</a> to
use this method in a firewalled environment.`;return{c(){t=c("p"),t.innerHTML=y},l(n){t=d(n,"P",{"data-svelte-h":!0}),m(t)!=="svelte-13hahdn"&&(t.innerHTML=y)},m(n,i){p(n,t,i)},p:Y,d(n){n&&l(t)}}}function or(x){let t,y="Examples:",n,i,M;return i=new dt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdhdjJWZWMyRm9yQ1RDJTJDJTIwQXV0b1Byb2Nlc3NvciUwQSUwQWNrcHQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRm1tcy0xYi1hbGwlMjIlMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChja3B0KSUwQW1vZGVsJTIwJTNEJTIwV2F2MlZlYzJGb3JDVEMuZnJvbV9wcmV0cmFpbmVkKGNrcHQlMkMlMjB0YXJnZXRfbGFuZyUzRCUyMmVuZyUyMiklMEElMjMlMjBzZXQlMjBzcGVjaWZpYyUyMGxhbmd1YWdlJTBBcHJvY2Vzc29yLnRva2VuaXplci5zZXRfdGFyZ2V0X2xhbmcoJTIyc3BhJTIyKSUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjJzcGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Wav2Vec2ForCTC, AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>ckpt = <span class="hljs-string">&quot;facebook/mms-1b-all&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(ckpt)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Wav2Vec2ForCTC.from_pretrained(ckpt, target_lang=<span class="hljs-string">&quot;eng&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set specific language</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.tokenizer.set_target_lang(<span class="hljs-string">&quot;spa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.load_adapter(<span class="hljs-string">&quot;spa&quot;</span>)`,wrap:!1}}),{c(){t=c("p"),t.textContent=y,n=s(),u(i.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),m(t)!=="svelte-kvfsh7"&&(t.textContent=y),n=r(o),f(i.$$.fragment,o)},m(o,j){p(o,t,j),p(o,n,j),g(i,o,j),M=!0},p:Y,i(o){M||(_(i.$$.fragment,o),M=!0)},o(o){v(i.$$.fragment,o),M=!1},d(o){o&&(l(t),l(n)),b(i,o)}}}function ar(x){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=y},l(n){t=d(n,"P",{"data-svelte-h":!0}),m(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(n,i){p(n,t,i)},p:Y,d(n){n&&l(t)}}}function nr(x){let t,y="Example:",n,i,M;return i=new dt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTJDJTIwV2F2MlZlYzJGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZGVtbyUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNvcnQoJTIyaWQlMjIpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGRhdGFzZXQuZmVhdHVyZXMlNUIlMjJhdWRpbyUyMiU1RC5zYW1wbGluZ19yYXRlJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBBdXRvRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyc3VwZXJiJTJGd2F2MnZlYzItYmFzZS1zdXBlcmIta3MlMjIpJTBBbW9kZWwlMjAlM0QlMjBXYXYyVmVjMkZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnN1cGVyYiUyRndhdjJ2ZWMyLWJhc2Utc3VwZXJiLWtzJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkcyUyMCUzRCUyMHRvcmNoLmFyZ21heChsb2dpdHMlMkMlMjBkaW0lM0QtMSkuaXRlbSgpJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkcyU1RCUwQXByZWRpY3RlZF9sYWJlbCUwQSUwQSUyMyUyMGNvbXB1dGUlMjBsb3NzJTIwLSUyMHRhcmdldF9sYWJlbCUyMGlzJTIwZS5nLiUyMCUyMmRvd24lMjIlMEF0YXJnZXRfbGFiZWwlMjAlM0QlMjBtb2RlbC5jb25maWcuaWQybGFiZWwlNUIwJTVEJTBBaW5wdXRzJTVCJTIybGFiZWxzJTIyJTVEJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1Qm1vZGVsLmNvbmZpZy5sYWJlbDJpZCU1QnRhcmdldF9sYWJlbCU1RCU1RCklMEFsb3NzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvc3MlMEFyb3VuZChsb3NzLml0ZW0oKSUyQyUyMDIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, Wav2Vec2ForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;superb/wav2vec2-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Wav2Vec2ForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;superb/wav2vec2-base-superb-ks&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = model.config.id2label[predicted_class_ids]
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label
<span class="hljs-string">&#x27;_unknown_&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute loss - target_label is e.g. &quot;down&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_label = model.config.id2label[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs[<span class="hljs-string">&quot;labels&quot;</span>] = torch.tensor([model.config.label2id[target_label]])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">6.54</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=y,n=s(),u(i.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),m(t)!=="svelte-11lpom8"&&(t.textContent=y),n=r(o),f(i.$$.fragment,o)},m(o,j){p(o,t,j),p(o,n,j),g(i,o,j),M=!0},p:Y,i(o){M||(_(i.$$.fragment,o),M=!0)},o(o){v(i.$$.fragment,o),M=!1},d(o){o&&(l(t),l(n)),b(i,o)}}}function sr(x){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=y},l(n){t=d(n,"P",{"data-svelte-h":!0}),m(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(n,i){p(n,t,i)},p:Y,d(n){n&&l(t)}}}function rr(x){let t,y="Example:",n,i,M;return i=new dt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTJDJTIwV2F2MlZlYzJGb3JBdWRpb0ZyYW1lQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kZW1vJTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJpZCUyMiklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwZGF0YXNldC5mZWF0dXJlcyU1QiUyMmF1ZGlvJTIyJTVELnNhbXBsaW5nX3JhdGUlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJhbnRvbi1sJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc2QlMjIpJTBBbW9kZWwlMjAlM0QlMjBXYXYyVmVjMkZvckF1ZGlvRnJhbWVDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYW50b24tbCUyRndhdjJ2ZWMyLWJhc2Utc3VwZXJiLXNkJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJvYmFiaWxpdGllcyUyMCUzRCUyMHRvcmNoLnNpZ21vaWQobG9naXRzJTVCMCU1RCklMEElMjMlMjBsYWJlbHMlMjBpcyUyMGElMjBvbmUtaG90JTIwYXJyYXklMjBvZiUyMHNoYXBlJTIwKG51bV9mcmFtZXMlMkMlMjBudW1fc3BlYWtlcnMpJTBBbGFiZWxzJTIwJTNEJTIwKHByb2JhYmlsaXRpZXMlMjAlM0UlMjAwLjUpLmxvbmcoKSUwQWxhYmVscyU1QjAlNUQudG9saXN0KCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, Wav2Vec2ForAudioFrameClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;anton-l/wav2vec2-base-superb-sd&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Wav2Vec2ForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;anton-l/wav2vec2-base-superb-sd&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, sampling_rate=sampling_rate)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.sigmoid(logits[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># labels is a one-hot array of shape (num_frames, num_speakers)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = (probabilities &gt; <span class="hljs-number">0.5</span>).long()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels[<span class="hljs-number">0</span>].tolist()
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>]`,wrap:!1}}),{c(){t=c("p"),t.textContent=y,n=s(),u(i.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),m(t)!=="svelte-11lpom8"&&(t.textContent=y),n=r(o),f(i.$$.fragment,o)},m(o,j){p(o,t,j),p(o,n,j),g(i,o,j),M=!0},p:Y,i(o){M||(_(i.$$.fragment,o),M=!0)},o(o){v(i.$$.fragment,o),M=!1},d(o){o&&(l(t),l(n)),b(i,o)}}}function lr(x){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=y},l(n){t=d(n,"P",{"data-svelte-h":!0}),m(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(n,i){p(n,t,i)},p:Y,d(n){n&&l(t)}}}function ir(x){let t,y="Example:",n,i,M;return i=new dt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTJDJTIwV2F2MlZlYzJGb3JYVmVjdG9yJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZGVtbyUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNvcnQoJTIyaWQlMjIpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGRhdGFzZXQuZmVhdHVyZXMlNUIlMjJhdWRpbyUyMiU1RC5zYW1wbGluZ19yYXRlJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBBdXRvRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyYW50b24tbCUyRndhdjJ2ZWMyLWJhc2Utc3VwZXJiLXN2JTIyKSUwQW1vZGVsJTIwJTNEJTIwV2F2MlZlYzJGb3JYVmVjdG9yLmZyb21fcHJldHJhaW5lZCglMjJhbnRvbi1sJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc3YlMjIpJTBBJTBBJTIzJTIwYXVkaW8lMjBmaWxlJTIwaXMlMjBkZWNvZGVkJTIwb24lMjB0aGUlMjBmbHklMEFpbnB1dHMlMjAlM0QlMjBmZWF0dXJlX2V4dHJhY3RvciglMEElMjAlMjAlMjAlMjAlNUJkJTVCJTIyYXJyYXklMjIlNUQlMjBmb3IlMjBkJTIwaW4lMjBkYXRhc2V0JTVCJTNBMiU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUlMEEpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGVtYmVkZGluZ3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykuZW1iZWRkaW5ncyUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLm5vcm1hbGl6ZShlbWJlZGRpbmdzJTJDJTIwZGltJTNELTEpLmNwdSgpJTBBJTBBJTIzJTIwdGhlJTIwcmVzdWx0aW5nJTIwZW1iZWRkaW5ncyUyMGNhbiUyMGJlJTIwdXNlZCUyMGZvciUyMGNvc2luZSUyMHNpbWlsYXJpdHktYmFzZWQlMjByZXRyaWV2YWwlMEFjb3NpbmVfc2ltJTIwJTNEJTIwdG9yY2gubm4uQ29zaW5lU2ltaWxhcml0eShkaW0lM0QtMSklMEFzaW1pbGFyaXR5JTIwJTNEJTIwY29zaW5lX3NpbShlbWJlZGRpbmdzJTVCMCU1RCUyQyUyMGVtYmVkZGluZ3MlNUIxJTVEKSUwQXRocmVzaG9sZCUyMCUzRCUyMDAuNyUyMCUyMCUyMyUyMHRoZSUyMG9wdGltYWwlMjB0aHJlc2hvbGQlMjBpcyUyMGRhdGFzZXQtZGVwZW5kZW50JTBBaWYlMjBzaW1pbGFyaXR5JTIwJTNDJTIwdGhyZXNob2xkJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyU3BlYWtlcnMlMjBhcmUlMjBub3QlMjB0aGUlMjBzYW1lISUyMiklMEFyb3VuZChzaW1pbGFyaXR5Lml0ZW0oKSUyQyUyMDIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, Wav2Vec2ForXVector
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;anton-l/wav2vec2-base-superb-sv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Wav2Vec2ForXVector.from_pretrained(<span class="hljs-string">&quot;anton-l/wav2vec2-base-superb-sv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(
<span class="hljs-meta">... </span>    [d[<span class="hljs-string">&quot;array&quot;</span>] <span class="hljs-keyword">for</span> d <span class="hljs-keyword">in</span> dataset[:<span class="hljs-number">2</span>][<span class="hljs-string">&quot;audio&quot;</span>]], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    embeddings = model(**inputs).embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = torch.nn.functional.normalize(embeddings, dim=-<span class="hljs-number">1</span>).cpu()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the resulting embeddings can be used for cosine similarity-based retrieval</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cosine_sim = torch.nn.CosineSimilarity(dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>similarity = cosine_sim(embeddings[<span class="hljs-number">0</span>], embeddings[<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>threshold = <span class="hljs-number">0.7</span>  <span class="hljs-comment"># the optimal threshold is dataset-dependent</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> similarity &lt; threshold:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Speakers are not the same!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(similarity.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">0.98</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=y,n=s(),u(i.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),m(t)!=="svelte-11lpom8"&&(t.textContent=y),n=r(o),f(i.$$.fragment,o)},m(o,j){p(o,t,j),p(o,n,j),g(i,o,j),M=!0},p:Y,i(o){M||(_(i.$$.fragment,o),M=!0)},o(o){v(i.$$.fragment,o),M=!1},d(o){o&&(l(t),l(n)),b(i,o)}}}function cr(x){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=y},l(n){t=d(n,"P",{"data-svelte-h":!0}),m(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(n,i){p(n,t,i)},p:Y,d(n){n&&l(t)}}}function dr(x){let t,y="Example:",n,i,M;return i=new dt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, Wav2Vec2ForPreTraining
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.models.wav2vec2.modeling_wav2vec2 <span class="hljs-keyword">import</span> _compute_mask_indices, _sample_negative_indices
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Wav2Vec2ForPreTraining.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = feature_extractor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_values  <span class="hljs-comment"># Batch size 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute masked indices</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size, raw_sequence_length = input_values.shape
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_length = model._get_feat_extract_output_lengths(raw_sequence_length).item()
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_time_indices = _compute_mask_indices(
<span class="hljs-meta">... </span>    shape=(batch_size, sequence_length), mask_prob=<span class="hljs-number">0.2</span>, mask_length=<span class="hljs-number">2</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampled_negative_indices = _sample_negative_indices(
<span class="hljs-meta">... </span>    features_shape=(batch_size, sequence_length),
<span class="hljs-meta">... </span>    num_negatives=model.config.num_negatives,
<span class="hljs-meta">... </span>    mask_time_indices=mask_time_indices,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_time_indices = torch.tensor(data=mask_time_indices, device=input_values.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampled_negative_indices = torch.tensor(
<span class="hljs-meta">... </span>    data=sampled_negative_indices, device=input_values.device, dtype=torch.long
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(input_values, mask_time_indices=mask_time_indices)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute cosine similarity between predicted (=projected_states) and target (=projected_quantized_states)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cosine_sim = torch.cosine_similarity(outputs.projected_states, outputs.projected_quantized_states, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># show that cosine similarity is much higher than random</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cosine_sim[mask_time_indices.to(torch.<span class="hljs-built_in">bool</span>)].mean() &gt; <span class="hljs-number">0.5</span>
tensor(<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># for contrastive loss training model should be put into train mode</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = model.train()
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(
<span class="hljs-meta">... </span>    input_values, mask_time_indices=mask_time_indices, sampled_negative_indices=sampled_negative_indices
<span class="hljs-meta">... </span>).loss`,wrap:!1}}),{c(){t=c("p"),t.textContent=y,n=s(),u(i.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),m(t)!=="svelte-11lpom8"&&(t.textContent=y),n=r(o),f(i.$$.fragment,o)},m(o,j){p(o,t,j),p(o,n,j),g(i,o,j),M=!0},p:Y,i(o){M||(_(i.$$.fragment,o),M=!0)},o(o){v(i.$$.fragment,o),M=!1},d(o){o&&(l(t),l(n)),b(i,o)}}}function pr(x){let t,y,n,i,M,o,j=`The bare Wav2Vec2 Model transformer outputting raw hidden-states without any specific head on top.
Wav2Vec2 was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,we,B,O=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving etc.).`,Me,X,K=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Te,k,G,re,P,Dt='The <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Model">Wav2Vec2Model</a> forward method, overrides the <code>__call__</code> special method.',Ee,N,Ie,Q,nt,ce,$e,I,de,le,pe,je=`Wav2Vec2 Model with a <code>language modeling</code> head on top for Connectionist Temporal Classification (CTC).
Wav2Vec2 was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,Be,z,st=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving etc.).`,Xe,oe,ae=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ge,H,ke,rt,We,Re='The <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a> forward method, overrides the <code>__call__</code> special method.',Et,me,Ce,Ne,xe,S,ge,q,ee,Pe="Load a language adapter model from a pre-trained adapter model.",qe,Qe,Se,L,Ye,A,Ae,T,F,Z,ie,pt=`Wav2Vec2 Model with a sequence classification head on top (a linear layer over the pooled output) for tasks like
SUPERB Keyword Spotting.`,R,ne,mt=`Wav2Vec2 was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,Pt,Ft,Ut=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving etc.).`,Qt,Zt,zt=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,St,He,De,jt,_e,It='The <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForSequenceClassification">Wav2Vec2ForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Le,ve,bo,Oe,Bt,Xt,ht,E,Fe,gt,W,J="Wav2Vec2 Model with a frame classification head on top for tasks like Speaker Diarization.",be,D,Ue=`Wav2Vec2 was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,he,Ve,Ot=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving etc.).`,Ua,yo,no=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,so,_t,Gt,Za,wo,$o='The <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForAudioFrameClassification">Wav2Vec2ForAudioFrameClassification</a> forward method, overrides the <code>__call__</code> special method.',ro,Kt,vt,bt,Bo,Rt,Ko,Ze,Nt,za,Mo,lo="Wav2Vec2 Model with an XVector feature extraction head on top for tasks like Speaker Verification.",ea,kt,To=`Wav2Vec2 was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,ta,At,cn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving etc.).`,oa,Wt,jo=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,aa,Ke,ko,Xo,qt,na='The <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForXVector">Wav2Vec2ForXVector</a> forward method, overrides the <code>__call__</code> special method.',ut,yt,sa,xt,ra,io,co,lt,po,eo,Yt,Ia=`Wav2Vec2 Model with a quantizer and <code>VQ</code> head on top.
Wav2Vec2 was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,Wo,Co,la=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving etc.).`,mo,ho,se=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,uo,wt,Ht,Ba,xo,Fo='The <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForPreTraining">Wav2Vec2ForPreTraining</a> forward method, overrides the <code>__call__</code> special method.',Xa,to,oo,Mt,Go;return t=new te({props:{title:"Wav2Vec2Model",local:"transformers.Wav2Vec2Model",headingTag:"h2"}}),i=new U({props:{name:"class transformers.Wav2Vec2Model",anchor:"transformers.Wav2Vec2Model",parameters:[{name:"config",val:": Wav2Vec2Config"}],parametersDescription:[{anchor:"transformers.Wav2Vec2Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L1796"}}),G=new U({props:{name:"forward",anchor:"transformers.Wav2Vec2Model.forward",parameters:[{name:"input_values",val:": Optional"},{name:"attention_mask",val:": Optional = None"},{name:"mask_time_indices",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Wav2Vec2Model.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.Wav2Vec2Model.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p><code>attention_mask</code> should only be passed if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">wav2vec2-base</a>, <code>attention_mask</code> should <strong>not</strong> be
passed to avoid degraded performance when doing batched inference. For such models <code>input_values</code> should
simply be padded with 0 and passed without <code>attention_mask</code>. Be aware that these models also yield slightly
different results depending on whether <code>input_values</code> is padded or not.</p>

					</div>`,name:"attention_mask"},{anchor:"transformers.Wav2Vec2Model.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Wav2Vec2Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Wav2Vec2Model.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L1886",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.modeling_outputs.Wav2Vec2BaseModelOutput"
>transformers.modeling_outputs.Wav2Vec2BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config"
>Wav2Vec2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>extract_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, conv_dim[-1])</code>) — Sequence of extracted feature vectors of the last convolutional layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.modeling_outputs.Wav2Vec2BaseModelOutput"
>transformers.modeling_outputs.Wav2Vec2BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),N=new ft({props:{$$slots:{default:[Ds]},$$scope:{ctx:x}}}),Q=new Ct({props:{anchor:"transformers.Wav2Vec2Model.forward.example",$$slots:{default:[Os]},$$scope:{ctx:x}}}),ce=new te({props:{title:"Wav2Vec2ForCTC",local:"transformers.Wav2Vec2ForCTC",headingTag:"h2"}}),de=new U({props:{name:"class transformers.Wav2Vec2ForCTC",anchor:"transformers.Wav2Vec2ForCTC",parameters:[{name:"config",val:""},{name:"target_lang",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Wav2Vec2ForCTC.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.Wav2Vec2ForCTC.target_lang",description:`<strong>target_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Language id of adapter weights. Adapter weights are stored in the format adapter.<lang>.safetensors or
adapter.<lang>.bin. Only relevant when using an instance of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a> with adapters. Uses &#x2018;eng&#x2019; by
default.</lang></lang>`,name:"target_lang"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L2217"}}),ke=new U({props:{name:"forward",anchor:"transformers.Wav2Vec2ForCTC.forward",parameters:[{name:"input_values",val:": Optional"},{name:"attention_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"labels",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Wav2Vec2ForCTC.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.Wav2Vec2ForCTC.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p><code>attention_mask</code> should only be passed if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">wav2vec2-base</a>, <code>attention_mask</code> should <strong>not</strong> be
passed to avoid degraded performance when doing batched inference. For such models <code>input_values</code> should
simply be padded with 0 and passed without <code>attention_mask</code>. Be aware that these models also yield slightly
different results depending on whether <code>input_values</code> is padded or not.</p>

					</div>`,name:"attention_mask"},{anchor:"transformers.Wav2Vec2ForCTC.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Wav2Vec2ForCTC.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Wav2Vec2ForCTC.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Wav2Vec2ForCTC.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_length)</code>, <em>optional</em>) &#x2014;
Labels for connectionist temporal classification. Note that <code>target_length</code> has to be smaller or equal to
the sequence length of the output logits. Indices are selected in <code>[-100, 0, ..., config.vocab_size - 1]</code>.
All labels set to <code>-100</code> are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L2299",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutput"
>transformers.modeling_outputs.CausalLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config"
>Wav2Vec2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutput"
>transformers.modeling_outputs.CausalLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),me=new ft({props:{$$slots:{default:[Ks]},$$scope:{ctx:x}}}),Ne=new Ct({props:{anchor:"transformers.Wav2Vec2ForCTC.forward.example",$$slots:{default:[er]},$$scope:{ctx:x}}}),ge=new U({props:{name:"load_adapter",anchor:"transformers.Wav2Vec2ForCTC.load_adapter",parameters:[{name:"target_lang",val:": str"},{name:"force_load",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2ForCTC.load_adapter.target_lang",description:`<strong>target_lang</strong> (<code>str</code>) &#x2014;
Has to be a language id of an existing adapter weight. Adapter weights are stored in the format
adapter.<lang>.safetensors or adapter.<lang>.bin</lang></lang>`,name:"target_lang"},{anchor:"transformers.Wav2Vec2ForCTC.load_adapter.force_load",description:`<strong>force_load</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether the weights shall be loaded even if <code>target_lang</code> matches <code>self.target_lang</code>.`,name:"force_load"},{anchor:"transformers.Wav2Vec2ForCTC.load_adapter.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.Wav2Vec2ForCTC.load_adapter.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.Wav2Vec2ForCTC.load_adapter.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.Wav2Vec2ForCTC.load_adapter.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.Wav2Vec2ForCTC.load_adapter.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (i.e., do not try to download the model).`,name:"local_files_only(bool,"},{anchor:"transformers.Wav2Vec2ForCTC.load_adapter.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, or not specified, will use
the token generated when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.Wav2Vec2ForCTC.load_adapter.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>To test a pull request you made on the Hub, you can pass \`revision=&#x201C;refs/pr/<pr_number>&#x201C;.</pr_number></p>

					</div>`,name:"revision"},{anchor:"transformers.Wav2Vec2ForCTC.load_adapter.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to accelerate downloads in China. If you are from China and have an accessibility
problem, you can set this option to resolve it. Note that we do not guarantee the timeliness or safety.
Please refer to the mirror site for more information.`,name:"mirror"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L1547"}}),Qe=new ft({props:{$$slots:{default:[tr]},$$scope:{ctx:x}}}),L=new Ct({props:{anchor:"transformers.Wav2Vec2ForCTC.load_adapter.example",$$slots:{default:[or]},$$scope:{ctx:x}}}),A=new te({props:{title:"Wav2Vec2ForSequenceClassification",local:"transformers.Wav2Vec2ForSequenceClassification",headingTag:"h2"}}),F=new U({props:{name:"class transformers.Wav2Vec2ForSequenceClassification",anchor:"transformers.Wav2Vec2ForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2ForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L2379"}}),De=new U({props:{name:"forward",anchor:"transformers.Wav2Vec2ForSequenceClassification.forward",parameters:[{name:"input_values",val:": Optional"},{name:"attention_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"labels",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Wav2Vec2ForSequenceClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.Wav2Vec2ForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p><code>attention_mask</code> should only be passed if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">wav2vec2-base</a>, <code>attention_mask</code> should <strong>not</strong> be
passed to avoid degraded performance when doing batched inference. For such models <code>input_values</code> should
simply be padded with 0 and passed without <code>attention_mask</code>. Be aware that these models also yield slightly
different results depending on whether <code>input_values</code> is padded or not.</p>

					</div>`,name:"attention_mask"},{anchor:"transformers.Wav2Vec2ForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Wav2Vec2ForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Wav2Vec2ForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Wav2Vec2ForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L2431",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config"
>Wav2Vec2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ve=new ft({props:{$$slots:{default:[ar]},$$scope:{ctx:x}}}),Oe=new Ct({props:{anchor:"transformers.Wav2Vec2ForSequenceClassification.forward.example",$$slots:{default:[nr]},$$scope:{ctx:x}}}),Xt=new te({props:{title:"Wav2Vec2ForAudioFrameClassification",local:"transformers.Wav2Vec2ForAudioFrameClassification",headingTag:"h2"}}),Fe=new U({props:{name:"class transformers.Wav2Vec2ForAudioFrameClassification",anchor:"transformers.Wav2Vec2ForAudioFrameClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2ForAudioFrameClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L2502"}}),Gt=new U({props:{name:"forward",anchor:"transformers.Wav2Vec2ForAudioFrameClassification.forward",parameters:[{name:"input_values",val:": Optional"},{name:"attention_mask",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Wav2Vec2ForAudioFrameClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.Wav2Vec2ForAudioFrameClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p><code>attention_mask</code> should only be passed if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">wav2vec2-base</a>, <code>attention_mask</code> should <strong>not</strong> be
passed to avoid degraded performance when doing batched inference. For such models <code>input_values</code> should
simply be padded with 0 and passed without <code>attention_mask</code>. Be aware that these models also yield slightly
different results depending on whether <code>input_values</code> is padded or not.</p>

					</div>`,name:"attention_mask"},{anchor:"transformers.Wav2Vec2ForAudioFrameClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Wav2Vec2ForAudioFrameClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Wav2Vec2ForAudioFrameClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Wav2Vec2ForAudioFrameClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L2552",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config"
>Wav2Vec2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Kt=new ft({props:{$$slots:{default:[sr]},$$scope:{ctx:x}}}),bt=new Ct({props:{anchor:"transformers.Wav2Vec2ForAudioFrameClassification.forward.example",$$slots:{default:[rr]},$$scope:{ctx:x}}}),Rt=new te({props:{title:"Wav2Vec2ForXVector",local:"transformers.Wav2Vec2ForXVector",headingTag:"h2"}}),Nt=new U({props:{name:"class transformers.Wav2Vec2ForXVector",anchor:"transformers.Wav2Vec2ForXVector",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2ForXVector.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L2668"}}),ko=new U({props:{name:"forward",anchor:"transformers.Wav2Vec2ForXVector.forward",parameters:[{name:"input_values",val:": Optional"},{name:"attention_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"labels",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Wav2Vec2ForXVector.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.Wav2Vec2ForXVector.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p><code>attention_mask</code> should only be passed if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">wav2vec2-base</a>, <code>attention_mask</code> should <strong>not</strong> be
passed to avoid degraded performance when doing batched inference. For such models <code>input_values</code> should
simply be padded with 0 and passed without <code>attention_mask</code>. Be aware that these models also yield slightly
different results depending on whether <code>input_values</code> is padded or not.</p>

					</div>`,name:"attention_mask"},{anchor:"transformers.Wav2Vec2ForXVector.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Wav2Vec2ForXVector.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Wav2Vec2ForXVector.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Wav2Vec2ForXVector.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L2736",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.XVectorOutput"
>transformers.modeling_outputs.XVectorOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config"
>Wav2Vec2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.xvector_output_dim)</code>) — Classification hidden states before AMSoftmax.</p>
</li>
<li>
<p><strong>embeddings</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.xvector_output_dim)</code>) — Utterance embeddings used for vector similarity-based retrieval.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.XVectorOutput"
>transformers.modeling_outputs.XVectorOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),yt=new ft({props:{$$slots:{default:[lr]},$$scope:{ctx:x}}}),xt=new Ct({props:{anchor:"transformers.Wav2Vec2ForXVector.forward.example",$$slots:{default:[ir]},$$scope:{ctx:x}}}),io=new te({props:{title:"Wav2Vec2ForPreTraining",local:"transformers.Wav2Vec2ForPreTraining",headingTag:"h2"}}),po=new U({props:{name:"class transformers.Wav2Vec2ForPreTraining",anchor:"transformers.Wav2Vec2ForPreTraining",parameters:[{name:"config",val:": Wav2Vec2Config"}],parametersDescription:[{anchor:"transformers.Wav2Vec2ForPreTraining.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L1947"}}),Ht=new U({props:{name:"forward",anchor:"transformers.Wav2Vec2ForPreTraining.forward",parameters:[{name:"input_values",val:": Optional"},{name:"attention_mask",val:": Optional = None"},{name:"mask_time_indices",val:": Optional = None"},{name:"sampled_negative_indices",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Wav2Vec2ForPreTraining.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.Wav2Vec2ForPreTraining.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p><code>attention_mask</code> should only be passed if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">wav2vec2-base</a>, <code>attention_mask</code> should <strong>not</strong> be
passed to avoid degraded performance when doing batched inference. For such models <code>input_values</code> should
simply be padded with 0 and passed without <code>attention_mask</code>. Be aware that these models also yield slightly
different results depending on whether <code>input_values</code> is padded or not.</p>

					</div>`,name:"attention_mask"},{anchor:"transformers.Wav2Vec2ForPreTraining.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Wav2Vec2ForPreTraining.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Wav2Vec2ForPreTraining.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Wav2Vec2ForPreTraining.forward.mask_time_indices",description:`<strong>mask_time_indices</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices to mask extracted features for contrastive loss. When in training mode, model learns to predict
masked extracted features in <em>config.proj_codevector_dim</em> space.`,name:"mask_time_indices"},{anchor:"transformers.Wav2Vec2ForPreTraining.forward.sampled_negative_indices",description:`<strong>sampled_negative_indices</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length, num_negatives)</code>, <em>optional</em>) &#x2014;
Indices indicating which quantized target vectors are used as negative sampled vectors in contrastive loss.
Required input for pre-training.`,name:"sampled_negative_indices"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L2008",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput"
>transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config"
>Wav2Vec2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<em>optional</em>, returned when <code>sample_negative_indices</code> are passed, <code>torch.FloatTensor</code> of shape <code>(1,)</code>) — Total loss as the sum of the contrastive loss (L_m) and the diversity loss (L_d) as stated in the <a
  href="https://arxiv.org/pdf/2006.11477.pdf"
  rel="nofollow"
>official
paper</a> . (classification) loss.</p>
</li>
<li>
<p><strong>projected_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.proj_codevector_dim)</code>) — Hidden-states of the model projected to <em>config.proj_codevector_dim</em> that can be used to predict the masked
projected quantized states.</p>
</li>
<li>
<p><strong>projected_quantized_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.proj_codevector_dim)</code>) — Quantized extracted feature vectors projected to <em>config.proj_codevector_dim</em> representing the positive
target vectors for contrastive loss.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>contrastive_loss</strong> (<em>optional</em>, returned when <code>sample_negative_indices</code> are passed, <code>torch.FloatTensor</code> of shape <code>(1,)</code>) — The contrastive loss (L_m) as stated in the <a
  href="https://arxiv.org/pdf/2006.11477.pdf"
  rel="nofollow"
>official paper</a> .</p>
</li>
<li>
<p><strong>diversity_loss</strong> (<em>optional</em>, returned when <code>sample_negative_indices</code> are passed, <code>torch.FloatTensor</code> of shape <code>(1,)</code>) — The diversity loss (L_d) as stated in the <a
  href="https://arxiv.org/pdf/2006.11477.pdf"
  rel="nofollow"
>official paper</a> .</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput"
>transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),to=new ft({props:{$$slots:{default:[cr]},$$scope:{ctx:x}}}),Mt=new Ct({props:{anchor:"transformers.Wav2Vec2ForPreTraining.forward.example",$$slots:{default:[dr]},$$scope:{ctx:x}}}),{c(){u(t.$$.fragment),y=s(),n=c("div"),u(i.$$.fragment),M=s(),o=c("p"),o.innerHTML=j,we=s(),B=c("p"),B.innerHTML=O,Me=s(),X=c("p"),X.innerHTML=K,Te=s(),k=c("div"),u(G.$$.fragment),re=s(),P=c("p"),P.innerHTML=Dt,Ee=s(),u(N.$$.fragment),Ie=s(),u(Q.$$.fragment),nt=s(),u(ce.$$.fragment),$e=s(),I=c("div"),u(de.$$.fragment),le=s(),pe=c("p"),pe.innerHTML=je,Be=s(),z=c("p"),z.innerHTML=st,Xe=s(),oe=c("p"),oe.innerHTML=ae,Ge=s(),H=c("div"),u(ke.$$.fragment),rt=s(),We=c("p"),We.innerHTML=Re,Et=s(),u(me.$$.fragment),Ce=s(),u(Ne.$$.fragment),xe=s(),S=c("div"),u(ge.$$.fragment),q=s(),ee=c("p"),ee.textContent=Pe,qe=s(),u(Qe.$$.fragment),Se=s(),u(L.$$.fragment),Ye=s(),u(A.$$.fragment),Ae=s(),T=c("div"),u(F.$$.fragment),Z=s(),ie=c("p"),ie.textContent=pt,R=s(),ne=c("p"),ne.innerHTML=mt,Pt=s(),Ft=c("p"),Ft.innerHTML=Ut,Qt=s(),Zt=c("p"),Zt.innerHTML=zt,St=s(),He=c("div"),u(De.$$.fragment),jt=s(),_e=c("p"),_e.innerHTML=It,Le=s(),u(ve.$$.fragment),bo=s(),u(Oe.$$.fragment),Bt=s(),u(Xt.$$.fragment),ht=s(),E=c("div"),u(Fe.$$.fragment),gt=s(),W=c("p"),W.textContent=J,be=s(),D=c("p"),D.innerHTML=Ue,he=s(),Ve=c("p"),Ve.innerHTML=Ot,Ua=s(),yo=c("p"),yo.innerHTML=no,so=s(),_t=c("div"),u(Gt.$$.fragment),Za=s(),wo=c("p"),wo.innerHTML=$o,ro=s(),u(Kt.$$.fragment),vt=s(),u(bt.$$.fragment),Bo=s(),u(Rt.$$.fragment),Ko=s(),Ze=c("div"),u(Nt.$$.fragment),za=s(),Mo=c("p"),Mo.textContent=lo,ea=s(),kt=c("p"),kt.innerHTML=To,ta=s(),At=c("p"),At.innerHTML=cn,oa=s(),Wt=c("p"),Wt.innerHTML=jo,aa=s(),Ke=c("div"),u(ko.$$.fragment),Xo=s(),qt=c("p"),qt.innerHTML=na,ut=s(),u(yt.$$.fragment),sa=s(),u(xt.$$.fragment),ra=s(),u(io.$$.fragment),co=s(),lt=c("div"),u(po.$$.fragment),eo=s(),Yt=c("p"),Yt.innerHTML=Ia,Wo=s(),Co=c("p"),Co.innerHTML=la,mo=s(),ho=c("p"),ho.innerHTML=se,uo=s(),wt=c("div"),u(Ht.$$.fragment),Ba=s(),xo=c("p"),xo.innerHTML=Fo,Xa=s(),u(to.$$.fragment),oo=s(),u(Mt.$$.fragment),this.h()},l(h){f(t.$$.fragment,h),y=r(h),n=d(h,"DIV",{class:!0});var V=$(n);f(i.$$.fragment,V),M=r(V),o=d(V,"P",{"data-svelte-h":!0}),m(o)!=="svelte-te9mu1"&&(o.innerHTML=j),we=r(V),B=d(V,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1c8p9n2"&&(B.innerHTML=O),Me=r(V),X=d(V,"P",{"data-svelte-h":!0}),m(X)!=="svelte-68lg8f"&&(X.innerHTML=K),Te=r(V),k=d(V,"DIV",{class:!0});var Vt=$(k);f(G.$$.fragment,Vt),re=r(Vt),P=d(Vt,"P",{"data-svelte-h":!0}),m(P)!=="svelte-wrinab"&&(P.innerHTML=Dt),Ee=r(Vt),f(N.$$.fragment,Vt),Ie=r(Vt),f(Q.$$.fragment,Vt),Vt.forEach(l),V.forEach(l),nt=r(h),f(ce.$$.fragment,h),$e=r(h),I=d(h,"DIV",{class:!0});var ue=$(I);f(de.$$.fragment,ue),le=r(ue),pe=d(ue,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-1p0g25y"&&(pe.innerHTML=je),Be=r(ue),z=d(ue,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1c8p9n2"&&(z.innerHTML=st),Xe=r(ue),oe=d(ue,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-68lg8f"&&(oe.innerHTML=ae),Ge=r(ue),H=d(ue,"DIV",{class:!0});var et=$(H);f(ke.$$.fragment,et),rt=r(et),We=d(et,"P",{"data-svelte-h":!0}),m(We)!=="svelte-pev92p"&&(We.innerHTML=Re),Et=r(et),f(me.$$.fragment,et),Ce=r(et),f(Ne.$$.fragment,et),et.forEach(l),xe=r(ue),S=d(ue,"DIV",{class:!0});var Jt=$(S);f(ge.$$.fragment,Jt),q=r(Jt),ee=d(Jt,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-1uzynjt"&&(ee.textContent=Pe),qe=r(Jt),f(Qe.$$.fragment,Jt),Se=r(Jt),f(L.$$.fragment,Jt),Jt.forEach(l),ue.forEach(l),Ye=r(h),f(A.$$.fragment,h),Ae=r(h),T=d(h,"DIV",{class:!0});var Je=$(T);f(F.$$.fragment,Je),Z=r(Je),ie=d(Je,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-dzph96"&&(ie.textContent=pt),R=r(Je),ne=d(Je,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-q3avhg"&&(ne.innerHTML=mt),Pt=r(Je),Ft=d(Je,"P",{"data-svelte-h":!0}),m(Ft)!=="svelte-1c8p9n2"&&(Ft.innerHTML=Ut),Qt=r(Je),Zt=d(Je,"P",{"data-svelte-h":!0}),m(Zt)!=="svelte-68lg8f"&&(Zt.innerHTML=zt),St=r(Je),He=d(Je,"DIV",{class:!0});var Lt=$(He);f(De.$$.fragment,Lt),jt=r(Lt),_e=d(Lt,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-12eo633"&&(_e.innerHTML=It),Le=r(Lt),f(ve.$$.fragment,Lt),bo=r(Lt),f(Oe.$$.fragment,Lt),Lt.forEach(l),Je.forEach(l),Bt=r(h),f(Xt.$$.fragment,h),ht=r(h),E=d(h,"DIV",{class:!0});var tt=$(E);f(Fe.$$.fragment,tt),gt=r(tt),W=d(tt,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1jplo9i"&&(W.textContent=J),be=r(tt),D=d(tt,"P",{"data-svelte-h":!0}),m(D)!=="svelte-q3avhg"&&(D.innerHTML=Ue),he=r(tt),Ve=d(tt,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-1c8p9n2"&&(Ve.innerHTML=Ot),Ua=r(tt),yo=d(tt,"P",{"data-svelte-h":!0}),m(yo)!=="svelte-68lg8f"&&(yo.innerHTML=no),so=r(tt),_t=d(tt,"DIV",{class:!0});var it=$(_t);f(Gt.$$.fragment,it),Za=r(it),wo=d(it,"P",{"data-svelte-h":!0}),m(wo)!=="svelte-13qqpjf"&&(wo.innerHTML=$o),ro=r(it),f(Kt.$$.fragment,it),vt=r(it),f(bt.$$.fragment,it),it.forEach(l),tt.forEach(l),Bo=r(h),f(Rt.$$.fragment,h),Ko=r(h),Ze=d(h,"DIV",{class:!0});var ye=$(Ze);f(Nt.$$.fragment,ye),za=r(ye),Mo=d(ye,"P",{"data-svelte-h":!0}),m(Mo)!=="svelte-nregqm"&&(Mo.textContent=lo),ea=r(ye),kt=d(ye,"P",{"data-svelte-h":!0}),m(kt)!=="svelte-q3avhg"&&(kt.innerHTML=To),ta=r(ye),At=d(ye,"P",{"data-svelte-h":!0}),m(At)!=="svelte-1c8p9n2"&&(At.innerHTML=cn),oa=r(ye),Wt=d(ye,"P",{"data-svelte-h":!0}),m(Wt)!=="svelte-68lg8f"&&(Wt.innerHTML=jo),aa=r(ye),Ke=d(ye,"DIV",{class:!0});var $t=$(Ke);f(ko.$$.fragment,$t),Xo=r($t),qt=d($t,"P",{"data-svelte-h":!0}),m(qt)!=="svelte-15h6ynb"&&(qt.innerHTML=na),ut=r($t),f(yt.$$.fragment,$t),sa=r($t),f(xt.$$.fragment,$t),$t.forEach(l),ye.forEach(l),ra=r(h),f(io.$$.fragment,h),co=r(h),lt=d(h,"DIV",{class:!0});var fe=$(lt);f(po.$$.fragment,fe),eo=r(fe),Yt=d(fe,"P",{"data-svelte-h":!0}),m(Yt)!=="svelte-wn7jg8"&&(Yt.innerHTML=Ia),Wo=r(fe),Co=d(fe,"P",{"data-svelte-h":!0}),m(Co)!=="svelte-1c8p9n2"&&(Co.innerHTML=la),mo=r(fe),ho=d(fe,"P",{"data-svelte-h":!0}),m(ho)!=="svelte-68lg8f"&&(ho.innerHTML=se),uo=r(fe),wt=d(fe,"DIV",{class:!0});var ot=$(wt);f(Ht.$$.fragment,ot),Ba=r(ot),xo=d(ot,"P",{"data-svelte-h":!0}),m(xo)!=="svelte-19gumb7"&&(xo.innerHTML=Fo),Xa=r(ot),f(to.$$.fragment,ot),oo=r(ot),f(Mt.$$.fragment,ot),ot.forEach(l),fe.forEach(l),this.h()},h(){C(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(h,V){g(t,h,V),p(h,y,V),p(h,n,V),g(i,n,null),a(n,M),a(n,o),a(n,we),a(n,B),a(n,Me),a(n,X),a(n,Te),a(n,k),g(G,k,null),a(k,re),a(k,P),a(k,Ee),g(N,k,null),a(k,Ie),g(Q,k,null),p(h,nt,V),g(ce,h,V),p(h,$e,V),p(h,I,V),g(de,I,null),a(I,le),a(I,pe),a(I,Be),a(I,z),a(I,Xe),a(I,oe),a(I,Ge),a(I,H),g(ke,H,null),a(H,rt),a(H,We),a(H,Et),g(me,H,null),a(H,Ce),g(Ne,H,null),a(I,xe),a(I,S),g(ge,S,null),a(S,q),a(S,ee),a(S,qe),g(Qe,S,null),a(S,Se),g(L,S,null),p(h,Ye,V),g(A,h,V),p(h,Ae,V),p(h,T,V),g(F,T,null),a(T,Z),a(T,ie),a(T,R),a(T,ne),a(T,Pt),a(T,Ft),a(T,Qt),a(T,Zt),a(T,St),a(T,He),g(De,He,null),a(He,jt),a(He,_e),a(He,Le),g(ve,He,null),a(He,bo),g(Oe,He,null),p(h,Bt,V),g(Xt,h,V),p(h,ht,V),p(h,E,V),g(Fe,E,null),a(E,gt),a(E,W),a(E,be),a(E,D),a(E,he),a(E,Ve),a(E,Ua),a(E,yo),a(E,so),a(E,_t),g(Gt,_t,null),a(_t,Za),a(_t,wo),a(_t,ro),g(Kt,_t,null),a(_t,vt),g(bt,_t,null),p(h,Bo,V),g(Rt,h,V),p(h,Ko,V),p(h,Ze,V),g(Nt,Ze,null),a(Ze,za),a(Ze,Mo),a(Ze,ea),a(Ze,kt),a(Ze,ta),a(Ze,At),a(Ze,oa),a(Ze,Wt),a(Ze,aa),a(Ze,Ke),g(ko,Ke,null),a(Ke,Xo),a(Ke,qt),a(Ke,ut),g(yt,Ke,null),a(Ke,sa),g(xt,Ke,null),p(h,ra,V),g(io,h,V),p(h,co,V),p(h,lt,V),g(po,lt,null),a(lt,eo),a(lt,Yt),a(lt,Wo),a(lt,Co),a(lt,mo),a(lt,ho),a(lt,uo),a(lt,wt),g(Ht,wt,null),a(wt,Ba),a(wt,xo),a(wt,Xa),g(to,wt,null),a(wt,oo),g(Mt,wt,null),Go=!0},p(h,V){const Vt={};V&2&&(Vt.$$scope={dirty:V,ctx:h}),N.$set(Vt);const ue={};V&2&&(ue.$$scope={dirty:V,ctx:h}),Q.$set(ue);const et={};V&2&&(et.$$scope={dirty:V,ctx:h}),me.$set(et);const Jt={};V&2&&(Jt.$$scope={dirty:V,ctx:h}),Ne.$set(Jt);const Je={};V&2&&(Je.$$scope={dirty:V,ctx:h}),Qe.$set(Je);const Lt={};V&2&&(Lt.$$scope={dirty:V,ctx:h}),L.$set(Lt);const tt={};V&2&&(tt.$$scope={dirty:V,ctx:h}),ve.$set(tt);const it={};V&2&&(it.$$scope={dirty:V,ctx:h}),Oe.$set(it);const ye={};V&2&&(ye.$$scope={dirty:V,ctx:h}),Kt.$set(ye);const $t={};V&2&&($t.$$scope={dirty:V,ctx:h}),bt.$set($t);const fe={};V&2&&(fe.$$scope={dirty:V,ctx:h}),yt.$set(fe);const ot={};V&2&&(ot.$$scope={dirty:V,ctx:h}),xt.$set(ot);const Ga={};V&2&&(Ga.$$scope={dirty:V,ctx:h}),to.$set(Ga);const Uo={};V&2&&(Uo.$$scope={dirty:V,ctx:h}),Mt.$set(Uo)},i(h){Go||(_(t.$$.fragment,h),_(i.$$.fragment,h),_(G.$$.fragment,h),_(N.$$.fragment,h),_(Q.$$.fragment,h),_(ce.$$.fragment,h),_(de.$$.fragment,h),_(ke.$$.fragment,h),_(me.$$.fragment,h),_(Ne.$$.fragment,h),_(ge.$$.fragment,h),_(Qe.$$.fragment,h),_(L.$$.fragment,h),_(A.$$.fragment,h),_(F.$$.fragment,h),_(De.$$.fragment,h),_(ve.$$.fragment,h),_(Oe.$$.fragment,h),_(Xt.$$.fragment,h),_(Fe.$$.fragment,h),_(Gt.$$.fragment,h),_(Kt.$$.fragment,h),_(bt.$$.fragment,h),_(Rt.$$.fragment,h),_(Nt.$$.fragment,h),_(ko.$$.fragment,h),_(yt.$$.fragment,h),_(xt.$$.fragment,h),_(io.$$.fragment,h),_(po.$$.fragment,h),_(Ht.$$.fragment,h),_(to.$$.fragment,h),_(Mt.$$.fragment,h),Go=!0)},o(h){v(t.$$.fragment,h),v(i.$$.fragment,h),v(G.$$.fragment,h),v(N.$$.fragment,h),v(Q.$$.fragment,h),v(ce.$$.fragment,h),v(de.$$.fragment,h),v(ke.$$.fragment,h),v(me.$$.fragment,h),v(Ne.$$.fragment,h),v(ge.$$.fragment,h),v(Qe.$$.fragment,h),v(L.$$.fragment,h),v(A.$$.fragment,h),v(F.$$.fragment,h),v(De.$$.fragment,h),v(ve.$$.fragment,h),v(Oe.$$.fragment,h),v(Xt.$$.fragment,h),v(Fe.$$.fragment,h),v(Gt.$$.fragment,h),v(Kt.$$.fragment,h),v(bt.$$.fragment,h),v(Rt.$$.fragment,h),v(Nt.$$.fragment,h),v(ko.$$.fragment,h),v(yt.$$.fragment,h),v(xt.$$.fragment,h),v(io.$$.fragment,h),v(po.$$.fragment,h),v(Ht.$$.fragment,h),v(to.$$.fragment,h),v(Mt.$$.fragment,h),Go=!1},d(h){h&&(l(y),l(n),l(nt),l($e),l(I),l(Ye),l(Ae),l(T),l(Bt),l(ht),l(E),l(Bo),l(Ko),l(Ze),l(ra),l(co),l(lt)),b(t,h),b(i),b(G),b(N),b(Q),b(ce,h),b(de),b(ke),b(me),b(Ne),b(ge),b(Qe),b(L),b(A,h),b(F),b(De),b(ve),b(Oe),b(Xt,h),b(Fe),b(Gt),b(Kt),b(bt),b(Rt,h),b(Nt),b(ko),b(yt),b(xt),b(io,h),b(po),b(Ht),b(to),b(Mt)}}}function mr(x){let t,y;return t=new fs({props:{$$slots:{default:[pr]},$$scope:{ctx:x}}}),{c(){u(t.$$.fragment)},l(n){f(t.$$.fragment,n)},m(n,i){g(t,n,i),y=!0},p(n,i){const M={};i&2&&(M.$$scope={dirty:i,ctx:n}),t.$set(M)},i(n){y||(_(t.$$.fragment,n),y=!0)},o(n){v(t.$$.fragment,n),y=!1},d(n){b(t,n)}}}function hr(x){let t,y="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",n,i,M="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,j,we=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,B,O,Me=`<li>a single Tensor with <code>input_values</code> only and nothing else: <code>model(input_values)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_values, attention_mask])</code> or <code>model([input_values, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_values&quot;: input_values, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,X,K,Te=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){t=c("p"),t.innerHTML=y,n=s(),i=c("ul"),i.innerHTML=M,o=s(),j=c("p"),j.innerHTML=we,B=s(),O=c("ul"),O.innerHTML=Me,X=s(),K=c("p"),K.innerHTML=Te},l(k){t=d(k,"P",{"data-svelte-h":!0}),m(t)!=="svelte-1ajbfxg"&&(t.innerHTML=y),n=r(k),i=d(k,"UL",{"data-svelte-h":!0}),m(i)!=="svelte-qm1t26"&&(i.innerHTML=M),o=r(k),j=d(k,"P",{"data-svelte-h":!0}),m(j)!=="svelte-1v9qsc5"&&(j.innerHTML=we),B=r(k),O=d(k,"UL",{"data-svelte-h":!0}),m(O)!=="svelte-1x9eg56"&&(O.innerHTML=Me),X=r(k),K=d(k,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1an3odd"&&(K.innerHTML=Te)},m(k,G){p(k,t,G),p(k,n,G),p(k,i,G),p(k,o,G),p(k,j,G),p(k,B,G),p(k,O,G),p(k,X,G),p(k,K,G)},p:Y,d(k){k&&(l(t),l(n),l(i),l(o),l(j),l(B),l(O),l(X),l(K))}}}function ur(x){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=y},l(n){t=d(n,"P",{"data-svelte-h":!0}),m(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(n,i){p(n,t,i)},p:Y,d(n){n&&l(t)}}}function fr(x){let t,y="Example:",n,i,M;return i=new dt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBURldhdjJWZWMyTW9kZWwlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjBzb3VuZGZpbGUlMjBhcyUyMHNmJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZ3YXYydmVjMi1iYXNlLTk2MGglMjIpJTBBbW9kZWwlMjAlM0QlMjBURldhdjJWZWMyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS05NjBoJTIyKSUwQSUwQSUwQWRlZiUyMG1hcF90b19hcnJheShiYXRjaCklM0ElMEElMjAlMjAlMjAlMjBzcGVlY2glMkMlMjBfJTIwJTNEJTIwc2YucmVhZChiYXRjaCU1QiUyMmZpbGUlMjIlNUQpJTBBJTIwJTIwJTIwJTIwYmF0Y2glNUIlMjJzcGVlY2glMjIlNUQlMjAlM0QlMjBzcGVlY2glMEElMjAlMjAlMjAlMjByZXR1cm4lMjBiYXRjaCUwQSUwQSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkcyUyMCUzRCUyMGRzLm1hcChtYXBfdG9fYXJyYXkpJTBBJTBBaW5wdXRfdmFsdWVzJTIwJTNEJTIwcHJvY2Vzc29yKGRzJTVCJTIyc3BlZWNoJTIyJTVEJTVCMCU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpLmlucHV0X3ZhbHVlcyUyMCUyMCUyMyUyMEJhdGNoJTIwc2l6ZSUyMDElMEFoaWRkZW5fc3RhdGVzJTIwJTNEJTIwbW9kZWwoaW5wdXRfdmFsdWVzKS5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, TFWav2Vec2Model
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> soundfile <span class="hljs-keyword">as</span> sf

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFWav2Vec2Model.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">map_to_array</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    speech, _ = sf.read(batch[<span class="hljs-string">&quot;file&quot;</span>])
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;speech&quot;</span>] = speech
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch


<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.<span class="hljs-built_in">map</span>(map_to_array)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = processor(ds[<span class="hljs-string">&quot;speech&quot;</span>][<span class="hljs-number">0</span>], return_tensors=<span class="hljs-string">&quot;tf&quot;</span>).input_values  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hidden_states = model(input_values).last_hidden_state`,wrap:!1}}),{c(){t=c("p"),t.textContent=y,n=s(),u(i.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),m(t)!=="svelte-11lpom8"&&(t.textContent=y),n=r(o),f(i.$$.fragment,o)},m(o,j){p(o,t,j),p(o,n,j),g(i,o,j),M=!0},p:Y,i(o){M||(_(i.$$.fragment,o),M=!0)},o(o){v(i.$$.fragment,o),M=!1},d(o){o&&(l(t),l(n)),b(i,o)}}}function gr(x){let t,y="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",n,i,M="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,j,we=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,B,O,Me=`<li>a single Tensor with <code>input_values</code> only and nothing else: <code>model(input_values)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_values, attention_mask])</code> or <code>model([input_values, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_values&quot;: input_values, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,X,K,Te=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){t=c("p"),t.innerHTML=y,n=s(),i=c("ul"),i.innerHTML=M,o=s(),j=c("p"),j.innerHTML=we,B=s(),O=c("ul"),O.innerHTML=Me,X=s(),K=c("p"),K.innerHTML=Te},l(k){t=d(k,"P",{"data-svelte-h":!0}),m(t)!=="svelte-1ajbfxg"&&(t.innerHTML=y),n=r(k),i=d(k,"UL",{"data-svelte-h":!0}),m(i)!=="svelte-qm1t26"&&(i.innerHTML=M),o=r(k),j=d(k,"P",{"data-svelte-h":!0}),m(j)!=="svelte-1v9qsc5"&&(j.innerHTML=we),B=r(k),O=d(k,"UL",{"data-svelte-h":!0}),m(O)!=="svelte-1x9eg56"&&(O.innerHTML=Me),X=r(k),K=d(k,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1an3odd"&&(K.innerHTML=Te)},m(k,G){p(k,t,G),p(k,n,G),p(k,i,G),p(k,o,G),p(k,j,G),p(k,B,G),p(k,O,G),p(k,X,G),p(k,K,G)},p:Y,d(k){k&&(l(t),l(n),l(i),l(o),l(j),l(B),l(O),l(X),l(K))}}}function _r(x){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=y},l(n){t=d(n,"P",{"data-svelte-h":!0}),m(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(n,i){p(n,t,i)},p:Y,d(n){n&&l(t)}}}function vr(x){let t,y="Example:",n,i,M;return i=new dt({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMFRGV2F2MlZlYzJGb3JDVEMlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjBzb3VuZGZpbGUlMjBhcyUyMHNmJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZ3YXYydmVjMi1iYXNlLTk2MGglMjIpJTBBbW9kZWwlMjAlM0QlMjBURldhdjJWZWMyRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRndhdjJ2ZWMyLWJhc2UtOTYwaCUyMiklMEElMEElMEFkZWYlMjBtYXBfdG9fYXJyYXkoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwc3BlZWNoJTJDJTIwXyUyMCUzRCUyMHNmLnJlYWQoYmF0Y2glNUIlMjJmaWxlJTIyJTVEKSUwQSUyMCUyMCUyMCUyMGJhdGNoJTVCJTIyc3BlZWNoJTIyJTVEJTIwJTNEJTIwc3BlZWNoJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYmF0Y2glMEElMEElMEFkcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBZHMlMjAlM0QlMjBkcy5tYXAobWFwX3RvX2FycmF5KSUwQSUwQWlucHV0X3ZhbHVlcyUyMCUzRCUyMHByb2Nlc3NvcihkcyU1QiUyMnNwZWVjaCUyMiU1RCU1QjAlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKS5pbnB1dF92YWx1ZXMlMjAlMjAlMjMlMjBCYXRjaCUyMHNpemUlMjAxJTBBbG9naXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRfdmFsdWVzKS5sb2dpdHMlMEFwcmVkaWN0ZWRfaWRzJTIwJTNEJTIwdGYuYXJnbWF4KGxvZ2l0cyUyQyUyMGF4aXMlM0QtMSklMEElMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmRlY29kZShwcmVkaWN0ZWRfaWRzJTVCMCU1RCklMEElMEElMjMlMjBjb21wdXRlJTIwbG9zcyUwQXRhcmdldF90cmFuc2NyaXB0aW9uJTIwJTNEJTIwJTIyQSUyME1BTiUyMFNBSUQlMjBUTyUyMFRIRSUyMFVOSVZFUlNFJTIwU0lSJTIwSSUyMEVYSVNUJTIyJTBBJTBBJTIzJTIwUGFzcyUyMHRyYW5zY3JpcHRpb24lMjBhcyUyMCU2MHRleHQlNjAlMjB0byUyMGVuY29kZSUyMGxhYmVscyUwQWxhYmVscyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdHJhbnNjcmlwdGlvbiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpLmlucHV0X2lkcyUwQSUwQWxvc3MlMjAlM0QlMjBtb2RlbChpbnB1dF92YWx1ZXMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpLmxvc3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, TFWav2Vec2ForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> soundfile <span class="hljs-keyword">as</span> sf

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFWav2Vec2ForCTC.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">map_to_array</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    speech, _ = sf.read(batch[<span class="hljs-string">&quot;file&quot;</span>])
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;speech&quot;</span>] = speech
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch


<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.<span class="hljs-built_in">map</span>(map_to_array)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = processor(ds[<span class="hljs-string">&quot;speech&quot;</span>][<span class="hljs-number">0</span>], return_tensors=<span class="hljs-string">&quot;tf&quot;</span>).input_values  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(input_values).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = tf.argmax(logits, axis=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.decode(predicted_ids[<span class="hljs-number">0</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute loss</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_transcription = <span class="hljs-string">&quot;A MAN SAID TO THE UNIVERSE SIR I EXIST&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pass transcription as \`text\` to encode labels</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = processor(text=transcription, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(input_values, labels=labels).loss`,wrap:!1}}),{c(){t=c("p"),t.textContent=y,n=s(),u(i.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),m(t)!=="svelte-11lpom8"&&(t.textContent=y),n=r(o),f(i.$$.fragment,o)},m(o,j){p(o,t,j),p(o,n,j),g(i,o,j),M=!0},p:Y,i(o){M||(_(i.$$.fragment,o),M=!0)},o(o){v(i.$$.fragment,o),M=!1},d(o){o&&(l(t),l(n)),b(i,o)}}}function br(x){let t,y,n,i,M,o,j="The bare TFWav2Vec2 Model transformer outputing raw hidden-states without any specific head on top.",we,B,O=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Me,X,K=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,Te,k,G,re,P,Dt,Ee,N='The <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.TFWav2Vec2Model">TFWav2Vec2Model</a> forward method, overrides the <code>__call__</code> special method.',Ie,Q,nt,ce,$e,I,de,le,pe,je,Be,z,st,Xe,oe,ae,Ge,H,ke,rt="TFWav2Vec2 Model with a <code>language modeling</code> head on top for Connectionist Temporal Classification (CTC).",We,Re,Et=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,me,Ce,Ne=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,xe,S,ge,q,ee,Pe,qe,Qe='The <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.TFWav2Vec2ForCTC">TFWav2Vec2ForCTC</a> forward method, overrides the <code>__call__</code> special method.',Se,L,Ye,A,Ae;return t=new te({props:{title:"TFWav2Vec2Model",local:"transformers.TFWav2Vec2Model",headingTag:"h2"}}),i=new U({props:{name:"class transformers.TFWav2Vec2Model",anchor:"transformers.TFWav2Vec2Model",parameters:[{name:"config",val:": Wav2Vec2Config"},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFWav2Vec2Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_tf_wav2vec2.py#L1502"}}),k=new ft({props:{$$slots:{default:[hr]},$$scope:{ctx:x}}}),P=new U({props:{name:"call",anchor:"transformers.TFWav2Vec2Model.call",parameters:[{name:"input_values",val:": tf.Tensor"},{name:"attention_mask",val:": tf.Tensor | None = None"},{name:"token_type_ids",val:": tf.Tensor | None = None"},{name:"position_ids",val:": tf.Tensor | None = None"},{name:"head_mask",val:": tf.Tensor | None = None"},{name:"inputs_embeds",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFWav2Vec2Model.call.input_values",description:`<strong>input_values</strong> (<code>np.ndarray</code>, <code>tf.Tensor</code>, <code>List[tf.Tensor]</code> <code>Dict[str, tf.Tensor]</code> or <code>Dict[str, np.ndarray]</code> and each example must have the shape <code>({0})</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_values"},{anchor:"transformers.TFWav2Vec2Model.call.attention_mask",description:`<strong>attention_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFWav2Vec2Model.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFWav2Vec2Model.call.position_ids",description:`<strong>position_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFWav2Vec2Model.call.head_mask",description:`<strong>head_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFWav2Vec2Model.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0}, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_values</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_values</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFWav2Vec2Model.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFWav2Vec2Model.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFWav2Vec2Model.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFWav2Vec2Model.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to \`False&#x201C;) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_tf_wav2vec2.py#L1512",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutput"
>transformers.modeling_tf_outputs.TFBaseModelOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config"
>Wav2Vec2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutput"
>transformers.modeling_tf_outputs.TFBaseModelOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),Q=new ft({props:{$$slots:{default:[ur]},$$scope:{ctx:x}}}),ce=new Ct({props:{anchor:"transformers.TFWav2Vec2Model.call.example",$$slots:{default:[fr]},$$scope:{ctx:x}}}),I=new te({props:{title:"TFWav2Vec2ForSequenceClassification",local:"transformers.TFWav2Vec2ForSequenceClassification",headingTag:"h2"}}),pe=new U({props:{name:"class transformers.TFWav2Vec2ForSequenceClassification",anchor:"transformers.TFWav2Vec2ForSequenceClassification",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_tf_wav2vec2.py#L1751"}}),z=new U({props:{name:"call",anchor:"transformers.TFWav2Vec2ForSequenceClassification.call",parameters:[{name:"input_values",val:": tf.Tensor"},{name:"attention_mask",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": bool | None = None"},{name:"output_hidden_states",val:": bool | None = None"},{name:"return_dict",val:": bool | None = None"},{name:"labels",val:": tf.Tensor | None = None"},{name:"training",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_tf_wav2vec2.py#L1792"}}),Xe=new te({props:{title:"TFWav2Vec2ForCTC",local:"transformers.TFWav2Vec2ForCTC",headingTag:"h2"}}),Ge=new U({props:{name:"class transformers.TFWav2Vec2ForCTC",anchor:"transformers.TFWav2Vec2ForCTC",parameters:[{name:"config",val:": Wav2Vec2Config"},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFWav2Vec2ForCTC.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_tf_wav2vec2.py#L1584"}}),S=new ft({props:{$$slots:{default:[gr]},$$scope:{ctx:x}}}),ee=new U({props:{name:"call",anchor:"transformers.TFWav2Vec2ForCTC.call",parameters:[{name:"input_values",val:": tf.Tensor"},{name:"attention_mask",val:": tf.Tensor | None = None"},{name:"token_type_ids",val:": tf.Tensor | None = None"},{name:"position_ids",val:": tf.Tensor | None = None"},{name:"head_mask",val:": tf.Tensor | None = None"},{name:"inputs_embeds",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"labels",val:": tf.Tensor | None = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFWav2Vec2ForCTC.call.input_values",description:`<strong>input_values</strong> (<code>np.ndarray</code>, <code>tf.Tensor</code>, <code>List[tf.Tensor]</code> <code>Dict[str, tf.Tensor]</code> or <code>Dict[str, np.ndarray]</code> and each example must have the shape <code>({0})</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_values"},{anchor:"transformers.TFWav2Vec2ForCTC.call.attention_mask",description:`<strong>attention_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFWav2Vec2ForCTC.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFWav2Vec2ForCTC.call.position_ids",description:`<strong>position_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFWav2Vec2ForCTC.call.head_mask",description:`<strong>head_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFWav2Vec2ForCTC.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0}, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_values</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_values</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFWav2Vec2ForCTC.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFWav2Vec2ForCTC.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFWav2Vec2ForCTC.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFWav2Vec2ForCTC.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to \`False&#x201C;) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFWav2Vec2ForCTC.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> or <code>np.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_values</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked),
the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_tf_wav2vec2.py#L1618",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFCausalLMOutput"
>transformers.modeling_tf_outputs.TFCausalLMOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config"
>Wav2Vec2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFCausalLMOutput"
>transformers.modeling_tf_outputs.TFCausalLMOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),L=new ft({props:{$$slots:{default:[_r]},$$scope:{ctx:x}}}),A=new Ct({props:{anchor:"transformers.TFWav2Vec2ForCTC.call.example",$$slots:{default:[vr]},$$scope:{ctx:x}}}),{c(){u(t.$$.fragment),y=s(),n=c("div"),u(i.$$.fragment),M=s(),o=c("p"),o.textContent=j,we=s(),B=c("p"),B.innerHTML=O,Me=s(),X=c("p"),X.innerHTML=K,Te=s(),u(k.$$.fragment),G=s(),re=c("div"),u(P.$$.fragment),Dt=s(),Ee=c("p"),Ee.innerHTML=N,Ie=s(),u(Q.$$.fragment),nt=s(),u(ce.$$.fragment),$e=s(),u(I.$$.fragment),de=s(),le=c("div"),u(pe.$$.fragment),je=s(),Be=c("div"),u(z.$$.fragment),st=s(),u(Xe.$$.fragment),oe=s(),ae=c("div"),u(Ge.$$.fragment),H=s(),ke=c("p"),ke.innerHTML=rt,We=s(),Re=c("p"),Re.innerHTML=Et,me=s(),Ce=c("p"),Ce.innerHTML=Ne,xe=s(),u(S.$$.fragment),ge=s(),q=c("div"),u(ee.$$.fragment),Pe=s(),qe=c("p"),qe.innerHTML=Qe,Se=s(),u(L.$$.fragment),Ye=s(),u(A.$$.fragment),this.h()},l(T){f(t.$$.fragment,T),y=r(T),n=d(T,"DIV",{class:!0});var F=$(n);f(i.$$.fragment,F),M=r(F),o=d(F,"P",{"data-svelte-h":!0}),m(o)!=="svelte-7z1r57"&&(o.textContent=j),we=r(F),B=d(F,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1qaxm70"&&(B.innerHTML=O),Me=r(F),X=d(F,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1be7e3c"&&(X.innerHTML=K),Te=r(F),f(k.$$.fragment,F),G=r(F),re=d(F,"DIV",{class:!0});var Z=$(re);f(P.$$.fragment,Z),Dt=r(Z),Ee=d(Z,"P",{"data-svelte-h":!0}),m(Ee)!=="svelte-1jsjtaf"&&(Ee.innerHTML=N),Ie=r(Z),f(Q.$$.fragment,Z),nt=r(Z),f(ce.$$.fragment,Z),Z.forEach(l),F.forEach(l),$e=r(T),f(I.$$.fragment,T),de=r(T),le=d(T,"DIV",{class:!0});var ie=$(le);f(pe.$$.fragment,ie),je=r(ie),Be=d(ie,"DIV",{class:!0});var pt=$(Be);f(z.$$.fragment,pt),pt.forEach(l),ie.forEach(l),st=r(T),f(Xe.$$.fragment,T),oe=r(T),ae=d(T,"DIV",{class:!0});var R=$(ae);f(Ge.$$.fragment,R),H=r(R),ke=d(R,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-uqrpa"&&(ke.innerHTML=rt),We=r(R),Re=d(R,"P",{"data-svelte-h":!0}),m(Re)!=="svelte-1qaxm70"&&(Re.innerHTML=Et),me=r(R),Ce=d(R,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-1be7e3c"&&(Ce.innerHTML=Ne),xe=r(R),f(S.$$.fragment,R),ge=r(R),q=d(R,"DIV",{class:!0});var ne=$(q);f(ee.$$.fragment,ne),Pe=r(ne),qe=d(ne,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-1kxw0at"&&(qe.innerHTML=Qe),Se=r(ne),f(L.$$.fragment,ne),Ye=r(ne),f(A.$$.fragment,ne),ne.forEach(l),R.forEach(l),this.h()},h(){C(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(T,F){g(t,T,F),p(T,y,F),p(T,n,F),g(i,n,null),a(n,M),a(n,o),a(n,we),a(n,B),a(n,Me),a(n,X),a(n,Te),g(k,n,null),a(n,G),a(n,re),g(P,re,null),a(re,Dt),a(re,Ee),a(re,Ie),g(Q,re,null),a(re,nt),g(ce,re,null),p(T,$e,F),g(I,T,F),p(T,de,F),p(T,le,F),g(pe,le,null),a(le,je),a(le,Be),g(z,Be,null),p(T,st,F),g(Xe,T,F),p(T,oe,F),p(T,ae,F),g(Ge,ae,null),a(ae,H),a(ae,ke),a(ae,We),a(ae,Re),a(ae,me),a(ae,Ce),a(ae,xe),g(S,ae,null),a(ae,ge),a(ae,q),g(ee,q,null),a(q,Pe),a(q,qe),a(q,Se),g(L,q,null),a(q,Ye),g(A,q,null),Ae=!0},p(T,F){const Z={};F&2&&(Z.$$scope={dirty:F,ctx:T}),k.$set(Z);const ie={};F&2&&(ie.$$scope={dirty:F,ctx:T}),Q.$set(ie);const pt={};F&2&&(pt.$$scope={dirty:F,ctx:T}),ce.$set(pt);const R={};F&2&&(R.$$scope={dirty:F,ctx:T}),S.$set(R);const ne={};F&2&&(ne.$$scope={dirty:F,ctx:T}),L.$set(ne);const mt={};F&2&&(mt.$$scope={dirty:F,ctx:T}),A.$set(mt)},i(T){Ae||(_(t.$$.fragment,T),_(i.$$.fragment,T),_(k.$$.fragment,T),_(P.$$.fragment,T),_(Q.$$.fragment,T),_(ce.$$.fragment,T),_(I.$$.fragment,T),_(pe.$$.fragment,T),_(z.$$.fragment,T),_(Xe.$$.fragment,T),_(Ge.$$.fragment,T),_(S.$$.fragment,T),_(ee.$$.fragment,T),_(L.$$.fragment,T),_(A.$$.fragment,T),Ae=!0)},o(T){v(t.$$.fragment,T),v(i.$$.fragment,T),v(k.$$.fragment,T),v(P.$$.fragment,T),v(Q.$$.fragment,T),v(ce.$$.fragment,T),v(I.$$.fragment,T),v(pe.$$.fragment,T),v(z.$$.fragment,T),v(Xe.$$.fragment,T),v(Ge.$$.fragment,T),v(S.$$.fragment,T),v(ee.$$.fragment,T),v(L.$$.fragment,T),v(A.$$.fragment,T),Ae=!1},d(T){T&&(l(y),l(n),l($e),l(de),l(le),l(st),l(oe),l(ae)),b(t,T),b(i),b(k),b(P),b(Q),b(ce),b(I,T),b(pe),b(z),b(Xe,T),b(Ge),b(S),b(ee),b(L),b(A)}}}function yr(x){let t,y;return t=new fs({props:{$$slots:{default:[br]},$$scope:{ctx:x}}}),{c(){u(t.$$.fragment)},l(n){f(t.$$.fragment,n)},m(n,i){g(t,n,i),y=!0},p(n,i){const M={};i&2&&(M.$$scope={dirty:i,ctx:n}),t.$set(M)},i(n){y||(_(t.$$.fragment,n),y=!0)},o(n){v(t.$$.fragment,n),y=!1},d(n){b(t,n)}}}function wr(x){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=y},l(n){t=d(n,"P",{"data-svelte-h":!0}),m(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(n,i){p(n,t,i)},p:Y,d(n){n&&l(t)}}}function Mr(x){let t,y="Example:",n,i,M;return i=new dt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBGbGF4V2F2MlZlYzJNb2RlbCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHNvdW5kZmlsZSUyMGFzJTIwc2YlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRndhdjJ2ZWMyLWxhcmdlLWx2NjAlMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4V2F2MlZlYzJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZ3YXYydmVjMi1sYXJnZS1sdjYwJTIyKSUwQSUwQSUwQWRlZiUyMG1hcF90b19hcnJheShiYXRjaCklM0ElMEElMjAlMjAlMjAlMjBzcGVlY2glMkMlMjBfJTIwJTNEJTIwc2YucmVhZChiYXRjaCU1QiUyMmZpbGUlMjIlNUQpJTBBJTIwJTIwJTIwJTIwYmF0Y2glNUIlMjJzcGVlY2glMjIlNUQlMjAlM0QlMjBzcGVlY2glMEElMjAlMjAlMjAlMjByZXR1cm4lMjBiYXRjaCUwQSUwQSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkcyUyMCUzRCUyMGRzLm1hcChtYXBfdG9fYXJyYXkpJTBBJTBBaW5wdXRfdmFsdWVzJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMGRzJTVCJTIyc3BlZWNoJTIyJTVEJTVCMCU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0QxNl8wMDAlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyJTBBKS5pbnB1dF92YWx1ZXMlMjAlMjAlMjMlMjBCYXRjaCUyMHNpemUlMjAxJTBBaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG1vZGVsKGlucHV0X3ZhbHVlcykubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, FlaxWav2Vec2Model
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> soundfile <span class="hljs-keyword">as</span> sf

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-large-lv60&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxWav2Vec2Model.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-large-lv60&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">map_to_array</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    speech, _ = sf.read(batch[<span class="hljs-string">&quot;file&quot;</span>])
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;speech&quot;</span>] = speech
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch


<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.<span class="hljs-built_in">map</span>(map_to_array)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = processor(
<span class="hljs-meta">... </span>    ds[<span class="hljs-string">&quot;speech&quot;</span>][<span class="hljs-number">0</span>], sampling_rate=<span class="hljs-number">16_000</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>
<span class="hljs-meta">... </span>).input_values  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hidden_states = model(input_values).last_hidden_state`,wrap:!1}}),{c(){t=c("p"),t.textContent=y,n=s(),u(i.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),m(t)!=="svelte-11lpom8"&&(t.textContent=y),n=r(o),f(i.$$.fragment,o)},m(o,j){p(o,t,j),p(o,n,j),g(i,o,j),M=!0},p:Y,i(o){M||(_(i.$$.fragment,o),M=!0)},o(o){v(i.$$.fragment,o),M=!1},d(o){o&&(l(t),l(n)),b(i,o)}}}function Tr(x){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=y},l(n){t=d(n,"P",{"data-svelte-h":!0}),m(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(n,i){p(n,t,i)},p:Y,d(n){n&&l(t)}}}function jr(x){let t,y="Example:",n,i,M;return i=new dt({props:{code:"aW1wb3J0JTIwamF4Lm51bXB5JTIwYXMlMjBqbnAlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMEZsYXhXYXYyVmVjMkZvckNUQyUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHNvdW5kZmlsZSUyMGFzJTIwc2YlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhXYXYyVmVjMkZvckNUQy5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZ3YXYydmVjMi1sYXJnZS05NjBoLWx2NjAlMjIpJTBBJTBBJTBBZGVmJTIwbWFwX3RvX2FycmF5KGJhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMHNwZWVjaCUyQyUyMF8lMjAlM0QlMjBzZi5yZWFkKGJhdGNoJTVCJTIyZmlsZSUyMiU1RCklMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMnNwZWVjaCUyMiU1RCUyMCUzRCUyMHNwZWVjaCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGJhdGNoJTBBJTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRzJTIwJTNEJTIwZHMubWFwKG1hcF90b19hcnJheSklMEElMEFpbnB1dF92YWx1ZXMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwZHMlNUIlMjJzcGVlY2glMjIlNUQlNUIwJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIlMEEpLmlucHV0X3ZhbHVlcyUyMCUyMCUyMyUyMEJhdGNoJTIwc2l6ZSUyMDElMEFsb2dpdHMlMjAlM0QlMjBtb2RlbChpbnB1dF92YWx1ZXMpLmxvZ2l0cyUwQXByZWRpY3RlZF9pZHMlMjAlM0QlMjBqbnAuYXJnbWF4KGxvZ2l0cyUyQyUyMGF4aXMlM0QtMSklMEElMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmRlY29kZShwcmVkaWN0ZWRfaWRzJTVCMCU1RCklMEElMjMlMjBzaG91bGQlMjBnaXZlJTNBJTIwJTIwJTIyQSUyME1BTiUyMFNBSUQlMjBUTyUyMFRIRSUyMFVOSVZFUlNFJTIwU0lSJTIwSSUyMEVYSVNUJTIy",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax.numpy <span class="hljs-keyword">as</span> jnp
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, FlaxWav2Vec2ForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> soundfile <span class="hljs-keyword">as</span> sf

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-large-960h-lv60&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxWav2Vec2ForCTC.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-large-960h-lv60&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">map_to_array</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    speech, _ = sf.read(batch[<span class="hljs-string">&quot;file&quot;</span>])
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;speech&quot;</span>] = speech
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch


<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.<span class="hljs-built_in">map</span>(map_to_array)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = processor(
<span class="hljs-meta">... </span>    ds[<span class="hljs-string">&quot;speech&quot;</span>][<span class="hljs-number">0</span>], sampling_rate=<span class="hljs-number">16_000</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>
<span class="hljs-meta">... </span>).input_values  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(input_values).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = jnp.argmax(logits, axis=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.decode(predicted_ids[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># should give:  &quot;A MAN SAID TO THE UNIVERSE SIR I EXIST&quot;</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=y,n=s(),u(i.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),m(t)!=="svelte-11lpom8"&&(t.textContent=y),n=r(o),f(i.$$.fragment,o)},m(o,j){p(o,t,j),p(o,n,j),g(i,o,j),M=!0},p:Y,i(o){M||(_(i.$$.fragment,o),M=!0)},o(o){v(i.$$.fragment,o),M=!1},d(o){o&&(l(t),l(n)),b(i,o)}}}function kr(x){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=y},l(n){t=d(n,"P",{"data-svelte-h":!0}),m(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(n,i){p(n,t,i)},p:Y,d(n){n&&l(t)}}}function Wr(x){let t,y="Example:",n,i,M;return i=new dt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> optax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax.numpy <span class="hljs-keyword">as</span> jnp
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, FlaxWav2Vec2ForPreTraining
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.models.wav2vec2.modeling_flax_wav2vec2 <span class="hljs-keyword">import</span> _compute_mask_indices
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> soundfile <span class="hljs-keyword">as</span> sf

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-large-lv60&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxWav2Vec2ForPreTraining.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-large-lv60&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">map_to_array</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    speech, _ = sf.read(batch[<span class="hljs-string">&quot;file&quot;</span>])
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;speech&quot;</span>] = speech
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch


<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.<span class="hljs-built_in">map</span>(map_to_array)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = feature_extractor(ds[<span class="hljs-string">&quot;speech&quot;</span>][<span class="hljs-number">0</span>], return_tensors=<span class="hljs-string">&quot;np&quot;</span>).input_values  <span class="hljs-comment"># Batch size 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute masked indices</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size, raw_sequence_length = input_values.shape
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_length = model._get_feat_extract_output_lengths(raw_sequence_length)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_time_indices = _compute_mask_indices((batch_size, sequence_length), mask_prob=<span class="hljs-number">0.2</span>, mask_length=<span class="hljs-number">2</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_values, mask_time_indices=mask_time_indices)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute cosine similarity between predicted (=projected_states) and target (=projected_quantized_states)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cosine_sim = optax.cosine_similarity(outputs.projected_states, outputs.projected_quantized_states)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># show that cosine similarity is much higher than random</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> np.asarray(cosine_sim)[mask_time_indices].mean() &gt; <span class="hljs-number">0.5</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=y,n=s(),u(i.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),m(t)!=="svelte-11lpom8"&&(t.textContent=y),n=r(o),f(i.$$.fragment,o)},m(o,j){p(o,t,j),p(o,n,j),g(i,o,j),M=!0},p:Y,i(o){M||(_(i.$$.fragment,o),M=!0)},o(o){v(i.$$.fragment,o),M=!1},d(o){o&&(l(t),l(n)),b(i,o)}}}function xr(x){let t,y,n,i,M,o,j=`The bare Wav2Vec2 Model transformer outputting raw hidden-states without any specific head on top.
Wav2Vec2 was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,we,B,O=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Me,X,K=`This model is also a Flax Linen
<a href="https://flax.readthedocs.io/en/latest/_autosummary/flax.nn.module.html" rel="nofollow">flax.nn.Module</a> subclass. Use it as a
regular Flax Module and refer to the Flax documentation for all matter related to general usage and behavior.`,Te,k,G="Finally, this model supports inherent JAX features such as:",re,P,Dt='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',Ee,N,Ie,Q,nt,ce="The <code>FlaxWav2Vec2PreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",$e,I,de,le,pe,je,Be,z,st,Xe,oe,ae=`Wav2Vec2 Model with a <code>language modeling</code> head on top for Connectionist Temporal Classification (CTC).
Wav2Vec2 was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,Ge,H,ke=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,rt,We,Re=`This model is also a Flax Linen
<a href="https://flax.readthedocs.io/en/latest/_autosummary/flax.nn.module.html" rel="nofollow">flax.nn.Module</a> subclass. Use it as a
regular Flax Module and refer to the Flax documentation for all matter related to general usage and behavior.`,Et,me,Ce="Finally, this model supports inherent JAX features such as:",Ne,xe,S='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',ge,q,ee,Pe,qe,Qe="The <code>FlaxWav2Vec2PreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",Se,L,Ye,A,Ae,T,F,Z,ie,pt,R,ne=`Wav2Vec2 Model with a quantizer and <code>VQ</code> head on top.
Wav2Vec2 was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,mt,Pt,Ft=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ut,Qt,Zt=`This model is also a Flax Linen
<a href="https://flax.readthedocs.io/en/latest/_autosummary/flax.nn.module.html" rel="nofollow">flax.nn.Module</a> subclass. Use it as a
regular Flax Module and refer to the Flax documentation for all matter related to general usage and behavior.`,zt,St,He="Finally, this model supports inherent JAX features such as:",De,jt,_e='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',It,Le,ve,bo,Oe,Bt='The <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.FlaxWav2Vec2ForPreTraining">FlaxWav2Vec2ForPreTraining</a> forward method, overrides the <code>__call__</code> special method.',Xt,ht,E,Fe,gt;return t=new te({props:{title:"FlaxWav2Vec2Model",local:"transformers.FlaxWav2Vec2Model",headingTag:"h2"}}),i=new U({props:{name:"class transformers.FlaxWav2Vec2Model",anchor:"transformers.FlaxWav2Vec2Model",parameters:[{name:"config",val:": Wav2Vec2Config"},{name:"input_shape",val:": Tuple = (1, 1024)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxWav2Vec2Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxWav2Vec2Model.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_flax_wav2vec2.py#L1051"}}),Ie=new U({props:{name:"__call__",anchor:"transformers.FlaxWav2Vec2Model.__call__",parameters:[{name:"input_values",val:""},{name:"attention_mask",val:" = None"},{name:"mask_time_indices",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"freeze_feature_encoder",val:": bool = False"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.FlaxWav2Vec2Model.__call__.input_values",description:`<strong>input_values</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>jnp.ndarray</code>. See <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.FlaxWav2Vec2Model.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a> .. warning:: <code>attention_mask</code> should only be passed
if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor
has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">wav2vec2-base</a>, <code>attention_mask</code> should <strong>not</strong> be
passed to avoid degraded performance when doing batched inference. For such models <code>input_values</code> should
simply be padded with 0 and passed without <code>attention_mask</code>. Be aware that these models also yield slightly
different results depending on whether <code>input_values</code> is padded or not.`,name:"attention_mask"},{anchor:"transformers.FlaxWav2Vec2Model.__call__.mask_time_indices",description:`<strong>mask_time_indices</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices to mask extracted features for contrastive loss. When in training mode, model learns to predict
masked extracted features in <em>config.proj_codevector_dim</em> space.`,name:"mask_time_indices"},{anchor:"transformers.FlaxWav2Vec2Model.__call__.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FlaxWav2Vec2Model.__call__.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FlaxWav2Vec2Model.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_flax_wav2vec2.py#L888",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2BaseModelOutput"
>transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.wav2vec2.configuration_wav2vec2.Wav2Vec2Config'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>extract_features</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, last_conv_dim)</code>) — Sequence of extracted feature vectors of the last convolutional layer of the model with <code>last_conv_dim</code>
being the dimension of the last convolutional layer.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2BaseModelOutput"
>transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),I=new ft({props:{$$slots:{default:[wr]},$$scope:{ctx:x}}}),le=new Ct({props:{anchor:"transformers.FlaxWav2Vec2Model.__call__.example",$$slots:{default:[Mr]},$$scope:{ctx:x}}}),je=new te({props:{title:"FlaxWav2Vec2ForCTC",local:"transformers.FlaxWav2Vec2ForCTC",headingTag:"h2"}}),st=new U({props:{name:"class transformers.FlaxWav2Vec2ForCTC",anchor:"transformers.FlaxWav2Vec2ForCTC",parameters:[{name:"config",val:": Wav2Vec2Config"},{name:"input_shape",val:": Tuple = (1, 1024)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxWav2Vec2ForCTC.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxWav2Vec2ForCTC.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_flax_wav2vec2.py#L1169"}}),ee=new U({props:{name:"__call__",anchor:"transformers.FlaxWav2Vec2ForCTC.__call__",parameters:[{name:"input_values",val:""},{name:"attention_mask",val:" = None"},{name:"mask_time_indices",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"freeze_feature_encoder",val:": bool = False"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.FlaxWav2Vec2ForCTC.__call__.input_values",description:`<strong>input_values</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>jnp.ndarray</code>. See <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.FlaxWav2Vec2ForCTC.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a> .. warning:: <code>attention_mask</code> should only be passed
if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor
has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">wav2vec2-base</a>, <code>attention_mask</code> should <strong>not</strong> be
passed to avoid degraded performance when doing batched inference. For such models <code>input_values</code> should
simply be padded with 0 and passed without <code>attention_mask</code>. Be aware that these models also yield slightly
different results depending on whether <code>input_values</code> is padded or not.`,name:"attention_mask"},{anchor:"transformers.FlaxWav2Vec2ForCTC.__call__.mask_time_indices",description:`<strong>mask_time_indices</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices to mask extracted features for contrastive loss. When in training mode, model learns to predict
masked extracted features in <em>config.proj_codevector_dim</em> space.`,name:"mask_time_indices"},{anchor:"transformers.FlaxWav2Vec2ForCTC.__call__.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FlaxWav2Vec2ForCTC.__call__.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FlaxWav2Vec2ForCTC.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_flax_wav2vec2.py#L888",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_flax_outputs.FlaxMaskedLMOutput"
>transformers.modeling_flax_outputs.FlaxMaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.wav2vec2.configuration_wav2vec2.Wav2Vec2Config'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_flax_outputs.FlaxMaskedLMOutput"
>transformers.modeling_flax_outputs.FlaxMaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),L=new ft({props:{$$slots:{default:[Tr]},$$scope:{ctx:x}}}),A=new Ct({props:{anchor:"transformers.FlaxWav2Vec2ForCTC.__call__.example",$$slots:{default:[jr]},$$scope:{ctx:x}}}),T=new te({props:{title:"FlaxWav2Vec2ForPreTraining",local:"transformers.FlaxWav2Vec2ForPreTraining",headingTag:"h2"}}),ie=new U({props:{name:"class transformers.FlaxWav2Vec2ForPreTraining",anchor:"transformers.FlaxWav2Vec2ForPreTraining",parameters:[{name:"config",val:": Wav2Vec2Config"},{name:"input_shape",val:": Tuple = (1, 1024)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxWav2Vec2ForPreTraining.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxWav2Vec2ForPreTraining.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_flax_wav2vec2.py#L1318"}}),ve=new U({props:{name:"__call__",anchor:"transformers.FlaxWav2Vec2ForPreTraining.__call__",parameters:[{name:"input_values",val:""},{name:"attention_mask",val:" = None"},{name:"mask_time_indices",val:" = None"},{name:"gumbel_temperature",val:": int = 1"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"},{name:"gumbel_rng",val:": PRNGKey = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"freeze_feature_encoder",val:": bool = False"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.FlaxWav2Vec2ForPreTraining.__call__.input_values",description:`<strong>input_values</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>jnp.ndarray</code>. See <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.FlaxWav2Vec2ForPreTraining.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a> .. warning:: <code>attention_mask</code> should only be passed
if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor
has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">wav2vec2-base</a>, <code>attention_mask</code> should <strong>not</strong> be
passed to avoid degraded performance when doing batched inference. For such models <code>input_values</code> should
simply be padded with 0 and passed without <code>attention_mask</code>. Be aware that these models also yield slightly
different results depending on whether <code>input_values</code> is padded or not.`,name:"attention_mask"},{anchor:"transformers.FlaxWav2Vec2ForPreTraining.__call__.mask_time_indices",description:`<strong>mask_time_indices</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices to mask extracted features for contrastive loss. When in training mode, model learns to predict
masked extracted features in <em>config.proj_codevector_dim</em> space.`,name:"mask_time_indices"},{anchor:"transformers.FlaxWav2Vec2ForPreTraining.__call__.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FlaxWav2Vec2ForPreTraining.__call__.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FlaxWav2Vec2ForPreTraining.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_flax_wav2vec2.py#L1322",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput"
>transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.wav2vec2.configuration_wav2vec2.Wav2Vec2Config'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<em>optional</em>, returned when model is in train mode, <code>jnp.ndarray</code> of shape <code>(1,)</code>) — Total loss as the sum of the contrastive loss (L_m) and the diversity loss (L_d) as stated in the <a
  href="https://arxiv.org/pdf/2006.11477.pdf"
  rel="nofollow"
>official
paper</a> . (classification) loss.</p>
</li>
<li>
<p><strong>projected_states</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.proj_codevector_dim)</code>) — Hidden-states of the model projected to <em>config.proj_codevector_dim</em> that can be used to predict the masked
projected quantized states.</p>
</li>
<li>
<p><strong>projected_quantized_states</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.proj_codevector_dim)</code>) — Quantized extracted feature vectors projected to <em>config.proj_codevector_dim</em> representing the positive
target vectors for contrastive loss.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput"
>transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ht=new ft({props:{$$slots:{default:[kr]},$$scope:{ctx:x}}}),Fe=new Ct({props:{anchor:"transformers.FlaxWav2Vec2ForPreTraining.__call__.example",$$slots:{default:[Wr]},$$scope:{ctx:x}}}),{c(){u(t.$$.fragment),y=s(),n=c("div"),u(i.$$.fragment),M=s(),o=c("p"),o.innerHTML=j,we=s(),B=c("p"),B.innerHTML=O,Me=s(),X=c("p"),X.innerHTML=K,Te=s(),k=c("p"),k.textContent=G,re=s(),P=c("ul"),P.innerHTML=Dt,Ee=s(),N=c("div"),u(Ie.$$.fragment),Q=s(),nt=c("p"),nt.innerHTML=ce,$e=s(),u(I.$$.fragment),de=s(),u(le.$$.fragment),pe=s(),u(je.$$.fragment),Be=s(),z=c("div"),u(st.$$.fragment),Xe=s(),oe=c("p"),oe.innerHTML=ae,Ge=s(),H=c("p"),H.innerHTML=ke,rt=s(),We=c("p"),We.innerHTML=Re,Et=s(),me=c("p"),me.textContent=Ce,Ne=s(),xe=c("ul"),xe.innerHTML=S,ge=s(),q=c("div"),u(ee.$$.fragment),Pe=s(),qe=c("p"),qe.innerHTML=Qe,Se=s(),u(L.$$.fragment),Ye=s(),u(A.$$.fragment),Ae=s(),u(T.$$.fragment),F=s(),Z=c("div"),u(ie.$$.fragment),pt=s(),R=c("p"),R.innerHTML=ne,mt=s(),Pt=c("p"),Pt.innerHTML=Ft,Ut=s(),Qt=c("p"),Qt.innerHTML=Zt,zt=s(),St=c("p"),St.textContent=He,De=s(),jt=c("ul"),jt.innerHTML=_e,It=s(),Le=c("div"),u(ve.$$.fragment),bo=s(),Oe=c("p"),Oe.innerHTML=Bt,Xt=s(),u(ht.$$.fragment),E=s(),u(Fe.$$.fragment),this.h()},l(W){f(t.$$.fragment,W),y=r(W),n=d(W,"DIV",{class:!0});var J=$(n);f(i.$$.fragment,J),M=r(J),o=d(J,"P",{"data-svelte-h":!0}),m(o)!=="svelte-te9mu1"&&(o.innerHTML=j),we=r(J),B=d(J,"P",{"data-svelte-h":!0}),m(B)!=="svelte-18ki9f4"&&(B.innerHTML=O),Me=r(J),X=d(J,"P",{"data-svelte-h":!0}),m(X)!=="svelte-idybz1"&&(X.innerHTML=K),Te=r(J),k=d(J,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1pplc4a"&&(k.textContent=G),re=r(J),P=d(J,"UL",{"data-svelte-h":!0}),m(P)!=="svelte-1w7z84m"&&(P.innerHTML=Dt),Ee=r(J),N=d(J,"DIV",{class:!0});var be=$(N);f(Ie.$$.fragment,be),Q=r(be),nt=d(be,"P",{"data-svelte-h":!0}),m(nt)!=="svelte-dpjknz"&&(nt.innerHTML=ce),$e=r(be),f(I.$$.fragment,be),de=r(be),f(le.$$.fragment,be),be.forEach(l),J.forEach(l),pe=r(W),f(je.$$.fragment,W),Be=r(W),z=d(W,"DIV",{class:!0});var D=$(z);f(st.$$.fragment,D),Xe=r(D),oe=d(D,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-1p0g25y"&&(oe.innerHTML=ae),Ge=r(D),H=d(D,"P",{"data-svelte-h":!0}),m(H)!=="svelte-18ki9f4"&&(H.innerHTML=ke),rt=r(D),We=d(D,"P",{"data-svelte-h":!0}),m(We)!=="svelte-idybz1"&&(We.innerHTML=Re),Et=r(D),me=d(D,"P",{"data-svelte-h":!0}),m(me)!=="svelte-1pplc4a"&&(me.textContent=Ce),Ne=r(D),xe=d(D,"UL",{"data-svelte-h":!0}),m(xe)!=="svelte-1w7z84m"&&(xe.innerHTML=S),ge=r(D),q=d(D,"DIV",{class:!0});var Ue=$(q);f(ee.$$.fragment,Ue),Pe=r(Ue),qe=d(Ue,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-dpjknz"&&(qe.innerHTML=Qe),Se=r(Ue),f(L.$$.fragment,Ue),Ye=r(Ue),f(A.$$.fragment,Ue),Ue.forEach(l),D.forEach(l),Ae=r(W),f(T.$$.fragment,W),F=r(W),Z=d(W,"DIV",{class:!0});var he=$(Z);f(ie.$$.fragment,he),pt=r(he),R=d(he,"P",{"data-svelte-h":!0}),m(R)!=="svelte-wn7jg8"&&(R.innerHTML=ne),mt=r(he),Pt=d(he,"P",{"data-svelte-h":!0}),m(Pt)!=="svelte-18ki9f4"&&(Pt.innerHTML=Ft),Ut=r(he),Qt=d(he,"P",{"data-svelte-h":!0}),m(Qt)!=="svelte-idybz1"&&(Qt.innerHTML=Zt),zt=r(he),St=d(he,"P",{"data-svelte-h":!0}),m(St)!=="svelte-1pplc4a"&&(St.textContent=He),De=r(he),jt=d(he,"UL",{"data-svelte-h":!0}),m(jt)!=="svelte-1w7z84m"&&(jt.innerHTML=_e),It=r(he),Le=d(he,"DIV",{class:!0});var Ve=$(Le);f(ve.$$.fragment,Ve),bo=r(Ve),Oe=d(Ve,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-tug4cx"&&(Oe.innerHTML=Bt),Xt=r(Ve),f(ht.$$.fragment,Ve),E=r(Ve),f(Fe.$$.fragment,Ve),Ve.forEach(l),he.forEach(l),this.h()},h(){C(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(W,J){g(t,W,J),p(W,y,J),p(W,n,J),g(i,n,null),a(n,M),a(n,o),a(n,we),a(n,B),a(n,Me),a(n,X),a(n,Te),a(n,k),a(n,re),a(n,P),a(n,Ee),a(n,N),g(Ie,N,null),a(N,Q),a(N,nt),a(N,$e),g(I,N,null),a(N,de),g(le,N,null),p(W,pe,J),g(je,W,J),p(W,Be,J),p(W,z,J),g(st,z,null),a(z,Xe),a(z,oe),a(z,Ge),a(z,H),a(z,rt),a(z,We),a(z,Et),a(z,me),a(z,Ne),a(z,xe),a(z,ge),a(z,q),g(ee,q,null),a(q,Pe),a(q,qe),a(q,Se),g(L,q,null),a(q,Ye),g(A,q,null),p(W,Ae,J),g(T,W,J),p(W,F,J),p(W,Z,J),g(ie,Z,null),a(Z,pt),a(Z,R),a(Z,mt),a(Z,Pt),a(Z,Ut),a(Z,Qt),a(Z,zt),a(Z,St),a(Z,De),a(Z,jt),a(Z,It),a(Z,Le),g(ve,Le,null),a(Le,bo),a(Le,Oe),a(Le,Xt),g(ht,Le,null),a(Le,E),g(Fe,Le,null),gt=!0},p(W,J){const be={};J&2&&(be.$$scope={dirty:J,ctx:W}),I.$set(be);const D={};J&2&&(D.$$scope={dirty:J,ctx:W}),le.$set(D);const Ue={};J&2&&(Ue.$$scope={dirty:J,ctx:W}),L.$set(Ue);const he={};J&2&&(he.$$scope={dirty:J,ctx:W}),A.$set(he);const Ve={};J&2&&(Ve.$$scope={dirty:J,ctx:W}),ht.$set(Ve);const Ot={};J&2&&(Ot.$$scope={dirty:J,ctx:W}),Fe.$set(Ot)},i(W){gt||(_(t.$$.fragment,W),_(i.$$.fragment,W),_(Ie.$$.fragment,W),_(I.$$.fragment,W),_(le.$$.fragment,W),_(je.$$.fragment,W),_(st.$$.fragment,W),_(ee.$$.fragment,W),_(L.$$.fragment,W),_(A.$$.fragment,W),_(T.$$.fragment,W),_(ie.$$.fragment,W),_(ve.$$.fragment,W),_(ht.$$.fragment,W),_(Fe.$$.fragment,W),gt=!0)},o(W){v(t.$$.fragment,W),v(i.$$.fragment,W),v(Ie.$$.fragment,W),v(I.$$.fragment,W),v(le.$$.fragment,W),v(je.$$.fragment,W),v(st.$$.fragment,W),v(ee.$$.fragment,W),v(L.$$.fragment,W),v(A.$$.fragment,W),v(T.$$.fragment,W),v(ie.$$.fragment,W),v(ve.$$.fragment,W),v(ht.$$.fragment,W),v(Fe.$$.fragment,W),gt=!1},d(W){W&&(l(y),l(n),l(pe),l(Be),l(z),l(Ae),l(F),l(Z)),b(t,W),b(i),b(Ie),b(I),b(le),b(je,W),b(st),b(ee),b(L),b(A),b(T,W),b(ie),b(ve),b(ht),b(Fe)}}}function Vr(x){let t,y;return t=new fs({props:{$$slots:{default:[xr]},$$scope:{ctx:x}}}),{c(){u(t.$$.fragment)},l(n){f(t.$$.fragment,n)},m(n,i){g(t,n,i),y=!0},p(n,i){const M={};i&2&&(M.$$scope={dirty:i,ctx:n}),t.$set(M)},i(n){y||(_(t.$$.fragment,n),y=!0)},o(n){v(t.$$.fragment,n),y=!1},d(n){b(t,n)}}}function Jr(x){let t,y,n,i,M,o,j,we,B,O='The Wav2Vec2 model was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael Auli.',Me,X,K="The abstract from the paper is the following:",Te,k,G=`<em>We show for the first time that learning powerful representations from speech audio alone followed by fine-tuning on
transcribed speech can outperform the best semi-supervised methods while being conceptually simpler. wav2vec 2.0 masks
the speech input in the latent space and solves a contrastive task defined over a quantization of the latent
representations which are jointly learned. Experiments using all labeled data of Librispeech achieve 1.8/3.3 WER on the
clean/other test sets. When lowering the amount of labeled data to one hour, wav2vec 2.0 outperforms the previous state
of the art on the 100 hour subset while using 100 times less labeled data. Using just ten minutes of labeled data and
pre-training on 53k hours of unlabeled data still achieves 4.8/8.2 WER. This demonstrates the feasibility of speech
recognition with limited amounts of labeled data.</em>`,re,P,Dt='This model was contributed by <a href="https://huggingface.co/patrickvonplaten" rel="nofollow">patrickvonplaten</a>.',Ee,N,Ie,Q,nt=`<li>Wav2Vec2 is a speech model that accepts a float array corresponding to the raw waveform of the speech signal.</li> <li>Wav2Vec2 model was trained using connectionist temporal classification (CTC) so the model output has to be decoded
using <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a>.</li>`,ce,$e,I,de,le="Flash Attention 2 is an faster, optimized version of the model.",pe,je,Be,z,st='First, check whether your hardware is compatible with Flash Attention 2. The latest list of compatible hardware can be found in the <a href="https://github.com/Dao-AILab/flash-attention#installation-and-features" rel="nofollow">official documentation</a>. If your hardware is not compatible with Flash Attention 2, you can still benefit from attention kernel optimisations through Better Transformer support covered <a href="https://huggingface.co/docs/transformers/main/en/model_doc/bark#using-better-transformer" rel="nofollow">above</a>.',Xe,oe,ae='Next, <a href="https://github.com/Dao-AILab/flash-attention#installation-and-features" rel="nofollow">install</a> the latest version of Flash Attention 2:',Ge,H,ke,rt,We,Re,Et='To load a model using Flash Attention 2, we can pass the argument <code>attn_implementation=&quot;flash_attention_2&quot;</code> to <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained" rel="nofollow"><code>.from_pretrained</code></a>. We’ll also load the model in half-precision (e.g. <code>torch.float16</code>), since it results in almost no degradation to audio quality but significantly lower memory usage and faster inference:',me,Ce,Ne,xe,S,ge,q="Below is an expected speedup diagram comparing the pure inference time between the native implementation in transformers of the <code>facebook/wav2vec2-large-960h-lv60-self</code> model and the flash-attention-2 and sdpa (scale-dot-product-attention) versions. . We show the average speedup obtained on the <code>librispeech_asr</code> <code>clean</code> validation split:",ee,Pe,qe='<img src="https://huggingface.co/datasets/kamilakesbi/transformers_image_doc/resolve/main/data/Wav2Vec2_speedup.png"/>',Qe,Se,L,Ye,A="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with Wav2Vec2. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Ae,T,F,Z,ie='<li>A notebook on how to <a href="https://colab.research.google.com/github/m3hrdadfi/soxan/blob/main/notebooks/Emotion_recognition_in_Greek_speech_using_Wav2Vec2.ipynb" rel="nofollow">leverage a pretrained Wav2Vec2 model for emotion classification</a>. 🌎</li> <li><a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/audio-classification" rel="nofollow">example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/audio_classification.ipynb" rel="nofollow">notebook</a>.</li> <li><a href="../tasks/audio_classification">Audio classification task guide</a></li>',pt,R,ne,mt,Pt='<li>A blog post on <a href="https://huggingface.co/blog/wav2vec2-with-ngram" rel="nofollow">boosting Wav2Vec2 with n-grams in 🤗 Transformers</a>.</li> <li>A blog post on how to <a href="https://huggingface.co/blog/fine-tune-wav2vec2-english" rel="nofollow">finetune Wav2Vec2 for English ASR with 🤗 Transformers</a>.</li> <li>A blog post on <a href="https://huggingface.co/blog/fine-tune-xlsr-wav2vec2" rel="nofollow">finetuning XLS-R for Multi-Lingual ASR with 🤗 Transformers</a>.</li> <li>A notebook on how to <a href="https://colab.research.google.com/github/Muennighoff/ytclipcc/blob/main/wav2vec_youtube_captions.ipynb" rel="nofollow">create YouTube captions from any video by transcribing audio with Wav2Vec2</a>. 🌎</li> <li><a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a> is supported by a notebook on <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/speech_recognition.ipynb" rel="nofollow">how to finetune a speech recognition model in English</a>, and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/multi_lingual_speech_recognition.ipynb" rel="nofollow">how to finetune a speech recognition model in any language</a>.</li> <li><a href="../tasks/asr">Automatic speech recognition task guide</a></li>',Ft,Ut,Qt="🚀 Deploy",Zt,zt,St='<li>A blog post on how to deploy Wav2Vec2 for <a href="https://www.philschmid.de/automatic-speech-recognition-sagemaker" rel="nofollow">Automatic Speech Recognition with Hugging Face’s Transformers &amp; Amazon SageMaker</a>.</li>',He,De,jt,_e,It,Le,ve,bo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Model">Wav2Vec2Model</a>. It is used to instantiate an
Wav2Vec2 model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Wav2Vec2
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">facebook/wav2vec2-base-960h</a> architecture.`,Oe,Bt,Xt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ht,E,Fe,gt,W,J,be,D,Ue,he="Constructs a Wav2Vec2CTC tokenizer.",Ve,Ot,Ua=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains some of the main methods. Users should refer to
the superclass for more information regarding such methods.`,yo,no,so,_t,Gt,Za=`Main method to tokenize and prepare for the model one or several sequence(s) or one or several pair(s) of
sequences.`,wo,$o,ro,Kt,vt,bt,Bo,Rt,Ko=`Converts a sequence of ids in a string, using the tokenizer and vocabulary with options to remove special
tokens and clean up tokenization spaces.`,Ze,Nt,za="Similar to doing <code>self.convert_tokens_to_string(self.convert_ids_to_tokens(token_ids))</code>.",Mo,lo,ea,kt,To,ta,At,cn="Convert a list of lists of token ids into a list of strings by calling decode.",oa,Wt,jo,aa,Ke,ko="Set the target language of a nested multi-lingual dictionary",Xo,qt,na,ut,yt,sa,xt,ra="Constructs a Wav2Vec2 feature extractor.",io,co,lt=`This feature extractor inherits from <a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.SequenceFeatureExtractor">SequenceFeatureExtractor</a> which contains
most of the main methods. Users should refer to this superclass for more information regarding those methods.`,po,eo,Yt,Ia,Wo,Co="Main method to featurize and prepare for the model one or several sequence(s).",la,mo,ho,se,uo,wt,Ht,Ba=`Constructs a Wav2Vec2 processor which wraps a Wav2Vec2 feature extractor and a Wav2Vec2 CTC tokenizer into a single
processor.`,xo,Fo,Xa=`<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> and <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>.
See the docstring of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__"><strong>call</strong>()</a> and <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.decode">decode()</a> for more information.`,to,oo,Mt,Go,h,V=`When used in normal mode, this method forwards all its arguments to Wav2Vec2FeatureExtractor’s
<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor.__call__"><strong>call</strong>()</a> and returns its output. If used in the context
<code>as_target_processor()</code> this method forwards all its arguments to PreTrainedTokenizer’s
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__"><strong>call</strong>()</a>. Please refer to the docstring of the above two methods for more information.`,Vt,ue,et,Jt,Je,Lt=`When used in normal mode, this method forwards all its arguments to Wav2Vec2FeatureExtractor’s
<a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.SequenceFeatureExtractor.pad">pad()</a> and returns its output. If used in the context
<code>as_target_processor()</code> this method forwards all its arguments to PreTrainedTokenizer’s
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.pad">pad()</a>. Please refer to the docstring of the above two methods for more information.`,tt,it,ye,$t,fe,ot,Ga,Uo,gs=`Saves the attributes of this processor (feature extractor, tokenizer…) in the specified directory so that it
can be reloaded using the <a href="/docs/transformers/main/en/main_classes/processors#transformers.ProcessorMixin.from_pretrained">from_pretrained()</a> method.`,Gn,Ro,Rn,No,ia,Nn,Ra,_s=`This method forwards all its arguments to PreTrainedTokenizer’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,qn,qo,ca,Yn,Na,vs=`This method forwards all its arguments to PreTrainedTokenizer’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer
to the docstring of this method for more information.`,mn,da,hn,ze,pa,Hn,qa,bs=`Constructs a Wav2Vec2 processor which wraps a Wav2Vec2 feature extractor, a Wav2Vec2 CTC tokenizer and a decoder
with language model support into a single processor for language model boosted speech recognition decoding.`,Ln,Yo,ma,En,Ya,ys=`When used in normal mode, this method forwards all its arguments to Wav2Vec2FeatureExtractor’s
<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor.__call__"><strong>call</strong>()</a> and returns its output. If used in the context
<code>as_target_processor()</code> this method forwards all its arguments to
Wav2Vec2CTCTokenizer’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__"><strong>call</strong>()</a>. Please refer to the docstring of the above two
methods for more information.`,Pn,Ho,ha,Qn,Ha,ws=`When used in normal mode, this method forwards all its arguments to Wav2Vec2FeatureExtractor’s
<a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.SequenceFeatureExtractor.pad">pad()</a> and returns its output. If used in the context
<code>as_target_processor()</code> this method forwards all its arguments to
Wav2Vec2CTCTokenizer’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.pad">pad()</a>. Please refer to the docstring of the above two methods
for more information.`,Sn,Vo,ua,An,La,Ms='Instantiate a <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ProcessorWithLM">Wav2Vec2ProcessorWithLM</a> from a pretrained Wav2Vec2 processor.',Dn,Lo,On,Ea,fa,Kn,ao,ga,es,Pa,Ts="Batch decode output logits to audio transcription with language model support.",ts,Eo,os,Qa,js=`Example:
See <a href="#decoding-multiple-audios">Decoding multiple audios</a>.`,as,Jo,_a,ns,Sa,ks="Decode output logits to audio transcription with language model support.",ss,Po,un,va,fn,ba,Ws=`If you are planning to decode multiple batches of audios, you should consider using <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ProcessorWithLM.batch_decode">batch_decode()</a> and passing an instantiated <code>multiprocessing.Pool</code>.
Otherwise, <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ProcessorWithLM.batch_decode">batch_decode()</a> performance will be slower than calling <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ProcessorWithLM.decode">decode()</a> for each audio individually, as it internally instantiates a new <code>Pool</code> for every call. See the example below:`,gn,ya,_n,wa,vn,Zo,Ma,rs,Aa,xs="Output type of <code>Wav2Vec2DecoderWithLM</code>, with transcription.",bn,zo,Ta,ls,Da,Vs="Base class for models that have been trained with the Wav2Vec2 loss objective.",yn,Io,ja,is,Oa,Js='Output type of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForPreTraining">Wav2Vec2ForPreTraining</a>, with potential hidden states and attentions.',wn,fo,ka,cs,Ka,$s="Output type of <code>FlaxWav2Vec2BaseModelOutput</code>, with potential hidden states and attentions.",ds,Qo,Wa,ps,en,Cs="“Returns a new object replacing the specified fields with new values.",Mn,go,xa,ms,tn,Fs="Output type of <code>FlaxWav2Vec2ForPreTrainingOutput</code>, with potential hidden states and attentions.",hs,So,Va,us,on,Us="“Returns a new object replacing the specified fields with new values.",Tn,Ao,jn,Ja,kn,dn,Wn;return M=new te({props:{title:"Wav2Vec2",local:"wav2vec2",headingTag:"h1"}}),j=new te({props:{title:"Overview",local:"overview",headingTag:"h2"}}),N=new te({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),$e=new te({props:{title:"Using Flash Attention 2",local:"using-flash-attention-2",headingTag:"h2"}}),je=new te({props:{title:"Installation",local:"installation",headingTag:"h3"}}),H=new dt({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0biUyMC0tbm8tYnVpbGQtaXNvbGF0aW9u",highlighted:"pip install -U flash-attn --no-build-isolation",wrap:!1}}),rt=new te({props:{title:"Usage",local:"usage",headingTag:"h3"}}),Ce=new dt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdhdjJWZWMyTW9kZWwlMEE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Wav2Vec2Model

model = Wav2Vec2Model.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-large-960h-lv60-self&quot;</span>, torch_dtype=torch.float16, attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>).to(device)
...`,wrap:!1}}),xe=new te({props:{title:"Expected speedups",local:"expected-speedups",headingTag:"h3"}}),Se=new te({props:{title:"Resources",local:"resources",headingTag:"h2"}}),T=new Is({props:{pipeline:"audio-classification"}}),R=new Is({props:{pipeline:"automatic-speech-recognition"}}),De=new te({props:{title:"Wav2Vec2Config",local:"transformers.Wav2Vec2Config",headingTag:"h2"}}),It=new U({props:{name:"class transformers.Wav2Vec2Config",anchor:"transformers.Wav2Vec2Config",parameters:[{name:"vocab_size",val:" = 32"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout",val:" = 0.1"},{name:"activation_dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.1"},{name:"feat_proj_dropout",val:" = 0.0"},{name:"feat_quantizer_dropout",val:" = 0.0"},{name:"final_dropout",val:" = 0.1"},{name:"layerdrop",val:" = 0.1"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"feat_extract_norm",val:" = 'group'"},{name:"feat_extract_activation",val:" = 'gelu'"},{name:"conv_dim",val:" = (512, 512, 512, 512, 512, 512, 512)"},{name:"conv_stride",val:" = (5, 2, 2, 2, 2, 2, 2)"},{name:"conv_kernel",val:" = (10, 3, 3, 3, 3, 2, 2)"},{name:"conv_bias",val:" = False"},{name:"num_conv_pos_embeddings",val:" = 128"},{name:"num_conv_pos_embedding_groups",val:" = 16"},{name:"do_stable_layer_norm",val:" = False"},{name:"apply_spec_augment",val:" = True"},{name:"mask_time_prob",val:" = 0.05"},{name:"mask_time_length",val:" = 10"},{name:"mask_time_min_masks",val:" = 2"},{name:"mask_feature_prob",val:" = 0.0"},{name:"mask_feature_length",val:" = 10"},{name:"mask_feature_min_masks",val:" = 0"},{name:"num_codevectors_per_group",val:" = 320"},{name:"num_codevector_groups",val:" = 2"},{name:"contrastive_logits_temperature",val:" = 0.1"},{name:"num_negatives",val:" = 100"},{name:"codevector_dim",val:" = 256"},{name:"proj_codevector_dim",val:" = 256"},{name:"diversity_loss_weight",val:" = 0.1"},{name:"ctc_loss_reduction",val:" = 'sum'"},{name:"ctc_zero_infinity",val:" = False"},{name:"use_weighted_layer_sum",val:" = False"},{name:"classifier_proj_size",val:" = 256"},{name:"tdnn_dim",val:" = (512, 512, 512, 512, 1500)"},{name:"tdnn_kernel",val:" = (5, 3, 3, 1, 1)"},{name:"tdnn_dilation",val:" = (1, 2, 3, 1, 1)"},{name:"xvector_output_dim",val:" = 512"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"add_adapter",val:" = False"},{name:"adapter_kernel_size",val:" = 3"},{name:"adapter_stride",val:" = 2"},{name:"num_adapter_layers",val:" = 3"},{name:"output_hidden_size",val:" = None"},{name:"adapter_attn_dim",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2Config.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Vocabulary size of the Wav2Vec2 model. Defines the number of different tokens that can be represented by
the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Model">Wav2Vec2Model</a> or <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.TFWav2Vec2Model">TFWav2Vec2Model</a>. Vocabulary size of the
model. Defines the different tokens that can be represented by the <em>inputs_ids</em> passed to the forward
method of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Model">Wav2Vec2Model</a>.`,name:"vocab_size"},{anchor:"transformers.Wav2Vec2Config.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.Wav2Vec2Config.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.Wav2Vec2Config.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.Wav2Vec2Config.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.Wav2Vec2Config.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.Wav2Vec2Config.hidden_dropout",description:`<strong>hidden_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout"},{anchor:"transformers.Wav2Vec2Config.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.Wav2Vec2Config.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.Wav2Vec2Config.final_dropout",description:`<strong>final_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for the final projection layer of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a>.`,name:"final_dropout"},{anchor:"transformers.Wav2Vec2Config.layerdrop",description:`<strong>layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The LayerDrop probability. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>) for more
details.`,name:"layerdrop"},{anchor:"transformers.Wav2Vec2Config.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Wav2Vec2Config.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.Wav2Vec2Config.feat_extract_norm",description:`<strong>feat_extract_norm</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;group&quot;</code>) &#x2014;
The norm to be applied to 1D convolutional layers in feature encoder. One of <code>&quot;group&quot;</code> for group
normalization of only the first 1D convolutional layer or <code>&quot;layer&quot;</code> for layer normalization of all 1D
convolutional layers.`,name:"feat_extract_norm"},{anchor:"transformers.Wav2Vec2Config.feat_proj_dropout",description:`<strong>feat_proj_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for output of the feature encoder.`,name:"feat_proj_dropout"},{anchor:"transformers.Wav2Vec2Config.feat_extract_activation",description:"<strong>feat_extract_activation</strong> (<code>str, </code>optional<code>, defaults to </code>&#x201C;gelu&#x201D;<code>) -- The non-linear activation function (function or string) in the 1D convolutional layers of the feature extractor. If string, </code>&#x201C;gelu&#x201D;<code>, </code>&#x201C;relu&#x201D;<code>, </code>&#x201C;selu&#x201D;<code>and</code>&#x201C;gelu_new&#x201D;` are supported.",name:"feat_extract_activation"},{anchor:"transformers.Wav2Vec2Config.feat_quantizer_dropout",description:`<strong>feat_quantizer_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for quantized feature encoder states.`,name:"feat_quantizer_dropout"},{anchor:"transformers.Wav2Vec2Config.conv_dim",description:`<strong>conv_dim</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>(512, 512, 512, 512, 512, 512, 512)</code>) &#x2014;
A tuple of integers defining the number of input and output channels of each 1D convolutional layer in the
feature encoder. The length of <em>conv_dim</em> defines the number of 1D convolutional layers.`,name:"conv_dim"},{anchor:"transformers.Wav2Vec2Config.conv_stride",description:`<strong>conv_stride</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>(5, 2, 2, 2, 2, 2, 2)</code>) &#x2014;
A tuple of integers defining the stride of each 1D convolutional layer in the feature encoder. The length
of <em>conv_stride</em> defines the number of convolutional layers and has to match the length of <em>conv_dim</em>.`,name:"conv_stride"},{anchor:"transformers.Wav2Vec2Config.conv_kernel",description:`<strong>conv_kernel</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>(10, 3, 3, 3, 3, 3, 3)</code>) &#x2014;
A tuple of integers defining the kernel size of each 1D convolutional layer in the feature encoder. The
length of <em>conv_kernel</em> defines the number of convolutional layers and has to match the length of
<em>conv_dim</em>.`,name:"conv_kernel"},{anchor:"transformers.Wav2Vec2Config.conv_bias",description:`<strong>conv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the 1D convolutional layers have a bias.`,name:"conv_bias"},{anchor:"transformers.Wav2Vec2Config.num_conv_pos_embeddings",description:`<strong>num_conv_pos_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Number of convolutional positional embeddings. Defines the kernel size of 1D convolutional positional
embeddings layer.`,name:"num_conv_pos_embeddings"},{anchor:"transformers.Wav2Vec2Config.num_conv_pos_embedding_groups",description:`<strong>num_conv_pos_embedding_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of groups of 1D convolutional positional embeddings layer.`,name:"num_conv_pos_embedding_groups"},{anchor:"transformers.Wav2Vec2Config.do_stable_layer_norm",description:`<strong>do_stable_layer_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to apply <em>stable</em> layer norm architecture of the Transformer encoder. <code>do_stable_layer_norm is True</code> corresponds to applying layer norm before the attention layer, whereas <code>do_stable_layer_norm is False</code> corresponds to applying layer norm after the attention layer.`,name:"do_stable_layer_norm"},{anchor:"transformers.Wav2Vec2Config.apply_spec_augment",description:`<strong>apply_spec_augment</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to apply <em>SpecAugment</em> data augmentation to the outputs of the feature encoder. For reference see
<a href="https://arxiv.org/abs/1904.08779" rel="nofollow">SpecAugment: A Simple Data Augmentation Method for Automatic Speech
Recognition</a>.`,name:"apply_spec_augment"},{anchor:"transformers.Wav2Vec2Config.mask_time_prob",description:`<strong>mask_time_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.05) &#x2014;
Percentage (between 0 and 1) of all feature vectors along the time axis which will be masked. The masking
procecure generates &#x201D;mask_time_prob<em>len(time_axis)/mask_time_length&#x201D; independent masks over the axis. If
reasoning from the propability of each feature vector to be chosen as the start of the vector span to be
masked, </em>mask_time_prob<em> should be \`prob_vector_start</em>mask_time_length<code>. Note that overlap may decrease the actual percentage of masked vectors. This is only relevant if </code>apply_spec_augment is True\`.`,name:"mask_time_prob"},{anchor:"transformers.Wav2Vec2Config.mask_time_length",description:`<strong>mask_time_length</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
Length of vector span along the time axis.`,name:"mask_time_length"},{anchor:"transformers.Wav2Vec2Config.mask_time_min_masks",description:`<strong>mask_time_min_masks</strong> (<code>int</code>, <em>optional</em>, defaults to 2), &#x2014;
The minimum number of masks of length <code>mask_feature_length</code> generated along the time axis, each time step,
irrespectively of <code>mask_feature_prob</code>. Only relevant if &#x201D;mask_time_prob*len(time_axis)/mask_time_length &lt;
mask_time_min_masks&#x201D;`,name:"mask_time_min_masks"},{anchor:"transformers.Wav2Vec2Config.mask_feature_prob",description:`<strong>mask_feature_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Percentage (between 0 and 1) of all feature vectors along the feature axis which will be masked. The
masking procecure generates &#x201D;mask_feature_prob<em>len(feature_axis)/mask_time_length&#x201D; independent masks over
the axis. If reasoning from the propability of each feature vector to be chosen as the start of the vector
span to be masked, </em>mask_feature_prob<em> should be \`prob_vector_start</em>mask_feature_length<code>. Note that overlap may decrease the actual percentage of masked vectors. This is only relevant if </code>apply_spec_augment is
True\`.`,name:"mask_feature_prob"},{anchor:"transformers.Wav2Vec2Config.mask_feature_length",description:`<strong>mask_feature_length</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
Length of vector span along the feature axis.`,name:"mask_feature_length"},{anchor:"transformers.Wav2Vec2Config.mask_feature_min_masks",description:`<strong>mask_feature_min_masks</strong> (<code>int</code>, <em>optional</em>, defaults to 0), &#x2014;
The minimum number of masks of length <code>mask_feature_length</code> generated along the feature axis, each time
step, irrespectively of <code>mask_feature_prob</code>. Only relevant if
&#x201D;mask_feature_prob*len(feature_axis)/mask_feature_length &lt; mask_feature_min_masks&#x201D;`,name:"mask_feature_min_masks"},{anchor:"transformers.Wav2Vec2Config.num_codevectors_per_group",description:`<strong>num_codevectors_per_group</strong> (<code>int</code>, <em>optional</em>, defaults to 320) &#x2014;
Number of entries in each quantization codebook (group).`,name:"num_codevectors_per_group"},{anchor:"transformers.Wav2Vec2Config.num_codevector_groups",description:`<strong>num_codevector_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of codevector groups for product codevector quantization.`,name:"num_codevector_groups"},{anchor:"transformers.Wav2Vec2Config.contrastive_logits_temperature",description:`<strong>contrastive_logits_temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The temperature <em>kappa</em> in the contrastive loss.`,name:"contrastive_logits_temperature"},{anchor:"transformers.Wav2Vec2Config.feat_quantizer_dropout",description:`<strong>feat_quantizer_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for the output of the feature encoder that&#x2019;s used by the quantizer.`,name:"feat_quantizer_dropout"},{anchor:"transformers.Wav2Vec2Config.num_negatives",description:`<strong>num_negatives</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Number of negative samples for the contrastive loss.`,name:"num_negatives"},{anchor:"transformers.Wav2Vec2Config.codevector_dim",description:`<strong>codevector_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the quantized feature vectors.`,name:"codevector_dim"},{anchor:"transformers.Wav2Vec2Config.proj_codevector_dim",description:`<strong>proj_codevector_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the final projection of both the quantized and the transformer features.`,name:"proj_codevector_dim"},{anchor:"transformers.Wav2Vec2Config.diversity_loss_weight",description:`<strong>diversity_loss_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The weight of the codebook diversity loss component.`,name:"diversity_loss_weight"},{anchor:"transformers.Wav2Vec2Config.ctc_loss_reduction",description:`<strong>ctc_loss_reduction</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sum&quot;</code>) &#x2014;
Specifies the reduction to apply to the output of <code>torch.nn.CTCLoss</code>. Only relevant when training an
instance of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a>.`,name:"ctc_loss_reduction"},{anchor:"transformers.Wav2Vec2Config.ctc_zero_infinity",description:`<strong>ctc_zero_infinity</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to zero infinite losses and the associated gradients of <code>torch.nn.CTCLoss</code>. Infinite losses mainly
occur when the inputs are too short to be aligned to the targets. Only relevant when training an instance
of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a>.`,name:"ctc_zero_infinity"},{anchor:"transformers.Wav2Vec2Config.use_weighted_layer_sum",description:`<strong>use_weighted_layer_sum</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a weighted average of layer outputs with learned weights. Only relevant when using an
instance of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForSequenceClassification">Wav2Vec2ForSequenceClassification</a>.`,name:"use_weighted_layer_sum"},{anchor:"transformers.Wav2Vec2Config.classifier_proj_size",description:`<strong>classifier_proj_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the projection before token mean-pooling for classification.`,name:"classifier_proj_size"},{anchor:"transformers.Wav2Vec2Config.tdnn_dim",description:`<strong>tdnn_dim</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>(512, 512, 512, 512, 1500)</code>) &#x2014;
A tuple of integers defining the number of output channels of each 1D convolutional layer in the <em>TDNN</em>
module of the <em>XVector</em> model. The length of <em>tdnn_dim</em> defines the number of <em>TDNN</em> layers.`,name:"tdnn_dim"},{anchor:"transformers.Wav2Vec2Config.tdnn_kernel",description:`<strong>tdnn_kernel</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>(5, 3, 3, 1, 1)</code>) &#x2014;
A tuple of integers defining the kernel size of each 1D convolutional layer in the <em>TDNN</em> module of the
<em>XVector</em> model. The length of <em>tdnn_kernel</em> has to match the length of <em>tdnn_dim</em>.`,name:"tdnn_kernel"},{anchor:"transformers.Wav2Vec2Config.tdnn_dilation",description:`<strong>tdnn_dilation</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>(1, 2, 3, 1, 1)</code>) &#x2014;
A tuple of integers defining the dilation factor of each 1D convolutional layer in <em>TDNN</em> module of the
<em>XVector</em> model. The length of <em>tdnn_dilation</em> has to match the length of <em>tdnn_dim</em>.`,name:"tdnn_dilation"},{anchor:"transformers.Wav2Vec2Config.xvector_output_dim",description:`<strong>xvector_output_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimensionality of the <em>XVector</em> embedding vectors.`,name:"xvector_output_dim"},{anchor:"transformers.Wav2Vec2Config.add_adapter",description:`<strong>add_adapter</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether a convolutional network should be stacked on top of the Wav2Vec2 Encoder. Can be very useful for
warm-starting Wav2Vec2 for SpeechEncoderDecoder models.`,name:"add_adapter"},{anchor:"transformers.Wav2Vec2Config.adapter_kernel_size",description:`<strong>adapter_kernel_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Kernel size of the convolutional layers in the adapter network. Only relevant if <code>add_adapter is True</code>.`,name:"adapter_kernel_size"},{anchor:"transformers.Wav2Vec2Config.adapter_stride",description:`<strong>adapter_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Stride of the convolutional layers in the adapter network. Only relevant if <code>add_adapter is True</code>.`,name:"adapter_stride"},{anchor:"transformers.Wav2Vec2Config.num_adapter_layers",description:`<strong>num_adapter_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of convolutional layers that should be used in the adapter network. Only relevant if <code>add_adapter is True</code>.`,name:"num_adapter_layers"},{anchor:"transformers.Wav2Vec2Config.adapter_attn_dim",description:`<strong>adapter_attn_dim</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimension of the attention adapter weights to be used in each attention block. An example of a model using
attention adapters is <a href="https://huggingface.co/facebook/mms-1b-all" rel="nofollow">facebook/mms-1b-all</a>.`,name:"adapter_attn_dim"},{anchor:"transformers.Wav2Vec2Config.output_hidden_size",description:`<strong>output_hidden_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimensionality of the encoder output layer. If not defined, this defaults to <em>hidden-size</em>. Only relevant
if <code>add_adapter is True</code>.`,name:"output_hidden_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/configuration_wav2vec2.py#L30"}}),E=new Ct({props:{anchor:"transformers.Wav2Vec2Config.example",$$slots:{default:[Ls]},$$scope:{ctx:x}}}),gt=new te({props:{title:"Wav2Vec2CTCTokenizer",local:"transformers.Wav2Vec2CTCTokenizer",headingTag:"h2"}}),be=new U({props:{name:"class transformers.Wav2Vec2CTCTokenizer",anchor:"transformers.Wav2Vec2CTCTokenizer",parameters:[{name:"vocab_file",val:""},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"word_delimiter_token",val:" = '|'"},{name:"replace_word_delimiter_char",val:" = ' '"},{name:"do_lower_case",val:" = False"},{name:"target_lang",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2CTCTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
File containing the vocabulary.`,name:"vocab_file"},{anchor:"transformers.Wav2Vec2CTCTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sentence token.`,name:"bos_token"},{anchor:"transformers.Wav2Vec2CTCTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sentence token.`,name:"eos_token"},{anchor:"transformers.Wav2Vec2CTCTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.Wav2Vec2CTCTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.Wav2Vec2CTCTokenizer.word_delimiter_token",description:`<strong>word_delimiter_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;|&quot;</code>) &#x2014;
The token used for defining the end of a word.`,name:"word_delimiter_token"},{anchor:"transformers.Wav2Vec2CTCTokenizer.do_lower_case",description:`<strong>do_lower_case</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to accept lowercase input and lowercase the output when decoding.`,name:"do_lower_case"},{anchor:"transformers.Wav2Vec2CTCTokenizer.target_lang",description:`<strong>target_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A target language the tokenizer should set by default. <code>target_lang</code> has to be defined for multi-lingual,
nested vocabulary such as <a href="https://huggingface.co/facebook/mms-1b-all" rel="nofollow">facebook/mms-1b-all</a>.</p>
<p>**kwargs &#x2014;
Additional keyword arguments passed along to <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>`,name:"target_lang"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/tokenization_wav2vec2.py#L115"}}),so=new U({props:{name:"__call__",anchor:"transformers.Wav2Vec2CTCTokenizer.__call__",parameters:[{name:"text",val:": Union = None"},{name:"text_pair",val:": Union = None"},{name:"text_target",val:": Union = None"},{name:"text_pair_target",val:": Union = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": Union = False"},{name:"truncation",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"stride",val:": int = 0"},{name:"is_split_into_words",val:": bool = False"},{name:"pad_to_multiple_of",val:": Optional = None"},{name:"return_tensors",val:": Union = None"},{name:"return_token_type_ids",val:": Optional = None"},{name:"return_attention_mask",val:": Optional = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.text_pair",description:`<strong>text_pair</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_pair"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.text_target",description:`<strong>text_target</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded as target texts. Each sequence can be a string or a
list of strings (pretokenized string). If the sequences are provided as list of strings (pretokenized),
you must set <code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_target"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.text_pair_target",description:`<strong>text_pair_target</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded as target texts. Each sequence can be a string or a
list of strings (pretokenized string). If the sequences are provided as list of strings (pretokenized),
you must set <code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_pair_target"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to add special tokens when encoding the sequences. This will use the underlying
<code>PretrainedTokenizerBase.build_inputs_with_special_tokens</code> function, which defines which tokens are
automatically added to the input ids. This is usefull if you want to add <code>bos</code> or <code>eos</code> tokens
automatically.`,name:"add_special_tokens"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls padding. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls truncation. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_second&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>False</code> or <code>&apos;do_not_truncate&apos;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).</li>
</ul>`,name:"truncation"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Controls the maximum length to use by one of the truncation/padding parameters.</p>
<p>If left unset or set to <code>None</code>, this will use the predefined model maximum length if a maximum length
is required by one of the truncation/padding parameters. If the model has no specific maximum input
length (like XLNet) truncation/padding to a maximum length will be deactivated.`,name:"max_length"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.`,name:"stride"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.is_split_into_words",description:`<strong>is_split_into_words</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the input is already pre-tokenized (e.g., split into words). If set to <code>True</code>, the
tokenizer assumes the input is already split into words (for instance, by splitting it on whitespace)
which it will tokenize. This is useful for NER or token classification.`,name:"is_split_into_words"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value. Requires <code>padding</code> to be activated.
This is especially useful to enable the use of Tensor Cores on NVIDIA hardware with compute capability
<code>&gt;= 7.5</code> (Volta).`,name:"pad_to_multiple_of"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.return_token_type_ids",description:`<strong>return_token_type_ids</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return token type IDs. If left to the default, will return the token type IDs according to
the specific tokenizer&#x2019;s default, defined by the <code>return_outputs</code> attribute.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"return_token_type_ids"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.return_attention_mask",description:`<strong>return_attention_mask</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return the attention mask. If left to the default, will return the attention mask according
to the specific tokenizer&#x2019;s default, defined by the <code>return_outputs</code> attribute.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"return_attention_mask"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.return_overflowing_tokens",description:`<strong>return_overflowing_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return overflowing token sequences. If a pair of sequences of input ids (or a batch
of pairs) is provided with <code>truncation_strategy = longest_first</code> or <code>True</code>, an error is raised instead
of returning overflowing tokens.`,name:"return_overflowing_tokens"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.return_special_tokens_mask",description:`<strong>return_special_tokens_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return special tokens mask information.`,name:"return_special_tokens_mask"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.return_offsets_mapping",description:`<strong>return_offsets_mapping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return <code>(char_start, char_end)</code> for each token.</p>
<p>This is only available on fast tokenizers inheriting from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a>, if using
Python&#x2019;s tokenizer, this method will raise <code>NotImplementedError</code>.`,name:"return_offsets_mapping"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.return_length",description:`<strong>return_length</strong>  (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the lengths of the encoded inputs.`,name:"return_length"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.verbose",description:`<strong>verbose</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to print more information and warnings.
**kwargs &#x2014; passed to the <code>self.tokenize()</code> method`,name:"verbose"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tokenization_utils_base.py#L2799",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a> with the following fields:</p>
<ul>
<li>
<p><strong>input_ids</strong> — List of token ids to be fed to a model.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
</li>
<li>
<p><strong>token_type_ids</strong> — List of token type ids to be fed to a model (when <code>return_token_type_ids=True</code> or
if <em>“token_type_ids”</em> is in <code>self.model_input_names</code>).</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a></p>
</li>
<li>
<p><strong>attention_mask</strong> — List of indices specifying which tokens should be attended to by the model (when
<code>return_attention_mask=True</code> or if <em>“attention_mask”</em> is in <code>self.model_input_names</code>).</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
</li>
<li>
<p><strong>overflowing_tokens</strong> — List of overflowing tokens sequences (when a <code>max_length</code> is specified and
<code>return_overflowing_tokens=True</code>).</p>
</li>
<li>
<p><strong>num_truncated_tokens</strong> — Number of tokens truncated (when a <code>max_length</code> is specified and
<code>return_overflowing_tokens=True</code>).</p>
</li>
<li>
<p><strong>special_tokens_mask</strong> — List of 0s and 1s, with 1 specifying added special tokens and 0 specifying
regular sequence tokens (when <code>add_special_tokens=True</code> and <code>return_special_tokens_mask=True</code>).</p>
</li>
<li>
<p><strong>length</strong> — The length of the inputs (when <code>return_length=True</code>)</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a></p>
`}}),ro=new U({props:{name:"save_vocabulary",anchor:"transformers.Wav2Vec2CTCTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/tokenization_wav2vec2.py#L633"}}),bt=new U({props:{name:"decode",anchor:"transformers.Wav2Vec2CTCTokenizer.decode",parameters:[{name:"token_ids",val:": Union"},{name:"skip_special_tokens",val:": bool = False"},{name:"clean_up_tokenization_spaces",val:": bool = None"},{name:"output_char_offsets",val:": bool = False"},{name:"output_word_offsets",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2CTCTokenizer.decode.token_ids",description:`<strong>token_ids</strong> (<code>Union[int, List[int], np.ndarray, torch.Tensor, tf.Tensor]</code>) &#x2014;
List of tokenized input ids. Can be obtained using the <code>__call__</code> method.`,name:"token_ids"},{anchor:"transformers.Wav2Vec2CTCTokenizer.decode.skip_special_tokens",description:`<strong>skip_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to remove special tokens in the decoding.`,name:"skip_special_tokens"},{anchor:"transformers.Wav2Vec2CTCTokenizer.decode.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to clean up the tokenization spaces.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.Wav2Vec2CTCTokenizer.decode.output_char_offsets",description:`<strong>output_char_offsets</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to output character offsets. Character offsets can be used in combination with the
sampling rate and model downsampling rate to compute the time-stamps of transcribed characters.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>Please take a look at the example below to better understand how to make use of <code>output_char_offsets</code>.</p>

					</div>`,name:"output_char_offsets"},{anchor:"transformers.Wav2Vec2CTCTokenizer.decode.output_word_offsets",description:`<strong>output_word_offsets</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to output word offsets. Word offsets can be used in combination with the sampling rate
and model downsampling rate to compute the time-stamps of transcribed words.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>Please take a look at the example below to better understand how to make use of <code>output_word_offsets</code>.</p>

					</div>`,name:"output_word_offsets"},{anchor:"transformers.Wav2Vec2CTCTokenizer.decode.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Will be passed to the underlying model specific decode method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/tokenization_wav2vec2.py#L528",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The list of decoded
sentences. Will be a <code>Wav2Vec2CTCTokenizerOutput</code> when
<code>output_char_offsets == True</code> or <code>output_word_offsets == True</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code> or <code>Wav2Vec2CTCTokenizerOutput</code></p>
`}}),lo=new Ct({props:{anchor:"transformers.Wav2Vec2CTCTokenizer.decode.example",$$slots:{default:[Es]},$$scope:{ctx:x}}}),To=new U({props:{name:"batch_decode",anchor:"transformers.Wav2Vec2CTCTokenizer.batch_decode",parameters:[{name:"sequences",val:": Union"},{name:"skip_special_tokens",val:": bool = False"},{name:"clean_up_tokenization_spaces",val:": bool = None"},{name:"output_char_offsets",val:": bool = False"},{name:"output_word_offsets",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2CTCTokenizer.batch_decode.sequences",description:`<strong>sequences</strong> (<code>Union[List[int], List[List[int]], np.ndarray, torch.Tensor, tf.Tensor]</code>) &#x2014;
List of tokenized input ids. Can be obtained using the <code>__call__</code> method.`,name:"sequences"},{anchor:"transformers.Wav2Vec2CTCTokenizer.batch_decode.skip_special_tokens",description:`<strong>skip_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to remove special tokens in the decoding.`,name:"skip_special_tokens"},{anchor:"transformers.Wav2Vec2CTCTokenizer.batch_decode.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to clean up the tokenization spaces.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.Wav2Vec2CTCTokenizer.batch_decode.output_char_offsets",description:`<strong>output_char_offsets</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to output character offsets. Character offsets can be used in combination with the
sampling rate and model downsampling rate to compute the time-stamps of transcribed characters.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>Please take a look at the Example of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer.decode">decode()</a> to better understand how to make
use of <code>output_char_offsets</code>. <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer.batch_decode">batch_decode()</a> works the same way with batched
output.</p>

					</div>`,name:"output_char_offsets"},{anchor:"transformers.Wav2Vec2CTCTokenizer.batch_decode.output_word_offsets",description:`<strong>output_word_offsets</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to output word offsets. Word offsets can be used in combination with the sampling rate
and model downsampling rate to compute the time-stamps of transcribed words.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>Please take a look at the Example of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer.decode">decode()</a> to better understand how to make
use of <code>output_word_offsets</code>. <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer.batch_decode">batch_decode()</a> works the same way with batched
output.</p>

					</div>`,name:"output_word_offsets"},{anchor:"transformers.Wav2Vec2CTCTokenizer.batch_decode.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Will be passed to the underlying model specific decode method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/tokenization_wav2vec2.py#L458",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The list of decoded
sentences. Will be a <code>Wav2Vec2CTCTokenizerOutput</code> when
<code>output_char_offsets == True</code> or <code>output_word_offsets == True</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code> or <code>Wav2Vec2CTCTokenizerOutput</code></p>
`}}),jo=new U({props:{name:"set_target_lang",anchor:"transformers.Wav2Vec2CTCTokenizer.set_target_lang",parameters:[{name:"target_lang",val:": str"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/tokenization_wav2vec2.py#L198"}}),qt=new te({props:{title:"Wav2Vec2FeatureExtractor",local:"transformers.Wav2Vec2FeatureExtractor",headingTag:"h2"}}),yt=new U({props:{name:"class transformers.Wav2Vec2FeatureExtractor",anchor:"transformers.Wav2Vec2FeatureExtractor",parameters:[{name:"feature_size",val:" = 1"},{name:"sampling_rate",val:" = 16000"},{name:"padding_value",val:" = 0.0"},{name:"return_attention_mask",val:" = False"},{name:"do_normalize",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2FeatureExtractor.feature_size",description:`<strong>feature_size</strong> (<code>int</code>, defaults to 1) &#x2014;
The feature dimension of the extracted features.`,name:"feature_size"},{anchor:"transformers.Wav2Vec2FeatureExtractor.sampling_rate",description:`<strong>sampling_rate</strong> (<code>int</code>, defaults to 16000) &#x2014;
The sampling rate at which the audio files should be digitalized expressed in hertz (Hz).`,name:"sampling_rate"},{anchor:"transformers.Wav2Vec2FeatureExtractor.padding_value",description:`<strong>padding_value</strong> (<code>float</code>, defaults to 0.0) &#x2014;
The value that is used to fill the padding values.`,name:"padding_value"},{anchor:"transformers.Wav2Vec2FeatureExtractor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to zero-mean unit-variance normalize the input. Normalizing can help to significantly
improve the performance for some models, <em>e.g.</em>,
<a href="https://huggingface.co/models?search=lv60" rel="nofollow">wav2vec2-lv60</a>.`,name:"do_normalize"},{anchor:"transformers.Wav2Vec2FeatureExtractor.return_attention_mask",description:`<strong>return_attention_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor.__call__"><strong>call</strong>()</a> should return <code>attention_mask</code>.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>Wav2Vec2 models that have set <code>config.feat_extract_norm == &quot;group&quot;</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">wav2vec2-base</a>, have <strong>not</strong> been trained using
<code>attention_mask</code>. For such models, <code>input_values</code> should simply be padded with 0 and no <code>attention_mask</code>
should be passed.</p>
<p>For Wav2Vec2 models that have set <code>config.feat_extract_norm == &quot;layer&quot;</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-large-960h-lv60-self" rel="nofollow">wav2vec2-lv60</a>, <code>attention_mask</code> should be
passed for batched inference.</p>

					</div>`,name:"return_attention_mask"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/feature_extraction_wav2vec2.py#L31"}}),Yt=new U({props:{name:"__call__",anchor:"transformers.Wav2Vec2FeatureExtractor.__call__",parameters:[{name:"raw_speech",val:": Union"},{name:"padding",val:": Union = False"},{name:"max_length",val:": Optional = None"},{name:"truncation",val:": bool = False"},{name:"pad_to_multiple_of",val:": Optional = None"},{name:"return_attention_mask",val:": Optional = None"},{name:"return_tensors",val:": Union = None"},{name:"sampling_rate",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2FeatureExtractor.__call__.raw_speech",description:`<strong>raw_speech</strong> (<code>np.ndarray</code>, <code>List[float]</code>, <code>List[np.ndarray]</code>, <code>List[List[float]]</code>) &#x2014;
The sequence or batch of sequences to be padded. Each sequence can be a numpy array, a list of float
values, a list of numpy arrays or a list of list of float values. Must be mono channel audio, not
stereo, i.e. single float per timestep.`,name:"raw_speech"},{anchor:"transformers.Wav2Vec2FeatureExtractor.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Select a strategy to pad the returned sequences (according to the model&#x2019;s padding side and padding
index) among:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.Wav2Vec2FeatureExtractor.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum length of the returned list and optionally padding length (see above).`,name:"max_length"},{anchor:"transformers.Wav2Vec2FeatureExtractor.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>) &#x2014;
Activates truncation to cut input sequences longer than <em>max_length</em> to <em>max_length</em>.`,name:"truncation"},{anchor:"transformers.Wav2Vec2FeatureExtractor.__call__.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value.</p>
<p>This is especially useful to enable the use of Tensor Cores on NVIDIA hardware with compute capability
<code>&gt;= 7.5</code> (Volta), or on TPUs which benefit from having sequence lengths be a multiple of 128.`,name:"pad_to_multiple_of"},{anchor:"transformers.Wav2Vec2FeatureExtractor.__call__.return_attention_mask",description:`<strong>return_attention_mask</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return the attention mask. If left to the default, will return the attention mask according
to the specific feature_extractor&#x2019;s default.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>Wav2Vec2 models that have set <code>config.feat_extract_norm == &quot;group&quot;</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">wav2vec2-base</a>, have <strong>not</strong> been trained using
<code>attention_mask</code>. For such models, <code>input_values</code> should simply be padded with 0 and no
<code>attention_mask</code> should be passed.</p>
<p>For Wav2Vec2 models that have set <code>config.feat_extract_norm == &quot;layer&quot;</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-large-960h-lv60-self" rel="nofollow">wav2vec2-lv60</a>, <code>attention_mask</code> should
be passed for batched inference.</p>

					</div>`,name:"return_attention_mask"},{anchor:"transformers.Wav2Vec2FeatureExtractor.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.Wav2Vec2FeatureExtractor.__call__.sampling_rate",description:`<strong>sampling_rate</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The sampling rate at which the <code>raw_speech</code> input was sampled. It is strongly recommended to pass
<code>sampling_rate</code> at the forward call to prevent silent errors.`,name:"sampling_rate"},{anchor:"transformers.Wav2Vec2FeatureExtractor.__call__.padding_value",description:"<strong>padding_value</strong> (<code>float</code>, defaults to 0.0) &#x2014;",name:"padding_value"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/feature_extraction_wav2vec2.py#L102"}}),mo=new te({props:{title:"Wav2Vec2Processor",local:"transformers.Wav2Vec2Processor",headingTag:"h2"}}),uo=new U({props:{name:"class transformers.Wav2Vec2Processor",anchor:"transformers.Wav2Vec2Processor",parameters:[{name:"feature_extractor",val:""},{name:"tokenizer",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2Processor.feature_extractor",description:`<strong>feature_extractor</strong> (<code>Wav2Vec2FeatureExtractor</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a>. The feature extractor is a required input.`,name:"feature_extractor"},{anchor:"transformers.Wav2Vec2Processor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
An instance of <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/processing_wav2vec2.py#L26"}}),Mt=new U({props:{name:"__call__",anchor:"transformers.Wav2Vec2Processor.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/processing_wav2vec2.py#L68"}}),et=new U({props:{name:"pad",anchor:"transformers.Wav2Vec2Processor.pad",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/processing_wav2vec2.py#L106"}}),ye=new U({props:{name:"from_pretrained",anchor:"transformers.Wav2Vec2Processor.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/processing_wav2vec2.py#L49"}}),ot=new U({props:{name:"save_pretrained",anchor:"transformers.Wav2Vec2Processor.save_pretrained",parameters:[{name:"save_directory",val:""},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2Processor.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the feature extractor JSON file and the tokenizer files will be saved (directory will
be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.Wav2Vec2Processor.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.Wav2Vec2Processor.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/main/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L167"}}),Ro=new ft({props:{$$slots:{default:[Ps]},$$scope:{ctx:x}}}),ia=new U({props:{name:"batch_decode",anchor:"transformers.Wav2Vec2Processor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/processing_wav2vec2.py#L136"}}),ca=new U({props:{name:"decode",anchor:"transformers.Wav2Vec2Processor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/processing_wav2vec2.py#L143"}}),da=new te({props:{title:"Wav2Vec2ProcessorWithLM",local:"transformers.Wav2Vec2ProcessorWithLM",headingTag:"h2"}}),pa=new U({props:{name:"class transformers.Wav2Vec2ProcessorWithLM",anchor:"transformers.Wav2Vec2ProcessorWithLM",parameters:[{name:"feature_extractor",val:": FeatureExtractionMixin"},{name:"tokenizer",val:": PreTrainedTokenizerBase"},{name:"decoder",val:": BeamSearchDecoderCTC"}],parametersDescription:[{anchor:"transformers.Wav2Vec2ProcessorWithLM.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a>. The feature extractor is a required input.`,name:"feature_extractor"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a>. The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decoder",description:`<strong>decoder</strong> (<code>pyctcdecode.BeamSearchDecoderCTC</code>) &#x2014;
An instance of <code>pyctcdecode.BeamSearchDecoderCTC</code>. The decoder is a required input.`,name:"decoder"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2_with_lm/processing_wav2vec2_with_lm.py#L67"}}),ma=new U({props:{name:"__call__",anchor:"transformers.Wav2Vec2ProcessorWithLM.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2_with_lm/processing_wav2vec2_with_lm.py#L214"}}),ha=new U({props:{name:"pad",anchor:"transformers.Wav2Vec2ProcessorWithLM.pad",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2_with_lm/processing_wav2vec2_with_lm.py#L253"}}),ua=new U({props:{name:"from_pretrained",anchor:"transformers.Wav2Vec2ProcessorWithLM.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2ProcessorWithLM.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.
**kwargs &#x2014;
Additional keyword arguments passed along to both <a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.SequenceFeatureExtractor">SequenceFeatureExtractor</a> and
<a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a></li>
</ul>`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2_with_lm/processing_wav2vec2_with_lm.py#L113"}}),Lo=new ft({props:{$$slots:{default:[Qs]},$$scope:{ctx:x}}}),fa=new U({props:{name:"save_pretrained",anchor:"transformers.Wav2Vec2ProcessorWithLM.save_pretrained",parameters:[{name:"save_directory",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2_with_lm/processing_wav2vec2_with_lm.py#L109"}}),ga=new U({props:{name:"batch_decode",anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode",parameters:[{name:"logits",val:": ndarray"},{name:"pool",val:": Optional = None"},{name:"num_processes",val:": Optional = None"},{name:"beam_width",val:": Optional = None"},{name:"beam_prune_logp",val:": Optional = None"},{name:"token_min_logp",val:": Optional = None"},{name:"hotwords",val:": Optional = None"},{name:"hotword_weight",val:": Optional = None"},{name:"alpha",val:": Optional = None"},{name:"beta",val:": Optional = None"},{name:"unk_score_offset",val:": Optional = None"},{name:"lm_score_boundary",val:": Optional = None"},{name:"output_word_offsets",val:": bool = False"},{name:"n_best",val:": int = 1"}],parametersDescription:[{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.logits",description:`<strong>logits</strong> (<code>np.ndarray</code>) &#x2014;
The logits output vector of the model representing the log probabilities for each token.`,name:"logits"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.pool",description:`<strong>pool</strong> (<code>multiprocessing.Pool</code>, <em>optional</em>) &#x2014;
An optional user-managed pool. If not set, one will be automatically created and closed. The pool
should be instantiated <em>after</em> <code>Wav2Vec2ProcessorWithLM</code>. Otherwise, the LM won&#x2019;t be available to the
pool&#x2019;s sub-processes.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>Currently, only pools created with a &#x2018;fork&#x2019; context can be used. If a &#x2018;spawn&#x2019; pool is passed, it will
be ignored and sequential decoding will be used instead.</p>

					</div>`,name:"pool"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.num_processes",description:`<strong>num_processes</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If <code>pool</code> is not set, number of processes on which the function should be parallelized over. Defaults
to the number of available CPUs.`,name:"num_processes"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.beam_width",description:`<strong>beam_width</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of beams at each step in decoding. Defaults to pyctcdecode&#x2019;s DEFAULT_BEAM_WIDTH.`,name:"beam_width"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.beam_prune_logp",description:`<strong>beam_prune_logp</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Beams that are much worse than best beam will be pruned Defaults to pyctcdecode&#x2019;s DEFAULT_PRUNE_LOGP.`,name:"beam_prune_logp"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.token_min_logp",description:`<strong>token_min_logp</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Tokens below this logp are skipped unless they are argmax of frame Defaults to pyctcdecode&#x2019;s
DEFAULT_MIN_TOKEN_LOGP.`,name:"token_min_logp"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.hotwords",description:`<strong>hotwords</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of words with extra importance, can be OOV for LM`,name:"hotwords"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.hotword_weight",description:`<strong>hotword_weight</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Weight factor for hotword importance Defaults to pyctcdecode&#x2019;s DEFAULT_HOTWORD_WEIGHT.`,name:"hotword_weight"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.alpha",description:`<strong>alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Weight for language model during shallow fusion`,name:"alpha"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.beta",description:`<strong>beta</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Weight for length score adjustment of during scoring`,name:"beta"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.unk_score_offset",description:`<strong>unk_score_offset</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Amount of log score offset for unknown tokens`,name:"unk_score_offset"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.lm_score_boundary",description:`<strong>lm_score_boundary</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to have kenlm respect boundaries when scoring`,name:"lm_score_boundary"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.output_word_offsets",description:`<strong>output_word_offsets</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to output word offsets. Word offsets can be used in combination with the sampling rate
and model downsampling rate to compute the time-stamps of transcribed words.`,name:"output_word_offsets"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.n_best",description:`<strong>n_best</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Number of best hypotheses to return. If <code>n_best</code> is greater than 1, the returned <code>text</code> will be a list
of lists of strings, <code>logit_score</code> will be a list of lists of floats, and <code>lm_score</code> will be a list of
lists of floats, where the length of the outer list will correspond to the batch size and the length of
the inner list will correspond to the number of returned hypotheses . The value should be &gt;= 1.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>Please take a look at the Example of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ProcessorWithLM.decode">decode()</a> to better understand how to
make use of <code>output_word_offsets</code>. <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ProcessorWithLM.batch_decode">batch_decode()</a> works the same way with
batched output.</p>

					</div>`,name:"n_best"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2_with_lm/processing_wav2vec2_with_lm.py#L284",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~models.wav2vec2.Wav2Vec2DecoderWithLMOutput</code>.</p>
`}}),Eo=new ft({props:{$$slots:{default:[Ss]},$$scope:{ctx:x}}}),_a=new U({props:{name:"decode",anchor:"transformers.Wav2Vec2ProcessorWithLM.decode",parameters:[{name:"logits",val:": ndarray"},{name:"beam_width",val:": Optional = None"},{name:"beam_prune_logp",val:": Optional = None"},{name:"token_min_logp",val:": Optional = None"},{name:"hotwords",val:": Optional = None"},{name:"hotword_weight",val:": Optional = None"},{name:"alpha",val:": Optional = None"},{name:"beta",val:": Optional = None"},{name:"unk_score_offset",val:": Optional = None"},{name:"lm_score_boundary",val:": Optional = None"},{name:"output_word_offsets",val:": bool = False"},{name:"n_best",val:": int = 1"}],parametersDescription:[{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.logits",description:`<strong>logits</strong> (<code>np.ndarray</code>) &#x2014;
The logits output vector of the model representing the log probabilities for each token.`,name:"logits"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.beam_width",description:`<strong>beam_width</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of beams at each step in decoding. Defaults to pyctcdecode&#x2019;s DEFAULT_BEAM_WIDTH.`,name:"beam_width"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.beam_prune_logp",description:`<strong>beam_prune_logp</strong> (<code>int</code>, <em>optional</em>) &#x2014;
A threshold to prune beams with log-probs less than best_beam_logp + beam_prune_logp. The value should
be &lt;= 0. Defaults to pyctcdecode&#x2019;s DEFAULT_PRUNE_LOGP.`,name:"beam_prune_logp"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.token_min_logp",description:`<strong>token_min_logp</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Tokens with log-probs below token_min_logp are skipped unless they are have the maximum log-prob for an
utterance. Defaults to pyctcdecode&#x2019;s DEFAULT_MIN_TOKEN_LOGP.`,name:"token_min_logp"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.hotwords",description:`<strong>hotwords</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of words with extra importance which can be missing from the LM&#x2019;s vocabulary, e.g. [&#x201C;huggingface&#x201D;]`,name:"hotwords"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.hotword_weight",description:`<strong>hotword_weight</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Weight multiplier that boosts hotword scores. Defaults to pyctcdecode&#x2019;s DEFAULT_HOTWORD_WEIGHT.`,name:"hotword_weight"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.alpha",description:`<strong>alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Weight for language model during shallow fusion`,name:"alpha"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.beta",description:`<strong>beta</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Weight for length score adjustment of during scoring`,name:"beta"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.unk_score_offset",description:`<strong>unk_score_offset</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Amount of log score offset for unknown tokens`,name:"unk_score_offset"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.lm_score_boundary",description:`<strong>lm_score_boundary</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to have kenlm respect boundaries when scoring`,name:"lm_score_boundary"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.output_word_offsets",description:`<strong>output_word_offsets</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to output word offsets. Word offsets can be used in combination with the sampling rate
and model downsampling rate to compute the time-stamps of transcribed words.`,name:"output_word_offsets"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.n_best",description:`<strong>n_best</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Number of best hypotheses to return. If <code>n_best</code> is greater than 1, the returned <code>text</code> will be a list
of strings, <code>logit_score</code> will be a list of floats, and <code>lm_score</code> will be a list of floats, where the
length of these lists will correspond to the number of returned hypotheses. The value should be &gt;= 1.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>Please take a look at the example below to better understand how to make use of <code>output_word_offsets</code>.</p>

					</div>`,name:"n_best"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2_with_lm/processing_wav2vec2_with_lm.py#L469",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~models.wav2vec2.Wav2Vec2DecoderWithLMOutput</code>.</p>
`}}),Po=new Ct({props:{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.example",$$slots:{default:[As]},$$scope:{ctx:x}}}),va=new te({props:{title:"Decoding multiple audios",local:"decoding-multiple-audios",headingTag:"h3"}}),ya=new dt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Let&#x27;s see how to use a user-managed pool for batch decoding multiple audios</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> multiprocessing <span class="hljs-keyword">import</span> get_context
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoProcessor, AutoModelForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> datasets
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># import model, feature extractor, tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(<span class="hljs-string">&quot;patrickvonplaten/wav2vec2-base-100h-with-lm&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;patrickvonplaten/wav2vec2-base-100h-with-lm&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load example dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, datasets.Audio(sampling_rate=<span class="hljs-number">16_000</span>))


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">map_to_array</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;speech&quot;</span>] = batch[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare speech data for batch inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(map_to_array, remove_columns=[<span class="hljs-string">&quot;audio&quot;</span>])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">map_to_pred</span>(<span class="hljs-params">batch, pool</span>):
<span class="hljs-meta">... </span>    inputs = processor(batch[<span class="hljs-string">&quot;speech&quot;</span>], sampling_rate=<span class="hljs-number">16_000</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">... </span>    inputs = {k: v.to(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}

<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        logits = model(**inputs).logits

<span class="hljs-meta">... </span>    transcription = processor.batch_decode(logits.cpu().numpy(), pool).text
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;transcription&quot;</span>] = transcription
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># note: pool should be instantiated *after* \`Wav2Vec2ProcessorWithLM\`.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment">#       otherwise, the LM won&#x27;t be available to the pool&#x27;s sub-processes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># select number of processes and batch_size based on number of CPU cores available and on dataset size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> get_context(<span class="hljs-string">&quot;fork&quot;</span>).Pool(processes=<span class="hljs-number">2</span>) <span class="hljs-keyword">as</span> pool:
<span class="hljs-meta">... </span>    result = dataset.<span class="hljs-built_in">map</span>(
<span class="hljs-meta">... </span>        map_to_pred, batched=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">2</span>, fn_kwargs={<span class="hljs-string">&quot;pool&quot;</span>: pool}, remove_columns=[<span class="hljs-string">&quot;speech&quot;</span>]
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">&gt;&gt;&gt; </span>result[<span class="hljs-string">&quot;transcription&quot;</span>][:<span class="hljs-number">2</span>]
[<span class="hljs-string">&#x27;MISTER QUILTER IS THE APOSTLE OF THE MIDDLE CLASSES AND WE ARE GLAD TO WELCOME HIS GOSPEL&#x27;</span>, <span class="hljs-string">&quot;NOR IS MISTER COULTER&#x27;S MANNER LESS INTERESTING THAN HIS MATTER&quot;</span>]`,wrap:!1}}),wa=new te({props:{title:"Wav2Vec2 specific outputs",local:"transformers.models.wav2vec2_with_lm.processing_wav2vec2_with_lm.Wav2Vec2DecoderWithLMOutput",headingTag:"h2"}}),Ma=new U({props:{name:"class transformers.models.wav2vec2_with_lm.processing_wav2vec2_with_lm.Wav2Vec2DecoderWithLMOutput",anchor:"transformers.models.wav2vec2_with_lm.processing_wav2vec2_with_lm.Wav2Vec2DecoderWithLMOutput",parameters:[{name:"text",val:": Union"},{name:"logit_score",val:": Union = None"},{name:"lm_score",val:": Union = None"},{name:"word_offsets",val:": Union = None"}],parametersDescription:[{anchor:"transformers.models.wav2vec2_with_lm.processing_wav2vec2_with_lm.Wav2Vec2DecoderWithLMOutput.text",description:`<strong>text</strong> (list of <code>str</code> or <code>str</code>) &#x2014;
Decoded logits in text from. Usually the speech transcription.`,name:"text"},{anchor:"transformers.models.wav2vec2_with_lm.processing_wav2vec2_with_lm.Wav2Vec2DecoderWithLMOutput.logit_score",description:`<strong>logit_score</strong> (list of <code>float</code> or <code>float</code>) &#x2014;
Total logit score of the beams associated with produced text.`,name:"logit_score"},{anchor:"transformers.models.wav2vec2_with_lm.processing_wav2vec2_with_lm.Wav2Vec2DecoderWithLMOutput.lm_score",description:`<strong>lm_score</strong> (list of <code>float</code>) &#x2014;
Fused lm_score of the beams associated with produced text.`,name:"lm_score"},{anchor:"transformers.models.wav2vec2_with_lm.processing_wav2vec2_with_lm.Wav2Vec2DecoderWithLMOutput.word_offsets",description:`<strong>word_offsets</strong> (list of <code>List[Dict[str, Union[int, str]]]</code> or <code>List[Dict[str, Union[int, str]]]</code>) &#x2014;
Offsets of the decoded words. In combination with sampling rate and model downsampling rate word offsets
can be used to compute time stamps for each word.`,name:"word_offsets"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2_with_lm/processing_wav2vec2_with_lm.py#L44"}}),Ta=new U({props:{name:"class transformers.modeling_outputs.Wav2Vec2BaseModelOutput",anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"extract_features",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput.extract_features",description:`<strong>extract_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, conv_dim[-1])</code>) &#x2014;
Sequence of extracted feature vectors of the last convolutional layer of the model.`,name:"extract_features"},{anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L1376"}}),ja=new U({props:{name:"class transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput",anchor:"transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"projected_states",val:": FloatTensor = None"},{name:"projected_quantized_states",val:": FloatTensor = None"},{name:"codevector_perplexity",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"contrastive_loss",val:": Optional = None"},{name:"diversity_loss",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput.loss",description:`<strong>loss</strong> (<em>optional</em>, returned when <code>sample_negative_indices</code> are passed, <code>torch.FloatTensor</code> of shape <code>(1,)</code>) &#x2014;
Total loss as the sum of the contrastive loss (L_m) and the diversity loss (L_d) as stated in the <a href="https://arxiv.org/pdf/2006.11477.pdf" rel="nofollow">official
paper</a> . (classification) loss.`,name:"loss"},{anchor:"transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput.projected_states",description:`<strong>projected_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.proj_codevector_dim)</code>) &#x2014;
Hidden-states of the model projected to <em>config.proj_codevector_dim</em> that can be used to predict the masked
projected quantized states.`,name:"projected_states"},{anchor:"transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput.projected_quantized_states",description:`<strong>projected_quantized_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.proj_codevector_dim)</code>) &#x2014;
Quantized extracted feature vectors projected to <em>config.proj_codevector_dim</em> representing the positive
target vectors for contrastive loss.`,name:"projected_quantized_states"},{anchor:"transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput.contrastive_loss",description:`<strong>contrastive_loss</strong> (<em>optional</em>, returned when <code>sample_negative_indices</code> are passed, <code>torch.FloatTensor</code> of shape <code>(1,)</code>) &#x2014;
The contrastive loss (L_m) as stated in the <a href="https://arxiv.org/pdf/2006.11477.pdf" rel="nofollow">official paper</a> .`,name:"contrastive_loss"},{anchor:"transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput.diversity_loss",description:`<strong>diversity_loss</strong> (<em>optional</em>, returned when <code>sample_negative_indices</code> are passed, <code>torch.FloatTensor</code> of shape <code>(1,)</code>) &#x2014;
The diversity loss (L_d) as stated in the <a href="https://arxiv.org/pdf/2006.11477.pdf" rel="nofollow">official paper</a> .`,name:"diversity_loss"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L115"}}),ka=new U({props:{name:"class transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2BaseModelOutput",anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2BaseModelOutput",parameters:[{name:"last_hidden_state",val:": Array = None"},{name:"extract_features",val:": Array = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2BaseModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2BaseModelOutput.extract_features",description:`<strong>extract_features</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, last_conv_dim)</code>) &#x2014;
Sequence of extracted feature vectors of the last convolutional layer of the model with <code>last_conv_dim</code>
being the dimension of the last convolutional layer.`,name:"extract_features"},{anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2BaseModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2BaseModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_flax_wav2vec2.py#L44"}}),Wa=new U({props:{name:"replace",anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2BaseModelOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),xa=new U({props:{name:"class transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput",anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput",parameters:[{name:"projected_states",val:": Array = None"},{name:"projected_quantized_states",val:": Array = None"},{name:"codevector_perplexity",val:": Array = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput.loss",description:`<strong>loss</strong> (<em>optional</em>, returned when model is in train mode, <code>jnp.ndarray</code> of shape <code>(1,)</code>) &#x2014;
Total loss as the sum of the contrastive loss (L_m) and the diversity loss (L_d) as stated in the <a href="https://arxiv.org/pdf/2006.11477.pdf" rel="nofollow">official
paper</a> . (classification) loss.`,name:"loss"},{anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput.projected_states",description:`<strong>projected_states</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.proj_codevector_dim)</code>) &#x2014;
Hidden-states of the model projected to <em>config.proj_codevector_dim</em> that can be used to predict the masked
projected quantized states.`,name:"projected_states"},{anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput.projected_quantized_states",description:`<strong>projected_quantized_states</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.proj_codevector_dim)</code>) &#x2014;
Quantized extracted feature vectors projected to <em>config.proj_codevector_dim</em> representing the positive
target vectors for contrastive loss.`,name:"projected_quantized_states"},{anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_flax_wav2vec2.py#L74"}}),Va=new U({props:{name:"replace",anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),Ao=new Ys({props:{pytorch:!0,tensorflow:!0,jax:!0,$$slots:{jax:[Vr],tensorflow:[yr],pytorch:[mr]},$$scope:{ctx:x}}}),Ja=new Hs({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/wav2vec2.md"}}),{c(){t=c("meta"),y=s(),n=c("p"),i=s(),u(M.$$.fragment),o=s(),u(j.$$.fragment),we=s(),B=c("p"),B.innerHTML=O,Me=s(),X=c("p"),X.textContent=K,Te=s(),k=c("p"),k.innerHTML=G,re=s(),P=c("p"),P.innerHTML=Dt,Ee=s(),u(N.$$.fragment),Ie=s(),Q=c("ul"),Q.innerHTML=nt,ce=s(),u($e.$$.fragment),I=s(),de=c("p"),de.textContent=le,pe=s(),u(je.$$.fragment),Be=s(),z=c("p"),z.innerHTML=st,Xe=s(),oe=c("p"),oe.innerHTML=ae,Ge=s(),u(H.$$.fragment),ke=s(),u(rt.$$.fragment),We=s(),Re=c("p"),Re.innerHTML=Et,me=s(),u(Ce.$$.fragment),Ne=s(),u(xe.$$.fragment),S=s(),ge=c("p"),ge.innerHTML=q,ee=s(),Pe=c("div"),Pe.innerHTML=qe,Qe=s(),u(Se.$$.fragment),L=s(),Ye=c("p"),Ye.textContent=A,Ae=s(),u(T.$$.fragment),F=s(),Z=c("ul"),Z.innerHTML=ie,pt=s(),u(R.$$.fragment),ne=s(),mt=c("ul"),mt.innerHTML=Pt,Ft=s(),Ut=c("p"),Ut.textContent=Qt,Zt=s(),zt=c("ul"),zt.innerHTML=St,He=s(),u(De.$$.fragment),jt=s(),_e=c("div"),u(It.$$.fragment),Le=s(),ve=c("p"),ve.innerHTML=bo,Oe=s(),Bt=c("p"),Bt.innerHTML=Xt,ht=s(),u(E.$$.fragment),Fe=s(),u(gt.$$.fragment),W=s(),J=c("div"),u(be.$$.fragment),D=s(),Ue=c("p"),Ue.textContent=he,Ve=s(),Ot=c("p"),Ot.innerHTML=Ua,yo=s(),no=c("div"),u(so.$$.fragment),_t=s(),Gt=c("p"),Gt.textContent=Za,wo=s(),$o=c("div"),u(ro.$$.fragment),Kt=s(),vt=c("div"),u(bt.$$.fragment),Bo=s(),Rt=c("p"),Rt.textContent=Ko,Ze=s(),Nt=c("p"),Nt.innerHTML=za,Mo=s(),u(lo.$$.fragment),ea=s(),kt=c("div"),u(To.$$.fragment),ta=s(),At=c("p"),At.textContent=cn,oa=s(),Wt=c("div"),u(jo.$$.fragment),aa=s(),Ke=c("p"),Ke.textContent=ko,Xo=s(),u(qt.$$.fragment),na=s(),ut=c("div"),u(yt.$$.fragment),sa=s(),xt=c("p"),xt.textContent=ra,io=s(),co=c("p"),co.innerHTML=lt,po=s(),eo=c("div"),u(Yt.$$.fragment),Ia=s(),Wo=c("p"),Wo.textContent=Co,la=s(),u(mo.$$.fragment),ho=s(),se=c("div"),u(uo.$$.fragment),wt=s(),Ht=c("p"),Ht.textContent=Ba,xo=s(),Fo=c("p"),Fo.innerHTML=Xa,to=s(),oo=c("div"),u(Mt.$$.fragment),Go=s(),h=c("p"),h.innerHTML=V,Vt=s(),ue=c("div"),u(et.$$.fragment),Jt=s(),Je=c("p"),Je.innerHTML=Lt,tt=s(),it=c("div"),u(ye.$$.fragment),$t=s(),fe=c("div"),u(ot.$$.fragment),Ga=s(),Uo=c("p"),Uo.innerHTML=gs,Gn=s(),u(Ro.$$.fragment),Rn=s(),No=c("div"),u(ia.$$.fragment),Nn=s(),Ra=c("p"),Ra.innerHTML=_s,qn=s(),qo=c("div"),u(ca.$$.fragment),Yn=s(),Na=c("p"),Na.innerHTML=vs,mn=s(),u(da.$$.fragment),hn=s(),ze=c("div"),u(pa.$$.fragment),Hn=s(),qa=c("p"),qa.textContent=bs,Ln=s(),Yo=c("div"),u(ma.$$.fragment),En=s(),Ya=c("p"),Ya.innerHTML=ys,Pn=s(),Ho=c("div"),u(ha.$$.fragment),Qn=s(),Ha=c("p"),Ha.innerHTML=ws,Sn=s(),Vo=c("div"),u(ua.$$.fragment),An=s(),La=c("p"),La.innerHTML=Ms,Dn=s(),u(Lo.$$.fragment),On=s(),Ea=c("div"),u(fa.$$.fragment),Kn=s(),ao=c("div"),u(ga.$$.fragment),es=s(),Pa=c("p"),Pa.textContent=Ts,ts=s(),u(Eo.$$.fragment),os=s(),Qa=c("p"),Qa.innerHTML=js,as=s(),Jo=c("div"),u(_a.$$.fragment),ns=s(),Sa=c("p"),Sa.textContent=ks,ss=s(),u(Po.$$.fragment),un=s(),u(va.$$.fragment),fn=s(),ba=c("p"),ba.innerHTML=Ws,gn=s(),u(ya.$$.fragment),_n=s(),u(wa.$$.fragment),vn=s(),Zo=c("div"),u(Ma.$$.fragment),rs=s(),Aa=c("p"),Aa.innerHTML=xs,bn=s(),zo=c("div"),u(Ta.$$.fragment),ls=s(),Da=c("p"),Da.textContent=Vs,yn=s(),Io=c("div"),u(ja.$$.fragment),is=s(),Oa=c("p"),Oa.innerHTML=Js,wn=s(),fo=c("div"),u(ka.$$.fragment),cs=s(),Ka=c("p"),Ka.innerHTML=$s,ds=s(),Qo=c("div"),u(Wa.$$.fragment),ps=s(),en=c("p"),en.textContent=Cs,Mn=s(),go=c("div"),u(xa.$$.fragment),ms=s(),tn=c("p"),tn.innerHTML=Fs,hs=s(),So=c("div"),u(Va.$$.fragment),us=s(),on=c("p"),on.textContent=Us,Tn=s(),u(Ao.$$.fragment),jn=s(),u(Ja.$$.fragment),kn=s(),dn=c("p"),this.h()},l(e){const w=Ns("svelte-u9bgzb",document.head);t=d(w,"META",{name:!0,content:!0}),w.forEach(l),y=r(e),n=d(e,"P",{}),$(n).forEach(l),i=r(e),f(M.$$.fragment,e),o=r(e),f(j.$$.fragment,e),we=r(e),B=d(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1an18c0"&&(B.innerHTML=O),Me=r(e),X=d(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-vfdo9a"&&(X.textContent=K),Te=r(e),k=d(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-11lu23i"&&(k.innerHTML=G),re=r(e),P=d(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1t6iyb9"&&(P.innerHTML=Dt),Ee=r(e),f(N.$$.fragment,e),Ie=r(e),Q=d(e,"UL",{"data-svelte-h":!0}),m(Q)!=="svelte-15bmgs8"&&(Q.innerHTML=nt),ce=r(e),f($e.$$.fragment,e),I=r(e),de=d(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-1r79v6g"&&(de.textContent=le),pe=r(e),f(je.$$.fragment,e),Be=r(e),z=d(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-ib5l43"&&(z.innerHTML=st),Xe=r(e),oe=d(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-1pp3dkd"&&(oe.innerHTML=ae),Ge=r(e),f(H.$$.fragment,e),ke=r(e),f(rt.$$.fragment,e),We=r(e),Re=d(e,"P",{"data-svelte-h":!0}),m(Re)!=="svelte-10jrnsm"&&(Re.innerHTML=Et),me=r(e),f(Ce.$$.fragment,e),Ne=r(e),f(xe.$$.fragment,e),S=r(e),ge=d(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-bjpb70"&&(ge.innerHTML=q),ee=r(e),Pe=d(e,"DIV",{style:!0,"data-svelte-h":!0}),m(Pe)!=="svelte-1xf428k"&&(Pe.innerHTML=qe),Qe=r(e),f(Se.$$.fragment,e),L=r(e),Ye=d(e,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-x9q80l"&&(Ye.textContent=A),Ae=r(e),f(T.$$.fragment,e),F=r(e),Z=d(e,"UL",{"data-svelte-h":!0}),m(Z)!=="svelte-v956il"&&(Z.innerHTML=ie),pt=r(e),f(R.$$.fragment,e),ne=r(e),mt=d(e,"UL",{"data-svelte-h":!0}),m(mt)!=="svelte-k10sov"&&(mt.innerHTML=Pt),Ft=r(e),Ut=d(e,"P",{"data-svelte-h":!0}),m(Ut)!=="svelte-lk14e4"&&(Ut.textContent=Qt),Zt=r(e),zt=d(e,"UL",{"data-svelte-h":!0}),m(zt)!=="svelte-wbd9h3"&&(zt.innerHTML=St),He=r(e),f(De.$$.fragment,e),jt=r(e),_e=d(e,"DIV",{class:!0});var _o=$(_e);f(It.$$.fragment,_o),Le=r(_o),ve=d(_o,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-xd7oth"&&(ve.innerHTML=bo),Oe=r(_o),Bt=d(_o,"P",{"data-svelte-h":!0}),m(Bt)!=="svelte-o55m63"&&(Bt.innerHTML=Xt),ht=r(_o),f(E.$$.fragment,_o),_o.forEach(l),Fe=r(e),f(gt.$$.fragment,e),W=r(e),J=d(e,"DIV",{class:!0});var at=$(J);f(be.$$.fragment,at),D=r(at),Ue=d(at,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-gxvlja"&&(Ue.textContent=he),Ve=r(at),Ot=d(at,"P",{"data-svelte-h":!0}),m(Ot)!=="svelte-1tlp8g2"&&(Ot.innerHTML=Ua),yo=r(at),no=d(at,"DIV",{class:!0});var $a=$(no);f(so.$$.fragment,$a),_t=r($a),Gt=d($a,"P",{"data-svelte-h":!0}),m(Gt)!=="svelte-kpxj0c"&&(Gt.textContent=Za),$a.forEach(l),wo=r(at),$o=d(at,"DIV",{class:!0});var pn=$($o);f(ro.$$.fragment,pn),pn.forEach(l),Kt=r(at),vt=d(at,"DIV",{class:!0});var vo=$(vt);f(bt.$$.fragment,vo),Bo=r(vo),Rt=d(vo,"P",{"data-svelte-h":!0}),m(Rt)!=="svelte-vbfkpu"&&(Rt.textContent=Ko),Ze=r(vo),Nt=d(vo,"P",{"data-svelte-h":!0}),m(Nt)!=="svelte-125uxon"&&(Nt.innerHTML=za),Mo=r(vo),f(lo.$$.fragment,vo),vo.forEach(l),ea=r(at),kt=d(at,"DIV",{class:!0});var Ca=$(kt);f(To.$$.fragment,Ca),ta=r(Ca),At=d(Ca,"P",{"data-svelte-h":!0}),m(At)!=="svelte-1deng2j"&&(At.textContent=cn),Ca.forEach(l),oa=r(at),Wt=d(at,"DIV",{class:!0});var Fa=$(Wt);f(jo.$$.fragment,Fa),aa=r(Fa),Ke=d(Fa,"P",{"data-svelte-h":!0}),m(Ke)!=="svelte-1cp5sz1"&&(Ke.textContent=ko),Fa.forEach(l),at.forEach(l),Xo=r(e),f(qt.$$.fragment,e),na=r(e),ut=d(e,"DIV",{class:!0});var Do=$(ut);f(yt.$$.fragment,Do),sa=r(Do),xt=d(Do,"P",{"data-svelte-h":!0}),m(xt)!=="svelte-10lmbzj"&&(xt.textContent=ra),io=r(Do),co=d(Do,"P",{"data-svelte-h":!0}),m(co)!=="svelte-3gz575"&&(co.innerHTML=lt),po=r(Do),eo=d(Do,"DIV",{class:!0});var xn=$(eo);f(Yt.$$.fragment,xn),Ia=r(xn),Wo=d(xn,"P",{"data-svelte-h":!0}),m(Wo)!=="svelte-1a6wgfx"&&(Wo.textContent=Co),xn.forEach(l),Do.forEach(l),la=r(e),f(mo.$$.fragment,e),ho=r(e),se=d(e,"DIV",{class:!0});var ct=$(se);f(uo.$$.fragment,ct),wt=r(ct),Ht=d(ct,"P",{"data-svelte-h":!0}),m(Ht)!=="svelte-2ag3qy"&&(Ht.textContent=Ba),xo=r(ct),Fo=d(ct,"P",{"data-svelte-h":!0}),m(Fo)!=="svelte-1tei9vm"&&(Fo.innerHTML=Xa),to=r(ct),oo=d(ct,"DIV",{class:!0});var Vn=$(oo);f(Mt.$$.fragment,Vn),Go=r(Vn),h=d(Vn,"P",{"data-svelte-h":!0}),m(h)!=="svelte-12jtark"&&(h.innerHTML=V),Vn.forEach(l),Vt=r(ct),ue=d(ct,"DIV",{class:!0});var Jn=$(ue);f(et.$$.fragment,Jn),Jt=r(Jn),Je=d(Jn,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-1cr3zei"&&(Je.innerHTML=Lt),Jn.forEach(l),tt=r(ct),it=d(ct,"DIV",{class:!0});var Zs=$(it);f(ye.$$.fragment,Zs),Zs.forEach(l),$t=r(ct),fe=d(ct,"DIV",{class:!0});var an=$(fe);f(ot.$$.fragment,an),Ga=r(an),Uo=d(an,"P",{"data-svelte-h":!0}),m(Uo)!=="svelte-ovc737"&&(Uo.innerHTML=gs),Gn=r(an),f(Ro.$$.fragment,an),an.forEach(l),Rn=r(ct),No=d(ct,"DIV",{class:!0});var $n=$(No);f(ia.$$.fragment,$n),Nn=r($n),Ra=d($n,"P",{"data-svelte-h":!0}),m(Ra)!=="svelte-oplyi9"&&(Ra.innerHTML=_s),$n.forEach(l),qn=r(ct),qo=d(ct,"DIV",{class:!0});var Cn=$(qo);f(ca.$$.fragment,Cn),Yn=r(Cn),Na=d(Cn,"P",{"data-svelte-h":!0}),m(Na)!=="svelte-1vvtk2v"&&(Na.innerHTML=vs),Cn.forEach(l),ct.forEach(l),mn=r(e),f(da.$$.fragment,e),hn=r(e),ze=d(e,"DIV",{class:!0});var Tt=$(ze);f(pa.$$.fragment,Tt),Hn=r(Tt),qa=d(Tt,"P",{"data-svelte-h":!0}),m(qa)!=="svelte-tn9a17"&&(qa.textContent=bs),Ln=r(Tt),Yo=d(Tt,"DIV",{class:!0});var Fn=$(Yo);f(ma.$$.fragment,Fn),En=r(Fn),Ya=d(Fn,"P",{"data-svelte-h":!0}),m(Ya)!=="svelte-160vhkm"&&(Ya.innerHTML=ys),Fn.forEach(l),Pn=r(Tt),Ho=d(Tt,"DIV",{class:!0});var Un=$(Ho);f(ha.$$.fragment,Un),Qn=r(Un),Ha=d(Un,"P",{"data-svelte-h":!0}),m(Ha)!=="svelte-140d9lq"&&(Ha.innerHTML=ws),Un.forEach(l),Sn=r(Tt),Vo=d(Tt,"DIV",{class:!0});var nn=$(Vo);f(ua.$$.fragment,nn),An=r(nn),La=d(nn,"P",{"data-svelte-h":!0}),m(La)!=="svelte-1endixv"&&(La.innerHTML=Ms),Dn=r(nn),f(Lo.$$.fragment,nn),nn.forEach(l),On=r(Tt),Ea=d(Tt,"DIV",{class:!0});var zs=$(Ea);f(fa.$$.fragment,zs),zs.forEach(l),Kn=r(Tt),ao=d(Tt,"DIV",{class:!0});var Oo=$(ao);f(ga.$$.fragment,Oo),es=r(Oo),Pa=d(Oo,"P",{"data-svelte-h":!0}),m(Pa)!=="svelte-1xixice"&&(Pa.textContent=Ts),ts=r(Oo),f(Eo.$$.fragment,Oo),os=r(Oo),Qa=d(Oo,"P",{"data-svelte-h":!0}),m(Qa)!=="svelte-1g4be31"&&(Qa.innerHTML=js),Oo.forEach(l),as=r(Tt),Jo=d(Tt,"DIV",{class:!0});var sn=$(Jo);f(_a.$$.fragment,sn),ns=r(sn),Sa=d(sn,"P",{"data-svelte-h":!0}),m(Sa)!=="svelte-1e03u9y"&&(Sa.textContent=ks),ss=r(sn),f(Po.$$.fragment,sn),sn.forEach(l),Tt.forEach(l),un=r(e),f(va.$$.fragment,e),fn=r(e),ba=d(e,"P",{"data-svelte-h":!0}),m(ba)!=="svelte-zjid7d"&&(ba.innerHTML=Ws),gn=r(e),f(ya.$$.fragment,e),_n=r(e),f(wa.$$.fragment,e),vn=r(e),Zo=d(e,"DIV",{class:!0});var Zn=$(Zo);f(Ma.$$.fragment,Zn),rs=r(Zn),Aa=d(Zn,"P",{"data-svelte-h":!0}),m(Aa)!=="svelte-amzs60"&&(Aa.innerHTML=xs),Zn.forEach(l),bn=r(e),zo=d(e,"DIV",{class:!0});var zn=$(zo);f(Ta.$$.fragment,zn),ls=r(zn),Da=d(zn,"P",{"data-svelte-h":!0}),m(Da)!=="svelte-1tmia4b"&&(Da.textContent=Vs),zn.forEach(l),yn=r(e),Io=d(e,"DIV",{class:!0});var In=$(Io);f(ja.$$.fragment,In),is=r(In),Oa=d(In,"P",{"data-svelte-h":!0}),m(Oa)!=="svelte-9z8jpr"&&(Oa.innerHTML=Js),In.forEach(l),wn=r(e),fo=d(e,"DIV",{class:!0});var rn=$(fo);f(ka.$$.fragment,rn),cs=r(rn),Ka=d(rn,"P",{"data-svelte-h":!0}),m(Ka)!=="svelte-11w6tdr"&&(Ka.innerHTML=$s),ds=r(rn),Qo=d(rn,"DIV",{class:!0});var Bn=$(Qo);f(Wa.$$.fragment,Bn),ps=r(Bn),en=d(Bn,"P",{"data-svelte-h":!0}),m(en)!=="svelte-5ihtpa"&&(en.textContent=Cs),Bn.forEach(l),rn.forEach(l),Mn=r(e),go=d(e,"DIV",{class:!0});var ln=$(go);f(xa.$$.fragment,ln),ms=r(ln),tn=d(ln,"P",{"data-svelte-h":!0}),m(tn)!=="svelte-ldrfqp"&&(tn.innerHTML=Fs),hs=r(ln),So=d(ln,"DIV",{class:!0});var Xn=$(So);f(Va.$$.fragment,Xn),us=r(Xn),on=d(Xn,"P",{"data-svelte-h":!0}),m(on)!=="svelte-5ihtpa"&&(on.textContent=Us),Xn.forEach(l),ln.forEach(l),Tn=r(e),f(Ao.$$.fragment,e),jn=r(e),f(Ja.$$.fragment,e),kn=r(e),dn=d(e,"P",{}),$(dn).forEach(l),this.h()},h(){C(t,"name","hf:doc:metadata"),C(t,"content",$r),qs(Pe,"text-align","center"),C(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(no,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C($o,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(eo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(oo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(No,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(qo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Yo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Ho,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Vo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Ea,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ao,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Jo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Zo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(zo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Io,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Qo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(fo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(So,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(go,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,w){a(document.head,t),p(e,y,w),p(e,n,w),p(e,i,w),g(M,e,w),p(e,o,w),g(j,e,w),p(e,we,w),p(e,B,w),p(e,Me,w),p(e,X,w),p(e,Te,w),p(e,k,w),p(e,re,w),p(e,P,w),p(e,Ee,w),g(N,e,w),p(e,Ie,w),p(e,Q,w),p(e,ce,w),g($e,e,w),p(e,I,w),p(e,de,w),p(e,pe,w),g(je,e,w),p(e,Be,w),p(e,z,w),p(e,Xe,w),p(e,oe,w),p(e,Ge,w),g(H,e,w),p(e,ke,w),g(rt,e,w),p(e,We,w),p(e,Re,w),p(e,me,w),g(Ce,e,w),p(e,Ne,w),g(xe,e,w),p(e,S,w),p(e,ge,w),p(e,ee,w),p(e,Pe,w),p(e,Qe,w),g(Se,e,w),p(e,L,w),p(e,Ye,w),p(e,Ae,w),g(T,e,w),p(e,F,w),p(e,Z,w),p(e,pt,w),g(R,e,w),p(e,ne,w),p(e,mt,w),p(e,Ft,w),p(e,Ut,w),p(e,Zt,w),p(e,zt,w),p(e,He,w),g(De,e,w),p(e,jt,w),p(e,_e,w),g(It,_e,null),a(_e,Le),a(_e,ve),a(_e,Oe),a(_e,Bt),a(_e,ht),g(E,_e,null),p(e,Fe,w),g(gt,e,w),p(e,W,w),p(e,J,w),g(be,J,null),a(J,D),a(J,Ue),a(J,Ve),a(J,Ot),a(J,yo),a(J,no),g(so,no,null),a(no,_t),a(no,Gt),a(J,wo),a(J,$o),g(ro,$o,null),a(J,Kt),a(J,vt),g(bt,vt,null),a(vt,Bo),a(vt,Rt),a(vt,Ze),a(vt,Nt),a(vt,Mo),g(lo,vt,null),a(J,ea),a(J,kt),g(To,kt,null),a(kt,ta),a(kt,At),a(J,oa),a(J,Wt),g(jo,Wt,null),a(Wt,aa),a(Wt,Ke),p(e,Xo,w),g(qt,e,w),p(e,na,w),p(e,ut,w),g(yt,ut,null),a(ut,sa),a(ut,xt),a(ut,io),a(ut,co),a(ut,po),a(ut,eo),g(Yt,eo,null),a(eo,Ia),a(eo,Wo),p(e,la,w),g(mo,e,w),p(e,ho,w),p(e,se,w),g(uo,se,null),a(se,wt),a(se,Ht),a(se,xo),a(se,Fo),a(se,to),a(se,oo),g(Mt,oo,null),a(oo,Go),a(oo,h),a(se,Vt),a(se,ue),g(et,ue,null),a(ue,Jt),a(ue,Je),a(se,tt),a(se,it),g(ye,it,null),a(se,$t),a(se,fe),g(ot,fe,null),a(fe,Ga),a(fe,Uo),a(fe,Gn),g(Ro,fe,null),a(se,Rn),a(se,No),g(ia,No,null),a(No,Nn),a(No,Ra),a(se,qn),a(se,qo),g(ca,qo,null),a(qo,Yn),a(qo,Na),p(e,mn,w),g(da,e,w),p(e,hn,w),p(e,ze,w),g(pa,ze,null),a(ze,Hn),a(ze,qa),a(ze,Ln),a(ze,Yo),g(ma,Yo,null),a(Yo,En),a(Yo,Ya),a(ze,Pn),a(ze,Ho),g(ha,Ho,null),a(Ho,Qn),a(Ho,Ha),a(ze,Sn),a(ze,Vo),g(ua,Vo,null),a(Vo,An),a(Vo,La),a(Vo,Dn),g(Lo,Vo,null),a(ze,On),a(ze,Ea),g(fa,Ea,null),a(ze,Kn),a(ze,ao),g(ga,ao,null),a(ao,es),a(ao,Pa),a(ao,ts),g(Eo,ao,null),a(ao,os),a(ao,Qa),a(ze,as),a(ze,Jo),g(_a,Jo,null),a(Jo,ns),a(Jo,Sa),a(Jo,ss),g(Po,Jo,null),p(e,un,w),g(va,e,w),p(e,fn,w),p(e,ba,w),p(e,gn,w),g(ya,e,w),p(e,_n,w),g(wa,e,w),p(e,vn,w),p(e,Zo,w),g(Ma,Zo,null),a(Zo,rs),a(Zo,Aa),p(e,bn,w),p(e,zo,w),g(Ta,zo,null),a(zo,ls),a(zo,Da),p(e,yn,w),p(e,Io,w),g(ja,Io,null),a(Io,is),a(Io,Oa),p(e,wn,w),p(e,fo,w),g(ka,fo,null),a(fo,cs),a(fo,Ka),a(fo,ds),a(fo,Qo),g(Wa,Qo,null),a(Qo,ps),a(Qo,en),p(e,Mn,w),p(e,go,w),g(xa,go,null),a(go,ms),a(go,tn),a(go,hs),a(go,So),g(Va,So,null),a(So,us),a(So,on),p(e,Tn,w),g(Ao,e,w),p(e,jn,w),g(Ja,e,w),p(e,kn,w),p(e,dn,w),Wn=!0},p(e,[w]){const _o={};w&2&&(_o.$$scope={dirty:w,ctx:e}),E.$set(_o);const at={};w&2&&(at.$$scope={dirty:w,ctx:e}),lo.$set(at);const $a={};w&2&&($a.$$scope={dirty:w,ctx:e}),Ro.$set($a);const pn={};w&2&&(pn.$$scope={dirty:w,ctx:e}),Lo.$set(pn);const vo={};w&2&&(vo.$$scope={dirty:w,ctx:e}),Eo.$set(vo);const Ca={};w&2&&(Ca.$$scope={dirty:w,ctx:e}),Po.$set(Ca);const Fa={};w&2&&(Fa.$$scope={dirty:w,ctx:e}),Ao.$set(Fa)},i(e){Wn||(_(M.$$.fragment,e),_(j.$$.fragment,e),_(N.$$.fragment,e),_($e.$$.fragment,e),_(je.$$.fragment,e),_(H.$$.fragment,e),_(rt.$$.fragment,e),_(Ce.$$.fragment,e),_(xe.$$.fragment,e),_(Se.$$.fragment,e),_(T.$$.fragment,e),_(R.$$.fragment,e),_(De.$$.fragment,e),_(It.$$.fragment,e),_(E.$$.fragment,e),_(gt.$$.fragment,e),_(be.$$.fragment,e),_(so.$$.fragment,e),_(ro.$$.fragment,e),_(bt.$$.fragment,e),_(lo.$$.fragment,e),_(To.$$.fragment,e),_(jo.$$.fragment,e),_(qt.$$.fragment,e),_(yt.$$.fragment,e),_(Yt.$$.fragment,e),_(mo.$$.fragment,e),_(uo.$$.fragment,e),_(Mt.$$.fragment,e),_(et.$$.fragment,e),_(ye.$$.fragment,e),_(ot.$$.fragment,e),_(Ro.$$.fragment,e),_(ia.$$.fragment,e),_(ca.$$.fragment,e),_(da.$$.fragment,e),_(pa.$$.fragment,e),_(ma.$$.fragment,e),_(ha.$$.fragment,e),_(ua.$$.fragment,e),_(Lo.$$.fragment,e),_(fa.$$.fragment,e),_(ga.$$.fragment,e),_(Eo.$$.fragment,e),_(_a.$$.fragment,e),_(Po.$$.fragment,e),_(va.$$.fragment,e),_(ya.$$.fragment,e),_(wa.$$.fragment,e),_(Ma.$$.fragment,e),_(Ta.$$.fragment,e),_(ja.$$.fragment,e),_(ka.$$.fragment,e),_(Wa.$$.fragment,e),_(xa.$$.fragment,e),_(Va.$$.fragment,e),_(Ao.$$.fragment,e),_(Ja.$$.fragment,e),Wn=!0)},o(e){v(M.$$.fragment,e),v(j.$$.fragment,e),v(N.$$.fragment,e),v($e.$$.fragment,e),v(je.$$.fragment,e),v(H.$$.fragment,e),v(rt.$$.fragment,e),v(Ce.$$.fragment,e),v(xe.$$.fragment,e),v(Se.$$.fragment,e),v(T.$$.fragment,e),v(R.$$.fragment,e),v(De.$$.fragment,e),v(It.$$.fragment,e),v(E.$$.fragment,e),v(gt.$$.fragment,e),v(be.$$.fragment,e),v(so.$$.fragment,e),v(ro.$$.fragment,e),v(bt.$$.fragment,e),v(lo.$$.fragment,e),v(To.$$.fragment,e),v(jo.$$.fragment,e),v(qt.$$.fragment,e),v(yt.$$.fragment,e),v(Yt.$$.fragment,e),v(mo.$$.fragment,e),v(uo.$$.fragment,e),v(Mt.$$.fragment,e),v(et.$$.fragment,e),v(ye.$$.fragment,e),v(ot.$$.fragment,e),v(Ro.$$.fragment,e),v(ia.$$.fragment,e),v(ca.$$.fragment,e),v(da.$$.fragment,e),v(pa.$$.fragment,e),v(ma.$$.fragment,e),v(ha.$$.fragment,e),v(ua.$$.fragment,e),v(Lo.$$.fragment,e),v(fa.$$.fragment,e),v(ga.$$.fragment,e),v(Eo.$$.fragment,e),v(_a.$$.fragment,e),v(Po.$$.fragment,e),v(va.$$.fragment,e),v(ya.$$.fragment,e),v(wa.$$.fragment,e),v(Ma.$$.fragment,e),v(Ta.$$.fragment,e),v(ja.$$.fragment,e),v(ka.$$.fragment,e),v(Wa.$$.fragment,e),v(xa.$$.fragment,e),v(Va.$$.fragment,e),v(Ao.$$.fragment,e),v(Ja.$$.fragment,e),Wn=!1},d(e){e&&(l(y),l(n),l(i),l(o),l(we),l(B),l(Me),l(X),l(Te),l(k),l(re),l(P),l(Ee),l(Ie),l(Q),l(ce),l(I),l(de),l(pe),l(Be),l(z),l(Xe),l(oe),l(Ge),l(ke),l(We),l(Re),l(me),l(Ne),l(S),l(ge),l(ee),l(Pe),l(Qe),l(L),l(Ye),l(Ae),l(F),l(Z),l(pt),l(ne),l(mt),l(Ft),l(Ut),l(Zt),l(zt),l(He),l(jt),l(_e),l(Fe),l(W),l(J),l(Xo),l(na),l(ut),l(la),l(ho),l(se),l(mn),l(hn),l(ze),l(un),l(fn),l(ba),l(gn),l(_n),l(vn),l(Zo),l(bn),l(zo),l(yn),l(Io),l(wn),l(fo),l(Mn),l(go),l(Tn),l(jn),l(kn),l(dn)),l(t),b(M,e),b(j,e),b(N,e),b($e,e),b(je,e),b(H,e),b(rt,e),b(Ce,e),b(xe,e),b(Se,e),b(T,e),b(R,e),b(De,e),b(It),b(E),b(gt,e),b(be),b(so),b(ro),b(bt),b(lo),b(To),b(jo),b(qt,e),b(yt),b(Yt),b(mo,e),b(uo),b(Mt),b(et),b(ye),b(ot),b(Ro),b(ia),b(ca),b(da,e),b(pa),b(ma),b(ha),b(ua),b(Lo),b(fa),b(ga),b(Eo),b(_a),b(Po),b(va,e),b(ya,e),b(wa,e),b(Ma),b(Ta),b(ja),b(ka),b(Wa),b(xa),b(Va),b(Ao,e),b(Ja,e)}}}const $r='{"title":"Wav2Vec2","local":"wav2vec2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Using Flash Attention 2","local":"using-flash-attention-2","sections":[{"title":"Installation","local":"installation","sections":[],"depth":3},{"title":"Usage","local":"usage","sections":[],"depth":3},{"title":"Expected speedups","local":"expected-speedups","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"Wav2Vec2Config","local":"transformers.Wav2Vec2Config","sections":[],"depth":2},{"title":"Wav2Vec2CTCTokenizer","local":"transformers.Wav2Vec2CTCTokenizer","sections":[],"depth":2},{"title":"Wav2Vec2FeatureExtractor","local":"transformers.Wav2Vec2FeatureExtractor","sections":[],"depth":2},{"title":"Wav2Vec2Processor","local":"transformers.Wav2Vec2Processor","sections":[],"depth":2},{"title":"Wav2Vec2ProcessorWithLM","local":"transformers.Wav2Vec2ProcessorWithLM","sections":[{"title":"Decoding multiple audios","local":"decoding-multiple-audios","sections":[],"depth":3}],"depth":2},{"title":"Wav2Vec2 specific outputs","local":"transformers.models.wav2vec2_with_lm.processing_wav2vec2_with_lm.Wav2Vec2DecoderWithLMOutput","sections":[],"depth":2},{"title":"Wav2Vec2Model","local":"transformers.Wav2Vec2Model","sections":[],"depth":2},{"title":"Wav2Vec2ForCTC","local":"transformers.Wav2Vec2ForCTC","sections":[],"depth":2},{"title":"Wav2Vec2ForSequenceClassification","local":"transformers.Wav2Vec2ForSequenceClassification","sections":[],"depth":2},{"title":"Wav2Vec2ForAudioFrameClassification","local":"transformers.Wav2Vec2ForAudioFrameClassification","sections":[],"depth":2},{"title":"Wav2Vec2ForXVector","local":"transformers.Wav2Vec2ForXVector","sections":[],"depth":2},{"title":"Wav2Vec2ForPreTraining","local":"transformers.Wav2Vec2ForPreTraining","sections":[],"depth":2},{"title":"TFWav2Vec2Model","local":"transformers.TFWav2Vec2Model","sections":[],"depth":2},{"title":"TFWav2Vec2ForSequenceClassification","local":"transformers.TFWav2Vec2ForSequenceClassification","sections":[],"depth":2},{"title":"TFWav2Vec2ForCTC","local":"transformers.TFWav2Vec2ForCTC","sections":[],"depth":2},{"title":"FlaxWav2Vec2Model","local":"transformers.FlaxWav2Vec2Model","sections":[],"depth":2},{"title":"FlaxWav2Vec2ForCTC","local":"transformers.FlaxWav2Vec2ForCTC","sections":[],"depth":2},{"title":"FlaxWav2Vec2ForPreTraining","local":"transformers.FlaxWav2Vec2ForPreTraining","sections":[],"depth":2}],"depth":1}';function Cr(x){return Xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nr extends Gs{constructor(t){super(),Rs(this,t,Cr,Jr,Bs,{})}}export{Nr as component};
