import{s as jn,o as rn,n as hn}from"../chunks/scheduler.9bc65507.js";import{S as yn,i as un,g as p,s as e,r as o,A as Jn,h as i,f as l,c as t,j as mn,u as M,x as c,k as ul,y as bn,a as n,v as m,d as j,t as r,w as h}from"../chunks/index.707bf1b6.js";import{T as dn}from"../chunks/Tip.c2ecdbf4.js";import{C as y}from"../chunks/CodeBlock.54a9f38d.js";import{D as Un}from"../chunks/DocNotebookDropdown.41f65cb5.js";import{H as qs,E as Tn}from"../chunks/EditOnGithub.922df6ba.js";function wn(Hs){let u,T='To see all architectures and checkpoints compatible with this task, we recommend checking the <a href="https://huggingface.co/tasks/object-detection" rel="nofollow">task-page</a>';return{c(){u=p("p"),u.innerHTML=T},l(J){u=i(J,"P",{"data-svelte-h":!0}),c(u)!=="svelte-5wyiet"&&(u.innerHTML=T)},m(J,Ys){n(J,u,Ys)},p:hn,d(J){J&&l(u)}}}function gn(Hs){let u,T,J,Ys,w,zs,g,$s,C,Jl=`Object detection is the computer vision task of detecting instances (such as humans, buildings, or cars) in an image. Object detection models receive an image as input and output
coordinates of the bounding boxes and associated labels of the detected objects. An image can contain multiple objects,
each with its own bounding box and a label (e.g. it can have a car and a building), and each object can
be present in different parts of an image (e.g. the image can have several cars).
This task is commonly used in autonomous driving for detecting things like pedestrians, road signs, and traffic lights.
Other applications include counting objects in images, image search, and more.`,Ss,I,bl="In this guide, you will learn how to:",Ds,f,dl=`<li>Finetune <a href="https://huggingface.co/docs/transformers/model_doc/detr" rel="nofollow">DETR</a>, a model that combines a convolutional
backbone with an encoder-decoder Transformer, on the <a href="https://huggingface.co/datasets/cppe-5" rel="nofollow">CPPE-5</a>
dataset.</li> <li>Use your finetuned model for inference.</li>`,Ls,b,Ks,Z,Ul="Before you begin, make sure you have all the necessary libraries installed:",Ps,A,Os,v,Tl=`You’ll use 🤗 Datasets to load a dataset from the Hugging Face Hub, 🤗 Transformers to train your model,
and <code>albumentations</code> to augment the data.`,sa,G,wl=`We encourage you to share your model with the community. Log in to your Hugging Face account to upload it to the Hub.
When prompted, enter your token to log in:`,aa,_,la,W,na,B,gl=`The <a href="https://huggingface.co/datasets/cppe-5" rel="nofollow">CPPE-5 dataset</a> contains images with
annotations identifying medical personal protective equipment (PPE) in the context of the COVID-19 pandemic.`,ea,k,Cl="Start by loading the dataset:",ta,x,pa,R,Il="You’ll see that this dataset already comes with a training set containing 1000 images and a test set with 29 images.",ia,Q,fl="To get familiar with the data, explore what the examples look like.",ca,V,oa,E,Zl="The examples in the dataset have the following fields:",Ma,X,Al='<li><code>image_id</code>: the example image id</li> <li><code>image</code>: a <code>PIL.Image.Image</code> object containing the image</li> <li><code>width</code>: width of the image</li> <li><code>height</code>: height of the image</li> <li><code>objects</code>: a dictionary containing bounding box metadata for the objects in the image:<ul><li><code>id</code>: the annotation id</li> <li><code>area</code>: the area of the bounding box</li> <li><code>bbox</code>: the object’s bounding box (in the <a href="https://albumentations.ai/docs/getting_started/bounding_boxes_augmentation/#coco" rel="nofollow">COCO format</a> )</li> <li><code>category</code>: the object’s category, with possible values including <code>Coverall (0)</code>, <code>Face_Shield (1)</code>, <code>Gloves (2)</code>, <code>Goggles (3)</code> and <code>Mask (4)</code></li></ul></li>',ma,N,vl=`You may notice that the <code>bbox</code> field follows the COCO format, which is the format that the DETR model expects.
However, the grouping of the fields inside <code>objects</code> differs from the annotation format DETR requires. You will
need to apply some preprocessing transformations before using this data for training.`,ja,Y,Gl="To get an even better understanding of the data, visualize an example in the dataset.",ra,q,ha,d,_l='<img src="https://i.imgur.com/TdaqPJO.png" alt="CPPE-5 Image Example"/>',ya,F,Wl=`To visualize the bounding boxes with associated labels, you can get the labels from the dataset’s metadata, specifically
the <code>category</code> field.
You’ll also want to create dictionaries that map a label id to a label class (<code>id2label</code>) and the other way around (<code>label2id</code>).
You can use them later when setting up the model. Including these maps will make your model reusable by others if you share
it on the Hugging Face Hub. Please note that, the part of above code that draws the bounding boxes assume that it is in <code>XYWH</code> (x,y co-ordinates and width and height of the box) format. It might not work for other formats like <code>(x1, y1, x2, y2)</code>.`,ua,H,Bl=`As a final step of getting familiar with the data, explore it for potential issues. One common problem with datasets for
object detection is bounding boxes that “stretch” beyond the edge of the image. Such “runaway” bounding boxes can raise
errors during training and should be addressed at this stage. There are a few examples with this issue in this dataset.
To keep things simple in this guide, we remove these images from the data.`,Ja,z,ba,$,da,S,kl=`To finetune a model, you must preprocess the data you plan to use to match precisely the approach used for the pre-trained model.
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a> takes care of processing image data to create <code>pixel_values</code>, <code>pixel_mask</code>, and
<code>labels</code> that a DETR model can train with. The image processor has some attributes that you won’t have to worry about:`,Ua,D,xl="<li><code>image_mean = [0.485, 0.456, 0.406 ]</code></li> <li><code>image_std = [0.229, 0.224, 0.225]</code></li>",Ta,L,Rl=`These are the mean and standard deviation used to normalize images during the model pre-training. These values are crucial
to replicate when doing inference or finetuning a pre-trained image model.`,wa,K,Ql="Instantiate the image processor from the same checkpoint as the model you want to finetune.",ga,P,Ca,O,Vl="Before passing the images to the <code>image_processor</code>, apply two preprocessing transformations to the dataset:",Ia,ss,El="<li>Augmenting images</li> <li>Reformatting annotations to meet DETR expectations</li>",fa,as,Xl=`First, to make sure the model does not overfit on the training data, you can apply image augmentation with any data augmentation library. Here we use <a href="https://albumentations.ai/docs/" rel="nofollow">Albumentations</a> …
This library ensures that transformations affect the image and update the bounding boxes accordingly.
The 🤗 Datasets library documentation has a detailed <a href="https://huggingface.co/docs/datasets/object_detection" rel="nofollow">guide on how to augment images for object detection</a>,
and it uses the exact same dataset as an example. Apply the same approach here, resize each image to (480, 480),
flip it horizontally, and brighten it:`,Za,ls,Aa,ns,Nl=`The <code>image_processor</code> expects the annotations to be in the following format: <code>{&#39;image_id&#39;: int, &#39;annotations&#39;: List[Dict]}</code>,
where each dictionary is a COCO object annotation. Let’s add a function to reformat annotations for a single example:`,va,es,Ga,ts,Yl="Now you can combine the image and annotation transformations to use on a batch of examples:",_a,ps,Wa,is,ql=`Apply this preprocessing function to the entire dataset using 🤗 Datasets <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.with_transform" rel="nofollow">with_transform</a> method. This method applies
transformations on the fly when you load an element of the dataset.`,Ba,cs,Fl=`At this point, you can check what an example from the dataset looks like after the transformations. You should see a tensor
with <code>pixel_values</code>, a tensor with <code>pixel_mask</code>, and <code>labels</code>.`,ka,os,xa,Ms,Hl=`You have successfully augmented the individual images and prepared their annotations. However, preprocessing isn’t
complete yet. In the final step, create a custom <code>collate_fn</code> to batch images together.
Pad images (which are now <code>pixel_values</code>) to the largest image in a batch, and create a corresponding <code>pixel_mask</code>
to indicate which pixels are real (1) and which are padding (0).`,Ra,ms,Qa,js,Va,rs,zl=`You have done most of the heavy lifting in the previous sections, so now you are ready to train your model!
The images in this dataset are still quite large, even after resizing. This means that finetuning this model will
require at least one GPU.`,Ea,hs,$l="Training involves the following steps:",Xa,ys,Sl='<li>Load the model with <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForObjectDetection">AutoModelForObjectDetection</a> using the same checkpoint as in the preprocessing.</li> <li>Define your training hyperparameters in <a href="/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>.</li> <li>Pass the training arguments to <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a> along with the model, dataset, image processor, and data collator.</li> <li>Call <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer.train">train()</a> to finetune your model.</li>',Na,us,Dl=`When loading the model from the same checkpoint that you used for the preprocessing, remember to pass the <code>label2id</code>
and <code>id2label</code> maps that you created earlier from the dataset’s metadata. Additionally, we specify <code>ignore_mismatched_sizes=True</code> to replace the existing classification head with a new one.`,Ya,Js,qa,bs,Ll=`In the <a href="/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> use <code>output_dir</code> to specify where to save your model, then configure hyperparameters as you see fit.
It is important you do not remove unused columns because this will drop the image column. Without the image column, you
can’t create <code>pixel_values</code>. For this reason, set <code>remove_unused_columns</code> to <code>False</code>.
If you wish to share your model by pushing to the Hub, set <code>push_to_hub</code> to <code>True</code> (you must be signed in to Hugging
Face to upload your model).`,Fa,ds,Ha,Us,Kl='Finally, bring everything together, and call <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer.train">train()</a>:',za,Ts,$a,ws,Pl=`If you have set <code>push_to_hub</code> to <code>True</code> in the <code>training_args</code>, the training checkpoints are pushed to the
Hugging Face Hub. Upon training completion, push the final model to the Hub as well by calling the <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer.push_to_hub">push_to_hub()</a> method.`,Sa,gs,Da,Cs,La,Is,Ol=`Object detection models are commonly evaluated with a set of <a href="https://cocodataset.org/#detection-eval">COCO-style metrics</a>.
You can use one of the existing metrics implementations, but here you’ll use the one from <code>torchvision</code> to evaluate the final
model that you pushed to the Hub.`,Ka,fs,sn=`To use the <code>torchvision</code> evaluator, you’ll need to prepare a ground truth COCO dataset. The API to build a COCO dataset
requires the data to be stored in a certain format, so you’ll need to save images and annotations to disk first. Just like
when you prepared your data for training, the annotations from the <code>cppe5[&quot;test&quot;]</code> need to be formatted. However, images
should stay as they are.`,Pa,Zs,an=`The evaluation step requires a bit of work, but it can be split in three major steps.
First, prepare the <code>cppe5[&quot;test&quot;]</code> set: format the annotations and save the data to disk.`,Oa,As,sl,vs,ln="Next, prepare an instance of a <code>CocoDetection</code> class that can be used with <code>cocoevaluator</code>.",al,Gs,ll,_s,nn="Finally, load the metrics and run the evaluation.",nl,Ws,el,Bs,en='These results can be further improved by adjusting the hyperparameters in <a href="/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>. Give it a go!',tl,ks,pl,xs,tn=`Now that you have finetuned a DETR model, evaluated it, and uploaded it to the Hugging Face Hub, you can use it for inference.
The simplest way to try out your finetuned model for inference is to use it in a <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a>. Instantiate a pipeline
for object detection with your model, and pass an image to it:`,il,Rs,cl,Qs,pn="You can also manually replicate the results of the pipeline if you’d like:",ol,Vs,Ml,Es,cn="Let’s plot the result:",ml,Xs,jl,U,on='<img src="https://i.imgur.com/4QZnf9A.png" alt="Object detection result on a new image"/>',rl,Ns,hl,Fs,yl;return w=new qs({props:{title:"Object detection",local:"object-detection",headingTag:"h1"}}),g=new Un({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/object_detection.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/object_detection.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/object_detection.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/object_detection.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/object_detection.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/object_detection.ipynb"}]}}),b=new dn({props:{$$slots:{default:[wn]},$$scope:{ctx:Hs}}}),A=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwZGF0YXNldHMlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRlJTIwZXZhbHVhdGUlMjBhbGJ1bWVudGF0aW9ucw==",highlighted:"pip install -q datasets transformers accelerate evaluate albumentations",wrap:!1}}),_=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),W=new qs({props:{title:"Load the CPPE-5 dataset",local:"load-the-cppe-5-dataset",headingTag:"h2"}}),x=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBY3BwZTUlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyY3BwZS01JTIyKSUwQWNwcGU1",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5 = load_dataset(<span class="hljs-string">&quot;cppe-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5
DatasetDict({
    train: Dataset({
        features: [<span class="hljs-string">&#x27;image_id&#x27;</span>, <span class="hljs-string">&#x27;image&#x27;</span>, <span class="hljs-string">&#x27;width&#x27;</span>, <span class="hljs-string">&#x27;height&#x27;</span>, <span class="hljs-string">&#x27;objects&#x27;</span>],
        num_rows: <span class="hljs-number">1000</span>
    })
    test: Dataset({
        features: [<span class="hljs-string">&#x27;image_id&#x27;</span>, <span class="hljs-string">&#x27;image&#x27;</span>, <span class="hljs-string">&#x27;width&#x27;</span>, <span class="hljs-string">&#x27;height&#x27;</span>, <span class="hljs-string">&#x27;objects&#x27;</span>],
        num_rows: <span class="hljs-number">29</span>
    })
})`,wrap:!1}}),V=new y({props:{code:"Y3BwZTUlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;image_id&#x27;</span>: <span class="hljs-number">15</span>,
 <span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=943x663 at <span class="hljs-number">0x7F9EC9E77C10</span>&gt;,
 <span class="hljs-string">&#x27;width&#x27;</span>: <span class="hljs-number">943</span>,
 <span class="hljs-string">&#x27;height&#x27;</span>: <span class="hljs-number">663</span>,
 <span class="hljs-string">&#x27;objects&#x27;</span>: {<span class="hljs-string">&#x27;id&#x27;</span>: [<span class="hljs-number">114</span>, <span class="hljs-number">115</span>, <span class="hljs-number">116</span>, <span class="hljs-number">117</span>],
  <span class="hljs-string">&#x27;area&#x27;</span>: [<span class="hljs-number">3796</span>, <span class="hljs-number">1596</span>, <span class="hljs-number">152768</span>, <span class="hljs-number">81002</span>],
  <span class="hljs-string">&#x27;bbox&#x27;</span>: [[<span class="hljs-number">302.0</span>, <span class="hljs-number">109.0</span>, <span class="hljs-number">73.0</span>, <span class="hljs-number">52.0</span>],
   [<span class="hljs-number">810.0</span>, <span class="hljs-number">100.0</span>, <span class="hljs-number">57.0</span>, <span class="hljs-number">28.0</span>],
   [<span class="hljs-number">160.0</span>, <span class="hljs-number">31.0</span>, <span class="hljs-number">248.0</span>, <span class="hljs-number">616.0</span>],
   [<span class="hljs-number">741.0</span>, <span class="hljs-number">68.0</span>, <span class="hljs-number">202.0</span>, <span class="hljs-number">401.0</span>]],
  <span class="hljs-string">&#x27;category&#x27;</span>: [<span class="hljs-number">4</span>, <span class="hljs-number">4</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]}}`,wrap:!1}}),q=new y({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image, ImageDraw

<span class="hljs-meta">&gt;&gt;&gt; </span>image = cppe5[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>annotations = cppe5[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;objects&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(image)

<span class="hljs-meta">&gt;&gt;&gt; </span>categories = cppe5[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;objects&quot;</span>].feature[<span class="hljs-string">&quot;category&quot;</span>].names

<span class="hljs-meta">&gt;&gt;&gt; </span>id2label = {index: x <span class="hljs-keyword">for</span> index, x <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(categories, start=<span class="hljs-number">0</span>)}
<span class="hljs-meta">&gt;&gt;&gt; </span>label2id = {v: k <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> id2label.items()}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(annotations[<span class="hljs-string">&quot;id&quot;</span>])):
<span class="hljs-meta">... </span>    box = annotations[<span class="hljs-string">&quot;bbox&quot;</span>][i]
<span class="hljs-meta">... </span>    class_idx = annotations[<span class="hljs-string">&quot;category&quot;</span>][i]
<span class="hljs-meta">... </span>    x, y, w, h = <span class="hljs-built_in">tuple</span>(box)
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Check if coordinates are normalized or not</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-built_in">max</span>(box) &gt; <span class="hljs-number">1.0</span>:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># Coordinates are un-normalized, no need to re-scale them</span>
<span class="hljs-meta">... </span>        x1, y1 = <span class="hljs-built_in">int</span>(x), <span class="hljs-built_in">int</span>(y)
<span class="hljs-meta">... </span>        x2, y2 = <span class="hljs-built_in">int</span>(x + w), <span class="hljs-built_in">int</span>(y + h)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># Coordinates are normalized, re-scale them</span>
<span class="hljs-meta">... </span>        x1 = <span class="hljs-built_in">int</span>(x * width)
<span class="hljs-meta">... </span>        y1 = <span class="hljs-built_in">int</span>(y * height)
<span class="hljs-meta">... </span>        x2 = <span class="hljs-built_in">int</span>((x + w) * width)
<span class="hljs-meta">... </span>        y2 = <span class="hljs-built_in">int</span>((y + h) * height)
<span class="hljs-meta">... </span>    draw.rectangle((x, y, x + w, y + h), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((x, y), id2label[class_idx], fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),z=new y({props:{code:"cmVtb3ZlX2lkeCUyMCUzRCUyMCU1QjU5MCUyQyUyMDgyMSUyQyUyMDgyMiUyQyUyMDg3NSUyQyUyMDg3NiUyQyUyMDg3OCUyQyUyMDg3OSU1RCUwQWtlZXAlMjAlM0QlMjAlNUJpJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UobGVuKGNwcGU1JTVCJTIydHJhaW4lMjIlNUQpKSUyMGlmJTIwaSUyMG5vdCUyMGluJTIwcmVtb3ZlX2lkeCU1RCUwQWNwcGU1JTVCJTIydHJhaW4lMjIlNUQlMjAlM0QlMjBjcHBlNSU1QiUyMnRyYWluJTIyJTVELnNlbGVjdChrZWVwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>remove_idx = [<span class="hljs-number">590</span>, <span class="hljs-number">821</span>, <span class="hljs-number">822</span>, <span class="hljs-number">875</span>, <span class="hljs-number">876</span>, <span class="hljs-number">878</span>, <span class="hljs-number">879</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>keep = [i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(cppe5[<span class="hljs-string">&quot;train&quot;</span>])) <span class="hljs-keyword">if</span> i <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> remove_idx]
<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5[<span class="hljs-string">&quot;train&quot;</span>] = cppe5[<span class="hljs-string">&quot;train&quot;</span>].select(keep)`,wrap:!1}}),$=new qs({props:{title:"Preprocess the data",local:"preprocess-the-data",headingTag:"h2"}}),P=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRmRldHItcmVzbmV0LTUwJTIyJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(checkpoint)`,wrap:!1}}),ls=new y({props:{code:"aW1wb3J0JTIwYWxidW1lbnRhdGlvbnMlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRyYW5zZm9ybSUyMCUzRCUyMGFsYnVtZW50YXRpb25zLkNvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWxidW1lbnRhdGlvbnMuUmVzaXplKDQ4MCUyQyUyMDQ4MCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhbGJ1bWVudGF0aW9ucy5Ib3Jpem9udGFsRmxpcChwJTNEMS4wKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFsYnVtZW50YXRpb25zLlJhbmRvbUJyaWdodG5lc3NDb250cmFzdChwJTNEMS4wKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMGJib3hfcGFyYW1zJTNEYWxidW1lbnRhdGlvbnMuQmJveFBhcmFtcyhmb3JtYXQlM0QlMjJjb2NvJTIyJTJDJTIwbGFiZWxfZmllbGRzJTNEJTVCJTIyY2F0ZWdvcnklMjIlNUQpJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> albumentations
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>transform = albumentations.Compose(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        albumentations.Resize(<span class="hljs-number">480</span>, <span class="hljs-number">480</span>),
<span class="hljs-meta">... </span>        albumentations.HorizontalFlip(p=<span class="hljs-number">1.0</span>),
<span class="hljs-meta">... </span>        albumentations.RandomBrightnessContrast(p=<span class="hljs-number">1.0</span>),
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>    bbox_params=albumentations.BboxParams(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;coco&quot;</span>, label_fields=[<span class="hljs-string">&quot;category&quot;</span>]),
<span class="hljs-meta">... </span>)`,wrap:!1}}),es=new y({props:{code:"ZGVmJTIwZm9ybWF0dGVkX2FubnMoaW1hZ2VfaWQlMkMlMjBjYXRlZ29yeSUyQyUyMGFyZWElMkMlMjBiYm94KSUzQSUwQSUyMCUyMCUyMCUyMGFubm90YXRpb25zJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMCUyQyUyMGxlbihjYXRlZ29yeSkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmV3X2FubiUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmltYWdlX2lkJTIyJTNBJTIwaW1hZ2VfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjYXRlZ29yeV9pZCUyMiUzQSUyMGNhdGVnb3J5JTVCaSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmlzQ3Jvd2QlMjIlM0ElMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJlYSUyMiUzQSUyMGFyZWElNUJpJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYmJveCUyMiUzQSUyMGxpc3QoYmJveCU1QmklNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYW5ub3RhdGlvbnMuYXBwZW5kKG5ld19hbm4pJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYW5ub3RhdGlvbnM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">formatted_anns</span>(<span class="hljs-params">image_id, category, area, bbox</span>):
<span class="hljs-meta">... </span>    annotations = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(category)):
<span class="hljs-meta">... </span>        new_ann = {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;image_id&quot;</span>: image_id,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;category_id&quot;</span>: category[i],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;isCrowd&quot;</span>: <span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;area&quot;</span>: area[i],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;bbox&quot;</span>: <span class="hljs-built_in">list</span>(bbox[i]),
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>        annotations.append(new_ann)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> annotations`,wrap:!1}}),ps=new y({props:{code:"JTIzJTIwdHJhbnNmb3JtaW5nJTIwYSUyMGJhdGNoJTBBZGVmJTIwdHJhbnNmb3JtX2F1Z19hbm4oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2VfaWRzJTIwJTNEJTIwZXhhbXBsZXMlNUIlMjJpbWFnZV9pZCUyMiU1RCUwQSUyMCUyMCUyMCUyMGltYWdlcyUyQyUyMGJib3hlcyUyQyUyMGFyZWElMkMlMjBjYXRlZ29yaWVzJTIwJTNEJTIwJTVCJTVEJTJDJTIwJTVCJTVEJTJDJTIwJTVCJTVEJTJDJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaW1hZ2UlMkMlMjBvYmplY3RzJTIwaW4lMjB6aXAoZXhhbXBsZXMlNUIlMjJpbWFnZSUyMiU1RCUyQyUyMGV4YW1wbGVzJTVCJTIyb2JqZWN0cyUyMiU1RCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMG5wLmFycmF5KGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklNUIlM0ElMkMlMjAlM0ElMkMlMjAlM0ElM0EtMSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMHRyYW5zZm9ybShpbWFnZSUzRGltYWdlJTJDJTIwYmJveGVzJTNEb2JqZWN0cyU1QiUyMmJib3glMjIlNUQlMkMlMjBjYXRlZ29yeSUzRG9iamVjdHMlNUIlMjJjYXRlZ29yeSUyMiU1RCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmVhLmFwcGVuZChvYmplY3RzJTVCJTIyYXJlYSUyMiU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZXMuYXBwZW5kKG91dCU1QiUyMmltYWdlJTIyJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJib3hlcy5hcHBlbmQob3V0JTVCJTIyYmJveGVzJTIyJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhdGVnb3JpZXMuYXBwZW5kKG91dCU1QiUyMmNhdGVnb3J5JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJpbWFnZV9pZCUyMiUzQSUyMGlkXyUyQyUyMCUyMmFubm90YXRpb25zJTIyJTNBJTIwZm9ybWF0dGVkX2FubnMoaWRfJTJDJTIwY2F0XyUyQyUyMGFyXyUyQyUyMGJveF8pJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwaWRfJTJDJTIwY2F0XyUyQyUyMGFyXyUyQyUyMGJveF8lMjBpbiUyMHppcChpbWFnZV9pZHMlMkMlMjBjYXRlZ29yaWVzJTJDJTIwYXJlYSUyQyUyMGJib3hlcyklMEElMjAlMjAlMjAlMjAlNUQlMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2VzJTJDJTIwYW5ub3RhdGlvbnMlM0R0YXJnZXRzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># transforming a batch</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_aug_ann</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    image_ids = examples[<span class="hljs-string">&quot;image_id&quot;</span>]
<span class="hljs-meta">... </span>    images, bboxes, area, categories = [], [], [], []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> image, objects <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[<span class="hljs-string">&quot;image&quot;</span>], examples[<span class="hljs-string">&quot;objects&quot;</span>]):
<span class="hljs-meta">... </span>        image = np.array(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>))[:, :, ::-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>        out = transform(image=image, bboxes=objects[<span class="hljs-string">&quot;bbox&quot;</span>], category=objects[<span class="hljs-string">&quot;category&quot;</span>])

<span class="hljs-meta">... </span>        area.append(objects[<span class="hljs-string">&quot;area&quot;</span>])
<span class="hljs-meta">... </span>        images.append(out[<span class="hljs-string">&quot;image&quot;</span>])
<span class="hljs-meta">... </span>        bboxes.append(out[<span class="hljs-string">&quot;bboxes&quot;</span>])
<span class="hljs-meta">... </span>        categories.append(out[<span class="hljs-string">&quot;category&quot;</span>])

<span class="hljs-meta">... </span>    targets = [
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;image_id&quot;</span>: id_, <span class="hljs-string">&quot;annotations&quot;</span>: formatted_anns(id_, cat_, ar_, box_)}
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> id_, cat_, ar_, box_ <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(image_ids, categories, area, bboxes)
<span class="hljs-meta">... </span>    ]

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> image_processor(images=images, annotations=targets, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),os=new y({props:{code:"Y3BwZTUlNUIlMjJ0cmFpbiUyMiU1RCUyMCUzRCUyMGNwcGU1JTVCJTIydHJhaW4lMjIlNUQud2l0aF90cmFuc2Zvcm0odHJhbnNmb3JtX2F1Z19hbm4pJTBBY3BwZTUlNUIlMjJ0cmFpbiUyMiU1RCU1QjE1JTVEJTBBJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5[<span class="hljs-string">&quot;train&quot;</span>] = cppe5[<span class="hljs-string">&quot;train&quot;</span>].with_transform(transform_aug_ann)
<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">15</span>]
{<span class="hljs-string">&#x27;pixel_values&#x27;</span>: tensor([[[ <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  ..., -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>],
          [ <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  ..., -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>],
          [ <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  ..., -<span class="hljs-number">1.9638</span>, -<span class="hljs-number">1.9638</span>, -<span class="hljs-number">1.9638</span>],
          ...,
          [-<span class="hljs-number">1.5699</span>, -<span class="hljs-number">1.5699</span>, -<span class="hljs-number">1.5699</span>,  ..., -<span class="hljs-number">1.9980</span>, -<span class="hljs-number">1.9980</span>, -<span class="hljs-number">1.9980</span>],
          [-<span class="hljs-number">1.5528</span>, -<span class="hljs-number">1.5528</span>, -<span class="hljs-number">1.5528</span>,  ..., -<span class="hljs-number">1.9980</span>, -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>],
          [-<span class="hljs-number">1.5528</span>, -<span class="hljs-number">1.5528</span>, -<span class="hljs-number">1.5528</span>,  ..., -<span class="hljs-number">1.9980</span>, -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>]],

         [[ <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  ..., -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>],
          [ <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  ..., -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>],
          [ <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  ..., -<span class="hljs-number">1.8256</span>, -<span class="hljs-number">1.8256</span>, -<span class="hljs-number">1.8256</span>],
          ...,
          [-<span class="hljs-number">1.3179</span>, -<span class="hljs-number">1.3179</span>, -<span class="hljs-number">1.3179</span>,  ..., -<span class="hljs-number">1.8606</span>, -<span class="hljs-number">1.8606</span>, -<span class="hljs-number">1.8606</span>],
          [-<span class="hljs-number">1.3004</span>, -<span class="hljs-number">1.3004</span>, -<span class="hljs-number">1.3004</span>,  ..., -<span class="hljs-number">1.8606</span>, -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>],
          [-<span class="hljs-number">1.3004</span>, -<span class="hljs-number">1.3004</span>, -<span class="hljs-number">1.3004</span>,  ..., -<span class="hljs-number">1.8606</span>, -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>]],

         [[ <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  ..., -<span class="hljs-number">1.6476</span>, -<span class="hljs-number">1.6476</span>, -<span class="hljs-number">1.6476</span>],
          [ <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  ..., -<span class="hljs-number">1.6476</span>, -<span class="hljs-number">1.6476</span>, -<span class="hljs-number">1.6476</span>],
          [ <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  ..., -<span class="hljs-number">1.6302</span>, -<span class="hljs-number">1.6302</span>, -<span class="hljs-number">1.6302</span>],
          ...,
          [-<span class="hljs-number">1.0201</span>, -<span class="hljs-number">1.0201</span>, -<span class="hljs-number">1.0201</span>,  ..., -<span class="hljs-number">1.5604</span>, -<span class="hljs-number">1.5604</span>, -<span class="hljs-number">1.5604</span>],
          [-<span class="hljs-number">1.0027</span>, -<span class="hljs-number">1.0027</span>, -<span class="hljs-number">1.0027</span>,  ..., -<span class="hljs-number">1.5604</span>, -<span class="hljs-number">1.5430</span>, -<span class="hljs-number">1.5430</span>],
          [-<span class="hljs-number">1.0027</span>, -<span class="hljs-number">1.0027</span>, -<span class="hljs-number">1.0027</span>,  ..., -<span class="hljs-number">1.5604</span>, -<span class="hljs-number">1.5430</span>, -<span class="hljs-number">1.5430</span>]]]),
 <span class="hljs-string">&#x27;pixel_mask&#x27;</span>: tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
         ...,
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]]),
 <span class="hljs-string">&#x27;labels&#x27;</span>: {<span class="hljs-string">&#x27;size&#x27;</span>: tensor([<span class="hljs-number">800</span>, <span class="hljs-number">800</span>]), <span class="hljs-string">&#x27;image_id&#x27;</span>: tensor([<span class="hljs-number">756</span>]), <span class="hljs-string">&#x27;class_labels&#x27;</span>: tensor([<span class="hljs-number">4</span>]), <span class="hljs-string">&#x27;boxes&#x27;</span>: tensor([[<span class="hljs-number">0.7340</span>, <span class="hljs-number">0.6986</span>, <span class="hljs-number">0.3414</span>, <span class="hljs-number">0.5944</span>]]), <span class="hljs-string">&#x27;area&#x27;</span>: tensor([<span class="hljs-number">519544.4375</span>]), <span class="hljs-string">&#x27;iscrowd&#x27;</span>: tensor([<span class="hljs-number">0</span>]), <span class="hljs-string">&#x27;orig_size&#x27;</span>: tensor([<span class="hljs-number">480</span>, <span class="hljs-number">480</span>])}}`,wrap:!1}}),ms=new y({props:{code:"ZGVmJTIwY29sbGF0ZV9mbihiYXRjaCklM0ElMEElMjAlMjAlMjAlMjBwaXhlbF92YWx1ZXMlMjAlM0QlMjAlNUJpdGVtJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwZm9yJTIwaXRlbSUyMGluJTIwYmF0Y2glNUQlMEElMjAlMjAlMjAlMjBlbmNvZGluZyUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5wYWQocGl4ZWxfdmFsdWVzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjAlNUJpdGVtJTVCJTIybGFiZWxzJTIyJTVEJTIwZm9yJTIwaXRlbSUyMGluJTIwYmF0Y2glNUQlMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMGJhdGNoJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwJTNEJTIwZW5jb2RpbmclNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMnBpeGVsX21hc2slMjIlNUQlMjAlM0QlMjBlbmNvZGluZyU1QiUyMnBpeGVsX21hc2slMjIlNUQlMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGxhYmVscyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGJhdGNo",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    pixel_values = [item[<span class="hljs-string">&quot;pixel_values&quot;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> batch]
<span class="hljs-meta">... </span>    encoding = image_processor.pad(pixel_values, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">... </span>    labels = [item[<span class="hljs-string">&quot;labels&quot;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> batch]
<span class="hljs-meta">... </span>    batch = {}
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = encoding[<span class="hljs-string">&quot;pixel_values&quot;</span>]
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;pixel_mask&quot;</span>] = encoding[<span class="hljs-string">&quot;pixel_mask&quot;</span>]
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch`,wrap:!1}}),js=new qs({props:{title:"Training the DETR model",local:"training-the-detr-model",headingTag:"h2"}}),Js=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBjaGVja3BvaW50JTJDJTBBJTIwJTIwJTIwJTIwaWQybGFiZWwlM0RpZDJsYWJlbCUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsMmlkJTNEbGFiZWwyaWQlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXZpc2lvbiUzRCUyMm5vX3RpbW0lMjIlMkMlMjAlMjMlMjBERVRSJTIwbW9kZWxzJTIwY2FuJTIwYmUlMjBsb2FkZWQlMjB3aXRob3V0JTIwdGltbSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(
<span class="hljs-meta">... </span>    checkpoint,
<span class="hljs-meta">... </span>    id2label=id2label,
<span class="hljs-meta">... </span>    label2id=label2id,
<span class="hljs-meta">... </span>    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    revision=<span class="hljs-string">&quot;no_timm&quot;</span>, <span class="hljs-comment"># DETR models can be loaded without timm</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),ds=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjJkZXRyLXJlc25ldC01MF9maW5ldHVuZWRfY3BwZTUlMjIlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX2Vwb2NocyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGZwMTYlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwc2F2ZV9zdGVwcyUzRDIwMCUyQyUwQSUyMCUyMCUyMCUyMGxvZ2dpbmdfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QxZS01JTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X2RlY2F5JTNEMWUtNCUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfdG90YWxfbGltaXQlM0QyJTJDJTBBJTIwJTIwJTIwJTIwcmVtb3ZlX3VudXNlZF9jb2x1bW5zJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBwdXNoX3RvX2h1YiUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(
<span class="hljs-meta">... </span>    output_dir=<span class="hljs-string">&quot;detr-resnet-50_finetuned_cppe5&quot;</span>,
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>    num_train_epochs=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    fp16=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">1e-5</span>,
<span class="hljs-meta">... </span>    weight_decay=<span class="hljs-number">1e-4</span>,
<span class="hljs-meta">... </span>    save_total_limit=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    remove_unused_columns=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Ts=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEY29sbGF0ZV9mbiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RjcHBlNSU1QiUyMnRyYWluJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEaW1hZ2VfcHJvY2Vzc29yJTJDJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    data_collator=collate_fn,
<span class="hljs-meta">... </span>    train_dataset=cppe5[<span class="hljs-string">&quot;train&quot;</span>],
<span class="hljs-meta">... </span>    tokenizer=image_processor,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()`,wrap:!1}}),gs=new y({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),Cs=new qs({props:{title:"Evaluate",local:"evaluate",headingTag:"h2"}}),As=new y({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> json


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># format annotations the same as for training, no need for data augmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">val_formatted_anns</span>(<span class="hljs-params">image_id, objects</span>):
<span class="hljs-meta">... </span>    annotations = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(objects[<span class="hljs-string">&quot;id&quot;</span>])):
<span class="hljs-meta">... </span>        new_ann = {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;id&quot;</span>: objects[<span class="hljs-string">&quot;id&quot;</span>][i],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;category_id&quot;</span>: objects[<span class="hljs-string">&quot;category&quot;</span>][i],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;iscrowd&quot;</span>: <span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;image_id&quot;</span>: image_id,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;area&quot;</span>: objects[<span class="hljs-string">&quot;area&quot;</span>][i],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;bbox&quot;</span>: objects[<span class="hljs-string">&quot;bbox&quot;</span>][i],
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>        annotations.append(new_ann)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> annotations


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Save images and annotations into the files torchvision.datasets.CocoDetection expects</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">save_cppe5_annotation_file_images</span>(<span class="hljs-params">cppe5</span>):
<span class="hljs-meta">... </span>    output_json = {}
<span class="hljs-meta">... </span>    path_output_cppe5 = <span class="hljs-string">f&quot;<span class="hljs-subst">{os.getcwd()}</span>/cppe5/&quot;</span>

<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> os.path.exists(path_output_cppe5):
<span class="hljs-meta">... </span>        os.makedirs(path_output_cppe5)

<span class="hljs-meta">... </span>    path_anno = os.path.join(path_output_cppe5, <span class="hljs-string">&quot;cppe5_ann.json&quot;</span>)
<span class="hljs-meta">... </span>    categories_json = [{<span class="hljs-string">&quot;supercategory&quot;</span>: <span class="hljs-string">&quot;none&quot;</span>, <span class="hljs-string">&quot;id&quot;</span>: <span class="hljs-built_in">id</span>, <span class="hljs-string">&quot;name&quot;</span>: id2label[<span class="hljs-built_in">id</span>]} <span class="hljs-keyword">for</span> <span class="hljs-built_in">id</span> <span class="hljs-keyword">in</span> id2label]
<span class="hljs-meta">... </span>    output_json[<span class="hljs-string">&quot;images&quot;</span>] = []
<span class="hljs-meta">... </span>    output_json[<span class="hljs-string">&quot;annotations&quot;</span>] = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> cppe5:
<span class="hljs-meta">... </span>        ann = val_formatted_anns(example[<span class="hljs-string">&quot;image_id&quot;</span>], example[<span class="hljs-string">&quot;objects&quot;</span>])
<span class="hljs-meta">... </span>        output_json[<span class="hljs-string">&quot;images&quot;</span>].append(
<span class="hljs-meta">... </span>            {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;id&quot;</span>: example[<span class="hljs-string">&quot;image_id&quot;</span>],
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;width&quot;</span>: example[<span class="hljs-string">&quot;image&quot;</span>].width,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;height&quot;</span>: example[<span class="hljs-string">&quot;image&quot;</span>].height,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;file_name&quot;</span>: <span class="hljs-string">f&quot;<span class="hljs-subst">{example[<span class="hljs-string">&#x27;image_id&#x27;</span>]}</span>.png&quot;</span>,
<span class="hljs-meta">... </span>            }
<span class="hljs-meta">... </span>        )
<span class="hljs-meta">... </span>        output_json[<span class="hljs-string">&quot;annotations&quot;</span>].extend(ann)
<span class="hljs-meta">... </span>    output_json[<span class="hljs-string">&quot;categories&quot;</span>] = categories_json

<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(path_anno, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>        json.dump(output_json, file, ensure_ascii=<span class="hljs-literal">False</span>, indent=<span class="hljs-number">4</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> im, img_id <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(cppe5[<span class="hljs-string">&quot;image&quot;</span>], cppe5[<span class="hljs-string">&quot;image_id&quot;</span>]):
<span class="hljs-meta">... </span>        path_img = os.path.join(path_output_cppe5, <span class="hljs-string">f&quot;<span class="hljs-subst">{img_id}</span>.png&quot;</span>)
<span class="hljs-meta">... </span>        im.save(path_img)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> path_output_cppe5, path_anno`,wrap:!1}}),Gs=new y({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torchvision


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">CocoDetection</span>(torchvision.datasets.CocoDetection):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, img_folder, image_processor, ann_file</span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__(img_folder, ann_file)
<span class="hljs-meta">... </span>        self.image_processor = image_processor

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__getitem__</span>(<span class="hljs-params">self, idx</span>):
<span class="hljs-meta">... </span>        <span class="hljs-comment"># read in PIL image and target in COCO format</span>
<span class="hljs-meta">... </span>        img, target = <span class="hljs-built_in">super</span>(CocoDetection, self).__getitem__(idx)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># preprocess image and target: converting target to DETR format,</span>
<span class="hljs-meta">... </span>        <span class="hljs-comment"># resizing + normalization of both image and target)</span>
<span class="hljs-meta">... </span>        image_id = self.ids[idx]
<span class="hljs-meta">... </span>        target = {<span class="hljs-string">&quot;image_id&quot;</span>: image_id, <span class="hljs-string">&quot;annotations&quot;</span>: target}
<span class="hljs-meta">... </span>        encoding = self.image_processor(images=img, annotations=target, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">... </span>        pixel_values = encoding[<span class="hljs-string">&quot;pixel_values&quot;</span>].squeeze()  <span class="hljs-comment"># remove batch dimension</span>
<span class="hljs-meta">... </span>        target = encoding[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]  <span class="hljs-comment"># remove batch dimension</span>

<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: pixel_values, <span class="hljs-string">&quot;labels&quot;</span>: target}


<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;devonho/detr-resnet-50_finetuned_cppe5&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>path_output_cppe5, path_anno = save_cppe5_annotation_file_images(cppe5[<span class="hljs-string">&quot;test&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>test_ds_coco_format = CocoDetection(path_output_cppe5, image_processor, path_anno)`,wrap:!1}}),Ws=new y({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> evaluate
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;devonho/detr-resnet-50_finetuned_cppe5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>module = evaluate.load(<span class="hljs-string">&quot;ybelkada/cocoevaluate&quot;</span>, coco=test_ds_coco_format.coco)
<span class="hljs-meta">&gt;&gt;&gt; </span>val_dataloader = torch.utils.data.DataLoader(
<span class="hljs-meta">... </span>    test_ds_coco_format, batch_size=<span class="hljs-number">8</span>, shuffle=<span class="hljs-literal">False</span>, num_workers=<span class="hljs-number">4</span>, collate_fn=collate_fn
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> idx, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(val_dataloader)):
<span class="hljs-meta">... </span>        pixel_values = batch[<span class="hljs-string">&quot;pixel_values&quot;</span>].to(device)
<span class="hljs-meta">... </span>        pixel_mask = batch[<span class="hljs-string">&quot;pixel_mask&quot;</span>].to(device)

<span class="hljs-meta">... </span>        labels = [
<span class="hljs-meta">... </span>            {k: v <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> t.items()} <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> batch[<span class="hljs-string">&quot;labels&quot;</span>]
<span class="hljs-meta">... </span>        ]  <span class="hljs-comment"># these are in DETR format, resized + normalized</span>

<span class="hljs-meta">... </span>        <span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">... </span>        outputs = model(pixel_values=pixel_values, pixel_mask=pixel_mask)

<span class="hljs-meta">... </span>        orig_target_sizes = torch.stack([target[<span class="hljs-string">&quot;orig_size&quot;</span>] <span class="hljs-keyword">for</span> target <span class="hljs-keyword">in</span> labels], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>        <span class="hljs-comment"># convert outputs of model to Pascal VOC format (xmin, ymin, xmax, ymax)</span>
<span class="hljs-meta">... </span>        results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0</span>, target_sizes=orig_target_sizes)  
...
<span class="hljs-meta">... </span>        module.add(prediction=results, reference=labels)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">del</span> batch

<span class="hljs-meta">&gt;&gt;&gt; </span>results = module.compute()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(results)
Accumulating evaluation results...
DONE (t=<span class="hljs-number">0.08</span>s).
IoU metric: bbox
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=   <span class="hljs-built_in">all</span> | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.352</span>
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.50</span>      | area=   <span class="hljs-built_in">all</span> | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.681</span>
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.75</span>      | area=   <span class="hljs-built_in">all</span> | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.292</span>
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area= small | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.168</span>
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=medium | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.208</span>
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area= large | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.429</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=   <span class="hljs-built_in">all</span> | maxDets=  <span class="hljs-number">1</span> ] = <span class="hljs-number">0.274</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=   <span class="hljs-built_in">all</span> | maxDets= <span class="hljs-number">10</span> ] = <span class="hljs-number">0.484</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=   <span class="hljs-built_in">all</span> | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.501</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area= small | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.191</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=medium | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.323</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area= large | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.590</span>`,wrap:!1}}),ks=new qs({props:{title:"Inference",local:"inference",headingTag:"h2"}}),Rs=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmkuaW1ndXIuY29tJTJGMmxuV29seS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFvYmpfZGV0ZWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJvYmplY3QtZGV0ZWN0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJkZXZvbmhvJTJGZGV0ci1yZXNuZXQtNTBfZmluZXR1bmVkX2NwcGU1JTIyKSUwQW9ial9kZXRlY3RvcihpbWFnZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://i.imgur.com/2lnWoly.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>obj_detector = pipeline(<span class="hljs-string">&quot;object-detection&quot;</span>, model=<span class="hljs-string">&quot;devonho/detr-resnet-50_finetuned_cppe5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>obj_detector(image)`,wrap:!1}}),Vs=new y({props:{code:"aW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJkZXZvbmhvJTJGZGV0ci1yZXNuZXQtNTBfZmluZXR1bmVkX2NwcGU1JTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJkZXZvbmhvJTJGZGV0ci1yZXNuZXQtNTBfZmluZXR1bmVkX2NwcGU1JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjAlMjAlMjAlMjB0YXJnZXRfc2l6ZXMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCaW1hZ2Uuc2l6ZSU1QiUzQSUzQS0xJTVEJTVEKSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX29iamVjdF9kZXRlY3Rpb24ob3V0cHV0cyUyQyUyMHRocmVzaG9sZCUzRDAuNSUyQyUyMHRhcmdldF9zaXplcyUzRHRhcmdldF9zaXplcyklNUIwJTVEJTBBJTBBZm9yJTIwc2NvcmUlMkMlMjBsYWJlbCUyQyUyMGJveCUyMGluJTIwemlwKHJlc3VsdHMlNUIlMjJzY29yZXMlMjIlNUQlMkMlMjByZXN1bHRzJTVCJTIybGFiZWxzJTIyJTVEJTJDJTIwcmVzdWx0cyU1QiUyMmJveGVzJTIyJTVEKSUzQSUwQSUyMCUyMCUyMCUyMGJveCUyMCUzRCUyMCU1QnJvdW5kKGklMkMlMjAyKSUyMGZvciUyMGklMjBpbiUyMGJveC50b2xpc3QoKSU1RCUwQSUyMCUyMCUyMCUyMHByaW50KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjJEZXRlY3RlZCUyMCU3Qm1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QmxhYmVsLml0ZW0oKSU1RCU3RCUyMHdpdGglMjBjb25maWRlbmNlJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMiU3QnJvdW5kKHNjb3JlLml0ZW0oKSUyQyUyMDMpJTdEJTIwYXQlMjBsb2NhdGlvbiUyMCU3QmJveCU3RCUyMiUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;devonho/detr-resnet-50_finetuned_cppe5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;devonho/detr-resnet-50_finetuned_cppe5&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">... </span>    results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.5</span>, target_sizes=target_sizes)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{model.config.id2label[label.item()]}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
<span class="hljs-meta">... </span>    )
Detected Coverall <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.566</span> at location [<span class="hljs-number">1215.32</span>, <span class="hljs-number">147.38</span>, <span class="hljs-number">4401.81</span>, <span class="hljs-number">3227.08</span>]
Detected Mask <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.584</span> at location [<span class="hljs-number">2449.06</span>, <span class="hljs-number">823.19</span>, <span class="hljs-number">3256.43</span>, <span class="hljs-number">1413.9</span>]`,wrap:!1}}),Xs=new y({props:{code:"ZHJhdyUyMCUzRCUyMEltYWdlRHJhdy5EcmF3KGltYWdlKSUwQSUwQWZvciUyMHNjb3JlJTJDJTIwbGFiZWwlMkMlMjBib3glMjBpbiUyMHppcChyZXN1bHRzJTVCJTIyc2NvcmVzJTIyJTVEJTJDJTIwcmVzdWx0cyU1QiUyMmxhYmVscyUyMiU1RCUyQyUyMHJlc3VsdHMlNUIlMjJib3hlcyUyMiU1RCklM0ElMEElMjAlMjAlMjAlMjBib3glMjAlM0QlMjAlNUJyb3VuZChpJTJDJTIwMiklMjBmb3IlMjBpJTIwaW4lMjBib3gudG9saXN0KCklNUQlMEElMjAlMjAlMjAlMjB4JTJDJTIweSUyQyUyMHgyJTJDJTIweTIlMjAlM0QlMjB0dXBsZShib3gpJTBBJTIwJTIwJTIwJTIwZHJhdy5yZWN0YW5nbGUoKHglMkMlMjB5JTJDJTIweDIlMkMlMjB5MiklMkMlMjBvdXRsaW5lJTNEJTIycmVkJTIyJTJDJTIwd2lkdGglM0QxKSUwQSUyMCUyMCUyMCUyMGRyYXcudGV4dCgoeCUyQyUyMHkpJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCbGFiZWwuaXRlbSgpJTVEJTJDJTIwZmlsbCUzRCUyMndoaXRlJTIyKSUwQSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    x, y, x2, y2 = <span class="hljs-built_in">tuple</span>(box)
<span class="hljs-meta">... </span>    draw.rectangle((x, y, x2, y2), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((x, y), model.config.id2label[label.item()], fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),Ns=new Tn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/object_detection.md"}}),{c(){u=p("meta"),T=e(),J=p("p"),Ys=e(),o(w.$$.fragment),zs=e(),o(g.$$.fragment),$s=e(),C=p("p"),C.textContent=Jl,Ss=e(),I=p("p"),I.textContent=bl,Ds=e(),f=p("ol"),f.innerHTML=dl,Ls=e(),o(b.$$.fragment),Ks=e(),Z=p("p"),Z.textContent=Ul,Ps=e(),o(A.$$.fragment),Os=e(),v=p("p"),v.innerHTML=Tl,sa=e(),G=p("p"),G.textContent=wl,aa=e(),o(_.$$.fragment),la=e(),o(W.$$.fragment),na=e(),B=p("p"),B.innerHTML=gl,ea=e(),k=p("p"),k.textContent=Cl,ta=e(),o(x.$$.fragment),pa=e(),R=p("p"),R.textContent=Il,ia=e(),Q=p("p"),Q.textContent=fl,ca=e(),o(V.$$.fragment),oa=e(),E=p("p"),E.textContent=Zl,Ma=e(),X=p("ul"),X.innerHTML=Al,ma=e(),N=p("p"),N.innerHTML=vl,ja=e(),Y=p("p"),Y.textContent=Gl,ra=e(),o(q.$$.fragment),ha=e(),d=p("div"),d.innerHTML=_l,ya=e(),F=p("p"),F.innerHTML=Wl,ua=e(),H=p("p"),H.textContent=Bl,Ja=e(),o(z.$$.fragment),ba=e(),o($.$$.fragment),da=e(),S=p("p"),S.innerHTML=kl,Ua=e(),D=p("ul"),D.innerHTML=xl,Ta=e(),L=p("p"),L.textContent=Rl,wa=e(),K=p("p"),K.textContent=Ql,ga=e(),o(P.$$.fragment),Ca=e(),O=p("p"),O.innerHTML=Vl,Ia=e(),ss=p("ul"),ss.innerHTML=El,fa=e(),as=p("p"),as.innerHTML=Xl,Za=e(),o(ls.$$.fragment),Aa=e(),ns=p("p"),ns.innerHTML=Nl,va=e(),o(es.$$.fragment),Ga=e(),ts=p("p"),ts.textContent=Yl,_a=e(),o(ps.$$.fragment),Wa=e(),is=p("p"),is.innerHTML=ql,Ba=e(),cs=p("p"),cs.innerHTML=Fl,ka=e(),o(os.$$.fragment),xa=e(),Ms=p("p"),Ms.innerHTML=Hl,Ra=e(),o(ms.$$.fragment),Qa=e(),o(js.$$.fragment),Va=e(),rs=p("p"),rs.textContent=zl,Ea=e(),hs=p("p"),hs.textContent=$l,Xa=e(),ys=p("ol"),ys.innerHTML=Sl,Na=e(),us=p("p"),us.innerHTML=Dl,Ya=e(),o(Js.$$.fragment),qa=e(),bs=p("p"),bs.innerHTML=Ll,Fa=e(),o(ds.$$.fragment),Ha=e(),Us=p("p"),Us.innerHTML=Kl,za=e(),o(Ts.$$.fragment),$a=e(),ws=p("p"),ws.innerHTML=Pl,Sa=e(),o(gs.$$.fragment),Da=e(),o(Cs.$$.fragment),La=e(),Is=p("p"),Is.innerHTML=Ol,Ka=e(),fs=p("p"),fs.innerHTML=sn,Pa=e(),Zs=p("p"),Zs.innerHTML=an,Oa=e(),o(As.$$.fragment),sl=e(),vs=p("p"),vs.innerHTML=ln,al=e(),o(Gs.$$.fragment),ll=e(),_s=p("p"),_s.textContent=nn,nl=e(),o(Ws.$$.fragment),el=e(),Bs=p("p"),Bs.innerHTML=en,tl=e(),o(ks.$$.fragment),pl=e(),xs=p("p"),xs.innerHTML=tn,il=e(),o(Rs.$$.fragment),cl=e(),Qs=p("p"),Qs.textContent=pn,ol=e(),o(Vs.$$.fragment),Ml=e(),Es=p("p"),Es.textContent=cn,ml=e(),o(Xs.$$.fragment),jl=e(),U=p("div"),U.innerHTML=on,rl=e(),o(Ns.$$.fragment),hl=e(),Fs=p("p"),this.h()},l(s){const a=Jn("svelte-u9bgzb",document.head);u=i(a,"META",{name:!0,content:!0}),a.forEach(l),T=t(s),J=i(s,"P",{}),mn(J).forEach(l),Ys=t(s),M(w.$$.fragment,s),zs=t(s),M(g.$$.fragment,s),$s=t(s),C=i(s,"P",{"data-svelte-h":!0}),c(C)!=="svelte-18pt6j0"&&(C.textContent=Jl),Ss=t(s),I=i(s,"P",{"data-svelte-h":!0}),c(I)!=="svelte-1xy9go1"&&(I.textContent=bl),Ds=t(s),f=i(s,"OL",{"data-svelte-h":!0}),c(f)!=="svelte-6qcuz8"&&(f.innerHTML=dl),Ls=t(s),M(b.$$.fragment,s),Ks=t(s),Z=i(s,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-1c9nexd"&&(Z.textContent=Ul),Ps=t(s),M(A.$$.fragment,s),Os=t(s),v=i(s,"P",{"data-svelte-h":!0}),c(v)!=="svelte-1hao5fk"&&(v.innerHTML=Tl),sa=t(s),G=i(s,"P",{"data-svelte-h":!0}),c(G)!=="svelte-1oee7b1"&&(G.textContent=wl),aa=t(s),M(_.$$.fragment,s),la=t(s),M(W.$$.fragment,s),na=t(s),B=i(s,"P",{"data-svelte-h":!0}),c(B)!=="svelte-9es7uf"&&(B.innerHTML=gl),ea=t(s),k=i(s,"P",{"data-svelte-h":!0}),c(k)!=="svelte-kvqzlo"&&(k.textContent=Cl),ta=t(s),M(x.$$.fragment,s),pa=t(s),R=i(s,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1f9ettc"&&(R.textContent=Il),ia=t(s),Q=i(s,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-4bevpw"&&(Q.textContent=fl),ca=t(s),M(V.$$.fragment,s),oa=t(s),E=i(s,"P",{"data-svelte-h":!0}),c(E)!=="svelte-m0t76z"&&(E.textContent=Zl),Ma=t(s),X=i(s,"UL",{"data-svelte-h":!0}),c(X)!=="svelte-1tn0avh"&&(X.innerHTML=Al),ma=t(s),N=i(s,"P",{"data-svelte-h":!0}),c(N)!=="svelte-edp0uk"&&(N.innerHTML=vl),ja=t(s),Y=i(s,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-1o4zzv7"&&(Y.textContent=Gl),ra=t(s),M(q.$$.fragment,s),ha=t(s),d=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(d)!=="svelte-1mkaz8h"&&(d.innerHTML=_l),ya=t(s),F=i(s,"P",{"data-svelte-h":!0}),c(F)!=="svelte-1u2nibn"&&(F.innerHTML=Wl),ua=t(s),H=i(s,"P",{"data-svelte-h":!0}),c(H)!=="svelte-34dvp0"&&(H.textContent=Bl),Ja=t(s),M(z.$$.fragment,s),ba=t(s),M($.$$.fragment,s),da=t(s),S=i(s,"P",{"data-svelte-h":!0}),c(S)!=="svelte-hc5tkr"&&(S.innerHTML=kl),Ua=t(s),D=i(s,"UL",{"data-svelte-h":!0}),c(D)!=="svelte-9xz2l6"&&(D.innerHTML=xl),Ta=t(s),L=i(s,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1uiy3io"&&(L.textContent=Rl),wa=t(s),K=i(s,"P",{"data-svelte-h":!0}),c(K)!=="svelte-1ipxopl"&&(K.textContent=Ql),ga=t(s),M(P.$$.fragment,s),Ca=t(s),O=i(s,"P",{"data-svelte-h":!0}),c(O)!=="svelte-16qnm9y"&&(O.innerHTML=Vl),Ia=t(s),ss=i(s,"UL",{"data-svelte-h":!0}),c(ss)!=="svelte-pqfhzt"&&(ss.innerHTML=El),fa=t(s),as=i(s,"P",{"data-svelte-h":!0}),c(as)!=="svelte-1p8vci"&&(as.innerHTML=Xl),Za=t(s),M(ls.$$.fragment,s),Aa=t(s),ns=i(s,"P",{"data-svelte-h":!0}),c(ns)!=="svelte-bsjzql"&&(ns.innerHTML=Nl),va=t(s),M(es.$$.fragment,s),Ga=t(s),ts=i(s,"P",{"data-svelte-h":!0}),c(ts)!=="svelte-16yruro"&&(ts.textContent=Yl),_a=t(s),M(ps.$$.fragment,s),Wa=t(s),is=i(s,"P",{"data-svelte-h":!0}),c(is)!=="svelte-gv4k4k"&&(is.innerHTML=ql),Ba=t(s),cs=i(s,"P",{"data-svelte-h":!0}),c(cs)!=="svelte-1o4lbgk"&&(cs.innerHTML=Fl),ka=t(s),M(os.$$.fragment,s),xa=t(s),Ms=i(s,"P",{"data-svelte-h":!0}),c(Ms)!=="svelte-1ghsv74"&&(Ms.innerHTML=Hl),Ra=t(s),M(ms.$$.fragment,s),Qa=t(s),M(js.$$.fragment,s),Va=t(s),rs=i(s,"P",{"data-svelte-h":!0}),c(rs)!=="svelte-1970dhn"&&(rs.textContent=zl),Ea=t(s),hs=i(s,"P",{"data-svelte-h":!0}),c(hs)!=="svelte-qp7n2l"&&(hs.textContent=$l),Xa=t(s),ys=i(s,"OL",{"data-svelte-h":!0}),c(ys)!=="svelte-rh2dgl"&&(ys.innerHTML=Sl),Na=t(s),us=i(s,"P",{"data-svelte-h":!0}),c(us)!=="svelte-3tgt16"&&(us.innerHTML=Dl),Ya=t(s),M(Js.$$.fragment,s),qa=t(s),bs=i(s,"P",{"data-svelte-h":!0}),c(bs)!=="svelte-1jr540"&&(bs.innerHTML=Ll),Fa=t(s),M(ds.$$.fragment,s),Ha=t(s),Us=i(s,"P",{"data-svelte-h":!0}),c(Us)!=="svelte-15i5vaz"&&(Us.innerHTML=Kl),za=t(s),M(Ts.$$.fragment,s),$a=t(s),ws=i(s,"P",{"data-svelte-h":!0}),c(ws)!=="svelte-ed5q9e"&&(ws.innerHTML=Pl),Sa=t(s),M(gs.$$.fragment,s),Da=t(s),M(Cs.$$.fragment,s),La=t(s),Is=i(s,"P",{"data-svelte-h":!0}),c(Is)!=="svelte-12kyztt"&&(Is.innerHTML=Ol),Ka=t(s),fs=i(s,"P",{"data-svelte-h":!0}),c(fs)!=="svelte-1gyi24o"&&(fs.innerHTML=sn),Pa=t(s),Zs=i(s,"P",{"data-svelte-h":!0}),c(Zs)!=="svelte-1egi90u"&&(Zs.innerHTML=an),Oa=t(s),M(As.$$.fragment,s),sl=t(s),vs=i(s,"P",{"data-svelte-h":!0}),c(vs)!=="svelte-4e01dv"&&(vs.innerHTML=ln),al=t(s),M(Gs.$$.fragment,s),ll=t(s),_s=i(s,"P",{"data-svelte-h":!0}),c(_s)!=="svelte-xiphfy"&&(_s.textContent=nn),nl=t(s),M(Ws.$$.fragment,s),el=t(s),Bs=i(s,"P",{"data-svelte-h":!0}),c(Bs)!=="svelte-1lq6j54"&&(Bs.innerHTML=en),tl=t(s),M(ks.$$.fragment,s),pl=t(s),xs=i(s,"P",{"data-svelte-h":!0}),c(xs)!=="svelte-1ttuytz"&&(xs.innerHTML=tn),il=t(s),M(Rs.$$.fragment,s),cl=t(s),Qs=i(s,"P",{"data-svelte-h":!0}),c(Qs)!=="svelte-o6117l"&&(Qs.textContent=pn),ol=t(s),M(Vs.$$.fragment,s),Ml=t(s),Es=i(s,"P",{"data-svelte-h":!0}),c(Es)!=="svelte-7zeucu"&&(Es.textContent=cn),ml=t(s),M(Xs.$$.fragment,s),jl=t(s),U=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(U)!=="svelte-16oi5q2"&&(U.innerHTML=on),rl=t(s),M(Ns.$$.fragment,s),hl=t(s),Fs=i(s,"P",{}),mn(Fs).forEach(l),this.h()},h(){ul(u,"name","hf:doc:metadata"),ul(u,"content",Cn),ul(d,"class","flex justify-center"),ul(U,"class","flex justify-center")},m(s,a){bn(document.head,u),n(s,T,a),n(s,J,a),n(s,Ys,a),m(w,s,a),n(s,zs,a),m(g,s,a),n(s,$s,a),n(s,C,a),n(s,Ss,a),n(s,I,a),n(s,Ds,a),n(s,f,a),n(s,Ls,a),m(b,s,a),n(s,Ks,a),n(s,Z,a),n(s,Ps,a),m(A,s,a),n(s,Os,a),n(s,v,a),n(s,sa,a),n(s,G,a),n(s,aa,a),m(_,s,a),n(s,la,a),m(W,s,a),n(s,na,a),n(s,B,a),n(s,ea,a),n(s,k,a),n(s,ta,a),m(x,s,a),n(s,pa,a),n(s,R,a),n(s,ia,a),n(s,Q,a),n(s,ca,a),m(V,s,a),n(s,oa,a),n(s,E,a),n(s,Ma,a),n(s,X,a),n(s,ma,a),n(s,N,a),n(s,ja,a),n(s,Y,a),n(s,ra,a),m(q,s,a),n(s,ha,a),n(s,d,a),n(s,ya,a),n(s,F,a),n(s,ua,a),n(s,H,a),n(s,Ja,a),m(z,s,a),n(s,ba,a),m($,s,a),n(s,da,a),n(s,S,a),n(s,Ua,a),n(s,D,a),n(s,Ta,a),n(s,L,a),n(s,wa,a),n(s,K,a),n(s,ga,a),m(P,s,a),n(s,Ca,a),n(s,O,a),n(s,Ia,a),n(s,ss,a),n(s,fa,a),n(s,as,a),n(s,Za,a),m(ls,s,a),n(s,Aa,a),n(s,ns,a),n(s,va,a),m(es,s,a),n(s,Ga,a),n(s,ts,a),n(s,_a,a),m(ps,s,a),n(s,Wa,a),n(s,is,a),n(s,Ba,a),n(s,cs,a),n(s,ka,a),m(os,s,a),n(s,xa,a),n(s,Ms,a),n(s,Ra,a),m(ms,s,a),n(s,Qa,a),m(js,s,a),n(s,Va,a),n(s,rs,a),n(s,Ea,a),n(s,hs,a),n(s,Xa,a),n(s,ys,a),n(s,Na,a),n(s,us,a),n(s,Ya,a),m(Js,s,a),n(s,qa,a),n(s,bs,a),n(s,Fa,a),m(ds,s,a),n(s,Ha,a),n(s,Us,a),n(s,za,a),m(Ts,s,a),n(s,$a,a),n(s,ws,a),n(s,Sa,a),m(gs,s,a),n(s,Da,a),m(Cs,s,a),n(s,La,a),n(s,Is,a),n(s,Ka,a),n(s,fs,a),n(s,Pa,a),n(s,Zs,a),n(s,Oa,a),m(As,s,a),n(s,sl,a),n(s,vs,a),n(s,al,a),m(Gs,s,a),n(s,ll,a),n(s,_s,a),n(s,nl,a),m(Ws,s,a),n(s,el,a),n(s,Bs,a),n(s,tl,a),m(ks,s,a),n(s,pl,a),n(s,xs,a),n(s,il,a),m(Rs,s,a),n(s,cl,a),n(s,Qs,a),n(s,ol,a),m(Vs,s,a),n(s,Ml,a),n(s,Es,a),n(s,ml,a),m(Xs,s,a),n(s,jl,a),n(s,U,a),n(s,rl,a),m(Ns,s,a),n(s,hl,a),n(s,Fs,a),yl=!0},p(s,[a]){const Mn={};a&2&&(Mn.$$scope={dirty:a,ctx:s}),b.$set(Mn)},i(s){yl||(j(w.$$.fragment,s),j(g.$$.fragment,s),j(b.$$.fragment,s),j(A.$$.fragment,s),j(_.$$.fragment,s),j(W.$$.fragment,s),j(x.$$.fragment,s),j(V.$$.fragment,s),j(q.$$.fragment,s),j(z.$$.fragment,s),j($.$$.fragment,s),j(P.$$.fragment,s),j(ls.$$.fragment,s),j(es.$$.fragment,s),j(ps.$$.fragment,s),j(os.$$.fragment,s),j(ms.$$.fragment,s),j(js.$$.fragment,s),j(Js.$$.fragment,s),j(ds.$$.fragment,s),j(Ts.$$.fragment,s),j(gs.$$.fragment,s),j(Cs.$$.fragment,s),j(As.$$.fragment,s),j(Gs.$$.fragment,s),j(Ws.$$.fragment,s),j(ks.$$.fragment,s),j(Rs.$$.fragment,s),j(Vs.$$.fragment,s),j(Xs.$$.fragment,s),j(Ns.$$.fragment,s),yl=!0)},o(s){r(w.$$.fragment,s),r(g.$$.fragment,s),r(b.$$.fragment,s),r(A.$$.fragment,s),r(_.$$.fragment,s),r(W.$$.fragment,s),r(x.$$.fragment,s),r(V.$$.fragment,s),r(q.$$.fragment,s),r(z.$$.fragment,s),r($.$$.fragment,s),r(P.$$.fragment,s),r(ls.$$.fragment,s),r(es.$$.fragment,s),r(ps.$$.fragment,s),r(os.$$.fragment,s),r(ms.$$.fragment,s),r(js.$$.fragment,s),r(Js.$$.fragment,s),r(ds.$$.fragment,s),r(Ts.$$.fragment,s),r(gs.$$.fragment,s),r(Cs.$$.fragment,s),r(As.$$.fragment,s),r(Gs.$$.fragment,s),r(Ws.$$.fragment,s),r(ks.$$.fragment,s),r(Rs.$$.fragment,s),r(Vs.$$.fragment,s),r(Xs.$$.fragment,s),r(Ns.$$.fragment,s),yl=!1},d(s){s&&(l(T),l(J),l(Ys),l(zs),l($s),l(C),l(Ss),l(I),l(Ds),l(f),l(Ls),l(Ks),l(Z),l(Ps),l(Os),l(v),l(sa),l(G),l(aa),l(la),l(na),l(B),l(ea),l(k),l(ta),l(pa),l(R),l(ia),l(Q),l(ca),l(oa),l(E),l(Ma),l(X),l(ma),l(N),l(ja),l(Y),l(ra),l(ha),l(d),l(ya),l(F),l(ua),l(H),l(Ja),l(ba),l(da),l(S),l(Ua),l(D),l(Ta),l(L),l(wa),l(K),l(ga),l(Ca),l(O),l(Ia),l(ss),l(fa),l(as),l(Za),l(Aa),l(ns),l(va),l(Ga),l(ts),l(_a),l(Wa),l(is),l(Ba),l(cs),l(ka),l(xa),l(Ms),l(Ra),l(Qa),l(Va),l(rs),l(Ea),l(hs),l(Xa),l(ys),l(Na),l(us),l(Ya),l(qa),l(bs),l(Fa),l(Ha),l(Us),l(za),l($a),l(ws),l(Sa),l(Da),l(La),l(Is),l(Ka),l(fs),l(Pa),l(Zs),l(Oa),l(sl),l(vs),l(al),l(ll),l(_s),l(nl),l(el),l(Bs),l(tl),l(pl),l(xs),l(il),l(cl),l(Qs),l(ol),l(Ml),l(Es),l(ml),l(jl),l(U),l(rl),l(hl),l(Fs)),l(u),h(w,s),h(g,s),h(b,s),h(A,s),h(_,s),h(W,s),h(x,s),h(V,s),h(q,s),h(z,s),h($,s),h(P,s),h(ls,s),h(es,s),h(ps,s),h(os,s),h(ms,s),h(js,s),h(Js,s),h(ds,s),h(Ts,s),h(gs,s),h(Cs,s),h(As,s),h(Gs,s),h(Ws,s),h(ks,s),h(Rs,s),h(Vs,s),h(Xs,s),h(Ns,s)}}}const Cn='{"title":"Object detection","local":"object-detection","sections":[{"title":"Load the CPPE-5 dataset","local":"load-the-cppe-5-dataset","sections":[],"depth":2},{"title":"Preprocess the data","local":"preprocess-the-data","sections":[],"depth":2},{"title":"Training the DETR model","local":"training-the-detr-model","sections":[],"depth":2},{"title":"Evaluate","local":"evaluate","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function In(Hs){return rn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wn extends yn{constructor(u){super(),un(this,u,In,gn,jn,{})}}export{Wn as component};
