# Kernels API Reference

## Main Functions

### get_kernel[[kernels.get_kernel]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>kernels.get_kernel</name><anchor>kernels.get_kernel</anchor><source>https://github.com/huggingface/kernels/blob/main/src/kernels/utils.py#L215</source><parameters>[{"name": "repo_id", "val": ": str"}, {"name": "revision", "val": ": typing.Optional[str] = None"}, {"name": "version", "val": ": typing.Optional[str] = None"}]</parameters><paramsdesc>- **repo_id** (`str`) --
  The Hub repository containing the kernel.
- **revision** (`str`, *optional*, defaults to `"main"`) --
  The specific revision (branch, tag, or commit) to download. Cannot be used together with `version`.
- **version** (`str`, *optional*) --
  The kernel version to download. This can be a Python version specifier, such as `">=1.0.0,<2.0.0"`.
  Cannot be used together with `revision`.</paramsdesc><paramgroups>0</paramgroups><rettype>`ModuleType`</rettype><retdesc>The imported kernel module.</retdesc></docstring>

Load a kernel from the kernel hub.

This function downloads a kernel to the local Hugging Face Hub cache directory (if it was not downloaded before)
and then loads the kernel.







<ExampleCodeBlock anchor="kernels.get_kernel.example">

Example:
```python
import torch
from kernels import get_kernel

activation = get_kernel("kernels-community/activation")
x = torch.randn(10, 20, device="cuda")
out = torch.empty_like(x)
result = activation.silu_and_mul(out, x)
```

</ExampleCodeBlock>


</div>

### get_local_kernel[[kernels.get_local_kernel]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>kernels.get_local_kernel</name><anchor>kernels.get_local_kernel</anchor><source>https://github.com/huggingface/kernels/blob/main/src/kernels/utils.py#L252</source><parameters>[{"name": "repo_path", "val": ": Path"}, {"name": "package_name", "val": ": str"}]</parameters><paramsdesc>- **repo_path** (`Path`) --
  The local path to the kernel repository.
- **package_name** (`str`) --
  The name of the package to import from the repository.</paramsdesc><paramgroups>0</paramgroups><rettype>`ModuleType`</rettype><retdesc>The imported kernel module.</retdesc></docstring>

Import a kernel from a local kernel repository path.








</div>

### has_kernel[[kernels.has_kernel]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>kernels.has_kernel</name><anchor>kernels.has_kernel</anchor><source>https://github.com/huggingface/kernels/blob/main/src/kernels/utils.py#L285</source><parameters>[{"name": "repo_id", "val": ": str"}, {"name": "revision", "val": ": typing.Optional[str] = None"}, {"name": "version", "val": ": typing.Optional[str] = None"}]</parameters><paramsdesc>- **repo_id** (`str`) --
  The Hub repository containing the kernel.
- **revision** (`str`, *optional*, defaults to `"main"`) --
  The specific revision (branch, tag, or commit) to download. Cannot be used together with `version`.
- **version** (`str`, *optional*) --
  The kernel version to download. This can be a Python version specifier, such as `">=1.0.0,<2.0.0"`.
  Cannot be used together with `revision`.</paramsdesc><paramgroups>0</paramgroups><rettype>`bool`</rettype><retdesc>`True` if a kernel is available for the current environment.</retdesc></docstring>

Check whether a kernel build exists for the current environment (Torch version and compute framework).








</div>

## Loading locked kernels

### load_kernel[[kernels.load_kernel]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>kernels.load_kernel</name><anchor>kernels.load_kernel</anchor><source>https://github.com/huggingface/kernels/blob/main/src/kernels/utils.py#L323</source><parameters>[{"name": "repo_id", "val": ": str"}, {"name": "lockfile", "val": ": typing.Optional[pathlib.Path] = None"}]</parameters><paramsdesc>- **repo_id** (`str`) --
  The Hub repository containing the kernel.
- **lockfile** (`Path`, *optional*) --
  Path to the lockfile. If not provided, the lockfile will be loaded from the caller's package metadata.</paramsdesc><paramgroups>0</paramgroups><rettype>`ModuleType`</rettype><retdesc>The imported kernel module.</retdesc></docstring>

Get a pre-downloaded, locked kernel.

If `lockfile` is not specified, the lockfile will be loaded from the caller's package metadata.








</div>

### get_locked_kernel[[kernels.get_locked_kernel]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>kernels.get_locked_kernel</name><anchor>kernels.get_locked_kernel</anchor><source>https://github.com/huggingface/kernels/blob/main/src/kernels/utils.py#L380</source><parameters>[{"name": "repo_id", "val": ": str"}, {"name": "local_files_only", "val": ": bool = False"}]</parameters><paramsdesc>- **repo_id** (`str`) --
  The Hub repository containing the kernel.
- **local_files_only** (`bool`, *optional*, defaults to `False`) --
  Whether to only use local files and not download from the Hub.</paramsdesc><paramgroups>0</paramgroups><rettype>`ModuleType`</rettype><retdesc>The imported kernel module.</retdesc></docstring>

Get a kernel using a lock file.








</div>

<EditOnGithub source="https://github.com/huggingface/kernels/blob/main/docs/source/api/kernels.md" />