import{s as Zt,n as Ct,o as xt}from"../chunks/scheduler.85c25b89.js";import{S as Wt,i as Gt,g as p,s as e,r as m,A as Bt,h as i,f as l,c as n,j as It,u as o,x as c,k as $t,y as Nt,a,v as r,d as h,t as M,w as g}from"../chunks/index.c9837788.js";import{C as X}from"../chunks/CodeBlock.52fa569e.js";import{H as V}from"../chunks/Heading.3097d2ed.js";function vt(Mt){let J,z,_,H,j,Y,w,gt='<strong>Xception</strong> is a convolutional neural network architecture that relies solely on <a href="https://paperswithcode.com/method/depthwise-separable-convolution" rel="nofollow">depthwise separable convolution</a> layers.',A,d,Jt='The weights from this model were ported from <a href="https://cv.gluon.ai/model_zoo/classification.html" rel="nofollow">Gluon</a>.',S,u,F,T,jt="To load a pretrained model:",L,y,D,f,wt="To load and preprocess the image:",P,b,q,U,dt="To get the model predictions:",K,I,O,$,ut="To get the top-5 predictions class names:",tt,Z,st,C,Tt="Replace the model name with the variant you want to use, e.g. <code>gluon_xception65</code>. You can find the IDs in the model summaries at the top of this page.",lt,x,yt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',at,W,et,G,ft="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",nt,B,pt,N,bt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,it,v,mt,k,Ut='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',ot,E,ct,Q,rt,R,ht;return j=new V({props:{title:"(Gluon) Xception",local:"gluon-xception",headingTag:"h1"}}),u=new V({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),y=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2dsdW9uX3hjZXB0aW9uNjUnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_xception65&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new V({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),B=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZ2x1b25feGNlcHRpb242NSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_xception65&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),v=new V({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new V({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new X({props:{code:"JTQwbWlzYyU3QmNob2xsZXQyMDE3eGNlcHRpb24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QlhjZXB0aW9uJTNBJTIwRGVlcCUyMExlYXJuaW5nJTIwd2l0aCUyMERlcHRod2lzZSUyMFNlcGFyYWJsZSUyMENvbnZvbHV0aW9ucyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QkZyYW4lQzMlQTdvaXMlMjBDaG9sbGV0JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTclN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxNjEwLjAyMzU3JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{chollet2017xception,
      title={Xception: Deep Learning with Depthwise Separable Convolutions}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{François Chollet}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2017}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1610.02357}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){J=p("meta"),z=e(),_=p("p"),H=e(),m(j.$$.fragment),Y=e(),w=p("p"),w.innerHTML=gt,A=e(),d=p("p"),d.innerHTML=Jt,S=e(),m(u.$$.fragment),F=e(),T=p("p"),T.textContent=jt,L=e(),m(y.$$.fragment),D=e(),f=p("p"),f.textContent=wt,P=e(),m(b.$$.fragment),q=e(),U=p("p"),U.textContent=dt,K=e(),m(I.$$.fragment),O=e(),$=p("p"),$.textContent=ut,tt=e(),m(Z.$$.fragment),st=e(),C=p("p"),C.innerHTML=Tt,lt=e(),x=p("p"),x.innerHTML=yt,at=e(),m(W.$$.fragment),et=e(),G=p("p"),G.textContent=ft,nt=e(),m(B.$$.fragment),pt=e(),N=p("p"),N.innerHTML=bt,it=e(),m(v.$$.fragment),mt=e(),k=p("p"),k.innerHTML=Ut,ot=e(),m(E.$$.fragment),ct=e(),m(Q.$$.fragment),rt=e(),R=p("p"),this.h()},l(t){const s=Bt("svelte-u9bgzb",document.head);J=i(s,"META",{name:!0,content:!0}),s.forEach(l),z=n(t),_=i(t,"P",{}),It(_).forEach(l),H=n(t),o(j.$$.fragment,t),Y=n(t),w=i(t,"P",{"data-svelte-h":!0}),c(w)!=="svelte-2dpud"&&(w.innerHTML=gt),A=n(t),d=i(t,"P",{"data-svelte-h":!0}),c(d)!=="svelte-1vag5uc"&&(d.innerHTML=Jt),S=n(t),o(u.$$.fragment,t),F=n(t),T=i(t,"P",{"data-svelte-h":!0}),c(T)!=="svelte-18ywhxh"&&(T.textContent=jt),L=n(t),o(y.$$.fragment,t),D=n(t),f=i(t,"P",{"data-svelte-h":!0}),c(f)!=="svelte-1c2ipa8"&&(f.textContent=wt),P=n(t),o(b.$$.fragment,t),q=n(t),U=i(t,"P",{"data-svelte-h":!0}),c(U)!=="svelte-1n9qsq1"&&(U.textContent=dt),K=n(t),o(I.$$.fragment,t),O=n(t),$=i(t,"P",{"data-svelte-h":!0}),c($)!=="svelte-19cnvx1"&&($.textContent=ut),tt=n(t),o(Z.$$.fragment,t),st=n(t),C=i(t,"P",{"data-svelte-h":!0}),c(C)!=="svelte-zau0t5"&&(C.innerHTML=Tt),lt=n(t),x=i(t,"P",{"data-svelte-h":!0}),c(x)!=="svelte-1wmi3ea"&&(x.innerHTML=yt),at=n(t),o(W.$$.fragment,t),et=n(t),G=i(t,"P",{"data-svelte-h":!0}),c(G)!=="svelte-9sr7nh"&&(G.textContent=ft),nt=n(t),o(B.$$.fragment,t),pt=n(t),N=i(t,"P",{"data-svelte-h":!0}),c(N)!=="svelte-1kguc51"&&(N.innerHTML=bt),it=n(t),o(v.$$.fragment,t),mt=n(t),k=i(t,"P",{"data-svelte-h":!0}),c(k)!=="svelte-1n0coha"&&(k.innerHTML=Ut),ot=n(t),o(E.$$.fragment,t),ct=n(t),o(Q.$$.fragment,t),rt=n(t),R=i(t,"P",{}),It(R).forEach(l),this.h()},h(){$t(J,"name","hf:doc:metadata"),$t(J,"content",kt)},m(t,s){Nt(document.head,J),a(t,z,s),a(t,_,s),a(t,H,s),r(j,t,s),a(t,Y,s),a(t,w,s),a(t,A,s),a(t,d,s),a(t,S,s),r(u,t,s),a(t,F,s),a(t,T,s),a(t,L,s),r(y,t,s),a(t,D,s),a(t,f,s),a(t,P,s),r(b,t,s),a(t,q,s),a(t,U,s),a(t,K,s),r(I,t,s),a(t,O,s),a(t,$,s),a(t,tt,s),r(Z,t,s),a(t,st,s),a(t,C,s),a(t,lt,s),a(t,x,s),a(t,at,s),r(W,t,s),a(t,et,s),a(t,G,s),a(t,nt,s),r(B,t,s),a(t,pt,s),a(t,N,s),a(t,it,s),r(v,t,s),a(t,mt,s),a(t,k,s),a(t,ot,s),r(E,t,s),a(t,ct,s),r(Q,t,s),a(t,rt,s),a(t,R,s),ht=!0},p:Ct,i(t){ht||(h(j.$$.fragment,t),h(u.$$.fragment,t),h(y.$$.fragment,t),h(b.$$.fragment,t),h(I.$$.fragment,t),h(Z.$$.fragment,t),h(W.$$.fragment,t),h(B.$$.fragment,t),h(v.$$.fragment,t),h(E.$$.fragment,t),h(Q.$$.fragment,t),ht=!0)},o(t){M(j.$$.fragment,t),M(u.$$.fragment,t),M(y.$$.fragment,t),M(b.$$.fragment,t),M(I.$$.fragment,t),M(Z.$$.fragment,t),M(W.$$.fragment,t),M(B.$$.fragment,t),M(v.$$.fragment,t),M(E.$$.fragment,t),M(Q.$$.fragment,t),ht=!1},d(t){t&&(l(z),l(_),l(H),l(Y),l(w),l(A),l(d),l(S),l(F),l(T),l(L),l(D),l(f),l(P),l(q),l(U),l(K),l(O),l($),l(tt),l(st),l(C),l(lt),l(x),l(at),l(et),l(G),l(nt),l(pt),l(N),l(it),l(mt),l(k),l(ot),l(ct),l(rt),l(R)),l(J),g(j,t),g(u,t),g(y,t),g(b,t),g(I,t),g(Z,t),g(W,t),g(B,t),g(v,t),g(E,t),g(Q,t)}}}const kt='{"title":"(Gluon) Xception","local":"gluon-xception","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Et(Mt){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vt extends Wt{constructor(J){super(),Gt(this,J,Et,vt,Zt,{})}}export{Vt as component};
